/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;

public class OptionalTypeAdapter<T>
extends TypeAdapter<Optional<T>> {
    private final TypeAdapter<T> delegate;

    public OptionalTypeAdapter(TypeAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, Optional<T> value) throws IOException {
        if (value == null || !value.isPresent()) {
            out.nullValue();
        } else {
            this.delegate.write(out, value.get());
        }
    }

    public Optional<T> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return Optional.empty();
        }
        return Optional.of(this.delegate.read(in));
    }
}

