/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class TextInputWidget
extends Widget {
    protected String input = "";
    protected String placeholder = "Search...";
    protected int cursorPos = 0;
    public boolean blinkToggle = true;
    protected long lastBlink = 0L;
    protected CustomColor backgroundColor = CustomColor.fromHexString((String)"FFFFFF");
    protected CustomColor focusedColor = CustomColor.fromHexString((String)"FFEA00");
    protected CustomColor textColor = CustomColor.fromHexString((String)"000000");
    int textXOffset;
    int textYOffset;
    int textScale;

    public TextInputWidget(int x, int y, int width, int height, int textXOffset, int textYOffset) {
        this(x, y, width, height, textXOffset, textYOffset, 3);
    }

    public TextInputWidget(int x, int y, int width, int height, int textXOffset, int textYOffset, int textScale) {
        super(x, y, width, height);
        this.textXOffset = textXOffset;
        this.textYOffset = textYOffset;
        this.textScale = textScale;
    }

    @Override
    protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        if (this.backgroundColor == null) {
            return;
        }
        CustomColor bg = this.hovered ? this.focusedColor : this.backgroundColor;
        this.ui.drawRect(this.x, this.y, this.width, this.height, bg);
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_327 font = client.field_1772;
        int textX = this.x + this.textXOffset;
        int textY = this.y + this.textYOffset;
        if (this.input.isEmpty() && !this.isFocused()) {
            this.ui.drawText(this.placeholder, textX, textY, CustomColor.fromHexString((String)"FFFFFF"), this.textScale);
        } else {
            if (this.cursorPos > this.input.length()) {
                this.cursorPos = this.input.length();
            }
            this.ui.drawText(this.input, textX, textY, this.textColor, this.textScale);
            long now = System.currentTimeMillis();
            if (now - this.lastBlink > 500L) {
                this.blinkToggle = !this.blinkToggle;
                this.lastBlink = now;
            }
            if (this.blinkToggle && this.isFocused()) {
                int cursorX = (int)((double)textX + (double)font.method_1727(this.input.substring(0, this.cursorPos)) * this.ui.getScaleFactor() + 1.0);
                this.ui.drawLine(cursorX, textY - 2 * this.textScale, cursorX, textY + 10 * this.textScale, 0.75f * (float)this.textScale, this.textColor);
            }
        }
    }

    @Override
    public boolean onClick(int button) {
        McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
        this.setFocused(true);
        this.cursorPos = this.input.length();
        return true;
    }

    @Override
    protected boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return false;
        }
        if (keyCode == 259 && this.cursorPos > 0) {
            this.input = this.removeAt(this.cursorPos, this.input);
            --this.cursorPos;
            return true;
        }
        if (keyCode == 261 && this.cursorPos < this.input.length()) {
            this.input = this.removeAt(this.cursorPos + 1, this.input);
            return true;
        }
        if (keyCode == 263 && this.cursorPos > 0) {
            --this.cursorPos;
            return true;
        }
        if (keyCode == 262 && this.cursorPos < this.input.length()) {
            ++this.cursorPos;
            return true;
        }
        return false;
    }

    @Override
    protected boolean onCharTyped(char chr, int modifiers) {
        if (!this.isFocused() || Character.isISOControl(chr)) {
            return false;
        }
        this.input = this.insertAt(this.cursorPos, String.valueOf(chr), this.input);
        ++this.cursorPos;
        return true;
    }

    protected String insertAt(int i, String value, String src) {
        return src.substring(0, i) + value + src.substring(i);
    }

    protected String removeAt(int i, String src) {
        if (i <= 0 || i > src.length()) {
            return src;
        }
        return src.substring(0, i - 1) + src.substring(i);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
        this.cursorPos = Math.min(input.length(), this.cursorPos);
    }

    public CustomColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(CustomColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public CustomColor getFocusedColor() {
        return this.focusedColor;
    }

    public void setFocusedColor(CustomColor focusedColor) {
        this.focusedColor = focusedColor;
    }

    public CustomColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(CustomColor textColor) {
        this.textColor = textColor;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }
}

