/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public abstract class WEElement<T> {
    public final T model;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected boolean selected = false;
    protected final List<Widget> childWidgets = new ArrayList<Widget>();
    protected class_2960 backgroundTexture;
    protected class_2960 hoverTexture;
    protected UIUtils ui;

    public WEElement(int x, int y, int width, int height, T model) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.model = model;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.onResize(width, height);
    }

    protected void onResize(int newWidth, int newHeight) {
    }

    public void init() {
    }

    public void tick() {
    }

    public void draw(class_332 ctx, int mouseX, int mouseY, float tickDelta, UIUtils ui) {
        this.ui = ui;
        if (!this.visible || this.ui == null) {
            return;
        }
        this.hovered = this.isMouseOver(mouseX, mouseY);
        this.drawBackground(ctx, mouseX, mouseY, tickDelta);
        this.drawContent(ctx, mouseX, mouseY, tickDelta);
        this.drawChildren(ctx, mouseX, mouseY, tickDelta);
        if (this.focused) {
            this.drawFocus(ctx);
        }
    }

    protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        if (this.backgroundTexture != null) {
            // empty if block
        }
    }

    protected abstract void drawContent(class_332 var1, int var2, int var3, float var4);

    protected void drawChildren(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        for (Widget w : this.childWidgets) {
            if (!w.visible) continue;
            w.draw(ctx, mouseX, mouseY, tickDelta, this.ui);
        }
    }

    protected void drawFocus(class_332 ctx) {
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (!(this.visible && this.enabled && this.isMouseOver(mx, my))) {
            return false;
        }
        for (int i = this.childWidgets.size() - 1; i >= 0; --i) {
            Widget w = this.childWidgets.get(i);
            if (!w.mouseClicked(mx, my, button)) continue;
            return true;
        }
        return this.onClick((int)mx, (int)my, button);
    }

    protected boolean onClick(int mouseX, int mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        for (Widget w : this.childWidgets) {
            if (!w.mouseReleased(mx, my, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double delta) {
        for (Widget w : this.childWidgets) {
            if (!w.mouseScrolled(mx, my, delta)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Widget w : this.childWidgets) {
            if (!w.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return this.onKeyPress(keyCode, scanCode, modifiers);
    }

    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        for (Widget w : this.childWidgets) {
            if (!w.charTyped(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mx, double my) {
        return mx >= (double)this.ui.sx(this.x) && my >= (double)this.ui.sy(this.y) && mx < (double)(this.ui.sx(this.x) + (float)this.ui.sw(this.width)) && my < (double)(this.ui.sy(this.y) + (float)this.ui.sh(this.height));
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void addChild(Widget widget) {
        this.childWidgets.add(widget);
    }

    public void removeChild(Widget widget) {
        this.childWidgets.remove(widget);
    }

    public void setUi(UIUtils ui) {
        this.ui = ui;
    }
}

