/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.WEElement;
import julianh06.wynnextras.utils.UI.Widget;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public abstract class WEScreen
extends class_437 {
    protected class_332 drawContext;
    protected double scaleFactor;
    protected int xStart;
    protected int yStart;
    protected int screenWidth;
    protected int screenHeight;
    protected UIUtils ui;
    public final List<Widget> rootWidgets = new ArrayList<Widget>();
    protected final List<WEElement<?>> listElements = new ArrayList();
    protected Widget focusedWidget = null;
    protected WEElement<?> focusedElement = null;
    protected float listX;
    protected float listY;
    protected float listWidth;
    protected float listHeight;
    protected float listItemHeight;
    protected float listSpacing;
    protected float listScrollOffset = 0.0f;
    protected int firstVisibleIndex = 0;
    protected int lastVisibleIndex = -1;
    protected float listViewportPadding = 1.0f;
    private static long lastScrollTime = 0L;
    private static final long scrollCooldown = 0L;
    private double lastScaleFactor = -1.0;
    private int lastScreenWidth = -1;
    private int lastScreenHeight = -1;

    protected WEScreen(class_2561 title) {
        super(title);
        this.screenWidth = class_310.method_1551().method_22683().method_4486();
        this.screenHeight = class_310.method_1551().method_22683().method_4502();
    }

    protected void registerScrolling() {
        ScreenMouseEvents.afterMouseScroll((class_437)this).register((screen, mX, mY, horizontalAmount, verticalAmount) -> {
            long now = System.currentTimeMillis();
            if (now - lastScrollTime < 0L) {
                return;
            }
            lastScrollTime = now;
            if (verticalAmount > 0.0) {
                this.scrollList(30.0f);
            } else {
                this.scrollList(-30.0f);
            }
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            this.field_22787 = class_310.method_1551();
        }
        if (this.field_22787 != null) {
            super.method_57734();
        }
        this.drawContext = context;
        this.computeScaleAndOffsets();
        if (this.ui == null) {
            this.ui = new UIUtils(context, this.scaleFactor, this.xStart, this.yStart);
        } else {
            this.ui.updateContext(context, this.scaleFactor, this.xStart, this.yStart);
        }
        this.ui.drawBackground();
        this.updateValues();
        this.updateVisibleListRange();
        this.layoutListElements();
        this.drawBackground(context, mouseX, mouseY, delta);
        this.drawContent(context, mouseX, mouseY, delta);
        for (Widget w : this.rootWidgets) {
            w.draw(context, mouseX, mouseY, delta, this.ui);
        }
        int start = Math.max(0, this.firstVisibleIndex - 1);
        int end = Math.min(this.listElements.size() - 1, this.lastVisibleIndex + 1);
        for (int i = start; i <= end; ++i) {
            WEElement<?> e = this.listElements.get(i);
            e.draw(context, mouseX, mouseY, delta, this.ui);
        }
        this.drawForeground(context, mouseX, mouseY, delta);
    }

    protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
    }

    protected abstract void drawContent(class_332 var1, int var2, int var3, float var4);

    protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
    }

    protected void updateWidgetBounds() {
        if (this.ui == null) {
            return;
        }
        for (Widget w : this.rootWidgets) {
            int sx = w.x;
            int sy = (int)((double)w.y * McUtils.guiScale());
            int sw = (int)((double)w.width * McUtils.guiScale());
            int sh = (int)((double)w.height * McUtils.guiScale());
            w.setBounds(sx, sy, sw, sh);
        }
    }

    protected void updateValues() {
    }

    protected void updateElementBounds() {
        if (this.ui == null) {
            return;
        }
        for (WEElement<?> e : this.listElements) {
            int sx = (int)((double)e.x * McUtils.guiScale());
            int sy = (int)((double)e.y * McUtils.guiScale());
            int sw = (int)((double)e.width * McUtils.guiScale());
            int sh = (int)((double)e.height * McUtils.guiScale());
            e.setBounds(sx, sy, sw, sh);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int i;
        for (i = this.rootWidgets.size() - 1; i >= 0; --i) {
            Widget w = this.rootWidgets.get(i);
            if (!w.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocusedWidget(w);
            this.setFocusedElement(null);
            return true;
        }
        if (this.isInsideListViewport(mouseX, mouseY)) {
            this.updateVisibleListRange();
            for (i = this.lastVisibleIndex; i >= this.firstVisibleIndex; --i) {
                WEElement<?> e = this.listElements.get(i);
                if (!e.mouseClicked(mouseX, mouseY, button)) continue;
                this.setFocusedElement(e);
                this.setFocusedWidget(null);
                return true;
            }
        }
        this.setFocusedWidget(null);
        this.setFocusedElement(null);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (int i = this.rootWidgets.size() - 1; i >= 0; --i) {
            if (!this.rootWidgets.get(i).mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.ui == null) {
            return false;
        }
        for (int i = this.rootWidgets.size() - 1; i >= 0; --i) {
            Widget w = this.rootWidgets.get(i);
            if (!w.contains((int)mouseX, (int)mouseY)) continue;
            w.mouseDragged(mouseX, mouseY, button, dx, dy);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.focusedWidget != null && this.focusedWidget.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (Widget w : this.rootWidgets) {
            if (!w.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.focusedWidget != null && this.focusedWidget.charTyped(chr, modifiers)) {
            return true;
        }
        for (Widget w : this.rootWidgets) {
            if (!w.charTyped(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    protected void setFocusedElement(WEElement<?> e) {
        if (this.focusedElement == e) {
            return;
        }
        if (this.focusedElement != null) {
            this.focusedElement.setFocused(false);
        }
        this.focusedElement = e;
        if (this.focusedElement != null) {
            this.focusedElement.setFocused(true);
        }
    }

    protected void setFocusedWidget(Widget w) {
        if (this.focusedWidget == w) {
            return;
        }
        if (this.focusedWidget != null) {
            this.focusedWidget.setFocused(false);
        }
        this.focusedWidget = w;
        if (this.focusedWidget != null) {
            this.focusedWidget.setFocused(true);
        }
    }

    protected void updateVisibleListRange() {
        int total = this.listElements.size();
        if (total == 0 || this.listItemHeight <= 0.0f || this.listHeight <= 0.0f) {
            this.firstVisibleIndex = 0;
            this.lastVisibleIndex = Math.max(-1, total - 1);
            return;
        }
        float slot = this.listItemHeight + this.listSpacing;
        int start = (int)Math.floor(this.listScrollOffset / slot);
        start = Math.max(0, start);
        int visibleCount = (int)Math.ceil(this.listHeight / slot) + 1;
        this.firstVisibleIndex = Math.min(total - 1, start);
        this.lastVisibleIndex = Math.min(total - 1, start + visibleCount - 1);
    }

    protected boolean isInsideListViewport(double mouseX, double mouseY) {
        if (this.ui == null) {
            return false;
        }
        float sx = this.ui.sx(this.listX);
        float sy = this.ui.sy(this.listY);
        int sw = this.ui.sw(this.listWidth);
        int sh = this.ui.sh(this.listHeight + this.listSpacing * (float)(this.listElements.size() - 1));
        return mouseX >= (double)sx && mouseY >= (double)sy && mouseX < (double)(sx + (float)sw) && mouseY < (double)(sy + (float)sh);
    }

    public void computeScaleAndOffsets() {
        class_310 client = class_310.method_1551();
        class_1041 w = client.method_22683();
        if (w == null) {
            return;
        }
        this.scaleFactor = Math.max(1.0, w.method_4495());
        this.screenWidth = w.method_4486();
        this.screenHeight = w.method_4502();
        this.xStart = 0;
        this.yStart = 0;
        if (this.ui != null) {
            this.ui.updateContext(this.drawContext, this.scaleFactor, this.xStart, this.yStart);
        }
    }

    protected void scrollList(float delta) {
        float contentHeight = (float)this.listElements.size() * (this.listItemHeight + this.listSpacing) - this.listSpacing;
        this.listScrollOffset -= delta;
        float scrollPadding = 40.0f;
        float maxScroll = Math.max(0.0f, contentHeight - this.listHeight + scrollPadding);
        this.listScrollOffset = Math.max(0.0f, Math.min(this.listScrollOffset, maxScroll));
        this.updateVisibleListRange();
        this.layoutListElements();
    }

    protected void layoutListElements() {
        if (this.listElements.isEmpty()) {
            return;
        }
        float yy = this.listY - this.listScrollOffset;
        for (int i = 0; i < this.listElements.size(); ++i) {
            WEElement<?> e = this.listElements.get(i);
            int logicalX = Math.round(this.listX);
            int logicalY = Math.round(yy);
            int logicalW = Math.round(this.listWidth);
            int logicalH = Math.round(this.listItemHeight);
            e.setBounds(logicalX, logicalY, logicalW, logicalH);
            yy += this.listItemHeight + this.listSpacing;
        }
    }

    protected void layoutVertical(List<? extends Widget> list, float startX, float startY, float itemHeight, float spacing, float scrollOffset) {
        float yy = startY - scrollOffset;
        for (Widget widget : list) {
            widget.setBounds((int)startX, (int)yy, this.getLogicalWidth(), (int)itemHeight);
            yy += itemHeight + spacing;
        }
    }

    protected int getLogicalWidth() {
        return (int)Math.round((double)this.screenWidth * this.scaleFactor);
    }

    protected int getLogicalHeight() {
        return (int)Math.round((double)this.screenHeight * this.scaleFactor);
    }

    public void addRootWidget(Widget w) {
        if (w == null) {
            return;
        }
        this.rootWidgets.add(w);
        if (this.ui != null) {
            try {
                w.getClass().getMethod("setUi", UIUtils.class).invoke((Object)w, this.ui);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void addListElement(WEElement<?> e) {
        if (e == null) {
            return;
        }
        this.listElements.add(e);
        try {
            e.getClass().getMethod("setUi", UIUtils.class).invoke(e, this.ui);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layoutListElements();
        this.updateVisibleListRange();
    }

    protected void removeListElement(WEElement<?> e) {
        if (e == null) {
            return;
        }
        this.listElements.remove(e);
        if (this.focusedElement == e) {
            this.setFocusedElement(null);
        }
        this.layoutListElements();
        this.updateVisibleListRange();
    }

    public void removeRootWidget(Widget w) {
        if (w == null) {
            return;
        }
        this.rootWidgets.remove(w);
        if (this.focusedWidget == w) {
            this.setFocusedWidget(null);
        }
    }

    public void method_25432() {
        super.method_25432();
        this.rootWidgets.clear();
        this.listElements.clear();
        this.focusedWidget = null;
    }

    protected void drawText(String text, float x, float y, CustomColor color, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        if (this.ui == null) {
            return;
        }
        this.ui.drawText(text, x, y, color, horizontalAlignment, verticalAlignment, shadow, textScale);
    }

    protected void drawText(String text, float x, float y, CustomColor color, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, float textScale) {
        this.drawText(text, x, y, color, horizontalAlignment, verticalAlignment, TextShadow.NORMAL, textScale);
    }

    protected void drawText(String text, float x, float y, CustomColor color, float textScale) {
        this.drawText(text, x, y, color, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, textScale);
    }

    protected void drawText(String text, float x, float y, CustomColor color) {
        this.drawText(text, x, y, color, 3.0f);
    }

    protected void drawText(String text, float x, float y) {
        this.drawText(text, x, y, CustomColor.fromHexString((String)"FFFFFF"));
    }

    protected void drawCenteredText(String text, float x, float y, CustomColor color, float textScale) {
        this.drawText(text, x, y, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, textScale);
    }

    protected void drawCenteredText(String text, float x, float y, CustomColor color) {
        this.drawCenteredText(text, x, y, color, 3.0f);
    }

    protected void drawCenteredText(String text, float x, float y) {
        this.drawCenteredText(text, x, y, CustomColor.fromHexString((String)"FFFFFF"));
    }

    protected void drawImage(class_2960 texture, float x, float y, float width, float height) {
        if (this.ui == null) {
            return;
        }
        this.ui.drawImage(texture, x, y, width, height);
    }

    public static void open(Supplier<? extends WEScreen> screenSupplier) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_63588(() -> {
            WEScreen current = null;
            if (client.field_1755 instanceof WEScreen) {
                current = (WEScreen)client.field_1755;
            }
            if (current != null && ((Object)((Object)current)).getClass() == ((Object)((Object)((WEScreen)((Object)((Object)screenSupplier.get()))))).getClass()) {
                return;
            }
            client.method_1507((class_437)screenSupplier.get());
        });
    }

    public void setDrawContext(class_332 drawContext) {
        this.drawContext = drawContext;
    }

    public void setUi(UIUtils ui) {
        this.ui = ui;
    }

    public UIUtils getUi() {
        return this.ui;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int getxStart() {
        return this.xStart;
    }

    public int getyStart() {
        return this.yStart;
    }
}

