/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils;

import java.util.Objects;
import java.util.Set;
import julianh06.wynnextras.utils.Pair;
import julianh06.wynnextras.utils.render.WorldRenderUtils;
import net.minecraft.class_238;
import net.minecraft.class_243;

public record WEVec(double x, double y, double z) {
    public WEVec(class_243 vec) {
        this(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public WEVec() {
        this(0.0, 0.0, 0.0);
    }

    public WEVec(float x, float y, float z) {
        this((double)x, (double)y, (double)z);
    }

    public class_243 toVec3d() {
        return new class_243(this.x, this.y, this.z);
    }

    public WEVec add(WEVec other) {
        return new WEVec(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public WEVec add(double x, double y, double z) {
        return new WEVec(this.x + x, this.y + y, this.z + z);
    }

    public WEVec subtract(WEVec other) {
        return new WEVec(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public WEVec multiply(WEVec other) {
        return new WEVec(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public WEVec multiply(double scalar) {
        return new WEVec(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public WEVec multiply(int scalar) {
        return new WEVec(this.x * (double)scalar, this.y * (double)scalar, this.z * (double)scalar);
    }

    public WEVec divide(WEVec other) {
        return new WEVec(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    public WEVec divide(double scalar) {
        return new WEVec(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    public double dot(WEVec other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public WEVec cross(WEVec other) {
        return new WEVec(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public double angleAsCos(WEVec other) {
        return this.normalize().dot(other.normalize());
    }

    public double angleInRad(WEVec other) {
        return Math.acos(this.angleAsCos(other));
    }

    public double angleInDeg(WEVec other) {
        return Math.toDegrees(this.angleInRad(other));
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distanceTo(WEVec other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0) + Math.pow(this.z - other.z, 2.0));
    }

    public WEVec normalize() {
        double scalar = org.joml.Math.invsqrt((double)Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        return new WEVec(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public WEVec inverse() {
        return new WEVec(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    public WEVec negate() {
        return new WEVec(-this.x, -this.y, -this.z);
    }

    public double min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public double max() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public boolean equals(WEVec other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y) && Objects.equals(this.z, other.z);
    }

    public WEVec down() {
        return new WEVec(this.x, this.y - 1.0, this.z);
    }

    public WEVec up() {
        return new WEVec(this.x, this.y + 1.0, this.z);
    }

    public WEVec toBlockPos() {
        return new WEVec(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public WEVec blockCenter() {
        return this.toBlockPos().add(0.5, 0.5, 0.5);
    }

    public class_238 boundingToOffset(double offX, double offY, double offZ) {
        return new class_238(Math.min(this.x, this.x + offX), Math.min(this.y, this.y + offY), Math.min(this.z, this.z + offZ), Math.max(this.x, this.x + offX), Math.max(this.y, this.y + offY), Math.max(this.z, this.z + offZ));
    }

    public class_238 boundingTo(WEVec other) {
        return new class_238(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z), Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    public Set<Pair<WEVec, WEVec>> edges() {
        return WorldRenderUtils.calculateEdges(this.boundingToOffset(1.0, 1.0, 1.0));
    }
}

