/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.overlays;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import java.awt.Color;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.overlays.EasyElement;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class EasyColorPicker
extends EasyElement {
    public boolean expanded = false;
    int mouseX = 0;
    int mouseY = 0;
    private CustomColor selectedColor;
    class_2960 hsvhueTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/hsvhue.png");
    class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/colorpickerbackground.png");
    private final int pickerWidth = 200;
    private final int pickerHeight = 200;

    public EasyColorPicker(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void draw(class_332 context) {
        if (this.selectedColor == null) {
            this.selectedColor = CustomColor.fromHexString((String)"ffffff");
        }
        RenderUtils.drawRect((class_4587)context.method_51448(), (CustomColor)this.selectedColor, (float)this.x, (float)this.y, (float)0.0f, (float)this.width, (float)this.height);
        if (this.expanded) {
            int pickerX = (int)((float)this.x + this.width + 25.0f / (float)WaypointScreen.scaleFactor);
            int pickerY = this.y;
            RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.hsvhueTexture, (float)pickerX, (float)pickerY, (float)(200.0f / (float)WaypointScreen.scaleFactor), (float)(200.0f / (float)WaypointScreen.scaleFactor), (int)(200 / WaypointScreen.scaleFactor), (int)(200 / WaypointScreen.scaleFactor));
            RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.backgroundTexture, (float)((float)pickerX - 5.0f / (float)WaypointScreen.scaleFactor), (float)((float)pickerY - 5.0f / (float)WaypointScreen.scaleFactor), (float)(210.0f / (float)WaypointScreen.scaleFactor), (float)(210.0f / (float)WaypointScreen.scaleFactor), (int)(210 / WaypointScreen.scaleFactor), (int)(210 / WaypointScreen.scaleFactor));
        }
    }

    @Override
    public void click() {
    }

    public void click(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (!this.expanded) {
            this.expanded = true;
        } else {
            int pickerX = (int)((float)this.x + this.width + 5.0f);
            int pickerY = this.y;
            if (mouseX >= pickerX && mouseX < pickerX + 200 && mouseY >= pickerY && mouseY < pickerY + 200) {
                int relX = mouseX - pickerX;
                int relY = mouseY - pickerY;
                float hue = (float)relX / 200.0f * (float)WaypointScreen.scaleFactor;
                float brightness = 1.0f - (float)relY / 200.0f * (float)WaypointScreen.scaleFactor;
                Color color = Color.getHSBColor(hue, 1.0f, brightness);
                this.selectedColor = new CustomColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
            }
        }
    }

    public CustomColor getSelectedColor() {
        if (this.selectedColor == null) {
            this.selectedColor = CustomColor.fromHexString((String)"ffffff");
        }
        return this.selectedColor;
    }

    public void setSelectedColor(CustomColor color) {
        this.selectedColor = color;
    }

    @Override
    public boolean isClickInBounds(int x, int y) {
        if (this.expanded) {
            boolean inPicker;
            int pickerX = (int)((float)this.x + this.width + 5.0f);
            int pickerY = this.y;
            int pickerRight = pickerX + 200 / WaypointScreen.scaleFactor;
            int pickerBottom = pickerY + 200 / WaypointScreen.scaleFactor;
            boolean bl = inPicker = x >= pickerX && x <= pickerRight && y >= pickerY && y <= pickerBottom;
            return inPicker;
        }
        if (x < this.x) {
            return false;
        }
        if (y < this.y) {
            return false;
        }
        if ((float)x > (float)this.x + this.width) {
            return false;
        }
        return !((float)y > (float)this.y + this.height);
    }
}

