/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.render;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.event.RenderWorldEvent;
import julianh06.wynnextras.utils.Pair;
import julianh06.wynnextras.utils.WEVec;
import julianh06.wynnextras.utils.render.RenderLayers;
import julianh06.wynnextras.utils.render.WorldRenderUtils;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class LineDrawer {
    private final List<QueuedLine> queuedLines = new ArrayList<QueuedLine>();
    private final RenderWorldEvent event;
    private final int lineWidth;
    private final boolean depth;

    public LineDrawer(RenderWorldEvent event, int lineWidth, boolean depth) {
        this.event = event;
        this.lineWidth = lineWidth;
        this.depth = depth;
    }

    private void drawQueuedLines() {
        if (this.queuedLines.isEmpty()) {
            return;
        }
        class_1921.class_4687 layer = RenderLayers.getLines(this.lineWidth, !this.depth);
        class_4588 buffer = this.event.vertexConsumerProvider.getBuffer((class_1921)layer);
        class_4587.class_4665 matrix = this.event.matrices.method_23760();
        for (QueuedLine line : this.queuedLines) {
            buffer.method_22918(matrix.method_23761(), (float)line.p1.x(), (float)line.p1.y(), (float)line.p1.z()).method_60831(matrix, (float)line.normal.x(), (float)line.normal.y(), (float)line.normal.z()).method_1336(line.color.getRed(), line.color.getGreen(), line.color.getBlue(), line.color.getAlpha());
            buffer.method_22918(matrix.method_23761(), (float)line.p2.x(), (float)line.p2.y(), (float)line.p2.z()).method_60831(matrix, (float)line.normal.x(), (float)line.normal.y(), (float)line.normal.z()).method_1336(line.color.getRed(), line.color.getGreen(), line.color.getBlue(), line.color.getAlpha());
        }
        this.queuedLines.clear();
    }

    private void addQueuedLine(WEVec p1, WEVec p2, Color color) {
        QueuedLine last;
        QueuedLine queuedLine = last = this.queuedLines.isEmpty() ? null : this.queuedLines.getLast();
        if (last == null) {
            this.queuedLines.add(new QueuedLine(p1, p2, color));
            return;
        }
        if (!last.p2.equals(p1)) {
            this.drawQueuedLines();
        }
        this.queuedLines.add(new QueuedLine(p1, p2, color));
    }

    public void drawEdges(WEVec location, Color color) {
        for (Pair<WEVec, WEVec> edge : location.edges()) {
            this.draw3DLine(edge.getFirst(), edge.getSecond(), color);
        }
    }

    public void drawEdges(class_238 box, Color color) {
        for (Pair<WEVec, WEVec> edge : WorldRenderUtils.calculateEdges(box)) {
            this.draw3DLine(edge.getFirst(), edge.getSecond(), color);
        }
    }

    public void draw3DLine(WEVec p1, WEVec p2, Color color) {
        this.addQueuedLine(p1, p2, color);
    }

    static void draw3D(RenderWorldEvent event, int lineWidth, boolean depth, LineDrawerDraws draws) {
        event.matrices.method_22903();
        WEVec inverseView = WorldRenderUtils.getViewerPos().negate();
        event.matrices.method_22904(inverseView.x(), inverseView.y(), inverseView.z());
        LineDrawer lineDrawer = new LineDrawer(event, lineWidth, depth);
        draws.draw(lineDrawer);
        lineDrawer.drawQueuedLines();
        event.matrices.method_22909();
    }

    public static class QueuedLine {
        public WEVec p1;
        public WEVec p2;
        public Color color;
        public WEVec normal;

        public QueuedLine(WEVec p1, WEVec p2, Color color) {
            this.p1 = p1;
            this.p2 = p2;
            this.color = color;
            this.normal = p2.subtract(p1).normalize();
        }
    }

    @FunctionalInterface
    static interface LineDrawerDraws {
        public void draw(LineDrawer var1);
    }
}

