/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BlockStream;
import db.buffers.BlockStreamHandle;
import db.buffers.DataBuffer;
import db.buffers.InputBlockStream;
import db.buffers.LocalBufferFile;
import db.buffers.OutputBlockStream;
import db.buffers.RemoteBufferFileHandle;
import ghidra.framework.remote.RemoteRepositoryHandle;
import ghidra.server.RepositoryManager;
import ghidra.server.remote.GhidraServer;
import ghidra.server.remote.RepositoryHandleImpl;
import ghidra.server.remote.ServerPortFactory;
import ghidra.server.stream.BlockStreamServer;
import ghidra.server.stream.RemoteInputBlockStreamHandle;
import ghidra.server.stream.RemoteOutputBlockStreamHandle;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;

public class RemoteBufferFileImpl
extends UnicastRemoteObject
implements RemoteBufferFileHandle,
Unreferenced {
    private static final HashMap<RemoteRepositoryHandle, List<RemoteBufferFileImpl>> instanceOwnerMap = new HashMap();
    private static final HashMap<String, List<RemoteBufferFileImpl>> instancePathMap = new HashMap();
    protected final RepositoryHandleImpl owner;
    protected final String associatedFilePath;
    private final String clientHost;
    private final LocalBufferFile bufferFile;
    private boolean disposed = false;

    public RemoteBufferFileImpl(LocalBufferFile bufferFile, RepositoryHandleImpl owner, String associatedFilePath) throws RemoteException {
        super(ServerPortFactory.getRMISSLPort(), GhidraServer.getRMIClientSocketFactory(), GhidraServer.getRMIServerSocketFactory());
        this.bufferFile = bufferFile;
        this.owner = owner;
        this.associatedFilePath = associatedFilePath;
        if (owner == null || associatedFilePath == null) {
            throw new IllegalArgumentException("Missing one or more required arguments");
        }
        this.clientHost = RepositoryManager.getRMIClient();
        RemoteBufferFileImpl.addInstance(this);
    }

    private static String getFilePathKey(RemoteBufferFileImpl rbf) {
        return RemoteBufferFileImpl.getFilePathKey(rbf.owner.getRepository().getName(), rbf.associatedFilePath);
    }

    private static String getFilePathKey(String repoName, String filePath) {
        return repoName + ":" + filePath;
    }

    private static synchronized void addInstance(RemoteBufferFileImpl rbf) {
        List<RemoteBufferFileImpl> list = instanceOwnerMap.get(rbf.owner);
        if (list == null) {
            list = new ArrayList<RemoteBufferFileImpl>();
            instanceOwnerMap.put(rbf.owner, list);
        }
        list.add(rbf);
        String filePathKey = RemoteBufferFileImpl.getFilePathKey(rbf);
        list = instancePathMap.get(filePathKey);
        if (list == null) {
            list = new ArrayList<RemoteBufferFileImpl>();
            instancePathMap.put(filePathKey, list);
        }
        list.add(rbf);
    }

    private static synchronized void removeOwnerInstance(RemoteBufferFileImpl rbf) {
        List<RemoteBufferFileImpl> list = instanceOwnerMap.get(rbf.owner);
        if (list != null && list.remove(rbf) && list.isEmpty()) {
            instanceOwnerMap.remove(rbf.owner);
        }
    }

    private static synchronized void removePathInstance(RemoteBufferFileImpl rbf) {
        String filePathKey = RemoteBufferFileImpl.getFilePathKey(rbf);
        List<RemoteBufferFileImpl> list = instancePathMap.get(filePathKey);
        if (list != null && list.remove(rbf) && list.isEmpty()) {
            instancePathMap.remove(filePathKey);
        }
    }

    public static synchronized boolean dispose(Object owner) {
        boolean found = false;
        List<RemoteBufferFileImpl> list = instanceOwnerMap.remove(owner);
        if (list != null) {
            for (RemoteBufferFileImpl rbf : list) {
                found = true;
                rbf.dispose();
            }
        }
        if (found) {
            RemoteBufferFileImpl.dispose(owner);
        }
        return found;
    }

    public static synchronized int getOpenFileCount(RepositoryHandleImpl owner) {
        List<RemoteBufferFileImpl> list = instanceOwnerMap.get(owner);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public String getUserClient() {
        if (this.clientHost != null) {
            return this.owner.getUserName() + "@" + this.clientHost;
        }
        return this.owner.getUserName();
    }

    public static String[] getOpenFileUsers(String repoName, String filePath) {
        String filePathKey = RemoteBufferFileImpl.getFilePathKey(repoName, filePath);
        List<RemoteBufferFileImpl> rbfList = instancePathMap.get(filePathKey);
        if (rbfList != null) {
            HashSet<String> set = new HashSet<String>();
            for (RemoteBufferFileImpl rbf : rbfList) {
                set.add(rbf.getUserClient());
            }
            String[] names = new String[set.size()];
            int index = 0;
            for (String name : set) {
                names[index++] = name;
            }
            return names;
        }
        return null;
    }

    @Override
    public void unreferenced() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RemoteBufferFileImpl.removeOwnerInstance(this);
        RemoteBufferFileImpl.removePathInstance(this);
        RemoteBufferFileImpl remoteBufferFileImpl = this;
        synchronized (remoteBufferFileImpl) {
            if (!this.disposed) {
                try {
                    RemoteBufferFileImpl.unexportObject(this, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                this.bufferFile.dispose();
                this.disposed = true;
            }
        }
    }

    public int getParameter(String name) throws NoSuchElementException, IOException {
        return this.bufferFile.getParameter(name);
    }

    public void setParameter(String name, int value) throws IOException {
        this.bufferFile.setParameter(name, value);
    }

    public void clearParameters() throws IOException {
        this.bufferFile.clearParameters();
    }

    public String[] getParameterNames() throws IOException {
        return this.bufferFile.getParameterNames();
    }

    public int getBufferSize() throws IOException {
        return this.bufferFile.getBufferSize();
    }

    public int getIndexCount() throws IOException {
        return this.bufferFile.getIndexCount();
    }

    public int[] getFreeIndexes() throws IOException {
        return this.bufferFile.getFreeIndexes();
    }

    public void setFreeIndexes(int[] indexes) throws IOException {
        this.bufferFile.setFreeIndexes(indexes);
    }

    public boolean isReadOnly() throws IOException {
        return this.bufferFile.isReadOnly();
    }

    public boolean setReadOnly() throws IOException {
        return this.bufferFile.setReadOnly();
    }

    public void close() throws IOException {
        this.bufferFile.close();
        this.dispose();
    }

    public boolean delete() throws IOException {
        boolean rc = false;
        try {
            rc = this.bufferFile.delete();
        }
        finally {
            this.dispose();
        }
        return rc;
    }

    public DataBuffer get(int index) throws IOException {
        return this.bufferFile.get(new DataBuffer(), index);
    }

    public void put(DataBuffer buf, int index) throws IOException {
        this.bufferFile.put(buf, index);
    }

    public InputBlockStream getInputBlockStream() throws IOException {
        throw new IOException("use of InputBlockStreamHandle required");
    }

    public OutputBlockStream getOutputBlockStream(int blockCount) throws IOException {
        throw new IOException("use of OutputBlockStreamHandle required");
    }

    public BlockStreamHandle<InputBlockStream> getInputBlockStreamHandle() throws IOException {
        InputBlockStream inputBlockStream;
        RemoteInputBlockStreamHandle streamHandle;
        BlockStreamServer blockStreamServer = BlockStreamServer.getBlockStreamServer();
        if (!blockStreamServer.registerBlockStream(streamHandle = new RemoteInputBlockStreamHandle(blockStreamServer, inputBlockStream = this.bufferFile.getInputBlockStream()), (BlockStream)inputBlockStream)) {
            throw new IOException("request failed: block stream server not running");
        }
        return streamHandle;
    }

    public BlockStreamHandle<OutputBlockStream> getOutputBlockStreamHandle(int blockCount) throws IOException {
        OutputBlockStream outputBlockStream;
        RemoteOutputBlockStreamHandle streamHandle;
        BlockStreamServer blockStreamServer = BlockStreamServer.getBlockStreamServer();
        if (!blockStreamServer.registerBlockStream(streamHandle = new RemoteOutputBlockStreamHandle(blockStreamServer, blockCount, (outputBlockStream = this.bufferFile.getOutputBlockStream(blockCount)).getBlockSize()), (BlockStream)outputBlockStream)) {
            throw new IOException("request failed: block stream server not running");
        }
        return streamHandle;
    }
}

