/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

public enum CompareResult {
    UNREL_LT(-1, false),
    REL_LT(-1, true),
    EQUALS(0, true),
    REL_GT(1, true),
    UNREL_GT(1, false);

    public final int compareTo;
    public final boolean related;

    public static CompareResult related(int compareTo) {
        if (compareTo < 0) {
            return REL_LT;
        }
        if (compareTo > 0) {
            return REL_GT;
        }
        return EQUALS;
    }

    public static CompareResult unrelated(int compareTo) {
        if (compareTo < 0) {
            return UNREL_LT;
        }
        if (compareTo > 0) {
            return UNREL_GT;
        }
        return EQUALS;
    }

    public static CompareResult unrelated(CompareResult result) {
        return CompareResult.unrelated(result.compareTo);
    }

    private CompareResult(int compareTo, boolean related) {
        this.compareTo = compareTo;
        this.related = related;
    }
}

