/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;

public abstract class AbstractEnumerateMsType
extends AbstractMsType
implements MsTypeField {
    protected ClassFieldMsAttributes attribute;
    protected Numeric numeric;
    protected String name;

    public AbstractEnumerateMsType(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.attribute = new ClassFieldMsAttributes(reader);
        this.numeric = new Numeric(reader);
        if (!this.numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Numeric getNumeric() {
        return this.numeric;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(this.attribute);
        builder.append(": ");
        builder.append(this.name);
        builder.append("=");
        builder.append(this.numeric);
    }
}

