/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import java.util.Set;
import java.util.stream.Collectors;

public class BreakpointLocationRow {
    private final DebuggerBreakpointsProvider provider;
    private final TraceBreakpointLocation loc;

    public BreakpointLocationRow(DebuggerBreakpointsProvider provider, TraceBreakpointLocation loc) {
        this.provider = provider;
        this.loc = loc;
    }

    private long getSnap() {
        return this.provider.traceManager.getCurrentFor(this.loc.getTrace()).getSnap();
    }

    public String getName() {
        return this.loc.getName(this.getSnap());
    }

    public boolean isEnabled() {
        return this.loc.isEnabled(this.getSnap());
    }

    public LogicalBreakpoint.State getState() {
        LogicalBreakpoint lb = this.provider.breakpointService.getBreakpoint(this.loc);
        if (lb == null) {
            return LogicalBreakpoint.State.NONE;
        }
        return lb.computeStateForLocation(this.loc);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.provider.breakpointService.enableLocs(Set.of(this.loc)).exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        } else {
            this.provider.breakpointService.disableLocs(Set.of(this.loc)).exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }
    }

    public void setState(LogicalBreakpoint.State state) {
        assert (state.isNormal());
        this.setEnabled(state.isEnabled());
    }

    public void setName(String name) {
        try (Transaction tid = this.loc.getTrace().openTransaction("Set breakpoint name");){
            this.loc.setName(this.getSnap(), name);
        }
    }

    public Address getAddress() {
        return this.loc.getMinAddress(this.getSnap());
    }

    public ProgramLocation getProgramLocation() {
        return new ProgramLocation((Program)this.loc.getTrace().getProgramView(), this.getAddress());
    }

    public String getTraceName() {
        return this.loc.getTrace().getName();
    }

    public String getThreads() {
        long snap = this.getSnap();
        return this.loc.getThreads(snap).stream().map(t -> t.getName(snap)).collect(Collectors.toSet()).toString();
    }

    public String getComment() {
        return this.loc.getComment(this.getSnap());
    }

    public void setComment(String comment) {
        try (Transaction tid = this.loc.getTrace().openTransaction("Set breakpoint comment");){
            this.loc.setComment(this.getSnap(), comment);
        }
    }

    public boolean hasSleigh() {
        return !"emu_swi();\nemu_exec_decoded();\n".equals(this.loc.getEmuSleigh(this.getSnap()));
    }

    public TraceBreakpointLocation getTraceBreakpoint() {
        return this.loc;
    }
}

