/*
 *
 *    Copyright (c) 2020-2022 Project CHIP Authors
 *    Copyright (c) 2018 Nest Labs, Inc.
 *    All rights reserved.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 *    @file
 *          Platform-specific configuration overrides for the Chip Device Layer
 *          on the ESP32.
 */

#pragma once
#include <sdkconfig.h>

// ==================== Platform Adaptations ====================

#define CHIP_DEVICE_CONFIG_LWIP_WIFI_STATION_IF_NAME "st"

#define CHIP_DEVICE_CONFIG_ESP32_BLE_ERROR_MIN 0xB00000
// ==================== Kconfig Overrides ====================

// The following values are configured via the ESP-IDF Kconfig mechanism.

#define CHIP_DEVICE_CONFIG_CHIP_TASK_STACK_SIZE CONFIG_CHIP_TASK_STACK_SIZE
#define CHIP_DEVICE_CONFIG_CHIP_TASK_PRIORITY CONFIG_CHIP_TASK_PRIORITY
#define CHIP_DEVICE_CONFIG_MAX_EVENT_QUEUE_SIZE CONFIG_MAX_EVENT_QUEUE_SIZE
#ifndef CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID
#define CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID CONFIG_DEVICE_VENDOR_ID
#endif /* CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID */
#ifndef CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID
#define CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID CONFIG_DEVICE_PRODUCT_ID
#define CHIP_DEVICE_CONFIG_DEVICE_TYPE CONFIG_DEVICE_TYPE
#define CHIP_DEVICE_CONFIG_DEFAULT_DEVICE_HARDWARE_VERSION CONFIG_DEFAULT_DEVICE_HARDWARE_VERSION

#endif /* CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID */

#ifdef CONFIG_ENABLE_MATTER_OVER_THREAD
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD CONFIG_ENABLE_MATTER_OVER_THREAD
#ifndef CONFIG_THREAD_NETWORK_COMMISSIONING_DRIVER
#define _NO_NETWORK_COMMISSIONING_DRIVER_ 1
#endif
#else
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD 0
#endif // CONFIG_ENABLE_MATTER_OVER_THREAD

#ifdef CONFIG_OPENTHREAD_SRP_CLIENT
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_SRP_CLIENT CONFIG_OPENTHREAD_SRP_CLIENT
#else
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_SRP_CLIENT 0
#endif // CONFIG_OPENTHREAD_SRP_CLIENT

#ifdef CONFIG_OPENTHREAD_DNS_CLIENT
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_DNS_CLIENT CONFIG_OPENTHREAD_DNS_CLIENT
#else
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_DNS_CLIENT 0
#endif // CONFIG_OPENTHREAD_DNS_CLIENT

#ifdef CONFIG_ENABLE_ETHERNET_TELEMETRY
#define CHIP_DEVICE_CONFIG_ENABLE_ETHERNET 1
#else
#define CHIP_DEVICE_CONFIG_ENABLE_ETHERNET 0
#endif // CONFIG_ENABLE_ETHERNET_TELEMETRY

#define CHIP_DEVICE_CONFIG_ENABLE_WIFI CHIP_DEVICE_CONFIG_ENABLE_WIFI_AP | CHIP_DEVICE_CONFIG_ENABLE_WIFI_STATION
#if CHIP_DEVICE_CONFIG_ENABLE_WIFI
#define CHIP_DEVICE_CONFIG_ENABLE_WIFI_TELEMETRY CONFIG_ENABLE_WIFI_TELEMETRY
#define CHIP_DEVICE_CONFIG_WIFI_STATION_RECONNECT_INTERVAL CONFIG_WIFI_STATION_RECONNECT_INTERVAL
#define CHIP_DEVICE_CONFIG_MAX_SCAN_NETWORKS_RESULTS CONFIG_MAX_SCAN_NETWORKS_RESULTS
#define CHIP_DEVICE_CONFIG_WIFI_SCAN_COMPLETION_TIMEOUT CONFIG_WIFI_SCAN_COMPLETION_TIMEOUT
#define CHIP_DEVICE_CONFIG_WIFI_CONNECTIVITY_TIMEOUT CONFIG_WIFI_CONNECTIVITY_TIMEOUT
#if CHIP_DEVICE_CONFIG_ENABLE_WIFI_AP
#define CHIP_DEVICE_CONFIG_WIFI_AP_SSID_PREFIX CONFIG_WIFI_AP_SSID_PREFIX
#define CHIP_DEVICE_CONFIG_WIFI_AP_CHANNEL CONFIG_WIFI_AP_CHANNEL
#define CHIP_DEVICE_CONFIG_WIFI_AP_MAX_STATIONS CONFIG_WIFI_AP_MAX_STATIONS
#define CHIP_DEVICE_CONFIG_WIFI_AP_BEACON_INTERVAL CONFIG_WIFI_AP_BEACON_INTERVAL
#define CHIP_DEVICE_CONFIG_WIFI_AP_IDLE_TIMEOUT CONFIG_WIFI_AP_IDLE_TIMEOUT
#endif /* CHIP_DEVICE_CONFIG_ENABLE_WIFI_AP */
#endif // CHIP_DEVICE_CONFIG_ENABLE_WIFI

#ifdef CONFIG_ENABLE_ICD_SERVER
#define CHIP_DEVICE_CONFIG_ICD_SLOW_POLL_INTERVAL chip::System::Clock::Milliseconds32(CONFIG_ICD_SLOW_POLL_INTERVAL_MS)
#define CHIP_DEVICE_CONFIG_ICD_FAST_POLL_INTERVAL chip::System::Clock::Milliseconds32(CONFIG_ICD_FAST_POLL_INTERVAL_MS)
#endif // CHIP_CONFIG_ENABLE_ICD_SERVER

#ifdef CONFIG_ENABLE_CHIPOBLE
#define CHIP_DEVICE_CONFIG_ENABLE_CHIPOBLE CONFIG_ENABLE_CHIPOBLE
#else
#define CHIP_DEVICE_CONFIG_ENABLE_CHIPOBLE 0
#endif // CONFIG_ENABLE_CHIPOBLE

#ifdef CONFIG_ENABLE_EXTENDED_DISCOVERY
#define CHIP_DEVICE_CONFIG_ENABLE_EXTENDED_DISCOVERY CONFIG_ENABLE_EXTENDED_DISCOVERY
#else
#define CHIP_DEVICE_CONFIG_ENABLE_EXTENDED_DISCOVERY 0
#endif // CONFIG_ENABLE_EXTENDED_DISCOVERY

#ifdef CONFIG_ENABLE_COMMISSIONABLE_DEVICE_TYPE
#define CHIP_DEVICE_CONFIG_ENABLE_COMMISSIONABLE_DEVICE_TYPE CONFIG_ENABLE_COMMISSIONABLE_DEVICE_TYPE
#else
#define CHIP_DEVICE_CONFIG_ENABLE_COMMISSIONABLE_DEVICE_TYPE 0
#endif // CONFIG_ENABLE_COMMISSIONABLE_DEVICE_TYPE

#define CHIP_DEVICE_CONFIG_BLE_DEVICE_NAME_PREFIX CONFIG_BLE_DEVICE_NAME_PREFIX
#define CHIP_DEVICE_CONFIG_BLE_FAST_ADVERTISING_INTERVAL_MIN CONFIG_BLE_FAST_ADVERTISING_INTERVAL_MIN
#define CHIP_DEVICE_CONFIG_BLE_FAST_ADVERTISING_INTERVAL_MAX CONFIG_BLE_FAST_ADVERTISING_INTERVAL_MAX
#define CHIP_DEVICE_CONFIG_BLE_SLOW_ADVERTISING_INTERVAL_MIN CONFIG_BLE_SLOW_ADVERTISING_INTERVAL_MIN
#define CHIP_DEVICE_CONFIG_BLE_SLOW_ADVERTISING_INTERVAL_MAX CONFIG_BLE_SLOW_ADVERTISING_INTERVAL_MAX
#define CHIP_DEVICE_CONFIG_CHIPOBLE_SINGLE_CONNECTION CONFIG_CHIPOBLE_SINGLE_CONNECTION
#define CHIP_DEVICE_CONFIG_CHIPOBLE_ENABLE_ADVERTISING_AUTOSTART CONFIG_CHIPOBLE_ENABLE_ADVERTISING_AUTOSTART
#define CHIP_DEVICE_CONFIG_SERVICE_PROVISIONING_ENDPOINT_ID CONFIG_SERVICE_PROVISIONING_ENDPOINT_ID
#define CHIP_DEVICE_CONFIG_SERVICE_PROVISIONING_CONNECTIVITY_TIMEOUT CONFIG_SERVICE_PROVISIONING_CONNECTIVITY_TIMEOUT
#define CHIP_DEVICE_CONFIG_SERVICE_PROVISIONING_REQUEST_TIMEOUT CONFIG_SERVICE_PROVISIONING_REQUEST_TIMEOUT

#ifdef CONFIG_ENABLE_TEST_SETUP_PARAMS
#define CHIP_DEVICE_CONFIG_ENABLE_TEST_SETUP_PARAMS 1
#else
#define CHIP_DEVICE_CONFIG_ENABLE_TEST_SETUP_PARAMS 0
#endif // CONFIG_ENABLE_TEST_SETUP_PARAMS

#define CHIP_DEVICE_CONFIG_TEST_SERIAL_NUMBER CONFIG_USE_TEST_SERIAL_NUMBER

#ifdef CONFIG_ENABLE_THREAD_TELEMETRY
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_TELEMETRY CONFIG_ENABLE_THREAD_TELEMETRY
#else
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_TELEMETRY 0
#endif // CONFIG_ENABLE_THREAD_TELEMETRY

#ifdef CONFIG_ENABLE_THREAD_TELEMETRY_FULL
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_TELEMETRY_FULL CONFIG_ENABLE_THREAD_TELEMETRY_FULL
#else
#define CHIP_DEVICE_CONFIG_ENABLE_THREAD_TELEMETRY_FULL 0
#endif // CONFIG_ENABLE_THREAD_TELEMETRY_FULL

#define CHIP_DEVICE_CONFIG_EVENT_LOGGING_CRIT_BUFFER_SIZE CONFIG_EVENT_LOGGING_CRIT_BUFFER_SIZE
#define CHIP_DEVICE_CONFIG_EVENT_LOGGING_INFO_BUFFER_SIZE CONFIG_EVENT_LOGGING_INFO_BUFFER_SIZE
#define CHIP_DEVICE_CONFIG_EVENT_LOGGING_DEBUG_BUFFER_SIZE CONFIG_EVENT_LOGGING_DEBUG_BUFFER_SIZE
#define CHIP_DEVICE_CONFIG_CHIP_FACTORY_NAMESPACE_PARTITION CONFIG_CHIP_FACTORY_NAMESPACE_PARTITION_LABEL
#define CHIP_DEVICE_CONFIG_CHIP_CONFIG_NAMESPACE_PARTITION CONFIG_CHIP_CONFIG_NAMESPACE_PARTITION_LABEL
#define CHIP_DEVICE_CONFIG_CHIP_COUNTERS_NAMESPACE_PARTITION CONFIG_CHIP_COUNTERS_NAMESPACE_PARTITION_LABEL
#define CHIP_DEVICE_CONFIG_CHIP_KVS_NAMESPACE_PARTITION CONFIG_CHIP_KVS_NAMESPACE_PARTITION_LABEL
#define CHIP_DEVICE_CONFIG_ENABLE_DEVICE_INSTANCE_INFO_PROVIDER CONFIG_ENABLE_ESP32_DEVICE_INSTANCE_INFO_PROVIDER
#define CHIP_DEVICE_CONFIG_DISCOVERY_TIMEOUT_SECS CONFIG_CHIP_DISCOVERY_TIMEOUT_SECS
#define CHIP_DEVICE_CONFIG_ENABLE_BOTH_COMMISSIONER_AND_COMMISSIONEE CONFIG_ENABLE_ESP32_BLE_CONTROLLER
#define CHIP_DEVICE_CONFIG_ENABLE_PAIRING_AUTOSTART CONFIG_CHIP_ENABLE_PAIRING_AUTOSTART

#ifdef CONFIG_ENABLE_BLE_EXT_ANNOUNCEMENT
#define CHIP_DEVICE_CONFIG_EXT_ADVERTISING CONFIG_ENABLE_BLE_EXT_ANNOUNCEMENT
#else
#define CHIP_DEVICE_CONFIG_EXT_ADVERTISING 0
#endif

// Options for background chip task
#ifdef CONFIG_ENABLE_BG_EVENT_PROCESSING
#define CHIP_DEVICE_CONFIG_ENABLE_BG_EVENT_PROCESSING CONFIG_ENABLE_BG_EVENT_PROCESSING
#else
#define CHIP_DEVICE_CONFIG_ENABLE_BG_EVENT_PROCESSING 0
#endif // CONFIG_ENABLE_BG_EVENT_PROCESSING

#define CHIP_DEVICE_CONFIG_BG_TASK_PRIORITY CONFIG_BG_CHIP_TASK_PRIORITY
#define CHIP_DEVICE_CONFIG_BG_MAX_EVENT_QUEUE_SIZE CONFIG_BG_MAX_EVENT_QUEUE_SIZE
#define CHIP_DEVICE_CONFIG_BG_TASK_STACK_SIZE CONFIG_BG_CHIP_TASK_STACK_SIZE

#ifdef CONFIG_WIFI_NETWORK_COMMISSIONING_DRIVER
#define CHIP_DEVICE_CONFIG_WIFI_NETWORK_DRIVER CONFIG_WIFI_NETWORK_COMMISSIONING_DRIVER
#else
#define CHIP_DEVICE_CONFIG_WIFI_NETWORK_DRIVER 0
#endif // CONFIG_WIFI_NETWORK_COMMISSIONING_DRIVER

#ifdef CONFIG_ETHERNET_NETWORK_COMMISSIONING_DRIVER
#define CHIP_DEVICE_CONFIG_ETHERNET_NETWORK_DRIVER CONFIG_ETHERNET_NETWORK_COMMISSIONING_DRIVER
#else
#define CHIP_DEVICE_CONFIG_ETHERNET_NETWORK_DRIVER 0
#endif // CONFIG_ETHERNET_NETWORK_COMMISSIONING_DRIVER
