/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** LP_CLKRST_LP_CLK_CONF_REG register
 *  need_des
 */
#define LP_CLKRST_LP_CLK_CONF_REG (DR_REG_LP_CLKRST_BASE + 0x0)
/** LP_CLKRST_SLOW_CLK_SEL : R/W; bitpos: [1:0]; default: 0;
 *  need_des
 */
#define LP_CLKRST_SLOW_CLK_SEL    0x00000003U
#define LP_CLKRST_SLOW_CLK_SEL_M  (LP_CLKRST_SLOW_CLK_SEL_V << LP_CLKRST_SLOW_CLK_SEL_S)
#define LP_CLKRST_SLOW_CLK_SEL_V  0x00000003U
#define LP_CLKRST_SLOW_CLK_SEL_S  0
/** LP_CLKRST_FAST_CLK_SEL : R/W; bitpos: [3:2]; default: 1;
 *  need_des
 */
#define LP_CLKRST_FAST_CLK_SEL    0x00000003U
#define LP_CLKRST_FAST_CLK_SEL_M  (LP_CLKRST_FAST_CLK_SEL_V << LP_CLKRST_FAST_CLK_SEL_S)
#define LP_CLKRST_FAST_CLK_SEL_V  0x00000003U
#define LP_CLKRST_FAST_CLK_SEL_S  2
/** LP_CLKRST_LP_PERI_DIV_NUM : R/W; bitpos: [9:4]; default: 0;
 *  need_des
 */
#define LP_CLKRST_LP_PERI_DIV_NUM    0x0000003FU
#define LP_CLKRST_LP_PERI_DIV_NUM_M  (LP_CLKRST_LP_PERI_DIV_NUM_V << LP_CLKRST_LP_PERI_DIV_NUM_S)
#define LP_CLKRST_LP_PERI_DIV_NUM_V  0x0000003FU
#define LP_CLKRST_LP_PERI_DIV_NUM_S  4
/** LP_CLKRST_ANA_SEL_REF_PLL8M : R/W; bitpos: [10]; default: 0;
 *  need_des
 */
#define LP_CLKRST_ANA_SEL_REF_PLL8M    (BIT(10))
#define LP_CLKRST_ANA_SEL_REF_PLL8M_M  (LP_CLKRST_ANA_SEL_REF_PLL8M_V << LP_CLKRST_ANA_SEL_REF_PLL8M_S)
#define LP_CLKRST_ANA_SEL_REF_PLL8M_V  0x00000001U
#define LP_CLKRST_ANA_SEL_REF_PLL8M_S  10

/** LP_CLKRST_LP_CLK_PO_EN_REG register
 *  need_des
 */
#define LP_CLKRST_LP_CLK_PO_EN_REG (DR_REG_LP_CLKRST_BASE + 0x4)
/** LP_CLKRST_CLK_CORE_EFUSE_OEN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_CORE_EFUSE_OEN    (BIT(0))
#define LP_CLKRST_CLK_CORE_EFUSE_OEN_M  (LP_CLKRST_CLK_CORE_EFUSE_OEN_V << LP_CLKRST_CLK_CORE_EFUSE_OEN_S)
#define LP_CLKRST_CLK_CORE_EFUSE_OEN_V  0x00000001U
#define LP_CLKRST_CLK_CORE_EFUSE_OEN_S  0
/** LP_CLKRST_CLK_LP_BUS_OEN : R/W; bitpos: [1]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_LP_BUS_OEN    (BIT(1))
#define LP_CLKRST_CLK_LP_BUS_OEN_M  (LP_CLKRST_CLK_LP_BUS_OEN_V << LP_CLKRST_CLK_LP_BUS_OEN_S)
#define LP_CLKRST_CLK_LP_BUS_OEN_V  0x00000001U
#define LP_CLKRST_CLK_LP_BUS_OEN_S  1
/** LP_CLKRST_CLK_AON_SLOW_OEN : R/W; bitpos: [2]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_AON_SLOW_OEN    (BIT(2))
#define LP_CLKRST_CLK_AON_SLOW_OEN_M  (LP_CLKRST_CLK_AON_SLOW_OEN_V << LP_CLKRST_CLK_AON_SLOW_OEN_S)
#define LP_CLKRST_CLK_AON_SLOW_OEN_V  0x00000001U
#define LP_CLKRST_CLK_AON_SLOW_OEN_S  2
/** LP_CLKRST_CLK_AON_FAST_OEN : R/W; bitpos: [3]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_AON_FAST_OEN    (BIT(3))
#define LP_CLKRST_CLK_AON_FAST_OEN_M  (LP_CLKRST_CLK_AON_FAST_OEN_V << LP_CLKRST_CLK_AON_FAST_OEN_S)
#define LP_CLKRST_CLK_AON_FAST_OEN_V  0x00000001U
#define LP_CLKRST_CLK_AON_FAST_OEN_S  3
/** LP_CLKRST_CLK_SLOW_OEN : R/W; bitpos: [4]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_SLOW_OEN    (BIT(4))
#define LP_CLKRST_CLK_SLOW_OEN_M  (LP_CLKRST_CLK_SLOW_OEN_V << LP_CLKRST_CLK_SLOW_OEN_S)
#define LP_CLKRST_CLK_SLOW_OEN_V  0x00000001U
#define LP_CLKRST_CLK_SLOW_OEN_S  4
/** LP_CLKRST_CLK_FAST_OEN : R/W; bitpos: [5]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_FAST_OEN    (BIT(5))
#define LP_CLKRST_CLK_FAST_OEN_M  (LP_CLKRST_CLK_FAST_OEN_V << LP_CLKRST_CLK_FAST_OEN_S)
#define LP_CLKRST_CLK_FAST_OEN_V  0x00000001U
#define LP_CLKRST_CLK_FAST_OEN_S  5
/** LP_CLKRST_CLK_FOSC_OEN : R/W; bitpos: [6]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_FOSC_OEN    (BIT(6))
#define LP_CLKRST_CLK_FOSC_OEN_M  (LP_CLKRST_CLK_FOSC_OEN_V << LP_CLKRST_CLK_FOSC_OEN_S)
#define LP_CLKRST_CLK_FOSC_OEN_V  0x00000001U
#define LP_CLKRST_CLK_FOSC_OEN_S  6
/** LP_CLKRST_CLK_RC32K_OEN : R/W; bitpos: [7]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_RC32K_OEN    (BIT(7))
#define LP_CLKRST_CLK_RC32K_OEN_M  (LP_CLKRST_CLK_RC32K_OEN_V << LP_CLKRST_CLK_RC32K_OEN_S)
#define LP_CLKRST_CLK_RC32K_OEN_V  0x00000001U
#define LP_CLKRST_CLK_RC32K_OEN_S  7
/** LP_CLKRST_CLK_SXTAL_OEN : R/W; bitpos: [8]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_SXTAL_OEN    (BIT(8))
#define LP_CLKRST_CLK_SXTAL_OEN_M  (LP_CLKRST_CLK_SXTAL_OEN_V << LP_CLKRST_CLK_SXTAL_OEN_S)
#define LP_CLKRST_CLK_SXTAL_OEN_V  0x00000001U
#define LP_CLKRST_CLK_SXTAL_OEN_S  8
/** LP_CLKRST_CLK_SOSC_OEN : R/W; bitpos: [9]; default: 0;
 *  1'b1: probe sosc clk on
 *  1'b0: probe sosc clk off
 */
#define LP_CLKRST_CLK_SOSC_OEN    (BIT(9))
#define LP_CLKRST_CLK_SOSC_OEN_M  (LP_CLKRST_CLK_SOSC_OEN_V << LP_CLKRST_CLK_SOSC_OEN_S)
#define LP_CLKRST_CLK_SOSC_OEN_V  0x00000001U
#define LP_CLKRST_CLK_SOSC_OEN_S  9

/** LP_CLKRST_LP_CLK_EN_REG register
 *  need_des
 */
#define LP_CLKRST_LP_CLK_EN_REG (DR_REG_LP_CLKRST_BASE + 0x8)
/** LP_CLKRST_LP_RTC_XTAL_FORCE_ON : R/W; bitpos: [26]; default: 0;
 *  need_des
 */
#define LP_CLKRST_LP_RTC_XTAL_FORCE_ON    (BIT(26))
#define LP_CLKRST_LP_RTC_XTAL_FORCE_ON_M  (LP_CLKRST_LP_RTC_XTAL_FORCE_ON_V << LP_CLKRST_LP_RTC_XTAL_FORCE_ON_S)
#define LP_CLKRST_LP_RTC_XTAL_FORCE_ON_V  0x00000001U
#define LP_CLKRST_LP_RTC_XTAL_FORCE_ON_S  26
/** LP_CLKRST_CK_EN_LP_RAM : R/W; bitpos: [27]; default: 1;
 *  need_des
 */
#define LP_CLKRST_CK_EN_LP_RAM    (BIT(27))
#define LP_CLKRST_CK_EN_LP_RAM_M  (LP_CLKRST_CK_EN_LP_RAM_V << LP_CLKRST_CK_EN_LP_RAM_S)
#define LP_CLKRST_CK_EN_LP_RAM_V  0x00000001U
#define LP_CLKRST_CK_EN_LP_RAM_S  27
/** LP_CLKRST_ETM_EVENT_TICK_EN : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_CLKRST_ETM_EVENT_TICK_EN    (BIT(28))
#define LP_CLKRST_ETM_EVENT_TICK_EN_M  (LP_CLKRST_ETM_EVENT_TICK_EN_V << LP_CLKRST_ETM_EVENT_TICK_EN_S)
#define LP_CLKRST_ETM_EVENT_TICK_EN_V  0x00000001U
#define LP_CLKRST_ETM_EVENT_TICK_EN_S  28
/** LP_CLKRST_PLL8M_CLK_FORCE_ON : R/W; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_CLKRST_PLL8M_CLK_FORCE_ON    (BIT(29))
#define LP_CLKRST_PLL8M_CLK_FORCE_ON_M  (LP_CLKRST_PLL8M_CLK_FORCE_ON_V << LP_CLKRST_PLL8M_CLK_FORCE_ON_S)
#define LP_CLKRST_PLL8M_CLK_FORCE_ON_V  0x00000001U
#define LP_CLKRST_PLL8M_CLK_FORCE_ON_S  29
/** LP_CLKRST_XTAL_CLK_FORCE_ON : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_CLKRST_XTAL_CLK_FORCE_ON    (BIT(30))
#define LP_CLKRST_XTAL_CLK_FORCE_ON_M  (LP_CLKRST_XTAL_CLK_FORCE_ON_V << LP_CLKRST_XTAL_CLK_FORCE_ON_S)
#define LP_CLKRST_XTAL_CLK_FORCE_ON_V  0x00000001U
#define LP_CLKRST_XTAL_CLK_FORCE_ON_S  30
/** LP_CLKRST_FOSC_CLK_FORCE_ON : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_CLKRST_FOSC_CLK_FORCE_ON    (BIT(31))
#define LP_CLKRST_FOSC_CLK_FORCE_ON_M  (LP_CLKRST_FOSC_CLK_FORCE_ON_V << LP_CLKRST_FOSC_CLK_FORCE_ON_S)
#define LP_CLKRST_FOSC_CLK_FORCE_ON_V  0x00000001U
#define LP_CLKRST_FOSC_CLK_FORCE_ON_S  31

/** LP_CLKRST_LP_RST_EN_REG register
 *  need_des
 */
#define LP_CLKRST_LP_RST_EN_REG (DR_REG_LP_CLKRST_BASE + 0xc)
/** LP_CLKRST_RST_EN_LP_HUK : R/W; bitpos: [24]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_HUK    (BIT(24))
#define LP_CLKRST_RST_EN_LP_HUK_M  (LP_CLKRST_RST_EN_LP_HUK_V << LP_CLKRST_RST_EN_LP_HUK_S)
#define LP_CLKRST_RST_EN_LP_HUK_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_HUK_S  24
/** LP_CLKRST_RST_EN_LP_ANAPERI : R/W; bitpos: [25]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_ANAPERI    (BIT(25))
#define LP_CLKRST_RST_EN_LP_ANAPERI_M  (LP_CLKRST_RST_EN_LP_ANAPERI_V << LP_CLKRST_RST_EN_LP_ANAPERI_S)
#define LP_CLKRST_RST_EN_LP_ANAPERI_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_ANAPERI_S  25
/** LP_CLKRST_RST_EN_LP_WDT : R/W; bitpos: [26]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_WDT    (BIT(26))
#define LP_CLKRST_RST_EN_LP_WDT_M  (LP_CLKRST_RST_EN_LP_WDT_V << LP_CLKRST_RST_EN_LP_WDT_S)
#define LP_CLKRST_RST_EN_LP_WDT_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_WDT_S  26
/** LP_CLKRST_RST_EN_LP_TIMER : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_TIMER    (BIT(27))
#define LP_CLKRST_RST_EN_LP_TIMER_M  (LP_CLKRST_RST_EN_LP_TIMER_V << LP_CLKRST_RST_EN_LP_TIMER_S)
#define LP_CLKRST_RST_EN_LP_TIMER_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_TIMER_S  27
/** LP_CLKRST_RST_EN_LP_RTC : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_RTC    (BIT(28))
#define LP_CLKRST_RST_EN_LP_RTC_M  (LP_CLKRST_RST_EN_LP_RTC_V << LP_CLKRST_RST_EN_LP_RTC_S)
#define LP_CLKRST_RST_EN_LP_RTC_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_RTC_S  28
/** LP_CLKRST_RST_EN_LP_MAILBOX : R/W; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_MAILBOX    (BIT(29))
#define LP_CLKRST_RST_EN_LP_MAILBOX_M  (LP_CLKRST_RST_EN_LP_MAILBOX_V << LP_CLKRST_RST_EN_LP_MAILBOX_S)
#define LP_CLKRST_RST_EN_LP_MAILBOX_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_MAILBOX_S  29
/** LP_CLKRST_RST_EN_LP_AONEFUSEREG : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_AONEFUSEREG    (BIT(30))
#define LP_CLKRST_RST_EN_LP_AONEFUSEREG_M  (LP_CLKRST_RST_EN_LP_AONEFUSEREG_V << LP_CLKRST_RST_EN_LP_AONEFUSEREG_S)
#define LP_CLKRST_RST_EN_LP_AONEFUSEREG_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_AONEFUSEREG_S  30
/** LP_CLKRST_RST_EN_LP_RAM : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_CLKRST_RST_EN_LP_RAM    (BIT(31))
#define LP_CLKRST_RST_EN_LP_RAM_M  (LP_CLKRST_RST_EN_LP_RAM_V << LP_CLKRST_RST_EN_LP_RAM_S)
#define LP_CLKRST_RST_EN_LP_RAM_V  0x00000001U
#define LP_CLKRST_RST_EN_LP_RAM_S  31

/** LP_CLKRST_RESET_CAUSE_REG register
 *  need_des
 */
#define LP_CLKRST_RESET_CAUSE_REG (DR_REG_LP_CLKRST_BASE + 0x10)
/** LP_CLKRST_LPCORE_RESET_CAUSE : RO; bitpos: [5:0]; default: 0;
 *  6'h1: POR reset
 *  6'h9: PMU LP PERI power down reset
 *  6'ha: PMU LP CPU reset
 *  6'hf: brown out reset
 *  6'h10: LP watchdog chip reset
 *  6'h12: super watch dog reset
 *  6'h13: glitch reset
 *  6'h14: software reset
 */
#define LP_CLKRST_LPCORE_RESET_CAUSE    0x0000003FU
#define LP_CLKRST_LPCORE_RESET_CAUSE_M  (LP_CLKRST_LPCORE_RESET_CAUSE_V << LP_CLKRST_LPCORE_RESET_CAUSE_S)
#define LP_CLKRST_LPCORE_RESET_CAUSE_V  0x0000003FU
#define LP_CLKRST_LPCORE_RESET_CAUSE_S  0
/** LP_CLKRST_LPCORE_RESET_FLAG : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define LP_CLKRST_LPCORE_RESET_FLAG    (BIT(6))
#define LP_CLKRST_LPCORE_RESET_FLAG_M  (LP_CLKRST_LPCORE_RESET_FLAG_V << LP_CLKRST_LPCORE_RESET_FLAG_S)
#define LP_CLKRST_LPCORE_RESET_FLAG_V  0x00000001U
#define LP_CLKRST_LPCORE_RESET_FLAG_S  6
/** LP_CLKRST_HPCORE0_RESET_CAUSE : RO; bitpos: [12:7]; default: 0;
 *  6'h1: POR reset
 *  6'h3: digital system software reset
 *  6'h5: PMU HP system power down reset
 *  6'h7: HP system reset from HP watchdog
 *  6'h9: HP system reset from LP watchdog
 *  6'hb: HP core reset from HP watchdog
 *  6'hc: HP core software reset
 *  6'hd: HP core reset from LP watchdog
 *  6'hf: brown out reset
 *  6'h10: LP watchdog chip reset
 *  6'h12: super watch dog reset
 *  6'h13: glitch reset
 *  6'h14: efuse crc error reset
 *  6'h16: HP usb jtag chip reset
 *  6'h17: HP usb uart chip reset
 *  6'h18: HP jtag reset
 *  6'h1a: HP core lockup
 */
#define LP_CLKRST_HPCORE0_RESET_CAUSE    0x0000003FU
#define LP_CLKRST_HPCORE0_RESET_CAUSE_M  (LP_CLKRST_HPCORE0_RESET_CAUSE_V << LP_CLKRST_HPCORE0_RESET_CAUSE_S)
#define LP_CLKRST_HPCORE0_RESET_CAUSE_V  0x0000003FU
#define LP_CLKRST_HPCORE0_RESET_CAUSE_S  7
/** LP_CLKRST_HPCORE0_RESET_FLAG : RO; bitpos: [13]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_RESET_FLAG    (BIT(13))
#define LP_CLKRST_HPCORE0_RESET_FLAG_M  (LP_CLKRST_HPCORE0_RESET_FLAG_V << LP_CLKRST_HPCORE0_RESET_FLAG_S)
#define LP_CLKRST_HPCORE0_RESET_FLAG_V  0x00000001U
#define LP_CLKRST_HPCORE0_RESET_FLAG_S  13
/** LP_CLKRST_HPCORE1_RESET_CAUSE : RO; bitpos: [19:14]; default: 0;
 *  6'h1: POR reset
 *  6'h3: digital system software reset
 *  6'h5: PMU HP system power down reset
 *  6'h7: HP system reset from HP watchdog
 *  6'h9: HP system reset from LP watchdog
 *  6'hb: HP core reset from HP watchdog
 *  6'hc: HP core software reset
 *  6'hd: HP core reset from LP watchdog
 *  6'hf: brown out reset
 *  6'h10: LP watchdog chip reset
 *  6'h12: super watch dog reset
 *  6'h13: glitch reset
 *  6'h14: efuse crc error reset
 *  6'h16: HP usb jtag chip reset
 *  6'h17: HP usb uart chip reset
 *  6'h18: HP jtag reset
 *  6'h1a: HP core lockup
 */
#define LP_CLKRST_HPCORE1_RESET_CAUSE    0x0000003FU
#define LP_CLKRST_HPCORE1_RESET_CAUSE_M  (LP_CLKRST_HPCORE1_RESET_CAUSE_V << LP_CLKRST_HPCORE1_RESET_CAUSE_S)
#define LP_CLKRST_HPCORE1_RESET_CAUSE_V  0x0000003FU
#define LP_CLKRST_HPCORE1_RESET_CAUSE_S  14
/** LP_CLKRST_HPCORE1_RESET_FLAG : RO; bitpos: [20]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_RESET_FLAG    (BIT(20))
#define LP_CLKRST_HPCORE1_RESET_FLAG_M  (LP_CLKRST_HPCORE1_RESET_FLAG_V << LP_CLKRST_HPCORE1_RESET_FLAG_S)
#define LP_CLKRST_HPCORE1_RESET_FLAG_V  0x00000001U
#define LP_CLKRST_HPCORE1_RESET_FLAG_S  20
/** LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK : R/W; bitpos: [25]; default: 1;
 *  1'b0: enable lpcore pmu_lp_cpu_reset reset_cause, 1'b1: disable lpcore
 *  pmu_lp_cpu_reset reset_cause
 */
#define LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK    (BIT(25))
#define LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK_M  (LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK_V << LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK_S)
#define LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK_V  0x00000001U
#define LP_CLKRST_LPCORE_RESET_CAUSE_PMU_LP_CPU_MASK_S  25
/** LP_CLKRST_LPCORE_RESET_CAUSE_CLR : WT; bitpos: [26]; default: 0;
 *  need_des
 */
#define LP_CLKRST_LPCORE_RESET_CAUSE_CLR    (BIT(26))
#define LP_CLKRST_LPCORE_RESET_CAUSE_CLR_M  (LP_CLKRST_LPCORE_RESET_CAUSE_CLR_V << LP_CLKRST_LPCORE_RESET_CAUSE_CLR_S)
#define LP_CLKRST_LPCORE_RESET_CAUSE_CLR_V  0x00000001U
#define LP_CLKRST_LPCORE_RESET_CAUSE_CLR_S  26
/** LP_CLKRST_LPCORE_RESET_FLAG_CLR : WT; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_CLKRST_LPCORE_RESET_FLAG_CLR    (BIT(27))
#define LP_CLKRST_LPCORE_RESET_FLAG_CLR_M  (LP_CLKRST_LPCORE_RESET_FLAG_CLR_V << LP_CLKRST_LPCORE_RESET_FLAG_CLR_S)
#define LP_CLKRST_LPCORE_RESET_FLAG_CLR_V  0x00000001U
#define LP_CLKRST_LPCORE_RESET_FLAG_CLR_S  27
/** LP_CLKRST_HPCORE0_RESET_CAUSE_CLR : WT; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_RESET_CAUSE_CLR    (BIT(28))
#define LP_CLKRST_HPCORE0_RESET_CAUSE_CLR_M  (LP_CLKRST_HPCORE0_RESET_CAUSE_CLR_V << LP_CLKRST_HPCORE0_RESET_CAUSE_CLR_S)
#define LP_CLKRST_HPCORE0_RESET_CAUSE_CLR_V  0x00000001U
#define LP_CLKRST_HPCORE0_RESET_CAUSE_CLR_S  28
/** LP_CLKRST_HPCORE0_RESET_FLAG_CLR : WT; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_RESET_FLAG_CLR    (BIT(29))
#define LP_CLKRST_HPCORE0_RESET_FLAG_CLR_M  (LP_CLKRST_HPCORE0_RESET_FLAG_CLR_V << LP_CLKRST_HPCORE0_RESET_FLAG_CLR_S)
#define LP_CLKRST_HPCORE0_RESET_FLAG_CLR_V  0x00000001U
#define LP_CLKRST_HPCORE0_RESET_FLAG_CLR_S  29
/** LP_CLKRST_HPCORE1_RESET_CAUSE_CLR : WT; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_RESET_CAUSE_CLR    (BIT(30))
#define LP_CLKRST_HPCORE1_RESET_CAUSE_CLR_M  (LP_CLKRST_HPCORE1_RESET_CAUSE_CLR_V << LP_CLKRST_HPCORE1_RESET_CAUSE_CLR_S)
#define LP_CLKRST_HPCORE1_RESET_CAUSE_CLR_V  0x00000001U
#define LP_CLKRST_HPCORE1_RESET_CAUSE_CLR_S  30
/** LP_CLKRST_HPCORE1_RESET_FLAG_CLR : WT; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_RESET_FLAG_CLR    (BIT(31))
#define LP_CLKRST_HPCORE1_RESET_FLAG_CLR_M  (LP_CLKRST_HPCORE1_RESET_FLAG_CLR_V << LP_CLKRST_HPCORE1_RESET_FLAG_CLR_S)
#define LP_CLKRST_HPCORE1_RESET_FLAG_CLR_V  0x00000001U
#define LP_CLKRST_HPCORE1_RESET_FLAG_CLR_S  31

/** LP_CLKRST_HPCPU_RESET_CTRL0_REG register
 *  need_des
 */
#define LP_CLKRST_HPCPU_RESET_CTRL0_REG (DR_REG_LP_CLKRST_BASE + 0x14)
/** LP_CLKRST_HPCORE0_LOCKUP_RESET_EN : R/W; bitpos: [0]; default: 0;
 *  write 1 to enable hpcore0 lockup reset feature, write 0 to disable hpcore0 lockup
 *  reset feature
 */
#define LP_CLKRST_HPCORE0_LOCKUP_RESET_EN    (BIT(0))
#define LP_CLKRST_HPCORE0_LOCKUP_RESET_EN_M  (LP_CLKRST_HPCORE0_LOCKUP_RESET_EN_V << LP_CLKRST_HPCORE0_LOCKUP_RESET_EN_S)
#define LP_CLKRST_HPCORE0_LOCKUP_RESET_EN_V  0x00000001U
#define LP_CLKRST_HPCORE0_LOCKUP_RESET_EN_S  0
/** LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH : R/W; bitpos: [3:1]; default: 1;
 *  need_des
 */
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH    0x00000007U
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH_M  (LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH_V << LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH_S)
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH_V  0x00000007U
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_LENGTH_S  1
/** LP_CLKRST_LP_WDT_HPCORE0_RESET_EN : R/W; bitpos: [4]; default: 0;
 *  write 1 to enable lp_wdt reset hpcore0 feature, write 0 to disable lp_wdt reset
 *  hpcore0 feature
 */
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_EN    (BIT(4))
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_EN_M  (LP_CLKRST_LP_WDT_HPCORE0_RESET_EN_V << LP_CLKRST_LP_WDT_HPCORE0_RESET_EN_S)
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_EN_V  0x00000001U
#define LP_CLKRST_LP_WDT_HPCORE0_RESET_EN_S  4
/** LP_CLKRST_HPCORE0_STALL_WAIT : R/W; bitpos: [11:5]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_STALL_WAIT    0x0000007FU
#define LP_CLKRST_HPCORE0_STALL_WAIT_M  (LP_CLKRST_HPCORE0_STALL_WAIT_V << LP_CLKRST_HPCORE0_STALL_WAIT_S)
#define LP_CLKRST_HPCORE0_STALL_WAIT_V  0x0000007FU
#define LP_CLKRST_HPCORE0_STALL_WAIT_S  5
/** LP_CLKRST_HPCORE0_STALL_EN : R/W; bitpos: [12]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_STALL_EN    (BIT(12))
#define LP_CLKRST_HPCORE0_STALL_EN_M  (LP_CLKRST_HPCORE0_STALL_EN_V << LP_CLKRST_HPCORE0_STALL_EN_S)
#define LP_CLKRST_HPCORE0_STALL_EN_V  0x00000001U
#define LP_CLKRST_HPCORE0_STALL_EN_S  12
/** LP_CLKRST_HPCORE0_SW_RESET : WT; bitpos: [13]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_SW_RESET    (BIT(13))
#define LP_CLKRST_HPCORE0_SW_RESET_M  (LP_CLKRST_HPCORE0_SW_RESET_V << LP_CLKRST_HPCORE0_SW_RESET_S)
#define LP_CLKRST_HPCORE0_SW_RESET_V  0x00000001U
#define LP_CLKRST_HPCORE0_SW_RESET_S  13
/** LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET : R/W; bitpos: [14]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET    (BIT(14))
#define LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET_M  (LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET_V << LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET_S)
#define LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET_V  0x00000001U
#define LP_CLKRST_HPCORE0_OCD_HALT_ON_RESET_S  14
/** LP_CLKRST_HPCORE0_STAT_VECTOR_SEL : R/W; bitpos: [15]; default: 1;
 *  1'b1: boot from HP TCM ROM: 0x4FC00000
 *  1'b0: boot from LP TCM RAM:  0x50108000
 */
#define LP_CLKRST_HPCORE0_STAT_VECTOR_SEL    (BIT(15))
#define LP_CLKRST_HPCORE0_STAT_VECTOR_SEL_M  (LP_CLKRST_HPCORE0_STAT_VECTOR_SEL_V << LP_CLKRST_HPCORE0_STAT_VECTOR_SEL_S)
#define LP_CLKRST_HPCORE0_STAT_VECTOR_SEL_V  0x00000001U
#define LP_CLKRST_HPCORE0_STAT_VECTOR_SEL_S  15
/** LP_CLKRST_HPCORE1_LOCKUP_RESET_EN : R/W; bitpos: [16]; default: 0;
 *  write 1 to enable hpcore1 lockup reset feature, write 0 to disable hpcore1 lockup
 *  reset feature
 */
#define LP_CLKRST_HPCORE1_LOCKUP_RESET_EN    (BIT(16))
#define LP_CLKRST_HPCORE1_LOCKUP_RESET_EN_M  (LP_CLKRST_HPCORE1_LOCKUP_RESET_EN_V << LP_CLKRST_HPCORE1_LOCKUP_RESET_EN_S)
#define LP_CLKRST_HPCORE1_LOCKUP_RESET_EN_V  0x00000001U
#define LP_CLKRST_HPCORE1_LOCKUP_RESET_EN_S  16
/** LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH : R/W; bitpos: [19:17]; default: 1;
 *  need_des
 */
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH    0x00000007U
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH_M  (LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH_V << LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH_S)
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH_V  0x00000007U
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_LENGTH_S  17
/** LP_CLKRST_LP_WDT_HPCORE1_RESET_EN : R/W; bitpos: [20]; default: 0;
 *  write 1 to enable lp_wdt reset hpcore1 feature, write 0 to disable lp_wdt reset
 *  hpcore1 feature
 */
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_EN    (BIT(20))
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_EN_M  (LP_CLKRST_LP_WDT_HPCORE1_RESET_EN_V << LP_CLKRST_LP_WDT_HPCORE1_RESET_EN_S)
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_EN_V  0x00000001U
#define LP_CLKRST_LP_WDT_HPCORE1_RESET_EN_S  20
/** LP_CLKRST_HPCORE1_STALL_WAIT : R/W; bitpos: [27:21]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_STALL_WAIT    0x0000007FU
#define LP_CLKRST_HPCORE1_STALL_WAIT_M  (LP_CLKRST_HPCORE1_STALL_WAIT_V << LP_CLKRST_HPCORE1_STALL_WAIT_S)
#define LP_CLKRST_HPCORE1_STALL_WAIT_V  0x0000007FU
#define LP_CLKRST_HPCORE1_STALL_WAIT_S  21
/** LP_CLKRST_HPCORE1_STALL_EN : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_STALL_EN    (BIT(28))
#define LP_CLKRST_HPCORE1_STALL_EN_M  (LP_CLKRST_HPCORE1_STALL_EN_V << LP_CLKRST_HPCORE1_STALL_EN_S)
#define LP_CLKRST_HPCORE1_STALL_EN_V  0x00000001U
#define LP_CLKRST_HPCORE1_STALL_EN_S  28
/** LP_CLKRST_HPCORE1_SW_RESET : WT; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_SW_RESET    (BIT(29))
#define LP_CLKRST_HPCORE1_SW_RESET_M  (LP_CLKRST_HPCORE1_SW_RESET_V << LP_CLKRST_HPCORE1_SW_RESET_S)
#define LP_CLKRST_HPCORE1_SW_RESET_V  0x00000001U
#define LP_CLKRST_HPCORE1_SW_RESET_S  29
/** LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET    (BIT(30))
#define LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET_M  (LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET_V << LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET_S)
#define LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET_V  0x00000001U
#define LP_CLKRST_HPCORE1_OCD_HALT_ON_RESET_S  30
/** LP_CLKRST_HPCORE1_STAT_VECTOR_SEL : R/W; bitpos: [31]; default: 1;
 *  1'b1: boot from HP TCM ROM: 0x4FC00000
 *  1'b0: boot from LP TCM RAM:  0x50108000
 */
#define LP_CLKRST_HPCORE1_STAT_VECTOR_SEL    (BIT(31))
#define LP_CLKRST_HPCORE1_STAT_VECTOR_SEL_M  (LP_CLKRST_HPCORE1_STAT_VECTOR_SEL_V << LP_CLKRST_HPCORE1_STAT_VECTOR_SEL_S)
#define LP_CLKRST_HPCORE1_STAT_VECTOR_SEL_V  0x00000001U
#define LP_CLKRST_HPCORE1_STAT_VECTOR_SEL_S  31

/** LP_CLKRST_HPCPU_RESET_CTRL1_REG register
 *  need_des
 */
#define LP_CLKRST_HPCPU_RESET_CTRL1_REG (DR_REG_LP_CLKRST_BASE + 0x18)
/** LP_CLKRST_HPCORE0_SW_STALL_CODE : R/W; bitpos: [23:16]; default: 0;
 *  HP core0 software stall when set to 8'h86
 */
#define LP_CLKRST_HPCORE0_SW_STALL_CODE    0x000000FFU
#define LP_CLKRST_HPCORE0_SW_STALL_CODE_M  (LP_CLKRST_HPCORE0_SW_STALL_CODE_V << LP_CLKRST_HPCORE0_SW_STALL_CODE_S)
#define LP_CLKRST_HPCORE0_SW_STALL_CODE_V  0x000000FFU
#define LP_CLKRST_HPCORE0_SW_STALL_CODE_S  16
/** LP_CLKRST_HPCORE1_SW_STALL_CODE : R/W; bitpos: [31:24]; default: 0;
 *  HP core1 software stall when set to 8'h86
 */
#define LP_CLKRST_HPCORE1_SW_STALL_CODE    0x000000FFU
#define LP_CLKRST_HPCORE1_SW_STALL_CODE_M  (LP_CLKRST_HPCORE1_SW_STALL_CODE_V << LP_CLKRST_HPCORE1_SW_STALL_CODE_S)
#define LP_CLKRST_HPCORE1_SW_STALL_CODE_V  0x000000FFU
#define LP_CLKRST_HPCORE1_SW_STALL_CODE_S  24

/** LP_CLKRST_FOSC_CNTL_REG register
 *  need_des
 */
#define LP_CLKRST_FOSC_CNTL_REG (DR_REG_LP_CLKRST_BASE + 0x1c)
/** LP_CLKRST_FOSC_DFREQ : R/W; bitpos: [31:22]; default: 400;
 *  need_des
 */
#define LP_CLKRST_FOSC_DFREQ    0x000003FFU
#define LP_CLKRST_FOSC_DFREQ_M  (LP_CLKRST_FOSC_DFREQ_V << LP_CLKRST_FOSC_DFREQ_S)
#define LP_CLKRST_FOSC_DFREQ_V  0x000003FFU
#define LP_CLKRST_FOSC_DFREQ_S  22

/** LP_CLKRST_RC32K_CNTL_REG register
 *  need_des
 */
#define LP_CLKRST_RC32K_CNTL_REG (DR_REG_LP_CLKRST_BASE + 0x20)
/** LP_CLKRST_RC32K_DFREQ : R/W; bitpos: [31:0]; default: 650;
 *  need_des
 */
#define LP_CLKRST_RC32K_DFREQ    0xFFFFFFFFU
#define LP_CLKRST_RC32K_DFREQ_M  (LP_CLKRST_RC32K_DFREQ_V << LP_CLKRST_RC32K_DFREQ_S)
#define LP_CLKRST_RC32K_DFREQ_V  0xFFFFFFFFU
#define LP_CLKRST_RC32K_DFREQ_S  0

/** LP_CLKRST_SOSC_CNTL_REG register
 *  need_des
 */
#define LP_CLKRST_SOSC_CNTL_REG (DR_REG_LP_CLKRST_BASE + 0x24)
/** LP_CLKRST_SOSC_DFREQ : R/W; bitpos: [31:22]; default: 172;
 *  need_des
 */
#define LP_CLKRST_SOSC_DFREQ    0x000003FFU
#define LP_CLKRST_SOSC_DFREQ_M  (LP_CLKRST_SOSC_DFREQ_V << LP_CLKRST_SOSC_DFREQ_S)
#define LP_CLKRST_SOSC_DFREQ_V  0x000003FFU
#define LP_CLKRST_SOSC_DFREQ_S  22

/** LP_CLKRST_CLK_TO_HP_REG register
 *  need_des
 */
#define LP_CLKRST_CLK_TO_HP_REG (DR_REG_LP_CLKRST_BASE + 0x28)
/** LP_CLKRST_ICG_HP_XTAL32K : R/W; bitpos: [28]; default: 1;
 *  reserved
 */
#define LP_CLKRST_ICG_HP_XTAL32K    (BIT(28))
#define LP_CLKRST_ICG_HP_XTAL32K_M  (LP_CLKRST_ICG_HP_XTAL32K_V << LP_CLKRST_ICG_HP_XTAL32K_S)
#define LP_CLKRST_ICG_HP_XTAL32K_V  0x00000001U
#define LP_CLKRST_ICG_HP_XTAL32K_S  28
/** LP_CLKRST_ICG_HP_SOSC : R/W; bitpos: [29]; default: 1;
 *  reserved
 */
#define LP_CLKRST_ICG_HP_SOSC    (BIT(29))
#define LP_CLKRST_ICG_HP_SOSC_M  (LP_CLKRST_ICG_HP_SOSC_V << LP_CLKRST_ICG_HP_SOSC_S)
#define LP_CLKRST_ICG_HP_SOSC_V  0x00000001U
#define LP_CLKRST_ICG_HP_SOSC_S  29
/** LP_CLKRST_ICG_HP_OSC32K : R/W; bitpos: [30]; default: 1;
 *  reserved
 */
#define LP_CLKRST_ICG_HP_OSC32K    (BIT(30))
#define LP_CLKRST_ICG_HP_OSC32K_M  (LP_CLKRST_ICG_HP_OSC32K_V << LP_CLKRST_ICG_HP_OSC32K_S)
#define LP_CLKRST_ICG_HP_OSC32K_V  0x00000001U
#define LP_CLKRST_ICG_HP_OSC32K_S  30
/** LP_CLKRST_ICG_HP_FOSC : R/W; bitpos: [31]; default: 1;
 *  reserved
 */
#define LP_CLKRST_ICG_HP_FOSC    (BIT(31))
#define LP_CLKRST_ICG_HP_FOSC_M  (LP_CLKRST_ICG_HP_FOSC_V << LP_CLKRST_ICG_HP_FOSC_S)
#define LP_CLKRST_ICG_HP_FOSC_V  0x00000001U
#define LP_CLKRST_ICG_HP_FOSC_S  31

/** LP_CLKRST_LPMEM_FORCE_REG register
 *  need_des
 */
#define LP_CLKRST_LPMEM_FORCE_REG (DR_REG_LP_CLKRST_BASE + 0x2c)
/** LP_CLKRST_LPMEM_CLK_FORCE_ON : R/W; bitpos: [31]; default: 0;
 *  reserved
 */
#define LP_CLKRST_LPMEM_CLK_FORCE_ON    (BIT(31))
#define LP_CLKRST_LPMEM_CLK_FORCE_ON_M  (LP_CLKRST_LPMEM_CLK_FORCE_ON_V << LP_CLKRST_LPMEM_CLK_FORCE_ON_S)
#define LP_CLKRST_LPMEM_CLK_FORCE_ON_V  0x00000001U
#define LP_CLKRST_LPMEM_CLK_FORCE_ON_S  31

/** LP_CLKRST_XTAL32K_REG register
 *  need_des
 */
#define LP_CLKRST_XTAL32K_REG (DR_REG_LP_CLKRST_BASE + 0x30)
/** LP_CLKRST_DRES_XTAL32K : R/W; bitpos: [24:22]; default: 3;
 *  need_des
 */
#define LP_CLKRST_DRES_XTAL32K    0x00000007U
#define LP_CLKRST_DRES_XTAL32K_M  (LP_CLKRST_DRES_XTAL32K_V << LP_CLKRST_DRES_XTAL32K_S)
#define LP_CLKRST_DRES_XTAL32K_V  0x00000007U
#define LP_CLKRST_DRES_XTAL32K_S  22
/** LP_CLKRST_DGM_XTAL32K : R/W; bitpos: [27:25]; default: 3;
 *  need_des
 */
#define LP_CLKRST_DGM_XTAL32K    0x00000007U
#define LP_CLKRST_DGM_XTAL32K_M  (LP_CLKRST_DGM_XTAL32K_V << LP_CLKRST_DGM_XTAL32K_S)
#define LP_CLKRST_DGM_XTAL32K_V  0x00000007U
#define LP_CLKRST_DGM_XTAL32K_S  25
/** LP_CLKRST_DBUF_XTAL32K : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_CLKRST_DBUF_XTAL32K    (BIT(28))
#define LP_CLKRST_DBUF_XTAL32K_M  (LP_CLKRST_DBUF_XTAL32K_V << LP_CLKRST_DBUF_XTAL32K_S)
#define LP_CLKRST_DBUF_XTAL32K_V  0x00000001U
#define LP_CLKRST_DBUF_XTAL32K_S  28
/** LP_CLKRST_DAC_XTAL32K : R/W; bitpos: [31:29]; default: 3;
 *  need_des
 */
#define LP_CLKRST_DAC_XTAL32K    0x00000007U
#define LP_CLKRST_DAC_XTAL32K_M  (LP_CLKRST_DAC_XTAL32K_V << LP_CLKRST_DAC_XTAL32K_S)
#define LP_CLKRST_DAC_XTAL32K_V  0x00000007U
#define LP_CLKRST_DAC_XTAL32K_S  29

/** LP_CLKRST_MUX_HPSYS_RESET_BYPASS_REG register
 *  need_des
 */
#define LP_CLKRST_MUX_HPSYS_RESET_BYPASS_REG (DR_REG_LP_CLKRST_BASE + 0x34)
/** LP_CLKRST_MUX_HPSYS_RESET_BYPASS : R/W; bitpos: [31:0]; default: 4294967295;
 *  reserved
 */
#define LP_CLKRST_MUX_HPSYS_RESET_BYPASS    0xFFFFFFFFU
#define LP_CLKRST_MUX_HPSYS_RESET_BYPASS_M  (LP_CLKRST_MUX_HPSYS_RESET_BYPASS_V << LP_CLKRST_MUX_HPSYS_RESET_BYPASS_S)
#define LP_CLKRST_MUX_HPSYS_RESET_BYPASS_V  0xFFFFFFFFU
#define LP_CLKRST_MUX_HPSYS_RESET_BYPASS_S  0

/** LP_CLKRST_HPSYS_0_RESET_BYPASS_REG register
 *  need_des
 */
#define LP_CLKRST_HPSYS_0_RESET_BYPASS_REG (DR_REG_LP_CLKRST_BASE + 0x38)
/** LP_CLKRST_HPSYS_0_RESET_BYPASS : R/W; bitpos: [31:0]; default: 4294967295;
 *  reserved
 */
#define LP_CLKRST_HPSYS_0_RESET_BYPASS    0xFFFFFFFFU
#define LP_CLKRST_HPSYS_0_RESET_BYPASS_M  (LP_CLKRST_HPSYS_0_RESET_BYPASS_V << LP_CLKRST_HPSYS_0_RESET_BYPASS_S)
#define LP_CLKRST_HPSYS_0_RESET_BYPASS_V  0xFFFFFFFFU
#define LP_CLKRST_HPSYS_0_RESET_BYPASS_S  0

/** LP_CLKRST_HPSYS_APM_RESET_BYPASS_REG register
 *  need_des
 */
#define LP_CLKRST_HPSYS_APM_RESET_BYPASS_REG (DR_REG_LP_CLKRST_BASE + 0x3c)
/** LP_CLKRST_HPSYS_APM_RESET_BYPASS : R/W; bitpos: [31:0]; default: 4294967295;
 *  reserved
 */
#define LP_CLKRST_HPSYS_APM_RESET_BYPASS    0xFFFFFFFFU
#define LP_CLKRST_HPSYS_APM_RESET_BYPASS_M  (LP_CLKRST_HPSYS_APM_RESET_BYPASS_V << LP_CLKRST_HPSYS_APM_RESET_BYPASS_S)
#define LP_CLKRST_HPSYS_APM_RESET_BYPASS_V  0xFFFFFFFFU
#define LP_CLKRST_HPSYS_APM_RESET_BYPASS_S  0

/** LP_CLKRST_HP_CLK_CTRL_REG register
 *  HP Clock Control Register.
 */
#define LP_CLKRST_HP_CLK_CTRL_REG (DR_REG_LP_CLKRST_BASE + 0x40)
/** LP_CLKRST_HP_ROOT_CLK_SRC_SEL : R/W; bitpos: [1:0]; default: 0;
 *  HP SoC Root Clock Source Select. 2'd0: xtal_40m, 2'd1: cpll_400m, 2'd2: fosc_20m.
 */
#define LP_CLKRST_HP_ROOT_CLK_SRC_SEL    0x00000003U
#define LP_CLKRST_HP_ROOT_CLK_SRC_SEL_M  (LP_CLKRST_HP_ROOT_CLK_SRC_SEL_V << LP_CLKRST_HP_ROOT_CLK_SRC_SEL_S)
#define LP_CLKRST_HP_ROOT_CLK_SRC_SEL_V  0x00000003U
#define LP_CLKRST_HP_ROOT_CLK_SRC_SEL_S  0
/** LP_CLKRST_HP_ROOT_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  HP SoC Root Clock Enable.
 */
#define LP_CLKRST_HP_ROOT_CLK_EN    (BIT(2))
#define LP_CLKRST_HP_ROOT_CLK_EN_M  (LP_CLKRST_HP_ROOT_CLK_EN_V << LP_CLKRST_HP_ROOT_CLK_EN_S)
#define LP_CLKRST_HP_ROOT_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_ROOT_CLK_EN_S  2
/** LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  PARLIO TX Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN    (BIT(3))
#define LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN_M  (LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN_V << LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN_S)
#define LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_PARLIO_TX_CLK_EN_S  3
/** LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN : R/W; bitpos: [4]; default: 1;
 *  PARLIO RX Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN    (BIT(4))
#define LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN_M  (LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN_V << LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN_S)
#define LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_PARLIO_RX_CLK_EN_S  4
/** LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN : R/W; bitpos: [5]; default: 1;
 *  UART4 SLP Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN    (BIT(5))
#define LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN_M  (LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN_V << LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN_S)
#define LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_UART4_SLP_CLK_EN_S  5
/** LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN : R/W; bitpos: [6]; default: 1;
 *  UART3 SLP Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN    (BIT(6))
#define LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN_M  (LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN_V << LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN_S)
#define LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_UART3_SLP_CLK_EN_S  6
/** LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN : R/W; bitpos: [7]; default: 1;
 *  UART2 SLP Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN    (BIT(7))
#define LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN_M  (LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN_V << LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN_S)
#define LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_UART2_SLP_CLK_EN_S  7
/** LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN : R/W; bitpos: [8]; default: 1;
 *  UART1 SLP Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN    (BIT(8))
#define LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN_M  (LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN_V << LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN_S)
#define LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_UART1_SLP_CLK_EN_S  8
/** LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN : R/W; bitpos: [9]; default: 1;
 *  UART0 SLP Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN    (BIT(9))
#define LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN_M  (LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN_V << LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN_S)
#define LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_UART0_SLP_CLK_EN_S  9
/** LP_CLKRST_HP_PAD_I2S2_MCLK_EN : R/W; bitpos: [10]; default: 1;
 *  I2S2 MCLK Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_I2S2_MCLK_EN    (BIT(10))
#define LP_CLKRST_HP_PAD_I2S2_MCLK_EN_M  (LP_CLKRST_HP_PAD_I2S2_MCLK_EN_V << LP_CLKRST_HP_PAD_I2S2_MCLK_EN_S)
#define LP_CLKRST_HP_PAD_I2S2_MCLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_I2S2_MCLK_EN_S  10
/** LP_CLKRST_HP_PAD_I2S1_MCLK_EN : R/W; bitpos: [11]; default: 1;
 *  I2S1 MCLK Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_I2S1_MCLK_EN    (BIT(11))
#define LP_CLKRST_HP_PAD_I2S1_MCLK_EN_M  (LP_CLKRST_HP_PAD_I2S1_MCLK_EN_V << LP_CLKRST_HP_PAD_I2S1_MCLK_EN_S)
#define LP_CLKRST_HP_PAD_I2S1_MCLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_I2S1_MCLK_EN_S  11
/** LP_CLKRST_HP_PAD_I2S0_MCLK_EN : R/W; bitpos: [12]; default: 1;
 *  I2S0 MCLK Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_I2S0_MCLK_EN    (BIT(12))
#define LP_CLKRST_HP_PAD_I2S0_MCLK_EN_M  (LP_CLKRST_HP_PAD_I2S0_MCLK_EN_V << LP_CLKRST_HP_PAD_I2S0_MCLK_EN_S)
#define LP_CLKRST_HP_PAD_I2S0_MCLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_I2S0_MCLK_EN_S  12
/** LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN : R/W; bitpos: [13]; default: 1;
 *  EMAC RX Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN    (BIT(13))
#define LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN_M  (LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN_V << LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN_S)
#define LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_EMAC_TX_CLK_EN_S  13
/** LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN : R/W; bitpos: [14]; default: 1;
 *  EMAC TX Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN    (BIT(14))
#define LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN_M  (LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN_V << LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN_S)
#define LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_EMAC_RX_CLK_EN_S  14
/** LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN : R/W; bitpos: [15]; default: 1;
 *  EMAC TXRX Clock From Pad Enable.
 */
#define LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN    (BIT(15))
#define LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN_M  (LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN_V << LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN_S)
#define LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PAD_EMAC_TXRX_CLK_EN_S  15
/** LP_CLKRST_HP_XTAL_32K_CLK_EN : R/W; bitpos: [16]; default: 1;
 *  XTAL 32K Clock Enable.
 */
#define LP_CLKRST_HP_XTAL_32K_CLK_EN    (BIT(16))
#define LP_CLKRST_HP_XTAL_32K_CLK_EN_M  (LP_CLKRST_HP_XTAL_32K_CLK_EN_V << LP_CLKRST_HP_XTAL_32K_CLK_EN_S)
#define LP_CLKRST_HP_XTAL_32K_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_XTAL_32K_CLK_EN_S  16
/** LP_CLKRST_HP_RC_32K_CLK_EN : R/W; bitpos: [17]; default: 1;
 *  RC 32K Clock Enable.
 */
#define LP_CLKRST_HP_RC_32K_CLK_EN    (BIT(17))
#define LP_CLKRST_HP_RC_32K_CLK_EN_M  (LP_CLKRST_HP_RC_32K_CLK_EN_V << LP_CLKRST_HP_RC_32K_CLK_EN_S)
#define LP_CLKRST_HP_RC_32K_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_RC_32K_CLK_EN_S  17
/** LP_CLKRST_HP_SOSC_150K_CLK_EN : R/W; bitpos: [18]; default: 1;
 *  SOSC 150K Clock Enable.
 */
#define LP_CLKRST_HP_SOSC_150K_CLK_EN    (BIT(18))
#define LP_CLKRST_HP_SOSC_150K_CLK_EN_M  (LP_CLKRST_HP_SOSC_150K_CLK_EN_V << LP_CLKRST_HP_SOSC_150K_CLK_EN_S)
#define LP_CLKRST_HP_SOSC_150K_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_SOSC_150K_CLK_EN_S  18
/** LP_CLKRST_HP_PLL_8M_CLK_EN : R/W; bitpos: [19]; default: 1;
 *  PLL 8M Clock Enable.
 */
#define LP_CLKRST_HP_PLL_8M_CLK_EN    (BIT(19))
#define LP_CLKRST_HP_PLL_8M_CLK_EN_M  (LP_CLKRST_HP_PLL_8M_CLK_EN_V << LP_CLKRST_HP_PLL_8M_CLK_EN_S)
#define LP_CLKRST_HP_PLL_8M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_PLL_8M_CLK_EN_S  19
/** LP_CLKRST_HP_AUDIO_PLL_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  AUDIO PLL Clock Enable.
 */
#define LP_CLKRST_HP_AUDIO_PLL_CLK_EN    (BIT(20))
#define LP_CLKRST_HP_AUDIO_PLL_CLK_EN_M  (LP_CLKRST_HP_AUDIO_PLL_CLK_EN_V << LP_CLKRST_HP_AUDIO_PLL_CLK_EN_S)
#define LP_CLKRST_HP_AUDIO_PLL_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_AUDIO_PLL_CLK_EN_S  20
/** LP_CLKRST_HP_SDIO_PLL2_CLK_EN : R/W; bitpos: [21]; default: 1;
 *  SDIO PLL2 Clock Enable.
 */
#define LP_CLKRST_HP_SDIO_PLL2_CLK_EN    (BIT(21))
#define LP_CLKRST_HP_SDIO_PLL2_CLK_EN_M  (LP_CLKRST_HP_SDIO_PLL2_CLK_EN_V << LP_CLKRST_HP_SDIO_PLL2_CLK_EN_S)
#define LP_CLKRST_HP_SDIO_PLL2_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_SDIO_PLL2_CLK_EN_S  21
/** LP_CLKRST_HP_SDIO_PLL1_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  SDIO PLL1 Clock Enable.
 */
#define LP_CLKRST_HP_SDIO_PLL1_CLK_EN    (BIT(22))
#define LP_CLKRST_HP_SDIO_PLL1_CLK_EN_M  (LP_CLKRST_HP_SDIO_PLL1_CLK_EN_V << LP_CLKRST_HP_SDIO_PLL1_CLK_EN_S)
#define LP_CLKRST_HP_SDIO_PLL1_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_SDIO_PLL1_CLK_EN_S  22
/** LP_CLKRST_HP_SDIO_PLL0_CLK_EN : R/W; bitpos: [23]; default: 1;
 *  SDIO PLL0 Clock Enable.
 */
#define LP_CLKRST_HP_SDIO_PLL0_CLK_EN    (BIT(23))
#define LP_CLKRST_HP_SDIO_PLL0_CLK_EN_M  (LP_CLKRST_HP_SDIO_PLL0_CLK_EN_V << LP_CLKRST_HP_SDIO_PLL0_CLK_EN_S)
#define LP_CLKRST_HP_SDIO_PLL0_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_SDIO_PLL0_CLK_EN_S  23
/** LP_CLKRST_HP_FOSC_20M_CLK_EN : R/W; bitpos: [24]; default: 1;
 *  FOSC 20M Clock Enable.
 */
#define LP_CLKRST_HP_FOSC_20M_CLK_EN    (BIT(24))
#define LP_CLKRST_HP_FOSC_20M_CLK_EN_M  (LP_CLKRST_HP_FOSC_20M_CLK_EN_V << LP_CLKRST_HP_FOSC_20M_CLK_EN_S)
#define LP_CLKRST_HP_FOSC_20M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_FOSC_20M_CLK_EN_S  24
/** LP_CLKRST_HP_XTAL_40M_CLK_EN : R/W; bitpos: [25]; default: 1;
 *  XTAL 40M Clock Enable.
 */
#define LP_CLKRST_HP_XTAL_40M_CLK_EN    (BIT(25))
#define LP_CLKRST_HP_XTAL_40M_CLK_EN_M  (LP_CLKRST_HP_XTAL_40M_CLK_EN_V << LP_CLKRST_HP_XTAL_40M_CLK_EN_S)
#define LP_CLKRST_HP_XTAL_40M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_XTAL_40M_CLK_EN_S  25
/** LP_CLKRST_HP_CPLL_400M_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  CPLL 400M Clock Enable.
 */
#define LP_CLKRST_HP_CPLL_400M_CLK_EN    (BIT(26))
#define LP_CLKRST_HP_CPLL_400M_CLK_EN_M  (LP_CLKRST_HP_CPLL_400M_CLK_EN_V << LP_CLKRST_HP_CPLL_400M_CLK_EN_S)
#define LP_CLKRST_HP_CPLL_400M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_CPLL_400M_CLK_EN_S  26
/** LP_CLKRST_HP_SPLL_480M_CLK_EN : R/W; bitpos: [27]; default: 1;
 *  SPLL 480M Clock Enable.
 */
#define LP_CLKRST_HP_SPLL_480M_CLK_EN    (BIT(27))
#define LP_CLKRST_HP_SPLL_480M_CLK_EN_M  (LP_CLKRST_HP_SPLL_480M_CLK_EN_V << LP_CLKRST_HP_SPLL_480M_CLK_EN_S)
#define LP_CLKRST_HP_SPLL_480M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_SPLL_480M_CLK_EN_S  27
/** LP_CLKRST_HP_MPLL_500M_CLK_EN : R/W; bitpos: [28]; default: 1;
 *  MPLL 500M Clock Enable.
 */
#define LP_CLKRST_HP_MPLL_500M_CLK_EN    (BIT(28))
#define LP_CLKRST_HP_MPLL_500M_CLK_EN_M  (LP_CLKRST_HP_MPLL_500M_CLK_EN_V << LP_CLKRST_HP_MPLL_500M_CLK_EN_S)
#define LP_CLKRST_HP_MPLL_500M_CLK_EN_V  0x00000001U
#define LP_CLKRST_HP_MPLL_500M_CLK_EN_S  28

/** LP_CLKRST_HP_USB_CLKRST_CTRL0_REG register
 *  HP USB Clock Reset Control Register.
 */
#define LP_CLKRST_HP_USB_CLKRST_CTRL0_REG (DR_REG_LP_CLKRST_BASE + 0x44)
/** LP_CLKRST_USB_OTG20_SLEEP_MODE : R/W; bitpos: [0]; default: 0;
 *  unused.
 */
#define LP_CLKRST_USB_OTG20_SLEEP_MODE    (BIT(0))
#define LP_CLKRST_USB_OTG20_SLEEP_MODE_M  (LP_CLKRST_USB_OTG20_SLEEP_MODE_V << LP_CLKRST_USB_OTG20_SLEEP_MODE_S)
#define LP_CLKRST_USB_OTG20_SLEEP_MODE_V  0x00000001U
#define LP_CLKRST_USB_OTG20_SLEEP_MODE_S  0
/** LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN : R/W; bitpos: [1]; default: 1;
 *  unused.
 */
#define LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN    (BIT(1))
#define LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN_M  (LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN_V << LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN_S)
#define LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_OTG20_BK_SYS_CLK_EN_S  1
/** LP_CLKRST_USB_OTG11_SLEEP_MODE : R/W; bitpos: [2]; default: 0;
 *  unused.
 */
#define LP_CLKRST_USB_OTG11_SLEEP_MODE    (BIT(2))
#define LP_CLKRST_USB_OTG11_SLEEP_MODE_M  (LP_CLKRST_USB_OTG11_SLEEP_MODE_V << LP_CLKRST_USB_OTG11_SLEEP_MODE_S)
#define LP_CLKRST_USB_OTG11_SLEEP_MODE_V  0x00000001U
#define LP_CLKRST_USB_OTG11_SLEEP_MODE_S  2
/** LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  unused.
 */
#define LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN    (BIT(3))
#define LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN_M  (LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN_V << LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN_S)
#define LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_OTG11_BK_SYS_CLK_EN_S  3
/** LP_CLKRST_USB_OTG11_48M_CLK_EN : R/W; bitpos: [4]; default: 1;
 *  usb otg11 fs phy clock enable.
 */
#define LP_CLKRST_USB_OTG11_48M_CLK_EN    (BIT(4))
#define LP_CLKRST_USB_OTG11_48M_CLK_EN_M  (LP_CLKRST_USB_OTG11_48M_CLK_EN_V << LP_CLKRST_USB_OTG11_48M_CLK_EN_S)
#define LP_CLKRST_USB_OTG11_48M_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_OTG11_48M_CLK_EN_S  4
/** LP_CLKRST_USB_DEVICE_48M_CLK_EN : R/W; bitpos: [5]; default: 1;
 *  usb device fs phy clock enable.
 */
#define LP_CLKRST_USB_DEVICE_48M_CLK_EN    (BIT(5))
#define LP_CLKRST_USB_DEVICE_48M_CLK_EN_M  (LP_CLKRST_USB_DEVICE_48M_CLK_EN_V << LP_CLKRST_USB_DEVICE_48M_CLK_EN_S)
#define LP_CLKRST_USB_DEVICE_48M_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_DEVICE_48M_CLK_EN_S  5
/** LP_CLKRST_USB_48M_DIV_NUM : R/W; bitpos: [13:6]; default: 9;
 *  usb 480m to 25m divide number.
 */
#define LP_CLKRST_USB_48M_DIV_NUM    0x000000FFU
#define LP_CLKRST_USB_48M_DIV_NUM_M  (LP_CLKRST_USB_48M_DIV_NUM_V << LP_CLKRST_USB_48M_DIV_NUM_S)
#define LP_CLKRST_USB_48M_DIV_NUM_V  0x000000FFU
#define LP_CLKRST_USB_48M_DIV_NUM_S  6
/** LP_CLKRST_USB_25M_DIV_NUM : R/W; bitpos: [21:14]; default: 19;
 *  usb 500m to 25m divide number.
 */
#define LP_CLKRST_USB_25M_DIV_NUM    0x000000FFU
#define LP_CLKRST_USB_25M_DIV_NUM_M  (LP_CLKRST_USB_25M_DIV_NUM_V << LP_CLKRST_USB_25M_DIV_NUM_S)
#define LP_CLKRST_USB_25M_DIV_NUM_V  0x000000FFU
#define LP_CLKRST_USB_25M_DIV_NUM_S  14
/** LP_CLKRST_USB_12M_DIV_NUM : R/W; bitpos: [29:22]; default: 39;
 *  usb 480m to 12m divide number.
 */
#define LP_CLKRST_USB_12M_DIV_NUM    0x000000FFU
#define LP_CLKRST_USB_12M_DIV_NUM_M  (LP_CLKRST_USB_12M_DIV_NUM_V << LP_CLKRST_USB_12M_DIV_NUM_S)
#define LP_CLKRST_USB_12M_DIV_NUM_V  0x000000FFU
#define LP_CLKRST_USB_12M_DIV_NUM_S  22

/** LP_CLKRST_HP_USB_CLKRST_CTRL1_REG register
 *  HP USB Clock Reset Control Register.
 */
#define LP_CLKRST_HP_USB_CLKRST_CTRL1_REG (DR_REG_LP_CLKRST_BASE + 0x48)
/** LP_CLKRST_RST_EN_USB_OTG20_ADP : R/W; bitpos: [0]; default: 0;
 *  usb otg20 adp reset en
 */
#define LP_CLKRST_RST_EN_USB_OTG20_ADP    (BIT(0))
#define LP_CLKRST_RST_EN_USB_OTG20_ADP_M  (LP_CLKRST_RST_EN_USB_OTG20_ADP_V << LP_CLKRST_RST_EN_USB_OTG20_ADP_S)
#define LP_CLKRST_RST_EN_USB_OTG20_ADP_V  0x00000001U
#define LP_CLKRST_RST_EN_USB_OTG20_ADP_S  0
/** LP_CLKRST_RST_EN_USB_OTG20_PHY : R/W; bitpos: [1]; default: 0;
 *  usb otg20 phy reset en
 */
#define LP_CLKRST_RST_EN_USB_OTG20_PHY    (BIT(1))
#define LP_CLKRST_RST_EN_USB_OTG20_PHY_M  (LP_CLKRST_RST_EN_USB_OTG20_PHY_V << LP_CLKRST_RST_EN_USB_OTG20_PHY_S)
#define LP_CLKRST_RST_EN_USB_OTG20_PHY_V  0x00000001U
#define LP_CLKRST_RST_EN_USB_OTG20_PHY_S  1
/** LP_CLKRST_RST_EN_USB_OTG20 : R/W; bitpos: [2]; default: 0;
 *  usb otg20 reset en
 */
#define LP_CLKRST_RST_EN_USB_OTG20    (BIT(2))
#define LP_CLKRST_RST_EN_USB_OTG20_M  (LP_CLKRST_RST_EN_USB_OTG20_V << LP_CLKRST_RST_EN_USB_OTG20_S)
#define LP_CLKRST_RST_EN_USB_OTG20_V  0x00000001U
#define LP_CLKRST_RST_EN_USB_OTG20_S  2
/** LP_CLKRST_RST_EN_USB_OTG11 : R/W; bitpos: [3]; default: 0;
 *  usb org11 reset en
 */
#define LP_CLKRST_RST_EN_USB_OTG11    (BIT(3))
#define LP_CLKRST_RST_EN_USB_OTG11_M  (LP_CLKRST_RST_EN_USB_OTG11_V << LP_CLKRST_RST_EN_USB_OTG11_S)
#define LP_CLKRST_RST_EN_USB_OTG11_V  0x00000001U
#define LP_CLKRST_RST_EN_USB_OTG11_S  3
/** LP_CLKRST_RST_EN_USB_DEVICE : R/W; bitpos: [4]; default: 0;
 *  usb device reset en
 */
#define LP_CLKRST_RST_EN_USB_DEVICE    (BIT(4))
#define LP_CLKRST_RST_EN_USB_DEVICE_M  (LP_CLKRST_RST_EN_USB_DEVICE_V << LP_CLKRST_RST_EN_USB_DEVICE_S)
#define LP_CLKRST_RST_EN_USB_DEVICE_V  0x00000001U
#define LP_CLKRST_RST_EN_USB_DEVICE_S  4
/** LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL : R/W; bitpos: [29:28]; default: 0;
 *  usb otg20 hs phy src sel. 2'd0: 12m, 2'd1: 25m, 2'd2: pad_hsphy_refclk.
 */
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL    0x00000003U
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL_M  (LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL_V << LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL_S)
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL_V  0x00000003U
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_SRC_SEL_S  28
/** LP_CLKRST_USB_OTG20_PHYREF_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  usb otg20 hs phy refclk enable.
 */
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_EN    (BIT(30))
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_EN_M  (LP_CLKRST_USB_OTG20_PHYREF_CLK_EN_V << LP_CLKRST_USB_OTG20_PHYREF_CLK_EN_S)
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_OTG20_PHYREF_CLK_EN_S  30
/** LP_CLKRST_USB_OTG20_ULPI_CLK_EN : R/W; bitpos: [31]; default: 1;
 *  usb otg20 ulpi clock enable.
 */
#define LP_CLKRST_USB_OTG20_ULPI_CLK_EN    (BIT(31))
#define LP_CLKRST_USB_OTG20_ULPI_CLK_EN_M  (LP_CLKRST_USB_OTG20_ULPI_CLK_EN_V << LP_CLKRST_USB_OTG20_ULPI_CLK_EN_S)
#define LP_CLKRST_USB_OTG20_ULPI_CLK_EN_V  0x00000001U
#define LP_CLKRST_USB_OTG20_ULPI_CLK_EN_S  31

/** LP_CLKRST_HP_SDMMC_EMAC_RST_CTRL_REG register
 *  need_des
 */
#define LP_CLKRST_HP_SDMMC_EMAC_RST_CTRL_REG (DR_REG_LP_CLKRST_BASE + 0x4c)
/** LP_CLKRST_RST_EN_SDMMC : R/W; bitpos: [28]; default: 0;
 *  hp sdmmc reset en
 */
#define LP_CLKRST_RST_EN_SDMMC    (BIT(28))
#define LP_CLKRST_RST_EN_SDMMC_M  (LP_CLKRST_RST_EN_SDMMC_V << LP_CLKRST_RST_EN_SDMMC_S)
#define LP_CLKRST_RST_EN_SDMMC_V  0x00000001U
#define LP_CLKRST_RST_EN_SDMMC_S  28
/** LP_CLKRST_FORCE_NORST_SDMMC : R/W; bitpos: [29]; default: 0;
 *  hp sdmmc force norst
 */
#define LP_CLKRST_FORCE_NORST_SDMMC    (BIT(29))
#define LP_CLKRST_FORCE_NORST_SDMMC_M  (LP_CLKRST_FORCE_NORST_SDMMC_V << LP_CLKRST_FORCE_NORST_SDMMC_S)
#define LP_CLKRST_FORCE_NORST_SDMMC_V  0x00000001U
#define LP_CLKRST_FORCE_NORST_SDMMC_S  29
/** LP_CLKRST_RST_EN_EMAC : R/W; bitpos: [30]; default: 0;
 *  hp emac reset en
 */
#define LP_CLKRST_RST_EN_EMAC    (BIT(30))
#define LP_CLKRST_RST_EN_EMAC_M  (LP_CLKRST_RST_EN_EMAC_V << LP_CLKRST_RST_EN_EMAC_S)
#define LP_CLKRST_RST_EN_EMAC_V  0x00000001U
#define LP_CLKRST_RST_EN_EMAC_S  30
/** LP_CLKRST_FORCE_NORST_EMAC : R/W; bitpos: [31]; default: 0;
 *  hp emac force norst
 */
#define LP_CLKRST_FORCE_NORST_EMAC    (BIT(31))
#define LP_CLKRST_FORCE_NORST_EMAC_M  (LP_CLKRST_FORCE_NORST_EMAC_V << LP_CLKRST_FORCE_NORST_EMAC_S)
#define LP_CLKRST_FORCE_NORST_EMAC_V  0x00000001U
#define LP_CLKRST_FORCE_NORST_EMAC_S  31

/** LP_CLKRST_DATE_REG register
 *  need_des
 */
#define LP_CLKRST_DATE_REG (DR_REG_LP_CLKRST_BASE + 0x3fc)
/** LP_CLKRST_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_CLKRST_CLK_EN    (BIT(31))
#define LP_CLKRST_CLK_EN_M  (LP_CLKRST_CLK_EN_V << LP_CLKRST_CLK_EN_S)
#define LP_CLKRST_CLK_EN_V  0x00000001U
#define LP_CLKRST_CLK_EN_S  31

#ifdef __cplusplus
}
#endif
