/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <stdint.h>

namespace chip {
namespace app {
namespace Clusters {

namespace detail {
// Enums shared across multiple clusters.

// Enum for ChangeIndicationEnum
enum class ChangeIndicationEnum : uint8_t
{
    kOk       = 0x00,
    kWarning  = 0x01,
    kCritical = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for DegradationDirectionEnum
enum class DegradationDirectionEnum : uint8_t
{
    kUp   = 0x00,
    kDown = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for LevelValueEnum
enum class LevelValueEnum : uint8_t
{
    kUnknown  = 0x00,
    kLow      = 0x01,
    kMedium   = 0x02,
    kHigh     = 0x03,
    kCritical = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for MeasurementMediumEnum
enum class MeasurementMediumEnum : uint8_t
{
    kAir   = 0x00,
    kWater = 0x01,
    kSoil  = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for MeasurementTypeEnum
enum class MeasurementTypeEnum : uint16_t
{
    kUnspecified      = 0x00,
    kVoltage          = 0x01,
    kActiveCurrent    = 0x02,
    kReactiveCurrent  = 0x03,
    kApparentCurrent  = 0x04,
    kActivePower      = 0x05,
    kReactivePower    = 0x06,
    kApparentPower    = 0x07,
    kRMSVoltage       = 0x08,
    kRMSCurrent       = 0x09,
    kRMSPower         = 0x0A,
    kFrequency        = 0x0B,
    kPowerFactor      = 0x0C,
    kNeutralCurrent   = 0x0D,
    kElectricalEnergy = 0x0E,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 15,
};

// Enum for MeasurementUnitEnum
enum class MeasurementUnitEnum : uint8_t
{
    kPpm  = 0x00,
    kPpb  = 0x01,
    kPpt  = 0x02,
    kMgm3 = 0x03,
    kUgm3 = 0x04,
    kNgm3 = 0x05,
    kPm3  = 0x06,
    kBqm3 = 0x07,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 8,
};

// Enum for ProductIdentifierTypeEnum
enum class ProductIdentifierTypeEnum : uint8_t
{
    kUpc    = 0x00,
    kGtin8  = 0x01,
    kEan    = 0x02,
    kGtin14 = 0x03,
    kOem    = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for StreamTypeEnum
enum class StreamTypeEnum : uint8_t
{
    kInternal  = 0x00,
    kRecording = 0x01,
    kAnalysis  = 0x02,
    kLiveView  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for WebRTCEndReasonEnum
enum class WebRTCEndReasonEnum : uint8_t
{
    kIceFailed         = 0x00,
    kIceTimeout        = 0x01,
    kUserHangup        = 0x02,
    kUserBusy          = 0x03,
    kReplaced          = 0x04,
    kNoUserMedia       = 0x05,
    kInviteTimeout     = 0x06,
    kAnsweredElsewhere = 0x07,
    kOutOfResources    = 0x08,
    kMediaTimeout      = 0x09,
    kLowPower          = 0x0A,
    kUnknownReason     = 0x0B,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 12,
};

// Bitmaps shared across multiple clusters.

// Bitmap for WebRTCMetadataOptions
enum class WebRTCMetadataOptions : uint8_t
{
    kDataTLV = 0x1,
};

} // namespace detail

namespace Globals {
// Global enums.

// Enum for AreaTypeTag
enum class AreaTypeTag : uint8_t
{
    kAisle           = 0x00,
    kAttic           = 0x01,
    kBackDoor        = 0x02,
    kBackYard        = 0x03,
    kBalcony         = 0x04,
    kBallroom        = 0x05,
    kBathroom        = 0x06,
    kBedroom         = 0x07,
    kBorder          = 0x08,
    kBoxroom         = 0x09,
    kBreakfastRoom   = 0x0A,
    kCarport         = 0x0B,
    kCellar          = 0x0C,
    kCloakroom       = 0x0D,
    kCloset          = 0x0E,
    kConservatory    = 0x0F,
    kCorridor        = 0x10,
    kCraftRoom       = 0x11,
    kCupboard        = 0x12,
    kDeck            = 0x13,
    kDen             = 0x14,
    kDining          = 0x15,
    kDrawingRoom     = 0x16,
    kDressingRoom    = 0x17,
    kDriveway        = 0x18,
    kElevator        = 0x19,
    kEnsuite         = 0x1A,
    kEntrance        = 0x1B,
    kEntryway        = 0x1C,
    kFamilyRoom      = 0x1D,
    kFoyer           = 0x1E,
    kFrontDoor       = 0x1F,
    kFrontYard       = 0x20,
    kGameRoom        = 0x21,
    kGarage          = 0x22,
    kGarageDoor      = 0x23,
    kGarden          = 0x24,
    kGardenDoor      = 0x25,
    kGuestBathroom   = 0x26,
    kGuestBedroom    = 0x27,
    kGuestRestroom   = 0x28,
    kGuestRoom       = 0x29,
    kGym             = 0x2A,
    kHallway         = 0x2B,
    kHearthRoom      = 0x2C,
    kKidsRoom        = 0x2D,
    kKidsBedroom     = 0x2E,
    kKitchen         = 0x2F,
    kLarder          = 0x30,
    kLaundryRoom     = 0x31,
    kLawn            = 0x32,
    kLibrary         = 0x33,
    kLivingRoom      = 0x34,
    kLounge          = 0x35,
    kMediaTvRoom     = 0x36,
    kMudRoom         = 0x37,
    kMusicRoom       = 0x38,
    kNursery         = 0x39,
    kOffice          = 0x3A,
    kOutdoorKitchen  = 0x3B,
    kOutside         = 0x3C,
    kPantry          = 0x3D,
    kParkingLot      = 0x3E,
    kParlor          = 0x3F,
    kPatio           = 0x40,
    kPlayRoom        = 0x41,
    kPoolRoom        = 0x42,
    kPorch           = 0x43,
    kPrimaryBathroom = 0x44,
    kPrimaryBedroom  = 0x45,
    kRamp            = 0x46,
    kReceptionRoom   = 0x47,
    kRecreationRoom  = 0x48,
    kRestroom        = 0x49,
    kRoof            = 0x4A,
    kSauna           = 0x4B,
    kScullery        = 0x4C,
    kSewingRoom      = 0x4D,
    kShed            = 0x4E,
    kSideDoor        = 0x4F,
    kSideYard        = 0x50,
    kSittingRoom     = 0x51,
    kSnug            = 0x52,
    kSpa             = 0x53,
    kStaircase       = 0x54,
    kSteamRoom       = 0x55,
    kStorageRoom     = 0x56,
    kStudio          = 0x57,
    kStudy           = 0x58,
    kSunRoom         = 0x59,
    kSwimmingPool    = 0x5A,
    kTerrace         = 0x5B,
    kUtilityRoom     = 0x5C,
    kWard            = 0x5D,
    kWorkshop        = 0x5E,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 95,
};

// Enum for AtomicRequestTypeEnum
enum class AtomicRequestTypeEnum : uint8_t
{
    kBeginWrite    = 0x00,
    kCommitWrite   = 0x01,
    kRollbackWrite = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for FloorSurfaceTag
enum class FloorSurfaceTag : uint8_t
{
    kCarpet           = 0x00,
    kCeramic          = 0x01,
    kConcrete         = 0x02,
    kCork             = 0x03,
    kDeepCarpet       = 0x04,
    kDirt             = 0x05,
    kEngineeredWood   = 0x06,
    kGlass            = 0x07,
    kGrass            = 0x08,
    kHardwood         = 0x09,
    kLaminate         = 0x0A,
    kLinoleum         = 0x0B,
    kMat              = 0x0C,
    kMetal            = 0x0D,
    kPlastic          = 0x0E,
    kPolishedConcrete = 0x0F,
    kRubber           = 0x10,
    kRug              = 0x11,
    kSand             = 0x12,
    kStone            = 0x13,
    kTatami           = 0x14,
    kTerrazzo         = 0x15,
    kTile             = 0x16,
    kVinyl            = 0x17,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 24,
};

// Enum for LandmarkTag
enum class LandmarkTag : uint8_t
{
    kAirConditioner = 0x00,
    kAirPurifier    = 0x01,
    kBackDoor       = 0x02,
    kBarStool       = 0x03,
    kBathMat        = 0x04,
    kBathtub        = 0x05,
    kBed            = 0x06,
    kBookshelf      = 0x07,
    kChair          = 0x08,
    kChristmasTree  = 0x09,
    kCoatRack       = 0x0A,
    kCoffeeTable    = 0x0B,
    kCookingRange   = 0x0C,
    kCouch          = 0x0D,
    kCountertop     = 0x0E,
    kCradle         = 0x0F,
    kCrib           = 0x10,
    kDesk           = 0x11,
    kDiningTable    = 0x12,
    kDishwasher     = 0x13,
    kDoor           = 0x14,
    kDresser        = 0x15,
    kLaundryDryer   = 0x16,
    kFan            = 0x17,
    kFireplace      = 0x18,
    kFreezer        = 0x19,
    kFrontDoor      = 0x1A,
    kHighChair      = 0x1B,
    kKitchenIsland  = 0x1C,
    kLamp           = 0x1D,
    kLitterBox      = 0x1E,
    kMirror         = 0x1F,
    kNightstand     = 0x20,
    kOven           = 0x21,
    kPetBed         = 0x22,
    kPetBowl        = 0x23,
    kPetCrate       = 0x24,
    kRefrigerator   = 0x25,
    kScratchingPost = 0x26,
    kShoeRack       = 0x27,
    kShower         = 0x28,
    kSideDoor       = 0x29,
    kSink           = 0x2A,
    kSofa           = 0x2B,
    kStove          = 0x2C,
    kTable          = 0x2D,
    kToilet         = 0x2E,
    kTrashCan       = 0x2F,
    kLaundryWasher  = 0x30,
    kWindow         = 0x31,
    kWineCooler     = 0x32,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 51,
};

// Enum for PositionTag
enum class PositionTag : uint8_t
{
    kLeft   = 0x00,
    kRight  = 0x01,
    kTop    = 0x02,
    kBottom = 0x03,
    kMiddle = 0x04,
    kRow    = 0x05,
    kColumn = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for RelativePositionTag
enum class RelativePositionTag : uint8_t
{
    kUnder   = 0x00,
    kNextTo  = 0x01,
    kAround  = 0x02,
    kOn      = 0x03,
    kAbove   = 0x04,
    kFrontOf = 0x05,
    kBehind  = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for TestGlobalEnum
enum class TestGlobalEnum : uint8_t
{
    kSomeValue      = 0x00,
    kSomeOtherValue = 0x01,
    kFinalValue     = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for ThreeLevelAutoEnum
enum class ThreeLevelAutoEnum : uint8_t
{
    kLow       = 0x00,
    kMedium    = 0x01,
    kHigh      = 0x02,
    kAutomatic = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Global bitmaps.

// Bitmap for TestGlobalBitmap
enum class TestGlobalBitmap : uint32_t
{
    kFirstBit  = 0x1,
    kSecondBit = 0x2,
};

} // namespace Globals

namespace Identify {

// Enum for EffectIdentifierEnum
enum class EffectIdentifierEnum : uint8_t
{
    kBlink         = 0x00,
    kBreathe       = 0x01,
    kOkay          = 0x02,
    kChannelChange = 0x0B,
    kFinishEffect  = 0xFE,
    kStopEffect    = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for EffectVariantEnum
enum class EffectVariantEnum : uint8_t
{
    kDefault = 0x00,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 1,
};

// Enum for IdentifyTypeEnum
enum class IdentifyTypeEnum : uint8_t
{
    kNone             = 0x00,
    kLightOutput      = 0x01,
    kVisibleIndicator = 0x02,
    kAudibleBeep      = 0x03,
    kDisplay          = 0x04,
    kActuator         = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};
} // namespace Identify

namespace Groups {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kGroupNames = 0x1,
};

// Bitmap for NameSupportBitmap
enum class NameSupportBitmap : uint8_t
{
    kGroupNames = 0x80,
};
} // namespace Groups

namespace OnOff {

// Enum for DelayedAllOffEffectVariantEnum
enum class DelayedAllOffEffectVariantEnum : uint8_t
{
    kDelayedOffFastFade = 0x00,
    kNoFade             = 0x01,
    kDelayedOffSlowFade = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for DyingLightEffectVariantEnum
enum class DyingLightEffectVariantEnum : uint8_t
{
    kDyingLightFadeOff = 0x00,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 1,
};

// Enum for EffectIdentifierEnum
enum class EffectIdentifierEnum : uint8_t
{
    kDelayedAllOff = 0x00,
    kDyingLight    = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for StartUpOnOffEnum
enum class StartUpOnOffEnum : uint8_t
{
    kOff    = 0x00,
    kOn     = 0x01,
    kToggle = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kLighting          = 0x1,
    kDeadFrontBehavior = 0x2,
    kOffOnly           = 0x4,
};

// Bitmap for OnOffControlBitmap
enum class OnOffControlBitmap : uint8_t
{
    kAcceptOnlyWhenOn = 0x1,
};
} // namespace OnOff

namespace LevelControl {

// Enum for MoveModeEnum
enum class MoveModeEnum : uint8_t
{
    kUp   = 0x00,
    kDown = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for StepModeEnum
enum class StepModeEnum : uint8_t
{
    kUp   = 0x00,
    kDown = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff     = 0x1,
    kLighting  = 0x2,
    kFrequency = 0x4,
};

// Bitmap for OptionsBitmap
enum class OptionsBitmap : uint8_t
{
    kExecuteIfOff           = 0x1,
    kCoupleColorTempToLevel = 0x2,
};
} // namespace LevelControl

namespace PulseWidthModulation {} // namespace PulseWidthModulation

namespace Descriptor {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTagList = 0x1,
};
} // namespace Descriptor

namespace Binding {} // namespace Binding

namespace AccessControl {

// Enum for AccessControlEntryAuthModeEnum
enum class AccessControlEntryAuthModeEnum : uint8_t
{
    kPase  = 0x01,
    kCase  = 0x02,
    kGroup = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for AccessControlEntryPrivilegeEnum
enum class AccessControlEntryPrivilegeEnum : uint8_t
{
    kView       = 0x01,
    kProxyView  = 0x02,
    kOperate    = 0x03,
    kManage     = 0x04,
    kAdminister = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for AccessRestrictionTypeEnum
enum class AccessRestrictionTypeEnum : uint8_t
{
    kAttributeAccessForbidden = 0x00,
    kAttributeWriteForbidden  = 0x01,
    kCommandForbidden         = 0x02,
    kEventForbidden           = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ChangeTypeEnum
enum class ChangeTypeEnum : uint8_t
{
    kChanged = 0x00,
    kAdded   = 0x01,
    kRemoved = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kExtension     = 0x1,
    kManagedDevice = 0x2,
};
} // namespace AccessControl

namespace Actions {

// Enum for ActionErrorEnum
enum class ActionErrorEnum : uint8_t
{
    kUnknown     = 0x00,
    kInterrupted = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for ActionStateEnum
enum class ActionStateEnum : uint8_t
{
    kInactive = 0x00,
    kActive   = 0x01,
    kPaused   = 0x02,
    kDisabled = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ActionTypeEnum
enum class ActionTypeEnum : uint8_t
{
    kOther        = 0x00,
    kScene        = 0x01,
    kSequence     = 0x02,
    kAutomation   = 0x03,
    kException    = 0x04,
    kNotification = 0x05,
    kAlarm        = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for EndpointListTypeEnum
enum class EndpointListTypeEnum : uint8_t
{
    kOther = 0x00,
    kRoom  = 0x01,
    kZone  = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for CommandBits
enum class CommandBits : uint16_t
{
    kInstantAction               = 0x1,
    kInstantActionWithTransition = 0x2,
    kStartAction                 = 0x4,
    kStartActionWithDuration     = 0x8,
    kStopAction                  = 0x10,
    kPauseAction                 = 0x20,
    kPauseActionWithDuration     = 0x40,
    kResumeAction                = 0x80,
    kEnableAction                = 0x100,
    kEnableActionWithDuration    = 0x200,
    kDisableAction               = 0x400,
    kDisableActionWithDuration   = 0x800,
};
} // namespace Actions

namespace BasicInformation {

// Enum for ColorEnum
enum class ColorEnum : uint8_t
{
    kBlack   = 0x00,
    kNavy    = 0x01,
    kGreen   = 0x02,
    kTeal    = 0x03,
    kMaroon  = 0x04,
    kPurple  = 0x05,
    kOlive   = 0x06,
    kGray    = 0x07,
    kBlue    = 0x08,
    kLime    = 0x09,
    kAqua    = 0x0A,
    kRed     = 0x0B,
    kFuchsia = 0x0C,
    kYellow  = 0x0D,
    kWhite   = 0x0E,
    kNickel  = 0x0F,
    kChrome  = 0x10,
    kBrass   = 0x11,
    kCopper  = 0x12,
    kSilver  = 0x13,
    kGold    = 0x14,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 21,
};

// Enum for ProductFinishEnum
enum class ProductFinishEnum : uint8_t
{
    kOther    = 0x00,
    kMatte    = 0x01,
    kSatin    = 0x02,
    kPolished = 0x03,
    kRugged   = 0x04,
    kFabric   = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};
} // namespace BasicInformation

namespace OtaSoftwareUpdateProvider {

// Enum for ApplyUpdateActionEnum
enum class ApplyUpdateActionEnum : uint8_t
{
    kProceed         = 0x00,
    kAwaitNextAction = 0x01,
    kDiscontinue     = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for DownloadProtocolEnum
enum class DownloadProtocolEnum : uint8_t
{
    kBDXSynchronous  = 0x00,
    kBDXAsynchronous = 0x01,
    kHttps           = 0x02,
    kVendorSpecific  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kUpdateAvailable              = 0x00,
    kBusy                         = 0x01,
    kNotAvailable                 = 0x02,
    kDownloadProtocolNotSupported = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};
} // namespace OtaSoftwareUpdateProvider

namespace OtaSoftwareUpdateRequestor {

// Enum for AnnouncementReasonEnum
enum class AnnouncementReasonEnum : uint8_t
{
    kSimpleAnnouncement    = 0x00,
    kUpdateAvailable       = 0x01,
    kUrgentUpdateAvailable = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for ChangeReasonEnum
enum class ChangeReasonEnum : uint8_t
{
    kUnknown         = 0x00,
    kSuccess         = 0x01,
    kFailure         = 0x02,
    kTimeOut         = 0x03,
    kDelayByProvider = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for UpdateStateEnum
enum class UpdateStateEnum : uint8_t
{
    kUnknown              = 0x00,
    kIdle                 = 0x01,
    kQuerying             = 0x02,
    kDelayedOnQuery       = 0x03,
    kDownloading          = 0x04,
    kApplying             = 0x05,
    kDelayedOnApply       = 0x06,
    kRollingBack          = 0x07,
    kDelayedOnUserConsent = 0x08,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 9,
};
} // namespace OtaSoftwareUpdateRequestor

namespace LocalizationConfiguration {} // namespace LocalizationConfiguration

namespace TimeFormatLocalization {

// Enum for CalendarTypeEnum
enum class CalendarTypeEnum : uint8_t
{
    kBuddhist        = 0x00,
    kChinese         = 0x01,
    kCoptic          = 0x02,
    kEthiopian       = 0x03,
    kGregorian       = 0x04,
    kHebrew          = 0x05,
    kIndian          = 0x06,
    kIslamic         = 0x07,
    kJapanese        = 0x08,
    kKorean          = 0x09,
    kPersian         = 0x0A,
    kTaiwanese       = 0x0B,
    kUseActiveLocale = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 12,
};

// Enum for HourFormatEnum
enum class HourFormatEnum : uint8_t
{
    k12hr            = 0x00,
    k24hr            = 0x01,
    kUseActiveLocale = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kCalendarFormat = 0x1,
};
} // namespace TimeFormatLocalization

namespace UnitLocalization {

// Enum for TempUnitEnum
enum class TempUnitEnum : uint8_t
{
    kFahrenheit = 0x00,
    kCelsius    = 0x01,
    kKelvin     = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTemperatureUnit = 0x1,
};
} // namespace UnitLocalization

namespace PowerSourceConfiguration {} // namespace PowerSourceConfiguration

namespace PowerSource {

// Enum for BatApprovedChemistryEnum
enum class BatApprovedChemistryEnum : uint16_t
{
    kUnspecified             = 0x00,
    kAlkaline                = 0x01,
    kLithiumCarbonFluoride   = 0x02,
    kLithiumChromiumOxide    = 0x03,
    kLithiumCopperOxide      = 0x04,
    kLithiumIronDisulfide    = 0x05,
    kLithiumManganeseDioxide = 0x06,
    kLithiumThionylChloride  = 0x07,
    kMagnesium               = 0x08,
    kMercuryOxide            = 0x09,
    kNickelOxyhydride        = 0x0A,
    kSilverOxide             = 0x0B,
    kZincAir                 = 0x0C,
    kZincCarbon              = 0x0D,
    kZincChloride            = 0x0E,
    kZincManganeseDioxide    = 0x0F,
    kLeadAcid                = 0x10,
    kLithiumCobaltOxide      = 0x11,
    kLithiumIon              = 0x12,
    kLithiumIonPolymer       = 0x13,
    kLithiumIronPhosphate    = 0x14,
    kLithiumSulfur           = 0x15,
    kLithiumTitanate         = 0x16,
    kNickelCadmium           = 0x17,
    kNickelHydrogen          = 0x18,
    kNickelIron              = 0x19,
    kNickelMetalHydride      = 0x1A,
    kNickelZinc              = 0x1B,
    kSilverZinc              = 0x1C,
    kSodiumIon               = 0x1D,
    kSodiumSulfur            = 0x1E,
    kZincBromide             = 0x1F,
    kZincCerium              = 0x20,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 33,
};

// Enum for BatChargeFaultEnum
enum class BatChargeFaultEnum : uint8_t
{
    kUnspecified         = 0x00,
    kAmbientTooHot       = 0x01,
    kAmbientTooCold      = 0x02,
    kBatteryTooHot       = 0x03,
    kBatteryTooCold      = 0x04,
    kBatteryAbsent       = 0x05,
    kBatteryOverVoltage  = 0x06,
    kBatteryUnderVoltage = 0x07,
    kChargerOverVoltage  = 0x08,
    kChargerUnderVoltage = 0x09,
    kSafetyTimeout       = 0x0A,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 11,
};

// Enum for BatChargeLevelEnum
enum class BatChargeLevelEnum : uint8_t
{
    kOk       = 0x00,
    kWarning  = 0x01,
    kCritical = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for BatChargeStateEnum
enum class BatChargeStateEnum : uint8_t
{
    kUnknown        = 0x00,
    kIsCharging     = 0x01,
    kIsAtFullCharge = 0x02,
    kIsNotCharging  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for BatCommonDesignationEnum
enum class BatCommonDesignationEnum : uint16_t
{
    kUnspecified = 0x00,
    kAaa         = 0x01,
    kAa          = 0x02,
    kC           = 0x03,
    kD           = 0x04,
    k4v5         = 0x05,
    k6v0         = 0x06,
    k9v0         = 0x07,
    k12aa        = 0x08,
    kAaaa        = 0x09,
    kA           = 0x0A,
    kB           = 0x0B,
    kF           = 0x0C,
    kN           = 0x0D,
    kNo6         = 0x0E,
    kSubC        = 0x0F,
    kA23         = 0x10,
    kA27         = 0x11,
    kBa5800      = 0x12,
    kDuplex      = 0x13,
    k4sr44       = 0x14,
    k523         = 0x15,
    k531         = 0x16,
    k15v0        = 0x17,
    k22v5        = 0x18,
    k30v0        = 0x19,
    k45v0        = 0x1A,
    k67v5        = 0x1B,
    kJ           = 0x1C,
    kCr123a      = 0x1D,
    kCr2         = 0x1E,
    k2cr5        = 0x1F,
    kCrP2        = 0x20,
    kCrV3        = 0x21,
    kSr41        = 0x22,
    kSr43        = 0x23,
    kSr44        = 0x24,
    kSr45        = 0x25,
    kSr48        = 0x26,
    kSr54        = 0x27,
    kSr55        = 0x28,
    kSr57        = 0x29,
    kSr58        = 0x2A,
    kSr59        = 0x2B,
    kSr60        = 0x2C,
    kSr63        = 0x2D,
    kSr64        = 0x2E,
    kSr65        = 0x2F,
    kSr66        = 0x30,
    kSr67        = 0x31,
    kSr68        = 0x32,
    kSr69        = 0x33,
    kSr516       = 0x34,
    kSr731       = 0x35,
    kSr712       = 0x36,
    kLr932       = 0x37,
    kA5          = 0x38,
    kA10         = 0x39,
    kA13         = 0x3A,
    kA312        = 0x3B,
    kA675        = 0x3C,
    kAc41e       = 0x3D,
    k10180       = 0x3E,
    k10280       = 0x3F,
    k10440       = 0x40,
    k14250       = 0x41,
    k14430       = 0x42,
    k14500       = 0x43,
    k14650       = 0x44,
    k15270       = 0x45,
    k16340       = 0x46,
    kRcr123a     = 0x47,
    k17500       = 0x48,
    k17670       = 0x49,
    k18350       = 0x4A,
    k18500       = 0x4B,
    k18650       = 0x4C,
    k19670       = 0x4D,
    k25500       = 0x4E,
    k26650       = 0x4F,
    k32600       = 0x50,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 81,
};

// Enum for BatFaultEnum
enum class BatFaultEnum : uint8_t
{
    kUnspecified = 0x00,
    kOverTemp    = 0x01,
    kUnderTemp   = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for BatReplaceabilityEnum
enum class BatReplaceabilityEnum : uint8_t
{
    kUnspecified        = 0x00,
    kNotReplaceable     = 0x01,
    kUserReplaceable    = 0x02,
    kFactoryReplaceable = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for PowerSourceStatusEnum
enum class PowerSourceStatusEnum : uint8_t
{
    kUnspecified = 0x00,
    kActive      = 0x01,
    kStandby     = 0x02,
    kUnavailable = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for WiredCurrentTypeEnum
enum class WiredCurrentTypeEnum : uint8_t
{
    kAc = 0x00,
    kDc = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for WiredFaultEnum
enum class WiredFaultEnum : uint8_t
{
    kUnspecified  = 0x00,
    kOverVoltage  = 0x01,
    kUnderVoltage = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kWired        = 0x1,
    kBattery      = 0x2,
    kRechargeable = 0x4,
    kReplaceable  = 0x8,
};
} // namespace PowerSource

namespace GeneralCommissioning {

// Enum for CommissioningErrorEnum
enum class CommissioningErrorEnum : uint8_t
{
    kOk                            = 0x00,
    kValueOutsideRange             = 0x01,
    kInvalidAuthentication         = 0x02,
    kNoFailSafe                    = 0x03,
    kBusyWithOtherAdmin            = 0x04,
    kRequiredTCNotAccepted         = 0x05,
    kTCAcknowledgementsNotReceived = 0x06,
    kTCMinVersionNotMet            = 0x07,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 8,
};

// Enum for RegulatoryLocationTypeEnum
enum class RegulatoryLocationTypeEnum : uint8_t
{
    kIndoor        = 0x00,
    kOutdoor       = 0x01,
    kIndoorOutdoor = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTermsAndConditions = 0x1,
};
} // namespace GeneralCommissioning

namespace NetworkCommissioning {

// Enum for NetworkCommissioningStatusEnum
enum class NetworkCommissioningStatusEnum : uint8_t
{
    kSuccess                = 0x00,
    kOutOfRange             = 0x01,
    kBoundsExceeded         = 0x02,
    kNetworkIDNotFound      = 0x03,
    kDuplicateNetworkID     = 0x04,
    kNetworkNotFound        = 0x05,
    kRegulatoryError        = 0x06,
    kAuthFailure            = 0x07,
    kUnsupportedSecurity    = 0x08,
    kOtherConnectionFailure = 0x09,
    kIPV6Failed             = 0x0A,
    kIPBindFailed           = 0x0B,
    kUnknownError           = 0x0C,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 13,
};

// Enum for WiFiBandEnum
enum class WiFiBandEnum : uint8_t
{
    k2g4  = 0x00,
    k3g65 = 0x01,
    k5g   = 0x02,
    k6g   = 0x03,
    k60g  = 0x04,
    k1g   = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kWiFiNetworkInterface     = 0x1,
    kThreadNetworkInterface   = 0x2,
    kEthernetNetworkInterface = 0x4,
    kPerDeviceCredentials     = 0x8,
};

// Bitmap for ThreadCapabilitiesBitmap
enum class ThreadCapabilitiesBitmap : uint16_t
{
    kIsBorderRouterCapable                = 0x1,
    kIsRouterCapable                      = 0x2,
    kIsSleepyEndDeviceCapable             = 0x4,
    kIsFullThreadDevice                   = 0x8,
    kIsSynchronizedSleepyEndDeviceCapable = 0x10,
};

// Bitmap for WiFiSecurityBitmap
enum class WiFiSecurityBitmap : uint8_t
{
    kUnencrypted   = 0x1,
    kWep           = 0x2,
    kWpaPersonal   = 0x4,
    kWpa2Personal  = 0x8,
    kWpa3Personal  = 0x10,
    kWpa3MatterPdc = 0x20,
};
} // namespace NetworkCommissioning

namespace DiagnosticLogs {

// Enum for IntentEnum
enum class IntentEnum : uint8_t
{
    kEndUserSupport = 0x00,
    kNetworkDiag    = 0x01,
    kCrashLogs      = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess   = 0x00,
    kExhausted = 0x01,
    kNoLogs    = 0x02,
    kBusy      = 0x03,
    kDenied    = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for TransferProtocolEnum
enum class TransferProtocolEnum : uint8_t
{
    kResponsePayload = 0x00,
    kBdx             = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};
} // namespace DiagnosticLogs

namespace GeneralDiagnostics {

// Enum for BootReasonEnum
enum class BootReasonEnum : uint8_t
{
    kUnspecified             = 0x00,
    kPowerOnReboot           = 0x01,
    kBrownOutReset           = 0x02,
    kSoftwareWatchdogReset   = 0x03,
    kHardwareWatchdogReset   = 0x04,
    kSoftwareUpdateCompleted = 0x05,
    kSoftwareReset           = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for HardwareFaultEnum
enum class HardwareFaultEnum : uint8_t
{
    kUnspecified            = 0x00,
    kRadio                  = 0x01,
    kSensor                 = 0x02,
    kResettableOverTemp     = 0x03,
    kNonResettableOverTemp  = 0x04,
    kPowerSource            = 0x05,
    kVisualDisplayFault     = 0x06,
    kAudioOutputFault       = 0x07,
    kUserInterfaceFault     = 0x08,
    kNonVolatileMemoryError = 0x09,
    kTamperDetected         = 0x0A,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 11,
};

// Enum for InterfaceTypeEnum
enum class InterfaceTypeEnum : uint8_t
{
    kUnspecified = 0x00,
    kWiFi        = 0x01,
    kEthernet    = 0x02,
    kCellular    = 0x03,
    kThread      = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for NetworkFaultEnum
enum class NetworkFaultEnum : uint8_t
{
    kUnspecified      = 0x00,
    kHardwareFailure  = 0x01,
    kNetworkJammed    = 0x02,
    kConnectionFailed = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for RadioFaultEnum
enum class RadioFaultEnum : uint8_t
{
    kUnspecified   = 0x00,
    kWiFiFault     = 0x01,
    kCellularFault = 0x02,
    kThreadFault   = 0x03,
    kNFCFault      = 0x04,
    kBLEFault      = 0x05,
    kEthernetFault = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kDataModelTest = 0x1,
};
} // namespace GeneralDiagnostics

namespace SoftwareDiagnostics {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kWatermarks = 0x1,
};
} // namespace SoftwareDiagnostics

namespace ThreadNetworkDiagnostics {

// Enum for ConnectionStatusEnum
enum class ConnectionStatusEnum : uint8_t
{
    kConnected    = 0x00,
    kNotConnected = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for NetworkFaultEnum
enum class NetworkFaultEnum : uint8_t
{
    kUnspecified     = 0x00,
    kLinkDown        = 0x01,
    kHardwareFailure = 0x02,
    kNetworkJammed   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for RoutingRoleEnum
enum class RoutingRoleEnum : uint8_t
{
    kUnspecified     = 0x00,
    kUnassigned      = 0x01,
    kSleepyEndDevice = 0x02,
    kEndDevice       = 0x03,
    kReed            = 0x04,
    kRouter          = 0x05,
    kLeader          = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPacketCounts = 0x1,
    kErrorCounts  = 0x2,
    kMLECounts    = 0x4,
    kMACCounts    = 0x8,
};
} // namespace ThreadNetworkDiagnostics

namespace WiFiNetworkDiagnostics {

// Enum for AssociationFailureCauseEnum
enum class AssociationFailureCauseEnum : uint8_t
{
    kUnknown              = 0x00,
    kAssociationFailed    = 0x01,
    kAuthenticationFailed = 0x02,
    kSsidNotFound         = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ConnectionStatusEnum
enum class ConnectionStatusEnum : uint8_t
{
    kConnected    = 0x00,
    kNotConnected = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for SecurityTypeEnum
enum class SecurityTypeEnum : uint8_t
{
    kUnspecified = 0x00,
    kNone        = 0x01,
    kWep         = 0x02,
    kWpa         = 0x03,
    kWpa2        = 0x04,
    kWpa3        = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Enum for WiFiVersionEnum
enum class WiFiVersionEnum : uint8_t
{
    kA  = 0x00,
    kB  = 0x01,
    kG  = 0x02,
    kN  = 0x03,
    kAc = 0x04,
    kAx = 0x05,
    kAh = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPacketCounts = 0x1,
    kErrorCounts  = 0x2,
};
} // namespace WiFiNetworkDiagnostics

namespace EthernetNetworkDiagnostics {

// Enum for PHYRateEnum
enum class PHYRateEnum : uint8_t
{
    kRate10M  = 0x00,
    kRate100M = 0x01,
    kRate1G   = 0x02,
    kRate25g  = 0x03,
    kRate5G   = 0x04,
    kRate10G  = 0x05,
    kRate40G  = 0x06,
    kRate100G = 0x07,
    kRate200G = 0x08,
    kRate400G = 0x09,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPacketCounts = 0x1,
    kErrorCounts  = 0x2,
};
} // namespace EthernetNetworkDiagnostics

namespace TimeSynchronization {

// Enum for GranularityEnum
enum class GranularityEnum : uint8_t
{
    kNoTimeGranularity       = 0x00,
    kMinutesGranularity      = 0x01,
    kSecondsGranularity      = 0x02,
    kMillisecondsGranularity = 0x03,
    kMicrosecondsGranularity = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for StatusCode
enum class StatusCode : uint8_t
{
    kTimeNotAccepted = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for TimeSourceEnum
enum class TimeSourceEnum : uint8_t
{
    kNone             = 0x00,
    kUnknown          = 0x01,
    kAdmin            = 0x02,
    kNodeTimeCluster  = 0x03,
    kNonMatterSNTP    = 0x04,
    kNonMatterNTP     = 0x05,
    kMatterSNTP       = 0x06,
    kMatterNTP        = 0x07,
    kMixedNTP         = 0x08,
    kNonMatterSNTPNTS = 0x09,
    kNonMatterNTPNTS  = 0x0A,
    kMatterSNTPNTS    = 0x0B,
    kMatterNTPNTS     = 0x0C,
    kMixedNTPNTS      = 0x0D,
    kCloudSource      = 0x0E,
    kPtp              = 0x0F,
    kGnss             = 0x10,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 17,
};

// Enum for TimeZoneDatabaseEnum
enum class TimeZoneDatabaseEnum : uint8_t
{
    kFull    = 0x00,
    kPartial = 0x01,
    kNone    = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTimeZone       = 0x1,
    kNTPClient      = 0x2,
    kNTPServer      = 0x4,
    kTimeSyncClient = 0x8,
};
} // namespace TimeSynchronization

namespace BridgedDeviceBasicInformation {

// Enum for ColorEnum
enum class ColorEnum : uint8_t
{
    kBlack   = 0x00,
    kNavy    = 0x01,
    kGreen   = 0x02,
    kTeal    = 0x03,
    kMaroon  = 0x04,
    kPurple  = 0x05,
    kOlive   = 0x06,
    kGray    = 0x07,
    kBlue    = 0x08,
    kLime    = 0x09,
    kAqua    = 0x0A,
    kRed     = 0x0B,
    kFuchsia = 0x0C,
    kYellow  = 0x0D,
    kWhite   = 0x0E,
    kNickel  = 0x0F,
    kChrome  = 0x10,
    kBrass   = 0x11,
    kCopper  = 0x12,
    kSilver  = 0x13,
    kGold    = 0x14,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 21,
};

// Enum for ProductFinishEnum
enum class ProductFinishEnum : uint8_t
{
    kOther    = 0x00,
    kMatte    = 0x01,
    kSatin    = 0x02,
    kPolished = 0x03,
    kRugged   = 0x04,
    kFabric   = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kBridgedICDSupport = 0x100000,
};
} // namespace BridgedDeviceBasicInformation

namespace Switch {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kLatchingSwitch            = 0x1,
    kMomentarySwitch           = 0x2,
    kMomentarySwitchRelease    = 0x4,
    kMomentarySwitchLongPress  = 0x8,
    kMomentarySwitchMultiPress = 0x10,
    kActionSwitch              = 0x20,
};
} // namespace Switch

namespace AdministratorCommissioning {

// Enum for CommissioningWindowStatusEnum
enum class CommissioningWindowStatusEnum : uint8_t
{
    kWindowNotOpen      = 0x00,
    kEnhancedWindowOpen = 0x01,
    kBasicWindowOpen    = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for StatusCode
enum class StatusCode : uint8_t
{
    kBusy               = 0x02,
    kPAKEParameterError = 0x03,
    kWindowNotOpen      = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kBasic = 0x1,
};
} // namespace AdministratorCommissioning

namespace OperationalCredentials {

// Enum for CertificateChainTypeEnum
enum class CertificateChainTypeEnum : uint8_t
{
    kDACCertificate = 0x01,
    kPAICertificate = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for NodeOperationalCertStatusEnum
enum class NodeOperationalCertStatusEnum : uint8_t
{
    kOk                  = 0x00,
    kInvalidPublicKey    = 0x01,
    kInvalidNodeOpId     = 0x02,
    kInvalidNOC          = 0x03,
    kMissingCsr          = 0x04,
    kTableFull           = 0x05,
    kInvalidAdminSubject = 0x06,
    kFabricConflict      = 0x09,
    kLabelConflict       = 0x0A,
    kInvalidFabricIndex  = 0x0B,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};
} // namespace OperationalCredentials

namespace GroupKeyManagement {

// Enum for GroupKeySecurityPolicyEnum
enum class GroupKeySecurityPolicyEnum : uint8_t
{
    kTrustFirst   = 0x00,
    kCacheAndSync = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kCacheAndSync = 0x1,
};
} // namespace GroupKeyManagement

namespace FixedLabel {} // namespace FixedLabel

namespace UserLabel {} // namespace UserLabel

namespace ProxyConfiguration {} // namespace ProxyConfiguration

namespace ProxyDiscovery {} // namespace ProxyDiscovery

namespace ProxyValid {} // namespace ProxyValid

namespace BooleanState {} // namespace BooleanState

namespace IcdManagement {

// Enum for ClientTypeEnum
enum class ClientTypeEnum : uint8_t
{
    kPermanent = 0x00,
    kEphemeral = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for OperatingModeEnum
enum class OperatingModeEnum : uint8_t
{
    kSit = 0x00,
    kLit = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kCheckInProtocolSupport = 0x1,
    kUserActiveModeTrigger  = 0x2,
    kLongIdleTimeSupport    = 0x4,
    kDynamicSitLitSupport   = 0x8,
};

// Bitmap for UserActiveModeTriggerBitmap
enum class UserActiveModeTriggerBitmap : uint32_t
{
    kPowerCycle               = 0x1,
    kSettingsMenu             = 0x2,
    kCustomInstruction        = 0x4,
    kDeviceManual             = 0x8,
    kActuateSensor            = 0x10,
    kActuateSensorSeconds     = 0x20,
    kActuateSensorTimes       = 0x40,
    kActuateSensorLightsBlink = 0x80,
    kResetButton              = 0x100,
    kResetButtonLightsBlink   = 0x200,
    kResetButtonSeconds       = 0x400,
    kResetButtonTimes         = 0x800,
    kSetupButton              = 0x1000,
    kSetupButtonSeconds       = 0x2000,
    kSetupButtonLightsBlink   = 0x4000,
    kSetupButtonTimes         = 0x8000,
    kAppDefinedButton         = 0x10000,
};
} // namespace IcdManagement

namespace Timer {

// Enum for TimerStatusEnum
enum class TimerStatusEnum : uint8_t
{
    kRunning = 0x00,
    kPaused  = 0x01,
    kExpired = 0x02,
    kReady   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kReset = 0x1,
};
} // namespace Timer

namespace OvenCavityOperationalState {

// Enum for ErrorStateEnum
enum class ErrorStateEnum : uint8_t
{
    kNoError                   = 0x00,
    kUnableToStartOrResume     = 0x01,
    kUnableToCompleteOperation = 0x02,
    kCommandInvalidInState     = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for OperationalStateEnum
enum class OperationalStateEnum : uint8_t
{
    kStopped = 0x00,
    kRunning = 0x01,
    kPaused  = 0x02,
    kError   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};
} // namespace OvenCavityOperationalState

namespace OvenMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto            = 0x00,
    kQuick           = 0x01,
    kQuiet           = 0x02,
    kLowNoise        = 0x03,
    kLowEnergy       = 0x04,
    kVacation        = 0x05,
    kMin             = 0x06,
    kMax             = 0x07,
    kNight           = 0x08,
    kDay             = 0x09,
    kBake            = 0x4000,
    kConvection      = 0x4001,
    kGrill           = 0x4002,
    kRoast           = 0x4003,
    kClean           = 0x4004,
    kConvectionBake  = 0x4005,
    kConvectionRoast = 0x4006,
    kWarming         = 0x4007,
    kProofing        = 0x4008,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace OvenMode

namespace LaundryDryerControls {

// Enum for DrynessLevelEnum
enum class DrynessLevelEnum : uint8_t
{
    kLow    = 0x00,
    kNormal = 0x01,
    kExtra  = 0x02,
    kMax    = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};
} // namespace LaundryDryerControls

namespace ModeSelect {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace ModeSelect

namespace LaundryWasherMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kNormal    = 0x4000,
    kDelicate  = 0x4001,
    kHeavy     = 0x4002,
    kWhites    = 0x4003,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace LaundryWasherMode

namespace RefrigeratorAndTemperatureControlledCabinetMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto        = 0x00,
    kQuick       = 0x01,
    kQuiet       = 0x02,
    kLowNoise    = 0x03,
    kLowEnergy   = 0x04,
    kVacation    = 0x05,
    kMin         = 0x06,
    kMax         = 0x07,
    kNight       = 0x08,
    kDay         = 0x09,
    kRapidCool   = 0x4000,
    kRapidFreeze = 0x4001,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace RefrigeratorAndTemperatureControlledCabinetMode

namespace LaundryWasherControls {

// Enum for NumberOfRinsesEnum
enum class NumberOfRinsesEnum : uint8_t
{
    kNone   = 0x00,
    kNormal = 0x01,
    kExtra  = 0x02,
    kMax    = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kSpin  = 0x1,
    kRinse = 0x2,
};
} // namespace LaundryWasherControls

namespace RvcRunMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kIdle      = 0x4000,
    kCleaning  = 0x4001,
    kMapping   = 0x4002,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Enum for StatusCode
enum class StatusCode : uint8_t
{
    kStuck                 = 0x41,
    kDustBinMissing        = 0x42,
    kDustBinFull           = 0x43,
    kWaterTankEmpty        = 0x44,
    kWaterTankMissing      = 0x45,
    kWaterTankLidOpen      = 0x46,
    kMopCleaningPadMissing = 0x47,
    kBatteryLow            = 0x48,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kDirectModeChange = 0x10000,
};
} // namespace RvcRunMode

namespace RvcCleanMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kDeepClean = 0x4000,
    kVacuum    = 0x4001,
    kMop       = 0x4002,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Enum for StatusCode
enum class StatusCode : uint8_t
{
    kCleaningInProgress = 0x40,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kDirectModeChange = 0x10000,
};
} // namespace RvcCleanMode

namespace TemperatureControl {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTemperatureNumber = 0x1,
    kTemperatureLevel  = 0x2,
    kTemperatureStep   = 0x4,
};
} // namespace TemperatureControl

namespace RefrigeratorAlarm {

// Bitmap for AlarmBitmap
enum class AlarmBitmap : uint32_t
{
    kDoorOpen = 0x1,
};
} // namespace RefrigeratorAlarm

namespace DishwasherMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kNormal    = 0x4000,
    kHeavy     = 0x4001,
    kLight     = 0x4002,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace DishwasherMode

namespace AirQuality {

// Enum for AirQualityEnum
enum class AirQualityEnum : uint8_t
{
    kUnknown       = 0x00,
    kGood          = 0x01,
    kFair          = 0x02,
    kModerate      = 0x03,
    kPoor          = 0x04,
    kVeryPoor      = 0x05,
    kExtremelyPoor = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kFair          = 0x1,
    kModerate      = 0x2,
    kVeryPoor      = 0x4,
    kExtremelyPoor = 0x8,
};
} // namespace AirQuality

namespace SmokeCoAlarm {

// Enum for AlarmStateEnum
enum class AlarmStateEnum : uint8_t
{
    kNormal   = 0x00,
    kWarning  = 0x01,
    kCritical = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for ContaminationStateEnum
enum class ContaminationStateEnum : uint8_t
{
    kNormal   = 0x00,
    kLow      = 0x01,
    kWarning  = 0x02,
    kCritical = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for EndOfServiceEnum
enum class EndOfServiceEnum : uint8_t
{
    kNormal  = 0x00,
    kExpired = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for ExpressedStateEnum
enum class ExpressedStateEnum : uint8_t
{
    kNormal            = 0x00,
    kSmokeAlarm        = 0x01,
    kCOAlarm           = 0x02,
    kBatteryAlert      = 0x03,
    kTesting           = 0x04,
    kHardwareFault     = 0x05,
    kEndOfService      = 0x06,
    kInterconnectSmoke = 0x07,
    kInterconnectCO    = 0x08,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 9,
};

// Enum for MuteStateEnum
enum class MuteStateEnum : uint8_t
{
    kNotMuted = 0x00,
    kMuted    = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for SensitivityEnum
enum class SensitivityEnum : uint8_t
{
    kHigh     = 0x00,
    kStandard = 0x01,
    kLow      = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kSmokeAlarm = 0x1,
    kCoAlarm    = 0x2,
};
} // namespace SmokeCoAlarm

namespace DishwasherAlarm {

// Bitmap for AlarmBitmap
enum class AlarmBitmap : uint32_t
{
    kInflowError     = 0x1,
    kDrainError      = 0x2,
    kDoorError       = 0x4,
    kTempTooLow      = 0x8,
    kTempTooHigh     = 0x10,
    kWaterLevelError = 0x20,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kReset = 0x1,
};
} // namespace DishwasherAlarm

namespace MicrowaveOvenMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kNormal    = 0x4000,
    kDefrost   = 0x4001,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace MicrowaveOvenMode

namespace MicrowaveOvenControl {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPowerAsNumber     = 0x1,
    kPowerInWatts      = 0x2,
    kPowerNumberLimits = 0x4,
};
} // namespace MicrowaveOvenControl

namespace OperationalState {

// Enum for ErrorStateEnum
enum class ErrorStateEnum : uint8_t
{
    kNoError                   = 0x00,
    kUnableToStartOrResume     = 0x01,
    kUnableToCompleteOperation = 0x02,
    kCommandInvalidInState     = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for OperationalStateEnum
enum class OperationalStateEnum : uint8_t
{
    kStopped = 0x00,
    kRunning = 0x01,
    kPaused  = 0x02,
    kError   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};
} // namespace OperationalState

namespace RvcOperationalState {

// Enum for ErrorStateEnum
enum class ErrorStateEnum : uint8_t
{
    kNoError                   = 0x00,
    kUnableToStartOrResume     = 0x01,
    kUnableToCompleteOperation = 0x02,
    kCommandInvalidInState     = 0x03,
    kFailedToFindChargingDock  = 0x40,
    kStuck                     = 0x41,
    kDustBinMissing            = 0x42,
    kDustBinFull               = 0x43,
    kWaterTankEmpty            = 0x44,
    kWaterTankMissing          = 0x45,
    kWaterTankLidOpen          = 0x46,
    kMopCleaningPadMissing     = 0x47,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Enum for OperationalStateEnum
enum class OperationalStateEnum : uint8_t
{
    kStopped        = 0x00,
    kRunning        = 0x01,
    kPaused         = 0x02,
    kError          = 0x03,
    kSeekingCharger = 0x40,
    kCharging       = 0x41,
    kDocked         = 0x42,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};
} // namespace RvcOperationalState

namespace ScenesManagement {

// Bitmap for CopyModeBitmap
enum class CopyModeBitmap : uint8_t
{
    kCopyAllScenes = 0x1,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kSceneNames = 0x1,
};
} // namespace ScenesManagement

namespace HepaFilterMonitoring {

using ChangeIndicationEnum = Clusters::detail::ChangeIndicationEnum;

using DegradationDirectionEnum = Clusters::detail::DegradationDirectionEnum;

using ProductIdentifierTypeEnum = Clusters::detail::ProductIdentifierTypeEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kCondition              = 0x1,
    kWarning                = 0x2,
    kReplacementProductList = 0x4,
};
} // namespace HepaFilterMonitoring

namespace ActivatedCarbonFilterMonitoring {

using ChangeIndicationEnum = Clusters::detail::ChangeIndicationEnum;

using DegradationDirectionEnum = Clusters::detail::DegradationDirectionEnum;

using ProductIdentifierTypeEnum = Clusters::detail::ProductIdentifierTypeEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kCondition              = 0x1,
    kWarning                = 0x2,
    kReplacementProductList = 0x4,
};
} // namespace ActivatedCarbonFilterMonitoring

namespace BooleanStateConfiguration {

// Bitmap for AlarmModeBitmap
enum class AlarmModeBitmap : uint8_t
{
    kVisual  = 0x1,
    kAudible = 0x2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kVisual           = 0x1,
    kAudible          = 0x2,
    kAlarmSuppress    = 0x4,
    kSensitivityLevel = 0x8,
};

// Bitmap for SensorFaultBitmap
enum class SensorFaultBitmap : uint16_t
{
    kGeneralFault = 0x1,
};
} // namespace BooleanStateConfiguration

namespace ValveConfigurationAndControl {

// Enum for StatusCodeEnum
enum class StatusCodeEnum : uint8_t
{
    kFailureDueToFault = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for ValveStateEnum
enum class ValveStateEnum : uint8_t
{
    kClosed        = 0x00,
    kOpen          = 0x01,
    kTransitioning = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kTimeSync = 0x1,
    kLevel    = 0x2,
};

// Bitmap for ValveFaultBitmap
enum class ValveFaultBitmap : uint16_t
{
    kGeneralFault    = 0x1,
    kBlocked         = 0x2,
    kLeaking         = 0x4,
    kNotConnected    = 0x8,
    kShortCircuit    = 0x10,
    kCurrentExceeded = 0x20,
};
} // namespace ValveConfigurationAndControl

namespace ElectricalPowerMeasurement {

using MeasurementTypeEnum = Clusters::detail::MeasurementTypeEnum;

// Enum for PowerModeEnum
enum class PowerModeEnum : uint8_t
{
    kUnknown = 0x00,
    kDc      = 0x01,
    kAc      = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kDirectCurrent      = 0x1,
    kAlternatingCurrent = 0x2,
    kPolyphasePower     = 0x4,
    kHarmonics          = 0x8,
    kPowerQuality       = 0x10,
};
} // namespace ElectricalPowerMeasurement

namespace ElectricalEnergyMeasurement {

using MeasurementTypeEnum = Clusters::detail::MeasurementTypeEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kImportedEnergy   = 0x1,
    kExportedEnergy   = 0x2,
    kCumulativeEnergy = 0x4,
    kPeriodicEnergy   = 0x8,
};
} // namespace ElectricalEnergyMeasurement

namespace WaterHeaterManagement {

// Enum for BoostStateEnum
enum class BoostStateEnum : uint8_t
{
    kInactive = 0x00,
    kActive   = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kEnergyManagement = 0x1,
    kTankPercent      = 0x2,
};

// Bitmap for WaterHeaterHeatSourceBitmap
enum class WaterHeaterHeatSourceBitmap : uint8_t
{
    kImmersionElement1 = 0x1,
    kImmersionElement2 = 0x2,
    kHeatPump          = 0x4,
    kBoiler            = 0x8,
    kOther             = 0x10,
};
} // namespace WaterHeaterManagement

namespace DemandResponseLoadControl {

// Enum for CriticalityLevelEnum
enum class CriticalityLevelEnum : uint8_t
{
    kUnknown           = 0x00,
    kGreen             = 0x01,
    kLevel1            = 0x02,
    kLevel2            = 0x03,
    kLevel3            = 0x04,
    kLevel4            = 0x05,
    kLevel5            = 0x06,
    kEmergency         = 0x07,
    kPlannedOutage     = 0x08,
    kServiceDisconnect = 0x09,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Enum for HeatingSourceEnum
enum class HeatingSourceEnum : uint8_t
{
    kAny         = 0x00,
    kElectric    = 0x01,
    kNonElectric = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for LoadControlEventChangeSourceEnum
enum class LoadControlEventChangeSourceEnum : uint8_t
{
    kAutomatic  = 0x00,
    kUserAction = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for LoadControlEventStatusEnum
enum class LoadControlEventStatusEnum : uint8_t
{
    kUnknown         = 0x00,
    kReceived        = 0x01,
    kInProgress      = 0x02,
    kCompleted       = 0x03,
    kOptedOut        = 0x04,
    kOptedIn         = 0x05,
    kCanceled        = 0x06,
    kSuperseded      = 0x07,
    kPartialOptedOut = 0x08,
    kPartialOptedIn  = 0x09,
    kNoParticipation = 0x0A,
    kUnavailable     = 0x0B,
    kFailed          = 0x0C,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 13,
};

// Bitmap for CancelControlBitmap
enum class CancelControlBitmap : uint16_t
{
    kRandomEnd = 0x1,
};

// Bitmap for DeviceClassBitmap
enum class DeviceClassBitmap : uint32_t
{
    kHvac             = 0x1,
    kStripHeater      = 0x2,
    kWaterHeater      = 0x4,
    kPoolPump         = 0x8,
    kSmartAppliance   = 0x10,
    kIrrigationPump   = 0x20,
    kCommercialLoad   = 0x40,
    kResidentialLoad  = 0x80,
    kExteriorLighting = 0x100,
    kInteriorLighting = 0x200,
    kEv               = 0x400,
    kGenerationSystem = 0x800,
    kSmartInverter    = 0x1000,
    kEvse             = 0x2000,
    kResu             = 0x4000,
    kEms              = 0x8000,
    kSem              = 0x10000,
};

// Bitmap for EventControlBitmap
enum class EventControlBitmap : uint16_t
{
    kRandomStart = 0x1,
};

// Bitmap for EventTransitionControlBitmap
enum class EventTransitionControlBitmap : uint16_t
{
    kRandomDuration = 0x1,
    kIgnoreOptOut   = 0x2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kEnrollmentGroups    = 0x1,
    kTemperatureOffset   = 0x2,
    kTemperatureSetpoint = 0x4,
    kLoadAdjustment      = 0x8,
    kDutyCycle           = 0x10,
    kPowerSavings        = 0x20,
    kHeatingSource       = 0x40,
};
} // namespace DemandResponseLoadControl

namespace Messages {

// Enum for FutureMessagePreferenceEnum
enum class FutureMessagePreferenceEnum : uint8_t
{
    kAllowed    = 0x00,
    kIncreased  = 0x01,
    kReduced    = 0x02,
    kDisallowed = 0x03,
    kBanned     = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for MessagePriorityEnum
enum class MessagePriorityEnum : uint8_t
{
    kLow      = 0x00,
    kMedium   = 0x01,
    kHigh     = 0x02,
    kCritical = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kReceivedConfirmation = 0x1,
    kConfirmationResponse = 0x2,
    kConfirmationReply    = 0x4,
    kProtectedMessages    = 0x8,
};

// Bitmap for MessageControlBitmap
enum class MessageControlBitmap : uint8_t
{
    kConfirmationRequired = 0x1,
    kResponseRequired     = 0x2,
    kReplyMessage         = 0x4,
    kMessageConfirmed     = 0x8,
    kMessageProtected     = 0x10,
};
} // namespace Messages

namespace DeviceEnergyManagement {

// Enum for AdjustmentCauseEnum
enum class AdjustmentCauseEnum : uint8_t
{
    kLocalOptimization = 0x00,
    kGridOptimization  = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for CauseEnum
enum class CauseEnum : uint8_t
{
    kNormalCompletion = 0x00,
    kOffline          = 0x01,
    kFault            = 0x02,
    kUserOptOut       = 0x03,
    kCancelled        = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for CostTypeEnum
enum class CostTypeEnum : uint8_t
{
    kFinancial    = 0x00,
    kGHGEmissions = 0x01,
    kComfort      = 0x02,
    kTemperature  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ESAStateEnum
enum class ESAStateEnum : uint8_t
{
    kOffline           = 0x00,
    kOnline            = 0x01,
    kFault             = 0x02,
    kPowerAdjustActive = 0x03,
    kPaused            = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for ESATypeEnum
enum class ESATypeEnum : uint8_t
{
    kEvse                = 0x00,
    kSpaceHeating        = 0x01,
    kWaterHeating        = 0x02,
    kSpaceCooling        = 0x03,
    kSpaceHeatingCooling = 0x04,
    kBatteryStorage      = 0x05,
    kSolarPV             = 0x06,
    kFridgeFreezer       = 0x07,
    kWashingMachine      = 0x08,
    kDishwasher          = 0x09,
    kCooking             = 0x0A,
    kHomeWaterPump       = 0x0B,
    kIrrigationWaterPump = 0x0C,
    kPoolPump            = 0x0D,
    kOther               = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 14,
};

// Enum for ForecastUpdateReasonEnum
enum class ForecastUpdateReasonEnum : uint8_t
{
    kInternalOptimization = 0x00,
    kLocalOptimization    = 0x01,
    kGridOptimization     = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for OptOutStateEnum
enum class OptOutStateEnum : uint8_t
{
    kNoOptOut    = 0x00,
    kLocalOptOut = 0x01,
    kGridOptOut  = 0x02,
    kOptOut      = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for PowerAdjustReasonEnum
enum class PowerAdjustReasonEnum : uint8_t
{
    kNoAdjustment                = 0x00,
    kLocalOptimizationAdjustment = 0x01,
    kGridOptimizationAdjustment  = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPowerAdjustment           = 0x1,
    kPowerForecastReporting    = 0x2,
    kStateForecastReporting    = 0x4,
    kStartTimeAdjustment       = 0x8,
    kPausable                  = 0x10,
    kForecastAdjustment        = 0x20,
    kConstraintBasedAdjustment = 0x40,
};
} // namespace DeviceEnergyManagement

namespace EnergyEvse {

// Enum for EnergyTransferStoppedReasonEnum
enum class EnergyTransferStoppedReasonEnum : uint8_t
{
    kEVStopped   = 0x00,
    kEVSEStopped = 0x01,
    kOther       = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for FaultStateEnum
enum class FaultStateEnum : uint8_t
{
    kNoError           = 0x00,
    kMeterFailure      = 0x01,
    kOverVoltage       = 0x02,
    kUnderVoltage      = 0x03,
    kOverCurrent       = 0x04,
    kContactWetFailure = 0x05,
    kContactDryFailure = 0x06,
    kGroundFault       = 0x07,
    kPowerLoss         = 0x08,
    kPowerQuality      = 0x09,
    kPilotShortCircuit = 0x0A,
    kEmergencyStop     = 0x0B,
    kEVDisconnected    = 0x0C,
    kWrongPowerSupply  = 0x0D,
    kLiveNeutralSwap   = 0x0E,
    kOverTemperature   = 0x0F,
    kOther             = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 16,
};

// Enum for StateEnum
enum class StateEnum : uint8_t
{
    kNotPluggedIn         = 0x00,
    kPluggedInNoDemand    = 0x01,
    kPluggedInDemand      = 0x02,
    kPluggedInCharging    = 0x03,
    kPluggedInDischarging = 0x04,
    kSessionEnding        = 0x05,
    kFault                = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for SupplyStateEnum
enum class SupplyStateEnum : uint8_t
{
    kDisabled            = 0x00,
    kChargingEnabled     = 0x01,
    kDischargingEnabled  = 0x02,
    kDisabledError       = 0x03,
    kDisabledDiagnostics = 0x04,
    kEnabled             = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kChargingPreferences = 0x1,
    kSoCReporting        = 0x2,
    kPlugAndCharge       = 0x4,
    kRfid                = 0x8,
    kV2x                 = 0x10,
};

// Bitmap for TargetDayOfWeekBitmap
enum class TargetDayOfWeekBitmap : uint8_t
{
    kSunday    = 0x1,
    kMonday    = 0x2,
    kTuesday   = 0x4,
    kWednesday = 0x8,
    kThursday  = 0x10,
    kFriday    = 0x20,
    kSaturday  = 0x40,
};
} // namespace EnergyEvse

namespace EnergyPreference {

// Enum for EnergyPriorityEnum
enum class EnergyPriorityEnum : uint8_t
{
    kComfort          = 0x00,
    kSpeed            = 0x01,
    kEfficiency       = 0x02,
    kWaterConsumption = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kEnergyBalance           = 0x1,
    kLowPowerModeSensitivity = 0x2,
};
} // namespace EnergyPreference

namespace PowerTopology {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNodeTopology     = 0x1,
    kTreeTopology     = 0x2,
    kSetTopology      = 0x4,
    kDynamicPowerFlow = 0x8,
};
} // namespace PowerTopology

namespace EnergyEvseMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto          = 0x00,
    kQuick         = 0x01,
    kQuiet         = 0x02,
    kLowNoise      = 0x03,
    kLowEnergy     = 0x04,
    kVacation      = 0x05,
    kMin           = 0x06,
    kMax           = 0x07,
    kNight         = 0x08,
    kDay           = 0x09,
    kManual        = 0x4000,
    kTimeOfUse     = 0x4001,
    kSolarCharging = 0x4002,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace EnergyEvseMode

namespace WaterHeaterMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto      = 0x00,
    kQuick     = 0x01,
    kQuiet     = 0x02,
    kLowNoise  = 0x03,
    kLowEnergy = 0x04,
    kVacation  = 0x05,
    kMin       = 0x06,
    kMax       = 0x07,
    kNight     = 0x08,
    kDay       = 0x09,
    kOff       = 0x4000,
    kManual    = 0x4001,
    kTimed     = 0x4002,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace WaterHeaterMode

namespace DeviceEnergyManagementMode {

// Enum for ModeTag
enum class ModeTag : uint16_t
{
    kAuto               = 0x00,
    kQuick              = 0x01,
    kQuiet              = 0x02,
    kLowNoise           = 0x03,
    kLowEnergy          = 0x04,
    kVacation           = 0x05,
    kMin                = 0x06,
    kMax                = 0x07,
    kNight              = 0x08,
    kDay                = 0x09,
    kNoOptimization     = 0x4000,
    kDeviceOptimization = 0x4001,
    kLocalOptimization  = 0x4002,
    kGridOptimization   = 0x4003,
    // kUnknownEnumValue intentionally not defined. This enum never goes
    // through DataModel::Decode, likely because it is a part of a derived
    // cluster. As a result having kUnknownEnumValue in this enum is error
    // prone, and was removed. See
    // src/app/common/templates/config-data.yaml.
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOnOff = 0x1,
};
} // namespace DeviceEnergyManagementMode

namespace DoorLock {

// Enum for AlarmCodeEnum
enum class AlarmCodeEnum : uint8_t
{
    kLockJammed              = 0x00,
    kLockFactoryReset        = 0x01,
    kLockRadioPowerCycled    = 0x03,
    kWrongCodeEntryLimit     = 0x04,
    kFrontEsceutcheonRemoved = 0x05,
    kDoorForcedOpen          = 0x06,
    kDoorAjar                = 0x07,
    kForcedUser              = 0x08,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for CredentialRuleEnum
enum class CredentialRuleEnum : uint8_t
{
    kSingle = 0x00,
    kDual   = 0x01,
    kTri    = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for CredentialTypeEnum
enum class CredentialTypeEnum : uint8_t
{
    kProgrammingPIN               = 0x00,
    kPin                          = 0x01,
    kRfid                         = 0x02,
    kFingerprint                  = 0x03,
    kFingerVein                   = 0x04,
    kFace                         = 0x05,
    kAliroCredentialIssuerKey     = 0x06,
    kAliroEvictableEndpointKey    = 0x07,
    kAliroNonEvictableEndpointKey = 0x08,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 9,
};

// Enum for DataOperationTypeEnum
enum class DataOperationTypeEnum : uint8_t
{
    kAdd    = 0x00,
    kClear  = 0x01,
    kModify = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for DlLockState
enum class DlLockState : uint8_t
{
    kNotFullyLocked = 0x00,
    kLocked         = 0x01,
    kUnlocked       = 0x02,
    kUnlatched      = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for DlLockType
enum class DlLockType : uint8_t
{
    kDeadBolt           = 0x00,
    kMagnetic           = 0x01,
    kOther              = 0x02,
    kMortise            = 0x03,
    kRim                = 0x04,
    kLatchBolt          = 0x05,
    kCylindricalLock    = 0x06,
    kTubularLock        = 0x07,
    kInterconnectedLock = 0x08,
    kDeadLatch          = 0x09,
    kDoorFurniture      = 0x0A,
    kEurocylinder       = 0x0B,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 12,
};

// Enum for DlStatus
enum class DlStatus : uint8_t
{
    kSuccess           = 0x00,
    kFailure           = 0x01,
    kDuplicate         = 0x02,
    kOccupied          = 0x03,
    kInvalidField      = 0x85,
    kResourceExhausted = 0x89,
    kNotFound          = 0x8B,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for DoorLockOperationEventCode
enum class DoorLockOperationEventCode : uint8_t
{
    kUnknownOrMfgSpecific  = 0x00,
    kLock                  = 0x01,
    kUnlock                = 0x02,
    kLockInvalidPinOrId    = 0x03,
    kLockInvalidSchedule   = 0x04,
    kUnlockInvalidPinOrId  = 0x05,
    kUnlockInvalidSchedule = 0x06,
    kOneTouchLock          = 0x07,
    kKeyLock               = 0x08,
    kKeyUnlock             = 0x09,
    kAutoLock              = 0x0A,
    kScheduleLock          = 0x0B,
    kScheduleUnlock        = 0x0C,
    kManualLock            = 0x0D,
    kManualUnlock          = 0x0E,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 15,
};

// Enum for DoorLockProgrammingEventCode
enum class DoorLockProgrammingEventCode : uint8_t
{
    kUnknownOrMfgSpecific = 0x00,
    kMasterCodeChanged    = 0x01,
    kPinAdded             = 0x02,
    kPinDeleted           = 0x03,
    kPinChanged           = 0x04,
    kIdAdded              = 0x05,
    kIdDeleted            = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for DoorLockSetPinOrIdStatus
enum class DoorLockSetPinOrIdStatus : uint8_t
{
    kSuccess            = 0x00,
    kGeneralFailure     = 0x01,
    kMemoryFull         = 0x02,
    kDuplicateCodeError = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for DoorLockUserStatus
enum class DoorLockUserStatus : uint8_t
{
    kAvailable        = 0x00,
    kOccupiedEnabled  = 0x01,
    kOccupiedDisabled = 0x03,
    kNotSupported     = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for DoorLockUserType
enum class DoorLockUserType : uint8_t
{
    kUnrestricted        = 0x00,
    kYearDayScheduleUser = 0x01,
    kWeekDayScheduleUser = 0x02,
    kMasterUser          = 0x03,
    kNonAccessUser       = 0x04,
    kNotSupported        = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for DoorStateEnum
enum class DoorStateEnum : uint8_t
{
    kDoorOpen             = 0x00,
    kDoorClosed           = 0x01,
    kDoorJammed           = 0x02,
    kDoorForcedOpen       = 0x03,
    kDoorUnspecifiedError = 0x04,
    kDoorAjar             = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Enum for LockDataTypeEnum
enum class LockDataTypeEnum : uint8_t
{
    kUnspecified                  = 0x00,
    kProgrammingCode              = 0x01,
    kUserIndex                    = 0x02,
    kWeekDaySchedule              = 0x03,
    kYearDaySchedule              = 0x04,
    kHolidaySchedule              = 0x05,
    kPin                          = 0x06,
    kRfid                         = 0x07,
    kFingerprint                  = 0x08,
    kFingerVein                   = 0x09,
    kFace                         = 0x0A,
    kAliroCredentialIssuerKey     = 0x0B,
    kAliroEvictableEndpointKey    = 0x0C,
    kAliroNonEvictableEndpointKey = 0x0D,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 14,
};

// Enum for LockOperationTypeEnum
enum class LockOperationTypeEnum : uint8_t
{
    kLock               = 0x00,
    kUnlock             = 0x01,
    kNonAccessUserEvent = 0x02,
    kForcedUserEvent    = 0x03,
    kUnlatch            = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for OperatingModeEnum
enum class OperatingModeEnum : uint8_t
{
    kNormal             = 0x00,
    kVacation           = 0x01,
    kPrivacy            = 0x02,
    kNoRemoteLockUnlock = 0x03,
    kPassage            = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for OperationErrorEnum
enum class OperationErrorEnum : uint8_t
{
    kUnspecified         = 0x00,
    kInvalidCredential   = 0x01,
    kDisabledUserDenied  = 0x02,
    kRestricted          = 0x03,
    kInsufficientBattery = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for OperationSourceEnum
enum class OperationSourceEnum : uint8_t
{
    kUnspecified       = 0x00,
    kManual            = 0x01,
    kProprietaryRemote = 0x02,
    kKeypad            = 0x03,
    kAuto              = 0x04,
    kButton            = 0x05,
    kSchedule          = 0x06,
    kRemote            = 0x07,
    kRfid              = 0x08,
    kBiometric         = 0x09,
    kAliro             = 0x0A,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 11,
};

// Enum for UserStatusEnum
enum class UserStatusEnum : uint8_t
{
    kAvailable        = 0x00,
    kOccupiedEnabled  = 0x01,
    kOccupiedDisabled = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for UserTypeEnum
enum class UserTypeEnum : uint8_t
{
    kUnrestrictedUser       = 0x00,
    kYearDayScheduleUser    = 0x01,
    kWeekDayScheduleUser    = 0x02,
    kProgrammingUser        = 0x03,
    kNonAccessUser          = 0x04,
    kForcedUser             = 0x05,
    kDisposableUser         = 0x06,
    kExpiringUser           = 0x07,
    kScheduleRestrictedUser = 0x08,
    kRemoteOnlyUser         = 0x09,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Bitmap for DaysMaskMap
enum class DaysMaskMap : uint8_t
{
    kSunday    = 0x1,
    kMonday    = 0x2,
    kTuesday   = 0x4,
    kWednesday = 0x8,
    kThursday  = 0x10,
    kFriday    = 0x20,
    kSaturday  = 0x40,
};

// Bitmap for DlCredentialRuleMask
enum class DlCredentialRuleMask : uint8_t
{
    kSingle = 0x1,
    kDual   = 0x2,
    kTri    = 0x4,
};

// Bitmap for DlCredentialRulesSupport
enum class DlCredentialRulesSupport : uint8_t
{
    kSingle = 0x1,
    kDual   = 0x2,
    kTri    = 0x4,
};

// Bitmap for DlDefaultConfigurationRegister
enum class DlDefaultConfigurationRegister : uint16_t
{
    kEnableLocalProgrammingEnabled         = 0x1,
    kKeypadInterfaceDefaultAccessEnabled   = 0x2,
    kRemoteInterfaceDefaultAccessIsEnabled = 0x4,
    kSoundEnabled                          = 0x20,
    kAutoRelockTimeSet                     = 0x40,
    kLEDSettingsSet                        = 0x80,
};

// Bitmap for DlKeypadOperationEventMask
enum class DlKeypadOperationEventMask : uint16_t
{
    kUnknown               = 0x1,
    kLock                  = 0x2,
    kUnlock                = 0x4,
    kLockInvalidPIN        = 0x8,
    kLockInvalidSchedule   = 0x10,
    kUnlockInvalidCode     = 0x20,
    kUnlockInvalidSchedule = 0x40,
    kNonAccessUserOpEvent  = 0x80,
};

// Bitmap for DlKeypadProgrammingEventMask
enum class DlKeypadProgrammingEventMask : uint16_t
{
    kUnknown               = 0x1,
    kProgrammingPINChanged = 0x2,
    kPINAdded              = 0x4,
    kPINCleared            = 0x8,
    kPINChanged            = 0x10,
};

// Bitmap for DlLocalProgrammingFeatures
enum class DlLocalProgrammingFeatures : uint8_t
{
    kAddUsersCredentialsSchedulesLocally    = 0x1,
    kModifyUsersCredentialsSchedulesLocally = 0x2,
    kClearUsersCredentialsSchedulesLocally  = 0x4,
    kAdjustLockSettingsLocally              = 0x8,
};

// Bitmap for DlManualOperationEventMask
enum class DlManualOperationEventMask : uint16_t
{
    kUnknown         = 0x1,
    kThumbturnLock   = 0x2,
    kThumbturnUnlock = 0x4,
    kOneTouchLock    = 0x8,
    kKeyLock         = 0x10,
    kKeyUnlock       = 0x20,
    kAutoLock        = 0x40,
    kScheduleLock    = 0x80,
    kScheduleUnlock  = 0x100,
    kManualLock      = 0x200,
    kManualUnlock    = 0x400,
};

// Bitmap for DlRFIDOperationEventMask
enum class DlRFIDOperationEventMask : uint16_t
{
    kUnknown               = 0x1,
    kLock                  = 0x2,
    kUnlock                = 0x4,
    kLockInvalidRFID       = 0x8,
    kLockInvalidSchedule   = 0x10,
    kUnlockInvalidRFID     = 0x20,
    kUnlockInvalidSchedule = 0x40,
};

// Bitmap for DlRFIDProgrammingEventMask
enum class DlRFIDProgrammingEventMask : uint16_t
{
    kUnknown         = 0x1,
    kRFIDCodeAdded   = 0x20,
    kRFIDCodeCleared = 0x40,
};

// Bitmap for DlRemoteOperationEventMask
enum class DlRemoteOperationEventMask : uint16_t
{
    kUnknown               = 0x1,
    kLock                  = 0x2,
    kUnlock                = 0x4,
    kLockInvalidCode       = 0x8,
    kLockInvalidSchedule   = 0x10,
    kUnlockInvalidCode     = 0x20,
    kUnlockInvalidSchedule = 0x40,
};

// Bitmap for DlRemoteProgrammingEventMask
enum class DlRemoteProgrammingEventMask : uint16_t
{
    kUnknown               = 0x1,
    kProgrammingPINChanged = 0x2,
    kPINAdded              = 0x4,
    kPINCleared            = 0x8,
    kPINChanged            = 0x10,
    kRFIDCodeAdded         = 0x20,
    kRFIDCodeCleared       = 0x40,
};

// Bitmap for DlSupportedOperatingModes
enum class DlSupportedOperatingModes : uint16_t
{
    kNormal             = 0x1,
    kVacation           = 0x2,
    kPrivacy            = 0x4,
    kNoRemoteLockUnlock = 0x8,
    kPassage            = 0x10,
};

// Bitmap for DoorLockDayOfWeek
enum class DoorLockDayOfWeek : uint8_t
{
    kSunday    = 0x1,
    kMonday    = 0x2,
    kTuesday   = 0x4,
    kWednesday = 0x8,
    kThursday  = 0x10,
    kFriday    = 0x20,
    kSaturday  = 0x40,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPinCredential               = 0x1,
    kRfidCredential              = 0x2,
    kFingerCredentials           = 0x4,
    kLogging                     = 0x8,
    kWeekDayAccessSchedules      = 0x10,
    kDoorPositionSensor          = 0x20,
    kFaceCredentials             = 0x40,
    kCredentialsOverTheAirAccess = 0x80,
    kUser                        = 0x100,
    kNotification                = 0x200,
    kYearDayAccessSchedules      = 0x400,
    kHolidaySchedules            = 0x800,
    kUnbolt                      = 0x1000,
    kAliroProvisioning           = 0x2000,
    kAliroBLEUWB                 = 0x4000,
};
} // namespace DoorLock

namespace WindowCovering {

// Enum for EndProductType
enum class EndProductType : uint8_t
{
    kRollerShade               = 0x00,
    kRomanShade                = 0x01,
    kBalloonShade              = 0x02,
    kWovenWood                 = 0x03,
    kPleatedShade              = 0x04,
    kCellularShade             = 0x05,
    kLayeredShade              = 0x06,
    kLayeredShade2D            = 0x07,
    kSheerShade                = 0x08,
    kTiltOnlyInteriorBlind     = 0x09,
    kInteriorBlind             = 0x0A,
    kVerticalBlindStripCurtain = 0x0B,
    kInteriorVenetianBlind     = 0x0C,
    kExteriorVenetianBlind     = 0x0D,
    kLateralLeftCurtain        = 0x0E,
    kLateralRightCurtain       = 0x0F,
    kCentralCurtain            = 0x10,
    kRollerShutter             = 0x11,
    kExteriorVerticalScreen    = 0x12,
    kAwningTerracePatio        = 0x13,
    kAwningVerticalScreen      = 0x14,
    kTiltOnlyPergola           = 0x15,
    kSwingingShutter           = 0x16,
    kSlidingShutter            = 0x17,
    kUnknown                   = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 24,
};

// Enum for Type
enum class Type : uint8_t
{
    kRollerShade               = 0x00,
    kRollerShade2Motor         = 0x01,
    kRollerShadeExterior       = 0x02,
    kRollerShadeExterior2Motor = 0x03,
    kDrapery                   = 0x04,
    kAwning                    = 0x05,
    kShutter                   = 0x06,
    kTiltBlindTiltOnly         = 0x07,
    kTiltBlindLiftAndTilt      = 0x08,
    kProjectorScreen           = 0x09,
    kUnknown                   = 0xFF,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 10,
};

// Bitmap for ConfigStatus
enum class ConfigStatus : uint8_t
{
    kOperational           = 0x1,
    kOnlineReserved        = 0x2,
    kLiftMovementReversed  = 0x4,
    kLiftPositionAware     = 0x8,
    kTiltPositionAware     = 0x10,
    kLiftEncoderControlled = 0x20,
    kTiltEncoderControlled = 0x40,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kLift              = 0x1,
    kTilt              = 0x2,
    kPositionAwareLift = 0x4,
    kAbsolutePosition  = 0x8,
    kPositionAwareTilt = 0x10,
};

// Bitmap for Mode
enum class Mode : uint8_t
{
    kMotorDirectionReversed = 0x1,
    kCalibrationMode        = 0x2,
    kMaintenanceMode        = 0x4,
    kLedFeedback            = 0x8,
};

// Bitmap for OperationalStatus
enum class OperationalStatus : uint8_t
{
    kGlobal = 0x3,
    kLift   = 0xC,
    kTilt   = 0x30,
};

// Bitmap for SafetyStatus
enum class SafetyStatus : uint16_t
{
    kRemoteLockout       = 0x1,
    kTamperDetection     = 0x2,
    kFailedCommunication = 0x4,
    kPositionFailure     = 0x8,
    kThermalProtection   = 0x10,
    kObstacleDetected    = 0x20,
    kPower               = 0x40,
    kStopInput           = 0x80,
    kMotorJammed         = 0x100,
    kHardwareFailure     = 0x200,
    kManualOperation     = 0x400,
    kProtection          = 0x800,
};
} // namespace WindowCovering

namespace ServiceArea {

// Enum for OperationalStatusEnum
enum class OperationalStatusEnum : uint8_t
{
    kPending   = 0x00,
    kOperating = 0x01,
    kSkipped   = 0x02,
    kCompleted = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for SelectAreasStatus
enum class SelectAreasStatus : uint8_t
{
    kSuccess         = 0x00,
    kUnsupportedArea = 0x01,
    kInvalidInMode   = 0x02,
    kInvalidSet      = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for SkipAreaStatus
enum class SkipAreaStatus : uint8_t
{
    kSuccess            = 0x00,
    kInvalidAreaList    = 0x01,
    kInvalidInMode      = 0x02,
    kInvalidSkippedArea = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kSelectWhileRunning = 0x1,
    kProgressReporting  = 0x2,
    kMaps               = 0x4,
};
} // namespace ServiceArea

namespace PumpConfigurationAndControl {

// Enum for ControlModeEnum
enum class ControlModeEnum : uint8_t
{
    kConstantSpeed        = 0x00,
    kConstantPressure     = 0x01,
    kProportionalPressure = 0x02,
    kConstantFlow         = 0x03,
    kConstantTemperature  = 0x05,
    kAutomatic            = 0x07,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for OperationModeEnum
enum class OperationModeEnum : uint8_t
{
    kNormal  = 0x00,
    kMinimum = 0x01,
    kMaximum = 0x02,
    kLocal   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kConstantPressure    = 0x1,
    kCompensatedPressure = 0x2,
    kConstantFlow        = 0x4,
    kConstantSpeed       = 0x8,
    kConstantTemperature = 0x10,
    kAutomatic           = 0x20,
    kLocalOperation      = 0x40,
};

// Bitmap for PumpStatusBitmap
enum class PumpStatusBitmap : uint16_t
{
    kDeviceFault       = 0x1,
    kSupplyFault       = 0x2,
    kSpeedLow          = 0x4,
    kSpeedHigh         = 0x8,
    kLocalOverride     = 0x10,
    kRunning           = 0x20,
    kRemotePressure    = 0x40,
    kRemoteFlow        = 0x80,
    kRemoteTemperature = 0x100,
};
} // namespace PumpConfigurationAndControl

namespace Thermostat {

// Enum for ACCapacityFormatEnum
enum class ACCapacityFormatEnum : uint8_t
{
    kBTUh = 0x00,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 1,
};

// Enum for ACCompressorTypeEnum
enum class ACCompressorTypeEnum : uint8_t
{
    kUnknown = 0x00,
    kT1      = 0x01,
    kT2      = 0x02,
    kT3      = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ACLouverPositionEnum
enum class ACLouverPositionEnum : uint8_t
{
    kClosed        = 0x01,
    kOpen          = 0x02,
    kQuarter       = 0x03,
    kHalf          = 0x04,
    kThreeQuarters = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for ACRefrigerantTypeEnum
enum class ACRefrigerantTypeEnum : uint8_t
{
    kUnknown = 0x00,
    kR22     = 0x01,
    kR410a   = 0x02,
    kR407c   = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for ACTypeEnum
enum class ACTypeEnum : uint8_t
{
    kUnknown          = 0x00,
    kCoolingFixed     = 0x01,
    kHeatPumpFixed    = 0x02,
    kCoolingInverter  = 0x03,
    kHeatPumpInverter = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for ControlSequenceOfOperationEnum
enum class ControlSequenceOfOperationEnum : uint8_t
{
    kCoolingOnly                 = 0x00,
    kCoolingWithReheat           = 0x01,
    kHeatingOnly                 = 0x02,
    kHeatingWithReheat           = 0x03,
    kCoolingAndHeating           = 0x04,
    kCoolingAndHeatingWithReheat = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Enum for PresetScenarioEnum
enum class PresetScenarioEnum : uint8_t
{
    kOccupied     = 0x01,
    kUnoccupied   = 0x02,
    kSleep        = 0x03,
    kWake         = 0x04,
    kVacation     = 0x05,
    kGoingToSleep = 0x06,
    kUserDefined  = 0xFE,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Enum for SetpointChangeSourceEnum
enum class SetpointChangeSourceEnum : uint8_t
{
    kManual   = 0x00,
    kSchedule = 0x01,
    kExternal = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for SetpointRaiseLowerModeEnum
enum class SetpointRaiseLowerModeEnum : uint8_t
{
    kHeat = 0x00,
    kCool = 0x01,
    kBoth = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for StartOfWeekEnum
enum class StartOfWeekEnum : uint8_t
{
    kSunday    = 0x00,
    kMonday    = 0x01,
    kTuesday   = 0x02,
    kWednesday = 0x03,
    kThursday  = 0x04,
    kFriday    = 0x05,
    kSaturday  = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for SystemModeEnum
enum class SystemModeEnum : uint8_t
{
    kOff           = 0x00,
    kAuto          = 0x01,
    kCool          = 0x03,
    kHeat          = 0x04,
    kEmergencyHeat = 0x05,
    kPrecooling    = 0x06,
    kFanOnly       = 0x07,
    kDry           = 0x08,
    kSleep         = 0x09,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for TemperatureSetpointHoldEnum
enum class TemperatureSetpointHoldEnum : uint8_t
{
    kSetpointHoldOff = 0x00,
    kSetpointHoldOn  = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for ThermostatRunningModeEnum
enum class ThermostatRunningModeEnum : uint8_t
{
    kOff  = 0x00,
    kCool = 0x03,
    kHeat = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 1,
};

// Bitmap for ACErrorCodeBitmap
enum class ACErrorCodeBitmap : uint32_t
{
    kCompressorFail    = 0x1,
    kRoomSensorFail    = 0x2,
    kOutdoorSensorFail = 0x4,
    kCoilSensorFail    = 0x8,
    kFanFail           = 0x10,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kHeating                     = 0x1,
    kCooling                     = 0x2,
    kOccupancy                   = 0x4,
    kScheduleConfiguration       = 0x8,
    kSetback                     = 0x10,
    kAutoMode                    = 0x20,
    kLocalTemperatureNotExposed  = 0x40,
    kMatterScheduleConfiguration = 0x80,
    kPresets                     = 0x100,
};

// Bitmap for HVACSystemTypeBitmap
enum class HVACSystemTypeBitmap : uint8_t
{
    kCoolingStage      = 0x3,
    kHeatingStage      = 0xC,
    kHeatingIsHeatPump = 0x10,
    kHeatingUsesFuel   = 0x20,
};

// Bitmap for OccupancyBitmap
enum class OccupancyBitmap : uint8_t
{
    kOccupied = 0x1,
};

// Bitmap for PresetTypeFeaturesBitmap
enum class PresetTypeFeaturesBitmap : uint16_t
{
    kAutomatic     = 0x1,
    kSupportsNames = 0x2,
};

// Bitmap for ProgrammingOperationModeBitmap
enum class ProgrammingOperationModeBitmap : uint8_t
{
    kScheduleActive = 0x1,
    kAutoRecovery   = 0x2,
    kEconomy        = 0x4,
};

// Bitmap for RelayStateBitmap
enum class RelayStateBitmap : uint16_t
{
    kHeat       = 0x1,
    kCool       = 0x2,
    kFan        = 0x4,
    kHeatStage2 = 0x8,
    kCoolStage2 = 0x10,
    kFanStage2  = 0x20,
    kFanStage3  = 0x40,
};

// Bitmap for RemoteSensingBitmap
enum class RemoteSensingBitmap : uint8_t
{
    kLocalTemperature   = 0x1,
    kOutdoorTemperature = 0x2,
    kOccupancy          = 0x4,
};

// Bitmap for ScheduleDayOfWeekBitmap
enum class ScheduleDayOfWeekBitmap : uint8_t
{
    kSunday    = 0x1,
    kMonday    = 0x2,
    kTuesday   = 0x4,
    kWednesday = 0x8,
    kThursday  = 0x10,
    kFriday    = 0x20,
    kSaturday  = 0x40,
    kAway      = 0x80,
};

// Bitmap for ScheduleModeBitmap
enum class ScheduleModeBitmap : uint8_t
{
    kHeatSetpointPresent = 0x1,
    kCoolSetpointPresent = 0x2,
};

// Bitmap for ScheduleTypeFeaturesBitmap
enum class ScheduleTypeFeaturesBitmap : uint16_t
{
    kSupportsPresets   = 0x1,
    kSupportsSetpoints = 0x2,
    kSupportsNames     = 0x4,
    kSupportsOff       = 0x8,
};
} // namespace Thermostat

namespace FanControl {

// Enum for AirflowDirectionEnum
enum class AirflowDirectionEnum : uint8_t
{
    kForward = 0x00,
    kReverse = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for FanModeEnum
enum class FanModeEnum : uint8_t
{
    kOff    = 0x00,
    kLow    = 0x01,
    kMedium = 0x02,
    kHigh   = 0x03,
    kOn     = 0x04,
    kAuto   = 0x05,
    kSmart  = 0x06,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 7,
};

// Enum for FanModeSequenceEnum
enum class FanModeSequenceEnum : uint8_t
{
    kOffLowMedHigh     = 0x00,
    kOffLowHigh        = 0x01,
    kOffLowMedHighAuto = 0x02,
    kOffLowHighAuto    = 0x03,
    kOffHighAuto       = 0x04,
    kOffHigh           = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Enum for StepDirectionEnum
enum class StepDirectionEnum : uint8_t
{
    kIncrease = 0x00,
    kDecrease = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kMultiSpeed       = 0x1,
    kAuto             = 0x2,
    kRocking          = 0x4,
    kWind             = 0x8,
    kStep             = 0x10,
    kAirflowDirection = 0x20,
};

// Bitmap for RockBitmap
enum class RockBitmap : uint8_t
{
    kRockLeftRight = 0x1,
    kRockUpDown    = 0x2,
    kRockRound     = 0x4,
};

// Bitmap for WindBitmap
enum class WindBitmap : uint8_t
{
    kSleepWind   = 0x1,
    kNaturalWind = 0x2,
};
} // namespace FanControl

namespace ThermostatUserInterfaceConfiguration {

// Enum for KeypadLockoutEnum
enum class KeypadLockoutEnum : uint8_t
{
    kNoLockout = 0x00,
    kLockout1  = 0x01,
    kLockout2  = 0x02,
    kLockout3  = 0x03,
    kLockout4  = 0x04,
    kLockout5  = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Enum for ScheduleProgrammingVisibilityEnum
enum class ScheduleProgrammingVisibilityEnum : uint8_t
{
    kScheduleProgrammingPermitted = 0x00,
    kScheduleProgrammingDenied    = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for TemperatureDisplayModeEnum
enum class TemperatureDisplayModeEnum : uint8_t
{
    kCelsius    = 0x00,
    kFahrenheit = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};
} // namespace ThermostatUserInterfaceConfiguration

namespace ColorControl {

// Enum for ColorLoopActionEnum
enum class ColorLoopActionEnum : uint8_t
{
    kDeactivate                            = 0x00,
    kActivateFromColorLoopStartEnhancedHue = 0x01,
    kActivateFromEnhancedCurrentHue        = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for ColorLoopDirectionEnum
enum class ColorLoopDirectionEnum : uint8_t
{
    kDecrement = 0x00,
    kIncrement = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for ColorModeEnum
enum class ColorModeEnum : uint8_t
{
    kCurrentHueAndCurrentSaturation = 0x00,
    kCurrentXAndCurrentY            = 0x01,
    kColorTemperatureMireds         = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Enum for DirectionEnum
enum class DirectionEnum : uint8_t
{
    kShortest = 0x00,
    kLongest  = 0x01,
    kUp       = 0x02,
    kDown     = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for DriftCompensationEnum
enum class DriftCompensationEnum : uint8_t
{
    kNone                                  = 0x00,
    kOtherOrUnknown                        = 0x01,
    kTemperatureMonitoring                 = 0x02,
    kOpticalLuminanceMonitoringAndFeedback = 0x03,
    kOpticalColorMonitoringAndFeedback     = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Enum for EnhancedColorModeEnum
enum class EnhancedColorModeEnum : uint8_t
{
    kCurrentHueAndCurrentSaturation         = 0x00,
    kCurrentXAndCurrentY                    = 0x01,
    kColorTemperatureMireds                 = 0x02,
    kEnhancedCurrentHueAndCurrentSaturation = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for MoveModeEnum
enum class MoveModeEnum : uint8_t
{
    kStop = 0x00,
    kUp   = 0x01,
    kDown = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for StepModeEnum
enum class StepModeEnum : uint8_t
{
    kUp   = 0x01,
    kDown = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 0,
};

// Bitmap for ColorCapabilitiesBitmap
enum class ColorCapabilitiesBitmap : uint16_t
{
    kHueSaturation    = 0x1,
    kEnhancedHue      = 0x2,
    kColorLoop        = 0x4,
    kXy               = 0x8,
    kColorTemperature = 0x10,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kHueAndSaturation = 0x1,
    kEnhancedHue      = 0x2,
    kColorLoop        = 0x4,
    kXy               = 0x8,
    kColorTemperature = 0x10,
};

// Bitmap for OptionsBitmap
enum class OptionsBitmap : uint8_t
{
    kExecuteIfOff = 0x1,
};

// Bitmap for UpdateFlagsBitmap
enum class UpdateFlagsBitmap : uint8_t
{
    kUpdateAction    = 0x1,
    kUpdateDirection = 0x2,
    kUpdateTime      = 0x4,
    kUpdateStartHue  = 0x8,
};
} // namespace ColorControl

namespace BallastConfiguration {

// Bitmap for BallastStatusBitmap
enum class BallastStatusBitmap : uint8_t
{
    kBallastNonOperational = 0x1,
    kLampFailure           = 0x2,
};

// Bitmap for LampAlarmModeBitmap
enum class LampAlarmModeBitmap : uint8_t
{
    kLampBurnHours = 0x1,
};
} // namespace BallastConfiguration

namespace IlluminanceMeasurement {

// Enum for LightSensorTypeEnum
enum class LightSensorTypeEnum : uint8_t
{
    kPhotodiode = 0x00,
    kCmos       = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};
} // namespace IlluminanceMeasurement

namespace TemperatureMeasurement {} // namespace TemperatureMeasurement

namespace PressureMeasurement {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kExtended = 0x1,
};
} // namespace PressureMeasurement

namespace FlowMeasurement {} // namespace FlowMeasurement

namespace RelativeHumidityMeasurement {} // namespace RelativeHumidityMeasurement

namespace OccupancySensing {

// Enum for OccupancySensorTypeEnum
enum class OccupancySensorTypeEnum : uint8_t
{
    kPir              = 0x00,
    kUltrasonic       = 0x01,
    kPIRAndUltrasonic = 0x02,
    kPhysicalContact  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kOther           = 0x1,
    kPassiveInfrared = 0x2,
    kUltrasonic      = 0x4,
    kPhysicalContact = 0x8,
    kActiveInfrared  = 0x10,
    kRadar           = 0x20,
    kRFSensing       = 0x40,
    kVision          = 0x80,
};

// Bitmap for OccupancyBitmap
enum class OccupancyBitmap : uint8_t
{
    kOccupied = 0x1,
};

// Bitmap for OccupancySensorTypeBitmap
enum class OccupancySensorTypeBitmap : uint8_t
{
    kPir             = 0x1,
    kUltrasonic      = 0x2,
    kPhysicalContact = 0x4,
};
} // namespace OccupancySensing

namespace CarbonMonoxideConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace CarbonMonoxideConcentrationMeasurement

namespace CarbonDioxideConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace CarbonDioxideConcentrationMeasurement

namespace NitrogenDioxideConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace NitrogenDioxideConcentrationMeasurement

namespace OzoneConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace OzoneConcentrationMeasurement

namespace Pm25ConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace Pm25ConcentrationMeasurement

namespace FormaldehydeConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace FormaldehydeConcentrationMeasurement

namespace Pm1ConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace Pm1ConcentrationMeasurement

namespace Pm10ConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace Pm10ConcentrationMeasurement

namespace TotalVolatileOrganicCompoundsConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace TotalVolatileOrganicCompoundsConcentrationMeasurement

namespace RadonConcentrationMeasurement {

using LevelValueEnum = Clusters::detail::LevelValueEnum;

using MeasurementMediumEnum = Clusters::detail::MeasurementMediumEnum;

using MeasurementUnitEnum = Clusters::detail::MeasurementUnitEnum;

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNumericMeasurement = 0x1,
    kLevelIndication    = 0x2,
    kMediumLevel        = 0x4,
    kCriticalLevel      = 0x8,
    kPeakMeasurement    = 0x10,
    kAverageMeasurement = 0x20,
};
} // namespace RadonConcentrationMeasurement

namespace WiFiNetworkManagement {} // namespace WiFiNetworkManagement

namespace ThreadBorderRouterManagement {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kPANChange = 0x1,
};
} // namespace ThreadBorderRouterManagement

namespace ThreadNetworkDirectory {} // namespace ThreadNetworkDirectory

namespace WakeOnLan {} // namespace WakeOnLan

namespace Channel {

// Enum for ChannelTypeEnum
enum class ChannelTypeEnum : uint8_t
{
    kSatellite   = 0x00,
    kCable       = 0x01,
    kTerrestrial = 0x02,
    kOtt         = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for LineupInfoTypeEnum
enum class LineupInfoTypeEnum : uint8_t
{
    kMso = 0x00,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 1,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess         = 0x00,
    kMultipleMatches = 0x01,
    kNoMatches       = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kChannelList     = 0x1,
    kLineupInfo      = 0x2,
    kElectronicGuide = 0x4,
    kRecordProgram   = 0x8,
};

// Bitmap for RecordingFlagBitmap
enum class RecordingFlagBitmap : uint32_t
{
    kScheduled    = 0x1,
    kRecordSeries = 0x2,
    kRecorded     = 0x4,
};
} // namespace Channel

namespace TargetNavigator {

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess        = 0x00,
    kTargetNotFound = 0x01,
    kNotAllowed     = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};
} // namespace TargetNavigator

namespace MediaPlayback {

// Enum for CharacteristicEnum
enum class CharacteristicEnum : uint8_t
{
    kForcedSubtitles              = 0x00,
    kDescribesVideo               = 0x01,
    kEasyToRead                   = 0x02,
    kFrameBased                   = 0x03,
    kMainProgram                  = 0x04,
    kOriginalContent              = 0x05,
    kVoiceOverTranslation         = 0x06,
    kCaption                      = 0x07,
    kSubtitle                     = 0x08,
    kAlternate                    = 0x09,
    kSupplementary                = 0x0A,
    kCommentary                   = 0x0B,
    kDubbedTranslation            = 0x0C,
    kDescription                  = 0x0D,
    kMetadata                     = 0x0E,
    kEnhancedAudioIntelligibility = 0x0F,
    kEmergency                    = 0x10,
    kKaraoke                      = 0x11,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 18,
};

// Enum for PlaybackStateEnum
enum class PlaybackStateEnum : uint8_t
{
    kPlaying    = 0x00,
    kPaused     = 0x01,
    kNotPlaying = 0x02,
    kBuffering  = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess                = 0x00,
    kInvalidStateForCommand = 0x01,
    kNotAllowed             = 0x02,
    kNotActive              = 0x03,
    kSpeedOutOfRange        = 0x04,
    kSeekOutOfRange         = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kAdvancedSeek  = 0x1,
    kVariableSpeed = 0x2,
    kTextTracks    = 0x4,
    kAudioTracks   = 0x8,
    kAudioAdvance  = 0x10,
};
} // namespace MediaPlayback

namespace MediaInput {

// Enum for InputTypeEnum
enum class InputTypeEnum : uint8_t
{
    kInternal  = 0x00,
    kAux       = 0x01,
    kCoax      = 0x02,
    kComposite = 0x03,
    kHdmi      = 0x04,
    kInput     = 0x05,
    kLine      = 0x06,
    kOptical   = 0x07,
    kVideo     = 0x08,
    kScart     = 0x09,
    kUsb       = 0x0A,
    kOther     = 0x0B,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 12,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNameUpdates = 0x1,
};
} // namespace MediaInput

namespace LowPower {} // namespace LowPower

namespace KeypadInput {

// Enum for CECKeyCodeEnum
enum class CECKeyCodeEnum : uint8_t
{
    kSelect                    = 0x00,
    kUp                        = 0x01,
    kDown                      = 0x02,
    kLeft                      = 0x03,
    kRight                     = 0x04,
    kRightUp                   = 0x05,
    kRightDown                 = 0x06,
    kLeftUp                    = 0x07,
    kLeftDown                  = 0x08,
    kRootMenu                  = 0x09,
    kSetupMenu                 = 0x0A,
    kContentsMenu              = 0x0B,
    kFavoriteMenu              = 0x0C,
    kExit                      = 0x0D,
    kMediaTopMenu              = 0x10,
    kMediaContextSensitiveMenu = 0x11,
    kNumberEntryMode           = 0x1D,
    kNumber11                  = 0x1E,
    kNumber12                  = 0x1F,
    kNumber0OrNumber10         = 0x20,
    kNumbers1                  = 0x21,
    kNumbers2                  = 0x22,
    kNumbers3                  = 0x23,
    kNumbers4                  = 0x24,
    kNumbers5                  = 0x25,
    kNumbers6                  = 0x26,
    kNumbers7                  = 0x27,
    kNumbers8                  = 0x28,
    kNumbers9                  = 0x29,
    kDot                       = 0x2A,
    kEnter                     = 0x2B,
    kClear                     = 0x2C,
    kNextFavorite              = 0x2F,
    kChannelUp                 = 0x30,
    kChannelDown               = 0x31,
    kPreviousChannel           = 0x32,
    kSoundSelect               = 0x33,
    kInputSelect               = 0x34,
    kDisplayInformation        = 0x35,
    kHelp                      = 0x36,
    kPageUp                    = 0x37,
    kPageDown                  = 0x38,
    kPower                     = 0x40,
    kVolumeUp                  = 0x41,
    kVolumeDown                = 0x42,
    kMute                      = 0x43,
    kPlay                      = 0x44,
    kStop                      = 0x45,
    kPause                     = 0x46,
    kRecord                    = 0x47,
    kRewind                    = 0x48,
    kFastForward               = 0x49,
    kEject                     = 0x4A,
    kForward                   = 0x4B,
    kBackward                  = 0x4C,
    kStopRecord                = 0x4D,
    kPauseRecord               = 0x4E,
    kReserved                  = 0x4F,
    kAngle                     = 0x50,
    kSubPicture                = 0x51,
    kVideoOnDemand             = 0x52,
    kElectronicProgramGuide    = 0x53,
    kTimerProgramming          = 0x54,
    kInitialConfiguration      = 0x55,
    kSelectBroadcastType       = 0x56,
    kSelectSoundPresentation   = 0x57,
    kPlayFunction              = 0x60,
    kPausePlayFunction         = 0x61,
    kRecordFunction            = 0x62,
    kPauseRecordFunction       = 0x63,
    kStopFunction              = 0x64,
    kMuteFunction              = 0x65,
    kRestoreVolumeFunction     = 0x66,
    kTuneFunction              = 0x67,
    kSelectMediaFunction       = 0x68,
    kSelectAvInputFunction     = 0x69,
    kSelectAudioInputFunction  = 0x6A,
    kPowerToggleFunction       = 0x6B,
    kPowerOffFunction          = 0x6C,
    kPowerOnFunction           = 0x6D,
    kF1Blue                    = 0x71,
    kF2Red                     = 0x72,
    kF3Green                   = 0x73,
    kF4Yellow                  = 0x74,
    kF5                        = 0x75,
    kData                      = 0x76,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 14,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess                  = 0x00,
    kUnsupportedKey           = 0x01,
    kInvalidKeyInCurrentState = 0x02,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 3,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNavigationKeyCodes = 0x1,
    kLocationKeys       = 0x2,
    kNumberKeys         = 0x4,
};
} // namespace KeypadInput

namespace ContentLauncher {

// Enum for CharacteristicEnum
enum class CharacteristicEnum : uint8_t
{
    kForcedSubtitles              = 0x00,
    kDescribesVideo               = 0x01,
    kEasyToRead                   = 0x02,
    kFrameBased                   = 0x03,
    kMainProgram                  = 0x04,
    kOriginalContent              = 0x05,
    kVoiceOverTranslation         = 0x06,
    kCaption                      = 0x07,
    kSubtitle                     = 0x08,
    kAlternate                    = 0x09,
    kSupplementary                = 0x0A,
    kCommentary                   = 0x0B,
    kDubbedTranslation            = 0x0C,
    kDescription                  = 0x0D,
    kMetadata                     = 0x0E,
    kEnhancedAudioIntelligibility = 0x0F,
    kEmergency                    = 0x10,
    kKaraoke                      = 0x11,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 18,
};

// Enum for MetricTypeEnum
enum class MetricTypeEnum : uint8_t
{
    kPixels     = 0x00,
    kPercentage = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};

// Enum for ParameterEnum
enum class ParameterEnum : uint8_t
{
    kActor      = 0x00,
    kChannel    = 0x01,
    kCharacter  = 0x02,
    kDirector   = 0x03,
    kEvent      = 0x04,
    kFranchise  = 0x05,
    kGenre      = 0x06,
    kLeague     = 0x07,
    kPopularity = 0x08,
    kProvider   = 0x09,
    kSport      = 0x0A,
    kSportsTeam = 0x0B,
    kType       = 0x0C,
    kVideo      = 0x0D,
    kSeason     = 0x0E,
    kEpisode    = 0x0F,
    kAny        = 0x10,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 17,
};

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess                = 0x00,
    kURLNotAvailable        = 0x01,
    kAuthFailed             = 0x02,
    kTextTrackNotAvailable  = 0x03,
    kAudioTrackNotAvailable = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kContentSearch = 0x1,
    kURLPlayback   = 0x2,
    kAdvancedSeek  = 0x4,
    kTextTracks    = 0x8,
    kAudioTracks   = 0x10,
};

// Bitmap for SupportedProtocolsBitmap
enum class SupportedProtocolsBitmap : uint32_t
{
    kDash = 0x1,
    kHls  = 0x2,
};
} // namespace ContentLauncher

namespace AudioOutput {

// Enum for OutputTypeEnum
enum class OutputTypeEnum : uint8_t
{
    kHdmi      = 0x00,
    kBt        = 0x01,
    kOptical   = 0x02,
    kHeadphone = 0x03,
    kInternal  = 0x04,
    kOther     = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kNameUpdates = 0x1,
};
} // namespace AudioOutput

namespace ApplicationLauncher {

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess             = 0x00,
    kAppNotAvailable     = 0x01,
    kSystemBusy          = 0x02,
    kPendingUserApproval = 0x03,
    kDownloading         = 0x04,
    kInstalling          = 0x05,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 6,
};

// Bitmap for Feature
enum class Feature : uint32_t
{
    kApplicationPlatform = 0x1,
};
} // namespace ApplicationLauncher

namespace ApplicationBasic {

// Enum for ApplicationStatusEnum
enum class ApplicationStatusEnum : uint8_t
{
    kStopped               = 0x00,
    kActiveVisibleFocus    = 0x01,
    kActiveHidden          = 0x02,
    kActiveVisibleNotFocus = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};
} // namespace ApplicationBasic

namespace AccountLogin {} // namespace AccountLogin

namespace ContentControl {

// Bitmap for Feature
enum class Feature : uint32_t
{
    kScreenTime             = 0x1,
    kPINManagement          = 0x2,
    kBlockUnrated           = 0x4,
    kOnDemandContentRating  = 0x8,
    kScheduledContentRating = 0x10,
};
} // namespace ContentControl

namespace ContentAppObserver {

// Enum for StatusEnum
enum class StatusEnum : uint8_t
{
    kSuccess        = 0x00,
    kUnexpectedData = 0x01,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 2,
};
} // namespace ContentAppObserver

namespace WebRTCTransportProvider {

using StreamTypeEnum = Clusters::detail::StreamTypeEnum;

using WebRTCEndReasonEnum = Clusters::detail::WebRTCEndReasonEnum;

using WebRTCMetadataOptions = Clusters::detail::WebRTCMetadataOptions;
} // namespace WebRTCTransportProvider

namespace Chime {} // namespace Chime

namespace EcosystemInformation {} // namespace EcosystemInformation

namespace CommissionerControl {

// Bitmap for SupportedDeviceCategoryBitmap
enum class SupportedDeviceCategoryBitmap : uint32_t
{
    kFabricSynchronization = 0x1,
};
} // namespace CommissionerControl

namespace UnitTesting {

// Enum for SimpleEnum
enum class SimpleEnum : uint8_t
{
    kUnspecified = 0x00,
    kValueA      = 0x01,
    kValueB      = 0x02,
    kValueC      = 0x03,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 4,
};

// Bitmap for Bitmap16MaskMap
enum class Bitmap16MaskMap : uint16_t
{
    kMaskVal1 = 0x1,
    kMaskVal2 = 0x2,
    kMaskVal3 = 0x4,
    kMaskVal4 = 0x4000,
};

// Bitmap for Bitmap32MaskMap
enum class Bitmap32MaskMap : uint32_t
{
    kMaskVal1 = 0x1,
    kMaskVal2 = 0x2,
    kMaskVal3 = 0x4,
    kMaskVal4 = 0x40000000,
};

// Bitmap for Bitmap64MaskMap
enum class Bitmap64MaskMap : uint64_t
{
    kMaskVal1 = 0x1,
    kMaskVal2 = 0x2,
    kMaskVal3 = 0x4,
    kMaskVal4 = 0x4000000000000000,
};

// Bitmap for Bitmap8MaskMap
enum class Bitmap8MaskMap : uint8_t
{
    kMaskVal1 = 0x1,
    kMaskVal2 = 0x2,
    kMaskVal3 = 0x4,
    kMaskVal4 = 0x40,
};

// Bitmap for SimpleBitmap
enum class SimpleBitmap : uint8_t
{
    kValueA = 0x1,
    kValueB = 0x2,
    kValueC = 0x4,
};
} // namespace UnitTesting

namespace FaultInjection {

// Enum for FaultType
enum class FaultType : uint8_t
{
    kUnspecified = 0x00,
    kSystemFault = 0x01,
    kInetFault   = 0x02,
    kChipFault   = 0x03,
    kCertFault   = 0x04,
    // All received enum values that are not listed above will be mapped
    // to kUnknownEnumValue. This is a helper enum value that should only
    // be used by code to process how it handles receiving and unknown
    // enum value. This specific should never be transmitted.
    kUnknownEnumValue = 5,
};
} // namespace FaultInjection

namespace SampleMei {} // namespace SampleMei

} // namespace Clusters
} // namespace app
} // namespace chip

// Included at the end, so all our definitions above are available.
#include <app/common/CompatEnumNames.h>
