'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" ? (version != null ? Bokeh[version] : Bokeh) : null;
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh" + (version != null ? " " + version : "") + ". You have to load it prior to loading plugins.");
    }
  })
({
"4e90918c0a": /* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const Panel = tslib_1.__importStar(require("2fe1822b2b") /* ./models */);
    exports.Panel = Panel;
    const base_1 = require("@bokehjs/base");
    (0, base_1.register_models)(Panel);
},
"2fe1822b2b": /* models\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.VizzuChart = exports.VideoStream = exports.Video = exports.VegaPlot = exports.TrendIndicator = exports.TooltipIcon = exports.ToggleIcon = void 0;
    const tslib_1 = require("tslib");
    var ace_1 = require("6227c89639") /* ./ace */;
    __esExport("AcePlot", ace_1.AcePlot);
    var anywidget_component_1 = require("1f663ffe94") /* ./anywidget_component */;
    __esExport("AnyWidgetComponent", anywidget_component_1.AnyWidgetComponent);
    var audio_1 = require("fd59c985b3") /* ./audio */;
    __esExport("Audio", audio_1.Audio);
    var browser_1 = require("5a16cc23e6") /* ./browser */;
    __esExport("BrowserInfo", browser_1.BrowserInfo);
    var button_1 = require("1db93211cd") /* ./button */;
    __esExport("Button", button_1.Button);
    var button_icon_1 = require("1738ddeb3a") /* ./button_icon */;
    __esExport("ButtonIcon", button_icon_1.ButtonIcon);
    var icon_1 = require("6c7fbea0ef") /* ./icon */;
    __esExport("ClickableIcon", icon_1.ClickableIcon);
    var card_1 = require("330f4a8735") /* ./card */;
    __esExport("Card", card_1.Card);
    var checkbox_button_group_1 = require("51fbe9e2d0") /* ./checkbox_button_group */;
    __esExport("CheckboxButtonGroup", checkbox_button_group_1.CheckboxButtonGroup);
    var chatarea_input_1 = require("27a077673d") /* ./chatarea_input */;
    __esExport("ChatAreaInput", chatarea_input_1.ChatAreaInput);
    var column_1 = require("dd255421d9") /* ./column */;
    __esExport("Column", column_1.Column);
    var comm_manager_1 = require("1bec1b1fcc") /* ./comm_manager */;
    __esExport("CommManager", comm_manager_1.CommManager);
    var customselect_1 = require("92bbd30bd1") /* ./customselect */;
    __esExport("CustomSelect", customselect_1.CustomSelect);
    var multiselect_1 = require("27b5580835") /* ./multiselect */;
    __esExport("CustomMultiSelect", multiselect_1.CustomMultiSelect);
    var tabulator_1 = require("7934c11cba") /* ./tabulator */;
    __esExport("DataTabulator", tabulator_1.DataTabulator);
    var datetime_picker_1 = require("100965d6f3") /* ./datetime_picker */;
    __esExport("DatetimePicker", datetime_picker_1.DatetimePicker);
    var datetime_slider_1 = require("c97cc0eade") /* ./datetime_slider */;
    __esExport("DatetimeSlider", datetime_slider_1.DatetimeSlider);
    var deckgl_1 = require("01df2ec63b") /* ./deckgl */;
    __esExport("DeckGLPlot", deckgl_1.DeckGLPlot);
    var discrete_player_1 = require("0dca2cd4f6") /* ./discrete_player */;
    __esExport("DiscretePlayer", discrete_player_1.DiscretePlayer);
    var echarts_1 = require("315eb8f63a") /* ./echarts */;
    __esExport("ECharts", echarts_1.ECharts);
    var feed_1 = require("4cfe0841a5") /* ./feed */;
    __esExport("Feed", feed_1.Feed);
    var file_download_1 = require("84a13dddfb") /* ./file_download */;
    __esExport("FileDownload", file_download_1.FileDownload);
    var file_dropper_1 = require("e8b7476f90") /* ./file_dropper */;
    __esExport("FileDropper", file_dropper_1.FileDropper);
    var html_1 = require("4c04683fdc") /* ./html */;
    __esExport("HTML", html_1.HTML);
    var ipywidget_1 = require("8a8089cbf3") /* ./ipywidget */;
    __esExport("IPyWidget", ipywidget_1.IPyWidget);
    var json_1 = require("245cd3cfde") /* ./json */;
    __esExport("JSON", json_1.JSON);
    var jsoneditor_1 = require("a123a88e31") /* ./jsoneditor */;
    __esExport("JSONEditor", jsoneditor_1.JSONEditor);
    var katex_1 = require("f672d71a9f") /* ./katex */;
    __esExport("KaTeX", katex_1.KaTeX);
    var location_1 = require("bd8e0fe48b") /* ./location */;
    __esExport("Location", location_1.Location);
    var mathjax_1 = require("d889a68424") /* ./mathjax */;
    __esExport("MathJax", mathjax_1.MathJax);
    var modal_1 = require("8c62aa80d9") /* ./modal */;
    __esExport("Modal", modal_1.Modal);
    var pdf_1 = require("f87ad1873c") /* ./pdf */;
    __esExport("PDF", pdf_1.PDF);
    var perspective_1 = require("29a0b0da9a") /* ./perspective */;
    __esExport("Perspective", perspective_1.Perspective);
    var player_1 = require("96e805ccb5") /* ./player */;
    __esExport("Player", player_1.Player);
    var plotly_1 = require("7d9124b744") /* ./plotly */;
    __esExport("PlotlyPlot", plotly_1.PlotlyPlot);
    var progress_1 = require("b1f4d68596") /* ./progress */;
    __esExport("Progress", progress_1.Progress);
    var quill_1 = require("f6d86c7342") /* ./quill */;
    __esExport("QuillInput", quill_1.QuillInput);
    var radio_button_group_1 = require("25e2d7c208") /* ./radio_button_group */;
    __esExport("RadioButtonGroup", radio_button_group_1.RadioButtonGroup);
    var react_component_1 = require("e31ba19a89") /* ./react_component */;
    __esExport("ReactComponent", react_component_1.ReactComponent);
    var reactive_html_1 = require("d5752cda5a") /* ./reactive_html */;
    __esExport("ReactiveHTML", reactive_html_1.ReactiveHTML);
    var reactive_esm_1 = require("50fda3c782") /* ./reactive_esm */;
    __esExport("ReactiveESM", reactive_esm_1.ReactiveESM);
    var singleselect_1 = require("4155401209") /* ./singleselect */;
    __esExport("SingleSelect", singleselect_1.SingleSelect);
    var speech_to_text_1 = require("5ac2cab0ab") /* ./speech_to_text */;
    __esExport("SpeechToText", speech_to_text_1.SpeechToText);
    var state_1 = require("92822cb73a") /* ./state */;
    __esExport("State", state_1.State);
    var tabs_1 = require("2231cdc549") /* ./tabs */;
    __esExport("Tabs", tabs_1.Tabs);
    var terminal_1 = require("121f00bd6f") /* ./terminal */;
    __esExport("Terminal", terminal_1.Terminal);
    var textarea_input_1 = require("b7d595d74a") /* ./textarea_input */;
    __esExport("TextAreaInput", textarea_input_1.TextAreaInput);
    var text_input_1 = require("8be416b160") /* ./text_input */;
    __esExport("TextInput", text_input_1.TextInput);
    var text_to_speech_1 = require("a04eb51988") /* ./text_to_speech */;
    __esExport("TextToSpeech", text_to_speech_1.TextToSpeech);
    var time_picker_1 = require("1afcab4e45") /* ./time_picker */;
    __esExport("TimePicker", time_picker_1.TimePicker);
    var toggle_icon_1 = require("ad985f285e") /* ./toggle_icon */;
    __esExport("ToggleIcon", toggle_icon_1.ToggleIcon);
    var tooltip_icon_1 = require("ae3a172647") /* ./tooltip_icon */;
    __esExport("TooltipIcon", tooltip_icon_1.TooltipIcon);
    var trend_1 = require("29d55a28a9") /* ./trend */;
    __esExport("TrendIndicator", trend_1.TrendIndicator);
    var vega_1 = require("119dc23765") /* ./vega */;
    __esExport("VegaPlot", vega_1.VegaPlot);
    var video_1 = require("79dc37b888") /* ./video */;
    __esExport("Video", video_1.Video);
    var videostream_1 = require("f8afc4e661") /* ./videostream */;
    __esExport("VideoStream", videostream_1.VideoStream);
    var vizzu_1 = require("1f7bc1f95b") /* ./vizzu */;
    __esExport("VizzuChart", vizzu_1.VizzuChart);
    tslib_1.__exportStar(require("c51f25e2a7") /* ./vtk */, exports);
},
"6227c89639": /* models\ace.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const dom_1 = require("@bokehjs/core/dom");
    const layout_1 = require("9b11ce01a3") /* ./layout */;
    const util_1 = require("6ae1cb3800") /* ./util */;
    class AcePlotView extends layout_1.HTMLBoxView {
        connect_signals() {
            super.connect_signals();
            const { code, theme, language, filename, print_margin, annotations, soft_tabs, indent, readonly } = this.model.properties;
            this.on_change(code, () => this._update_code_from_model());
            this.on_change(theme, () => this._update_theme());
            this.on_change(language, () => this._update_language());
            this.on_change(filename, () => this._update_filename());
            this.on_change(print_margin, () => this._update_print_margin());
            this.on_change(annotations, () => this._add_annotations());
            this.on_change(indent, () => this._editor.setOptions({ tabSize: this.model.indent }));
            this.on_change(soft_tabs, () => this._editor.setOptions({ useSoftTabs: this.model.soft_tabs }));
            this.on_change(readonly, () => {
                this._editor.setReadOnly(this.model.readonly);
            });
        }
        render() {
            super.render();
            this._container = (0, dom_1.div)({
                id: (0, util_1.ID)(),
                style: {
                    width: "100%",
                    height: "100%",
                    zIndex: "0",
                },
            });
            this.shadow_el.append(this._container);
            this._container.textContent = this.model.code;
            this._editor = ace.edit(this._container);
            this._editor.renderer.attachToShadowRoot();
            this._langTools = ace.require("ace/ext/language_tools");
            this._modelist = ace.require("ace/ext/modelist");
            this._editor.setOptions({
                enableBasicAutocompletion: true,
                tabSize: this.model.indent,
                useSoftTabs: this.model.soft_tabs,
                enableSnippets: true,
                fontFamily: "monospace", //hack for cursor position
            });
            this._update_theme();
            this._update_filename();
            this._update_language();
            this._editor.setReadOnly(this.model.readonly);
            this._editor.setShowPrintMargin(this.model.print_margin);
            // if on keyup, update code from editor
            if (this.model.on_keyup) {
                this._editor.on("change", () => this._update_code_from_editor());
            }
            else {
                this._editor.on("blur", () => this._update_code_from_editor());
                this._editor.commands.addCommand({
                    name: "updateCodeFromEditor",
                    bindKey: { win: "Ctrl-Enter", mac: "Command-Enter" },
                    exec: () => {
                        this._update_code_from_editor();
                    },
                });
            }
            this._editor.on("change", () => this._update_code_input_from_editor());
        }
        _update_code_from_model() {
            if (this._editor && this._editor.getValue() != this.model.code) {
                this._editor.setValue(this.model.code);
            }
        }
        _update_print_margin() {
            this._editor.setShowPrintMargin(this.model.print_margin);
        }
        _update_code_from_editor() {
            if (this._editor.getValue() != this.model.code) {
                this.model.code = this._editor.getValue();
            }
        }
        _update_code_input_from_editor() {
            if (this._editor.getValue() != this.model.code_input) {
                this.model.code_input = this._editor.getValue();
            }
        }
        _update_theme() {
            this._editor.setTheme(`ace/theme/${this.model.theme}`);
        }
        _update_filename() {
            if (this.model.filename) {
                const mode = this._modelist.getModeForPath(this.model.filename).mode;
                this.model.language = mode.slice(9);
            }
        }
        _update_language() {
            if (this.model.language != null) {
                this._editor.session.setMode(`ace/mode/${this.model.language}`);
            }
        }
        _add_annotations() {
            this._editor.session.setAnnotations(this.model.annotations);
        }
        after_layout() {
            super.after_layout();
            if (this._editor !== undefined) {
                this._editor.resize();
            }
        }
    }
    exports.AcePlotView = AcePlotView;
    AcePlotView.__name__ = "AcePlotView";
    class AcePlot extends layout_1.HTMLBox {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.AcePlot = AcePlot;
    _a = AcePlot;
    AcePlot.__name__ = "AcePlot";
    AcePlot.__module__ = "panel.models.ace";
    (() => {
        _a.prototype.default_view = AcePlotView;
        _a.define(({ Any, Bool, Int, List, Str, Nullable }) => ({
            annotations: [List(Any), []],
            code: [Str, ""],
            code_input: [Str, ""],
            filename: [Nullable(Str), null],
            indent: [Int, 4],
            language: [Str, ""],
            on_keyup: [Bool, true],
            print_margin: [Bool, false],
            theme: [Str, "github_light_default"],
            readonly: [Bool, false],
            soft_tabs: [Bool, false],
        }));
        _a.override({
            height: 300,
            width: 300,
        });
    })();
},
"9b11ce01a3": /* models\layout.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.set_size = set_size;
    const dom_1 = require("@bokehjs/core/dom");
    const types_1 = require("@bokehjs/core/util/types");
    const assert_1 = require("@bokehjs/core/util/assert");
    const widget_1 = require("@bokehjs/models/widgets/widget");
    const layout_dom_1 = require("@bokehjs/models/layouts/layout_dom");
    class PanelMarkupView extends widget_1.WidgetView {
        connect_signals() {
            super.connect_signals();
            const { width, height, min_height, max_height, margin, sizing_mode } = this.model.properties;
            this.on_change([width, height, min_height, max_height, margin, sizing_mode], () => {
                set_size(this.el, this.model);
                set_size(this.container, this.model, false);
            });
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            if (this.provider.status == "not_started" || this.provider.status == "loading") {
                this.provider.ready.connect(() => {
                    if (this.contains_tex_string(this.model.text)) {
                        this.render();
                    }
                });
            }
        }
        watch_stylesheets() {
            this._initialized_stylesheets = new Map();
            for (const stylesheet of this._applied_stylesheets) {
                // @ts-expect-error: 'el' is protected
                const style_el = stylesheet.el;
                if (style_el instanceof HTMLLinkElement) {
                    this._initialized_stylesheets.set(style_el.href, false);
                    style_el.addEventListener("load", () => {
                        this._initialized_stylesheets.set(style_el.href, true);
                        if ([...this._initialized_stylesheets.values()].every((v) => v)) {
                            requestAnimationFrame(() => this.style_redraw());
                        }
                    });
                }
            }
            if (this._initialized_stylesheets.size == 0) {
                this.style_redraw();
            }
        }
        rerender_(view = null) {
            // Can be removed when Bokeh>3.7 (see https://github.com/holoviz/panel/pull/7815)
            view = view == null ? this : view;
            if (view.rerender) {
                view.rerender();
            }
            else {
                view.render();
                view.r_after_render();
            }
        }
        style_redraw() { }
        has_math_disabled() {
            return this.model.disable_math || !this.contains_tex_string(this.model.text);
        }
        render() {
            super.render();
            set_size(this.el, this.model);
            this.container = (0, dom_1.div)();
            set_size(this.container, this.model, false);
            this.shadow_el.appendChild(this.container);
            if (this.provider.status == "failed" || this.provider.status == "loaded") {
                this._has_finished = true;
            }
        }
    }
    exports.PanelMarkupView = PanelMarkupView;
    PanelMarkupView.__name__ = "PanelMarkupView";
    function set_size(el, model, adjust_margin = true) {
        let width_policy = model.width != null ? "fixed" : "fit";
        let height_policy = model.height != null ? "fixed" : "fit";
        const { sizing_mode, margin } = model;
        if (sizing_mode != null) {
            if (sizing_mode == "fixed") {
                width_policy = height_policy = "fixed";
            }
            else if (sizing_mode == "stretch_both") {
                width_policy = height_policy = "max";
            }
            else if (sizing_mode == "stretch_width") {
                width_policy = "max";
            }
            else if (sizing_mode == "stretch_height") {
                height_policy = "max";
            }
            else {
                switch (sizing_mode) {
                    case "scale_width": {
                        width_policy = "max";
                        height_policy = "min";
                        break;
                    }
                    case "scale_height": {
                        width_policy = "min";
                        height_policy = "max";
                        break;
                    }
                    case "scale_both": {
                        width_policy = "max";
                        height_policy = "max";
                        break;
                    }
                    default: {
                        (0, assert_1.unreachable)();
                    }
                }
            }
        }
        let wm, hm;
        if (!adjust_margin) {
            hm = wm = 0;
        }
        else if ((0, types_1.isArray)(margin)) {
            if (margin.length === 4) {
                hm = margin[0] + margin[2];
                wm = margin[1] + margin[3];
            }
            else {
                hm = margin[0] * 2;
                wm = margin[1] * 2;
            }
        }
        else if (margin == null) {
            hm = wm = 0;
        }
        else {
            wm = hm = margin * 2;
        }
        if (width_policy == "fixed" && model.width != null) {
            el.style.width = (0, dom_1.px)(model.width);
        }
        else if (width_policy == "max") {
            el.style.width = wm != 0 ? `calc(100% - ${(0, dom_1.px)(wm)})` : "100%";
        }
        if (model.min_width != null) {
            el.style.minWidth = (0, dom_1.px)(model.min_width);
        }
        if (model.max_width != null) {
            el.style.maxWidth = (0, dom_1.px)(model.max_width);
        }
        if (height_policy == "fixed" && model.height != null) {
            el.style.height = (0, dom_1.px)(model.height);
        }
        else if (height_policy == "max") {
            el.style.height = hm != 0 ? `calc(100% - ${(0, dom_1.px)(hm)})` : "100%";
        }
        if (model.min_height != null) {
            el.style.minHeight = (0, dom_1.px)(model.min_height);
        }
        if (model.max_height != null) {
            el.style.maxHeight = (0, dom_1.px)(model.max_height);
        }
    }
    class HTMLBoxView extends layout_dom_1.LayoutDOMView {
        connect_signals() {
            super.connect_signals();
            const { width, height, min_height, max_height, margin, sizing_mode } = this.model.properties;
            this.on_change([width, height, min_height, max_height, margin, sizing_mode], () => {
                set_size(this.el, this.model);
            });
        }
        render() {
            super.render();
            set_size(this.el, this.model);
        }
        rerender_(view = null) {
            // Can be removed when Bokeh>3.7 (see https://github.com/holoviz/panel/pull/7815)
            view = view == null ? this : view;
            if (view.rerender) {
                view.rerender();
            }
            else {
                view.render();
                view.r_after_render();
            }
        }
        watch_stylesheets() {
            this._initialized_stylesheets = new Map();
            for (const stylesheet of this._applied_stylesheets) {
                // @ts-expect-error: 'el' is protected
                const style_el = stylesheet.el;
                if (style_el instanceof HTMLLinkElement) {
                    this._initialized_stylesheets.set(style_el.href, false);
                    style_el.addEventListener("load", () => {
                        this._initialized_stylesheets.set(style_el.href, true);
                        if ([...this._initialized_stylesheets.values()].every((v) => v)) {
                            this.style_redraw();
                        }
                    });
                }
            }
            if (Object.keys(this._initialized_stylesheets).length === 0) {
                requestAnimationFrame(() => this.style_redraw());
            }
        }
        style_redraw() { }
        get child_models() {
            return [];
        }
    }
    exports.HTMLBoxView = HTMLBoxView;
    HTMLBoxView.__name__ = "HTMLBoxView";
    class HTMLBox extends layout_dom_1.LayoutDOM {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.HTMLBox = HTMLBox;
    HTMLBox.__name__ = "HTMLBox";
},
"6ae1cb3800": /* models\util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.throttle = throttle;
    exports.deepCopy = deepCopy;
    exports.reshape = reshape;
    exports.loadScript = loadScript;
    exports.ID = ID;
    exports.convertUndefined = convertUndefined;
    exports.formatError = formatError;
    exports.find_attributes = find_attributes;
    exports.schedule_when = schedule_when;
    const array_1 = require("@bokehjs/core/util/array");
    const types_1 = require("@bokehjs/core/util/types");
    const get = (obj, path, defaultValue = undefined) => {
        const travel = (regexp) => String.prototype.split
            .call(path, regexp)
            .filter(Boolean)
            .reduce((res, key) => (res !== null && res !== undefined ? res[key] : res), obj);
        const result = travel(/[,[\]]+?/) || travel(/[,[\].]+?/);
        return result === undefined || result === obj ? defaultValue : result;
    };
    exports.get = get;
    function throttle(func, limit) {
        let lastRan = 0;
        let trailingCall = null;
        return function (...args) {
            // @ts-ignore
            const context = this;
            const now = Date.now();
            if (trailingCall) {
                clearTimeout(trailingCall);
            }
            if ((now - lastRan) >= limit) {
                func.apply(context, args);
                lastRan = Date.now();
            }
            else {
                trailingCall = setTimeout(function () {
                    func.apply(context, args);
                    lastRan = Date.now();
                    trailingCall = null;
                }, limit - (now - lastRan));
            }
        };
    }
    function deepCopy(obj) {
        let copy;
        // Handle the 3 simple types, and null or undefined
        if (null == obj || "object" != typeof obj) {
            return obj;
        }
        // Handle Array
        if (obj instanceof Array) {
            copy = [];
            for (let i = 0, len = obj.length; i < len; i++) {
                copy[i] = deepCopy(obj[i]);
            }
            return copy;
        }
        // Handle Object
        if (obj instanceof Object) {
            const copy = {};
            for (const attr in obj) {
                const key = attr;
                if (obj.hasOwnProperty(key)) {
                    copy[key] = deepCopy(obj[key]);
                }
            }
            return copy;
        }
        throw new Error("Unable to copy obj! Its type isn't supported.");
    }
    function reshape(arr, dim) {
        let elemIndex = 0;
        if (!dim || !arr) {
            return [];
        }
        function _nest(dimIndex) {
            let result = [];
            if (dimIndex === dim.length - 1) {
                result = (0, array_1.concat)(arr.slice(elemIndex, elemIndex + dim[dimIndex]));
                elemIndex += dim[dimIndex];
            }
            else {
                for (let i = 0; i < dim[dimIndex]; i++) {
                    result.push(_nest(dimIndex + 1));
                }
            }
            return result;
        }
        return _nest(0);
    }
    async function loadScript(type, src) {
        const script = document.createElement("script");
        script.type = type;
        script.src = src;
        script.defer = true;
        document.head.appendChild(script);
        return new Promise((resolve, reject) => {
            script.onload = () => {
                resolve();
            };
            script.onerror = () => {
                reject();
            };
        });
    }
    function ID() {
        // Math.random should be unique because of its seeding algorithm.
        // Convert it to base 36 (numbers + letters), and grab the first 9 characters
        // after the decimal.
        return `_${Math.random().toString(36).substring(2, 11)}`;
    }
    function convertUndefined(obj) {
        if ((0, types_1.isArray)(obj)) {
            return obj.map(convertUndefined);
        }
        else if ((0, types_1.isPlainObject)(obj)) {
            Object
                .entries(obj)
                .forEach(([key, value]) => {
                if ((0, types_1.isPlainObject)(value) || (0, types_1.isArray)(value)) {
                    convertUndefined(value);
                }
                else if (value === undefined) {
                    obj[key] = null;
                }
            });
        }
        return obj;
    }
    function formatError(error, code) {
        const regex = /\((\d+):(\d+)\)/;
        let msg = `<span class="msg">${error}</span>`;
        const match = msg.match(regex);
        if (!match) {
            return msg;
        }
        const line_num = parseInt(match[1]);
        const col = parseInt(match[2]);
        const start = Math.max(0, line_num - 5);
        const col_index = line_num - start;
        const lines = code.replace(">", "&lt;").replace("<", "&gt;").split(/\r?\n/).slice(start, line_num + 5);
        msg += "<br><br>";
        for (let i = 0; i < col_index; i++) {
            const cls = (i == (col_index - 1)) ? " class=\"highlight\"" : "";
            msg += `<pre${cls}>${lines[i]}</pre>`;
        }
        const indent = " ".repeat(col - 1);
        msg += `<pre class="highlight">${indent}^</pre>`;
        for (let i = col_index; i < lines.length; i++) {
            msg += `<pre>${lines[i]}</pre>`;
        }
        return msg;
    }
    function find_attributes(text, obj, ignored) {
        const regex = RegExp(`\\b${obj}\\.([a-zA-Z_][a-zA-Z0-9_]*)\\b`, "g");
        const matches = [];
        let match, attr;
        while ((match = regex.exec(text)) !== null && (attr = match[0].slice(obj.length + 1)) !== null && !ignored.includes(attr)) {
            matches.push(attr);
        }
        return (0, array_1.uniq)(matches);
    }
    function schedule_when(func, predicate, timeout = 10) {
        const scheduled = () => {
            if (predicate()) {
                func();
            }
            else {
                setTimeout(scheduled, timeout);
            }
        };
        scheduled();
    }
},
"1f663ffe94": /* models\anywidget_component.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const reactive_esm_1 = require("50fda3c782") /* ./reactive_esm */;
    class AnyWidgetModelAdapter {
        constructor(model) {
            this.view = null;
            this.model = model;
            this.model_changes = {};
            this.data_changes = {};
        }
        get(name) {
            let value;
            const propPath = name.split(".");
            let targetModel = this.model.data;
            for (let i = 0; i < propPath.length - 1; i++) {
                if (targetModel && targetModel.attributes && propPath[i] in targetModel.attributes) {
                    targetModel = targetModel.attributes[propPath[i]];
                }
                else {
                    // Stop if any part of the path is missing
                    targetModel = null;
                    break;
                }
            }
            if (targetModel && targetModel.attributes && propPath[propPath.length - 1] in targetModel.attributes) {
                value = targetModel.attributes[propPath[propPath.length - 1]];
            }
            else {
                value = this.model.attributes[name];
            }
            if (value instanceof ArrayBuffer) {
                value = new DataView(value);
            }
            return value;
        }
        set(name, value) {
            if (name.split(".")[0] in this.model.data.attributes) {
                this.data_changes = { ...this.data_changes, [name]: value };
            }
            else if (name in this.model.attributes) {
                this.model_changes = { ...this.model_changes, [name]: value };
            }
        }
        save_changes() {
            this.model.setv(this.model_changes);
            this.model_changes = {};
            for (const key in this.data_changes) {
                const propPath = key.split(".");
                let targetModel = this.model.data;
                for (let i = 0; i < propPath.length - 1; i++) {
                    if (targetModel && targetModel.attributes && propPath[i] in targetModel.attributes) {
                        targetModel = targetModel.attributes[propPath[i]];
                    }
                    else {
                        console.warn(`Skipping '${key}': '${propPath[i]}' does not exist.`);
                        targetModel = null;
                        break;
                    }
                }
                if (targetModel && targetModel.attributes && propPath[propPath.length - 1] in targetModel.attributes) {
                    targetModel.setv({ [propPath[propPath.length - 1]]: this.data_changes[key] });
                }
                else {
                    console.warn(`Skipping '${key}': Final property '${propPath[propPath.length - 1]}' not found.`);
                }
            }
            this.data_changes = {};
        }
        on(event, cb) {
            if (event.startsWith("change:")) {
                this.model.watch(this.view, event.slice("change:".length), cb);
            }
            else if (event === "msg:custom" && this.view) {
                this.view.on_event(cb);
            }
            else {
                console.error(`Event of type '${event}' not recognized.`);
            }
        }
        off(event, cb) {
            if (event.startsWith("change:")) {
                this.model.unwatch(this.view, event.slice("change:".length), cb);
            }
            else if (event === "msg:custom" && this.view) {
                this.view.remove_on_event(cb);
            }
            else {
                console.error(`Event of type '${event}' not recognized.`);
            }
        }
    }
    AnyWidgetModelAdapter.__name__ = "AnyWidgetModelAdapter";
    class AnyWidgetAdapter extends AnyWidgetModelAdapter {
        constructor(view) {
            super(view.model);
            this.view = view;
        }
        get_child(name) {
            const child_model = this.model.data[name];
            if (Array.isArray(child_model)) {
                const subchildren = [];
                for (const subchild of child_model) {
                    const subview = this.view.get_child_view(subchild);
                    if (subview) {
                        subchildren.push(subview.el);
                    }
                }
                return subchildren;
            }
            else {
                return this.view.get_child_view(child_model)?.el;
            }
        }
    }
    AnyWidgetAdapter.__name__ = "AnyWidgetAdapter";
    class AnyWidgetComponentView extends reactive_esm_1.ReactiveESMView {
        initialize() {
            super.initialize();
            this.adapter = new AnyWidgetAdapter(this);
        }
        remove() {
            super.remove();
            if (this.destroyer) {
                this.destroyer.then((d) => d({ model: this.adapter, el: this.container }));
            }
        }
        after_rendered() {
            this.render_children();
            this._rendered = true;
        }
    }
    exports.AnyWidgetComponentView = AnyWidgetComponentView;
    AnyWidgetComponentView.__name__ = "AnyWidgetComponentView";
    class AnyWidgetComponent extends reactive_esm_1.ReactiveESM {
        constructor(attrs) {
            super(attrs);
            this.sucrase_transforms = ["typescript", "jsx"];
        }
        _render_code() {
            return `
function render(id) {
  const view = Bokeh.index.find_one_by_id(id)
  if (!view) { return }

  const out = Promise.resolve(view.render_fn({
    view, model: view.adapter, data: view.model.data, el: view.container
  }) || null)
  view.destroyer = out
  out.then(() => view.after_rendered())
}

export default {render}`;
        }
        _run_initializer(initialize) {
            const props = { model: new AnyWidgetModelAdapter(this) };
            initialize(props);
        }
    }
    exports.AnyWidgetComponent = AnyWidgetComponent;
    _a = AnyWidgetComponent;
    AnyWidgetComponent.__name__ = "AnyWidgetComponent";
    AnyWidgetComponent.__module__ = "panel.models.esm";
    (() => {
        _a.prototype.default_view = AnyWidgetComponentView;
    })();
},
"50fda3c782": /* models\reactive_esm.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c;
    __esModule();
    exports.model_getter = model_getter;
    exports.model_setter = model_setter;
    const tslib_1 = require("tslib");
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var ESMEvent_1;
    const sucrase_1 = require("48024289a4") /* sucrase */;
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    const dom_1 = require("@bokehjs/core/dom");
    const dom_2 = require("@bokehjs/core/dom");
    const layout_dom_1 = require("@bokehjs/models/layouts/layout_dom");
    const types_1 = require("@bokehjs/core/util/types");
    const event_to_object_1 = require("a572dba9cd") /* ./event-to-object */;
    const html_1 = require("4c04683fdc") /* ./html */;
    const layout_1 = require("9b11ce01a3") /* ./layout */;
    const util_1 = require("6ae1cb3800") /* ./util */;
    const esm_css_1 = tslib_1.__importDefault(require("727a14f76b") /* ../styles/models/esm.css */);
    const MODULE_CACHE = new Map();
    class DataEvent extends bokeh_events_1.ModelEvent {
        constructor(data) {
            super();
            this.data = data;
        }
        get event_values() {
            return { model: this.origin, data: this.data };
        }
    }
    exports.DataEvent = DataEvent;
    _a = DataEvent;
    DataEvent.__name__ = "DataEvent";
    (() => {
        _a.prototype.event_name = "data_event";
    })();
    let ESMEvent = (_b = class ESMEvent extends DataEvent {
        static from_values(values) {
            const { model, data } = values;
            const event = new ESMEvent_1(data);
            event.origin = model;
            return event;
        }
    },
        (() => {
            ESMEvent_1 = _b;
        })(),
        _b.__name__ = "ESMEvent",
        _b);
    exports.ESMEvent = ESMEvent;
    exports.ESMEvent = ESMEvent = ESMEvent_1 = __decorate([
        (0, bokeh_events_1.server_event)("esm_event")
    ], ESMEvent);
    function model_getter(target, name) {
        const model = target.model;
        if (name === "get_child") {
            return (child) => {
                if (!target.accessed_children.includes(child)) {
                    target.accessed_children.push(child);
                }
                const child_model = model.data[child];
                if ((0, types_1.isArray)(child_model)) {
                    const children = [];
                    for (const subchild of child_model) {
                        children.push(target.get_child_view(subchild)?.el);
                    }
                    return children;
                }
                else if (model != null) {
                    return target.get_child_view(child_model)?.el;
                }
                return null;
            };
        }
        else if (name === "send_msg") {
            return (data) => {
                model.trigger_event(new DataEvent(data));
            };
        }
        else if (name === "send_event") {
            return (name, event) => {
                const serialized = (0, util_1.convertUndefined)((0, event_to_object_1.serializeEvent)(event));
                model.trigger_event(new html_1.DOMEvent(name, serialized));
            };
        }
        else if (name === "off") {
            return (prop, callback) => {
                const props = (0, types_1.isArray)(prop) ? prop : [prop];
                for (let p of props) {
                    if (p.startsWith("change:")) {
                        p = p.slice("change:".length);
                    }
                    if (p in model.attributes || p.split(".")[0] in model.data.attributes) {
                        model.unwatch(target, p, callback);
                        continue;
                    }
                    else if (p === "msg:custom") {
                        target.remove_on_event(callback);
                        continue;
                    }
                    if (p.startsWith("lifecycle:")) {
                        p = p.slice("lifecycle:".length);
                    }
                    if (target._lifecycle_handlers.has(p)) {
                        const handlers = target._lifecycle_handlers.get(p);
                        if (handlers && handlers.includes(callback)) {
                            target._lifecycle_handlers.set(p, handlers.filter(v => v !== callback));
                        }
                        continue;
                    }
                    console.warn(`Could not unregister callback for event type '${p}'`);
                }
            };
        }
        else if (name === "on") {
            return (prop, callback, force = false) => {
                const props = (0, types_1.isArray)(prop) ? prop : [prop];
                for (let p of props) {
                    if (p.startsWith("change:")) {
                        p = p.slice("change:".length);
                    }
                    if (p in model.attributes || p.split(".")[0] in model.data.attributes) {
                        model.watch(target, p, callback, force);
                        continue;
                    }
                    else if (p === "msg:custom") {
                        target.on_event(callback);
                        continue;
                    }
                    if (p.startsWith("lifecycle:")) {
                        p = p.slice("lifecycle:".length);
                    }
                    if (target._lifecycle_handlers.has(p)) {
                        (target._lifecycle_handlers.get(p) || []).push(callback);
                        continue;
                    }
                    console.warn(`Could not register callback for event type '${p}'`);
                }
            };
        }
        else if (Reflect.has(model.data, name)) {
            if (name in model.data.attributes && !target.accessed_properties.includes(name)) {
                target.accessed_properties.push(name);
            }
            return Reflect.get(model.data, name);
        }
        else if (Reflect.has(model, name)) {
            return Reflect.get(model, name);
        }
        return undefined;
    }
    function model_setter(target, name, value) {
        const model = target.model;
        if (Reflect.has(model.data, name)) {
            return Reflect.set(model.data, name, value);
        }
        else if (Reflect.has(model, name)) {
            return Reflect.set(model, name, value);
        }
        return false;
    }
    function init_model_getter(target, name) {
        if (Reflect.has(target.data, name)) {
            return Reflect.get(target.data, name);
        }
        else if (Reflect.has(target, name)) {
            return Reflect.get(target, name);
        }
    }
    function init_model_setter(target, name, value) {
        if (Reflect.has(target.data, name)) {
            return Reflect.set(target.data, name, value);
        }
        else if (Reflect.has(target, name)) {
            return Reflect.set(target, name, value);
        }
        return false;
    }
    class ReactiveESMView extends layout_1.HTMLBoxView {
        constructor() {
            super(...arguments);
            this.accessed_properties = [];
            this.accessed_children = [];
            this.compiled_module = null;
            this._changing = false;
            this._child_rendered = new Map();
            this._event_handlers = [];
            this._lifecycle_handlers = new Map([
                ["update_layout", []],
                ["after_layout", []],
                ["after_render", []],
                ["resize", []],
                ["remove", []],
                ["mounted", []],
            ]);
            this._rendered = false;
            this._stale_children = false;
            this._mounted = new Map();
        }
        initialize() {
            super.initialize();
            this._module_cache = MODULE_CACHE;
            this._child_callbacks = new Map();
            this.model_proxy = new Proxy(this, {
                get: model_getter,
                set: model_setter,
            });
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            this.compiled_module = await this.model.compiled_module;
        }
        stylesheets() {
            const stylesheets = super.stylesheets();
            stylesheets.push(esm_css_1.default);
            if (this.model.css_bundle) {
                if (this.model.bundle === "url") {
                    stylesheets.push(new dom_2.ImportedStyleSheet(this.model.css_bundle));
                }
                else {
                    stylesheets.push(this.model.css_bundle);
                }
            }
            return stylesheets;
        }
        connect_signals() {
            super.connect_signals();
            const { esm, importmap, class_name } = this.model.properties;
            this.on_change([esm, importmap], async () => {
                this.compiled_module = await this.model.compiled_module;
                this.invalidate_render();
            });
            this.on_change(class_name, () => {
                this.container.className = this.model.class_name.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
            });
            const child_props = this.model.children.map((child) => this.model.data.properties[child]);
            this.on_change(child_props, () => {
                this.update_children();
            });
            this.model.on_event(ESMEvent, (event) => {
                for (const cb of this._event_handlers) {
                    cb(event.data);
                }
            });
        }
        disconnect_signals() {
            super.disconnect_signals();
            this._child_callbacks = new Map();
            this.model.disconnect_watchers(this);
        }
        _on_mounted() { }
        notify_mount(child, id, remove) {
            if (!this._mounted.has(child)) {
                this._mounted.set(child, new Set());
            }
            if (remove) {
                this._mounted.get(child)?.delete(id);
            }
            else {
                this._mounted.get(child)?.add(id);
            }
            let children = this.model.data[child];
            if (!(0, types_1.isArray)(children)) {
                children = [children];
            }
            if (children.every((model) => this._mounted.get(child)?.has(model.id))) {
                this._on_mounted();
                for (const cb of this._lifecycle_handlers.get("mounted") || []) {
                    cb(child);
                }
            }
        }
        on_event(callback) {
            this._event_handlers.push(callback);
        }
        remove_on_event(callback) {
            if (this._event_handlers.includes(callback)) {
                this._event_handlers = this._event_handlers.filter((item) => item !== callback);
                return true;
            }
            return false;
        }
        get_child_view(model) {
            return this._child_views.get(model);
        }
        get render_fn() {
            if (this.compiled_module === null) {
                return null;
            }
            else if (this.compiled_module.default) {
                return this.compiled_module.default.render;
            }
            else {
                return this.compiled_module.render;
            }
        }
        get child_models() {
            const children = [];
            for (const child of this.model.children) {
                const model = this.model.data[child];
                if ((0, types_1.isArray)(model)) {
                    for (const subchild of model) {
                        children.push(subchild);
                    }
                }
                else if (model != null) {
                    children.push(model);
                }
            }
            return children;
        }
        render_error(error) {
            const error_div = (0, dom_1.div)({ class: "error" });
            error_div.innerHTML = (0, util_1.formatError)(error, this.model.esm);
            this.container.appendChild(error_div);
        }
        render() {
            this.empty();
            this._update_stylesheets();
            this._update_css_classes();
            this._apply_styles();
            this._update_css_variables();
            this._apply_visible();
            this._child_callbacks = new Map();
            this._child_rendered.clear();
            this._rendered = false;
            (0, layout_1.set_size)(this.el, this.model);
            this.container = (0, dom_1.div)();
            this.container.className = this.model.class_name.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
            (0, layout_1.set_size)(this.container, this.model, false);
            this.shadow_el.append(this.container);
            if (this.model.compile_error) {
                this.render_error(this.model.compile_error);
            }
            else {
                this.render_esm();
            }
            for (const element_view of this.element_views) {
                // this.shadow_el is needed for Bokeh < 3.7.0 as this.self_target is not defined
                // can be removed when our minimum version is Bokeh 3.7.0
                // https://github.com/holoviz/panel/pull/7948
                const target = element_view.rendering_target() ?? this.self_target ?? this.shadow_el;
                element_view.render_to(target);
            }
        }
        get is_managed() {
            return this.parent instanceof layout_dom_1.LayoutDOMView && !(this.parent instanceof ReactiveESMView);
        }
        compute_layout() {
            if (this.is_managed) {
                super.compute_layout();
                return;
            }
            this.measure_layout();
            this.update_bbox();
            this._compute_layout();
            this.after_layout();
            // Override private property
            this._layout_computed = true;
        }
        _update_bbox() {
            const displayed = (() => {
                // Consider using Element.checkVisibility() in the future.
                // https://w3c.github.io/csswg-drafts/cssom-view-1/#dom-element-checkvisibility
                if (!this.el.isConnected) {
                    return false;
                }
                else if (this.el.offsetParent != null) {
                    return true;
                }
                else {
                    const { position, display } = getComputedStyle(this.el);
                    return position == "fixed" && display != "none";
                }
            })();
            // Override private property
            this._is_displayed = displayed;
            return true;
        }
        after_rendered() {
            const handlers = (this._lifecycle_handlers.get("after_render") || []);
            for (const cb of handlers) {
                cb();
            }
            this.render_children();
            this.model_proxy.on(this.accessed_children, () => { this._stale_children = true; });
            if (!this._rendered) {
                for (const cb of (this._lifecycle_handlers.get("after_layout") || [])) {
                    cb();
                }
            }
            this._rendered = true;
        }
        render_esm() {
            if (this.model.compiled === null || this.model.render_module === null) {
                return;
            }
            this.accessed_properties = [];
            for (const lf of this._lifecycle_handlers.keys()) {
                (this._lifecycle_handlers.get(lf) || []).splice(0);
            }
            this.model.disconnect_watchers(this);
            this.model.render_module.then((mod) => mod.default.render(this.model.id));
        }
        render_children() {
            for (const child of this.model.children) {
                const child_model = this.model.data[child];
                const children = (0, types_1.isArray)(child_model) ? child_model : [child_model];
                for (const subchild of children) {
                    const view = this._child_views.get(subchild);
                    if (!view) {
                        continue;
                    }
                    const parent = view.el.parentNode;
                    if (parent && !this._child_rendered.has(view)) {
                        this.rerender_(view);
                        this._child_rendered.set(view, true);
                    }
                }
            }
            this.after_render();
        }
        invalidate_layout() {
            if (this.is_managed) {
                super.invalidate_layout();
                return;
            }
            this.update_layout();
            this.compute_layout();
        }
        remove() {
            super.remove();
            for (const cb of (this._lifecycle_handlers.get("remove") || [])) {
                cb();
            }
            this._child_callbacks.clear();
            this._child_rendered.clear();
            this._mounted.clear();
        }
        after_resize() {
            if (this._rendered && !this._changing) {
                super.after_resize();
                for (const cb of (this._lifecycle_handlers.get("resize") || [])) {
                    cb();
                }
            }
        }
        after_layout() {
            super.after_layout();
            if (this._rendered && !this._changing) {
                for (const cb of (this._lifecycle_handlers.get("after_layout") || [])) {
                    cb();
                }
            }
        }
        _lookup_child(child_view) {
            for (const child of this.model.children) {
                let models = this.model.data[child];
                models = (0, types_1.isArray)(models) ? models : [models];
                for (const model of models) {
                    if (model === child_view.model) {
                        return child;
                    }
                }
            }
            return null;
        }
        async update_children() {
            const created_children = new Set(await this.build_child_views());
            const all_views = this.child_views;
            for (const child_view of all_views) {
                child_view.el.remove();
            }
            const new_views = new Map();
            for (const child_view of this.child_views) {
                if (!created_children.has(child_view)) {
                    continue;
                }
                const child = this._lookup_child(child_view);
                if (!child) {
                    continue;
                }
                if (new_views.has(child)) {
                    new_views.get(child).push(child_view);
                }
                else {
                    new_views.set(child, [child_view]);
                }
            }
            for (const view of this._child_rendered.keys()) {
                if (!all_views.includes(view)) {
                    this._child_rendered.delete(view);
                }
            }
            for (const child of this.model.children) {
                const callbacks = this._child_callbacks.get(child) || [];
                const new_children = new_views.get(child) || [];
                for (const callback of callbacks) {
                    callback(new_children);
                }
            }
            if (this._stale_children) {
                this.render_esm();
                this._stale_children = false;
            }
            this._update_children();
            this.invalidate_layout();
        }
        on_child_render(child, callback) {
            if (!this._child_callbacks.has(child)) {
                this._child_callbacks.set(child, []);
            }
            const callbacks = this._child_callbacks.get(child) || [];
            callbacks.push(callback);
        }
        remove_on_child_render(child, callback) {
            if (!this._child_callbacks.has(child)) {
                return;
            }
            if (callback === undefined) {
                this._child_callbacks.delete(child);
            }
            else {
                let callbacks = this._child_callbacks.get(child) || [];
                callbacks = callbacks.filter((cb) => cb !== callback);
                this._child_callbacks.set(child, callbacks);
            }
        }
    }
    exports.ReactiveESMView = ReactiveESMView;
    ReactiveESMView.__name__ = "ReactiveESMView";
    class ReactiveESM extends layout_1.HTMLBox {
        constructor(attrs) {
            super(attrs);
            this.compiled = null;
            this.compiled_module = null;
            this.compile_error = null;
            this.render_module = null;
            this.sucrase_transforms = ["typescript"];
            this._destroyer = null;
            this._esm_watchers = {};
            this._event_callbacks = new Map();
        }
        initialize() {
            super.initialize();
            this.model_proxy = new Proxy(this, {
                get: init_model_getter,
                set: init_model_setter,
            });
            this.recompile();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.esm.change, () => this.recompile());
            this.connect(this.properties.importmap.change, () => this.recompile());
        }
        watch(view, prop, cb, force = false) {
            if (prop in this._esm_watchers) {
                this._esm_watchers[prop].push([view, cb]);
            }
            else {
                this._esm_watchers[prop] = [[view, cb]];
            }
            const propPath = prop.split(".");
            let target = this.data;
            let resolvedProp = null;
            for (let i = 0; i < propPath.length - 1; i++) {
                if (target && target.properties && propPath[i] in target.properties) {
                    target = target[propPath[i]];
                }
                else {
                    // Break if any level of the path is invalid
                    target = null;
                    break;
                }
            }
            if (target && target.properties && propPath[propPath.length - 1] in target.properties) {
                resolvedProp = propPath[propPath.length - 1];
            }
            // Handle reset of param.Event properties
            if (!force && target === this.data && resolvedProp && this.events.includes(resolvedProp)) {
                const orig_cb = cb;
                cb = () => {
                    if (resolvedProp && this.data[resolvedProp]) {
                        orig_cb();
                        this.data.setv({ [resolvedProp]: false });
                    }
                };
                this._event_callbacks.set(orig_cb, cb);
            }
            // Attach watcher if property is found
            if (resolvedProp && target) {
                target.property(resolvedProp).change.connect(cb);
            }
            else if (prop in this.properties) {
                this.property(prop).change.connect(cb);
            }
        }
        unwatch(view, prop, cb) {
            if (!(prop in this._esm_watchers)) {
                return false;
            }
            // Filter out the specific callback for this view
            const remaining = [];
            for (const [wview, wcb] of this._esm_watchers[prop]) {
                if (wview !== view || wcb !== cb) {
                    remaining.push([wview, wcb]);
                }
            }
            // Update or delete watcher list
            if (remaining.length > 0) {
                this._esm_watchers[prop] = remaining;
            }
            else {
                delete this._esm_watchers[prop];
            }
            // Resolve nested properties
            const propPath = prop.split(".");
            let target = this.data;
            let resolvedProp = null;
            for (let i = 0; i < propPath.length - 1; i++) {
                if (target && target.properties && propPath[i] in target.properties) {
                    target = target[propPath[i]];
                }
                else {
                    // Stop if the path does not exist
                    target = null;
                    break;
                }
            }
            if (target && target.properties && propPath[propPath.length - 1] in target.properties) {
                resolvedProp = propPath[propPath.length - 1];
            }
            if (this._event_callbacks.has(cb)) {
                cb = this._event_callbacks.get(cb);
                this._event_callbacks.delete(cb);
            }
            // Detach watcher if property is found
            if (resolvedProp && target) {
                return target.property(resolvedProp).change.disconnect(cb);
            }
            else if (prop in this.properties) {
                return this.property(prop).change.disconnect(cb);
            }
            return false;
        }
        disconnect_watchers(view) {
            for (const p in this._esm_watchers) {
                const prop = this.data.properties[p];
                const remaining = [];
                for (const [wview, cb] of this._esm_watchers[p]) {
                    if (wview === view) {
                        prop?.change.disconnect(cb);
                    }
                    else {
                        remaining.push([wview, cb]);
                    }
                }
                if (remaining.length > 0) {
                    this._esm_watchers[p] = remaining;
                }
                else {
                    delete this._esm_watchers[p];
                }
            }
        }
        _declare_importmap() {
            if (this.importmap) {
                const importMap = { ...this.importmap };
                try {
                    // @ts-ignore
                    importShim.addImportMap(importMap);
                }
                catch (e) {
                    console.warn(`Failed to add import map: ${e}`);
                }
            }
        }
        _run_initializer(initialize) {
            const props = { model: this.model_proxy };
            this._destroyer = initialize(props);
        }
        destroy() {
            super.destroy();
            if (this._destroyer) {
                this._destroyer(this.model_proxy);
            }
        }
        init_module() {
            if (this.compile_error) {
                return;
            }
            else if (MODULE_CACHE.has(this._render_cache_key)) {
                this.render_module = MODULE_CACHE.get(this._render_cache_key);
            }
            else {
                const code = this._render_code();
                const render_url = URL.createObjectURL(new Blob([code], { type: "text/javascript" }));
                // @ts-ignore
                this.render_module = importShim(render_url);
                MODULE_CACHE.set(this._render_cache_key, this.render_module);
            }
        }
        _render_code() {
            return `
function render(id) {
  const view = Bokeh.index.find_one_by_id(id)
  if (view == null) {
    return null
  }

  const output = view.render_fn({
    view: view, model: view.model_proxy, data: view.model.data, el: view.container
  })

  Promise.resolve(output).then((out) => {
    if (out instanceof Element) {
      view.container.replaceChildren(out)
    }
    view.after_rendered()
  })
}

export default {render}`;
        }
        get _render_cache_key() {
            return "reactive_esm";
        }
        compile() {
            if (this.bundle != null) {
                return this.esm;
            }
            let compiled;
            try {
                compiled = (0, sucrase_1.transform)(this.esm, {
                    transforms: this.sucrase_transforms,
                    filePath: "render.tsx",
                }).code;
            }
            catch (e) {
                if (e instanceof SyntaxError) {
                    if (this.dev) {
                        this.compile_error = e;
                        return null;
                    }
                    else {
                        e.message = `${e.message}. See more information with '--dev' flag.`;
                        throw e;
                    }
                }
                else {
                    throw e;
                }
            }
            return compiled;
        }
        async recompile() {
            this.compile_error = null;
            const compiled = this.compile();
            if (compiled === null) {
                this.compiled_module = Promise.resolve(null);
                return;
            }
            this.compiled = compiled;
            this._declare_importmap();
            let esm_module;
            const use_cache = (!this.dev || this.bundle);
            const cache_key = (this.bundle === "url") ? this.esm : (this.bundle || `${this.class_name}-${this.esm.length}`);
            let resolve;
            if (use_cache && MODULE_CACHE.has(cache_key)) {
                esm_module = Promise.resolve(MODULE_CACHE.get(cache_key));
            }
            else {
                if (use_cache) {
                    MODULE_CACHE.set(cache_key, new Promise((res) => { resolve = res; }));
                }
                let url;
                if (this.bundle === "url") {
                    url = this.esm;
                }
                else {
                    url = URL.createObjectURL(new Blob([this.compiled], { type: "text/javascript" }));
                }
                esm_module = window.importShim(url);
            }
            this.compiled_module = esm_module.then((mod) => {
                if (resolve) {
                    resolve(mod);
                }
                try {
                    let initialize;
                    if (this.bundle != null && (mod.default || {}).hasOwnProperty(this.class_name)) {
                        mod = mod.default[this.class_name];
                    }
                    if (mod.initialize) {
                        initialize = mod.initialize;
                    }
                    else if (mod.default && mod.default.initialize) {
                        initialize = mod.default.initialize;
                    }
                    else if (typeof mod.default === "function") {
                        const initialized = mod.default();
                        mod = { default: initialized };
                        initialize = initialized.initialize;
                    }
                    if (initialize) {
                        this._run_initializer(initialize);
                    }
                    this.init_module();
                    return mod;
                }
                catch (e) {
                    if (this.dev) {
                        this.compile_error = e;
                    }
                    console.error(`Could not initialize module due to error: ${e}`);
                    return null;
                }
            });
        }
    }
    exports.ReactiveESM = ReactiveESM;
    _c = ReactiveESM;
    ReactiveESM.__name__ = "ReactiveESM";
    ReactiveESM.__module__ = "panel.models.esm";
    (() => {
        _c.prototype.default_view = ReactiveESMView;
        _c.define(({ Any, Array, Bool, Nullable, Str }) => ({
            css_bundle: [Nullable(Str), null],
            bundle: [Nullable(Str), null],
            children: [Array(Str), []],
            class_name: [Str, ""],
            data: [Any],
            dev: [Bool, false],
            esm: [Str, ""],
            events: [Array(Str), []],
            importmap: [Any, {}],
        }));
    })();
},
"48024289a4": /* sucrase\dist\esm\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.getVersion = getVersion;
    exports.transform = transform;
    exports.getFormattedTokens = getFormattedTokens;
    const tslib_1 = require("tslib");
    const CJSImportProcessor_1 = tslib_1.__importDefault(require("add4298d4c") /* ./CJSImportProcessor */);
    const computeSourceMap_1 = tslib_1.__importDefault(require("03a5a23920") /* ./computeSourceMap */);
    const HelperManager_1 = require("40e1a4d3af") /* ./HelperManager */;
    const identifyShadowedGlobals_1 = tslib_1.__importDefault(require("5f4ada3fc1") /* ./identifyShadowedGlobals */);
    const NameManager_1 = tslib_1.__importDefault(require("425f39b83e") /* ./NameManager */);
    const Options_1 = require("bb0c9c6022") /* ./Options */;
    const parser_1 = require("7a45c9fdec") /* ./parser */;
    const TokenProcessor_1 = tslib_1.__importDefault(require("1c7cc5e988") /* ./TokenProcessor */);
    const RootTransformer_1 = tslib_1.__importDefault(require("131f5202c7") /* ./transformers/RootTransformer */);
    const formatTokens_1 = tslib_1.__importDefault(require("2e6a9a5b28") /* ./util/formatTokens */);
    const getTSImportedNames_1 = tslib_1.__importDefault(require("4160f5108d") /* ./util/getTSImportedNames */);
    ;
    function getVersion() {
        /* istanbul ignore next */
        return "3.35.0";
    }
    function transform(code, options) {
        (0, Options_1.validateOptions)(options);
        try {
            const sucraseContext = getSucraseContext(code, options);
            const transformer = new RootTransformer_1.default(sucraseContext, options.transforms, Boolean(options.enableLegacyBabel5ModuleInterop), options);
            const transformerResult = transformer.transform();
            let result = { code: transformerResult.code };
            if (options.sourceMapOptions) {
                if (!options.filePath) {
                    throw new Error("filePath must be specified when generating a source map.");
                }
                result = {
                    ...result,
                    sourceMap: (0, computeSourceMap_1.default)(transformerResult, options.filePath, options.sourceMapOptions, code, sucraseContext.tokenProcessor.tokens),
                };
            }
            return result;
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (e) {
            if (options.filePath) {
                e.message = `Error transforming ${options.filePath}: ${e.message}`;
            }
            throw e;
        }
    }
    /**
     * Return a string representation of the sucrase tokens, mostly useful for
     * diagnostic purposes.
     */
    function getFormattedTokens(code, options) {
        const tokens = getSucraseContext(code, options).tokenProcessor.tokens;
        return (0, formatTokens_1.default)(code, tokens);
    }
    /**
     * Call into the parser/tokenizer and do some further preprocessing:
     * - Come up with a set of used names so that we can assign new names.
     * - Preprocess all import/export statements so we know which globals we are interested in.
     * - Compute situations where any of those globals are shadowed.
     *
     * In the future, some of these preprocessing steps can be skipped based on what actual work is
     * being done.
     */
    function getSucraseContext(code, options) {
        const isJSXEnabled = options.transforms.includes("jsx");
        const isTypeScriptEnabled = options.transforms.includes("typescript");
        const isFlowEnabled = options.transforms.includes("flow");
        const disableESTransforms = options.disableESTransforms === true;
        const file = (0, parser_1.parse)(code, isJSXEnabled, isTypeScriptEnabled, isFlowEnabled);
        const tokens = file.tokens;
        const scopes = file.scopes;
        const nameManager = new NameManager_1.default(code, tokens);
        const helperManager = new HelperManager_1.HelperManager(nameManager);
        const tokenProcessor = new TokenProcessor_1.default(code, tokens, isFlowEnabled, disableESTransforms, helperManager);
        const enableLegacyTypeScriptModuleInterop = Boolean(options.enableLegacyTypeScriptModuleInterop);
        let importProcessor = null;
        if (options.transforms.includes("imports")) {
            importProcessor = new CJSImportProcessor_1.default(nameManager, tokenProcessor, enableLegacyTypeScriptModuleInterop, options, options.transforms.includes("typescript"), Boolean(options.keepUnusedImports), helperManager);
            importProcessor.preprocessTokens();
            // We need to mark shadowed globals after processing imports so we know that the globals are,
            // but before type-only import pruning, since that relies on shadowing information.
            (0, identifyShadowedGlobals_1.default)(tokenProcessor, scopes, importProcessor.getGlobalNames());
            if (options.transforms.includes("typescript") && !options.keepUnusedImports) {
                importProcessor.pruneTypeOnlyImports();
            }
        }
        else if (options.transforms.includes("typescript") && !options.keepUnusedImports) {
            // Shadowed global detection is needed for TS implicit elision of imported names.
            (0, identifyShadowedGlobals_1.default)(tokenProcessor, scopes, (0, getTSImportedNames_1.default)(tokenProcessor));
        }
        return { tokenProcessor, scopes, nameManager, importProcessor, helperManager };
    }
},
"add4298d4c": /* sucrase\dist\esm\CJSImportProcessor.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const tokenizer_1 = require("bfb18d0576") /* ./parser/tokenizer */;
    const keywords_1 = require("99ff836c64") /* ./parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ./parser/tokenizer/types */;
    const getImportExportSpecifierInfo_1 = tslib_1.__importDefault(require("14d4ae78a4") /* ./util/getImportExportSpecifierInfo */);
    const getNonTypeIdentifiers_1 = require("1ff9c9004b") /* ./util/getNonTypeIdentifiers */;
    /**
     * Class responsible for preprocessing and bookkeeping import and export declarations within the
     * file.
     *
     * TypeScript uses a simpler mechanism that does not use functions like interopRequireDefault and
     * interopRequireWildcard, so we also allow that mode for compatibility.
     */
    class CJSImportProcessor {
        __init() { this.nonTypeIdentifiers = new Set(); }
        __init2() { this.importInfoByPath = new Map(); }
        __init3() { this.importsToReplace = new Map(); }
        __init4() { this.identifierReplacements = new Map(); }
        __init5() { this.exportBindingsByLocalName = new Map(); }
        constructor(nameManager, tokens, enableLegacyTypeScriptModuleInterop, options, isTypeScriptTransformEnabled, keepUnusedImports, helperManager) { ; this.nameManager = nameManager; this.tokens = tokens; this.enableLegacyTypeScriptModuleInterop = enableLegacyTypeScriptModuleInterop; this.options = options; this.isTypeScriptTransformEnabled = isTypeScriptTransformEnabled; this.keepUnusedImports = keepUnusedImports; this.helperManager = helperManager; CJSImportProcessor.prototype.__init.call(this); CJSImportProcessor.prototype.__init2.call(this); CJSImportProcessor.prototype.__init3.call(this); CJSImportProcessor.prototype.__init4.call(this); CJSImportProcessor.prototype.__init5.call(this); }
        preprocessTokens() {
            for (let i = 0; i < this.tokens.tokens.length; i++) {
                if (this.tokens.matches1AtIndex(i, types_1.TokenType._import) &&
                    !this.tokens.matches3AtIndex(i, types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.eq)) {
                    this.preprocessImportAtIndex(i);
                }
                if (this.tokens.matches1AtIndex(i, types_1.TokenType._export) &&
                    !this.tokens.matches2AtIndex(i, types_1.TokenType._export, types_1.TokenType.eq)) {
                    this.preprocessExportAtIndex(i);
                }
            }
            this.generateImportReplacements();
        }
        /**
         * In TypeScript, import statements that only import types should be removed.
         * This includes `import {} from 'foo';`, but not `import 'foo';`.
         */
        pruneTypeOnlyImports() {
            this.nonTypeIdentifiers = (0, getNonTypeIdentifiers_1.getNonTypeIdentifiers)(this.tokens, this.options);
            for (const [path, importInfo] of this.importInfoByPath.entries()) {
                if (importInfo.hasBareImport ||
                    importInfo.hasStarExport ||
                    importInfo.exportStarNames.length > 0 ||
                    importInfo.namedExports.length > 0) {
                    continue;
                }
                const names = [
                    ...importInfo.defaultNames,
                    ...importInfo.wildcardNames,
                    ...importInfo.namedImports.map(({ localName }) => localName),
                ];
                if (names.every((name) => this.shouldAutomaticallyElideImportedName(name))) {
                    this.importsToReplace.set(path, "");
                }
            }
        }
        shouldAutomaticallyElideImportedName(name) {
            return (this.isTypeScriptTransformEnabled &&
                !this.keepUnusedImports &&
                !this.nonTypeIdentifiers.has(name));
        }
        generateImportReplacements() {
            for (const [path, importInfo] of this.importInfoByPath.entries()) {
                const { defaultNames, wildcardNames, namedImports, namedExports, exportStarNames, hasStarExport, } = importInfo;
                if (defaultNames.length === 0 &&
                    wildcardNames.length === 0 &&
                    namedImports.length === 0 &&
                    namedExports.length === 0 &&
                    exportStarNames.length === 0 &&
                    !hasStarExport) {
                    // Import is never used, so don't even assign a name.
                    this.importsToReplace.set(path, `require('${path}');`);
                    continue;
                }
                const primaryImportName = this.getFreeIdentifierForPath(path);
                let secondaryImportName;
                if (this.enableLegacyTypeScriptModuleInterop) {
                    secondaryImportName = primaryImportName;
                }
                else {
                    secondaryImportName =
                        wildcardNames.length > 0 ? wildcardNames[0] : this.getFreeIdentifierForPath(path);
                }
                let requireCode = `var ${primaryImportName} = require('${path}');`;
                if (wildcardNames.length > 0) {
                    for (const wildcardName of wildcardNames) {
                        const moduleExpr = this.enableLegacyTypeScriptModuleInterop
                            ? primaryImportName
                            : `${this.helperManager.getHelperName("interopRequireWildcard")}(${primaryImportName})`;
                        requireCode += ` var ${wildcardName} = ${moduleExpr};`;
                    }
                }
                else if (exportStarNames.length > 0 && secondaryImportName !== primaryImportName) {
                    requireCode += ` var ${secondaryImportName} = ${this.helperManager.getHelperName("interopRequireWildcard")}(${primaryImportName});`;
                }
                else if (defaultNames.length > 0 && secondaryImportName !== primaryImportName) {
                    requireCode += ` var ${secondaryImportName} = ${this.helperManager.getHelperName("interopRequireDefault")}(${primaryImportName});`;
                }
                for (const { importedName, localName } of namedExports) {
                    requireCode += ` ${this.helperManager.getHelperName("createNamedExportFrom")}(${primaryImportName}, '${localName}', '${importedName}');`;
                }
                for (const exportStarName of exportStarNames) {
                    requireCode += ` exports.${exportStarName} = ${secondaryImportName};`;
                }
                if (hasStarExport) {
                    requireCode += ` ${this.helperManager.getHelperName("createStarExport")}(${primaryImportName});`;
                }
                this.importsToReplace.set(path, requireCode);
                for (const defaultName of defaultNames) {
                    this.identifierReplacements.set(defaultName, `${secondaryImportName}.default`);
                }
                for (const { importedName, localName } of namedImports) {
                    this.identifierReplacements.set(localName, `${primaryImportName}.${importedName}`);
                }
            }
        }
        getFreeIdentifierForPath(path) {
            const components = path.split("/");
            const lastComponent = components[components.length - 1];
            const baseName = lastComponent.replace(/\W/g, "");
            return this.nameManager.claimFreeName(`_${baseName}`);
        }
        preprocessImportAtIndex(index) {
            const defaultNames = [];
            const wildcardNames = [];
            const namedImports = [];
            index++;
            if ((this.tokens.matchesContextualAtIndex(index, keywords_1.ContextualKeyword._type) ||
                this.tokens.matches1AtIndex(index, types_1.TokenType._typeof)) &&
                !this.tokens.matches1AtIndex(index + 1, types_1.TokenType.comma) &&
                !this.tokens.matchesContextualAtIndex(index + 1, keywords_1.ContextualKeyword._from)) {
                // import type declaration, so no need to process anything.
                return;
            }
            if (this.tokens.matches1AtIndex(index, types_1.TokenType.parenL)) {
                // Dynamic import, so nothing to do
                return;
            }
            if (this.tokens.matches1AtIndex(index, types_1.TokenType.name)) {
                defaultNames.push(this.tokens.identifierNameAtIndex(index));
                index++;
                if (this.tokens.matches1AtIndex(index, types_1.TokenType.comma)) {
                    index++;
                }
            }
            if (this.tokens.matches1AtIndex(index, types_1.TokenType.star)) {
                // * as
                index += 2;
                wildcardNames.push(this.tokens.identifierNameAtIndex(index));
                index++;
            }
            if (this.tokens.matches1AtIndex(index, types_1.TokenType.braceL)) {
                const result = this.getNamedImports(index + 1);
                index = result.newIndex;
                for (const namedImport of result.namedImports) {
                    // Treat {default as X} as a default import to ensure usage of require interop helper
                    if (namedImport.importedName === "default") {
                        defaultNames.push(namedImport.localName);
                    }
                    else {
                        namedImports.push(namedImport);
                    }
                }
            }
            if (this.tokens.matchesContextualAtIndex(index, keywords_1.ContextualKeyword._from)) {
                index++;
            }
            if (!this.tokens.matches1AtIndex(index, types_1.TokenType.string)) {
                throw new Error("Expected string token at the end of import statement.");
            }
            const path = this.tokens.stringValueAtIndex(index);
            const importInfo = this.getImportInfo(path);
            importInfo.defaultNames.push(...defaultNames);
            importInfo.wildcardNames.push(...wildcardNames);
            importInfo.namedImports.push(...namedImports);
            if (defaultNames.length === 0 && wildcardNames.length === 0 && namedImports.length === 0) {
                importInfo.hasBareImport = true;
            }
        }
        preprocessExportAtIndex(index) {
            if (this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType._var) ||
                this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType._let) ||
                this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType._const)) {
                this.preprocessVarExportAtIndex(index);
            }
            else if (this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType._function) ||
                this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType._class)) {
                const exportName = this.tokens.identifierNameAtIndex(index + 2);
                this.addExportBinding(exportName, exportName);
            }
            else if (this.tokens.matches3AtIndex(index, types_1.TokenType._export, types_1.TokenType.name, types_1.TokenType._function)) {
                const exportName = this.tokens.identifierNameAtIndex(index + 3);
                this.addExportBinding(exportName, exportName);
            }
            else if (this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType.braceL)) {
                this.preprocessNamedExportAtIndex(index);
            }
            else if (this.tokens.matches2AtIndex(index, types_1.TokenType._export, types_1.TokenType.star)) {
                this.preprocessExportStarAtIndex(index);
            }
        }
        preprocessVarExportAtIndex(index) {
            let depth = 0;
            // Handle cases like `export let {x} = y;`, starting at the open-brace in that case.
            for (let i = index + 2;; i++) {
                if (this.tokens.matches1AtIndex(i, types_1.TokenType.braceL) ||
                    this.tokens.matches1AtIndex(i, types_1.TokenType.dollarBraceL) ||
                    this.tokens.matches1AtIndex(i, types_1.TokenType.bracketL)) {
                    depth++;
                }
                else if (this.tokens.matches1AtIndex(i, types_1.TokenType.braceR) ||
                    this.tokens.matches1AtIndex(i, types_1.TokenType.bracketR)) {
                    depth--;
                }
                else if (depth === 0 && !this.tokens.matches1AtIndex(i, types_1.TokenType.name)) {
                    break;
                }
                else if (this.tokens.matches1AtIndex(1, types_1.TokenType.eq)) {
                    const endIndex = this.tokens.currentToken().rhsEndIndex;
                    if (endIndex == null) {
                        throw new Error("Expected = token with an end index.");
                    }
                    i = endIndex - 1;
                }
                else {
                    const token = this.tokens.tokens[i];
                    if ((0, tokenizer_1.isDeclaration)(token)) {
                        const exportName = this.tokens.identifierNameAtIndex(i);
                        this.identifierReplacements.set(exportName, `exports.${exportName}`);
                    }
                }
            }
        }
        /**
         * Walk this export statement just in case it's an export...from statement.
         * If it is, combine it into the import info for that path. Otherwise, just
         * bail out; it'll be handled later.
         */
        preprocessNamedExportAtIndex(index) {
            // export {
            index += 2;
            const { newIndex, namedImports } = this.getNamedImports(index);
            index = newIndex;
            if (this.tokens.matchesContextualAtIndex(index, keywords_1.ContextualKeyword._from)) {
                index++;
            }
            else {
                // Reinterpret "a as b" to be local/exported rather than imported/local.
                for (const { importedName: localName, localName: exportedName } of namedImports) {
                    this.addExportBinding(localName, exportedName);
                }
                return;
            }
            if (!this.tokens.matches1AtIndex(index, types_1.TokenType.string)) {
                throw new Error("Expected string token at the end of import statement.");
            }
            const path = this.tokens.stringValueAtIndex(index);
            const importInfo = this.getImportInfo(path);
            importInfo.namedExports.push(...namedImports);
        }
        preprocessExportStarAtIndex(index) {
            let exportedName = null;
            if (this.tokens.matches3AtIndex(index, types_1.TokenType._export, types_1.TokenType.star, types_1.TokenType._as)) {
                // export * as
                index += 3;
                exportedName = this.tokens.identifierNameAtIndex(index);
                // foo from
                index += 2;
            }
            else {
                // export * from
                index += 3;
            }
            if (!this.tokens.matches1AtIndex(index, types_1.TokenType.string)) {
                throw new Error("Expected string token at the end of star export statement.");
            }
            const path = this.tokens.stringValueAtIndex(index);
            const importInfo = this.getImportInfo(path);
            if (exportedName !== null) {
                importInfo.exportStarNames.push(exportedName);
            }
            else {
                importInfo.hasStarExport = true;
            }
        }
        getNamedImports(index) {
            const namedImports = [];
            while (true) {
                if (this.tokens.matches1AtIndex(index, types_1.TokenType.braceR)) {
                    index++;
                    break;
                }
                const specifierInfo = (0, getImportExportSpecifierInfo_1.default)(this.tokens, index);
                index = specifierInfo.endIndex;
                if (!specifierInfo.isType) {
                    namedImports.push({
                        importedName: specifierInfo.leftName,
                        localName: specifierInfo.rightName,
                    });
                }
                if (this.tokens.matches2AtIndex(index, types_1.TokenType.comma, types_1.TokenType.braceR)) {
                    index += 2;
                    break;
                }
                else if (this.tokens.matches1AtIndex(index, types_1.TokenType.braceR)) {
                    index++;
                    break;
                }
                else if (this.tokens.matches1AtIndex(index, types_1.TokenType.comma)) {
                    index++;
                }
                else {
                    throw new Error(`Unexpected token: ${JSON.stringify(this.tokens.tokens[index])}`);
                }
            }
            return { newIndex: index, namedImports };
        }
        /**
         * Get a mutable import info object for this path, creating one if it doesn't
         * exist yet.
         */
        getImportInfo(path) {
            const existingInfo = this.importInfoByPath.get(path);
            if (existingInfo) {
                return existingInfo;
            }
            const newInfo = {
                defaultNames: [],
                wildcardNames: [],
                namedImports: [],
                namedExports: [],
                hasBareImport: false,
                exportStarNames: [],
                hasStarExport: false,
            };
            this.importInfoByPath.set(path, newInfo);
            return newInfo;
        }
        addExportBinding(localName, exportedName) {
            if (!this.exportBindingsByLocalName.has(localName)) {
                this.exportBindingsByLocalName.set(localName, []);
            }
            this.exportBindingsByLocalName.get(localName).push(exportedName);
        }
        /**
         * Return the code to use for the import for this path, or the empty string if
         * the code has already been "claimed" by a previous import.
         */
        claimImportCode(importPath) {
            const result = this.importsToReplace.get(importPath);
            this.importsToReplace.set(importPath, "");
            return result || "";
        }
        getIdentifierReplacement(identifierName) {
            return this.identifierReplacements.get(identifierName) || null;
        }
        /**
         * Return a string like `exports.foo = exports.bar`.
         */
        resolveExportBinding(assignedName) {
            const exportedNames = this.exportBindingsByLocalName.get(assignedName);
            if (!exportedNames || exportedNames.length === 0) {
                return null;
            }
            return exportedNames.map((exportedName) => `exports.${exportedName}`).join(" = ");
        }
        /**
         * Return all imported/exported names where we might be interested in whether usages of those
         * names are shadowed.
         */
        getGlobalNames() {
            return new Set([
                ...this.identifierReplacements.keys(),
                ...this.exportBindingsByLocalName.keys(),
            ]);
        }
    }
    exports.default = CJSImportProcessor;
},
"bfb18d0576": /* sucrase\dist\esm\parser\tokenizer\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.isDeclaration = isDeclaration;
    exports.isNonTopLevelDeclaration = isNonTopLevelDeclaration;
    exports.isTopLevelDeclaration = isTopLevelDeclaration;
    exports.isBlockScopedDeclaration = isBlockScopedDeclaration;
    exports.isFunctionScopedDeclaration = isFunctionScopedDeclaration;
    exports.isObjectShorthandDeclaration = isObjectShorthandDeclaration;
    exports.next = next;
    exports.nextTemplateToken = nextTemplateToken;
    exports.retokenizeSlashAsRegex = retokenizeSlashAsRegex;
    exports.pushTypeContext = pushTypeContext;
    exports.popTypeContext = popTypeContext;
    exports.eat = eat;
    exports.eatTypeToken = eatTypeToken;
    exports.match = match;
    exports.lookaheadType = lookaheadType;
    exports.lookaheadTypeAndKeyword = lookaheadTypeAndKeyword;
    exports.nextTokenStart = nextTokenStart;
    exports.nextTokenStartSince = nextTokenStartSince;
    exports.lookaheadCharCode = lookaheadCharCode;
    exports.nextToken = nextToken;
    exports.skipLineComment = skipLineComment;
    exports.skipSpace = skipSpace;
    exports.finishToken = finishToken;
    exports.rescan_gt = rescan_gt;
    exports.getTokenFromCode = getTokenFromCode;
    exports.skipWord = skipWord;
    const tslib_1 = require("tslib");
    const base_1 = require("540718e523") /* ../traverser/base */;
    const util_1 = require("bc94bbadc1") /* ../traverser/util */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const identifier_1 = require("364148c9f0") /* ../util/identifier */;
    const whitespace_1 = require("2a3176644a") /* ../util/whitespace */;
    const keywords_1 = require("99ff836c64") /* ./keywords */;
    const readWord_1 = tslib_1.__importDefault(require("e6eb78033b") /* ./readWord */);
    const types_1 = require("f0c35cbd76") /* ./types */;
    (function (IdentifierRole) {
        const Access = 0;
        IdentifierRole[IdentifierRole["Access"] = Access] = "Access";
        const ExportAccess = Access + 1;
        IdentifierRole[IdentifierRole["ExportAccess"] = ExportAccess] = "ExportAccess";
        const TopLevelDeclaration = ExportAccess + 1;
        IdentifierRole[IdentifierRole["TopLevelDeclaration"] = TopLevelDeclaration] = "TopLevelDeclaration";
        const FunctionScopedDeclaration = TopLevelDeclaration + 1;
        IdentifierRole[IdentifierRole["FunctionScopedDeclaration"] = FunctionScopedDeclaration] = "FunctionScopedDeclaration";
        const BlockScopedDeclaration = FunctionScopedDeclaration + 1;
        IdentifierRole[IdentifierRole["BlockScopedDeclaration"] = BlockScopedDeclaration] = "BlockScopedDeclaration";
        const ObjectShorthandTopLevelDeclaration = BlockScopedDeclaration + 1;
        IdentifierRole[IdentifierRole["ObjectShorthandTopLevelDeclaration"] = ObjectShorthandTopLevelDeclaration] = "ObjectShorthandTopLevelDeclaration";
        const ObjectShorthandFunctionScopedDeclaration = ObjectShorthandTopLevelDeclaration + 1;
        IdentifierRole[IdentifierRole["ObjectShorthandFunctionScopedDeclaration"] = ObjectShorthandFunctionScopedDeclaration] = "ObjectShorthandFunctionScopedDeclaration";
        const ObjectShorthandBlockScopedDeclaration = ObjectShorthandFunctionScopedDeclaration + 1;
        IdentifierRole[IdentifierRole["ObjectShorthandBlockScopedDeclaration"] = ObjectShorthandBlockScopedDeclaration] = "ObjectShorthandBlockScopedDeclaration";
        const ObjectShorthand = ObjectShorthandBlockScopedDeclaration + 1;
        IdentifierRole[IdentifierRole["ObjectShorthand"] = ObjectShorthand] = "ObjectShorthand";
        // Any identifier bound in an import statement, e.g. both A and b from
        // `import A, * as b from 'A';`
        const ImportDeclaration = ObjectShorthand + 1;
        IdentifierRole[IdentifierRole["ImportDeclaration"] = ImportDeclaration] = "ImportDeclaration";
        const ObjectKey = ImportDeclaration + 1;
        IdentifierRole[IdentifierRole["ObjectKey"] = ObjectKey] = "ObjectKey";
        // The `foo` in `import {foo as bar} from "./abc";`.
        const ImportAccess = ObjectKey + 1;
        IdentifierRole[IdentifierRole["ImportAccess"] = ImportAccess] = "ImportAccess";
    })(exports.IdentifierRole || (exports.IdentifierRole = {}));
    (function (JSXRole) {
        // The element is self-closing or has a body that resolves to empty. We
        // shouldn't emit children at all in this case.
        const NoChildren = 0;
        JSXRole[JSXRole["NoChildren"] = NoChildren] = "NoChildren";
        // The element has a single explicit child, which might still be an arbitrary
        // expression like an array. We should emit that expression as the children.
        const OneChild = NoChildren + 1;
        JSXRole[JSXRole["OneChild"] = OneChild] = "OneChild";
        // The element has at least two explicitly-specified children or has spread
        // children, so child positions are assumed to be "static". We should wrap
        // these children in an array.
        const StaticChildren = OneChild + 1;
        JSXRole[JSXRole["StaticChildren"] = StaticChildren] = "StaticChildren";
        // The element has a prop named "key" after a prop spread, so we should fall
        // back to the createElement function.
        const KeyAfterPropSpread = StaticChildren + 1;
        JSXRole[JSXRole["KeyAfterPropSpread"] = KeyAfterPropSpread] = "KeyAfterPropSpread";
    })(exports.JSXRole || (exports.JSXRole = {}));
    function isDeclaration(token) {
        const role = token.identifierRole;
        return (role === exports.IdentifierRole.TopLevelDeclaration ||
            role === exports.IdentifierRole.FunctionScopedDeclaration ||
            role === exports.IdentifierRole.BlockScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandTopLevelDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandFunctionScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandBlockScopedDeclaration);
    }
    function isNonTopLevelDeclaration(token) {
        const role = token.identifierRole;
        return (role === exports.IdentifierRole.FunctionScopedDeclaration ||
            role === exports.IdentifierRole.BlockScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandFunctionScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandBlockScopedDeclaration);
    }
    function isTopLevelDeclaration(token) {
        const role = token.identifierRole;
        return (role === exports.IdentifierRole.TopLevelDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandTopLevelDeclaration ||
            role === exports.IdentifierRole.ImportDeclaration);
    }
    function isBlockScopedDeclaration(token) {
        const role = token.identifierRole;
        // Treat top-level declarations as block scope since the distinction doesn't matter here.
        return (role === exports.IdentifierRole.TopLevelDeclaration ||
            role === exports.IdentifierRole.BlockScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandTopLevelDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandBlockScopedDeclaration);
    }
    function isFunctionScopedDeclaration(token) {
        const role = token.identifierRole;
        return (role === exports.IdentifierRole.FunctionScopedDeclaration ||
            role === exports.IdentifierRole.ObjectShorthandFunctionScopedDeclaration);
    }
    function isObjectShorthandDeclaration(token) {
        return (token.identifierRole === exports.IdentifierRole.ObjectShorthandTopLevelDeclaration ||
            token.identifierRole === exports.IdentifierRole.ObjectShorthandBlockScopedDeclaration ||
            token.identifierRole === exports.IdentifierRole.ObjectShorthandFunctionScopedDeclaration);
    }
    // Object type used to represent tokens. Note that normally, tokens
    // simply exist as properties on the parser object. This is only
    // used for the onToken callback and the external tokenizer.
    class Token {
        constructor() {
            this.type = base_1.state.type;
            this.contextualKeyword = base_1.state.contextualKeyword;
            this.start = base_1.state.start;
            this.end = base_1.state.end;
            this.scopeDepth = base_1.state.scopeDepth;
            this.isType = base_1.state.isType;
            this.identifierRole = null;
            this.jsxRole = null;
            this.shadowsGlobal = false;
            this.isAsyncOperation = false;
            this.contextId = null;
            this.rhsEndIndex = null;
            this.isExpression = false;
            this.numNullishCoalesceStarts = 0;
            this.numNullishCoalesceEnds = 0;
            this.isOptionalChainStart = false;
            this.isOptionalChainEnd = false;
            this.subscriptStartIndex = null;
            this.nullishStartIndex = null;
        }
    }
    exports.Token = Token;
    // ## Tokenizer
    // Move to the next token
    function next() {
        base_1.state.tokens.push(new Token());
        nextToken();
    }
    // Call instead of next when inside a template, since that needs to be handled differently.
    function nextTemplateToken() {
        base_1.state.tokens.push(new Token());
        base_1.state.start = base_1.state.pos;
        readTmplToken();
    }
    // The tokenizer never parses regexes by default. Instead, the parser is responsible for
    // instructing it to parse a regex when we see a slash at the start of an expression.
    function retokenizeSlashAsRegex() {
        if (base_1.state.type === types_1.TokenType.assign) {
            --base_1.state.pos;
        }
        readRegexp();
    }
    function pushTypeContext(existingTokensInType) {
        for (let i = base_1.state.tokens.length - existingTokensInType; i < base_1.state.tokens.length; i++) {
            base_1.state.tokens[i].isType = true;
        }
        const oldIsType = base_1.state.isType;
        base_1.state.isType = true;
        return oldIsType;
    }
    function popTypeContext(oldIsType) {
        base_1.state.isType = oldIsType;
    }
    function eat(type) {
        if (match(type)) {
            next();
            return true;
        }
        else {
            return false;
        }
    }
    function eatTypeToken(tokenType) {
        const oldIsType = base_1.state.isType;
        base_1.state.isType = true;
        eat(tokenType);
        base_1.state.isType = oldIsType;
    }
    function match(type) {
        return base_1.state.type === type;
    }
    function lookaheadType() {
        const snapshot = base_1.state.snapshot();
        next();
        const type = base_1.state.type;
        base_1.state.restoreFromSnapshot(snapshot);
        return type;
    }
    class TypeAndKeyword {
        constructor(type, contextualKeyword) {
            this.type = type;
            this.contextualKeyword = contextualKeyword;
        }
    }
    exports.TypeAndKeyword = TypeAndKeyword;
    function lookaheadTypeAndKeyword() {
        const snapshot = base_1.state.snapshot();
        next();
        const type = base_1.state.type;
        const contextualKeyword = base_1.state.contextualKeyword;
        base_1.state.restoreFromSnapshot(snapshot);
        return new TypeAndKeyword(type, contextualKeyword);
    }
    function nextTokenStart() {
        return nextTokenStartSince(base_1.state.pos);
    }
    function nextTokenStartSince(pos) {
        whitespace_1.skipWhiteSpace.lastIndex = pos;
        const skip = whitespace_1.skipWhiteSpace.exec(base_1.input);
        return pos + skip[0].length;
    }
    function lookaheadCharCode() {
        return base_1.input.charCodeAt(nextTokenStart());
    }
    // Read a single token, updating the parser object's token-related
    // properties.
    function nextToken() {
        skipSpace();
        base_1.state.start = base_1.state.pos;
        if (base_1.state.pos >= base_1.input.length) {
            const tokens = base_1.state.tokens;
            // We normally run past the end a bit, but if we're way past the end, avoid an infinite loop.
            // Also check the token positions rather than the types since sometimes we rewrite the token
            // type to something else.
            if (tokens.length >= 2 &&
                tokens[tokens.length - 1].start >= base_1.input.length &&
                tokens[tokens.length - 2].start >= base_1.input.length) {
                (0, util_1.unexpected)("Unexpectedly reached the end of input.");
            }
            finishToken(types_1.TokenType.eof);
            return;
        }
        readToken(base_1.input.charCodeAt(base_1.state.pos));
    }
    function readToken(code) {
        // Identifier or keyword. '\uXXXX' sequences are allowed in
        // identifiers, so '\' also dispatches to that.
        if (identifier_1.IS_IDENTIFIER_START[code] ||
            code === charcodes_1.charCodes.backslash ||
            (code === charcodes_1.charCodes.atSign && base_1.input.charCodeAt(base_1.state.pos + 1) === charcodes_1.charCodes.atSign)) {
            (0, readWord_1.default)();
        }
        else {
            getTokenFromCode(code);
        }
    }
    function skipBlockComment() {
        while (base_1.input.charCodeAt(base_1.state.pos) !== charcodes_1.charCodes.asterisk ||
            base_1.input.charCodeAt(base_1.state.pos + 1) !== charcodes_1.charCodes.slash) {
            base_1.state.pos++;
            if (base_1.state.pos > base_1.input.length) {
                (0, util_1.unexpected)("Unterminated comment", base_1.state.pos - 2);
                return;
            }
        }
        base_1.state.pos += 2;
    }
    function skipLineComment(startSkip) {
        let ch = base_1.input.charCodeAt((base_1.state.pos += startSkip));
        if (base_1.state.pos < base_1.input.length) {
            while (ch !== charcodes_1.charCodes.lineFeed &&
                ch !== charcodes_1.charCodes.carriageReturn &&
                ch !== charcodes_1.charCodes.lineSeparator &&
                ch !== charcodes_1.charCodes.paragraphSeparator &&
                ++base_1.state.pos < base_1.input.length) {
                ch = base_1.input.charCodeAt(base_1.state.pos);
            }
        }
    }
    // Called at the start of the parse and after every token. Skips
    // whitespace and comments.
    function skipSpace() {
        while (base_1.state.pos < base_1.input.length) {
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            switch (ch) {
                case charcodes_1.charCodes.carriageReturn:
                    if (base_1.input.charCodeAt(base_1.state.pos + 1) === charcodes_1.charCodes.lineFeed) {
                        ++base_1.state.pos;
                    }
                case charcodes_1.charCodes.lineFeed:
                case charcodes_1.charCodes.lineSeparator:
                case charcodes_1.charCodes.paragraphSeparator:
                    ++base_1.state.pos;
                    break;
                case charcodes_1.charCodes.slash:
                    switch (base_1.input.charCodeAt(base_1.state.pos + 1)) {
                        case charcodes_1.charCodes.asterisk:
                            base_1.state.pos += 2;
                            skipBlockComment();
                            break;
                        case charcodes_1.charCodes.slash:
                            skipLineComment(2);
                            break;
                        default:
                            return;
                    }
                    break;
                default:
                    if (whitespace_1.IS_WHITESPACE[ch]) {
                        ++base_1.state.pos;
                    }
                    else {
                        return;
                    }
            }
        }
    }
    // Called at the end of every token. Sets various fields, and skips the space after the token, so
    // that the next one's `start` will point at the right position.
    function finishToken(type, contextualKeyword = keywords_1.ContextualKeyword.NONE) {
        base_1.state.end = base_1.state.pos;
        base_1.state.type = type;
        base_1.state.contextualKeyword = contextualKeyword;
    }
    // ### Token reading
    // This is the function that is called to fetch the next token. It
    // is somewhat obscure, because it works in character codes rather
    // than characters, and because operator parsing has been inlined
    // into it.
    //
    // All in the name of speed.
    function readToken_dot() {
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar >= charcodes_1.charCodes.digit0 && nextChar <= charcodes_1.charCodes.digit9) {
            readNumber(true);
            return;
        }
        if (nextChar === charcodes_1.charCodes.dot && base_1.input.charCodeAt(base_1.state.pos + 2) === charcodes_1.charCodes.dot) {
            base_1.state.pos += 3;
            finishToken(types_1.TokenType.ellipsis);
        }
        else {
            ++base_1.state.pos;
            finishToken(types_1.TokenType.dot);
        }
    }
    function readToken_slash() {
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            finishOp(types_1.TokenType.assign, 2);
        }
        else {
            finishOp(types_1.TokenType.slash, 1);
        }
    }
    function readToken_mult_modulo(code) {
        // '%*'
        let tokenType = code === charcodes_1.charCodes.asterisk ? types_1.TokenType.star : types_1.TokenType.modulo;
        let width = 1;
        let nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        // Exponentiation operator **
        if (code === charcodes_1.charCodes.asterisk && nextChar === charcodes_1.charCodes.asterisk) {
            width++;
            nextChar = base_1.input.charCodeAt(base_1.state.pos + 2);
            tokenType = types_1.TokenType.exponent;
        }
        // Match *= or %=, disallowing *=> which can be valid in flow.
        if (nextChar === charcodes_1.charCodes.equalsTo &&
            base_1.input.charCodeAt(base_1.state.pos + 2) !== charcodes_1.charCodes.greaterThan) {
            width++;
            tokenType = types_1.TokenType.assign;
        }
        finishOp(tokenType, width);
    }
    function readToken_pipe_amp(code) {
        // '|&'
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === code) {
            if (base_1.input.charCodeAt(base_1.state.pos + 2) === charcodes_1.charCodes.equalsTo) {
                // ||= or &&=
                finishOp(types_1.TokenType.assign, 3);
            }
            else {
                // || or &&
                finishOp(code === charcodes_1.charCodes.verticalBar ? types_1.TokenType.logicalOR : types_1.TokenType.logicalAND, 2);
            }
            return;
        }
        if (code === charcodes_1.charCodes.verticalBar) {
            // '|>'
            if (nextChar === charcodes_1.charCodes.greaterThan) {
                finishOp(types_1.TokenType.pipeline, 2);
                return;
            }
            else if (nextChar === charcodes_1.charCodes.rightCurlyBrace && base_1.isFlowEnabled) {
                // '|}'
                finishOp(types_1.TokenType.braceBarR, 2);
                return;
            }
        }
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            finishOp(types_1.TokenType.assign, 2);
            return;
        }
        finishOp(code === charcodes_1.charCodes.verticalBar ? types_1.TokenType.bitwiseOR : types_1.TokenType.bitwiseAND, 1);
    }
    function readToken_caret() {
        // '^'
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            finishOp(types_1.TokenType.assign, 2);
        }
        else {
            finishOp(types_1.TokenType.bitwiseXOR, 1);
        }
    }
    function readToken_plus_min(code) {
        // '+-'
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === code) {
            // Tentatively call this a prefix operator, but it might be changed to postfix later.
            finishOp(types_1.TokenType.preIncDec, 2);
            return;
        }
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            finishOp(types_1.TokenType.assign, 2);
        }
        else if (code === charcodes_1.charCodes.plusSign) {
            finishOp(types_1.TokenType.plus, 1);
        }
        else {
            finishOp(types_1.TokenType.minus, 1);
        }
    }
    function readToken_lt() {
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === charcodes_1.charCodes.lessThan) {
            if (base_1.input.charCodeAt(base_1.state.pos + 2) === charcodes_1.charCodes.equalsTo) {
                finishOp(types_1.TokenType.assign, 3);
                return;
            }
            // We see <<, but need to be really careful about whether to treat it as a
            // true left-shift or as two < tokens.
            if (base_1.state.isType) {
                // Within a type, << might come up in a snippet like `Array<<T>() => void>`,
                // so treat it as two < tokens. Importantly, this should only override <<
                // rather than other tokens like <= . If we treated <= as < in a type
                // context, then the snippet `a as T <= 1` would incorrectly start parsing
                // a type argument on T. We don't need to worry about `a as T << 1`
                // because TypeScript disallows that syntax.
                finishOp(types_1.TokenType.lessThan, 1);
            }
            else {
                // Outside a type, this might be a true left-shift operator, or it might
                // still be two open-type-arg tokens, such as in `f<<T>() => void>()`. We
                // look at the token while considering the `f`, so we don't yet know that
                // we're in a type context. In this case, we initially tokenize as a
                // left-shift and correct after-the-fact as necessary in
                // tsParseTypeArgumentsWithPossibleBitshift .
                finishOp(types_1.TokenType.bitShiftL, 2);
            }
            return;
        }
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            // <=
            finishOp(types_1.TokenType.relationalOrEqual, 2);
        }
        else {
            finishOp(types_1.TokenType.lessThan, 1);
        }
    }
    function readToken_gt() {
        if (base_1.state.isType) {
            // Avoid right-shift for things like `Array<Array<string>>` and
            // greater-than-or-equal for things like `const a: Array<number>=[];`.
            finishOp(types_1.TokenType.greaterThan, 1);
            return;
        }
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === charcodes_1.charCodes.greaterThan) {
            const size = base_1.input.charCodeAt(base_1.state.pos + 2) === charcodes_1.charCodes.greaterThan ? 3 : 2;
            if (base_1.input.charCodeAt(base_1.state.pos + size) === charcodes_1.charCodes.equalsTo) {
                finishOp(types_1.TokenType.assign, size + 1);
                return;
            }
            finishOp(types_1.TokenType.bitShiftR, size);
            return;
        }
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            // >=
            finishOp(types_1.TokenType.relationalOrEqual, 2);
        }
        else {
            finishOp(types_1.TokenType.greaterThan, 1);
        }
    }
    /**
     * Reinterpret a possible > token when transitioning from a type to a non-type
     * context.
     *
     * This comes up in two situations where >= needs to be treated as one token:
     * - After an `as` expression, like in the code `a as T >= 1`.
     * - In a type argument in an expression context, e.g. `f(a < b, c >= d)`, we
     *   need to see the token as >= so that we get an error and backtrack to
     *   normal expression parsing.
     *
     * Other situations require >= to be seen as two tokens, e.g.
     * `const x: Array<T>=[];`, so it's important to treat > as its own token in
     * typical type parsing situations.
     */
    function rescan_gt() {
        if (base_1.state.type === types_1.TokenType.greaterThan) {
            base_1.state.pos -= 1;
            readToken_gt();
        }
    }
    function readToken_eq_excl(code) {
        // '=!'
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        if (nextChar === charcodes_1.charCodes.equalsTo) {
            finishOp(types_1.TokenType.equality, base_1.input.charCodeAt(base_1.state.pos + 2) === charcodes_1.charCodes.equalsTo ? 3 : 2);
            return;
        }
        if (code === charcodes_1.charCodes.equalsTo && nextChar === charcodes_1.charCodes.greaterThan) {
            // '=>'
            base_1.state.pos += 2;
            finishToken(types_1.TokenType.arrow);
            return;
        }
        finishOp(code === charcodes_1.charCodes.equalsTo ? types_1.TokenType.eq : types_1.TokenType.bang, 1);
    }
    function readToken_question() {
        // '?'
        const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
        const nextChar2 = base_1.input.charCodeAt(base_1.state.pos + 2);
        if (nextChar === charcodes_1.charCodes.questionMark &&
            // In Flow (but not TypeScript), ??string is a valid type that should be
            // tokenized as two individual ? tokens.
            !(base_1.isFlowEnabled && base_1.state.isType)) {
            if (nextChar2 === charcodes_1.charCodes.equalsTo) {
                // '??='
                finishOp(types_1.TokenType.assign, 3);
            }
            else {
                // '??'
                finishOp(types_1.TokenType.nullishCoalescing, 2);
            }
        }
        else if (nextChar === charcodes_1.charCodes.dot &&
            !(nextChar2 >= charcodes_1.charCodes.digit0 && nextChar2 <= charcodes_1.charCodes.digit9)) {
            // '.' not followed by a number
            base_1.state.pos += 2;
            finishToken(types_1.TokenType.questionDot);
        }
        else {
            ++base_1.state.pos;
            finishToken(types_1.TokenType.question);
        }
    }
    function getTokenFromCode(code) {
        switch (code) {
            case charcodes_1.charCodes.numberSign:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.hash);
                return;
            // The interpretation of a dot depends on whether it is followed
            // by a digit or another two dots.
            case charcodes_1.charCodes.dot:
                readToken_dot();
                return;
            // Punctuation tokens.
            case charcodes_1.charCodes.leftParenthesis:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.parenL);
                return;
            case charcodes_1.charCodes.rightParenthesis:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.parenR);
                return;
            case charcodes_1.charCodes.semicolon:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.semi);
                return;
            case charcodes_1.charCodes.comma:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.comma);
                return;
            case charcodes_1.charCodes.leftSquareBracket:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.bracketL);
                return;
            case charcodes_1.charCodes.rightSquareBracket:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.bracketR);
                return;
            case charcodes_1.charCodes.leftCurlyBrace:
                if (base_1.isFlowEnabled && base_1.input.charCodeAt(base_1.state.pos + 1) === charcodes_1.charCodes.verticalBar) {
                    finishOp(types_1.TokenType.braceBarL, 2);
                }
                else {
                    ++base_1.state.pos;
                    finishToken(types_1.TokenType.braceL);
                }
                return;
            case charcodes_1.charCodes.rightCurlyBrace:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.braceR);
                return;
            case charcodes_1.charCodes.colon:
                if (base_1.input.charCodeAt(base_1.state.pos + 1) === charcodes_1.charCodes.colon) {
                    finishOp(types_1.TokenType.doubleColon, 2);
                }
                else {
                    ++base_1.state.pos;
                    finishToken(types_1.TokenType.colon);
                }
                return;
            case charcodes_1.charCodes.questionMark:
                readToken_question();
                return;
            case charcodes_1.charCodes.atSign:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.at);
                return;
            case charcodes_1.charCodes.graveAccent:
                ++base_1.state.pos;
                finishToken(types_1.TokenType.backQuote);
                return;
            case charcodes_1.charCodes.digit0: {
                const nextChar = base_1.input.charCodeAt(base_1.state.pos + 1);
                // '0x', '0X', '0o', '0O', '0b', '0B'
                if (nextChar === charcodes_1.charCodes.lowercaseX ||
                    nextChar === charcodes_1.charCodes.uppercaseX ||
                    nextChar === charcodes_1.charCodes.lowercaseO ||
                    nextChar === charcodes_1.charCodes.uppercaseO ||
                    nextChar === charcodes_1.charCodes.lowercaseB ||
                    nextChar === charcodes_1.charCodes.uppercaseB) {
                    readRadixNumber();
                    return;
                }
            }
            // Anything else beginning with a digit is an integer, octal
            // number, or float.
            case charcodes_1.charCodes.digit1:
            case charcodes_1.charCodes.digit2:
            case charcodes_1.charCodes.digit3:
            case charcodes_1.charCodes.digit4:
            case charcodes_1.charCodes.digit5:
            case charcodes_1.charCodes.digit6:
            case charcodes_1.charCodes.digit7:
            case charcodes_1.charCodes.digit8:
            case charcodes_1.charCodes.digit9:
                readNumber(false);
                return;
            // Quotes produce strings.
            case charcodes_1.charCodes.quotationMark:
            case charcodes_1.charCodes.apostrophe:
                readString(code);
                return;
            // Operators are parsed inline in tiny state machines. '=' (charCodes.equalsTo) is
            // often referred to. `finishOp` simply skips the amount of
            // characters it is given as second argument, and returns a token
            // of the type given by its first argument.
            case charcodes_1.charCodes.slash:
                readToken_slash();
                return;
            case charcodes_1.charCodes.percentSign:
            case charcodes_1.charCodes.asterisk:
                readToken_mult_modulo(code);
                return;
            case charcodes_1.charCodes.verticalBar:
            case charcodes_1.charCodes.ampersand:
                readToken_pipe_amp(code);
                return;
            case charcodes_1.charCodes.caret:
                readToken_caret();
                return;
            case charcodes_1.charCodes.plusSign:
            case charcodes_1.charCodes.dash:
                readToken_plus_min(code);
                return;
            case charcodes_1.charCodes.lessThan:
                readToken_lt();
                return;
            case charcodes_1.charCodes.greaterThan:
                readToken_gt();
                return;
            case charcodes_1.charCodes.equalsTo:
            case charcodes_1.charCodes.exclamationMark:
                readToken_eq_excl(code);
                return;
            case charcodes_1.charCodes.tilde:
                finishOp(types_1.TokenType.tilde, 1);
                return;
            default:
                break;
        }
        (0, util_1.unexpected)(`Unexpected character '${String.fromCharCode(code)}'`, base_1.state.pos);
    }
    function finishOp(type, size) {
        base_1.state.pos += size;
        finishToken(type);
    }
    function readRegexp() {
        const start = base_1.state.pos;
        let escaped = false;
        let inClass = false;
        for (;;) {
            if (base_1.state.pos >= base_1.input.length) {
                (0, util_1.unexpected)("Unterminated regular expression", start);
                return;
            }
            const code = base_1.input.charCodeAt(base_1.state.pos);
            if (escaped) {
                escaped = false;
            }
            else {
                if (code === charcodes_1.charCodes.leftSquareBracket) {
                    inClass = true;
                }
                else if (code === charcodes_1.charCodes.rightSquareBracket && inClass) {
                    inClass = false;
                }
                else if (code === charcodes_1.charCodes.slash && !inClass) {
                    break;
                }
                escaped = code === charcodes_1.charCodes.backslash;
            }
            ++base_1.state.pos;
        }
        ++base_1.state.pos;
        // Need to use `skipWord` because '\uXXXX' sequences are allowed here (don't ask).
        skipWord();
        finishToken(types_1.TokenType.regexp);
    }
    /**
     * Read a decimal integer. Note that this can't be unified with the similar code
     * in readRadixNumber (which also handles hex digits) because "e" needs to be
     * the end of the integer so that we can properly handle scientific notation.
     */
    function readInt() {
        while (true) {
            const code = base_1.input.charCodeAt(base_1.state.pos);
            if ((code >= charcodes_1.charCodes.digit0 && code <= charcodes_1.charCodes.digit9) || code === charcodes_1.charCodes.underscore) {
                base_1.state.pos++;
            }
            else {
                break;
            }
        }
    }
    function readRadixNumber() {
        base_1.state.pos += 2; // 0x
        // Walk to the end of the number, allowing hex digits.
        while (true) {
            const code = base_1.input.charCodeAt(base_1.state.pos);
            if ((code >= charcodes_1.charCodes.digit0 && code <= charcodes_1.charCodes.digit9) ||
                (code >= charcodes_1.charCodes.lowercaseA && code <= charcodes_1.charCodes.lowercaseF) ||
                (code >= charcodes_1.charCodes.uppercaseA && code <= charcodes_1.charCodes.uppercaseF) ||
                code === charcodes_1.charCodes.underscore) {
                base_1.state.pos++;
            }
            else {
                break;
            }
        }
        const nextChar = base_1.input.charCodeAt(base_1.state.pos);
        if (nextChar === charcodes_1.charCodes.lowercaseN) {
            ++base_1.state.pos;
            finishToken(types_1.TokenType.bigint);
        }
        else {
            finishToken(types_1.TokenType.num);
        }
    }
    // Read an integer, octal integer, or floating-point number.
    function readNumber(startsWithDot) {
        let isBigInt = false;
        let isDecimal = false;
        if (!startsWithDot) {
            readInt();
        }
        let nextChar = base_1.input.charCodeAt(base_1.state.pos);
        if (nextChar === charcodes_1.charCodes.dot) {
            ++base_1.state.pos;
            readInt();
            nextChar = base_1.input.charCodeAt(base_1.state.pos);
        }
        if (nextChar === charcodes_1.charCodes.uppercaseE || nextChar === charcodes_1.charCodes.lowercaseE) {
            nextChar = base_1.input.charCodeAt(++base_1.state.pos);
            if (nextChar === charcodes_1.charCodes.plusSign || nextChar === charcodes_1.charCodes.dash) {
                ++base_1.state.pos;
            }
            readInt();
            nextChar = base_1.input.charCodeAt(base_1.state.pos);
        }
        if (nextChar === charcodes_1.charCodes.lowercaseN) {
            ++base_1.state.pos;
            isBigInt = true;
        }
        else if (nextChar === charcodes_1.charCodes.lowercaseM) {
            ++base_1.state.pos;
            isDecimal = true;
        }
        if (isBigInt) {
            finishToken(types_1.TokenType.bigint);
            return;
        }
        if (isDecimal) {
            finishToken(types_1.TokenType.decimal);
            return;
        }
        finishToken(types_1.TokenType.num);
    }
    function readString(quote) {
        base_1.state.pos++;
        for (;;) {
            if (base_1.state.pos >= base_1.input.length) {
                (0, util_1.unexpected)("Unterminated string constant");
                return;
            }
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            if (ch === charcodes_1.charCodes.backslash) {
                base_1.state.pos++;
            }
            else if (ch === quote) {
                break;
            }
            base_1.state.pos++;
        }
        base_1.state.pos++;
        finishToken(types_1.TokenType.string);
    }
    // Reads template string tokens.
    function readTmplToken() {
        for (;;) {
            if (base_1.state.pos >= base_1.input.length) {
                (0, util_1.unexpected)("Unterminated template");
                return;
            }
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            if (ch === charcodes_1.charCodes.graveAccent ||
                (ch === charcodes_1.charCodes.dollarSign && base_1.input.charCodeAt(base_1.state.pos + 1) === charcodes_1.charCodes.leftCurlyBrace)) {
                if (base_1.state.pos === base_1.state.start && match(types_1.TokenType.template)) {
                    if (ch === charcodes_1.charCodes.dollarSign) {
                        base_1.state.pos += 2;
                        finishToken(types_1.TokenType.dollarBraceL);
                        return;
                    }
                    else {
                        ++base_1.state.pos;
                        finishToken(types_1.TokenType.backQuote);
                        return;
                    }
                }
                finishToken(types_1.TokenType.template);
                return;
            }
            if (ch === charcodes_1.charCodes.backslash) {
                base_1.state.pos++;
            }
            base_1.state.pos++;
        }
    }
    // Skip to the end of the current word. Note that this is the same as the snippet at the end of
    // readWord, but calling skipWord from readWord seems to slightly hurt performance from some rough
    // measurements.
    function skipWord() {
        while (base_1.state.pos < base_1.input.length) {
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            if (identifier_1.IS_IDENTIFIER_CHAR[ch]) {
                base_1.state.pos++;
            }
            else if (ch === charcodes_1.charCodes.backslash) {
                // \u
                base_1.state.pos += 2;
                if (base_1.input.charCodeAt(base_1.state.pos) === charcodes_1.charCodes.leftCurlyBrace) {
                    while (base_1.state.pos < base_1.input.length &&
                        base_1.input.charCodeAt(base_1.state.pos) !== charcodes_1.charCodes.rightCurlyBrace) {
                        base_1.state.pos++;
                    }
                    base_1.state.pos++;
                }
            }
            else {
                break;
            }
        }
    }
},
"540718e523": /* sucrase\dist\esm\parser\traverser\base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.getNextContextId = getNextContextId;
    exports.augmentError = augmentError;
    exports.locationForIndex = locationForIndex;
    exports.initParser = initParser;
    const tslib_1 = require("tslib");
    const state_1 = tslib_1.__importDefault(require("eda46439d5") /* ../tokenizer/state */);
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    function getNextContextId() {
        return exports.nextContextId++;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function augmentError(error) {
        if ("pos" in error) {
            const loc = locationForIndex(error.pos);
            error.message += ` (${loc.line}:${loc.column})`;
            error.loc = loc;
        }
        return error;
    }
    class Loc {
        constructor(line, column) {
            this.line = line;
            this.column = column;
        }
    }
    exports.Loc = Loc;
    function locationForIndex(pos) {
        let line = 1;
        let column = 1;
        for (let i = 0; i < pos; i++) {
            if (exports.input.charCodeAt(i) === charcodes_1.charCodes.lineFeed) {
                line++;
                column = 1;
            }
            else {
                column++;
            }
        }
        return new Loc(line, column);
    }
    function initParser(inputCode, isJSXEnabledArg, isTypeScriptEnabledArg, isFlowEnabledArg) {
        exports.input = inputCode;
        exports.state = new state_1.default();
        exports.nextContextId = 1;
        exports.isJSXEnabled = isJSXEnabledArg;
        exports.isTypeScriptEnabled = isTypeScriptEnabledArg;
        exports.isFlowEnabled = isFlowEnabledArg;
    }
},
"eda46439d5": /* sucrase\dist\esm\parser\tokenizer\state.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const keywords_1 = require("99ff836c64") /* ./keywords */;
    const types_1 = require("f0c35cbd76") /* ./types */;
    class Scope {
        constructor(startTokenIndex, endTokenIndex, isFunctionScope) {
            this.startTokenIndex = startTokenIndex;
            this.endTokenIndex = endTokenIndex;
            this.isFunctionScope = isFunctionScope;
        }
    }
    exports.Scope = Scope;
    class StateSnapshot {
        constructor(potentialArrowAt, noAnonFunctionType, inDisallowConditionalTypesContext, tokensLength, scopesLength, pos, type, contextualKeyword, start, end, isType, scopeDepth, error) { ; this.potentialArrowAt = potentialArrowAt; this.noAnonFunctionType = noAnonFunctionType; this.inDisallowConditionalTypesContext = inDisallowConditionalTypesContext; this.tokensLength = tokensLength; this.scopesLength = scopesLength; this.pos = pos; this.type = type; this.contextualKeyword = contextualKeyword; this.start = start; this.end = end; this.isType = isType; this.scopeDepth = scopeDepth; this.error = error; }
    }
    exports.StateSnapshot = StateSnapshot;
    class State {
        constructor() { State.prototype.__init.call(this); State.prototype.__init2.call(this); State.prototype.__init3.call(this); State.prototype.__init4.call(this); State.prototype.__init5.call(this); State.prototype.__init6.call(this); State.prototype.__init7.call(this); State.prototype.__init8.call(this); State.prototype.__init9.call(this); State.prototype.__init10.call(this); State.prototype.__init11.call(this); State.prototype.__init12.call(this); State.prototype.__init13.call(this); }
        // Used to signify the start of a potential arrow function
        __init() { this.potentialArrowAt = -1; }
        // Used by Flow to handle an edge case involving function type parsing.
        __init2() { this.noAnonFunctionType = false; }
        // Used by TypeScript to handle ambiguities when parsing conditional types.
        __init3() { this.inDisallowConditionalTypesContext = false; }
        // Token store.
        __init4() { this.tokens = []; }
        // Array of all observed scopes, ordered by their ending position.
        __init5() { this.scopes = []; }
        // The current position of the tokenizer in the input.
        __init6() { this.pos = 0; }
        // Information about the current token.
        __init7() { this.type = types_1.TokenType.eof; }
        __init8() { this.contextualKeyword = keywords_1.ContextualKeyword.NONE; }
        __init9() { this.start = 0; }
        __init10() { this.end = 0; }
        __init11() { this.isType = false; }
        __init12() { this.scopeDepth = 0; }
        /**
         * If the parser is in an error state, then the token is always tt.eof and all functions can
         * keep executing but should be written so they don't get into an infinite loop in this situation.
         *
         * This approach, combined with the ability to snapshot and restore state, allows us to implement
         * backtracking without exceptions and without needing to explicitly propagate error states
         * everywhere.
         */
        __init13() { this.error = null; }
        snapshot() {
            return new StateSnapshot(this.potentialArrowAt, this.noAnonFunctionType, this.inDisallowConditionalTypesContext, this.tokens.length, this.scopes.length, this.pos, this.type, this.contextualKeyword, this.start, this.end, this.isType, this.scopeDepth, this.error);
        }
        restoreFromSnapshot(snapshot) {
            this.potentialArrowAt = snapshot.potentialArrowAt;
            this.noAnonFunctionType = snapshot.noAnonFunctionType;
            this.inDisallowConditionalTypesContext = snapshot.inDisallowConditionalTypesContext;
            this.tokens.length = snapshot.tokensLength;
            this.scopes.length = snapshot.scopesLength;
            this.pos = snapshot.pos;
            this.type = snapshot.type;
            this.contextualKeyword = snapshot.contextualKeyword;
            this.start = snapshot.start;
            this.end = snapshot.end;
            this.isType = snapshot.isType;
            this.scopeDepth = snapshot.scopeDepth;
            this.error = snapshot.error;
        }
    }
    exports.default = State;
},
"99ff836c64": /* sucrase\dist\esm\parser\tokenizer\keywords.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    (function (ContextualKeyword) {
        const NONE = 0;
        ContextualKeyword[ContextualKeyword["NONE"] = NONE] = "NONE";
        const _abstract = NONE + 1;
        ContextualKeyword[ContextualKeyword["_abstract"] = _abstract] = "_abstract";
        const _accessor = _abstract + 1;
        ContextualKeyword[ContextualKeyword["_accessor"] = _accessor] = "_accessor";
        const _as = _accessor + 1;
        ContextualKeyword[ContextualKeyword["_as"] = _as] = "_as";
        const _assert = _as + 1;
        ContextualKeyword[ContextualKeyword["_assert"] = _assert] = "_assert";
        const _asserts = _assert + 1;
        ContextualKeyword[ContextualKeyword["_asserts"] = _asserts] = "_asserts";
        const _async = _asserts + 1;
        ContextualKeyword[ContextualKeyword["_async"] = _async] = "_async";
        const _await = _async + 1;
        ContextualKeyword[ContextualKeyword["_await"] = _await] = "_await";
        const _checks = _await + 1;
        ContextualKeyword[ContextualKeyword["_checks"] = _checks] = "_checks";
        const _constructor = _checks + 1;
        ContextualKeyword[ContextualKeyword["_constructor"] = _constructor] = "_constructor";
        const _declare = _constructor + 1;
        ContextualKeyword[ContextualKeyword["_declare"] = _declare] = "_declare";
        const _enum = _declare + 1;
        ContextualKeyword[ContextualKeyword["_enum"] = _enum] = "_enum";
        const _exports = _enum + 1;
        ContextualKeyword[ContextualKeyword["_exports"] = _exports] = "_exports";
        const _from = _exports + 1;
        ContextualKeyword[ContextualKeyword["_from"] = _from] = "_from";
        const _get = _from + 1;
        ContextualKeyword[ContextualKeyword["_get"] = _get] = "_get";
        const _global = _get + 1;
        ContextualKeyword[ContextualKeyword["_global"] = _global] = "_global";
        const _implements = _global + 1;
        ContextualKeyword[ContextualKeyword["_implements"] = _implements] = "_implements";
        const _infer = _implements + 1;
        ContextualKeyword[ContextualKeyword["_infer"] = _infer] = "_infer";
        const _interface = _infer + 1;
        ContextualKeyword[ContextualKeyword["_interface"] = _interface] = "_interface";
        const _is = _interface + 1;
        ContextualKeyword[ContextualKeyword["_is"] = _is] = "_is";
        const _keyof = _is + 1;
        ContextualKeyword[ContextualKeyword["_keyof"] = _keyof] = "_keyof";
        const _mixins = _keyof + 1;
        ContextualKeyword[ContextualKeyword["_mixins"] = _mixins] = "_mixins";
        const _module = _mixins + 1;
        ContextualKeyword[ContextualKeyword["_module"] = _module] = "_module";
        const _namespace = _module + 1;
        ContextualKeyword[ContextualKeyword["_namespace"] = _namespace] = "_namespace";
        const _of = _namespace + 1;
        ContextualKeyword[ContextualKeyword["_of"] = _of] = "_of";
        const _opaque = _of + 1;
        ContextualKeyword[ContextualKeyword["_opaque"] = _opaque] = "_opaque";
        const _out = _opaque + 1;
        ContextualKeyword[ContextualKeyword["_out"] = _out] = "_out";
        const _override = _out + 1;
        ContextualKeyword[ContextualKeyword["_override"] = _override] = "_override";
        const _private = _override + 1;
        ContextualKeyword[ContextualKeyword["_private"] = _private] = "_private";
        const _protected = _private + 1;
        ContextualKeyword[ContextualKeyword["_protected"] = _protected] = "_protected";
        const _proto = _protected + 1;
        ContextualKeyword[ContextualKeyword["_proto"] = _proto] = "_proto";
        const _public = _proto + 1;
        ContextualKeyword[ContextualKeyword["_public"] = _public] = "_public";
        const _readonly = _public + 1;
        ContextualKeyword[ContextualKeyword["_readonly"] = _readonly] = "_readonly";
        const _require = _readonly + 1;
        ContextualKeyword[ContextualKeyword["_require"] = _require] = "_require";
        const _satisfies = _require + 1;
        ContextualKeyword[ContextualKeyword["_satisfies"] = _satisfies] = "_satisfies";
        const _set = _satisfies + 1;
        ContextualKeyword[ContextualKeyword["_set"] = _set] = "_set";
        const _static = _set + 1;
        ContextualKeyword[ContextualKeyword["_static"] = _static] = "_static";
        const _symbol = _static + 1;
        ContextualKeyword[ContextualKeyword["_symbol"] = _symbol] = "_symbol";
        const _type = _symbol + 1;
        ContextualKeyword[ContextualKeyword["_type"] = _type] = "_type";
        const _unique = _type + 1;
        ContextualKeyword[ContextualKeyword["_unique"] = _unique] = "_unique";
        const _using = _unique + 1;
        ContextualKeyword[ContextualKeyword["_using"] = _using] = "_using";
    })(exports.ContextualKeyword || (exports.ContextualKeyword = {}));
},
"f0c35cbd76": /* sucrase\dist\esm\parser\tokenizer\types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.formatTokenType = formatTokenType;
    (function (TokenType) {
        // Precedence 0 means not an operator; otherwise it is a positive number up to 12.
        const PRECEDENCE_MASK = 0xf;
        TokenType[TokenType["PRECEDENCE_MASK"] = PRECEDENCE_MASK] = "PRECEDENCE_MASK";
        const IS_KEYWORD = 1 << 4;
        TokenType[TokenType["IS_KEYWORD"] = IS_KEYWORD] = "IS_KEYWORD";
        const IS_ASSIGN = 1 << 5;
        TokenType[TokenType["IS_ASSIGN"] = IS_ASSIGN] = "IS_ASSIGN";
        const IS_RIGHT_ASSOCIATIVE = 1 << 6;
        TokenType[TokenType["IS_RIGHT_ASSOCIATIVE"] = IS_RIGHT_ASSOCIATIVE] = "IS_RIGHT_ASSOCIATIVE";
        const IS_PREFIX = 1 << 7;
        TokenType[TokenType["IS_PREFIX"] = IS_PREFIX] = "IS_PREFIX";
        const IS_POSTFIX = 1 << 8;
        TokenType[TokenType["IS_POSTFIX"] = IS_POSTFIX] = "IS_POSTFIX";
        const IS_EXPRESSION_START = 1 << 9;
        TokenType[TokenType["IS_EXPRESSION_START"] = IS_EXPRESSION_START] = "IS_EXPRESSION_START";
        const num = 512;
        TokenType[TokenType["num"] = num] = "num"; // num startsExpr
        const bigint = 1536;
        TokenType[TokenType["bigint"] = bigint] = "bigint"; // bigint startsExpr
        const decimal = 2560;
        TokenType[TokenType["decimal"] = decimal] = "decimal"; // decimal startsExpr
        const regexp = 3584;
        TokenType[TokenType["regexp"] = regexp] = "regexp"; // regexp startsExpr
        const string = 4608;
        TokenType[TokenType["string"] = string] = "string"; // string startsExpr
        const name = 5632;
        TokenType[TokenType["name"] = name] = "name"; // name startsExpr
        const eof = 6144;
        TokenType[TokenType["eof"] = eof] = "eof"; // eof
        const bracketL = 7680;
        TokenType[TokenType["bracketL"] = bracketL] = "bracketL"; // [ startsExpr
        const bracketR = 8192;
        TokenType[TokenType["bracketR"] = bracketR] = "bracketR"; // ]
        const braceL = 9728;
        TokenType[TokenType["braceL"] = braceL] = "braceL"; // { startsExpr
        const braceBarL = 10752;
        TokenType[TokenType["braceBarL"] = braceBarL] = "braceBarL"; // {| startsExpr
        const braceR = 11264;
        TokenType[TokenType["braceR"] = braceR] = "braceR"; // }
        const braceBarR = 12288;
        TokenType[TokenType["braceBarR"] = braceBarR] = "braceBarR"; // |}
        const parenL = 13824;
        TokenType[TokenType["parenL"] = parenL] = "parenL"; // ( startsExpr
        const parenR = 14336;
        TokenType[TokenType["parenR"] = parenR] = "parenR"; // )
        const comma = 15360;
        TokenType[TokenType["comma"] = comma] = "comma"; // ,
        const semi = 16384;
        TokenType[TokenType["semi"] = semi] = "semi"; // ;
        const colon = 17408;
        TokenType[TokenType["colon"] = colon] = "colon"; // :
        const doubleColon = 18432;
        TokenType[TokenType["doubleColon"] = doubleColon] = "doubleColon"; // ::
        const dot = 19456;
        TokenType[TokenType["dot"] = dot] = "dot"; // .
        const question = 20480;
        TokenType[TokenType["question"] = question] = "question"; // ?
        const questionDot = 21504;
        TokenType[TokenType["questionDot"] = questionDot] = "questionDot"; // ?.
        const arrow = 22528;
        TokenType[TokenType["arrow"] = arrow] = "arrow"; // =>
        const template = 23552;
        TokenType[TokenType["template"] = template] = "template"; // template
        const ellipsis = 24576;
        TokenType[TokenType["ellipsis"] = ellipsis] = "ellipsis"; // ...
        const backQuote = 25600;
        TokenType[TokenType["backQuote"] = backQuote] = "backQuote"; // `
        const dollarBraceL = 27136;
        TokenType[TokenType["dollarBraceL"] = dollarBraceL] = "dollarBraceL"; // ${ startsExpr
        const at = 27648;
        TokenType[TokenType["at"] = at] = "at"; // @
        const hash = 29184;
        TokenType[TokenType["hash"] = hash] = "hash"; // # startsExpr
        const eq = 29728;
        TokenType[TokenType["eq"] = eq] = "eq"; // = isAssign
        const assign = 30752;
        TokenType[TokenType["assign"] = assign] = "assign"; // _= isAssign
        const preIncDec = 32640;
        TokenType[TokenType["preIncDec"] = preIncDec] = "preIncDec"; // ++/-- prefix postfix startsExpr
        const postIncDec = 33664;
        TokenType[TokenType["postIncDec"] = postIncDec] = "postIncDec"; // ++/-- prefix postfix startsExpr
        const bang = 34432;
        TokenType[TokenType["bang"] = bang] = "bang"; // ! prefix startsExpr
        const tilde = 35456;
        TokenType[TokenType["tilde"] = tilde] = "tilde"; // ~ prefix startsExpr
        const pipeline = 35841;
        TokenType[TokenType["pipeline"] = pipeline] = "pipeline"; // |> prec:1
        const nullishCoalescing = 36866;
        TokenType[TokenType["nullishCoalescing"] = nullishCoalescing] = "nullishCoalescing"; // ?? prec:2
        const logicalOR = 37890;
        TokenType[TokenType["logicalOR"] = logicalOR] = "logicalOR"; // || prec:2
        const logicalAND = 38915;
        TokenType[TokenType["logicalAND"] = logicalAND] = "logicalAND"; // && prec:3
        const bitwiseOR = 39940;
        TokenType[TokenType["bitwiseOR"] = bitwiseOR] = "bitwiseOR"; // | prec:4
        const bitwiseXOR = 40965;
        TokenType[TokenType["bitwiseXOR"] = bitwiseXOR] = "bitwiseXOR"; // ^ prec:5
        const bitwiseAND = 41990;
        TokenType[TokenType["bitwiseAND"] = bitwiseAND] = "bitwiseAND"; // & prec:6
        const equality = 43015;
        TokenType[TokenType["equality"] = equality] = "equality"; // ==/!= prec:7
        const lessThan = 44040;
        TokenType[TokenType["lessThan"] = lessThan] = "lessThan"; // < prec:8
        const greaterThan = 45064;
        TokenType[TokenType["greaterThan"] = greaterThan] = "greaterThan"; // > prec:8
        const relationalOrEqual = 46088;
        TokenType[TokenType["relationalOrEqual"] = relationalOrEqual] = "relationalOrEqual"; // <=/>= prec:8
        const bitShiftL = 47113;
        TokenType[TokenType["bitShiftL"] = bitShiftL] = "bitShiftL"; // << prec:9
        const bitShiftR = 48137;
        TokenType[TokenType["bitShiftR"] = bitShiftR] = "bitShiftR"; // >>/>>> prec:9
        const plus = 49802;
        TokenType[TokenType["plus"] = plus] = "plus"; // + prec:10 prefix startsExpr
        const minus = 50826;
        TokenType[TokenType["minus"] = minus] = "minus"; // - prec:10 prefix startsExpr
        const modulo = 51723;
        TokenType[TokenType["modulo"] = modulo] = "modulo"; // % prec:11 startsExpr
        const star = 52235;
        TokenType[TokenType["star"] = star] = "star"; // * prec:11
        const slash = 53259;
        TokenType[TokenType["slash"] = slash] = "slash"; // / prec:11
        const exponent = 54348;
        TokenType[TokenType["exponent"] = exponent] = "exponent"; // ** prec:12 rightAssociative
        const jsxName = 55296;
        TokenType[TokenType["jsxName"] = jsxName] = "jsxName"; // jsxName
        const jsxText = 56320;
        TokenType[TokenType["jsxText"] = jsxText] = "jsxText"; // jsxText
        const jsxEmptyText = 57344;
        TokenType[TokenType["jsxEmptyText"] = jsxEmptyText] = "jsxEmptyText"; // jsxEmptyText
        const jsxTagStart = 58880;
        TokenType[TokenType["jsxTagStart"] = jsxTagStart] = "jsxTagStart"; // jsxTagStart startsExpr
        const jsxTagEnd = 59392;
        TokenType[TokenType["jsxTagEnd"] = jsxTagEnd] = "jsxTagEnd"; // jsxTagEnd
        const typeParameterStart = 60928;
        TokenType[TokenType["typeParameterStart"] = typeParameterStart] = "typeParameterStart"; // typeParameterStart startsExpr
        const nonNullAssertion = 61440;
        TokenType[TokenType["nonNullAssertion"] = nonNullAssertion] = "nonNullAssertion"; // nonNullAssertion
        const _break = 62480;
        TokenType[TokenType["_break"] = _break] = "_break"; // break keyword
        const _case = 63504;
        TokenType[TokenType["_case"] = _case] = "_case"; // case keyword
        const _catch = 64528;
        TokenType[TokenType["_catch"] = _catch] = "_catch"; // catch keyword
        const _continue = 65552;
        TokenType[TokenType["_continue"] = _continue] = "_continue"; // continue keyword
        const _debugger = 66576;
        TokenType[TokenType["_debugger"] = _debugger] = "_debugger"; // debugger keyword
        const _default = 67600;
        TokenType[TokenType["_default"] = _default] = "_default"; // default keyword
        const _do = 68624;
        TokenType[TokenType["_do"] = _do] = "_do"; // do keyword
        const _else = 69648;
        TokenType[TokenType["_else"] = _else] = "_else"; // else keyword
        const _finally = 70672;
        TokenType[TokenType["_finally"] = _finally] = "_finally"; // finally keyword
        const _for = 71696;
        TokenType[TokenType["_for"] = _for] = "_for"; // for keyword
        const _function = 73232;
        TokenType[TokenType["_function"] = _function] = "_function"; // function keyword startsExpr
        const _if = 73744;
        TokenType[TokenType["_if"] = _if] = "_if"; // if keyword
        const _return = 74768;
        TokenType[TokenType["_return"] = _return] = "_return"; // return keyword
        const _switch = 75792;
        TokenType[TokenType["_switch"] = _switch] = "_switch"; // switch keyword
        const _throw = 77456;
        TokenType[TokenType["_throw"] = _throw] = "_throw"; // throw keyword prefix startsExpr
        const _try = 77840;
        TokenType[TokenType["_try"] = _try] = "_try"; // try keyword
        const _var = 78864;
        TokenType[TokenType["_var"] = _var] = "_var"; // var keyword
        const _let = 79888;
        TokenType[TokenType["_let"] = _let] = "_let"; // let keyword
        const _const = 80912;
        TokenType[TokenType["_const"] = _const] = "_const"; // const keyword
        const _while = 81936;
        TokenType[TokenType["_while"] = _while] = "_while"; // while keyword
        const _with = 82960;
        TokenType[TokenType["_with"] = _with] = "_with"; // with keyword
        const _new = 84496;
        TokenType[TokenType["_new"] = _new] = "_new"; // new keyword startsExpr
        const _this = 85520;
        TokenType[TokenType["_this"] = _this] = "_this"; // this keyword startsExpr
        const _super = 86544;
        TokenType[TokenType["_super"] = _super] = "_super"; // super keyword startsExpr
        const _class = 87568;
        TokenType[TokenType["_class"] = _class] = "_class"; // class keyword startsExpr
        const _extends = 88080;
        TokenType[TokenType["_extends"] = _extends] = "_extends"; // extends keyword
        const _export = 89104;
        TokenType[TokenType["_export"] = _export] = "_export"; // export keyword
        const _import = 90640;
        TokenType[TokenType["_import"] = _import] = "_import"; // import keyword startsExpr
        const _yield = 91664;
        TokenType[TokenType["_yield"] = _yield] = "_yield"; // yield keyword startsExpr
        const _null = 92688;
        TokenType[TokenType["_null"] = _null] = "_null"; // null keyword startsExpr
        const _true = 93712;
        TokenType[TokenType["_true"] = _true] = "_true"; // true keyword startsExpr
        const _false = 94736;
        TokenType[TokenType["_false"] = _false] = "_false"; // false keyword startsExpr
        const _in = 95256;
        TokenType[TokenType["_in"] = _in] = "_in"; // in prec:8 keyword
        const _instanceof = 96280;
        TokenType[TokenType["_instanceof"] = _instanceof] = "_instanceof"; // instanceof prec:8 keyword
        const _typeof = 97936;
        TokenType[TokenType["_typeof"] = _typeof] = "_typeof"; // typeof keyword prefix startsExpr
        const _void = 98960;
        TokenType[TokenType["_void"] = _void] = "_void"; // void keyword prefix startsExpr
        const _delete = 99984;
        TokenType[TokenType["_delete"] = _delete] = "_delete"; // delete keyword prefix startsExpr
        const _async = 100880;
        TokenType[TokenType["_async"] = _async] = "_async"; // async keyword startsExpr
        const _get = 101904;
        TokenType[TokenType["_get"] = _get] = "_get"; // get keyword startsExpr
        const _set = 102928;
        TokenType[TokenType["_set"] = _set] = "_set"; // set keyword startsExpr
        const _declare = 103952;
        TokenType[TokenType["_declare"] = _declare] = "_declare"; // declare keyword startsExpr
        const _readonly = 104976;
        TokenType[TokenType["_readonly"] = _readonly] = "_readonly"; // readonly keyword startsExpr
        const _abstract = 106000;
        TokenType[TokenType["_abstract"] = _abstract] = "_abstract"; // abstract keyword startsExpr
        const _static = 107024;
        TokenType[TokenType["_static"] = _static] = "_static"; // static keyword startsExpr
        const _public = 107536;
        TokenType[TokenType["_public"] = _public] = "_public"; // public keyword
        const _private = 108560;
        TokenType[TokenType["_private"] = _private] = "_private"; // private keyword
        const _protected = 109584;
        TokenType[TokenType["_protected"] = _protected] = "_protected"; // protected keyword
        const _override = 110608;
        TokenType[TokenType["_override"] = _override] = "_override"; // override keyword
        const _as = 112144;
        TokenType[TokenType["_as"] = _as] = "_as"; // as keyword startsExpr
        const _enum = 113168;
        TokenType[TokenType["_enum"] = _enum] = "_enum"; // enum keyword startsExpr
        const _type = 114192;
        TokenType[TokenType["_type"] = _type] = "_type"; // type keyword startsExpr
        const _implements = 115216;
        TokenType[TokenType["_implements"] = _implements] = "_implements"; // implements keyword startsExpr
    })(exports.TokenType || (exports.TokenType = {}));
    function formatTokenType(tokenType) {
        switch (tokenType) {
            case exports.TokenType.num:
                return "num";
            case exports.TokenType.bigint:
                return "bigint";
            case exports.TokenType.decimal:
                return "decimal";
            case exports.TokenType.regexp:
                return "regexp";
            case exports.TokenType.string:
                return "string";
            case exports.TokenType.name:
                return "name";
            case exports.TokenType.eof:
                return "eof";
            case exports.TokenType.bracketL:
                return "[";
            case exports.TokenType.bracketR:
                return "]";
            case exports.TokenType.braceL:
                return "{";
            case exports.TokenType.braceBarL:
                return "{|";
            case exports.TokenType.braceR:
                return "}";
            case exports.TokenType.braceBarR:
                return "|}";
            case exports.TokenType.parenL:
                return "(";
            case exports.TokenType.parenR:
                return ")";
            case exports.TokenType.comma:
                return ",";
            case exports.TokenType.semi:
                return ";";
            case exports.TokenType.colon:
                return ":";
            case exports.TokenType.doubleColon:
                return "::";
            case exports.TokenType.dot:
                return ".";
            case exports.TokenType.question:
                return "?";
            case exports.TokenType.questionDot:
                return "?.";
            case exports.TokenType.arrow:
                return "=>";
            case exports.TokenType.template:
                return "template";
            case exports.TokenType.ellipsis:
                return "...";
            case exports.TokenType.backQuote:
                return "`";
            case exports.TokenType.dollarBraceL:
                return "${";
            case exports.TokenType.at:
                return "@";
            case exports.TokenType.hash:
                return "#";
            case exports.TokenType.eq:
                return "=";
            case exports.TokenType.assign:
                return "_=";
            case exports.TokenType.preIncDec:
                return "++/--";
            case exports.TokenType.postIncDec:
                return "++/--";
            case exports.TokenType.bang:
                return "!";
            case exports.TokenType.tilde:
                return "~";
            case exports.TokenType.pipeline:
                return "|>";
            case exports.TokenType.nullishCoalescing:
                return "??";
            case exports.TokenType.logicalOR:
                return "||";
            case exports.TokenType.logicalAND:
                return "&&";
            case exports.TokenType.bitwiseOR:
                return "|";
            case exports.TokenType.bitwiseXOR:
                return "^";
            case exports.TokenType.bitwiseAND:
                return "&";
            case exports.TokenType.equality:
                return "==/!=";
            case exports.TokenType.lessThan:
                return "<";
            case exports.TokenType.greaterThan:
                return ">";
            case exports.TokenType.relationalOrEqual:
                return "<=/>=";
            case exports.TokenType.bitShiftL:
                return "<<";
            case exports.TokenType.bitShiftR:
                return ">>/>>>";
            case exports.TokenType.plus:
                return "+";
            case exports.TokenType.minus:
                return "-";
            case exports.TokenType.modulo:
                return "%";
            case exports.TokenType.star:
                return "*";
            case exports.TokenType.slash:
                return "/";
            case exports.TokenType.exponent:
                return "**";
            case exports.TokenType.jsxName:
                return "jsxName";
            case exports.TokenType.jsxText:
                return "jsxText";
            case exports.TokenType.jsxEmptyText:
                return "jsxEmptyText";
            case exports.TokenType.jsxTagStart:
                return "jsxTagStart";
            case exports.TokenType.jsxTagEnd:
                return "jsxTagEnd";
            case exports.TokenType.typeParameterStart:
                return "typeParameterStart";
            case exports.TokenType.nonNullAssertion:
                return "nonNullAssertion";
            case exports.TokenType._break:
                return "break";
            case exports.TokenType._case:
                return "case";
            case exports.TokenType._catch:
                return "catch";
            case exports.TokenType._continue:
                return "continue";
            case exports.TokenType._debugger:
                return "debugger";
            case exports.TokenType._default:
                return "default";
            case exports.TokenType._do:
                return "do";
            case exports.TokenType._else:
                return "else";
            case exports.TokenType._finally:
                return "finally";
            case exports.TokenType._for:
                return "for";
            case exports.TokenType._function:
                return "function";
            case exports.TokenType._if:
                return "if";
            case exports.TokenType._return:
                return "return";
            case exports.TokenType._switch:
                return "switch";
            case exports.TokenType._throw:
                return "throw";
            case exports.TokenType._try:
                return "try";
            case exports.TokenType._var:
                return "var";
            case exports.TokenType._let:
                return "let";
            case exports.TokenType._const:
                return "const";
            case exports.TokenType._while:
                return "while";
            case exports.TokenType._with:
                return "with";
            case exports.TokenType._new:
                return "new";
            case exports.TokenType._this:
                return "this";
            case exports.TokenType._super:
                return "super";
            case exports.TokenType._class:
                return "class";
            case exports.TokenType._extends:
                return "extends";
            case exports.TokenType._export:
                return "export";
            case exports.TokenType._import:
                return "import";
            case exports.TokenType._yield:
                return "yield";
            case exports.TokenType._null:
                return "null";
            case exports.TokenType._true:
                return "true";
            case exports.TokenType._false:
                return "false";
            case exports.TokenType._in:
                return "in";
            case exports.TokenType._instanceof:
                return "instanceof";
            case exports.TokenType._typeof:
                return "typeof";
            case exports.TokenType._void:
                return "void";
            case exports.TokenType._delete:
                return "delete";
            case exports.TokenType._async:
                return "async";
            case exports.TokenType._get:
                return "get";
            case exports.TokenType._set:
                return "set";
            case exports.TokenType._declare:
                return "declare";
            case exports.TokenType._readonly:
                return "readonly";
            case exports.TokenType._abstract:
                return "abstract";
            case exports.TokenType._static:
                return "static";
            case exports.TokenType._public:
                return "public";
            case exports.TokenType._private:
                return "private";
            case exports.TokenType._protected:
                return "protected";
            case exports.TokenType._override:
                return "override";
            case exports.TokenType._as:
                return "as";
            case exports.TokenType._enum:
                return "enum";
            case exports.TokenType._type:
                return "type";
            case exports.TokenType._implements:
                return "implements";
            default:
                return "";
        }
    }
},
"22746c8ce8": /* sucrase\dist\esm\parser\util\charcodes.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.isDigit = isDigit;
    (function (charCodes) {
        const backSpace = 8;
        charCodes[charCodes["backSpace"] = backSpace] = "backSpace";
        const lineFeed = 10;
        charCodes[charCodes["lineFeed"] = lineFeed] = "lineFeed"; //  '\n'
        const tab = 9;
        charCodes[charCodes["tab"] = tab] = "tab"; //  '\t'
        const carriageReturn = 13;
        charCodes[charCodes["carriageReturn"] = carriageReturn] = "carriageReturn"; //  '\r'
        const shiftOut = 14;
        charCodes[charCodes["shiftOut"] = shiftOut] = "shiftOut";
        const space = 32;
        charCodes[charCodes["space"] = space] = "space";
        const exclamationMark = 33;
        charCodes[charCodes["exclamationMark"] = exclamationMark] = "exclamationMark"; //  '!'
        const quotationMark = 34;
        charCodes[charCodes["quotationMark"] = quotationMark] = "quotationMark"; //  '"'
        const numberSign = 35;
        charCodes[charCodes["numberSign"] = numberSign] = "numberSign"; //  '#'
        const dollarSign = 36;
        charCodes[charCodes["dollarSign"] = dollarSign] = "dollarSign"; //  '$'
        const percentSign = 37;
        charCodes[charCodes["percentSign"] = percentSign] = "percentSign"; //  '%'
        const ampersand = 38;
        charCodes[charCodes["ampersand"] = ampersand] = "ampersand"; //  '&'
        const apostrophe = 39;
        charCodes[charCodes["apostrophe"] = apostrophe] = "apostrophe"; //  '''
        const leftParenthesis = 40;
        charCodes[charCodes["leftParenthesis"] = leftParenthesis] = "leftParenthesis"; //  '('
        const rightParenthesis = 41;
        charCodes[charCodes["rightParenthesis"] = rightParenthesis] = "rightParenthesis"; //  ')'
        const asterisk = 42;
        charCodes[charCodes["asterisk"] = asterisk] = "asterisk"; //  '*'
        const plusSign = 43;
        charCodes[charCodes["plusSign"] = plusSign] = "plusSign"; //  '+'
        const comma = 44;
        charCodes[charCodes["comma"] = comma] = "comma"; //  ','
        const dash = 45;
        charCodes[charCodes["dash"] = dash] = "dash"; //  '-'
        const dot = 46;
        charCodes[charCodes["dot"] = dot] = "dot"; //  '.'
        const slash = 47;
        charCodes[charCodes["slash"] = slash] = "slash"; //  '/'
        const digit0 = 48;
        charCodes[charCodes["digit0"] = digit0] = "digit0"; //  '0'
        const digit1 = 49;
        charCodes[charCodes["digit1"] = digit1] = "digit1"; //  '1'
        const digit2 = 50;
        charCodes[charCodes["digit2"] = digit2] = "digit2"; //  '2'
        const digit3 = 51;
        charCodes[charCodes["digit3"] = digit3] = "digit3"; //  '3'
        const digit4 = 52;
        charCodes[charCodes["digit4"] = digit4] = "digit4"; //  '4'
        const digit5 = 53;
        charCodes[charCodes["digit5"] = digit5] = "digit5"; //  '5'
        const digit6 = 54;
        charCodes[charCodes["digit6"] = digit6] = "digit6"; //  '6'
        const digit7 = 55;
        charCodes[charCodes["digit7"] = digit7] = "digit7"; //  '7'
        const digit8 = 56;
        charCodes[charCodes["digit8"] = digit8] = "digit8"; //  '8'
        const digit9 = 57;
        charCodes[charCodes["digit9"] = digit9] = "digit9"; //  '9'
        const colon = 58;
        charCodes[charCodes["colon"] = colon] = "colon"; //  ':'
        const semicolon = 59;
        charCodes[charCodes["semicolon"] = semicolon] = "semicolon"; //  ';'
        const lessThan = 60;
        charCodes[charCodes["lessThan"] = lessThan] = "lessThan"; //  '<'
        const equalsTo = 61;
        charCodes[charCodes["equalsTo"] = equalsTo] = "equalsTo"; //  '='
        const greaterThan = 62;
        charCodes[charCodes["greaterThan"] = greaterThan] = "greaterThan"; //  '>'
        const questionMark = 63;
        charCodes[charCodes["questionMark"] = questionMark] = "questionMark"; //  '?'
        const atSign = 64;
        charCodes[charCodes["atSign"] = atSign] = "atSign"; //  '@'
        const uppercaseA = 65;
        charCodes[charCodes["uppercaseA"] = uppercaseA] = "uppercaseA"; //  'A'
        const uppercaseB = 66;
        charCodes[charCodes["uppercaseB"] = uppercaseB] = "uppercaseB"; //  'B'
        const uppercaseC = 67;
        charCodes[charCodes["uppercaseC"] = uppercaseC] = "uppercaseC"; //  'C'
        const uppercaseD = 68;
        charCodes[charCodes["uppercaseD"] = uppercaseD] = "uppercaseD"; //  'D'
        const uppercaseE = 69;
        charCodes[charCodes["uppercaseE"] = uppercaseE] = "uppercaseE"; //  'E'
        const uppercaseF = 70;
        charCodes[charCodes["uppercaseF"] = uppercaseF] = "uppercaseF"; //  'F'
        const uppercaseG = 71;
        charCodes[charCodes["uppercaseG"] = uppercaseG] = "uppercaseG"; //  'G'
        const uppercaseH = 72;
        charCodes[charCodes["uppercaseH"] = uppercaseH] = "uppercaseH"; //  'H'
        const uppercaseI = 73;
        charCodes[charCodes["uppercaseI"] = uppercaseI] = "uppercaseI"; //  'I'
        const uppercaseJ = 74;
        charCodes[charCodes["uppercaseJ"] = uppercaseJ] = "uppercaseJ"; //  'J'
        const uppercaseK = 75;
        charCodes[charCodes["uppercaseK"] = uppercaseK] = "uppercaseK"; //  'K'
        const uppercaseL = 76;
        charCodes[charCodes["uppercaseL"] = uppercaseL] = "uppercaseL"; //  'L'
        const uppercaseM = 77;
        charCodes[charCodes["uppercaseM"] = uppercaseM] = "uppercaseM"; //  'M'
        const uppercaseN = 78;
        charCodes[charCodes["uppercaseN"] = uppercaseN] = "uppercaseN"; //  'N'
        const uppercaseO = 79;
        charCodes[charCodes["uppercaseO"] = uppercaseO] = "uppercaseO"; //  'O'
        const uppercaseP = 80;
        charCodes[charCodes["uppercaseP"] = uppercaseP] = "uppercaseP"; //  'P'
        const uppercaseQ = 81;
        charCodes[charCodes["uppercaseQ"] = uppercaseQ] = "uppercaseQ"; //  'Q'
        const uppercaseR = 82;
        charCodes[charCodes["uppercaseR"] = uppercaseR] = "uppercaseR"; //  'R'
        const uppercaseS = 83;
        charCodes[charCodes["uppercaseS"] = uppercaseS] = "uppercaseS"; //  'S'
        const uppercaseT = 84;
        charCodes[charCodes["uppercaseT"] = uppercaseT] = "uppercaseT"; //  'T'
        const uppercaseU = 85;
        charCodes[charCodes["uppercaseU"] = uppercaseU] = "uppercaseU"; //  'U'
        const uppercaseV = 86;
        charCodes[charCodes["uppercaseV"] = uppercaseV] = "uppercaseV"; //  'V'
        const uppercaseW = 87;
        charCodes[charCodes["uppercaseW"] = uppercaseW] = "uppercaseW"; //  'W'
        const uppercaseX = 88;
        charCodes[charCodes["uppercaseX"] = uppercaseX] = "uppercaseX"; //  'X'
        const uppercaseY = 89;
        charCodes[charCodes["uppercaseY"] = uppercaseY] = "uppercaseY"; //  'Y'
        const uppercaseZ = 90;
        charCodes[charCodes["uppercaseZ"] = uppercaseZ] = "uppercaseZ"; //  'Z'
        const leftSquareBracket = 91;
        charCodes[charCodes["leftSquareBracket"] = leftSquareBracket] = "leftSquareBracket"; //  '['
        const backslash = 92;
        charCodes[charCodes["backslash"] = backslash] = "backslash"; //  '\    '
        const rightSquareBracket = 93;
        charCodes[charCodes["rightSquareBracket"] = rightSquareBracket] = "rightSquareBracket"; //  ']'
        const caret = 94;
        charCodes[charCodes["caret"] = caret] = "caret"; //  '^'
        const underscore = 95;
        charCodes[charCodes["underscore"] = underscore] = "underscore"; //  '_'
        const graveAccent = 96;
        charCodes[charCodes["graveAccent"] = graveAccent] = "graveAccent"; //  '`'
        const lowercaseA = 97;
        charCodes[charCodes["lowercaseA"] = lowercaseA] = "lowercaseA"; //  'a'
        const lowercaseB = 98;
        charCodes[charCodes["lowercaseB"] = lowercaseB] = "lowercaseB"; //  'b'
        const lowercaseC = 99;
        charCodes[charCodes["lowercaseC"] = lowercaseC] = "lowercaseC"; //  'c'
        const lowercaseD = 100;
        charCodes[charCodes["lowercaseD"] = lowercaseD] = "lowercaseD"; //  'd'
        const lowercaseE = 101;
        charCodes[charCodes["lowercaseE"] = lowercaseE] = "lowercaseE"; //  'e'
        const lowercaseF = 102;
        charCodes[charCodes["lowercaseF"] = lowercaseF] = "lowercaseF"; //  'f'
        const lowercaseG = 103;
        charCodes[charCodes["lowercaseG"] = lowercaseG] = "lowercaseG"; //  'g'
        const lowercaseH = 104;
        charCodes[charCodes["lowercaseH"] = lowercaseH] = "lowercaseH"; //  'h'
        const lowercaseI = 105;
        charCodes[charCodes["lowercaseI"] = lowercaseI] = "lowercaseI"; //  'i'
        const lowercaseJ = 106;
        charCodes[charCodes["lowercaseJ"] = lowercaseJ] = "lowercaseJ"; //  'j'
        const lowercaseK = 107;
        charCodes[charCodes["lowercaseK"] = lowercaseK] = "lowercaseK"; //  'k'
        const lowercaseL = 108;
        charCodes[charCodes["lowercaseL"] = lowercaseL] = "lowercaseL"; //  'l'
        const lowercaseM = 109;
        charCodes[charCodes["lowercaseM"] = lowercaseM] = "lowercaseM"; //  'm'
        const lowercaseN = 110;
        charCodes[charCodes["lowercaseN"] = lowercaseN] = "lowercaseN"; //  'n'
        const lowercaseO = 111;
        charCodes[charCodes["lowercaseO"] = lowercaseO] = "lowercaseO"; //  'o'
        const lowercaseP = 112;
        charCodes[charCodes["lowercaseP"] = lowercaseP] = "lowercaseP"; //  'p'
        const lowercaseQ = 113;
        charCodes[charCodes["lowercaseQ"] = lowercaseQ] = "lowercaseQ"; //  'q'
        const lowercaseR = 114;
        charCodes[charCodes["lowercaseR"] = lowercaseR] = "lowercaseR"; //  'r'
        const lowercaseS = 115;
        charCodes[charCodes["lowercaseS"] = lowercaseS] = "lowercaseS"; //  's'
        const lowercaseT = 116;
        charCodes[charCodes["lowercaseT"] = lowercaseT] = "lowercaseT"; //  't'
        const lowercaseU = 117;
        charCodes[charCodes["lowercaseU"] = lowercaseU] = "lowercaseU"; //  'u'
        const lowercaseV = 118;
        charCodes[charCodes["lowercaseV"] = lowercaseV] = "lowercaseV"; //  'v'
        const lowercaseW = 119;
        charCodes[charCodes["lowercaseW"] = lowercaseW] = "lowercaseW"; //  'w'
        const lowercaseX = 120;
        charCodes[charCodes["lowercaseX"] = lowercaseX] = "lowercaseX"; //  'x'
        const lowercaseY = 121;
        charCodes[charCodes["lowercaseY"] = lowercaseY] = "lowercaseY"; //  'y'
        const lowercaseZ = 122;
        charCodes[charCodes["lowercaseZ"] = lowercaseZ] = "lowercaseZ"; //  'z'
        const leftCurlyBrace = 123;
        charCodes[charCodes["leftCurlyBrace"] = leftCurlyBrace] = "leftCurlyBrace"; //  '{'
        const verticalBar = 124;
        charCodes[charCodes["verticalBar"] = verticalBar] = "verticalBar"; //  '|'
        const rightCurlyBrace = 125;
        charCodes[charCodes["rightCurlyBrace"] = rightCurlyBrace] = "rightCurlyBrace"; //  '}'
        const tilde = 126;
        charCodes[charCodes["tilde"] = tilde] = "tilde"; //  '~'
        const nonBreakingSpace = 160;
        charCodes[charCodes["nonBreakingSpace"] = nonBreakingSpace] = "nonBreakingSpace";
        // eslint-disable-next-line no-irregular-whitespace
        const oghamSpaceMark = 5760;
        charCodes[charCodes["oghamSpaceMark"] = oghamSpaceMark] = "oghamSpaceMark"; // ' '
        const lineSeparator = 8232;
        charCodes[charCodes["lineSeparator"] = lineSeparator] = "lineSeparator";
        const paragraphSeparator = 8233;
        charCodes[charCodes["paragraphSeparator"] = paragraphSeparator] = "paragraphSeparator";
    })(exports.charCodes || (exports.charCodes = {}));
    function isDigit(code) {
        return ((code >= exports.charCodes.digit0 && code <= exports.charCodes.digit9) ||
            (code >= exports.charCodes.lowercaseA && code <= exports.charCodes.lowercaseF) ||
            (code >= exports.charCodes.uppercaseA && code <= exports.charCodes.uppercaseF));
    }
},
"bc94bbadc1": /* sucrase\dist\esm\parser\traverser\util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.isContextual = isContextual;
    exports.isLookaheadContextual = isLookaheadContextual;
    exports.eatContextual = eatContextual;
    exports.expectContextual = expectContextual;
    exports.canInsertSemicolon = canInsertSemicolon;
    exports.hasPrecedingLineBreak = hasPrecedingLineBreak;
    exports.hasFollowingLineBreak = hasFollowingLineBreak;
    exports.isLineTerminator = isLineTerminator;
    exports.semicolon = semicolon;
    exports.expect = expect;
    exports.unexpected = unexpected;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const base_1 = require("540718e523") /* ./base */;
    // ## Parser utilities
    // Tests whether parsed token is a contextual keyword.
    function isContextual(contextualKeyword) {
        return base_1.state.contextualKeyword === contextualKeyword;
    }
    function isLookaheadContextual(contextualKeyword) {
        const l = (0, index_1.lookaheadTypeAndKeyword)();
        return l.type === types_1.TokenType.name && l.contextualKeyword === contextualKeyword;
    }
    // Consumes contextual keyword if possible.
    function eatContextual(contextualKeyword) {
        return base_1.state.contextualKeyword === contextualKeyword && (0, index_1.eat)(types_1.TokenType.name);
    }
    // Asserts that following token is given contextual keyword.
    function expectContextual(contextualKeyword) {
        if (!eatContextual(contextualKeyword)) {
            unexpected();
        }
    }
    // Test whether a semicolon can be inserted at the current position.
    function canInsertSemicolon() {
        return (0, index_1.match)(types_1.TokenType.eof) || (0, index_1.match)(types_1.TokenType.braceR) || hasPrecedingLineBreak();
    }
    function hasPrecedingLineBreak() {
        const prevToken = base_1.state.tokens[base_1.state.tokens.length - 1];
        const lastTokEnd = prevToken ? prevToken.end : 0;
        for (let i = lastTokEnd; i < base_1.state.start; i++) {
            const code = base_1.input.charCodeAt(i);
            if (code === charcodes_1.charCodes.lineFeed ||
                code === charcodes_1.charCodes.carriageReturn ||
                code === 0x2028 ||
                code === 0x2029) {
                return true;
            }
        }
        return false;
    }
    function hasFollowingLineBreak() {
        const nextStart = (0, index_1.nextTokenStart)();
        for (let i = base_1.state.end; i < nextStart; i++) {
            const code = base_1.input.charCodeAt(i);
            if (code === charcodes_1.charCodes.lineFeed ||
                code === charcodes_1.charCodes.carriageReturn ||
                code === 0x2028 ||
                code === 0x2029) {
                return true;
            }
        }
        return false;
    }
    function isLineTerminator() {
        return (0, index_1.eat)(types_1.TokenType.semi) || canInsertSemicolon();
    }
    // Consume a semicolon, or, failing that, see if we are allowed to
    // pretend that there is a semicolon at this position.
    function semicolon() {
        if (!isLineTerminator()) {
            unexpected('Unexpected token, expected ";"');
        }
    }
    // Expect a token of a given type. If found, consume it, otherwise,
    // raise an unexpected token error at given pos.
    function expect(type) {
        const matched = (0, index_1.eat)(type);
        if (!matched) {
            unexpected(`Unexpected token, expected "${(0, types_1.formatTokenType)(type)}"`);
        }
    }
    /**
     * Transition the parser to an error state. All code needs to be written to naturally unwind in this
     * state, which allows us to backtrack without exceptions and without error plumbing everywhere.
     */
    function unexpected(message = "Unexpected token", pos = base_1.state.start) {
        if (base_1.state.error) {
            return;
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const err = new SyntaxError(message);
        err.pos = pos;
        base_1.state.error = err;
        base_1.state.pos = base_1.input.length;
        (0, index_1.finishToken)(types_1.TokenType.eof);
    }
},
"364148c9f0": /* sucrase\dist\esm\parser\util\identifier.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const charcodes_1 = require("22746c8ce8") /* ./charcodes */;
    const whitespace_1 = require("2a3176644a") /* ./whitespace */;
    function computeIsIdentifierChar(code) {
        if (code < 48)
            return code === 36;
        if (code < 58)
            return true;
        if (code < 65)
            return false;
        if (code < 91)
            return true;
        if (code < 97)
            return code === 95;
        if (code < 123)
            return true;
        if (code < 128)
            return false;
        throw new Error("Should not be called with non-ASCII char code.");
    }
    exports.IS_IDENTIFIER_CHAR = new Uint8Array(65536);
    for (let i = 0; i < 128; i++) {
        exports.IS_IDENTIFIER_CHAR[i] = computeIsIdentifierChar(i) ? 1 : 0;
    }
    for (let i = 128; i < 65536; i++) {
        exports.IS_IDENTIFIER_CHAR[i] = 1;
    }
    // Aside from whitespace and newlines, all characters outside the ASCII space are either
    // identifier characters or invalid. Since we're not performing code validation, we can just
    // treat all invalid characters as identifier characters.
    for (const whitespaceChar of whitespace_1.WHITESPACE_CHARS) {
        exports.IS_IDENTIFIER_CHAR[whitespaceChar] = 0;
    }
    exports.IS_IDENTIFIER_CHAR[0x2028] = 0;
    exports.IS_IDENTIFIER_CHAR[0x2029] = 0;
    exports.IS_IDENTIFIER_START = exports.IS_IDENTIFIER_CHAR.slice();
    for (let numChar = charcodes_1.charCodes.digit0; numChar <= charcodes_1.charCodes.digit9; numChar++) {
        exports.IS_IDENTIFIER_START[numChar] = 0;
    }
},
"2a3176644a": /* sucrase\dist\esm\parser\util\whitespace.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const charcodes_1 = require("22746c8ce8") /* ./charcodes */;
    // https://tc39.github.io/ecma262/#sec-white-space
    exports.WHITESPACE_CHARS = [
        0x0009,
        0x000b,
        0x000c,
        charcodes_1.charCodes.space,
        charcodes_1.charCodes.nonBreakingSpace,
        charcodes_1.charCodes.oghamSpaceMark,
        0x2000, // EN QUAD
        0x2001, // EM QUAD
        0x2002, // EN SPACE
        0x2003, // EM SPACE
        0x2004, // THREE-PER-EM SPACE
        0x2005, // FOUR-PER-EM SPACE
        0x2006, // SIX-PER-EM SPACE
        0x2007, // FIGURE SPACE
        0x2008, // PUNCTUATION SPACE
        0x2009, // THIN SPACE
        0x200a, // HAIR SPACE
        0x202f, // NARROW NO-BREAK SPACE
        0x205f, // MEDIUM MATHEMATICAL SPACE
        0x3000, // IDEOGRAPHIC SPACE
        0xfeff, // ZERO WIDTH NO-BREAK SPACE
    ];
    exports.skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
    exports.IS_WHITESPACE = new Uint8Array(65536);
    for (const char of exports.WHITESPACE_CHARS) {
        exports.IS_WHITESPACE[char] = 1;
    }
},
"e6eb78033b": /* sucrase\dist\esm\parser\tokenizer\readWord.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = readWord;
    const base_1 = require("540718e523") /* ../traverser/base */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const identifier_1 = require("364148c9f0") /* ../util/identifier */;
    const index_1 = require("bfb18d0576") /* ./index */;
    const readWordTree_1 = require("3d4c06ef43") /* ./readWordTree */;
    const types_1 = require("f0c35cbd76") /* ./types */;
    /**
     * Read an identifier, producing either a name token or matching on one of the existing keywords.
     * For performance, we pre-generate big decision tree that we traverse. Each node represents a
     * prefix and has 27 values, where the first value is the token or contextual token, if any (-1 if
     * not), and the other 26 values are the transitions to other nodes, or -1 to stop.
     */
    function readWord() {
        let treePos = 0;
        let code = 0;
        let pos = base_1.state.pos;
        while (pos < base_1.input.length) {
            code = base_1.input.charCodeAt(pos);
            if (code < charcodes_1.charCodes.lowercaseA || code > charcodes_1.charCodes.lowercaseZ) {
                break;
            }
            const next = readWordTree_1.READ_WORD_TREE[treePos + (code - charcodes_1.charCodes.lowercaseA) + 1];
            if (next === -1) {
                break;
            }
            else {
                treePos = next;
                pos++;
            }
        }
        const keywordValue = readWordTree_1.READ_WORD_TREE[treePos];
        if (keywordValue > -1 && !identifier_1.IS_IDENTIFIER_CHAR[code]) {
            base_1.state.pos = pos;
            if (keywordValue & 1) {
                (0, index_1.finishToken)(keywordValue >>> 1);
            }
            else {
                (0, index_1.finishToken)(types_1.TokenType.name, keywordValue >>> 1);
            }
            return;
        }
        while (pos < base_1.input.length) {
            const ch = base_1.input.charCodeAt(pos);
            if (identifier_1.IS_IDENTIFIER_CHAR[ch]) {
                pos++;
            }
            else if (ch === charcodes_1.charCodes.backslash) {
                // \u
                pos += 2;
                if (base_1.input.charCodeAt(pos) === charcodes_1.charCodes.leftCurlyBrace) {
                    while (pos < base_1.input.length && base_1.input.charCodeAt(pos) !== charcodes_1.charCodes.rightCurlyBrace) {
                        pos++;
                    }
                    pos++;
                }
            }
            else if (ch === charcodes_1.charCodes.atSign && base_1.input.charCodeAt(pos + 1) === charcodes_1.charCodes.atSign) {
                pos += 2;
            }
            else {
                break;
            }
        }
        base_1.state.pos = pos;
        (0, index_1.finishToken)(types_1.TokenType.name);
    }
},
"3d4c06ef43": /* sucrase\dist\esm\parser\tokenizer\readWordTree.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Generated file, do not edit! Run "yarn generate" to re-generate this file.
    const keywords_1 = require("99ff836c64") /* ./keywords */;
    const types_1 = require("f0c35cbd76") /* ./types */;
    // prettier-ignore
    exports.READ_WORD_TREE = new Int32Array([
        // ""
        -1, 27, 783, 918, 1755, 2376, 2862, 3483, -1, 3699, -1, 4617, 4752, 4833, 5130, 5508, 5940, -1, 6480, 6939, 7749, 8181, 8451, 8613, -1, 8829, -1,
        // "a"
        -1, -1, 54, 243, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, -1, -1, -1, 675, -1, -1, -1,
        // "ab"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 81, -1, -1, -1, -1, -1, -1, -1,
        // "abs"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, -1, -1, -1, -1, -1, -1,
        // "abst"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135, -1, -1, -1, -1, -1, -1, -1, -1,
        // "abstr"
        -1, 162, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "abstra"
        -1, -1, -1, 189, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "abstrac"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 216, -1, -1, -1, -1, -1, -1,
        // "abstract"
        keywords_1.ContextualKeyword._abstract << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ac"
        -1, -1, -1, 270, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "acc"
        -1, -1, -1, -1, -1, 297, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "acce"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 324, -1, -1, -1, -1, -1, -1, -1,
        // "acces"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 351, -1, -1, -1, -1, -1, -1, -1,
        // "access"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 378, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "accesso"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 405, -1, -1, -1, -1, -1, -1, -1, -1,
        // "accessor"
        keywords_1.ContextualKeyword._accessor << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "as"
        keywords_1.ContextualKeyword._as << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 459, -1, -1, -1, -1, -1, 594, -1,
        // "ass"
        -1, -1, -1, -1, -1, 486, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "asse"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 513, -1, -1, -1, -1, -1, -1, -1, -1,
        // "asser"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 540, -1, -1, -1, -1, -1, -1,
        // "assert"
        keywords_1.ContextualKeyword._assert << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 567, -1, -1, -1, -1, -1, -1, -1,
        // "asserts"
        keywords_1.ContextualKeyword._asserts << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "asy"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 621, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "asyn"
        -1, -1, -1, 648, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "async"
        keywords_1.ContextualKeyword._async << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "aw"
        -1, 702, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "awa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 729, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "awai"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 756, -1, -1, -1, -1, -1, -1,
        // "await"
        keywords_1.ContextualKeyword._await << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "b"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 810, -1, -1, -1, -1, -1, -1, -1, -1,
        // "br"
        -1, -1, -1, -1, -1, 837, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "bre"
        -1, 864, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "brea"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 891, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "break"
        (types_1.TokenType._break << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "c"
        -1, 945, -1, -1, -1, -1, -1, -1, 1107, -1, -1, -1, 1242, -1, -1, 1350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ca"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 972, 1026, -1, -1, -1, -1, -1, -1,
        // "cas"
        -1, -1, -1, -1, -1, 999, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "case"
        (types_1.TokenType._case << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "cat"
        -1, -1, -1, 1053, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "catc"
        -1, -1, -1, -1, -1, -1, -1, -1, 1080, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "catch"
        (types_1.TokenType._catch << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ch"
        -1, -1, -1, -1, -1, 1134, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "che"
        -1, -1, -1, 1161, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "chec"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1188, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "check"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1215, -1, -1, -1, -1, -1, -1, -1,
        // "checks"
        keywords_1.ContextualKeyword._checks << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "cl"
        -1, 1269, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "cla"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1296, -1, -1, -1, -1, -1, -1, -1,
        // "clas"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1323, -1, -1, -1, -1, -1, -1, -1,
        // "class"
        (types_1.TokenType._class << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "co"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1377, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "con"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1404, 1620, -1, -1, -1, -1, -1, -1,
        // "cons"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1431, -1, -1, -1, -1, -1, -1,
        // "const"
        (types_1.TokenType._const << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1458, -1, -1, -1, -1, -1, -1, -1, -1,
        // "constr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1485, -1, -1, -1, -1, -1,
        // "constru"
        -1, -1, -1, 1512, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "construc"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1539, -1, -1, -1, -1, -1, -1,
        // "construct"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1566, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "constructo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1593, -1, -1, -1, -1, -1, -1, -1, -1,
        // "constructor"
        keywords_1.ContextualKeyword._constructor << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "cont"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 1647, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "conti"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1674, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "contin"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1701, -1, -1, -1, -1, -1,
        // "continu"
        -1, -1, -1, -1, -1, 1728, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "continue"
        (types_1.TokenType._continue << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "d"
        -1, -1, -1, -1, -1, 1782, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2349, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "de"
        -1, -1, 1809, 1971, -1, -1, 2106, -1, -1, -1, -1, -1, 2241, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "deb"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1836, -1, -1, -1, -1, -1,
        // "debu"
        -1, -1, -1, -1, -1, -1, -1, 1863, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "debug"
        -1, -1, -1, -1, -1, -1, -1, 1890, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "debugg"
        -1, -1, -1, -1, -1, 1917, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "debugge"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1944, -1, -1, -1, -1, -1, -1, -1, -1,
        // "debugger"
        (types_1.TokenType._debugger << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "dec"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1998, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "decl"
        -1, 2025, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "decla"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2052, -1, -1, -1, -1, -1, -1, -1, -1,
        // "declar"
        -1, -1, -1, -1, -1, 2079, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "declare"
        keywords_1.ContextualKeyword._declare << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "def"
        -1, 2133, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "defa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2160, -1, -1, -1, -1, -1,
        // "defau"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2187, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "defaul"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2214, -1, -1, -1, -1, -1, -1,
        // "default"
        (types_1.TokenType._default << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "del"
        -1, -1, -1, -1, -1, 2268, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "dele"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2295, -1, -1, -1, -1, -1, -1,
        // "delet"
        -1, -1, -1, -1, -1, 2322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "delete"
        (types_1.TokenType._delete << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "do"
        (types_1.TokenType._do << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "e"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2403, -1, 2484, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2565, -1, -1,
        // "el"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2430, -1, -1, -1, -1, -1, -1, -1,
        // "els"
        -1, -1, -1, -1, -1, 2457, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "else"
        (types_1.TokenType._else << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "en"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2511, -1, -1, -1, -1, -1,
        // "enu"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2538, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "enum"
        keywords_1.ContextualKeyword._enum << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ex"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2592, -1, -1, -1, 2727, -1, -1, -1, -1, -1, -1,
        // "exp"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2619, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "expo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2646, -1, -1, -1, -1, -1, -1, -1, -1,
        // "expor"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2673, -1, -1, -1, -1, -1, -1,
        // "export"
        (types_1.TokenType._export << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2700, -1, -1, -1, -1, -1, -1, -1,
        // "exports"
        keywords_1.ContextualKeyword._exports << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ext"
        -1, -1, -1, -1, -1, 2754, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "exte"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2781, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "exten"
        -1, -1, -1, -1, 2808, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "extend"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2835, -1, -1, -1, -1, -1, -1, -1,
        // "extends"
        (types_1.TokenType._extends << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "f"
        -1, 2889, -1, -1, -1, -1, -1, -1, -1, 2997, -1, -1, -1, -1, -1, 3159, -1, -1, 3213, -1, -1, 3294, -1, -1, -1, -1, -1,
        // "fa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2916, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fal"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2943, -1, -1, -1, -1, -1, -1, -1,
        // "fals"
        -1, -1, -1, -1, -1, 2970, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "false"
        (types_1.TokenType._false << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3024, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fin"
        -1, 3051, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fina"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3078, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "final"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "finall"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3132, -1,
        // "finally"
        (types_1.TokenType._finally << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3186, -1, -1, -1, -1, -1, -1, -1, -1,
        // "for"
        (types_1.TokenType._for << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3240, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fro"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3267, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "from"
        keywords_1.ContextualKeyword._from << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fu"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "fun"
        -1, -1, -1, 3348, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "func"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3375, -1, -1, -1, -1, -1, -1,
        // "funct"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 3402, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "functi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3429, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "functio"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3456, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "function"
        (types_1.TokenType._function << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "g"
        -1, -1, -1, -1, -1, 3510, -1, -1, -1, -1, -1, -1, 3564, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ge"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3537, -1, -1, -1, -1, -1, -1,
        // "get"
        keywords_1.ContextualKeyword._get << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "gl"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3591, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "glo"
        -1, -1, 3618, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "glob"
        -1, 3645, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "globa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3672, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "global"
        keywords_1.ContextualKeyword._global << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "i"
        -1, -1, -1, -1, -1, -1, 3726, -1, -1, -1, -1, -1, -1, 3753, 4077, -1, -1, -1, -1, 4590, -1, -1, -1, -1, -1, -1, -1,
        // "if"
        (types_1.TokenType._if << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "im"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3780, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "imp"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3807, -1, -1, 3996, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "impl"
        -1, -1, -1, -1, -1, 3834, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "imple"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3861, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "implem"
        -1, -1, -1, -1, -1, 3888, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "impleme"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3915, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "implemen"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3942, -1, -1, -1, -1, -1, -1,
        // "implement"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3969, -1, -1, -1, -1, -1, -1, -1,
        // "implements"
        keywords_1.ContextualKeyword._implements << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "impo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4023, -1, -1, -1, -1, -1, -1, -1, -1,
        // "impor"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4050, -1, -1, -1, -1, -1, -1,
        // "import"
        (types_1.TokenType._import << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "in"
        (types_1.TokenType._in << 1) + 1, -1, -1, -1, -1, -1, 4104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4185, 4401, -1, -1, -1, -1, -1, -1,
        // "inf"
        -1, -1, -1, -1, -1, 4131, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "infe"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4158, -1, -1, -1, -1, -1, -1, -1, -1,
        // "infer"
        keywords_1.ContextualKeyword._infer << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ins"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4212, -1, -1, -1, -1, -1, -1,
        // "inst"
        -1, 4239, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "insta"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4266, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "instan"
        -1, -1, -1, 4293, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "instanc"
        -1, -1, -1, -1, -1, 4320, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "instance"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4347, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "instanceo"
        -1, -1, -1, -1, -1, -1, 4374, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "instanceof"
        (types_1.TokenType._instanceof << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "int"
        -1, -1, -1, -1, -1, 4428, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "inte"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4455, -1, -1, -1, -1, -1, -1, -1, -1,
        // "inter"
        -1, -1, -1, -1, -1, -1, 4482, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "interf"
        -1, 4509, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "interfa"
        -1, -1, -1, 4536, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "interfac"
        -1, -1, -1, -1, -1, 4563, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "interface"
        keywords_1.ContextualKeyword._interface << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "is"
        keywords_1.ContextualKeyword._is << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "k"
        -1, -1, -1, -1, -1, 4644, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ke"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4671, -1,
        // "key"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4698, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "keyo"
        -1, -1, -1, -1, -1, -1, 4725, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "keyof"
        keywords_1.ContextualKeyword._keyof << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "l"
        -1, -1, -1, -1, -1, 4779, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "le"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4806, -1, -1, -1, -1, -1, -1,
        // "let"
        (types_1.TokenType._let << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "m"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 4860, -1, -1, -1, -1, -1, 4995, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "mi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4887, -1, -1,
        // "mix"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 4914, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "mixi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4941, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "mixin"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4968, -1, -1, -1, -1, -1, -1, -1,
        // "mixins"
        keywords_1.ContextualKeyword._mixins << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "mo"
        -1, -1, -1, -1, 5022, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "mod"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5049, -1, -1, -1, -1, -1,
        // "modu"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5076, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "modul"
        -1, -1, -1, -1, -1, 5103, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "module"
        keywords_1.ContextualKeyword._module << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "n"
        -1, 5157, -1, -1, -1, 5373, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5427, -1, -1, -1, -1, -1,
        // "na"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5184, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "nam"
        -1, -1, -1, -1, -1, 5211, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "name"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5238, -1, -1, -1, -1, -1, -1, -1,
        // "names"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5265, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "namesp"
        -1, 5292, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "namespa"
        -1, -1, -1, 5319, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "namespac"
        -1, -1, -1, -1, -1, 5346, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "namespace"
        keywords_1.ContextualKeyword._namespace << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ne"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5400, -1, -1, -1,
        // "new"
        (types_1.TokenType._new << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "nu"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5454, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "nul"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5481, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "null"
        (types_1.TokenType._null << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "o"
        -1, -1, -1, -1, -1, -1, 5535, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5562, -1, -1, -1, -1, 5697, 5751, -1, -1, -1, -1,
        // "of"
        keywords_1.ContextualKeyword._of << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "op"
        -1, 5589, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "opa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5616, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "opaq"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5643, -1, -1, -1, -1, -1,
        // "opaqu"
        -1, -1, -1, -1, -1, 5670, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "opaque"
        keywords_1.ContextualKeyword._opaque << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ou"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5724, -1, -1, -1, -1, -1, -1,
        // "out"
        keywords_1.ContextualKeyword._out << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ov"
        -1, -1, -1, -1, -1, 5778, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ove"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5805, -1, -1, -1, -1, -1, -1, -1, -1,
        // "over"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5832, -1, -1, -1, -1, -1, -1, -1, -1,
        // "overr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 5859, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "overri"
        -1, -1, -1, -1, 5886, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "overrid"
        -1, -1, -1, -1, -1, 5913, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "override"
        keywords_1.ContextualKeyword._override << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "p"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5967, -1, -1, 6345, -1, -1, -1, -1, -1,
        // "pr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 5994, -1, -1, -1, -1, -1, 6129, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "pri"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6021, -1, -1, -1, -1,
        // "priv"
        -1, 6048, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "priva"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6075, -1, -1, -1, -1, -1, -1,
        // "privat"
        -1, -1, -1, -1, -1, 6102, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "private"
        keywords_1.ContextualKeyword._private << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "pro"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6156, -1, -1, -1, -1, -1, -1,
        // "prot"
        -1, -1, -1, -1, -1, 6183, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6318, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "prote"
        -1, -1, -1, 6210, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "protec"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6237, -1, -1, -1, -1, -1, -1,
        // "protect"
        -1, -1, -1, -1, -1, 6264, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "protecte"
        -1, -1, -1, -1, 6291, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "protected"
        keywords_1.ContextualKeyword._protected << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "proto"
        keywords_1.ContextualKeyword._proto << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "pu"
        -1, -1, 6372, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "pub"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6399, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "publ"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 6426, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "publi"
        -1, -1, -1, 6453, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "public"
        keywords_1.ContextualKeyword._public << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "r"
        -1, -1, -1, -1, -1, 6507, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "re"
        -1, 6534, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6696, -1, -1, 6831, -1, -1, -1, -1, -1, -1,
        // "rea"
        -1, -1, -1, -1, 6561, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "read"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6588, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "reado"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6615, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "readon"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6642, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "readonl"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6669, -1,
        // "readonly"
        keywords_1.ContextualKeyword._readonly << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "req"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6723, -1, -1, -1, -1, -1,
        // "requ"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 6750, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "requi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6777, -1, -1, -1, -1, -1, -1, -1, -1,
        // "requir"
        -1, -1, -1, -1, -1, 6804, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "require"
        keywords_1.ContextualKeyword._require << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ret"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6858, -1, -1, -1, -1, -1,
        // "retu"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6885, -1, -1, -1, -1, -1, -1, -1, -1,
        // "retur"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6912, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "return"
        (types_1.TokenType._return << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "s"
        -1, 6966, -1, -1, -1, 7182, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7236, 7371, -1, 7479, -1, 7614, -1,
        // "sa"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6993, -1, -1, -1, -1, -1, -1,
        // "sat"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 7020, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sati"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7047, -1, -1, -1, -1, -1, -1, -1,
        // "satis"
        -1, -1, -1, -1, -1, -1, 7074, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "satisf"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 7101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "satisfi"
        -1, -1, -1, -1, -1, 7128, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "satisfie"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7155, -1, -1, -1, -1, -1, -1, -1,
        // "satisfies"
        keywords_1.ContextualKeyword._satisfies << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "se"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7209, -1, -1, -1, -1, -1, -1,
        // "set"
        keywords_1.ContextualKeyword._set << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "st"
        -1, 7263, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sta"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7290, -1, -1, -1, -1, -1, -1,
        // "stat"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 7317, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "stati"
        -1, -1, -1, 7344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "static"
        keywords_1.ContextualKeyword._static << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "su"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7398, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sup"
        -1, -1, -1, -1, -1, 7425, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "supe"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7452, -1, -1, -1, -1, -1, -1, -1, -1,
        // "super"
        (types_1.TokenType._super << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sw"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 7506, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "swi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7533, -1, -1, -1, -1, -1, -1,
        // "swit"
        -1, -1, -1, 7560, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "switc"
        -1, -1, -1, -1, -1, -1, -1, -1, 7587, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "switch"
        (types_1.TokenType._switch << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sy"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7641, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "sym"
        -1, -1, 7668, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "symb"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7695, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "symbo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7722, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "symbol"
        keywords_1.ContextualKeyword._symbol << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "t"
        -1, -1, -1, -1, -1, -1, -1, -1, 7776, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7938, -1, -1, -1, -1, -1, -1, 8046, -1,
        // "th"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 7803, -1, -1, -1, -1, -1, -1, -1, -1, 7857, -1, -1, -1, -1, -1, -1, -1, -1,
        // "thi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7830, -1, -1, -1, -1, -1, -1, -1,
        // "this"
        (types_1.TokenType._this << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "thr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7884, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "thro"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7911, -1, -1, -1,
        // "throw"
        (types_1.TokenType._throw << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "tr"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7965, -1, -1, -1, 8019, -1,
        // "tru"
        -1, -1, -1, -1, -1, 7992, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "true"
        (types_1.TokenType._true << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "try"
        (types_1.TokenType._try << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "ty"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8073, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "typ"
        -1, -1, -1, -1, -1, 8100, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "type"
        keywords_1.ContextualKeyword._type << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "typeo"
        -1, -1, -1, -1, -1, -1, 8154, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "typeof"
        (types_1.TokenType._typeof << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "u"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8208, -1, -1, -1, -1, 8343, -1, -1, -1, -1, -1, -1, -1,
        // "un"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 8235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "uni"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8262, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "uniq"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8289, -1, -1, -1, -1, -1,
        // "uniqu"
        -1, -1, -1, -1, -1, 8316, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "unique"
        keywords_1.ContextualKeyword._unique << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "us"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 8370, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "usi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8397, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "usin"
        -1, -1, -1, -1, -1, -1, -1, 8424, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "using"
        keywords_1.ContextualKeyword._using << 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "v"
        -1, 8478, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8532, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "va"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8505, -1, -1, -1, -1, -1, -1, -1, -1,
        // "var"
        (types_1.TokenType._var << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "vo"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 8559, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "voi"
        -1, -1, -1, -1, 8586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "void"
        (types_1.TokenType._void << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "w"
        -1, -1, -1, -1, -1, -1, -1, -1, 8640, 8748, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "wh"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 8667, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "whi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8694, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "whil"
        -1, -1, -1, -1, -1, 8721, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "while"
        (types_1.TokenType._while << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "wi"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8775, -1, -1, -1, -1, -1, -1,
        // "wit"
        -1, -1, -1, -1, -1, -1, -1, -1, 8802, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "with"
        (types_1.TokenType._with << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "y"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, 8856, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "yi"
        -1, -1, -1, -1, -1, 8883, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "yie"
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8910, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "yiel"
        -1, -1, -1, -1, 8937, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        // "yield"
        (types_1.TokenType._yield << 1) + 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    ]);
},
"14d4ae78a4": /* sucrase\dist\esm\util\getImportExportSpecifierInfo.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getImportExportSpecifierInfo;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Determine information about this named import or named export specifier.
     *
     * This syntax is the `a` from statements like these:
     * import {A} from "./foo";
     * export {A};
     * export {A} from "./foo";
     *
     * As it turns out, we can exactly characterize the syntax meaning by simply
     * counting the number of tokens, which can be from 1 to 4:
     * {A}
     * {type A}
     * {A as B}
     * {type A as B}
     *
     * In the type case, we never actually need the names in practice, so don't get
     * them.
     *
     * TODO: There's some redundancy with the type detection here and the isType
     * flag that's already present on tokens in TS mode. This function could
     * potentially be simplified and/or pushed to the call sites to avoid the object
     * allocation.
     */
    function getImportExportSpecifierInfo(tokens, index = tokens.currentIndex()) {
        let endIndex = index + 1;
        if (isSpecifierEnd(tokens, endIndex)) {
            // import {A}
            const name = tokens.identifierNameAtIndex(index);
            return {
                isType: false,
                leftName: name,
                rightName: name,
                endIndex,
            };
        }
        endIndex++;
        if (isSpecifierEnd(tokens, endIndex)) {
            // import {type A}
            return {
                isType: true,
                leftName: null,
                rightName: null,
                endIndex,
            };
        }
        endIndex++;
        if (isSpecifierEnd(tokens, endIndex)) {
            // import {A as B}
            return {
                isType: false,
                leftName: tokens.identifierNameAtIndex(index),
                rightName: tokens.identifierNameAtIndex(index + 2),
                endIndex,
            };
        }
        endIndex++;
        if (isSpecifierEnd(tokens, endIndex)) {
            // import {type A as B}
            return {
                isType: true,
                leftName: null,
                rightName: null,
                endIndex,
            };
        }
        throw new Error(`Unexpected import/export specifier at ${index}`);
    }
    function isSpecifierEnd(tokens, index) {
        const token = tokens.tokens[index];
        return token.type === types_1.TokenType.braceR || token.type === types_1.TokenType.comma;
    }
},
"1ff9c9004b": /* sucrase\dist\esm\util\getNonTypeIdentifiers.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.getNonTypeIdentifiers = getNonTypeIdentifiers;
    const tslib_1 = require("tslib");
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const JSXTransformer_1 = require("a0e577c292") /* ../transformers/JSXTransformer */;
    const getJSXPragmaInfo_1 = tslib_1.__importDefault(require("d797c101ed") /* ./getJSXPragmaInfo */);
    function getNonTypeIdentifiers(tokens, options) {
        const jsxPragmaInfo = (0, getJSXPragmaInfo_1.default)(options);
        const nonTypeIdentifiers = new Set();
        for (let i = 0; i < tokens.tokens.length; i++) {
            const token = tokens.tokens[i];
            if (token.type === types_1.TokenType.name &&
                !token.isType &&
                (token.identifierRole === tokenizer_1.IdentifierRole.Access ||
                    token.identifierRole === tokenizer_1.IdentifierRole.ObjectShorthand ||
                    token.identifierRole === tokenizer_1.IdentifierRole.ExportAccess) &&
                !token.shadowsGlobal) {
                nonTypeIdentifiers.add(tokens.identifierNameForToken(token));
            }
            if (token.type === types_1.TokenType.jsxTagStart) {
                nonTypeIdentifiers.add(jsxPragmaInfo.base);
            }
            if (token.type === types_1.TokenType.jsxTagStart &&
                i + 1 < tokens.tokens.length &&
                tokens.tokens[i + 1].type === types_1.TokenType.jsxTagEnd) {
                nonTypeIdentifiers.add(jsxPragmaInfo.base);
                nonTypeIdentifiers.add(jsxPragmaInfo.fragmentBase);
            }
            if (token.type === types_1.TokenType.jsxName && token.identifierRole === tokenizer_1.IdentifierRole.Access) {
                const identifierName = tokens.identifierNameForToken(token);
                // Lower-case single-component tag names like "div" don't count.
                if (!(0, JSXTransformer_1.startsWithLowerCase)(identifierName) || tokens.tokens[i + 1].type === types_1.TokenType.dot) {
                    nonTypeIdentifiers.add(tokens.identifierNameForToken(token));
                }
            }
        }
        return nonTypeIdentifiers;
    }
},
"a0e577c292": /* sucrase\dist\esm\transformers\JSXTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.startsWithLowerCase = startsWithLowerCase;
    const tslib_1 = require("tslib");
    const xhtml_1 = tslib_1.__importDefault(require("c6b7812f89") /* ../parser/plugins/jsx/xhtml */);
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const charcodes_1 = require("22746c8ce8") /* ../parser/util/charcodes */;
    const getJSXPragmaInfo_1 = tslib_1.__importDefault(require("d797c101ed") /* ../util/getJSXPragmaInfo */);
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class JSXTransformer extends Transformer_1.default {
        // State for calculating the line number of each JSX tag in development.
        __init() { this.lastLineNumber = 1; }
        __init2() { this.lastIndex = 0; }
        // In development, variable name holding the name of the current file.
        __init3() { this.filenameVarName = null; }
        // Mapping of claimed names for imports in the automatic transform, e,g.
        // {jsx: "_jsx"}. This determines which imports to generate in the prefix.
        __init4() { this.esmAutomaticImportNameResolutions = {}; }
        // When automatically adding imports in CJS mode, we store the variable name
        // holding the imported CJS module so we can require it in the prefix.
        __init5() { this.cjsAutomaticModuleNameResolutions = {}; }
        constructor(rootTransformer, tokens, importProcessor, nameManager, options) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.importProcessor = importProcessor;
            this.nameManager = nameManager;
            this.options = options;
            JSXTransformer.prototype.__init.call(this);
            JSXTransformer.prototype.__init2.call(this);
            JSXTransformer.prototype.__init3.call(this);
            JSXTransformer.prototype.__init4.call(this);
            JSXTransformer.prototype.__init5.call(this);
            ;
            this.jsxPragmaInfo = (0, getJSXPragmaInfo_1.default)(options);
            this.isAutomaticRuntime = options.jsxRuntime === "automatic";
            this.jsxImportSource = options.jsxImportSource || "react";
        }
        process() {
            if (this.tokens.matches1(types_1.TokenType.jsxTagStart)) {
                this.processJSXTag();
                return true;
            }
            return false;
        }
        getPrefixCode() {
            let prefix = "";
            if (this.filenameVarName) {
                prefix += `const ${this.filenameVarName} = ${JSON.stringify(this.options.filePath || "")};`;
            }
            if (this.isAutomaticRuntime) {
                if (this.importProcessor) {
                    // CJS mode: emit require statements for all modules that were referenced.
                    for (const [path, resolvedName] of Object.entries(this.cjsAutomaticModuleNameResolutions)) {
                        prefix += `var ${resolvedName} = require("${path}");`;
                    }
                }
                else {
                    // ESM mode: consolidate and emit import statements for referenced names.
                    const { createElement: createElementResolution, ...otherResolutions } = this.esmAutomaticImportNameResolutions;
                    if (createElementResolution) {
                        prefix += `import {createElement as ${createElementResolution}} from "${this.jsxImportSource}";`;
                    }
                    const importSpecifiers = Object.entries(otherResolutions)
                        .map(([name, resolvedName]) => `${name} as ${resolvedName}`)
                        .join(", ");
                    if (importSpecifiers) {
                        const importPath = this.jsxImportSource + (this.options.production ? "/jsx-runtime" : "/jsx-dev-runtime");
                        prefix += `import {${importSpecifiers}} from "${importPath}";`;
                    }
                }
            }
            return prefix;
        }
        processJSXTag() {
            const { jsxRole, start } = this.tokens.currentToken();
            // Calculate line number information at the very start (if in development
            // mode) so that the information is guaranteed to be queried in token order.
            const elementLocationCode = this.options.production ? null : this.getElementLocationCode(start);
            if (this.isAutomaticRuntime && jsxRole !== tokenizer_1.JSXRole.KeyAfterPropSpread) {
                this.transformTagToJSXFunc(elementLocationCode, jsxRole);
            }
            else {
                this.transformTagToCreateElement(elementLocationCode);
            }
        }
        getElementLocationCode(firstTokenStart) {
            const lineNumber = this.getLineNumberForIndex(firstTokenStart);
            return `lineNumber: ${lineNumber}`;
        }
        /**
         * Get the line number for this source position. This is calculated lazily and
         * must be called in increasing order by index.
         */
        getLineNumberForIndex(index) {
            const code = this.tokens.code;
            while (this.lastIndex < index && this.lastIndex < code.length) {
                if (code[this.lastIndex] === "\n") {
                    this.lastLineNumber++;
                }
                this.lastIndex++;
            }
            return this.lastLineNumber;
        }
        /**
         * Convert the current JSX element to a call to jsx, jsxs, or jsxDEV. This is
         * the primary transformation for the automatic transform.
         *
         * Example:
         * <div a={1} key={2}>Hello{x}</div>
         * becomes
         * jsxs('div', {a: 1, children: ["Hello", x]}, 2)
         */
        transformTagToJSXFunc(elementLocationCode, jsxRole) {
            const isStatic = jsxRole === tokenizer_1.JSXRole.StaticChildren;
            // First tag is always jsxTagStart.
            this.tokens.replaceToken(this.getJSXFuncInvocationCode(isStatic));
            let keyCode = null;
            if (this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                // Fragment syntax.
                this.tokens.replaceToken(`${this.getFragmentCode()}, {`);
                this.processAutomaticChildrenAndEndProps(jsxRole);
            }
            else {
                // Normal open tag or self-closing tag.
                this.processTagIntro();
                this.tokens.appendCode(", {");
                keyCode = this.processProps(true);
                if (this.tokens.matches2(types_1.TokenType.slash, types_1.TokenType.jsxTagEnd)) {
                    // Self-closing tag, no children to add, so close the props.
                    this.tokens.appendCode("}");
                }
                else if (this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                    // Tag with children.
                    this.tokens.removeToken();
                    this.processAutomaticChildrenAndEndProps(jsxRole);
                }
                else {
                    throw new Error("Expected either /> or > at the end of the tag.");
                }
                // If a key was present, move it to its own arg. Note that moving code
                // like this will cause line numbers to get out of sync within the JSX
                // element if the key expression has a newline in it. This is unfortunate,
                // but hopefully should be rare.
                if (keyCode) {
                    this.tokens.appendCode(`, ${keyCode}`);
                }
            }
            if (!this.options.production) {
                // If the key wasn't already added, add it now so we can correctly set
                // positional args for jsxDEV.
                if (keyCode === null) {
                    this.tokens.appendCode(", void 0");
                }
                this.tokens.appendCode(`, ${isStatic}, ${this.getDevSource(elementLocationCode)}, this`);
            }
            // We're at the close-tag or the end of a self-closing tag, so remove
            // everything else and close the function call.
            this.tokens.removeInitialToken();
            while (!this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                this.tokens.removeToken();
            }
            this.tokens.replaceToken(")");
        }
        /**
         * Convert the current JSX element to a createElement call. In the classic
         * runtime, this is the only case. In the automatic runtime, this is called
         * as a fallback in some situations.
         *
         * Example:
         * <div a={1} key={2}>Hello{x}</div>
         * becomes
         * React.createElement('div', {a: 1, key: 2}, "Hello", x)
         */
        transformTagToCreateElement(elementLocationCode) {
            // First tag is always jsxTagStart.
            this.tokens.replaceToken(this.getCreateElementInvocationCode());
            if (this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                // Fragment syntax.
                this.tokens.replaceToken(`${this.getFragmentCode()}, null`);
                this.processChildren(true);
            }
            else {
                // Normal open tag or self-closing tag.
                this.processTagIntro();
                this.processPropsObjectWithDevInfo(elementLocationCode);
                if (this.tokens.matches2(types_1.TokenType.slash, types_1.TokenType.jsxTagEnd)) {
                    // Self-closing tag; no children to process.
                }
                else if (this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                    // Tag with children and a close-tag; process the children as args.
                    this.tokens.removeToken();
                    this.processChildren(true);
                }
                else {
                    throw new Error("Expected either /> or > at the end of the tag.");
                }
            }
            // We're at the close-tag or the end of a self-closing tag, so remove
            // everything else and close the function call.
            this.tokens.removeInitialToken();
            while (!this.tokens.matches1(types_1.TokenType.jsxTagEnd)) {
                this.tokens.removeToken();
            }
            this.tokens.replaceToken(")");
        }
        /**
         * Get the code for the relevant function for this context: jsx, jsxs,
         * or jsxDEV. The following open-paren is included as well.
         *
         * These functions are only used for the automatic runtime, so they are always
         * auto-imported, but the auto-import will be either CJS or ESM based on the
         * target module format.
         */
        getJSXFuncInvocationCode(isStatic) {
            if (this.options.production) {
                if (isStatic) {
                    return this.claimAutoImportedFuncInvocation("jsxs", "/jsx-runtime");
                }
                else {
                    return this.claimAutoImportedFuncInvocation("jsx", "/jsx-runtime");
                }
            }
            else {
                return this.claimAutoImportedFuncInvocation("jsxDEV", "/jsx-dev-runtime");
            }
        }
        /**
         * Return the code to use for the createElement function, e.g.
         * `React.createElement`, including the following open-paren.
         *
         * This is the main function to use for the classic runtime. For the
         * automatic runtime, this function is used as a fallback function to
         * preserve behavior when there is a prop spread followed by an explicit
         * key. In that automatic runtime case, the function should be automatically
         * imported.
         */
        getCreateElementInvocationCode() {
            if (this.isAutomaticRuntime) {
                return this.claimAutoImportedFuncInvocation("createElement", "");
            }
            else {
                const { jsxPragmaInfo } = this;
                const resolvedPragmaBaseName = this.importProcessor
                    ? this.importProcessor.getIdentifierReplacement(jsxPragmaInfo.base) || jsxPragmaInfo.base
                    : jsxPragmaInfo.base;
                return `${resolvedPragmaBaseName}${jsxPragmaInfo.suffix}(`;
            }
        }
        /**
         * Return the code to use as the component when compiling a shorthand
         * fragment, e.g. `React.Fragment`.
         *
         * This may be called from either the classic or automatic runtime, and
         * the value should be auto-imported for the automatic runtime.
         */
        getFragmentCode() {
            if (this.isAutomaticRuntime) {
                return this.claimAutoImportedName("Fragment", this.options.production ? "/jsx-runtime" : "/jsx-dev-runtime");
            }
            else {
                const { jsxPragmaInfo } = this;
                const resolvedFragmentPragmaBaseName = this.importProcessor
                    ? this.importProcessor.getIdentifierReplacement(jsxPragmaInfo.fragmentBase) ||
                        jsxPragmaInfo.fragmentBase
                    : jsxPragmaInfo.fragmentBase;
                return resolvedFragmentPragmaBaseName + jsxPragmaInfo.fragmentSuffix;
            }
        }
        /**
         * Return code that invokes the given function.
         *
         * When the imports transform is enabled, use the CJSImportTransformer
         * strategy of using `.call(void 0, ...` to avoid passing a `this` value in a
         * situation that would otherwise look like a method call.
         */
        claimAutoImportedFuncInvocation(funcName, importPathSuffix) {
            const funcCode = this.claimAutoImportedName(funcName, importPathSuffix);
            if (this.importProcessor) {
                return `${funcCode}.call(void 0, `;
            }
            else {
                return `${funcCode}(`;
            }
        }
        claimAutoImportedName(funcName, importPathSuffix) {
            if (this.importProcessor) {
                // CJS mode: claim a name for the module and mark it for import.
                const path = this.jsxImportSource + importPathSuffix;
                if (!this.cjsAutomaticModuleNameResolutions[path]) {
                    this.cjsAutomaticModuleNameResolutions[path] =
                        this.importProcessor.getFreeIdentifierForPath(path);
                }
                return `${this.cjsAutomaticModuleNameResolutions[path]}.${funcName}`;
            }
            else {
                // ESM mode: claim a name for this function and add it to the names that
                // should be auto-imported when the prefix is generated.
                if (!this.esmAutomaticImportNameResolutions[funcName]) {
                    this.esmAutomaticImportNameResolutions[funcName] = this.nameManager.claimFreeName(`_${funcName}`);
                }
                return this.esmAutomaticImportNameResolutions[funcName];
            }
        }
        /**
         * Process the first part of a tag, before any props.
         */
        processTagIntro() {
            // Walk forward until we see one of these patterns:
            // jsxName to start the first prop, preceded by another jsxName to end the tag name.
            // jsxName to start the first prop, preceded by greaterThan to end the type argument.
            // [open brace] to start the first prop.
            // [jsxTagEnd] to end the open-tag.
            // [slash, jsxTagEnd] to end the self-closing tag.
            let introEnd = this.tokens.currentIndex() + 1;
            while (this.tokens.tokens[introEnd].isType ||
                (!this.tokens.matches2AtIndex(introEnd - 1, types_1.TokenType.jsxName, types_1.TokenType.jsxName) &&
                    !this.tokens.matches2AtIndex(introEnd - 1, types_1.TokenType.greaterThan, types_1.TokenType.jsxName) &&
                    !this.tokens.matches1AtIndex(introEnd, types_1.TokenType.braceL) &&
                    !this.tokens.matches1AtIndex(introEnd, types_1.TokenType.jsxTagEnd) &&
                    !this.tokens.matches2AtIndex(introEnd, types_1.TokenType.slash, types_1.TokenType.jsxTagEnd))) {
                introEnd++;
            }
            if (introEnd === this.tokens.currentIndex() + 1) {
                const tagName = this.tokens.identifierName();
                if (startsWithLowerCase(tagName)) {
                    this.tokens.replaceToken(`'${tagName}'`);
                }
            }
            while (this.tokens.currentIndex() < introEnd) {
                this.rootTransformer.processToken();
            }
        }
        /**
         * Starting at the beginning of the props, add the props argument to
         * React.createElement, including the comma before it.
         */
        processPropsObjectWithDevInfo(elementLocationCode) {
            const devProps = this.options.production
                ? ""
                : `__self: this, __source: ${this.getDevSource(elementLocationCode)}`;
            if (!this.tokens.matches1(types_1.TokenType.jsxName) && !this.tokens.matches1(types_1.TokenType.braceL)) {
                if (devProps) {
                    this.tokens.appendCode(`, {${devProps}}`);
                }
                else {
                    this.tokens.appendCode(`, null`);
                }
                return;
            }
            this.tokens.appendCode(`, {`);
            this.processProps(false);
            if (devProps) {
                this.tokens.appendCode(` ${devProps}}`);
            }
            else {
                this.tokens.appendCode("}");
            }
        }
        /**
         * Transform the core part of the props, assuming that a { has already been
         * inserted before us and that a } will be inserted after us.
         *
         * If extractKeyCode is true (i.e. when using any jsx... function), any prop
         * named "key" has its code captured and returned rather than being emitted to
         * the output code. This shifts line numbers, and emitting the code later will
         * correct line numbers again. If no key is found or if extractKeyCode is
         * false, this function returns null.
         */
        processProps(extractKeyCode) {
            let keyCode = null;
            while (true) {
                if (this.tokens.matches2(types_1.TokenType.jsxName, types_1.TokenType.eq)) {
                    // This is a regular key={value} or key="value" prop.
                    const propName = this.tokens.identifierName();
                    if (extractKeyCode && propName === "key") {
                        if (keyCode !== null) {
                            // The props list has multiple keys. Different implementations are
                            // inconsistent about what to do here: as of this writing, Babel and
                            // swc keep the *last* key and completely remove the rest, while
                            // TypeScript uses the *first* key and leaves the others as regular
                            // props. The React team collaborated with Babel on the
                            // implementation of this behavior, so presumably the Babel behavior
                            // is the one to use.
                            // Since we won't ever be emitting the previous key code, we need to
                            // at least emit its newlines here so that the line numbers match up
                            // in the long run.
                            this.tokens.appendCode(keyCode.replace(/[^\n]/g, ""));
                        }
                        // key
                        this.tokens.removeToken();
                        // =
                        this.tokens.removeToken();
                        const snapshot = this.tokens.snapshot();
                        this.processPropValue();
                        keyCode = this.tokens.dangerouslyGetAndRemoveCodeSinceSnapshot(snapshot);
                        // Don't add a comma
                        continue;
                    }
                    else {
                        this.processPropName(propName);
                        this.tokens.replaceToken(": ");
                        this.processPropValue();
                    }
                }
                else if (this.tokens.matches1(types_1.TokenType.jsxName)) {
                    // This is a shorthand prop like <input disabled />.
                    const propName = this.tokens.identifierName();
                    this.processPropName(propName);
                    this.tokens.appendCode(": true");
                }
                else if (this.tokens.matches1(types_1.TokenType.braceL)) {
                    // This is prop spread, like <div {...getProps()}>, which we can pass
                    // through fairly directly as an object spread.
                    this.tokens.replaceToken("");
                    this.rootTransformer.processBalancedCode();
                    this.tokens.replaceToken("");
                }
                else {
                    break;
                }
                this.tokens.appendCode(",");
            }
            return keyCode;
        }
        processPropName(propName) {
            if (propName.includes("-")) {
                this.tokens.replaceToken(`'${propName}'`);
            }
            else {
                this.tokens.copyToken();
            }
        }
        processPropValue() {
            if (this.tokens.matches1(types_1.TokenType.braceL)) {
                this.tokens.replaceToken("");
                this.rootTransformer.processBalancedCode();
                this.tokens.replaceToken("");
            }
            else if (this.tokens.matches1(types_1.TokenType.jsxTagStart)) {
                this.processJSXTag();
            }
            else {
                this.processStringPropValue();
            }
        }
        processStringPropValue() {
            const token = this.tokens.currentToken();
            const valueCode = this.tokens.code.slice(token.start + 1, token.end - 1);
            const replacementCode = formatJSXTextReplacement(valueCode);
            const literalCode = formatJSXStringValueLiteral(valueCode);
            this.tokens.replaceToken(literalCode + replacementCode);
        }
        /**
         * Starting in the middle of the props object literal, produce an additional
         * prop for the children and close the object literal.
         */
        processAutomaticChildrenAndEndProps(jsxRole) {
            if (jsxRole === tokenizer_1.JSXRole.StaticChildren) {
                this.tokens.appendCode(" children: [");
                this.processChildren(false);
                this.tokens.appendCode("]}");
            }
            else {
                // The parser information tells us whether we will see a real child or if
                // all remaining children (if any) will resolve to empty. If there are no
                // non-empty children, don't emit a children prop at all, but still
                // process children so that we properly transform the code into nothing.
                if (jsxRole === tokenizer_1.JSXRole.OneChild) {
                    this.tokens.appendCode(" children: ");
                }
                this.processChildren(false);
                this.tokens.appendCode("}");
            }
        }
        /**
         * Transform children into a comma-separated list, which will be either
         * arguments to createElement or array elements of a children prop.
         */
        processChildren(needsInitialComma) {
            let needsComma = needsInitialComma;
            while (true) {
                if (this.tokens.matches2(types_1.TokenType.jsxTagStart, types_1.TokenType.slash)) {
                    // Closing tag, so no more children.
                    return;
                }
                let didEmitElement = false;
                if (this.tokens.matches1(types_1.TokenType.braceL)) {
                    if (this.tokens.matches2(types_1.TokenType.braceL, types_1.TokenType.braceR)) {
                        // Empty interpolations and comment-only interpolations are allowed
                        // and don't create an extra child arg.
                        this.tokens.replaceToken("");
                        this.tokens.replaceToken("");
                    }
                    else {
                        // Interpolated expression.
                        this.tokens.replaceToken(needsComma ? ", " : "");
                        this.rootTransformer.processBalancedCode();
                        this.tokens.replaceToken("");
                        didEmitElement = true;
                    }
                }
                else if (this.tokens.matches1(types_1.TokenType.jsxTagStart)) {
                    // Child JSX element
                    this.tokens.appendCode(needsComma ? ", " : "");
                    this.processJSXTag();
                    didEmitElement = true;
                }
                else if (this.tokens.matches1(types_1.TokenType.jsxText) || this.tokens.matches1(types_1.TokenType.jsxEmptyText)) {
                    didEmitElement = this.processChildTextElement(needsComma);
                }
                else {
                    throw new Error("Unexpected token when processing JSX children.");
                }
                if (didEmitElement) {
                    needsComma = true;
                }
            }
        }
        /**
         * Turn a JSX text element into a string literal, or nothing at all if the JSX
         * text resolves to the empty string.
         *
         * Returns true if a string literal is emitted, false otherwise.
         */
        processChildTextElement(needsComma) {
            const token = this.tokens.currentToken();
            const valueCode = this.tokens.code.slice(token.start, token.end);
            const replacementCode = formatJSXTextReplacement(valueCode);
            const literalCode = formatJSXTextLiteral(valueCode);
            if (literalCode === '""') {
                this.tokens.replaceToken(replacementCode);
                return false;
            }
            else {
                this.tokens.replaceToken(`${needsComma ? ", " : ""}${literalCode}${replacementCode}`);
                return true;
            }
        }
        getDevSource(elementLocationCode) {
            return `{fileName: ${this.getFilenameVarName()}, ${elementLocationCode}}`;
        }
        getFilenameVarName() {
            if (!this.filenameVarName) {
                this.filenameVarName = this.nameManager.claimFreeName("_jsxFileName");
            }
            return this.filenameVarName;
        }
    }
    exports.default = JSXTransformer;
    /**
     * Spec for identifiers: https://tc39.github.io/ecma262/#prod-IdentifierStart.
     *
     * Really only treat anything starting with a-z as tag names.  `_`, `$`, `é`
     * should be treated as component names
     */
    function startsWithLowerCase(s) {
        const firstChar = s.charCodeAt(0);
        return firstChar >= charcodes_1.charCodes.lowercaseA && firstChar <= charcodes_1.charCodes.lowercaseZ;
    }
    /**
     * Turn the given jsxText string into a JS string literal. Leading and trailing
     * whitespace on lines is removed, except immediately after the open-tag and
     * before the close-tag. Empty lines are completely removed, and spaces are
     * added between lines after that.
     *
     * We use JSON.stringify to introduce escape characters as necessary, and trim
     * the start and end of each line and remove blank lines.
     */
    function formatJSXTextLiteral(text) {
        let result = "";
        let whitespace = "";
        let isInInitialLineWhitespace = false;
        let seenNonWhitespace = false;
        for (let i = 0; i < text.length; i++) {
            const c = text[i];
            if (c === " " || c === "\t" || c === "\r") {
                if (!isInInitialLineWhitespace) {
                    whitespace += c;
                }
            }
            else if (c === "\n") {
                whitespace = "";
                isInInitialLineWhitespace = true;
            }
            else {
                if (seenNonWhitespace && isInInitialLineWhitespace) {
                    result += " ";
                }
                result += whitespace;
                whitespace = "";
                if (c === "&") {
                    const { entity, newI } = processEntity(text, i + 1);
                    i = newI - 1;
                    result += entity;
                }
                else {
                    result += c;
                }
                seenNonWhitespace = true;
                isInInitialLineWhitespace = false;
            }
        }
        if (!isInInitialLineWhitespace) {
            result += whitespace;
        }
        return JSON.stringify(result);
    }
    /**
     * Produce the code that should be printed after the JSX text string literal,
     * with most content removed, but all newlines preserved and all spacing at the
     * end preserved.
     */
    function formatJSXTextReplacement(text) {
        let numNewlines = 0;
        let numSpaces = 0;
        for (const c of text) {
            if (c === "\n") {
                numNewlines++;
                numSpaces = 0;
            }
            else if (c === " ") {
                numSpaces++;
            }
        }
        return "\n".repeat(numNewlines) + " ".repeat(numSpaces);
    }
    /**
     * Format a string in the value position of a JSX prop.
     *
     * Use the same implementation as convertAttribute from
     * babel-helper-builder-react-jsx.
     */
    function formatJSXStringValueLiteral(text) {
        let result = "";
        for (let i = 0; i < text.length; i++) {
            const c = text[i];
            if (c === "\n") {
                if (/\s/.test(text[i + 1])) {
                    result += " ";
                    while (i < text.length && /\s/.test(text[i + 1])) {
                        i++;
                    }
                }
                else {
                    result += "\n";
                }
            }
            else if (c === "&") {
                const { entity, newI } = processEntity(text, i + 1);
                result += entity;
                i = newI - 1;
            }
            else {
                result += c;
            }
        }
        return JSON.stringify(result);
    }
    /**
     * Starting at a &, see if there's an HTML entity (specified by name, decimal
     * char code, or hex char code) and return it if so.
     *
     * Modified from jsxReadString in babel-parser.
     */
    function processEntity(text, indexAfterAmpersand) {
        let str = "";
        let count = 0;
        let entity;
        let i = indexAfterAmpersand;
        if (text[i] === "#") {
            let radix = 10;
            i++;
            let numStart;
            if (text[i] === "x") {
                radix = 16;
                i++;
                numStart = i;
                while (i < text.length && isHexDigit(text.charCodeAt(i))) {
                    i++;
                }
            }
            else {
                numStart = i;
                while (i < text.length && isDecimalDigit(text.charCodeAt(i))) {
                    i++;
                }
            }
            if (text[i] === ";") {
                const numStr = text.slice(numStart, i);
                if (numStr) {
                    i++;
                    entity = String.fromCodePoint(parseInt(numStr, radix));
                }
            }
        }
        else {
            while (i < text.length && count++ < 10) {
                const ch = text[i];
                i++;
                if (ch === ";") {
                    entity = xhtml_1.default.get(str);
                    break;
                }
                str += ch;
            }
        }
        if (!entity) {
            return { entity: "&", newI: indexAfterAmpersand };
        }
        return { entity, newI: i };
    }
    function isDecimalDigit(code) {
        return code >= charcodes_1.charCodes.digit0 && code <= charcodes_1.charCodes.digit9;
    }
    function isHexDigit(code) {
        return ((code >= charcodes_1.charCodes.digit0 && code <= charcodes_1.charCodes.digit9) ||
            (code >= charcodes_1.charCodes.lowercaseA && code <= charcodes_1.charCodes.lowercaseF) ||
            (code >= charcodes_1.charCodes.uppercaseA && code <= charcodes_1.charCodes.uppercaseF));
    }
},
"c6b7812f89": /* sucrase\dist\esm\parser\plugins\jsx\xhtml.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Use a Map rather than object to avoid unexpected __proto__ access.
    exports.default = new Map([
        ["quot", "\u0022"],
        ["amp", "&"],
        ["apos", "\u0027"],
        ["lt", "<"],
        ["gt", ">"],
        ["nbsp", "\u00A0"],
        ["iexcl", "\u00A1"],
        ["cent", "\u00A2"],
        ["pound", "\u00A3"],
        ["curren", "\u00A4"],
        ["yen", "\u00A5"],
        ["brvbar", "\u00A6"],
        ["sect", "\u00A7"],
        ["uml", "\u00A8"],
        ["copy", "\u00A9"],
        ["ordf", "\u00AA"],
        ["laquo", "\u00AB"],
        ["not", "\u00AC"],
        ["shy", "\u00AD"],
        ["reg", "\u00AE"],
        ["macr", "\u00AF"],
        ["deg", "\u00B0"],
        ["plusmn", "\u00B1"],
        ["sup2", "\u00B2"],
        ["sup3", "\u00B3"],
        ["acute", "\u00B4"],
        ["micro", "\u00B5"],
        ["para", "\u00B6"],
        ["middot", "\u00B7"],
        ["cedil", "\u00B8"],
        ["sup1", "\u00B9"],
        ["ordm", "\u00BA"],
        ["raquo", "\u00BB"],
        ["frac14", "\u00BC"],
        ["frac12", "\u00BD"],
        ["frac34", "\u00BE"],
        ["iquest", "\u00BF"],
        ["Agrave", "\u00C0"],
        ["Aacute", "\u00C1"],
        ["Acirc", "\u00C2"],
        ["Atilde", "\u00C3"],
        ["Auml", "\u00C4"],
        ["Aring", "\u00C5"],
        ["AElig", "\u00C6"],
        ["Ccedil", "\u00C7"],
        ["Egrave", "\u00C8"],
        ["Eacute", "\u00C9"],
        ["Ecirc", "\u00CA"],
        ["Euml", "\u00CB"],
        ["Igrave", "\u00CC"],
        ["Iacute", "\u00CD"],
        ["Icirc", "\u00CE"],
        ["Iuml", "\u00CF"],
        ["ETH", "\u00D0"],
        ["Ntilde", "\u00D1"],
        ["Ograve", "\u00D2"],
        ["Oacute", "\u00D3"],
        ["Ocirc", "\u00D4"],
        ["Otilde", "\u00D5"],
        ["Ouml", "\u00D6"],
        ["times", "\u00D7"],
        ["Oslash", "\u00D8"],
        ["Ugrave", "\u00D9"],
        ["Uacute", "\u00DA"],
        ["Ucirc", "\u00DB"],
        ["Uuml", "\u00DC"],
        ["Yacute", "\u00DD"],
        ["THORN", "\u00DE"],
        ["szlig", "\u00DF"],
        ["agrave", "\u00E0"],
        ["aacute", "\u00E1"],
        ["acirc", "\u00E2"],
        ["atilde", "\u00E3"],
        ["auml", "\u00E4"],
        ["aring", "\u00E5"],
        ["aelig", "\u00E6"],
        ["ccedil", "\u00E7"],
        ["egrave", "\u00E8"],
        ["eacute", "\u00E9"],
        ["ecirc", "\u00EA"],
        ["euml", "\u00EB"],
        ["igrave", "\u00EC"],
        ["iacute", "\u00ED"],
        ["icirc", "\u00EE"],
        ["iuml", "\u00EF"],
        ["eth", "\u00F0"],
        ["ntilde", "\u00F1"],
        ["ograve", "\u00F2"],
        ["oacute", "\u00F3"],
        ["ocirc", "\u00F4"],
        ["otilde", "\u00F5"],
        ["ouml", "\u00F6"],
        ["divide", "\u00F7"],
        ["oslash", "\u00F8"],
        ["ugrave", "\u00F9"],
        ["uacute", "\u00FA"],
        ["ucirc", "\u00FB"],
        ["uuml", "\u00FC"],
        ["yacute", "\u00FD"],
        ["thorn", "\u00FE"],
        ["yuml", "\u00FF"],
        ["OElig", "\u0152"],
        ["oelig", "\u0153"],
        ["Scaron", "\u0160"],
        ["scaron", "\u0161"],
        ["Yuml", "\u0178"],
        ["fnof", "\u0192"],
        ["circ", "\u02C6"],
        ["tilde", "\u02DC"],
        ["Alpha", "\u0391"],
        ["Beta", "\u0392"],
        ["Gamma", "\u0393"],
        ["Delta", "\u0394"],
        ["Epsilon", "\u0395"],
        ["Zeta", "\u0396"],
        ["Eta", "\u0397"],
        ["Theta", "\u0398"],
        ["Iota", "\u0399"],
        ["Kappa", "\u039A"],
        ["Lambda", "\u039B"],
        ["Mu", "\u039C"],
        ["Nu", "\u039D"],
        ["Xi", "\u039E"],
        ["Omicron", "\u039F"],
        ["Pi", "\u03A0"],
        ["Rho", "\u03A1"],
        ["Sigma", "\u03A3"],
        ["Tau", "\u03A4"],
        ["Upsilon", "\u03A5"],
        ["Phi", "\u03A6"],
        ["Chi", "\u03A7"],
        ["Psi", "\u03A8"],
        ["Omega", "\u03A9"],
        ["alpha", "\u03B1"],
        ["beta", "\u03B2"],
        ["gamma", "\u03B3"],
        ["delta", "\u03B4"],
        ["epsilon", "\u03B5"],
        ["zeta", "\u03B6"],
        ["eta", "\u03B7"],
        ["theta", "\u03B8"],
        ["iota", "\u03B9"],
        ["kappa", "\u03BA"],
        ["lambda", "\u03BB"],
        ["mu", "\u03BC"],
        ["nu", "\u03BD"],
        ["xi", "\u03BE"],
        ["omicron", "\u03BF"],
        ["pi", "\u03C0"],
        ["rho", "\u03C1"],
        ["sigmaf", "\u03C2"],
        ["sigma", "\u03C3"],
        ["tau", "\u03C4"],
        ["upsilon", "\u03C5"],
        ["phi", "\u03C6"],
        ["chi", "\u03C7"],
        ["psi", "\u03C8"],
        ["omega", "\u03C9"],
        ["thetasym", "\u03D1"],
        ["upsih", "\u03D2"],
        ["piv", "\u03D6"],
        ["ensp", "\u2002"],
        ["emsp", "\u2003"],
        ["thinsp", "\u2009"],
        ["zwnj", "\u200C"],
        ["zwj", "\u200D"],
        ["lrm", "\u200E"],
        ["rlm", "\u200F"],
        ["ndash", "\u2013"],
        ["mdash", "\u2014"],
        ["lsquo", "\u2018"],
        ["rsquo", "\u2019"],
        ["sbquo", "\u201A"],
        ["ldquo", "\u201C"],
        ["rdquo", "\u201D"],
        ["bdquo", "\u201E"],
        ["dagger", "\u2020"],
        ["Dagger", "\u2021"],
        ["bull", "\u2022"],
        ["hellip", "\u2026"],
        ["permil", "\u2030"],
        ["prime", "\u2032"],
        ["Prime", "\u2033"],
        ["lsaquo", "\u2039"],
        ["rsaquo", "\u203A"],
        ["oline", "\u203E"],
        ["frasl", "\u2044"],
        ["euro", "\u20AC"],
        ["image", "\u2111"],
        ["weierp", "\u2118"],
        ["real", "\u211C"],
        ["trade", "\u2122"],
        ["alefsym", "\u2135"],
        ["larr", "\u2190"],
        ["uarr", "\u2191"],
        ["rarr", "\u2192"],
        ["darr", "\u2193"],
        ["harr", "\u2194"],
        ["crarr", "\u21B5"],
        ["lArr", "\u21D0"],
        ["uArr", "\u21D1"],
        ["rArr", "\u21D2"],
        ["dArr", "\u21D3"],
        ["hArr", "\u21D4"],
        ["forall", "\u2200"],
        ["part", "\u2202"],
        ["exist", "\u2203"],
        ["empty", "\u2205"],
        ["nabla", "\u2207"],
        ["isin", "\u2208"],
        ["notin", "\u2209"],
        ["ni", "\u220B"],
        ["prod", "\u220F"],
        ["sum", "\u2211"],
        ["minus", "\u2212"],
        ["lowast", "\u2217"],
        ["radic", "\u221A"],
        ["prop", "\u221D"],
        ["infin", "\u221E"],
        ["ang", "\u2220"],
        ["and", "\u2227"],
        ["or", "\u2228"],
        ["cap", "\u2229"],
        ["cup", "\u222A"],
        ["int", "\u222B"],
        ["there4", "\u2234"],
        ["sim", "\u223C"],
        ["cong", "\u2245"],
        ["asymp", "\u2248"],
        ["ne", "\u2260"],
        ["equiv", "\u2261"],
        ["le", "\u2264"],
        ["ge", "\u2265"],
        ["sub", "\u2282"],
        ["sup", "\u2283"],
        ["nsub", "\u2284"],
        ["sube", "\u2286"],
        ["supe", "\u2287"],
        ["oplus", "\u2295"],
        ["otimes", "\u2297"],
        ["perp", "\u22A5"],
        ["sdot", "\u22C5"],
        ["lceil", "\u2308"],
        ["rceil", "\u2309"],
        ["lfloor", "\u230A"],
        ["rfloor", "\u230B"],
        ["lang", "\u2329"],
        ["rang", "\u232A"],
        ["loz", "\u25CA"],
        ["spades", "\u2660"],
        ["clubs", "\u2663"],
        ["hearts", "\u2665"],
        ["diams", "\u2666"],
    ]);
},
"d797c101ed": /* sucrase\dist\esm\util\getJSXPragmaInfo.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getJSXPragmaInfo;
    function getJSXPragmaInfo(options) {
        const [base, suffix] = splitPragma(options.jsxPragma || "React.createElement");
        const [fragmentBase, fragmentSuffix] = splitPragma(options.jsxFragmentPragma || "React.Fragment");
        return { base, suffix, fragmentBase, fragmentSuffix };
    }
    function splitPragma(pragma) {
        let dotIndex = pragma.indexOf(".");
        if (dotIndex === -1) {
            dotIndex = pragma.length;
        }
        return [pragma.slice(0, dotIndex), pragma.slice(dotIndex)];
    }
},
"a46f119f74": /* sucrase\dist\esm\transformers\Transformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Transformer {
        // Return true if anything was processed, false otherwise.
        getPrefixCode() {
            return "";
        }
        getHoistedCode() {
            return "";
        }
        getSuffixCode() {
            return "";
        }
    }
    exports.default = Transformer;
},
"03a5a23920": /* sucrase\dist\esm\computeSourceMap.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = computeSourceMap;
    const gen_mapping_1 = require("dba3894e29") /* @jridgewell/gen-mapping */;
    const charcodes_1 = require("22746c8ce8") /* ./parser/util/charcodes */;
    /**
     * Generate a source map indicating that each line maps directly to the original line,
     * with the tokens in their new positions.
     */
    function computeSourceMap({ code: generatedCode, mappings: rawMappings }, filePath, options, source, tokens) {
        const sourceColumns = computeSourceColumns(source, tokens);
        const map = new gen_mapping_1.GenMapping({ file: options.compiledFilename });
        let tokenIndex = 0;
        // currentMapping is the output source index for the current input token being
        // considered.
        let currentMapping = rawMappings[0];
        while (currentMapping === undefined && tokenIndex < rawMappings.length - 1) {
            tokenIndex++;
            currentMapping = rawMappings[tokenIndex];
        }
        let line = 0;
        let lineStart = 0;
        if (currentMapping !== lineStart) {
            (0, gen_mapping_1.maybeAddSegment)(map, line, 0, filePath, line, 0);
        }
        for (let i = 0; i < generatedCode.length; i++) {
            if (i === currentMapping) {
                const genColumn = currentMapping - lineStart;
                const sourceColumn = sourceColumns[tokenIndex];
                (0, gen_mapping_1.maybeAddSegment)(map, line, genColumn, filePath, line, sourceColumn);
                while ((currentMapping === i || currentMapping === undefined) &&
                    tokenIndex < rawMappings.length - 1) {
                    tokenIndex++;
                    currentMapping = rawMappings[tokenIndex];
                }
            }
            if (generatedCode.charCodeAt(i) === charcodes_1.charCodes.lineFeed) {
                line++;
                lineStart = i + 1;
                if (currentMapping !== lineStart) {
                    (0, gen_mapping_1.maybeAddSegment)(map, line, 0, filePath, line, 0);
                }
            }
        }
        const { sourceRoot, sourcesContent, ...sourceMap } = (0, gen_mapping_1.toEncodedMap)(map);
        return sourceMap;
    }
    /**
     * Create an array mapping each token index to the 0-based column of the start
     * position of the token.
     */
    function computeSourceColumns(code, tokens) {
        const sourceColumns = new Array(tokens.length);
        let tokenIndex = 0;
        let currentMapping = tokens[tokenIndex].start;
        let lineStart = 0;
        for (let i = 0; i < code.length; i++) {
            if (i === currentMapping) {
                sourceColumns[tokenIndex] = currentMapping - lineStart;
                tokenIndex++;
                currentMapping = tokens[tokenIndex].start;
            }
            if (code.charCodeAt(i) === charcodes_1.charCodes.lineFeed) {
                lineStart = i + 1;
            }
        }
        return sourceColumns;
    }
},
"dba3894e29": /* @jridgewell\gen-mapping\dist\gen-mapping.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.addMapping = addMapping;
    exports.addSegment = addSegment;
    exports.allMappings = allMappings;
    exports.fromMap = fromMap;
    exports.setIgnore = setIgnore;
    exports.setSourceContent = setSourceContent;
    exports.toDecodedMap = toDecodedMap;
    exports.toEncodedMap = toEncodedMap;
    const set_array_1 = require("39961f1de0") /* @jridgewell/set-array */;
    const sourcemap_codec_1 = require("4b3e7fe51a") /* @jridgewell/sourcemap-codec */;
    const trace_mapping_1 = require("ed38200738") /* @jridgewell/trace-mapping */;
    const COLUMN = 0;
    const SOURCES_INDEX = 1;
    const SOURCE_LINE = 2;
    const SOURCE_COLUMN = 3;
    const NAMES_INDEX = 4;
    const NO_NAME = -1;
    /**
     * Provides the state to generate a sourcemap.
     */
    class GenMapping {
        constructor({ file, sourceRoot } = {}) {
            this._names = new set_array_1.SetArray();
            this._sources = new set_array_1.SetArray();
            this._sourcesContent = [];
            this._mappings = [];
            this.file = file;
            this.sourceRoot = sourceRoot;
            this._ignoreList = new set_array_1.SetArray();
        }
    }
    exports.GenMapping = GenMapping;
    /**
     * Typescript doesn't allow friend access to private fields, so this just casts the map into a type
     * with public access modifiers.
     */
    function cast(map) {
        return map;
    }
    function addSegment(map, genLine, genColumn, source, sourceLine, sourceColumn, name, content) {
        return addSegmentInternal(false, map, genLine, genColumn, source, sourceLine, sourceColumn, name, content);
    }
    function addMapping(map, mapping) {
        return addMappingInternal(false, map, mapping);
    }
    /**
     * Same as `addSegment`, but will only add the segment if it generates useful information in the
     * resulting map. This only works correctly if segments are added **in order**, meaning you should
     * not add a segment with a lower generated line/column than one that came before.
     */
    const maybeAddSegment = (map, genLine, genColumn, source, sourceLine, sourceColumn, name, content) => {
        return addSegmentInternal(true, map, genLine, genColumn, source, sourceLine, sourceColumn, name, content);
    };
    exports.maybeAddSegment = maybeAddSegment;
    /**
     * Same as `addMapping`, but will only add the mapping if it generates useful information in the
     * resulting map. This only works correctly if mappings are added **in order**, meaning you should
     * not add a mapping with a lower generated line/column than one that came before.
     */
    const maybeAddMapping = (map, mapping) => {
        return addMappingInternal(true, map, mapping);
    };
    exports.maybeAddMapping = maybeAddMapping;
    /**
     * Adds/removes the content of the source file to the source map.
     */
    function setSourceContent(map, source, content) {
        const { _sources: sources, _sourcesContent: sourcesContent } = cast(map);
        const index = (0, set_array_1.put)(sources, source);
        sourcesContent[index] = content;
    }
    function setIgnore(map, source, ignore = true) {
        const { _sources: sources, _sourcesContent: sourcesContent, _ignoreList: ignoreList } = cast(map);
        const index = (0, set_array_1.put)(sources, source);
        if (index === sourcesContent.length)
            sourcesContent[index] = null;
        if (ignore)
            (0, set_array_1.put)(ignoreList, index);
        else
            (0, set_array_1.remove)(ignoreList, index);
    }
    /**
     * Returns a sourcemap object (with decoded mappings) suitable for passing to a library that expects
     * a sourcemap, or to JSON.stringify.
     */
    function toDecodedMap(map) {
        const { _mappings: mappings, _sources: sources, _sourcesContent: sourcesContent, _names: names, _ignoreList: ignoreList, } = cast(map);
        removeEmptyFinalLines(mappings);
        return {
            version: 3,
            file: map.file || undefined,
            names: names.array,
            sourceRoot: map.sourceRoot || undefined,
            sources: sources.array,
            sourcesContent,
            mappings,
            ignoreList: ignoreList.array,
        };
    }
    /**
     * Returns a sourcemap object (with encoded mappings) suitable for passing to a library that expects
     * a sourcemap, or to JSON.stringify.
     */
    function toEncodedMap(map) {
        const decoded = toDecodedMap(map);
        return Object.assign(Object.assign({}, decoded), { mappings: (0, sourcemap_codec_1.encode)(decoded.mappings) });
    }
    /**
     * Constructs a new GenMapping, using the already present mappings of the input.
     */
    function fromMap(input) {
        const map = new trace_mapping_1.TraceMap(input);
        const gen = new GenMapping({ file: map.file, sourceRoot: map.sourceRoot });
        putAll(cast(gen)._names, map.names);
        putAll(cast(gen)._sources, map.sources);
        cast(gen)._sourcesContent = map.sourcesContent || map.sources.map(() => null);
        cast(gen)._mappings = (0, trace_mapping_1.decodedMappings)(map);
        if (map.ignoreList)
            putAll(cast(gen)._ignoreList, map.ignoreList);
        return gen;
    }
    /**
     * Returns an array of high-level mapping objects for every recorded segment, which could then be
     * passed to the `source-map` library.
     */
    function allMappings(map) {
        const out = [];
        const { _mappings: mappings, _sources: sources, _names: names } = cast(map);
        for (let i = 0; i < mappings.length; i++) {
            const line = mappings[i];
            for (let j = 0; j < line.length; j++) {
                const seg = line[j];
                const generated = { line: i + 1, column: seg[COLUMN] };
                let source = undefined;
                let original = undefined;
                let name = undefined;
                if (seg.length !== 1) {
                    source = sources.array[seg[SOURCES_INDEX]];
                    original = { line: seg[SOURCE_LINE] + 1, column: seg[SOURCE_COLUMN] };
                    if (seg.length === 5)
                        name = names.array[seg[NAMES_INDEX]];
                }
                out.push({ generated, source, original, name });
            }
        }
        return out;
    }
    // This split declaration is only so that terser can elminiate the static initialization block.
    function addSegmentInternal(skipable, map, genLine, genColumn, source, sourceLine, sourceColumn, name, content) {
        const { _mappings: mappings, _sources: sources, _sourcesContent: sourcesContent, _names: names, } = cast(map);
        const line = getLine(mappings, genLine);
        const index = getColumnIndex(line, genColumn);
        if (!source) {
            if (skipable && skipSourceless(line, index))
                return;
            return insert(line, index, [genColumn]);
        }
        const sourcesIndex = (0, set_array_1.put)(sources, source);
        const namesIndex = name ? (0, set_array_1.put)(names, name) : NO_NAME;
        if (sourcesIndex === sourcesContent.length)
            sourcesContent[sourcesIndex] = content !== null && content !== void 0 ? content : null;
        if (skipable && skipSource(line, index, sourcesIndex, sourceLine, sourceColumn, namesIndex)) {
            return;
        }
        return insert(line, index, name
            ? [genColumn, sourcesIndex, sourceLine, sourceColumn, namesIndex]
            : [genColumn, sourcesIndex, sourceLine, sourceColumn]);
    }
    function getLine(mappings, index) {
        for (let i = mappings.length; i <= index; i++) {
            mappings[i] = [];
        }
        return mappings[index];
    }
    function getColumnIndex(line, genColumn) {
        let index = line.length;
        for (let i = index - 1; i >= 0; index = i--) {
            const current = line[i];
            if (genColumn >= current[COLUMN])
                break;
        }
        return index;
    }
    function insert(array, index, value) {
        for (let i = array.length; i > index; i--) {
            array[i] = array[i - 1];
        }
        array[index] = value;
    }
    function removeEmptyFinalLines(mappings) {
        const { length } = mappings;
        let len = length;
        for (let i = len - 1; i >= 0; len = i, i--) {
            if (mappings[i].length > 0)
                break;
        }
        if (len < length)
            mappings.length = len;
    }
    function putAll(setarr, array) {
        for (let i = 0; i < array.length; i++)
            (0, set_array_1.put)(setarr, array[i]);
    }
    function skipSourceless(line, index) {
        // The start of a line is already sourceless, so adding a sourceless segment to the beginning
        // doesn't generate any useful information.
        if (index === 0)
            return true;
        const prev = line[index - 1];
        // If the previous segment is also sourceless, then adding another sourceless segment doesn't
        // genrate any new information. Else, this segment will end the source/named segment and point to
        // a sourceless position, which is useful.
        return prev.length === 1;
    }
    function skipSource(line, index, sourcesIndex, sourceLine, sourceColumn, namesIndex) {
        // A source/named segment at the start of a line gives position at that genColumn
        if (index === 0)
            return false;
        const prev = line[index - 1];
        // If the previous segment is sourceless, then we're transitioning to a source.
        if (prev.length === 1)
            return false;
        // If the previous segment maps to the exact same source position, then this segment doesn't
        // provide any new position information.
        return (sourcesIndex === prev[SOURCES_INDEX] &&
            sourceLine === prev[SOURCE_LINE] &&
            sourceColumn === prev[SOURCE_COLUMN] &&
            namesIndex === (prev.length === 5 ? prev[NAMES_INDEX] : NO_NAME));
    }
    function addMappingInternal(skipable, map, mapping) {
        const { generated, source, original, name, content } = mapping;
        if (!source) {
            return addSegmentInternal(skipable, map, generated.line - 1, generated.column, null, null, null, null, null);
        }
        return addSegmentInternal(skipable, map, generated.line - 1, generated.column, source, original.line - 1, original.column, name, content);
    }
},
"39961f1de0": /* @jridgewell\set-array\dist\set-array.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.get = get;
    exports.pop = pop;
    exports.put = put;
    exports.remove = remove;
    /**
     * SetArray acts like a `Set` (allowing only one occurrence of a string `key`), but provides the
     * index of the `key` in the backing array.
     *
     * This is designed to allow synchronizing a second array with the contents of the backing array,
     * like how in a sourcemap `sourcesContent[i]` is the source content associated with `source[i]`,
     * and there are never duplicates.
     */
    class SetArray {
        constructor() {
            this._indexes = { __proto__: null };
            this.array = [];
        }
    }
    exports.SetArray = SetArray;
    /**
     * Typescript doesn't allow friend access to private fields, so this just casts the set into a type
     * with public access modifiers.
     */
    function cast(set) {
        return set;
    }
    /**
     * Gets the index associated with `key` in the backing array, if it is already present.
     */
    function get(setarr, key) {
        return cast(setarr)._indexes[key];
    }
    /**
     * Puts `key` into the backing array, if it is not already present. Returns
     * the index of the `key` in the backing array.
     */
    function put(setarr, key) {
        // The key may or may not be present. If it is present, it's a number.
        const index = get(setarr, key);
        if (index !== undefined)
            return index;
        const { array, _indexes: indexes } = cast(setarr);
        const length = array.push(key);
        return (indexes[key] = length - 1);
    }
    /**
     * Pops the last added item out of the SetArray.
     */
    function pop(setarr) {
        const { array, _indexes: indexes } = cast(setarr);
        if (array.length === 0)
            return;
        const last = array.pop();
        indexes[last] = undefined;
    }
    /**
     * Removes the key, if it exists in the set.
     */
    function remove(setarr, key) {
        const index = get(setarr, key);
        if (index === undefined)
            return;
        const { array, _indexes: indexes } = cast(setarr);
        for (let i = index + 1; i < array.length; i++) {
            const k = array[i];
            array[i - 1] = k;
            indexes[k]--;
        }
        indexes[key] = undefined;
        array.pop();
    }
},
"4b3e7fe51a": /* @jridgewell\sourcemap-codec\dist\sourcemap-codec.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.decode = decode;
    exports.decodeGeneratedRanges = decodeGeneratedRanges;
    exports.decodeOriginalScopes = decodeOriginalScopes;
    exports.encode = encode;
    exports.encodeGeneratedRanges = encodeGeneratedRanges;
    exports.encodeOriginalScopes = encodeOriginalScopes;
    const comma = ','.charCodeAt(0);
    const semicolon = ';'.charCodeAt(0);
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    const intToChar = new Uint8Array(64); // 64 possible chars.
    const charToInt = new Uint8Array(128); // z is 122 in ASCII
    for (let i = 0; i < chars.length; i++) {
        const c = chars.charCodeAt(i);
        intToChar[i] = c;
        charToInt[c] = i;
    }
    function decodeInteger(reader, relative) {
        let value = 0;
        let shift = 0;
        let integer = 0;
        do {
            const c = reader.next();
            integer = charToInt[c];
            value |= (integer & 31) << shift;
            shift += 5;
        } while (integer & 32);
        const shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
            value = -0x80000000 | -value;
        }
        return relative + value;
    }
    function encodeInteger(builder, num, relative) {
        let delta = num - relative;
        delta = delta < 0 ? (-delta << 1) | 1 : delta << 1;
        do {
            let clamped = delta & 0b011111;
            delta >>>= 5;
            if (delta > 0)
                clamped |= 0b100000;
            builder.write(intToChar[clamped]);
        } while (delta > 0);
        return num;
    }
    function hasMoreVlq(reader, max) {
        if (reader.pos >= max)
            return false;
        return reader.peek() !== comma;
    }
    const bufLength = 1024 * 16;
    // Provide a fallback for older environments.
    const td = typeof TextDecoder !== 'undefined'
        ? /* #__PURE__ */ new TextDecoder()
        : typeof Buffer !== 'undefined'
            ? {
                decode(buf) {
                    const out = Buffer.from(buf.buffer, buf.byteOffset, buf.byteLength);
                    return out.toString();
                },
            }
            : {
                decode(buf) {
                    let out = '';
                    for (let i = 0; i < buf.length; i++) {
                        out += String.fromCharCode(buf[i]);
                    }
                    return out;
                },
            };
    class StringWriter {
        constructor() {
            this.pos = 0;
            this.out = '';
            this.buffer = new Uint8Array(bufLength);
        }
        write(v) {
            const { buffer } = this;
            buffer[this.pos++] = v;
            if (this.pos === bufLength) {
                this.out += td.decode(buffer);
                this.pos = 0;
            }
        }
        flush() {
            const { buffer, out, pos } = this;
            return pos > 0 ? out + td.decode(buffer.subarray(0, pos)) : out;
        }
    }
    class StringReader {
        constructor(buffer) {
            this.pos = 0;
            this.buffer = buffer;
        }
        next() {
            return this.buffer.charCodeAt(this.pos++);
        }
        peek() {
            return this.buffer.charCodeAt(this.pos);
        }
        indexOf(char) {
            const { buffer, pos } = this;
            const idx = buffer.indexOf(char, pos);
            return idx === -1 ? buffer.length : idx;
        }
    }
    const EMPTY = [];
    function decodeOriginalScopes(input) {
        const { length } = input;
        const reader = new StringReader(input);
        const scopes = [];
        const stack = [];
        let line = 0;
        for (; reader.pos < length; reader.pos++) {
            line = decodeInteger(reader, line);
            const column = decodeInteger(reader, 0);
            if (!hasMoreVlq(reader, length)) {
                const last = stack.pop();
                last[2] = line;
                last[3] = column;
                continue;
            }
            const kind = decodeInteger(reader, 0);
            const fields = decodeInteger(reader, 0);
            const hasName = fields & 0b0001;
            const scope = (hasName ? [line, column, 0, 0, kind, decodeInteger(reader, 0)] : [line, column, 0, 0, kind]);
            let vars = EMPTY;
            if (hasMoreVlq(reader, length)) {
                vars = [];
                do {
                    const varsIndex = decodeInteger(reader, 0);
                    vars.push(varsIndex);
                } while (hasMoreVlq(reader, length));
            }
            scope.vars = vars;
            scopes.push(scope);
            stack.push(scope);
        }
        return scopes;
    }
    function encodeOriginalScopes(scopes) {
        const writer = new StringWriter();
        for (let i = 0; i < scopes.length;) {
            i = _encodeOriginalScopes(scopes, i, writer, [0]);
        }
        return writer.flush();
    }
    function _encodeOriginalScopes(scopes, index, writer, state) {
        const scope = scopes[index];
        const { 0: startLine, 1: startColumn, 2: endLine, 3: endColumn, 4: kind, vars } = scope;
        if (index > 0)
            writer.write(comma);
        state[0] = encodeInteger(writer, startLine, state[0]);
        encodeInteger(writer, startColumn, 0);
        encodeInteger(writer, kind, 0);
        const fields = scope.length === 6 ? 0b0001 : 0;
        encodeInteger(writer, fields, 0);
        if (scope.length === 6)
            encodeInteger(writer, scope[5], 0);
        for (const v of vars) {
            encodeInteger(writer, v, 0);
        }
        for (index++; index < scopes.length;) {
            const next = scopes[index];
            const { 0: l, 1: c } = next;
            if (l > endLine || (l === endLine && c >= endColumn)) {
                break;
            }
            index = _encodeOriginalScopes(scopes, index, writer, state);
        }
        writer.write(comma);
        state[0] = encodeInteger(writer, endLine, state[0]);
        encodeInteger(writer, endColumn, 0);
        return index;
    }
    function decodeGeneratedRanges(input) {
        const { length } = input;
        const reader = new StringReader(input);
        const ranges = [];
        const stack = [];
        let genLine = 0;
        let definitionSourcesIndex = 0;
        let definitionScopeIndex = 0;
        let callsiteSourcesIndex = 0;
        let callsiteLine = 0;
        let callsiteColumn = 0;
        let bindingLine = 0;
        let bindingColumn = 0;
        do {
            const semi = reader.indexOf(';');
            let genColumn = 0;
            for (; reader.pos < semi; reader.pos++) {
                genColumn = decodeInteger(reader, genColumn);
                if (!hasMoreVlq(reader, semi)) {
                    const last = stack.pop();
                    last[2] = genLine;
                    last[3] = genColumn;
                    continue;
                }
                const fields = decodeInteger(reader, 0);
                const hasDefinition = fields & 0b0001;
                const hasCallsite = fields & 0b0010;
                const hasScope = fields & 0b0100;
                let callsite = null;
                let bindings = EMPTY;
                let range;
                if (hasDefinition) {
                    const defSourcesIndex = decodeInteger(reader, definitionSourcesIndex);
                    definitionScopeIndex = decodeInteger(reader, definitionSourcesIndex === defSourcesIndex ? definitionScopeIndex : 0);
                    definitionSourcesIndex = defSourcesIndex;
                    range = [genLine, genColumn, 0, 0, defSourcesIndex, definitionScopeIndex];
                }
                else {
                    range = [genLine, genColumn, 0, 0];
                }
                range.isScope = !!hasScope;
                if (hasCallsite) {
                    const prevCsi = callsiteSourcesIndex;
                    const prevLine = callsiteLine;
                    callsiteSourcesIndex = decodeInteger(reader, callsiteSourcesIndex);
                    const sameSource = prevCsi === callsiteSourcesIndex;
                    callsiteLine = decodeInteger(reader, sameSource ? callsiteLine : 0);
                    callsiteColumn = decodeInteger(reader, sameSource && prevLine === callsiteLine ? callsiteColumn : 0);
                    callsite = [callsiteSourcesIndex, callsiteLine, callsiteColumn];
                }
                range.callsite = callsite;
                if (hasMoreVlq(reader, semi)) {
                    bindings = [];
                    do {
                        bindingLine = genLine;
                        bindingColumn = genColumn;
                        const expressionsCount = decodeInteger(reader, 0);
                        let expressionRanges;
                        if (expressionsCount < -1) {
                            expressionRanges = [[decodeInteger(reader, 0)]];
                            for (let i = -1; i > expressionsCount; i--) {
                                const prevBl = bindingLine;
                                bindingLine = decodeInteger(reader, bindingLine);
                                bindingColumn = decodeInteger(reader, bindingLine === prevBl ? bindingColumn : 0);
                                const expression = decodeInteger(reader, 0);
                                expressionRanges.push([expression, bindingLine, bindingColumn]);
                            }
                        }
                        else {
                            expressionRanges = [[expressionsCount]];
                        }
                        bindings.push(expressionRanges);
                    } while (hasMoreVlq(reader, semi));
                }
                range.bindings = bindings;
                ranges.push(range);
                stack.push(range);
            }
            genLine++;
            reader.pos = semi + 1;
        } while (reader.pos < length);
        return ranges;
    }
    function encodeGeneratedRanges(ranges) {
        if (ranges.length === 0)
            return '';
        const writer = new StringWriter();
        for (let i = 0; i < ranges.length;) {
            i = _encodeGeneratedRanges(ranges, i, writer, [0, 0, 0, 0, 0, 0, 0]);
        }
        return writer.flush();
    }
    function _encodeGeneratedRanges(ranges, index, writer, state) {
        const range = ranges[index];
        const { 0: startLine, 1: startColumn, 2: endLine, 3: endColumn, isScope, callsite, bindings, } = range;
        if (state[0] < startLine) {
            catchupLine(writer, state[0], startLine);
            state[0] = startLine;
            state[1] = 0;
        }
        else if (index > 0) {
            writer.write(comma);
        }
        state[1] = encodeInteger(writer, range[1], state[1]);
        const fields = (range.length === 6 ? 0b0001 : 0) | (callsite ? 0b0010 : 0) | (isScope ? 0b0100 : 0);
        encodeInteger(writer, fields, 0);
        if (range.length === 6) {
            const { 4: sourcesIndex, 5: scopesIndex } = range;
            if (sourcesIndex !== state[2]) {
                state[3] = 0;
            }
            state[2] = encodeInteger(writer, sourcesIndex, state[2]);
            state[3] = encodeInteger(writer, scopesIndex, state[3]);
        }
        if (callsite) {
            const { 0: sourcesIndex, 1: callLine, 2: callColumn } = range.callsite;
            if (sourcesIndex !== state[4]) {
                state[5] = 0;
                state[6] = 0;
            }
            else if (callLine !== state[5]) {
                state[6] = 0;
            }
            state[4] = encodeInteger(writer, sourcesIndex, state[4]);
            state[5] = encodeInteger(writer, callLine, state[5]);
            state[6] = encodeInteger(writer, callColumn, state[6]);
        }
        if (bindings) {
            for (const binding of bindings) {
                if (binding.length > 1)
                    encodeInteger(writer, -binding.length, 0);
                const expression = binding[0][0];
                encodeInteger(writer, expression, 0);
                let bindingStartLine = startLine;
                let bindingStartColumn = startColumn;
                for (let i = 1; i < binding.length; i++) {
                    const expRange = binding[i];
                    bindingStartLine = encodeInteger(writer, expRange[1], bindingStartLine);
                    bindingStartColumn = encodeInteger(writer, expRange[2], bindingStartColumn);
                    encodeInteger(writer, expRange[0], 0);
                }
            }
        }
        for (index++; index < ranges.length;) {
            const next = ranges[index];
            const { 0: l, 1: c } = next;
            if (l > endLine || (l === endLine && c >= endColumn)) {
                break;
            }
            index = _encodeGeneratedRanges(ranges, index, writer, state);
        }
        if (state[0] < endLine) {
            catchupLine(writer, state[0], endLine);
            state[0] = endLine;
            state[1] = 0;
        }
        else {
            writer.write(comma);
        }
        state[1] = encodeInteger(writer, endColumn, state[1]);
        return index;
    }
    function catchupLine(writer, lastLine, line) {
        do {
            writer.write(semicolon);
        } while (++lastLine < line);
    }
    function decode(mappings) {
        const { length } = mappings;
        const reader = new StringReader(mappings);
        const decoded = [];
        let genColumn = 0;
        let sourcesIndex = 0;
        let sourceLine = 0;
        let sourceColumn = 0;
        let namesIndex = 0;
        do {
            const semi = reader.indexOf(';');
            const line = [];
            let sorted = true;
            let lastCol = 0;
            genColumn = 0;
            while (reader.pos < semi) {
                let seg;
                genColumn = decodeInteger(reader, genColumn);
                if (genColumn < lastCol)
                    sorted = false;
                lastCol = genColumn;
                if (hasMoreVlq(reader, semi)) {
                    sourcesIndex = decodeInteger(reader, sourcesIndex);
                    sourceLine = decodeInteger(reader, sourceLine);
                    sourceColumn = decodeInteger(reader, sourceColumn);
                    if (hasMoreVlq(reader, semi)) {
                        namesIndex = decodeInteger(reader, namesIndex);
                        seg = [genColumn, sourcesIndex, sourceLine, sourceColumn, namesIndex];
                    }
                    else {
                        seg = [genColumn, sourcesIndex, sourceLine, sourceColumn];
                    }
                }
                else {
                    seg = [genColumn];
                }
                line.push(seg);
                reader.pos++;
            }
            if (!sorted)
                sort(line);
            decoded.push(line);
            reader.pos = semi + 1;
        } while (reader.pos <= length);
        return decoded;
    }
    function sort(line) {
        line.sort(sortComparator);
    }
    function sortComparator(a, b) {
        return a[0] - b[0];
    }
    function encode(decoded) {
        const writer = new StringWriter();
        let sourcesIndex = 0;
        let sourceLine = 0;
        let sourceColumn = 0;
        let namesIndex = 0;
        for (let i = 0; i < decoded.length; i++) {
            const line = decoded[i];
            if (i > 0)
                writer.write(semicolon);
            if (line.length === 0)
                continue;
            let genColumn = 0;
            for (let j = 0; j < line.length; j++) {
                const segment = line[j];
                if (j > 0)
                    writer.write(comma);
                genColumn = encodeInteger(writer, segment[0], genColumn);
                if (segment.length === 1)
                    continue;
                sourcesIndex = encodeInteger(writer, segment[1], sourcesIndex);
                sourceLine = encodeInteger(writer, segment[2], sourceLine);
                sourceColumn = encodeInteger(writer, segment[3], sourceColumn);
                if (segment.length === 4)
                    continue;
                namesIndex = encodeInteger(writer, segment[4], namesIndex);
            }
        }
        return writer.flush();
    }
},
"ed38200738": /* @jridgewell\trace-mapping\dist\trace-mapping.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.allGeneratedPositionsFor = allGeneratedPositionsFor;
    exports.decodedMap = decodedMap;
    exports.decodedMappings = decodedMappings;
    exports.eachMapping = eachMapping;
    exports.encodedMap = encodedMap;
    exports.encodedMappings = encodedMappings;
    exports.generatedPositionFor = generatedPositionFor;
    exports.isIgnored = isIgnored;
    exports.originalPositionFor = originalPositionFor;
    exports.presortedDecodedMap = presortedDecodedMap;
    exports.sourceContentFor = sourceContentFor;
    exports.traceSegment = traceSegment;
    const tslib_1 = require("tslib");
    const sourcemap_codec_1 = require("4b3e7fe51a") /* @jridgewell/sourcemap-codec */;
    const resolve_uri_1 = tslib_1.__importDefault(require("92bc7d86f0") /* @jridgewell/resolve-uri */);
    function resolve(input, base) {
        // The base is always treated as a directory, if it's not empty.
        // https://github.com/mozilla/source-map/blob/8cb3ee57/lib/util.js#L327
        // https://github.com/chromium/chromium/blob/da4adbb3/third_party/blink/renderer/devtools/front_end/sdk/SourceMap.js#L400-L401
        if (base && !base.endsWith('/'))
            base += '/';
        return (0, resolve_uri_1.default)(input, base);
    }
    /**
     * Removes everything after the last "/", but leaves the slash.
     */
    function stripFilename(path) {
        if (!path)
            return '';
        const index = path.lastIndexOf('/');
        return path.slice(0, index + 1);
    }
    const COLUMN = 0;
    const SOURCES_INDEX = 1;
    const SOURCE_LINE = 2;
    const SOURCE_COLUMN = 3;
    const NAMES_INDEX = 4;
    const REV_GENERATED_LINE = 1;
    const REV_GENERATED_COLUMN = 2;
    function maybeSort(mappings, owned) {
        const unsortedIndex = nextUnsortedSegmentLine(mappings, 0);
        if (unsortedIndex === mappings.length)
            return mappings;
        // If we own the array (meaning we parsed it from JSON), then we're free to directly mutate it. If
        // not, we do not want to modify the consumer's input array.
        if (!owned)
            mappings = mappings.slice();
        for (let i = unsortedIndex; i < mappings.length; i = nextUnsortedSegmentLine(mappings, i + 1)) {
            mappings[i] = sortSegments(mappings[i], owned);
        }
        return mappings;
    }
    function nextUnsortedSegmentLine(mappings, start) {
        for (let i = start; i < mappings.length; i++) {
            if (!isSorted(mappings[i]))
                return i;
        }
        return mappings.length;
    }
    function isSorted(line) {
        for (let j = 1; j < line.length; j++) {
            if (line[j][COLUMN] < line[j - 1][COLUMN]) {
                return false;
            }
        }
        return true;
    }
    function sortSegments(line, owned) {
        if (!owned)
            line = line.slice();
        return line.sort(sortComparator);
    }
    function sortComparator(a, b) {
        return a[COLUMN] - b[COLUMN];
    }
    let found = false;
    /**
     * A binary search implementation that returns the index if a match is found.
     * If no match is found, then the left-index (the index associated with the item that comes just
     * before the desired index) is returned. To maintain proper sort order, a splice would happen at
     * the next index:
     *
     * ```js
     * const array = [1, 3];
     * const needle = 2;
     * const index = binarySearch(array, needle, (item, needle) => item - needle);
     *
     * assert.equal(index, 0);
     * array.splice(index + 1, 0, needle);
     * assert.deepEqual(array, [1, 2, 3]);
     * ```
     */
    function binarySearch(haystack, needle, low, high) {
        while (low <= high) {
            const mid = low + ((high - low) >> 1);
            const cmp = haystack[mid][COLUMN] - needle;
            if (cmp === 0) {
                found = true;
                return mid;
            }
            if (cmp < 0) {
                low = mid + 1;
            }
            else {
                high = mid - 1;
            }
        }
        found = false;
        return low - 1;
    }
    function upperBound(haystack, needle, index) {
        for (let i = index + 1; i < haystack.length; index = i++) {
            if (haystack[i][COLUMN] !== needle)
                break;
        }
        return index;
    }
    function lowerBound(haystack, needle, index) {
        for (let i = index - 1; i >= 0; index = i--) {
            if (haystack[i][COLUMN] !== needle)
                break;
        }
        return index;
    }
    function memoizedState() {
        return {
            lastKey: -1,
            lastNeedle: -1,
            lastIndex: -1,
        };
    }
    /**
     * This overly complicated beast is just to record the last tested line/column and the resulting
     * index, allowing us to skip a few tests if mappings are monotonically increasing.
     */
    function memoizedBinarySearch(haystack, needle, state, key) {
        const { lastKey, lastNeedle, lastIndex } = state;
        let low = 0;
        let high = haystack.length - 1;
        if (key === lastKey) {
            if (needle === lastNeedle) {
                found = lastIndex !== -1 && haystack[lastIndex][COLUMN] === needle;
                return lastIndex;
            }
            if (needle >= lastNeedle) {
                // lastIndex may be -1 if the previous needle was not found.
                low = lastIndex === -1 ? 0 : lastIndex;
            }
            else {
                high = lastIndex;
            }
        }
        state.lastKey = key;
        state.lastNeedle = needle;
        return (state.lastIndex = binarySearch(haystack, needle, low, high));
    }
    // Rebuilds the original source files, with mappings that are ordered by source line/column instead
    // of generated line/column.
    function buildBySources(decoded, memos) {
        const sources = memos.map(buildNullArray);
        for (let i = 0; i < decoded.length; i++) {
            const line = decoded[i];
            for (let j = 0; j < line.length; j++) {
                const seg = line[j];
                if (seg.length === 1)
                    continue;
                const sourceIndex = seg[SOURCES_INDEX];
                const sourceLine = seg[SOURCE_LINE];
                const sourceColumn = seg[SOURCE_COLUMN];
                const originalSource = sources[sourceIndex];
                const originalLine = (originalSource[sourceLine] || (originalSource[sourceLine] = []));
                const memo = memos[sourceIndex];
                // The binary search either found a match, or it found the left-index just before where the
                // segment should go. Either way, we want to insert after that. And there may be multiple
                // generated segments associated with an original location, so there may need to move several
                // indexes before we find where we need to insert.
                let index = upperBound(originalLine, sourceColumn, memoizedBinarySearch(originalLine, sourceColumn, memo, sourceLine));
                memo.lastIndex = ++index;
                insert(originalLine, index, [sourceColumn, i, seg[COLUMN]]);
            }
        }
        return sources;
    }
    function insert(array, index, value) {
        for (let i = array.length; i > index; i--) {
            array[i] = array[i - 1];
        }
        array[index] = value;
    }
    // Null arrays allow us to use ordered index keys without actually allocating contiguous memory like
    // a real array. We use a null-prototype object to avoid prototype pollution and deoptimizations.
    // Numeric properties on objects are magically sorted in ascending order by the engine regardless of
    // the insertion order. So, by setting any numeric keys, even out of order, we'll get ascending
    // order when iterating with for-in.
    function buildNullArray() {
        return { __proto__: null };
    }
    const AnyMap = function (map, mapUrl) {
        const parsed = parse(map);
        if (!('sections' in parsed)) {
            return new TraceMap(parsed, mapUrl);
        }
        const mappings = [];
        const sources = [];
        const sourcesContent = [];
        const names = [];
        const ignoreList = [];
        recurse(parsed, mapUrl, mappings, sources, sourcesContent, names, ignoreList, 0, 0, Infinity, Infinity);
        const joined = {
            version: 3,
            file: parsed.file,
            names,
            sources,
            sourcesContent,
            mappings,
            ignoreList,
        };
        return presortedDecodedMap(joined);
    };
    exports.AnyMap = AnyMap;
    function parse(map) {
        return typeof map === 'string' ? JSON.parse(map) : map;
    }
    function recurse(input, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset, columnOffset, stopLine, stopColumn) {
        const { sections } = input;
        for (let i = 0; i < sections.length; i++) {
            const { map, offset } = sections[i];
            let sl = stopLine;
            let sc = stopColumn;
            if (i + 1 < sections.length) {
                const nextOffset = sections[i + 1].offset;
                sl = Math.min(stopLine, lineOffset + nextOffset.line);
                if (sl === stopLine) {
                    sc = Math.min(stopColumn, columnOffset + nextOffset.column);
                }
                else if (sl < stopLine) {
                    sc = columnOffset + nextOffset.column;
                }
            }
            addSection(map, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset + offset.line, columnOffset + offset.column, sl, sc);
        }
    }
    function addSection(input, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset, columnOffset, stopLine, stopColumn) {
        const parsed = parse(input);
        if ('sections' in parsed)
            return recurse(...arguments);
        const map = new TraceMap(parsed, mapUrl);
        const sourcesOffset = sources.length;
        const namesOffset = names.length;
        const decoded = decodedMappings(map);
        const { resolvedSources, sourcesContent: contents, ignoreList: ignores } = map;
        append(sources, resolvedSources);
        append(names, map.names);
        if (contents)
            append(sourcesContent, contents);
        else
            for (let i = 0; i < resolvedSources.length; i++)
                sourcesContent.push(null);
        if (ignores)
            for (let i = 0; i < ignores.length; i++)
                ignoreList.push(ignores[i] + sourcesOffset);
        for (let i = 0; i < decoded.length; i++) {
            const lineI = lineOffset + i;
            // We can only add so many lines before we step into the range that the next section's map
            // controls. When we get to the last line, then we'll start checking the segments to see if
            // they've crossed into the column range. But it may not have any columns that overstep, so we
            // still need to check that we don't overstep lines, too.
            if (lineI > stopLine)
                return;
            // The out line may already exist in mappings (if we're continuing the line started by a
            // previous section). Or, we may have jumped ahead several lines to start this section.
            const out = getLine(mappings, lineI);
            // On the 0th loop, the section's column offset shifts us forward. On all other lines (since the
            // map can be multiple lines), it doesn't.
            const cOffset = i === 0 ? columnOffset : 0;
            const line = decoded[i];
            for (let j = 0; j < line.length; j++) {
                const seg = line[j];
                const column = cOffset + seg[COLUMN];
                // If this segment steps into the column range that the next section's map controls, we need
                // to stop early.
                if (lineI === stopLine && column >= stopColumn)
                    return;
                if (seg.length === 1) {
                    out.push([column]);
                    continue;
                }
                const sourcesIndex = sourcesOffset + seg[SOURCES_INDEX];
                const sourceLine = seg[SOURCE_LINE];
                const sourceColumn = seg[SOURCE_COLUMN];
                out.push(seg.length === 4
                    ? [column, sourcesIndex, sourceLine, sourceColumn]
                    : [column, sourcesIndex, sourceLine, sourceColumn, namesOffset + seg[NAMES_INDEX]]);
            }
        }
    }
    function append(arr, other) {
        for (let i = 0; i < other.length; i++)
            arr.push(other[i]);
    }
    function getLine(arr, index) {
        for (let i = arr.length; i <= index; i++)
            arr[i] = [];
        return arr[index];
    }
    const LINE_GTR_ZERO = '`line` must be greater than 0 (lines start at line 1)';
    const COL_GTR_EQ_ZERO = '`column` must be greater than or equal to 0 (columns start at column 0)';
    const LEAST_UPPER_BOUND = -1;
    exports.LEAST_UPPER_BOUND = LEAST_UPPER_BOUND;
    const GREATEST_LOWER_BOUND = 1;
    exports.GREATEST_LOWER_BOUND = GREATEST_LOWER_BOUND;
    class TraceMap {
        constructor(map, mapUrl) {
            const isString = typeof map === 'string';
            if (!isString && map._decodedMemo)
                return map;
            const parsed = (isString ? JSON.parse(map) : map);
            const { version, file, names, sourceRoot, sources, sourcesContent } = parsed;
            this.version = version;
            this.file = file;
            this.names = names || [];
            this.sourceRoot = sourceRoot;
            this.sources = sources;
            this.sourcesContent = sourcesContent;
            this.ignoreList = parsed.ignoreList || parsed.x_google_ignoreList || undefined;
            const from = resolve(sourceRoot || '', stripFilename(mapUrl));
            this.resolvedSources = sources.map((s) => resolve(s || '', from));
            const { mappings } = parsed;
            if (typeof mappings === 'string') {
                this._encoded = mappings;
                this._decoded = undefined;
            }
            else {
                this._encoded = undefined;
                this._decoded = maybeSort(mappings, isString);
            }
            this._decodedMemo = memoizedState();
            this._bySources = undefined;
            this._bySourceMemos = undefined;
        }
    }
    exports.TraceMap = TraceMap;
    /**
     * Typescript doesn't allow friend access to private fields, so this just casts the map into a type
     * with public access modifiers.
     */
    function cast(map) {
        return map;
    }
    /**
     * Returns the encoded (VLQ string) form of the SourceMap's mappings field.
     */
    function encodedMappings(map) {
        var _a;
        var _b;
        return ((_a = (_b = cast(map))._encoded) !== null && _a !== void 0 ? _a : (_b._encoded = (0, sourcemap_codec_1.encode)(cast(map)._decoded)));
    }
    /**
     * Returns the decoded (array of lines of segments) form of the SourceMap's mappings field.
     */
    function decodedMappings(map) {
        var _a;
        return ((_a = cast(map))._decoded || (_a._decoded = (0, sourcemap_codec_1.decode)(cast(map)._encoded)));
    }
    /**
     * A low-level API to find the segment associated with a generated line/column (think, from a
     * stack trace). Line and column here are 0-based, unlike `originalPositionFor`.
     */
    function traceSegment(map, line, column) {
        const decoded = decodedMappings(map);
        // It's common for parent source maps to have pointers to lines that have no
        // mapping (like a "//# sourceMappingURL=") at the end of the child file.
        if (line >= decoded.length)
            return null;
        const segments = decoded[line];
        const index = traceSegmentInternal(segments, cast(map)._decodedMemo, line, column, GREATEST_LOWER_BOUND);
        return index === -1 ? null : segments[index];
    }
    /**
     * A higher-level API to find the source/line/column associated with a generated line/column
     * (think, from a stack trace). Line is 1-based, but column is 0-based, due to legacy behavior in
     * `source-map` library.
     */
    function originalPositionFor(map, needle) {
        let { line, column, bias } = needle;
        line--;
        if (line < 0)
            throw new Error(LINE_GTR_ZERO);
        if (column < 0)
            throw new Error(COL_GTR_EQ_ZERO);
        const decoded = decodedMappings(map);
        // It's common for parent source maps to have pointers to lines that have no
        // mapping (like a "//# sourceMappingURL=") at the end of the child file.
        if (line >= decoded.length)
            return OMapping(null, null, null, null);
        const segments = decoded[line];
        const index = traceSegmentInternal(segments, cast(map)._decodedMemo, line, column, bias || GREATEST_LOWER_BOUND);
        if (index === -1)
            return OMapping(null, null, null, null);
        const segment = segments[index];
        if (segment.length === 1)
            return OMapping(null, null, null, null);
        const { names, resolvedSources } = map;
        return OMapping(resolvedSources[segment[SOURCES_INDEX]], segment[SOURCE_LINE] + 1, segment[SOURCE_COLUMN], segment.length === 5 ? names[segment[NAMES_INDEX]] : null);
    }
    /**
     * Finds the generated line/column position of the provided source/line/column source position.
     */
    function generatedPositionFor(map, needle) {
        const { source, line, column, bias } = needle;
        return generatedPosition(map, source, line, column, bias || GREATEST_LOWER_BOUND, false);
    }
    /**
     * Finds all generated line/column positions of the provided source/line/column source position.
     */
    function allGeneratedPositionsFor(map, needle) {
        const { source, line, column, bias } = needle;
        // SourceMapConsumer uses LEAST_UPPER_BOUND for some reason, so we follow suit.
        return generatedPosition(map, source, line, column, bias || LEAST_UPPER_BOUND, true);
    }
    /**
     * Iterates each mapping in generated position order.
     */
    function eachMapping(map, cb) {
        const decoded = decodedMappings(map);
        const { names, resolvedSources } = map;
        for (let i = 0; i < decoded.length; i++) {
            const line = decoded[i];
            for (let j = 0; j < line.length; j++) {
                const seg = line[j];
                const generatedLine = i + 1;
                const generatedColumn = seg[0];
                let source = null;
                let originalLine = null;
                let originalColumn = null;
                let name = null;
                if (seg.length !== 1) {
                    source = resolvedSources[seg[1]];
                    originalLine = seg[2] + 1;
                    originalColumn = seg[3];
                }
                if (seg.length === 5)
                    name = names[seg[4]];
                cb({
                    generatedLine,
                    generatedColumn,
                    source,
                    originalLine,
                    originalColumn,
                    name,
                });
            }
        }
    }
    function sourceIndex(map, source) {
        const { sources, resolvedSources } = map;
        let index = sources.indexOf(source);
        if (index === -1)
            index = resolvedSources.indexOf(source);
        return index;
    }
    /**
     * Retrieves the source content for a particular source, if its found. Returns null if not.
     */
    function sourceContentFor(map, source) {
        const { sourcesContent } = map;
        if (sourcesContent == null)
            return null;
        const index = sourceIndex(map, source);
        return index === -1 ? null : sourcesContent[index];
    }
    /**
     * Determines if the source is marked to ignore by the source map.
     */
    function isIgnored(map, source) {
        const { ignoreList } = map;
        if (ignoreList == null)
            return false;
        const index = sourceIndex(map, source);
        return index === -1 ? false : ignoreList.includes(index);
    }
    /**
     * A helper that skips sorting of the input map's mappings array, which can be expensive for larger
     * maps.
     */
    function presortedDecodedMap(map, mapUrl) {
        const tracer = new TraceMap(clone(map, []), mapUrl);
        cast(tracer)._decoded = map.mappings;
        return tracer;
    }
    /**
     * Returns a sourcemap object (with decoded mappings) suitable for passing to a library that expects
     * a sourcemap, or to JSON.stringify.
     */
    function decodedMap(map) {
        return clone(map, decodedMappings(map));
    }
    /**
     * Returns a sourcemap object (with encoded mappings) suitable for passing to a library that expects
     * a sourcemap, or to JSON.stringify.
     */
    function encodedMap(map) {
        return clone(map, encodedMappings(map));
    }
    function clone(map, mappings) {
        return {
            version: map.version,
            file: map.file,
            names: map.names,
            sourceRoot: map.sourceRoot,
            sources: map.sources,
            sourcesContent: map.sourcesContent,
            mappings,
            ignoreList: map.ignoreList || map.x_google_ignoreList,
        };
    }
    function OMapping(source, line, column, name) {
        return { source, line, column, name };
    }
    function GMapping(line, column) {
        return { line, column };
    }
    function traceSegmentInternal(segments, memo, line, column, bias) {
        let index = memoizedBinarySearch(segments, column, memo, line);
        if (found) {
            index = (bias === LEAST_UPPER_BOUND ? upperBound : lowerBound)(segments, column, index);
        }
        else if (bias === LEAST_UPPER_BOUND)
            index++;
        if (index === -1 || index === segments.length)
            return -1;
        return index;
    }
    function sliceGeneratedPositions(segments, memo, line, column, bias) {
        let min = traceSegmentInternal(segments, memo, line, column, GREATEST_LOWER_BOUND);
        // We ignored the bias when tracing the segment so that we're guarnateed to find the first (in
        // insertion order) segment that matched. Even if we did respect the bias when tracing, we would
        // still need to call `lowerBound()` to find the first segment, which is slower than just looking
        // for the GREATEST_LOWER_BOUND to begin with. The only difference that matters for us is when the
        // binary search didn't match, in which case GREATEST_LOWER_BOUND just needs to increment to
        // match LEAST_UPPER_BOUND.
        if (!found && bias === LEAST_UPPER_BOUND)
            min++;
        if (min === -1 || min === segments.length)
            return [];
        // We may have found the segment that started at an earlier column. If this is the case, then we
        // need to slice all generated segments that match _that_ column, because all such segments span
        // to our desired column.
        const matchedColumn = found ? column : segments[min][COLUMN];
        // The binary search is not guaranteed to find the lower bound when a match wasn't found.
        if (!found)
            min = lowerBound(segments, matchedColumn, min);
        const max = upperBound(segments, matchedColumn, min);
        const result = [];
        for (; min <= max; min++) {
            const segment = segments[min];
            result.push(GMapping(segment[REV_GENERATED_LINE] + 1, segment[REV_GENERATED_COLUMN]));
        }
        return result;
    }
    function generatedPosition(map, source, line, column, bias, all) {
        var _a;
        line--;
        if (line < 0)
            throw new Error(LINE_GTR_ZERO);
        if (column < 0)
            throw new Error(COL_GTR_EQ_ZERO);
        const { sources, resolvedSources } = map;
        let sourceIndex = sources.indexOf(source);
        if (sourceIndex === -1)
            sourceIndex = resolvedSources.indexOf(source);
        if (sourceIndex === -1)
            return all ? [] : GMapping(null, null);
        const generated = ((_a = cast(map))._bySources || (_a._bySources = buildBySources(decodedMappings(map), (cast(map)._bySourceMemos = sources.map(memoizedState)))));
        const segments = generated[sourceIndex][line];
        if (segments == null)
            return all ? [] : GMapping(null, null);
        const memo = cast(map)._bySourceMemos[sourceIndex];
        if (all)
            return sliceGeneratedPositions(segments, memo, line, column, bias);
        const index = traceSegmentInternal(segments, memo, line, column, bias);
        if (index === -1)
            return GMapping(null, null);
        const segment = segments[index];
        return GMapping(segment[REV_GENERATED_LINE] + 1, segment[REV_GENERATED_COLUMN]);
    }
},
"92bc7d86f0": /* @jridgewell\resolve-uri\dist\resolve-uri.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = resolve;
    // Matches the scheme of a URL, eg "http://"
    const schemeRegex = /^[\w+.-]+:\/\//;
    /**
     * Matches the parts of a URL:
     * 1. Scheme, including ":", guaranteed.
     * 2. User/password, including "@", optional.
     * 3. Host, guaranteed.
     * 4. Port, including ":", optional.
     * 5. Path, including "/", optional.
     * 6. Query, including "?", optional.
     * 7. Hash, including "#", optional.
     */
    const urlRegex = /^([\w+.-]+:)\/\/([^@/#?]*@)?([^:/#?]*)(:\d+)?(\/[^#?]*)?(\?[^#]*)?(#.*)?/;
    /**
     * File URLs are weird. They dont' need the regular `//` in the scheme, they may or may not start
     * with a leading `/`, they can have a domain (but only if they don't start with a Windows drive).
     *
     * 1. Host, optional.
     * 2. Path, which may include "/", guaranteed.
     * 3. Query, including "?", optional.
     * 4. Hash, including "#", optional.
     */
    const fileRegex = /^file:(?:\/\/((?![a-z]:)[^/#?]*)?)?(\/?[^#?]*)(\?[^#]*)?(#.*)?/i;
    function isAbsoluteUrl(input) {
        return schemeRegex.test(input);
    }
    function isSchemeRelativeUrl(input) {
        return input.startsWith('//');
    }
    function isAbsolutePath(input) {
        return input.startsWith('/');
    }
    function isFileUrl(input) {
        return input.startsWith('file:');
    }
    function isRelative(input) {
        return /^[.?#]/.test(input);
    }
    function parseAbsoluteUrl(input) {
        const match = urlRegex.exec(input);
        return makeUrl(match[1], match[2] || '', match[3], match[4] || '', match[5] || '/', match[6] || '', match[7] || '');
    }
    function parseFileUrl(input) {
        const match = fileRegex.exec(input);
        const path = match[2];
        return makeUrl('file:', '', match[1] || '', '', isAbsolutePath(path) ? path : '/' + path, match[3] || '', match[4] || '');
    }
    function makeUrl(scheme, user, host, port, path, query, hash) {
        return {
            scheme,
            user,
            host,
            port,
            path,
            query,
            hash,
            type: 7 /* Absolute */,
        };
    }
    function parseUrl(input) {
        if (isSchemeRelativeUrl(input)) {
            const url = parseAbsoluteUrl('http:' + input);
            url.scheme = '';
            url.type = 6 /* SchemeRelative */;
            return url;
        }
        if (isAbsolutePath(input)) {
            const url = parseAbsoluteUrl('http://foo.com' + input);
            url.scheme = '';
            url.host = '';
            url.type = 5 /* AbsolutePath */;
            return url;
        }
        if (isFileUrl(input))
            return parseFileUrl(input);
        if (isAbsoluteUrl(input))
            return parseAbsoluteUrl(input);
        const url = parseAbsoluteUrl('http://foo.com/' + input);
        url.scheme = '';
        url.host = '';
        url.type = input
            ? input.startsWith('?')
                ? 3 /* Query */
                : input.startsWith('#')
                    ? 2 /* Hash */
                    : 4 /* RelativePath */
            : 1 /* Empty */;
        return url;
    }
    function stripPathFilename(path) {
        // If a path ends with a parent directory "..", then it's a relative path with excess parent
        // paths. It's not a file, so we can't strip it.
        if (path.endsWith('/..'))
            return path;
        const index = path.lastIndexOf('/');
        return path.slice(0, index + 1);
    }
    function mergePaths(url, base) {
        normalizePath(base, base.type);
        // If the path is just a "/", then it was an empty path to begin with (remember, we're a relative
        // path).
        if (url.path === '/') {
            url.path = base.path;
        }
        else {
            // Resolution happens relative to the base path's directory, not the file.
            url.path = stripPathFilename(base.path) + url.path;
        }
    }
    /**
     * The path can have empty directories "//", unneeded parents "foo/..", or current directory
     * "foo/.". We need to normalize to a standard representation.
     */
    function normalizePath(url, type) {
        const rel = type <= 4 /* RelativePath */;
        const pieces = url.path.split('/');
        // We need to preserve the first piece always, so that we output a leading slash. The item at
        // pieces[0] is an empty string.
        let pointer = 1;
        // Positive is the number of real directories we've output, used for popping a parent directory.
        // Eg, "foo/bar/.." will have a positive 2, and we can decrement to be left with just "foo".
        let positive = 0;
        // We need to keep a trailing slash if we encounter an empty directory (eg, splitting "foo/" will
        // generate `["foo", ""]` pieces). And, if we pop a parent directory. But once we encounter a
        // real directory, we won't need to append, unless the other conditions happen again.
        let addTrailingSlash = false;
        for (let i = 1; i < pieces.length; i++) {
            const piece = pieces[i];
            // An empty directory, could be a trailing slash, or just a double "//" in the path.
            if (!piece) {
                addTrailingSlash = true;
                continue;
            }
            // If we encounter a real directory, then we don't need to append anymore.
            addTrailingSlash = false;
            // A current directory, which we can always drop.
            if (piece === '.')
                continue;
            // A parent directory, we need to see if there are any real directories we can pop. Else, we
            // have an excess of parents, and we'll need to keep the "..".
            if (piece === '..') {
                if (positive) {
                    addTrailingSlash = true;
                    positive--;
                    pointer--;
                }
                else if (rel) {
                    // If we're in a relativePath, then we need to keep the excess parents. Else, in an absolute
                    // URL, protocol relative URL, or an absolute path, we don't need to keep excess.
                    pieces[pointer++] = piece;
                }
                continue;
            }
            // We've encountered a real directory. Move it to the next insertion pointer, which accounts for
            // any popped or dropped directories.
            pieces[pointer++] = piece;
            positive++;
        }
        let path = '';
        for (let i = 1; i < pointer; i++) {
            path += '/' + pieces[i];
        }
        if (!path || (addTrailingSlash && !path.endsWith('/..'))) {
            path += '/';
        }
        url.path = path;
    }
    /**
     * Attempts to resolve `input` URL/path relative to `base`.
     */
    function resolve(input, base) {
        if (!input && !base)
            return '';
        const url = parseUrl(input);
        let inputType = url.type;
        if (base && inputType !== 7 /* Absolute */) {
            const baseUrl = parseUrl(base);
            const baseType = baseUrl.type;
            switch (inputType) {
                case 1 /* Empty */:
                    url.hash = baseUrl.hash;
                // fall through
                case 2 /* Hash */:
                    url.query = baseUrl.query;
                // fall through
                case 3 /* Query */:
                case 4 /* RelativePath */:
                    mergePaths(url, baseUrl);
                // fall through
                case 5 /* AbsolutePath */:
                    // The host, user, and port are joined, you can't copy one without the others.
                    url.user = baseUrl.user;
                    url.host = baseUrl.host;
                    url.port = baseUrl.port;
                // fall through
                case 6 /* SchemeRelative */:
                    // The input doesn't have a schema at least, so we need to copy at least that over.
                    url.scheme = baseUrl.scheme;
            }
            if (baseType > inputType)
                inputType = baseType;
        }
        normalizePath(url, inputType);
        const queryHash = url.query + url.hash;
        switch (inputType) {
            // This is impossible, because of the empty checks at the start of the function.
            // case UrlType.Empty:
            case 2 /* Hash */:
            case 3 /* Query */:
                return queryHash;
            case 4 /* RelativePath */: {
                // The first char is always a "/", and we need it to be relative.
                const path = url.path.slice(1);
                if (!path)
                    return queryHash || '.';
                if (isRelative(base || input) && !isRelative(path)) {
                    // If base started with a leading ".", or there is no base and input started with a ".",
                    // then we need to ensure that the relative path starts with a ".". We don't know if
                    // relative starts with a "..", though, so check before prepending.
                    return './' + path + queryHash;
                }
                return path + queryHash;
            }
            case 5 /* AbsolutePath */:
                return url.path + queryHash;
            default:
                return url.scheme + '//' + url.user + url.host + url.port + url.path + queryHash;
        }
    }
},
"40e1a4d3af": /* sucrase\dist\esm\HelperManager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const HELPERS = {
        require: `
    import {createRequire as CREATE_REQUIRE_NAME} from "module";
    const require = CREATE_REQUIRE_NAME(import.meta.url);
  `,
        interopRequireWildcard: `
    function interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              newObj[key] = obj[key];
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
  `,
        interopRequireDefault: `
    function interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
  `,
        createNamedExportFrom: `
    function createNamedExportFrom(obj, localName, importedName) {
      Object.defineProperty(exports, localName, {enumerable: true, configurable: true, get: () => obj[importedName]});
    }
  `,
        // Note that TypeScript and Babel do this differently; TypeScript does a simple existence
        // check in the exports object and does a plain assignment, whereas Babel uses
        // defineProperty and builds an object of explicitly-exported names so that star exports can
        // always take lower precedence. For now, we do the easier TypeScript thing.
        createStarExport: `
    function createStarExport(obj) {
      Object.keys(obj)
        .filter((key) => key !== "default" && key !== "__esModule")
        .forEach((key) => {
          if (exports.hasOwnProperty(key)) {
            return;
          }
          Object.defineProperty(exports, key, {enumerable: true, configurable: true, get: () => obj[key]});
        });
    }
  `,
        nullishCoalesce: `
    function nullishCoalesce(lhs, rhsFn) {
      if (lhs != null) {
        return lhs;
      } else {
        return rhsFn();
      }
    }
  `,
        asyncNullishCoalesce: `
    async function asyncNullishCoalesce(lhs, rhsFn) {
      if (lhs != null) {
        return lhs;
      } else {
        return await rhsFn();
      }
    }
  `,
        optionalChain: `
    function optionalChain(ops) {
      let lastAccessLHS = undefined;
      let value = ops[0];
      let i = 1;
      while (i < ops.length) {
        const op = ops[i];
        const fn = ops[i + 1];
        i += 2;
        if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
          return undefined;
        }
        if (op === 'access' || op === 'optionalAccess') {
          lastAccessLHS = value;
          value = fn(value);
        } else if (op === 'call' || op === 'optionalCall') {
          value = fn((...args) => value.call(lastAccessLHS, ...args));
          lastAccessLHS = undefined;
        }
      }
      return value;
    }
  `,
        asyncOptionalChain: `
    async function asyncOptionalChain(ops) {
      let lastAccessLHS = undefined;
      let value = ops[0];
      let i = 1;
      while (i < ops.length) {
        const op = ops[i];
        const fn = ops[i + 1];
        i += 2;
        if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
          return undefined;
        }
        if (op === 'access' || op === 'optionalAccess') {
          lastAccessLHS = value;
          value = await fn(value);
        } else if (op === 'call' || op === 'optionalCall') {
          value = await fn((...args) => value.call(lastAccessLHS, ...args));
          lastAccessLHS = undefined;
        }
      }
      return value;
    }
  `,
        optionalChainDelete: `
    function optionalChainDelete(ops) {
      const result = OPTIONAL_CHAIN_NAME(ops);
      return result == null ? true : result;
    }
  `,
        asyncOptionalChainDelete: `
    async function asyncOptionalChainDelete(ops) {
      const result = await ASYNC_OPTIONAL_CHAIN_NAME(ops);
      return result == null ? true : result;
    }
  `,
    };
    class HelperManager {
        __init() { this.helperNames = {}; }
        __init2() { this.createRequireName = null; }
        constructor(nameManager) { ; this.nameManager = nameManager; HelperManager.prototype.__init.call(this); HelperManager.prototype.__init2.call(this); }
        getHelperName(baseName) {
            let helperName = this.helperNames[baseName];
            if (helperName) {
                return helperName;
            }
            helperName = this.nameManager.claimFreeName(`_${baseName}`);
            this.helperNames[baseName] = helperName;
            return helperName;
        }
        emitHelpers() {
            let resultCode = "";
            if (this.helperNames.optionalChainDelete) {
                this.getHelperName("optionalChain");
            }
            if (this.helperNames.asyncOptionalChainDelete) {
                this.getHelperName("asyncOptionalChain");
            }
            for (const [baseName, helperCodeTemplate] of Object.entries(HELPERS)) {
                const helperName = this.helperNames[baseName];
                let helperCode = helperCodeTemplate;
                if (baseName === "optionalChainDelete") {
                    helperCode = helperCode.replace("OPTIONAL_CHAIN_NAME", this.helperNames.optionalChain);
                }
                else if (baseName === "asyncOptionalChainDelete") {
                    helperCode = helperCode.replace("ASYNC_OPTIONAL_CHAIN_NAME", this.helperNames.asyncOptionalChain);
                }
                else if (baseName === "require") {
                    if (this.createRequireName === null) {
                        this.createRequireName = this.nameManager.claimFreeName("_createRequire");
                    }
                    helperCode = helperCode.replace(/CREATE_REQUIRE_NAME/g, this.createRequireName);
                }
                if (helperName) {
                    resultCode += " ";
                    resultCode += helperCode.replace(baseName, helperName).replace(/\s+/g, " ").trim();
                }
            }
            return resultCode;
        }
    }
    exports.HelperManager = HelperManager;
},
"5f4ada3fc1": /* sucrase\dist\esm\identifyShadowedGlobals.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = identifyShadowedGlobals;
    exports.hasShadowedGlobals = hasShadowedGlobals;
    const tokenizer_1 = require("bfb18d0576") /* ./parser/tokenizer */;
    const types_1 = require("f0c35cbd76") /* ./parser/tokenizer/types */;
    /**
     * Traverse the given tokens and modify them if necessary to indicate that some names shadow global
     * variables.
     */
    function identifyShadowedGlobals(tokens, scopes, globalNames) {
        if (!hasShadowedGlobals(tokens, globalNames)) {
            return;
        }
        markShadowedGlobals(tokens, scopes, globalNames);
    }
    /**
     * We can do a fast up-front check to see if there are any declarations to global names. If not,
     * then there's no point in computing scope assignments.
     */
    // Exported for testing.
    function hasShadowedGlobals(tokens, globalNames) {
        for (const token of tokens.tokens) {
            if (token.type === types_1.TokenType.name &&
                !token.isType &&
                (0, tokenizer_1.isNonTopLevelDeclaration)(token) &&
                globalNames.has(tokens.identifierNameForToken(token))) {
                return true;
            }
        }
        return false;
    }
    function markShadowedGlobals(tokens, scopes, globalNames) {
        const scopeStack = [];
        let scopeIndex = scopes.length - 1;
        // Scopes were generated at completion time, so they're sorted by end index, so we can maintain a
        // good stack by going backwards through them.
        for (let i = tokens.tokens.length - 1;; i--) {
            while (scopeStack.length > 0 && scopeStack[scopeStack.length - 1].startTokenIndex === i + 1) {
                scopeStack.pop();
            }
            while (scopeIndex >= 0 && scopes[scopeIndex].endTokenIndex === i + 1) {
                scopeStack.push(scopes[scopeIndex]);
                scopeIndex--;
            }
            // Process scopes after the last iteration so we can make sure we pop all of them.
            if (i < 0) {
                break;
            }
            const token = tokens.tokens[i];
            const name = tokens.identifierNameForToken(token);
            if (scopeStack.length > 1 && !token.isType && token.type === types_1.TokenType.name && globalNames.has(name)) {
                if ((0, tokenizer_1.isBlockScopedDeclaration)(token)) {
                    markShadowedForScope(scopeStack[scopeStack.length - 1], tokens, name);
                }
                else if ((0, tokenizer_1.isFunctionScopedDeclaration)(token)) {
                    let stackIndex = scopeStack.length - 1;
                    while (stackIndex > 0 && !scopeStack[stackIndex].isFunctionScope) {
                        stackIndex--;
                    }
                    if (stackIndex < 0) {
                        throw new Error("Did not find parent function scope.");
                    }
                    markShadowedForScope(scopeStack[stackIndex], tokens, name);
                }
            }
        }
        if (scopeStack.length > 0) {
            throw new Error("Expected empty scope stack after processing file.");
        }
    }
    function markShadowedForScope(scope, tokens, name) {
        for (let i = scope.startTokenIndex; i < scope.endTokenIndex; i++) {
            const token = tokens.tokens[i];
            if ((token.type === types_1.TokenType.name || token.type === types_1.TokenType.jsxName) &&
                tokens.identifierNameForToken(token) === name) {
                token.shadowsGlobal = true;
            }
        }
    }
},
"425f39b83e": /* sucrase\dist\esm\NameManager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const getIdentifierNames_1 = tslib_1.__importDefault(require("981a8f5cdf") /* ./util/getIdentifierNames */);
    class NameManager {
        __init() { this.usedNames = new Set(); }
        constructor(code, tokens) {
            ;
            NameManager.prototype.__init.call(this);
            this.usedNames = new Set((0, getIdentifierNames_1.default)(code, tokens));
        }
        claimFreeName(name) {
            const newName = this.findFreeName(name);
            this.usedNames.add(newName);
            return newName;
        }
        findFreeName(name) {
            if (!this.usedNames.has(name)) {
                return name;
            }
            let suffixNum = 2;
            while (this.usedNames.has(name + String(suffixNum))) {
                suffixNum++;
            }
            return name + String(suffixNum);
        }
    }
    exports.default = NameManager;
},
"981a8f5cdf": /* sucrase\dist\esm\util\getIdentifierNames.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getIdentifierNames;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Get all identifier names in the code, in order, including duplicates.
     */
    function getIdentifierNames(code, tokens) {
        const names = [];
        for (const token of tokens) {
            if (token.type === types_1.TokenType.name) {
                names.push(code.slice(token.start, token.end));
            }
        }
        return names;
    }
},
"bb0c9c6022": /* sucrase\dist\esm\Options.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.validateOptions = validateOptions;
    const tslib_1 = require("tslib");
    const ts_interface_checker_1 = require("566f6e7d92") /* ts-interface-checker */;
    const Options_gen_types_1 = tslib_1.__importDefault(require("26465ac544") /* ./Options-gen-types */);
    const { Options: OptionsChecker } = (0, ts_interface_checker_1.createCheckers)(Options_gen_types_1.default);
    function validateOptions(options) {
        OptionsChecker.strictCheck(options);
    }
},
"566f6e7d92": /* ts-interface-checker\dist\index.js */ function _(require, module, exports, __esModule, __esExport) {
    var __spreadArrays = (this && this.__spreadArrays) || function () {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };
    __esModule();
    var types_1 = require("feda7bf54d") /* ./types */;
    var util_1 = require("cc5514a417") /* ./util */;
    /**
     * Export functions used to define interfaces.
     */
    var types_2 = require("feda7bf54d") /* ./types */;
    __esExport("TArray", types_2.TArray);
    __esExport("TEnumType", types_2.TEnumType);
    __esExport("TEnumLiteral", types_2.TEnumLiteral);
    __esExport("TFunc", types_2.TFunc);
    __esExport("TIface", types_2.TIface);
    __esExport("TLiteral", types_2.TLiteral);
    __esExport("TName", types_2.TName);
    __esExport("TOptional", types_2.TOptional);
    __esExport("TParam", types_2.TParam);
    __esExport("TParamList", types_2.TParamList);
    __esExport("TProp", types_2.TProp);
    __esExport("TTuple", types_2.TTuple);
    __esExport("TType", types_2.TType);
    __esExport("TUnion", types_2.TUnion);
    __esExport("TIntersection", types_2.TIntersection);
    __esExport("array", types_2.array);
    __esExport("enumlit", types_2.enumlit);
    __esExport("enumtype", types_2.enumtype);
    __esExport("func", types_2.func);
    __esExport("iface", types_2.iface);
    __esExport("lit", types_2.lit);
    __esExport("name", types_2.name);
    __esExport("opt", types_2.opt);
    __esExport("param", types_2.param);
    __esExport("tuple", types_2.tuple);
    __esExport("union", types_2.union);
    __esExport("intersection", types_2.intersection);
    __esExport("BasicType", types_2.BasicType);
    var util_2 = require("cc5514a417") /* ./util */;
    __esExport("VError", util_2.VError);
    /**
     * Takes one of more type suites (e.g. a module generated by `ts-interface-builder`), and combines
     * them into a suite of interface checkers. If a type is used by name, that name should be present
     * among the passed-in type suites.
     *
     * The returned object maps type names to Checker objects.
     */
    function createCheckers() {
        var typeSuite = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            typeSuite[_i] = arguments[_i];
        }
        var fullSuite = Object.assign.apply(Object, __spreadArrays([{}, types_1.basicTypes], typeSuite));
        var checkers = {};
        for (var _a = 0, typeSuite_1 = typeSuite; _a < typeSuite_1.length; _a++) {
            var suite_1 = typeSuite_1[_a];
            for (var _b = 0, _c = Object.keys(suite_1); _b < _c.length; _b++) {
                var name = _c[_b];
                checkers[name] = new Checker(fullSuite, suite_1[name]);
            }
        }
        return checkers;
    }
    exports.createCheckers = createCheckers;
    /**
     * Checker implements validation of objects, and also includes accessors to validate method calls.
     * Checkers should be created using `createCheckers()`.
     */
    var Checker = /** @class */ (function () {
        // Create checkers by using `createCheckers()` function.
        function Checker(suite, ttype, _path) {
            if (_path === void 0) {
                _path = 'value';
            }
            this.suite = suite;
            this.ttype = ttype;
            this._path = _path;
            this.props = new Map();
            if (ttype instanceof types_1.TIface) {
                for (var _i = 0, _a = ttype.props; _i < _a.length; _i++) {
                    var p = _a[_i];
                    this.props.set(p.name, p.ttype);
                }
            }
            this.checkerPlain = this.ttype.getChecker(suite, false);
            this.checkerStrict = this.ttype.getChecker(suite, true);
        }
        /**
         * Set the path to report in errors, instead of the default "value". (E.g. if the Checker is for
         * a "person" interface, set path to "person" to report e.g. "person.name is not a string".)
         */
        Checker.prototype.setReportedPath = function (path) {
            this._path = path;
        };
        /**
         * Check that the given value satisfies this checker's type, or throw Error.
         */
        Checker.prototype.check = function (value) { return this._doCheck(this.checkerPlain, value); };
        /**
         * A fast check for whether or not the given value satisfies this Checker's type. This returns
         * true or false, does not produce an error message, and is fast both on success and on failure.
         */
        Checker.prototype.test = function (value) {
            return this.checkerPlain(value, new util_1.NoopContext());
        };
        /**
         * Returns an error object describing the errors if the given value does not satisfy this
         * Checker's type, or null if it does.
         */
        Checker.prototype.validate = function (value) {
            return this._doValidate(this.checkerPlain, value);
        };
        /**
         * Check that the given value satisfies this checker's type strictly. This checks that objects
         * and tuples have no extra members. Note that this prevents backward compatibility, so usually
         * a plain check() is more appropriate.
         */
        Checker.prototype.strictCheck = function (value) { return this._doCheck(this.checkerStrict, value); };
        /**
         * A fast strict check for whether or not the given value satisfies this Checker's type. Returns
         * true or false, does not produce an error message, and is fast both on success and on failure.
         */
        Checker.prototype.strictTest = function (value) {
            return this.checkerStrict(value, new util_1.NoopContext());
        };
        /**
         * Returns an error object describing the errors if the given value does not satisfy this
         * Checker's type strictly, or null if it does.
         */
        Checker.prototype.strictValidate = function (value) {
            return this._doValidate(this.checkerStrict, value);
        };
        /**
         * If this checker is for an interface, returns a Checker for the type required for the given
         * property of this interface.
         */
        Checker.prototype.getProp = function (prop) {
            var ttype = this.props.get(prop);
            if (!ttype) {
                throw new Error("Type has no property " + prop);
            }
            return new Checker(this.suite, ttype, this._path + "." + prop);
        };
        /**
         * If this checker is for an interface, returns a Checker for the argument-list required to call
         * the given method of this interface. E.g. if this Checker is for the interface:
         *    interface Foo {
         *      find(s: string, pos?: number): number;
         *    }
         * Then methodArgs("find").check(...) will succeed for ["foo"] and ["foo", 3], but not for [17].
         */
        Checker.prototype.methodArgs = function (methodName) {
            var tfunc = this._getMethod(methodName);
            return new Checker(this.suite, tfunc.paramList);
        };
        /**
         * If this checker is for an interface, returns a Checker for the return value of the given
         * method of this interface.
         */
        Checker.prototype.methodResult = function (methodName) {
            var tfunc = this._getMethod(methodName);
            return new Checker(this.suite, tfunc.result);
        };
        /**
         * If this checker is for a function, returns a Checker for its argument-list.
         */
        Checker.prototype.getArgs = function () {
            if (!(this.ttype instanceof types_1.TFunc)) {
                throw new Error("getArgs() applied to non-function");
            }
            return new Checker(this.suite, this.ttype.paramList);
        };
        /**
         * If this checker is for a function, returns a Checker for its result.
         */
        Checker.prototype.getResult = function () {
            if (!(this.ttype instanceof types_1.TFunc)) {
                throw new Error("getResult() applied to non-function");
            }
            return new Checker(this.suite, this.ttype.result);
        };
        /**
         * Return the type for which this is a checker.
         */
        Checker.prototype.getType = function () {
            return this.ttype;
        };
        /**
         * Actual implementation of check() and strictCheck().
         */
        Checker.prototype._doCheck = function (checkerFunc, value) {
            var noopCtx = new util_1.NoopContext();
            if (!checkerFunc(value, noopCtx)) {
                var detailCtx = new util_1.DetailContext();
                checkerFunc(value, detailCtx);
                throw detailCtx.getError(this._path);
            }
        };
        Checker.prototype._doValidate = function (checkerFunc, value) {
            var noopCtx = new util_1.NoopContext();
            if (checkerFunc(value, noopCtx)) {
                return null;
            }
            var detailCtx = new util_1.DetailContext();
            checkerFunc(value, detailCtx);
            return detailCtx.getErrorDetail(this._path);
        };
        Checker.prototype._getMethod = function (methodName) {
            var ttype = this.props.get(methodName);
            if (!ttype) {
                throw new Error("Type has no property " + methodName);
            }
            if (!(ttype instanceof types_1.TFunc)) {
                throw new Error("Property " + methodName + " is not a method");
            }
            return ttype;
        };
        return Checker;
    }());
    exports.Checker = Checker;
},
"feda7bf54d": /* ts-interface-checker\dist\types.js */ function _(require, module, exports, __esModule, __esExport) {
    /**
     * This module defines nodes used to define types and validations for objects and interfaces.
     */
    // tslint:disable:no-shadowed-variable prefer-for-of
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (b.hasOwnProperty(p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var util_1 = require("cc5514a417") /* ./util */;
    /** Node that represents a type. */
    var TType = /** @class */ (function () {
        function TType() {
        }
        return TType;
    }());
    exports.TType = TType;
    /** Parses a type spec into a TType node. */
    function parseSpec(typeSpec) {
        return typeof typeSpec === "string" ? name(typeSpec) : typeSpec;
    }
    function getNamedType(suite, name) {
        var ttype = suite[name];
        if (!ttype) {
            throw new Error("Unknown type " + name);
        }
        return ttype;
    }
    /**
     * Defines a type name, either built-in, or defined in this suite. It can typically be included in
     * the specs as just a plain string.
     */
    function name(value) { return new TName(value); }
    exports.name = name;
    var TName = /** @class */ (function (_super) {
        __extends(TName, _super);
        function TName(name) {
            var _this = _super.call(this) || this;
            _this.name = name;
            _this._failMsg = "is not a " + name;
            return _this;
        }
        TName.prototype.getChecker = function (suite, strict, allowedProps) {
            var _this = this;
            var ttype = getNamedType(suite, this.name);
            var checker = ttype.getChecker(suite, strict, allowedProps);
            if (ttype instanceof BasicType || ttype instanceof TName) {
                return checker;
            }
            // For complex types, add an additional "is not a <Type>" message on failure.
            return function (value, ctx) { return checker(value, ctx) ? true : ctx.fail(null, _this._failMsg, 0); };
        };
        return TName;
    }(TType));
    exports.TName = TName;
    /**
     * Defines a literal value, e.g. lit('hello') or lit(123).
     */
    function lit(value) { return new TLiteral(value); }
    exports.lit = lit;
    var TLiteral = /** @class */ (function (_super) {
        __extends(TLiteral, _super);
        function TLiteral(value) {
            var _this = _super.call(this) || this;
            _this.value = value;
            _this.name = JSON.stringify(value);
            _this._failMsg = "is not " + _this.name;
            return _this;
        }
        TLiteral.prototype.getChecker = function (suite, strict) {
            var _this = this;
            return function (value, ctx) { return (value === _this.value) ? true : ctx.fail(null, _this._failMsg, -1); };
        };
        return TLiteral;
    }(TType));
    exports.TLiteral = TLiteral;
    /**
     * Defines an array type, e.g. array('number').
     */
    function array(typeSpec) { return new TArray(parseSpec(typeSpec)); }
    exports.array = array;
    var TArray = /** @class */ (function (_super) {
        __extends(TArray, _super);
        function TArray(ttype) {
            var _this = _super.call(this) || this;
            _this.ttype = ttype;
            return _this;
        }
        TArray.prototype.getChecker = function (suite, strict) {
            var itemChecker = this.ttype.getChecker(suite, strict);
            return function (value, ctx) {
                if (!Array.isArray(value)) {
                    return ctx.fail(null, "is not an array", 0);
                }
                for (var i = 0; i < value.length; i++) {
                    var ok = itemChecker(value[i], ctx);
                    if (!ok) {
                        return ctx.fail(i, null, 1);
                    }
                }
                return true;
            };
        };
        return TArray;
    }(TType));
    exports.TArray = TArray;
    /**
     * Defines a tuple type, e.g. tuple('string', 'number').
     */
    function tuple() {
        var typeSpec = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            typeSpec[_i] = arguments[_i];
        }
        return new TTuple(typeSpec.map(function (t) { return parseSpec(t); }));
    }
    exports.tuple = tuple;
    var TTuple = /** @class */ (function (_super) {
        __extends(TTuple, _super);
        function TTuple(ttypes) {
            var _this = _super.call(this) || this;
            _this.ttypes = ttypes;
            return _this;
        }
        TTuple.prototype.getChecker = function (suite, strict) {
            var itemCheckers = this.ttypes.map(function (t) { return t.getChecker(suite, strict); });
            var checker = function (value, ctx) {
                if (!Array.isArray(value)) {
                    return ctx.fail(null, "is not an array", 0);
                }
                for (var i = 0; i < itemCheckers.length; i++) {
                    var ok = itemCheckers[i](value[i], ctx);
                    if (!ok) {
                        return ctx.fail(i, null, 1);
                    }
                }
                return true;
            };
            if (!strict) {
                return checker;
            }
            return function (value, ctx) {
                if (!checker(value, ctx)) {
                    return false;
                }
                return value.length <= itemCheckers.length ? true :
                    ctx.fail(itemCheckers.length, "is extraneous", 2);
            };
        };
        return TTuple;
    }(TType));
    exports.TTuple = TTuple;
    /**
     * Defines a union type, e.g. union('number', 'null').
     */
    function union() {
        var typeSpec = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            typeSpec[_i] = arguments[_i];
        }
        return new TUnion(typeSpec.map(function (t) { return parseSpec(t); }));
    }
    exports.union = union;
    var TUnion = /** @class */ (function (_super) {
        __extends(TUnion, _super);
        function TUnion(ttypes) {
            var _this = _super.call(this) || this;
            _this.ttypes = ttypes;
            var names = ttypes.map(function (t) { return t instanceof TName || t instanceof TLiteral ? t.name : null; })
                .filter(function (n) { return n; });
            var otherTypes = ttypes.length - names.length;
            if (names.length) {
                if (otherTypes > 0) {
                    names.push(otherTypes + " more");
                }
                _this._failMsg = "is none of " + names.join(", ");
            }
            else {
                _this._failMsg = "is none of " + otherTypes + " types";
            }
            return _this;
        }
        TUnion.prototype.getChecker = function (suite, strict) {
            var _this = this;
            var itemCheckers = this.ttypes.map(function (t) { return t.getChecker(suite, strict); });
            return function (value, ctx) {
                var ur = ctx.unionResolver();
                for (var i = 0; i < itemCheckers.length; i++) {
                    var ok = itemCheckers[i](value, ur.createContext());
                    if (ok) {
                        return true;
                    }
                }
                ctx.resolveUnion(ur);
                return ctx.fail(null, _this._failMsg, 0);
            };
        };
        return TUnion;
    }(TType));
    exports.TUnion = TUnion;
    /**
     * Defines an intersection type, e.g. intersection('number', 'null').
     */
    function intersection() {
        var typeSpec = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            typeSpec[_i] = arguments[_i];
        }
        return new TIntersection(typeSpec.map(function (t) { return parseSpec(t); }));
    }
    exports.intersection = intersection;
    var TIntersection = /** @class */ (function (_super) {
        __extends(TIntersection, _super);
        function TIntersection(ttypes) {
            var _this = _super.call(this) || this;
            _this.ttypes = ttypes;
            return _this;
        }
        TIntersection.prototype.getChecker = function (suite, strict) {
            var allowedProps = new Set();
            var itemCheckers = this.ttypes.map(function (t) { return t.getChecker(suite, strict, allowedProps); });
            return function (value, ctx) {
                var ok = itemCheckers.every(function (checker) { return checker(value, ctx); });
                if (ok) {
                    return true;
                }
                return ctx.fail(null, null, 0);
            };
        };
        return TIntersection;
    }(TType));
    exports.TIntersection = TIntersection;
    /**
     * Defines an enum type, e.g. enum({'A': 1, 'B': 2}).
     */
    function enumtype(values) {
        return new TEnumType(values);
    }
    exports.enumtype = enumtype;
    var TEnumType = /** @class */ (function (_super) {
        __extends(TEnumType, _super);
        function TEnumType(members) {
            var _this = _super.call(this) || this;
            _this.members = members;
            _this.validValues = new Set();
            _this._failMsg = "is not a valid enum value";
            _this.validValues = new Set(Object.keys(members).map(function (name) { return members[name]; }));
            return _this;
        }
        TEnumType.prototype.getChecker = function (suite, strict) {
            var _this = this;
            return function (value, ctx) {
                return (_this.validValues.has(value) ? true : ctx.fail(null, _this._failMsg, 0));
            };
        };
        return TEnumType;
    }(TType));
    exports.TEnumType = TEnumType;
    /**
     * Defines a literal enum value, such as Direction.Up, specified as enumlit("Direction", "Up").
     */
    function enumlit(name, prop) {
        return new TEnumLiteral(name, prop);
    }
    exports.enumlit = enumlit;
    var TEnumLiteral = /** @class */ (function (_super) {
        __extends(TEnumLiteral, _super);
        function TEnumLiteral(enumName, prop) {
            var _this = _super.call(this) || this;
            _this.enumName = enumName;
            _this.prop = prop;
            _this._failMsg = "is not " + enumName + "." + prop;
            return _this;
        }
        TEnumLiteral.prototype.getChecker = function (suite, strict) {
            var _this = this;
            var ttype = getNamedType(suite, this.enumName);
            if (!(ttype instanceof TEnumType)) {
                throw new Error("Type " + this.enumName + " used in enumlit is not an enum type");
            }
            var val = ttype.members[this.prop];
            if (!ttype.members.hasOwnProperty(this.prop)) {
                throw new Error("Unknown value " + this.enumName + "." + this.prop + " used in enumlit");
            }
            return function (value, ctx) { return (value === val) ? true : ctx.fail(null, _this._failMsg, -1); };
        };
        return TEnumLiteral;
    }(TType));
    exports.TEnumLiteral = TEnumLiteral;
    function makeIfaceProps(props) {
        return Object.keys(props).map(function (name) { return makeIfaceProp(name, props[name]); });
    }
    function makeIfaceProp(name, prop) {
        return prop instanceof TOptional ?
            new TProp(name, prop.ttype, true) :
            new TProp(name, parseSpec(prop), false);
    }
    /**
     * Defines an interface. The first argument is an array of interfaces that it extends, and the
     * second is an array of properties.
     */
    function iface(bases, props) {
        return new TIface(bases, makeIfaceProps(props));
    }
    exports.iface = iface;
    var TIface = /** @class */ (function (_super) {
        __extends(TIface, _super);
        function TIface(bases, props) {
            var _this = _super.call(this) || this;
            _this.bases = bases;
            _this.props = props;
            _this.propSet = new Set(props.map(function (p) { return p.name; }));
            return _this;
        }
        TIface.prototype.getChecker = function (suite, strict, allowedProps) {
            var _this = this;
            var baseCheckers = this.bases.map(function (b) { return getNamedType(suite, b).getChecker(suite, strict); });
            var propCheckers = this.props.map(function (prop) { return prop.ttype.getChecker(suite, strict); });
            var testCtx = new util_1.NoopContext();
            // Consider a prop required if it's not optional AND does not allow for undefined as a value.
            var isPropRequired = this.props.map(function (prop, i) {
                return !prop.isOpt && !propCheckers[i](undefined, testCtx);
            });
            var checker = function (value, ctx) {
                if (typeof value !== "object" || value === null) {
                    return ctx.fail(null, "is not an object", 0);
                }
                for (var i = 0; i < baseCheckers.length; i++) {
                    if (!baseCheckers[i](value, ctx)) {
                        return false;
                    }
                }
                for (var i = 0; i < propCheckers.length; i++) {
                    var name_1 = _this.props[i].name;
                    var v = value[name_1];
                    if (v === undefined) {
                        if (isPropRequired[i]) {
                            return ctx.fail(name_1, "is missing", 1);
                        }
                    }
                    else {
                        var ok = propCheckers[i](v, ctx);
                        if (!ok) {
                            return ctx.fail(name_1, null, 1);
                        }
                    }
                }
                return true;
            };
            if (!strict) {
                return checker;
            }
            var propSet = this.propSet;
            if (allowedProps) {
                this.propSet.forEach(function (prop) { return allowedProps.add(prop); });
                propSet = allowedProps;
            }
            // In strict mode, check also for unknown enumerable properties.
            return function (value, ctx) {
                if (!checker(value, ctx)) {
                    return false;
                }
                for (var prop in value) {
                    if (!propSet.has(prop)) {
                        return ctx.fail(prop, "is extraneous", 2);
                    }
                }
                return true;
            };
        };
        return TIface;
    }(TType));
    exports.TIface = TIface;
    /**
     * Defines an optional property on an interface.
     */
    function opt(typeSpec) { return new TOptional(parseSpec(typeSpec)); }
    exports.opt = opt;
    var TOptional = /** @class */ (function (_super) {
        __extends(TOptional, _super);
        function TOptional(ttype) {
            var _this = _super.call(this) || this;
            _this.ttype = ttype;
            return _this;
        }
        TOptional.prototype.getChecker = function (suite, strict) {
            var itemChecker = this.ttype.getChecker(suite, strict);
            return function (value, ctx) {
                return value === undefined || itemChecker(value, ctx);
            };
        };
        return TOptional;
    }(TType));
    exports.TOptional = TOptional;
    /**
     * Defines a property in an interface.
     */
    var TProp = /** @class */ (function () {
        function TProp(name, ttype, isOpt) {
            this.name = name;
            this.ttype = ttype;
            this.isOpt = isOpt;
        }
        return TProp;
    }());
    exports.TProp = TProp;
    /**
     * Defines a function. The first argument declares the function's return type, the rest declare
     * its parameters.
     */
    function func(resultSpec) {
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        return new TFunc(new TParamList(params), parseSpec(resultSpec));
    }
    exports.func = func;
    var TFunc = /** @class */ (function (_super) {
        __extends(TFunc, _super);
        function TFunc(paramList, result) {
            var _this = _super.call(this) || this;
            _this.paramList = paramList;
            _this.result = result;
            return _this;
        }
        TFunc.prototype.getChecker = function (suite, strict) {
            return function (value, ctx) {
                return typeof value === "function" ? true : ctx.fail(null, "is not a function", 0);
            };
        };
        return TFunc;
    }(TType));
    exports.TFunc = TFunc;
    /**
     * Defines a function parameter.
     */
    function param(name, typeSpec, isOpt) {
        return new TParam(name, parseSpec(typeSpec), Boolean(isOpt));
    }
    exports.param = param;
    var TParam = /** @class */ (function () {
        function TParam(name, ttype, isOpt) {
            this.name = name;
            this.ttype = ttype;
            this.isOpt = isOpt;
        }
        return TParam;
    }());
    exports.TParam = TParam;
    /**
     * Defines a function parameter list.
     */
    var TParamList = /** @class */ (function (_super) {
        __extends(TParamList, _super);
        function TParamList(params) {
            var _this = _super.call(this) || this;
            _this.params = params;
            return _this;
        }
        TParamList.prototype.getChecker = function (suite, strict) {
            var _this = this;
            var itemCheckers = this.params.map(function (t) { return t.ttype.getChecker(suite, strict); });
            var testCtx = new util_1.NoopContext();
            var isParamRequired = this.params.map(function (param, i) {
                return !param.isOpt && !itemCheckers[i](undefined, testCtx);
            });
            var checker = function (value, ctx) {
                if (!Array.isArray(value)) {
                    return ctx.fail(null, "is not an array", 0);
                }
                for (var i = 0; i < itemCheckers.length; i++) {
                    var p = _this.params[i];
                    if (value[i] === undefined) {
                        if (isParamRequired[i]) {
                            return ctx.fail(p.name, "is missing", 1);
                        }
                    }
                    else {
                        var ok = itemCheckers[i](value[i], ctx);
                        if (!ok) {
                            return ctx.fail(p.name, null, 1);
                        }
                    }
                }
                return true;
            };
            if (!strict) {
                return checker;
            }
            return function (value, ctx) {
                if (!checker(value, ctx)) {
                    return false;
                }
                return value.length <= itemCheckers.length ? true :
                    ctx.fail(itemCheckers.length, "is extraneous", 2);
            };
        };
        return TParamList;
    }(TType));
    exports.TParamList = TParamList;
    /**
     * Single TType implementation for all basic built-in types.
     */
    var BasicType = /** @class */ (function (_super) {
        __extends(BasicType, _super);
        function BasicType(validator, message) {
            var _this = _super.call(this) || this;
            _this.validator = validator;
            _this.message = message;
            return _this;
        }
        BasicType.prototype.getChecker = function (suite, strict) {
            var _this = this;
            return function (value, ctx) { return _this.validator(value) ? true : ctx.fail(null, _this.message, 0); };
        };
        return BasicType;
    }(TType));
    exports.BasicType = BasicType;
    /**
     * Defines the suite of basic types.
     */
    exports.basicTypes = {
        any: new BasicType(function (v) { return true; }, "is invalid"),
        number: new BasicType(function (v) { return (typeof v === "number"); }, "is not a number"),
        object: new BasicType(function (v) { return (typeof v === "object" && v); }, "is not an object"),
        boolean: new BasicType(function (v) { return (typeof v === "boolean"); }, "is not a boolean"),
        string: new BasicType(function (v) { return (typeof v === "string"); }, "is not a string"),
        symbol: new BasicType(function (v) { return (typeof v === "symbol"); }, "is not a symbol"),
        void: new BasicType(function (v) { return (v == null); }, "is not void"),
        undefined: new BasicType(function (v) { return (v === undefined); }, "is not undefined"),
        null: new BasicType(function (v) { return (v === null); }, "is not null"),
        never: new BasicType(function (v) { return false; }, "is unexpected"),
        Date: new BasicType(getIsNativeChecker("[object Date]"), "is not a Date"),
        RegExp: new BasicType(getIsNativeChecker("[object RegExp]"), "is not a RegExp"),
    };
    // This approach for checking native object types mirrors that of lodash. Its advantage over
    // `isinstance` is that it can still return true for native objects created in different JS
    // execution environments.
    var nativeToString = Object.prototype.toString;
    function getIsNativeChecker(tag) {
        return function (v) { return typeof v === "object" && v && nativeToString.call(v) === tag; };
    }
    if (typeof Buffer !== "undefined") {
        exports.basicTypes.Buffer = new BasicType(function (v) { return Buffer.isBuffer(v); }, "is not a Buffer");
    }
    var _loop_1 = function (array_1) {
        exports.basicTypes[array_1.name] = new BasicType(function (v) { return (v instanceof array_1); }, "is not a " + array_1.name);
    };
    // Support typed arrays of various flavors
    for (var _i = 0, _a = [Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
        Int32Array, Uint32Array, Float32Array, Float64Array, ArrayBuffer]; _i < _a.length; _i++) {
        var array_1 = _a[_i];
        _loop_1(array_1);
    }
},
"cc5514a417": /* ts-interface-checker\dist\util.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (b.hasOwnProperty(p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    /**
     * Error thrown by validation. Besides an informative message, it includes the path to the
     * property which triggered the failure.
     */
    var VError = /** @class */ (function (_super) {
        __extends(VError, _super);
        function VError(path, message) {
            var _this = _super.call(this, message) || this;
            _this.path = path;
            // See https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work for info about this workaround.
            Object.setPrototypeOf(_this, VError.prototype);
            return _this;
        }
        return VError;
    }(Error));
    exports.VError = VError;
    /**
     * Fast implementation of IContext used for first-pass validation. If that fails, we can validate
     * using DetailContext to collect error messages. That's faster for the common case when messages
     * normally pass validation.
     */
    var NoopContext = /** @class */ (function () {
        function NoopContext() {
        }
        NoopContext.prototype.fail = function (relPath, message, score) {
            return false;
        };
        NoopContext.prototype.unionResolver = function () { return this; };
        NoopContext.prototype.createContext = function () { return this; };
        NoopContext.prototype.resolveUnion = function (ur) { };
        return NoopContext;
    }());
    exports.NoopContext = NoopContext;
    /**
     * Complete implementation of IContext that collects meaningfull errors.
     */
    var DetailContext = /** @class */ (function () {
        function DetailContext() {
            // Stack of property names and associated messages for reporting helpful error messages.
            this._propNames = [""];
            this._messages = [null];
            // Score is used to choose the best union member whose DetailContext to use for reporting.
            // Higher score means better match (or rather less severe mismatch).
            this._score = 0;
        }
        DetailContext.prototype.fail = function (relPath, message, score) {
            this._propNames.push(relPath);
            this._messages.push(message);
            this._score += score;
            return false;
        };
        DetailContext.prototype.unionResolver = function () {
            return new DetailUnionResolver();
        };
        DetailContext.prototype.resolveUnion = function (unionResolver) {
            var _a, _b;
            var u = unionResolver;
            var best = null;
            for (var _i = 0, _c = u.contexts; _i < _c.length; _i++) {
                var ctx = _c[_i];
                if (!best || ctx._score >= best._score) {
                    best = ctx;
                }
            }
            if (best && best._score > 0) {
                (_a = this._propNames).push.apply(_a, best._propNames);
                (_b = this._messages).push.apply(_b, best._messages);
            }
        };
        DetailContext.prototype.getError = function (path) {
            var msgParts = [];
            for (var i = this._propNames.length - 1; i >= 0; i--) {
                var p = this._propNames[i];
                path += (typeof p === "number") ? "[" + p + "]" : (p ? "." + p : "");
                var m = this._messages[i];
                if (m) {
                    msgParts.push(path + " " + m);
                }
            }
            return new VError(path, msgParts.join("; "));
        };
        DetailContext.prototype.getErrorDetail = function (path) {
            var details = [];
            for (var i = this._propNames.length - 1; i >= 0; i--) {
                var p = this._propNames[i];
                path += (typeof p === "number") ? "[" + p + "]" : (p ? "." + p : "");
                var message = this._messages[i];
                if (message) {
                    details.push({ path: path, message: message });
                }
            }
            var detail = null;
            for (var i = details.length - 1; i >= 0; i--) {
                if (detail) {
                    details[i].nested = [detail];
                }
                detail = details[i];
            }
            return detail;
        };
        return DetailContext;
    }());
    exports.DetailContext = DetailContext;
    var DetailUnionResolver = /** @class */ (function () {
        function DetailUnionResolver() {
            this.contexts = [];
        }
        DetailUnionResolver.prototype.createContext = function () {
            var ctx = new DetailContext();
            this.contexts.push(ctx);
            return ctx;
        };
        return DetailUnionResolver;
    }());
},
"26465ac544": /* sucrase\dist\esm\Options-gen-types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    /**
     * This module was automatically generated by `ts-interface-builder`
     */
    const t = tslib_1.__importStar(require("566f6e7d92") /* ts-interface-checker */);
    // tslint:disable:object-literal-key-quotes
    exports.Transform = t.union(t.lit("jsx"), t.lit("typescript"), t.lit("flow"), t.lit("imports"), t.lit("react-hot-loader"), t.lit("jest"));
    exports.SourceMapOptions = t.iface([], {
        compiledFilename: "string",
    });
    exports.Options = t.iface([], {
        transforms: t.array("Transform"),
        disableESTransforms: t.opt("boolean"),
        jsxRuntime: t.opt(t.union(t.lit("classic"), t.lit("automatic"), t.lit("preserve"))),
        production: t.opt("boolean"),
        jsxImportSource: t.opt("string"),
        jsxPragma: t.opt("string"),
        jsxFragmentPragma: t.opt("string"),
        keepUnusedImports: t.opt("boolean"),
        preserveDynamicImport: t.opt("boolean"),
        injectCreateRequireForImportRequire: t.opt("boolean"),
        enableLegacyTypeScriptModuleInterop: t.opt("boolean"),
        enableLegacyBabel5ModuleInterop: t.opt("boolean"),
        sourceMapOptions: t.opt("SourceMapOptions"),
        filePath: t.opt("string"),
    });
    const exportedTypeSuite = {
        Transform: exports.Transform,
        SourceMapOptions: exports.SourceMapOptions,
        Options: exports.Options,
    };
    exports.default = exportedTypeSuite;
},
"7a45c9fdec": /* sucrase\dist\esm\parser\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parse = parse;
    const base_1 = require("540718e523") /* ./traverser/base */;
    const index_1 = require("5bde8156b9") /* ./traverser/index */;
    class File {
        constructor(tokens, scopes) {
            this.tokens = tokens;
            this.scopes = scopes;
        }
    }
    exports.File = File;
    function parse(input, isJSXEnabled, isTypeScriptEnabled, isFlowEnabled) {
        if (isFlowEnabled && isTypeScriptEnabled) {
            throw new Error("Cannot combine flow and typescript plugins.");
        }
        (0, base_1.initParser)(input, isJSXEnabled, isTypeScriptEnabled, isFlowEnabled);
        const result = (0, index_1.parseFile)();
        if (base_1.state.error) {
            throw (0, base_1.augmentError)(base_1.state.error);
        }
        return result;
    }
},
"5bde8156b9": /* sucrase\dist\esm\parser\traverser\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parseFile = parseFile;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const base_1 = require("540718e523") /* ./base */;
    const statement_1 = require("e3b9989da1") /* ./statement */;
    function parseFile() {
        // If enabled, skip leading hashbang line.
        if (base_1.state.pos === 0 &&
            base_1.input.charCodeAt(0) === charcodes_1.charCodes.numberSign &&
            base_1.input.charCodeAt(1) === charcodes_1.charCodes.exclamationMark) {
            (0, index_1.skipLineComment)(2);
        }
        (0, index_1.nextToken)();
        return (0, statement_1.parseTopLevel)();
    }
},
"e3b9989da1": /* sucrase\dist\esm\parser\traverser\statement.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parseTopLevel = parseTopLevel;
    exports.parseStatement = parseStatement;
    exports.parseDecorators = parseDecorators;
    exports.baseParseMaybeDecoratorArguments = baseParseMaybeDecoratorArguments;
    exports.parseVarStatement = parseVarStatement;
    exports.parseBlock = parseBlock;
    exports.parseBlockBody = parseBlockBody;
    exports.parseFunction = parseFunction;
    exports.parseFunctionParams = parseFunctionParams;
    exports.parseClass = parseClass;
    exports.parseClassPropertyName = parseClassPropertyName;
    exports.parsePostMemberNameModifiers = parsePostMemberNameModifiers;
    exports.parseClassProperty = parseClassProperty;
    exports.parseExport = parseExport;
    exports.parseExportFrom = parseExportFrom;
    exports.baseParseExportStar = baseParseExportStar;
    exports.parseExportSpecifiers = parseExportSpecifiers;
    exports.parseImport = parseImport;
    const index_1 = require("7a45c9fdec") /* ../index */;
    const flow_1 = require("9b8d43cd0a") /* ../plugins/flow */;
    const typescript_1 = require("6a970c22b9") /* ../plugins/typescript */;
    const tokenizer_1 = require("bfb18d0576") /* ../tokenizer */;
    const keywords_1 = require("99ff836c64") /* ../tokenizer/keywords */;
    const state_1 = require("eda46439d5") /* ../tokenizer/state */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const base_1 = require("540718e523") /* ./base */;
    const expression_1 = require("8178e7c3c8") /* ./expression */;
    const lval_1 = require("4cefc59e67") /* ./lval */;
    const util_1 = require("bc94bbadc1") /* ./util */;
    function parseTopLevel() {
        parseBlockBody(types_1.TokenType.eof);
        base_1.state.scopes.push(new state_1.Scope(0, base_1.state.tokens.length, true));
        if (base_1.state.scopeDepth !== 0) {
            throw new Error(`Invalid scope depth at end of file: ${base_1.state.scopeDepth}`);
        }
        return new index_1.File(base_1.state.tokens, base_1.state.scopes);
    }
    // Parse a single statement.
    //
    // If expecting a statement and finding a slash operator, parse a
    // regular expression literal. This is to handle cases like
    // `if (foo) /blah/.exec(foo)`, where looking at the previous token
    // does not help.
    function parseStatement(declaration) {
        if (base_1.isFlowEnabled) {
            if ((0, flow_1.flowTryParseStatement)()) {
                return;
            }
        }
        if ((0, tokenizer_1.match)(types_1.TokenType.at)) {
            parseDecorators();
        }
        parseStatementContent(declaration);
    }
    function parseStatementContent(declaration) {
        if (base_1.isTypeScriptEnabled) {
            if ((0, typescript_1.tsTryParseStatementContent)()) {
                return;
            }
        }
        const starttype = base_1.state.type;
        // Most types of statements are recognized by the keyword they
        // start with. Many are trivial to parse, some require a bit of
        // complexity.
        switch (starttype) {
            case types_1.TokenType._break:
            case types_1.TokenType._continue:
                parseBreakContinueStatement();
                return;
            case types_1.TokenType._debugger:
                parseDebuggerStatement();
                return;
            case types_1.TokenType._do:
                parseDoStatement();
                return;
            case types_1.TokenType._for:
                parseForStatement();
                return;
            case types_1.TokenType._function:
                if ((0, tokenizer_1.lookaheadType)() === types_1.TokenType.dot)
                    break;
                if (!declaration)
                    (0, util_1.unexpected)();
                parseFunctionStatement();
                return;
            case types_1.TokenType._class:
                if (!declaration)
                    (0, util_1.unexpected)();
                parseClass(true);
                return;
            case types_1.TokenType._if:
                parseIfStatement();
                return;
            case types_1.TokenType._return:
                parseReturnStatement();
                return;
            case types_1.TokenType._switch:
                parseSwitchStatement();
                return;
            case types_1.TokenType._throw:
                parseThrowStatement();
                return;
            case types_1.TokenType._try:
                parseTryStatement();
                return;
            case types_1.TokenType._let:
            case types_1.TokenType._const:
                if (!declaration)
                    (0, util_1.unexpected)(); // NOTE: falls through to _var
            case types_1.TokenType._var:
                parseVarStatement(starttype !== types_1.TokenType._var);
                return;
            case types_1.TokenType._while:
                parseWhileStatement();
                return;
            case types_1.TokenType.braceL:
                parseBlock();
                return;
            case types_1.TokenType.semi:
                parseEmptyStatement();
                return;
            case types_1.TokenType._export:
            case types_1.TokenType._import: {
                const nextType = (0, tokenizer_1.lookaheadType)();
                if (nextType === types_1.TokenType.parenL || nextType === types_1.TokenType.dot) {
                    break;
                }
                (0, tokenizer_1.next)();
                if (starttype === types_1.TokenType._import) {
                    parseImport();
                }
                else {
                    parseExport();
                }
                return;
            }
            case types_1.TokenType.name:
                if (base_1.state.contextualKeyword === keywords_1.ContextualKeyword._async) {
                    const functionStart = base_1.state.start;
                    // peek ahead and see if next token is a function
                    const snapshot = base_1.state.snapshot();
                    (0, tokenizer_1.next)();
                    if ((0, tokenizer_1.match)(types_1.TokenType._function) && !(0, util_1.canInsertSemicolon)()) {
                        (0, util_1.expect)(types_1.TokenType._function);
                        parseFunction(functionStart, true);
                        return;
                    }
                    else {
                        base_1.state.restoreFromSnapshot(snapshot);
                    }
                }
                else if (base_1.state.contextualKeyword === keywords_1.ContextualKeyword._using &&
                    !(0, util_1.hasFollowingLineBreak)() &&
                    // Statements like `using[0]` and `using in foo` aren't actual using
                    // declarations.
                    (0, tokenizer_1.lookaheadType)() === types_1.TokenType.name) {
                    parseVarStatement(true);
                    return;
                }
                else if (startsAwaitUsing()) {
                    (0, util_1.expectContextual)(keywords_1.ContextualKeyword._await);
                    parseVarStatement(true);
                    return;
                }
            default:
                // Do nothing.
                break;
        }
        // If the statement does not start with a statement keyword or a
        // brace, it's an ExpressionStatement or LabeledStatement. We
        // simply start parsing an expression, and afterwards, if the
        // next token is a colon and the expression was a simple
        // Identifier node, we switch to interpreting it as a label.
        const initialTokensLength = base_1.state.tokens.length;
        (0, expression_1.parseExpression)();
        let simpleName = null;
        if (base_1.state.tokens.length === initialTokensLength + 1) {
            const token = base_1.state.tokens[base_1.state.tokens.length - 1];
            if (token.type === types_1.TokenType.name) {
                simpleName = token.contextualKeyword;
            }
        }
        if (simpleName == null) {
            (0, util_1.semicolon)();
            return;
        }
        if ((0, tokenizer_1.eat)(types_1.TokenType.colon)) {
            parseLabeledStatement();
        }
        else {
            // This was an identifier, so we might want to handle flow/typescript-specific cases.
            parseIdentifierStatement(simpleName);
        }
    }
    /**
     * Determine if we're positioned at an `await using` declaration.
     *
     * Note that this can happen either in place of a regular variable declaration
     * or in a loop body, and in both places, there are similar-looking cases where
     * we need to return false.
     *
     * Examples returning true:
     * await using foo = bar();
     * for (await using a of b) {}
     *
     * Examples returning false:
     * await using
     * await using + 1
     * await using instanceof T
     * for (await using;;) {}
     *
     * For now, we early return if we don't see `await`, then do a simple
     * backtracking-based lookahead for the `using` and identifier tokens. In the
     * future, this could be optimized with a character-based approach.
     */
    function startsAwaitUsing() {
        if (!(0, util_1.isContextual)(keywords_1.ContextualKeyword._await)) {
            return false;
        }
        const snapshot = base_1.state.snapshot();
        // await
        (0, tokenizer_1.next)();
        if (!(0, util_1.isContextual)(keywords_1.ContextualKeyword._using) || (0, util_1.hasPrecedingLineBreak)()) {
            base_1.state.restoreFromSnapshot(snapshot);
            return false;
        }
        // using
        (0, tokenizer_1.next)();
        if (!(0, tokenizer_1.match)(types_1.TokenType.name) || (0, util_1.hasPrecedingLineBreak)()) {
            base_1.state.restoreFromSnapshot(snapshot);
            return false;
        }
        base_1.state.restoreFromSnapshot(snapshot);
        return true;
    }
    function parseDecorators() {
        while ((0, tokenizer_1.match)(types_1.TokenType.at)) {
            parseDecorator();
        }
    }
    function parseDecorator() {
        (0, tokenizer_1.next)();
        if ((0, tokenizer_1.eat)(types_1.TokenType.parenL)) {
            (0, expression_1.parseExpression)();
            (0, util_1.expect)(types_1.TokenType.parenR);
        }
        else {
            (0, expression_1.parseIdentifier)();
            while ((0, tokenizer_1.eat)(types_1.TokenType.dot)) {
                (0, expression_1.parseIdentifier)();
            }
            parseMaybeDecoratorArguments();
        }
    }
    function parseMaybeDecoratorArguments() {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseMaybeDecoratorArguments)();
        }
        else {
            baseParseMaybeDecoratorArguments();
        }
    }
    function baseParseMaybeDecoratorArguments() {
        if ((0, tokenizer_1.eat)(types_1.TokenType.parenL)) {
            (0, expression_1.parseCallExpressionArguments)();
        }
    }
    function parseBreakContinueStatement() {
        (0, tokenizer_1.next)();
        if (!(0, util_1.isLineTerminator)()) {
            (0, expression_1.parseIdentifier)();
            (0, util_1.semicolon)();
        }
    }
    function parseDebuggerStatement() {
        (0, tokenizer_1.next)();
        (0, util_1.semicolon)();
    }
    function parseDoStatement() {
        (0, tokenizer_1.next)();
        parseStatement(false);
        (0, util_1.expect)(types_1.TokenType._while);
        (0, expression_1.parseParenExpression)();
        (0, tokenizer_1.eat)(types_1.TokenType.semi);
    }
    function parseForStatement() {
        base_1.state.scopeDepth++;
        const startTokenIndex = base_1.state.tokens.length;
        parseAmbiguousForStatement();
        const endTokenIndex = base_1.state.tokens.length;
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, false));
        base_1.state.scopeDepth--;
    }
    /**
     * Determine if this token is a `using` declaration (explicit resource
     * management) as part of a loop.
     * https://github.com/tc39/proposal-explicit-resource-management
     */
    function isUsingInLoop() {
        if (!(0, util_1.isContextual)(keywords_1.ContextualKeyword._using)) {
            return false;
        }
        // This must be `for (using of`, where `using` is the name of the loop
        // variable.
        if ((0, util_1.isLookaheadContextual)(keywords_1.ContextualKeyword._of)) {
            return false;
        }
        return true;
    }
    // Disambiguating between a `for` and a `for`/`in` or `for`/`of`
    // loop is non-trivial. Basically, we have to parse the init `var`
    // statement or expression, disallowing the `in` operator (see
    // the second parameter to `parseExpression`), and then check
    // whether the next token is `in` or `of`. When there is no init
    // part (semicolon immediately after the opening parenthesis), it
    // is a regular `for` loop.
    function parseAmbiguousForStatement() {
        (0, tokenizer_1.next)();
        let forAwait = false;
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._await)) {
            forAwait = true;
            (0, tokenizer_1.next)();
        }
        (0, util_1.expect)(types_1.TokenType.parenL);
        if ((0, tokenizer_1.match)(types_1.TokenType.semi)) {
            if (forAwait) {
                (0, util_1.unexpected)();
            }
            parseFor();
            return;
        }
        const isAwaitUsing = startsAwaitUsing();
        if (isAwaitUsing || (0, tokenizer_1.match)(types_1.TokenType._var) || (0, tokenizer_1.match)(types_1.TokenType._let) || (0, tokenizer_1.match)(types_1.TokenType._const) || isUsingInLoop()) {
            if (isAwaitUsing) {
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._await);
            }
            (0, tokenizer_1.next)();
            parseVar(true, base_1.state.type !== types_1.TokenType._var);
            if ((0, tokenizer_1.match)(types_1.TokenType._in) || (0, util_1.isContextual)(keywords_1.ContextualKeyword._of)) {
                parseForIn(forAwait);
                return;
            }
            parseFor();
            return;
        }
        (0, expression_1.parseExpression)(true);
        if ((0, tokenizer_1.match)(types_1.TokenType._in) || (0, util_1.isContextual)(keywords_1.ContextualKeyword._of)) {
            parseForIn(forAwait);
            return;
        }
        if (forAwait) {
            (0, util_1.unexpected)();
        }
        parseFor();
    }
    function parseFunctionStatement() {
        const functionStart = base_1.state.start;
        (0, tokenizer_1.next)();
        parseFunction(functionStart, true);
    }
    function parseIfStatement() {
        (0, tokenizer_1.next)();
        (0, expression_1.parseParenExpression)();
        parseStatement(false);
        if ((0, tokenizer_1.eat)(types_1.TokenType._else)) {
            parseStatement(false);
        }
    }
    function parseReturnStatement() {
        (0, tokenizer_1.next)();
        // In `return` (and `break`/`continue`), the keywords with
        // optional arguments, we eagerly look for a semicolon or the
        // possibility to insert one.
        if (!(0, util_1.isLineTerminator)()) {
            (0, expression_1.parseExpression)();
            (0, util_1.semicolon)();
        }
    }
    function parseSwitchStatement() {
        (0, tokenizer_1.next)();
        (0, expression_1.parseParenExpression)();
        base_1.state.scopeDepth++;
        const startTokenIndex = base_1.state.tokens.length;
        (0, util_1.expect)(types_1.TokenType.braceL);
        // Don't bother validation; just go through any sequence of cases, defaults, and statements.
        while (!(0, tokenizer_1.match)(types_1.TokenType.braceR) && !base_1.state.error) {
            if ((0, tokenizer_1.match)(types_1.TokenType._case) || (0, tokenizer_1.match)(types_1.TokenType._default)) {
                const isCase = (0, tokenizer_1.match)(types_1.TokenType._case);
                (0, tokenizer_1.next)();
                if (isCase) {
                    (0, expression_1.parseExpression)();
                }
                (0, util_1.expect)(types_1.TokenType.colon);
            }
            else {
                parseStatement(true);
            }
        }
        (0, tokenizer_1.next)(); // Closing brace
        const endTokenIndex = base_1.state.tokens.length;
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, false));
        base_1.state.scopeDepth--;
    }
    function parseThrowStatement() {
        (0, tokenizer_1.next)();
        (0, expression_1.parseExpression)();
        (0, util_1.semicolon)();
    }
    function parseCatchClauseParam() {
        (0, lval_1.parseBindingAtom)(true /* isBlockScope */);
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsTryParseTypeAnnotation)();
        }
    }
    function parseTryStatement() {
        (0, tokenizer_1.next)();
        parseBlock();
        if ((0, tokenizer_1.match)(types_1.TokenType._catch)) {
            (0, tokenizer_1.next)();
            let catchBindingStartTokenIndex = null;
            if ((0, tokenizer_1.match)(types_1.TokenType.parenL)) {
                base_1.state.scopeDepth++;
                catchBindingStartTokenIndex = base_1.state.tokens.length;
                (0, util_1.expect)(types_1.TokenType.parenL);
                parseCatchClauseParam();
                (0, util_1.expect)(types_1.TokenType.parenR);
            }
            parseBlock();
            if (catchBindingStartTokenIndex != null) {
                // We need a special scope for the catch binding which includes the binding itself and the
                // catch block.
                const endTokenIndex = base_1.state.tokens.length;
                base_1.state.scopes.push(new state_1.Scope(catchBindingStartTokenIndex, endTokenIndex, false));
                base_1.state.scopeDepth--;
            }
        }
        if ((0, tokenizer_1.eat)(types_1.TokenType._finally)) {
            parseBlock();
        }
    }
    function parseVarStatement(isBlockScope) {
        (0, tokenizer_1.next)();
        parseVar(false, isBlockScope);
        (0, util_1.semicolon)();
    }
    function parseWhileStatement() {
        (0, tokenizer_1.next)();
        (0, expression_1.parseParenExpression)();
        parseStatement(false);
    }
    function parseEmptyStatement() {
        (0, tokenizer_1.next)();
    }
    function parseLabeledStatement() {
        parseStatement(true);
    }
    /**
     * Parse a statement starting with an identifier of the given name. Subclasses match on the name
     * to handle statements like "declare".
     */
    function parseIdentifierStatement(contextualKeyword) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseIdentifierStatement)(contextualKeyword);
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseIdentifierStatement)(contextualKeyword);
        }
        else {
            (0, util_1.semicolon)();
        }
    }
    // Parse a semicolon-enclosed block of statements.
    function parseBlock(isFunctionScope = false, contextId = 0) {
        const startTokenIndex = base_1.state.tokens.length;
        base_1.state.scopeDepth++;
        (0, util_1.expect)(types_1.TokenType.braceL);
        if (contextId) {
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
        }
        parseBlockBody(types_1.TokenType.braceR);
        if (contextId) {
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
        }
        const endTokenIndex = base_1.state.tokens.length;
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, isFunctionScope));
        base_1.state.scopeDepth--;
    }
    function parseBlockBody(end) {
        while (!(0, tokenizer_1.eat)(end) && !base_1.state.error) {
            parseStatement(true);
        }
    }
    // Parse a regular `for` loop. The disambiguation code in
    // `parseStatement` will already have parsed the init statement or
    // expression.
    function parseFor() {
        (0, util_1.expect)(types_1.TokenType.semi);
        if (!(0, tokenizer_1.match)(types_1.TokenType.semi)) {
            (0, expression_1.parseExpression)();
        }
        (0, util_1.expect)(types_1.TokenType.semi);
        if (!(0, tokenizer_1.match)(types_1.TokenType.parenR)) {
            (0, expression_1.parseExpression)();
        }
        (0, util_1.expect)(types_1.TokenType.parenR);
        parseStatement(false);
    }
    // Parse a `for`/`in` and `for`/`of` loop, which are almost
    // same from parser's perspective.
    function parseForIn(forAwait) {
        if (forAwait) {
            (0, util_1.eatContextual)(keywords_1.ContextualKeyword._of);
        }
        else {
            (0, tokenizer_1.next)();
        }
        (0, expression_1.parseExpression)();
        (0, util_1.expect)(types_1.TokenType.parenR);
        parseStatement(false);
    }
    // Parse a list of variable declarations.
    function parseVar(isFor, isBlockScope) {
        while (true) {
            parseVarHead(isBlockScope);
            if ((0, tokenizer_1.eat)(types_1.TokenType.eq)) {
                const eqIndex = base_1.state.tokens.length - 1;
                (0, expression_1.parseMaybeAssign)(isFor);
                base_1.state.tokens[eqIndex].rhsEndIndex = base_1.state.tokens.length;
            }
            if (!(0, tokenizer_1.eat)(types_1.TokenType.comma)) {
                break;
            }
        }
    }
    function parseVarHead(isBlockScope) {
        (0, lval_1.parseBindingAtom)(isBlockScope);
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsAfterParseVarHead)();
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowAfterParseVarHead)();
        }
    }
    // Parse a function declaration or literal (depending on the
    // `isStatement` parameter).
    function parseFunction(functionStart, isStatement, optionalId = false) {
        if ((0, tokenizer_1.match)(types_1.TokenType.star)) {
            (0, tokenizer_1.next)();
        }
        if (isStatement && !optionalId && !(0, tokenizer_1.match)(types_1.TokenType.name) && !(0, tokenizer_1.match)(types_1.TokenType._yield)) {
            (0, util_1.unexpected)();
        }
        let nameScopeStartTokenIndex = null;
        if ((0, tokenizer_1.match)(types_1.TokenType.name)) {
            // Expression-style functions should limit their name's scope to the function body, so we make
            // a new function scope to enforce that.
            if (!isStatement) {
                nameScopeStartTokenIndex = base_1.state.tokens.length;
                base_1.state.scopeDepth++;
            }
            (0, lval_1.parseBindingIdentifier)(false);
        }
        const startTokenIndex = base_1.state.tokens.length;
        base_1.state.scopeDepth++;
        parseFunctionParams();
        (0, expression_1.parseFunctionBodyAndFinish)(functionStart);
        const endTokenIndex = base_1.state.tokens.length;
        // In addition to the block scope of the function body, we need a separate function-style scope
        // that includes the params.
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, true));
        base_1.state.scopeDepth--;
        if (nameScopeStartTokenIndex !== null) {
            base_1.state.scopes.push(new state_1.Scope(nameScopeStartTokenIndex, endTokenIndex, true));
            base_1.state.scopeDepth--;
        }
    }
    function parseFunctionParams(allowModifiers = false, funcContextId = 0) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsStartParseFunctionParams)();
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowStartParseFunctionParams)();
        }
        (0, util_1.expect)(types_1.TokenType.parenL);
        if (funcContextId) {
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = funcContextId;
        }
        (0, lval_1.parseBindingList)(types_1.TokenType.parenR, false /* isBlockScope */, false /* allowEmpty */, allowModifiers, funcContextId);
        if (funcContextId) {
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = funcContextId;
        }
    }
    // Parse a class declaration or literal (depending on the
    // `isStatement` parameter).
    function parseClass(isStatement, optionalId = false) {
        // Put a context ID on the class keyword, the open-brace, and the close-brace, so that later
        // code can easily navigate to meaningful points on the class.
        const contextId = (0, base_1.getNextContextId)();
        (0, tokenizer_1.next)();
        base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
        base_1.state.tokens[base_1.state.tokens.length - 1].isExpression = !isStatement;
        // Like with functions, we declare a special "name scope" from the start of the name to the end
        // of the class, but only with expression-style classes, to represent the fact that the name is
        // available to the body of the class but not an outer declaration.
        let nameScopeStartTokenIndex = null;
        if (!isStatement) {
            nameScopeStartTokenIndex = base_1.state.tokens.length;
            base_1.state.scopeDepth++;
        }
        parseClassId(isStatement, optionalId);
        parseClassSuper();
        const openBraceIndex = base_1.state.tokens.length;
        parseClassBody(contextId);
        if (base_1.state.error) {
            return;
        }
        base_1.state.tokens[openBraceIndex].contextId = contextId;
        base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
        if (nameScopeStartTokenIndex !== null) {
            const endTokenIndex = base_1.state.tokens.length;
            base_1.state.scopes.push(new state_1.Scope(nameScopeStartTokenIndex, endTokenIndex, false));
            base_1.state.scopeDepth--;
        }
    }
    function isClassProperty() {
        return (0, tokenizer_1.match)(types_1.TokenType.eq) || (0, tokenizer_1.match)(types_1.TokenType.semi) || (0, tokenizer_1.match)(types_1.TokenType.braceR) || (0, tokenizer_1.match)(types_1.TokenType.bang) || (0, tokenizer_1.match)(types_1.TokenType.colon);
    }
    function isClassMethod() {
        return (0, tokenizer_1.match)(types_1.TokenType.parenL) || (0, tokenizer_1.match)(types_1.TokenType.lessThan);
    }
    function parseClassBody(classContextId) {
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, tokenizer_1.eat)(types_1.TokenType.braceR) && !base_1.state.error) {
            if ((0, tokenizer_1.eat)(types_1.TokenType.semi)) {
                continue;
            }
            if ((0, tokenizer_1.match)(types_1.TokenType.at)) {
                parseDecorator();
                continue;
            }
            const memberStart = base_1.state.start;
            parseClassMember(memberStart, classContextId);
        }
    }
    function parseClassMember(memberStart, classContextId) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseModifiers)([
                keywords_1.ContextualKeyword._declare,
                keywords_1.ContextualKeyword._public,
                keywords_1.ContextualKeyword._protected,
                keywords_1.ContextualKeyword._private,
                keywords_1.ContextualKeyword._override,
            ]);
        }
        let isStatic = false;
        if ((0, tokenizer_1.match)(types_1.TokenType.name) && base_1.state.contextualKeyword === keywords_1.ContextualKeyword._static) {
            (0, expression_1.parseIdentifier)(); // eats 'static'
            if (isClassMethod()) {
                parseClassMethod(memberStart, /* isConstructor */ false);
                return;
            }
            else if (isClassProperty()) {
                parseClassProperty();
                return;
            }
            // otherwise something static
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._static;
            isStatic = true;
            if ((0, tokenizer_1.match)(types_1.TokenType.braceL)) {
                // This is a static block. Mark the word "static" with the class context ID for class element
                // detection and parse as a regular block.
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = classContextId;
                parseBlock();
                return;
            }
        }
        parseClassMemberWithIsStatic(memberStart, isStatic, classContextId);
    }
    function parseClassMemberWithIsStatic(memberStart, isStatic, classContextId) {
        if (base_1.isTypeScriptEnabled) {
            if ((0, typescript_1.tsTryParseClassMemberWithIsStatic)(isStatic)) {
                return;
            }
        }
        if ((0, tokenizer_1.eat)(types_1.TokenType.star)) {
            // a generator
            parseClassPropertyName(classContextId);
            parseClassMethod(memberStart, /* isConstructor */ false);
            return;
        }
        // Get the identifier name so we can tell if it's actually a keyword like "async", "get", or
        // "set".
        parseClassPropertyName(classContextId);
        let isConstructor = false;
        const token = base_1.state.tokens[base_1.state.tokens.length - 1];
        // We allow "constructor" as either an identifier or a string.
        if (token.contextualKeyword === keywords_1.ContextualKeyword._constructor) {
            isConstructor = true;
        }
        parsePostMemberNameModifiers();
        if (isClassMethod()) {
            parseClassMethod(memberStart, isConstructor);
        }
        else if (isClassProperty()) {
            parseClassProperty();
        }
        else if (token.contextualKeyword === keywords_1.ContextualKeyword._async && !(0, util_1.isLineTerminator)()) {
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._async;
            // an async method
            const isGenerator = (0, tokenizer_1.match)(types_1.TokenType.star);
            if (isGenerator) {
                (0, tokenizer_1.next)();
            }
            // The so-called parsed name would have been "async": get the real name.
            parseClassPropertyName(classContextId);
            parsePostMemberNameModifiers();
            parseClassMethod(memberStart, false /* isConstructor */);
        }
        else if ((token.contextualKeyword === keywords_1.ContextualKeyword._get ||
            token.contextualKeyword === keywords_1.ContextualKeyword._set) &&
            !((0, util_1.isLineTerminator)() && (0, tokenizer_1.match)(types_1.TokenType.star))) {
            if (token.contextualKeyword === keywords_1.ContextualKeyword._get) {
                base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._get;
            }
            else {
                base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._set;
            }
            // `get\n*` is an uninitialized property named 'get' followed by a generator.
            // a getter or setter
            // The so-called parsed name would have been "get/set": get the real name.
            parseClassPropertyName(classContextId);
            parseClassMethod(memberStart, /* isConstructor */ false);
        }
        else if (token.contextualKeyword === keywords_1.ContextualKeyword._accessor && !(0, util_1.isLineTerminator)()) {
            parseClassPropertyName(classContextId);
            parseClassProperty();
        }
        else if ((0, util_1.isLineTerminator)()) {
            // an uninitialized class property (due to ASI, since we don't otherwise recognize the next token)
            parseClassProperty();
        }
        else {
            (0, util_1.unexpected)();
        }
    }
    function parseClassMethod(functionStart, isConstructor) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsTryParseTypeParameters)();
        }
        else if (base_1.isFlowEnabled) {
            if ((0, tokenizer_1.match)(types_1.TokenType.lessThan)) {
                (0, flow_1.flowParseTypeParameterDeclaration)();
            }
        }
        (0, expression_1.parseMethod)(functionStart, isConstructor);
    }
    // Return the name of the class property, if it is a simple identifier.
    function parseClassPropertyName(classContextId) {
        (0, expression_1.parsePropertyName)(classContextId);
    }
    function parsePostMemberNameModifiers() {
        if (base_1.isTypeScriptEnabled) {
            const oldIsType = (0, tokenizer_1.pushTypeContext)(0);
            (0, tokenizer_1.eat)(types_1.TokenType.question);
            (0, tokenizer_1.popTypeContext)(oldIsType);
        }
    }
    function parseClassProperty() {
        if (base_1.isTypeScriptEnabled) {
            (0, tokenizer_1.eatTypeToken)(types_1.TokenType.bang);
            (0, typescript_1.tsTryParseTypeAnnotation)();
        }
        else if (base_1.isFlowEnabled) {
            if ((0, tokenizer_1.match)(types_1.TokenType.colon)) {
                (0, flow_1.flowParseTypeAnnotation)();
            }
        }
        if ((0, tokenizer_1.match)(types_1.TokenType.eq)) {
            const equalsTokenIndex = base_1.state.tokens.length;
            (0, tokenizer_1.next)();
            (0, expression_1.parseMaybeAssign)();
            base_1.state.tokens[equalsTokenIndex].rhsEndIndex = base_1.state.tokens.length;
        }
        (0, util_1.semicolon)();
    }
    function parseClassId(isStatement, optionalId = false) {
        if (base_1.isTypeScriptEnabled &&
            (!isStatement || optionalId) &&
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._implements)) {
            return;
        }
        if ((0, tokenizer_1.match)(types_1.TokenType.name)) {
            (0, lval_1.parseBindingIdentifier)(true);
        }
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsTryParseTypeParameters)();
        }
        else if (base_1.isFlowEnabled) {
            if ((0, tokenizer_1.match)(types_1.TokenType.lessThan)) {
                (0, flow_1.flowParseTypeParameterDeclaration)();
            }
        }
    }
    // Returns true if there was a superclass.
    function parseClassSuper() {
        let hasSuper = false;
        if ((0, tokenizer_1.eat)(types_1.TokenType._extends)) {
            (0, expression_1.parseExprSubscripts)();
            hasSuper = true;
        }
        else {
            hasSuper = false;
        }
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsAfterParseClassSuper)(hasSuper);
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowAfterParseClassSuper)(hasSuper);
        }
    }
    // Parses module export declaration.
    function parseExport() {
        const exportIndex = base_1.state.tokens.length - 1;
        if (base_1.isTypeScriptEnabled) {
            if ((0, typescript_1.tsTryParseExport)()) {
                return;
            }
        }
        // export * from '...'
        if (shouldParseExportStar()) {
            parseExportStar();
        }
        else if (isExportDefaultSpecifier()) {
            // export default from
            (0, expression_1.parseIdentifier)();
            if ((0, tokenizer_1.match)(types_1.TokenType.comma) && (0, tokenizer_1.lookaheadType)() === types_1.TokenType.star) {
                (0, util_1.expect)(types_1.TokenType.comma);
                (0, util_1.expect)(types_1.TokenType.star);
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._as);
                (0, expression_1.parseIdentifier)();
            }
            else {
                parseExportSpecifiersMaybe();
            }
            parseExportFrom();
        }
        else if ((0, tokenizer_1.eat)(types_1.TokenType._default)) {
            // export default ...
            parseExportDefaultExpression();
        }
        else if (shouldParseExportDeclaration()) {
            parseExportDeclaration();
        }
        else {
            // export { x, y as z } [from '...']
            parseExportSpecifiers();
            parseExportFrom();
        }
        base_1.state.tokens[exportIndex].rhsEndIndex = base_1.state.tokens.length;
    }
    function parseExportDefaultExpression() {
        if (base_1.isTypeScriptEnabled) {
            if ((0, typescript_1.tsTryParseExportDefaultExpression)()) {
                return;
            }
        }
        if (base_1.isFlowEnabled) {
            if ((0, flow_1.flowTryParseExportDefaultExpression)()) {
                return;
            }
        }
        const functionStart = base_1.state.start;
        if ((0, tokenizer_1.eat)(types_1.TokenType._function)) {
            parseFunction(functionStart, true, true);
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._async) && (0, tokenizer_1.lookaheadType)() === types_1.TokenType._function) {
            // async function declaration
            (0, util_1.eatContextual)(keywords_1.ContextualKeyword._async);
            (0, tokenizer_1.eat)(types_1.TokenType._function);
            parseFunction(functionStart, true, true);
        }
        else if ((0, tokenizer_1.match)(types_1.TokenType._class)) {
            parseClass(true, true);
        }
        else if ((0, tokenizer_1.match)(types_1.TokenType.at)) {
            parseDecorators();
            parseClass(true, true);
        }
        else {
            (0, expression_1.parseMaybeAssign)();
            (0, util_1.semicolon)();
        }
    }
    function parseExportDeclaration() {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseExportDeclaration)();
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseExportDeclaration)();
        }
        else {
            parseStatement(true);
        }
    }
    function isExportDefaultSpecifier() {
        if (base_1.isTypeScriptEnabled && (0, typescript_1.tsIsDeclarationStart)()) {
            return false;
        }
        else if (base_1.isFlowEnabled && (0, flow_1.flowShouldDisallowExportDefaultSpecifier)()) {
            return false;
        }
        if ((0, tokenizer_1.match)(types_1.TokenType.name)) {
            return base_1.state.contextualKeyword !== keywords_1.ContextualKeyword._async;
        }
        if (!(0, tokenizer_1.match)(types_1.TokenType._default)) {
            return false;
        }
        const _next = (0, tokenizer_1.nextTokenStart)();
        const lookahead = (0, tokenizer_1.lookaheadTypeAndKeyword)();
        const hasFrom = lookahead.type === types_1.TokenType.name && lookahead.contextualKeyword === keywords_1.ContextualKeyword._from;
        if (lookahead.type === types_1.TokenType.comma) {
            return true;
        }
        // lookahead again when `export default from` is seen
        if (hasFrom) {
            const nextAfterFrom = base_1.input.charCodeAt((0, tokenizer_1.nextTokenStartSince)(_next + 4));
            return nextAfterFrom === charcodes_1.charCodes.quotationMark || nextAfterFrom === charcodes_1.charCodes.apostrophe;
        }
        return false;
    }
    function parseExportSpecifiersMaybe() {
        if ((0, tokenizer_1.eat)(types_1.TokenType.comma)) {
            parseExportSpecifiers();
        }
    }
    function parseExportFrom() {
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._from)) {
            (0, expression_1.parseExprAtom)();
            maybeParseImportAttributes();
        }
        (0, util_1.semicolon)();
    }
    function shouldParseExportStar() {
        if (base_1.isFlowEnabled) {
            return (0, flow_1.flowShouldParseExportStar)();
        }
        else {
            return (0, tokenizer_1.match)(types_1.TokenType.star);
        }
    }
    function parseExportStar() {
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseExportStar)();
        }
        else {
            baseParseExportStar();
        }
    }
    function baseParseExportStar() {
        (0, util_1.expect)(types_1.TokenType.star);
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._as)) {
            parseExportNamespace();
        }
        else {
            parseExportFrom();
        }
    }
    function parseExportNamespace() {
        (0, tokenizer_1.next)();
        base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._as;
        (0, expression_1.parseIdentifier)();
        parseExportSpecifiersMaybe();
        parseExportFrom();
    }
    function shouldParseExportDeclaration() {
        return ((base_1.isTypeScriptEnabled && (0, typescript_1.tsIsDeclarationStart)()) ||
            (base_1.isFlowEnabled && (0, flow_1.flowShouldParseExportDeclaration)()) ||
            base_1.state.type === types_1.TokenType._var ||
            base_1.state.type === types_1.TokenType._const ||
            base_1.state.type === types_1.TokenType._let ||
            base_1.state.type === types_1.TokenType._function ||
            base_1.state.type === types_1.TokenType._class ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._async) ||
            (0, tokenizer_1.match)(types_1.TokenType.at));
    }
    // Parses a comma-separated list of module exports.
    function parseExportSpecifiers() {
        let first = true;
        // export { x, y as z } [from '...']
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, tokenizer_1.eat)(types_1.TokenType.braceR) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_1.TokenType.comma);
                if ((0, tokenizer_1.eat)(types_1.TokenType.braceR)) {
                    break;
                }
            }
            parseExportSpecifier();
        }
    }
    function parseExportSpecifier() {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseExportSpecifier)();
            return;
        }
        (0, expression_1.parseIdentifier)();
        base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = tokenizer_1.IdentifierRole.ExportAccess;
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._as)) {
            (0, expression_1.parseIdentifier)();
        }
    }
    /**
     * Starting at the `module` token in an import, determine if it was truly an
     * import reflection token or just looks like one.
     *
     * Returns true for:
     * import module foo from "foo";
     * import module from from "foo";
     *
     * Returns false for:
     * import module from "foo";
     * import module, {bar} from "foo";
     */
    function isImportReflection() {
        const snapshot = base_1.state.snapshot();
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._module);
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._from)) {
            if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._from)) {
                base_1.state.restoreFromSnapshot(snapshot);
                return true;
            }
            else {
                base_1.state.restoreFromSnapshot(snapshot);
                return false;
            }
        }
        else if ((0, tokenizer_1.match)(types_1.TokenType.comma)) {
            base_1.state.restoreFromSnapshot(snapshot);
            return false;
        }
        else {
            base_1.state.restoreFromSnapshot(snapshot);
            return true;
        }
    }
    /**
     * Eat the "module" token from the import reflection proposal.
     * https://github.com/tc39/proposal-import-reflection
     */
    function parseMaybeImportReflection() {
        // isImportReflection does snapshot/restore, so only run it if we see the word
        // "module".
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._module) && isImportReflection()) {
            (0, tokenizer_1.next)();
        }
    }
    // Parses import declaration.
    function parseImport() {
        if (base_1.isTypeScriptEnabled && (0, tokenizer_1.match)(types_1.TokenType.name) && (0, tokenizer_1.lookaheadType)() === types_1.TokenType.eq) {
            (0, typescript_1.tsParseImportEqualsDeclaration)();
            return;
        }
        if (base_1.isTypeScriptEnabled && (0, util_1.isContextual)(keywords_1.ContextualKeyword._type)) {
            const lookahead = (0, tokenizer_1.lookaheadTypeAndKeyword)();
            if (lookahead.type === types_1.TokenType.name && lookahead.contextualKeyword !== keywords_1.ContextualKeyword._from) {
                // One of these `import type` cases:
                // import type T = require('T');
                // import type A from 'A';
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._type);
                if ((0, tokenizer_1.lookaheadType)() === types_1.TokenType.eq) {
                    (0, typescript_1.tsParseImportEqualsDeclaration)();
                    return;
                }
                // If this is an `import type...from` statement, then we already ate the
                // type token, so proceed to the regular import parser.
            }
            else if (lookahead.type === types_1.TokenType.star || lookahead.type === types_1.TokenType.braceL) {
                // One of these `import type` cases, in which case we can eat the type token
                // and proceed as normal:
                // import type * as A from 'A';
                // import type {a} from 'A';
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._type);
            }
            // Otherwise, we are importing the name "type".
        }
        // import '...'
        if ((0, tokenizer_1.match)(types_1.TokenType.string)) {
            (0, expression_1.parseExprAtom)();
        }
        else {
            parseMaybeImportReflection();
            parseImportSpecifiers();
            (0, util_1.expectContextual)(keywords_1.ContextualKeyword._from);
            (0, expression_1.parseExprAtom)();
        }
        maybeParseImportAttributes();
        (0, util_1.semicolon)();
    }
    // eslint-disable-next-line no-unused-vars
    function shouldParseDefaultImport() {
        return (0, tokenizer_1.match)(types_1.TokenType.name);
    }
    function parseImportSpecifierLocal() {
        (0, lval_1.parseImportedIdentifier)();
    }
    // Parses a comma-separated list of module imports.
    function parseImportSpecifiers() {
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowStartParseImportSpecifiers)();
        }
        let first = true;
        if (shouldParseDefaultImport()) {
            // import defaultObj, { x, y as z } from '...'
            parseImportSpecifierLocal();
            if (!(0, tokenizer_1.eat)(types_1.TokenType.comma))
                return;
        }
        if ((0, tokenizer_1.match)(types_1.TokenType.star)) {
            (0, tokenizer_1.next)();
            (0, util_1.expectContextual)(keywords_1.ContextualKeyword._as);
            parseImportSpecifierLocal();
            return;
        }
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, tokenizer_1.eat)(types_1.TokenType.braceR) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                // Detect an attempt to deep destructure
                if ((0, tokenizer_1.eat)(types_1.TokenType.colon)) {
                    (0, util_1.unexpected)("ES2015 named imports do not destructure. Use another statement for destructuring after the import.");
                }
                (0, util_1.expect)(types_1.TokenType.comma);
                if ((0, tokenizer_1.eat)(types_1.TokenType.braceR)) {
                    break;
                }
            }
            parseImportSpecifier();
        }
    }
    function parseImportSpecifier() {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseImportSpecifier)();
            return;
        }
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseImportSpecifier)();
            return;
        }
        (0, lval_1.parseImportedIdentifier)();
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._as)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = tokenizer_1.IdentifierRole.ImportAccess;
            (0, tokenizer_1.next)();
            (0, lval_1.parseImportedIdentifier)();
        }
    }
    /**
     * Parse import attributes like `with {type: "json"}`, or the legacy form
     * `assert {type: "json"}`.
     *
     * Import attributes technically have their own syntax, but are always parseable
     * as a plain JS object, so just do that for simplicity.
     */
    function maybeParseImportAttributes() {
        if ((0, tokenizer_1.match)(types_1.TokenType._with) || ((0, util_1.isContextual)(keywords_1.ContextualKeyword._assert) && !(0, util_1.hasPrecedingLineBreak)())) {
            (0, tokenizer_1.next)();
            (0, expression_1.parseObj)(false, false);
        }
    }
},
"9b8d43cd0a": /* sucrase\dist\esm\parser\plugins\flow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.flowParseTypeParameterDeclaration = flowParseTypeParameterDeclaration;
    exports.flowParseTypeAnnotation = flowParseTypeAnnotation;
    exports.flowParseVariance = flowParseVariance;
    exports.flowParseFunctionBodyAndFinish = flowParseFunctionBodyAndFinish;
    exports.flowParseSubscript = flowParseSubscript;
    exports.flowStartParseNewArguments = flowStartParseNewArguments;
    exports.flowTryParseStatement = flowTryParseStatement;
    exports.flowTryParseExportDefaultExpression = flowTryParseExportDefaultExpression;
    exports.flowParseIdentifierStatement = flowParseIdentifierStatement;
    exports.flowShouldParseExportDeclaration = flowShouldParseExportDeclaration;
    exports.flowShouldDisallowExportDefaultSpecifier = flowShouldDisallowExportDefaultSpecifier;
    exports.flowParseExportDeclaration = flowParseExportDeclaration;
    exports.flowShouldParseExportStar = flowShouldParseExportStar;
    exports.flowParseExportStar = flowParseExportStar;
    exports.flowAfterParseClassSuper = flowAfterParseClassSuper;
    exports.flowStartParseObjPropValue = flowStartParseObjPropValue;
    exports.flowParseAssignableListItemTypes = flowParseAssignableListItemTypes;
    exports.flowStartParseImportSpecifiers = flowStartParseImportSpecifiers;
    exports.flowParseImportSpecifier = flowParseImportSpecifier;
    exports.flowStartParseFunctionParams = flowStartParseFunctionParams;
    exports.flowAfterParseVarHead = flowAfterParseVarHead;
    exports.flowStartParseAsyncArrowFromCallExpression = flowStartParseAsyncArrowFromCallExpression;
    exports.flowParseMaybeAssign = flowParseMaybeAssign;
    exports.flowParseArrow = flowParseArrow;
    exports.flowParseSubscripts = flowParseSubscripts;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const keywords_1 = require("99ff836c64") /* ../tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const base_1 = require("540718e523") /* ../traverser/base */;
    const expression_1 = require("8178e7c3c8") /* ../traverser/expression */;
    const statement_1 = require("e3b9989da1") /* ../traverser/statement */;
    const util_1 = require("bc94bbadc1") /* ../traverser/util */;
    function isMaybeDefaultImport(lookahead) {
        return ((lookahead.type === types_1.TokenType.name || !!(lookahead.type & types_1.TokenType.IS_KEYWORD)) &&
            lookahead.contextualKeyword !== keywords_1.ContextualKeyword._from);
    }
    function flowParseTypeInitialiser(tok) {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(tok || types_1.TokenType.colon);
        flowParseType();
        (0, index_1.popTypeContext)(oldIsType);
    }
    function flowParsePredicate() {
        (0, util_1.expect)(types_1.TokenType.modulo);
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._checks);
        if ((0, index_1.eat)(types_1.TokenType.parenL)) {
            (0, expression_1.parseExpression)();
            (0, util_1.expect)(types_1.TokenType.parenR);
        }
    }
    function flowParseTypeAndPredicateInitialiser() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(types_1.TokenType.colon);
        if ((0, index_1.match)(types_1.TokenType.modulo)) {
            flowParsePredicate();
        }
        else {
            flowParseType();
            if ((0, index_1.match)(types_1.TokenType.modulo)) {
                flowParsePredicate();
            }
        }
        (0, index_1.popTypeContext)(oldIsType);
    }
    function flowParseDeclareClass() {
        (0, index_1.next)();
        flowParseInterfaceish(/* isClass */ true);
    }
    function flowParseDeclareFunction() {
        (0, index_1.next)();
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
        }
        (0, util_1.expect)(types_1.TokenType.parenL);
        flowParseFunctionTypeParams();
        (0, util_1.expect)(types_1.TokenType.parenR);
        flowParseTypeAndPredicateInitialiser();
        (0, util_1.semicolon)();
    }
    function flowParseDeclare() {
        if ((0, index_1.match)(types_1.TokenType._class)) {
            flowParseDeclareClass();
        }
        else if ((0, index_1.match)(types_1.TokenType._function)) {
            flowParseDeclareFunction();
        }
        else if ((0, index_1.match)(types_1.TokenType._var)) {
            flowParseDeclareVariable();
        }
        else if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._module)) {
            if ((0, index_1.eat)(types_1.TokenType.dot)) {
                flowParseDeclareModuleExports();
            }
            else {
                flowParseDeclareModule();
            }
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type)) {
            flowParseDeclareTypeAlias();
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._opaque)) {
            flowParseDeclareOpaqueType();
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._interface)) {
            flowParseDeclareInterface();
        }
        else if ((0, index_1.match)(types_1.TokenType._export)) {
            flowParseDeclareExportDeclaration();
        }
        else {
            (0, util_1.unexpected)();
        }
    }
    function flowParseDeclareVariable() {
        (0, index_1.next)();
        flowParseTypeAnnotatableIdentifier();
        (0, util_1.semicolon)();
    }
    function flowParseDeclareModule() {
        if ((0, index_1.match)(types_1.TokenType.string)) {
            (0, expression_1.parseExprAtom)();
        }
        else {
            (0, expression_1.parseIdentifier)();
        }
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, index_1.match)(types_1.TokenType.braceR) && !base_1.state.error) {
            if ((0, index_1.match)(types_1.TokenType._import)) {
                (0, index_1.next)();
                (0, statement_1.parseImport)();
            }
            else {
                (0, util_1.unexpected)();
            }
        }
        (0, util_1.expect)(types_1.TokenType.braceR);
    }
    function flowParseDeclareExportDeclaration() {
        (0, util_1.expect)(types_1.TokenType._export);
        if ((0, index_1.eat)(types_1.TokenType._default)) {
            if ((0, index_1.match)(types_1.TokenType._function) || (0, index_1.match)(types_1.TokenType._class)) {
                // declare export default class ...
                // declare export default function ...
                flowParseDeclare();
            }
            else {
                // declare export default [type];
                flowParseType();
                (0, util_1.semicolon)();
            }
        }
        else if ((0, index_1.match)(types_1.TokenType._var) || // declare export var ...
            (0, index_1.match)(types_1.TokenType._function) || // declare export function ...
            (0, index_1.match)(types_1.TokenType._class) || // declare export class ...
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._opaque) // declare export opaque ..
        ) {
            flowParseDeclare();
        }
        else if ((0, index_1.match)(types_1.TokenType.star) || // declare export * from ''
            (0, index_1.match)(types_1.TokenType.braceL) || // declare export {} ...
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._interface) || // declare export interface ...
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._type) || // declare export type ...
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._opaque) // declare export opaque type ...
        ) {
            (0, statement_1.parseExport)();
        }
        else {
            (0, util_1.unexpected)();
        }
    }
    function flowParseDeclareModuleExports() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._exports);
        flowParseTypeAnnotation();
        (0, util_1.semicolon)();
    }
    function flowParseDeclareTypeAlias() {
        (0, index_1.next)();
        flowParseTypeAlias();
    }
    function flowParseDeclareOpaqueType() {
        (0, index_1.next)();
        flowParseOpaqueType(true);
    }
    function flowParseDeclareInterface() {
        (0, index_1.next)();
        flowParseInterfaceish();
    }
    // Interfaces
    function flowParseInterfaceish(isClass = false) {
        flowParseRestrictedIdentifier();
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
        }
        if ((0, index_1.eat)(types_1.TokenType._extends)) {
            do {
                flowParseInterfaceExtends();
            } while (!isClass && (0, index_1.eat)(types_1.TokenType.comma));
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._mixins)) {
            (0, index_1.next)();
            do {
                flowParseInterfaceExtends();
            } while ((0, index_1.eat)(types_1.TokenType.comma));
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._implements)) {
            (0, index_1.next)();
            do {
                flowParseInterfaceExtends();
            } while ((0, index_1.eat)(types_1.TokenType.comma));
        }
        flowParseObjectType(isClass, false, isClass);
    }
    function flowParseInterfaceExtends() {
        flowParseQualifiedTypeIdentifier(false);
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterInstantiation();
        }
    }
    function flowParseInterface() {
        flowParseInterfaceish();
    }
    function flowParseRestrictedIdentifier() {
        (0, expression_1.parseIdentifier)();
    }
    function flowParseTypeAlias() {
        flowParseRestrictedIdentifier();
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
        }
        flowParseTypeInitialiser(types_1.TokenType.eq);
        (0, util_1.semicolon)();
    }
    function flowParseOpaqueType(declare) {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._type);
        flowParseRestrictedIdentifier();
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
        }
        // Parse the supertype
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            flowParseTypeInitialiser(types_1.TokenType.colon);
        }
        if (!declare) {
            flowParseTypeInitialiser(types_1.TokenType.eq);
        }
        (0, util_1.semicolon)();
    }
    function flowParseTypeParameter() {
        flowParseVariance();
        flowParseTypeAnnotatableIdentifier();
        if ((0, index_1.eat)(types_1.TokenType.eq)) {
            flowParseType();
        }
    }
    function flowParseTypeParameterDeclaration() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        // istanbul ignore else: this condition is already checked at all call sites
        if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.typeParameterStart)) {
            (0, index_1.next)();
        }
        else {
            (0, util_1.unexpected)();
        }
        do {
            flowParseTypeParameter();
            if (!(0, index_1.match)(types_1.TokenType.greaterThan)) {
                (0, util_1.expect)(types_1.TokenType.comma);
            }
        } while (!(0, index_1.match)(types_1.TokenType.greaterThan) && !base_1.state.error);
        (0, util_1.expect)(types_1.TokenType.greaterThan);
        (0, index_1.popTypeContext)(oldIsType);
    }
    function flowParseTypeParameterInstantiation() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(types_1.TokenType.lessThan);
        while (!(0, index_1.match)(types_1.TokenType.greaterThan) && !base_1.state.error) {
            flowParseType();
            if (!(0, index_1.match)(types_1.TokenType.greaterThan)) {
                (0, util_1.expect)(types_1.TokenType.comma);
            }
        }
        (0, util_1.expect)(types_1.TokenType.greaterThan);
        (0, index_1.popTypeContext)(oldIsType);
    }
    function flowParseInterfaceType() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._interface);
        if ((0, index_1.eat)(types_1.TokenType._extends)) {
            do {
                flowParseInterfaceExtends();
            } while ((0, index_1.eat)(types_1.TokenType.comma));
        }
        flowParseObjectType(false, false, false);
    }
    function flowParseObjectPropertyKey() {
        if ((0, index_1.match)(types_1.TokenType.num) || (0, index_1.match)(types_1.TokenType.string)) {
            (0, expression_1.parseExprAtom)();
        }
        else {
            (0, expression_1.parseIdentifier)();
        }
    }
    function flowParseObjectTypeIndexer() {
        // Note: bracketL has already been consumed
        if ((0, index_1.lookaheadType)() === types_1.TokenType.colon) {
            flowParseObjectPropertyKey();
            flowParseTypeInitialiser();
        }
        else {
            flowParseType();
        }
        (0, util_1.expect)(types_1.TokenType.bracketR);
        flowParseTypeInitialiser();
    }
    function flowParseObjectTypeInternalSlot() {
        // Note: both bracketL have already been consumed
        flowParseObjectPropertyKey();
        (0, util_1.expect)(types_1.TokenType.bracketR);
        (0, util_1.expect)(types_1.TokenType.bracketR);
        if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.parenL)) {
            flowParseObjectTypeMethodish();
        }
        else {
            (0, index_1.eat)(types_1.TokenType.question);
            flowParseTypeInitialiser();
        }
    }
    function flowParseObjectTypeMethodish() {
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
        }
        (0, util_1.expect)(types_1.TokenType.parenL);
        while (!(0, index_1.match)(types_1.TokenType.parenR) && !(0, index_1.match)(types_1.TokenType.ellipsis) && !base_1.state.error) {
            flowParseFunctionTypeParam();
            if (!(0, index_1.match)(types_1.TokenType.parenR)) {
                (0, util_1.expect)(types_1.TokenType.comma);
            }
        }
        if ((0, index_1.eat)(types_1.TokenType.ellipsis)) {
            flowParseFunctionTypeParam();
        }
        (0, util_1.expect)(types_1.TokenType.parenR);
        flowParseTypeInitialiser();
    }
    function flowParseObjectTypeCallProperty() {
        flowParseObjectTypeMethodish();
    }
    function flowParseObjectType(allowStatic, allowExact, allowProto) {
        let endDelim;
        if (allowExact && (0, index_1.match)(types_1.TokenType.braceBarL)) {
            (0, util_1.expect)(types_1.TokenType.braceBarL);
            endDelim = types_1.TokenType.braceBarR;
        }
        else {
            (0, util_1.expect)(types_1.TokenType.braceL);
            endDelim = types_1.TokenType.braceR;
        }
        while (!(0, index_1.match)(endDelim) && !base_1.state.error) {
            if (allowProto && (0, util_1.isContextual)(keywords_1.ContextualKeyword._proto)) {
                const lookahead = (0, index_1.lookaheadType)();
                if (lookahead !== types_1.TokenType.colon && lookahead !== types_1.TokenType.question) {
                    (0, index_1.next)();
                    allowStatic = false;
                }
            }
            if (allowStatic && (0, util_1.isContextual)(keywords_1.ContextualKeyword._static)) {
                const lookahead = (0, index_1.lookaheadType)();
                if (lookahead !== types_1.TokenType.colon && lookahead !== types_1.TokenType.question) {
                    (0, index_1.next)();
                }
            }
            flowParseVariance();
            if ((0, index_1.eat)(types_1.TokenType.bracketL)) {
                if ((0, index_1.eat)(types_1.TokenType.bracketL)) {
                    flowParseObjectTypeInternalSlot();
                }
                else {
                    flowParseObjectTypeIndexer();
                }
            }
            else if ((0, index_1.match)(types_1.TokenType.parenL) || (0, index_1.match)(types_1.TokenType.lessThan)) {
                flowParseObjectTypeCallProperty();
            }
            else {
                if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._get) || (0, util_1.isContextual)(keywords_1.ContextualKeyword._set)) {
                    const lookahead = (0, index_1.lookaheadType)();
                    if (lookahead === types_1.TokenType.name || lookahead === types_1.TokenType.string || lookahead === types_1.TokenType.num) {
                        (0, index_1.next)();
                    }
                }
                flowParseObjectTypeProperty();
            }
            flowObjectTypeSemicolon();
        }
        (0, util_1.expect)(endDelim);
    }
    function flowParseObjectTypeProperty() {
        if ((0, index_1.match)(types_1.TokenType.ellipsis)) {
            (0, util_1.expect)(types_1.TokenType.ellipsis);
            if (!(0, index_1.eat)(types_1.TokenType.comma)) {
                (0, index_1.eat)(types_1.TokenType.semi);
            }
            // Explicit inexact object syntax.
            if ((0, index_1.match)(types_1.TokenType.braceR)) {
                return;
            }
            flowParseType();
        }
        else {
            flowParseObjectPropertyKey();
            if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.parenL)) {
                // This is a method property
                flowParseObjectTypeMethodish();
            }
            else {
                (0, index_1.eat)(types_1.TokenType.question);
                flowParseTypeInitialiser();
            }
        }
    }
    function flowObjectTypeSemicolon() {
        if (!(0, index_1.eat)(types_1.TokenType.semi) && !(0, index_1.eat)(types_1.TokenType.comma) && !(0, index_1.match)(types_1.TokenType.braceR) && !(0, index_1.match)(types_1.TokenType.braceBarR)) {
            (0, util_1.unexpected)();
        }
    }
    function flowParseQualifiedTypeIdentifier(initialIdAlreadyParsed) {
        if (!initialIdAlreadyParsed) {
            (0, expression_1.parseIdentifier)();
        }
        while ((0, index_1.eat)(types_1.TokenType.dot)) {
            (0, expression_1.parseIdentifier)();
        }
    }
    function flowParseGenericType() {
        flowParseQualifiedTypeIdentifier(true);
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterInstantiation();
        }
    }
    function flowParseTypeofType() {
        (0, util_1.expect)(types_1.TokenType._typeof);
        flowParsePrimaryType();
    }
    function flowParseTupleType() {
        (0, util_1.expect)(types_1.TokenType.bracketL);
        // We allow trailing commas
        while (base_1.state.pos < base_1.input.length && !(0, index_1.match)(types_1.TokenType.bracketR)) {
            flowParseType();
            if ((0, index_1.match)(types_1.TokenType.bracketR)) {
                break;
            }
            (0, util_1.expect)(types_1.TokenType.comma);
        }
        (0, util_1.expect)(types_1.TokenType.bracketR);
    }
    function flowParseFunctionTypeParam() {
        const lookahead = (0, index_1.lookaheadType)();
        if (lookahead === types_1.TokenType.colon || lookahead === types_1.TokenType.question) {
            (0, expression_1.parseIdentifier)();
            (0, index_1.eat)(types_1.TokenType.question);
            flowParseTypeInitialiser();
        }
        else {
            flowParseType();
        }
    }
    function flowParseFunctionTypeParams() {
        while (!(0, index_1.match)(types_1.TokenType.parenR) && !(0, index_1.match)(types_1.TokenType.ellipsis) && !base_1.state.error) {
            flowParseFunctionTypeParam();
            if (!(0, index_1.match)(types_1.TokenType.parenR)) {
                (0, util_1.expect)(types_1.TokenType.comma);
            }
        }
        if ((0, index_1.eat)(types_1.TokenType.ellipsis)) {
            flowParseFunctionTypeParam();
        }
    }
    // The parsing of types roughly parallels the parsing of expressions, and
    // primary types are kind of like primary expressions...they're the
    // primitives with which other types are constructed.
    function flowParsePrimaryType() {
        let isGroupedType = false;
        const oldNoAnonFunctionType = base_1.state.noAnonFunctionType;
        switch (base_1.state.type) {
            case types_1.TokenType.name: {
                if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._interface)) {
                    flowParseInterfaceType();
                    return;
                }
                (0, expression_1.parseIdentifier)();
                flowParseGenericType();
                return;
            }
            case types_1.TokenType.braceL:
                flowParseObjectType(false, false, false);
                return;
            case types_1.TokenType.braceBarL:
                flowParseObjectType(false, true, false);
                return;
            case types_1.TokenType.bracketL:
                flowParseTupleType();
                return;
            case types_1.TokenType.lessThan:
                flowParseTypeParameterDeclaration();
                (0, util_1.expect)(types_1.TokenType.parenL);
                flowParseFunctionTypeParams();
                (0, util_1.expect)(types_1.TokenType.parenR);
                (0, util_1.expect)(types_1.TokenType.arrow);
                flowParseType();
                return;
            case types_1.TokenType.parenL:
                (0, index_1.next)();
                // Check to see if this is actually a grouped type
                if (!(0, index_1.match)(types_1.TokenType.parenR) && !(0, index_1.match)(types_1.TokenType.ellipsis)) {
                    if ((0, index_1.match)(types_1.TokenType.name)) {
                        const token = (0, index_1.lookaheadType)();
                        isGroupedType = token !== types_1.TokenType.question && token !== types_1.TokenType.colon;
                    }
                    else {
                        isGroupedType = true;
                    }
                }
                if (isGroupedType) {
                    base_1.state.noAnonFunctionType = false;
                    flowParseType();
                    base_1.state.noAnonFunctionType = oldNoAnonFunctionType;
                    // A `,` or a `) =>` means this is an anonymous function type
                    if (base_1.state.noAnonFunctionType ||
                        !((0, index_1.match)(types_1.TokenType.comma) || ((0, index_1.match)(types_1.TokenType.parenR) && (0, index_1.lookaheadType)() === types_1.TokenType.arrow))) {
                        (0, util_1.expect)(types_1.TokenType.parenR);
                        return;
                    }
                    else {
                        // Eat a comma if there is one
                        (0, index_1.eat)(types_1.TokenType.comma);
                    }
                }
                flowParseFunctionTypeParams();
                (0, util_1.expect)(types_1.TokenType.parenR);
                (0, util_1.expect)(types_1.TokenType.arrow);
                flowParseType();
                return;
            case types_1.TokenType.minus:
                (0, index_1.next)();
                (0, expression_1.parseLiteral)();
                return;
            case types_1.TokenType.string:
            case types_1.TokenType.num:
            case types_1.TokenType._true:
            case types_1.TokenType._false:
            case types_1.TokenType._null:
            case types_1.TokenType._this:
            case types_1.TokenType._void:
            case types_1.TokenType.star:
                (0, index_1.next)();
                return;
            default:
                if (base_1.state.type === types_1.TokenType._typeof) {
                    flowParseTypeofType();
                    return;
                }
                else if (base_1.state.type & types_1.TokenType.IS_KEYWORD) {
                    (0, index_1.next)();
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType.name;
                    return;
                }
        }
        (0, util_1.unexpected)();
    }
    function flowParsePostfixType() {
        flowParsePrimaryType();
        while (!(0, util_1.canInsertSemicolon)() && ((0, index_1.match)(types_1.TokenType.bracketL) || (0, index_1.match)(types_1.TokenType.questionDot))) {
            (0, index_1.eat)(types_1.TokenType.questionDot);
            (0, util_1.expect)(types_1.TokenType.bracketL);
            if ((0, index_1.eat)(types_1.TokenType.bracketR)) {
                // Array type
            }
            else {
                // Indexed access type
                flowParseType();
                (0, util_1.expect)(types_1.TokenType.bracketR);
            }
        }
    }
    function flowParsePrefixType() {
        if ((0, index_1.eat)(types_1.TokenType.question)) {
            flowParsePrefixType();
        }
        else {
            flowParsePostfixType();
        }
    }
    function flowParseAnonFunctionWithoutParens() {
        flowParsePrefixType();
        if (!base_1.state.noAnonFunctionType && (0, index_1.eat)(types_1.TokenType.arrow)) {
            flowParseType();
        }
    }
    function flowParseIntersectionType() {
        (0, index_1.eat)(types_1.TokenType.bitwiseAND);
        flowParseAnonFunctionWithoutParens();
        while ((0, index_1.eat)(types_1.TokenType.bitwiseAND)) {
            flowParseAnonFunctionWithoutParens();
        }
    }
    function flowParseUnionType() {
        (0, index_1.eat)(types_1.TokenType.bitwiseOR);
        flowParseIntersectionType();
        while ((0, index_1.eat)(types_1.TokenType.bitwiseOR)) {
            flowParseIntersectionType();
        }
    }
    function flowParseType() {
        flowParseUnionType();
    }
    function flowParseTypeAnnotation() {
        flowParseTypeInitialiser();
    }
    function flowParseTypeAnnotatableIdentifier() {
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            flowParseTypeAnnotation();
        }
    }
    function flowParseVariance() {
        if ((0, index_1.match)(types_1.TokenType.plus) || (0, index_1.match)(types_1.TokenType.minus)) {
            (0, index_1.next)();
            base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
        }
    }
    // ==================================
    // Overrides
    // ==================================
    function flowParseFunctionBodyAndFinish(funcContextId) {
        // For arrow functions, `parseArrow` handles the return type itself.
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            flowParseTypeAndPredicateInitialiser();
        }
        (0, expression_1.parseFunctionBody)(false, funcContextId);
    }
    function flowParseSubscript(startTokenIndex, noCalls, stopState) {
        if ((0, index_1.match)(types_1.TokenType.questionDot) && (0, index_1.lookaheadType)() === types_1.TokenType.lessThan) {
            if (noCalls) {
                stopState.stop = true;
                return;
            }
            (0, index_1.next)();
            flowParseTypeParameterInstantiation();
            (0, util_1.expect)(types_1.TokenType.parenL);
            (0, expression_1.parseCallExpressionArguments)();
            return;
        }
        else if (!noCalls && (0, index_1.match)(types_1.TokenType.lessThan)) {
            const snapshot = base_1.state.snapshot();
            flowParseTypeParameterInstantiation();
            (0, util_1.expect)(types_1.TokenType.parenL);
            (0, expression_1.parseCallExpressionArguments)();
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
            else {
                return;
            }
        }
        (0, expression_1.baseParseSubscript)(startTokenIndex, noCalls, stopState);
    }
    function flowStartParseNewArguments() {
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            const snapshot = base_1.state.snapshot();
            flowParseTypeParameterInstantiation();
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
        }
    }
    // interfaces
    function flowTryParseStatement() {
        if ((0, index_1.match)(types_1.TokenType.name) && base_1.state.contextualKeyword === keywords_1.ContextualKeyword._interface) {
            const oldIsType = (0, index_1.pushTypeContext)(0);
            (0, index_1.next)();
            flowParseInterface();
            (0, index_1.popTypeContext)(oldIsType);
            return true;
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._enum)) {
            flowParseEnumDeclaration();
            return true;
        }
        return false;
    }
    function flowTryParseExportDefaultExpression() {
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._enum)) {
            flowParseEnumDeclaration();
            return true;
        }
        return false;
    }
    // declares, interfaces and type aliases
    function flowParseIdentifierStatement(contextualKeyword) {
        if (contextualKeyword === keywords_1.ContextualKeyword._declare) {
            if ((0, index_1.match)(types_1.TokenType._class) ||
                (0, index_1.match)(types_1.TokenType.name) ||
                (0, index_1.match)(types_1.TokenType._function) ||
                (0, index_1.match)(types_1.TokenType._var) ||
                (0, index_1.match)(types_1.TokenType._export)) {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                flowParseDeclare();
                (0, index_1.popTypeContext)(oldIsType);
            }
        }
        else if ((0, index_1.match)(types_1.TokenType.name)) {
            if (contextualKeyword === keywords_1.ContextualKeyword._interface) {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                flowParseInterface();
                (0, index_1.popTypeContext)(oldIsType);
            }
            else if (contextualKeyword === keywords_1.ContextualKeyword._type) {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                flowParseTypeAlias();
                (0, index_1.popTypeContext)(oldIsType);
            }
            else if (contextualKeyword === keywords_1.ContextualKeyword._opaque) {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                flowParseOpaqueType(false);
                (0, index_1.popTypeContext)(oldIsType);
            }
        }
        (0, util_1.semicolon)();
    }
    // export type
    function flowShouldParseExportDeclaration() {
        return ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type) ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._interface) ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._opaque) ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._enum));
    }
    function flowShouldDisallowExportDefaultSpecifier() {
        return ((0, index_1.match)(types_1.TokenType.name) &&
            (base_1.state.contextualKeyword === keywords_1.ContextualKeyword._type ||
                base_1.state.contextualKeyword === keywords_1.ContextualKeyword._interface ||
                base_1.state.contextualKeyword === keywords_1.ContextualKeyword._opaque ||
                base_1.state.contextualKeyword === keywords_1.ContextualKeyword._enum));
    }
    function flowParseExportDeclaration() {
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type)) {
            const oldIsType = (0, index_1.pushTypeContext)(1);
            (0, index_1.next)();
            if ((0, index_1.match)(types_1.TokenType.braceL)) {
                // export type { foo, bar };
                (0, statement_1.parseExportSpecifiers)();
                (0, statement_1.parseExportFrom)();
            }
            else {
                // export type Foo = Bar;
                flowParseTypeAlias();
            }
            (0, index_1.popTypeContext)(oldIsType);
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._opaque)) {
            const oldIsType = (0, index_1.pushTypeContext)(1);
            (0, index_1.next)();
            // export opaque type Foo = Bar;
            flowParseOpaqueType(false);
            (0, index_1.popTypeContext)(oldIsType);
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._interface)) {
            const oldIsType = (0, index_1.pushTypeContext)(1);
            (0, index_1.next)();
            flowParseInterface();
            (0, index_1.popTypeContext)(oldIsType);
        }
        else {
            (0, statement_1.parseStatement)(true);
        }
    }
    function flowShouldParseExportStar() {
        return (0, index_1.match)(types_1.TokenType.star) || ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type) && (0, index_1.lookaheadType)() === types_1.TokenType.star);
    }
    function flowParseExportStar() {
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._type)) {
            const oldIsType = (0, index_1.pushTypeContext)(2);
            (0, statement_1.baseParseExportStar)();
            (0, index_1.popTypeContext)(oldIsType);
        }
        else {
            (0, statement_1.baseParseExportStar)();
        }
    }
    // parse a the super class type parameters and implements
    function flowAfterParseClassSuper(hasSuper) {
        if (hasSuper && (0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterInstantiation();
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._implements)) {
            const oldIsType = (0, index_1.pushTypeContext)(0);
            (0, index_1.next)();
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._implements;
            do {
                flowParseRestrictedIdentifier();
                if ((0, index_1.match)(types_1.TokenType.lessThan)) {
                    flowParseTypeParameterInstantiation();
                }
            } while ((0, index_1.eat)(types_1.TokenType.comma));
            (0, index_1.popTypeContext)(oldIsType);
        }
    }
    // parse type parameters for object method shorthand
    function flowStartParseObjPropValue() {
        // method shorthand
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            flowParseTypeParameterDeclaration();
            if (!(0, index_1.match)(types_1.TokenType.parenL))
                (0, util_1.unexpected)();
        }
    }
    function flowParseAssignableListItemTypes() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, index_1.eat)(types_1.TokenType.question);
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            flowParseTypeAnnotation();
        }
        (0, index_1.popTypeContext)(oldIsType);
    }
    // parse typeof and type imports
    function flowStartParseImportSpecifiers() {
        if ((0, index_1.match)(types_1.TokenType._typeof) || (0, util_1.isContextual)(keywords_1.ContextualKeyword._type)) {
            const lh = (0, index_1.lookaheadTypeAndKeyword)();
            if (isMaybeDefaultImport(lh) || lh.type === types_1.TokenType.braceL || lh.type === types_1.TokenType.star) {
                (0, index_1.next)();
            }
        }
    }
    // parse import-type/typeof shorthand
    function flowParseImportSpecifier() {
        const isTypeKeyword = base_1.state.contextualKeyword === keywords_1.ContextualKeyword._type || base_1.state.type === types_1.TokenType._typeof;
        if (isTypeKeyword) {
            (0, index_1.next)();
        }
        else {
            (0, expression_1.parseIdentifier)();
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._as) && !(0, util_1.isLookaheadContextual)(keywords_1.ContextualKeyword._as)) {
            (0, expression_1.parseIdentifier)();
            if (isTypeKeyword && !(0, index_1.match)(types_1.TokenType.name) && !(base_1.state.type & types_1.TokenType.IS_KEYWORD)) {
                // `import {type as ,` or `import {type as }`
            }
            else {
                // `import {type as foo`
                (0, expression_1.parseIdentifier)();
            }
        }
        else {
            if (isTypeKeyword && ((0, index_1.match)(types_1.TokenType.name) || !!(base_1.state.type & types_1.TokenType.IS_KEYWORD))) {
                // `import {type foo`
                (0, expression_1.parseIdentifier)();
            }
            if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._as)) {
                (0, expression_1.parseIdentifier)();
            }
        }
    }
    // parse function type parameters - function foo<T>() {}
    function flowStartParseFunctionParams() {
        // Originally this checked if the method is a getter/setter, but if it was, we'd crash soon
        // anyway, so don't try to propagate that information.
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            const oldIsType = (0, index_1.pushTypeContext)(0);
            flowParseTypeParameterDeclaration();
            (0, index_1.popTypeContext)(oldIsType);
        }
    }
    // parse flow type annotations on variable declarator heads - let foo: string = bar
    function flowAfterParseVarHead() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            flowParseTypeAnnotation();
        }
    }
    // parse the return type of an async arrow function - let foo = (async (): number => {});
    function flowStartParseAsyncArrowFromCallExpression() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            const oldNoAnonFunctionType = base_1.state.noAnonFunctionType;
            base_1.state.noAnonFunctionType = true;
            flowParseTypeAnnotation();
            base_1.state.noAnonFunctionType = oldNoAnonFunctionType;
        }
    }
    // We need to support type parameter declarations for arrow functions. This
    // is tricky. There are three situations we need to handle
    //
    // 1. This is either JSX or an arrow function. We'll try JSX first. If that
    //    fails, we'll try an arrow function. If that fails, we'll throw the JSX
    //    error.
    // 2. This is an arrow function. We'll parse the type parameter declaration,
    //    parse the rest, make sure the rest is an arrow function, and go from
    //    there
    // 3. This is neither. Just call the super method
    function flowParseMaybeAssign(noIn, isWithinParens) {
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            const snapshot = base_1.state.snapshot();
            let wasArrow = (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
                base_1.state.type = types_1.TokenType.typeParameterStart;
            }
            else {
                return wasArrow;
            }
            const oldIsType = (0, index_1.pushTypeContext)(0);
            flowParseTypeParameterDeclaration();
            (0, index_1.popTypeContext)(oldIsType);
            wasArrow = (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
            if (wasArrow) {
                return true;
            }
            (0, util_1.unexpected)();
        }
        return (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
    }
    // handle return types for arrow functions
    function flowParseArrow() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            const oldIsType = (0, index_1.pushTypeContext)(0);
            const snapshot = base_1.state.snapshot();
            const oldNoAnonFunctionType = base_1.state.noAnonFunctionType;
            base_1.state.noAnonFunctionType = true;
            flowParseTypeAndPredicateInitialiser();
            base_1.state.noAnonFunctionType = oldNoAnonFunctionType;
            if ((0, util_1.canInsertSemicolon)())
                (0, util_1.unexpected)();
            if (!(0, index_1.match)(types_1.TokenType.arrow))
                (0, util_1.unexpected)();
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
            (0, index_1.popTypeContext)(oldIsType);
        }
        return (0, index_1.eat)(types_1.TokenType.arrow);
    }
    function flowParseSubscripts(startTokenIndex, noCalls = false) {
        if (base_1.state.tokens[base_1.state.tokens.length - 1].contextualKeyword === keywords_1.ContextualKeyword._async &&
            (0, index_1.match)(types_1.TokenType.lessThan)) {
            const snapshot = base_1.state.snapshot();
            const wasArrow = parseAsyncArrowWithTypeParameters();
            if (wasArrow && !base_1.state.error) {
                return;
            }
            base_1.state.restoreFromSnapshot(snapshot);
        }
        (0, expression_1.baseParseSubscripts)(startTokenIndex, noCalls);
    }
    // Returns true if there was an arrow function here.
    function parseAsyncArrowWithTypeParameters() {
        base_1.state.scopeDepth++;
        const startTokenIndex = base_1.state.tokens.length;
        (0, statement_1.parseFunctionParams)();
        if (!(0, expression_1.parseArrow)()) {
            return false;
        }
        (0, expression_1.parseArrowExpression)(startTokenIndex);
        return true;
    }
    function flowParseEnumDeclaration() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._enum);
        base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._enum;
        (0, expression_1.parseIdentifier)();
        flowParseEnumBody();
    }
    function flowParseEnumBody() {
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._of)) {
            (0, index_1.next)();
        }
        (0, util_1.expect)(types_1.TokenType.braceL);
        flowParseEnumMembers();
        (0, util_1.expect)(types_1.TokenType.braceR);
    }
    function flowParseEnumMembers() {
        while (!(0, index_1.match)(types_1.TokenType.braceR) && !base_1.state.error) {
            if ((0, index_1.eat)(types_1.TokenType.ellipsis)) {
                break;
            }
            flowParseEnumMember();
            if (!(0, index_1.match)(types_1.TokenType.braceR)) {
                (0, util_1.expect)(types_1.TokenType.comma);
            }
        }
    }
    function flowParseEnumMember() {
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.eat)(types_1.TokenType.eq)) {
            // Flow enum values are always just one token (a string, number, or boolean literal).
            (0, index_1.next)();
        }
    }
},
"8178e7c3c8": /* sucrase\dist\esm\parser\traverser\expression.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parseExpression = parseExpression;
    exports.parseMaybeAssign = parseMaybeAssign;
    exports.baseParseMaybeAssign = baseParseMaybeAssign;
    exports.baseParseConditional = baseParseConditional;
    exports.parseMaybeUnary = parseMaybeUnary;
    exports.parseExprSubscripts = parseExprSubscripts;
    exports.baseParseSubscripts = baseParseSubscripts;
    exports.baseParseSubscript = baseParseSubscript;
    exports.atPossibleAsync = atPossibleAsync;
    exports.parseCallExpressionArguments = parseCallExpressionArguments;
    exports.parseExprAtom = parseExprAtom;
    exports.parseLiteral = parseLiteral;
    exports.parseParenExpression = parseParenExpression;
    exports.parseArrow = parseArrow;
    exports.parseTemplate = parseTemplate;
    exports.parseObj = parseObj;
    exports.parsePropertyName = parsePropertyName;
    exports.parseMethod = parseMethod;
    exports.parseArrowExpression = parseArrowExpression;
    exports.parseFunctionBodyAndFinish = parseFunctionBodyAndFinish;
    exports.parseFunctionBody = parseFunctionBody;
    exports.parseIdentifier = parseIdentifier;
    // A recursive descent parser operates by defining functions for all
    // syntactic elements, and recursively calling those, each function
    // advancing the input stream and returning an AST node. Precedence
    // of constructs (for example, the fact that `!x[1]` means `!(x[1])`
    // instead of `(!x)[1]` is handled by the fact that the parser
    // function that parses unary prefix operators is called first, and
    // in turn calls the function that parses `[]` subscripts — that
    // way, it'll receive the node for `x[1]` already parsed, and wraps
    // *that* in the unary operator node.
    //
    // Acorn uses an [operator precedence parser][opp] to handle binary
    // operator precedence, because it is much more compact than using
    // the technique outlined above, which uses different, nesting
    // functions to specify precedence, for all of the ten binary
    // precedence levels that JavaScript defines.
    //
    // [opp]: http://en.wikipedia.org/wiki/Operator-precedence_parser
    const flow_1 = require("9b8d43cd0a") /* ../plugins/flow */;
    const index_1 = require("d7708a7d24") /* ../plugins/jsx/index */;
    const types_1 = require("85c51351f6") /* ../plugins/types */;
    const typescript_1 = require("6a970c22b9") /* ../plugins/typescript */;
    const index_2 = require("bfb18d0576") /* ../tokenizer/index */;
    const keywords_1 = require("99ff836c64") /* ../tokenizer/keywords */;
    const state_1 = require("eda46439d5") /* ../tokenizer/state */;
    const types_2 = require("f0c35cbd76") /* ../tokenizer/types */;
    const charcodes_1 = require("22746c8ce8") /* ../util/charcodes */;
    const identifier_1 = require("364148c9f0") /* ../util/identifier */;
    const base_1 = require("540718e523") /* ./base */;
    const lval_1 = require("4cefc59e67") /* ./lval */;
    const statement_1 = require("e3b9989da1") /* ./statement */;
    const util_1 = require("bc94bbadc1") /* ./util */;
    class StopState {
        constructor(stop) {
            this.stop = stop;
        }
    }
    exports.StopState = StopState;
    // ### Expression parsing
    // These nest, from the most general expression type at the top to
    // 'atomic', nondivisible expression types at the bottom. Most of
    // the functions will simply let the function (s) below them parse,
    // and, *if* the syntactic construct they handle is present, wrap
    // the AST node that the inner parser gave them in another node.
    function parseExpression(noIn = false) {
        parseMaybeAssign(noIn);
        if ((0, index_2.match)(types_2.TokenType.comma)) {
            while ((0, index_2.eat)(types_2.TokenType.comma)) {
                parseMaybeAssign(noIn);
            }
        }
    }
    /**
     * noIn is used when parsing a for loop so that we don't interpret a following "in" as the binary
     * operatior.
     * isWithinParens is used to indicate that we're parsing something that might be a comma expression
     * or might be an arrow function or might be a Flow type assertion (which requires explicit parens).
     * In these cases, we should allow : and ?: after the initial "left" part.
     */
    function parseMaybeAssign(noIn = false, isWithinParens = false) {
        if (base_1.isTypeScriptEnabled) {
            return (0, typescript_1.tsParseMaybeAssign)(noIn, isWithinParens);
        }
        else if (base_1.isFlowEnabled) {
            return (0, flow_1.flowParseMaybeAssign)(noIn, isWithinParens);
        }
        else {
            return baseParseMaybeAssign(noIn, isWithinParens);
        }
    }
    // Parse an assignment expression. This includes applications of
    // operators like `+=`.
    // Returns true if the expression was an arrow function.
    function baseParseMaybeAssign(noIn, isWithinParens) {
        if ((0, index_2.match)(types_2.TokenType._yield)) {
            parseYield();
            return false;
        }
        if ((0, index_2.match)(types_2.TokenType.parenL) || (0, index_2.match)(types_2.TokenType.name) || (0, index_2.match)(types_2.TokenType._yield)) {
            base_1.state.potentialArrowAt = base_1.state.start;
        }
        const wasArrow = parseMaybeConditional(noIn);
        if (isWithinParens) {
            parseParenItem();
        }
        if (base_1.state.type & types_2.TokenType.IS_ASSIGN) {
            (0, index_2.next)();
            parseMaybeAssign(noIn);
            return false;
        }
        return wasArrow;
    }
    // Parse a ternary conditional (`?:`) operator.
    // Returns true if the expression was an arrow function.
    function parseMaybeConditional(noIn) {
        const wasArrow = parseExprOps(noIn);
        if (wasArrow) {
            return true;
        }
        parseConditional(noIn);
        return false;
    }
    function parseConditional(noIn) {
        if (base_1.isTypeScriptEnabled || base_1.isFlowEnabled) {
            (0, types_1.typedParseConditional)(noIn);
        }
        else {
            baseParseConditional(noIn);
        }
    }
    function baseParseConditional(noIn) {
        if ((0, index_2.eat)(types_2.TokenType.question)) {
            parseMaybeAssign();
            (0, util_1.expect)(types_2.TokenType.colon);
            parseMaybeAssign(noIn);
        }
    }
    // Start the precedence parser.
    // Returns true if this was an arrow function
    function parseExprOps(noIn) {
        const startTokenIndex = base_1.state.tokens.length;
        const wasArrow = parseMaybeUnary();
        if (wasArrow) {
            return true;
        }
        parseExprOp(startTokenIndex, -1, noIn);
        return false;
    }
    // Parse binary operators with the operator precedence parsing
    // algorithm. `left` is the left-hand side of the operator.
    // `minPrec` provides context that allows the function to stop and
    // defer further parser to one of its callers when it encounters an
    // operator that has a lower precedence than the set it is parsing.
    function parseExprOp(startTokenIndex, minPrec, noIn) {
        if (base_1.isTypeScriptEnabled &&
            (types_2.TokenType._in & types_2.TokenType.PRECEDENCE_MASK) > minPrec &&
            !(0, util_1.hasPrecedingLineBreak)() &&
            ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._as) || (0, util_1.eatContextual)(keywords_1.ContextualKeyword._satisfies))) {
            const oldIsType = (0, index_2.pushTypeContext)(1);
            (0, typescript_1.tsParseType)();
            (0, index_2.popTypeContext)(oldIsType);
            (0, index_2.rescan_gt)();
            parseExprOp(startTokenIndex, minPrec, noIn);
            return;
        }
        const prec = base_1.state.type & types_2.TokenType.PRECEDENCE_MASK;
        if (prec > 0 && (!noIn || !(0, index_2.match)(types_2.TokenType._in))) {
            if (prec > minPrec) {
                const op = base_1.state.type;
                (0, index_2.next)();
                if (op === types_2.TokenType.nullishCoalescing) {
                    base_1.state.tokens[base_1.state.tokens.length - 1].nullishStartIndex = startTokenIndex;
                }
                const rhsStartTokenIndex = base_1.state.tokens.length;
                parseMaybeUnary();
                // Extend the right operand of this operator if possible.
                parseExprOp(rhsStartTokenIndex, op & types_2.TokenType.IS_RIGHT_ASSOCIATIVE ? prec - 1 : prec, noIn);
                if (op === types_2.TokenType.nullishCoalescing) {
                    base_1.state.tokens[startTokenIndex].numNullishCoalesceStarts++;
                    base_1.state.tokens[base_1.state.tokens.length - 1].numNullishCoalesceEnds++;
                }
                // Continue with any future operator holding this expression as the left operand.
                parseExprOp(startTokenIndex, minPrec, noIn);
            }
        }
    }
    // Parse unary operators, both prefix and postfix.
    // Returns true if this was an arrow function.
    function parseMaybeUnary() {
        if (base_1.isTypeScriptEnabled && !base_1.isJSXEnabled && (0, index_2.eat)(types_2.TokenType.lessThan)) {
            (0, typescript_1.tsParseTypeAssertion)();
            return false;
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._module) &&
            (0, index_2.lookaheadCharCode)() === charcodes_1.charCodes.leftCurlyBrace &&
            !(0, util_1.hasFollowingLineBreak)()) {
            parseModuleExpression();
            return false;
        }
        if (base_1.state.type & types_2.TokenType.IS_PREFIX) {
            (0, index_2.next)();
            parseMaybeUnary();
            return false;
        }
        const wasArrow = parseExprSubscripts();
        if (wasArrow) {
            return true;
        }
        while (base_1.state.type & types_2.TokenType.IS_POSTFIX && !(0, util_1.canInsertSemicolon)()) {
            // The tokenizer calls everything a preincrement, so make it a postincrement when
            // we see it in that context.
            if (base_1.state.type === types_2.TokenType.preIncDec) {
                base_1.state.type = types_2.TokenType.postIncDec;
            }
            (0, index_2.next)();
        }
        return false;
    }
    // Parse call, dot, and `[]`-subscript expressions.
    // Returns true if this was an arrow function.
    function parseExprSubscripts() {
        const startTokenIndex = base_1.state.tokens.length;
        const wasArrow = parseExprAtom();
        if (wasArrow) {
            return true;
        }
        parseSubscripts(startTokenIndex);
        // If there was any optional chain operation, the start token would be marked
        // as such, so also mark the end now.
        if (base_1.state.tokens.length > startTokenIndex && base_1.state.tokens[startTokenIndex].isOptionalChainStart) {
            base_1.state.tokens[base_1.state.tokens.length - 1].isOptionalChainEnd = true;
        }
        return false;
    }
    function parseSubscripts(startTokenIndex, noCalls = false) {
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseSubscripts)(startTokenIndex, noCalls);
        }
        else {
            baseParseSubscripts(startTokenIndex, noCalls);
        }
    }
    function baseParseSubscripts(startTokenIndex, noCalls = false) {
        const stopState = new StopState(false);
        do {
            parseSubscript(startTokenIndex, noCalls, stopState);
        } while (!stopState.stop && !base_1.state.error);
    }
    function parseSubscript(startTokenIndex, noCalls, stopState) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseSubscript)(startTokenIndex, noCalls, stopState);
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseSubscript)(startTokenIndex, noCalls, stopState);
        }
        else {
            baseParseSubscript(startTokenIndex, noCalls, stopState);
        }
    }
    /** Set 'state.stop = true' to indicate that we should stop parsing subscripts. */
    function baseParseSubscript(startTokenIndex, noCalls, stopState) {
        if (!noCalls && (0, index_2.eat)(types_2.TokenType.doubleColon)) {
            parseNoCallExpr();
            stopState.stop = true;
            // Propagate startTokenIndex so that `a::b?.()` will keep `a` as the first token. We may want
            // to revisit this in the future when fully supporting bind syntax.
            parseSubscripts(startTokenIndex, noCalls);
        }
        else if ((0, index_2.match)(types_2.TokenType.questionDot)) {
            base_1.state.tokens[startTokenIndex].isOptionalChainStart = true;
            if (noCalls && (0, index_2.lookaheadType)() === types_2.TokenType.parenL) {
                stopState.stop = true;
                return;
            }
            (0, index_2.next)();
            base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
            if ((0, index_2.eat)(types_2.TokenType.bracketL)) {
                parseExpression();
                (0, util_1.expect)(types_2.TokenType.bracketR);
            }
            else if ((0, index_2.eat)(types_2.TokenType.parenL)) {
                parseCallExpressionArguments();
            }
            else {
                parseMaybePrivateName();
            }
        }
        else if ((0, index_2.eat)(types_2.TokenType.dot)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
            parseMaybePrivateName();
        }
        else if ((0, index_2.eat)(types_2.TokenType.bracketL)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
            parseExpression();
            (0, util_1.expect)(types_2.TokenType.bracketR);
        }
        else if (!noCalls && (0, index_2.match)(types_2.TokenType.parenL)) {
            if (atPossibleAsync()) {
                // We see "async", but it's possible it's a usage of the name "async". Parse as if it's a
                // function call, and if we see an arrow later, backtrack and re-parse as a parameter list.
                const snapshot = base_1.state.snapshot();
                const asyncStartTokenIndex = base_1.state.tokens.length;
                (0, index_2.next)();
                base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
                const callContextId = (0, base_1.getNextContextId)();
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = callContextId;
                parseCallExpressionArguments();
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = callContextId;
                if (shouldParseAsyncArrow()) {
                    // We hit an arrow, so backtrack and start again parsing function parameters.
                    base_1.state.restoreFromSnapshot(snapshot);
                    stopState.stop = true;
                    base_1.state.scopeDepth++;
                    (0, statement_1.parseFunctionParams)();
                    parseAsyncArrowFromCallExpression(asyncStartTokenIndex);
                }
            }
            else {
                (0, index_2.next)();
                base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
                const callContextId = (0, base_1.getNextContextId)();
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = callContextId;
                parseCallExpressionArguments();
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = callContextId;
            }
        }
        else if ((0, index_2.match)(types_2.TokenType.backQuote)) {
            // Tagged template expression.
            parseTemplate();
        }
        else {
            stopState.stop = true;
        }
    }
    function atPossibleAsync() {
        // This was made less strict than the original version to avoid passing around nodes, but it
        // should be safe to have rare false positives here.
        return (base_1.state.tokens[base_1.state.tokens.length - 1].contextualKeyword === keywords_1.ContextualKeyword._async &&
            !(0, util_1.canInsertSemicolon)());
    }
    function parseCallExpressionArguments() {
        let first = true;
        while (!(0, index_2.eat)(types_2.TokenType.parenR) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_2.TokenType.comma);
                if ((0, index_2.eat)(types_2.TokenType.parenR)) {
                    break;
                }
            }
            parseExprListItem(false);
        }
    }
    function shouldParseAsyncArrow() {
        return (0, index_2.match)(types_2.TokenType.colon) || (0, index_2.match)(types_2.TokenType.arrow);
    }
    function parseAsyncArrowFromCallExpression(startTokenIndex) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsStartParseAsyncArrowFromCallExpression)();
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowStartParseAsyncArrowFromCallExpression)();
        }
        (0, util_1.expect)(types_2.TokenType.arrow);
        parseArrowExpression(startTokenIndex);
    }
    // Parse a no-call expression (like argument of `new` or `::` operators).
    function parseNoCallExpr() {
        const startTokenIndex = base_1.state.tokens.length;
        parseExprAtom();
        parseSubscripts(startTokenIndex, true);
    }
    // Parse an atomic expression — either a single token that is an
    // expression, an expression started by a keyword like `function` or
    // `new`, or an expression wrapped in punctuation like `()`, `[]`,
    // or `{}`.
    // Returns true if the parsed expression was an arrow function.
    function parseExprAtom() {
        if ((0, index_2.eat)(types_2.TokenType.modulo)) {
            // V8 intrinsic expression. Just parse the identifier, and the function invocation is parsed
            // naturally.
            parseIdentifier();
            return false;
        }
        if ((0, index_2.match)(types_2.TokenType.jsxText) || (0, index_2.match)(types_2.TokenType.jsxEmptyText)) {
            parseLiteral();
            return false;
        }
        else if ((0, index_2.match)(types_2.TokenType.lessThan) && base_1.isJSXEnabled) {
            base_1.state.type = types_2.TokenType.jsxTagStart;
            (0, index_1.jsxParseElement)();
            (0, index_2.next)();
            return false;
        }
        const canBeArrow = base_1.state.potentialArrowAt === base_1.state.start;
        switch (base_1.state.type) {
            case types_2.TokenType.slash:
            case types_2.TokenType.assign:
                (0, index_2.retokenizeSlashAsRegex)();
            // Fall through.
            case types_2.TokenType._super:
            case types_2.TokenType._this:
            case types_2.TokenType.regexp:
            case types_2.TokenType.num:
            case types_2.TokenType.bigint:
            case types_2.TokenType.decimal:
            case types_2.TokenType.string:
            case types_2.TokenType._null:
            case types_2.TokenType._true:
            case types_2.TokenType._false:
                (0, index_2.next)();
                return false;
            case types_2.TokenType._import:
                (0, index_2.next)();
                if ((0, index_2.match)(types_2.TokenType.dot)) {
                    // import.meta
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_2.TokenType.name;
                    (0, index_2.next)();
                    parseIdentifier();
                }
                return false;
            case types_2.TokenType.name: {
                const startTokenIndex = base_1.state.tokens.length;
                const functionStart = base_1.state.start;
                const contextualKeyword = base_1.state.contextualKeyword;
                parseIdentifier();
                if (contextualKeyword === keywords_1.ContextualKeyword._await) {
                    parseAwait();
                    return false;
                }
                else if (contextualKeyword === keywords_1.ContextualKeyword._async &&
                    (0, index_2.match)(types_2.TokenType._function) &&
                    !(0, util_1.canInsertSemicolon)()) {
                    (0, index_2.next)();
                    (0, statement_1.parseFunction)(functionStart, false);
                    return false;
                }
                else if (canBeArrow &&
                    contextualKeyword === keywords_1.ContextualKeyword._async &&
                    !(0, util_1.canInsertSemicolon)() &&
                    (0, index_2.match)(types_2.TokenType.name)) {
                    base_1.state.scopeDepth++;
                    (0, lval_1.parseBindingIdentifier)(false);
                    (0, util_1.expect)(types_2.TokenType.arrow);
                    // let foo = async bar => {};
                    parseArrowExpression(startTokenIndex);
                    return true;
                }
                else if ((0, index_2.match)(types_2.TokenType._do) && !(0, util_1.canInsertSemicolon)()) {
                    (0, index_2.next)();
                    (0, statement_1.parseBlock)();
                    return false;
                }
                if (canBeArrow && !(0, util_1.canInsertSemicolon)() && (0, index_2.match)(types_2.TokenType.arrow)) {
                    base_1.state.scopeDepth++;
                    (0, lval_1.markPriorBindingIdentifier)(false);
                    (0, util_1.expect)(types_2.TokenType.arrow);
                    parseArrowExpression(startTokenIndex);
                    return true;
                }
                base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_2.IdentifierRole.Access;
                return false;
            }
            case types_2.TokenType._do: {
                (0, index_2.next)();
                (0, statement_1.parseBlock)();
                return false;
            }
            case types_2.TokenType.parenL: {
                const wasArrow = parseParenAndDistinguishExpression(canBeArrow);
                return wasArrow;
            }
            case types_2.TokenType.bracketL:
                (0, index_2.next)();
                parseExprList(types_2.TokenType.bracketR, true);
                return false;
            case types_2.TokenType.braceL:
                parseObj(false, false);
                return false;
            case types_2.TokenType._function:
                parseFunctionExpression();
                return false;
            case types_2.TokenType.at:
                (0, statement_1.parseDecorators)();
            // Fall through.
            case types_2.TokenType._class:
                (0, statement_1.parseClass)(false);
                return false;
            case types_2.TokenType._new:
                parseNew();
                return false;
            case types_2.TokenType.backQuote:
                parseTemplate();
                return false;
            case types_2.TokenType.doubleColon: {
                (0, index_2.next)();
                parseNoCallExpr();
                return false;
            }
            case types_2.TokenType.hash: {
                const code = (0, index_2.lookaheadCharCode)();
                if (identifier_1.IS_IDENTIFIER_START[code] || code === charcodes_1.charCodes.backslash) {
                    parseMaybePrivateName();
                }
                else {
                    (0, index_2.next)();
                }
                // Smart pipeline topic reference.
                return false;
            }
            default:
                (0, util_1.unexpected)();
                return false;
        }
    }
    function parseMaybePrivateName() {
        (0, index_2.eat)(types_2.TokenType.hash);
        parseIdentifier();
    }
    function parseFunctionExpression() {
        const functionStart = base_1.state.start;
        parseIdentifier();
        if ((0, index_2.eat)(types_2.TokenType.dot)) {
            // function.sent
            parseIdentifier();
        }
        (0, statement_1.parseFunction)(functionStart, false);
    }
    function parseLiteral() {
        (0, index_2.next)();
    }
    function parseParenExpression() {
        (0, util_1.expect)(types_2.TokenType.parenL);
        parseExpression();
        (0, util_1.expect)(types_2.TokenType.parenR);
    }
    // Returns true if this was an arrow expression.
    function parseParenAndDistinguishExpression(canBeArrow) {
        // Assume this is a normal parenthesized expression, but if we see an arrow, we'll bail and
        // start over as a parameter list.
        const snapshot = base_1.state.snapshot();
        const startTokenIndex = base_1.state.tokens.length;
        (0, util_1.expect)(types_2.TokenType.parenL);
        let first = true;
        while (!(0, index_2.match)(types_2.TokenType.parenR) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_2.TokenType.comma);
                if ((0, index_2.match)(types_2.TokenType.parenR)) {
                    break;
                }
            }
            if ((0, index_2.match)(types_2.TokenType.ellipsis)) {
                (0, lval_1.parseRest)(false /* isBlockScope */);
                parseParenItem();
                break;
            }
            else {
                parseMaybeAssign(false, true);
            }
        }
        (0, util_1.expect)(types_2.TokenType.parenR);
        if (canBeArrow && shouldParseArrow()) {
            const wasArrow = parseArrow();
            if (wasArrow) {
                // It was an arrow function this whole time, so start over and parse it as params so that we
                // get proper token annotations.
                base_1.state.restoreFromSnapshot(snapshot);
                base_1.state.scopeDepth++;
                // Don't specify a context ID because arrow functions don't need a context ID.
                (0, statement_1.parseFunctionParams)();
                parseArrow();
                parseArrowExpression(startTokenIndex);
                if (base_1.state.error) {
                    // Nevermind! This must have been something that looks very much like an
                    // arrow function but where its "parameter list" isn't actually a valid
                    // parameter list. Force non-arrow parsing.
                    // See https://github.com/alangpierce/sucrase/issues/666 for an example.
                    base_1.state.restoreFromSnapshot(snapshot);
                    parseParenAndDistinguishExpression(false);
                    return false;
                }
                return true;
            }
        }
        return false;
    }
    function shouldParseArrow() {
        return (0, index_2.match)(types_2.TokenType.colon) || !(0, util_1.canInsertSemicolon)();
    }
    // Returns whether there was an arrow token.
    function parseArrow() {
        if (base_1.isTypeScriptEnabled) {
            return (0, typescript_1.tsParseArrow)();
        }
        else if (base_1.isFlowEnabled) {
            return (0, flow_1.flowParseArrow)();
        }
        else {
            return (0, index_2.eat)(types_2.TokenType.arrow);
        }
    }
    function parseParenItem() {
        if (base_1.isTypeScriptEnabled || base_1.isFlowEnabled) {
            (0, types_1.typedParseParenItem)();
        }
    }
    // New's precedence is slightly tricky. It must allow its argument to
    // be a `[]` or dot subscript expression, but not a call — at least,
    // not without wrapping it in parentheses. Thus, it uses the noCalls
    // argument to parseSubscripts to prevent it from consuming the
    // argument list.
    function parseNew() {
        (0, util_1.expect)(types_2.TokenType._new);
        if ((0, index_2.eat)(types_2.TokenType.dot)) {
            // new.target
            parseIdentifier();
            return;
        }
        parseNewCallee();
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowStartParseNewArguments)();
        }
        if ((0, index_2.eat)(types_2.TokenType.parenL)) {
            parseExprList(types_2.TokenType.parenR);
        }
    }
    function parseNewCallee() {
        parseNoCallExpr();
        (0, index_2.eat)(types_2.TokenType.questionDot);
    }
    function parseTemplate() {
        // Finish `, read quasi
        (0, index_2.nextTemplateToken)();
        // Finish quasi, read ${
        (0, index_2.nextTemplateToken)();
        while (!(0, index_2.match)(types_2.TokenType.backQuote) && !base_1.state.error) {
            (0, util_1.expect)(types_2.TokenType.dollarBraceL);
            parseExpression();
            // Finish }, read quasi
            (0, index_2.nextTemplateToken)();
            // Finish quasi, read either ${ or `
            (0, index_2.nextTemplateToken)();
        }
        (0, index_2.next)();
    }
    // Parse an object literal or binding pattern.
    function parseObj(isPattern, isBlockScope) {
        // Attach a context ID to the object open and close brace and each object key.
        const contextId = (0, base_1.getNextContextId)();
        let first = true;
        (0, index_2.next)();
        base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
        while (!(0, index_2.eat)(types_2.TokenType.braceR) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_2.TokenType.comma);
                if ((0, index_2.eat)(types_2.TokenType.braceR)) {
                    break;
                }
            }
            let isGenerator = false;
            if ((0, index_2.match)(types_2.TokenType.ellipsis)) {
                const previousIndex = base_1.state.tokens.length;
                (0, lval_1.parseSpread)();
                if (isPattern) {
                    // Mark role when the only thing being spread over is an identifier.
                    if (base_1.state.tokens.length === previousIndex + 2) {
                        (0, lval_1.markPriorBindingIdentifier)(isBlockScope);
                    }
                    if ((0, index_2.eat)(types_2.TokenType.braceR)) {
                        break;
                    }
                }
                continue;
            }
            if (!isPattern) {
                isGenerator = (0, index_2.eat)(types_2.TokenType.star);
            }
            if (!isPattern && (0, util_1.isContextual)(keywords_1.ContextualKeyword._async)) {
                if (isGenerator)
                    (0, util_1.unexpected)();
                parseIdentifier();
                if ((0, index_2.match)(types_2.TokenType.colon) ||
                    (0, index_2.match)(types_2.TokenType.parenL) ||
                    (0, index_2.match)(types_2.TokenType.braceR) ||
                    (0, index_2.match)(types_2.TokenType.eq) ||
                    (0, index_2.match)(types_2.TokenType.comma)) {
                    // This is a key called "async" rather than an async function.
                }
                else {
                    if ((0, index_2.match)(types_2.TokenType.star)) {
                        (0, index_2.next)();
                        isGenerator = true;
                    }
                    parsePropertyName(contextId);
                }
            }
            else {
                parsePropertyName(contextId);
            }
            parseObjPropValue(isPattern, isBlockScope, contextId);
        }
        base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
    }
    function isGetterOrSetterMethod(isPattern) {
        // We go off of the next and don't bother checking if the node key is actually "get" or "set".
        // This lets us avoid generating a node, and should only make the validation worse.
        return (!isPattern &&
            ((0, index_2.match)(types_2.TokenType.string) || // get "string"() {}
                (0, index_2.match)(types_2.TokenType.num) || // get 1() {}
                (0, index_2.match)(types_2.TokenType.bracketL) || // get ["string"]() {}
                (0, index_2.match)(types_2.TokenType.name) || // get foo() {}
                !!(base_1.state.type & types_2.TokenType.IS_KEYWORD)) // get debugger() {}
        );
    }
    // Returns true if this was a method.
    function parseObjectMethod(isPattern, objectContextId) {
        // We don't need to worry about modifiers because object methods can't have optional bodies, so
        // the start will never be used.
        const functionStart = base_1.state.start;
        if ((0, index_2.match)(types_2.TokenType.parenL)) {
            if (isPattern)
                (0, util_1.unexpected)();
            parseMethod(functionStart, /* isConstructor */ false);
            return true;
        }
        if (isGetterOrSetterMethod(isPattern)) {
            parsePropertyName(objectContextId);
            parseMethod(functionStart, /* isConstructor */ false);
            return true;
        }
        return false;
    }
    function parseObjectProperty(isPattern, isBlockScope) {
        if ((0, index_2.eat)(types_2.TokenType.colon)) {
            if (isPattern) {
                (0, lval_1.parseMaybeDefault)(isBlockScope);
            }
            else {
                parseMaybeAssign(false);
            }
            return;
        }
        // Since there's no colon, we assume this is an object shorthand.
        // If we're in a destructuring, we've now discovered that the key was actually an assignee, so
        // we need to tag it as a declaration with the appropriate scope. Otherwise, we might need to
        // transform it on access, so mark it as a normal object shorthand.
        let identifierRole;
        if (isPattern) {
            if (base_1.state.scopeDepth === 0) {
                identifierRole = index_2.IdentifierRole.ObjectShorthandTopLevelDeclaration;
            }
            else if (isBlockScope) {
                identifierRole = index_2.IdentifierRole.ObjectShorthandBlockScopedDeclaration;
            }
            else {
                identifierRole = index_2.IdentifierRole.ObjectShorthandFunctionScopedDeclaration;
            }
        }
        else {
            identifierRole = index_2.IdentifierRole.ObjectShorthand;
        }
        base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = identifierRole;
        // Regardless of whether we know this to be a pattern or if we're in an ambiguous context, allow
        // parsing as if there's a default value.
        (0, lval_1.parseMaybeDefault)(isBlockScope, true);
    }
    function parseObjPropValue(isPattern, isBlockScope, objectContextId) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsStartParseObjPropValue)();
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowStartParseObjPropValue)();
        }
        const wasMethod = parseObjectMethod(isPattern, objectContextId);
        if (!wasMethod) {
            parseObjectProperty(isPattern, isBlockScope);
        }
    }
    function parsePropertyName(objectContextId) {
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseVariance)();
        }
        if ((0, index_2.eat)(types_2.TokenType.bracketL)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = objectContextId;
            parseMaybeAssign();
            (0, util_1.expect)(types_2.TokenType.bracketR);
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = objectContextId;
        }
        else {
            if ((0, index_2.match)(types_2.TokenType.num) || (0, index_2.match)(types_2.TokenType.string) || (0, index_2.match)(types_2.TokenType.bigint) || (0, index_2.match)(types_2.TokenType.decimal)) {
                parseExprAtom();
            }
            else {
                parseMaybePrivateName();
            }
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_2.IdentifierRole.ObjectKey;
            base_1.state.tokens[base_1.state.tokens.length - 1].contextId = objectContextId;
        }
    }
    // Parse object or class method.
    function parseMethod(functionStart, isConstructor) {
        const funcContextId = (0, base_1.getNextContextId)();
        base_1.state.scopeDepth++;
        const startTokenIndex = base_1.state.tokens.length;
        const allowModifiers = isConstructor; // For TypeScript parameter properties
        (0, statement_1.parseFunctionParams)(allowModifiers, funcContextId);
        parseFunctionBodyAndFinish(functionStart, funcContextId);
        const endTokenIndex = base_1.state.tokens.length;
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, true));
        base_1.state.scopeDepth--;
    }
    // Parse arrow function expression.
    // If the parameters are provided, they will be converted to an
    // assignable list.
    function parseArrowExpression(startTokenIndex) {
        parseFunctionBody(true);
        const endTokenIndex = base_1.state.tokens.length;
        base_1.state.scopes.push(new state_1.Scope(startTokenIndex, endTokenIndex, true));
        base_1.state.scopeDepth--;
    }
    function parseFunctionBodyAndFinish(functionStart, funcContextId = 0) {
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseFunctionBodyAndFinish)(functionStart, funcContextId);
        }
        else if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseFunctionBodyAndFinish)(funcContextId);
        }
        else {
            parseFunctionBody(false, funcContextId);
        }
    }
    function parseFunctionBody(allowExpression, funcContextId = 0) {
        const isExpression = allowExpression && !(0, index_2.match)(types_2.TokenType.braceL);
        if (isExpression) {
            parseMaybeAssign();
        }
        else {
            (0, statement_1.parseBlock)(true /* isFunctionScope */, funcContextId);
        }
    }
    // Parses a comma-separated list of expressions, and returns them as
    // an array. `close` is the token type that ends the list, and
    // `allowEmpty` can be turned on to allow subsequent commas with
    // nothing in between them to be parsed as `null` (which is needed
    // for array literals).
    function parseExprList(close, allowEmpty = false) {
        let first = true;
        while (!(0, index_2.eat)(close) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_2.TokenType.comma);
                if ((0, index_2.eat)(close))
                    break;
            }
            parseExprListItem(allowEmpty);
        }
    }
    function parseExprListItem(allowEmpty) {
        if (allowEmpty && (0, index_2.match)(types_2.TokenType.comma)) {
            // Empty item; nothing more to parse for this item.
        }
        else if ((0, index_2.match)(types_2.TokenType.ellipsis)) {
            (0, lval_1.parseSpread)();
            parseParenItem();
        }
        else if ((0, index_2.match)(types_2.TokenType.question)) {
            // Partial function application proposal.
            (0, index_2.next)();
        }
        else {
            parseMaybeAssign(false, true);
        }
    }
    // Parse the next token as an identifier.
    function parseIdentifier() {
        (0, index_2.next)();
        base_1.state.tokens[base_1.state.tokens.length - 1].type = types_2.TokenType.name;
    }
    // Parses await expression inside async function.
    function parseAwait() {
        parseMaybeUnary();
    }
    // Parses yield expression inside generator.
    function parseYield() {
        (0, index_2.next)();
        if (!(0, index_2.match)(types_2.TokenType.semi) && !(0, util_1.canInsertSemicolon)()) {
            (0, index_2.eat)(types_2.TokenType.star);
            parseMaybeAssign();
        }
    }
    // https://github.com/tc39/proposal-js-module-blocks
    function parseModuleExpression() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._module);
        (0, util_1.expect)(types_2.TokenType.braceL);
        // For now, just call parseBlockBody to parse the block. In the future when we
        // implement full support, we'll want to emit scopes and possibly other
        // information.
        (0, statement_1.parseBlockBody)(types_2.TokenType.braceR);
    }
},
"d7708a7d24": /* sucrase\dist\esm\parser\plugins\jsx\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.jsxParseElement = jsxParseElement;
    exports.nextJSXTagToken = nextJSXTagToken;
    const index_1 = require("bfb18d0576") /* ../../tokenizer/index */;
    const types_1 = require("f0c35cbd76") /* ../../tokenizer/types */;
    const base_1 = require("540718e523") /* ../../traverser/base */;
    const expression_1 = require("8178e7c3c8") /* ../../traverser/expression */;
    const util_1 = require("bc94bbadc1") /* ../../traverser/util */;
    const charcodes_1 = require("22746c8ce8") /* ../../util/charcodes */;
    const identifier_1 = require("364148c9f0") /* ../../util/identifier */;
    const typescript_1 = require("6a970c22b9") /* ../typescript */;
    /**
     * Read token with JSX contents.
     *
     * In addition to detecting jsxTagStart and also regular tokens that might be
     * part of an expression, this code detects the start and end of text ranges
     * within JSX children. In order to properly count the number of children, we
     * distinguish jsxText from jsxEmptyText, which is a text range that simplifies
     * to the empty string after JSX whitespace trimming.
     *
     * It turns out that a JSX text range will simplify to the empty string if and
     * only if both of these conditions hold:
     * - The range consists entirely of whitespace characters (only counting space,
     *   tab, \r, and \n).
     * - The range has at least one newline.
     * This can be proven by analyzing any implementation of whitespace trimming,
     * e.g. formatJSXTextLiteral in Sucrase or cleanJSXElementLiteralChild in Babel.
     */
    function jsxReadToken() {
        let sawNewline = false;
        let sawNonWhitespace = false;
        while (true) {
            if (base_1.state.pos >= base_1.input.length) {
                (0, util_1.unexpected)("Unterminated JSX contents");
                return;
            }
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            if (ch === charcodes_1.charCodes.lessThan || ch === charcodes_1.charCodes.leftCurlyBrace) {
                if (base_1.state.pos === base_1.state.start) {
                    if (ch === charcodes_1.charCodes.lessThan) {
                        base_1.state.pos++;
                        (0, index_1.finishToken)(types_1.TokenType.jsxTagStart);
                        return;
                    }
                    (0, index_1.getTokenFromCode)(ch);
                    return;
                }
                if (sawNewline && !sawNonWhitespace) {
                    (0, index_1.finishToken)(types_1.TokenType.jsxEmptyText);
                }
                else {
                    (0, index_1.finishToken)(types_1.TokenType.jsxText);
                }
                return;
            }
            // This is part of JSX text.
            if (ch === charcodes_1.charCodes.lineFeed) {
                sawNewline = true;
            }
            else if (ch !== charcodes_1.charCodes.space && ch !== charcodes_1.charCodes.carriageReturn && ch !== charcodes_1.charCodes.tab) {
                sawNonWhitespace = true;
            }
            base_1.state.pos++;
        }
    }
    function jsxReadString(quote) {
        base_1.state.pos++;
        for (;;) {
            if (base_1.state.pos >= base_1.input.length) {
                (0, util_1.unexpected)("Unterminated string constant");
                return;
            }
            const ch = base_1.input.charCodeAt(base_1.state.pos);
            if (ch === quote) {
                base_1.state.pos++;
                break;
            }
            base_1.state.pos++;
        }
        (0, index_1.finishToken)(types_1.TokenType.string);
    }
    // Read a JSX identifier (valid tag or attribute name).
    //
    // Optimized version since JSX identifiers can't contain
    // escape characters and so can be read as single slice.
    // Also assumes that first character was already checked
    // by isIdentifierStart in readToken.
    function jsxReadWord() {
        let ch;
        do {
            if (base_1.state.pos > base_1.input.length) {
                (0, util_1.unexpected)("Unexpectedly reached the end of input.");
                return;
            }
            ch = base_1.input.charCodeAt(++base_1.state.pos);
        } while (identifier_1.IS_IDENTIFIER_CHAR[ch] || ch === charcodes_1.charCodes.dash);
        (0, index_1.finishToken)(types_1.TokenType.jsxName);
    }
    // Parse next token as JSX identifier
    function jsxParseIdentifier() {
        nextJSXTagToken();
    }
    // Parse namespaced identifier.
    function jsxParseNamespacedName(identifierRole) {
        jsxParseIdentifier();
        if (!(0, index_1.eat)(types_1.TokenType.colon)) {
            // Plain identifier, so this is an access.
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = identifierRole;
            return;
        }
        // Process the second half of the namespaced name.
        jsxParseIdentifier();
    }
    // Parses element name in any form - namespaced, member
    // or single identifier.
    function jsxParseElementName() {
        const firstTokenIndex = base_1.state.tokens.length;
        jsxParseNamespacedName(index_1.IdentifierRole.Access);
        let hadDot = false;
        while ((0, index_1.match)(types_1.TokenType.dot)) {
            hadDot = true;
            nextJSXTagToken();
            jsxParseIdentifier();
        }
        // For tags like <div> with a lowercase letter and no dots, the name is
        // actually *not* an identifier access, since it's referring to a built-in
        // tag name. Remove the identifier role in this case so that it's not
        // accidentally transformed by the imports transform when preserving JSX.
        if (!hadDot) {
            const firstToken = base_1.state.tokens[firstTokenIndex];
            const firstChar = base_1.input.charCodeAt(firstToken.start);
            if (firstChar >= charcodes_1.charCodes.lowercaseA && firstChar <= charcodes_1.charCodes.lowercaseZ) {
                firstToken.identifierRole = null;
            }
        }
    }
    // Parses any type of JSX attribute value.
    function jsxParseAttributeValue() {
        switch (base_1.state.type) {
            case types_1.TokenType.braceL:
                (0, index_1.next)();
                (0, expression_1.parseExpression)();
                nextJSXTagToken();
                return;
            case types_1.TokenType.jsxTagStart:
                jsxParseElement();
                nextJSXTagToken();
                return;
            case types_1.TokenType.string:
                nextJSXTagToken();
                return;
            default:
                (0, util_1.unexpected)("JSX value should be either an expression or a quoted JSX text");
        }
    }
    // Parse JSX spread child, after already processing the {
    // Does not parse the closing }
    function jsxParseSpreadChild() {
        (0, util_1.expect)(types_1.TokenType.ellipsis);
        (0, expression_1.parseExpression)();
    }
    // Parses JSX opening tag starting after "<".
    // Returns true if the tag was self-closing.
    // Does not parse the last token.
    function jsxParseOpeningElement(initialTokenIndex) {
        if ((0, index_1.match)(types_1.TokenType.jsxTagEnd)) {
            // This is an open-fragment.
            return false;
        }
        jsxParseElementName();
        if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsTryParseJSXTypeArgument)();
        }
        let hasSeenPropSpread = false;
        while (!(0, index_1.match)(types_1.TokenType.slash) && !(0, index_1.match)(types_1.TokenType.jsxTagEnd) && !base_1.state.error) {
            if ((0, index_1.eat)(types_1.TokenType.braceL)) {
                hasSeenPropSpread = true;
                (0, util_1.expect)(types_1.TokenType.ellipsis);
                (0, expression_1.parseMaybeAssign)();
                // }
                nextJSXTagToken();
                continue;
            }
            if (hasSeenPropSpread &&
                base_1.state.end - base_1.state.start === 3 &&
                base_1.input.charCodeAt(base_1.state.start) === charcodes_1.charCodes.lowercaseK &&
                base_1.input.charCodeAt(base_1.state.start + 1) === charcodes_1.charCodes.lowercaseE &&
                base_1.input.charCodeAt(base_1.state.start + 2) === charcodes_1.charCodes.lowercaseY) {
                base_1.state.tokens[initialTokenIndex].jsxRole = index_1.JSXRole.KeyAfterPropSpread;
            }
            jsxParseNamespacedName(index_1.IdentifierRole.ObjectKey);
            if ((0, index_1.match)(types_1.TokenType.eq)) {
                nextJSXTagToken();
                jsxParseAttributeValue();
            }
        }
        const isSelfClosing = (0, index_1.match)(types_1.TokenType.slash);
        if (isSelfClosing) {
            // /
            nextJSXTagToken();
        }
        return isSelfClosing;
    }
    // Parses JSX closing tag starting after "</".
    // Does not parse the last token.
    function jsxParseClosingElement() {
        if ((0, index_1.match)(types_1.TokenType.jsxTagEnd)) {
            // Fragment syntax, so we immediately have a tag end.
            return;
        }
        jsxParseElementName();
    }
    // Parses entire JSX element, including its opening tag
    // (starting after "<"), attributes, contents and closing tag.
    // Does not parse the last token.
    function jsxParseElementAt() {
        const initialTokenIndex = base_1.state.tokens.length - 1;
        base_1.state.tokens[initialTokenIndex].jsxRole = index_1.JSXRole.NoChildren;
        let numExplicitChildren = 0;
        const isSelfClosing = jsxParseOpeningElement(initialTokenIndex);
        if (!isSelfClosing) {
            nextJSXExprToken();
            while (true) {
                switch (base_1.state.type) {
                    case types_1.TokenType.jsxTagStart:
                        nextJSXTagToken();
                        if ((0, index_1.match)(types_1.TokenType.slash)) {
                            nextJSXTagToken();
                            jsxParseClosingElement();
                            // Key after prop spread takes precedence over number of children,
                            // since it means we switch to createElement, which doesn't care
                            // about number of children.
                            if (base_1.state.tokens[initialTokenIndex].jsxRole !== index_1.JSXRole.KeyAfterPropSpread) {
                                if (numExplicitChildren === 1) {
                                    base_1.state.tokens[initialTokenIndex].jsxRole = index_1.JSXRole.OneChild;
                                }
                                else if (numExplicitChildren > 1) {
                                    base_1.state.tokens[initialTokenIndex].jsxRole = index_1.JSXRole.StaticChildren;
                                }
                            }
                            return;
                        }
                        numExplicitChildren++;
                        jsxParseElementAt();
                        nextJSXExprToken();
                        break;
                    case types_1.TokenType.jsxText:
                        numExplicitChildren++;
                        nextJSXExprToken();
                        break;
                    case types_1.TokenType.jsxEmptyText:
                        nextJSXExprToken();
                        break;
                    case types_1.TokenType.braceL:
                        (0, index_1.next)();
                        if ((0, index_1.match)(types_1.TokenType.ellipsis)) {
                            jsxParseSpreadChild();
                            nextJSXExprToken();
                            // Spread children are a mechanism to explicitly mark children as
                            // static, so count it as 2 children to satisfy the "more than one
                            // child" condition.
                            numExplicitChildren += 2;
                        }
                        else {
                            // If we see {}, this is an empty pseudo-expression that doesn't
                            // count as a child.
                            if (!(0, index_1.match)(types_1.TokenType.braceR)) {
                                numExplicitChildren++;
                                (0, expression_1.parseExpression)();
                            }
                            nextJSXExprToken();
                        }
                        break;
                    // istanbul ignore next - should never happen
                    default:
                        (0, util_1.unexpected)();
                        return;
                }
            }
        }
    }
    // Parses entire JSX element from current position.
    // Does not parse the last token.
    function jsxParseElement() {
        nextJSXTagToken();
        jsxParseElementAt();
    }
    // ==================================
    // Overrides
    // ==================================
    function nextJSXTagToken() {
        base_1.state.tokens.push(new index_1.Token());
        (0, index_1.skipSpace)();
        base_1.state.start = base_1.state.pos;
        const code = base_1.input.charCodeAt(base_1.state.pos);
        if (identifier_1.IS_IDENTIFIER_START[code]) {
            jsxReadWord();
        }
        else if (code === charcodes_1.charCodes.quotationMark || code === charcodes_1.charCodes.apostrophe) {
            jsxReadString(code);
        }
        else {
            // The following tokens are just one character each.
            ++base_1.state.pos;
            switch (code) {
                case charcodes_1.charCodes.greaterThan:
                    (0, index_1.finishToken)(types_1.TokenType.jsxTagEnd);
                    break;
                case charcodes_1.charCodes.lessThan:
                    (0, index_1.finishToken)(types_1.TokenType.jsxTagStart);
                    break;
                case charcodes_1.charCodes.slash:
                    (0, index_1.finishToken)(types_1.TokenType.slash);
                    break;
                case charcodes_1.charCodes.equalsTo:
                    (0, index_1.finishToken)(types_1.TokenType.eq);
                    break;
                case charcodes_1.charCodes.leftCurlyBrace:
                    (0, index_1.finishToken)(types_1.TokenType.braceL);
                    break;
                case charcodes_1.charCodes.dot:
                    (0, index_1.finishToken)(types_1.TokenType.dot);
                    break;
                case charcodes_1.charCodes.colon:
                    (0, index_1.finishToken)(types_1.TokenType.colon);
                    break;
                default:
                    (0, util_1.unexpected)();
            }
        }
    }
    function nextJSXExprToken() {
        base_1.state.tokens.push(new index_1.Token());
        base_1.state.start = base_1.state.pos;
        jsxReadToken();
    }
},
"6a970c22b9": /* sucrase\dist\esm\parser\plugins\typescript.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.tsParseModifiers = tsParseModifiers;
    exports.tsParseModifier = tsParseModifier;
    exports.tsTryParseTypeParameters = tsTryParseTypeParameters;
    exports.tsTryParseTypeAnnotation = tsTryParseTypeAnnotation;
    exports.tsParseTypeAnnotation = tsParseTypeAnnotation;
    exports.tsParseType = tsParseType;
    exports.tsParseNonConditionalType = tsParseNonConditionalType;
    exports.tsParseTypeAssertion = tsParseTypeAssertion;
    exports.tsTryParseJSXTypeArgument = tsTryParseJSXTypeArgument;
    exports.tsParseImportEqualsDeclaration = tsParseImportEqualsDeclaration;
    exports.tsIsDeclarationStart = tsIsDeclarationStart;
    exports.tsParseFunctionBodyAndFinish = tsParseFunctionBodyAndFinish;
    exports.tsParseSubscript = tsParseSubscript;
    exports.tsTryParseExport = tsTryParseExport;
    exports.tsParseImportSpecifier = tsParseImportSpecifier;
    exports.tsParseExportSpecifier = tsParseExportSpecifier;
    exports.tsTryParseExportDefaultExpression = tsTryParseExportDefaultExpression;
    exports.tsTryParseStatementContent = tsTryParseStatementContent;
    exports.tsTryParseClassMemberWithIsStatic = tsTryParseClassMemberWithIsStatic;
    exports.tsParseIdentifierStatement = tsParseIdentifierStatement;
    exports.tsParseExportDeclaration = tsParseExportDeclaration;
    exports.tsAfterParseClassSuper = tsAfterParseClassSuper;
    exports.tsStartParseObjPropValue = tsStartParseObjPropValue;
    exports.tsStartParseFunctionParams = tsStartParseFunctionParams;
    exports.tsAfterParseVarHead = tsAfterParseVarHead;
    exports.tsStartParseAsyncArrowFromCallExpression = tsStartParseAsyncArrowFromCallExpression;
    exports.tsParseMaybeAssign = tsParseMaybeAssign;
    exports.tsParseMaybeAssignWithJSX = tsParseMaybeAssignWithJSX;
    exports.tsParseMaybeAssignWithoutJSX = tsParseMaybeAssignWithoutJSX;
    exports.tsParseArrow = tsParseArrow;
    exports.tsParseAssignableListItemTypes = tsParseAssignableListItemTypes;
    exports.tsParseMaybeDecoratorArguments = tsParseMaybeDecoratorArguments;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const keywords_1 = require("99ff836c64") /* ../tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const base_1 = require("540718e523") /* ../traverser/base */;
    const expression_1 = require("8178e7c3c8") /* ../traverser/expression */;
    const lval_1 = require("4cefc59e67") /* ../traverser/lval */;
    const statement_1 = require("e3b9989da1") /* ../traverser/statement */;
    const util_1 = require("bc94bbadc1") /* ../traverser/util */;
    const jsx_1 = require("d7708a7d24") /* ./jsx */;
    function tsIsIdentifier() {
        // TODO: actually a bit more complex in TypeScript, but shouldn't matter.
        // See https://github.com/Microsoft/TypeScript/issues/15008
        return (0, index_1.match)(types_1.TokenType.name);
    }
    function isLiteralPropertyName() {
        return ((0, index_1.match)(types_1.TokenType.name) ||
            Boolean(base_1.state.type & types_1.TokenType.IS_KEYWORD) ||
            (0, index_1.match)(types_1.TokenType.string) ||
            (0, index_1.match)(types_1.TokenType.num) ||
            (0, index_1.match)(types_1.TokenType.bigint) ||
            (0, index_1.match)(types_1.TokenType.decimal));
    }
    function tsNextTokenCanFollowModifier() {
        // Note: TypeScript's implementation is much more complicated because
        // more things are considered modifiers there.
        // This implementation only handles modifiers not handled by babylon itself. And "static".
        // TODO: Would be nice to avoid lookahead. Want a hasLineBreakUpNext() method...
        const snapshot = base_1.state.snapshot();
        (0, index_1.next)();
        const canFollowModifier = ((0, index_1.match)(types_1.TokenType.bracketL) ||
            (0, index_1.match)(types_1.TokenType.braceL) ||
            (0, index_1.match)(types_1.TokenType.star) ||
            (0, index_1.match)(types_1.TokenType.ellipsis) ||
            (0, index_1.match)(types_1.TokenType.hash) ||
            isLiteralPropertyName()) &&
            !(0, util_1.hasPrecedingLineBreak)();
        if (canFollowModifier) {
            return true;
        }
        else {
            base_1.state.restoreFromSnapshot(snapshot);
            return false;
        }
    }
    function tsParseModifiers(allowedModifiers) {
        while (true) {
            const modifier = tsParseModifier(allowedModifiers);
            if (modifier === null) {
                break;
            }
        }
    }
    /** Parses a modifier matching one the given modifier names. */
    function tsParseModifier(allowedModifiers) {
        if (!(0, index_1.match)(types_1.TokenType.name)) {
            return null;
        }
        const modifier = base_1.state.contextualKeyword;
        if (allowedModifiers.indexOf(modifier) !== -1 && tsNextTokenCanFollowModifier()) {
            switch (modifier) {
                case keywords_1.ContextualKeyword._readonly:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._readonly;
                    break;
                case keywords_1.ContextualKeyword._abstract:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._abstract;
                    break;
                case keywords_1.ContextualKeyword._static:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._static;
                    break;
                case keywords_1.ContextualKeyword._public:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._public;
                    break;
                case keywords_1.ContextualKeyword._private:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._private;
                    break;
                case keywords_1.ContextualKeyword._protected:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._protected;
                    break;
                case keywords_1.ContextualKeyword._override:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._override;
                    break;
                case keywords_1.ContextualKeyword._declare:
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._declare;
                    break;
                default:
                    break;
            }
            return modifier;
        }
        return null;
    }
    function tsParseEntityName() {
        (0, expression_1.parseIdentifier)();
        while ((0, index_1.eat)(types_1.TokenType.dot)) {
            (0, expression_1.parseIdentifier)();
        }
    }
    function tsParseTypeReference() {
        tsParseEntityName();
        if (!(0, util_1.hasPrecedingLineBreak)() && (0, index_1.match)(types_1.TokenType.lessThan)) {
            tsParseTypeArguments();
        }
    }
    function tsParseThisTypePredicate() {
        (0, index_1.next)();
        tsParseTypeAnnotation();
    }
    function tsParseThisTypeNode() {
        (0, index_1.next)();
    }
    function tsParseTypeQuery() {
        (0, util_1.expect)(types_1.TokenType._typeof);
        if ((0, index_1.match)(types_1.TokenType._import)) {
            tsParseImportType();
        }
        else {
            tsParseEntityName();
        }
        if (!(0, util_1.hasPrecedingLineBreak)() && (0, index_1.match)(types_1.TokenType.lessThan)) {
            tsParseTypeArguments();
        }
    }
    function tsParseImportType() {
        (0, util_1.expect)(types_1.TokenType._import);
        (0, util_1.expect)(types_1.TokenType.parenL);
        (0, util_1.expect)(types_1.TokenType.string);
        (0, util_1.expect)(types_1.TokenType.parenR);
        if ((0, index_1.eat)(types_1.TokenType.dot)) {
            tsParseEntityName();
        }
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            tsParseTypeArguments();
        }
    }
    function tsParseTypeParameter() {
        (0, index_1.eat)(types_1.TokenType._const);
        const hadIn = (0, index_1.eat)(types_1.TokenType._in);
        const hadOut = (0, util_1.eatContextual)(keywords_1.ContextualKeyword._out);
        (0, index_1.eat)(types_1.TokenType._const);
        if ((hadIn || hadOut) && !(0, index_1.match)(types_1.TokenType.name)) {
            // The "in" or "out" keyword must have actually been the type parameter
            // name, so set it as the name.
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType.name;
        }
        else {
            (0, expression_1.parseIdentifier)();
        }
        if ((0, index_1.eat)(types_1.TokenType._extends)) {
            tsParseType();
        }
        if ((0, index_1.eat)(types_1.TokenType.eq)) {
            tsParseType();
        }
    }
    function tsTryParseTypeParameters() {
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            tsParseTypeParameters();
        }
    }
    function tsParseTypeParameters() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.typeParameterStart)) {
            (0, index_1.next)();
        }
        else {
            (0, util_1.unexpected)();
        }
        while (!(0, index_1.eat)(types_1.TokenType.greaterThan) && !base_1.state.error) {
            tsParseTypeParameter();
            (0, index_1.eat)(types_1.TokenType.comma);
        }
        (0, index_1.popTypeContext)(oldIsType);
    }
    // Note: In TypeScript implementation we must provide `yieldContext` and `awaitContext`,
    // but here it's always false, because this is only used for types.
    function tsFillSignature(returnToken) {
        // Arrow fns *must* have return token (`=>`). Normal functions can omit it.
        const returnTokenRequired = returnToken === types_1.TokenType.arrow;
        tsTryParseTypeParameters();
        (0, util_1.expect)(types_1.TokenType.parenL);
        // Create a scope even though we're doing type parsing so we don't accidentally
        // treat params as top-level bindings.
        base_1.state.scopeDepth++;
        tsParseBindingListForSignature(false /* isBlockScope */);
        base_1.state.scopeDepth--;
        if (returnTokenRequired) {
            tsParseTypeOrTypePredicateAnnotation(returnToken);
        }
        else if ((0, index_1.match)(returnToken)) {
            tsParseTypeOrTypePredicateAnnotation(returnToken);
        }
    }
    function tsParseBindingListForSignature(isBlockScope) {
        (0, lval_1.parseBindingList)(types_1.TokenType.parenR, isBlockScope);
    }
    function tsParseTypeMemberSemicolon() {
        if (!(0, index_1.eat)(types_1.TokenType.comma)) {
            (0, util_1.semicolon)();
        }
    }
    function tsParseSignatureMember() {
        tsFillSignature(types_1.TokenType.colon);
        tsParseTypeMemberSemicolon();
    }
    function tsIsUnambiguouslyIndexSignature() {
        const snapshot = base_1.state.snapshot();
        (0, index_1.next)(); // Skip '{'
        const isIndexSignature = (0, index_1.eat)(types_1.TokenType.name) && (0, index_1.match)(types_1.TokenType.colon);
        base_1.state.restoreFromSnapshot(snapshot);
        return isIndexSignature;
    }
    function tsTryParseIndexSignature() {
        if (!((0, index_1.match)(types_1.TokenType.bracketL) && tsIsUnambiguouslyIndexSignature())) {
            return false;
        }
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(types_1.TokenType.bracketL);
        (0, expression_1.parseIdentifier)();
        tsParseTypeAnnotation();
        (0, util_1.expect)(types_1.TokenType.bracketR);
        tsTryParseTypeAnnotation();
        tsParseTypeMemberSemicolon();
        (0, index_1.popTypeContext)(oldIsType);
        return true;
    }
    function tsParsePropertyOrMethodSignature(isReadonly) {
        (0, index_1.eat)(types_1.TokenType.question);
        if (!isReadonly && ((0, index_1.match)(types_1.TokenType.parenL) || (0, index_1.match)(types_1.TokenType.lessThan))) {
            tsFillSignature(types_1.TokenType.colon);
            tsParseTypeMemberSemicolon();
        }
        else {
            tsTryParseTypeAnnotation();
            tsParseTypeMemberSemicolon();
        }
    }
    function tsParseTypeMember() {
        if ((0, index_1.match)(types_1.TokenType.parenL) || (0, index_1.match)(types_1.TokenType.lessThan)) {
            // call signature
            tsParseSignatureMember();
            return;
        }
        if ((0, index_1.match)(types_1.TokenType._new)) {
            (0, index_1.next)();
            if ((0, index_1.match)(types_1.TokenType.parenL) || (0, index_1.match)(types_1.TokenType.lessThan)) {
                // constructor signature
                tsParseSignatureMember();
            }
            else {
                tsParsePropertyOrMethodSignature(false);
            }
            return;
        }
        const readonly = !!tsParseModifier([keywords_1.ContextualKeyword._readonly]);
        const found = tsTryParseIndexSignature();
        if (found) {
            return;
        }
        if (((0, util_1.isContextual)(keywords_1.ContextualKeyword._get) || (0, util_1.isContextual)(keywords_1.ContextualKeyword._set)) &&
            tsNextTokenCanFollowModifier()) {
            // This is a getter/setter on a type. The tsNextTokenCanFollowModifier
            // function already called next() for us, so continue parsing the name.
        }
        (0, expression_1.parsePropertyName)(-1 /* Types don't need context IDs. */);
        tsParsePropertyOrMethodSignature(readonly);
    }
    function tsParseTypeLiteral() {
        tsParseObjectTypeMembers();
    }
    function tsParseObjectTypeMembers() {
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, index_1.eat)(types_1.TokenType.braceR) && !base_1.state.error) {
            tsParseTypeMember();
        }
    }
    function tsLookaheadIsStartOfMappedType() {
        const snapshot = base_1.state.snapshot();
        const isStartOfMappedType = tsIsStartOfMappedType();
        base_1.state.restoreFromSnapshot(snapshot);
        return isStartOfMappedType;
    }
    function tsIsStartOfMappedType() {
        (0, index_1.next)();
        if ((0, index_1.eat)(types_1.TokenType.plus) || (0, index_1.eat)(types_1.TokenType.minus)) {
            return (0, util_1.isContextual)(keywords_1.ContextualKeyword._readonly);
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._readonly)) {
            (0, index_1.next)();
        }
        if (!(0, index_1.match)(types_1.TokenType.bracketL)) {
            return false;
        }
        (0, index_1.next)();
        if (!tsIsIdentifier()) {
            return false;
        }
        (0, index_1.next)();
        return (0, index_1.match)(types_1.TokenType._in);
    }
    function tsParseMappedTypeParameter() {
        (0, expression_1.parseIdentifier)();
        (0, util_1.expect)(types_1.TokenType._in);
        tsParseType();
    }
    function tsParseMappedType() {
        (0, util_1.expect)(types_1.TokenType.braceL);
        if ((0, index_1.match)(types_1.TokenType.plus) || (0, index_1.match)(types_1.TokenType.minus)) {
            (0, index_1.next)();
            (0, util_1.expectContextual)(keywords_1.ContextualKeyword._readonly);
        }
        else {
            (0, util_1.eatContextual)(keywords_1.ContextualKeyword._readonly);
        }
        (0, util_1.expect)(types_1.TokenType.bracketL);
        tsParseMappedTypeParameter();
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._as)) {
            tsParseType();
        }
        (0, util_1.expect)(types_1.TokenType.bracketR);
        if ((0, index_1.match)(types_1.TokenType.plus) || (0, index_1.match)(types_1.TokenType.minus)) {
            (0, index_1.next)();
            (0, util_1.expect)(types_1.TokenType.question);
        }
        else {
            (0, index_1.eat)(types_1.TokenType.question);
        }
        tsTryParseType();
        (0, util_1.semicolon)();
        (0, util_1.expect)(types_1.TokenType.braceR);
    }
    function tsParseTupleType() {
        (0, util_1.expect)(types_1.TokenType.bracketL);
        while (!(0, index_1.eat)(types_1.TokenType.bracketR) && !base_1.state.error) {
            // Do not validate presence of either none or only labeled elements
            tsParseTupleElementType();
            (0, index_1.eat)(types_1.TokenType.comma);
        }
    }
    function tsParseTupleElementType() {
        // parses `...TsType[]`
        if ((0, index_1.eat)(types_1.TokenType.ellipsis)) {
            tsParseType();
        }
        else {
            // parses `TsType?`
            tsParseType();
            (0, index_1.eat)(types_1.TokenType.question);
        }
        // The type we parsed above was actually a label
        if ((0, index_1.eat)(types_1.TokenType.colon)) {
            // Labeled tuple types must affix the label with `...` or `?`, so no need to handle those here
            tsParseType();
        }
    }
    function tsParseParenthesizedType() {
        (0, util_1.expect)(types_1.TokenType.parenL);
        tsParseType();
        (0, util_1.expect)(types_1.TokenType.parenR);
    }
    function tsParseTemplateLiteralType() {
        // Finish `, read quasi
        (0, index_1.nextTemplateToken)();
        // Finish quasi, read ${
        (0, index_1.nextTemplateToken)();
        while (!(0, index_1.match)(types_1.TokenType.backQuote) && !base_1.state.error) {
            (0, util_1.expect)(types_1.TokenType.dollarBraceL);
            tsParseType();
            // Finish }, read quasi
            (0, index_1.nextTemplateToken)();
            // Finish quasi, read either ${ or `
            (0, index_1.nextTemplateToken)();
        }
        (0, index_1.next)();
    }
    var FunctionType;
    (function (FunctionType) {
        const TSFunctionType = 0;
        FunctionType[FunctionType["TSFunctionType"] = TSFunctionType] = "TSFunctionType";
        const TSConstructorType = TSFunctionType + 1;
        FunctionType[FunctionType["TSConstructorType"] = TSConstructorType] = "TSConstructorType";
        const TSAbstractConstructorType = TSConstructorType + 1;
        FunctionType[FunctionType["TSAbstractConstructorType"] = TSAbstractConstructorType] = "TSAbstractConstructorType";
    })(FunctionType || (FunctionType = {}));
    function tsParseFunctionOrConstructorType(type) {
        if (type === FunctionType.TSAbstractConstructorType) {
            (0, util_1.expectContextual)(keywords_1.ContextualKeyword._abstract);
        }
        if (type === FunctionType.TSConstructorType || type === FunctionType.TSAbstractConstructorType) {
            (0, util_1.expect)(types_1.TokenType._new);
        }
        const oldInDisallowConditionalTypesContext = base_1.state.inDisallowConditionalTypesContext;
        base_1.state.inDisallowConditionalTypesContext = false;
        tsFillSignature(types_1.TokenType.arrow);
        base_1.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
    }
    function tsParseNonArrayType() {
        switch (base_1.state.type) {
            case types_1.TokenType.name:
                tsParseTypeReference();
                return;
            case types_1.TokenType._void:
            case types_1.TokenType._null:
                (0, index_1.next)();
                return;
            case types_1.TokenType.string:
            case types_1.TokenType.num:
            case types_1.TokenType.bigint:
            case types_1.TokenType.decimal:
            case types_1.TokenType._true:
            case types_1.TokenType._false:
                (0, expression_1.parseLiteral)();
                return;
            case types_1.TokenType.minus:
                (0, index_1.next)();
                (0, expression_1.parseLiteral)();
                return;
            case types_1.TokenType._this: {
                tsParseThisTypeNode();
                if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._is) && !(0, util_1.hasPrecedingLineBreak)()) {
                    tsParseThisTypePredicate();
                }
                return;
            }
            case types_1.TokenType._typeof:
                tsParseTypeQuery();
                return;
            case types_1.TokenType._import:
                tsParseImportType();
                return;
            case types_1.TokenType.braceL:
                if (tsLookaheadIsStartOfMappedType()) {
                    tsParseMappedType();
                }
                else {
                    tsParseTypeLiteral();
                }
                return;
            case types_1.TokenType.bracketL:
                tsParseTupleType();
                return;
            case types_1.TokenType.parenL:
                tsParseParenthesizedType();
                return;
            case types_1.TokenType.backQuote:
                tsParseTemplateLiteralType();
                return;
            default:
                if (base_1.state.type & types_1.TokenType.IS_KEYWORD) {
                    (0, index_1.next)();
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType.name;
                    return;
                }
                break;
        }
        (0, util_1.unexpected)();
    }
    function tsParseArrayTypeOrHigher() {
        tsParseNonArrayType();
        while (!(0, util_1.hasPrecedingLineBreak)() && (0, index_1.eat)(types_1.TokenType.bracketL)) {
            if (!(0, index_1.eat)(types_1.TokenType.bracketR)) {
                // If we hit ] immediately, this is an array type, otherwise it's an indexed access type.
                tsParseType();
                (0, util_1.expect)(types_1.TokenType.bracketR);
            }
        }
    }
    function tsParseInferType() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._infer);
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType._extends)) {
            // Infer type constraints introduce an ambiguity about whether the "extends"
            // is a constraint for this infer type or is another conditional type.
            const snapshot = base_1.state.snapshot();
            (0, util_1.expect)(types_1.TokenType._extends);
            const oldInDisallowConditionalTypesContext = base_1.state.inDisallowConditionalTypesContext;
            base_1.state.inDisallowConditionalTypesContext = true;
            tsParseType();
            base_1.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
            if (base_1.state.error || (!base_1.state.inDisallowConditionalTypesContext && (0, index_1.match)(types_1.TokenType.question))) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
        }
    }
    function tsParseTypeOperatorOrHigher() {
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._keyof) ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._unique) ||
            (0, util_1.isContextual)(keywords_1.ContextualKeyword._readonly)) {
            (0, index_1.next)();
            tsParseTypeOperatorOrHigher();
        }
        else if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._infer)) {
            tsParseInferType();
        }
        else {
            const oldInDisallowConditionalTypesContext = base_1.state.inDisallowConditionalTypesContext;
            base_1.state.inDisallowConditionalTypesContext = false;
            tsParseArrayTypeOrHigher();
            base_1.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
        }
    }
    function tsParseIntersectionTypeOrHigher() {
        (0, index_1.eat)(types_1.TokenType.bitwiseAND);
        tsParseTypeOperatorOrHigher();
        if ((0, index_1.match)(types_1.TokenType.bitwiseAND)) {
            while ((0, index_1.eat)(types_1.TokenType.bitwiseAND)) {
                tsParseTypeOperatorOrHigher();
            }
        }
    }
    function tsParseUnionTypeOrHigher() {
        (0, index_1.eat)(types_1.TokenType.bitwiseOR);
        tsParseIntersectionTypeOrHigher();
        if ((0, index_1.match)(types_1.TokenType.bitwiseOR)) {
            while ((0, index_1.eat)(types_1.TokenType.bitwiseOR)) {
                tsParseIntersectionTypeOrHigher();
            }
        }
    }
    function tsIsStartOfFunctionType() {
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            return true;
        }
        return (0, index_1.match)(types_1.TokenType.parenL) && tsLookaheadIsUnambiguouslyStartOfFunctionType();
    }
    function tsSkipParameterStart() {
        if ((0, index_1.match)(types_1.TokenType.name) || (0, index_1.match)(types_1.TokenType._this)) {
            (0, index_1.next)();
            return true;
        }
        // If this is a possible array/object destructure, walk to the matching bracket/brace.
        // The next token after will tell us definitively whether this is a function param.
        if ((0, index_1.match)(types_1.TokenType.braceL) || (0, index_1.match)(types_1.TokenType.bracketL)) {
            let depth = 1;
            (0, index_1.next)();
            while (depth > 0 && !base_1.state.error) {
                if ((0, index_1.match)(types_1.TokenType.braceL) || (0, index_1.match)(types_1.TokenType.bracketL)) {
                    depth++;
                }
                else if ((0, index_1.match)(types_1.TokenType.braceR) || (0, index_1.match)(types_1.TokenType.bracketR)) {
                    depth--;
                }
                (0, index_1.next)();
            }
            return true;
        }
        return false;
    }
    function tsLookaheadIsUnambiguouslyStartOfFunctionType() {
        const snapshot = base_1.state.snapshot();
        const isUnambiguouslyStartOfFunctionType = tsIsUnambiguouslyStartOfFunctionType();
        base_1.state.restoreFromSnapshot(snapshot);
        return isUnambiguouslyStartOfFunctionType;
    }
    function tsIsUnambiguouslyStartOfFunctionType() {
        (0, index_1.next)();
        if ((0, index_1.match)(types_1.TokenType.parenR) || (0, index_1.match)(types_1.TokenType.ellipsis)) {
            // ( )
            // ( ...
            return true;
        }
        if (tsSkipParameterStart()) {
            if ((0, index_1.match)(types_1.TokenType.colon) || (0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.question) || (0, index_1.match)(types_1.TokenType.eq)) {
                // ( xxx :
                // ( xxx ,
                // ( xxx ?
                // ( xxx =
                return true;
            }
            if ((0, index_1.match)(types_1.TokenType.parenR)) {
                (0, index_1.next)();
                if ((0, index_1.match)(types_1.TokenType.arrow)) {
                    // ( xxx ) =>
                    return true;
                }
            }
        }
        return false;
    }
    function tsParseTypeOrTypePredicateAnnotation(returnToken) {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(returnToken);
        const finishedReturn = tsParseTypePredicateOrAssertsPrefix();
        if (!finishedReturn) {
            tsParseType();
        }
        (0, index_1.popTypeContext)(oldIsType);
    }
    function tsTryParseTypeOrTypePredicateAnnotation() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            tsParseTypeOrTypePredicateAnnotation(types_1.TokenType.colon);
        }
    }
    function tsTryParseTypeAnnotation() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            tsParseTypeAnnotation();
        }
    }
    function tsTryParseType() {
        if ((0, index_1.eat)(types_1.TokenType.colon)) {
            tsParseType();
        }
    }
    /**
     * Detect a few special return syntax cases: `x is T`, `asserts x`, `asserts x is T`,
     * `asserts this is T`.
     *
     * Returns true if we parsed the return type, false if there's still a type to be parsed.
     */
    function tsParseTypePredicateOrAssertsPrefix() {
        const snapshot = base_1.state.snapshot();
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._asserts)) {
            // Normally this is `asserts x is T`, but at this point, it might be `asserts is T` (a user-
            // defined type guard on the `asserts` variable) or just a type called `asserts`.
            (0, index_1.next)();
            if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._is)) {
                // If we see `asserts is`, then this must be of the form `asserts is T`, since
                // `asserts is is T` isn't valid.
                tsParseType();
                return true;
            }
            else if (tsIsIdentifier() || (0, index_1.match)(types_1.TokenType._this)) {
                (0, index_1.next)();
                if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._is)) {
                    // If we see `is`, then this is `asserts x is T`. Otherwise, it's `asserts x`.
                    tsParseType();
                }
                return true;
            }
            else {
                // Regular type, so bail out and start type parsing from scratch.
                base_1.state.restoreFromSnapshot(snapshot);
                return false;
            }
        }
        else if (tsIsIdentifier() || (0, index_1.match)(types_1.TokenType._this)) {
            // This is a regular identifier, which may or may not have "is" after it.
            (0, index_1.next)();
            if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._is) && !(0, util_1.hasPrecedingLineBreak)()) {
                (0, index_1.next)();
                tsParseType();
                return true;
            }
            else {
                // Regular type, so bail out and start type parsing from scratch.
                base_1.state.restoreFromSnapshot(snapshot);
                return false;
            }
        }
        return false;
    }
    function tsParseTypeAnnotation() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(types_1.TokenType.colon);
        tsParseType();
        (0, index_1.popTypeContext)(oldIsType);
    }
    function tsParseType() {
        tsParseNonConditionalType();
        if (base_1.state.inDisallowConditionalTypesContext || (0, util_1.hasPrecedingLineBreak)() || !(0, index_1.eat)(types_1.TokenType._extends)) {
            return;
        }
        // extends type
        const oldInDisallowConditionalTypesContext = base_1.state.inDisallowConditionalTypesContext;
        base_1.state.inDisallowConditionalTypesContext = true;
        tsParseNonConditionalType();
        base_1.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
        (0, util_1.expect)(types_1.TokenType.question);
        // true type
        tsParseType();
        (0, util_1.expect)(types_1.TokenType.colon);
        // false type
        tsParseType();
    }
    function isAbstractConstructorSignature() {
        return (0, util_1.isContextual)(keywords_1.ContextualKeyword._abstract) && (0, index_1.lookaheadType)() === types_1.TokenType._new;
    }
    function tsParseNonConditionalType() {
        if (tsIsStartOfFunctionType()) {
            tsParseFunctionOrConstructorType(FunctionType.TSFunctionType);
            return;
        }
        if ((0, index_1.match)(types_1.TokenType._new)) {
            // As in `new () => Date`
            tsParseFunctionOrConstructorType(FunctionType.TSConstructorType);
            return;
        }
        else if (isAbstractConstructorSignature()) {
            // As in `abstract new () => Date`
            tsParseFunctionOrConstructorType(FunctionType.TSAbstractConstructorType);
            return;
        }
        tsParseUnionTypeOrHigher();
    }
    function tsParseTypeAssertion() {
        const oldIsType = (0, index_1.pushTypeContext)(1);
        tsParseType();
        (0, util_1.expect)(types_1.TokenType.greaterThan);
        (0, index_1.popTypeContext)(oldIsType);
        (0, expression_1.parseMaybeUnary)();
    }
    function tsTryParseJSXTypeArgument() {
        if ((0, index_1.eat)(types_1.TokenType.jsxTagStart)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType.typeParameterStart;
            const oldIsType = (0, index_1.pushTypeContext)(1);
            while (!(0, index_1.match)(types_1.TokenType.greaterThan) && !base_1.state.error) {
                tsParseType();
                (0, index_1.eat)(types_1.TokenType.comma);
            }
            // Process >, but the one after needs to be parsed JSX-style.
            (0, jsx_1.nextJSXTagToken)();
            (0, index_1.popTypeContext)(oldIsType);
        }
    }
    function tsParseHeritageClause() {
        while (!(0, index_1.match)(types_1.TokenType.braceL) && !base_1.state.error) {
            tsParseExpressionWithTypeArguments();
            (0, index_1.eat)(types_1.TokenType.comma);
        }
    }
    function tsParseExpressionWithTypeArguments() {
        // Note: TS uses parseLeftHandSideExpressionOrHigher,
        // then has grammar errors later if it's not an EntityName.
        tsParseEntityName();
        if ((0, index_1.match)(types_1.TokenType.lessThan)) {
            tsParseTypeArguments();
        }
    }
    function tsParseInterfaceDeclaration() {
        (0, lval_1.parseBindingIdentifier)(false);
        tsTryParseTypeParameters();
        if ((0, index_1.eat)(types_1.TokenType._extends)) {
            tsParseHeritageClause();
        }
        tsParseObjectTypeMembers();
    }
    function tsParseTypeAliasDeclaration() {
        (0, lval_1.parseBindingIdentifier)(false);
        tsTryParseTypeParameters();
        (0, util_1.expect)(types_1.TokenType.eq);
        tsParseType();
        (0, util_1.semicolon)();
    }
    function tsParseEnumMember() {
        // Computed property names are grammar errors in an enum, so accept just string literal or identifier.
        if ((0, index_1.match)(types_1.TokenType.string)) {
            (0, expression_1.parseLiteral)();
        }
        else {
            (0, expression_1.parseIdentifier)();
        }
        if ((0, index_1.eat)(types_1.TokenType.eq)) {
            const eqIndex = base_1.state.tokens.length - 1;
            (0, expression_1.parseMaybeAssign)();
            base_1.state.tokens[eqIndex].rhsEndIndex = base_1.state.tokens.length;
        }
    }
    function tsParseEnumDeclaration() {
        (0, lval_1.parseBindingIdentifier)(false);
        (0, util_1.expect)(types_1.TokenType.braceL);
        while (!(0, index_1.eat)(types_1.TokenType.braceR) && !base_1.state.error) {
            tsParseEnumMember();
            (0, index_1.eat)(types_1.TokenType.comma);
        }
    }
    function tsParseModuleBlock() {
        (0, util_1.expect)(types_1.TokenType.braceL);
        (0, statement_1.parseBlockBody)(/* end */ types_1.TokenType.braceR);
    }
    function tsParseModuleOrNamespaceDeclaration() {
        (0, lval_1.parseBindingIdentifier)(false);
        if ((0, index_1.eat)(types_1.TokenType.dot)) {
            tsParseModuleOrNamespaceDeclaration();
        }
        else {
            tsParseModuleBlock();
        }
    }
    function tsParseAmbientExternalModuleDeclaration() {
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._global)) {
            (0, expression_1.parseIdentifier)();
        }
        else if ((0, index_1.match)(types_1.TokenType.string)) {
            (0, expression_1.parseExprAtom)();
        }
        else {
            (0, util_1.unexpected)();
        }
        if ((0, index_1.match)(types_1.TokenType.braceL)) {
            tsParseModuleBlock();
        }
        else {
            (0, util_1.semicolon)();
        }
    }
    function tsParseImportEqualsDeclaration() {
        (0, lval_1.parseImportedIdentifier)();
        (0, util_1.expect)(types_1.TokenType.eq);
        tsParseModuleReference();
        (0, util_1.semicolon)();
    }
    function tsIsExternalModuleReference() {
        return (0, util_1.isContextual)(keywords_1.ContextualKeyword._require) && (0, index_1.lookaheadType)() === types_1.TokenType.parenL;
    }
    function tsParseModuleReference() {
        if (tsIsExternalModuleReference()) {
            tsParseExternalModuleReference();
        }
        else {
            tsParseEntityName();
        }
    }
    function tsParseExternalModuleReference() {
        (0, util_1.expectContextual)(keywords_1.ContextualKeyword._require);
        (0, util_1.expect)(types_1.TokenType.parenL);
        if (!(0, index_1.match)(types_1.TokenType.string)) {
            (0, util_1.unexpected)();
        }
        (0, expression_1.parseLiteral)();
        (0, util_1.expect)(types_1.TokenType.parenR);
    }
    // Utilities
    // Returns true if a statement matched.
    function tsTryParseDeclare() {
        if ((0, util_1.isLineTerminator)()) {
            return false;
        }
        switch (base_1.state.type) {
            case types_1.TokenType._function: {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                (0, index_1.next)();
                // We don't need to precisely get the function start here, since it's only used to mark
                // the function as a type if it's bodiless, and it's already a type here.
                const functionStart = base_1.state.start;
                (0, statement_1.parseFunction)(functionStart, /* isStatement */ true);
                (0, index_1.popTypeContext)(oldIsType);
                return true;
            }
            case types_1.TokenType._class: {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                (0, statement_1.parseClass)(/* isStatement */ true, /* optionalId */ false);
                (0, index_1.popTypeContext)(oldIsType);
                return true;
            }
            case types_1.TokenType._const: {
                if ((0, index_1.match)(types_1.TokenType._const) && (0, util_1.isLookaheadContextual)(keywords_1.ContextualKeyword._enum)) {
                    const oldIsType = (0, index_1.pushTypeContext)(1);
                    // `const enum = 0;` not allowed because "enum" is a strict mode reserved word.
                    (0, util_1.expect)(types_1.TokenType._const);
                    (0, util_1.expectContextual)(keywords_1.ContextualKeyword._enum);
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._enum;
                    tsParseEnumDeclaration();
                    (0, index_1.popTypeContext)(oldIsType);
                    return true;
                }
            }
            // falls through
            case types_1.TokenType._var:
            case types_1.TokenType._let: {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                (0, statement_1.parseVarStatement)(base_1.state.type !== types_1.TokenType._var);
                (0, index_1.popTypeContext)(oldIsType);
                return true;
            }
            case types_1.TokenType.name: {
                const oldIsType = (0, index_1.pushTypeContext)(1);
                const contextualKeyword = base_1.state.contextualKeyword;
                let matched = false;
                if (contextualKeyword === keywords_1.ContextualKeyword._global) {
                    tsParseAmbientExternalModuleDeclaration();
                    matched = true;
                }
                else {
                    matched = tsParseDeclaration(contextualKeyword, /* isBeforeToken */ true);
                }
                (0, index_1.popTypeContext)(oldIsType);
                return matched;
            }
            default:
                return false;
        }
    }
    // Note: this won't be called unless the keyword is allowed in `shouldParseExportDeclaration`.
    // Returns true if it matched a declaration.
    function tsTryParseExportDeclaration() {
        return tsParseDeclaration(base_1.state.contextualKeyword, /* isBeforeToken */ true);
    }
    // Returns true if it matched a statement.
    function tsParseExpressionStatement(contextualKeyword) {
        switch (contextualKeyword) {
            case keywords_1.ContextualKeyword._declare: {
                const declareTokenIndex = base_1.state.tokens.length - 1;
                const matched = tsTryParseDeclare();
                if (matched) {
                    base_1.state.tokens[declareTokenIndex].type = types_1.TokenType._declare;
                    return true;
                }
                break;
            }
            case keywords_1.ContextualKeyword._global:
                // `global { }` (with no `declare`) may appear inside an ambient module declaration.
                // Would like to use tsParseAmbientExternalModuleDeclaration here, but already ran past "global".
                if ((0, index_1.match)(types_1.TokenType.braceL)) {
                    tsParseModuleBlock();
                    return true;
                }
                break;
            default:
                return tsParseDeclaration(contextualKeyword, /* isBeforeToken */ false);
        }
        return false;
    }
    /**
     * Common code for parsing a declaration.
     *
     * isBeforeToken indicates that the current parser state is at the contextual
     * keyword (and that it is not yet emitted) rather than reading the token after
     * it. When isBeforeToken is true, we may be preceded by an `export` token and
     * should include that token in a type context we create, e.g. to handle
     * `export interface` or `export type`. (This is a bit of a hack and should be
     * cleaned up at some point.)
     *
     * Returns true if it matched a declaration.
     */
    function tsParseDeclaration(contextualKeyword, isBeforeToken) {
        switch (contextualKeyword) {
            case keywords_1.ContextualKeyword._abstract:
                if (tsCheckLineTerminator(isBeforeToken) && (0, index_1.match)(types_1.TokenType._class)) {
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._abstract;
                    (0, statement_1.parseClass)(/* isStatement */ true, /* optionalId */ false);
                    return true;
                }
                break;
            case keywords_1.ContextualKeyword._enum:
                if (tsCheckLineTerminator(isBeforeToken) && (0, index_1.match)(types_1.TokenType.name)) {
                    base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._enum;
                    tsParseEnumDeclaration();
                    return true;
                }
                break;
            case keywords_1.ContextualKeyword._interface:
                if (tsCheckLineTerminator(isBeforeToken) && (0, index_1.match)(types_1.TokenType.name)) {
                    // `next` is true in "export" and "declare" contexts, so we want to remove that token
                    // as well.
                    const oldIsType = (0, index_1.pushTypeContext)(isBeforeToken ? 2 : 1);
                    tsParseInterfaceDeclaration();
                    (0, index_1.popTypeContext)(oldIsType);
                    return true;
                }
                break;
            case keywords_1.ContextualKeyword._module:
                if (tsCheckLineTerminator(isBeforeToken)) {
                    if ((0, index_1.match)(types_1.TokenType.string)) {
                        const oldIsType = (0, index_1.pushTypeContext)(isBeforeToken ? 2 : 1);
                        tsParseAmbientExternalModuleDeclaration();
                        (0, index_1.popTypeContext)(oldIsType);
                        return true;
                    }
                    else if ((0, index_1.match)(types_1.TokenType.name)) {
                        const oldIsType = (0, index_1.pushTypeContext)(isBeforeToken ? 2 : 1);
                        tsParseModuleOrNamespaceDeclaration();
                        (0, index_1.popTypeContext)(oldIsType);
                        return true;
                    }
                }
                break;
            case keywords_1.ContextualKeyword._namespace:
                if (tsCheckLineTerminator(isBeforeToken) && (0, index_1.match)(types_1.TokenType.name)) {
                    const oldIsType = (0, index_1.pushTypeContext)(isBeforeToken ? 2 : 1);
                    tsParseModuleOrNamespaceDeclaration();
                    (0, index_1.popTypeContext)(oldIsType);
                    return true;
                }
                break;
            case keywords_1.ContextualKeyword._type:
                if (tsCheckLineTerminator(isBeforeToken) && (0, index_1.match)(types_1.TokenType.name)) {
                    const oldIsType = (0, index_1.pushTypeContext)(isBeforeToken ? 2 : 1);
                    tsParseTypeAliasDeclaration();
                    (0, index_1.popTypeContext)(oldIsType);
                    return true;
                }
                break;
            default:
                break;
        }
        return false;
    }
    function tsCheckLineTerminator(isBeforeToken) {
        if (isBeforeToken) {
            // Babel checks hasFollowingLineBreak here and returns false, but this
            // doesn't actually come up, e.g. `export interface` can never be on its own
            // line in valid code.
            (0, index_1.next)();
            return true;
        }
        else {
            return !(0, util_1.isLineTerminator)();
        }
    }
    // Returns true if there was a generic async arrow function.
    function tsTryParseGenericAsyncArrowFunction() {
        const snapshot = base_1.state.snapshot();
        tsParseTypeParameters();
        (0, statement_1.parseFunctionParams)();
        tsTryParseTypeOrTypePredicateAnnotation();
        (0, util_1.expect)(types_1.TokenType.arrow);
        if (base_1.state.error) {
            base_1.state.restoreFromSnapshot(snapshot);
            return false;
        }
        (0, expression_1.parseFunctionBody)(true);
        return true;
    }
    /**
     * If necessary, hack the tokenizer state so that this bitshift was actually a
     * less-than token, then keep parsing. This should only be used in situations
     * where we restore from snapshot on error (which reverts this change) or
     * where bitshift would be illegal anyway (e.g. in a class "extends" clause).
     *
     * This hack is useful to handle situations like foo<<T>() => void>() where
     * there can legitimately be two open-angle-brackets in a row in TS.
     */
    function tsParseTypeArgumentsWithPossibleBitshift() {
        if (base_1.state.type === types_1.TokenType.bitShiftL) {
            base_1.state.pos -= 1;
            (0, index_1.finishToken)(types_1.TokenType.lessThan);
        }
        tsParseTypeArguments();
    }
    function tsParseTypeArguments() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, util_1.expect)(types_1.TokenType.lessThan);
        while (!(0, index_1.match)(types_1.TokenType.greaterThan) && !base_1.state.error) {
            tsParseType();
            (0, index_1.eat)(types_1.TokenType.comma);
        }
        if (!oldIsType) {
            // If the type arguments are present in an expression context, e.g.
            // f<number>(), then the > sign should be tokenized as a non-type token.
            // In particular, f(a < b, c >= d) should parse the >= as a single token,
            // resulting in a syntax error and fallback to the non-type-args
            // interpretation. In the success case, even though the > is tokenized as a
            // non-type token, it still must be marked as a type token so that it is
            // erased.
            (0, index_1.popTypeContext)(oldIsType);
            (0, index_1.rescan_gt)();
            (0, util_1.expect)(types_1.TokenType.greaterThan);
            base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
        }
        else {
            (0, util_1.expect)(types_1.TokenType.greaterThan);
            (0, index_1.popTypeContext)(oldIsType);
        }
    }
    function tsIsDeclarationStart() {
        if ((0, index_1.match)(types_1.TokenType.name)) {
            switch (base_1.state.contextualKeyword) {
                case keywords_1.ContextualKeyword._abstract:
                case keywords_1.ContextualKeyword._declare:
                case keywords_1.ContextualKeyword._enum:
                case keywords_1.ContextualKeyword._interface:
                case keywords_1.ContextualKeyword._module:
                case keywords_1.ContextualKeyword._namespace:
                case keywords_1.ContextualKeyword._type:
                    return true;
                default:
                    break;
            }
        }
        return false;
    }
    // ======================================================
    // OVERRIDES
    // ======================================================
    function tsParseFunctionBodyAndFinish(functionStart, funcContextId) {
        // For arrow functions, `parseArrow` handles the return type itself.
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            tsParseTypeOrTypePredicateAnnotation(types_1.TokenType.colon);
        }
        // The original code checked the node type to make sure this function type allows a missing
        // body, but we skip that to avoid sending around the node type. We instead just use the
        // allowExpressionBody boolean to make sure it's not an arrow function.
        if (!(0, index_1.match)(types_1.TokenType.braceL) && (0, util_1.isLineTerminator)()) {
            // Retroactively mark the function declaration as a type.
            let i = base_1.state.tokens.length - 1;
            while (i >= 0 &&
                (base_1.state.tokens[i].start >= functionStart ||
                    base_1.state.tokens[i].type === types_1.TokenType._default ||
                    base_1.state.tokens[i].type === types_1.TokenType._export)) {
                base_1.state.tokens[i].isType = true;
                i--;
            }
            return;
        }
        (0, expression_1.parseFunctionBody)(false, funcContextId);
    }
    function tsParseSubscript(startTokenIndex, noCalls, stopState) {
        if (!(0, util_1.hasPrecedingLineBreak)() && (0, index_1.eat)(types_1.TokenType.bang)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType.nonNullAssertion;
            return;
        }
        if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.bitShiftL)) {
            // There are number of things we are going to "maybe" parse, like type arguments on
            // tagged template expressions. If any of them fail, walk it back and continue.
            const snapshot = base_1.state.snapshot();
            if (!noCalls && (0, expression_1.atPossibleAsync)()) {
                // Almost certainly this is a generic async function `async <T>() => ...
                // But it might be a call with a type argument `async<T>();`
                const asyncArrowFn = tsTryParseGenericAsyncArrowFunction();
                if (asyncArrowFn) {
                    return;
                }
            }
            tsParseTypeArgumentsWithPossibleBitshift();
            if (!noCalls && (0, index_1.eat)(types_1.TokenType.parenL)) {
                // With f<T>(), the subscriptStartIndex marker is on the ( token.
                base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
                (0, expression_1.parseCallExpressionArguments)();
            }
            else if ((0, index_1.match)(types_1.TokenType.backQuote)) {
                // Tagged template with a type argument.
                (0, expression_1.parseTemplate)();
            }
            else if (
            // The remaining possible case is an instantiation expression, e.g.
            // Array<number> . Check for a few cases that would disqualify it and
            // cause us to bail out.
            // a<b>>c is not (a<b>)>c, but a<(b>>c)
            base_1.state.type === types_1.TokenType.greaterThan ||
                // a<b>c is (a<b)>c
                (base_1.state.type !== types_1.TokenType.parenL &&
                    Boolean(base_1.state.type & types_1.TokenType.IS_EXPRESSION_START) &&
                    !(0, util_1.hasPrecedingLineBreak)())) {
                // Bail out. We have something like a<b>c, which is not an expression with
                // type arguments but an (a < b) > c comparison.
                (0, util_1.unexpected)();
            }
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
            else {
                return;
            }
        }
        else if (!noCalls && (0, index_1.match)(types_1.TokenType.questionDot) && (0, index_1.lookaheadType)() === types_1.TokenType.lessThan) {
            // If we see f?.<, then this must be an optional call with a type argument.
            (0, index_1.next)();
            base_1.state.tokens[startTokenIndex].isOptionalChainStart = true;
            // With f?.<T>(), the subscriptStartIndex marker is on the ?. token.
            base_1.state.tokens[base_1.state.tokens.length - 1].subscriptStartIndex = startTokenIndex;
            tsParseTypeArguments();
            (0, util_1.expect)(types_1.TokenType.parenL);
            (0, expression_1.parseCallExpressionArguments)();
        }
        (0, expression_1.baseParseSubscript)(startTokenIndex, noCalls, stopState);
    }
    function tsTryParseExport() {
        if ((0, index_1.eat)(types_1.TokenType._import)) {
            // One of these cases:
            // export import A = B;
            // export import type A = require("A");
            if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type) && (0, index_1.lookaheadType)() !== types_1.TokenType.eq) {
                // Eat a `type` token, unless it's actually an identifier name.
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._type);
            }
            tsParseImportEqualsDeclaration();
            return true;
        }
        else if ((0, index_1.eat)(types_1.TokenType.eq)) {
            // `export = x;`
            (0, expression_1.parseExpression)();
            (0, util_1.semicolon)();
            return true;
        }
        else if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._as)) {
            // `export as namespace A;`
            // See `parseNamespaceExportDeclaration` in TypeScript's own parser
            (0, util_1.expectContextual)(keywords_1.ContextualKeyword._namespace);
            (0, expression_1.parseIdentifier)();
            (0, util_1.semicolon)();
            return true;
        }
        else {
            if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._type)) {
                const nextType = (0, index_1.lookaheadType)();
                // export type {foo} from 'a';
                // export type * from 'a';'
                // export type * as ns from 'a';'
                if (nextType === types_1.TokenType.braceL || nextType === types_1.TokenType.star) {
                    (0, index_1.next)();
                }
            }
            return false;
        }
    }
    /**
     * Parse a TS import specifier, which may be prefixed with "type" and may be of
     * the form `foo as bar`.
     *
     * The number of identifier-like tokens we see happens to be enough to uniquely
     * identify the form, so simply count the number of identifiers rather than
     * matching the words `type` or `as`. This is particularly important because
     * `type` and `as` could each actually be plain identifiers rather than
     * keywords.
     */
    function tsParseImportSpecifier() {
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // import {foo}
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ImportDeclaration;
            return;
        }
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // import {type foo}
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ImportDeclaration;
            base_1.state.tokens[base_1.state.tokens.length - 2].isType = true;
            base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
            return;
        }
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // import {foo as bar}
            base_1.state.tokens[base_1.state.tokens.length - 3].identifierRole = index_1.IdentifierRole.ImportAccess;
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ImportDeclaration;
            return;
        }
        (0, expression_1.parseIdentifier)();
        // import {type foo as bar}
        base_1.state.tokens[base_1.state.tokens.length - 3].identifierRole = index_1.IdentifierRole.ImportAccess;
        base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ImportDeclaration;
        base_1.state.tokens[base_1.state.tokens.length - 4].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 3].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 2].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
    }
    /**
     * Just like named import specifiers, export specifiers can have from 1 to 4
     * tokens, inclusive, and the number of tokens determines the role of each token.
     */
    function tsParseExportSpecifier() {
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // export {foo}
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ExportAccess;
            return;
        }
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // export {type foo}
            base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ExportAccess;
            base_1.state.tokens[base_1.state.tokens.length - 2].isType = true;
            base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
            return;
        }
        (0, expression_1.parseIdentifier)();
        if ((0, index_1.match)(types_1.TokenType.comma) || (0, index_1.match)(types_1.TokenType.braceR)) {
            // export {foo as bar}
            base_1.state.tokens[base_1.state.tokens.length - 3].identifierRole = index_1.IdentifierRole.ExportAccess;
            return;
        }
        (0, expression_1.parseIdentifier)();
        // export {type foo as bar}
        base_1.state.tokens[base_1.state.tokens.length - 3].identifierRole = index_1.IdentifierRole.ExportAccess;
        base_1.state.tokens[base_1.state.tokens.length - 4].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 3].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 2].isType = true;
        base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
    }
    function tsTryParseExportDefaultExpression() {
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._abstract) && (0, index_1.lookaheadType)() === types_1.TokenType._class) {
            base_1.state.type = types_1.TokenType._abstract;
            (0, index_1.next)(); // Skip "abstract"
            (0, statement_1.parseClass)(true, true);
            return true;
        }
        if ((0, util_1.isContextual)(keywords_1.ContextualKeyword._interface)) {
            // Make sure "export default" are considered type tokens so the whole thing is removed.
            const oldIsType = (0, index_1.pushTypeContext)(2);
            tsParseDeclaration(keywords_1.ContextualKeyword._interface, true);
            (0, index_1.popTypeContext)(oldIsType);
            return true;
        }
        return false;
    }
    function tsTryParseStatementContent() {
        if (base_1.state.type === types_1.TokenType._const) {
            const ahead = (0, index_1.lookaheadTypeAndKeyword)();
            if (ahead.type === types_1.TokenType.name && ahead.contextualKeyword === keywords_1.ContextualKeyword._enum) {
                (0, util_1.expect)(types_1.TokenType._const);
                (0, util_1.expectContextual)(keywords_1.ContextualKeyword._enum);
                base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._enum;
                tsParseEnumDeclaration();
                return true;
            }
        }
        return false;
    }
    function tsTryParseClassMemberWithIsStatic(isStatic) {
        const memberStartIndexAfterStatic = base_1.state.tokens.length;
        tsParseModifiers([
            keywords_1.ContextualKeyword._abstract,
            keywords_1.ContextualKeyword._readonly,
            keywords_1.ContextualKeyword._declare,
            keywords_1.ContextualKeyword._static,
            keywords_1.ContextualKeyword._override,
        ]);
        const modifiersEndIndex = base_1.state.tokens.length;
        const found = tsTryParseIndexSignature();
        if (found) {
            // Index signatures are type declarations, so set the modifier tokens as
            // type tokens. Most tokens could be assumed to be type tokens, but `static`
            // is ambiguous unless we set it explicitly here.
            const memberStartIndex = isStatic
                ? memberStartIndexAfterStatic - 1
                : memberStartIndexAfterStatic;
            for (let i = memberStartIndex; i < modifiersEndIndex; i++) {
                base_1.state.tokens[i].isType = true;
            }
            return true;
        }
        return false;
    }
    // Note: The reason we do this in `parseIdentifierStatement` and not `parseStatement`
    // is that e.g. `type()` is valid JS, so we must try parsing that first.
    // If it's really a type, we will parse `type` as the statement, and can correct it here
    // by parsing the rest.
    function tsParseIdentifierStatement(contextualKeyword) {
        const matched = tsParseExpressionStatement(contextualKeyword);
        if (!matched) {
            (0, util_1.semicolon)();
        }
    }
    function tsParseExportDeclaration() {
        // "export declare" is equivalent to just "export".
        const isDeclare = (0, util_1.eatContextual)(keywords_1.ContextualKeyword._declare);
        if (isDeclare) {
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._declare;
        }
        let matchedDeclaration = false;
        if ((0, index_1.match)(types_1.TokenType.name)) {
            if (isDeclare) {
                const oldIsType = (0, index_1.pushTypeContext)(2);
                matchedDeclaration = tsTryParseExportDeclaration();
                (0, index_1.popTypeContext)(oldIsType);
            }
            else {
                matchedDeclaration = tsTryParseExportDeclaration();
            }
        }
        if (!matchedDeclaration) {
            if (isDeclare) {
                const oldIsType = (0, index_1.pushTypeContext)(2);
                (0, statement_1.parseStatement)(true);
                (0, index_1.popTypeContext)(oldIsType);
            }
            else {
                (0, statement_1.parseStatement)(true);
            }
        }
    }
    function tsAfterParseClassSuper(hasSuper) {
        if (hasSuper && ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.bitShiftL))) {
            tsParseTypeArgumentsWithPossibleBitshift();
        }
        if ((0, util_1.eatContextual)(keywords_1.ContextualKeyword._implements)) {
            base_1.state.tokens[base_1.state.tokens.length - 1].type = types_1.TokenType._implements;
            const oldIsType = (0, index_1.pushTypeContext)(1);
            tsParseHeritageClause();
            (0, index_1.popTypeContext)(oldIsType);
        }
    }
    function tsStartParseObjPropValue() {
        tsTryParseTypeParameters();
    }
    function tsStartParseFunctionParams() {
        tsTryParseTypeParameters();
    }
    // `let x: number;`
    function tsAfterParseVarHead() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        if (!(0, util_1.hasPrecedingLineBreak)()) {
            (0, index_1.eat)(types_1.TokenType.bang);
        }
        tsTryParseTypeAnnotation();
        (0, index_1.popTypeContext)(oldIsType);
    }
    // parse the return type of an async arrow function - let foo = (async (): number => {});
    function tsStartParseAsyncArrowFromCallExpression() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            tsParseTypeAnnotation();
        }
    }
    // Returns true if the expression was an arrow function.
    function tsParseMaybeAssign(noIn, isWithinParens) {
        // Note: When the JSX plugin is on, type assertions (`<T> x`) aren't valid syntax.
        if (base_1.isJSXEnabled) {
            return tsParseMaybeAssignWithJSX(noIn, isWithinParens);
        }
        else {
            return tsParseMaybeAssignWithoutJSX(noIn, isWithinParens);
        }
    }
    function tsParseMaybeAssignWithJSX(noIn, isWithinParens) {
        if (!(0, index_1.match)(types_1.TokenType.lessThan)) {
            return (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
        }
        // Prefer to parse JSX if possible. But may be an arrow fn.
        const snapshot = base_1.state.snapshot();
        let wasArrow = (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
        if (base_1.state.error) {
            base_1.state.restoreFromSnapshot(snapshot);
        }
        else {
            return wasArrow;
        }
        // Otherwise, try as type-parameterized arrow function.
        base_1.state.type = types_1.TokenType.typeParameterStart;
        // This is similar to TypeScript's `tryParseParenthesizedArrowFunctionExpression`.
        tsParseTypeParameters();
        wasArrow = (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
        if (!wasArrow) {
            (0, util_1.unexpected)();
        }
        return wasArrow;
    }
    function tsParseMaybeAssignWithoutJSX(noIn, isWithinParens) {
        if (!(0, index_1.match)(types_1.TokenType.lessThan)) {
            return (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
        }
        const snapshot = base_1.state.snapshot();
        // This is similar to TypeScript's `tryParseParenthesizedArrowFunctionExpression`.
        tsParseTypeParameters();
        const wasArrow = (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
        if (!wasArrow) {
            (0, util_1.unexpected)();
        }
        if (base_1.state.error) {
            base_1.state.restoreFromSnapshot(snapshot);
        }
        else {
            return wasArrow;
        }
        // Try parsing a type cast instead of an arrow function.
        // This will start with a type assertion (via parseMaybeUnary).
        // But don't directly call `tsParseTypeAssertion` because we want to handle any binary after it.
        return (0, expression_1.baseParseMaybeAssign)(noIn, isWithinParens);
    }
    function tsParseArrow() {
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            // This is different from how the TS parser does it.
            // TS uses lookahead. Babylon parses it as a parenthesized expression and converts.
            const snapshot = base_1.state.snapshot();
            tsParseTypeOrTypePredicateAnnotation(types_1.TokenType.colon);
            if ((0, util_1.canInsertSemicolon)())
                (0, util_1.unexpected)();
            if (!(0, index_1.match)(types_1.TokenType.arrow))
                (0, util_1.unexpected)();
            if (base_1.state.error) {
                base_1.state.restoreFromSnapshot(snapshot);
            }
        }
        return (0, index_1.eat)(types_1.TokenType.arrow);
    }
    // Allow type annotations inside of a parameter list.
    function tsParseAssignableListItemTypes() {
        const oldIsType = (0, index_1.pushTypeContext)(0);
        (0, index_1.eat)(types_1.TokenType.question);
        tsTryParseTypeAnnotation();
        (0, index_1.popTypeContext)(oldIsType);
    }
    function tsParseMaybeDecoratorArguments() {
        if ((0, index_1.match)(types_1.TokenType.lessThan) || (0, index_1.match)(types_1.TokenType.bitShiftL)) {
            tsParseTypeArgumentsWithPossibleBitshift();
        }
        (0, statement_1.baseParseMaybeDecoratorArguments)();
    }
},
"4cefc59e67": /* sucrase\dist\esm\parser\traverser\lval.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parseSpread = parseSpread;
    exports.parseRest = parseRest;
    exports.parseBindingIdentifier = parseBindingIdentifier;
    exports.parseImportedIdentifier = parseImportedIdentifier;
    exports.markPriorBindingIdentifier = markPriorBindingIdentifier;
    exports.parseBindingAtom = parseBindingAtom;
    exports.parseBindingList = parseBindingList;
    exports.parseMaybeDefault = parseMaybeDefault;
    const flow_1 = require("9b8d43cd0a") /* ../plugins/flow */;
    const typescript_1 = require("6a970c22b9") /* ../plugins/typescript */;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const keywords_1 = require("99ff836c64") /* ../tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const base_1 = require("540718e523") /* ./base */;
    const expression_1 = require("8178e7c3c8") /* ./expression */;
    const util_1 = require("bc94bbadc1") /* ./util */;
    function parseSpread() {
        (0, index_1.next)();
        (0, expression_1.parseMaybeAssign)(false);
    }
    function parseRest(isBlockScope) {
        (0, index_1.next)();
        parseBindingAtom(isBlockScope);
    }
    function parseBindingIdentifier(isBlockScope) {
        (0, expression_1.parseIdentifier)();
        markPriorBindingIdentifier(isBlockScope);
    }
    function parseImportedIdentifier() {
        (0, expression_1.parseIdentifier)();
        base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = index_1.IdentifierRole.ImportDeclaration;
    }
    function markPriorBindingIdentifier(isBlockScope) {
        let identifierRole;
        if (base_1.state.scopeDepth === 0) {
            identifierRole = index_1.IdentifierRole.TopLevelDeclaration;
        }
        else if (isBlockScope) {
            identifierRole = index_1.IdentifierRole.BlockScopedDeclaration;
        }
        else {
            identifierRole = index_1.IdentifierRole.FunctionScopedDeclaration;
        }
        base_1.state.tokens[base_1.state.tokens.length - 1].identifierRole = identifierRole;
    }
    // Parses lvalue (assignable) atom.
    function parseBindingAtom(isBlockScope) {
        switch (base_1.state.type) {
            case types_1.TokenType._this: {
                // In TypeScript, "this" may be the name of a parameter, so allow it.
                const oldIsType = (0, index_1.pushTypeContext)(0);
                (0, index_1.next)();
                (0, index_1.popTypeContext)(oldIsType);
                return;
            }
            case types_1.TokenType._yield:
            case types_1.TokenType.name: {
                base_1.state.type = types_1.TokenType.name;
                parseBindingIdentifier(isBlockScope);
                return;
            }
            case types_1.TokenType.bracketL: {
                (0, index_1.next)();
                parseBindingList(types_1.TokenType.bracketR, isBlockScope, true /* allowEmpty */);
                return;
            }
            case types_1.TokenType.braceL:
                (0, expression_1.parseObj)(true, isBlockScope);
                return;
            default:
                (0, util_1.unexpected)();
        }
    }
    function parseBindingList(close, isBlockScope, allowEmpty = false, allowModifiers = false, contextId = 0) {
        let first = true;
        let hasRemovedComma = false;
        const firstItemTokenIndex = base_1.state.tokens.length;
        while (!(0, index_1.eat)(close) && !base_1.state.error) {
            if (first) {
                first = false;
            }
            else {
                (0, util_1.expect)(types_1.TokenType.comma);
                base_1.state.tokens[base_1.state.tokens.length - 1].contextId = contextId;
                // After a "this" type in TypeScript, we need to set the following comma (if any) to also be
                // a type token so that it will be removed.
                if (!hasRemovedComma && base_1.state.tokens[firstItemTokenIndex].isType) {
                    base_1.state.tokens[base_1.state.tokens.length - 1].isType = true;
                    hasRemovedComma = true;
                }
            }
            if (allowEmpty && (0, index_1.match)(types_1.TokenType.comma)) {
                // Empty item; nothing further to parse for this item.
            }
            else if ((0, index_1.eat)(close)) {
                break;
            }
            else if ((0, index_1.match)(types_1.TokenType.ellipsis)) {
                parseRest(isBlockScope);
                parseAssignableListItemTypes();
                // Support rest element trailing commas allowed by TypeScript <2.9.
                (0, index_1.eat)(types_1.TokenType.comma);
                (0, util_1.expect)(close);
                break;
            }
            else {
                parseAssignableListItem(allowModifiers, isBlockScope);
            }
        }
    }
    function parseAssignableListItem(allowModifiers, isBlockScope) {
        if (allowModifiers) {
            (0, typescript_1.tsParseModifiers)([
                keywords_1.ContextualKeyword._public,
                keywords_1.ContextualKeyword._protected,
                keywords_1.ContextualKeyword._private,
                keywords_1.ContextualKeyword._readonly,
                keywords_1.ContextualKeyword._override,
            ]);
        }
        parseMaybeDefault(isBlockScope);
        parseAssignableListItemTypes();
        parseMaybeDefault(isBlockScope, true /* leftAlreadyParsed */);
    }
    function parseAssignableListItemTypes() {
        if (base_1.isFlowEnabled) {
            (0, flow_1.flowParseAssignableListItemTypes)();
        }
        else if (base_1.isTypeScriptEnabled) {
            (0, typescript_1.tsParseAssignableListItemTypes)();
        }
    }
    // Parses assignment pattern around given atom if possible.
    function parseMaybeDefault(isBlockScope, leftAlreadyParsed = false) {
        if (!leftAlreadyParsed) {
            parseBindingAtom(isBlockScope);
        }
        if (!(0, index_1.eat)(types_1.TokenType.eq)) {
            return;
        }
        const eqIndex = base_1.state.tokens.length - 1;
        (0, expression_1.parseMaybeAssign)();
        base_1.state.tokens[eqIndex].rhsEndIndex = base_1.state.tokens.length;
    }
},
"85c51351f6": /* sucrase\dist\esm\parser\plugins\types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.typedParseConditional = typedParseConditional;
    exports.typedParseParenItem = typedParseParenItem;
    const index_1 = require("bfb18d0576") /* ../tokenizer/index */;
    const types_1 = require("f0c35cbd76") /* ../tokenizer/types */;
    const base_1 = require("540718e523") /* ../traverser/base */;
    const expression_1 = require("8178e7c3c8") /* ../traverser/expression */;
    const flow_1 = require("9b8d43cd0a") /* ./flow */;
    const typescript_1 = require("6a970c22b9") /* ./typescript */;
    /**
     * Common parser code for TypeScript and Flow.
     */
    // An apparent conditional expression could actually be an optional parameter in an arrow function.
    function typedParseConditional(noIn) {
        // If we see ?:, this can't possibly be a valid conditional. typedParseParenItem will be called
        // later to finish off the arrow parameter. We also need to handle bare ? tokens for optional
        // parameters without type annotations, i.e. ?, and ?) .
        if ((0, index_1.match)(types_1.TokenType.question)) {
            const nextType = (0, index_1.lookaheadType)();
            if (nextType === types_1.TokenType.colon || nextType === types_1.TokenType.comma || nextType === types_1.TokenType.parenR) {
                return;
            }
        }
        (0, expression_1.baseParseConditional)(noIn);
    }
    // Note: These "type casts" are *not* valid TS expressions.
    // But we parse them here and change them when completing the arrow function.
    function typedParseParenItem() {
        (0, index_1.eatTypeToken)(types_1.TokenType.question);
        if ((0, index_1.match)(types_1.TokenType.colon)) {
            if (base_1.isTypeScriptEnabled) {
                (0, typescript_1.tsParseTypeAnnotation)();
            }
            else if (base_1.isFlowEnabled) {
                (0, flow_1.flowParseTypeAnnotation)();
            }
        }
    }
},
"1c7cc5e988": /* sucrase\dist\esm\TokenProcessor.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ./parser/tokenizer/types */;
    const isAsyncOperation_1 = tslib_1.__importDefault(require("3e31f9f9c3") /* ./util/isAsyncOperation */);
    class TokenProcessor {
        __init() { this.resultCode = ""; }
        // Array mapping input token index to optional string index position in the
        // output code.
        __init2() { this.resultMappings = new Array(this.tokens.length); }
        __init3() { this.tokenIndex = 0; }
        constructor(code, tokens, isFlowEnabled, disableESTransforms, helperManager) { ; this.code = code; this.tokens = tokens; this.isFlowEnabled = isFlowEnabled; this.disableESTransforms = disableESTransforms; this.helperManager = helperManager; TokenProcessor.prototype.__init.call(this); TokenProcessor.prototype.__init2.call(this); TokenProcessor.prototype.__init3.call(this); }
        /**
         * Snapshot the token state in a way that can be restored later, useful for
         * things like lookahead.
         *
         * resultMappings do not need to be copied since in all use cases, they will
         * be overwritten anyway after restore.
         */
        snapshot() {
            return {
                resultCode: this.resultCode,
                tokenIndex: this.tokenIndex,
            };
        }
        restoreToSnapshot(snapshot) {
            this.resultCode = snapshot.resultCode;
            this.tokenIndex = snapshot.tokenIndex;
        }
        /**
         * Remove and return the code generated since the snapshot, leaving the
         * current token position in-place. Unlike most TokenProcessor operations,
         * this operation can result in input/output line number mismatches because
         * the removed code may contain newlines, so this operation should be used
         * sparingly.
         */
        dangerouslyGetAndRemoveCodeSinceSnapshot(snapshot) {
            const result = this.resultCode.slice(snapshot.resultCode.length);
            this.resultCode = snapshot.resultCode;
            return result;
        }
        reset() {
            this.resultCode = "";
            this.resultMappings = new Array(this.tokens.length);
            this.tokenIndex = 0;
        }
        matchesContextualAtIndex(index, contextualKeyword) {
            return (this.matches1AtIndex(index, types_1.TokenType.name) &&
                this.tokens[index].contextualKeyword === contextualKeyword);
        }
        identifierNameAtIndex(index) {
            // TODO: We need to process escapes since technically you can have unicode escapes in variable
            // names.
            return this.identifierNameForToken(this.tokens[index]);
        }
        identifierNameAtRelativeIndex(relativeIndex) {
            return this.identifierNameForToken(this.tokenAtRelativeIndex(relativeIndex));
        }
        identifierName() {
            return this.identifierNameForToken(this.currentToken());
        }
        identifierNameForToken(token) {
            return this.code.slice(token.start, token.end);
        }
        rawCodeForToken(token) {
            return this.code.slice(token.start, token.end);
        }
        stringValueAtIndex(index) {
            return this.stringValueForToken(this.tokens[index]);
        }
        stringValue() {
            return this.stringValueForToken(this.currentToken());
        }
        stringValueForToken(token) {
            // This is used to identify when two imports are the same and to resolve TypeScript enum keys.
            // Ideally we'd process escapes within the strings, but for now we pretty much take the raw
            // code.
            return this.code.slice(token.start + 1, token.end - 1);
        }
        matches1AtIndex(index, t1) {
            return this.tokens[index].type === t1;
        }
        matches2AtIndex(index, t1, t2) {
            return this.tokens[index].type === t1 && this.tokens[index + 1].type === t2;
        }
        matches3AtIndex(index, t1, t2, t3) {
            return (this.tokens[index].type === t1 &&
                this.tokens[index + 1].type === t2 &&
                this.tokens[index + 2].type === t3);
        }
        matches1(t1) {
            return this.tokens[this.tokenIndex].type === t1;
        }
        matches2(t1, t2) {
            return this.tokens[this.tokenIndex].type === t1 && this.tokens[this.tokenIndex + 1].type === t2;
        }
        matches3(t1, t2, t3) {
            return (this.tokens[this.tokenIndex].type === t1 &&
                this.tokens[this.tokenIndex + 1].type === t2 &&
                this.tokens[this.tokenIndex + 2].type === t3);
        }
        matches4(t1, t2, t3, t4) {
            return (this.tokens[this.tokenIndex].type === t1 &&
                this.tokens[this.tokenIndex + 1].type === t2 &&
                this.tokens[this.tokenIndex + 2].type === t3 &&
                this.tokens[this.tokenIndex + 3].type === t4);
        }
        matches5(t1, t2, t3, t4, t5) {
            return (this.tokens[this.tokenIndex].type === t1 &&
                this.tokens[this.tokenIndex + 1].type === t2 &&
                this.tokens[this.tokenIndex + 2].type === t3 &&
                this.tokens[this.tokenIndex + 3].type === t4 &&
                this.tokens[this.tokenIndex + 4].type === t5);
        }
        matchesContextual(contextualKeyword) {
            return this.matchesContextualAtIndex(this.tokenIndex, contextualKeyword);
        }
        matchesContextIdAndLabel(type, contextId) {
            return this.matches1(type) && this.currentToken().contextId === contextId;
        }
        previousWhitespaceAndComments() {
            let whitespaceAndComments = this.code.slice(this.tokenIndex > 0 ? this.tokens[this.tokenIndex - 1].end : 0, this.tokenIndex < this.tokens.length ? this.tokens[this.tokenIndex].start : this.code.length);
            if (this.isFlowEnabled) {
                whitespaceAndComments = whitespaceAndComments.replace(/@flow/g, "");
            }
            return whitespaceAndComments;
        }
        replaceToken(newCode) {
            this.resultCode += this.previousWhitespaceAndComments();
            this.appendTokenPrefix();
            this.resultMappings[this.tokenIndex] = this.resultCode.length;
            this.resultCode += newCode;
            this.appendTokenSuffix();
            this.tokenIndex++;
        }
        replaceTokenTrimmingLeftWhitespace(newCode) {
            this.resultCode += this.previousWhitespaceAndComments().replace(/[^\r\n]/g, "");
            this.appendTokenPrefix();
            this.resultMappings[this.tokenIndex] = this.resultCode.length;
            this.resultCode += newCode;
            this.appendTokenSuffix();
            this.tokenIndex++;
        }
        removeInitialToken() {
            this.replaceToken("");
        }
        removeToken() {
            this.replaceTokenTrimmingLeftWhitespace("");
        }
        /**
         * Remove all code until the next }, accounting for balanced braces.
         */
        removeBalancedCode() {
            let braceDepth = 0;
            while (!this.isAtEnd()) {
                if (this.matches1(types_1.TokenType.braceL)) {
                    braceDepth++;
                }
                else if (this.matches1(types_1.TokenType.braceR)) {
                    if (braceDepth === 0) {
                        return;
                    }
                    braceDepth--;
                }
                this.removeToken();
            }
        }
        copyExpectedToken(tokenType) {
            if (this.tokens[this.tokenIndex].type !== tokenType) {
                throw new Error(`Expected token ${tokenType}`);
            }
            this.copyToken();
        }
        copyToken() {
            this.resultCode += this.previousWhitespaceAndComments();
            this.appendTokenPrefix();
            this.resultMappings[this.tokenIndex] = this.resultCode.length;
            this.resultCode += this.code.slice(this.tokens[this.tokenIndex].start, this.tokens[this.tokenIndex].end);
            this.appendTokenSuffix();
            this.tokenIndex++;
        }
        copyTokenWithPrefix(prefix) {
            this.resultCode += this.previousWhitespaceAndComments();
            this.appendTokenPrefix();
            this.resultCode += prefix;
            this.resultMappings[this.tokenIndex] = this.resultCode.length;
            this.resultCode += this.code.slice(this.tokens[this.tokenIndex].start, this.tokens[this.tokenIndex].end);
            this.appendTokenSuffix();
            this.tokenIndex++;
        }
        appendTokenPrefix() {
            const token = this.currentToken();
            if (token.numNullishCoalesceStarts || token.isOptionalChainStart) {
                token.isAsyncOperation = (0, isAsyncOperation_1.default)(this);
            }
            if (this.disableESTransforms) {
                return;
            }
            if (token.numNullishCoalesceStarts) {
                for (let i = 0; i < token.numNullishCoalesceStarts; i++) {
                    if (token.isAsyncOperation) {
                        this.resultCode += "await ";
                        this.resultCode += this.helperManager.getHelperName("asyncNullishCoalesce");
                    }
                    else {
                        this.resultCode += this.helperManager.getHelperName("nullishCoalesce");
                    }
                    this.resultCode += "(";
                }
            }
            if (token.isOptionalChainStart) {
                if (token.isAsyncOperation) {
                    this.resultCode += "await ";
                }
                if (this.tokenIndex > 0 && this.tokenAtRelativeIndex(-1).type === types_1.TokenType._delete) {
                    if (token.isAsyncOperation) {
                        this.resultCode += this.helperManager.getHelperName("asyncOptionalChainDelete");
                    }
                    else {
                        this.resultCode += this.helperManager.getHelperName("optionalChainDelete");
                    }
                }
                else if (token.isAsyncOperation) {
                    this.resultCode += this.helperManager.getHelperName("asyncOptionalChain");
                }
                else {
                    this.resultCode += this.helperManager.getHelperName("optionalChain");
                }
                this.resultCode += "([";
            }
        }
        appendTokenSuffix() {
            const token = this.currentToken();
            if (token.isOptionalChainEnd && !this.disableESTransforms) {
                this.resultCode += "])";
            }
            if (token.numNullishCoalesceEnds && !this.disableESTransforms) {
                for (let i = 0; i < token.numNullishCoalesceEnds; i++) {
                    this.resultCode += "))";
                }
            }
        }
        appendCode(code) {
            this.resultCode += code;
        }
        currentToken() {
            return this.tokens[this.tokenIndex];
        }
        currentTokenCode() {
            const token = this.currentToken();
            return this.code.slice(token.start, token.end);
        }
        tokenAtRelativeIndex(relativeIndex) {
            return this.tokens[this.tokenIndex + relativeIndex];
        }
        currentIndex() {
            return this.tokenIndex;
        }
        /**
         * Move to the next token. Only suitable in preprocessing steps. When
         * generating new code, you should use copyToken or removeToken.
         */
        nextToken() {
            if (this.tokenIndex === this.tokens.length) {
                throw new Error("Unexpectedly reached end of input.");
            }
            this.tokenIndex++;
        }
        previousToken() {
            this.tokenIndex--;
        }
        finish() {
            if (this.tokenIndex !== this.tokens.length) {
                throw new Error("Tried to finish processing tokens before reaching the end.");
            }
            this.resultCode += this.previousWhitespaceAndComments();
            return { code: this.resultCode, mappings: this.resultMappings };
        }
        isAtEnd() {
            return this.tokenIndex === this.tokens.length;
        }
    }
    exports.default = TokenProcessor;
},
"3e31f9f9c3": /* sucrase\dist\esm\util\isAsyncOperation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = isAsyncOperation;
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    /**
     * Determine whether this optional chain or nullish coalescing operation has any await statements in
     * it. If so, we'll need to transpile to an async operation.
     *
     * We compute this by walking the length of the operation and returning true if we see an await
     * keyword used as a real await (rather than an object key or property access). Nested optional
     * chain/nullish operations need to be tracked but don't silence await, but a nested async function
     * (or any other nested scope) will make the await not count.
     */
    function isAsyncOperation(tokens) {
        let index = tokens.currentIndex();
        let depth = 0;
        const startToken = tokens.currentToken();
        do {
            const token = tokens.tokens[index];
            if (token.isOptionalChainStart) {
                depth++;
            }
            if (token.isOptionalChainEnd) {
                depth--;
            }
            depth += token.numNullishCoalesceStarts;
            depth -= token.numNullishCoalesceEnds;
            if (token.contextualKeyword === keywords_1.ContextualKeyword._await &&
                token.identifierRole == null &&
                token.scopeDepth === startToken.scopeDepth) {
                return true;
            }
            index += 1;
        } while (depth > 0 && index < tokens.tokens.length);
        return false;
    }
},
"131f5202c7": /* sucrase\dist\esm\transformers\RootTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const getClassInfo_1 = tslib_1.__importDefault(require("6aa22e0eb8") /* ../util/getClassInfo */);
    const CJSImportTransformer_1 = tslib_1.__importDefault(require("268dc8808b") /* ./CJSImportTransformer */);
    const ESMImportTransformer_1 = tslib_1.__importDefault(require("8db2e4c5d7") /* ./ESMImportTransformer */);
    const FlowTransformer_1 = tslib_1.__importDefault(require("3913cc12b3") /* ./FlowTransformer */);
    const JestHoistTransformer_1 = tslib_1.__importDefault(require("3eb46b07e3") /* ./JestHoistTransformer */);
    const JSXTransformer_1 = tslib_1.__importDefault(require("a0e577c292") /* ./JSXTransformer */);
    const NumericSeparatorTransformer_1 = tslib_1.__importDefault(require("09e20c28d7") /* ./NumericSeparatorTransformer */);
    const OptionalCatchBindingTransformer_1 = tslib_1.__importDefault(require("1dc037e3ca") /* ./OptionalCatchBindingTransformer */);
    const OptionalChainingNullishTransformer_1 = tslib_1.__importDefault(require("6995ead426") /* ./OptionalChainingNullishTransformer */);
    const ReactDisplayNameTransformer_1 = tslib_1.__importDefault(require("9aad52e886") /* ./ReactDisplayNameTransformer */);
    const ReactHotLoaderTransformer_1 = tslib_1.__importDefault(require("c3f855a290") /* ./ReactHotLoaderTransformer */);
    const TypeScriptTransformer_1 = tslib_1.__importDefault(require("581b1c506a") /* ./TypeScriptTransformer */);
    class RootTransformer {
        __init() { this.transformers = []; }
        __init2() { this.generatedVariables = []; }
        constructor(sucraseContext, transforms, enableLegacyBabel5ModuleInterop, options) {
            ;
            RootTransformer.prototype.__init.call(this);
            RootTransformer.prototype.__init2.call(this);
            this.nameManager = sucraseContext.nameManager;
            this.helperManager = sucraseContext.helperManager;
            const { tokenProcessor, importProcessor } = sucraseContext;
            this.tokens = tokenProcessor;
            this.isImportsTransformEnabled = transforms.includes("imports");
            this.isReactHotLoaderTransformEnabled = transforms.includes("react-hot-loader");
            this.disableESTransforms = Boolean(options.disableESTransforms);
            if (!options.disableESTransforms) {
                this.transformers.push(new OptionalChainingNullishTransformer_1.default(tokenProcessor, this.nameManager));
                this.transformers.push(new NumericSeparatorTransformer_1.default(tokenProcessor));
                this.transformers.push(new OptionalCatchBindingTransformer_1.default(tokenProcessor, this.nameManager));
            }
            if (transforms.includes("jsx")) {
                if (options.jsxRuntime !== "preserve") {
                    this.transformers.push(new JSXTransformer_1.default(this, tokenProcessor, importProcessor, this.nameManager, options));
                }
                this.transformers.push(new ReactDisplayNameTransformer_1.default(this, tokenProcessor, importProcessor, options));
            }
            let reactHotLoaderTransformer = null;
            if (transforms.includes("react-hot-loader")) {
                if (!options.filePath) {
                    throw new Error("filePath is required when using the react-hot-loader transform.");
                }
                reactHotLoaderTransformer = new ReactHotLoaderTransformer_1.default(tokenProcessor, options.filePath);
                this.transformers.push(reactHotLoaderTransformer);
            }
            // Note that we always want to enable the imports transformer, even when the import transform
            // itself isn't enabled, since we need to do type-only import pruning for both Flow and
            // TypeScript.
            if (transforms.includes("imports")) {
                if (importProcessor === null) {
                    throw new Error("Expected non-null importProcessor with imports transform enabled.");
                }
                this.transformers.push(new CJSImportTransformer_1.default(this, tokenProcessor, importProcessor, this.nameManager, this.helperManager, reactHotLoaderTransformer, enableLegacyBabel5ModuleInterop, Boolean(options.enableLegacyTypeScriptModuleInterop), transforms.includes("typescript"), transforms.includes("flow"), Boolean(options.preserveDynamicImport), Boolean(options.keepUnusedImports)));
            }
            else {
                this.transformers.push(new ESMImportTransformer_1.default(tokenProcessor, this.nameManager, this.helperManager, reactHotLoaderTransformer, transforms.includes("typescript"), transforms.includes("flow"), Boolean(options.keepUnusedImports), options));
            }
            if (transforms.includes("flow")) {
                this.transformers.push(new FlowTransformer_1.default(this, tokenProcessor, transforms.includes("imports")));
            }
            if (transforms.includes("typescript")) {
                this.transformers.push(new TypeScriptTransformer_1.default(this, tokenProcessor, transforms.includes("imports")));
            }
            if (transforms.includes("jest")) {
                this.transformers.push(new JestHoistTransformer_1.default(this, tokenProcessor, this.nameManager, importProcessor));
            }
        }
        transform() {
            this.tokens.reset();
            this.processBalancedCode();
            const shouldAddUseStrict = this.isImportsTransformEnabled;
            // "use strict" always needs to be first, so override the normal transformer order.
            let prefix = shouldAddUseStrict ? '"use strict";' : "";
            for (const transformer of this.transformers) {
                prefix += transformer.getPrefixCode();
            }
            prefix += this.helperManager.emitHelpers();
            prefix += this.generatedVariables.map((v) => ` var ${v};`).join("");
            for (const transformer of this.transformers) {
                prefix += transformer.getHoistedCode();
            }
            let suffix = "";
            for (const transformer of this.transformers) {
                suffix += transformer.getSuffixCode();
            }
            const result = this.tokens.finish();
            let { code } = result;
            if (code.startsWith("#!")) {
                let newlineIndex = code.indexOf("\n");
                if (newlineIndex === -1) {
                    newlineIndex = code.length;
                    code += "\n";
                }
                return {
                    code: code.slice(0, newlineIndex + 1) + prefix + code.slice(newlineIndex + 1) + suffix,
                    // The hashbang line has no tokens, so shifting the tokens to account
                    // for prefix can happen normally.
                    mappings: this.shiftMappings(result.mappings, prefix.length),
                };
            }
            else {
                return {
                    code: prefix + code + suffix,
                    mappings: this.shiftMappings(result.mappings, prefix.length),
                };
            }
        }
        processBalancedCode() {
            let braceDepth = 0;
            let parenDepth = 0;
            while (!this.tokens.isAtEnd()) {
                if (this.tokens.matches1(types_1.TokenType.braceL) || this.tokens.matches1(types_1.TokenType.dollarBraceL)) {
                    braceDepth++;
                }
                else if (this.tokens.matches1(types_1.TokenType.braceR)) {
                    if (braceDepth === 0) {
                        return;
                    }
                    braceDepth--;
                }
                if (this.tokens.matches1(types_1.TokenType.parenL)) {
                    parenDepth++;
                }
                else if (this.tokens.matches1(types_1.TokenType.parenR)) {
                    if (parenDepth === 0) {
                        return;
                    }
                    parenDepth--;
                }
                this.processToken();
            }
        }
        processToken() {
            if (this.tokens.matches1(types_1.TokenType._class)) {
                this.processClass();
                return;
            }
            for (const transformer of this.transformers) {
                const wasProcessed = transformer.process();
                if (wasProcessed) {
                    return;
                }
            }
            this.tokens.copyToken();
        }
        /**
         * Skip past a class with a name and return that name.
         */
        processNamedClass() {
            if (!this.tokens.matches2(types_1.TokenType._class, types_1.TokenType.name)) {
                throw new Error("Expected identifier for exported class name.");
            }
            const name = this.tokens.identifierNameAtIndex(this.tokens.currentIndex() + 1);
            this.processClass();
            return name;
        }
        processClass() {
            const classInfo = (0, getClassInfo_1.default)(this, this.tokens, this.nameManager, this.disableESTransforms);
            // Both static and instance initializers need a class name to use to invoke the initializer, so
            // assign to one if necessary.
            const needsCommaExpression = (classInfo.headerInfo.isExpression || !classInfo.headerInfo.className) &&
                classInfo.staticInitializerNames.length + classInfo.instanceInitializerNames.length > 0;
            let className = classInfo.headerInfo.className;
            if (needsCommaExpression) {
                className = this.nameManager.claimFreeName("_class");
                this.generatedVariables.push(className);
                this.tokens.appendCode(` (${className} =`);
            }
            const classToken = this.tokens.currentToken();
            const contextId = classToken.contextId;
            if (contextId == null) {
                throw new Error("Expected class to have a context ID.");
            }
            this.tokens.copyExpectedToken(types_1.TokenType._class);
            while (!this.tokens.matchesContextIdAndLabel(types_1.TokenType.braceL, contextId)) {
                this.processToken();
            }
            this.processClassBody(classInfo, className);
            const staticInitializerStatements = classInfo.staticInitializerNames.map((name) => `${className}.${name}()`);
            if (needsCommaExpression) {
                this.tokens.appendCode(`, ${staticInitializerStatements.map((s) => `${s}, `).join("")}${className})`);
            }
            else if (classInfo.staticInitializerNames.length > 0) {
                this.tokens.appendCode(` ${staticInitializerStatements.map((s) => `${s};`).join(" ")}`);
            }
        }
        /**
         * We want to just handle class fields in all contexts, since TypeScript supports them. Later,
         * when some JS implementations support class fields, this should be made optional.
         */
        processClassBody(classInfo, className) {
            const { headerInfo, constructorInsertPos, constructorInitializerStatements, fields, instanceInitializerNames, rangesToRemove, } = classInfo;
            let fieldIndex = 0;
            let rangeToRemoveIndex = 0;
            const classContextId = this.tokens.currentToken().contextId;
            if (classContextId == null) {
                throw new Error("Expected non-null context ID on class.");
            }
            this.tokens.copyExpectedToken(types_1.TokenType.braceL);
            if (this.isReactHotLoaderTransformEnabled) {
                this.tokens.appendCode("__reactstandin__regenerateByEval(key, code) {this[key] = eval(code);}");
            }
            const needsConstructorInit = constructorInitializerStatements.length + instanceInitializerNames.length > 0;
            if (constructorInsertPos === null && needsConstructorInit) {
                const constructorInitializersCode = this.makeConstructorInitCode(constructorInitializerStatements, instanceInitializerNames, className);
                if (headerInfo.hasSuperclass) {
                    const argsName = this.nameManager.claimFreeName("args");
                    this.tokens.appendCode(`constructor(...${argsName}) { super(...${argsName}); ${constructorInitializersCode}; }`);
                }
                else {
                    this.tokens.appendCode(`constructor() { ${constructorInitializersCode}; }`);
                }
            }
            while (!this.tokens.matchesContextIdAndLabel(types_1.TokenType.braceR, classContextId)) {
                if (fieldIndex < fields.length && this.tokens.currentIndex() === fields[fieldIndex].start) {
                    let needsCloseBrace = false;
                    if (this.tokens.matches1(types_1.TokenType.bracketL)) {
                        this.tokens.copyTokenWithPrefix(`${fields[fieldIndex].initializerName}() {this`);
                    }
                    else if (this.tokens.matches1(types_1.TokenType.string) || this.tokens.matches1(types_1.TokenType.num)) {
                        this.tokens.copyTokenWithPrefix(`${fields[fieldIndex].initializerName}() {this[`);
                        needsCloseBrace = true;
                    }
                    else {
                        this.tokens.copyTokenWithPrefix(`${fields[fieldIndex].initializerName}() {this.`);
                    }
                    while (this.tokens.currentIndex() < fields[fieldIndex].end) {
                        if (needsCloseBrace && this.tokens.currentIndex() === fields[fieldIndex].equalsIndex) {
                            this.tokens.appendCode("]");
                        }
                        this.processToken();
                    }
                    this.tokens.appendCode("}");
                    fieldIndex++;
                }
                else if (rangeToRemoveIndex < rangesToRemove.length &&
                    this.tokens.currentIndex() >= rangesToRemove[rangeToRemoveIndex].start) {
                    if (this.tokens.currentIndex() < rangesToRemove[rangeToRemoveIndex].end) {
                        this.tokens.removeInitialToken();
                    }
                    while (this.tokens.currentIndex() < rangesToRemove[rangeToRemoveIndex].end) {
                        this.tokens.removeToken();
                    }
                    rangeToRemoveIndex++;
                }
                else if (this.tokens.currentIndex() === constructorInsertPos) {
                    this.tokens.copyToken();
                    if (needsConstructorInit) {
                        this.tokens.appendCode(`;${this.makeConstructorInitCode(constructorInitializerStatements, instanceInitializerNames, className)};`);
                    }
                    this.processToken();
                }
                else {
                    this.processToken();
                }
            }
            this.tokens.copyExpectedToken(types_1.TokenType.braceR);
        }
        makeConstructorInitCode(constructorInitializerStatements, instanceInitializerNames, className) {
            return [
                ...constructorInitializerStatements,
                ...instanceInitializerNames.map((name) => `${className}.prototype.${name}.call(this)`),
            ].join(";");
        }
        /**
         * Normally it's ok to simply remove type tokens, but we need to be more careful when dealing with
         * arrow function return types since they can confuse the parser. In that case, we want to move
         * the close-paren to the same line as the arrow.
         *
         * See https://github.com/alangpierce/sucrase/issues/391 for more details.
         */
        processPossibleArrowParamEnd() {
            if (this.tokens.matches2(types_1.TokenType.parenR, types_1.TokenType.colon) && this.tokens.tokenAtRelativeIndex(1).isType) {
                let nextNonTypeIndex = this.tokens.currentIndex() + 1;
                // Look ahead to see if this is an arrow function or something else.
                while (this.tokens.tokens[nextNonTypeIndex].isType) {
                    nextNonTypeIndex++;
                }
                if (this.tokens.matches1AtIndex(nextNonTypeIndex, types_1.TokenType.arrow)) {
                    this.tokens.removeInitialToken();
                    while (this.tokens.currentIndex() < nextNonTypeIndex) {
                        this.tokens.removeToken();
                    }
                    this.tokens.replaceTokenTrimmingLeftWhitespace(") =>");
                    return true;
                }
            }
            return false;
        }
        /**
         * An async arrow function might be of the form:
         *
         * async <
         *   T
         * >() => {}
         *
         * in which case, removing the type parameters will cause a syntax error. Detect this case and
         * move the open-paren earlier.
         */
        processPossibleAsyncArrowWithTypeParams() {
            if (!this.tokens.matchesContextual(keywords_1.ContextualKeyword._async) &&
                !this.tokens.matches1(types_1.TokenType._async)) {
                return false;
            }
            const nextToken = this.tokens.tokenAtRelativeIndex(1);
            if (nextToken.type !== types_1.TokenType.lessThan || !nextToken.isType) {
                return false;
            }
            let nextNonTypeIndex = this.tokens.currentIndex() + 1;
            // Look ahead to see if this is an arrow function or something else.
            while (this.tokens.tokens[nextNonTypeIndex].isType) {
                nextNonTypeIndex++;
            }
            if (this.tokens.matches1AtIndex(nextNonTypeIndex, types_1.TokenType.parenL)) {
                this.tokens.replaceToken("async (");
                this.tokens.removeInitialToken();
                while (this.tokens.currentIndex() < nextNonTypeIndex) {
                    this.tokens.removeToken();
                }
                this.tokens.removeToken();
                // We ate a ( token, so we need to process the tokens in between and then the ) token so that
                // we remain balanced.
                this.processBalancedCode();
                this.processToken();
                return true;
            }
            return false;
        }
        processPossibleTypeRange() {
            if (this.tokens.currentToken().isType) {
                this.tokens.removeInitialToken();
                while (this.tokens.currentToken().isType) {
                    this.tokens.removeToken();
                }
                return true;
            }
            return false;
        }
        shiftMappings(mappings, prefixLength) {
            for (let i = 0; i < mappings.length; i++) {
                const mapping = mappings[i];
                if (mapping !== undefined) {
                    mappings[i] = mapping + prefixLength;
                }
            }
            return mappings;
        }
    }
    exports.default = RootTransformer;
},
"6aa22e0eb8": /* sucrase\dist\esm\util\getClassInfo.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getClassInfo;
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Get information about the class fields for this class, given a token processor pointing to the
     * open-brace at the start of the class.
     */
    function getClassInfo(rootTransformer, tokens, nameManager, disableESTransforms) {
        const snapshot = tokens.snapshot();
        const headerInfo = processClassHeader(tokens);
        let constructorInitializerStatements = [];
        const instanceInitializerNames = [];
        const staticInitializerNames = [];
        let constructorInsertPos = null;
        const fields = [];
        const rangesToRemove = [];
        const classContextId = tokens.currentToken().contextId;
        if (classContextId == null) {
            throw new Error("Expected non-null class context ID on class open-brace.");
        }
        tokens.nextToken();
        while (!tokens.matchesContextIdAndLabel(types_1.TokenType.braceR, classContextId)) {
            if (tokens.matchesContextual(keywords_1.ContextualKeyword._constructor) && !tokens.currentToken().isType) {
                ({ constructorInitializerStatements, constructorInsertPos } = processConstructor(tokens));
            }
            else if (tokens.matches1(types_1.TokenType.semi)) {
                if (!disableESTransforms) {
                    rangesToRemove.push({ start: tokens.currentIndex(), end: tokens.currentIndex() + 1 });
                }
                tokens.nextToken();
            }
            else if (tokens.currentToken().isType) {
                tokens.nextToken();
            }
            else {
                // Either a method or a field. Skip to the identifier part.
                const statementStartIndex = tokens.currentIndex();
                let isStatic = false;
                let isESPrivate = false;
                let isDeclareOrAbstract = false;
                while (isAccessModifier(tokens.currentToken())) {
                    if (tokens.matches1(types_1.TokenType._static)) {
                        isStatic = true;
                    }
                    if (tokens.matches1(types_1.TokenType.hash)) {
                        isESPrivate = true;
                    }
                    if (tokens.matches1(types_1.TokenType._declare) || tokens.matches1(types_1.TokenType._abstract)) {
                        isDeclareOrAbstract = true;
                    }
                    tokens.nextToken();
                }
                if (isStatic && tokens.matches1(types_1.TokenType.braceL)) {
                    // This is a static block, so don't process it in any special way.
                    skipToNextClassElement(tokens, classContextId);
                    continue;
                }
                if (isESPrivate) {
                    // Sucrase doesn't attempt to transpile private fields; just leave them as-is.
                    skipToNextClassElement(tokens, classContextId);
                    continue;
                }
                if (tokens.matchesContextual(keywords_1.ContextualKeyword._constructor) &&
                    !tokens.currentToken().isType) {
                    ({ constructorInitializerStatements, constructorInsertPos } = processConstructor(tokens));
                    continue;
                }
                const nameStartIndex = tokens.currentIndex();
                skipFieldName(tokens);
                if (tokens.matches1(types_1.TokenType.lessThan) || tokens.matches1(types_1.TokenType.parenL)) {
                    // This is a method, so nothing to process.
                    skipToNextClassElement(tokens, classContextId);
                    continue;
                }
                // There might be a type annotation that we need to skip.
                while (tokens.currentToken().isType) {
                    tokens.nextToken();
                }
                if (tokens.matches1(types_1.TokenType.eq)) {
                    const equalsIndex = tokens.currentIndex();
                    // This is an initializer, so we need to wrap in an initializer method.
                    const valueEnd = tokens.currentToken().rhsEndIndex;
                    if (valueEnd == null) {
                        throw new Error("Expected rhsEndIndex on class field assignment.");
                    }
                    tokens.nextToken();
                    while (tokens.currentIndex() < valueEnd) {
                        rootTransformer.processToken();
                    }
                    let initializerName;
                    if (isStatic) {
                        initializerName = nameManager.claimFreeName("__initStatic");
                        staticInitializerNames.push(initializerName);
                    }
                    else {
                        initializerName = nameManager.claimFreeName("__init");
                        instanceInitializerNames.push(initializerName);
                    }
                    // Fields start at the name, so `static x = 1;` has a field range of `x = 1;`.
                    fields.push({
                        initializerName,
                        equalsIndex,
                        start: nameStartIndex,
                        end: tokens.currentIndex(),
                    });
                }
                else if (!disableESTransforms || isDeclareOrAbstract) {
                    // This is a regular field declaration, like `x;`. With the class transform enabled, we just
                    // remove the line so that no output is produced. With the class transform disabled, we
                    // usually want to preserve the declaration (but still strip types), but if the `declare`
                    // or `abstract` keyword is specified, we should remove the line to avoid initializing the
                    // value to undefined.
                    rangesToRemove.push({ start: statementStartIndex, end: tokens.currentIndex() });
                }
            }
        }
        tokens.restoreToSnapshot(snapshot);
        if (disableESTransforms) {
            // With ES transforms disabled, we don't want to transform regular class
            // field declarations, and we don't need to do any additional tricks to
            // reference the constructor for static init, but we still need to transform
            // TypeScript field initializers defined as constructor parameters and we
            // still need to remove `declare` fields. For now, we run the same code
            // path but omit any field information, as if the class had no field
            // declarations. In the future, when we fully drop the class fields
            // transform, we can simplify this code significantly.
            return {
                headerInfo,
                constructorInitializerStatements,
                instanceInitializerNames: [],
                staticInitializerNames: [],
                constructorInsertPos,
                fields: [],
                rangesToRemove,
            };
        }
        else {
            return {
                headerInfo,
                constructorInitializerStatements,
                instanceInitializerNames,
                staticInitializerNames,
                constructorInsertPos,
                fields,
                rangesToRemove,
            };
        }
    }
    /**
     * Move the token processor to the next method/field in the class.
     *
     * To do that, we seek forward to the next start of a class name (either an open
     * bracket or an identifier, or the closing curly brace), then seek backward to
     * include any access modifiers.
     */
    function skipToNextClassElement(tokens, classContextId) {
        tokens.nextToken();
        while (tokens.currentToken().contextId !== classContextId) {
            tokens.nextToken();
        }
        while (isAccessModifier(tokens.tokenAtRelativeIndex(-1))) {
            tokens.previousToken();
        }
    }
    function processClassHeader(tokens) {
        const classToken = tokens.currentToken();
        const contextId = classToken.contextId;
        if (contextId == null) {
            throw new Error("Expected context ID on class token.");
        }
        const isExpression = classToken.isExpression;
        if (isExpression == null) {
            throw new Error("Expected isExpression on class token.");
        }
        let className = null;
        let hasSuperclass = false;
        tokens.nextToken();
        if (tokens.matches1(types_1.TokenType.name)) {
            className = tokens.identifierName();
        }
        while (!tokens.matchesContextIdAndLabel(types_1.TokenType.braceL, contextId)) {
            // If this has a superclass, there will always be an `extends` token. If it doesn't have a
            // superclass, only type parameters and `implements` clauses can show up here, all of which
            // consist only of type tokens. A declaration like `class A<B extends C> {` should *not* count
            // as having a superclass.
            if (tokens.matches1(types_1.TokenType._extends) && !tokens.currentToken().isType) {
                hasSuperclass = true;
            }
            tokens.nextToken();
        }
        return { isExpression, className, hasSuperclass };
    }
    /**
     * Extract useful information out of a constructor, starting at the "constructor" name.
     */
    function processConstructor(tokens) {
        const constructorInitializerStatements = [];
        tokens.nextToken();
        const constructorContextId = tokens.currentToken().contextId;
        if (constructorContextId == null) {
            throw new Error("Expected context ID on open-paren starting constructor params.");
        }
        // Advance through parameters looking for access modifiers.
        while (!tokens.matchesContextIdAndLabel(types_1.TokenType.parenR, constructorContextId)) {
            if (tokens.currentToken().contextId === constructorContextId) {
                // Current token is an open paren or comma just before a param, so check
                // that param for access modifiers.
                tokens.nextToken();
                if (isAccessModifier(tokens.currentToken())) {
                    tokens.nextToken();
                    while (isAccessModifier(tokens.currentToken())) {
                        tokens.nextToken();
                    }
                    const token = tokens.currentToken();
                    if (token.type !== types_1.TokenType.name) {
                        throw new Error("Expected identifier after access modifiers in constructor arg.");
                    }
                    const name = tokens.identifierNameForToken(token);
                    constructorInitializerStatements.push(`this.${name} = ${name}`);
                }
            }
            else {
                tokens.nextToken();
            }
        }
        // )
        tokens.nextToken();
        // Constructor type annotations are invalid, but skip them anyway since
        // they're easy to skip.
        while (tokens.currentToken().isType) {
            tokens.nextToken();
        }
        let constructorInsertPos = tokens.currentIndex();
        // Advance through body looking for a super call.
        let foundSuperCall = false;
        while (!tokens.matchesContextIdAndLabel(types_1.TokenType.braceR, constructorContextId)) {
            if (!foundSuperCall && tokens.matches2(types_1.TokenType._super, types_1.TokenType.parenL)) {
                tokens.nextToken();
                const superCallContextId = tokens.currentToken().contextId;
                if (superCallContextId == null) {
                    throw new Error("Expected a context ID on the super call");
                }
                while (!tokens.matchesContextIdAndLabel(types_1.TokenType.parenR, superCallContextId)) {
                    tokens.nextToken();
                }
                constructorInsertPos = tokens.currentIndex();
                foundSuperCall = true;
            }
            tokens.nextToken();
        }
        // }
        tokens.nextToken();
        return { constructorInitializerStatements, constructorInsertPos };
    }
    /**
     * Determine if this is any token that can go before the name in a method/field.
     */
    function isAccessModifier(token) {
        return [
            types_1.TokenType._async,
            types_1.TokenType._get,
            types_1.TokenType._set,
            types_1.TokenType.plus,
            types_1.TokenType.minus,
            types_1.TokenType._readonly,
            types_1.TokenType._static,
            types_1.TokenType._public,
            types_1.TokenType._private,
            types_1.TokenType._protected,
            types_1.TokenType._override,
            types_1.TokenType._abstract,
            types_1.TokenType.star,
            types_1.TokenType._declare,
            types_1.TokenType.hash,
        ].includes(token.type);
    }
    /**
     * The next token or set of tokens is either an identifier or an expression in square brackets, for
     * a method or field name.
     */
    function skipFieldName(tokens) {
        if (tokens.matches1(types_1.TokenType.bracketL)) {
            const startToken = tokens.currentToken();
            const classContextId = startToken.contextId;
            if (classContextId == null) {
                throw new Error("Expected class context ID on computed name open bracket.");
            }
            while (!tokens.matchesContextIdAndLabel(types_1.TokenType.bracketR, classContextId)) {
                tokens.nextToken();
            }
            tokens.nextToken();
        }
        else {
            tokens.nextToken();
        }
    }
},
"268dc8808b": /* sucrase\dist\esm\transformers\CJSImportTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const elideImportEquals_1 = tslib_1.__importDefault(require("a5f4e01d7b") /* ../util/elideImportEquals */);
    const getDeclarationInfo_1 = tslib_1.__importStar(require("f1b0dcccab") /* ../util/getDeclarationInfo */);
    const getImportExportSpecifierInfo_1 = tslib_1.__importDefault(require("14d4ae78a4") /* ../util/getImportExportSpecifierInfo */);
    const isExportFrom_1 = tslib_1.__importDefault(require("c3c484c8b2") /* ../util/isExportFrom */);
    const removeMaybeImportAttributes_1 = require("f659e3ed39") /* ../util/removeMaybeImportAttributes */;
    const shouldElideDefaultExport_1 = tslib_1.__importDefault(require("11afb90ac4") /* ../util/shouldElideDefaultExport */);
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    /**
     * Class for editing import statements when we are transforming to commonjs.
     */
    class CJSImportTransformer extends Transformer_1.default {
        __init() { this.hadExport = false; }
        __init2() { this.hadNamedExport = false; }
        __init3() { this.hadDefaultExport = false; }
        constructor(rootTransformer, tokens, importProcessor, nameManager, helperManager, reactHotLoaderTransformer, enableLegacyBabel5ModuleInterop, enableLegacyTypeScriptModuleInterop, isTypeScriptTransformEnabled, isFlowTransformEnabled, preserveDynamicImport, keepUnusedImports) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.importProcessor = importProcessor;
            this.nameManager = nameManager;
            this.helperManager = helperManager;
            this.reactHotLoaderTransformer = reactHotLoaderTransformer;
            this.enableLegacyBabel5ModuleInterop = enableLegacyBabel5ModuleInterop;
            this.enableLegacyTypeScriptModuleInterop = enableLegacyTypeScriptModuleInterop;
            this.isTypeScriptTransformEnabled = isTypeScriptTransformEnabled;
            this.isFlowTransformEnabled = isFlowTransformEnabled;
            this.preserveDynamicImport = preserveDynamicImport;
            this.keepUnusedImports = keepUnusedImports;
            CJSImportTransformer.prototype.__init.call(this);
            CJSImportTransformer.prototype.__init2.call(this);
            CJSImportTransformer.prototype.__init3.call(this);
            ;
            this.declarationInfo = isTypeScriptTransformEnabled
                ? (0, getDeclarationInfo_1.default)(tokens)
                : getDeclarationInfo_1.EMPTY_DECLARATION_INFO;
        }
        getPrefixCode() {
            let prefix = "";
            if (this.hadExport) {
                prefix += 'Object.defineProperty(exports, "__esModule", {value: true});';
            }
            return prefix;
        }
        getSuffixCode() {
            if (this.enableLegacyBabel5ModuleInterop && this.hadDefaultExport && !this.hadNamedExport) {
                return "\nmodule.exports = exports.default;\n";
            }
            return "";
        }
        process() {
            // TypeScript `import foo = require('foo');` should always just be translated to plain require.
            if (this.tokens.matches3(types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.eq)) {
                return this.processImportEquals();
            }
            if (this.tokens.matches1(types_1.TokenType._import)) {
                this.processImport();
                return true;
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.eq)) {
                this.tokens.replaceToken("module.exports");
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._export) && !this.tokens.currentToken().isType) {
                this.hadExport = true;
                return this.processExport();
            }
            if (this.tokens.matches2(types_1.TokenType.name, types_1.TokenType.postIncDec)) {
                // Fall through to normal identifier matching if this doesn't apply.
                if (this.processPostIncDec()) {
                    return true;
                }
            }
            if (this.tokens.matches1(types_1.TokenType.name) || this.tokens.matches1(types_1.TokenType.jsxName)) {
                return this.processIdentifier();
            }
            if (this.tokens.matches1(types_1.TokenType.eq)) {
                return this.processAssignment();
            }
            if (this.tokens.matches1(types_1.TokenType.assign)) {
                return this.processComplexAssignment();
            }
            if (this.tokens.matches1(types_1.TokenType.preIncDec)) {
                return this.processPreIncDec();
            }
            return false;
        }
        processImportEquals() {
            const importName = this.tokens.identifierNameAtIndex(this.tokens.currentIndex() + 1);
            if (this.importProcessor.shouldAutomaticallyElideImportedName(importName)) {
                // If this name is only used as a type, elide the whole import.
                (0, elideImportEquals_1.default)(this.tokens);
            }
            else {
                // Otherwise, switch `import` to `const`.
                this.tokens.replaceToken("const");
            }
            return true;
        }
        /**
         * Transform this:
         * import foo, {bar} from 'baz';
         * into
         * var _baz = require('baz'); var _baz2 = _interopRequireDefault(_baz);
         *
         * The import code was already generated in the import preprocessing step, so
         * we just need to look it up.
         */
        processImport() {
            if (this.tokens.matches2(types_1.TokenType._import, types_1.TokenType.parenL)) {
                if (this.preserveDynamicImport) {
                    // Bail out, only making progress for this one token.
                    this.tokens.copyToken();
                    return;
                }
                const requireWrapper = this.enableLegacyTypeScriptModuleInterop
                    ? ""
                    : `${this.helperManager.getHelperName("interopRequireWildcard")}(`;
                this.tokens.replaceToken(`Promise.resolve().then(() => ${requireWrapper}require`);
                const contextId = this.tokens.currentToken().contextId;
                if (contextId == null) {
                    throw new Error("Expected context ID on dynamic import invocation.");
                }
                this.tokens.copyToken();
                while (!this.tokens.matchesContextIdAndLabel(types_1.TokenType.parenR, contextId)) {
                    this.rootTransformer.processToken();
                }
                this.tokens.replaceToken(requireWrapper ? ")))" : "))");
                return;
            }
            const shouldElideImport = this.removeImportAndDetectIfShouldElide();
            if (shouldElideImport) {
                this.tokens.removeToken();
            }
            else {
                const path = this.tokens.stringValue();
                this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(path));
                this.tokens.appendCode(this.importProcessor.claimImportCode(path));
            }
            (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
            if (this.tokens.matches1(types_1.TokenType.semi)) {
                this.tokens.removeToken();
            }
        }
        /**
         * Erase this import (since any CJS output would be completely different), and
         * return true if this import is should be elided due to being a type-only
         * import. Such imports will not be emitted at all to avoid side effects.
         *
         * Import elision only happens with the TypeScript or Flow transforms enabled.
         *
         * TODO: This function has some awkward overlap with
         *  CJSImportProcessor.pruneTypeOnlyImports , and the two should be unified.
         *  That function handles TypeScript implicit import name elision, and removes
         *  an import if all typical imported names (without `type`) are removed due
         *  to being type-only imports. This function handles Flow import removal and
         *  properly distinguishes `import 'foo'` from `import {} from 'foo'` for TS
         *  purposes.
         *
         * The position should end at the import string.
         */
        removeImportAndDetectIfShouldElide() {
            this.tokens.removeInitialToken();
            if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._type) &&
                !this.tokens.matches1AtIndex(this.tokens.currentIndex() + 1, types_1.TokenType.comma) &&
                !this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 1, keywords_1.ContextualKeyword._from)) {
                // This is an "import type" statement, so exit early.
                this.removeRemainingImport();
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType.name) || this.tokens.matches1(types_1.TokenType.star)) {
                // We have a default import or namespace import, so there must be some
                // non-type import.
                this.removeRemainingImport();
                return false;
            }
            if (this.tokens.matches1(types_1.TokenType.string)) {
                // This is a bare import, so we should proceed with the import.
                return false;
            }
            let foundNonTypeImport = false;
            let foundAnyNamedImport = false;
            while (!this.tokens.matches1(types_1.TokenType.string)) {
                // Check if any named imports are of the form "foo" or "foo as bar", with
                // no leading "type".
                if ((!foundNonTypeImport && this.tokens.matches1(types_1.TokenType.braceL)) ||
                    this.tokens.matches1(types_1.TokenType.comma)) {
                    this.tokens.removeToken();
                    if (!this.tokens.matches1(types_1.TokenType.braceR)) {
                        foundAnyNamedImport = true;
                    }
                    if (this.tokens.matches2(types_1.TokenType.name, types_1.TokenType.comma) ||
                        this.tokens.matches2(types_1.TokenType.name, types_1.TokenType.braceR) ||
                        this.tokens.matches4(types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.comma) ||
                        this.tokens.matches4(types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.braceR)) {
                        foundNonTypeImport = true;
                    }
                }
                this.tokens.removeToken();
            }
            if (this.keepUnusedImports) {
                return false;
            }
            if (this.isTypeScriptTransformEnabled) {
                return !foundNonTypeImport;
            }
            else if (this.isFlowTransformEnabled) {
                // In Flow, unlike TS, `import {} from 'foo';` preserves the import.
                return foundAnyNamedImport && !foundNonTypeImport;
            }
            else {
                return false;
            }
        }
        removeRemainingImport() {
            while (!this.tokens.matches1(types_1.TokenType.string)) {
                this.tokens.removeToken();
            }
        }
        processIdentifier() {
            const token = this.tokens.currentToken();
            if (token.shadowsGlobal) {
                return false;
            }
            if (token.identifierRole === tokenizer_1.IdentifierRole.ObjectShorthand) {
                return this.processObjectShorthand();
            }
            if (token.identifierRole !== tokenizer_1.IdentifierRole.Access) {
                return false;
            }
            const replacement = this.importProcessor.getIdentifierReplacement(this.tokens.identifierNameForToken(token));
            if (!replacement) {
                return false;
            }
            // Tolerate any number of closing parens while looking for an opening paren
            // that indicates a function call.
            let possibleOpenParenIndex = this.tokens.currentIndex() + 1;
            while (possibleOpenParenIndex < this.tokens.tokens.length &&
                this.tokens.tokens[possibleOpenParenIndex].type === types_1.TokenType.parenR) {
                possibleOpenParenIndex++;
            }
            // Avoid treating imported functions as methods of their `exports` object
            // by using `(0, f)` when the identifier is in a paren expression. Else
            // use `Function.prototype.call` when the identifier is a guaranteed
            // function call. When using `call`, pass undefined as the context.
            if (this.tokens.tokens[possibleOpenParenIndex].type === types_1.TokenType.parenL) {
                if (this.tokens.tokenAtRelativeIndex(1).type === types_1.TokenType.parenL &&
                    this.tokens.tokenAtRelativeIndex(-1).type !== types_1.TokenType._new) {
                    this.tokens.replaceToken(`${replacement}.call(void 0, `);
                    // Remove the old paren.
                    this.tokens.removeToken();
                    // Balance out the new paren.
                    this.rootTransformer.processBalancedCode();
                    this.tokens.copyExpectedToken(types_1.TokenType.parenR);
                }
                else {
                    // See here: http://2ality.com/2015/12/references.html
                    this.tokens.replaceToken(`(0, ${replacement})`);
                }
            }
            else {
                this.tokens.replaceToken(replacement);
            }
            return true;
        }
        processObjectShorthand() {
            const identifier = this.tokens.identifierName();
            const replacement = this.importProcessor.getIdentifierReplacement(identifier);
            if (!replacement) {
                return false;
            }
            this.tokens.replaceToken(`${identifier}: ${replacement}`);
            return true;
        }
        processExport() {
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._enum) ||
                this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._const, types_1.TokenType._enum)) {
                this.hadNamedExport = true;
                // Let the TypeScript transform handle it.
                return false;
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._default)) {
                if (this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._enum)) {
                    this.hadDefaultExport = true;
                    // Flow export default enums need some special handling, so handle them
                    // in that tranform rather than this one.
                    return false;
                }
                this.processExportDefault();
                return true;
            }
            else if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.braceL)) {
                this.processExportBindings();
                return true;
            }
            else if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.name) &&
                this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 1, keywords_1.ContextualKeyword._type)) {
                // export type {a};
                // export type {a as b};
                // export type {a} from './b';
                // export type * from './b';
                // export type * as ns from './b';
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                if (this.tokens.matches1(types_1.TokenType.braceL)) {
                    while (!this.tokens.matches1(types_1.TokenType.braceR)) {
                        this.tokens.removeToken();
                    }
                    this.tokens.removeToken();
                }
                else {
                    // *
                    this.tokens.removeToken();
                    if (this.tokens.matches1(types_1.TokenType._as)) {
                        // as
                        this.tokens.removeToken();
                        // ns
                        this.tokens.removeToken();
                    }
                }
                // Remove type re-export `... } from './T'`
                if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._from) &&
                    this.tokens.matches1AtIndex(this.tokens.currentIndex() + 1, types_1.TokenType.string)) {
                    this.tokens.removeToken();
                    this.tokens.removeToken();
                    (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
                }
                return true;
            }
            this.hadNamedExport = true;
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._var) ||
                this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._let) ||
                this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._const)) {
                this.processExportVar();
                return true;
            }
            else if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._function) ||
                // export async function
                this.tokens.matches3(types_1.TokenType._export, types_1.TokenType.name, types_1.TokenType._function)) {
                this.processExportFunction();
                return true;
            }
            else if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._class) ||
                this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._abstract, types_1.TokenType._class) ||
                this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.at)) {
                this.processExportClass();
                return true;
            }
            else if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.star)) {
                this.processExportStar();
                return true;
            }
            else {
                throw new Error("Unrecognized export syntax.");
            }
        }
        processAssignment() {
            const index = this.tokens.currentIndex();
            const identifierToken = this.tokens.tokens[index - 1];
            // If the LHS is a type identifier, this must be a declaration like `let a: b = c;`,
            // with `b` as the identifier, so nothing needs to be done in that case.
            if (identifierToken.isType || identifierToken.type !== types_1.TokenType.name) {
                return false;
            }
            if (identifierToken.shadowsGlobal) {
                return false;
            }
            if (index >= 2 && this.tokens.matches1AtIndex(index - 2, types_1.TokenType.dot)) {
                return false;
            }
            if (index >= 2 && [types_1.TokenType._var, types_1.TokenType._let, types_1.TokenType._const].includes(this.tokens.tokens[index - 2].type)) {
                // Declarations don't need an extra assignment. This doesn't avoid the
                // assignment for comma-separated declarations, but it's still correct
                // since the assignment is just redundant.
                return false;
            }
            const assignmentSnippet = this.importProcessor.resolveExportBinding(this.tokens.identifierNameForToken(identifierToken));
            if (!assignmentSnippet) {
                return false;
            }
            this.tokens.copyToken();
            this.tokens.appendCode(` ${assignmentSnippet} =`);
            return true;
        }
        /**
         * Process something like `a += 3`, where `a` might be an exported value.
         */
        processComplexAssignment() {
            const index = this.tokens.currentIndex();
            const identifierToken = this.tokens.tokens[index - 1];
            if (identifierToken.type !== types_1.TokenType.name) {
                return false;
            }
            if (identifierToken.shadowsGlobal) {
                return false;
            }
            if (index >= 2 && this.tokens.matches1AtIndex(index - 2, types_1.TokenType.dot)) {
                return false;
            }
            const assignmentSnippet = this.importProcessor.resolveExportBinding(this.tokens.identifierNameForToken(identifierToken));
            if (!assignmentSnippet) {
                return false;
            }
            this.tokens.appendCode(` = ${assignmentSnippet}`);
            this.tokens.copyToken();
            return true;
        }
        /**
         * Process something like `++a`, where `a` might be an exported value.
         */
        processPreIncDec() {
            const index = this.tokens.currentIndex();
            const identifierToken = this.tokens.tokens[index + 1];
            if (identifierToken.type !== types_1.TokenType.name) {
                return false;
            }
            if (identifierToken.shadowsGlobal) {
                return false;
            }
            // Ignore things like ++a.b and ++a[b] and ++a().b.
            if (index + 2 < this.tokens.tokens.length &&
                (this.tokens.matches1AtIndex(index + 2, types_1.TokenType.dot) ||
                    this.tokens.matches1AtIndex(index + 2, types_1.TokenType.bracketL) ||
                    this.tokens.matches1AtIndex(index + 2, types_1.TokenType.parenL))) {
                return false;
            }
            const identifierName = this.tokens.identifierNameForToken(identifierToken);
            const assignmentSnippet = this.importProcessor.resolveExportBinding(identifierName);
            if (!assignmentSnippet) {
                return false;
            }
            this.tokens.appendCode(`${assignmentSnippet} = `);
            this.tokens.copyToken();
            return true;
        }
        /**
         * Process something like `a++`, where `a` might be an exported value.
         * This starts at the `a`, not at the `++`.
         */
        processPostIncDec() {
            const index = this.tokens.currentIndex();
            const identifierToken = this.tokens.tokens[index];
            const operatorToken = this.tokens.tokens[index + 1];
            if (identifierToken.type !== types_1.TokenType.name) {
                return false;
            }
            if (identifierToken.shadowsGlobal) {
                return false;
            }
            if (index >= 1 && this.tokens.matches1AtIndex(index - 1, types_1.TokenType.dot)) {
                return false;
            }
            const identifierName = this.tokens.identifierNameForToken(identifierToken);
            const assignmentSnippet = this.importProcessor.resolveExportBinding(identifierName);
            if (!assignmentSnippet) {
                return false;
            }
            const operatorCode = this.tokens.rawCodeForToken(operatorToken);
            // We might also replace the identifier with something like exports.x, so
            // do that replacement here as well.
            const base = this.importProcessor.getIdentifierReplacement(identifierName) || identifierName;
            if (operatorCode === "++") {
                this.tokens.replaceToken(`(${base} = ${assignmentSnippet} = ${base} + 1, ${base} - 1)`);
            }
            else if (operatorCode === "--") {
                this.tokens.replaceToken(`(${base} = ${assignmentSnippet} = ${base} - 1, ${base} + 1)`);
            }
            else {
                throw new Error(`Unexpected operator: ${operatorCode}`);
            }
            this.tokens.removeToken();
            return true;
        }
        processExportDefault() {
            let exportedRuntimeValue = true;
            if (this.tokens.matches4(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._function, types_1.TokenType.name) ||
                // export default async function
                (this.tokens.matches5(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType.name, types_1.TokenType._function, types_1.TokenType.name) &&
                    this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 2, keywords_1.ContextualKeyword._async))) {
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                // Named function export case: change it to a top-level function
                // declaration followed by exports statement.
                const name = this.processNamedFunction();
                this.tokens.appendCode(` exports.default = ${name};`);
            }
            else if (this.tokens.matches4(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._class, types_1.TokenType.name) ||
                this.tokens.matches5(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._abstract, types_1.TokenType._class, types_1.TokenType.name) ||
                this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType.at)) {
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                this.copyDecorators();
                if (this.tokens.matches1(types_1.TokenType._abstract)) {
                    this.tokens.removeToken();
                }
                const name = this.rootTransformer.processNamedClass();
                this.tokens.appendCode(` exports.default = ${name};`);
                // After this point, this is a plain "export default E" statement.
            }
            else if ((0, shouldElideDefaultExport_1.default)(this.isTypeScriptTransformEnabled, this.keepUnusedImports, this.tokens, this.declarationInfo)) {
                // If the exported value is just an identifier and should be elided by TypeScript
                // rules, then remove it entirely. It will always have the form `export default e`,
                // where `e` is an identifier.
                exportedRuntimeValue = false;
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                this.tokens.removeToken();
            }
            else if (this.reactHotLoaderTransformer) {
                // We need to assign E to a variable. Change "export default E" to
                // "let _default; exports.default = _default = E"
                const defaultVarName = this.nameManager.claimFreeName("_default");
                this.tokens.replaceToken(`let ${defaultVarName}; exports.`);
                this.tokens.copyToken();
                this.tokens.appendCode(` = ${defaultVarName} =`);
                this.reactHotLoaderTransformer.setExtractedDefaultExportName(defaultVarName);
            }
            else {
                // Change "export default E" to "exports.default = E"
                this.tokens.replaceToken("exports.");
                this.tokens.copyToken();
                this.tokens.appendCode(" =");
            }
            if (exportedRuntimeValue) {
                this.hadDefaultExport = true;
            }
        }
        copyDecorators() {
            while (this.tokens.matches1(types_1.TokenType.at)) {
                this.tokens.copyToken();
                if (this.tokens.matches1(types_1.TokenType.parenL)) {
                    this.tokens.copyExpectedToken(types_1.TokenType.parenL);
                    this.rootTransformer.processBalancedCode();
                    this.tokens.copyExpectedToken(types_1.TokenType.parenR);
                }
                else {
                    this.tokens.copyExpectedToken(types_1.TokenType.name);
                    while (this.tokens.matches1(types_1.TokenType.dot)) {
                        this.tokens.copyExpectedToken(types_1.TokenType.dot);
                        this.tokens.copyExpectedToken(types_1.TokenType.name);
                    }
                    if (this.tokens.matches1(types_1.TokenType.parenL)) {
                        this.tokens.copyExpectedToken(types_1.TokenType.parenL);
                        this.rootTransformer.processBalancedCode();
                        this.tokens.copyExpectedToken(types_1.TokenType.parenR);
                    }
                }
            }
        }
        /**
         * Transform a declaration like `export var`, `export let`, or `export const`.
         */
        processExportVar() {
            if (this.isSimpleExportVar()) {
                this.processSimpleExportVar();
            }
            else {
                this.processComplexExportVar();
            }
        }
        /**
         * Determine if the export is of the form:
         * export var/let/const [varName] = [expr];
         * In other words, determine if function name inference might apply.
         */
        isSimpleExportVar() {
            let tokenIndex = this.tokens.currentIndex();
            // export
            tokenIndex++;
            // var/let/const
            tokenIndex++;
            if (!this.tokens.matches1AtIndex(tokenIndex, types_1.TokenType.name)) {
                return false;
            }
            tokenIndex++;
            while (tokenIndex < this.tokens.tokens.length && this.tokens.tokens[tokenIndex].isType) {
                tokenIndex++;
            }
            if (!this.tokens.matches1AtIndex(tokenIndex, types_1.TokenType.eq)) {
                return false;
            }
            return true;
        }
        /**
         * Transform an `export var` declaration initializing a single variable.
         *
         * For example, this:
         * export const f = () => {};
         * becomes this:
         * const f = () => {}; exports.f = f;
         *
         * The variable is unused (e.g. exports.f has the true value of the export).
         * We need to produce an assignment of this form so that the function will
         * have an inferred name of "f", which wouldn't happen in the more general
         * case below.
         */
        processSimpleExportVar() {
            // export
            this.tokens.removeInitialToken();
            // var/let/const
            this.tokens.copyToken();
            const varName = this.tokens.identifierName();
            // x: number  ->  x
            while (!this.tokens.matches1(types_1.TokenType.eq)) {
                this.rootTransformer.processToken();
            }
            const endIndex = this.tokens.currentToken().rhsEndIndex;
            if (endIndex == null) {
                throw new Error("Expected = token with an end index.");
            }
            while (this.tokens.currentIndex() < endIndex) {
                this.rootTransformer.processToken();
            }
            this.tokens.appendCode(`; exports.${varName} = ${varName}`);
        }
        /**
         * Transform normal declaration exports, including handling destructuring.
         * For example, this:
         * export const {x: [a = 2, b], c} = d;
         * becomes this:
         * ({x: [exports.a = 2, exports.b], c: exports.c} = d;)
         */
        processComplexExportVar() {
            this.tokens.removeInitialToken();
            this.tokens.removeToken();
            const needsParens = this.tokens.matches1(types_1.TokenType.braceL);
            if (needsParens) {
                this.tokens.appendCode("(");
            }
            let depth = 0;
            while (true) {
                if (this.tokens.matches1(types_1.TokenType.braceL) ||
                    this.tokens.matches1(types_1.TokenType.dollarBraceL) ||
                    this.tokens.matches1(types_1.TokenType.bracketL)) {
                    depth++;
                    this.tokens.copyToken();
                }
                else if (this.tokens.matches1(types_1.TokenType.braceR) || this.tokens.matches1(types_1.TokenType.bracketR)) {
                    depth--;
                    this.tokens.copyToken();
                }
                else if (depth === 0 &&
                    !this.tokens.matches1(types_1.TokenType.name) &&
                    !this.tokens.currentToken().isType) {
                    break;
                }
                else if (this.tokens.matches1(types_1.TokenType.eq)) {
                    // Default values might have assignments in the RHS that we want to ignore, so skip past
                    // them.
                    const endIndex = this.tokens.currentToken().rhsEndIndex;
                    if (endIndex == null) {
                        throw new Error("Expected = token with an end index.");
                    }
                    while (this.tokens.currentIndex() < endIndex) {
                        this.rootTransformer.processToken();
                    }
                }
                else {
                    const token = this.tokens.currentToken();
                    if ((0, tokenizer_1.isDeclaration)(token)) {
                        const name = this.tokens.identifierName();
                        let replacement = this.importProcessor.getIdentifierReplacement(name);
                        if (replacement === null) {
                            throw new Error(`Expected a replacement for ${name} in \`export var\` syntax.`);
                        }
                        if ((0, tokenizer_1.isObjectShorthandDeclaration)(token)) {
                            replacement = `${name}: ${replacement}`;
                        }
                        this.tokens.replaceToken(replacement);
                    }
                    else {
                        this.rootTransformer.processToken();
                    }
                }
            }
            if (needsParens) {
                // Seek to the end of the RHS.
                const endIndex = this.tokens.currentToken().rhsEndIndex;
                if (endIndex == null) {
                    throw new Error("Expected = token with an end index.");
                }
                while (this.tokens.currentIndex() < endIndex) {
                    this.rootTransformer.processToken();
                }
                this.tokens.appendCode(")");
            }
        }
        /**
         * Transform this:
         * export function foo() {}
         * into this:
         * function foo() {} exports.foo = foo;
         */
        processExportFunction() {
            this.tokens.replaceToken("");
            const name = this.processNamedFunction();
            this.tokens.appendCode(` exports.${name} = ${name};`);
        }
        /**
         * Skip past a function with a name and return that name.
         */
        processNamedFunction() {
            if (this.tokens.matches1(types_1.TokenType._function)) {
                this.tokens.copyToken();
            }
            else if (this.tokens.matches2(types_1.TokenType.name, types_1.TokenType._function)) {
                if (!this.tokens.matchesContextual(keywords_1.ContextualKeyword._async)) {
                    throw new Error("Expected async keyword in function export.");
                }
                this.tokens.copyToken();
                this.tokens.copyToken();
            }
            if (this.tokens.matches1(types_1.TokenType.star)) {
                this.tokens.copyToken();
            }
            if (!this.tokens.matches1(types_1.TokenType.name)) {
                throw new Error("Expected identifier for exported function name.");
            }
            const name = this.tokens.identifierName();
            this.tokens.copyToken();
            if (this.tokens.currentToken().isType) {
                this.tokens.removeInitialToken();
                while (this.tokens.currentToken().isType) {
                    this.tokens.removeToken();
                }
            }
            this.tokens.copyExpectedToken(types_1.TokenType.parenL);
            this.rootTransformer.processBalancedCode();
            this.tokens.copyExpectedToken(types_1.TokenType.parenR);
            this.rootTransformer.processPossibleTypeRange();
            this.tokens.copyExpectedToken(types_1.TokenType.braceL);
            this.rootTransformer.processBalancedCode();
            this.tokens.copyExpectedToken(types_1.TokenType.braceR);
            return name;
        }
        /**
         * Transform this:
         * export class A {}
         * into this:
         * class A {} exports.A = A;
         */
        processExportClass() {
            this.tokens.removeInitialToken();
            this.copyDecorators();
            if (this.tokens.matches1(types_1.TokenType._abstract)) {
                this.tokens.removeToken();
            }
            const name = this.rootTransformer.processNamedClass();
            this.tokens.appendCode(` exports.${name} = ${name};`);
        }
        /**
         * Transform this:
         * export {a, b as c};
         * into this:
         * exports.a = a; exports.c = b;
         *
         * OR
         *
         * Transform this:
         * export {a, b as c} from './foo';
         * into the pre-generated Object.defineProperty code from the ImportProcessor.
         *
         * For the first case, if the TypeScript transform is enabled, we need to skip
         * exports that are only defined as types.
         */
        processExportBindings() {
            this.tokens.removeInitialToken();
            this.tokens.removeToken();
            const isReExport = (0, isExportFrom_1.default)(this.tokens);
            const exportStatements = [];
            while (true) {
                if (this.tokens.matches1(types_1.TokenType.braceR)) {
                    this.tokens.removeToken();
                    break;
                }
                const specifierInfo = (0, getImportExportSpecifierInfo_1.default)(this.tokens);
                while (this.tokens.currentIndex() < specifierInfo.endIndex) {
                    this.tokens.removeToken();
                }
                const shouldRemoveExport = specifierInfo.isType ||
                    (!isReExport && this.shouldElideExportedIdentifier(specifierInfo.leftName));
                if (!shouldRemoveExport) {
                    const exportedName = specifierInfo.rightName;
                    if (exportedName === "default") {
                        this.hadDefaultExport = true;
                    }
                    else {
                        this.hadNamedExport = true;
                    }
                    const localName = specifierInfo.leftName;
                    const newLocalName = this.importProcessor.getIdentifierReplacement(localName);
                    exportStatements.push(`exports.${exportedName} = ${newLocalName || localName};`);
                }
                if (this.tokens.matches1(types_1.TokenType.braceR)) {
                    this.tokens.removeToken();
                    break;
                }
                if (this.tokens.matches2(types_1.TokenType.comma, types_1.TokenType.braceR)) {
                    this.tokens.removeToken();
                    this.tokens.removeToken();
                    break;
                }
                else if (this.tokens.matches1(types_1.TokenType.comma)) {
                    this.tokens.removeToken();
                }
                else {
                    throw new Error(`Unexpected token: ${JSON.stringify(this.tokens.currentToken())}`);
                }
            }
            if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._from)) {
                // This is an export...from, so throw away the normal named export code
                // and use the Object.defineProperty code from ImportProcessor.
                this.tokens.removeToken();
                const path = this.tokens.stringValue();
                this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(path));
                (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
            }
            else {
                // This is a normal named export, so use that.
                this.tokens.appendCode(exportStatements.join(" "));
            }
            if (this.tokens.matches1(types_1.TokenType.semi)) {
                this.tokens.removeToken();
            }
        }
        processExportStar() {
            this.tokens.removeInitialToken();
            while (!this.tokens.matches1(types_1.TokenType.string)) {
                this.tokens.removeToken();
            }
            const path = this.tokens.stringValue();
            this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(path));
            (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
            if (this.tokens.matches1(types_1.TokenType.semi)) {
                this.tokens.removeToken();
            }
        }
        shouldElideExportedIdentifier(name) {
            return (this.isTypeScriptTransformEnabled &&
                !this.keepUnusedImports &&
                !this.declarationInfo.valueDeclarations.has(name));
        }
    }
    exports.default = CJSImportTransformer;
},
"a5f4e01d7b": /* sucrase\dist\esm\util\elideImportEquals.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = elideImportEquals;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    function elideImportEquals(tokens) {
        // import
        tokens.removeInitialToken();
        // name
        tokens.removeToken();
        // =
        tokens.removeToken();
        // name or require
        tokens.removeToken();
        // Handle either `import A = require('A')` or `import A = B.C.D`.
        if (tokens.matches1(types_1.TokenType.parenL)) {
            // (
            tokens.removeToken();
            // path string
            tokens.removeToken();
            // )
            tokens.removeToken();
        }
        else {
            while (tokens.matches1(types_1.TokenType.dot)) {
                // .
                tokens.removeToken();
                // name
                tokens.removeToken();
            }
        }
    }
},
"f1b0dcccab": /* sucrase\dist\esm\util\getDeclarationInfo.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getDeclarationInfo;
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    exports.EMPTY_DECLARATION_INFO = {
        typeDeclarations: new Set(),
        valueDeclarations: new Set(),
    };
    /**
     * Get all top-level identifiers that should be preserved when exported in TypeScript.
     *
     * Examples:
     * - If an identifier is declared as `const x`, then `export {x}` should be preserved.
     * - If it's declared as `type x`, then `export {x}` should be removed.
     * - If it's declared as both `const x` and `type x`, then the export should be preserved.
     * - Classes and enums should be preserved (even though they also introduce types).
     * - Imported identifiers should be preserved since we don't have enough information to
     *   rule them out. --isolatedModules disallows re-exports, which catches errors here.
     */
    function getDeclarationInfo(tokens) {
        const typeDeclarations = new Set();
        const valueDeclarations = new Set();
        for (let i = 0; i < tokens.tokens.length; i++) {
            const token = tokens.tokens[i];
            if (token.type === types_1.TokenType.name && (0, tokenizer_1.isTopLevelDeclaration)(token)) {
                if (token.isType) {
                    typeDeclarations.add(tokens.identifierNameForToken(token));
                }
                else {
                    valueDeclarations.add(tokens.identifierNameForToken(token));
                }
            }
        }
        return { typeDeclarations, valueDeclarations };
    }
},
"c3c484c8b2": /* sucrase\dist\esm\util\isExportFrom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = isExportFrom;
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Starting at `export {`, look ahead and return `true` if this is an
     * `export {...} from` statement and `false` if this is a plain multi-export.
     */
    function isExportFrom(tokens) {
        let closeBraceIndex = tokens.currentIndex();
        while (!tokens.matches1AtIndex(closeBraceIndex, types_1.TokenType.braceR)) {
            closeBraceIndex++;
        }
        return (tokens.matchesContextualAtIndex(closeBraceIndex + 1, keywords_1.ContextualKeyword._from) &&
            tokens.matches1AtIndex(closeBraceIndex + 2, types_1.TokenType.string));
    }
},
"f659e3ed39": /* sucrase\dist\esm\util\removeMaybeImportAttributes.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.removeMaybeImportAttributes = removeMaybeImportAttributes;
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Starting at a potential `with` or (legacy) `assert` token, remove the import
     * attributes if they exist.
     */
    function removeMaybeImportAttributes(tokens) {
        if (tokens.matches2(types_1.TokenType._with, types_1.TokenType.braceL) ||
            (tokens.matches2(types_1.TokenType.name, types_1.TokenType.braceL) && tokens.matchesContextual(keywords_1.ContextualKeyword._assert))) {
            // assert
            tokens.removeToken();
            // {
            tokens.removeToken();
            tokens.removeBalancedCode();
            // }
            tokens.removeToken();
        }
    }
},
"11afb90ac4": /* sucrase\dist\esm\util\shouldElideDefaultExport.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = shouldElideDefaultExport;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    /**
     * Common method sharing code between CJS and ESM cases, since they're the same here.
     */
    function shouldElideDefaultExport(isTypeScriptTransformEnabled, keepUnusedImports, tokens, declarationInfo) {
        if (!isTypeScriptTransformEnabled || keepUnusedImports) {
            return false;
        }
        const exportToken = tokens.currentToken();
        if (exportToken.rhsEndIndex == null) {
            throw new Error("Expected non-null rhsEndIndex on export token.");
        }
        // The export must be of the form `export default a` or `export default a;`.
        const numTokens = exportToken.rhsEndIndex - tokens.currentIndex();
        if (numTokens !== 3 &&
            !(numTokens === 4 && tokens.matches1AtIndex(exportToken.rhsEndIndex - 1, types_1.TokenType.semi))) {
            return false;
        }
        const identifierToken = tokens.tokenAtRelativeIndex(2);
        if (identifierToken.type !== types_1.TokenType.name) {
            return false;
        }
        const exportedName = tokens.identifierNameForToken(identifierToken);
        return (declarationInfo.typeDeclarations.has(exportedName) &&
            !declarationInfo.valueDeclarations.has(exportedName));
    }
},
"8db2e4c5d7": /* sucrase\dist\esm\transformers\ESMImportTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const elideImportEquals_1 = tslib_1.__importDefault(require("a5f4e01d7b") /* ../util/elideImportEquals */);
    const getDeclarationInfo_1 = tslib_1.__importStar(require("f1b0dcccab") /* ../util/getDeclarationInfo */);
    const getImportExportSpecifierInfo_1 = tslib_1.__importDefault(require("14d4ae78a4") /* ../util/getImportExportSpecifierInfo */);
    const getNonTypeIdentifiers_1 = require("1ff9c9004b") /* ../util/getNonTypeIdentifiers */;
    const isExportFrom_1 = tslib_1.__importDefault(require("c3c484c8b2") /* ../util/isExportFrom */);
    const removeMaybeImportAttributes_1 = require("f659e3ed39") /* ../util/removeMaybeImportAttributes */;
    const shouldElideDefaultExport_1 = tslib_1.__importDefault(require("11afb90ac4") /* ../util/shouldElideDefaultExport */);
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    /**
     * Class for editing import statements when we are keeping the code as ESM. We still need to remove
     * type-only imports in TypeScript and Flow.
     */
    class ESMImportTransformer extends Transformer_1.default {
        constructor(tokens, nameManager, helperManager, reactHotLoaderTransformer, isTypeScriptTransformEnabled, isFlowTransformEnabled, keepUnusedImports, options) {
            super();
            this.tokens = tokens;
            this.nameManager = nameManager;
            this.helperManager = helperManager;
            this.reactHotLoaderTransformer = reactHotLoaderTransformer;
            this.isTypeScriptTransformEnabled = isTypeScriptTransformEnabled;
            this.isFlowTransformEnabled = isFlowTransformEnabled;
            this.keepUnusedImports = keepUnusedImports;
            ;
            this.nonTypeIdentifiers =
                isTypeScriptTransformEnabled && !keepUnusedImports
                    ? (0, getNonTypeIdentifiers_1.getNonTypeIdentifiers)(tokens, options)
                    : new Set();
            this.declarationInfo =
                isTypeScriptTransformEnabled && !keepUnusedImports
                    ? (0, getDeclarationInfo_1.default)(tokens)
                    : getDeclarationInfo_1.EMPTY_DECLARATION_INFO;
            this.injectCreateRequireForImportRequire = Boolean(options.injectCreateRequireForImportRequire);
        }
        process() {
            // TypeScript `import foo = require('foo');` should always just be translated to plain require.
            if (this.tokens.matches3(types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.eq)) {
                return this.processImportEquals();
            }
            if (this.tokens.matches4(types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.eq) &&
                this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 1, keywords_1.ContextualKeyword._type)) {
                // import type T = require('T')
                this.tokens.removeInitialToken();
                // This construct is always exactly 8 tokens long, so remove the 7 remaining tokens.
                for (let i = 0; i < 7; i++) {
                    this.tokens.removeToken();
                }
                return true;
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.eq)) {
                this.tokens.replaceToken("module.exports");
                return true;
            }
            if (this.tokens.matches5(types_1.TokenType._export, types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.name, types_1.TokenType.eq) &&
                this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 2, keywords_1.ContextualKeyword._type)) {
                // export import type T = require('T')
                this.tokens.removeInitialToken();
                // This construct is always exactly 9 tokens long, so remove the 8 remaining tokens.
                for (let i = 0; i < 8; i++) {
                    this.tokens.removeToken();
                }
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._import)) {
                return this.processImport();
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._default)) {
                return this.processExportDefault();
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.braceL)) {
                return this.processNamedExports();
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType.name) &&
                this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 1, keywords_1.ContextualKeyword._type)) {
                // export type {a};
                // export type {a as b};
                // export type {a} from './b';
                // export type * from './b';
                // export type * as ns from './b';
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                if (this.tokens.matches1(types_1.TokenType.braceL)) {
                    while (!this.tokens.matches1(types_1.TokenType.braceR)) {
                        this.tokens.removeToken();
                    }
                    this.tokens.removeToken();
                }
                else {
                    // *
                    this.tokens.removeToken();
                    if (this.tokens.matches1(types_1.TokenType._as)) {
                        // as
                        this.tokens.removeToken();
                        // ns
                        this.tokens.removeToken();
                    }
                }
                // Remove type re-export `... } from './T'`
                if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._from) &&
                    this.tokens.matches1AtIndex(this.tokens.currentIndex() + 1, types_1.TokenType.string)) {
                    this.tokens.removeToken();
                    this.tokens.removeToken();
                    (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
                }
                return true;
            }
            return false;
        }
        processImportEquals() {
            const importName = this.tokens.identifierNameAtIndex(this.tokens.currentIndex() + 1);
            if (this.shouldAutomaticallyElideImportedName(importName)) {
                // If this name is only used as a type, elide the whole import.
                (0, elideImportEquals_1.default)(this.tokens);
            }
            else if (this.injectCreateRequireForImportRequire) {
                // We're using require in an environment (Node ESM) that doesn't provide
                // it as a global, so generate a helper to import it.
                // import -> const
                this.tokens.replaceToken("const");
                // Foo
                this.tokens.copyToken();
                // =
                this.tokens.copyToken();
                // require
                this.tokens.replaceToken(this.helperManager.getHelperName("require"));
            }
            else {
                // Otherwise, just switch `import` to `const`.
                this.tokens.replaceToken("const");
            }
            return true;
        }
        processImport() {
            if (this.tokens.matches2(types_1.TokenType._import, types_1.TokenType.parenL)) {
                // Dynamic imports don't need to be transformed.
                return false;
            }
            const snapshot = this.tokens.snapshot();
            const allImportsRemoved = this.removeImportTypeBindings();
            if (allImportsRemoved) {
                this.tokens.restoreToSnapshot(snapshot);
                while (!this.tokens.matches1(types_1.TokenType.string)) {
                    this.tokens.removeToken();
                }
                this.tokens.removeToken();
                (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
                if (this.tokens.matches1(types_1.TokenType.semi)) {
                    this.tokens.removeToken();
                }
            }
            return true;
        }
        /**
         * Remove type bindings from this import, leaving the rest of the import intact.
         *
         * Return true if this import was ONLY types, and thus is eligible for removal. This will bail out
         * of the replacement operation, so we can return early here.
         */
        removeImportTypeBindings() {
            this.tokens.copyExpectedToken(types_1.TokenType._import);
            if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._type) &&
                !this.tokens.matches1AtIndex(this.tokens.currentIndex() + 1, types_1.TokenType.comma) &&
                !this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 1, keywords_1.ContextualKeyword._from)) {
                // This is an "import type" statement, so exit early.
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType.string)) {
                // This is a bare import, so we should proceed with the import.
                this.tokens.copyToken();
                return false;
            }
            // Skip the "module" token in import reflection.
            if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._module) &&
                this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 2, keywords_1.ContextualKeyword._from)) {
                this.tokens.copyToken();
            }
            let foundNonTypeImport = false;
            let foundAnyNamedImport = false;
            let needsComma = false;
            // Handle default import.
            if (this.tokens.matches1(types_1.TokenType.name)) {
                if (this.shouldAutomaticallyElideImportedName(this.tokens.identifierName())) {
                    this.tokens.removeToken();
                    if (this.tokens.matches1(types_1.TokenType.comma)) {
                        this.tokens.removeToken();
                    }
                }
                else {
                    foundNonTypeImport = true;
                    this.tokens.copyToken();
                    if (this.tokens.matches1(types_1.TokenType.comma)) {
                        // We're in a statement like:
                        // import A, * as B from './A';
                        // or
                        // import A, {foo} from './A';
                        // where the `A` is being kept. The comma should be removed if an only
                        // if the next part of the import statement is elided, but that's hard
                        // to determine at this point in the code. Instead, always remove it
                        // and set a flag to add it back if necessary.
                        needsComma = true;
                        this.tokens.removeToken();
                    }
                }
            }
            if (this.tokens.matches1(types_1.TokenType.star)) {
                if (this.shouldAutomaticallyElideImportedName(this.tokens.identifierNameAtRelativeIndex(2))) {
                    this.tokens.removeToken();
                    this.tokens.removeToken();
                    this.tokens.removeToken();
                }
                else {
                    if (needsComma) {
                        this.tokens.appendCode(",");
                    }
                    foundNonTypeImport = true;
                    this.tokens.copyExpectedToken(types_1.TokenType.star);
                    this.tokens.copyExpectedToken(types_1.TokenType.name);
                    this.tokens.copyExpectedToken(types_1.TokenType.name);
                }
            }
            else if (this.tokens.matches1(types_1.TokenType.braceL)) {
                if (needsComma) {
                    this.tokens.appendCode(",");
                }
                this.tokens.copyToken();
                while (!this.tokens.matches1(types_1.TokenType.braceR)) {
                    foundAnyNamedImport = true;
                    const specifierInfo = (0, getImportExportSpecifierInfo_1.default)(this.tokens);
                    if (specifierInfo.isType ||
                        this.shouldAutomaticallyElideImportedName(specifierInfo.rightName)) {
                        while (this.tokens.currentIndex() < specifierInfo.endIndex) {
                            this.tokens.removeToken();
                        }
                        if (this.tokens.matches1(types_1.TokenType.comma)) {
                            this.tokens.removeToken();
                        }
                    }
                    else {
                        foundNonTypeImport = true;
                        while (this.tokens.currentIndex() < specifierInfo.endIndex) {
                            this.tokens.copyToken();
                        }
                        if (this.tokens.matches1(types_1.TokenType.comma)) {
                            this.tokens.copyToken();
                        }
                    }
                }
                this.tokens.copyExpectedToken(types_1.TokenType.braceR);
            }
            if (this.keepUnusedImports) {
                return false;
            }
            if (this.isTypeScriptTransformEnabled) {
                return !foundNonTypeImport;
            }
            else if (this.isFlowTransformEnabled) {
                // In Flow, unlike TS, `import {} from 'foo';` preserves the import.
                return foundAnyNamedImport && !foundNonTypeImport;
            }
            else {
                return false;
            }
        }
        shouldAutomaticallyElideImportedName(name) {
            return (this.isTypeScriptTransformEnabled &&
                !this.keepUnusedImports &&
                !this.nonTypeIdentifiers.has(name));
        }
        processExportDefault() {
            if ((0, shouldElideDefaultExport_1.default)(this.isTypeScriptTransformEnabled, this.keepUnusedImports, this.tokens, this.declarationInfo)) {
                // If the exported value is just an identifier and should be elided by TypeScript
                // rules, then remove it entirely. It will always have the form `export default e`,
                // where `e` is an identifier.
                this.tokens.removeInitialToken();
                this.tokens.removeToken();
                this.tokens.removeToken();
                return true;
            }
            const alreadyHasName = this.tokens.matches4(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._function, types_1.TokenType.name) ||
                // export default async function
                (this.tokens.matches5(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType.name, types_1.TokenType._function, types_1.TokenType.name) &&
                    this.tokens.matchesContextualAtIndex(this.tokens.currentIndex() + 2, keywords_1.ContextualKeyword._async)) ||
                this.tokens.matches4(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._class, types_1.TokenType.name) ||
                this.tokens.matches5(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._abstract, types_1.TokenType._class, types_1.TokenType.name);
            if (!alreadyHasName && this.reactHotLoaderTransformer) {
                // This is a plain "export default E" statement and we need to assign E to a variable.
                // Change "export default E" to "let _default; export default _default = E"
                const defaultVarName = this.nameManager.claimFreeName("_default");
                this.tokens.replaceToken(`let ${defaultVarName}; export`);
                this.tokens.copyToken();
                this.tokens.appendCode(` ${defaultVarName} =`);
                this.reactHotLoaderTransformer.setExtractedDefaultExportName(defaultVarName);
                return true;
            }
            return false;
        }
        /**
         * Handle a statement with one of these forms:
         * export {a, type b};
         * export {c, type d} from 'foo';
         *
         * In both cases, any explicit type exports should be removed. In the first
         * case, we also need to handle implicit export elision for names declared as
         * types. In the second case, we must NOT do implicit named export elision,
         * but we must remove the runtime import if all exports are type exports.
         */
        processNamedExports() {
            if (!this.isTypeScriptTransformEnabled) {
                return false;
            }
            this.tokens.copyExpectedToken(types_1.TokenType._export);
            this.tokens.copyExpectedToken(types_1.TokenType.braceL);
            const isReExport = (0, isExportFrom_1.default)(this.tokens);
            let foundNonTypeExport = false;
            while (!this.tokens.matches1(types_1.TokenType.braceR)) {
                const specifierInfo = (0, getImportExportSpecifierInfo_1.default)(this.tokens);
                if (specifierInfo.isType ||
                    (!isReExport && this.shouldElideExportedName(specifierInfo.leftName))) {
                    // Type export, so remove all tokens, including any comma.
                    while (this.tokens.currentIndex() < specifierInfo.endIndex) {
                        this.tokens.removeToken();
                    }
                    if (this.tokens.matches1(types_1.TokenType.comma)) {
                        this.tokens.removeToken();
                    }
                }
                else {
                    // Non-type export, so copy all tokens, including any comma.
                    foundNonTypeExport = true;
                    while (this.tokens.currentIndex() < specifierInfo.endIndex) {
                        this.tokens.copyToken();
                    }
                    if (this.tokens.matches1(types_1.TokenType.comma)) {
                        this.tokens.copyToken();
                    }
                }
            }
            this.tokens.copyExpectedToken(types_1.TokenType.braceR);
            if (!this.keepUnusedImports && isReExport && !foundNonTypeExport) {
                // This is a type-only re-export, so skip evaluating the other module. Technically this
                // leaves the statement as `export {}`, but that's ok since that's a no-op.
                this.tokens.removeToken();
                this.tokens.removeToken();
                (0, removeMaybeImportAttributes_1.removeMaybeImportAttributes)(this.tokens);
            }
            return true;
        }
        /**
         * ESM elides all imports with the rule that we only elide if we see that it's
         * a type and never see it as a value. This is in contrast to CJS, which
         * elides imports that are completely unknown.
         */
        shouldElideExportedName(name) {
            return (this.isTypeScriptTransformEnabled &&
                !this.keepUnusedImports &&
                this.declarationInfo.typeDeclarations.has(name) &&
                !this.declarationInfo.valueDeclarations.has(name));
        }
    }
    exports.default = ESMImportTransformer;
},
"3913cc12b3": /* sucrase\dist\esm\transformers\FlowTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const keywords_1 = require("99ff836c64") /* ../parser/tokenizer/keywords */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class FlowTransformer extends Transformer_1.default {
        constructor(rootTransformer, tokens, isImportsTransformEnabled) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.isImportsTransformEnabled = isImportsTransformEnabled;
            ;
        }
        process() {
            if (this.rootTransformer.processPossibleArrowParamEnd() ||
                this.rootTransformer.processPossibleAsyncArrowWithTypeParams() ||
                this.rootTransformer.processPossibleTypeRange()) {
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._enum)) {
                this.processEnum();
                return true;
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._enum)) {
                this.processNamedExportEnum();
                return true;
            }
            if (this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._default, types_1.TokenType._enum)) {
                this.processDefaultExportEnum();
                return true;
            }
            return false;
        }
        /**
         * Handle a declaration like:
         * export enum E ...
         *
         * With this imports transform, this becomes:
         * const E = [[enum]]; exports.E = E;
         *
         * otherwise, it becomes:
         * export const E = [[enum]];
         */
        processNamedExportEnum() {
            if (this.isImportsTransformEnabled) {
                // export
                this.tokens.removeInitialToken();
                const enumName = this.tokens.identifierNameAtRelativeIndex(1);
                this.processEnum();
                this.tokens.appendCode(` exports.${enumName} = ${enumName};`);
            }
            else {
                this.tokens.copyToken();
                this.processEnum();
            }
        }
        /**
         * Handle a declaration like:
         * export default enum E
         *
         * With the imports transform, this becomes:
         * const E = [[enum]]; exports.default = E;
         *
         * otherwise, it becomes:
         * const E = [[enum]]; export default E;
         */
        processDefaultExportEnum() {
            // export
            this.tokens.removeInitialToken();
            // default
            this.tokens.removeToken();
            const enumName = this.tokens.identifierNameAtRelativeIndex(1);
            this.processEnum();
            if (this.isImportsTransformEnabled) {
                this.tokens.appendCode(` exports.default = ${enumName};`);
            }
            else {
                this.tokens.appendCode(` export default ${enumName};`);
            }
        }
        /**
         * Transpile flow enums to invoke the "flow-enums-runtime" library.
         *
         * Currently, the transpiled code always uses `require("flow-enums-runtime")`,
         * but if future flexibility is needed, we could expose a config option for
         * this string (similar to configurable JSX). Even when targeting ESM, the
         * default behavior of babel-plugin-transform-flow-enums is to use require
         * rather than injecting an import.
         *
         * Flow enums are quite a bit simpler than TS enums and have some convenient
         * constraints:
         * - Element initializers must be either always present or always absent. That
         *   means that we can use fixed lookahead on the first element (if any) and
         *   assume that all elements are like that.
         * - The right-hand side of an element initializer must be a literal value,
         *   not a complex expression and not referencing other elements. That means
         *   we can simply copy a single token.
         *
         * Enums can be broken up into three basic cases:
         *
         * Mirrored enums:
         * enum E {A, B}
         *   ->
         * const E = require("flow-enums-runtime").Mirrored(["A", "B"]);
         *
         * Initializer enums:
         * enum E {A = 1, B = 2}
         *   ->
         * const E = require("flow-enums-runtime")({A: 1, B: 2});
         *
         * Symbol enums:
         * enum E of symbol {A, B}
         *   ->
         * const E = require("flow-enums-runtime")({A: Symbol("A"), B: Symbol("B")});
         *
         * We can statically detect which of the three cases this is by looking at the
         * "of" declaration (if any) and seeing if the first element has an initializer.
         * Since the other transform details are so similar between the three cases, we
         * use a single implementation and vary the transform within processEnumElement
         * based on case.
         */
        processEnum() {
            // enum E -> const E
            this.tokens.replaceToken("const");
            this.tokens.copyExpectedToken(types_1.TokenType.name);
            let isSymbolEnum = false;
            if (this.tokens.matchesContextual(keywords_1.ContextualKeyword._of)) {
                this.tokens.removeToken();
                isSymbolEnum = this.tokens.matchesContextual(keywords_1.ContextualKeyword._symbol);
                this.tokens.removeToken();
            }
            const hasInitializers = this.tokens.matches3(types_1.TokenType.braceL, types_1.TokenType.name, types_1.TokenType.eq);
            this.tokens.appendCode(' = require("flow-enums-runtime")');
            const isMirrored = !isSymbolEnum && !hasInitializers;
            this.tokens.replaceTokenTrimmingLeftWhitespace(isMirrored ? ".Mirrored([" : "({");
            while (!this.tokens.matches1(types_1.TokenType.braceR)) {
                // ... is allowed at the end and has no runtime behavior.
                if (this.tokens.matches1(types_1.TokenType.ellipsis)) {
                    this.tokens.removeToken();
                    break;
                }
                this.processEnumElement(isSymbolEnum, hasInitializers);
                if (this.tokens.matches1(types_1.TokenType.comma)) {
                    this.tokens.copyToken();
                }
            }
            this.tokens.replaceToken(isMirrored ? "]);" : "});");
        }
        /**
         * Process an individual enum element, producing either an array element or an
         * object element based on what type of enum this is.
         */
        processEnumElement(isSymbolEnum, hasInitializers) {
            if (isSymbolEnum) {
                // Symbol enums never have initializers and are expanded to object elements.
                // A, -> A: Symbol("A"),
                const elementName = this.tokens.identifierName();
                this.tokens.copyToken();
                this.tokens.appendCode(`: Symbol("${elementName}")`);
            }
            else if (hasInitializers) {
                // Initializers are expanded to object elements.
                // A = 1, -> A: 1,
                this.tokens.copyToken();
                this.tokens.replaceTokenTrimmingLeftWhitespace(":");
                this.tokens.copyToken();
            }
            else {
                // Enum elements without initializers become string literal array elements.
                // A, -> "A",
                this.tokens.replaceToken(`"${this.tokens.identifierName()}"`);
            }
        }
    }
    exports.default = FlowTransformer;
},
"3eb46b07e3": /* sucrase\dist\esm\transformers\JestHoistTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    function _optionalChain(ops) {
        let lastAccessLHS = undefined;
        let value = ops[0];
        let i = 1;
        while (i < ops.length) {
            const op = ops[i];
            const fn = ops[i + 1];
            i += 2;
            if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {
                return undefined;
            }
            if (op === 'access' || op === 'optionalAccess') {
                lastAccessLHS = value;
                value = fn(value);
            }
            else if (op === 'call' || op === 'optionalCall') {
                value = fn((...args) => value.call(lastAccessLHS, ...args));
                lastAccessLHS = undefined;
            }
        }
        return value;
    }
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    const JEST_GLOBAL_NAME = "jest";
    const HOISTED_METHODS = ["mock", "unmock", "enableAutomock", "disableAutomock"];
    /**
     * Implementation of babel-plugin-jest-hoist, which hoists up some jest method
     * calls above the imports to allow them to override other imports.
     *
     * To preserve line numbers, rather than directly moving the jest.mock code, we
     * wrap each invocation in a function statement and then call the function from
     * the top of the file.
     */
    class JestHoistTransformer extends Transformer_1.default {
        __init() { this.hoistedFunctionNames = []; }
        constructor(rootTransformer, tokens, nameManager, importProcessor) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.nameManager = nameManager;
            this.importProcessor = importProcessor;
            JestHoistTransformer.prototype.__init.call(this);
            ;
        }
        process() {
            if (this.tokens.currentToken().scopeDepth === 0 &&
                this.tokens.matches4(types_1.TokenType.name, types_1.TokenType.dot, types_1.TokenType.name, types_1.TokenType.parenL) &&
                this.tokens.identifierName() === JEST_GLOBAL_NAME) {
                // TODO: This only works if imports transform is active, which it will be for jest.
                //       But if jest adds module support and we no longer need the import transform, this needs fixing.
                if (_optionalChain([this, 'access', _ => _.importProcessor, 'optionalAccess', _2 => _2.getGlobalNames, 'call', _3 => _3(), 'optionalAccess', _4 => _4.has, 'call', _5 => _5(JEST_GLOBAL_NAME)])) {
                    return false;
                }
                return this.extractHoistedCalls();
            }
            return false;
        }
        getHoistedCode() {
            if (this.hoistedFunctionNames.length > 0) {
                // This will be placed before module interop code, but that's fine since
                // imports aren't allowed in module mock factories.
                return this.hoistedFunctionNames.map((name) => `${name}();`).join("");
            }
            return "";
        }
        /**
         * Extracts any methods calls on the jest-object that should be hoisted.
         *
         * According to the jest docs, https://jestjs.io/docs/en/jest-object#jestmockmodulename-factory-options,
         * mock, unmock, enableAutomock, disableAutomock, are the methods that should be hoisted.
         *
         * We do not apply the same checks of the arguments as babel-plugin-jest-hoist does.
         */
        extractHoistedCalls() {
            // We're handling a chain of calls where `jest` may or may not need to be inserted for each call
            // in the chain, so remove the initial `jest` to make the loop implementation cleaner.
            this.tokens.removeToken();
            // Track some state so that multiple non-hoisted chained calls in a row keep their chaining
            // syntax.
            let followsNonHoistedJestCall = false;
            // Iterate through all chained calls on the jest object.
            while (this.tokens.matches3(types_1.TokenType.dot, types_1.TokenType.name, types_1.TokenType.parenL)) {
                const methodName = this.tokens.identifierNameAtIndex(this.tokens.currentIndex() + 1);
                const shouldHoist = HOISTED_METHODS.includes(methodName);
                if (shouldHoist) {
                    // We've matched e.g. `.mock(...)` or similar call.
                    // Replace the initial `.` with `function __jestHoist(){jest.`
                    const hoistedFunctionName = this.nameManager.claimFreeName("__jestHoist");
                    this.hoistedFunctionNames.push(hoistedFunctionName);
                    this.tokens.replaceToken(`function ${hoistedFunctionName}(){${JEST_GLOBAL_NAME}.`);
                    this.tokens.copyToken();
                    this.tokens.copyToken();
                    this.rootTransformer.processBalancedCode();
                    this.tokens.copyExpectedToken(types_1.TokenType.parenR);
                    this.tokens.appendCode(";}");
                    followsNonHoistedJestCall = false;
                }
                else {
                    // This is a non-hoisted method, so just transform the code as usual.
                    if (followsNonHoistedJestCall) {
                        // If we didn't hoist the previous call, we can leave the code as-is to chain off of the
                        // previous method call. It's important to preserve the code here because we don't know
                        // for sure that the method actually returned the jest object for chaining.
                        this.tokens.copyToken();
                    }
                    else {
                        // If we hoisted the previous call, we know it returns the jest object back, so we insert
                        // the identifier `jest` to continue the chain.
                        this.tokens.replaceToken(`${JEST_GLOBAL_NAME}.`);
                    }
                    this.tokens.copyToken();
                    this.tokens.copyToken();
                    this.rootTransformer.processBalancedCode();
                    this.tokens.copyExpectedToken(types_1.TokenType.parenR);
                    followsNonHoistedJestCall = true;
                }
            }
            return true;
        }
    }
    exports.default = JestHoistTransformer;
},
"09e20c28d7": /* sucrase\dist\esm\transformers\NumericSeparatorTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class NumericSeparatorTransformer extends Transformer_1.default {
        constructor(tokens) {
            super();
            this.tokens = tokens;
            ;
        }
        process() {
            if (this.tokens.matches1(types_1.TokenType.num)) {
                const code = this.tokens.currentTokenCode();
                if (code.includes("_")) {
                    this.tokens.replaceToken(code.replace(/_/g, ""));
                    return true;
                }
            }
            return false;
        }
    }
    exports.default = NumericSeparatorTransformer;
},
"1dc037e3ca": /* sucrase\dist\esm\transformers\OptionalCatchBindingTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class OptionalCatchBindingTransformer extends Transformer_1.default {
        constructor(tokens, nameManager) {
            super();
            this.tokens = tokens;
            this.nameManager = nameManager;
            ;
        }
        process() {
            if (this.tokens.matches2(types_1.TokenType._catch, types_1.TokenType.braceL)) {
                this.tokens.copyToken();
                this.tokens.appendCode(` (${this.nameManager.claimFreeName("e")})`);
                return true;
            }
            return false;
        }
    }
    exports.default = OptionalCatchBindingTransformer;
},
"6995ead426": /* sucrase\dist\esm\transformers\OptionalChainingNullishTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    /**
     * Transformer supporting the optional chaining and nullish coalescing operators.
     *
     * Tech plan here:
     * https://github.com/alangpierce/sucrase/wiki/Sucrase-Optional-Chaining-and-Nullish-Coalescing-Technical-Plan
     *
     * The prefix and suffix code snippets are handled by TokenProcessor, and this transformer handles
     * the operators themselves.
     */
    class OptionalChainingNullishTransformer extends Transformer_1.default {
        constructor(tokens, nameManager) {
            super();
            this.tokens = tokens;
            this.nameManager = nameManager;
            ;
        }
        process() {
            if (this.tokens.matches1(types_1.TokenType.nullishCoalescing)) {
                const token = this.tokens.currentToken();
                if (this.tokens.tokens[token.nullishStartIndex].isAsyncOperation) {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(", async () => (");
                }
                else {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(", () => (");
                }
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._delete)) {
                const nextToken = this.tokens.tokenAtRelativeIndex(1);
                if (nextToken.isOptionalChainStart) {
                    this.tokens.removeInitialToken();
                    return true;
                }
            }
            const token = this.tokens.currentToken();
            const chainStart = token.subscriptStartIndex;
            if (chainStart != null &&
                this.tokens.tokens[chainStart].isOptionalChainStart &&
                // Super subscripts can't be optional (since super is never null/undefined), and the syntax
                // relies on the subscript being intact, so leave this token alone.
                this.tokens.tokenAtRelativeIndex(-1).type !== types_1.TokenType._super) {
                const param = this.nameManager.claimFreeName("_");
                let arrowStartSnippet;
                if (chainStart > 0 &&
                    this.tokens.matches1AtIndex(chainStart - 1, types_1.TokenType._delete) &&
                    this.isLastSubscriptInChain()) {
                    // Delete operations are special: we already removed the delete keyword, and to still
                    // perform a delete, we need to insert a delete in the very last part of the chain, which
                    // in correct code will always be a property access.
                    arrowStartSnippet = `${param} => delete ${param}`;
                }
                else {
                    arrowStartSnippet = `${param} => ${param}`;
                }
                if (this.tokens.tokens[chainStart].isAsyncOperation) {
                    arrowStartSnippet = `async ${arrowStartSnippet}`;
                }
                if (this.tokens.matches2(types_1.TokenType.questionDot, types_1.TokenType.parenL) ||
                    this.tokens.matches2(types_1.TokenType.questionDot, types_1.TokenType.lessThan)) {
                    if (this.justSkippedSuper()) {
                        this.tokens.appendCode(".bind(this)");
                    }
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalCall', ${arrowStartSnippet}`);
                }
                else if (this.tokens.matches2(types_1.TokenType.questionDot, types_1.TokenType.bracketL)) {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalAccess', ${arrowStartSnippet}`);
                }
                else if (this.tokens.matches1(types_1.TokenType.questionDot)) {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalAccess', ${arrowStartSnippet}.`);
                }
                else if (this.tokens.matches1(types_1.TokenType.dot)) {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'access', ${arrowStartSnippet}.`);
                }
                else if (this.tokens.matches1(types_1.TokenType.bracketL)) {
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'access', ${arrowStartSnippet}[`);
                }
                else if (this.tokens.matches1(types_1.TokenType.parenL)) {
                    if (this.justSkippedSuper()) {
                        this.tokens.appendCode(".bind(this)");
                    }
                    this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'call', ${arrowStartSnippet}(`);
                }
                else {
                    throw new Error("Unexpected subscript operator in optional chain.");
                }
                return true;
            }
            return false;
        }
        /**
         * Determine if the current token is the last of its chain, so that we know whether it's eligible
         * to have a delete op inserted.
         *
         * We can do this by walking forward until we determine one way or another. Each
         * isOptionalChainStart token must be paired with exactly one isOptionalChainEnd token after it in
         * a nesting way, so we can track depth and walk to the end of the chain (the point where the
         * depth goes negative) and see if any other subscript token is after us in the chain.
         */
        isLastSubscriptInChain() {
            let depth = 0;
            for (let i = this.tokens.currentIndex() + 1;; i++) {
                if (i >= this.tokens.tokens.length) {
                    throw new Error("Reached the end of the code while finding the end of the access chain.");
                }
                if (this.tokens.tokens[i].isOptionalChainStart) {
                    depth++;
                }
                else if (this.tokens.tokens[i].isOptionalChainEnd) {
                    depth--;
                }
                if (depth < 0) {
                    return true;
                }
                // This subscript token is a later one in the same chain.
                if (depth === 0 && this.tokens.tokens[i].subscriptStartIndex != null) {
                    return false;
                }
            }
        }
        /**
         * Determine if we are the open-paren in an expression like super.a()?.b.
         *
         * We can do this by walking backward to find the previous subscript. If that subscript was
         * preceded by a super, then we must be the subscript after it, so if this is a call expression,
         * we'll need to attach the right context.
         */
        justSkippedSuper() {
            let depth = 0;
            let index = this.tokens.currentIndex() - 1;
            while (true) {
                if (index < 0) {
                    throw new Error("Reached the start of the code while finding the start of the access chain.");
                }
                if (this.tokens.tokens[index].isOptionalChainStart) {
                    depth--;
                }
                else if (this.tokens.tokens[index].isOptionalChainEnd) {
                    depth++;
                }
                if (depth < 0) {
                    return false;
                }
                // This subscript token is a later one in the same chain.
                if (depth === 0 && this.tokens.tokens[index].subscriptStartIndex != null) {
                    return this.tokens.tokens[index - 1].type === types_1.TokenType._super;
                }
                index--;
            }
        }
    }
    exports.default = OptionalChainingNullishTransformer;
},
"9aad52e886": /* sucrase\dist\esm\transformers\ReactDisplayNameTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    /**
     * Implementation of babel-plugin-transform-react-display-name, which adds a
     * display name to usages of React.createClass and createReactClass.
     */
    class ReactDisplayNameTransformer extends Transformer_1.default {
        constructor(rootTransformer, tokens, importProcessor, options) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.importProcessor = importProcessor;
            this.options = options;
            ;
        }
        process() {
            const startIndex = this.tokens.currentIndex();
            if (this.tokens.identifierName() === "createReactClass") {
                const newName = this.importProcessor && this.importProcessor.getIdentifierReplacement("createReactClass");
                if (newName) {
                    this.tokens.replaceToken(`(0, ${newName})`);
                }
                else {
                    this.tokens.copyToken();
                }
                this.tryProcessCreateClassCall(startIndex);
                return true;
            }
            if (this.tokens.matches3(types_1.TokenType.name, types_1.TokenType.dot, types_1.TokenType.name) &&
                this.tokens.identifierName() === "React" &&
                this.tokens.identifierNameAtIndex(this.tokens.currentIndex() + 2) === "createClass") {
                const newName = this.importProcessor
                    ? this.importProcessor.getIdentifierReplacement("React") || "React"
                    : "React";
                if (newName) {
                    this.tokens.replaceToken(newName);
                    this.tokens.copyToken();
                    this.tokens.copyToken();
                }
                else {
                    this.tokens.copyToken();
                    this.tokens.copyToken();
                    this.tokens.copyToken();
                }
                this.tryProcessCreateClassCall(startIndex);
                return true;
            }
            return false;
        }
        /**
         * This is called with the token position at the open-paren.
         */
        tryProcessCreateClassCall(startIndex) {
            const displayName = this.findDisplayName(startIndex);
            if (!displayName) {
                return;
            }
            if (this.classNeedsDisplayName()) {
                this.tokens.copyExpectedToken(types_1.TokenType.parenL);
                this.tokens.copyExpectedToken(types_1.TokenType.braceL);
                this.tokens.appendCode(`displayName: '${displayName}',`);
                this.rootTransformer.processBalancedCode();
                this.tokens.copyExpectedToken(types_1.TokenType.braceR);
                this.tokens.copyExpectedToken(types_1.TokenType.parenR);
            }
        }
        findDisplayName(startIndex) {
            if (startIndex < 2) {
                return null;
            }
            if (this.tokens.matches2AtIndex(startIndex - 2, types_1.TokenType.name, types_1.TokenType.eq)) {
                // This is an assignment (or declaration) and the LHS is either an identifier or a member
                // expression ending in an identifier, so use that identifier name.
                return this.tokens.identifierNameAtIndex(startIndex - 2);
            }
            if (startIndex >= 2 &&
                this.tokens.tokens[startIndex - 2].identifierRole === tokenizer_1.IdentifierRole.ObjectKey) {
                // This is an object literal value.
                return this.tokens.identifierNameAtIndex(startIndex - 2);
            }
            if (this.tokens.matches2AtIndex(startIndex - 2, types_1.TokenType._export, types_1.TokenType._default)) {
                return this.getDisplayNameFromFilename();
            }
            return null;
        }
        getDisplayNameFromFilename() {
            const filePath = this.options.filePath || "unknown";
            const pathSegments = filePath.split("/");
            const filename = pathSegments[pathSegments.length - 1];
            const dotIndex = filename.lastIndexOf(".");
            const baseFilename = dotIndex === -1 ? filename : filename.slice(0, dotIndex);
            if (baseFilename === "index" && pathSegments[pathSegments.length - 2]) {
                return pathSegments[pathSegments.length - 2];
            }
            else {
                return baseFilename;
            }
        }
        /**
         * We only want to add a display name when this is a function call containing
         * one argument, which is an object literal without `displayName` as an
         * existing key.
         */
        classNeedsDisplayName() {
            let index = this.tokens.currentIndex();
            if (!this.tokens.matches2(types_1.TokenType.parenL, types_1.TokenType.braceL)) {
                return false;
            }
            // The block starts on the {, and we expect any displayName key to be in
            // that context. We need to ignore other other contexts to avoid matching
            // nested displayName keys.
            const objectStartIndex = index + 1;
            const objectContextId = this.tokens.tokens[objectStartIndex].contextId;
            if (objectContextId == null) {
                throw new Error("Expected non-null context ID on object open-brace.");
            }
            for (; index < this.tokens.tokens.length; index++) {
                const token = this.tokens.tokens[index];
                if (token.type === types_1.TokenType.braceR && token.contextId === objectContextId) {
                    index++;
                    break;
                }
                if (this.tokens.identifierNameAtIndex(index) === "displayName" &&
                    this.tokens.tokens[index].identifierRole === tokenizer_1.IdentifierRole.ObjectKey &&
                    token.contextId === objectContextId) {
                    // We found a displayName key, so bail out.
                    return false;
                }
            }
            if (index === this.tokens.tokens.length) {
                throw new Error("Unexpected end of input when processing React class.");
            }
            // If we got this far, we know we have createClass with an object with no
            // display name, so we want to proceed as long as that was the only argument.
            return (this.tokens.matches1AtIndex(index, types_1.TokenType.parenR) ||
                this.tokens.matches2AtIndex(index, types_1.TokenType.comma, types_1.TokenType.parenR));
        }
    }
    exports.default = ReactDisplayNameTransformer;
},
"c3f855a290": /* sucrase\dist\esm\transformers\ReactHotLoaderTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const tokenizer_1 = require("bfb18d0576") /* ../parser/tokenizer */;
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class ReactHotLoaderTransformer extends Transformer_1.default {
        __init() { this.extractedDefaultExportName = null; }
        constructor(tokens, filePath) {
            super();
            this.tokens = tokens;
            this.filePath = filePath;
            ReactHotLoaderTransformer.prototype.__init.call(this);
            ;
        }
        setExtractedDefaultExportName(extractedDefaultExportName) {
            this.extractedDefaultExportName = extractedDefaultExportName;
        }
        getPrefixCode() {
            return `
      (function () {
        var enterModule = require('react-hot-loader').enterModule;
        enterModule && enterModule(module);
      })();`
                .replace(/\s+/g, " ")
                .trim();
        }
        getSuffixCode() {
            const topLevelNames = new Set();
            for (const token of this.tokens.tokens) {
                if (!token.isType &&
                    (0, tokenizer_1.isTopLevelDeclaration)(token) &&
                    token.identifierRole !== tokenizer_1.IdentifierRole.ImportDeclaration) {
                    topLevelNames.add(this.tokens.identifierNameForToken(token));
                }
            }
            const namesToRegister = Array.from(topLevelNames).map((name) => ({
                variableName: name,
                uniqueLocalName: name,
            }));
            if (this.extractedDefaultExportName) {
                namesToRegister.push({
                    variableName: this.extractedDefaultExportName,
                    uniqueLocalName: "default",
                });
            }
            return `
;(function () {
  var reactHotLoader = require('react-hot-loader').default;
  var leaveModule = require('react-hot-loader').leaveModule;
  if (!reactHotLoader) {
    return;
  }
${namesToRegister
                .map(({ variableName, uniqueLocalName }) => `  reactHotLoader.register(${variableName}, "${uniqueLocalName}", ${JSON.stringify(this.filePath || "")});`)
                .join("\n")}
  leaveModule(module);
})();`;
        }
        process() {
            return false;
        }
    }
    exports.default = ReactHotLoaderTransformer;
},
"581b1c506a": /* sucrase\dist\esm\transformers\TypeScriptTransformer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const isIdentifier_1 = tslib_1.__importDefault(require("5e8df41f33") /* ../util/isIdentifier */);
    const Transformer_1 = tslib_1.__importDefault(require("a46f119f74") /* ./Transformer */);
    class TypeScriptTransformer extends Transformer_1.default {
        constructor(rootTransformer, tokens, isImportsTransformEnabled) {
            super();
            this.rootTransformer = rootTransformer;
            this.tokens = tokens;
            this.isImportsTransformEnabled = isImportsTransformEnabled;
            ;
        }
        process() {
            if (this.rootTransformer.processPossibleArrowParamEnd() ||
                this.rootTransformer.processPossibleAsyncArrowWithTypeParams() ||
                this.rootTransformer.processPossibleTypeRange()) {
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._public) ||
                this.tokens.matches1(types_1.TokenType._protected) ||
                this.tokens.matches1(types_1.TokenType._private) ||
                this.tokens.matches1(types_1.TokenType._abstract) ||
                this.tokens.matches1(types_1.TokenType._readonly) ||
                this.tokens.matches1(types_1.TokenType._override) ||
                this.tokens.matches1(types_1.TokenType.nonNullAssertion)) {
                this.tokens.removeInitialToken();
                return true;
            }
            if (this.tokens.matches1(types_1.TokenType._enum) || this.tokens.matches2(types_1.TokenType._const, types_1.TokenType._enum)) {
                this.processEnum();
                return true;
            }
            if (this.tokens.matches2(types_1.TokenType._export, types_1.TokenType._enum) ||
                this.tokens.matches3(types_1.TokenType._export, types_1.TokenType._const, types_1.TokenType._enum)) {
                this.processEnum(true);
                return true;
            }
            return false;
        }
        processEnum(isExport = false) {
            // We might have "export const enum", so just remove all relevant tokens.
            this.tokens.removeInitialToken();
            while (this.tokens.matches1(types_1.TokenType._const) || this.tokens.matches1(types_1.TokenType._enum)) {
                this.tokens.removeToken();
            }
            const enumName = this.tokens.identifierName();
            this.tokens.removeToken();
            if (isExport && !this.isImportsTransformEnabled) {
                this.tokens.appendCode("export ");
            }
            this.tokens.appendCode(`var ${enumName}; (function (${enumName})`);
            this.tokens.copyExpectedToken(types_1.TokenType.braceL);
            this.processEnumBody(enumName);
            this.tokens.copyExpectedToken(types_1.TokenType.braceR);
            if (isExport && this.isImportsTransformEnabled) {
                this.tokens.appendCode(`)(${enumName} || (exports.${enumName} = ${enumName} = {}));`);
            }
            else {
                this.tokens.appendCode(`)(${enumName} || (${enumName} = {}));`);
            }
        }
        /**
         * Transform an enum into equivalent JS. This has complexity in a few places:
         * - TS allows string enums, numeric enums, and a mix of the two styles within an enum.
         * - Enum keys are allowed to be referenced in later enum values.
         * - Enum keys are allowed to be strings.
         * - When enum values are omitted, they should follow an auto-increment behavior.
         */
        processEnumBody(enumName) {
            // Code that can be used to reference the previous enum member, or null if this is the first
            // enum member.
            let previousValueCode = null;
            while (true) {
                if (this.tokens.matches1(types_1.TokenType.braceR)) {
                    break;
                }
                const { nameStringCode, variableName } = this.extractEnumKeyInfo(this.tokens.currentToken());
                this.tokens.removeInitialToken();
                if (this.tokens.matches3(types_1.TokenType.eq, types_1.TokenType.string, types_1.TokenType.comma) ||
                    this.tokens.matches3(types_1.TokenType.eq, types_1.TokenType.string, types_1.TokenType.braceR)) {
                    this.processStringLiteralEnumMember(enumName, nameStringCode, variableName);
                }
                else if (this.tokens.matches1(types_1.TokenType.eq)) {
                    this.processExplicitValueEnumMember(enumName, nameStringCode, variableName);
                }
                else {
                    this.processImplicitValueEnumMember(enumName, nameStringCode, variableName, previousValueCode);
                }
                if (this.tokens.matches1(types_1.TokenType.comma)) {
                    this.tokens.removeToken();
                }
                if (variableName != null) {
                    previousValueCode = variableName;
                }
                else {
                    previousValueCode = `${enumName}[${nameStringCode}]`;
                }
            }
        }
        /**
         * Detect name information about this enum key, which will be used to determine which code to emit
         * and whether we should declare a variable as part of this declaration.
         *
         * Some cases to keep in mind:
         * - Enum keys can be implicitly referenced later, e.g. `X = 1, Y = X`. In Sucrase, we implement
         *   this by declaring a variable `X` so that later expressions can use it.
         * - In addition to the usual identifier key syntax, enum keys are allowed to be string literals,
         *   e.g. `"hello world" = 3,`. Template literal syntax is NOT allowed.
         * - Even if the enum key is defined as a string literal, it may still be referenced by identifier
         *   later, e.g. `"X" = 1, Y = X`. That means that we need to detect whether or not a string
         *   literal is identifier-like and emit a variable if so, even if the declaration did not use an
         *   identifier.
         * - Reserved keywords like `break` are valid enum keys, but are not valid to be referenced later
         *   and would be a syntax error if we emitted a variable, so we need to skip the variable
         *   declaration in those cases.
         *
         * The variableName return value captures these nuances: if non-null, we can and must emit a
         * variable declaration, and if null, we can't and shouldn't.
         */
        extractEnumKeyInfo(nameToken) {
            if (nameToken.type === types_1.TokenType.name) {
                const name = this.tokens.identifierNameForToken(nameToken);
                return {
                    nameStringCode: `"${name}"`,
                    variableName: (0, isIdentifier_1.default)(name) ? name : null,
                };
            }
            else if (nameToken.type === types_1.TokenType.string) {
                const name = this.tokens.stringValueForToken(nameToken);
                return {
                    nameStringCode: this.tokens.code.slice(nameToken.start, nameToken.end),
                    variableName: (0, isIdentifier_1.default)(name) ? name : null,
                };
            }
            else {
                throw new Error("Expected name or string at beginning of enum element.");
            }
        }
        /**
         * Handle an enum member where the RHS is just a string literal (not omitted, not a number, and
         * not a complex expression). This is the typical form for TS string enums, and in this case, we
         * do *not* create a reverse mapping.
         *
         * This is called after deleting the key token, when the token processor is at the equals sign.
         *
         * Example 1:
         * someKey = "some value"
         * ->
         * const someKey = "some value"; MyEnum["someKey"] = someKey;
         *
         * Example 2:
         * "some key" = "some value"
         * ->
         * MyEnum["some key"] = "some value";
         */
        processStringLiteralEnumMember(enumName, nameStringCode, variableName) {
            if (variableName != null) {
                this.tokens.appendCode(`const ${variableName}`);
                // =
                this.tokens.copyToken();
                // value string
                this.tokens.copyToken();
                this.tokens.appendCode(`; ${enumName}[${nameStringCode}] = ${variableName};`);
            }
            else {
                this.tokens.appendCode(`${enumName}[${nameStringCode}]`);
                // =
                this.tokens.copyToken();
                // value string
                this.tokens.copyToken();
                this.tokens.appendCode(";");
            }
        }
        /**
         * Handle an enum member initialized with an expression on the right-hand side (other than a
         * string literal). In these cases, we should transform the expression and emit code that sets up
         * a reverse mapping.
         *
         * The TypeScript implementation of this operation distinguishes between expressions that can be
         * "constant folded" at compile time (i.e. consist of number literals and simple math operations
         * on those numbers) and ones that are dynamic. For constant expressions, it emits the resolved
         * numeric value, and auto-incrementing is only allowed in that case. Evaluating expressions at
         * compile time would add significant complexity to Sucrase, so Sucrase instead leaves the
         * expression as-is, and will later emit something like `MyEnum["previousKey"] + 1` to implement
         * auto-incrementing.
         *
         * This is called after deleting the key token, when the token processor is at the equals sign.
         *
         * Example 1:
         * someKey = 1 + 1
         * ->
         * const someKey = 1 + 1; MyEnum[MyEnum["someKey"] = someKey] = "someKey";
         *
         * Example 2:
         * "some key" = 1 + 1
         * ->
         * MyEnum[MyEnum["some key"] = 1 + 1] = "some key";
         */
        processExplicitValueEnumMember(enumName, nameStringCode, variableName) {
            const rhsEndIndex = this.tokens.currentToken().rhsEndIndex;
            if (rhsEndIndex == null) {
                throw new Error("Expected rhsEndIndex on enum assign.");
            }
            if (variableName != null) {
                this.tokens.appendCode(`const ${variableName}`);
                this.tokens.copyToken();
                while (this.tokens.currentIndex() < rhsEndIndex) {
                    this.rootTransformer.processToken();
                }
                this.tokens.appendCode(`; ${enumName}[${enumName}[${nameStringCode}] = ${variableName}] = ${nameStringCode};`);
            }
            else {
                this.tokens.appendCode(`${enumName}[${enumName}[${nameStringCode}]`);
                this.tokens.copyToken();
                while (this.tokens.currentIndex() < rhsEndIndex) {
                    this.rootTransformer.processToken();
                }
                this.tokens.appendCode(`] = ${nameStringCode};`);
            }
        }
        /**
         * Handle an enum member with no right-hand side expression. In this case, the value is the
         * previous value plus 1, or 0 if there was no previous value. We should also always emit a
         * reverse mapping.
         *
         * Example 1:
         * someKey2
         * ->
         * const someKey2 = someKey1 + 1; MyEnum[MyEnum["someKey2"] = someKey2] = "someKey2";
         *
         * Example 2:
         * "some key 2"
         * ->
         * MyEnum[MyEnum["some key 2"] = someKey1 + 1] = "some key 2";
         */
        processImplicitValueEnumMember(enumName, nameStringCode, variableName, previousValueCode) {
            let valueCode = previousValueCode != null ? `${previousValueCode} + 1` : "0";
            if (variableName != null) {
                this.tokens.appendCode(`const ${variableName} = ${valueCode}; `);
                valueCode = variableName;
            }
            this.tokens.appendCode(`${enumName}[${enumName}[${nameStringCode}] = ${valueCode}] = ${nameStringCode};`);
        }
    }
    exports.default = TypeScriptTransformer;
},
"5e8df41f33": /* sucrase\dist\esm\util\isIdentifier.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = isIdentifier;
    const identifier_1 = require("364148c9f0") /* ../parser/util/identifier */;
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar
    // Hard-code a list of reserved words rather than trying to use keywords or contextual keywords
    // from the parser, since currently there are various exceptions, like `package` being reserved
    // but unused and various contextual keywords being reserved. Note that we assume that all code
    // compiled by Sucrase is in a module, so strict mode words and await are all considered reserved
    // here.
    const RESERVED_WORDS = new Set([
        // Reserved keywords as of ECMAScript 2015
        "break",
        "case",
        "catch",
        "class",
        "const",
        "continue",
        "debugger",
        "default",
        "delete",
        "do",
        "else",
        "export",
        "extends",
        "finally",
        "for",
        "function",
        "if",
        "import",
        "in",
        "instanceof",
        "new",
        "return",
        "super",
        "switch",
        "this",
        "throw",
        "try",
        "typeof",
        "var",
        "void",
        "while",
        "with",
        "yield",
        // Future reserved keywords
        "enum",
        "implements",
        "interface",
        "let",
        "package",
        "private",
        "protected",
        "public",
        "static",
        "await",
        // Literals that cannot be used as identifiers
        "false",
        "null",
        "true",
    ]);
    /**
     * Determine if the given name is a legal variable name.
     *
     * This is needed when transforming TypeScript enums; if an enum key is a valid
     * variable name, it might be referenced later in the enum, so we need to
     * declare a variable.
     */
    function isIdentifier(name) {
        if (name.length === 0) {
            return false;
        }
        if (!identifier_1.IS_IDENTIFIER_START[name.charCodeAt(0)]) {
            return false;
        }
        for (let i = 1; i < name.length; i++) {
            if (!identifier_1.IS_IDENTIFIER_CHAR[name.charCodeAt(i)]) {
                return false;
            }
        }
        return !RESERVED_WORDS.has(name);
    }
},
"2e6a9a5b28": /* sucrase\dist\esm\util\formatTokens.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = formatTokens;
    const tslib_1 = require("tslib");
    const lines_and_columns_1 = tslib_1.__importDefault(require("d2035ed1c8") /* lines-and-columns */);
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    function formatTokens(code, tokens) {
        if (tokens.length === 0) {
            return "";
        }
        const tokenKeys = Object.keys(tokens[0]).filter((k) => k !== "type" && k !== "value" && k !== "start" && k !== "end" && k !== "loc");
        const typeKeys = Object.keys(tokens[0].type).filter((k) => k !== "label" && k !== "keyword");
        const headings = ["Location", "Label", "Raw", ...tokenKeys, ...typeKeys];
        const lines = new lines_and_columns_1.default(code);
        const rows = [headings, ...tokens.map(getTokenComponents)];
        const padding = headings.map(() => 0);
        for (const components of rows) {
            for (let i = 0; i < components.length; i++) {
                padding[i] = Math.max(padding[i], components[i].length);
            }
        }
        return rows
            .map((components) => components.map((component, i) => component.padEnd(padding[i])).join(" "))
            .join("\n");
        function getTokenComponents(token) {
            const raw = code.slice(token.start, token.end);
            return [
                formatRange(token.start, token.end),
                (0, types_1.formatTokenType)(token.type),
                truncate(String(raw), 14),
                // @ts-ignore: Intentional dynamic access by key.
                ...tokenKeys.map((key) => formatValue(token[key], key)),
                // @ts-ignore: Intentional dynamic access by key.
                ...typeKeys.map((key) => formatValue(token.type[key], key)),
            ];
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        function formatValue(value, key) {
            if (value === true) {
                return key;
            }
            else if (value === false || value === null) {
                return "";
            }
            else {
                return String(value);
            }
        }
        function formatRange(start, end) {
            return `${formatPos(start)}-${formatPos(end)}`;
        }
        function formatPos(pos) {
            const location = lines.locationForIndex(pos);
            if (!location) {
                return "Unknown";
            }
            else {
                return `${location.line + 1}:${location.column + 1}`;
            }
        }
    }
    function truncate(s, length) {
        if (s.length > length) {
            return `${s.slice(0, length - 3)}...`;
        }
        else {
            return s;
        }
    }
},
"d2035ed1c8": /* lines-and-columns\build\index.js */ function _(require, module, exports, __esModule, __esExport) {
    exports.__esModule = true;
    var LF = '\n';
    var CR = '\r';
    var LinesAndColumns = /** @class */ (function () {
        function LinesAndColumns(string) {
            this.string = string;
            var offsets = [0];
            for (var offset = 0; offset < string.length;) {
                switch (string[offset]) {
                    case LF:
                        offset += LF.length;
                        offsets.push(offset);
                        break;
                    case CR:
                        offset += CR.length;
                        if (string[offset] === LF) {
                            offset += LF.length;
                        }
                        offsets.push(offset);
                        break;
                    default:
                        offset++;
                        break;
                }
            }
            this.offsets = offsets;
        }
        LinesAndColumns.prototype.locationForIndex = function (index) {
            if (index < 0 || index > this.string.length) {
                return null;
            }
            var line = 0;
            var offsets = this.offsets;
            while (offsets[line + 1] <= index) {
                line++;
            }
            var column = index - offsets[line];
            return { line: line, column: column };
        };
        LinesAndColumns.prototype.indexForLocation = function (location) {
            var line = location.line, column = location.column;
            if (line < 0 || line >= this.offsets.length) {
                return null;
            }
            if (column < 0 || column > this.lengthOfLine(line)) {
                return null;
            }
            return this.offsets[line] + column;
        };
        LinesAndColumns.prototype.lengthOfLine = function (line) {
            var offset = this.offsets[line];
            var nextOffset = line === this.offsets.length - 1
                ? this.string.length
                : this.offsets[line + 1];
            return nextOffset - offset;
        };
        return LinesAndColumns;
    }());
    exports.LinesAndColumns = LinesAndColumns;
    exports["default"] = LinesAndColumns;
},
"4160f5108d": /* sucrase\dist\esm\util\getTSImportedNames.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = getTSImportedNames;
    const tslib_1 = require("tslib");
    const types_1 = require("f0c35cbd76") /* ../parser/tokenizer/types */;
    const getImportExportSpecifierInfo_1 = tslib_1.__importDefault(require("14d4ae78a4") /* ./getImportExportSpecifierInfo */);
    /**
     * Special case code to scan for imported names in ESM TypeScript. We need to do this so we can
     * properly get globals so we can compute shadowed globals.
     *
     * This is similar to logic in CJSImportProcessor, but trimmed down to avoid logic with CJS
     * replacement and flow type imports.
     */
    function getTSImportedNames(tokens) {
        const importedNames = new Set();
        for (let i = 0; i < tokens.tokens.length; i++) {
            if (tokens.matches1AtIndex(i, types_1.TokenType._import) &&
                !tokens.matches3AtIndex(i, types_1.TokenType._import, types_1.TokenType.name, types_1.TokenType.eq)) {
                collectNamesForImport(tokens, i, importedNames);
            }
        }
        return importedNames;
    }
    function collectNamesForImport(tokens, index, importedNames) {
        index++;
        if (tokens.matches1AtIndex(index, types_1.TokenType.parenL)) {
            // Dynamic import, so nothing to do
            return;
        }
        if (tokens.matches1AtIndex(index, types_1.TokenType.name)) {
            importedNames.add(tokens.identifierNameAtIndex(index));
            index++;
            if (tokens.matches1AtIndex(index, types_1.TokenType.comma)) {
                index++;
            }
        }
        if (tokens.matches1AtIndex(index, types_1.TokenType.star)) {
            // * as
            index += 2;
            importedNames.add(tokens.identifierNameAtIndex(index));
            index++;
        }
        if (tokens.matches1AtIndex(index, types_1.TokenType.braceL)) {
            index++;
            collectNamesForNamedImport(tokens, index, importedNames);
        }
    }
    function collectNamesForNamedImport(tokens, index, importedNames) {
        while (true) {
            if (tokens.matches1AtIndex(index, types_1.TokenType.braceR)) {
                return;
            }
            const specifierInfo = (0, getImportExportSpecifierInfo_1.default)(tokens, index);
            index = specifierInfo.endIndex;
            if (!specifierInfo.isType) {
                importedNames.add(specifierInfo.rightName);
            }
            if (tokens.matches2AtIndex(index, types_1.TokenType.comma, types_1.TokenType.braceR)) {
                return;
            }
            else if (tokens.matches1AtIndex(index, types_1.TokenType.braceR)) {
                return;
            }
            else if (tokens.matches1AtIndex(index, types_1.TokenType.comma)) {
                index++;
            }
            else {
                throw new Error(`Unexpected token: ${JSON.stringify(tokens.tokens[index])}`);
            }
        }
    }
},
"a572dba9cd": /* models\event-to-object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.serializeEvent = serializeEvent;
    /*
    The MIT License (MIT)
    
    Copyright (c) 2019 Ryan S. Morshead
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
    */
    function serializeEvent(event) {
        const data = {};
        // support for CustomEvents: the whole `detail` object is serialized
        if (event.detail !== undefined) {
            Object.assign(data, { detail: JSON.parse(JSON.stringify(event.detail)) });
        }
        if (event.type in eventTransforms) {
            Object.assign(data, eventTransforms[event.type](event));
        }
        data.target = serializeDomElement(event.target);
        data.currentTarget =
            event.target === event.currentTarget
                ? data.target
                : serializeDomElement(event.currentTarget);
        data.relatedTarget = serializeDomElement(event.relatedTarget);
        return data;
    }
    function serializeDomElement(element) {
        let elementData = null;
        if (element) {
            elementData = defaultElementTransform(element);
            if (element.tagName in elementTransforms) {
                elementTransforms[element.tagName].forEach((trans) => Object.assign(elementData, trans(element)));
            }
        }
        return elementData;
    }
    const elementTransformCategories = {
        hasValue: (element) => ({
            value: element.value,
        }),
        hasCurrentTime: (element) => ({
            currentTime: element.currentTime,
        }),
        hasFiles: (element) => {
            if (element.type === "file") {
                return {
                    files: [...element.files ?? []].map((file) => ({
                        lastModified: file.lastModified,
                        name: file.name,
                        size: file.size,
                        type: file.type,
                    })),
                };
            }
            else {
                return {};
            }
        },
    };
    function defaultElementTransform(element) {
        try {
            return { boundingClientRect: { ...element.getBoundingClientRect() } };
        }
        catch {
            return {};
        }
    }
    const elementTagCategories = {
        hasValue: [
            "BUTTON",
            "INPUT",
            "OPTION",
            "LI",
            "METER",
            "PROGRESS",
            "PARAM",
            "SELECT",
            "TEXTAREA",
        ],
        hasCurrentTime: ["AUDIO", "VIDEO"],
        hasFiles: ["INPUT"],
    };
    const elementTransforms = {};
    Object.keys(elementTagCategories).forEach((category) => {
        elementTagCategories[category].forEach((type) => {
            const transforms = elementTransforms[type] || (elementTransforms[type] = []);
            transforms.push(elementTransformCategories[category]);
        });
    });
    class EventTransformCategories {
        clipboard(event) {
            return {
                clipboardData: event.clipboardData,
            };
        }
        composition(event) {
            return {
                data: event.data,
            };
        }
        keyboard(event) {
            return {
                altKey: event.altKey,
                charCode: event.charCode,
                ctrlKey: event.ctrlKey,
                key: event.key,
                keyCode: event.keyCode,
                locale: event.locale,
                location: event.location,
                metaKey: event.metaKey,
                repeat: event.repeat,
                shiftKey: event.shiftKey,
                which: event.which,
            };
        }
        mouse(event) {
            return {
                altKey: event.altKey,
                button: event.button,
                buttons: event.buttons,
                clientX: event.clientX,
                clientY: event.clientY,
                ctrlKey: event.ctrlKey,
                metaKey: event.metaKey,
                pageX: event.pageX,
                pageY: event.pageY,
                screenX: event.screenX,
                screenY: event.screenY,
                shiftKey: event.shiftKey,
            };
        }
        pointer(event) {
            return {
                ...this.mouse(event),
                pointerId: event.pointerId,
                width: event.width,
                height: event.height,
                pressure: event.pressure,
                tiltX: event.tiltX,
                tiltY: event.tiltY,
                pointerType: event.pointerType,
                isPrimary: event.isPrimary,
            };
        }
        selection() {
            return {
                selectedText: window.getSelection().toString(),
            };
        }
        ;
        touch(event) {
            return {
                altKey: event.altKey,
                ctrlKey: event.ctrlKey,
                metaKey: event.metaKey,
                shiftKey: event.shiftKey,
            };
        }
        ui(event) {
            return {
                detail: event.detail,
            };
        }
        wheel(event) {
            return {
                deltaMode: event.deltaMode,
                deltaX: event.deltaX,
                deltaY: event.deltaY,
                deltaZ: event.deltaZ,
            };
        }
        animation(event) {
            return {
                animationName: event.animationName,
                pseudoElement: event.pseudoElement,
                elapsedTime: event.elapsedTime,
            };
        }
        transition(event) {
            return {
                propertyName: event.propertyName,
                pseudoElement: event.pseudoElement,
                elapsedTime: event.elapsedTime,
            };
        }
    }
    EventTransformCategories.__name__ = "EventTransformCategories";
    const eventTypeCategories = {
        clipboard: ["copy", "cut", "paste"],
        composition: ["compositionend", "compositionstart", "compositionupdate"],
        keyboard: ["keydown", "keypress", "keyup"],
        mouse: [
            "click",
            "contextmenu",
            "doubleclick",
            "drag",
            "dragend",
            "dragenter",
            "dragexit",
            "dragleave",
            "dragover",
            "dragstart",
            "drop",
            "mousedown",
            "mouseenter",
            "mouseleave",
            "mousemove",
            "mouseout",
            "mouseover",
            "mouseup",
        ],
        pointer: [
            "pointerdown",
            "pointermove",
            "pointerup",
            "pointercancel",
            "gotpointercapture",
            "lostpointercapture",
            "pointerenter",
            "pointerleave",
            "pointerover",
            "pointerout",
        ],
        selection: ["select"],
        touch: ["touchcancel", "touchend", "touchmove", "touchstart"],
        ui: ["scroll"],
        wheel: ["wheel"],
        animation: ["animationstart", "animationend", "animationiteration"],
        transition: ["transitionend"],
    };
    const eventTransforms = {};
    const eventTransformCategories = new EventTransformCategories();
    Object.keys(eventTypeCategories).forEach((category) => {
        eventTypeCategories[category].forEach((type) => {
            // Bind the method to the eventTransformCategories instance to ensure correct 'this'
            eventTransforms[type] = eventTransformCategories[category].bind(eventTransformCategories);
        });
    });
},
"4c04683fdc": /* models\html.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c;
    __esModule();
    exports.html_decode = html_decode;
    exports.run_scripts = run_scripts;
    const tslib_1 = require("tslib");
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var HTMLStreamEvent_1;
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    const object_1 = require("@bokehjs/core/util/object");
    const markup_1 = require("@bokehjs/models/widgets/markup");
    const layout_1 = require("9b11ce01a3") /* ./layout */;
    const event_to_object_1 = require("a572dba9cd") /* ./event-to-object */;
    const util_1 = require("6ae1cb3800") /* ./util */;
    const html_css_1 = tslib_1.__importDefault(require("8694ed3f61") /* ../styles/models/html.css */);
    const COPY_ICON = `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"  fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-clipboard"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" /><path d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z"/></svg>`;
    const CHECK_ICON = `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"  fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-check"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10"/></svg>`;
    function searchAllDOMs(node, selector) {
        let found = [];
        if (node instanceof Element && node.matches(selector)) {
            found.push(node);
        }
        node.children && Array.from(node.children).forEach(child => {
            found = found.concat(searchAllDOMs(child, selector));
        });
        if (node instanceof Element && node.shadowRoot) {
            found = found.concat(searchAllDOMs(node.shadowRoot, selector));
        }
        return found;
    }
    let HTMLStreamEvent = (_a = class HTMLStreamEvent extends bokeh_events_1.ModelEvent {
        constructor(model, patch, start) {
            super();
            this.model = model;
            this.patch = patch;
            this.start = start;
            this.patch = patch;
            this.start = start;
            this.origin = model;
        }
        get event_values() {
            return { model: this.origin, patch: this.patch, start: this.start };
        }
        static from_values(values) {
            const { model, patch, start } = values;
            return new HTMLStreamEvent_1(model, patch, start);
        }
    },
        (() => {
            HTMLStreamEvent_1 = _a;
        })(),
        _a.__name__ = "HTMLStreamEvent",
        _a);
    exports.HTMLStreamEvent = HTMLStreamEvent;
    exports.HTMLStreamEvent = HTMLStreamEvent = HTMLStreamEvent_1 = __decorate([
        (0, bokeh_events_1.server_event)("html_stream")
    ], HTMLStreamEvent);
    class DOMEvent extends bokeh_events_1.ModelEvent {
        constructor(node, data) {
            super();
            this.node = node;
            this.data = data;
        }
        get event_values() {
            return { model: this.origin, node: this.node, data: this.data };
        }
    }
    exports.DOMEvent = DOMEvent;
    _b = DOMEvent;
    DOMEvent.__name__ = "DOMEvent";
    (() => {
        _b.prototype.event_name = "dom_event";
    })();
    function html_decode(input) {
        const doc = new DOMParser().parseFromString(input, "text/html");
        return doc.documentElement.textContent;
    }
    function run_scripts(node) {
        for (const old_script of node.querySelectorAll("script")) {
            const new_script = document.createElement("script");
            for (const attr of old_script.attributes) {
                new_script.setAttribute(attr.name, attr.value);
            }
            new_script.append(document.createTextNode(old_script.innerHTML));
            const parent_node = old_script.parentNode;
            if (parent_node != null) {
                parent_node.replaceChild(new_script, old_script);
            }
        }
    }
    class HTMLView extends layout_1.PanelMarkupView {
        constructor() {
            super(...arguments);
            this._buffer = null;
            this._event_listeners = new Map();
        }
        connect_signals() {
            super.connect_signals();
            const { text, visible, events } = this.model.properties;
            this.on_change(text, () => {
                this._buffer = null;
                const html = this.process_tex();
                this.set_html(html);
            });
            this.on_change(visible, () => {
                if (this.model.visible) {
                    this.container.style.visibility = "visible";
                }
            });
            this.on_change(events, () => {
                this._remove_event_listeners();
                this._setup_event_listeners();
            });
            const set_text = (0, util_1.throttle)(() => {
                const text = this._buffer;
                this._buffer = null;
                this.model.setv({ text }, { silent: true });
                const html = this.process_tex();
                this.set_html(html);
            }, 10);
            this.model.on_event(HTMLStreamEvent, (event) => {
                const beginning = this._buffer == null ? this.model.text : this._buffer;
                this._buffer = beginning.slice(0, event.start) + event.patch;
                set_text();
            });
        }
        stylesheets() {
            return [...super.stylesheets(), html_css_1.default];
        }
        set_html(html) {
            if (html === null || this.container == null) {
                return;
            }
            this.container.innerHTML = html;
            if (this.model.run_scripts) {
                run_scripts(this.container);
            }
            this._setup_event_listeners();
            for (const codeblock of this.container.querySelectorAll(".codehilite")) {
                const copy_button = document.createElement("button");
                const pre = codeblock.children[0];
                copy_button.className = "copybtn";
                copy_button.innerHTML = COPY_ICON;
                copy_button.addEventListener("click", () => {
                    const code = pre.innerText;
                    navigator.clipboard.writeText(code).then(() => {
                        copy_button.innerHTML = CHECK_ICON;
                        setTimeout(() => {
                            copy_button.innerHTML = COPY_ICON;
                        }, 300);
                    });
                });
                codeblock.insertBefore(copy_button, pre);
            }
            for (const anchor of this.container.querySelectorAll("a")) {
                const link = anchor.getAttribute("href");
                if (link && link.startsWith("#")) {
                    anchor.addEventListener("click", () => {
                        const found = searchAllDOMs(document.body, link);
                        if ((found.length > 0) && found[0] instanceof Element) {
                            found[0].scrollIntoView();
                        }
                    });
                    if (!this.root.has_finished() && this.model.document && window.location.hash === link) {
                        this.model.document.on_event("document_ready", () => {
                            anchor.scrollIntoView();
                            setTimeout(() => anchor.scrollIntoView(), 5);
                        });
                    }
                }
            }
        }
        render() {
            super.render();
            this.container.style.visibility = "hidden";
            this.shadow_el.appendChild(this.container);
            if (this.provider.status == "failed" || this.provider.status == "loaded") {
                this._has_finished = true;
            }
            const html = this.process_tex();
            this.watch_stylesheets();
            this.set_html(html);
        }
        style_redraw() {
            if (this.model.visible) {
                this.container.style.visibility = "visible";
            }
        }
        process_tex() {
            const decoded = html_decode(this.model.text);
            const text = decoded ?? this.model.text;
            if (this.model.disable_math || !this.contains_tex(text)) {
                return text;
            }
            const tex_parts = this.provider.MathJax.find_tex(text);
            const processed_text = [];
            let last_index = 0;
            for (const part of tex_parts) {
                processed_text.push(text.slice(last_index, part.start.n));
                processed_text.push(this.provider.MathJax.tex2svg(part.math, { display: part.display }).outerHTML);
                last_index = part.end.n;
            }
            if (last_index < text.length) {
                processed_text.push(text.slice(last_index));
            }
            return processed_text.join("");
        }
        contains_tex(html) {
            if (!this.provider.MathJax) {
                return false;
            }
            return this.provider.MathJax.find_tex(html).length > 0;
        }
        _remove_event_listeners() {
            for (const [node, callbacks] of this._event_listeners) {
                const el = document.getElementById(node);
                if (el == null) {
                    console.warn(`DOM node '${node}' could not be found. Cannot subscribe to DOM events.`);
                    continue;
                }
                for (const [event_name, event_callback] of callbacks) {
                    el.removeEventListener(event_name, event_callback);
                }
            }
            this._event_listeners.clear();
        }
        _setup_event_listeners() {
            for (const [node, event_names] of (0, object_1.entries)(this.model.events)) {
                const el = document.getElementById(node);
                if (el == null) {
                    console.warn(`DOM node '${node}' could not be found. Cannot subscribe to DOM events.`);
                    continue;
                }
                for (const event_name of event_names) {
                    const callback = (event) => {
                        this.model.trigger_event(new DOMEvent(node, (0, event_to_object_1.serializeEvent)(event)));
                    };
                    el.addEventListener(event_name, callback);
                    let callbacks = this._event_listeners.get(node);
                    if (callbacks === undefined) {
                        this._event_listeners.set(node, callbacks = new Map());
                    }
                    callbacks.set(event_name, callback);
                }
            }
        }
    }
    exports.HTMLView = HTMLView;
    HTMLView.__name__ = "HTMLView";
    class HTML extends markup_1.Markup {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.HTML = HTML;
    _c = HTML;
    HTML.__name__ = "HTML";
    HTML.__module__ = "panel.models.markup";
    (() => {
        _c.prototype.default_view = HTMLView;
        _c.define(({ Bool, Str, List, Dict }) => ({
            events: [Dict(List(Str)), {}],
            run_scripts: [Bool, true],
        }));
    })();
},
"8694ed3f61": /* styles\models\html.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `.copybtn{position:sticky;display:flex;top:0;left:100%;width:1.7em;height:1.7em;opacity:0;transition:opacity 0.3s, border 0.3s, background-color 0.3s;user-select:none;padding:0;border:none;outline:none;border-radius:0.4em;border:#1b1f2426 1px solid;background-color:#f6f8fa;color:#57606a;}.codehilite pre{margin-top:-1.7em;}.copybtn svg{stroke:currentColor;width:1.5em;height:1.5em;padding:0.1em;}.codehilite:hover .copybtn{opacity:1;cursor:pointer;}`;
},
"727a14f76b": /* styles\models\esm.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `.error-wrapper,.child-wrapper{display:contents;}.error{padding:0.75rem 1.25rem;border:1px solid transparent;border-radius:0.25rem;color:var(--danger-text-color);background-color:var(--danger-bg-subtle);border-color:var(--danger-border-subtle);}.error .msg{font-weight:bold;}.error pre.highlight{backdrop-filter:brightness(0.8);font-weight:900;}`;
},
"fd59c985b3": /* models\audio.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const layout_1 = require("9b11ce01a3") /* ./layout */;
    class AudioView extends layout_1.HTMLBoxView {
        initialize() {
            super.initialize();
            this._blocked = false;
            this._setting = false;
            this._time = Date.now();
        }
        connect_signals() {
            super.connect_signals();
            const { loop, paused, time, value, volume, muted, autoplay } = this.model.properties;
            this.on_change(loop, () => this.set_loop());
            this.on_change(paused, () => this.set_paused());
            this.on_change(time, () => this.set_time());
            this.on_change(value, () => this.set_value());
            this.on_change(volume, () => this.set_volume());
            this.on_change(muted, () => this.set_muted());
            this.on_change(autoplay, () => this.set_autoplay());
        }
        render() {
            super.render();
            this.audioEl = document.createElement("audio");
            this.audioEl.controls = true;
            this.audioEl.src = this.model.value;
            this.audioEl.currentTime = this.model.time;
            this.audioEl.loop = this.model.loop;
            this.audioEl.muted = this.model.muted;
            this.audioEl.autoplay = this.model.autoplay;
            if (this.model.volume != null) {
                this.audioEl.volume = this.model.volume / 100;
            }
            else {
                this.model.volume = this.audioEl.volume * 100;
            }
            this.audioEl.onpause = () => this.model.paused = true;
            this.audioEl.onplay = () => this.model.paused = false;
            this.audioEl.ontimeupdate = () => this.update_time(this);
            this.audioEl.onvolumechange = () => this.update_volume(this);
            (0, layout_1.set_size)(this.audioEl, this.model, false);
            this.shadow_el.appendChild(this.audioEl);
            if (!this.model.paused) {
                this.audioEl.play();
            }
        }
        update_time(view) {
            if (view._setting) {
                view._setting = false;
                return;
            }
            if ((Date.now() - view._time) < view.model.throttle) {
                return;
            }
            view._blocked = true;
            view.model.time = view.audioEl.currentTime;
            view._time = Date.now();
        }
        update_volume(view) {
            if (view._setting) {
                view._setting = false;
                return;
            }
            view._blocked = true;
            view.model.volume = view.audioEl.volume * 100;
        }
        set_loop() {
            this.audioEl.loop = this.model.loop;
        }
        set_muted() {
            this.audioEl.muted = this.model.muted;
        }
        set_autoplay() {
            this.audioEl.autoplay = this.model.autoplay;
        }
        set_paused() {
            if (!this.audioEl.paused && this.model.paused) {
                this.audioEl.pause();
            }
            if (this.audioEl.paused && !this.model.paused) {
                this.audioEl.play();
            }
        }
        set_volume() {
            if (this._blocked) {
                this._blocked = false;
                return;
            }
            this._setting = true;
            if (this.model.volume != null) {
                this.audioEl.volume = this.model.volume / 100;
            }
        }
        set_time() {
            if (this._blocked) {
                this._blocked = false;
                return;
            }
            this._setting = true;
            this.audioEl.currentTime = this.model.time;
        }
        set_value() {
            this.audioEl.src = this.model.value;
        }
    }
    exports.AudioView = AudioView;
    AudioView.__name__ = "AudioView";
    class Audio extends layout_1.HTMLBox {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Audio = Audio;
    _a = Audio;
    Audio.__name__ = "Audio";
    Audio.__module__ = "panel.models.widgets";
    (() => {
        _a.prototype.default_view = AudioView;
        _a.define(({ Any, Bool, Float, Nullable }) => ({
            loop: [Bool, false],
            paused: [Bool, true],
            muted: [Bool, false],
            autoplay: [Bool, false],
            time: [Float, 0],
            throttle: [Float, 250],
            value: [Any, ""],
            volume: [Nullable(Float), null],
        }));
    })();
},
"5a16cc23e6": /* models\browser.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const view_1 = require("@bokehjs/core/view");
    const model_1 = require("@bokehjs/model");
    class BrowserInfoView extends view_1.View {
        initialize() {
            super.initialize();
            if (window.matchMedia != null) {
                const darkModeMediaQuery = window.matchMedia("(prefers-color-scheme: dark)");
                darkModeMediaQuery.addEventListener("change", (e) => {
                    this.model.dark_mode = e.matches;
                });
                this.model.dark_mode = darkModeMediaQuery.matches;
            }
            this.model.device_pixel_ratio = window.devicePixelRatio;
            if (navigator != null) {
                this.model.language = navigator.language;
                this.model.webdriver = navigator.webdriver;
            }
            const timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
            if (timezone != null) {
                this.model.timezone = timezone;
            }
            const timezone_offset = new Date().getTimezoneOffset();
            if (timezone_offset != null) {
                this.model.timezone_offset = timezone_offset;
            }
            try {
                const canvas = document.createElement("canvas");
                this.model.webgl = !!(window.WebGLRenderingContext &&
                    (canvas.getContext("webgl") || canvas.getContext("experimental-webgl")));
            }
            catch (e) {
                this.model.webgl = false;
            }
            this._has_finished = true;
            this.notify_finished();
        }
    }
    exports.BrowserInfoView = BrowserInfoView;
    BrowserInfoView.__name__ = "BrowserInfoView";
    class BrowserInfo extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BrowserInfo = BrowserInfo;
    _a = BrowserInfo;
    BrowserInfo.__name__ = "BrowserInfo";
    BrowserInfo.__module__ = "panel.models.browser";
    (() => {
        _a.prototype.default_view = BrowserInfoView;
        _a.define(({ Bool, Nullable, Float, Str }) => ({
            dark_mode: [Nullable(Bool), null],
            device_pixel_ratio: [Nullable(Float), null],
            language: [Nullable(Str), null],
            timezone: [Nullable(Str), null],
            timezone_offset: [Nullable(Float), null],
            webdriver: [Nullable(Bool), null],
            webgl: [Nullable(Bool), null],
        }));
    })();
},
"1db93211cd": /* models\button.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tooltip_1 = require("@bokehjs/models/ui/tooltip");
    const build_views_1 = require("@bokehjs/core/build_views");
    const button_1 = require("@bokehjs/models/widgets/button");
    class ButtonView extends button_1.ButtonView {
        *children() {
            yield* super.children();
            if (this.tooltip != null) {
                yield this.tooltip;
            }
        }
        connect_signals() {
            super.connect_signals();
            const { tooltip } = this.model.properties;
            this.on_change(tooltip, () => this.update_tooltip());
        }
        async update_tooltip() {
            if (this.tooltip != null) {
                this.tooltip.remove();
            }
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        remove() {
            this.tooltip?.remove();
            super.remove();
        }
        render() {
            super.render();
            const toggle = (visible) => {
                this.tooltip?.model.setv({
                    visible,
                });
            };
            let timer;
            this.el.addEventListener("mouseenter", () => {
                timer = setTimeout(() => toggle(true), this.model.tooltip_delay);
            });
            this.el.addEventListener("mouseleave", () => {
                clearTimeout(timer);
                toggle(false);
            });
        }
    }
    exports.ButtonView = ButtonView;
    ButtonView.__name__ = "ButtonView";
    class Button extends button_1.Button {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Button = Button;
    _a = Button;
    Button.__name__ = "Button";
    Button.__module__ = "panel.models.widgets";
    (() => {
        _a.prototype.default_view = ButtonView;
        _a.define(({ Nullable, Ref, Float }) => ({
            tooltip: [Nullable(Ref(tooltip_1.Tooltip)), null],
            tooltip_delay: [Float, 500],
        }));
    })();
},
"1738ddeb3a": /* models\button_icon.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const icon_1 = require("6c7fbea0ef") /* ./icon */;
    class ButtonIconView extends icon_1.ClickableIconView {
        *controls() { }
        update_cursor() {
            this.icon_view.el.style.cursor = this.model.disabled ? "default" : "pointer";
        }
        click() {
            if (this.model.disabled) {
                return;
            }
            super.click();
            const updateState = (value, disabled) => {
                this.model.value = value;
                this.model.disabled = disabled;
            };
            updateState(true, true);
            new Promise(resolve => setTimeout(resolve, this.model.toggle_duration))
                .then(() => {
                updateState(false, false);
            });
        }
    }
    exports.ButtonIconView = ButtonIconView;
    ButtonIconView.__name__ = "ButtonIconView";
    class ButtonIcon extends icon_1.ClickableIcon {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ButtonIcon = ButtonIcon;
    _a = ButtonIcon;
    ButtonIcon.__name__ = "ButtonIcon";
    ButtonIcon.__module__ = "panel.models.icon";
    (() => {
        _a.prototype.default_view = ButtonIconView;
        _a.define(({ Int }) => ({
            toggle_duration: [Int, 75],
        }));
    })();
},
"6c7fbea0ef": /* models\icon.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tooltip_1 = require("@bokehjs/models/ui/tooltip");
    const tabler_icon_1 = require("@bokehjs/models/ui/icons/tabler_icon");
    const svg_icon_1 = require("@bokehjs/models/ui/icons/svg_icon");
    const control_1 = require("@bokehjs/models/widgets/control");
    const dom_1 = require("@bokehjs/core/dom");
    const build_views_1 = require("@bokehjs/core/build_views");
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    class ClickableIconView extends control_1.ControlView {
        *controls() { }
        remove() {
            this.tooltip?.remove();
            this.icon_view.remove();
            super.remove();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            this.was_svg_icon = this.is_svg_icon(this.model.icon);
            this.label_el = (0, dom_1.div)({ class: "bk-IconLabel" }, this.model.title);
            this.label_el.style.fontSize = this.calculate_size(0.6);
            this.icon_view = await this.build_icon_model(this.model.icon, this.was_svg_icon);
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        *children() {
            yield* super.children();
            yield this.icon_view;
            if (this.tooltip != null) {
                yield this.tooltip;
            }
        }
        is_svg_icon(icon) {
            return icon.trim().startsWith("<svg");
        }
        connect_signals() {
            super.connect_signals();
            const { icon, active_icon, disabled, value, size, tooltip } = this.model.properties;
            this.on_change([active_icon, icon, value], () => this.update_icon());
            this.on_change(this.model.properties.title, () => this.update_label());
            this.on_change(disabled, () => this.update_cursor());
            this.on_change(size, () => this.update_size());
            this.on_change(tooltip, () => this.update_tooltip());
        }
        async update_tooltip() {
            if (this.tooltip != null) {
                this.tooltip.remove();
            }
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        render() {
            super.render();
            this.icon_view.render();
            this.update_icon();
            this.update_label();
            this.update_cursor();
            this.row_div = (0, dom_1.div)({
                class: "bk-IconRow",
            }, this.icon_view.el, this.label_el);
            this.shadow_el.appendChild(this.row_div);
            const toggle_tooltip = (visible) => {
                this.tooltip?.model.setv({
                    visible,
                });
            };
            let timer;
            this.el.addEventListener("mouseenter", () => {
                if (timer) {
                    clearTimeout(timer);
                }
                timer = setTimeout(() => toggle_tooltip(true), this.model.tooltip_delay);
            });
            this.el.addEventListener("pointerleave", () => {
                clearTimeout(timer);
                timer = undefined;
                toggle_tooltip(false);
            });
        }
        update_label() {
            this.label_el.innerText = this.model.title;
        }
        update_cursor() {
            this.icon_view.el.style.cursor = this.model.disabled ? "not-allowed" : "pointer";
        }
        update_size() {
            this.icon_view.model.size = this.calculate_size();
            this.label_el.style.fontSize = this.calculate_size(0.6);
        }
        async build_icon_model(icon, is_svg_icon) {
            const size = this.calculate_size();
            const icon_model = (() => {
                if (is_svg_icon) {
                    return new svg_icon_1.SVGIcon({ svg: icon, size });
                }
                else {
                    return new tabler_icon_1.TablerIcon({ icon_name: icon, size });
                }
            })();
            const icon_view = await (0, build_views_1.build_view)(icon_model, { parent: this });
            icon_view.el.addEventListener("click", () => this.click());
            return icon_view;
        }
        async update_icon() {
            const icon = this.model.value ? this.get_active_icon() : this.model.icon;
            this.class_list.toggle("active", this.model.value);
            const is_svg_icon = this.is_svg_icon(icon);
            if (this.was_svg_icon !== is_svg_icon) {
                // If the icon type has changed, we need to rebuild the icon view
                // and invalidate the old one.
                const icon_view = await this.build_icon_model(icon, is_svg_icon);
                icon_view.render();
                this.icon_view.remove();
                this.icon_view = icon_view;
                this.was_svg_icon = is_svg_icon;
                this.update_cursor();
                // We need to re-append the new icon view to the DOM
                this.row_div.insertBefore(this.icon_view.el, this.label_el);
            }
            else if (is_svg_icon) {
                this.icon_view.model.svg = icon;
            }
            else {
                this.icon_view.model.icon_name = icon;
            }
            this.icon_view.el.style.lineHeight = "0";
        }
        get_active_icon() {
            return this.model.active_icon !== "" ? this.model.active_icon : `${this.model.icon}-filled`;
        }
        calculate_size(factor = 1) {
            if (this.model.size !== null) {
                return `calc(${this.model.size} * ${factor})`;
            }
            const maxWidth = this.model.width ?? 15;
            const maxHeight = this.model.height ?? 15;
            const size = Math.max(maxWidth, maxHeight) * factor;
            return `${size}px`;
        }
        click() {
            this.model.trigger_event(new bokeh_events_1.ButtonClick());
        }
    }
    exports.ClickableIconView = ClickableIconView;
    ClickableIconView.__name__ = "ClickableIconView";
    class ClickableIcon extends control_1.Control {
        constructor(attrs) {
            super(attrs);
        }
        on_click(callback) {
            this.on_event(bokeh_events_1.ButtonClick, callback);
        }
    }
    exports.ClickableIcon = ClickableIcon;
    _a = ClickableIcon;
    ClickableIcon.__name__ = "ClickableIcon";
    ClickableIcon.__module__ = "panel.models.icon";
    (() => {
        _a.prototype.default_view = ClickableIconView;
        _a.define(({ Nullable, Ref, Float, Str, Bool }) => ({
            active_icon: [Str, ""],
            icon: [Str, "heart"],
            size: [Nullable(Str), null],
            value: [Bool, false],
            title: [Str, ""],
            tooltip: [Nullable(Ref(tooltip_1.Tooltip)), null],
            tooltip_delay: [Float, 500],
        }));
    })();
},
"330f4a8735": /* models\card.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require("tslib");
    const DOM = tslib_1.__importStar(require("@bokehjs/core/dom"));
    const column_1 = require("dd255421d9") /* ./column */;
    const card_css_1 = tslib_1.__importDefault(require("edc7ee0090") /* ../styles/models/card.css */);
    const CHEVRON_RIGHT = `
<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-right"><path stroke="none" d="M0 0h12v12H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>
`;
    const CHEVRON_DOWN = `
<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-down"><path stroke="none" d="M0 0h12v12H0z" fill="none"/><path d="M6 9l6 6l6 -6" /></svg>
`;
    class CardView extends column_1.ColumnView {
        constructor() {
            super(...arguments);
            this.collapsed_style = new DOM.InlineStyleSheet();
        }
        connect_signals() {
            super.connect_signals();
            const { active_header_background, collapsed, header_background, header_color, hide_header } = this.model.properties;
            this.on_change(collapsed, () => this._collapse());
            this.on_change([header_color, hide_header], () => this.render());
            this.on_change([active_header_background, collapsed, header_background], () => {
                const header_background = this.header_background;
                if (header_background == null) {
                    return;
                }
                this.child_views[0].el.style.backgroundColor = header_background;
                this.header_el.style.backgroundColor = header_background;
            });
        }
        stylesheets() {
            return [...super.stylesheets(), card_css_1.default];
        }
        *_stylesheets() {
            yield* super._stylesheets();
            yield this.collapsed_style;
        }
        get header_background() {
            let header_background = this.model.header_background;
            if (!this.model.collapsed && this.model.active_header_background) {
                header_background = this.model.active_header_background;
            }
            return header_background;
        }
        render() {
            this.empty();
            if (this.model.collapsed) {
                this.collapsed_style.replace(":host", {
                    height: "fit-content",
                    flex: "none",
                });
            }
            this._update_stylesheets();
            this._update_css_classes();
            this._apply_styles();
            this._apply_visible();
            this.class_list.add(...this.css_classes());
            const { button_css_classes, header_color, header_tag, header_css_classes } = this.model;
            const header_background = this.header_background;
            const header = this.child_views[0];
            let header_el;
            if (this.model.collapsible) {
                this.button_el = DOM.button({ class: header_css_classes });
                const icon = DOM.div({ class: button_css_classes });
                icon.innerHTML = this.model.collapsed ? CHEVRON_RIGHT : CHEVRON_DOWN;
                this.button_el.appendChild(icon);
                this.button_el.style.backgroundColor = header_background != null ? header_background : "";
                header.el.style.backgroundColor = header_background != null ? header_background : "";
                this.button_el.appendChild(header.el);
                this.button_el.addEventListener("click", (e) => this._toggle_button(e));
                header_el = this.button_el;
            }
            else {
                header_el = DOM.create_element(header_tag, { class: header_css_classes });
                header_el.style.backgroundColor = header_background != null ? header_background : "";
                header_el.appendChild(header.el);
            }
            this.header_el = header_el;
            if (!this.model.hide_header) {
                header_el.style.color = header_color != null ? header_color : "";
                this.shadow_el.appendChild(header_el);
                header.render();
                header.r_after_render();
            }
            if (this.model.collapsed) {
                return;
            }
            for (const child_view of this.child_views.slice(1)) {
                this.shadow_el.appendChild(child_view.el);
                child_view.render();
                child_view.r_after_render();
            }
        }
        async update_children() {
            await this.build_child_views();
            this.render();
            this.invalidate_layout();
        }
        _toggle_button(e) {
            for (const path of e.composedPath()) {
                if (path instanceof HTMLInputElement) {
                    return;
                }
            }
            this.model.collapsed = !this.model.collapsed;
        }
        _collapse() {
            for (const child_view of this.child_views.slice(1)) {
                if (this.model.collapsed) {
                    this.shadow_el.removeChild(child_view.el);
                    child_view.model.visible = false;
                }
                else {
                    child_view.render();
                    child_view.after_render();
                    this.shadow_el.appendChild(child_view.el);
                    child_view.model.visible = true;
                }
            }
            if (this.model.collapsed) {
                this.collapsed_style.replace(":host", {
                    height: "fit-content",
                    flex: "none",
                });
            }
            else {
                this.collapsed_style.clear();
            }
            this.button_el.children[0].innerHTML = this.model.collapsed ? CHEVRON_RIGHT : CHEVRON_DOWN;
            this.invalidate_layout();
        }
        _create_element() {
            return DOM.create_element(this.model.tag, { class: this.css_classes() });
        }
    }
    exports.CardView = CardView;
    CardView.__name__ = "CardView";
    class Card extends column_1.Column {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Card = Card;
    _a = Card;
    Card.__name__ = "Card";
    Card.__module__ = "panel.models.layout";
    (() => {
        _a.prototype.default_view = CardView;
        _a.define(({ List, Bool, Nullable, Str }) => ({
            active_header_background: [Nullable(Str), null],
            button_css_classes: [List(Str), []],
            collapsed: [Bool, true],
            collapsible: [Bool, true],
            header_background: [Nullable(Str), null],
            header_color: [Nullable(Str), null],
            header_css_classes: [List(Str), []],
            header_tag: [Str, "div"],
            hide_header: [Bool, false],
            tag: [Str, "div"],
        }));
    })();
},
"dd255421d9": /* models\column.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c;
    __esModule();
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var ScrollToEvent_1;
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    const dom_1 = require("@bokehjs/core/dom");
    const column_1 = require("@bokehjs/models/layouts/column");
    class ScrollButtonClick extends bokeh_events_1.ModelEvent {
    }
    exports.ScrollButtonClick = ScrollButtonClick;
    _a = ScrollButtonClick;
    ScrollButtonClick.__name__ = "ScrollButtonClick";
    (() => {
        _a.prototype.event_name = "scroll_button_click";
    })();
    let ScrollToEvent = (_b = class ScrollToEvent extends bokeh_events_1.ModelEvent {
        constructor(model, index) {
            super();
            this.model = model;
            this.index = index;
            this.index = index;
            this.origin = model;
        }
        get event_values() {
            return { model: this.origin, index: this.index };
        }
        static from_values(values) {
            const { model, index } = values;
            return new ScrollToEvent_1(model, index);
        }
    },
        (() => {
            ScrollToEvent_1 = _b;
        })(),
        _b.__name__ = "ScrollToEvent",
        _b);
    exports.ScrollToEvent = ScrollToEvent;
    exports.ScrollToEvent = ScrollToEvent = ScrollToEvent_1 = __decorate([
        (0, bokeh_events_1.server_event)("scroll_to")
    ], ScrollToEvent);
    class ColumnView extends column_1.ColumnView {
        constructor() {
            super(...arguments);
            this._updating = false;
        }
        connect_signals() {
            super.connect_signals();
            const { children, scroll_position, scroll_button_threshold } = this.model.properties;
            this.on_change(children, () => this.trigger_auto_scroll());
            this.on_change(scroll_position, () => this.scroll_to_position());
            this.on_change(scroll_button_threshold, () => this.toggle_scroll_button());
            this.model.on_event(ScrollToEvent, (event) => this.scroll_to_index(event.index));
        }
        get distance_from_latest() {
            return this.el.scrollHeight - this.el.scrollTop - this.el.clientHeight;
        }
        scroll_to_index(index) {
            if (index === null) {
                return;
            }
            if (index >= this.model.children.length) {
                console.warn(`Invalid scroll index: ${index}`);
                return;
            }
            // Get the child view at the specified index
            const childView = this.child_views[index];
            if (!childView) {
                console.warn(`Child view not found for index: ${index}`);
                return;
            }
            // Get the top position of the child element relative to the column
            const childEl = childView.el;
            const childRect = childEl.getBoundingClientRect();
            const columnRect = this.el.getBoundingClientRect();
            const relativeTop = childRect.top - columnRect.top + this.el.scrollTop;
            // Scroll to the child's position
            this.model.scroll_position = Math.round(relativeTop);
        }
        scroll_to_position() {
            if (this._updating) {
                return;
            }
            requestAnimationFrame(() => {
                this.el.scrollTo({ top: this.model.scroll_position, behavior: "instant" });
            });
        }
        scroll_to_latest(scroll_limit = null) {
            if (scroll_limit !== null) {
                const within_limit = this.distance_from_latest <= scroll_limit;
                if (!within_limit) {
                    return;
                }
            }
            requestAnimationFrame(() => {
                this.model.scroll_position = Math.round(this.el.scrollHeight);
            });
        }
        trigger_auto_scroll() {
            const limit = this.model.auto_scroll_limit;
            if (limit == 0) {
                return;
            }
            const within_limit = this.distance_from_latest <= limit;
            if (!within_limit) {
                return;
            }
            this.scroll_to_latest();
        }
        record_scroll_position() {
            this._updating = true;
            this.model.scroll_position = Math.round(this.el.scrollTop);
            this._updating = false;
        }
        toggle_scroll_button() {
            const threshold = this.model.scroll_button_threshold;
            if (!this.scroll_down_button_el || threshold === 0) {
                return;
            }
            const exceeds_threshold = this.distance_from_latest >= threshold;
            this.scroll_down_button_el.classList.toggle("visible", exceeds_threshold);
        }
        render() {
            super.render();
            this.scroll_down_button_el = (0, dom_1.div)({ class: "scroll-button" });
            this.shadow_el.appendChild(this.scroll_down_button_el);
            this.el.addEventListener("scroll", () => {
                this.record_scroll_position();
                this.toggle_scroll_button();
            });
            this.scroll_down_button_el.addEventListener("click", () => {
                this.scroll_to_latest();
                this.model.trigger_event(new ScrollButtonClick());
            });
        }
        async update_children() {
            const created = await this.build_child_views();
            const created_views = new Set(created);
            // Find index up to which the order of the existing views
            // matches the order of the new views. This allows us to
            // skip re-inserting the views up to this point
            const current_views = Array.from(this.shadow_el.children).flatMap(el => {
                const view = this.child_views.find(view => view.el === el);
                return view === undefined ? [] : [view];
            });
            let matching_index = null;
            for (let i = 0; i < current_views.length; i++) {
                if (current_views[i] === this.child_views[i]) {
                    matching_index = i;
                }
                else {
                    break;
                }
            }
            // Since appending to a DOM node will move the node to the end if it has
            // already been added appending all the children in order will result in
            // correct ordering.
            for (let i = 0; i < this.child_views.length; i++) {
                const view = this.child_views[i];
                const is_new = created_views.has(view);
                // this.shadow_el is needed for Bokeh < 3.7.0 as this.self_target is not defined
                // can be removed when our minimum version is Bokeh 3.7.0
                // https://github.com/holoviz/panel/pull/7948
                const target = view.rendering_target() ?? this.self_target ?? this.shadow_el;
                if (is_new) {
                    view.render_to(target);
                }
                else if (matching_index === null || i > matching_index) {
                    target.append(view.el);
                }
            }
            this.r_after_render();
            this._update_children();
            this.invalidate_layout();
        }
        after_render() {
            super.after_render();
            requestAnimationFrame(() => {
                if (this.model.scroll_position) {
                    this.scroll_to_position();
                }
                if (this.model.view_latest) {
                    this.scroll_to_latest();
                }
                this.toggle_scroll_button();
            });
        }
    }
    exports.ColumnView = ColumnView;
    ColumnView.__name__ = "ColumnView";
    class Column extends column_1.Column {
        constructor(attrs) {
            super(attrs);
        }
        on_click(callback) {
            this.on_event(ScrollButtonClick, callback);
        }
    }
    exports.Column = Column;
    _c = Column;
    Column.__name__ = "Column";
    Column.__module__ = "panel.models.layout";
    (() => {
        _c.prototype.default_view = ColumnView;
        _c.define(({ Int, Bool, Nullable }) => ({
            scroll_position: [Int, 0],
            scroll_index: [Nullable(Int), null],
            auto_scroll_limit: [Int, 0],
            scroll_button_threshold: [Int, 0],
            view_latest: [Bool, false],
        }));
    })();
},
"edc7ee0090": /* styles\models\card.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host(.card){border-radius:0.25rem;box-shadow:rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;flex:auto;outline:1px solid rgba(0, 0, 0, 0.125);}:host(.accordion){box-shadow:rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;outline:1px solid rgba(0, 0, 0, 0.125);width:100%;}.card-header{align-items:center;background-color:rgba(0, 0, 0, 0.03);border:unset;border-radius:0.25rem;display:inline-flex;justify-content:start;outline:unset;position:sticky;width:100%;margin-right:0.5em;padding-inline:0.5em;cursor:pointer;}.card-header:hover{box-shadow:0 0 3px rgba(0, 0, 0, 0.3);}.card-header:not(:hover){box-shadow:0 0 3px rgba(0, 0, 0, 0);}.accordion-header{align-items:center;background-color:rgba(0, 0, 0, 0.03);border:unset;outline:1px solid;border-radius:0;display:flex;justify-content:start;position:sticky;width:100%;cursor:pointer;}.card-button{background-color:transparent;margin-left:0em;margin-right:0.25em;height:12px;width:12px;}.card-header-row{position:relative !important;}.card-title{align-items:center;font-size:1.4em;font-weight:bold;overflow-wrap:break-word;}.card-header-row > .bk{overflow-wrap:break-word;text-align:center;}`;
},
"51fbe9e2d0": /* models\checkbox_button_group.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tooltip_1 = require("@bokehjs/models/ui/tooltip");
    const build_views_1 = require("@bokehjs/core/build_views");
    const checkbox_button_group_1 = require("@bokehjs/models/widgets/checkbox_button_group");
    class CheckboxButtonGroupView extends checkbox_button_group_1.CheckboxButtonGroupView {
        *children() {
            yield* super.children();
            if (this.tooltip != null) {
                yield this.tooltip;
            }
        }
        connect_signals() {
            super.connect_signals();
            const { tooltip } = this.model.properties;
            this.on_change(tooltip, () => this.update_tooltip());
        }
        async update_tooltip() {
            if (this.tooltip != null) {
                this.tooltip.remove();
            }
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { tooltip } = this.model;
            if (tooltip != null) {
                this.tooltip = await (0, build_views_1.build_view)(tooltip, { parent: this });
            }
        }
        remove() {
            this.tooltip?.remove();
            super.remove();
        }
        render() {
            super.render();
            const toggle = (visible) => {
                this.tooltip?.model.setv({
                    visible,
                });
            };
            let timer;
            this.el.addEventListener("mouseenter", () => {
                timer = setTimeout(() => toggle(true), this.model.tooltip_delay);
            });
            this.el.addEventListener("mouseleave", () => {
                clearTimeout(timer);
                toggle(false);
            });
        }
    }
    exports.CheckboxButtonGroupView = CheckboxButtonGroupView;
    CheckboxButtonGroupView.__name__ = "CheckboxButtonGroupView";
    class CheckboxButtonGroup extends checkbox_button_group_1.CheckboxButtonGroup {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CheckboxButtonGroup = CheckboxButtonGroup;
    _a = CheckboxButtonGroup;
    CheckboxButtonGroup.__name__ = "CheckboxButtonGroup";
    CheckboxButtonGroup.__module__ = "panel.models.widgets";
    (() => {
        _a.prototype.default_view = CheckboxButtonGroupView;
        _a.define(({ Nullable, Ref, Float }) => ({
            tooltip: [Nullable(Ref(tooltip_1.Tooltip)), null],
            tooltip_delay: [Float, 500],
        }));
    })();
},
"27a077673d": /* models\chatarea_input.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const textarea_input_1 = require("b7d595d74a") /* ./textarea_input */;
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    class ChatMessageEvent extends bokeh_events_1.ModelEvent {
        constructor(value) {
            super();
            this.value = value;
        }
        get event_values() {
            return { model: this.origin, value: this.value };
        }
    }
    exports.ChatMessageEvent = ChatMessageEvent;
    _a = ChatMessageEvent;
    ChatMessageEvent.__name__ = "ChatMessageEvent";
    (() => {
        _a.prototype.event_name = "chat_message_event";
    })();
    class ChatAreaInputView extends textarea_input_1.TextAreaInputView {
        connect_signals() {
            super.connect_signals();
            const { value_input } = this.model.properties;
            this.on_change(value_input, () => this.update_rows());
        }
        render() {
            super.render();
            this.el.addEventListener("keydown", (event) => {
                if (event.key === "Enter") {
                    if (!event.shiftKey && (event.ctrlKey != this.model.enter_sends)) {
                        if (!this.model.disabled_enter) {
                            this.model.trigger_event(new ChatMessageEvent(this.model.value_input));
                            this.model.value_input = "";
                        }
                        event.preventDefault();
                    }
                    else if (event.ctrlKey && this.model.enter_sends) {
                        this.model.value_input += "\n";
                        event.preventDefault();
                    }
                }
            });
        }
    }
    exports.ChatAreaInputView = ChatAreaInputView;
    ChatAreaInputView.__name__ = "ChatAreaInputView";
    class ChatAreaInput extends textarea_input_1.TextAreaInput {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ChatAreaInput = ChatAreaInput;
    _b = ChatAreaInput;
    ChatAreaInput.__name__ = "ChatAreaInput";
    ChatAreaInput.__module__ = "panel.models.chatarea_input";
    (() => {
        _b.prototype.default_view = ChatAreaInputView;
        _b.define(({ Bool }) => {
            return {
                disabled_enter: [Bool, false],
                enter_sends: [Bool, true],
            };
        });
    })();
},
"b7d595d74a": /* models\textarea_input.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const textarea_input_1 = require("@bokehjs/models/widgets/textarea_input");
    class TextAreaInputView extends textarea_input_1.TextAreaInputView {
        connect_signals() {
            super.connect_signals();
            const { value, max_rows } = this.model.properties;
            this.on_change([max_rows, value], () => this.update_rows());
        }
        update_rows() {
            if (!this.model.auto_grow) {
                return;
            }
            // Use this.el directly to access the textarea element
            const textarea = this.input_el;
            const textLines = textarea.value.split("\n");
            const numRows = Math.max(textLines.length, this.model.rows, 1);
            textarea.rows = Math.min(numRows, this.model.max_rows || Infinity);
        }
        render() {
            super.render();
            this.update_rows();
            this.el.addEventListener("input", () => {
                this.update_rows();
            });
        }
    }
    exports.TextAreaInputView = TextAreaInputView;
    TextAreaInputView.__name__ = "TextAreaInputView";
    class TextAreaInput extends textarea_input_1.TextAreaInput {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TextAreaInput = TextAreaInput;
    _a = TextAreaInput;
    TextAreaInput.__name__ = "TextAreaInput";
    TextAreaInput.__module__ = "panel.models.widgets";
    (() => {
        _a.prototype.default_view = TextAreaInputView;
        _a.define(({ Bool, Int, Nullable }) => ({
            auto_grow: [Bool, false],
            max_rows: [Nullable(Int), null],
        }));
    })();
},
"1bec1b1fcc": /* models\comm_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const document_1 = require("@bokehjs/document");
    const view_1 = require("@bokehjs/core/view");
    const model_1 = require("@bokehjs/model");
    const message_1 = require("@bokehjs/protocol/message");
    const receiver_1 = require("@bokehjs/protocol/receiver");
    const buffer_1 = require("@bokehjs/core/serialization/buffer");
    const types_1 = require("@bokehjs/core/util/types");
    const object_1 = require("@bokehjs/core/util/object");
    exports.comm_settings = {
        debounce: true,
    };
    class CommManagerView extends view_1.View {
    }
    exports.CommManagerView = CommManagerView;
    CommManagerView.__name__ = "CommManagerView";
    class CommManager extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this._document_listener = (event) => this._document_changed(event);
        }
        initialize() {
            super.initialize();
            this._receiver = new receiver_1.Receiver();
            this._event_buffer = [];
            this._blocked = false;
            this._reconnect = false;
            this._timeout = Date.now();
            if ((window.PyViz == undefined) || (!window.PyViz.comm_manager)) {
                console.warn("Could not find comm manager on window.PyViz, ensure the extension is loaded.");
            }
            else {
                this.ns = window.PyViz;
                this.ns.comm_manager.register_target(this.plot_id, this.comm_id, (msg) => {
                    for (const view of this.ns.shared_views.get(this.plot_id)) {
                        if (view !== this) {
                            view.msg_handler(msg);
                        }
                    }
                    try {
                        this.msg_handler(msg);
                    }
                    catch (e) {
                        console.error(e);
                    }
                });
                this._client_comm = this.ns.comm_manager.get_client_comm(this.plot_id, this.client_comm_id, (msg) => this.on_ack(msg));
                this._reconnect = !this._client_comm?.active || false;
                if (this.ns.shared_views == null) {
                    this.ns.shared_views = new Map();
                }
                if (this.ns.shared_views.has(this.plot_id)) {
                    this.ns.shared_views.get(this.plot_id).push(this);
                }
                else {
                    this.ns.shared_views.set(this.plot_id, [this]);
                }
            }
        }
        _doc_attached() {
            super._doc_attached();
            if (this.document != null) {
                this.document.on_change(this._document_listener);
            }
        }
        _document_changed(event) {
            // Filter out changes to attributes that aren't server-visible
            if (event instanceof document_1.ModelChangedEvent && !event.model.properties[event.attr].syncable) {
                return;
            }
            this._event_buffer.push(event);
            if (this._reconnect && this._client_comm?.connected) {
                this.on_ack({ metadata: { msg_type: "Ready" } });
            }
            else if (!exports.comm_settings.debounce) {
                this.process_events();
            }
            else if ((!this._blocked || (Date.now() > this._timeout))) {
                setTimeout(() => this.process_events(), this.debounce);
                this._blocked = true;
                this._timeout = Date.now() + this.timeout;
            }
        }
        _extract_buffers(value, buffers) {
            if ((0, types_1.isArray)(value)) {
                for (const val of value) {
                    this._extract_buffers(val, buffers);
                }
            }
            else if (value instanceof Map) {
                for (const key of value.keys()) {
                    const v = value.get(key);
                    this._extract_buffers(v, buffers);
                }
            }
            else if (value instanceof buffer_1.Buffer) {
                const { buffer } = value;
                const id = buffers.length;
                buffers.push(buffer);
                return { id };
            }
            else if ((0, types_1.isPlainObject)(value)) {
                for (const key of (0, object_1.keys)(value)) {
                    const replaced = this._extract_buffers(value[key], buffers);
                    if (replaced != null) {
                        value[key] = replaced;
                    }
                }
            }
        }
        process_events() {
            if ((this.document == null) || (this._client_comm == null)) {
                return;
            }
            const patch = this.document.create_json_patch(this._event_buffer);
            this._event_buffer = [];
            const message = { ...message_1.Message.create("PATCH-DOC", {}, patch) };
            const buffers = [];
            this._extract_buffers(message.content, buffers);
            this._client_comm.send(message, {}, buffers);
            for (const view of this.ns.shared_views.get(this.plot_id)) {
                if (view !== this && view.document != null) {
                    view.document.apply_json_patch(patch, [], this.id);
                }
            }
        }
        disconnect_signals() {
            super.disconnect_signals();
            this.ns.shared_views.shared_views.delete(this.plot_id);
        }
        on_ack(msg) {
            // Receives acknowledgement from Python, processing event
            // and unblocking Comm if event queue empty
            const metadata = msg.metadata;
            if (this._event_buffer.length > 0) {
                this._blocked = true;
                this._timeout = Date.now() + this.timeout;
                this.process_events();
            }
            else {
                this._blocked = false;
            }
            if ((metadata.msg_type == "Ready") && metadata.content) {
                // eslint-disable-next-line no-console
                console.log("Python callback returned following output:", metadata.content);
            }
            else if (metadata.msg_type == "Error") {
                console.warn("Python failed with the following traceback:", metadata.traceback);
            }
        }
        msg_handler(msg) {
            const metadata = msg.metadata;
            const buffers = msg.buffers;
            const content = msg.content.data;
            const plot_id = this.plot_id;
            if ((metadata.msg_type == "Ready")) {
                if (metadata.content) {
                    // eslint-disable-next-line no-console
                    console.log("Python callback returned following output:", metadata.content);
                }
                else if (metadata.msg_type == "Error") {
                    console.warn("Python failed with the following traceback:", metadata.traceback);
                }
            }
            else if (plot_id != null) {
                let plot = null;
                if ((plot_id in this.ns.plot_index) && (this.ns.plot_index[plot_id] != null)) {
                    plot = this.ns.plot_index[plot_id];
                }
                else if ((window.Bokeh !== undefined) && (plot_id in window.Bokeh.index)) {
                    plot = window.Bokeh.index[plot_id];
                }
                if (plot == null) {
                    return;
                }
                if (content.length) {
                    this._receiver.consume(content);
                }
                else if ((buffers != undefined) && (buffers.length > 0)) {
                    this._receiver.consume(buffers[0].buffer);
                }
                else {
                    return;
                }
                const comm_msg = this._receiver.message;
                if ((comm_msg != null) && (Object.keys(comm_msg.content).length > 0) && this.document != null) {
                    const patch = comm_msg.content;
                    this.document.apply_json_patch(patch, comm_msg.buffers);
                }
            }
        }
    }
    exports.CommManager = CommManager;
    _a = CommManager;
    CommManager.__name__ = "CommManager";
    CommManager.__module__ = "panel.models.comm_manager";
    (() => {
        _a.prototype.default_view = CommManagerView;
        _a.define(({ Int, Str, Nullable }) => ({
            plot_id: [Nullable(Str), null],
            comm_id: [Nullable(Str), null],
            client_comm_id: [Nullable(Str), null],
            timeout: [Int, 5000],
            debounce: [Int, 50],
        }));
    })();
},
"92bbd30bd1": /* models\customselect.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const select_1 = require("@bokehjs/models/widgets/select");
    class CustomSelectView extends select_1.SelectView {
        connect_signals() {
            super.connect_signals();
            const { disabled_options } = this.model.properties;
            this.on_change(disabled_options, () => this._update_disabled_options());
        }
        options_el() {
            const opts = super.options_el();
            const { disabled_options } = this.model;
            opts.forEach((element) => {
                // XXX: what about HTMLOptGroupElement?
                if (element instanceof HTMLOptionElement && disabled_options.includes(element.value)) {
                    element.setAttribute("disabled", "true");
                }
            });
            return opts;
        }
        _update_disabled_options() {
            for (const element of this.input_el.options) {
                if (this.model.disabled_options.includes(element.value)) {
                    element.setAttribute("disabled", "true");
                }
                else {
                    element.removeAttribute("disabled");
                }
            }
        }
    }
    exports.CustomSelectView = CustomSelectView;
    CustomSelectView.__name__ = "CustomSelectView";
    class CustomSelect extends select_1.Select {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CustomSelect = CustomSelect;
    _a = CustomSelect;
    CustomSelect.__name__ = "CustomSelect";
    CustomSelect.__module__ = "panel.models.widgets";
    (() => {
        _a.prototype.default_view = CustomSelectView;
        _a.define(({ List, Str }) => {
            return {
                disabled_options: [List(Str), []],
            };
        });
    })();
},
"27b5580835": /* models\multiselect.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const multiselect_1 = require("@bokehjs/models/widgets/multiselect");
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    class DoubleClickEvent extends bokeh_events_1.ModelEvent {
        constructor(option) {
            super();
            this.option = option;
        }
        get event_values() {
            return { model: this.origin, option: this.option };
        }
    }
    exports.DoubleClickEvent = DoubleClickEvent;
    _a = DoubleClickEvent;
    DoubleClickEvent.__name__ = "DoubleClickEvent";
    (() => {
        _a.prototype.event_name = "dblclick_event";
    })();
    class CustomMultiSelectView extends multiselect_1.MultiSelectView {
        render() {
            super.render();
            for (const option of this.input_el.children) {
                option.addEventListener("dblclick", (event) => {
                    if (event.target) {
                        this.model.trigger_event(new DoubleClickEvent(event.target.value));
                    }
                });
            }
        }
    }
    exports.CustomMultiSelectView = CustomMultiSelectView;
    CustomMultiSelectView.__name__ = "CustomMultiSelectView";
    class CustomMultiSelect extends multiselect_1.MultiSelect {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CustomMultiSelect = CustomMultiSelect;
    _b = CustomMultiSelect;
    CustomMultiSelect.__name__ = "CustomMultiSelect";
    CustomMultiSelect.__module__ = "panel.models.widgets";
    (() => {
        _b.prototype.default_view = CustomMultiSelectView;
    })();
},
"7934c11cba": /* models\tabulator.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d;
    __esModule();
    const tslib_1 = require("tslib");
    const dom_1 = require("@bokehjs/core/dom");
    const arrayable_1 = require("@bokehjs/core/util/arrayable");
    const types_1 = require("@bokehjs/core/util/types");
    const bokeh_events_1 = require("@bokehjs/core/bokeh_events");
    const dom_2 = require("@bokehjs/core/dom");
    const kinds_1 = require("@bokehjs/core/kinds");
    const column_data_source_1 = require("@bokehjs/models/sources/column_data_source");
    const tables_1 = require("@bokehjs/models/widgets/tables");
    const debounce_1 = require("99a25e6992") /* debounce */;
    const comm_manager_1 = require("1bec1b1fcc") /* ./comm_manager */;
    const data_1 = require("be689f0377") /* ./data */;
    const layout_1 = require("9b11ce01a3") /* ./layout */;
    const util_1 = require("6ae1cb3800") /* ./util */;
    const tabulator_css_1 = tslib_1.__importDefault(require("b0e650c65c") /* ../styles/models/tabulator.css */);
    class TableEditEvent extends bokeh_events_1.ModelEvent {
        constructor(column, row, pre) {
            super();
            this.column = column;
            this.row = row;
            this.pre = pre;
        }
        get event_values() {
            return { model: this.origin, column: this.column, row: this.row, pre: this.pre };
        }
    }
    exports.TableEditEvent = TableEditEvent;
    _a = TableEditEvent;
    TableEditEvent.__name__ = "TableEditEvent";
    (() => {
        _a.prototype.event_name = "table-edit";
    })();
    class CellClickEvent extends bokeh_events_1.ModelEvent {
        constructor(column, row) {
            super();
            this.column = column;
            this.row = row;
        }
        get event_values() {
            return { model: this.origin, column: this.column, row: this.row };
        }
    }
    exports.CellClickEvent = CellClickEvent;
    _b = CellClickEvent;
    CellClickEvent.__name__ = "CellClickEvent";
    (() => {
        _b.prototype.event_name = "cell-click";
    })();
    class SelectionEvent extends bokeh_events_1.ModelEvent {
        constructor(indices, selected, flush = false) {
            super();
            this.indices = indices;
            this.selected = selected;
            this.flush = flush;
        }
        get event_values() {
            return { model: this.origin, indices: this.indices, selected: this.selected, flush: this.flush };
        }
    }
    exports.SelectionEvent = SelectionEvent;
    _c = SelectionEvent;
    SelectionEvent.__name__ = "SelectionEvent";
    (() => {
        _c.prototype.event_name = "selection-change";
    })();
    function find_group(key, value, records) {
        for (const record of records) {
            if (record[key] == value) {
                return record;
            }
        }
        return null;
    }
    function summarize(grouped, columns, aggregators, depth = 0) {
        const summary = {};
        if (grouped.length == 0) {
            return summary;
        }
        // depth level 0 is the root, finish here
        let aggs = "";
        if (depth > 0) {
            aggs = aggregators[depth - 1];
        }
        for (const group of grouped) {
            const subsummary = summarize(group._children, columns, aggregators, depth + 1);
            for (const col in subsummary) {
                if ((0, types_1.isArray)(subsummary[col])) {
                    group[col] = (0, arrayable_1.sum)(subsummary[col]) / subsummary[col].length;
                }
                else {
                    group[col] = subsummary[col];
                }
            }
            for (const column of columns.slice(1)) {
                // if no aggregation method provided for an index level,
                // or a specific column of an index level, do not aggregate data
                let agg = "";
                if (typeof aggs === "string") {
                    agg = aggs;
                }
                else if (column.field in aggs) {
                    agg = aggs[column.field];
                }
                const val = group[column.field];
                if (column.field in summary) {
                    const old_val = summary[column.field];
                    if (agg === "min") {
                        summary[column.field] = (val < old_val) ? val : old_val;
                    }
                    else if (agg === "max") {
                        summary[column.field] = (val > old_val) ? val : old_val;
                    }
                    else if (agg === "sum") {
                        summary[column.field] = val + old_val;
                    }
                    else if (agg === "mean") {
                        if ((0, types_1.isArray)(summary[column.field])) {
                            summary[column.field].push(val);
                        }
                        else {
                            summary[column.field] = [old_val, val];
                        }
                    }
                }
                else {
                    summary[column.field] = val;
                }
            }
        }
        return summary;
    }
    function group_data(records, columns, indexes, aggregators) {
        const grouped = [];
        const index_field = columns[0].field;
        for (const record of records) {
            const value = record[indexes[0]];
            let group = find_group(index_field, value, grouped);
            if (group == null) {
                group = { _children: [] };
                group[index_field] = value;
                grouped.push(group);
            }
            let subgroup = group;
            for (const index of indexes.slice(1)) {
                subgroup = find_group(index_field, record[index], subgroup._children);
                if (subgroup == null) {
                    subgroup = { _children: [] };
                    subgroup[index_field] = record[index];
                    group._children.push(subgroup);
                }
                for (const column of columns.slice(1)) {
                    subgroup[column.field] = record[column];
                }
                group = subgroup;
            }
            for (const column of columns.slice(1)) {
                subgroup[column.field] = record[column.field];
            }
        }
        const aggs = [];
        for (const index of indexes) {
            if (index in aggregators) {
                if (aggregators[index] instanceof Map) {
                    // when some column names are numeric, need to convert that from a Map to an Object
                    aggs.push(Object.fromEntries(aggregators[index]));
                }
                else {
                    aggs.push(aggregators[index]);
                }
            }
            else {
                aggs.push("sum");
            }
        }
        summarize(grouped, columns, aggs);
        return grouped;
    }
    const timestampSorter = function (a, b, _aRow, _bRow, _column, _dir, _params) {
        // Bokeh/Panel serializes datetime objects as UNIX timestamps (in milliseconds).
        //a, b - the two values being compared
        //aRow, bRow - the row components for the values being compared (useful if you need to access additional fields in the row data for the sort)
        //column - the column component for the column being sorted
        //dir - the direction of the sort ("asc" or "desc")
        //sorterParams - sorterParams object from column definition array
        // Added an _ in front of some parameters as they're unused and the Typescript compiler was complaining about it.
        // const alignEmptyValues = params.alignEmptyValues
        let emptyAlign;
        emptyAlign = 0;
        const opts = { zone: new window.luxon.IANAZone("UTC") };
        if (Number.isNaN(a)) {
            a = window.luxon.DateTime.fromISO("invalid");
        }
        else {
            a = window.luxon.DateTime.fromMillis(a, opts);
        }
        if (Number.isNaN(b)) {
            b = window.luxon.DateTime.fromISO("invalid");
        }
        else {
            b = window.luxon.DateTime.fromMillis(b, opts);
        }
        if (!a.isValid) {
            emptyAlign = !b.isValid ? 0 : -1;
        }
        else if (!b.isValid) {
            emptyAlign = 1;
        }
        else {
            //compare valid values
            return a - b;
        }
        // Invalid (e.g. NaN) always at the bottom
        emptyAlign *= -1;
        return emptyAlign;
    };
    const dateEditor = function (cell, onRendered, success, cancel) {
        //cell - the cell component for the editable cell
        //onRendered - function to call when the editor has been rendered
        //success - function to call to pass the successfully updated value to Tabulator
        //cancel - function to call to abort the edit and return to a normal cell
        //create and style input
        const rawValue = cell.getValue();
        const opts = { zone: new window.luxon.IANAZone("UTC") };
        let cellValue;
        if (rawValue === "NaN" || rawValue === null) {
            cellValue = null;
        }
        else {
            cellValue = window.luxon.DateTime.fromMillis(rawValue, opts).toFormat("yyyy-MM-dd");
        }
        const input = document.createElement("input");
        input.setAttribute("type", "date");
        input.style.padding = "4px";
        input.style.width = "100%";
        input.style.boxSizing = "border-box";
        input.value = cellValue;
        onRendered(() => {
            input.focus();
            input.style.height = "100%";
        });
        function onChange() {
            const new_val = window.luxon.DateTime.fromFormat(input.value, "yyyy-MM-dd", opts).toMillis();
            if (new_val != cellValue) {
                success(new_val);
            }
            else {
                cancel();
            }
        }
        //submit new value on blur or change
        input.addEventListener("blur", onChange);
        //submit new value on enter
        input.addEventListener("keydown", (e) => {
            if (e.key == "Enter") {
                setTimeout(onChange, 100);
            }
            if (e.key == "Escape") {
                setTimeout(cancel, 100);
            }
        });
        return input;
    };
    const datetimeEditor = function (cell, onRendered, success, cancel) {
        //cell - the cell component for the editable cell
        //onRendered - function to call when the editor has been rendered
        //success - function to call to pass the successfully updated value to Tabulator
        //cancel - function to call to abort the edit and return to a normal cell
        //create and style input
        const rawValue = cell.getValue();
        const opts = { zone: new window.luxon.IANAZone("UTC") };
        let cellValue;
        if (rawValue === "NaN" || rawValue === null) {
            cellValue = null;
        }
        else {
            cellValue = window.luxon.DateTime.fromMillis(rawValue, opts).toFormat("yyyy-MM-dd'T'T");
        }
        const input = document.createElement("input");
        input.setAttribute("type", "datetime-local");
        input.style.padding = "4px";
        input.style.width = "100%";
        input.style.boxSizing = "border-box";
        input.value = cellValue;
        onRendered(() => {
            input.focus();
            input.style.height = "100%";
        });
        function onChange() {
            const new_val = window.luxon.DateTime.fromFormat(input.value, "yyyy-MM-dd'T'T", opts).toMillis();
            if (new_val != cellValue) {
                success(new_val);
            }
            else {
                cancel();
            }
        }
        //submit new value on blur or change
        input.addEventListener("blur", onChange);
        //submit new value on enter
        input.addEventListener("keydown", (e) => {
            if (e.key == "Enter") {
                setTimeout(onChange, 100);
            }
            if (e.key == "Escape") {
                setTimeout(cancel, 100);
            }
        });
        return input;
    };
    const nestedEditor = function (cell, editorParams) {
        //cell - the cell component for the editable cell
        const row = cell.getRow().getData();
        let values = editorParams.options;
        for (const i of editorParams.lookup_order) {
            values = row[i] in values ? values[row[i]] : [];
            if (Array.isArray(values)) {
                break;
            }
        }
        return values ? values : [];
    };
    function find_column(group, field) {
        if (group.columns != null) {
            for (const col of group.columns) {
                const found = find_column(col, field);
                if (found) {
                    return found;
                }
            }
        }
        else {
            return group.field === field ? group : null;
        }
    }
    function clone_column(group) {
        if (group.columns == null) {
            return { ...group };
        }
        const group_columns = [];
        for (const col of group.columns) {
            group_columns.push(clone_column(col));
        }
        return { ...group, columns: group_columns };
    }
    class DataTabulatorView extends layout_1.HTMLBoxView {
        constructor() {
            super(...arguments);
            this.columns = new Map();
            this.container = null;
            this._tabulator_cell_updating = false;
            this._updating_page = false;
            this._updating_expanded = false;
            this._updating_sort = false;
            this._updating_page_size = false;
            this._selection_updating = false;
            this._last_selected_row = null;
            this._lastVerticalScrollbarTopPosition = 0;
            this._lastHorizontalScrollbarLeftPosition = 0;
            this._applied_styles = false;
            this._building = false;
            this._redrawing = false;
            this._debounced_redraw = null;
            this._restore_scroll = false;
            this._updating_scroll = false;
            this._is_scrolling = false;
            this._automatic_page_size = false;
        }
        connect_signals() {
            super.connect_signals();
            this._debounced_redraw = (0, debounce_1.debounce)(() => this._resize_redraw(), 20, false);
            const { configuration, layout, columns, groupby, visible, download, children, expanded, cell_styles, hidden_columns, page_size, page, max_page, frozen_rows, sorters, theme_classes, } = this.model.properties;
            this.on_change([configuration, layout, groupby], (0, debounce_1.debounce)(() => {
                this.invalidate_render();
            }, 20, false));
            this.on_change(visible, () => {
                if (this.model.visible) {
                    this.tabulator.element.style.visibility = "visible";
                }
            });
            this.on_change(columns, () => {
                this.tabulator.setColumns(this.getColumns());
                this.setHidden();
            });
            this.on_change(download, () => {
                const ftype = this.model.filename.endsWith(".json") ? "json" : "csv";
                this.tabulator.download(ftype, this.model.filename);
            });
            this.on_change(children, () => this.renderChildren());
            this.on_change(expanded, () => {
                // The first cell is the cell of the frozen _index column.
                for (const row of this.tabulator.rowManager.getRows()) {
                    if (row.cells.length > 0) {
                        row.cells[0].layoutElement();
                    }
                }
                // Make sure the expand icon is changed when expanded is
                // changed from Python.
                for (const row of this.tabulator.rowManager.getRows()) {
                    if (row.cells.length > 0) {
                        const index = row.data._index;
                        const icon = this.model.expanded.includes(index) ? "▼" : "►";
                        row.cells[1].element.innerText = icon;
                    }
                }
                // If content is embedded, views may not have been
                // rendered so if expanded is updated server side
                // we have to trigger a render
                if (this.model.embed_content && !this._updating_expanded) {
                    this.renderChildren();
                }
            });
            this.on_change(cell_styles, () => {
                if (this._applied_styles) {
                    this.tabulator.redraw(true);
                }
                this.setStyles();
            });
            this.on_change(hidden_columns, () => {
                this.setHidden();
                this.tabulator.redraw(true);
            });
            this.on_change(page_size, () => this.setPageSize());
            this.on_change(page, () => {
                if (!this._updating_page) {
                    this.setPage();
                }
            });
            this.on_change(visible, () => this.setVisibility());
            this.on_change(max_page, () => this.setMaxPage());
            this.on_change(frozen_rows, () => this.setFrozen());
            this.on_change(sorters, () => this.setSorters());
            this.on_change(theme_classes, () => this.setCSSClasses(this.tabulator.element));
            this.on_change(this.model.source.properties.data, () => {
                if (this.tabulator === undefined) {
                    return;
                }
                this._restore_scroll = "horizontal";
                this._selection_updating = true;
                this._updating_scroll = true;
                this.setData();
                this._updating_scroll = false;
                this._selection_updating = false;
                this.postUpdate();
            });
            this.connect(this.model.source.streaming, () => this.addData());
            this.connect(this.model.source.patching, () => {
                const inds = this.model.source.selected.indices;
                this._updating_scroll = true;
                this.updateOrAddData();
                this._updating_scroll = false;
                // Restore indices since updating data may have reset checkbox column
                this.model.source.selected.indices = inds;
                this.restore_scroll();
            });
            this.connect(this.model.source.selected.change, () => this.setSelection());
            this.connect(this.model.source.selected.properties.indices.change, () => this.setSelection());
        }
        get groupBy() {
            const groupby = (data) => {
                const groups = [];
                for (const g of this.model.groupby) {
                    const group = `${g}: ${data[g]}`;
                    groups.push(group);
                }
                return groups.join(", ");
            };
            return (this.model.groupby.length > 0) ? groupby : false;
        }
        get sorters() {
            const sorters = [];
            if (this.model.sorters.length > 0) {
                sorters.push({ column: "_index", dir: "asc" });
            }
            for (const sort of this.model.sorters.reverse()) {
                if (sort.column === undefined) {
                    sort.column = sort.field;
                }
                sorters.push(sort);
            }
            return sorters;
        }
        invalidate_render() {
            this.tabulator.destroy();
            this.tabulator = null;
            this.rerender_();
        }
        redraw(columns = true, rows = true) {
            if (this._building || this.tabulator == null || this._redrawing) {
                return;
            }
            this._redrawing = true;
            if (columns && (this.tabulator.columnManager.element != null)) {
                this.tabulator.columnManager.redraw(true);
            }
            if (rows && (this.tabulator.rowManager.renderer != null)) {
                this.tabulator.rowManager.redraw(true);
                this.setStyles();
            }
            this._redrawing = false;
            this._restore_scroll = true;
        }
        get is_drawing() {
            return this._building || this._redrawing || !this.root.has_finished();
        }
        after_layout() {
            super.after_layout();
            if (this.tabulator != null && this._initializing && !this.is_drawing) {
                this._initializing = false;
                this._resize_redraw();
            }
        }
        after_resize() {
            super.after_resize();
            if (!this._is_scrolling && !this._initializing && !this.is_drawing) {
                this._debounced_redraw();
            }
        }
        _resize_redraw() {
            if (this._initializing || !this.container || this._building) {
                return;
            }
            const width = this.container.clientWidth;
            const height = this.container.clientHeight;
            if (!width || !height) {
                return;
            }
            this.redraw(true, true);
            this.restore_scroll();
            this.recompute_page_size();
        }
        stylesheets() {
            return [...super.stylesheets(), tabulator_css_1.default];
        }
        setCSSClasses(el) {
            el.className = "pnx-tabulator tabulator";
            for (const cls of this.model.theme_classes) {
                el.classList.add(cls);
            }
        }
        render() {
            if (this.tabulator != null) {
                this.tabulator.destroy();
            }
            super.render();
            this._initializing = true;
            this._building = true;
            const container = (0, dom_2.div)({ style: { display: "contents" } });
            const el = (0, dom_2.div)({ style: { width: "100%", height: "100%", visibility: "hidden" } });
            this.container = el;
            this.setCSSClasses(el);
            container.appendChild(el);
            this.shadow_el.appendChild(container);
            const configuration = this.getConfiguration();
            this.tabulator = new Tabulator(el, configuration);
            this.watch_stylesheets();
            this.init_callbacks();
        }
        style_redraw() {
            if (this.model.visible) {
                this.tabulator.element.style.visibility = "visible";
            }
            if (!this._initializing && !this._building) {
                this.redraw();
            }
        }
        tableInit() {
            this._building = true;
            // Patch the ajax request and page data parsing methods
            const ajax = this.tabulator.modules.ajax;
            ajax.sendRequest = (_url, params, _config) => {
                return this.requestPage(params.page, params.sort);
            };
            this.tabulator.modules.page._parseRemoteData = () => {
                return false;
            };
        }
        init_callbacks() {
            // Initialization
            this.tabulator.on("tableBuilding", () => this.tableInit());
            this.tabulator.on("tableBuilt", () => this.tableBuilt());
            // Rendering callbacks
            this.tabulator.on("selectableRowsCheck", (row) => {
                const selectable = this.model.selectable_rows;
                return (selectable == null) || selectable.includes(row._row.data._index);
            });
            this.tabulator.on("tooltips", (cell) => {
                return `${cell.getColumn().getField()}: ${cell.getValue()}`;
            });
            this.tabulator.on("scrollVertical", (0, debounce_1.debounce)(() => {
                this.setStyles();
            }, 50, false));
            // Sync state with model
            this.tabulator.on("rowSelectionChanged", (data, rows, selected, deselected) => {
                this.rowSelectionChanged(data, rows, selected, deselected);
            });
            this.tabulator.on("rowClick", (e, row) => this.rowClicked(e, row));
            this.tabulator.on("cellEdited", (cell) => this.cellEdited(cell));
            this.tabulator.on("dataFiltering", (filters) => {
                this.record_scroll();
                this.model.filters = filters;
            });
            this.tabulator.on("dataFiltered", (_, rows) => {
                if (this._building) {
                    return;
                }
                // Ensure that after filtering empty scroll renders
                if (rows.length === 0) {
                    this.tabulator.rowManager.renderEmptyScroll();
                }
                if (this.model.pagination != null) {
                    // Ensure that after filtering the page is updated
                    this.updatePage(this.tabulator.getPage());
                }
            });
            this.tabulator.on("pageLoaded", (pageno) => {
                this.updatePage(pageno);
            });
            this.tabulator.on("renderComplete", () => {
                if (this._building) {
                    return;
                }
                this.postUpdate();
            });
            this.tabulator.on("dataSorting", (sorters) => {
                const sorts = [];
                for (const s of sorters) {
                    if (s.field !== "_index") {
                        sorts.push({ field: s.field, dir: s.dir });
                    }
                }
                if (this.model.pagination !== "remote") {
                    this._updating_sort = true;
                    this.model.sorters = sorts.reverse();
                    this._updating_sort = false;
                }
            });
        }
        tableBuilt() {
            this.setSelection();
            this.renderChildren();
            this.setStyles();
            // Track scrolling position and active scroll
            const holder = this.shadow_el.querySelector(".tabulator-tableholder");
            let scroll_timeout;
            if (holder) {
                holder.addEventListener("scroll", () => {
                    this.record_scroll();
                    this._is_scrolling = true;
                    clearTimeout(scroll_timeout);
                    scroll_timeout = setTimeout(() => {
                        this._is_scrolling = false;
                    }, 200);
                });
            }
            if (this.model.pagination) {
                this.setMaxPage();
                this.tabulator.setPage(this.model.page);
            }
            this._building = false;
            (0, util_1.schedule_when)(() => {
                const initializing = this._initializing;
                this._initializing = false;
                if (initializing) {
                    this._resize_redraw();
                }
            }, () => this.root.has_finished() && [...this._initialized_stylesheets.values()].every(v => v));
        }
        recompute_page_size() {
            if (!this.model.pagination || this.model.page_size !== null || this._automatic_page_size) {
                return;
            }
            this._automatic_page_size = true;
            const responsive = this.model.sizing_mode && (this.model.sizing_mode.includes("height") || this.model.sizing_mode.includes("both"));
            const holder = this.shadow_el.querySelector(".tabulator-tableholder");
            const table = this.shadow_el.querySelector(".tabulator-table");
            if (table != null && holder != null) {
                const table_height = holder.clientHeight;
                let height = 0;
                let page_size = null;
                const heights = [];
                for (let i = 0; i < table.children.length; i++) {
                    const row_height = table.children[i].clientHeight;
                    heights.push(row_height);
                    height += row_height;
                    if (height > table_height) {
                        page_size = i;
                        if (responsive) {
                            page_size -= 1;
                        }
                        break;
                    }
                }
                if (height < table_height) {
                    page_size = table.children.length;
                    const remaining = table_height - height;
                    page_size += Math.floor(remaining / Math.min(...heights));
                    if (responsive) {
                        page_size -= 2;
                    }
                }
                this._updating_page_size = true;
                try {
                    this.model.page_size = Math.max(page_size || 1, 1);
                }
                finally {
                    this._updating_page_size = false;
                }
            }
        }
        requestPage(page, sorters) {
            return new Promise((resolve, reject) => {
                try {
                    if (page != null && sorters != null) {
                        this._updating_sort = true;
                        const sorts = [];
                        for (const s of sorters) {
                            if (s.field !== "_index") {
                                sorts.push({ field: s.field, dir: s.dir });
                            }
                        }
                        this.model.sorters = sorts;
                        this._updating_sort = false;
                        this._updating_page = true;
                        try {
                            this.model.page = page || 1;
                        }
                        finally {
                            this._updating_page = false;
                        }
                    }
                    resolve([]);
                }
                catch (err) {
                    reject(err);
                }
            });
        }
        getLayout() {
            const layout = this.model.layout;
            switch (layout) {
                case "fit_data":
                    return "fitData";
                case "fit_data_fill":
                    return "fitDataFill";
                case "fit_data_stretch":
                    return "fitDataStretch";
                case "fit_data_table":
                    return "fitDataTable";
                case "fit_columns":
                    return "fitColumns";
            }
        }
        getConfiguration() {
            // Only use selectable mode if explicitly requested otherwise manually handle selections
            const selectableRows = this.model.select_mode === "toggle" ? true : NaN;
            const configuration = {
                ...this.model.configuration,
                index: "_index",
                nestedFieldSeparator: false,
                movableColumns: false,
                selectableRows,
                columns: this.getColumns(),
                initialSort: this.sorters,
                layout: this.getLayout(),
                pagination: this.model.pagination != null,
                paginationMode: this.model.pagination,
                paginationSize: this.model.page_size || 20,
                paginationInitialPage: 1,
                groupBy: this.groupBy,
                frozenRows: (row) => {
                    return (this.model.frozen_rows.length > 0) ? this.model.frozen_rows.includes(row._row.data._index) : false;
                },
                rowFormatter: (row) => this._render_row(row, false),
            };
            if (this.model.max_height != null) {
                configuration.maxHeight = this.model.max_height;
            }
            if (this.model.pagination === "remote") {
                configuration.ajaxURL = "http://panel.pyviz.org";
                configuration.sortMode = "remote";
            }
            const data = this.getData();
            return {
                ...configuration,
                data,
            };
        }
        get_child(idx) {
            if (this.model.children instanceof Map) {
                return this.model.children.get(idx) || null;
            }
            return null;
        }
        get child_models() {
            const children = [];
            for (const idx of this.model.expanded) {
                const child = this.get_child(idx);
                if (child != null) {
                    children.push(child);
                }
            }
            return children;
        }
        get row_index() {
            const rows = this.tabulator.getRows();
            const lookup = new Map();
            for (const row of rows) {
                const index = row._row?.data._index;
                if (index != null) {
                    lookup.set(index, row);
                }
            }
            return lookup;
        }
        renderChildren() {
            void new Promise(async () => {
                await this.build_child_views();
                const lookup = this.row_index;
                const expanded = this.model.expanded;
                for (const index of expanded) {
                    const model = this.get_child(index);
                    const row = lookup.get(index);
                    const view = model == null ? null : this._child_views.get(model);
                    if (view != null) {
                        this._render_row(row, index === expanded[expanded.length - 1]);
                    }
                }
            });
        }
        _render_row(row, resize = true) {
            const index = row._row?.data._index;
            if (!this.model.expanded.includes(index)) {
                return;
            }
            const model = this.get_child(index);
            const view = model == null ? null : this._child_views.get(model);
            if (view == null) {
                return;
            }
            (0, util_1.schedule_when)(() => {
                const rowEl = row.getElement();
                const style = getComputedStyle(this.tabulator.element.children[1].children[0]);
                const bg = style.backgroundColor;
                const neg_margin = rowEl.style.paddingLeft ? `-${rowEl.style.paddingLeft}` : "0";
                const prev_child = rowEl.children[rowEl.children.length - 1];
                let viewEl;
                if (prev_child != null && prev_child.className == "row-content") {
                    viewEl = prev_child;
                    if (viewEl.children.length && viewEl.children[0] === view.el) {
                        return;
                    }
                }
                else {
                    viewEl = (0, dom_2.div)({ class: "row-content", style: { background_color: bg, margin_left: neg_margin, max_width: "100%", overflow_x: "hidden" } });
                    rowEl.appendChild(viewEl);
                }
                (0, dom_1.display)(view.el);
                viewEl.appendChild(view.el);
                if (view.shadow_el.children.length === 0) {
                    this.rerender_(view);
                }
                if (resize) {
                    this._update_children();
                    this.resize_table();
                }
            }, () => this.root.has_finished());
        }
        resize_table() {
            if (this.tabulator.rowManager.renderer != null) {
                try {
                    this.tabulator.rowManager.adjustTableSize();
                }
                catch (e) { }
            }
            this.invalidate_layout();
        }
        _expand_render(cell) {
            const index = cell._cell.row.data._index;
            const icon = this.model.expanded.indexOf(index) < 0 ? "►" : "▼";
            return icon;
        }
        _update_expand(cell) {
            const index = cell._cell.row.data._index;
            const expanded = [...this.model.expanded];
            if (!expanded.includes(index)) {
                expanded.push(index);
            }
            else {
                const exp_index = expanded.indexOf(index);
                const removed = expanded.splice(exp_index, 1)[0];
                const model = this.get_child(removed);
                if (model != null) {
                    const view = this._child_views.get(model);
                    if (view !== undefined && view.el != null) {
                        (0, dom_1.undisplay)(view.el);
                    }
                }
            }
            this._updating_expanded = true;
            this.model.expanded = expanded;
            this._updating_expanded = false;
            if (!expanded.includes(index)) {
                return;
            }
            let ready = true;
            for (const idx of this.model.expanded) {
                if (this.get_child(idx) == null) {
                    ready = false;
                    break;
                }
            }
            if (ready) {
                this.renderChildren();
            }
        }
        getData() {
            const cds = this.model.source;
            let data;
            if (cds === null || (cds.columns().length === 0)) {
                data = [];
            }
            else {
                data = (0, data_1.transform_cds_to_records)(cds, true);
            }
            if (this.model.configuration.dataTree) {
                data = group_data(data, this.model.columns, this.model.indexes, this.model.aggregators);
            }
            return data;
        }
        getColumns() {
            this.columns = new Map();
            const config_columns = this.model.configuration?.columns;
            const columns = [];
            columns.push({ field: "_index", frozen: true, visible: false });
            if (config_columns != null) {
                for (const column of config_columns) {
                    const new_column = clone_column(column);
                    if (column.formatter === "expand") {
                        const expand = {
                            hozAlign: "center",
                            cellClick: (_, cell) => {
                                this._update_expand(cell);
                            },
                            formatter: (cell) => {
                                return this._expand_render(cell);
                            },
                            width: 40,
                            frozen: true,
                        };
                        columns.push(expand);
                    }
                    else {
                        if (new_column.formatter === "rowSelection") {
                            new_column.cellClick = (_, cell) => {
                                cell.getRow().toggleSelect();
                            };
                        }
                        columns.push(new_column);
                    }
                }
            }
            for (const column of this.model.columns) {
                let tab_column = null;
                if (config_columns != null) {
                    for (const col of columns) {
                        tab_column = find_column(col, column.field);
                        if (tab_column != null) {
                            break;
                        }
                    }
                }
                if (tab_column == null) {
                    tab_column = { field: column.field };
                }
                this.columns.set(column.field, tab_column);
                if (tab_column.title == null) {
                    tab_column.title = column.title;
                }
                if (tab_column.headerTooltip === undefined) {
                    tab_column.headerTooltip = true;
                }
                if (tab_column.width == null && column.width != null && column.width != 0) {
                    tab_column.width = column.width;
                }
                if (tab_column.formatter == null && column.formatter != null) {
                    const formatter = column.formatter;
                    const ftype = formatter.type;
                    if (ftype === "BooleanFormatter") {
                        tab_column.formatter = "tickCross";
                    }
                    else {
                        tab_column.formatter = (cell) => {
                            const row = cell.getRow();
                            const formatted = column.formatter.doFormat(cell.getRow(), cell, cell.getValue(), null, row.getData());
                            if (column.formatter.type === "HTMLTemplateFormatter") {
                                return formatted;
                            }
                            const node = (0, dom_2.div)();
                            node.innerHTML = formatted;
                            const child = node.children[0];
                            if (child.innerHTML === "function(){return c.convert(arguments)}") { // If the formatter fails
                                return "";
                            }
                            return child;
                        };
                    }
                }
                if (tab_column.sorter == "timestamp") {
                    tab_column.sorter = timestampSorter;
                }
                if (tab_column.sorter === undefined) {
                    tab_column.sorter = "string";
                }
                const editor = column.editor;
                const ctype = editor.type;
                if (tab_column.editor != null) {
                    if (tab_column.editor === "date") {
                        tab_column.editor = dateEditor;
                    }
                    else if (tab_column.editor === "datetime") {
                        tab_column.editor = datetimeEditor;
                    }
                    else if (tab_column.editor === "nested") {
                        tab_column.editorParams.valuesLookup = (cell) => {
                            return nestedEditor(cell, tab_column.editorParams);
                        };
                        tab_column.editor = "list";
                    }
                }
                else if (ctype === "StringEditor") {
                    if (editor.completions.length > 0) {
                        tab_column.editor = "list";
                        tab_column.editorParams = { values: editor.completions, autocomplete: true, listOnEmpty: true };
                    }
                    else {
                        tab_column.editor = "input";
                    }
                }
                else if (ctype === "TextEditor") {
                    tab_column.editor = "textarea";
                }
                else if (ctype === "IntEditor" || ctype === "NumberEditor") {
                    tab_column.editor = "number";
                    tab_column.editorParams = { step: editor.step };
                    if (ctype === "IntEditor") {
                        tab_column.validator = "integer";
                    }
                    else {
                        tab_column.validator = "numeric";
                    }
                }
                else if (ctype === "CheckboxEditor") {
                    tab_column.editor = "tickCross";
                }
                else if (ctype === "DateEditor") {
                    tab_column.editor = dateEditor;
                }
                else if (ctype === "SelectEditor") {
                    tab_column.editor = "list";
                    tab_column.editorParams = { values: editor.options };
                }
                else if (editor != null && editor.default_view != null) {
                    tab_column.editor = (cell, onRendered, success, cancel) => {
                        this.renderEditor(column, cell, onRendered, success, cancel);
                    };
                }
                tab_column.visible = (tab_column.visible != false && !this.model.hidden_columns.includes(column.field));
                tab_column.editable = () => (this.model.editable && (editor.default_view != null));
                if (tab_column.headerFilter) {
                    if ((0, types_1.isBoolean)(tab_column.headerFilter) && (0, types_1.isString)(tab_column.editor)) {
                        tab_column.headerFilter = tab_column.editor;
                        tab_column.headerFilterParams = tab_column.editorParams;
                    }
                }
                for (const sort of this.model.sorters) {
                    if (tab_column.field === sort.field) {
                        tab_column.headerSortStartingDir = sort.dir;
                    }
                }
                tab_column.cellClick = (_, cell) => {
                    const index = cell.getData()._index;
                    const event = new CellClickEvent(column.field, index);
                    this.model.trigger_event(event);
                };
                if (config_columns == null) {
                    columns.push(tab_column);
                }
            }
            for (const col in this.model.buttons) {
                const button_formatter = () => {
                    return this.model.buttons[col];
                };
                const button_column = {
                    formatter: button_formatter,
                    hozAlign: "center",
                    cellClick: (_, cell) => {
                        const index = cell.getData()._index;
                        const event = new CellClickEvent(col, index);
                        this.model.trigger_event(event);
                    },
                };
                columns.push(button_column);
            }
            return columns;
        }
        renderEditor(column, cell, onRendered, success, cancel) {
            const editor = column.editor;
            const view = new editor.default_view({ column, model: editor, parent: this, container: cell._cell.element });
            view.initialize();
            view.connect_signals();
            onRendered(() => {
                view.setValue(cell.getValue());
            });
            view.inputEl.addEventListener("input", () => {
                const value = view.serializeValue();
                const old_value = cell.getValue();
                const validation = view.validate();
                if (!validation.valid) {
                    cancel(validation.msg);
                }
                if (old_value != null && typeof value != typeof old_value) {
                    cancel("Mismatching type");
                }
                else {
                    success(view.serializeValue());
                }
            });
            return view.inputEl;
        }
        // Update table
        setData() {
            if (this._initializing || this._building || !this.tabulator.initialized) {
                return Promise.resolve(undefined);
            }
            const data = this.getData();
            if (this.model.pagination != null) {
                return this.tabulator.rowManager.setData(data, true, false);
            }
            else {
                return this.tabulator.setData(data);
            }
        }
        addData() {
            const rows = this.tabulator.rowManager.getRows();
            const last_row = rows[rows.length - 1];
            const start = ((last_row?.data._index) || 0);
            this._updating_page = true;
            const promise = this.setData();
            if (this.model.follow) {
                promise.then(() => {
                    if (this.model.pagination) {
                        this.tabulator.setPage(Math.ceil(this.tabulator.rowManager.getDataCount() / (this.model.page_size || 20)));
                    }
                    if (last_row) {
                        this.tabulator.scrollToRow(start, "top", false);
                    }
                    this._updating_page = false;
                });
            }
            else {
                this._updating_page = true;
            }
        }
        postUpdate() {
            this.setSelection();
            this.setStyles();
            if (this._restore_scroll) {
                const vertical = this._restore_scroll === "horizontal" ? false : true;
                const horizontal = this._restore_scroll === "vertical" ? false : true;
                this.restore_scroll(horizontal, vertical);
                this._restore_scroll = false;
            }
        }
        updateOrAddData() {
            // To avoid double updating the tabulator data
            if (this._tabulator_cell_updating) {
                return;
            }
            // Temporarily set minHeight to avoid "scroll-to-top" issues caused
            // by Tabulator JS entirely destroying the table when .setData is called.
            // Inspired by https://github.com/olifolkerd/tabulator/issues/4155
            const prev_minheight = this.tabulator.element.style.minHeight;
            this.tabulator.element.style.minHeight = `${this.tabulator.element.offsetHeight}px`;
            const data = (0, data_1.transform_cds_to_records)(this.model.source, true);
            this.tabulator.setData(data).then(() => {
                this.tabulator.element.style.minHeight = prev_minheight;
            });
        }
        setFrozen() {
            for (const row of this.model.frozen_rows) {
                this.tabulator.getRow(row).freeze();
            }
        }
        setVisibility() {
            if (this.tabulator == null) {
                return;
            }
            this.tabulator.element.style.visibility = this.model.visible ? "visible" : "hidden";
        }
        updatePage(pageno) {
            if (this.model.pagination === "local" && this.model.page !== pageno && !this._updating_page) {
                this._updating_page = true;
                this.model.page = pageno;
                this._updating_page = false;
                this.setStyles();
            }
        }
        setGroupBy() {
            this.tabulator.setGroupBy(this.groupBy);
        }
        setSorters() {
            if (this._updating_sort) {
                return;
            }
            this.tabulator.setSort(this.sorters);
        }
        setStyles() {
            const style_data = this.model.cell_styles.data;
            if (this.tabulator == null || this.tabulator.getDataCount() == 0 || style_data == null || !style_data.size) {
                return;
            }
            this._applied_styles = false;
            for (const r of style_data.keys()) {
                const row_style = style_data.get(r);
                const row = this.tabulator.getRow(r);
                if (!row) {
                    continue;
                }
                const cells = row._row.cells;
                for (const c of row_style.keys()) {
                    const style = row_style.get(c);
                    const cell = cells[c];
                    if (cell == null || !style.length) {
                        continue;
                    }
                    const element = cell.element;
                    for (const s of style) {
                        let prop, value;
                        if ((0, types_1.isArray)(s)) {
                            [prop, value] = s;
                        }
                        else if (!s.includes(":")) {
                            continue;
                        }
                        else {
                            [prop, value] = s.split(":");
                        }
                        element.style.setProperty(prop, value.trimLeft());
                        this._applied_styles = true;
                    }
                }
            }
        }
        setHidden() {
            for (const column of this.tabulator.getColumns()) {
                const col = column._column;
                if ((col.field == "_index") || this.model.hidden_columns.includes(col.field)) {
                    column.hide();
                }
                else {
                    column.show();
                }
            }
        }
        setMaxPage() {
            this.tabulator.setMaxPage(this.model.max_page);
            if (this.tabulator.modules.page.pagesElement) {
                this.tabulator.modules.page._setPageButtons();
            }
        }
        setPage() {
            this.tabulator.setPage(Math.min(this.model.max_page, this.model.page));
            if (this.model.pagination === "local") {
                this.setStyles();
            }
        }
        setPageSize() {
            if (!this._updating_page_size) {
                this._automatic_page_size = false;
            }
            this.tabulator.setPageSize(this.model.page_size);
            if (this.model.pagination === "local") {
                this.setStyles();
            }
        }
        setSelection() {
            if (this.tabulator == null || this._initializing || this._selection_updating || !this.tabulator.initialized) {
                return;
            }
            const indices = this.model.source.selected.indices;
            const current_indices = this.tabulator.getSelectedData().map((row) => row._index);
            if (JSON.stringify(indices) == JSON.stringify(current_indices)) {
                return;
            }
            this._selection_updating = true;
            this.tabulator.deselectRow();
            this.tabulator.selectRow(indices);
            for (const index of indices) {
                const row = this.tabulator.rowManager.findRow(index);
                if (row) {
                    this.tabulator.scrollToRow(index, "center", false).catch(() => { });
                }
            }
            this._selection_updating = false;
        }
        restore_scroll(horizontal = true, vertical = true) {
            if (!(horizontal || vertical)) {
                return;
            }
            const opts = { behavior: "instant" };
            if (vertical) {
                opts.top = this._lastVerticalScrollbarTopPosition;
            }
            if (horizontal) {
                opts.left = this._lastHorizontalScrollbarLeftPosition;
            }
            setTimeout(() => {
                this._updating_scroll = true;
                this.tabulator.rowManager.element.scrollTo(opts);
                this._updating_scroll = false;
            }, 0);
        }
        // Update model
        record_scroll() {
            if (this._updating_scroll) {
                return;
            }
            this._lastVerticalScrollbarTopPosition = this.tabulator.rowManager.element.scrollTop;
            this._lastHorizontalScrollbarLeftPosition = this.tabulator.rowManager.element.scrollLeft;
        }
        rowClicked(e, row) {
            if (this._selection_updating ||
                this._initializing ||
                (0, types_1.isString)(this.model.select_mode) ||
                this.model.select_mode === false || // selection disabled
                this.model.configuration.dataTree || // dataTree does not support selection
                e.srcElement?.innerText === "►" // expand button
            ) {
                return;
            }
            let indices = [];
            const selected = this.model.source.selected;
            const index = row._row.data._index;
            if (e.ctrlKey || e.metaKey) {
                indices = [...selected.indices];
            }
            else if (e.shiftKey && this._last_selected_row) {
                const rows = row._row.parent.getDisplayRows();
                const start_idx = rows.indexOf(this._last_selected_row);
                if (start_idx !== -1) {
                    const end_idx = rows.indexOf(row._row);
                    const reverse = start_idx > end_idx;
                    const [start, end] = reverse ? [end_idx + 1, start_idx + 1] : [start_idx, end_idx];
                    indices = rows.slice(start, end).map((r) => r.data._index);
                    if (reverse) {
                        indices = indices.reverse();
                    }
                }
            }
            const flush = !(e.ctrlKey || e.metaKey || e.shiftKey);
            const includes = indices.includes(index);
            const remote = this.model.pagination === "remote";
            // Toggle the index on or off (if remote we let Python do the toggling)
            if (!includes || remote) {
                indices.push(index);
            }
            else {
                indices.splice(indices.indexOf(index), 1);
            }
            // Remove the first selected indices when selectable is an int.
            if ((0, types_1.isNumber)(this.model.select_mode)) {
                while (indices.length > this.model.select_mode) {
                    indices.shift();
                }
            }
            const filtered = this._filter_selected(indices);
            if (!remote) {
                this.tabulator.deselectRow();
                this.tabulator.selectRow(filtered);
            }
            this._last_selected_row = row._row;
            this._selection_updating = true;
            if (!remote) {
                selected.indices = filtered;
            }
            this.model.trigger_event(new SelectionEvent(indices, !includes, flush));
            this._selection_updating = false;
        }
        _filter_selected(indices) {
            const filtered = [];
            for (const ind of indices) {
                if (this.model.selectable_rows == null ||
                    this.model.selectable_rows.indexOf(ind) >= 0) {
                    filtered.push(ind);
                }
            }
            return filtered;
        }
        rowSelectionChanged(data, _row, selected, deselected) {
            if (this._selection_updating ||
                this._initializing ||
                (0, types_1.isBoolean)(this.model.select_mode) ||
                (0, types_1.isNumber)(this.model.select_mode) ||
                this.model.configuration.dataTree) {
                return;
            }
            if (this.model.pagination === "remote") {
                const selected_indices = selected.map((x) => x._row.data._index);
                const deselected_indices = deselected.map((x) => x._row.data._index);
                if (selected_indices.length > 0) {
                    this._selection_updating = true;
                    this.model.trigger_event(new SelectionEvent(selected_indices, true, false));
                }
                if (deselected_indices.length > 0) {
                    this._selection_updating = true;
                    this.model.trigger_event(new SelectionEvent(deselected_indices, false, false));
                }
            }
            else {
                const indices = data.map((row) => row._index);
                const filtered = this._filter_selected(indices);
                this._selection_updating = indices.length === filtered.length;
                this.model.source.selected.indices = filtered;
            }
            this._selection_updating = false;
        }
        cellEdited(cell) {
            const field = cell._cell.column.field;
            const column_def = this.columns.get(field);
            const index = cell.getData()._index;
            const value = cell._cell.value;
            if (column_def.validator === "numeric" && value === "") {
                cell.setValue(NaN, true);
                return;
            }
            this._tabulator_cell_updating = true;
            comm_manager_1.comm_settings.debounce = false;
            this.model.trigger_event(new TableEditEvent(field, index, true));
            try {
                this.model.source.patch({ [field]: [[index, value]] });
            }
            finally {
                comm_manager_1.comm_settings.debounce = true;
                this._tabulator_cell_updating = false;
            }
            this.model.trigger_event(new TableEditEvent(field, index, false));
            this.tabulator.scrollToRow(index, "top", false);
        }
    }
    exports.DataTabulatorView = DataTabulatorView;
    DataTabulatorView.__name__ = "DataTabulatorView";
    exports.TableLayout = (0, kinds_1.Enum)("fit_data", "fit_data_fill", "fit_data_stretch", "fit_data_table", "fit_columns");
    // The Bokeh .ts model corresponding to the Bokeh .py model
    class DataTabulator extends layout_1.HTMLBox {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataTabulator = DataTabulator;
    _d = DataTabulator;
    DataTabulator.__name__ = "DataTabulator";
    DataTabulator.__module__ = "panel.models.tabulator";
    (() => {
        _d.prototype.default_view = DataTabulatorView;
        _d.define(({ Any, List, Bool, Nullable, Float, Ref, Str }) => ({
            aggregators: [Any, {}],
            buttons: [Any, {}],
            children: [Any, new Map()],
            configuration: [Any, {}],
            columns: [List(Ref(tables_1.TableColumn)), []],
            download: [Bool, false],
            editable: [Bool, true],
            embed_content: [Bool, false],
            expanded: [List(Float), []],
            filename: [Str, "table.csv"],
            filters: [List(Any), []],
            follow: [Bool, true],
            frozen_rows: [List(Float), []],
            groupby: [List(Str), []],
            hidden_columns: [List(Str), []],
            indexes: [List(Str), []],
            layout: [exports.TableLayout, "fit_data"],
            max_page: [Float, 0],
            pagination: [Nullable(Str), null],
            page: [Float, 0],
            page_size: [Nullable(Float), null],
            select_mode: [Any, true],
            selectable_rows: [Nullable(List(Float)), null],
            source: [Ref(column_data_source_1.ColumnDataSource)],
            sorters: [List(Any), []],
            cell_styles: [Any, {}],
            theme_classes: [List(Str), []],
        }));
    })();
},
"99a25e6992": /* debounce\index.js */ function _(require, module, exports, __esModule, __esExport) {
    /**
     * Returns a function, that, as long as it continues to be invoked, will not
     * be triggered. The function will be called after it stops being called for
     * N milliseconds. If `immediate` is passed, trigger the function on the
     * leading edge, instead of the trailing. The function also has a property 'clear'
     * that is a function which will clear the timer to prevent previously scheduled executions.
     *
     * @source underscore.js
     * @see http://unscriptable.com/2009/03/20/debouncing-javascript-methods/
     * @param {Function} function to wrap
     * @param {Number} timeout in ms (`100`)
     * @param {Boolean} whether to execute at the beginning (`false`)
     * @api public
     */
    function debounce(func, wait, immediate) {
        var timeout, args, context, timestamp, result;
        if (null == wait)
            wait = 100;
        function later() {
            var last = Date.now() - timestamp;
            if (last < wait && last >= 0) {
                timeout = setTimeout(later, wait - last);
            }
            else {
                timeout = null;
                if (!immediate) {
                    result = func.apply(context, args);
                    context = args = null;
                }
            }
        }
        ;
        var debounced = function () {
            context = this;
            args = arguments;
            timestamp = Date.now();
            var callNow = immediate && !timeout;
            if (!timeout)
                timeout = setTimeout(later, wait);
            if (callNow) {
                result = func.apply(context, args);
                context = args = null;
            }
            return result;
        };
        debounced.clear = function () {
            if (timeout) {
                clearTimeout(timeout);
                timeout = null;
            }
        };
        debounced.flush = function () {
            if (timeout) {
                result = func.apply(context, args);
                context = args = null;
                clearTimeout(timeout);
                timeout = null;
            }
        };
        return debounced;
    }
    ;
    // Adds compatibility for ES modules
    debounce.debounce = debounce;
    module.exports = debounce;
},
"be689f0377": /* models\data.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.transform_cds_to_records = transform_cds_to_records;
    exports.dict_to_records = dict_to_records;
    const types_1 = require("@bokehjs/core/util/types");
    function transform_cds_to_records(cds, addId = false, start = 0) {
        const data = [];
        const columns = cds.columns();
        const cdsLength = cds.get_length();
        if (columns.length === 0 || cdsLength === null) {
            return [];
        }
        for (let i = start; i < cdsLength; i++) {
            const item = {};
            for (const column of columns) {
                const array = cds.get_array(column);
                const shape = (array[0] == null || array[0].shape == null) ? null : array[0].shape;
                if (shape != null && shape.length > 1 && (0, types_1.isNumber)(shape[0])) {
                    item[column] = array.slice(i * shape[1], i * shape[1] + shape[1]);
                }
                else if (array.length != cdsLength && (array.length % cdsLength === 0)) {
                    const offset = array.length / cdsLength;
                    item[column] = array.slice(i * offset, i * offset + offset);
                }
                else {
                    item[column] = array[i];
                }
            }
            if (addId) {
                item._index = i;
            }
            data.push(item);
        }
        return data;
    }
    function dict_to_records(data, index = true) {
        const records = [];
        for (let i = 0; i < data.index.length; i++) {
            const record = {};
            for (const col of data) {
                if (index || col !== "index") {
                    record[col] = data[col][i];
                }
            }
        }
        return records;
    }
},
"b0e650c65c": /* styles\models\tabulator.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.panel_models_markup_HTML = "bk-panel-models-markup-HTML";
    exports.default = `.tabulator-table{max-width:max-content;}.tabulator-table .tabulator-row .row-content .bk-panel-models-markup-HTML{white-space:normal;}`;
},
"100965d6f3": /* models\datetime_picker.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require("tslib");
    const flatpickr_1 = tslib_1.__importDefault(require("1156ddcec2") /* flatpickr */);
    const input_widget_1 = require("@bokehjs/models/widgets/input_widget");
    const dom_1 = require("@bokehjs/core/dom");
    const enums_1 = require("@bokehjs/core/enums");
    const types_1 = require("@bokehjs/core/util/types");
    const inputs = tslib_1.__importStar(require("@bokehjs/styles/widgets/inputs.css"));
    const flatpickr_css_1 = tslib_1.__importDefault(require("@bokehjs/styles/widgets/flatpickr.css"));
    function _convert_date_list(value) {
        const result = [];
        for (const item of value) {
            if ((0, types_1.isString)(item)) {
                result.push(item);
            }
            else {
                const [from, to] = item;
                result.push({ from, to });
            }
        }
        return result;
    }
    class DatetimePickerView extends input_widget_1.InputWidgetView {
        connect_signals() {
            super.connect_signals();
            const { value, min_date, max_date, disabled_dates, enabled_dates, inline, enable_time, enable_seconds, military_time, date_format, mode, } = this.model.properties;
            this.on_change(value, () => this.model.value ? this._picker?.setDate(this.model.value) : this._clear());
            this.on_change(min_date, () => this._picker?.set("minDate", this.model.min_date));
            this.on_change(max_date, () => this._picker?.set("maxDate", this.model.max_date));
            this.on_change(disabled_dates, () => {
                const { disabled_dates } = this.model;
                this._picker?.set("disable", disabled_dates != null ? _convert_date_list(disabled_dates) : []);
            });
            this.on_change(enabled_dates, () => {
                const { enabled_dates } = this.model;
                if (enabled_dates != null) {
                    this._picker?.set("enable", _convert_date_list(enabled_dates));
                }
                else {
                    // this reimplements `set()` for the `undefined` case
                    if (this._picker) {
                        this._picker.config._enable = undefined;
                        this._picker.redraw();
                        this._picker.updateValue(true);
                    }
                }
            });
            this.on_change(inline, () => this._picker?.set("inline", this.model.inline));
            this.on_change(enable_time, () => this._picker?.set("enableTime", this.model.enable_time));
            this.on_change(enable_seconds, () => this._picker?.set("enableSeconds", this.model.enable_seconds));
            this.on_change(military_time, () => this._picker?.set("time_24hr", this.model.military_time));
            this.on_change(mode, () => this._picker?.set("mode", this.model.mode));
            this.on_change(date_format, () => this._picker?.set("dateFormat", this.model.date_format));
        }
        remove() {
            this._picker?.destroy();
            super.remove();
        }
        stylesheets() {
            return [...super.stylesheets(), flatpickr_css_1.default];
        }
        _render_input() {
            return this.input_el = (0, dom_1.input)({ type: "text", class: inputs.input, disabled: this.model.disabled });
        }
        render() {
            if (this._picker != null) {
                return;
            }
            super.render();
            const options = {
                allowInput: this.model.allow_input,
                appendTo: this.group_el,
                positionElement: this.input_el,
                defaultDate: this.model.value,
                inline: this.model.inline,
                position: this._position.bind(this),
                enableTime: this.model.enable_time,
                enableSeconds: this.model.enable_seconds,
                time_24hr: this.model.military_time,
                dateFormat: this.model.date_format,
                mode: this.model.mode,
                onClose: (selected_dates, date_string, instance) => this._on_close(selected_dates, date_string, instance),
            };
            const { min_date, max_date, disabled_dates, enabled_dates } = this.model;
            if (min_date != null) {
                options.minDate = min_date;
            }
            if (max_date != null) {
                options.maxDate = max_date;
            }
            if (disabled_dates != null) {
                options.disable = _convert_date_list(disabled_dates);
            }
            if (enabled_dates != null) {
                options.enable = _convert_date_list(enabled_dates);
            }
            this._picker = (0, flatpickr_1.default)(this.input_el, options);
            this._picker.maxDateHasTime = true;
            this._picker.minDateHasTime = true;
        }
        _clear() {
            this._picker?.clear();
            this.model.value = null;
        }
        _on_close(_selected_dates, date_string, _instance) {
            if (this.model.mode == "range" && !date_string.includes("to")) {
                return;
            }
            this.model.value = date_string;
            this.change_input();
        }
        _position(self, custom_el) {
            // This function is copied directly from bokehs date_picker
            const positionElement = custom_el ?? self._positionElement;
            const calendarHeight = [...self.calendarContainer.children].reduce((acc, child) => acc + (0, dom_1.bounding_box)(child).height, 0);
            const calendarWidth = self.calendarContainer.offsetWidth;
            const configPos = this.model.position.split(" ");
            const configPosVertical = configPos[0];
            const configPosHorizontal = configPos.length > 1 ? configPos[1] : null;
            // const inputBounds = positionElement.getBoundingClientRect()
            const inputBounds = {
                top: positionElement.offsetTop,
                bottom: positionElement.offsetTop + positionElement.offsetHeight,
                left: positionElement.offsetLeft,
                right: positionElement.offsetLeft + positionElement.offsetWidth,
                width: positionElement.offsetWidth,
            };
            const distanceFromBottom = window.innerHeight - inputBounds.bottom;
            const showOnTop = configPosVertical === "above" ||
                (configPosVertical !== "below" &&
                    distanceFromBottom < calendarHeight &&
                    inputBounds.top > calendarHeight);
            // const top =
            //   window.scrollY +
            //   inputBounds.top +
            //   (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2)
            const top = self.config.appendTo
                ? inputBounds.top +
                    (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2)
                : window.scrollY +
                    inputBounds.top +
                    (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);
            self.calendarContainer.classList.toggle("arrowTop", !showOnTop);
            self.calendarContainer.classList.toggle("arrowBottom", showOnTop);
            if (self.config.inline) {
                return;
            }
            let left = window.scrollX + inputBounds.left;
            let isCenter = false;
            let isRight = false;
            if (configPosHorizontal === "center") {
                left -= (calendarWidth - inputBounds.width) / 2;
                isCenter = true;
            }
            else if (configPosHorizontal === "right") {
                left -= calendarWidth - inputBounds.width;
                isRight = true;
            }
            self.calendarContainer.classList.toggle("arrowLeft", !isCenter && !isRight);
            self.calendarContainer.classList.toggle("arrowCenter", isCenter);
            self.calendarContainer.classList.toggle("arrowRight", isRight);
            const right = window.document.body.offsetWidth -
                (window.scrollX + inputBounds.right);
            const rightMost = left + calendarWidth > window.document.body.offsetWidth;
            const centerMost = right + calendarWidth > window.document.body.offsetWidth;
            self.calendarContainer.classList.toggle("rightMost", rightMost);
            if (self.config.static) {
                return;
            }
            self.calendarContainer.style.top = `${top}px`;
            if (!rightMost) {
                self.calendarContainer.style.left = `${left}px`;
                self.calendarContainer.style.right = "auto";
            }
            else if (!centerMost) {
                self.calendarContainer.style.left = "auto";
                self.calendarContainer.style.right = `${right}px`;
            }
            else {
                const css = this.shadow_el.styleSheets[0];
                const bodyWidth = window.document.body.offsetWidth;
                const centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);
                const centerBefore = ".flatpickr-calendar.centerMost:before";
                const centerAfter = ".flatpickr-calendar.centerMost:after";
                const centerIndex = css.cssRules.length;
                const centerStyle = `{left:${inputBounds.left}px;right:auto;}`;
                self.calendarContainer.classList.toggle("rightMost", false);
                self.calendarContainer.classList.toggle("centerMost", true);
                css.insertRule(`${centerBefore},${centerAfter}${centerStyle}`, centerIndex);
                self.calendarContainer.style.left = `${centerLeft}px`;
                self.calendarContainer.style.right = "auto";
            }
        }
    }
    exports.DatetimePickerView = DatetimePickerView;
    DatetimePickerView.__name__ = "DatetimePickerView";
    class DatetimePicker extends input_widget_1.InputWidget {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DatetimePicker = DatetimePicker;
    _a = DatetimePicker;
    DatetimePicker.__name__ = "DatetimePicker";
    DatetimePicker.__module__ = "panel.models.datetime_picker";
    (() => {
        _a.prototype.default_view = DatetimePickerView;
        _a.define(({ Bool, Str, List, Tuple, Or, Nullable }) => {
            const DateStr = Str;
            const DatesList = List(Or(DateStr, Tuple(DateStr, DateStr)));
            return {
                allow_input: [Bool, false],
                value: [Nullable(Str), null],
                min_date: [Nullable(Str), null],
                max_date: [Nullable(Str), null],
                disabled_dates: [Nullable(DatesList), null],
                enabled_dates: [Nullable(DatesList), null],
                position: [enums_1.CalendarPosition, "auto"],
                inline: [Bool, false],
                enable_time: [Bool, true],
                enable_seconds: [Bool, true],
                military_time: [Bool, true],
                date_format: [Str, "Y-m-d H:i:S"],
                mode: [Str, "single"],
            };
        });
    })();
},
"1156ddcec2": /* flatpickr\dist\esm\index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require("tslib");
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __spreadArrays = (this && this.__spreadArrays) || function () {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };
    const options_1 = require("651d495396") /* ./types/options */;
    const default_1 = tslib_1.__importDefault(require("3bfa124fda") /* ./l10n/default */);
    const utils_1 = require("15458073ce") /* ./utils */;
    const dom_1 = require("6b6749c6cf") /* ./utils/dom */;
    const dates_1 = require("1bb8c967d1") /* ./utils/dates */;
    const formatting_1 = require("3d14787c35") /* ./utils/formatting */;
    require("6f45019dc1") /* ./utils/polyfills */;
    var DEBOUNCED_CHANGE_MS = 300;
    function FlatpickrInstance(element, instanceConfig) {
        var self = {
            config: __assign(__assign({}, options_1.defaults), flatpickr.defaultConfig),
            l10n: default_1.default,
        };
        self.parseDate = (0, dates_1.createDateParser)({ config: self.config, l10n: self.l10n });
        self._handlers = [];
        self.pluginElements = [];
        self.loadedPlugins = [];
        self._bind = bind;
        self._setHoursFromDate = setHoursFromDate;
        self._positionCalendar = positionCalendar;
        self.changeMonth = changeMonth;
        self.changeYear = changeYear;
        self.clear = clear;
        self.close = close;
        self.onMouseOver = onMouseOver;
        self._createElement = dom_1.createElement;
        self.createDay = createDay;
        self.destroy = destroy;
        self.isEnabled = isEnabled;
        self.jumpToDate = jumpToDate;
        self.updateValue = updateValue;
        self.open = open;
        self.redraw = redraw;
        self.set = set;
        self.setDate = setDate;
        self.toggle = toggle;
        function setupHelperFunctions() {
            self.utils = {
                getDaysInMonth: function (month, yr) {
                    if (month === void 0) {
                        month = self.currentMonth;
                    }
                    if (yr === void 0) {
                        yr = self.currentYear;
                    }
                    if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))
                        return 29;
                    return self.l10n.daysInMonth[month];
                },
            };
        }
        function init() {
            self.element = self.input = element;
            self.isOpen = false;
            parseConfig();
            setupLocale();
            setupInputs();
            setupDates();
            setupHelperFunctions();
            if (!self.isMobile)
                build();
            bindEvents();
            if (self.selectedDates.length || self.config.noCalendar) {
                if (self.config.enableTime) {
                    setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);
                }
                updateValue(false);
            }
            setCalendarWidth();
            var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
            if (!self.isMobile && isSafari) {
                positionCalendar();
            }
            triggerEvent("onReady");
        }
        function getClosestActiveElement() {
            var _a;
            return (((_a = self.calendarContainer) === null || _a === void 0 ? void 0 : _a.getRootNode())
                .activeElement || document.activeElement);
        }
        function bindToInstance(fn) {
            return fn.bind(self);
        }
        function setCalendarWidth() {
            var config = self.config;
            if (config.weekNumbers === false && config.showMonths === 1) {
                return;
            }
            else if (config.noCalendar !== true) {
                window.requestAnimationFrame(function () {
                    if (self.calendarContainer !== undefined) {
                        self.calendarContainer.style.visibility = "hidden";
                        self.calendarContainer.style.display = "block";
                    }
                    if (self.daysContainer !== undefined) {
                        var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;
                        self.daysContainer.style.width = daysWidth + "px";
                        self.calendarContainer.style.width =
                            daysWidth +
                                (self.weekWrapper !== undefined
                                    ? self.weekWrapper.offsetWidth
                                    : 0) +
                                "px";
                        self.calendarContainer.style.removeProperty("visibility");
                        self.calendarContainer.style.removeProperty("display");
                    }
                });
            }
        }
        function updateTime(e) {
            if (self.selectedDates.length === 0) {
                var defaultDate = self.config.minDate === undefined ||
                    (0, dates_1.compareDates)(new Date(), self.config.minDate) >= 0
                    ? new Date()
                    : new Date(self.config.minDate.getTime());
                var defaults = (0, dates_1.getDefaultHours)(self.config);
                defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());
                self.selectedDates = [defaultDate];
                self.latestSelectedDateObj = defaultDate;
            }
            if (e !== undefined && e.type !== "blur") {
                timeWrapper(e);
            }
            var prevValue = self._input.value;
            setHoursFromInputs();
            updateValue();
            if (self._input.value !== prevValue) {
                self._debouncedChange();
            }
        }
        function ampm2military(hour, amPM) {
            return (hour % 12) + 12 * (0, utils_1.int)(amPM === self.l10n.amPM[1]);
        }
        function military2ampm(hour) {
            switch (hour % 24) {
                case 0:
                case 12:
                    return 12;
                default:
                    return hour % 12;
            }
        }
        function setHoursFromInputs() {
            if (self.hourElement === undefined || self.minuteElement === undefined)
                return;
            var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined
                ? (parseInt(self.secondElement.value, 10) || 0) % 60
                : 0;
            if (self.amPM !== undefined) {
                hours = ampm2military(hours, self.amPM.textContent);
            }
            var limitMinHours = self.config.minTime !== undefined ||
                (self.config.minDate &&
                    self.minDateHasTime &&
                    self.latestSelectedDateObj &&
                    (0, dates_1.compareDates)(self.latestSelectedDateObj, self.config.minDate, true) ===
                        0);
            var limitMaxHours = self.config.maxTime !== undefined ||
                (self.config.maxDate &&
                    self.maxDateHasTime &&
                    self.latestSelectedDateObj &&
                    (0, dates_1.compareDates)(self.latestSelectedDateObj, self.config.maxDate, true) ===
                        0);
            if (self.config.maxTime !== undefined &&
                self.config.minTime !== undefined &&
                self.config.minTime > self.config.maxTime) {
                var minBound = (0, dates_1.calculateSecondsSinceMidnight)(self.config.minTime.getHours(), self.config.minTime.getMinutes(), self.config.minTime.getSeconds());
                var maxBound = (0, dates_1.calculateSecondsSinceMidnight)(self.config.maxTime.getHours(), self.config.maxTime.getMinutes(), self.config.maxTime.getSeconds());
                var currentTime = (0, dates_1.calculateSecondsSinceMidnight)(hours, minutes, seconds);
                if (currentTime > maxBound && currentTime < minBound) {
                    var result = (0, dates_1.parseSeconds)(minBound);
                    hours = result[0];
                    minutes = result[1];
                    seconds = result[2];
                }
            }
            else {
                if (limitMaxHours) {
                    var maxTime = self.config.maxTime !== undefined
                        ? self.config.maxTime
                        : self.config.maxDate;
                    hours = Math.min(hours, maxTime.getHours());
                    if (hours === maxTime.getHours())
                        minutes = Math.min(minutes, maxTime.getMinutes());
                    if (minutes === maxTime.getMinutes())
                        seconds = Math.min(seconds, maxTime.getSeconds());
                }
                if (limitMinHours) {
                    var minTime = self.config.minTime !== undefined
                        ? self.config.minTime
                        : self.config.minDate;
                    hours = Math.max(hours, minTime.getHours());
                    if (hours === minTime.getHours() && minutes < minTime.getMinutes())
                        minutes = minTime.getMinutes();
                    if (minutes === minTime.getMinutes())
                        seconds = Math.max(seconds, minTime.getSeconds());
                }
            }
            setHours(hours, minutes, seconds);
        }
        function setHoursFromDate(dateObj) {
            var date = dateObj || self.latestSelectedDateObj;
            if (date && date instanceof Date) {
                setHours(date.getHours(), date.getMinutes(), date.getSeconds());
            }
        }
        function setHours(hours, minutes, seconds) {
            if (self.latestSelectedDateObj !== undefined) {
                self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);
            }
            if (!self.hourElement || !self.minuteElement || self.isMobile)
                return;
            self.hourElement.value = (0, utils_1.pad)(!self.config.time_24hr
                ? ((12 + hours) % 12) + 12 * (0, utils_1.int)(hours % 12 === 0)
                : hours);
            self.minuteElement.value = (0, utils_1.pad)(minutes);
            if (self.amPM !== undefined)
                self.amPM.textContent = self.l10n.amPM[(0, utils_1.int)(hours >= 12)];
            if (self.secondElement !== undefined)
                self.secondElement.value = (0, utils_1.pad)(seconds);
        }
        function onYearInput(event) {
            var eventTarget = (0, dom_1.getEventTarget)(event);
            var year = parseInt(eventTarget.value) + (event.delta || 0);
            if (year / 1000 > 1 ||
                (event.key === "Enter" && !/[^\d]/.test(year.toString()))) {
                changeYear(year);
            }
        }
        function bind(element, event, handler, options) {
            if (event instanceof Array)
                return event.forEach(function (ev) { return bind(element, ev, handler, options); });
            if (element instanceof Array)
                return element.forEach(function (el) { return bind(el, event, handler, options); });
            element.addEventListener(event, handler, options);
            self._handlers.push({
                remove: function () { return element.removeEventListener(event, handler, options); },
            });
        }
        function triggerChange() {
            triggerEvent("onChange");
        }
        function bindEvents() {
            if (self.config.wrap) {
                ["open", "close", "toggle", "clear"].forEach(function (evt) {
                    Array.prototype.forEach.call(self.element.querySelectorAll("[data-" + evt + "]"), function (el) {
                        return bind(el, "click", self[evt]);
                    });
                });
            }
            if (self.isMobile) {
                setupMobile();
                return;
            }
            var debouncedResize = (0, utils_1.debounce)(onResize, 50);
            self._debouncedChange = (0, utils_1.debounce)(triggerChange, DEBOUNCED_CHANGE_MS);
            if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))
                bind(self.daysContainer, "mouseover", function (e) {
                    if (self.config.mode === "range")
                        onMouseOver((0, dom_1.getEventTarget)(e));
                });
            bind(self._input, "keydown", onKeyDown);
            if (self.calendarContainer !== undefined) {
                bind(self.calendarContainer, "keydown", onKeyDown);
            }
            if (!self.config.inline && !self.config.static)
                bind(window, "resize", debouncedResize);
            if (window.ontouchstart !== undefined)
                bind(window.document, "touchstart", documentClick);
            else
                bind(window.document, "mousedown", documentClick);
            bind(window.document, "focus", documentClick, { capture: true });
            if (self.config.clickOpens === true) {
                bind(self._input, "focus", self.open);
                bind(self._input, "click", self.open);
            }
            if (self.daysContainer !== undefined) {
                bind(self.monthNav, "click", onMonthNavClick);
                bind(self.monthNav, ["keyup", "increment"], onYearInput);
                bind(self.daysContainer, "click", selectDate);
            }
            if (self.timeContainer !== undefined &&
                self.minuteElement !== undefined &&
                self.hourElement !== undefined) {
                var selText = function (e) {
                    return (0, dom_1.getEventTarget)(e).select();
                };
                bind(self.timeContainer, ["increment"], updateTime);
                bind(self.timeContainer, "blur", updateTime, { capture: true });
                bind(self.timeContainer, "click", timeIncrement);
                bind([self.hourElement, self.minuteElement], ["focus", "click"], selText);
                if (self.secondElement !== undefined)
                    bind(self.secondElement, "focus", function () { return self.secondElement && self.secondElement.select(); });
                if (self.amPM !== undefined) {
                    bind(self.amPM, "click", function (e) {
                        updateTime(e);
                    });
                }
            }
            if (self.config.allowInput) {
                bind(self._input, "blur", onBlur);
            }
        }
        function jumpToDate(jumpDate, triggerChange) {
            var jumpTo = jumpDate !== undefined
                ? self.parseDate(jumpDate)
                : self.latestSelectedDateObj ||
                    (self.config.minDate && self.config.minDate > self.now
                        ? self.config.minDate
                        : self.config.maxDate && self.config.maxDate < self.now
                            ? self.config.maxDate
                            : self.now);
            var oldYear = self.currentYear;
            var oldMonth = self.currentMonth;
            try {
                if (jumpTo !== undefined) {
                    self.currentYear = jumpTo.getFullYear();
                    self.currentMonth = jumpTo.getMonth();
                }
            }
            catch (e) {
                e.message = "Invalid date supplied: " + jumpTo;
                self.config.errorHandler(e);
            }
            if (triggerChange && self.currentYear !== oldYear) {
                triggerEvent("onYearChange");
                buildMonthSwitch();
            }
            if (triggerChange &&
                (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {
                triggerEvent("onMonthChange");
            }
            self.redraw();
        }
        function timeIncrement(e) {
            var eventTarget = (0, dom_1.getEventTarget)(e);
            if (~eventTarget.className.indexOf("arrow"))
                incrementNumInput(e, eventTarget.classList.contains("arrowUp") ? 1 : -1);
        }
        function incrementNumInput(e, delta, inputElem) {
            var target = e && (0, dom_1.getEventTarget)(e);
            var input = inputElem ||
                (target && target.parentNode && target.parentNode.firstChild);
            var event = createEvent("increment");
            event.delta = delta;
            input && input.dispatchEvent(event);
        }
        function build() {
            var fragment = window.document.createDocumentFragment();
            self.calendarContainer = (0, dom_1.createElement)("div", "flatpickr-calendar");
            self.calendarContainer.tabIndex = -1;
            if (!self.config.noCalendar) {
                fragment.appendChild(buildMonthNav());
                self.innerContainer = (0, dom_1.createElement)("div", "flatpickr-innerContainer");
                if (self.config.weekNumbers) {
                    var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;
                    self.innerContainer.appendChild(weekWrapper);
                    self.weekNumbers = weekNumbers;
                    self.weekWrapper = weekWrapper;
                }
                self.rContainer = (0, dom_1.createElement)("div", "flatpickr-rContainer");
                self.rContainer.appendChild(buildWeekdays());
                if (!self.daysContainer) {
                    self.daysContainer = (0, dom_1.createElement)("div", "flatpickr-days");
                    self.daysContainer.tabIndex = -1;
                }
                buildDays();
                self.rContainer.appendChild(self.daysContainer);
                self.innerContainer.appendChild(self.rContainer);
                fragment.appendChild(self.innerContainer);
            }
            if (self.config.enableTime) {
                fragment.appendChild(buildTime());
            }
            (0, dom_1.toggleClass)(self.calendarContainer, "rangeMode", self.config.mode === "range");
            (0, dom_1.toggleClass)(self.calendarContainer, "animate", self.config.animate === true);
            (0, dom_1.toggleClass)(self.calendarContainer, "multiMonth", self.config.showMonths > 1);
            self.calendarContainer.appendChild(fragment);
            var customAppend = self.config.appendTo !== undefined &&
                self.config.appendTo.nodeType !== undefined;
            if (self.config.inline || self.config.static) {
                self.calendarContainer.classList.add(self.config.inline ? "inline" : "static");
                if (self.config.inline) {
                    if (!customAppend && self.element.parentNode)
                        self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);
                    else if (self.config.appendTo !== undefined)
                        self.config.appendTo.appendChild(self.calendarContainer);
                }
                if (self.config.static) {
                    var wrapper = (0, dom_1.createElement)("div", "flatpickr-wrapper");
                    if (self.element.parentNode)
                        self.element.parentNode.insertBefore(wrapper, self.element);
                    wrapper.appendChild(self.element);
                    if (self.altInput)
                        wrapper.appendChild(self.altInput);
                    wrapper.appendChild(self.calendarContainer);
                }
            }
            if (!self.config.static && !self.config.inline)
                (self.config.appendTo !== undefined
                    ? self.config.appendTo
                    : window.document.body).appendChild(self.calendarContainer);
        }
        function createDay(className, date, _dayNumber, i) {
            var dateIsEnabled = isEnabled(date, true), dayElement = (0, dom_1.createElement)("span", className, date.getDate().toString());
            dayElement.dateObj = date;
            dayElement.$i = i;
            dayElement.setAttribute("aria-label", self.formatDate(date, self.config.ariaDateFormat));
            if (className.indexOf("hidden") === -1 &&
                (0, dates_1.compareDates)(date, self.now) === 0) {
                self.todayDateElem = dayElement;
                dayElement.classList.add("today");
                dayElement.setAttribute("aria-current", "date");
            }
            if (dateIsEnabled) {
                dayElement.tabIndex = -1;
                if (isDateSelected(date)) {
                    dayElement.classList.add("selected");
                    self.selectedDateElem = dayElement;
                    if (self.config.mode === "range") {
                        (0, dom_1.toggleClass)(dayElement, "startRange", self.selectedDates[0] &&
                            (0, dates_1.compareDates)(date, self.selectedDates[0], true) === 0);
                        (0, dom_1.toggleClass)(dayElement, "endRange", self.selectedDates[1] &&
                            (0, dates_1.compareDates)(date, self.selectedDates[1], true) === 0);
                        if (className === "nextMonthDay")
                            dayElement.classList.add("inRange");
                    }
                }
            }
            else {
                dayElement.classList.add("flatpickr-disabled");
            }
            if (self.config.mode === "range") {
                if (isDateInRange(date) && !isDateSelected(date))
                    dayElement.classList.add("inRange");
            }
            if (self.weekNumbers &&
                self.config.showMonths === 1 &&
                className !== "prevMonthDay" &&
                i % 7 === 6) {
                self.weekNumbers.insertAdjacentHTML("beforeend", "<span class='flatpickr-day'>" + self.config.getWeek(date) + "</span>");
            }
            triggerEvent("onDayCreate", dayElement);
            return dayElement;
        }
        function focusOnDayElem(targetNode) {
            targetNode.focus();
            if (self.config.mode === "range")
                onMouseOver(targetNode);
        }
        function getFirstAvailableDay(delta) {
            var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;
            var endMonth = delta > 0 ? self.config.showMonths : -1;
            for (var m = startMonth; m != endMonth; m += delta) {
                var month = self.daysContainer.children[m];
                var startIndex = delta > 0 ? 0 : month.children.length - 1;
                var endIndex = delta > 0 ? month.children.length : -1;
                for (var i = startIndex; i != endIndex; i += delta) {
                    var c = month.children[i];
                    if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj))
                        return c;
                }
            }
            return undefined;
        }
        function getNextAvailableDay(current, delta) {
            var givenMonth = current.className.indexOf("Month") === -1
                ? current.dateObj.getMonth()
                : self.currentMonth;
            var endMonth = delta > 0 ? self.config.showMonths : -1;
            var loopDelta = delta > 0 ? 1 : -1;
            for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {
                var month = self.daysContainer.children[m];
                var startIndex = givenMonth - self.currentMonth === m
                    ? current.$i + delta
                    : delta < 0
                        ? month.children.length - 1
                        : 0;
                var numMonthDays = month.children.length;
                for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {
                    var c = month.children[i];
                    if (c.className.indexOf("hidden") === -1 &&
                        isEnabled(c.dateObj) &&
                        Math.abs(current.$i - i) >= Math.abs(delta))
                        return focusOnDayElem(c);
                }
            }
            self.changeMonth(loopDelta);
            focusOnDay(getFirstAvailableDay(loopDelta), 0);
            return undefined;
        }
        function focusOnDay(current, offset) {
            var activeElement = getClosestActiveElement();
            var dayFocused = isInView(activeElement || document.body);
            var startElem = current !== undefined
                ? current
                : dayFocused
                    ? activeElement
                    : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)
                        ? self.selectedDateElem
                        : self.todayDateElem !== undefined && isInView(self.todayDateElem)
                            ? self.todayDateElem
                            : getFirstAvailableDay(offset > 0 ? 1 : -1);
            if (startElem === undefined) {
                self._input.focus();
            }
            else if (!dayFocused) {
                focusOnDayElem(startElem);
            }
            else {
                getNextAvailableDay(startElem, offset);
            }
        }
        function buildMonthDays(year, month) {
            var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;
            var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);
            var daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? "prevMonthDay hidden" : "prevMonthDay", nextMonthDayClass = isMultiMonth ? "nextMonthDay hidden" : "nextMonthDay";
            var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;
            for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {
                days.appendChild(createDay("flatpickr-day " + prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));
            }
            for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {
                days.appendChild(createDay("flatpickr-day", new Date(year, month, dayNumber), dayNumber, dayIndex));
            }
            for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&
                (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {
                days.appendChild(createDay("flatpickr-day " + nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));
            }
            var dayContainer = (0, dom_1.createElement)("div", "dayContainer");
            dayContainer.appendChild(days);
            return dayContainer;
        }
        function buildDays() {
            if (self.daysContainer === undefined) {
                return;
            }
            (0, dom_1.clearNode)(self.daysContainer);
            if (self.weekNumbers)
                (0, dom_1.clearNode)(self.weekNumbers);
            var frag = document.createDocumentFragment();
            for (var i = 0; i < self.config.showMonths; i++) {
                var d = new Date(self.currentYear, self.currentMonth, 1);
                d.setMonth(self.currentMonth + i);
                frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));
            }
            self.daysContainer.appendChild(frag);
            self.days = self.daysContainer.firstChild;
            if (self.config.mode === "range" && self.selectedDates.length === 1) {
                onMouseOver();
            }
        }
        function buildMonthSwitch() {
            if (self.config.showMonths > 1 ||
                self.config.monthSelectorType !== "dropdown")
                return;
            var shouldBuildMonth = function (month) {
                if (self.config.minDate !== undefined &&
                    self.currentYear === self.config.minDate.getFullYear() &&
                    month < self.config.minDate.getMonth()) {
                    return false;
                }
                return !(self.config.maxDate !== undefined &&
                    self.currentYear === self.config.maxDate.getFullYear() &&
                    month > self.config.maxDate.getMonth());
            };
            self.monthsDropdownContainer.tabIndex = -1;
            self.monthsDropdownContainer.innerHTML = "";
            for (var i = 0; i < 12; i++) {
                if (!shouldBuildMonth(i))
                    continue;
                var month = (0, dom_1.createElement)("option", "flatpickr-monthDropdown-month");
                month.value = new Date(self.currentYear, i).getMonth().toString();
                month.textContent = (0, formatting_1.monthToStr)(i, self.config.shorthandCurrentMonth, self.l10n);
                month.tabIndex = -1;
                if (self.currentMonth === i) {
                    month.selected = true;
                }
                self.monthsDropdownContainer.appendChild(month);
            }
        }
        function buildMonth() {
            var container = (0, dom_1.createElement)("div", "flatpickr-month");
            var monthNavFragment = window.document.createDocumentFragment();
            var monthElement;
            if (self.config.showMonths > 1 ||
                self.config.monthSelectorType === "static") {
                monthElement = (0, dom_1.createElement)("span", "cur-month");
            }
            else {
                self.monthsDropdownContainer = (0, dom_1.createElement)("select", "flatpickr-monthDropdown-months");
                self.monthsDropdownContainer.setAttribute("aria-label", self.l10n.monthAriaLabel);
                bind(self.monthsDropdownContainer, "change", function (e) {
                    var target = (0, dom_1.getEventTarget)(e);
                    var selectedMonth = parseInt(target.value, 10);
                    self.changeMonth(selectedMonth - self.currentMonth);
                    triggerEvent("onMonthChange");
                });
                buildMonthSwitch();
                monthElement = self.monthsDropdownContainer;
            }
            var yearInput = (0, dom_1.createNumberInput)("cur-year", { tabindex: "-1" });
            var yearElement = yearInput.getElementsByTagName("input")[0];
            yearElement.setAttribute("aria-label", self.l10n.yearAriaLabel);
            if (self.config.minDate) {
                yearElement.setAttribute("min", self.config.minDate.getFullYear().toString());
            }
            if (self.config.maxDate) {
                yearElement.setAttribute("max", self.config.maxDate.getFullYear().toString());
                yearElement.disabled =
                    !!self.config.minDate &&
                        self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();
            }
            var currentMonth = (0, dom_1.createElement)("div", "flatpickr-current-month");
            currentMonth.appendChild(monthElement);
            currentMonth.appendChild(yearInput);
            monthNavFragment.appendChild(currentMonth);
            container.appendChild(monthNavFragment);
            return {
                container: container,
                yearElement: yearElement,
                monthElement: monthElement,
            };
        }
        function buildMonths() {
            (0, dom_1.clearNode)(self.monthNav);
            self.monthNav.appendChild(self.prevMonthNav);
            if (self.config.showMonths) {
                self.yearElements = [];
                self.monthElements = [];
            }
            for (var m = self.config.showMonths; m--;) {
                var month = buildMonth();
                self.yearElements.push(month.yearElement);
                self.monthElements.push(month.monthElement);
                self.monthNav.appendChild(month.container);
            }
            self.monthNav.appendChild(self.nextMonthNav);
        }
        function buildMonthNav() {
            self.monthNav = (0, dom_1.createElement)("div", "flatpickr-months");
            self.yearElements = [];
            self.monthElements = [];
            self.prevMonthNav = (0, dom_1.createElement)("span", "flatpickr-prev-month");
            self.prevMonthNav.innerHTML = self.config.prevArrow;
            self.nextMonthNav = (0, dom_1.createElement)("span", "flatpickr-next-month");
            self.nextMonthNav.innerHTML = self.config.nextArrow;
            buildMonths();
            Object.defineProperty(self, "_hidePrevMonthArrow", {
                get: function () { return self.__hidePrevMonthArrow; },
                set: function (bool) {
                    if (self.__hidePrevMonthArrow !== bool) {
                        (0, dom_1.toggleClass)(self.prevMonthNav, "flatpickr-disabled", bool);
                        self.__hidePrevMonthArrow = bool;
                    }
                },
            });
            Object.defineProperty(self, "_hideNextMonthArrow", {
                get: function () { return self.__hideNextMonthArrow; },
                set: function (bool) {
                    if (self.__hideNextMonthArrow !== bool) {
                        (0, dom_1.toggleClass)(self.nextMonthNav, "flatpickr-disabled", bool);
                        self.__hideNextMonthArrow = bool;
                    }
                },
            });
            self.currentYearElement = self.yearElements[0];
            updateNavigationCurrentMonth();
            return self.monthNav;
        }
        function buildTime() {
            self.calendarContainer.classList.add("hasTime");
            if (self.config.noCalendar)
                self.calendarContainer.classList.add("noCalendar");
            var defaults = (0, dates_1.getDefaultHours)(self.config);
            self.timeContainer = (0, dom_1.createElement)("div", "flatpickr-time");
            self.timeContainer.tabIndex = -1;
            var separator = (0, dom_1.createElement)("span", "flatpickr-time-separator", ":");
            var hourInput = (0, dom_1.createNumberInput)("flatpickr-hour", {
                "aria-label": self.l10n.hourAriaLabel,
            });
            self.hourElement = hourInput.getElementsByTagName("input")[0];
            var minuteInput = (0, dom_1.createNumberInput)("flatpickr-minute", {
                "aria-label": self.l10n.minuteAriaLabel,
            });
            self.minuteElement = minuteInput.getElementsByTagName("input")[0];
            self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;
            self.hourElement.value = (0, utils_1.pad)(self.latestSelectedDateObj
                ? self.latestSelectedDateObj.getHours()
                : self.config.time_24hr
                    ? defaults.hours
                    : military2ampm(defaults.hours));
            self.minu