import { d as dispatch } from './dispatch-Q6CxlFMN.js';

var EOL = {}, EOF = {}, QUOTE = 34, NEWLINE = 10, RETURN = 13;
function objectConverter(columns) {
  return new Function("d", "return {" + columns.map(function(name, i) {
    return JSON.stringify(name) + ": d[" + i + '] || ""';
  }).join(",") + "}");
}
function customConverter(columns, f) {
  var object2 = objectConverter(columns);
  return function(row, i) {
    return f(object2(row), i, columns);
  };
}
function inferColumns(rows) {
  var columnSet = /* @__PURE__ */ Object.create(null), columns = [];
  rows.forEach(function(row) {
    for (var column in row) {
      if (!(column in columnSet)) {
        columns.push(columnSet[column] = column);
      }
    }
  });
  return columns;
}
function pad$2(value2, width2) {
  var s = value2 + "", length2 = s.length;
  return length2 < width2 ? new Array(width2 - length2 + 1).join(0) + s : s;
}
function formatYear$1(year) {
  return year < 0 ? "-" + pad$2(-year, 6) : year > 9999 ? "+" + pad$2(year, 6) : pad$2(year, 4);
}
function formatDate(date2) {
  var hours = date2.getUTCHours(), minutes = date2.getUTCMinutes(), seconds = date2.getUTCSeconds(), milliseconds = date2.getUTCMilliseconds();
  return isNaN(date2) ? "Invalid Date" : formatYear$1(date2.getUTCFullYear()) + "-" + pad$2(date2.getUTCMonth() + 1, 2) + "-" + pad$2(date2.getUTCDate(), 2) + (milliseconds ? "T" + pad$2(hours, 2) + ":" + pad$2(minutes, 2) + ":" + pad$2(seconds, 2) + "." + pad$2(milliseconds, 3) + "Z" : seconds ? "T" + pad$2(hours, 2) + ":" + pad$2(minutes, 2) + ":" + pad$2(seconds, 2) + "Z" : minutes || hours ? "T" + pad$2(hours, 2) + ":" + pad$2(minutes, 2) + "Z" : "");
}
function dsvFormat(delimiter) {
  var reFormat = new RegExp('["' + delimiter + "\n\r]"), DELIMITER = delimiter.charCodeAt(0);
  function parse2(text2, f) {
    var convert, columns, rows = parseRows(text2, function(row, i) {
      if (convert)
        return convert(row, i - 1);
      columns = row, convert = f ? customConverter(row, f) : objectConverter(row);
    });
    rows.columns = columns || [];
    return rows;
  }
  function parseRows(text2, f) {
    var rows = [], N = text2.length, I = 0, n = 0, t, eof = N <= 0, eol = false;
    if (text2.charCodeAt(N - 1) === NEWLINE)
      --N;
    if (text2.charCodeAt(N - 1) === RETURN)
      --N;
    function token() {
      if (eof)
        return EOF;
      if (eol)
        return eol = false, EOL;
      var i, j = I, c2;
      if (text2.charCodeAt(j) === QUOTE) {
        while (I++ < N && text2.charCodeAt(I) !== QUOTE || text2.charCodeAt(++I) === QUOTE)
          ;
        if ((i = I) >= N)
          eof = true;
        else if ((c2 = text2.charCodeAt(I++)) === NEWLINE)
          eol = true;
        else if (c2 === RETURN) {
          eol = true;
          if (text2.charCodeAt(I) === NEWLINE)
            ++I;
        }
        return text2.slice(j + 1, i - 1).replace(/""/g, '"');
      }
      while (I < N) {
        if ((c2 = text2.charCodeAt(i = I++)) === NEWLINE)
          eol = true;
        else if (c2 === RETURN) {
          eol = true;
          if (text2.charCodeAt(I) === NEWLINE)
            ++I;
        } else if (c2 !== DELIMITER)
          continue;
        return text2.slice(j, i);
      }
      return eof = true, text2.slice(j, N);
    }
    while ((t = token()) !== EOF) {
      var row = [];
      while (t !== EOL && t !== EOF)
        row.push(t), t = token();
      if (f && (row = f(row, n++)) == null)
        continue;
      rows.push(row);
    }
    return rows;
  }
  function preformatBody(rows, columns) {
    return rows.map(function(row) {
      return columns.map(function(column) {
        return formatValue2(row[column]);
      }).join(delimiter);
    });
  }
  function format2(rows, columns) {
    if (columns == null)
      columns = inferColumns(rows);
    return [columns.map(formatValue2).join(delimiter)].concat(preformatBody(rows, columns)).join("\n");
  }
  function formatBody(rows, columns) {
    if (columns == null)
      columns = inferColumns(rows);
    return preformatBody(rows, columns).join("\n");
  }
  function formatRows(rows) {
    return rows.map(formatRow).join("\n");
  }
  function formatRow(row) {
    return row.map(formatValue2).join(delimiter);
  }
  function formatValue2(value2) {
    return value2 == null ? "" : value2 instanceof Date ? formatDate(value2) : reFormat.test(value2 += "") ? '"' + value2.replace(/"/g, '""') + '"' : value2;
  }
  return {
    parse: parse2,
    parseRows,
    format: format2,
    formatBody,
    formatRows,
    formatRow,
    formatValue: formatValue2
  };
}
function ascending$2(a2, b2) {
  return a2 == null || b2 == null ? NaN : a2 < b2 ? -1 : a2 > b2 ? 1 : a2 >= b2 ? 0 : NaN;
}
function descending$1(a2, b2) {
  return a2 == null || b2 == null ? NaN : b2 < a2 ? -1 : b2 > a2 ? 1 : b2 >= a2 ? 0 : NaN;
}
function bisector(f) {
  let compare12, compare2, delta;
  if (f.length !== 2) {
    compare12 = ascending$2;
    compare2 = (d, x2) => ascending$2(f(d), x2);
    delta = (d, x2) => f(d) - x2;
  } else {
    compare12 = f === ascending$2 || f === descending$1 ? f : zero$3;
    compare2 = f;
    delta = f;
  }
  function left(a2, x2, lo = 0, hi = a2.length) {
    if (lo < hi) {
      if (compare12(x2, x2) !== 0)
        return hi;
      do {
        const mid = lo + hi >>> 1;
        if (compare2(a2[mid], x2) < 0)
          lo = mid + 1;
        else
          hi = mid;
      } while (lo < hi);
    }
    return lo;
  }
  function right(a2, x2, lo = 0, hi = a2.length) {
    if (lo < hi) {
      if (compare12(x2, x2) !== 0)
        return hi;
      do {
        const mid = lo + hi >>> 1;
        if (compare2(a2[mid], x2) <= 0)
          lo = mid + 1;
        else
          hi = mid;
      } while (lo < hi);
    }
    return lo;
  }
  function center(a2, x2, lo = 0, hi = a2.length) {
    const i = left(a2, x2, lo, hi - 1);
    return i > lo && delta(a2[i - 1], x2) > -delta(a2[i], x2) ? i - 1 : i;
  }
  return { left, center, right };
}
function zero$3() {
  return 0;
}
function number$6(x2) {
  return x2 === null ? NaN : +x2;
}
function* numbers$2(values2, valueof) {
  if (valueof === void 0) {
    for (let value2 of values2) {
      if (value2 != null && (value2 = +value2) >= value2) {
        yield value2;
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      if ((value2 = valueof(value2, ++index2, values2)) != null && (value2 = +value2) >= value2) {
        yield value2;
      }
    }
  }
}
const ascendingBisect = bisector(ascending$2);
const bisectRight$1 = ascendingBisect.right;
const bisectLeft$1 = ascendingBisect.left;
bisector(number$6).center;
function variance(values2, valueof) {
  let count2 = 0;
  let delta;
  let mean2 = 0;
  let sum2 = 0;
  if (valueof === void 0) {
    for (let value2 of values2) {
      if (value2 != null && (value2 = +value2) >= value2) {
        delta = value2 - mean2;
        mean2 += delta / ++count2;
        sum2 += delta * (value2 - mean2);
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      if ((value2 = valueof(value2, ++index2, values2)) != null && (value2 = +value2) >= value2) {
        delta = value2 - mean2;
        mean2 += delta / ++count2;
        sum2 += delta * (value2 - mean2);
      }
    }
  }
  if (count2 > 1)
    return sum2 / (count2 - 1);
}
function deviation(values2, valueof) {
  const v = variance(values2, valueof);
  return v ? Math.sqrt(v) : v;
}
class Adder {
  constructor() {
    this._partials = new Float64Array(32);
    this._n = 0;
  }
  add(x2) {
    const p = this._partials;
    let i = 0;
    for (let j = 0; j < this._n && j < 32; j++) {
      const y2 = p[j], hi = x2 + y2, lo = Math.abs(x2) < Math.abs(y2) ? x2 - (hi - y2) : y2 - (hi - x2);
      if (lo)
        p[i++] = lo;
      x2 = hi;
    }
    p[i] = x2;
    this._n = i + 1;
    return this;
  }
  valueOf() {
    const p = this._partials;
    let n = this._n, x2, y2, lo, hi = 0;
    if (n > 0) {
      hi = p[--n];
      while (n > 0) {
        x2 = hi;
        y2 = p[--n];
        hi = x2 + y2;
        lo = y2 - (hi - x2);
        if (lo)
          break;
      }
      if (n > 0 && (lo < 0 && p[n - 1] < 0 || lo > 0 && p[n - 1] > 0)) {
        y2 = lo * 2;
        x2 = hi + y2;
        if (y2 == x2 - hi)
          hi = x2;
      }
    }
    return hi;
  }
}
class InternMap extends Map {
  constructor(entries, key2 = keyof) {
    super();
    Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key2 } });
    if (entries != null)
      for (const [key3, value2] of entries)
        this.set(key3, value2);
  }
  get(key2) {
    return super.get(intern_get(this, key2));
  }
  has(key2) {
    return super.has(intern_get(this, key2));
  }
  set(key2, value2) {
    return super.set(intern_set(this, key2), value2);
  }
  delete(key2) {
    return super.delete(intern_delete(this, key2));
  }
}
class InternSet extends Set {
  constructor(values2, key2 = keyof) {
    super();
    Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key2 } });
    if (values2 != null)
      for (const value2 of values2)
        this.add(value2);
  }
  has(value2) {
    return super.has(intern_get(this, value2));
  }
  add(value2) {
    return super.add(intern_set(this, value2));
  }
  delete(value2) {
    return super.delete(intern_delete(this, value2));
  }
}
function intern_get({ _intern, _key }, value2) {
  const key2 = _key(value2);
  return _intern.has(key2) ? _intern.get(key2) : value2;
}
function intern_set({ _intern, _key }, value2) {
  const key2 = _key(value2);
  if (_intern.has(key2))
    return _intern.get(key2);
  _intern.set(key2, value2);
  return value2;
}
function intern_delete({ _intern, _key }, value2) {
  const key2 = _key(value2);
  if (_intern.has(key2)) {
    value2 = _intern.get(key2);
    _intern.delete(key2);
  }
  return value2;
}
function keyof(value2) {
  return value2 !== null && typeof value2 === "object" ? value2.valueOf() : value2;
}
function permute(source2, keys2) {
  return Array.from(keys2, (key2) => source2[key2]);
}
function compareDefined(compare2 = ascending$2) {
  if (compare2 === ascending$2)
    return ascendingDefined;
  if (typeof compare2 !== "function")
    throw new TypeError("compare is not a function");
  return (a2, b2) => {
    const x2 = compare2(a2, b2);
    if (x2 || x2 === 0)
      return x2;
    return (compare2(b2, b2) === 0) - (compare2(a2, a2) === 0);
  };
}
function ascendingDefined(a2, b2) {
  return (a2 == null || !(a2 >= a2)) - (b2 == null || !(b2 >= b2)) || (a2 < b2 ? -1 : a2 > b2 ? 1 : 0);
}
const e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
function tickSpec(start, stop2, count2) {
  const step = (stop2 - start) / Math.max(0, count2), power = Math.floor(Math.log10(step)), error2 = step / Math.pow(10, power), factor = error2 >= e10 ? 10 : error2 >= e5 ? 5 : error2 >= e2 ? 2 : 1;
  let i1, i2, inc;
  if (power < 0) {
    inc = Math.pow(10, -power) / factor;
    i1 = Math.round(start * inc);
    i2 = Math.round(stop2 * inc);
    if (i1 / inc < start)
      ++i1;
    if (i2 / inc > stop2)
      --i2;
    inc = -inc;
  } else {
    inc = Math.pow(10, power) * factor;
    i1 = Math.round(start / inc);
    i2 = Math.round(stop2 / inc);
    if (i1 * inc < start)
      ++i1;
    if (i2 * inc > stop2)
      --i2;
  }
  if (i2 < i1 && 0.5 <= count2 && count2 < 2)
    return tickSpec(start, stop2, count2 * 2);
  return [i1, i2, inc];
}
function ticks(start, stop2, count2) {
  stop2 = +stop2, start = +start, count2 = +count2;
  if (!(count2 > 0))
    return [];
  if (start === stop2)
    return [start];
  const reverse2 = stop2 < start, [i1, i2, inc] = reverse2 ? tickSpec(stop2, start, count2) : tickSpec(start, stop2, count2);
  if (!(i2 >= i1))
    return [];
  const n = i2 - i1 + 1, ticks2 = new Array(n);
  if (reverse2) {
    if (inc < 0)
      for (let i = 0; i < n; ++i)
        ticks2[i] = (i2 - i) / -inc;
    else
      for (let i = 0; i < n; ++i)
        ticks2[i] = (i2 - i) * inc;
  } else {
    if (inc < 0)
      for (let i = 0; i < n; ++i)
        ticks2[i] = (i1 + i) / -inc;
    else
      for (let i = 0; i < n; ++i)
        ticks2[i] = (i1 + i) * inc;
  }
  return ticks2;
}
function tickIncrement(start, stop2, count2) {
  stop2 = +stop2, start = +start, count2 = +count2;
  return tickSpec(start, stop2, count2)[2];
}
function tickStep(start, stop2, count2) {
  stop2 = +stop2, start = +start, count2 = +count2;
  const reverse2 = stop2 < start, inc = reverse2 ? tickIncrement(stop2, start, count2) : tickIncrement(start, stop2, count2);
  return (reverse2 ? -1 : 1) * (inc < 0 ? 1 / -inc : inc);
}
function max$2(values2, valueof) {
  let max2;
  if (valueof === void 0) {
    for (const value2 of values2) {
      if (value2 != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
        max2 = value2;
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      if ((value2 = valueof(value2, ++index2, values2)) != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
        max2 = value2;
      }
    }
  }
  return max2;
}
function min$2(values2, valueof) {
  let min2;
  if (valueof === void 0) {
    for (const value2 of values2) {
      if (value2 != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
        min2 = value2;
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      if ((value2 = valueof(value2, ++index2, values2)) != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
        min2 = value2;
      }
    }
  }
  return min2;
}
function quickselect(array2, k, left = 0, right = Infinity, compare2) {
  k = Math.floor(k);
  left = Math.floor(Math.max(0, left));
  right = Math.floor(Math.min(array2.length - 1, right));
  if (!(left <= k && k <= right))
    return array2;
  compare2 = compare2 === void 0 ? ascendingDefined : compareDefined(compare2);
  while (right > left) {
    if (right - left > 600) {
      const n = right - left + 1;
      const m2 = k - left + 1;
      const z = Math.log(n);
      const s = 0.5 * Math.exp(2 * z / 3);
      const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m2 - n / 2 < 0 ? -1 : 1);
      const newLeft = Math.max(left, Math.floor(k - m2 * s / n + sd));
      const newRight = Math.min(right, Math.floor(k + (n - m2) * s / n + sd));
      quickselect(array2, k, newLeft, newRight, compare2);
    }
    const t = array2[k];
    let i = left;
    let j = right;
    swap$1(array2, left, k);
    if (compare2(array2[right], t) > 0)
      swap$1(array2, left, right);
    while (i < j) {
      swap$1(array2, i, j), ++i, --j;
      while (compare2(array2[i], t) < 0)
        ++i;
      while (compare2(array2[j], t) > 0)
        --j;
    }
    if (compare2(array2[left], t) === 0)
      swap$1(array2, left, j);
    else
      ++j, swap$1(array2, j, right);
    if (j <= k)
      left = j + 1;
    if (k <= j)
      right = j - 1;
  }
  return array2;
}
function swap$1(array2, i, j) {
  const t = array2[i];
  array2[i] = array2[j];
  array2[j] = t;
}
function quantile$1(values2, p, valueof) {
  values2 = Float64Array.from(numbers$2(values2, valueof));
  if (!(n = values2.length) || isNaN(p = +p))
    return;
  if (p <= 0 || n < 2)
    return min$2(values2);
  if (p >= 1)
    return max$2(values2);
  var n, i = (n - 1) * p, i0 = Math.floor(i), value0 = max$2(quickselect(values2, i0).subarray(0, i0 + 1)), value1 = min$2(values2.subarray(i0 + 1));
  return value0 + (value1 - value0) * (i - i0);
}
function quantileSorted(values2, p, valueof = number$6) {
  if (!(n = values2.length) || isNaN(p = +p))
    return;
  if (p <= 0 || n < 2)
    return +valueof(values2[0], 0, values2);
  if (p >= 1)
    return +valueof(values2[n - 1], n - 1, values2);
  var n, i = (n - 1) * p, i0 = Math.floor(i), value0 = +valueof(values2[i0], i0, values2), value1 = +valueof(values2[i0 + 1], i0 + 1, values2);
  return value0 + (value1 - value0) * (i - i0);
}
function mean(values2, valueof) {
  let count2 = 0;
  let sum2 = 0;
  if (valueof === void 0) {
    for (let value2 of values2) {
      if (value2 != null && (value2 = +value2) >= value2) {
        ++count2, sum2 += value2;
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      if ((value2 = valueof(value2, ++index2, values2)) != null && (value2 = +value2) >= value2) {
        ++count2, sum2 += value2;
      }
    }
  }
  if (count2)
    return sum2 / count2;
}
function median(values2, valueof) {
  return quantile$1(values2, 0.5, valueof);
}
function* flatten(arrays) {
  for (const array2 of arrays) {
    yield* array2;
  }
}
function merge$4(arrays) {
  return Array.from(flatten(arrays));
}
function range$4(start, stop2, step) {
  start = +start, stop2 = +stop2, step = (n = arguments.length) < 2 ? (stop2 = start, start = 0, 1) : n < 3 ? 1 : +step;
  var i = -1, n = Math.max(0, Math.ceil((stop2 - start) / step)) | 0, range2 = new Array(n);
  while (++i < n) {
    range2[i] = start + i * step;
  }
  return range2;
}
function sum$1(values2, valueof) {
  let sum2 = 0;
  {
    for (let value2 of values2) {
      if (value2 = +value2) {
        sum2 += value2;
      }
    }
  }
  return sum2;
}
function intersection(values2, ...others) {
  values2 = new InternSet(values2);
  others = others.map(set$3);
  out:
    for (const value2 of values2) {
      for (const other of others) {
        if (!other.has(value2)) {
          values2.delete(value2);
          continue out;
        }
      }
    }
  return values2;
}
function set$3(values2) {
  return values2 instanceof InternSet ? values2 : new InternSet(values2);
}
function union(...others) {
  const set2 = new InternSet();
  for (const other of others) {
    for (const o of other) {
      set2.add(o);
    }
  }
  return set2;
}
function define(constructor, factory, prototype2) {
  constructor.prototype = factory.prototype = prototype2;
  prototype2.constructor = constructor;
}
function extend$1(parent, definition2) {
  var prototype2 = Object.create(parent.prototype);
  for (var key2 in definition2)
    prototype2[key2] = definition2[key2];
  return prototype2;
}
function Color() {
}
var darker = 0.7;
var brighter = 1 / darker;
var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
var named = {
  aliceblue: 15792383,
  antiquewhite: 16444375,
  aqua: 65535,
  aquamarine: 8388564,
  azure: 15794175,
  beige: 16119260,
  bisque: 16770244,
  black: 0,
  blanchedalmond: 16772045,
  blue: 255,
  blueviolet: 9055202,
  brown: 10824234,
  burlywood: 14596231,
  cadetblue: 6266528,
  chartreuse: 8388352,
  chocolate: 13789470,
  coral: 16744272,
  cornflowerblue: 6591981,
  cornsilk: 16775388,
  crimson: 14423100,
  cyan: 65535,
  darkblue: 139,
  darkcyan: 35723,
  darkgoldenrod: 12092939,
  darkgray: 11119017,
  darkgreen: 25600,
  darkgrey: 11119017,
  darkkhaki: 12433259,
  darkmagenta: 9109643,
  darkolivegreen: 5597999,
  darkorange: 16747520,
  darkorchid: 10040012,
  darkred: 9109504,
  darksalmon: 15308410,
  darkseagreen: 9419919,
  darkslateblue: 4734347,
  darkslategray: 3100495,
  darkslategrey: 3100495,
  darkturquoise: 52945,
  darkviolet: 9699539,
  deeppink: 16716947,
  deepskyblue: 49151,
  dimgray: 6908265,
  dimgrey: 6908265,
  dodgerblue: 2003199,
  firebrick: 11674146,
  floralwhite: 16775920,
  forestgreen: 2263842,
  fuchsia: 16711935,
  gainsboro: 14474460,
  ghostwhite: 16316671,
  gold: 16766720,
  goldenrod: 14329120,
  gray: 8421504,
  green: 32768,
  greenyellow: 11403055,
  grey: 8421504,
  honeydew: 15794160,
  hotpink: 16738740,
  indianred: 13458524,
  indigo: 4915330,
  ivory: 16777200,
  khaki: 15787660,
  lavender: 15132410,
  lavenderblush: 16773365,
  lawngreen: 8190976,
  lemonchiffon: 16775885,
  lightblue: 11393254,
  lightcoral: 15761536,
  lightcyan: 14745599,
  lightgoldenrodyellow: 16448210,
  lightgray: 13882323,
  lightgreen: 9498256,
  lightgrey: 13882323,
  lightpink: 16758465,
  lightsalmon: 16752762,
  lightseagreen: 2142890,
  lightskyblue: 8900346,
  lightslategray: 7833753,
  lightslategrey: 7833753,
  lightsteelblue: 11584734,
  lightyellow: 16777184,
  lime: 65280,
  limegreen: 3329330,
  linen: 16445670,
  magenta: 16711935,
  maroon: 8388608,
  mediumaquamarine: 6737322,
  mediumblue: 205,
  mediumorchid: 12211667,
  mediumpurple: 9662683,
  mediumseagreen: 3978097,
  mediumslateblue: 8087790,
  mediumspringgreen: 64154,
  mediumturquoise: 4772300,
  mediumvioletred: 13047173,
  midnightblue: 1644912,
  mintcream: 16121850,
  mistyrose: 16770273,
  moccasin: 16770229,
  navajowhite: 16768685,
  navy: 128,
  oldlace: 16643558,
  olive: 8421376,
  olivedrab: 7048739,
  orange: 16753920,
  orangered: 16729344,
  orchid: 14315734,
  palegoldenrod: 15657130,
  palegreen: 10025880,
  paleturquoise: 11529966,
  palevioletred: 14381203,
  papayawhip: 16773077,
  peachpuff: 16767673,
  peru: 13468991,
  pink: 16761035,
  plum: 14524637,
  powderblue: 11591910,
  purple: 8388736,
  rebeccapurple: 6697881,
  red: 16711680,
  rosybrown: 12357519,
  royalblue: 4286945,
  saddlebrown: 9127187,
  salmon: 16416882,
  sandybrown: 16032864,
  seagreen: 3050327,
  seashell: 16774638,
  sienna: 10506797,
  silver: 12632256,
  skyblue: 8900331,
  slateblue: 6970061,
  slategray: 7372944,
  slategrey: 7372944,
  snow: 16775930,
  springgreen: 65407,
  steelblue: 4620980,
  tan: 13808780,
  teal: 32896,
  thistle: 14204888,
  tomato: 16737095,
  turquoise: 4251856,
  violet: 15631086,
  wheat: 16113331,
  white: 16777215,
  whitesmoke: 16119285,
  yellow: 16776960,
  yellowgreen: 10145074
};
define(Color, color$2, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});
function color_formatHex() {
  return this.rgb().formatHex();
}
function color_formatHex8() {
  return this.rgb().formatHex8();
}
function color_formatHsl() {
  return hslConvert(this).formatHsl();
}
function color_formatRgb() {
  return this.rgb().formatRgb();
}
function color$2(format2) {
  var m2, l;
  format2 = (format2 + "").trim().toLowerCase();
  return (m2 = reHex.exec(format2)) ? (l = m2[1].length, m2 = parseInt(m2[1], 16), l === 6 ? rgbn(m2) : l === 3 ? new Rgb(m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, (m2 & 15) << 4 | m2 & 15, 1) : l === 8 ? rgba(m2 >> 24 & 255, m2 >> 16 & 255, m2 >> 8 & 255, (m2 & 255) / 255) : l === 4 ? rgba(m2 >> 12 & 15 | m2 >> 8 & 240, m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, ((m2 & 15) << 4 | m2 & 15) / 255) : null) : (m2 = reRgbInteger.exec(format2)) ? new Rgb(m2[1], m2[2], m2[3], 1) : (m2 = reRgbPercent.exec(format2)) ? new Rgb(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, 1) : (m2 = reRgbaInteger.exec(format2)) ? rgba(m2[1], m2[2], m2[3], m2[4]) : (m2 = reRgbaPercent.exec(format2)) ? rgba(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, m2[4]) : (m2 = reHslPercent.exec(format2)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, 1) : (m2 = reHslaPercent.exec(format2)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, m2[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
}
function rgbn(n) {
  return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
}
function rgba(r, g, b2, a2) {
  if (a2 <= 0)
    r = g = b2 = NaN;
  return new Rgb(r, g, b2, a2);
}
function rgbConvert(o) {
  if (!(o instanceof Color))
    o = color$2(o);
  if (!o)
    return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}
function rgb(r, g, b2, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b2, opacity == null ? 1 : opacity);
}
function Rgb(r, g, b2, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b2;
  this.opacity = +opacity;
}
define(Rgb, rgb, extend$1(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb() {
    return this;
  },
  clamp() {
    return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
  },
  displayable() {
    return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatHex8: rgb_formatHex8,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));
function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}
function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}
function rgb_formatRgb() {
  const a2 = clampa(this.opacity);
  return `${a2 === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a2 === 1 ? ")" : `, ${a2})`}`;
}
function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}
function clampi(value2) {
  return Math.max(0, Math.min(255, Math.round(value2) || 0));
}
function hex(value2) {
  value2 = clampi(value2);
  return (value2 < 16 ? "0" : "") + value2.toString(16);
}
function hsla(h2, s, l, a2) {
  if (a2 <= 0)
    h2 = s = l = NaN;
  else if (l <= 0 || l >= 1)
    h2 = s = NaN;
  else if (s <= 0)
    h2 = NaN;
  return new Hsl(h2, s, l, a2);
}
function hslConvert(o) {
  if (o instanceof Hsl)
    return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color))
    o = color$2(o);
  if (!o)
    return new Hsl();
  if (o instanceof Hsl)
    return o;
  o = o.rgb();
  var r = o.r / 255, g = o.g / 255, b2 = o.b / 255, min2 = Math.min(r, g, b2), max2 = Math.max(r, g, b2), h2 = NaN, s = max2 - min2, l = (max2 + min2) / 2;
  if (s) {
    if (r === max2)
      h2 = (g - b2) / s + (g < b2) * 6;
    else if (g === max2)
      h2 = (b2 - r) / s + 2;
    else
      h2 = (r - g) / s + 4;
    s /= l < 0.5 ? max2 + min2 : 2 - max2 - min2;
    h2 *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h2;
  }
  return new Hsl(h2, s, l, o.opacity);
}
function hsl$2(h2, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h2) : new Hsl(h2, s, l, opacity == null ? 1 : opacity);
}
function Hsl(h2, s, l, opacity) {
  this.h = +h2;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}
define(Hsl, hsl$2, extend$1(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb() {
    var h2 = this.h % 360 + (this.h < 0) * 360, s = isNaN(h2) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h2 >= 240 ? h2 - 240 : h2 + 120, m1, m2),
      hsl2rgb(h2, m1, m2),
      hsl2rgb(h2 < 120 ? h2 + 240 : h2 - 120, m1, m2),
      this.opacity
    );
  },
  clamp() {
    return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
  },
  displayable() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl() {
    const a2 = clampa(this.opacity);
    return `${a2 === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a2 === 1 ? ")" : `, ${a2})`}`;
  }
}));
function clamph(value2) {
  value2 = (value2 || 0) % 360;
  return value2 < 0 ? value2 + 360 : value2;
}
function clampt(value2) {
  return Math.max(0, Math.min(1, value2 || 0));
}
function hsl2rgb(h2, m1, m2) {
  return (h2 < 60 ? m1 + (m2 - m1) * h2 / 60 : h2 < 180 ? m2 : h2 < 240 ? m1 + (m2 - m1) * (240 - h2) / 60 : m1) * 255;
}
const radians$1 = Math.PI / 180;
const degrees$2 = 180 / Math.PI;
const K = 18, Xn = 0.96422, Yn = 1, Zn = 0.82521, t0$2 = 4 / 29, t1$1 = 6 / 29, t2 = 3 * t1$1 * t1$1, t3 = t1$1 * t1$1 * t1$1;
function labConvert(o) {
  if (o instanceof Lab)
    return new Lab(o.l, o.a, o.b, o.opacity);
  if (o instanceof Hcl)
    return hcl2lab(o);
  if (!(o instanceof Rgb))
    o = rgbConvert(o);
  var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b2 = rgb2lrgb(o.b), y2 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b2) / Yn), x2, z;
  if (r === g && g === b2)
    x2 = z = y2;
  else {
    x2 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b2) / Xn);
    z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b2) / Zn);
  }
  return new Lab(116 * y2 - 16, 500 * (x2 - y2), 200 * (y2 - z), o.opacity);
}
function lab$1(l, a2, b2, opacity) {
  return arguments.length === 1 ? labConvert(l) : new Lab(l, a2, b2, opacity == null ? 1 : opacity);
}
function Lab(l, a2, b2, opacity) {
  this.l = +l;
  this.a = +a2;
  this.b = +b2;
  this.opacity = +opacity;
}
define(Lab, lab$1, extend$1(Color, {
  brighter(k) {
    return new Lab(this.l + K * (k == null ? 1 : k), this.a, this.b, this.opacity);
  },
  darker(k) {
    return new Lab(this.l - K * (k == null ? 1 : k), this.a, this.b, this.opacity);
  },
  rgb() {
    var y2 = (this.l + 16) / 116, x2 = isNaN(this.a) ? y2 : y2 + this.a / 500, z = isNaN(this.b) ? y2 : y2 - this.b / 200;
    x2 = Xn * lab2xyz(x2);
    y2 = Yn * lab2xyz(y2);
    z = Zn * lab2xyz(z);
    return new Rgb(
      lrgb2rgb(3.1338561 * x2 - 1.6168667 * y2 - 0.4906146 * z),
      lrgb2rgb(-0.9787684 * x2 + 1.9161415 * y2 + 0.033454 * z),
      lrgb2rgb(0.0719453 * x2 - 0.2289914 * y2 + 1.4052427 * z),
      this.opacity
    );
  }
}));
function xyz2lab(t) {
  return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0$2;
}
function lab2xyz(t) {
  return t > t1$1 ? t * t * t : t2 * (t - t0$2);
}
function lrgb2rgb(x2) {
  return 255 * (x2 <= 31308e-7 ? 12.92 * x2 : 1.055 * Math.pow(x2, 1 / 2.4) - 0.055);
}
function rgb2lrgb(x2) {
  return (x2 /= 255) <= 0.04045 ? x2 / 12.92 : Math.pow((x2 + 0.055) / 1.055, 2.4);
}
function hclConvert(o) {
  if (o instanceof Hcl)
    return new Hcl(o.h, o.c, o.l, o.opacity);
  if (!(o instanceof Lab))
    o = labConvert(o);
  if (o.a === 0 && o.b === 0)
    return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
  var h2 = Math.atan2(o.b, o.a) * degrees$2;
  return new Hcl(h2 < 0 ? h2 + 360 : h2, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
}
function hcl$1(h2, c2, l, opacity) {
  return arguments.length === 1 ? hclConvert(h2) : new Hcl(h2, c2, l, opacity == null ? 1 : opacity);
}
function Hcl(h2, c2, l, opacity) {
  this.h = +h2;
  this.c = +c2;
  this.l = +l;
  this.opacity = +opacity;
}
function hcl2lab(o) {
  if (isNaN(o.h))
    return new Lab(o.l, 0, 0, o.opacity);
  var h2 = o.h * radians$1;
  return new Lab(o.l, Math.cos(h2) * o.c, Math.sin(h2) * o.c, o.opacity);
}
define(Hcl, hcl$1, extend$1(Color, {
  brighter(k) {
    return new Hcl(this.h, this.c, this.l + K * (k == null ? 1 : k), this.opacity);
  },
  darker(k) {
    return new Hcl(this.h, this.c, this.l - K * (k == null ? 1 : k), this.opacity);
  },
  rgb() {
    return hcl2lab(this).rgb();
  }
}));
var A = -0.14861, B$1 = 1.78277, C$1 = -0.29227, D$1 = -0.90649, E = 1.97294, ED = E * D$1, EB = E * B$1, BC_DA = B$1 * C$1 - D$1 * A;
function cubehelixConvert(o) {
  if (o instanceof Cubehelix)
    return new Cubehelix(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Rgb))
    o = rgbConvert(o);
  var r = o.r / 255, g = o.g / 255, b2 = o.b / 255, l = (BC_DA * b2 + ED * r - EB * g) / (BC_DA + ED - EB), bl2 = b2 - l, k = (E * (g - l) - C$1 * bl2) / D$1, s = Math.sqrt(k * k + bl2 * bl2) / (E * l * (1 - l)), h2 = s ? Math.atan2(k, bl2) * degrees$2 - 120 : NaN;
  return new Cubehelix(h2 < 0 ? h2 + 360 : h2, s, l, o.opacity);
}
function cubehelix$2(h2, s, l, opacity) {
  return arguments.length === 1 ? cubehelixConvert(h2) : new Cubehelix(h2, s, l, opacity == null ? 1 : opacity);
}
function Cubehelix(h2, s, l, opacity) {
  this.h = +h2;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}
define(Cubehelix, cubehelix$2, extend$1(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Cubehelix(this.h, this.s, this.l * k, this.opacity);
  },
  rgb() {
    var h2 = isNaN(this.h) ? 0 : (this.h + 120) * radians$1, l = +this.l, a2 = isNaN(this.s) ? 0 : this.s * l * (1 - l), cosh2 = Math.cos(h2), sinh2 = Math.sin(h2);
    return new Rgb(
      255 * (l + a2 * (A * cosh2 + B$1 * sinh2)),
      255 * (l + a2 * (C$1 * cosh2 + D$1 * sinh2)),
      255 * (l + a2 * (E * cosh2)),
      this.opacity
    );
  }
}));
function basis(t12, v0, v1, v2, v3) {
  var t22 = t12 * t12, t32 = t22 * t12;
  return ((1 - 3 * t12 + 3 * t22 - t32) * v0 + (4 - 6 * t22 + 3 * t32) * v1 + (1 + 3 * t12 + 3 * t22 - 3 * t32) * v2 + t32 * v3) / 6;
}
function basis$1(values2) {
  var n = values2.length - 1;
  return function(t) {
    var i = t <= 0 ? t = 0 : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n), v1 = values2[i], v2 = values2[i + 1], v0 = i > 0 ? values2[i - 1] : 2 * v1 - v2, v3 = i < n - 1 ? values2[i + 2] : 2 * v2 - v1;
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}
function basisClosed(values2) {
  var n = values2.length;
  return function(t) {
    var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n), v0 = values2[(i + n - 1) % n], v1 = values2[i % n], v2 = values2[(i + 1) % n], v3 = values2[(i + 2) % n];
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}
const constant$4 = (x2) => () => x2;
function linear$2(a2, d) {
  return function(t) {
    return a2 + t * d;
  };
}
function exponential(a2, b2, y2) {
  return a2 = Math.pow(a2, y2), b2 = Math.pow(b2, y2) - a2, y2 = 1 / y2, function(t) {
    return Math.pow(a2 + t * b2, y2);
  };
}
function hue$1(a2, b2) {
  var d = b2 - a2;
  return d ? linear$2(a2, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant$4(isNaN(a2) ? b2 : a2);
}
function gamma(y2) {
  return (y2 = +y2) === 1 ? nogamma : function(a2, b2) {
    return b2 - a2 ? exponential(a2, b2, y2) : constant$4(isNaN(a2) ? b2 : a2);
  };
}
function nogamma(a2, b2) {
  var d = b2 - a2;
  return d ? linear$2(a2, d) : constant$4(isNaN(a2) ? b2 : a2);
}
const interpolateRgb = function rgbGamma(y2) {
  var color2 = gamma(y2);
  function rgb$1(start, end) {
    var r = color2((start = rgb(start)).r, (end = rgb(end)).r), g = color2(start.g, end.g), b2 = color2(start.b, end.b), opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.r = r(t);
      start.g = g(t);
      start.b = b2(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }
  rgb$1.gamma = rgbGamma;
  return rgb$1;
}(1);
function rgbSpline(spline) {
  return function(colors2) {
    var n = colors2.length, r = new Array(n), g = new Array(n), b2 = new Array(n), i, color2;
    for (i = 0; i < n; ++i) {
      color2 = rgb(colors2[i]);
      r[i] = color2.r || 0;
      g[i] = color2.g || 0;
      b2[i] = color2.b || 0;
    }
    r = spline(r);
    g = spline(g);
    b2 = spline(b2);
    color2.opacity = 1;
    return function(t) {
      color2.r = r(t);
      color2.g = g(t);
      color2.b = b2(t);
      return color2 + "";
    };
  };
}
var rgbBasis = rgbSpline(basis$1);
var rgbBasisClosed = rgbSpline(basisClosed);
function numberArray(a2, b2) {
  if (!b2)
    b2 = [];
  var n = a2 ? Math.min(b2.length, a2.length) : 0, c2 = b2.slice(), i;
  return function(t) {
    for (i = 0; i < n; ++i)
      c2[i] = a2[i] * (1 - t) + b2[i] * t;
    return c2;
  };
}
function isNumberArray(x2) {
  return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
}
function array$6(a2, b2) {
  return (isNumberArray(b2) ? numberArray : genericArray)(a2, b2);
}
function genericArray(a2, b2) {
  var nb = b2 ? b2.length : 0, na = a2 ? Math.min(nb, a2.length) : 0, x2 = new Array(na), c2 = new Array(nb), i;
  for (i = 0; i < na; ++i)
    x2[i] = interpolate$1(a2[i], b2[i]);
  for (; i < nb; ++i)
    c2[i] = b2[i];
  return function(t) {
    for (i = 0; i < na; ++i)
      c2[i] = x2[i](t);
    return c2;
  };
}
function date$1(a2, b2) {
  var d = /* @__PURE__ */ new Date();
  return a2 = +a2, b2 = +b2, function(t) {
    return d.setTime(a2 * (1 - t) + b2 * t), d;
  };
}
function interpolateNumber(a2, b2) {
  return a2 = +a2, b2 = +b2, function(t) {
    return a2 * (1 - t) + b2 * t;
  };
}
function object$1(a2, b2) {
  var i = {}, c2 = {}, k;
  if (a2 === null || typeof a2 !== "object")
    a2 = {};
  if (b2 === null || typeof b2 !== "object")
    b2 = {};
  for (k in b2) {
    if (k in a2) {
      i[k] = interpolate$1(a2[k], b2[k]);
    } else {
      c2[k] = b2[k];
    }
  }
  return function(t) {
    for (k in i)
      c2[k] = i[k](t);
    return c2;
  };
}
var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
function zero$2(b2) {
  return function() {
    return b2;
  };
}
function one$2(b2) {
  return function(t) {
    return b2(t) + "";
  };
}
function interpolateString(a2, b2) {
  var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i = -1, s = [], q = [];
  a2 = a2 + "", b2 = b2 + "";
  while ((am = reA.exec(a2)) && (bm = reB.exec(b2))) {
    if ((bs = bm.index) > bi) {
      bs = b2.slice(bi, bs);
      if (s[i])
        s[i] += bs;
      else
        s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      if (s[i])
        s[i] += bm;
      else
        s[++i] = bm;
    } else {
      s[++i] = null;
      q.push({ i, x: interpolateNumber(am, bm) });
    }
    bi = reB.lastIndex;
  }
  if (bi < b2.length) {
    bs = b2.slice(bi);
    if (s[i])
      s[i] += bs;
    else
      s[++i] = bs;
  }
  return s.length < 2 ? q[0] ? one$2(q[0].x) : zero$2(b2) : (b2 = q.length, function(t) {
    for (var i2 = 0, o; i2 < b2; ++i2)
      s[(o = q[i2]).i] = o.x(t);
    return s.join("");
  });
}
function interpolate$1(a2, b2) {
  var t = typeof b2, c2;
  return b2 == null || t === "boolean" ? constant$4(b2) : (t === "number" ? interpolateNumber : t === "string" ? (c2 = color$2(b2)) ? (b2 = c2, interpolateRgb) : interpolateString : b2 instanceof color$2 ? interpolateRgb : b2 instanceof Date ? date$1 : isNumberArray(b2) ? numberArray : Array.isArray(b2) ? genericArray : typeof b2.valueOf !== "function" && typeof b2.toString !== "function" || isNaN(b2) ? object$1 : interpolateNumber)(a2, b2);
}
function discrete$1(range2) {
  var n = range2.length;
  return function(t) {
    return range2[Math.max(0, Math.min(n - 1, Math.floor(t * n)))];
  };
}
function hue(a2, b2) {
  var i = hue$1(+a2, +b2);
  return function(t) {
    var x2 = i(t);
    return x2 - 360 * Math.floor(x2 / 360);
  };
}
function interpolateRound(a2, b2) {
  return a2 = +a2, b2 = +b2, function(t) {
    return Math.round(a2 * (1 - t) + b2 * t);
  };
}
var degrees$1 = 180 / Math.PI;
var identity$6 = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};
function decompose(a2, b2, c2, d, e, f) {
  var scaleX, scaleY2, skewX;
  if (scaleX = Math.sqrt(a2 * a2 + b2 * b2))
    a2 /= scaleX, b2 /= scaleX;
  if (skewX = a2 * c2 + b2 * d)
    c2 -= a2 * skewX, d -= b2 * skewX;
  if (scaleY2 = Math.sqrt(c2 * c2 + d * d))
    c2 /= scaleY2, d /= scaleY2, skewX /= scaleY2;
  if (a2 * d < b2 * c2)
    a2 = -a2, b2 = -b2, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b2, a2) * degrees$1,
    skewX: Math.atan(skewX) * degrees$1,
    scaleX,
    scaleY: scaleY2
  };
}
var svgNode;
function parseCss(value2) {
  const m2 = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value2 + "");
  return m2.isIdentity ? identity$6 : decompose(m2.a, m2.b, m2.c, m2.d, m2.e, m2.f);
}
function parseSvg(value2) {
  if (value2 == null)
    return identity$6;
  if (!svgNode)
    svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value2);
  if (!(value2 = svgNode.transform.baseVal.consolidate()))
    return identity$6;
  value2 = value2.matrix;
  return decompose(value2.a, value2.b, value2.c, value2.d, value2.e, value2.f);
}
function interpolateTransform(parse2, pxComma, pxParen, degParen) {
  function pop(s) {
    return s.length ? s.pop() + " " : "";
  }
  function translate2(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }
  function rotate2(a2, b2, s, q) {
    if (a2 !== b2) {
      if (a2 - b2 > 180)
        b2 += 360;
      else if (b2 - a2 > 180)
        a2 += 360;
      q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a2, b2) });
    } else if (b2) {
      s.push(pop(s) + "rotate(" + b2 + degParen);
    }
  }
  function skewX(a2, b2, s, q) {
    if (a2 !== b2) {
      q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a2, b2) });
    } else if (b2) {
      s.push(pop(s) + "skewX(" + b2 + degParen);
    }
  }
  function scale2(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop(s) + "scale(", null, ",", null, ")");
      q.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop(s) + "scale(" + xb + "," + yb + ")");
    }
  }
  return function(a2, b2) {
    var s = [], q = [];
    a2 = parse2(a2), b2 = parse2(b2);
    translate2(a2.translateX, a2.translateY, b2.translateX, b2.translateY, s, q);
    rotate2(a2.rotate, b2.rotate, s, q);
    skewX(a2.skewX, b2.skewX, s, q);
    scale2(a2.scaleX, a2.scaleY, b2.scaleX, b2.scaleY, s, q);
    a2 = b2 = null;
    return function(t) {
      var i = -1, n = q.length, o;
      while (++i < n)
        s[(o = q[i]).i] = o.x(t);
      return s.join("");
    };
  };
}
var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
var epsilon2$1 = 1e-12;
function cosh(x2) {
  return ((x2 = Math.exp(x2)) + 1 / x2) / 2;
}
function sinh(x2) {
  return ((x2 = Math.exp(x2)) - 1 / x2) / 2;
}
function tanh(x2) {
  return ((x2 = Math.exp(2 * x2)) - 1) / (x2 + 1);
}
const interpolateZoom = function zoomRho(rho, rho2, rho4) {
  function zoom2(p02, p1) {
    var ux0 = p02[0], uy0 = p02[1], w0 = p02[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
    if (d2 < epsilon2$1) {
      S = Math.log(w1 / w0) / rho;
      i = function(t) {
        return [
          ux0 + t * dx,
          uy0 + t * dy,
          w0 * Math.exp(rho * t * S)
        ];
      };
    } else {
      var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1), b1 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
      S = (r1 - r0) / rho;
      i = function(t) {
        var s = t * S, coshr0 = cosh(r0), u2 = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s + r0) - sinh(r0));
        return [
          ux0 + u2 * dx,
          uy0 + u2 * dy,
          w0 * coshr0 / cosh(rho * s + r0)
        ];
      };
    }
    i.duration = S * 1e3 * rho / Math.SQRT2;
    return i;
  }
  zoom2.rho = function(_) {
    var _1 = Math.max(1e-3, +_), _2 = _1 * _1, _4 = _2 * _2;
    return zoomRho(_1, _2, _4);
  };
  return zoom2;
}(Math.SQRT2, 2, 4);
function hsl(hue2) {
  return function(start, end) {
    var h2 = hue2((start = hsl$2(start)).h, (end = hsl$2(end)).h), s = nogamma(start.s, end.s), l = nogamma(start.l, end.l), opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.h = h2(t);
      start.s = s(t);
      start.l = l(t);
      start.opacity = opacity(t);
      return start + "";
    };
  };
}
const hsl$1 = hsl(hue$1);
var hslLong = hsl(nogamma);
function lab(start, end) {
  var l = nogamma((start = lab$1(start)).l, (end = lab$1(end)).l), a2 = nogamma(start.a, end.a), b2 = nogamma(start.b, end.b), opacity = nogamma(start.opacity, end.opacity);
  return function(t) {
    start.l = l(t);
    start.a = a2(t);
    start.b = b2(t);
    start.opacity = opacity(t);
    return start + "";
  };
}
function hcl(hue2) {
  return function(start, end) {
    var h2 = hue2((start = hcl$1(start)).h, (end = hcl$1(end)).h), c2 = nogamma(start.c, end.c), l = nogamma(start.l, end.l), opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.h = h2(t);
      start.c = c2(t);
      start.l = l(t);
      start.opacity = opacity(t);
      return start + "";
    };
  };
}
const interpolateHcl = hcl(hue$1);
var hclLong = hcl(nogamma);
function cubehelix(hue2) {
  return function cubehelixGamma(y2) {
    y2 = +y2;
    function cubehelix2(start, end) {
      var h2 = hue2((start = cubehelix$2(start)).h, (end = cubehelix$2(end)).h), s = nogamma(start.s, end.s), l = nogamma(start.l, end.l), opacity = nogamma(start.opacity, end.opacity);
      return function(t) {
        start.h = h2(t);
        start.s = s(t);
        start.l = l(Math.pow(t, y2));
        start.opacity = opacity(t);
        return start + "";
      };
    }
    cubehelix2.gamma = cubehelixGamma;
    return cubehelix2;
  }(1);
}
const cubehelix$1 = cubehelix(hue$1);
var cubehelixLong = cubehelix(nogamma);
function piecewise(interpolate2, values2) {
  if (values2 === void 0)
    values2 = interpolate2, interpolate2 = interpolate$1;
  var i = 0, n = values2.length - 1, v = values2[0], I = new Array(n < 0 ? 0 : n);
  while (i < n)
    I[i] = interpolate2(v, v = values2[++i]);
  return function(t) {
    var i2 = Math.max(0, Math.min(n - 1, Math.floor(t *= n)));
    return I[i2](t - i2);
  };
}
function quantize$2(interpolator, n) {
  var samples = new Array(n);
  for (var i = 0; i < n; ++i)
    samples[i] = interpolator(i / (n - 1));
  return samples;
}
const $$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  interpolate: interpolate$1,
  interpolateArray: array$6,
  interpolateBasis: basis$1,
  interpolateBasisClosed: basisClosed,
  interpolateCubehelix: cubehelix$1,
  interpolateCubehelixLong: cubehelixLong,
  interpolateDate: date$1,
  interpolateDiscrete: discrete$1,
  interpolateHcl,
  interpolateHclLong: hclLong,
  interpolateHsl: hsl$1,
  interpolateHslLong: hslLong,
  interpolateHue: hue,
  interpolateLab: lab,
  interpolateNumber,
  interpolateNumberArray: numberArray,
  interpolateObject: object$1,
  interpolateRgb,
  interpolateRgbBasis: rgbBasis,
  interpolateRgbBasisClosed: rgbBasisClosed,
  interpolateRound,
  interpolateString,
  interpolateTransformCss,
  interpolateTransformSvg,
  interpolateZoom,
  piecewise,
  quantize: quantize$2
}, Symbol.toStringTag, { value: "Module" }));
var frame = 0, timeout = 0, interval$1 = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f) {
  setTimeout(f, 17);
};
function now() {
  return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
}
function clearNow() {
  clockNow = 0;
}
function Timer$1() {
  this._call = this._time = this._next = null;
}
Timer$1.prototype = timer$1.prototype = {
  constructor: Timer$1,
  restart: function(callback, delay, time2) {
    if (typeof callback !== "function")
      throw new TypeError("callback is not a function");
    time2 = (time2 == null ? now() : +time2) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail)
        taskTail._next = this;
      else
        taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time2;
    sleep();
  },
  stop: function() {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  }
};
function timer$1(callback, delay, time2) {
  var t = new Timer$1();
  t.restart(callback, delay, time2);
  return t;
}
function timerFlush() {
  now();
  ++frame;
  var t = taskHead, e;
  while (t) {
    if ((e = clockNow - t._time) >= 0)
      t._call.call(void 0, e);
    t = t._next;
  }
  --frame;
}
function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  frame = timeout = 0;
  try {
    timerFlush();
  } finally {
    frame = 0;
    nap();
    clockNow = 0;
  }
}
function poke() {
  var now2 = clock.now(), delay = now2 - clockLast;
  if (delay > pokeDelay)
    clockSkew -= delay, clockLast = now2;
}
function nap() {
  var t02, t12 = taskHead, t22, time2 = Infinity;
  while (t12) {
    if (t12._call) {
      if (time2 > t12._time)
        time2 = t12._time;
      t02 = t12, t12 = t12._next;
    } else {
      t22 = t12._next, t12._next = null;
      t12 = t02 ? t02._next = t22 : taskHead = t22;
    }
  }
  taskTail = t02;
  sleep(time2);
}
function sleep(time2) {
  if (frame)
    return;
  if (timeout)
    timeout = clearTimeout(timeout);
  var delay = time2 - clockNow;
  if (delay > 24) {
    if (time2 < Infinity)
      timeout = setTimeout(wake, time2 - clock.now() - clockSkew);
    if (interval$1)
      interval$1 = clearInterval(interval$1);
  } else {
    if (!interval$1)
      clockLast = clock.now(), interval$1 = setInterval(poke, pokeDelay);
    frame = 1, setFrame(wake);
  }
}
function interval(callback, delay, time2) {
  var t = new Timer$1(), total = delay;
  if (delay == null)
    return t.restart(callback, delay, time2), t;
  t._restart = t.restart;
  t.restart = function(callback2, delay2, time3) {
    delay2 = +delay2, time3 = time3 == null ? now() : +time3;
    t._restart(function tick(elapsed) {
      elapsed += total;
      t._restart(tick, total += delay2, time3);
      callback2(elapsed);
    }, delay2, time3);
  };
  t.restart(callback, delay, time2);
  return t;
}
const pi$3 = Math.PI, tau$3 = 2 * pi$3, epsilon$6 = 1e-6, tauEpsilon = tau$3 - epsilon$6;
function append$1(strings) {
  this._ += strings[0];
  for (let i = 1, n = strings.length; i < n; ++i) {
    this._ += arguments[i] + strings[i];
  }
}
function appendRound$1(digits) {
  let d = Math.floor(digits);
  if (!(d >= 0))
    throw new Error(`invalid digits: ${digits}`);
  if (d > 15)
    return append$1;
  const k = 10 ** d;
  return function(strings) {
    this._ += strings[0];
    for (let i = 1, n = strings.length; i < n; ++i) {
      this._ += Math.round(arguments[i] * k) / k + strings[i];
    }
  };
}
let Path$1 = class Path {
  constructor(digits) {
    this._x0 = this._y0 = // start of current subpath
    this._x1 = this._y1 = null;
    this._ = "";
    this._append = digits == null ? append$1 : appendRound$1(digits);
  }
  moveTo(x2, y2) {
    this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}`;
  }
  closePath() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._append`Z`;
    }
  }
  lineTo(x2, y2) {
    this._append`L${this._x1 = +x2},${this._y1 = +y2}`;
  }
  quadraticCurveTo(x12, y12, x2, y2) {
    this._append`Q${+x12},${+y12},${this._x1 = +x2},${this._y1 = +y2}`;
  }
  bezierCurveTo(x12, y12, x2, y2, x3, y3) {
    this._append`C${+x12},${+y12},${+x2},${+y2},${this._x1 = +x3},${this._y1 = +y3}`;
  }
  arcTo(x12, y12, x2, y2, r) {
    x12 = +x12, y12 = +y12, x2 = +x2, y2 = +y2, r = +r;
    if (r < 0)
      throw new Error(`negative radius: ${r}`);
    let x02 = this._x1, y02 = this._y1, x21 = x2 - x12, y21 = y2 - y12, x01 = x02 - x12, y01 = y02 - y12, l01_2 = x01 * x01 + y01 * y01;
    if (this._x1 === null) {
      this._append`M${this._x1 = x12},${this._y1 = y12}`;
    } else if (!(l01_2 > epsilon$6))
      ;
    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$6) || !r) {
      this._append`L${this._x1 = x12},${this._y1 = y12}`;
    } else {
      let x20 = x2 - x02, y20 = y2 - y02, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi$3 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
      if (Math.abs(t01 - 1) > epsilon$6) {
        this._append`L${x12 + t01 * x01},${y12 + t01 * y01}`;
      }
      this._append`A${r},${r},0,0,${+(y01 * x20 > x01 * y20)},${this._x1 = x12 + t21 * x21},${this._y1 = y12 + t21 * y21}`;
    }
  }
  arc(x2, y2, r, a0, a1, ccw) {
    x2 = +x2, y2 = +y2, r = +r, ccw = !!ccw;
    if (r < 0)
      throw new Error(`negative radius: ${r}`);
    let dx = r * Math.cos(a0), dy = r * Math.sin(a0), x02 = x2 + dx, y02 = y2 + dy, cw2 = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
    if (this._x1 === null) {
      this._append`M${x02},${y02}`;
    } else if (Math.abs(this._x1 - x02) > epsilon$6 || Math.abs(this._y1 - y02) > epsilon$6) {
      this._append`L${x02},${y02}`;
    }
    if (!r)
      return;
    if (da < 0)
      da = da % tau$3 + tau$3;
    if (da > tauEpsilon) {
      this._append`A${r},${r},0,1,${cw2},${x2 - dx},${y2 - dy}A${r},${r},0,1,${cw2},${this._x1 = x02},${this._y1 = y02}`;
    } else if (da > epsilon$6) {
      this._append`A${r},${r},0,${+(da >= pi$3)},${cw2},${this._x1 = x2 + r * Math.cos(a1)},${this._y1 = y2 + r * Math.sin(a1)}`;
    }
  }
  rect(x2, y2, w2, h2) {
    this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}h${w2 = +w2}v${+h2}h${-w2}Z`;
  }
  toString() {
    return this._;
  }
};
function path$3() {
  return new Path$1();
}
path$3.prototype = Path$1.prototype;
const epsilon$5 = 11102230246251565e-32;
const splitter = 134217729;
const resulterrbound = (3 + 8 * epsilon$5) * epsilon$5;
function sum(elen, e, flen, f, h2) {
  let Q, Qnew, hh, bvirt;
  let enow = e[0];
  let fnow = f[0];
  let eindex = 0;
  let findex = 0;
  if (fnow > enow === fnow > -enow) {
    Q = enow;
    enow = e[++eindex];
  } else {
    Q = fnow;
    fnow = f[++findex];
  }
  let hindex = 0;
  if (eindex < elen && findex < flen) {
    if (fnow > enow === fnow > -enow) {
      Qnew = enow + Q;
      hh = Q - (Qnew - enow);
      enow = e[++eindex];
    } else {
      Qnew = fnow + Q;
      hh = Q - (Qnew - fnow);
      fnow = f[++findex];
    }
    Q = Qnew;
    if (hh !== 0) {
      h2[hindex++] = hh;
    }
    while (eindex < elen && findex < flen) {
      if (fnow > enow === fnow > -enow) {
        Qnew = Q + enow;
        bvirt = Qnew - Q;
        hh = Q - (Qnew - bvirt) + (enow - bvirt);
        enow = e[++eindex];
      } else {
        Qnew = Q + fnow;
        bvirt = Qnew - Q;
        hh = Q - (Qnew - bvirt) + (fnow - bvirt);
        fnow = f[++findex];
      }
      Q = Qnew;
      if (hh !== 0) {
        h2[hindex++] = hh;
      }
    }
  }
  while (eindex < elen) {
    Qnew = Q + enow;
    bvirt = Qnew - Q;
    hh = Q - (Qnew - bvirt) + (enow - bvirt);
    enow = e[++eindex];
    Q = Qnew;
    if (hh !== 0) {
      h2[hindex++] = hh;
    }
  }
  while (findex < flen) {
    Qnew = Q + fnow;
    bvirt = Qnew - Q;
    hh = Q - (Qnew - bvirt) + (fnow - bvirt);
    fnow = f[++findex];
    Q = Qnew;
    if (hh !== 0) {
      h2[hindex++] = hh;
    }
  }
  if (Q !== 0 || hindex === 0) {
    h2[hindex++] = Q;
  }
  return hindex;
}
function estimate(elen, e) {
  let Q = e[0];
  for (let i = 1; i < elen; i++)
    Q += e[i];
  return Q;
}
function vec(n) {
  return new Float64Array(n);
}
const ccwerrboundA = (3 + 16 * epsilon$5) * epsilon$5;
const ccwerrboundB = (2 + 12 * epsilon$5) * epsilon$5;
const ccwerrboundC = (9 + 64 * epsilon$5) * epsilon$5 * epsilon$5;
const B = vec(4);
const C1 = vec(8);
const C2 = vec(12);
const D = vec(16);
const u = vec(4);
function orient2dadapt(ax, ay, bx, by, cx, cy, detsum) {
  let acxtail, acytail, bcxtail, bcytail;
  let bvirt, c2, ahi, alo, bhi, blo, _i, _j, _0, s1, s0, t12, t02, u3;
  const acx = ax - cx;
  const bcx = bx - cx;
  const acy = ay - cy;
  const bcy = by - cy;
  s1 = acx * bcy;
  c2 = splitter * acx;
  ahi = c2 - (c2 - acx);
  alo = acx - ahi;
  c2 = splitter * bcy;
  bhi = c2 - (c2 - bcy);
  blo = bcy - bhi;
  s0 = alo * blo - (s1 - ahi * bhi - alo * bhi - ahi * blo);
  t12 = acy * bcx;
  c2 = splitter * acy;
  ahi = c2 - (c2 - acy);
  alo = acy - ahi;
  c2 = splitter * bcx;
  bhi = c2 - (c2 - bcx);
  blo = bcx - bhi;
  t02 = alo * blo - (t12 - ahi * bhi - alo * bhi - ahi * blo);
  _i = s0 - t02;
  bvirt = s0 - _i;
  B[0] = s0 - (_i + bvirt) + (bvirt - t02);
  _j = s1 + _i;
  bvirt = _j - s1;
  _0 = s1 - (_j - bvirt) + (_i - bvirt);
  _i = _0 - t12;
  bvirt = _0 - _i;
  B[1] = _0 - (_i + bvirt) + (bvirt - t12);
  u3 = _j + _i;
  bvirt = u3 - _j;
  B[2] = _j - (u3 - bvirt) + (_i - bvirt);
  B[3] = u3;
  let det = estimate(4, B);
  let errbound = ccwerrboundB * detsum;
  if (det >= errbound || -det >= errbound) {
    return det;
  }
  bvirt = ax - acx;
  acxtail = ax - (acx + bvirt) + (bvirt - cx);
  bvirt = bx - bcx;
  bcxtail = bx - (bcx + bvirt) + (bvirt - cx);
  bvirt = ay - acy;
  acytail = ay - (acy + bvirt) + (bvirt - cy);
  bvirt = by - bcy;
  bcytail = by - (bcy + bvirt) + (bvirt - cy);
  if (acxtail === 0 && acytail === 0 && bcxtail === 0 && bcytail === 0) {
    return det;
  }
  errbound = ccwerrboundC * detsum + resulterrbound * Math.abs(det);
  det += acx * bcytail + bcy * acxtail - (acy * bcxtail + bcx * acytail);
  if (det >= errbound || -det >= errbound)
    return det;
  s1 = acxtail * bcy;
  c2 = splitter * acxtail;
  ahi = c2 - (c2 - acxtail);
  alo = acxtail - ahi;
  c2 = splitter * bcy;
  bhi = c2 - (c2 - bcy);
  blo = bcy - bhi;
  s0 = alo * blo - (s1 - ahi * bhi - alo * bhi - ahi * blo);
  t12 = acytail * bcx;
  c2 = splitter * acytail;
  ahi = c2 - (c2 - acytail);
  alo = acytail - ahi;
  c2 = splitter * bcx;
  bhi = c2 - (c2 - bcx);
  blo = bcx - bhi;
  t02 = alo * blo - (t12 - ahi * bhi - alo * bhi - ahi * blo);
  _i = s0 - t02;
  bvirt = s0 - _i;
  u[0] = s0 - (_i + bvirt) + (bvirt - t02);
  _j = s1 + _i;
  bvirt = _j - s1;
  _0 = s1 - (_j - bvirt) + (_i - bvirt);
  _i = _0 - t12;
  bvirt = _0 - _i;
  u[1] = _0 - (_i + bvirt) + (bvirt - t12);
  u3 = _j + _i;
  bvirt = u3 - _j;
  u[2] = _j - (u3 - bvirt) + (_i - bvirt);
  u[3] = u3;
  const C1len = sum(4, B, 4, u, C1);
  s1 = acx * bcytail;
  c2 = splitter * acx;
  ahi = c2 - (c2 - acx);
  alo = acx - ahi;
  c2 = splitter * bcytail;
  bhi = c2 - (c2 - bcytail);
  blo = bcytail - bhi;
  s0 = alo * blo - (s1 - ahi * bhi - alo * bhi - ahi * blo);
  t12 = acy * bcxtail;
  c2 = splitter * acy;
  ahi = c2 - (c2 - acy);
  alo = acy - ahi;
  c2 = splitter * bcxtail;
  bhi = c2 - (c2 - bcxtail);
  blo = bcxtail - bhi;
  t02 = alo * blo - (t12 - ahi * bhi - alo * bhi - ahi * blo);
  _i = s0 - t02;
  bvirt = s0 - _i;
  u[0] = s0 - (_i + bvirt) + (bvirt - t02);
  _j = s1 + _i;
  bvirt = _j - s1;
  _0 = s1 - (_j - bvirt) + (_i - bvirt);
  _i = _0 - t12;
  bvirt = _0 - _i;
  u[1] = _0 - (_i + bvirt) + (bvirt - t12);
  u3 = _j + _i;
  bvirt = u3 - _j;
  u[2] = _j - (u3 - bvirt) + (_i - bvirt);
  u[3] = u3;
  const C2len = sum(C1len, C1, 4, u, C2);
  s1 = acxtail * bcytail;
  c2 = splitter * acxtail;
  ahi = c2 - (c2 - acxtail);
  alo = acxtail - ahi;
  c2 = splitter * bcytail;
  bhi = c2 - (c2 - bcytail);
  blo = bcytail - bhi;
  s0 = alo * blo - (s1 - ahi * bhi - alo * bhi - ahi * blo);
  t12 = acytail * bcxtail;
  c2 = splitter * acytail;
  ahi = c2 - (c2 - acytail);
  alo = acytail - ahi;
  c2 = splitter * bcxtail;
  bhi = c2 - (c2 - bcxtail);
  blo = bcxtail - bhi;
  t02 = alo * blo - (t12 - ahi * bhi - alo * bhi - ahi * blo);
  _i = s0 - t02;
  bvirt = s0 - _i;
  u[0] = s0 - (_i + bvirt) + (bvirt - t02);
  _j = s1 + _i;
  bvirt = _j - s1;
  _0 = s1 - (_j - bvirt) + (_i - bvirt);
  _i = _0 - t12;
  bvirt = _0 - _i;
  u[1] = _0 - (_i + bvirt) + (bvirt - t12);
  u3 = _j + _i;
  bvirt = u3 - _j;
  u[2] = _j - (u3 - bvirt) + (_i - bvirt);
  u[3] = u3;
  const Dlen = sum(C2len, C2, 4, u, D);
  return D[Dlen - 1];
}
function orient2d(ax, ay, bx, by, cx, cy) {
  const detleft = (ay - cy) * (bx - cx);
  const detright = (ax - cx) * (by - cy);
  const det = detleft - detright;
  const detsum = Math.abs(detleft + detright);
  if (Math.abs(det) >= ccwerrboundA * detsum)
    return det;
  return -orient2dadapt(ax, ay, bx, by, cx, cy, detsum);
}
const EPSILON$2 = Math.pow(2, -52);
const EDGE_STACK = new Uint32Array(512);
class Delaunator {
  static from(points2, getX = defaultGetX, getY = defaultGetY) {
    const n = points2.length;
    const coords = new Float64Array(n * 2);
    for (let i = 0; i < n; i++) {
      const p = points2[i];
      coords[2 * i] = getX(p);
      coords[2 * i + 1] = getY(p);
    }
    return new Delaunator(coords);
  }
  constructor(coords) {
    const n = coords.length >> 1;
    if (n > 0 && typeof coords[0] !== "number")
      throw new Error("Expected coords to contain numbers.");
    this.coords = coords;
    const maxTriangles = Math.max(2 * n - 5, 0);
    this._triangles = new Uint32Array(maxTriangles * 3);
    this._halfedges = new Int32Array(maxTriangles * 3);
    this._hashSize = Math.ceil(Math.sqrt(n));
    this._hullPrev = new Uint32Array(n);
    this._hullNext = new Uint32Array(n);
    this._hullTri = new Uint32Array(n);
    this._hullHash = new Int32Array(this._hashSize);
    this._ids = new Uint32Array(n);
    this._dists = new Float64Array(n);
    this.update();
  }
  update() {
    const { coords, _hullPrev: hullPrev, _hullNext: hullNext, _hullTri: hullTri, _hullHash: hullHash } = this;
    const n = coords.length >> 1;
    let minX = Infinity;
    let minY = Infinity;
    let maxX = -Infinity;
    let maxY2 = -Infinity;
    for (let i = 0; i < n; i++) {
      const x2 = coords[2 * i];
      const y2 = coords[2 * i + 1];
      if (x2 < minX)
        minX = x2;
      if (y2 < minY)
        minY = y2;
      if (x2 > maxX)
        maxX = x2;
      if (y2 > maxY2)
        maxY2 = y2;
      this._ids[i] = i;
    }
    const cx = (minX + maxX) / 2;
    const cy = (minY + maxY2) / 2;
    let i0, i1, i2;
    for (let i = 0, minDist = Infinity; i < n; i++) {
      const d = dist(cx, cy, coords[2 * i], coords[2 * i + 1]);
      if (d < minDist) {
        i0 = i;
        minDist = d;
      }
    }
    const i0x = coords[2 * i0];
    const i0y = coords[2 * i0 + 1];
    for (let i = 0, minDist = Infinity; i < n; i++) {
      if (i === i0)
        continue;
      const d = dist(i0x, i0y, coords[2 * i], coords[2 * i + 1]);
      if (d < minDist && d > 0) {
        i1 = i;
        minDist = d;
      }
    }
    let i1x = coords[2 * i1];
    let i1y = coords[2 * i1 + 1];
    let minRadius = Infinity;
    for (let i = 0; i < n; i++) {
      if (i === i0 || i === i1)
        continue;
      const r = circumradius(i0x, i0y, i1x, i1y, coords[2 * i], coords[2 * i + 1]);
      if (r < minRadius) {
        i2 = i;
        minRadius = r;
      }
    }
    let i2x = coords[2 * i2];
    let i2y = coords[2 * i2 + 1];
    if (minRadius === Infinity) {
      for (let i = 0; i < n; i++) {
        this._dists[i] = coords[2 * i] - coords[0] || coords[2 * i + 1] - coords[1];
      }
      quicksort(this._ids, this._dists, 0, n - 1);
      const hull = new Uint32Array(n);
      let j = 0;
      for (let i = 0, d0 = -Infinity; i < n; i++) {
        const id2 = this._ids[i];
        const d = this._dists[id2];
        if (d > d0) {
          hull[j++] = id2;
          d0 = d;
        }
      }
      this.hull = hull.subarray(0, j);
      this.triangles = new Uint32Array(0);
      this.halfedges = new Uint32Array(0);
      return;
    }
    if (orient2d(i0x, i0y, i1x, i1y, i2x, i2y) < 0) {
      const i = i1;
      const x2 = i1x;
      const y2 = i1y;
      i1 = i2;
      i1x = i2x;
      i1y = i2y;
      i2 = i;
      i2x = x2;
      i2y = y2;
    }
    const center = circumcenter(i0x, i0y, i1x, i1y, i2x, i2y);
    this._cx = center.x;
    this._cy = center.y;
    for (let i = 0; i < n; i++) {
      this._dists[i] = dist(coords[2 * i], coords[2 * i + 1], center.x, center.y);
    }
    quicksort(this._ids, this._dists, 0, n - 1);
    this._hullStart = i0;
    let hullSize = 3;
    hullNext[i0] = hullPrev[i2] = i1;
    hullNext[i1] = hullPrev[i0] = i2;
    hullNext[i2] = hullPrev[i1] = i0;
    hullTri[i0] = 0;
    hullTri[i1] = 1;
    hullTri[i2] = 2;
    hullHash.fill(-1);
    hullHash[this._hashKey(i0x, i0y)] = i0;
    hullHash[this._hashKey(i1x, i1y)] = i1;
    hullHash[this._hashKey(i2x, i2y)] = i2;
    this.trianglesLen = 0;
    this._addTriangle(i0, i1, i2, -1, -1, -1);
    for (let k = 0, xp, yp; k < this._ids.length; k++) {
      const i = this._ids[k];
      const x2 = coords[2 * i];
      const y2 = coords[2 * i + 1];
      if (k > 0 && Math.abs(x2 - xp) <= EPSILON$2 && Math.abs(y2 - yp) <= EPSILON$2)
        continue;
      xp = x2;
      yp = y2;
      if (i === i0 || i === i1 || i === i2)
        continue;
      let start = 0;
      for (let j = 0, key2 = this._hashKey(x2, y2); j < this._hashSize; j++) {
        start = hullHash[(key2 + j) % this._hashSize];
        if (start !== -1 && start !== hullNext[start])
          break;
      }
      start = hullPrev[start];
      let e = start, q;
      while (q = hullNext[e], orient2d(x2, y2, coords[2 * e], coords[2 * e + 1], coords[2 * q], coords[2 * q + 1]) >= 0) {
        e = q;
        if (e === start) {
          e = -1;
          break;
        }
      }
      if (e === -1)
        continue;
      let t = this._addTriangle(e, i, hullNext[e], -1, -1, hullTri[e]);
      hullTri[i] = this._legalize(t + 2);
      hullTri[e] = t;
      hullSize++;
      let n2 = hullNext[e];
      while (q = hullNext[n2], orient2d(x2, y2, coords[2 * n2], coords[2 * n2 + 1], coords[2 * q], coords[2 * q + 1]) < 0) {
        t = this._addTriangle(n2, i, q, hullTri[i], -1, hullTri[n2]);
        hullTri[i] = this._legalize(t + 2);
        hullNext[n2] = n2;
        hullSize--;
        n2 = q;
      }
      if (e === start) {
        while (q = hullPrev[e], orient2d(x2, y2, coords[2 * q], coords[2 * q + 1], coords[2 * e], coords[2 * e + 1]) < 0) {
          t = this._addTriangle(q, i, e, -1, hullTri[e], hullTri[q]);
          this._legalize(t + 2);
          hullTri[q] = t;
          hullNext[e] = e;
          hullSize--;
          e = q;
        }
      }
      this._hullStart = hullPrev[i] = e;
      hullNext[e] = hullPrev[n2] = i;
      hullNext[i] = n2;
      hullHash[this._hashKey(x2, y2)] = i;
      hullHash[this._hashKey(coords[2 * e], coords[2 * e + 1])] = e;
    }
    this.hull = new Uint32Array(hullSize);
    for (let i = 0, e = this._hullStart; i < hullSize; i++) {
      this.hull[i] = e;
      e = hullNext[e];
    }
    this.triangles = this._triangles.subarray(0, this.trianglesLen);
    this.halfedges = this._halfedges.subarray(0, this.trianglesLen);
  }
  _hashKey(x2, y2) {
    return Math.floor(pseudoAngle(x2 - this._cx, y2 - this._cy) * this._hashSize) % this._hashSize;
  }
  _legalize(a2) {
    const { _triangles: triangles, _halfedges: halfedges, coords } = this;
    let i = 0;
    let ar = 0;
    while (true) {
      const b2 = halfedges[a2];
      const a0 = a2 - a2 % 3;
      ar = a0 + (a2 + 2) % 3;
      if (b2 === -1) {
        if (i === 0)
          break;
        a2 = EDGE_STACK[--i];
        continue;
      }
      const b0 = b2 - b2 % 3;
      const al = a0 + (a2 + 1) % 3;
      const bl2 = b0 + (b2 + 2) % 3;
      const p02 = triangles[ar];
      const pr = triangles[a2];
      const pl = triangles[al];
      const p1 = triangles[bl2];
      const illegal = inCircle(
        coords[2 * p02],
        coords[2 * p02 + 1],
        coords[2 * pr],
        coords[2 * pr + 1],
        coords[2 * pl],
        coords[2 * pl + 1],
        coords[2 * p1],
        coords[2 * p1 + 1]
      );
      if (illegal) {
        triangles[a2] = p1;
        triangles[b2] = p02;
        const hbl = halfedges[bl2];
        if (hbl === -1) {
          let e = this._hullStart;
          do {
            if (this._hullTri[e] === bl2) {
              this._hullTri[e] = a2;
              break;
            }
            e = this._hullPrev[e];
          } while (e !== this._hullStart);
        }
        this._link(a2, hbl);
        this._link(b2, halfedges[ar]);
        this._link(ar, bl2);
        const br2 = b0 + (b2 + 1) % 3;
        if (i < EDGE_STACK.length) {
          EDGE_STACK[i++] = br2;
        }
      } else {
        if (i === 0)
          break;
        a2 = EDGE_STACK[--i];
      }
    }
    return ar;
  }
  _link(a2, b2) {
    this._halfedges[a2] = b2;
    if (b2 !== -1)
      this._halfedges[b2] = a2;
  }
  // add a new triangle given vertex indices and adjacent half-edge ids
  _addTriangle(i0, i1, i2, a2, b2, c2) {
    const t = this.trianglesLen;
    this._triangles[t] = i0;
    this._triangles[t + 1] = i1;
    this._triangles[t + 2] = i2;
    this._link(t, a2);
    this._link(t + 1, b2);
    this._link(t + 2, c2);
    this.trianglesLen += 3;
    return t;
  }
}
function pseudoAngle(dx, dy) {
  const p = dx / (Math.abs(dx) + Math.abs(dy));
  return (dy > 0 ? 3 - p : 1 + p) / 4;
}
function dist(ax, ay, bx, by) {
  const dx = ax - bx;
  const dy = ay - by;
  return dx * dx + dy * dy;
}
function inCircle(ax, ay, bx, by, cx, cy, px2, py2) {
  const dx = ax - px2;
  const dy = ay - py2;
  const ex = bx - px2;
  const ey = by - py2;
  const fx = cx - px2;
  const fy = cy - py2;
  const ap = dx * dx + dy * dy;
  const bp = ex * ex + ey * ey;
  const cp = fx * fx + fy * fy;
  return dx * (ey * cp - bp * fy) - dy * (ex * cp - bp * fx) + ap * (ex * fy - ey * fx) < 0;
}
function circumradius(ax, ay, bx, by, cx, cy) {
  const dx = bx - ax;
  const dy = by - ay;
  const ex = cx - ax;
  const ey = cy - ay;
  const bl2 = dx * dx + dy * dy;
  const cl = ex * ex + ey * ey;
  const d = 0.5 / (dx * ey - dy * ex);
  const x2 = (ey * bl2 - dy * cl) * d;
  const y2 = (dx * cl - ex * bl2) * d;
  return x2 * x2 + y2 * y2;
}
function circumcenter(ax, ay, bx, by, cx, cy) {
  const dx = bx - ax;
  const dy = by - ay;
  const ex = cx - ax;
  const ey = cy - ay;
  const bl2 = dx * dx + dy * dy;
  const cl = ex * ex + ey * ey;
  const d = 0.5 / (dx * ey - dy * ex);
  const x2 = ax + (ey * bl2 - dy * cl) * d;
  const y2 = ay + (dx * cl - ex * bl2) * d;
  return { x: x2, y: y2 };
}
function quicksort(ids, dists, left, right) {
  if (right - left <= 20) {
    for (let i = left + 1; i <= right; i++) {
      const temp2 = ids[i];
      const tempDist = dists[temp2];
      let j = i - 1;
      while (j >= left && dists[ids[j]] > tempDist)
        ids[j + 1] = ids[j--];
      ids[j + 1] = temp2;
    }
  } else {
    const median2 = left + right >> 1;
    let i = left + 1;
    let j = right;
    swap(ids, median2, i);
    if (dists[ids[left]] > dists[ids[right]])
      swap(ids, left, right);
    if (dists[ids[i]] > dists[ids[right]])
      swap(ids, i, right);
    if (dists[ids[left]] > dists[ids[i]])
      swap(ids, left, i);
    const temp2 = ids[i];
    const tempDist = dists[temp2];
    while (true) {
      do
        i++;
      while (dists[ids[i]] < tempDist);
      do
        j--;
      while (dists[ids[j]] > tempDist);
      if (j < i)
        break;
      swap(ids, i, j);
    }
    ids[left + 1] = ids[j];
    ids[j] = temp2;
    if (right - i + 1 >= j - left) {
      quicksort(ids, dists, i, right);
      quicksort(ids, dists, left, j - 1);
    } else {
      quicksort(ids, dists, left, j - 1);
      quicksort(ids, dists, i, right);
    }
  }
}
function swap(arr, i, j) {
  const tmp = arr[i];
  arr[i] = arr[j];
  arr[j] = tmp;
}
function defaultGetX(p) {
  return p[0];
}
function defaultGetY(p) {
  return p[1];
}
const epsilon$4 = 1e-6;
class Path2 {
  constructor() {
    this._x0 = this._y0 = // start of current subpath
    this._x1 = this._y1 = null;
    this._ = "";
  }
  moveTo(x2, y2) {
    this._ += `M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}`;
  }
  closePath() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._ += "Z";
    }
  }
  lineTo(x2, y2) {
    this._ += `L${this._x1 = +x2},${this._y1 = +y2}`;
  }
  arc(x2, y2, r) {
    x2 = +x2, y2 = +y2, r = +r;
    const x02 = x2 + r;
    const y02 = y2;
    if (r < 0)
      throw new Error("negative radius");
    if (this._x1 === null)
      this._ += `M${x02},${y02}`;
    else if (Math.abs(this._x1 - x02) > epsilon$4 || Math.abs(this._y1 - y02) > epsilon$4)
      this._ += "L" + x02 + "," + y02;
    if (!r)
      return;
    this._ += `A${r},${r},0,1,1,${x2 - r},${y2}A${r},${r},0,1,1,${this._x1 = x02},${this._y1 = y02}`;
  }
  rect(x2, y2, w2, h2) {
    this._ += `M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}h${+w2}v${+h2}h${-w2}Z`;
  }
  value() {
    return this._ || null;
  }
}
class Polygon {
  constructor() {
    this._ = [];
  }
  moveTo(x2, y2) {
    this._.push([x2, y2]);
  }
  closePath() {
    this._.push(this._[0].slice());
  }
  lineTo(x2, y2) {
    this._.push([x2, y2]);
  }
  value() {
    return this._.length ? this._ : null;
  }
}
let Voronoi$1 = class Voronoi {
  constructor(delaunay, [xmin, ymin, xmax, ymax] = [0, 0, 960, 500]) {
    if (!((xmax = +xmax) >= (xmin = +xmin)) || !((ymax = +ymax) >= (ymin = +ymin)))
      throw new Error("invalid bounds");
    this.delaunay = delaunay;
    this._circumcenters = new Float64Array(delaunay.points.length * 2);
    this.vectors = new Float64Array(delaunay.points.length * 2);
    this.xmax = xmax, this.xmin = xmin;
    this.ymax = ymax, this.ymin = ymin;
    this._init();
  }
  update() {
    this.delaunay.update();
    this._init();
    return this;
  }
  _init() {
    const { delaunay: { points: points2, hull, triangles }, vectors } = this;
    let bx, by;
    const circumcenters = this.circumcenters = this._circumcenters.subarray(0, triangles.length / 3 * 2);
    for (let i = 0, j = 0, n = triangles.length, x2, y2; i < n; i += 3, j += 2) {
      const t12 = triangles[i] * 2;
      const t22 = triangles[i + 1] * 2;
      const t32 = triangles[i + 2] * 2;
      const x13 = points2[t12];
      const y13 = points2[t12 + 1];
      const x22 = points2[t22];
      const y22 = points2[t22 + 1];
      const x3 = points2[t32];
      const y3 = points2[t32 + 1];
      const dx = x22 - x13;
      const dy = y22 - y13;
      const ex = x3 - x13;
      const ey = y3 - y13;
      const ab = (dx * ey - dy * ex) * 2;
      if (Math.abs(ab) < 1e-9) {
        if (bx === void 0) {
          bx = by = 0;
          for (const i2 of hull)
            bx += points2[i2 * 2], by += points2[i2 * 2 + 1];
          bx /= hull.length, by /= hull.length;
        }
        const a2 = 1e9 * Math.sign((bx - x13) * ey - (by - y13) * ex);
        x2 = (x13 + x3) / 2 - a2 * ey;
        y2 = (y13 + y3) / 2 + a2 * ex;
      } else {
        const d = 1 / ab;
        const bl2 = dx * dx + dy * dy;
        const cl = ex * ex + ey * ey;
        x2 = x13 + (ey * bl2 - dy * cl) * d;
        y2 = y13 + (dx * cl - ex * bl2) * d;
      }
      circumcenters[j] = x2;
      circumcenters[j + 1] = y2;
    }
    let h2 = hull[hull.length - 1];
    let p02, p1 = h2 * 4;
    let x02, x12 = points2[2 * h2];
    let y02, y12 = points2[2 * h2 + 1];
    vectors.fill(0);
    for (let i = 0; i < hull.length; ++i) {
      h2 = hull[i];
      p02 = p1, x02 = x12, y02 = y12;
      p1 = h2 * 4, x12 = points2[2 * h2], y12 = points2[2 * h2 + 1];
      vectors[p02 + 2] = vectors[p1] = y02 - y12;
      vectors[p02 + 3] = vectors[p1 + 1] = x12 - x02;
    }
  }
  render(context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const { delaunay: { halfedges, inedges, hull }, circumcenters, vectors } = this;
    if (hull.length <= 1)
      return null;
    for (let i = 0, n = halfedges.length; i < n; ++i) {
      const j = halfedges[i];
      if (j < i)
        continue;
      const ti = Math.floor(i / 3) * 2;
      const tj = Math.floor(j / 3) * 2;
      const xi = circumcenters[ti];
      const yi = circumcenters[ti + 1];
      const xj = circumcenters[tj];
      const yj = circumcenters[tj + 1];
      this._renderSegment(xi, yi, xj, yj, context2);
    }
    let h0, h1 = hull[hull.length - 1];
    for (let i = 0; i < hull.length; ++i) {
      h0 = h1, h1 = hull[i];
      const t = Math.floor(inedges[h1] / 3) * 2;
      const x2 = circumcenters[t];
      const y2 = circumcenters[t + 1];
      const v = h0 * 4;
      const p = this._project(x2, y2, vectors[v + 2], vectors[v + 3]);
      if (p)
        this._renderSegment(x2, y2, p[0], p[1], context2);
    }
    return buffer && buffer.value();
  }
  renderBounds(context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    context2.rect(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    return buffer && buffer.value();
  }
  renderCell(i, context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const points2 = this._clip(i);
    if (points2 === null || !points2.length)
      return;
    context2.moveTo(points2[0], points2[1]);
    let n = points2.length;
    while (points2[0] === points2[n - 2] && points2[1] === points2[n - 1] && n > 1)
      n -= 2;
    for (let i2 = 2; i2 < n; i2 += 2) {
      if (points2[i2] !== points2[i2 - 2] || points2[i2 + 1] !== points2[i2 - 1])
        context2.lineTo(points2[i2], points2[i2 + 1]);
    }
    context2.closePath();
    return buffer && buffer.value();
  }
  *cellPolygons() {
    const { delaunay: { points: points2 } } = this;
    for (let i = 0, n = points2.length / 2; i < n; ++i) {
      const cell2 = this.cellPolygon(i);
      if (cell2)
        cell2.index = i, yield cell2;
    }
  }
  cellPolygon(i) {
    const polygon = new Polygon();
    this.renderCell(i, polygon);
    return polygon.value();
  }
  _renderSegment(x02, y02, x12, y12, context2) {
    let S;
    const c0 = this._regioncode(x02, y02);
    const c1 = this._regioncode(x12, y12);
    if (c0 === 0 && c1 === 0) {
      context2.moveTo(x02, y02);
      context2.lineTo(x12, y12);
    } else if (S = this._clipSegment(x02, y02, x12, y12, c0, c1)) {
      context2.moveTo(S[0], S[1]);
      context2.lineTo(S[2], S[3]);
    }
  }
  contains(i, x2, y2) {
    if ((x2 = +x2, x2 !== x2) || (y2 = +y2, y2 !== y2))
      return false;
    return this.delaunay._step(i, x2, y2) === i;
  }
  *neighbors(i) {
    const ci = this._clip(i);
    if (ci)
      for (const j of this.delaunay.neighbors(i)) {
        const cj = this._clip(j);
        if (cj)
          loop:
            for (let ai = 0, li = ci.length; ai < li; ai += 2) {
              for (let aj = 0, lj = cj.length; aj < lj; aj += 2) {
                if (ci[ai] === cj[aj] && ci[ai + 1] === cj[aj + 1] && ci[(ai + 2) % li] === cj[(aj + lj - 2) % lj] && ci[(ai + 3) % li] === cj[(aj + lj - 1) % lj]) {
                  yield j;
                  break loop;
                }
              }
            }
      }
  }
  _cell(i) {
    const { circumcenters, delaunay: { inedges, halfedges, triangles } } = this;
    const e0 = inedges[i];
    if (e0 === -1)
      return null;
    const points2 = [];
    let e = e0;
    do {
      const t = Math.floor(e / 3);
      points2.push(circumcenters[t * 2], circumcenters[t * 2 + 1]);
      e = e % 3 === 2 ? e - 2 : e + 1;
      if (triangles[e] !== i)
        break;
      e = halfedges[e];
    } while (e !== e0 && e !== -1);
    return points2;
  }
  _clip(i) {
    if (i === 0 && this.delaunay.hull.length === 1) {
      return [this.xmax, this.ymin, this.xmax, this.ymax, this.xmin, this.ymax, this.xmin, this.ymin];
    }
    const points2 = this._cell(i);
    if (points2 === null)
      return null;
    const { vectors: V } = this;
    const v = i * 4;
    return this._simplify(V[v] || V[v + 1] ? this._clipInfinite(i, points2, V[v], V[v + 1], V[v + 2], V[v + 3]) : this._clipFinite(i, points2));
  }
  _clipFinite(i, points2) {
    const n = points2.length;
    let P = null;
    let x02, y02, x12 = points2[n - 2], y12 = points2[n - 1];
    let c0, c1 = this._regioncode(x12, y12);
    let e0, e1 = 0;
    for (let j = 0; j < n; j += 2) {
      x02 = x12, y02 = y12, x12 = points2[j], y12 = points2[j + 1];
      c0 = c1, c1 = this._regioncode(x12, y12);
      if (c0 === 0 && c1 === 0) {
        e0 = e1, e1 = 0;
        if (P)
          P.push(x12, y12);
        else
          P = [x12, y12];
      } else {
        let S, sx0, sy0, sx1, sy1;
        if (c0 === 0) {
          if ((S = this._clipSegment(x02, y02, x12, y12, c0, c1)) === null)
            continue;
          [sx0, sy0, sx1, sy1] = S;
        } else {
          if ((S = this._clipSegment(x12, y12, x02, y02, c1, c0)) === null)
            continue;
          [sx1, sy1, sx0, sy0] = S;
          e0 = e1, e1 = this._edgecode(sx0, sy0);
          if (e0 && e1)
            this._edge(i, e0, e1, P, P.length);
          if (P)
            P.push(sx0, sy0);
          else
            P = [sx0, sy0];
        }
        e0 = e1, e1 = this._edgecode(sx1, sy1);
        if (e0 && e1)
          this._edge(i, e0, e1, P, P.length);
        if (P)
          P.push(sx1, sy1);
        else
          P = [sx1, sy1];
      }
    }
    if (P) {
      e0 = e1, e1 = this._edgecode(P[0], P[1]);
      if (e0 && e1)
        this._edge(i, e0, e1, P, P.length);
    } else if (this.contains(i, (this.xmin + this.xmax) / 2, (this.ymin + this.ymax) / 2)) {
      return [this.xmax, this.ymin, this.xmax, this.ymax, this.xmin, this.ymax, this.xmin, this.ymin];
    }
    return P;
  }
  _clipSegment(x02, y02, x12, y12, c0, c1) {
    const flip2 = c0 < c1;
    if (flip2)
      [x02, y02, x12, y12, c0, c1] = [x12, y12, x02, y02, c1, c0];
    while (true) {
      if (c0 === 0 && c1 === 0)
        return flip2 ? [x12, y12, x02, y02] : [x02, y02, x12, y12];
      if (c0 & c1)
        return null;
      let x2, y2, c2 = c0 || c1;
      if (c2 & 8)
        x2 = x02 + (x12 - x02) * (this.ymax - y02) / (y12 - y02), y2 = this.ymax;
      else if (c2 & 4)
        x2 = x02 + (x12 - x02) * (this.ymin - y02) / (y12 - y02), y2 = this.ymin;
      else if (c2 & 2)
        y2 = y02 + (y12 - y02) * (this.xmax - x02) / (x12 - x02), x2 = this.xmax;
      else
        y2 = y02 + (y12 - y02) * (this.xmin - x02) / (x12 - x02), x2 = this.xmin;
      if (c0)
        x02 = x2, y02 = y2, c0 = this._regioncode(x02, y02);
      else
        x12 = x2, y12 = y2, c1 = this._regioncode(x12, y12);
    }
  }
  _clipInfinite(i, points2, vx0, vy0, vxn, vyn) {
    let P = Array.from(points2), p;
    if (p = this._project(P[0], P[1], vx0, vy0))
      P.unshift(p[0], p[1]);
    if (p = this._project(P[P.length - 2], P[P.length - 1], vxn, vyn))
      P.push(p[0], p[1]);
    if (P = this._clipFinite(i, P)) {
      for (let j = 0, n = P.length, c0, c1 = this._edgecode(P[n - 2], P[n - 1]); j < n; j += 2) {
        c0 = c1, c1 = this._edgecode(P[j], P[j + 1]);
        if (c0 && c1)
          j = this._edge(i, c0, c1, P, j), n = P.length;
      }
    } else if (this.contains(i, (this.xmin + this.xmax) / 2, (this.ymin + this.ymax) / 2)) {
      P = [this.xmin, this.ymin, this.xmax, this.ymin, this.xmax, this.ymax, this.xmin, this.ymax];
    }
    return P;
  }
  _edge(i, e0, e1, P, j) {
    while (e0 !== e1) {
      let x2, y2;
      switch (e0) {
        case 5:
          e0 = 4;
          continue;
        case 4:
          e0 = 6, x2 = this.xmax, y2 = this.ymin;
          break;
        case 6:
          e0 = 2;
          continue;
        case 2:
          e0 = 10, x2 = this.xmax, y2 = this.ymax;
          break;
        case 10:
          e0 = 8;
          continue;
        case 8:
          e0 = 9, x2 = this.xmin, y2 = this.ymax;
          break;
        case 9:
          e0 = 1;
          continue;
        case 1:
          e0 = 5, x2 = this.xmin, y2 = this.ymin;
          break;
      }
      if ((P[j] !== x2 || P[j + 1] !== y2) && this.contains(i, x2, y2)) {
        P.splice(j, 0, x2, y2), j += 2;
      }
    }
    return j;
  }
  _project(x02, y02, vx, vy) {
    let t = Infinity, c2, x2, y2;
    if (vy < 0) {
      if (y02 <= this.ymin)
        return null;
      if ((c2 = (this.ymin - y02) / vy) < t)
        y2 = this.ymin, x2 = x02 + (t = c2) * vx;
    } else if (vy > 0) {
      if (y02 >= this.ymax)
        return null;
      if ((c2 = (this.ymax - y02) / vy) < t)
        y2 = this.ymax, x2 = x02 + (t = c2) * vx;
    }
    if (vx > 0) {
      if (x02 >= this.xmax)
        return null;
      if ((c2 = (this.xmax - x02) / vx) < t)
        x2 = this.xmax, y2 = y02 + (t = c2) * vy;
    } else if (vx < 0) {
      if (x02 <= this.xmin)
        return null;
      if ((c2 = (this.xmin - x02) / vx) < t)
        x2 = this.xmin, y2 = y02 + (t = c2) * vy;
    }
    return [x2, y2];
  }
  _edgecode(x2, y2) {
    return (x2 === this.xmin ? 1 : x2 === this.xmax ? 2 : 0) | (y2 === this.ymin ? 4 : y2 === this.ymax ? 8 : 0);
  }
  _regioncode(x2, y2) {
    return (x2 < this.xmin ? 1 : x2 > this.xmax ? 2 : 0) | (y2 < this.ymin ? 4 : y2 > this.ymax ? 8 : 0);
  }
  _simplify(P) {
    if (P && P.length > 4) {
      for (let i = 0; i < P.length; i += 2) {
        const j = (i + 2) % P.length, k = (i + 4) % P.length;
        if (P[i] === P[j] && P[j] === P[k] || P[i + 1] === P[j + 1] && P[j + 1] === P[k + 1]) {
          P.splice(j, 2), i -= 2;
        }
      }
      if (!P.length)
        P = null;
    }
    return P;
  }
};
const tau$2 = 2 * Math.PI, pow$4 = Math.pow;
function pointX(p) {
  return p[0];
}
function pointY(p) {
  return p[1];
}
function collinear$1(d) {
  const { triangles, coords } = d;
  for (let i = 0; i < triangles.length; i += 3) {
    const a2 = 2 * triangles[i], b2 = 2 * triangles[i + 1], c2 = 2 * triangles[i + 2], cross2 = (coords[c2] - coords[a2]) * (coords[b2 + 1] - coords[a2 + 1]) - (coords[b2] - coords[a2]) * (coords[c2 + 1] - coords[a2 + 1]);
    if (cross2 > 1e-10)
      return false;
  }
  return true;
}
function jitter(x2, y2, r) {
  return [x2 + Math.sin(x2 + y2) * r, y2 + Math.cos(x2 - y2) * r];
}
class Delaunay {
  static from(points2, fx = pointX, fy = pointY, that) {
    return new Delaunay("length" in points2 ? flatArray(points2, fx, fy, that) : Float64Array.from(flatIterable(points2, fx, fy, that)));
  }
  constructor(points2) {
    this._delaunator = new Delaunator(points2);
    this.inedges = new Int32Array(points2.length / 2);
    this._hullIndex = new Int32Array(points2.length / 2);
    this.points = this._delaunator.coords;
    this._init();
  }
  update() {
    this._delaunator.update();
    this._init();
    return this;
  }
  _init() {
    const d = this._delaunator, points2 = this.points;
    if (d.hull && d.hull.length > 2 && collinear$1(d)) {
      this.collinear = Int32Array.from({ length: points2.length / 2 }, (_, i) => i).sort((i, j) => points2[2 * i] - points2[2 * j] || points2[2 * i + 1] - points2[2 * j + 1]);
      const e = this.collinear[0], f = this.collinear[this.collinear.length - 1], bounds2 = [points2[2 * e], points2[2 * e + 1], points2[2 * f], points2[2 * f + 1]], r = 1e-8 * Math.hypot(bounds2[3] - bounds2[1], bounds2[2] - bounds2[0]);
      for (let i = 0, n = points2.length / 2; i < n; ++i) {
        const p = jitter(points2[2 * i], points2[2 * i + 1], r);
        points2[2 * i] = p[0];
        points2[2 * i + 1] = p[1];
      }
      this._delaunator = new Delaunator(points2);
    } else {
      delete this.collinear;
    }
    const halfedges = this.halfedges = this._delaunator.halfedges;
    const hull = this.hull = this._delaunator.hull;
    const triangles = this.triangles = this._delaunator.triangles;
    const inedges = this.inedges.fill(-1);
    const hullIndex = this._hullIndex.fill(-1);
    for (let e = 0, n = halfedges.length; e < n; ++e) {
      const p = triangles[e % 3 === 2 ? e - 2 : e + 1];
      if (halfedges[e] === -1 || inedges[p] === -1)
        inedges[p] = e;
    }
    for (let i = 0, n = hull.length; i < n; ++i) {
      hullIndex[hull[i]] = i;
    }
    if (hull.length <= 2 && hull.length > 0) {
      this.triangles = new Int32Array(3).fill(-1);
      this.halfedges = new Int32Array(3).fill(-1);
      this.triangles[0] = hull[0];
      inedges[hull[0]] = 1;
      if (hull.length === 2) {
        inedges[hull[1]] = 0;
        this.triangles[1] = hull[1];
        this.triangles[2] = hull[1];
      }
    }
  }
  voronoi(bounds2) {
    return new Voronoi$1(this, bounds2);
  }
  *neighbors(i) {
    const { inedges, hull, _hullIndex, halfedges, triangles, collinear: collinear2 } = this;
    if (collinear2) {
      const l = collinear2.indexOf(i);
      if (l > 0)
        yield collinear2[l - 1];
      if (l < collinear2.length - 1)
        yield collinear2[l + 1];
      return;
    }
    const e0 = inedges[i];
    if (e0 === -1)
      return;
    let e = e0, p02 = -1;
    do {
      yield p02 = triangles[e];
      e = e % 3 === 2 ? e - 2 : e + 1;
      if (triangles[e] !== i)
        return;
      e = halfedges[e];
      if (e === -1) {
        const p = hull[(_hullIndex[i] + 1) % hull.length];
        if (p !== p02)
          yield p;
        return;
      }
    } while (e !== e0);
  }
  find(x2, y2, i = 0) {
    if ((x2 = +x2, x2 !== x2) || (y2 = +y2, y2 !== y2))
      return -1;
    const i0 = i;
    let c2;
    while ((c2 = this._step(i, x2, y2)) >= 0 && c2 !== i && c2 !== i0)
      i = c2;
    return c2;
  }
  _step(i, x2, y2) {
    const { inedges, hull, _hullIndex, halfedges, triangles, points: points2 } = this;
    if (inedges[i] === -1 || !points2.length)
      return (i + 1) % (points2.length >> 1);
    let c2 = i;
    let dc = pow$4(x2 - points2[i * 2], 2) + pow$4(y2 - points2[i * 2 + 1], 2);
    const e0 = inedges[i];
    let e = e0;
    do {
      let t = triangles[e];
      const dt = pow$4(x2 - points2[t * 2], 2) + pow$4(y2 - points2[t * 2 + 1], 2);
      if (dt < dc)
        dc = dt, c2 = t;
      e = e % 3 === 2 ? e - 2 : e + 1;
      if (triangles[e] !== i)
        break;
      e = halfedges[e];
      if (e === -1) {
        e = hull[(_hullIndex[i] + 1) % hull.length];
        if (e !== t) {
          if (pow$4(x2 - points2[e * 2], 2) + pow$4(y2 - points2[e * 2 + 1], 2) < dc)
            return e;
        }
        break;
      }
    } while (e !== e0);
    return c2;
  }
  render(context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const { points: points2, halfedges, triangles } = this;
    for (let i = 0, n = halfedges.length; i < n; ++i) {
      const j = halfedges[i];
      if (j < i)
        continue;
      const ti = triangles[i] * 2;
      const tj = triangles[j] * 2;
      context2.moveTo(points2[ti], points2[ti + 1]);
      context2.lineTo(points2[tj], points2[tj + 1]);
    }
    this.renderHull(context2);
    return buffer && buffer.value();
  }
  renderPoints(context2, r) {
    if (r === void 0 && (!context2 || typeof context2.moveTo !== "function"))
      r = context2, context2 = null;
    r = r == void 0 ? 2 : +r;
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const { points: points2 } = this;
    for (let i = 0, n = points2.length; i < n; i += 2) {
      const x2 = points2[i], y2 = points2[i + 1];
      context2.moveTo(x2 + r, y2);
      context2.arc(x2, y2, r, 0, tau$2);
    }
    return buffer && buffer.value();
  }
  renderHull(context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const { hull, points: points2 } = this;
    const h2 = hull[0] * 2, n = hull.length;
    context2.moveTo(points2[h2], points2[h2 + 1]);
    for (let i = 1; i < n; ++i) {
      const h3 = 2 * hull[i];
      context2.lineTo(points2[h3], points2[h3 + 1]);
    }
    context2.closePath();
    return buffer && buffer.value();
  }
  hullPolygon() {
    const polygon = new Polygon();
    this.renderHull(polygon);
    return polygon.value();
  }
  renderTriangle(i, context2) {
    const buffer = context2 == null ? context2 = new Path2() : void 0;
    const { points: points2, triangles } = this;
    const t02 = triangles[i *= 3] * 2;
    const t12 = triangles[i + 1] * 2;
    const t22 = triangles[i + 2] * 2;
    context2.moveTo(points2[t02], points2[t02 + 1]);
    context2.lineTo(points2[t12], points2[t12 + 1]);
    context2.lineTo(points2[t22], points2[t22 + 1]);
    context2.closePath();
    return buffer && buffer.value();
  }
  *trianglePolygons() {
    const { triangles } = this;
    for (let i = 0, n = triangles.length / 3; i < n; ++i) {
      yield this.trianglePolygon(i);
    }
  }
  trianglePolygon(i) {
    const polygon = new Polygon();
    this.renderTriangle(i, polygon);
    return polygon.value();
  }
}
function flatArray(points2, fx, fy, that) {
  const n = points2.length;
  const array2 = new Float64Array(n * 2);
  for (let i = 0; i < n; ++i) {
    const p = points2[i];
    array2[i * 2] = fx.call(that, p, i, points2);
    array2[i * 2 + 1] = fy.call(that, p, i, points2);
  }
  return array2;
}
function* flatIterable(points2, fx, fy, that) {
  let i = 0;
  for (const p of points2) {
    yield fx.call(that, p, i, points2);
    yield fy.call(that, p, i, points2);
    ++i;
  }
}
function forceCenter(x2, y2) {
  var nodes, strength = 1;
  if (x2 == null)
    x2 = 0;
  if (y2 == null)
    y2 = 0;
  function force2() {
    var i, n = nodes.length, node, sx = 0, sy = 0;
    for (i = 0; i < n; ++i) {
      node = nodes[i], sx += node.x, sy += node.y;
    }
    for (sx = (sx / n - x2) * strength, sy = (sy / n - y2) * strength, i = 0; i < n; ++i) {
      node = nodes[i], node.x -= sx, node.y -= sy;
    }
  }
  force2.initialize = function(_) {
    nodes = _;
  };
  force2.x = function(_) {
    return arguments.length ? (x2 = +_, force2) : x2;
  };
  force2.y = function(_) {
    return arguments.length ? (y2 = +_, force2) : y2;
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = +_, force2) : strength;
  };
  return force2;
}
function tree_add(d) {
  const x2 = +this._x.call(null, d), y2 = +this._y.call(null, d);
  return add$3(this.cover(x2, y2), x2, y2, d);
}
function add$3(tree2, x2, y2, d) {
  if (isNaN(x2) || isNaN(y2))
    return tree2;
  var parent, node = tree2._root, leaf = { data: d }, x02 = tree2._x0, y02 = tree2._y0, x12 = tree2._x1, y12 = tree2._y1, xm, ym, xp, yp, right, bottom, i, j;
  if (!node)
    return tree2._root = leaf, tree2;
  while (node.length) {
    if (right = x2 >= (xm = (x02 + x12) / 2))
      x02 = xm;
    else
      x12 = xm;
    if (bottom = y2 >= (ym = (y02 + y12) / 2))
      y02 = ym;
    else
      y12 = ym;
    if (parent = node, !(node = node[i = bottom << 1 | right]))
      return parent[i] = leaf, tree2;
  }
  xp = +tree2._x.call(null, node.data);
  yp = +tree2._y.call(null, node.data);
  if (x2 === xp && y2 === yp)
    return leaf.next = node, parent ? parent[i] = leaf : tree2._root = leaf, tree2;
  do {
    parent = parent ? parent[i] = new Array(4) : tree2._root = new Array(4);
    if (right = x2 >= (xm = (x02 + x12) / 2))
      x02 = xm;
    else
      x12 = xm;
    if (bottom = y2 >= (ym = (y02 + y12) / 2))
      y02 = ym;
    else
      y12 = ym;
  } while ((i = bottom << 1 | right) === (j = (yp >= ym) << 1 | xp >= xm));
  return parent[j] = node, parent[i] = leaf, tree2;
}
function addAll(data2) {
  var d, i, n = data2.length, x2, y2, xz = new Array(n), yz = new Array(n), x02 = Infinity, y02 = Infinity, x12 = -Infinity, y12 = -Infinity;
  for (i = 0; i < n; ++i) {
    if (isNaN(x2 = +this._x.call(null, d = data2[i])) || isNaN(y2 = +this._y.call(null, d)))
      continue;
    xz[i] = x2;
    yz[i] = y2;
    if (x2 < x02)
      x02 = x2;
    if (x2 > x12)
      x12 = x2;
    if (y2 < y02)
      y02 = y2;
    if (y2 > y12)
      y12 = y2;
  }
  if (x02 > x12 || y02 > y12)
    return this;
  this.cover(x02, y02).cover(x12, y12);
  for (i = 0; i < n; ++i) {
    add$3(this, xz[i], yz[i], data2[i]);
  }
  return this;
}
function tree_cover(x2, y2) {
  if (isNaN(x2 = +x2) || isNaN(y2 = +y2))
    return this;
  var x02 = this._x0, y02 = this._y0, x12 = this._x1, y12 = this._y1;
  if (isNaN(x02)) {
    x12 = (x02 = Math.floor(x2)) + 1;
    y12 = (y02 = Math.floor(y2)) + 1;
  } else {
    var z = x12 - x02 || 1, node = this._root, parent, i;
    while (x02 > x2 || x2 >= x12 || y02 > y2 || y2 >= y12) {
      i = (y2 < y02) << 1 | x2 < x02;
      parent = new Array(4), parent[i] = node, node = parent, z *= 2;
      switch (i) {
        case 0:
          x12 = x02 + z, y12 = y02 + z;
          break;
        case 1:
          x02 = x12 - z, y12 = y02 + z;
          break;
        case 2:
          x12 = x02 + z, y02 = y12 - z;
          break;
        case 3:
          x02 = x12 - z, y02 = y12 - z;
          break;
      }
    }
    if (this._root && this._root.length)
      this._root = node;
  }
  this._x0 = x02;
  this._y0 = y02;
  this._x1 = x12;
  this._y1 = y12;
  return this;
}
function tree_data() {
  var data2 = [];
  this.visit(function(node) {
    if (!node.length)
      do
        data2.push(node.data);
      while (node = node.next);
  });
  return data2;
}
function tree_extent(_) {
  return arguments.length ? this.cover(+_[0][0], +_[0][1]).cover(+_[1][0], +_[1][1]) : isNaN(this._x0) ? void 0 : [[this._x0, this._y0], [this._x1, this._y1]];
}
function Quad(node, x02, y02, x12, y12) {
  this.node = node;
  this.x0 = x02;
  this.y0 = y02;
  this.x1 = x12;
  this.y1 = y12;
}
function tree_find(x2, y2, radius2) {
  var data2, x02 = this._x0, y02 = this._y0, x12, y12, x22, y22, x3 = this._x1, y3 = this._y1, quads = [], node = this._root, q, i;
  if (node)
    quads.push(new Quad(node, x02, y02, x3, y3));
  if (radius2 == null)
    radius2 = Infinity;
  else {
    x02 = x2 - radius2, y02 = y2 - radius2;
    x3 = x2 + radius2, y3 = y2 + radius2;
    radius2 *= radius2;
  }
  while (q = quads.pop()) {
    if (!(node = q.node) || (x12 = q.x0) > x3 || (y12 = q.y0) > y3 || (x22 = q.x1) < x02 || (y22 = q.y1) < y02)
      continue;
    if (node.length) {
      var xm = (x12 + x22) / 2, ym = (y12 + y22) / 2;
      quads.push(
        new Quad(node[3], xm, ym, x22, y22),
        new Quad(node[2], x12, ym, xm, y22),
        new Quad(node[1], xm, y12, x22, ym),
        new Quad(node[0], x12, y12, xm, ym)
      );
      if (i = (y2 >= ym) << 1 | x2 >= xm) {
        q = quads[quads.length - 1];
        quads[quads.length - 1] = quads[quads.length - 1 - i];
        quads[quads.length - 1 - i] = q;
      }
    } else {
      var dx = x2 - +this._x.call(null, node.data), dy = y2 - +this._y.call(null, node.data), d2 = dx * dx + dy * dy;
      if (d2 < radius2) {
        var d = Math.sqrt(radius2 = d2);
        x02 = x2 - d, y02 = y2 - d;
        x3 = x2 + d, y3 = y2 + d;
        data2 = node.data;
      }
    }
  }
  return data2;
}
function tree_remove(d) {
  if (isNaN(x2 = +this._x.call(null, d)) || isNaN(y2 = +this._y.call(null, d)))
    return this;
  var parent, node = this._root, retainer, previous, next, x02 = this._x0, y02 = this._y0, x12 = this._x1, y12 = this._y1, x2, y2, xm, ym, right, bottom, i, j;
  if (!node)
    return this;
  if (node.length)
    while (true) {
      if (right = x2 >= (xm = (x02 + x12) / 2))
        x02 = xm;
      else
        x12 = xm;
      if (bottom = y2 >= (ym = (y02 + y12) / 2))
        y02 = ym;
      else
        y12 = ym;
      if (!(parent = node, node = node[i = bottom << 1 | right]))
        return this;
      if (!node.length)
        break;
      if (parent[i + 1 & 3] || parent[i + 2 & 3] || parent[i + 3 & 3])
        retainer = parent, j = i;
    }
  while (node.data !== d)
    if (!(previous = node, node = node.next))
      return this;
  if (next = node.next)
    delete node.next;
  if (previous)
    return next ? previous.next = next : delete previous.next, this;
  if (!parent)
    return this._root = next, this;
  next ? parent[i] = next : delete parent[i];
  if ((node = parent[0] || parent[1] || parent[2] || parent[3]) && node === (parent[3] || parent[2] || parent[1] || parent[0]) && !node.length) {
    if (retainer)
      retainer[j] = node;
    else
      this._root = node;
  }
  return this;
}
function removeAll(data2) {
  for (var i = 0, n = data2.length; i < n; ++i)
    this.remove(data2[i]);
  return this;
}
function tree_root() {
  return this._root;
}
function tree_size() {
  var size = 0;
  this.visit(function(node) {
    if (!node.length)
      do
        ++size;
      while (node = node.next);
  });
  return size;
}
function tree_visit(callback) {
  var quads = [], q, node = this._root, child, x02, y02, x12, y12;
  if (node)
    quads.push(new Quad(node, this._x0, this._y0, this._x1, this._y1));
  while (q = quads.pop()) {
    if (!callback(node = q.node, x02 = q.x0, y02 = q.y0, x12 = q.x1, y12 = q.y1) && node.length) {
      var xm = (x02 + x12) / 2, ym = (y02 + y12) / 2;
      if (child = node[3])
        quads.push(new Quad(child, xm, ym, x12, y12));
      if (child = node[2])
        quads.push(new Quad(child, x02, ym, xm, y12));
      if (child = node[1])
        quads.push(new Quad(child, xm, y02, x12, ym));
      if (child = node[0])
        quads.push(new Quad(child, x02, y02, xm, ym));
    }
  }
  return this;
}
function tree_visitAfter(callback) {
  var quads = [], next = [], q;
  if (this._root)
    quads.push(new Quad(this._root, this._x0, this._y0, this._x1, this._y1));
  while (q = quads.pop()) {
    var node = q.node;
    if (node.length) {
      var child, x02 = q.x0, y02 = q.y0, x12 = q.x1, y12 = q.y1, xm = (x02 + x12) / 2, ym = (y02 + y12) / 2;
      if (child = node[0])
        quads.push(new Quad(child, x02, y02, xm, ym));
      if (child = node[1])
        quads.push(new Quad(child, xm, y02, x12, ym));
      if (child = node[2])
        quads.push(new Quad(child, x02, ym, xm, y12));
      if (child = node[3])
        quads.push(new Quad(child, xm, ym, x12, y12));
    }
    next.push(q);
  }
  while (q = next.pop()) {
    callback(q.node, q.x0, q.y0, q.x1, q.y1);
  }
  return this;
}
function defaultX(d) {
  return d[0];
}
function tree_x(_) {
  return arguments.length ? (this._x = _, this) : this._x;
}
function defaultY(d) {
  return d[1];
}
function tree_y(_) {
  return arguments.length ? (this._y = _, this) : this._y;
}
function quadtree(nodes, x2, y2) {
  var tree2 = new Quadtree(x2 == null ? defaultX : x2, y2 == null ? defaultY : y2, NaN, NaN, NaN, NaN);
  return nodes == null ? tree2 : tree2.addAll(nodes);
}
function Quadtree(x2, y2, x02, y02, x12, y12) {
  this._x = x2;
  this._y = y2;
  this._x0 = x02;
  this._y0 = y02;
  this._x1 = x12;
  this._y1 = y12;
  this._root = void 0;
}
function leaf_copy(leaf) {
  var copy2 = { data: leaf.data }, next = copy2;
  while (leaf = leaf.next)
    next = next.next = { data: leaf.data };
  return copy2;
}
var treeProto = quadtree.prototype = Quadtree.prototype;
treeProto.copy = function() {
  var copy2 = new Quadtree(this._x, this._y, this._x0, this._y0, this._x1, this._y1), node = this._root, nodes, child;
  if (!node)
    return copy2;
  if (!node.length)
    return copy2._root = leaf_copy(node), copy2;
  nodes = [{ source: node, target: copy2._root = new Array(4) }];
  while (node = nodes.pop()) {
    for (var i = 0; i < 4; ++i) {
      if (child = node.source[i]) {
        if (child.length)
          nodes.push({ source: child, target: node.target[i] = new Array(4) });
        else
          node.target[i] = leaf_copy(child);
      }
    }
  }
  return copy2;
};
treeProto.add = tree_add;
treeProto.addAll = addAll;
treeProto.cover = tree_cover;
treeProto.data = tree_data;
treeProto.extent = tree_extent;
treeProto.find = tree_find;
treeProto.remove = tree_remove;
treeProto.removeAll = removeAll;
treeProto.root = tree_root;
treeProto.size = tree_size;
treeProto.visit = tree_visit;
treeProto.visitAfter = tree_visitAfter;
treeProto.x = tree_x;
treeProto.y = tree_y;
function constant$3(x2) {
  return function() {
    return x2;
  };
}
function jiggle(random2) {
  return (random2() - 0.5) * 1e-6;
}
function x$3(d) {
  return d.x + d.vx;
}
function y$3(d) {
  return d.y + d.vy;
}
function forceCollide(radius2) {
  var nodes, radii, random2, strength = 1, iterations2 = 1;
  if (typeof radius2 !== "function")
    radius2 = constant$3(radius2 == null ? 1 : +radius2);
  function force2() {
    var i, n = nodes.length, tree2, node, xi, yi, ri, ri2;
    for (var k = 0; k < iterations2; ++k) {
      tree2 = quadtree(nodes, x$3, y$3).visitAfter(prepare2);
      for (i = 0; i < n; ++i) {
        node = nodes[i];
        ri = radii[node.index], ri2 = ri * ri;
        xi = node.x + node.vx;
        yi = node.y + node.vy;
        tree2.visit(apply2);
      }
    }
    function apply2(quad2, x02, y02, x12, y12) {
      var data2 = quad2.data, rj = quad2.r, r = ri + rj;
      if (data2) {
        if (data2.index > node.index) {
          var x2 = xi - data2.x - data2.vx, y2 = yi - data2.y - data2.vy, l = x2 * x2 + y2 * y2;
          if (l < r * r) {
            if (x2 === 0)
              x2 = jiggle(random2), l += x2 * x2;
            if (y2 === 0)
              y2 = jiggle(random2), l += y2 * y2;
            l = (r - (l = Math.sqrt(l))) / l * strength;
            node.vx += (x2 *= l) * (r = (rj *= rj) / (ri2 + rj));
            node.vy += (y2 *= l) * r;
            data2.vx -= x2 * (r = 1 - r);
            data2.vy -= y2 * r;
          }
        }
        return;
      }
      return x02 > xi + r || x12 < xi - r || y02 > yi + r || y12 < yi - r;
    }
  }
  function prepare2(quad2) {
    if (quad2.data)
      return quad2.r = radii[quad2.data.index];
    for (var i = quad2.r = 0; i < 4; ++i) {
      if (quad2[i] && quad2[i].r > quad2.r) {
        quad2.r = quad2[i].r;
      }
    }
  }
  function initialize2() {
    if (!nodes)
      return;
    var i, n = nodes.length, node;
    radii = new Array(n);
    for (i = 0; i < n; ++i)
      node = nodes[i], radii[node.index] = +radius2(node, i, nodes);
  }
  force2.initialize = function(_nodes, _random) {
    nodes = _nodes;
    random2 = _random;
    initialize2();
  };
  force2.iterations = function(_) {
    return arguments.length ? (iterations2 = +_, force2) : iterations2;
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = +_, force2) : strength;
  };
  force2.radius = function(_) {
    return arguments.length ? (radius2 = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : radius2;
  };
  return force2;
}
function index$2(d) {
  return d.index;
}
function find$2(nodeById, nodeId) {
  var node = nodeById.get(nodeId);
  if (!node)
    throw new Error("node not found: " + nodeId);
  return node;
}
function forceLink(links) {
  var id2 = index$2, strength = defaultStrength, strengths, distance = constant$3(30), distances, nodes, count2, bias, random2, iterations2 = 1;
  if (links == null)
    links = [];
  function defaultStrength(link2) {
    return 1 / Math.min(count2[link2.source.index], count2[link2.target.index]);
  }
  function force2(alpha) {
    for (var k = 0, n = links.length; k < iterations2; ++k) {
      for (var i = 0, link2, source2, target2, x2, y2, l, b2; i < n; ++i) {
        link2 = links[i], source2 = link2.source, target2 = link2.target;
        x2 = target2.x + target2.vx - source2.x - source2.vx || jiggle(random2);
        y2 = target2.y + target2.vy - source2.y - source2.vy || jiggle(random2);
        l = Math.sqrt(x2 * x2 + y2 * y2);
        l = (l - distances[i]) / l * alpha * strengths[i];
        x2 *= l, y2 *= l;
        target2.vx -= x2 * (b2 = bias[i]);
        target2.vy -= y2 * b2;
        source2.vx += x2 * (b2 = 1 - b2);
        source2.vy += y2 * b2;
      }
    }
  }
  function initialize2() {
    if (!nodes)
      return;
    var i, n = nodes.length, m2 = links.length, nodeById = new Map(nodes.map((d, i2) => [id2(d, i2, nodes), d])), link2;
    for (i = 0, count2 = new Array(n); i < m2; ++i) {
      link2 = links[i], link2.index = i;
      if (typeof link2.source !== "object")
        link2.source = find$2(nodeById, link2.source);
      if (typeof link2.target !== "object")
        link2.target = find$2(nodeById, link2.target);
      count2[link2.source.index] = (count2[link2.source.index] || 0) + 1;
      count2[link2.target.index] = (count2[link2.target.index] || 0) + 1;
    }
    for (i = 0, bias = new Array(m2); i < m2; ++i) {
      link2 = links[i], bias[i] = count2[link2.source.index] / (count2[link2.source.index] + count2[link2.target.index]);
    }
    strengths = new Array(m2), initializeStrength();
    distances = new Array(m2), initializeDistance();
  }
  function initializeStrength() {
    if (!nodes)
      return;
    for (var i = 0, n = links.length; i < n; ++i) {
      strengths[i] = +strength(links[i], i, links);
    }
  }
  function initializeDistance() {
    if (!nodes)
      return;
    for (var i = 0, n = links.length; i < n; ++i) {
      distances[i] = +distance(links[i], i, links);
    }
  }
  force2.initialize = function(_nodes, _random) {
    nodes = _nodes;
    random2 = _random;
    initialize2();
  };
  force2.links = function(_) {
    return arguments.length ? (links = _, initialize2(), force2) : links;
  };
  force2.id = function(_) {
    return arguments.length ? (id2 = _, force2) : id2;
  };
  force2.iterations = function(_) {
    return arguments.length ? (iterations2 = +_, force2) : iterations2;
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : constant$3(+_), initializeStrength(), force2) : strength;
  };
  force2.distance = function(_) {
    return arguments.length ? (distance = typeof _ === "function" ? _ : constant$3(+_), initializeDistance(), force2) : distance;
  };
  return force2;
}
const a$1 = 1664525;
const c$1 = 1013904223;
const m$1 = 4294967296;
function lcg$2() {
  let s = 1;
  return () => (s = (a$1 * s + c$1) % m$1) / m$1;
}
function x$2(d) {
  return d.x;
}
function y$2(d) {
  return d.y;
}
var initialRadius = 10, initialAngle = Math.PI * (3 - Math.sqrt(5));
function forceSimulation(nodes) {
  var simulation2, alpha = 1, alphaMin = 1e-3, alphaDecay = 1 - Math.pow(alphaMin, 1 / 300), alphaTarget = 0, velocityDecay = 0.6, forces = /* @__PURE__ */ new Map(), stepper = timer$1(step), event2 = dispatch("tick", "end"), random2 = lcg$2();
  if (nodes == null)
    nodes = [];
  function step() {
    tick();
    event2.call("tick", simulation2);
    if (alpha < alphaMin) {
      stepper.stop();
      event2.call("end", simulation2);
    }
  }
  function tick(iterations2) {
    var i, n = nodes.length, node;
    if (iterations2 === void 0)
      iterations2 = 1;
    for (var k = 0; k < iterations2; ++k) {
      alpha += (alphaTarget - alpha) * alphaDecay;
      forces.forEach(function(force2) {
        force2(alpha);
      });
      for (i = 0; i < n; ++i) {
        node = nodes[i];
        if (node.fx == null)
          node.x += node.vx *= velocityDecay;
        else
          node.x = node.fx, node.vx = 0;
        if (node.fy == null)
          node.y += node.vy *= velocityDecay;
        else
          node.y = node.fy, node.vy = 0;
      }
    }
    return simulation2;
  }
  function initializeNodes() {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.index = i;
      if (node.fx != null)
        node.x = node.fx;
      if (node.fy != null)
        node.y = node.fy;
      if (isNaN(node.x) || isNaN(node.y)) {
        var radius2 = initialRadius * Math.sqrt(0.5 + i), angle2 = i * initialAngle;
        node.x = radius2 * Math.cos(angle2);
        node.y = radius2 * Math.sin(angle2);
      }
      if (isNaN(node.vx) || isNaN(node.vy)) {
        node.vx = node.vy = 0;
      }
    }
  }
  function initializeForce(force2) {
    if (force2.initialize)
      force2.initialize(nodes, random2);
    return force2;
  }
  initializeNodes();
  return simulation2 = {
    tick,
    restart: function() {
      return stepper.restart(step), simulation2;
    },
    stop: function() {
      return stepper.stop(), simulation2;
    },
    nodes: function(_) {
      return arguments.length ? (nodes = _, initializeNodes(), forces.forEach(initializeForce), simulation2) : nodes;
    },
    alpha: function(_) {
      return arguments.length ? (alpha = +_, simulation2) : alpha;
    },
    alphaMin: function(_) {
      return arguments.length ? (alphaMin = +_, simulation2) : alphaMin;
    },
    alphaDecay: function(_) {
      return arguments.length ? (alphaDecay = +_, simulation2) : +alphaDecay;
    },
    alphaTarget: function(_) {
      return arguments.length ? (alphaTarget = +_, simulation2) : alphaTarget;
    },
    velocityDecay: function(_) {
      return arguments.length ? (velocityDecay = 1 - _, simulation2) : 1 - velocityDecay;
    },
    randomSource: function(_) {
      return arguments.length ? (random2 = _, forces.forEach(initializeForce), simulation2) : random2;
    },
    force: function(name, _) {
      return arguments.length > 1 ? (_ == null ? forces.delete(name) : forces.set(name, initializeForce(_)), simulation2) : forces.get(name);
    },
    find: function(x2, y2, radius2) {
      var i = 0, n = nodes.length, dx, dy, d2, node, closest;
      if (radius2 == null)
        radius2 = Infinity;
      else
        radius2 *= radius2;
      for (i = 0; i < n; ++i) {
        node = nodes[i];
        dx = x2 - node.x;
        dy = y2 - node.y;
        d2 = dx * dx + dy * dy;
        if (d2 < radius2)
          closest = node, radius2 = d2;
      }
      return closest;
    },
    on: function(name, _) {
      return arguments.length > 1 ? (event2.on(name, _), simulation2) : event2.on(name);
    }
  };
}
function forceManyBody() {
  var nodes, node, random2, alpha, strength = constant$3(-30), strengths, distanceMin2 = 1, distanceMax2 = Infinity, theta2 = 0.81;
  function force2(_) {
    var i, n = nodes.length, tree2 = quadtree(nodes, x$2, y$2).visitAfter(accumulate);
    for (alpha = _, i = 0; i < n; ++i)
      node = nodes[i], tree2.visit(apply2);
  }
  function initialize2() {
    if (!nodes)
      return;
    var i, n = nodes.length, node2;
    strengths = new Array(n);
    for (i = 0; i < n; ++i)
      node2 = nodes[i], strengths[node2.index] = +strength(node2, i, nodes);
  }
  function accumulate(quad2) {
    var strength2 = 0, q, c2, weight = 0, x2, y2, i;
    if (quad2.length) {
      for (x2 = y2 = i = 0; i < 4; ++i) {
        if ((q = quad2[i]) && (c2 = Math.abs(q.value))) {
          strength2 += q.value, weight += c2, x2 += c2 * q.x, y2 += c2 * q.y;
        }
      }
      quad2.x = x2 / weight;
      quad2.y = y2 / weight;
    } else {
      q = quad2;
      q.x = q.data.x;
      q.y = q.data.y;
      do
        strength2 += strengths[q.data.index];
      while (q = q.next);
    }
    quad2.value = strength2;
  }
  function apply2(quad2, x12, _, x2) {
    if (!quad2.value)
      return true;
    var x3 = quad2.x - node.x, y2 = quad2.y - node.y, w2 = x2 - x12, l = x3 * x3 + y2 * y2;
    if (w2 * w2 / theta2 < l) {
      if (l < distanceMax2) {
        if (x3 === 0)
          x3 = jiggle(random2), l += x3 * x3;
        if (y2 === 0)
          y2 = jiggle(random2), l += y2 * y2;
        if (l < distanceMin2)
          l = Math.sqrt(distanceMin2 * l);
        node.vx += x3 * quad2.value * alpha / l;
        node.vy += y2 * quad2.value * alpha / l;
      }
      return true;
    } else if (quad2.length || l >= distanceMax2)
      return;
    if (quad2.data !== node || quad2.next) {
      if (x3 === 0)
        x3 = jiggle(random2), l += x3 * x3;
      if (y2 === 0)
        y2 = jiggle(random2), l += y2 * y2;
      if (l < distanceMin2)
        l = Math.sqrt(distanceMin2 * l);
    }
    do
      if (quad2.data !== node) {
        w2 = strengths[quad2.data.index] * alpha / l;
        node.vx += x3 * w2;
        node.vy += y2 * w2;
      }
    while (quad2 = quad2.next);
  }
  force2.initialize = function(_nodes, _random) {
    nodes = _nodes;
    random2 = _random;
    initialize2();
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : strength;
  };
  force2.distanceMin = function(_) {
    return arguments.length ? (distanceMin2 = _ * _, force2) : Math.sqrt(distanceMin2);
  };
  force2.distanceMax = function(_) {
    return arguments.length ? (distanceMax2 = _ * _, force2) : Math.sqrt(distanceMax2);
  };
  force2.theta = function(_) {
    return arguments.length ? (theta2 = _ * _, force2) : Math.sqrt(theta2);
  };
  return force2;
}
function forceX(x2) {
  var strength = constant$3(0.1), nodes, strengths, xz;
  if (typeof x2 !== "function")
    x2 = constant$3(x2 == null ? 0 : +x2);
  function force2(alpha) {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.vx += (xz[i] - node.x) * strengths[i] * alpha;
    }
  }
  function initialize2() {
    if (!nodes)
      return;
    var i, n = nodes.length;
    strengths = new Array(n);
    xz = new Array(n);
    for (i = 0; i < n; ++i) {
      strengths[i] = isNaN(xz[i] = +x2(nodes[i], i, nodes)) ? 0 : +strength(nodes[i], i, nodes);
    }
  }
  force2.initialize = function(_) {
    nodes = _;
    initialize2();
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : strength;
  };
  force2.x = function(_) {
    return arguments.length ? (x2 = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : x2;
  };
  return force2;
}
function forceY(y2) {
  var strength = constant$3(0.1), nodes, strengths, yz;
  if (typeof y2 !== "function")
    y2 = constant$3(y2 == null ? 0 : +y2);
  function force2(alpha) {
    for (var i = 0, n = nodes.length, node; i < n; ++i) {
      node = nodes[i], node.vy += (yz[i] - node.y) * strengths[i] * alpha;
    }
  }
  function initialize2() {
    if (!nodes)
      return;
    var i, n = nodes.length;
    strengths = new Array(n);
    yz = new Array(n);
    for (i = 0; i < n; ++i) {
      strengths[i] = isNaN(yz[i] = +y2(nodes[i], i, nodes)) ? 0 : +strength(nodes[i], i, nodes);
    }
  }
  force2.initialize = function(_) {
    nodes = _;
    initialize2();
  };
  force2.strength = function(_) {
    return arguments.length ? (strength = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : strength;
  };
  force2.y = function(_) {
    return arguments.length ? (y2 = typeof _ === "function" ? _ : constant$3(+_), initialize2(), force2) : y2;
  };
  return force2;
}
function formatDecimal(x2) {
  return Math.abs(x2 = Math.round(x2)) >= 1e21 ? x2.toLocaleString("en").replace(/,/g, "") : x2.toString(10);
}
function formatDecimalParts(x2, p) {
  if ((i = (x2 = p ? x2.toExponential(p - 1) : x2.toExponential()).indexOf("e")) < 0)
    return null;
  var i, coefficient = x2.slice(0, i);
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x2.slice(i + 1)
  ];
}
function exponent(x2) {
  return x2 = formatDecimalParts(Math.abs(x2)), x2 ? x2[1] : NaN;
}
function formatGroup(grouping, thousands) {
  return function(value2, width2) {
    var i = value2.length, t = [], j = 0, g = grouping[0], length2 = 0;
    while (i > 0 && g > 0) {
      if (length2 + g + 1 > width2)
        g = Math.max(1, width2 - length2);
      t.push(value2.substring(i -= g, i + g));
      if ((length2 += g + 1) > width2)
        break;
      g = grouping[j = (j + 1) % grouping.length];
    }
    return t.reverse().join(thousands);
  };
}
function formatNumerals(numerals) {
  return function(value2) {
    return value2.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}
var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
function formatSpecifier(specifier) {
  if (!(match2 = re.exec(specifier)))
    throw new Error("invalid format: " + specifier);
  var match2;
  return new FormatSpecifier({
    fill: match2[1],
    align: match2[2],
    sign: match2[3],
    symbol: match2[4],
    zero: match2[5],
    width: match2[6],
    comma: match2[7],
    precision: match2[8] && match2[8].slice(1),
    trim: match2[9],
    type: match2[10]
  });
}
formatSpecifier.prototype = FormatSpecifier.prototype;
function FormatSpecifier(specifier) {
  this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
  this.align = specifier.align === void 0 ? ">" : specifier.align + "";
  this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === void 0 ? void 0 : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === void 0 ? "" : specifier.type + "";
}
FormatSpecifier.prototype.toString = function() {
  return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
};
function formatTrim(s) {
  out:
    for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
      switch (s[i]) {
        case ".":
          i0 = i1 = i;
          break;
        case "0":
          if (i0 === 0)
            i0 = i;
          i1 = i;
          break;
        default:
          if (!+s[i])
            break out;
          if (i0 > 0)
            i0 = 0;
          break;
      }
    }
  return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
}
var prefixExponent;
function formatPrefixAuto(x2, p) {
  var d = formatDecimalParts(x2, p);
  if (!d)
    return x2 + "";
  var coefficient = d[0], exponent2 = d[1], i = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
  return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + formatDecimalParts(x2, Math.max(0, p + i - 1))[0];
}
function formatRounded(x2, p) {
  var d = formatDecimalParts(x2, p);
  if (!d)
    return x2 + "";
  var coefficient = d[0], exponent2 = d[1];
  return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
}
const formatTypes = {
  "%": (x2, p) => (x2 * 100).toFixed(p),
  "b": (x2) => Math.round(x2).toString(2),
  "c": (x2) => x2 + "",
  "d": formatDecimal,
  "e": (x2, p) => x2.toExponential(p),
  "f": (x2, p) => x2.toFixed(p),
  "g": (x2, p) => x2.toPrecision(p),
  "o": (x2) => Math.round(x2).toString(8),
  "p": (x2, p) => formatRounded(x2 * 100, p),
  "r": formatRounded,
  "s": formatPrefixAuto,
  "X": (x2) => Math.round(x2).toString(16).toUpperCase(),
  "x": (x2) => Math.round(x2).toString(16)
};
function identity$5(x2) {
  return x2;
}
var map$1 = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
function formatLocale$1(locale2) {
  var group2 = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$5 : formatGroup(map$1.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$5 : formatNumerals(map$1.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "−" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);
    var fill2 = specifier.fill, align = specifier.align, sign2 = specifier.sign, symbol2 = specifier.symbol, zero2 = specifier.zero, width2 = specifier.width, comma = specifier.comma, precision = specifier.precision, trim = specifier.trim, type2 = specifier.type;
    if (type2 === "n")
      comma = true, type2 = "g";
    else if (!formatTypes[type2])
      precision === void 0 && (precision = 12), trim = true, type2 = "g";
    if (zero2 || fill2 === "0" && align === "=")
      zero2 = true, fill2 = "0", align = "=";
    var prefix = symbol2 === "$" ? currencyPrefix : symbol2 === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol2 === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
    var formatType = formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
    precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
    function format2(value2) {
      var valuePrefix = prefix, valueSuffix = suffix, i, n, c2;
      if (type2 === "c") {
        valueSuffix = formatType(value2) + valueSuffix;
        value2 = "";
      } else {
        value2 = +value2;
        var valueNegative = value2 < 0 || 1 / value2 < 0;
        value2 = isNaN(value2) ? nan : formatType(Math.abs(value2), precision);
        if (trim)
          value2 = formatTrim(value2);
        if (valueNegative && +value2 === 0 && sign2 !== "+")
          valueNegative = false;
        valuePrefix = (valueNegative ? sign2 === "(" ? sign2 : minus : sign2 === "-" || sign2 === "(" ? "" : sign2) + valuePrefix;
        valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign2 === "(" ? ")" : "");
        if (maybeSuffix) {
          i = -1, n = value2.length;
          while (++i < n) {
            if (c2 = value2.charCodeAt(i), 48 > c2 || c2 > 57) {
              valueSuffix = (c2 === 46 ? decimal + value2.slice(i + 1) : value2.slice(i)) + valueSuffix;
              value2 = value2.slice(0, i);
              break;
            }
          }
        }
      }
      if (comma && !zero2)
        value2 = group2(value2, Infinity);
      var length2 = valuePrefix.length + value2.length + valueSuffix.length, padding2 = length2 < width2 ? new Array(width2 - length2 + 1).join(fill2) : "";
      if (comma && zero2)
        value2 = group2(padding2 + value2, padding2.length ? width2 - valueSuffix.length : Infinity), padding2 = "";
      switch (align) {
        case "<":
          value2 = valuePrefix + value2 + valueSuffix + padding2;
          break;
        case "=":
          value2 = valuePrefix + padding2 + value2 + valueSuffix;
          break;
        case "^":
          value2 = padding2.slice(0, length2 = padding2.length >> 1) + valuePrefix + value2 + valueSuffix + padding2.slice(length2);
          break;
        default:
          value2 = padding2 + valuePrefix + value2 + valueSuffix;
          break;
      }
      return numerals(value2);
    }
    format2.toString = function() {
      return specifier + "";
    };
    return format2;
  }
  function formatPrefix2(specifier, value2) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
    return function(value3) {
      return f(k * value3) + prefix;
    };
  }
  return {
    format: newFormat,
    formatPrefix: formatPrefix2
  };
}
var locale$2;
var format$4;
var formatPrefix;
defaultLocale$2({
  thousands: ",",
  grouping: [3],
  currency: ["$", ""]
});
function defaultLocale$2(definition2) {
  locale$2 = formatLocale$1(definition2);
  format$4 = locale$2.format;
  formatPrefix = locale$2.formatPrefix;
  return locale$2;
}
function precisionFixed(step) {
  return Math.max(0, -exponent(Math.abs(step)));
}
function precisionPrefix(step, value2) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3 - exponent(Math.abs(step)));
}
function precisionRound(step, max2) {
  step = Math.abs(step), max2 = Math.abs(max2) - step;
  return Math.max(0, exponent(max2) - exponent(step)) + 1;
}
var epsilon$3 = 1e-6;
var epsilon2 = 1e-12;
var pi$2 = Math.PI;
var halfPi$2 = pi$2 / 2;
var quarterPi = pi$2 / 4;
var tau$1 = pi$2 * 2;
var degrees = 180 / pi$2;
var radians = pi$2 / 180;
var abs$2 = Math.abs;
var atan = Math.atan;
var atan2$1 = Math.atan2;
var cos$2 = Math.cos;
var ceil = Math.ceil;
var exp$2 = Math.exp;
var hypot = Math.hypot;
var log$5 = Math.log;
var pow$3 = Math.pow;
var sin$2 = Math.sin;
var sign$1 = Math.sign || function(x2) {
  return x2 > 0 ? 1 : x2 < 0 ? -1 : 0;
};
var sqrt$3 = Math.sqrt;
var tan = Math.tan;
function acos$1(x2) {
  return x2 > 1 ? 0 : x2 < -1 ? pi$2 : Math.acos(x2);
}
function asin$2(x2) {
  return x2 > 1 ? halfPi$2 : x2 < -1 ? -halfPi$2 : Math.asin(x2);
}
function noop$3() {
}
function streamGeometry(geometry, stream2) {
  if (geometry && streamGeometryType.hasOwnProperty(geometry.type)) {
    streamGeometryType[geometry.type](geometry, stream2);
  }
}
var streamObjectType = {
  Feature: function(object2, stream2) {
    streamGeometry(object2.geometry, stream2);
  },
  FeatureCollection: function(object2, stream2) {
    var features = object2.features, i = -1, n = features.length;
    while (++i < n)
      streamGeometry(features[i].geometry, stream2);
  }
};
var streamGeometryType = {
  Sphere: function(object2, stream2) {
    stream2.sphere();
  },
  Point: function(object2, stream2) {
    object2 = object2.coordinates;
    stream2.point(object2[0], object2[1], object2[2]);
  },
  MultiPoint: function(object2, stream2) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n)
      object2 = coordinates[i], stream2.point(object2[0], object2[1], object2[2]);
  },
  LineString: function(object2, stream2) {
    streamLine(object2.coordinates, stream2, 0);
  },
  MultiLineString: function(object2, stream2) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n)
      streamLine(coordinates[i], stream2, 0);
  },
  Polygon: function(object2, stream2) {
    streamPolygon(object2.coordinates, stream2);
  },
  MultiPolygon: function(object2, stream2) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n)
      streamPolygon(coordinates[i], stream2);
  },
  GeometryCollection: function(object2, stream2) {
    var geometries = object2.geometries, i = -1, n = geometries.length;
    while (++i < n)
      streamGeometry(geometries[i], stream2);
  }
};
function streamLine(coordinates, stream2, closed) {
  var i = -1, n = coordinates.length - closed, coordinate;
  stream2.lineStart();
  while (++i < n)
    coordinate = coordinates[i], stream2.point(coordinate[0], coordinate[1], coordinate[2]);
  stream2.lineEnd();
}
function streamPolygon(coordinates, stream2) {
  var i = -1, n = coordinates.length;
  stream2.polygonStart();
  while (++i < n)
    streamLine(coordinates[i], stream2, 1);
  stream2.polygonEnd();
}
function geoStream(object2, stream2) {
  if (object2 && streamObjectType.hasOwnProperty(object2.type)) {
    streamObjectType[object2.type](object2, stream2);
  } else {
    streamGeometry(object2, stream2);
  }
}
var areaRingSum$1 = new Adder();
var areaSum$1 = new Adder(), lambda00$2, phi00$2, lambda0$1, cosPhi0, sinPhi0;
var areaStream$1 = {
  point: noop$3,
  lineStart: noop$3,
  lineEnd: noop$3,
  polygonStart: function() {
    areaRingSum$1 = new Adder();
    areaStream$1.lineStart = areaRingStart$1;
    areaStream$1.lineEnd = areaRingEnd$1;
  },
  polygonEnd: function() {
    var areaRing = +areaRingSum$1;
    areaSum$1.add(areaRing < 0 ? tau$1 + areaRing : areaRing);
    this.lineStart = this.lineEnd = this.point = noop$3;
  },
  sphere: function() {
    areaSum$1.add(tau$1);
  }
};
function areaRingStart$1() {
  areaStream$1.point = areaPointFirst$1;
}
function areaRingEnd$1() {
  areaPoint$1(lambda00$2, phi00$2);
}
function areaPointFirst$1(lambda, phi2) {
  areaStream$1.point = areaPoint$1;
  lambda00$2 = lambda, phi00$2 = phi2;
  lambda *= radians, phi2 *= radians;
  lambda0$1 = lambda, cosPhi0 = cos$2(phi2 = phi2 / 2 + quarterPi), sinPhi0 = sin$2(phi2);
}
function areaPoint$1(lambda, phi2) {
  lambda *= radians, phi2 *= radians;
  phi2 = phi2 / 2 + quarterPi;
  var dLambda = lambda - lambda0$1, sdLambda = dLambda >= 0 ? 1 : -1, adLambda = sdLambda * dLambda, cosPhi = cos$2(phi2), sinPhi = sin$2(phi2), k = sinPhi0 * sinPhi, u2 = cosPhi0 * cosPhi + k * cos$2(adLambda), v = k * sdLambda * sin$2(adLambda);
  areaRingSum$1.add(atan2$1(v, u2));
  lambda0$1 = lambda, cosPhi0 = cosPhi, sinPhi0 = sinPhi;
}
function geoArea$1$1(object2) {
  areaSum$1 = new Adder();
  geoStream(object2, areaStream$1);
  return areaSum$1 * 2;
}
function spherical(cartesian2) {
  return [atan2$1(cartesian2[1], cartesian2[0]), asin$2(cartesian2[2])];
}
function cartesian(spherical2) {
  var lambda = spherical2[0], phi2 = spherical2[1], cosPhi = cos$2(phi2);
  return [cosPhi * cos$2(lambda), cosPhi * sin$2(lambda), sin$2(phi2)];
}
function cartesianDot(a2, b2) {
  return a2[0] * b2[0] + a2[1] * b2[1] + a2[2] * b2[2];
}
function cartesianCross(a2, b2) {
  return [a2[1] * b2[2] - a2[2] * b2[1], a2[2] * b2[0] - a2[0] * b2[2], a2[0] * b2[1] - a2[1] * b2[0]];
}
function cartesianAddInPlace(a2, b2) {
  a2[0] += b2[0], a2[1] += b2[1], a2[2] += b2[2];
}
function cartesianScale(vector, k) {
  return [vector[0] * k, vector[1] * k, vector[2] * k];
}
function cartesianNormalizeInPlace(d) {
  var l = sqrt$3(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  d[0] /= l, d[1] /= l, d[2] /= l;
}
var lambda0, phi0, lambda1, phi1, lambda2, lambda00$1, phi00$1, p0, deltaSum, ranges, range$3;
var boundsStream$1 = {
  point: boundsPoint$1,
  lineStart: boundsLineStart,
  lineEnd: boundsLineEnd,
  polygonStart: function() {
    boundsStream$1.point = boundsRingPoint;
    boundsStream$1.lineStart = boundsRingStart;
    boundsStream$1.lineEnd = boundsRingEnd;
    deltaSum = new Adder();
    areaStream$1.polygonStart();
  },
  polygonEnd: function() {
    areaStream$1.polygonEnd();
    boundsStream$1.point = boundsPoint$1;
    boundsStream$1.lineStart = boundsLineStart;
    boundsStream$1.lineEnd = boundsLineEnd;
    if (areaRingSum$1 < 0)
      lambda0 = -(lambda1 = 180), phi0 = -(phi1 = 90);
    else if (deltaSum > epsilon$3)
      phi1 = 90;
    else if (deltaSum < -epsilon$3)
      phi0 = -90;
    range$3[0] = lambda0, range$3[1] = lambda1;
  },
  sphere: function() {
    lambda0 = -(lambda1 = 180), phi0 = -(phi1 = 90);
  }
};
function boundsPoint$1(lambda, phi2) {
  ranges.push(range$3 = [lambda0 = lambda, lambda1 = lambda]);
  if (phi2 < phi0)
    phi0 = phi2;
  if (phi2 > phi1)
    phi1 = phi2;
}
function linePoint(lambda, phi2) {
  var p = cartesian([lambda * radians, phi2 * radians]);
  if (p0) {
    var normal = cartesianCross(p0, p), equatorial = [normal[1], -normal[0], 0], inflection = cartesianCross(equatorial, normal);
    cartesianNormalizeInPlace(inflection);
    inflection = spherical(inflection);
    var delta = lambda - lambda2, sign2 = delta > 0 ? 1 : -1, lambdai = inflection[0] * degrees * sign2, phii, antimeridian = abs$2(delta) > 180;
    if (antimeridian ^ (sign2 * lambda2 < lambdai && lambdai < sign2 * lambda)) {
      phii = inflection[1] * degrees;
      if (phii > phi1)
        phi1 = phii;
    } else if (lambdai = (lambdai + 360) % 360 - 180, antimeridian ^ (sign2 * lambda2 < lambdai && lambdai < sign2 * lambda)) {
      phii = -inflection[1] * degrees;
      if (phii < phi0)
        phi0 = phii;
    } else {
      if (phi2 < phi0)
        phi0 = phi2;
      if (phi2 > phi1)
        phi1 = phi2;
    }
    if (antimeridian) {
      if (lambda < lambda2) {
        if (angle(lambda0, lambda) > angle(lambda0, lambda1))
          lambda1 = lambda;
      } else {
        if (angle(lambda, lambda1) > angle(lambda0, lambda1))
          lambda0 = lambda;
      }
    } else {
      if (lambda1 >= lambda0) {
        if (lambda < lambda0)
          lambda0 = lambda;
        if (lambda > lambda1)
          lambda1 = lambda;
      } else {
        if (lambda > lambda2) {
          if (angle(lambda0, lambda) > angle(lambda0, lambda1))
            lambda1 = lambda;
        } else {
          if (angle(lambda, lambda1) > angle(lambda0, lambda1))
            lambda0 = lambda;
        }
      }
    }
  } else {
    ranges.push(range$3 = [lambda0 = lambda, lambda1 = lambda]);
  }
  if (phi2 < phi0)
    phi0 = phi2;
  if (phi2 > phi1)
    phi1 = phi2;
  p0 = p, lambda2 = lambda;
}
function boundsLineStart() {
  boundsStream$1.point = linePoint;
}
function boundsLineEnd() {
  range$3[0] = lambda0, range$3[1] = lambda1;
  boundsStream$1.point = boundsPoint$1;
  p0 = null;
}
function boundsRingPoint(lambda, phi2) {
  if (p0) {
    var delta = lambda - lambda2;
    deltaSum.add(abs$2(delta) > 180 ? delta + (delta > 0 ? 360 : -360) : delta);
  } else {
    lambda00$1 = lambda, phi00$1 = phi2;
  }
  areaStream$1.point(lambda, phi2);
  linePoint(lambda, phi2);
}
function boundsRingStart() {
  areaStream$1.lineStart();
}
function boundsRingEnd() {
  boundsRingPoint(lambda00$1, phi00$1);
  areaStream$1.lineEnd();
  if (abs$2(deltaSum) > epsilon$3)
    lambda0 = -(lambda1 = 180);
  range$3[0] = lambda0, range$3[1] = lambda1;
  p0 = null;
}
function angle(lambda02, lambda12) {
  return (lambda12 -= lambda02) < 0 ? lambda12 + 360 : lambda12;
}
function rangeCompare(a2, b2) {
  return a2[0] - b2[0];
}
function rangeContains(range2, x2) {
  return range2[0] <= range2[1] ? range2[0] <= x2 && x2 <= range2[1] : x2 < range2[0] || range2[1] < x2;
}
function geoBounds$1$1(feature2) {
  var i, n, a2, b2, merged, deltaMax, delta;
  phi1 = lambda1 = -(lambda0 = phi0 = Infinity);
  ranges = [];
  geoStream(feature2, boundsStream$1);
  if (n = ranges.length) {
    ranges.sort(rangeCompare);
    for (i = 1, a2 = ranges[0], merged = [a2]; i < n; ++i) {
      b2 = ranges[i];
      if (rangeContains(a2, b2[0]) || rangeContains(a2, b2[1])) {
        if (angle(a2[0], b2[1]) > angle(a2[0], a2[1]))
          a2[1] = b2[1];
        if (angle(b2[0], a2[1]) > angle(a2[0], a2[1]))
          a2[0] = b2[0];
      } else {
        merged.push(a2 = b2);
      }
    }
    for (deltaMax = -Infinity, n = merged.length - 1, i = 0, a2 = merged[n]; i <= n; a2 = b2, ++i) {
      b2 = merged[i];
      if ((delta = angle(a2[1], b2[0])) > deltaMax)
        deltaMax = delta, lambda0 = b2[0], lambda1 = a2[1];
    }
  }
  ranges = range$3 = null;
  return lambda0 === Infinity || phi0 === Infinity ? [[NaN, NaN], [NaN, NaN]] : [[lambda0, phi0], [lambda1, phi1]];
}
var W0, W1, X0$1, Y0$1, Z0$1, X1$1, Y1$1, Z1$1, X2$1, Y2$1, Z2$1, lambda00, phi00, x0$4, y0$4, z0;
var centroidStream$1 = {
  sphere: noop$3,
  point: centroidPoint$1,
  lineStart: centroidLineStart$1,
  lineEnd: centroidLineEnd$1,
  polygonStart: function() {
    centroidStream$1.lineStart = centroidRingStart$1;
    centroidStream$1.lineEnd = centroidRingEnd$1;
  },
  polygonEnd: function() {
    centroidStream$1.lineStart = centroidLineStart$1;
    centroidStream$1.lineEnd = centroidLineEnd$1;
  }
};
function centroidPoint$1(lambda, phi2) {
  lambda *= radians, phi2 *= radians;
  var cosPhi = cos$2(phi2);
  centroidPointCartesian(cosPhi * cos$2(lambda), cosPhi * sin$2(lambda), sin$2(phi2));
}
function centroidPointCartesian(x2, y2, z) {
  ++W0;
  X0$1 += (x2 - X0$1) / W0;
  Y0$1 += (y2 - Y0$1) / W0;
  Z0$1 += (z - Z0$1) / W0;
}
function centroidLineStart$1() {
  centroidStream$1.point = centroidLinePointFirst;
}
function centroidLinePointFirst(lambda, phi2) {
  lambda *= radians, phi2 *= radians;
  var cosPhi = cos$2(phi2);
  x0$4 = cosPhi * cos$2(lambda);
  y0$4 = cosPhi * sin$2(lambda);
  z0 = sin$2(phi2);
  centroidStream$1.point = centroidLinePoint;
  centroidPointCartesian(x0$4, y0$4, z0);
}
function centroidLinePoint(lambda, phi2) {
  lambda *= radians, phi2 *= radians;
  var cosPhi = cos$2(phi2), x2 = cosPhi * cos$2(lambda), y2 = cosPhi * sin$2(lambda), z = sin$2(phi2), w2 = atan2$1(sqrt$3((w2 = y0$4 * z - z0 * y2) * w2 + (w2 = z0 * x2 - x0$4 * z) * w2 + (w2 = x0$4 * y2 - y0$4 * x2) * w2), x0$4 * x2 + y0$4 * y2 + z0 * z);
  W1 += w2;
  X1$1 += w2 * (x0$4 + (x0$4 = x2));
  Y1$1 += w2 * (y0$4 + (y0$4 = y2));
  Z1$1 += w2 * (z0 + (z0 = z));
  centroidPointCartesian(x0$4, y0$4, z0);
}
function centroidLineEnd$1() {
  centroidStream$1.point = centroidPoint$1;
}
function centroidRingStart$1() {
  centroidStream$1.point = centroidRingPointFirst;
}
function centroidRingEnd$1() {
  centroidRingPoint(lambda00, phi00);
  centroidStream$1.point = centroidPoint$1;
}
function centroidRingPointFirst(lambda, phi2) {
  lambda00 = lambda, phi00 = phi2;
  lambda *= radians, phi2 *= radians;
  centroidStream$1.point = centroidRingPoint;
  var cosPhi = cos$2(phi2);
  x0$4 = cosPhi * cos$2(lambda);
  y0$4 = cosPhi * sin$2(lambda);
  z0 = sin$2(phi2);
  centroidPointCartesian(x0$4, y0$4, z0);
}
function centroidRingPoint(lambda, phi2) {
  lambda *= radians, phi2 *= radians;
  var cosPhi = cos$2(phi2), x2 = cosPhi * cos$2(lambda), y2 = cosPhi * sin$2(lambda), z = sin$2(phi2), cx = y0$4 * z - z0 * y2, cy = z0 * x2 - x0$4 * z, cz = x0$4 * y2 - y0$4 * x2, m2 = hypot(cx, cy, cz), w2 = asin$2(m2), v = m2 && -w2 / m2;
  X2$1.add(v * cx);
  Y2$1.add(v * cy);
  Z2$1.add(v * cz);
  W1 += w2;
  X1$1 += w2 * (x0$4 + (x0$4 = x2));
  Y1$1 += w2 * (y0$4 + (y0$4 = y2));
  Z1$1 += w2 * (z0 + (z0 = z));
  centroidPointCartesian(x0$4, y0$4, z0);
}
function geoCentroid$1$1(object2) {
  W0 = W1 = X0$1 = Y0$1 = Z0$1 = X1$1 = Y1$1 = Z1$1 = 0;
  X2$1 = new Adder();
  Y2$1 = new Adder();
  Z2$1 = new Adder();
  geoStream(object2, centroidStream$1);
  var x2 = +X2$1, y2 = +Y2$1, z = +Z2$1, m2 = hypot(x2, y2, z);
  if (m2 < epsilon2) {
    x2 = X1$1, y2 = Y1$1, z = Z1$1;
    if (W1 < epsilon$3)
      x2 = X0$1, y2 = Y0$1, z = Z0$1;
    m2 = hypot(x2, y2, z);
    if (m2 < epsilon2)
      return [NaN, NaN];
  }
  return [atan2$1(y2, x2) * degrees, asin$2(z / m2) * degrees];
}
function compose(a2, b2) {
  function compose2(x2, y2) {
    return x2 = a2(x2, y2), b2(x2[0], x2[1]);
  }
  if (a2.invert && b2.invert)
    compose2.invert = function(x2, y2) {
      return x2 = b2.invert(x2, y2), x2 && a2.invert(x2[0], x2[1]);
    };
  return compose2;
}
function rotationIdentity(lambda, phi2) {
  if (abs$2(lambda) > pi$2)
    lambda -= Math.round(lambda / tau$1) * tau$1;
  return [lambda, phi2];
}
rotationIdentity.invert = rotationIdentity;
function rotateRadians(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= tau$1) ? deltaPhi || deltaGamma ? compose(rotationLambda(deltaLambda), rotationPhiGamma(deltaPhi, deltaGamma)) : rotationLambda(deltaLambda) : deltaPhi || deltaGamma ? rotationPhiGamma(deltaPhi, deltaGamma) : rotationIdentity;
}
function forwardRotationLambda(deltaLambda) {
  return function(lambda, phi2) {
    lambda += deltaLambda;
    if (abs$2(lambda) > pi$2)
      lambda -= Math.round(lambda / tau$1) * tau$1;
    return [lambda, phi2];
  };
}
function rotationLambda(deltaLambda) {
  var rotation2 = forwardRotationLambda(deltaLambda);
  rotation2.invert = forwardRotationLambda(-deltaLambda);
  return rotation2;
}
function rotationPhiGamma(deltaPhi, deltaGamma) {
  var cosDeltaPhi = cos$2(deltaPhi), sinDeltaPhi = sin$2(deltaPhi), cosDeltaGamma = cos$2(deltaGamma), sinDeltaGamma = sin$2(deltaGamma);
  function rotation2(lambda, phi2) {
    var cosPhi = cos$2(phi2), x2 = cos$2(lambda) * cosPhi, y2 = sin$2(lambda) * cosPhi, z = sin$2(phi2), k = z * cosDeltaPhi + x2 * sinDeltaPhi;
    return [
      atan2$1(y2 * cosDeltaGamma - k * sinDeltaGamma, x2 * cosDeltaPhi - z * sinDeltaPhi),
      asin$2(k * cosDeltaGamma + y2 * sinDeltaGamma)
    ];
  }
  rotation2.invert = function(lambda, phi2) {
    var cosPhi = cos$2(phi2), x2 = cos$2(lambda) * cosPhi, y2 = sin$2(lambda) * cosPhi, z = sin$2(phi2), k = z * cosDeltaGamma - y2 * sinDeltaGamma;
    return [
      atan2$1(y2 * cosDeltaGamma + z * sinDeltaGamma, x2 * cosDeltaPhi + k * sinDeltaPhi),
      asin$2(k * cosDeltaPhi - x2 * sinDeltaPhi)
    ];
  };
  return rotation2;
}
function rotation(rotate2) {
  rotate2 = rotateRadians(rotate2[0] * radians, rotate2[1] * radians, rotate2.length > 2 ? rotate2[2] * radians : 0);
  function forward(coordinates) {
    coordinates = rotate2(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= degrees, coordinates[1] *= degrees, coordinates;
  }
  forward.invert = function(coordinates) {
    coordinates = rotate2.invert(coordinates[0] * radians, coordinates[1] * radians);
    return coordinates[0] *= degrees, coordinates[1] *= degrees, coordinates;
  };
  return forward;
}
function circleStream(stream2, radius2, delta, direction, t02, t12) {
  if (!delta)
    return;
  var cosRadius = cos$2(radius2), sinRadius = sin$2(radius2), step = direction * delta;
  if (t02 == null) {
    t02 = radius2 + direction * tau$1;
    t12 = radius2 - step / 2;
  } else {
    t02 = circleRadius(cosRadius, t02);
    t12 = circleRadius(cosRadius, t12);
    if (direction > 0 ? t02 < t12 : t02 > t12)
      t02 += direction * tau$1;
  }
  for (var point2, t = t02; direction > 0 ? t > t12 : t < t12; t -= step) {
    point2 = spherical([cosRadius, -sinRadius * cos$2(t), -sinRadius * sin$2(t)]);
    stream2.point(point2[0], point2[1]);
  }
}
function circleRadius(cosRadius, point2) {
  point2 = cartesian(point2), point2[0] -= cosRadius;
  cartesianNormalizeInPlace(point2);
  var radius2 = acos$1(-point2[1]);
  return ((-point2[2] < 0 ? -radius2 : radius2) + tau$1 - epsilon$3) % tau$1;
}
function clipBuffer() {
  var lines = [], line2;
  return {
    point: function(x2, y2, m2) {
      line2.push([x2, y2, m2]);
    },
    lineStart: function() {
      lines.push(line2 = []);
    },
    lineEnd: noop$3,
    rejoin: function() {
      if (lines.length > 1)
        lines.push(lines.pop().concat(lines.shift()));
    },
    result: function() {
      var result = lines;
      lines = [];
      line2 = null;
      return result;
    }
  };
}
function pointEqual(a2, b2) {
  return abs$2(a2[0] - b2[0]) < epsilon$3 && abs$2(a2[1] - b2[1]) < epsilon$3;
}
function Intersection(point2, points2, other, entry2) {
  this.x = point2;
  this.z = points2;
  this.o = other;
  this.e = entry2;
  this.v = false;
  this.n = this.p = null;
}
function clipRejoin(segments2, compareIntersection2, startInside, interpolate2, stream2) {
  var subject = [], clip2 = [], i, n;
  segments2.forEach(function(segment) {
    if ((n2 = segment.length - 1) <= 0)
      return;
    var n2, p02 = segment[0], p1 = segment[n2], x2;
    if (pointEqual(p02, p1)) {
      if (!p02[2] && !p1[2]) {
        stream2.lineStart();
        for (i = 0; i < n2; ++i)
          stream2.point((p02 = segment[i])[0], p02[1]);
        stream2.lineEnd();
        return;
      }
      p1[0] += 2 * epsilon$3;
    }
    subject.push(x2 = new Intersection(p02, segment, null, true));
    clip2.push(x2.o = new Intersection(p02, null, x2, false));
    subject.push(x2 = new Intersection(p1, segment, null, false));
    clip2.push(x2.o = new Intersection(p1, null, x2, true));
  });
  if (!subject.length)
    return;
  clip2.sort(compareIntersection2);
  link(subject);
  link(clip2);
  for (i = 0, n = clip2.length; i < n; ++i) {
    clip2[i].e = startInside = !startInside;
  }
  var start = subject[0], points2, point2;
  while (1) {
    var current = start, isSubject = true;
    while (current.v)
      if ((current = current.n) === start)
        return;
    points2 = current.z;
    stream2.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points2.length; i < n; ++i)
            stream2.point((point2 = points2[i])[0], point2[1]);
        } else {
          interpolate2(current.x, current.n.x, 1, stream2);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points2 = current.p.z;
          for (i = points2.length - 1; i >= 0; --i)
            stream2.point((point2 = points2[i])[0], point2[1]);
        } else {
          interpolate2(current.x, current.p.x, -1, stream2);
        }
        current = current.p;
      }
      current = current.o;
      points2 = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream2.lineEnd();
  }
}
function link(array2) {
  if (!(n = array2.length))
    return;
  var n, i = 0, a2 = array2[0], b2;
  while (++i < n) {
    a2.n = b2 = array2[i];
    b2.p = a2;
    a2 = b2;
  }
  a2.n = b2 = array2[0];
  b2.p = a2;
}
function longitude(point2) {
  return abs$2(point2[0]) <= pi$2 ? point2[0] : sign$1(point2[0]) * ((abs$2(point2[0]) + pi$2) % tau$1 - pi$2);
}
function polygonContains(polygon, point2) {
  var lambda = longitude(point2), phi2 = point2[1], sinPhi = sin$2(phi2), normal = [sin$2(lambda), -cos$2(lambda), 0], angle2 = 0, winding = 0;
  var sum2 = new Adder();
  if (sinPhi === 1)
    phi2 = halfPi$2 + epsilon$3;
  else if (sinPhi === -1)
    phi2 = -halfPi$2 - epsilon$3;
  for (var i = 0, n = polygon.length; i < n; ++i) {
    if (!(m2 = (ring = polygon[i]).length))
      continue;
    var ring, m2, point0 = ring[m2 - 1], lambda02 = longitude(point0), phi02 = point0[1] / 2 + quarterPi, sinPhi02 = sin$2(phi02), cosPhi02 = cos$2(phi02);
    for (var j = 0; j < m2; ++j, lambda02 = lambda12, sinPhi02 = sinPhi1, cosPhi02 = cosPhi1, point0 = point1) {
      var point1 = ring[j], lambda12 = longitude(point1), phi12 = point1[1] / 2 + quarterPi, sinPhi1 = sin$2(phi12), cosPhi1 = cos$2(phi12), delta = lambda12 - lambda02, sign2 = delta >= 0 ? 1 : -1, absDelta = sign2 * delta, antimeridian = absDelta > pi$2, k = sinPhi02 * sinPhi1;
      sum2.add(atan2$1(k * sign2 * sin$2(absDelta), cosPhi02 * cosPhi1 + k * cos$2(absDelta)));
      angle2 += antimeridian ? delta + sign2 * tau$1 : delta;
      if (antimeridian ^ lambda02 >= lambda ^ lambda12 >= lambda) {
        var arc2 = cartesianCross(cartesian(point0), cartesian(point1));
        cartesianNormalizeInPlace(arc2);
        var intersection2 = cartesianCross(normal, arc2);
        cartesianNormalizeInPlace(intersection2);
        var phiArc = (antimeridian ^ delta >= 0 ? -1 : 1) * asin$2(intersection2[2]);
        if (phi2 > phiArc || phi2 === phiArc && (arc2[0] || arc2[1])) {
          winding += antimeridian ^ delta >= 0 ? 1 : -1;
        }
      }
    }
  }
  return (angle2 < -epsilon$3 || angle2 < epsilon$3 && sum2 < -epsilon2) ^ winding & 1;
}
function clip$3(pointVisible, clipLine2, interpolate2, start) {
  return function(sink) {
    var line2 = clipLine2(sink), ringBuffer = clipBuffer(), ringSink = clipLine2(ringBuffer), polygonStarted = false, polygon, segments2, ring;
    var clip2 = {
      point: point2,
      lineStart,
      lineEnd,
      polygonStart: function() {
        clip2.point = pointRing;
        clip2.lineStart = ringStart;
        clip2.lineEnd = ringEnd;
        segments2 = [];
        polygon = [];
      },
      polygonEnd: function() {
        clip2.point = point2;
        clip2.lineStart = lineStart;
        clip2.lineEnd = lineEnd;
        segments2 = merge$4(segments2);
        var startInside = polygonContains(polygon, start);
        if (segments2.length) {
          if (!polygonStarted)
            sink.polygonStart(), polygonStarted = true;
          clipRejoin(segments2, compareIntersection, startInside, interpolate2, sink);
        } else if (startInside) {
          if (!polygonStarted)
            sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          interpolate2(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted)
          sink.polygonEnd(), polygonStarted = false;
        segments2 = polygon = null;
      },
      sphere: function() {
        sink.polygonStart();
        sink.lineStart();
        interpolate2(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      }
    };
    function point2(lambda, phi2) {
      if (pointVisible(lambda, phi2))
        sink.point(lambda, phi2);
    }
    function pointLine(lambda, phi2) {
      line2.point(lambda, phi2);
    }
    function lineStart() {
      clip2.point = pointLine;
      line2.lineStart();
    }
    function lineEnd() {
      clip2.point = point2;
      line2.lineEnd();
    }
    function pointRing(lambda, phi2) {
      ring.push([lambda, phi2]);
      ringSink.point(lambda, phi2);
    }
    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }
    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();
      var clean = ringSink.clean(), ringSegments = ringBuffer.result(), i, n = ringSegments.length, m2, segment, point3;
      ring.pop();
      polygon.push(ring);
      ring = null;
      if (!n)
        return;
      if (clean & 1) {
        segment = ringSegments[0];
        if ((m2 = segment.length - 1) > 0) {
          if (!polygonStarted)
            sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          for (i = 0; i < m2; ++i)
            sink.point((point3 = segment[i])[0], point3[1]);
          sink.lineEnd();
        }
        return;
      }
      if (n > 1 && clean & 2)
        ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));
      segments2.push(ringSegments.filter(validSegment));
    }
    return clip2;
  };
}
function validSegment(segment) {
  return segment.length > 1;
}
function compareIntersection(a2, b2) {
  return ((a2 = a2.x)[0] < 0 ? a2[1] - halfPi$2 - epsilon$3 : halfPi$2 - a2[1]) - ((b2 = b2.x)[0] < 0 ? b2[1] - halfPi$2 - epsilon$3 : halfPi$2 - b2[1]);
}
const clipAntimeridian = clip$3(
  function() {
    return true;
  },
  clipAntimeridianLine,
  clipAntimeridianInterpolate,
  [-pi$2, -halfPi$2]
);
function clipAntimeridianLine(stream2) {
  var lambda02 = NaN, phi02 = NaN, sign0 = NaN, clean;
  return {
    lineStart: function() {
      stream2.lineStart();
      clean = 1;
    },
    point: function(lambda12, phi12) {
      var sign1 = lambda12 > 0 ? pi$2 : -pi$2, delta = abs$2(lambda12 - lambda02);
      if (abs$2(delta - pi$2) < epsilon$3) {
        stream2.point(lambda02, phi02 = (phi02 + phi12) / 2 > 0 ? halfPi$2 : -halfPi$2);
        stream2.point(sign0, phi02);
        stream2.lineEnd();
        stream2.lineStart();
        stream2.point(sign1, phi02);
        stream2.point(lambda12, phi02);
        clean = 0;
      } else if (sign0 !== sign1 && delta >= pi$2) {
        if (abs$2(lambda02 - sign0) < epsilon$3)
          lambda02 -= sign0 * epsilon$3;
        if (abs$2(lambda12 - sign1) < epsilon$3)
          lambda12 -= sign1 * epsilon$3;
        phi02 = clipAntimeridianIntersect(lambda02, phi02, lambda12, phi12);
        stream2.point(sign0, phi02);
        stream2.lineEnd();
        stream2.lineStart();
        stream2.point(sign1, phi02);
        clean = 0;
      }
      stream2.point(lambda02 = lambda12, phi02 = phi12);
      sign0 = sign1;
    },
    lineEnd: function() {
      stream2.lineEnd();
      lambda02 = phi02 = NaN;
    },
    clean: function() {
      return 2 - clean;
    }
  };
}
function clipAntimeridianIntersect(lambda02, phi02, lambda12, phi12) {
  var cosPhi02, cosPhi1, sinLambda0Lambda1 = sin$2(lambda02 - lambda12);
  return abs$2(sinLambda0Lambda1) > epsilon$3 ? atan((sin$2(phi02) * (cosPhi1 = cos$2(phi12)) * sin$2(lambda12) - sin$2(phi12) * (cosPhi02 = cos$2(phi02)) * sin$2(lambda02)) / (cosPhi02 * cosPhi1 * sinLambda0Lambda1)) : (phi02 + phi12) / 2;
}
function clipAntimeridianInterpolate(from, to, direction, stream2) {
  var phi2;
  if (from == null) {
    phi2 = direction * halfPi$2;
    stream2.point(-pi$2, phi2);
    stream2.point(0, phi2);
    stream2.point(pi$2, phi2);
    stream2.point(pi$2, 0);
    stream2.point(pi$2, -phi2);
    stream2.point(0, -phi2);
    stream2.point(-pi$2, -phi2);
    stream2.point(-pi$2, 0);
    stream2.point(-pi$2, phi2);
  } else if (abs$2(from[0] - to[0]) > epsilon$3) {
    var lambda = from[0] < to[0] ? pi$2 : -pi$2;
    phi2 = direction * lambda / 2;
    stream2.point(-lambda, phi2);
    stream2.point(0, phi2);
    stream2.point(lambda, phi2);
  } else {
    stream2.point(to[0], to[1]);
  }
}
function clipCircle(radius2) {
  var cr2 = cos$2(radius2), delta = 6 * radians, smallRadius = cr2 > 0, notHemisphere = abs$2(cr2) > epsilon$3;
  function interpolate2(from, to, direction, stream2) {
    circleStream(stream2, radius2, delta, direction, from, to);
  }
  function visible(lambda, phi2) {
    return cos$2(lambda) * cos$2(phi2) > cr2;
  }
  function clipLine2(stream2) {
    var point0, c0, v0, v00, clean;
    return {
      lineStart: function() {
        v00 = v0 = false;
        clean = 1;
      },
      point: function(lambda, phi2) {
        var point1 = [lambda, phi2], point2, v = visible(lambda, phi2), c2 = smallRadius ? v ? 0 : code(lambda, phi2) : v ? code(lambda + (lambda < 0 ? pi$2 : -pi$2), phi2) : 0;
        if (!point0 && (v00 = v0 = v))
          stream2.lineStart();
        if (v !== v0) {
          point2 = intersect2(point0, point1);
          if (!point2 || pointEqual(point0, point2) || pointEqual(point1, point2))
            point1[2] = 1;
        }
        if (v !== v0) {
          clean = 0;
          if (v) {
            stream2.lineStart();
            point2 = intersect2(point1, point0);
            stream2.point(point2[0], point2[1]);
          } else {
            point2 = intersect2(point0, point1);
            stream2.point(point2[0], point2[1], 2);
            stream2.lineEnd();
          }
          point0 = point2;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          if (!(c2 & c0) && (t = intersect2(point1, point0, true))) {
            clean = 0;
            if (smallRadius) {
              stream2.lineStart();
              stream2.point(t[0][0], t[0][1]);
              stream2.point(t[1][0], t[1][1]);
              stream2.lineEnd();
            } else {
              stream2.point(t[1][0], t[1][1]);
              stream2.lineEnd();
              stream2.lineStart();
              stream2.point(t[0][0], t[0][1], 3);
            }
          }
        }
        if (v && (!point0 || !pointEqual(point0, point1))) {
          stream2.point(point1[0], point1[1]);
        }
        point0 = point1, v0 = v, c0 = c2;
      },
      lineEnd: function() {
        if (v0)
          stream2.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function() {
        return clean | (v00 && v0) << 1;
      }
    };
  }
  function intersect2(a2, b2, two) {
    var pa2 = cartesian(a2), pb = cartesian(b2);
    var n1 = [1, 0, 0], n2 = cartesianCross(pa2, pb), n2n2 = cartesianDot(n2, n2), n1n2 = n2[0], determinant = n2n2 - n1n2 * n1n2;
    if (!determinant)
      return !two && a2;
    var c1 = cr2 * n2n2 / determinant, c2 = -cr2 * n1n2 / determinant, n1xn2 = cartesianCross(n1, n2), A5 = cartesianScale(n1, c1), B2 = cartesianScale(n2, c2);
    cartesianAddInPlace(A5, B2);
    var u2 = n1xn2, w2 = cartesianDot(A5, u2), uu = cartesianDot(u2, u2), t22 = w2 * w2 - uu * (cartesianDot(A5, A5) - 1);
    if (t22 < 0)
      return;
    var t = sqrt$3(t22), q = cartesianScale(u2, (-w2 - t) / uu);
    cartesianAddInPlace(q, A5);
    q = spherical(q);
    if (!two)
      return q;
    var lambda02 = a2[0], lambda12 = b2[0], phi02 = a2[1], phi12 = b2[1], z;
    if (lambda12 < lambda02)
      z = lambda02, lambda02 = lambda12, lambda12 = z;
    var delta2 = lambda12 - lambda02, polar = abs$2(delta2 - pi$2) < epsilon$3, meridian = polar || delta2 < epsilon$3;
    if (!polar && phi12 < phi02)
      z = phi02, phi02 = phi12, phi12 = z;
    if (meridian ? polar ? phi02 + phi12 > 0 ^ q[1] < (abs$2(q[0] - lambda02) < epsilon$3 ? phi02 : phi12) : phi02 <= q[1] && q[1] <= phi12 : delta2 > pi$2 ^ (lambda02 <= q[0] && q[0] <= lambda12)) {
      var q1 = cartesianScale(u2, (-w2 + t) / uu);
      cartesianAddInPlace(q1, A5);
      return [q, spherical(q1)];
    }
  }
  function code(lambda, phi2) {
    var r = smallRadius ? radius2 : pi$2 - radius2, code2 = 0;
    if (lambda < -r)
      code2 |= 1;
    else if (lambda > r)
      code2 |= 2;
    if (phi2 < -r)
      code2 |= 4;
    else if (phi2 > r)
      code2 |= 8;
    return code2;
  }
  return clip$3(visible, clipLine2, interpolate2, smallRadius ? [0, -radius2] : [-pi$2, radius2 - pi$2]);
}
function clipLine(a2, b2, x02, y02, x12, y12) {
  var ax = a2[0], ay = a2[1], bx = b2[0], by = b2[1], t02 = 0, t12 = 1, dx = bx - ax, dy = by - ay, r;
  r = x02 - ax;
  if (!dx && r > 0)
    return;
  r /= dx;
  if (dx < 0) {
    if (r < t02)
      return;
    if (r < t12)
      t12 = r;
  } else if (dx > 0) {
    if (r > t12)
      return;
    if (r > t02)
      t02 = r;
  }
  r = x12 - ax;
  if (!dx && r < 0)
    return;
  r /= dx;
  if (dx < 0) {
    if (r > t12)
      return;
    if (r > t02)
      t02 = r;
  } else if (dx > 0) {
    if (r < t02)
      return;
    if (r < t12)
      t12 = r;
  }
  r = y02 - ay;
  if (!dy && r > 0)
    return;
  r /= dy;
  if (dy < 0) {
    if (r < t02)
      return;
    if (r < t12)
      t12 = r;
  } else if (dy > 0) {
    if (r > t12)
      return;
    if (r > t02)
      t02 = r;
  }
  r = y12 - ay;
  if (!dy && r < 0)
    return;
  r /= dy;
  if (dy < 0) {
    if (r > t12)
      return;
    if (r > t02)
      t02 = r;
  } else if (dy > 0) {
    if (r < t02)
      return;
    if (r < t12)
      t12 = r;
  }
  if (t02 > 0)
    a2[0] = ax + t02 * dx, a2[1] = ay + t02 * dy;
  if (t12 < 1)
    b2[0] = ax + t12 * dx, b2[1] = ay + t12 * dy;
  return true;
}
var clipMax = 1e9, clipMin = -clipMax;
function clipRectangle(x02, y02, x12, y12) {
  function visible(x2, y2) {
    return x02 <= x2 && x2 <= x12 && y02 <= y2 && y2 <= y12;
  }
  function interpolate2(from, to, direction, stream2) {
    var a2 = 0, a1 = 0;
    if (from == null || (a2 = corner(from, direction)) !== (a1 = corner(to, direction)) || comparePoint(from, to) < 0 ^ direction > 0) {
      do
        stream2.point(a2 === 0 || a2 === 3 ? x02 : x12, a2 > 1 ? y12 : y02);
      while ((a2 = (a2 + direction + 4) % 4) !== a1);
    } else {
      stream2.point(to[0], to[1]);
    }
  }
  function corner(p, direction) {
    return abs$2(p[0] - x02) < epsilon$3 ? direction > 0 ? 0 : 3 : abs$2(p[0] - x12) < epsilon$3 ? direction > 0 ? 2 : 1 : abs$2(p[1] - y02) < epsilon$3 ? direction > 0 ? 1 : 0 : direction > 0 ? 3 : 2;
  }
  function compareIntersection2(a2, b2) {
    return comparePoint(a2.x, b2.x);
  }
  function comparePoint(a2, b2) {
    var ca = corner(a2, 1), cb = corner(b2, 1);
    return ca !== cb ? ca - cb : ca === 0 ? b2[1] - a2[1] : ca === 1 ? a2[0] - b2[0] : ca === 2 ? a2[1] - b2[1] : b2[0] - a2[0];
  }
  return function(stream2) {
    var activeStream = stream2, bufferStream = clipBuffer(), segments2, polygon, ring, x__, y__, v__, x_, y_, v_, first, clean;
    var clipStream = {
      point: point2,
      lineStart,
      lineEnd,
      polygonStart,
      polygonEnd
    };
    function point2(x2, y2) {
      if (visible(x2, y2))
        activeStream.point(x2, y2);
    }
    function polygonInside() {
      var winding = 0;
      for (var i = 0, n = polygon.length; i < n; ++i) {
        for (var ring2 = polygon[i], j = 1, m2 = ring2.length, point3 = ring2[0], a0, a1, b0 = point3[0], b1 = point3[1]; j < m2; ++j) {
          a0 = b0, a1 = b1, point3 = ring2[j], b0 = point3[0], b1 = point3[1];
          if (a1 <= y12) {
            if (b1 > y12 && (b0 - a0) * (y12 - a1) > (b1 - a1) * (x02 - a0))
              ++winding;
          } else {
            if (b1 <= y12 && (b0 - a0) * (y12 - a1) < (b1 - a1) * (x02 - a0))
              --winding;
          }
        }
      }
      return winding;
    }
    function polygonStart() {
      activeStream = bufferStream, segments2 = [], polygon = [], clean = true;
    }
    function polygonEnd() {
      var startInside = polygonInside(), cleanInside = clean && startInside, visible2 = (segments2 = merge$4(segments2)).length;
      if (cleanInside || visible2) {
        stream2.polygonStart();
        if (cleanInside) {
          stream2.lineStart();
          interpolate2(null, null, 1, stream2);
          stream2.lineEnd();
        }
        if (visible2) {
          clipRejoin(segments2, compareIntersection2, startInside, interpolate2, stream2);
        }
        stream2.polygonEnd();
      }
      activeStream = stream2, segments2 = polygon = ring = null;
    }
    function lineStart() {
      clipStream.point = linePoint2;
      if (polygon)
        polygon.push(ring = []);
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }
    function lineEnd() {
      if (segments2) {
        linePoint2(x__, y__);
        if (v__ && v_)
          bufferStream.rejoin();
        segments2.push(bufferStream.result());
      }
      clipStream.point = point2;
      if (v_)
        activeStream.lineEnd();
    }
    function linePoint2(x2, y2) {
      var v = visible(x2, y2);
      if (polygon)
        ring.push([x2, y2]);
      if (first) {
        x__ = x2, y__ = y2, v__ = v;
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x2, y2);
        }
      } else {
        if (v && v_)
          activeStream.point(x2, y2);
        else {
          var a2 = [x_ = Math.max(clipMin, Math.min(clipMax, x_)), y_ = Math.max(clipMin, Math.min(clipMax, y_))], b2 = [x2 = Math.max(clipMin, Math.min(clipMax, x2)), y2 = Math.max(clipMin, Math.min(clipMax, y2))];
          if (clipLine(a2, b2, x02, y02, x12, y12)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a2[0], a2[1]);
            }
            activeStream.point(b2[0], b2[1]);
            if (!v)
              activeStream.lineEnd();
            clean = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x2, y2);
            clean = false;
          }
        }
      }
      x_ = x2, y_ = y2, v_ = v;
    }
    return clipStream;
  };
}
function graticuleX(y02, y12, dy) {
  var y2 = range$4(y02, y12 - epsilon$3, dy).concat(y12);
  return function(x2) {
    return y2.map(function(y3) {
      return [x2, y3];
    });
  };
}
function graticuleY(x02, x12, dx) {
  var x2 = range$4(x02, x12 - epsilon$3, dx).concat(x12);
  return function(y2) {
    return x2.map(function(x3) {
      return [x3, y2];
    });
  };
}
function graticule() {
  var x12, x02, X12, X02, y12, y02, Y12, Y02, dx = 10, dy = dx, DX = 90, DY = 360, x2, y2, X3, Y3, precision = 2.5;
  function graticule2() {
    return { type: "MultiLineString", coordinates: lines() };
  }
  function lines() {
    return range$4(ceil(X02 / DX) * DX, X12, DX).map(X3).concat(range$4(ceil(Y02 / DY) * DY, Y12, DY).map(Y3)).concat(range$4(ceil(x02 / dx) * dx, x12, dx).filter(function(x3) {
      return abs$2(x3 % DX) > epsilon$3;
    }).map(x2)).concat(range$4(ceil(y02 / dy) * dy, y12, dy).filter(function(y3) {
      return abs$2(y3 % DY) > epsilon$3;
    }).map(y2));
  }
  graticule2.lines = function() {
    return lines().map(function(coordinates) {
      return { type: "LineString", coordinates };
    });
  };
  graticule2.outline = function() {
    return {
      type: "Polygon",
      coordinates: [
        X3(X02).concat(
          Y3(Y12).slice(1),
          X3(X12).reverse().slice(1),
          Y3(Y02).reverse().slice(1)
        )
      ]
    };
  };
  graticule2.extent = function(_) {
    if (!arguments.length)
      return graticule2.extentMinor();
    return graticule2.extentMajor(_).extentMinor(_);
  };
  graticule2.extentMajor = function(_) {
    if (!arguments.length)
      return [[X02, Y02], [X12, Y12]];
    X02 = +_[0][0], X12 = +_[1][0];
    Y02 = +_[0][1], Y12 = +_[1][1];
    if (X02 > X12)
      _ = X02, X02 = X12, X12 = _;
    if (Y02 > Y12)
      _ = Y02, Y02 = Y12, Y12 = _;
    return graticule2.precision(precision);
  };
  graticule2.extentMinor = function(_) {
    if (!arguments.length)
      return [[x02, y02], [x12, y12]];
    x02 = +_[0][0], x12 = +_[1][0];
    y02 = +_[0][1], y12 = +_[1][1];
    if (x02 > x12)
      _ = x02, x02 = x12, x12 = _;
    if (y02 > y12)
      _ = y02, y02 = y12, y12 = _;
    return graticule2.precision(precision);
  };
  graticule2.step = function(_) {
    if (!arguments.length)
      return graticule2.stepMinor();
    return graticule2.stepMajor(_).stepMinor(_);
  };
  graticule2.stepMajor = function(_) {
    if (!arguments.length)
      return [DX, DY];
    DX = +_[0], DY = +_[1];
    return graticule2;
  };
  graticule2.stepMinor = function(_) {
    if (!arguments.length)
      return [dx, dy];
    dx = +_[0], dy = +_[1];
    return graticule2;
  };
  graticule2.precision = function(_) {
    if (!arguments.length)
      return precision;
    precision = +_;
    x2 = graticuleX(y02, y12, 90);
    y2 = graticuleY(x02, x12, precision);
    X3 = graticuleX(Y02, Y12, 90);
    Y3 = graticuleY(X02, X12, precision);
    return graticule2;
  };
  return graticule2.extentMajor([[-180, -90 + epsilon$3], [180, 90 - epsilon$3]]).extentMinor([[-180, -80 - epsilon$3], [180, 80 + epsilon$3]]);
}
const identity$4 = (x2) => x2;
var areaSum = new Adder(), areaRingSum = new Adder(), x00$2, y00$2, x0$3, y0$3;
var areaStream = {
  point: noop$3,
  lineStart: noop$3,
  lineEnd: noop$3,
  polygonStart: function() {
    areaStream.lineStart = areaRingStart;
    areaStream.lineEnd = areaRingEnd;
  },
  polygonEnd: function() {
    areaStream.lineStart = areaStream.lineEnd = areaStream.point = noop$3;
    areaSum.add(abs$2(areaRingSum));
    areaRingSum = new Adder();
  },
  result: function() {
    var area2 = areaSum / 2;
    areaSum = new Adder();
    return area2;
  }
};
function areaRingStart() {
  areaStream.point = areaPointFirst;
}
function areaPointFirst(x2, y2) {
  areaStream.point = areaPoint;
  x00$2 = x0$3 = x2, y00$2 = y0$3 = y2;
}
function areaPoint(x2, y2) {
  areaRingSum.add(y0$3 * x2 - x0$3 * y2);
  x0$3 = x2, y0$3 = y2;
}
function areaRingEnd() {
  areaPoint(x00$2, y00$2);
}
var x0$2 = Infinity, y0$2 = x0$2, x1 = -x0$2, y1 = x1;
var boundsStream = {
  point: boundsPoint,
  lineStart: noop$3,
  lineEnd: noop$3,
  polygonStart: noop$3,
  polygonEnd: noop$3,
  result: function() {
    var bounds2 = [[x0$2, y0$2], [x1, y1]];
    x1 = y1 = -(y0$2 = x0$2 = Infinity);
    return bounds2;
  }
};
function boundsPoint(x2, y2) {
  if (x2 < x0$2)
    x0$2 = x2;
  if (x2 > x1)
    x1 = x2;
  if (y2 < y0$2)
    y0$2 = y2;
  if (y2 > y1)
    y1 = y2;
}
var X0 = 0, Y0 = 0, Z0 = 0, X1 = 0, Y1 = 0, Z1 = 0, X2 = 0, Y2 = 0, Z2 = 0, x00$1, y00$1, x0$1, y0$1;
var centroidStream = {
  point: centroidPoint,
  lineStart: centroidLineStart,
  lineEnd: centroidLineEnd,
  polygonStart: function() {
    centroidStream.lineStart = centroidRingStart;
    centroidStream.lineEnd = centroidRingEnd;
  },
  polygonEnd: function() {
    centroidStream.point = centroidPoint;
    centroidStream.lineStart = centroidLineStart;
    centroidStream.lineEnd = centroidLineEnd;
  },
  result: function() {
    var centroid = Z2 ? [X2 / Z2, Y2 / Z2] : Z1 ? [X1 / Z1, Y1 / Z1] : Z0 ? [X0 / Z0, Y0 / Z0] : [NaN, NaN];
    X0 = Y0 = Z0 = X1 = Y1 = Z1 = X2 = Y2 = Z2 = 0;
    return centroid;
  }
};
function centroidPoint(x2, y2) {
  X0 += x2;
  Y0 += y2;
  ++Z0;
}
function centroidLineStart() {
  centroidStream.point = centroidPointFirstLine;
}
function centroidPointFirstLine(x2, y2) {
  centroidStream.point = centroidPointLine;
  centroidPoint(x0$1 = x2, y0$1 = y2);
}
function centroidPointLine(x2, y2) {
  var dx = x2 - x0$1, dy = y2 - y0$1, z = sqrt$3(dx * dx + dy * dy);
  X1 += z * (x0$1 + x2) / 2;
  Y1 += z * (y0$1 + y2) / 2;
  Z1 += z;
  centroidPoint(x0$1 = x2, y0$1 = y2);
}
function centroidLineEnd() {
  centroidStream.point = centroidPoint;
}
function centroidRingStart() {
  centroidStream.point = centroidPointFirstRing;
}
function centroidRingEnd() {
  centroidPointRing(x00$1, y00$1);
}
function centroidPointFirstRing(x2, y2) {
  centroidStream.point = centroidPointRing;
  centroidPoint(x00$1 = x0$1 = x2, y00$1 = y0$1 = y2);
}
function centroidPointRing(x2, y2) {
  var dx = x2 - x0$1, dy = y2 - y0$1, z = sqrt$3(dx * dx + dy * dy);
  X1 += z * (x0$1 + x2) / 2;
  Y1 += z * (y0$1 + y2) / 2;
  Z1 += z;
  z = y0$1 * x2 - x0$1 * y2;
  X2 += z * (x0$1 + x2);
  Y2 += z * (y0$1 + y2);
  Z2 += z * 3;
  centroidPoint(x0$1 = x2, y0$1 = y2);
}
function PathContext(context2) {
  this._context = context2;
}
PathContext.prototype = {
  _radius: 4.5,
  pointRadius: function(_) {
    return this._radius = _, this;
  },
  polygonStart: function() {
    this._line = 0;
  },
  polygonEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line === 0)
      this._context.closePath();
    this._point = NaN;
  },
  point: function(x2, y2) {
    switch (this._point) {
      case 0: {
        this._context.moveTo(x2, y2);
        this._point = 1;
        break;
      }
      case 1: {
        this._context.lineTo(x2, y2);
        break;
      }
      default: {
        this._context.moveTo(x2 + this._radius, y2);
        this._context.arc(x2, y2, this._radius, 0, tau$1);
        break;
      }
    }
  },
  result: noop$3
};
var lengthSum = new Adder(), lengthRing, x00, y00, x0, y0;
var lengthStream = {
  point: noop$3,
  lineStart: function() {
    lengthStream.point = lengthPointFirst;
  },
  lineEnd: function() {
    if (lengthRing)
      lengthPoint(x00, y00);
    lengthStream.point = noop$3;
  },
  polygonStart: function() {
    lengthRing = true;
  },
  polygonEnd: function() {
    lengthRing = null;
  },
  result: function() {
    var length2 = +lengthSum;
    lengthSum = new Adder();
    return length2;
  }
};
function lengthPointFirst(x2, y2) {
  lengthStream.point = lengthPoint;
  x00 = x0 = x2, y00 = y0 = y2;
}
function lengthPoint(x2, y2) {
  x0 -= x2, y0 -= y2;
  lengthSum.add(sqrt$3(x0 * x0 + y0 * y0));
  x0 = x2, y0 = y2;
}
let cacheDigits, cacheAppend, cacheRadius, cacheCircle;
class PathString {
  constructor(digits) {
    this._append = digits == null ? append : appendRound(digits);
    this._radius = 4.5;
    this._ = "";
  }
  pointRadius(_) {
    this._radius = +_;
    return this;
  }
  polygonStart() {
    this._line = 0;
  }
  polygonEnd() {
    this._line = NaN;
  }
  lineStart() {
    this._point = 0;
  }
  lineEnd() {
    if (this._line === 0)
      this._ += "Z";
    this._point = NaN;
  }
  point(x2, y2) {
    switch (this._point) {
      case 0: {
        this._append`M${x2},${y2}`;
        this._point = 1;
        break;
      }
      case 1: {
        this._append`L${x2},${y2}`;
        break;
      }
      default: {
        this._append`M${x2},${y2}`;
        if (this._radius !== cacheRadius || this._append !== cacheAppend) {
          const r = this._radius;
          const s = this._;
          this._ = "";
          this._append`m0,${r}a${r},${r} 0 1,1 0,${-2 * r}a${r},${r} 0 1,1 0,${2 * r}z`;
          cacheRadius = r;
          cacheAppend = this._append;
          cacheCircle = this._;
          this._ = s;
        }
        this._ += cacheCircle;
        break;
      }
    }
  }
  result() {
    const result = this._;
    this._ = "";
    return result.length ? result : null;
  }
}
function append(strings) {
  let i = 1;
  this._ += strings[0];
  for (const j = strings.length; i < j; ++i) {
    this._ += arguments[i] + strings[i];
  }
}
function appendRound(digits) {
  const d = Math.floor(digits);
  if (!(d >= 0))
    throw new RangeError(`invalid digits: ${digits}`);
  if (d > 15)
    return append;
  if (d !== cacheDigits) {
    const k = 10 ** d;
    cacheDigits = d;
    cacheAppend = function append2(strings) {
      let i = 1;
      this._ += strings[0];
      for (const j = strings.length; i < j; ++i) {
        this._ += Math.round(arguments[i] * k) / k + strings[i];
      }
    };
  }
  return cacheAppend;
}
function geoPath(projection2, context2) {
  let digits = 3, pointRadius = 4.5, projectionStream, contextStream;
  function path2(object2) {
    if (object2) {
      if (typeof pointRadius === "function")
        contextStream.pointRadius(+pointRadius.apply(this, arguments));
      geoStream(object2, projectionStream(contextStream));
    }
    return contextStream.result();
  }
  path2.area = function(object2) {
    geoStream(object2, projectionStream(areaStream));
    return areaStream.result();
  };
  path2.measure = function(object2) {
    geoStream(object2, projectionStream(lengthStream));
    return lengthStream.result();
  };
  path2.bounds = function(object2) {
    geoStream(object2, projectionStream(boundsStream));
    return boundsStream.result();
  };
  path2.centroid = function(object2) {
    geoStream(object2, projectionStream(centroidStream));
    return centroidStream.result();
  };
  path2.projection = function(_) {
    if (!arguments.length)
      return projection2;
    projectionStream = _ == null ? (projection2 = null, identity$4) : (projection2 = _).stream;
    return path2;
  };
  path2.context = function(_) {
    if (!arguments.length)
      return context2;
    contextStream = _ == null ? (context2 = null, new PathString(digits)) : new PathContext(context2 = _);
    if (typeof pointRadius !== "function")
      contextStream.pointRadius(pointRadius);
    return path2;
  };
  path2.pointRadius = function(_) {
    if (!arguments.length)
      return pointRadius;
    pointRadius = typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
    return path2;
  };
  path2.digits = function(_) {
    if (!arguments.length)
      return digits;
    if (_ == null)
      digits = null;
    else {
      const d = Math.floor(_);
      if (!(d >= 0))
        throw new RangeError(`invalid digits: ${_}`);
      digits = d;
    }
    if (context2 === null)
      contextStream = new PathString(digits);
    return path2;
  };
  return path2.projection(projection2).digits(digits).context(context2);
}
function transformer$3(methods2) {
  return function(stream2) {
    var s = new TransformStream();
    for (var key2 in methods2)
      s[key2] = methods2[key2];
    s.stream = stream2;
    return s;
  };
}
function TransformStream() {
}
TransformStream.prototype = {
  constructor: TransformStream,
  point: function(x2, y2) {
    this.stream.point(x2, y2);
  },
  sphere: function() {
    this.stream.sphere();
  },
  lineStart: function() {
    this.stream.lineStart();
  },
  lineEnd: function() {
    this.stream.lineEnd();
  },
  polygonStart: function() {
    this.stream.polygonStart();
  },
  polygonEnd: function() {
    this.stream.polygonEnd();
  }
};
function fit$1(projection2, fitBounds, object2) {
  var clip2 = projection2.clipExtent && projection2.clipExtent();
  projection2.scale(150).translate([0, 0]);
  if (clip2 != null)
    projection2.clipExtent(null);
  geoStream(object2, projection2.stream(boundsStream));
  fitBounds(boundsStream.result());
  if (clip2 != null)
    projection2.clipExtent(clip2);
  return projection2;
}
function fitExtent(projection2, extent2, object2) {
  return fit$1(projection2, function(b2) {
    var w2 = extent2[1][0] - extent2[0][0], h2 = extent2[1][1] - extent2[0][1], k = Math.min(w2 / (b2[1][0] - b2[0][0]), h2 / (b2[1][1] - b2[0][1])), x2 = +extent2[0][0] + (w2 - k * (b2[1][0] + b2[0][0])) / 2, y2 = +extent2[0][1] + (h2 - k * (b2[1][1] + b2[0][1])) / 2;
    projection2.scale(150 * k).translate([x2, y2]);
  }, object2);
}
function fitSize(projection2, size, object2) {
  return fitExtent(projection2, [[0, 0], size], object2);
}
function fitWidth(projection2, width2, object2) {
  return fit$1(projection2, function(b2) {
    var w2 = +width2, k = w2 / (b2[1][0] - b2[0][0]), x2 = (w2 - k * (b2[1][0] + b2[0][0])) / 2, y2 = -k * b2[0][1];
    projection2.scale(150 * k).translate([x2, y2]);
  }, object2);
}
function fitHeight(projection2, height2, object2) {
  return fit$1(projection2, function(b2) {
    var h2 = +height2, k = h2 / (b2[1][1] - b2[0][1]), x2 = -k * b2[0][0], y2 = (h2 - k * (b2[1][1] + b2[0][1])) / 2;
    projection2.scale(150 * k).translate([x2, y2]);
  }, object2);
}
var maxDepth = 16, cosMinDistance = cos$2(30 * radians);
function resample(project2, delta2) {
  return +delta2 ? resample$1(project2, delta2) : resampleNone(project2);
}
function resampleNone(project2) {
  return transformer$3({
    point: function(x2, y2) {
      x2 = project2(x2, y2);
      this.stream.point(x2[0], x2[1]);
    }
  });
}
function resample$1(project2, delta2) {
  function resampleLineTo(x02, y02, lambda02, a0, b0, c0, x12, y12, lambda12, a1, b1, c1, depth, stream2) {
    var dx = x12 - x02, dy = y12 - y02, d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a2 = a0 + a1, b2 = b0 + b1, c2 = c0 + c1, m2 = sqrt$3(a2 * a2 + b2 * b2 + c2 * c2), phi2 = asin$2(c2 /= m2), lambda22 = abs$2(abs$2(c2) - 1) < epsilon$3 || abs$2(lambda02 - lambda12) < epsilon$3 ? (lambda02 + lambda12) / 2 : atan2$1(b2, a2), p = project2(lambda22, phi2), x2 = p[0], y2 = p[1], dx2 = x2 - x02, dy2 = y2 - y02, dz = dy * dx2 - dx * dy2;
      if (dz * dz / d2 > delta2 || abs$2((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 || a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance) {
        resampleLineTo(x02, y02, lambda02, a0, b0, c0, x2, y2, lambda22, a2 /= m2, b2 /= m2, c2, depth, stream2);
        stream2.point(x2, y2);
        resampleLineTo(x2, y2, lambda22, a2, b2, c2, x12, y12, lambda12, a1, b1, c1, depth, stream2);
      }
    }
  }
  return function(stream2) {
    var lambda002, x002, y002, a00, b00, c00, lambda02, x02, y02, a0, b0, c0;
    var resampleStream = {
      point: point2,
      lineStart,
      lineEnd,
      polygonStart: function() {
        stream2.polygonStart();
        resampleStream.lineStart = ringStart;
      },
      polygonEnd: function() {
        stream2.polygonEnd();
        resampleStream.lineStart = lineStart;
      }
    };
    function point2(x2, y2) {
      x2 = project2(x2, y2);
      stream2.point(x2[0], x2[1]);
    }
    function lineStart() {
      x02 = NaN;
      resampleStream.point = linePoint2;
      stream2.lineStart();
    }
    function linePoint2(lambda, phi2) {
      var c2 = cartesian([lambda, phi2]), p = project2(lambda, phi2);
      resampleLineTo(x02, y02, lambda02, a0, b0, c0, x02 = p[0], y02 = p[1], lambda02 = lambda, a0 = c2[0], b0 = c2[1], c0 = c2[2], maxDepth, stream2);
      stream2.point(x02, y02);
    }
    function lineEnd() {
      resampleStream.point = point2;
      stream2.lineEnd();
    }
    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }
    function ringPoint(lambda, phi2) {
      linePoint2(lambda002 = lambda, phi2), x002 = x02, y002 = y02, a00 = a0, b00 = b0, c00 = c0;
      resampleStream.point = linePoint2;
    }
    function ringEnd() {
      resampleLineTo(x02, y02, lambda02, a0, b0, c0, x002, y002, lambda002, a00, b00, c00, maxDepth, stream2);
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }
    return resampleStream;
  };
}
var transformRadians = transformer$3({
  point: function(x2, y2) {
    this.stream.point(x2 * radians, y2 * radians);
  }
});
function transformRotate(rotate2) {
  return transformer$3({
    point: function(x2, y2) {
      var r = rotate2(x2, y2);
      return this.stream.point(r[0], r[1]);
    }
  });
}
function scaleTranslate(k, dx, dy, sx, sy) {
  function transform2(x2, y2) {
    x2 *= sx;
    y2 *= sy;
    return [dx + k * x2, dy - k * y2];
  }
  transform2.invert = function(x2, y2) {
    return [(x2 - dx) / k * sx, (dy - y2) / k * sy];
  };
  return transform2;
}
function scaleTranslateRotate(k, dx, dy, sx, sy, alpha) {
  if (!alpha)
    return scaleTranslate(k, dx, dy, sx, sy);
  var cosAlpha = cos$2(alpha), sinAlpha = sin$2(alpha), a2 = cosAlpha * k, b2 = sinAlpha * k, ai = cosAlpha / k, bi = sinAlpha / k, ci = (sinAlpha * dy - cosAlpha * dx) / k, fi = (sinAlpha * dx + cosAlpha * dy) / k;
  function transform2(x2, y2) {
    x2 *= sx;
    y2 *= sy;
    return [a2 * x2 - b2 * y2 + dx, dy - b2 * x2 - a2 * y2];
  }
  transform2.invert = function(x2, y2) {
    return [sx * (ai * x2 - bi * y2 + ci), sy * (fi - bi * x2 - ai * y2)];
  };
  return transform2;
}
function projection$1(project2) {
  return projectionMutator(function() {
    return project2;
  })();
}
function projectionMutator(projectAt) {
  var project2, k = 150, x2 = 480, y2 = 250, lambda = 0, phi2 = 0, deltaLambda = 0, deltaPhi = 0, deltaGamma = 0, rotate2, alpha = 0, sx = 1, sy = 1, theta = null, preclip = clipAntimeridian, x02 = null, y02, x12, y12, postclip = identity$4, delta2 = 0.5, projectResample, projectTransform, projectRotateTransform, cache2, cacheStream;
  function projection2(point2) {
    return projectRotateTransform(point2[0] * radians, point2[1] * radians);
  }
  function invert2(point2) {
    point2 = projectRotateTransform.invert(point2[0], point2[1]);
    return point2 && [point2[0] * degrees, point2[1] * degrees];
  }
  projection2.stream = function(stream2) {
    return cache2 && cacheStream === stream2 ? cache2 : cache2 = transformRadians(transformRotate(rotate2)(preclip(projectResample(postclip(cacheStream = stream2)))));
  };
  projection2.preclip = function(_) {
    return arguments.length ? (preclip = _, theta = void 0, reset2()) : preclip;
  };
  projection2.postclip = function(_) {
    return arguments.length ? (postclip = _, x02 = y02 = x12 = y12 = null, reset2()) : postclip;
  };
  projection2.clipAngle = function(_) {
    return arguments.length ? (preclip = +_ ? clipCircle(theta = _ * radians) : (theta = null, clipAntimeridian), reset2()) : theta * degrees;
  };
  projection2.clipExtent = function(_) {
    return arguments.length ? (postclip = _ == null ? (x02 = y02 = x12 = y12 = null, identity$4) : clipRectangle(x02 = +_[0][0], y02 = +_[0][1], x12 = +_[1][0], y12 = +_[1][1]), reset2()) : x02 == null ? null : [[x02, y02], [x12, y12]];
  };
  projection2.scale = function(_) {
    return arguments.length ? (k = +_, recenter()) : k;
  };
  projection2.translate = function(_) {
    return arguments.length ? (x2 = +_[0], y2 = +_[1], recenter()) : [x2, y2];
  };
  projection2.center = function(_) {
    return arguments.length ? (lambda = _[0] % 360 * radians, phi2 = _[1] % 360 * radians, recenter()) : [lambda * degrees, phi2 * degrees];
  };
  projection2.rotate = function(_) {
    return arguments.length ? (deltaLambda = _[0] % 360 * radians, deltaPhi = _[1] % 360 * radians, deltaGamma = _.length > 2 ? _[2] % 360 * radians : 0, recenter()) : [deltaLambda * degrees, deltaPhi * degrees, deltaGamma * degrees];
  };
  projection2.angle = function(_) {
    return arguments.length ? (alpha = _ % 360 * radians, recenter()) : alpha * degrees;
  };
  projection2.reflectX = function(_) {
    return arguments.length ? (sx = _ ? -1 : 1, recenter()) : sx < 0;
  };
  projection2.reflectY = function(_) {
    return arguments.length ? (sy = _ ? -1 : 1, recenter()) : sy < 0;
  };
  projection2.precision = function(_) {
    return arguments.length ? (projectResample = resample(projectTransform, delta2 = _ * _), reset2()) : sqrt$3(delta2);
  };
  projection2.fitExtent = function(extent2, object2) {
    return fitExtent(projection2, extent2, object2);
  };
  projection2.fitSize = function(size, object2) {
    return fitSize(projection2, size, object2);
  };
  projection2.fitWidth = function(width2, object2) {
    return fitWidth(projection2, width2, object2);
  };
  projection2.fitHeight = function(height2, object2) {
    return fitHeight(projection2, height2, object2);
  };
  function recenter() {
    var center = scaleTranslateRotate(k, 0, 0, sx, sy, alpha).apply(null, project2(lambda, phi2)), transform2 = scaleTranslateRotate(k, x2 - center[0], y2 - center[1], sx, sy, alpha);
    rotate2 = rotateRadians(deltaLambda, deltaPhi, deltaGamma);
    projectTransform = compose(project2, transform2);
    projectRotateTransform = compose(rotate2, projectTransform);
    projectResample = resample(projectTransform, delta2);
    return reset2();
  }
  function reset2() {
    cache2 = cacheStream = null;
    return projection2;
  }
  return function() {
    project2 = projectAt.apply(this, arguments);
    projection2.invert = project2.invert && invert2;
    return recenter();
  };
}
function conicProjection(projectAt) {
  var phi02 = 0, phi12 = pi$2 / 3, m2 = projectionMutator(projectAt), p = m2(phi02, phi12);
  p.parallels = function(_) {
    return arguments.length ? m2(phi02 = _[0] * radians, phi12 = _[1] * radians) : [phi02 * degrees, phi12 * degrees];
  };
  return p;
}
function cylindricalEqualAreaRaw(phi02) {
  var cosPhi02 = cos$2(phi02);
  function forward(lambda, phi2) {
    return [lambda * cosPhi02, sin$2(phi2) / cosPhi02];
  }
  forward.invert = function(x2, y2) {
    return [x2 / cosPhi02, asin$2(y2 * cosPhi02)];
  };
  return forward;
}
function conicEqualAreaRaw(y02, y12) {
  var sy0 = sin$2(y02), n = (sy0 + sin$2(y12)) / 2;
  if (abs$2(n) < epsilon$3)
    return cylindricalEqualAreaRaw(y02);
  var c2 = 1 + sy0 * (2 * n - sy0), r0 = sqrt$3(c2) / n;
  function project2(x2, y2) {
    var r = sqrt$3(c2 - 2 * n * sin$2(y2)) / n;
    return [r * sin$2(x2 *= n), r0 - r * cos$2(x2)];
  }
  project2.invert = function(x2, y2) {
    var r0y = r0 - y2, l = atan2$1(x2, abs$2(r0y)) * sign$1(r0y);
    if (r0y * n < 0)
      l -= pi$2 * sign$1(x2) * sign$1(r0y);
    return [l / n, asin$2((c2 - (x2 * x2 + r0y * r0y) * n * n) / (2 * n))];
  };
  return project2;
}
function geoConicEqualArea() {
  return conicProjection(conicEqualAreaRaw).scale(155.424).center([0, 33.6442]);
}
function geoAlbers() {
  return geoConicEqualArea().parallels([29.5, 45.5]).scale(1070).translate([480, 250]).rotate([96, 0]).center([-0.6, 38.7]);
}
function multiplex(streams) {
  var n = streams.length;
  return {
    point: function(x2, y2) {
      var i = -1;
      while (++i < n)
        streams[i].point(x2, y2);
    },
    sphere: function() {
      var i = -1;
      while (++i < n)
        streams[i].sphere();
    },
    lineStart: function() {
      var i = -1;
      while (++i < n)
        streams[i].lineStart();
    },
    lineEnd: function() {
      var i = -1;
      while (++i < n)
        streams[i].lineEnd();
    },
    polygonStart: function() {
      var i = -1;
      while (++i < n)
        streams[i].polygonStart();
    },
    polygonEnd: function() {
      var i = -1;
      while (++i < n)
        streams[i].polygonEnd();
    }
  };
}
function geoAlbersUsa() {
  var cache2, cacheStream, lower48 = geoAlbers(), lower48Point, alaska = geoConicEqualArea().rotate([154, 0]).center([-2, 58.5]).parallels([55, 65]), alaskaPoint, hawaii = geoConicEqualArea().rotate([157, 0]).center([-3, 19.9]).parallels([8, 18]), hawaiiPoint, point2, pointStream = { point: function(x2, y2) {
    point2 = [x2, y2];
  } };
  function albersUsa(coordinates) {
    var x2 = coordinates[0], y2 = coordinates[1];
    return point2 = null, (lower48Point.point(x2, y2), point2) || (alaskaPoint.point(x2, y2), point2) || (hawaiiPoint.point(x2, y2), point2);
  }
  albersUsa.invert = function(coordinates) {
    var k = lower48.scale(), t = lower48.translate(), x2 = (coordinates[0] - t[0]) / k, y2 = (coordinates[1] - t[1]) / k;
    return (y2 >= 0.12 && y2 < 0.234 && x2 >= -0.425 && x2 < -0.214 ? alaska : y2 >= 0.166 && y2 < 0.234 && x2 >= -0.214 && x2 < -0.115 ? hawaii : lower48).invert(coordinates);
  };
  albersUsa.stream = function(stream2) {
    return cache2 && cacheStream === stream2 ? cache2 : cache2 = multiplex([lower48.stream(cacheStream = stream2), alaska.stream(stream2), hawaii.stream(stream2)]);
  };
  albersUsa.precision = function(_) {
    if (!arguments.length)
      return lower48.precision();
    lower48.precision(_), alaska.precision(_), hawaii.precision(_);
    return reset2();
  };
  albersUsa.scale = function(_) {
    if (!arguments.length)
      return lower48.scale();
    lower48.scale(_), alaska.scale(_ * 0.35), hawaii.scale(_);
    return albersUsa.translate(lower48.translate());
  };
  albersUsa.translate = function(_) {
    if (!arguments.length)
      return lower48.translate();
    var k = lower48.scale(), x2 = +_[0], y2 = +_[1];
    lower48Point = lower48.translate(_).clipExtent([[x2 - 0.455 * k, y2 - 0.238 * k], [x2 + 0.455 * k, y2 + 0.238 * k]]).stream(pointStream);
    alaskaPoint = alaska.translate([x2 - 0.307 * k, y2 + 0.201 * k]).clipExtent([[x2 - 0.425 * k + epsilon$3, y2 + 0.12 * k + epsilon$3], [x2 - 0.214 * k - epsilon$3, y2 + 0.234 * k - epsilon$3]]).stream(pointStream);
    hawaiiPoint = hawaii.translate([x2 - 0.205 * k, y2 + 0.212 * k]).clipExtent([[x2 - 0.214 * k + epsilon$3, y2 + 0.166 * k + epsilon$3], [x2 - 0.115 * k - epsilon$3, y2 + 0.234 * k - epsilon$3]]).stream(pointStream);
    return reset2();
  };
  albersUsa.fitExtent = function(extent2, object2) {
    return fitExtent(albersUsa, extent2, object2);
  };
  albersUsa.fitSize = function(size, object2) {
    return fitSize(albersUsa, size, object2);
  };
  albersUsa.fitWidth = function(width2, object2) {
    return fitWidth(albersUsa, width2, object2);
  };
  albersUsa.fitHeight = function(height2, object2) {
    return fitHeight(albersUsa, height2, object2);
  };
  function reset2() {
    cache2 = cacheStream = null;
    return albersUsa;
  }
  return albersUsa.scale(1070);
}
function azimuthalRaw(scale2) {
  return function(x2, y2) {
    var cx = cos$2(x2), cy = cos$2(y2), k = scale2(cx * cy);
    if (k === Infinity)
      return [2, 0];
    return [
      k * cy * sin$2(x2),
      k * sin$2(y2)
    ];
  };
}
function azimuthalInvert(angle2) {
  return function(x2, y2) {
    var z = sqrt$3(x2 * x2 + y2 * y2), c2 = angle2(z), sc = sin$2(c2), cc = cos$2(c2);
    return [
      atan2$1(x2 * sc, z * cc),
      asin$2(z && y2 * sc / z)
    ];
  };
}
var azimuthalEqualAreaRaw = azimuthalRaw(function(cxcy) {
  return sqrt$3(2 / (1 + cxcy));
});
azimuthalEqualAreaRaw.invert = azimuthalInvert(function(z) {
  return 2 * asin$2(z / 2);
});
function geoAzimuthalEqualArea() {
  return projection$1(azimuthalEqualAreaRaw).scale(124.75).clipAngle(180 - 1e-3);
}
var azimuthalEquidistantRaw = azimuthalRaw(function(c2) {
  return (c2 = acos$1(c2)) && c2 / sin$2(c2);
});
azimuthalEquidistantRaw.invert = azimuthalInvert(function(z) {
  return z;
});
function geoAzimuthalEquidistant() {
  return projection$1(azimuthalEquidistantRaw).scale(79.4188).clipAngle(180 - 1e-3);
}
function mercatorRaw(lambda, phi2) {
  return [lambda, log$5(tan((halfPi$2 + phi2) / 2))];
}
mercatorRaw.invert = function(x2, y2) {
  return [x2, 2 * atan(exp$2(y2)) - halfPi$2];
};
function geoMercator() {
  return mercatorProjection(mercatorRaw).scale(961 / tau$1);
}
function mercatorProjection(project2) {
  var m2 = projection$1(project2), center = m2.center, scale2 = m2.scale, translate2 = m2.translate, clipExtent = m2.clipExtent, x02 = null, y02, x12, y12;
  m2.scale = function(_) {
    return arguments.length ? (scale2(_), reclip()) : scale2();
  };
  m2.translate = function(_) {
    return arguments.length ? (translate2(_), reclip()) : translate2();
  };
  m2.center = function(_) {
    return arguments.length ? (center(_), reclip()) : center();
  };
  m2.clipExtent = function(_) {
    return arguments.length ? (_ == null ? x02 = y02 = x12 = y12 = null : (x02 = +_[0][0], y02 = +_[0][1], x12 = +_[1][0], y12 = +_[1][1]), reclip()) : x02 == null ? null : [[x02, y02], [x12, y12]];
  };
  function reclip() {
    var k = pi$2 * scale2(), t = m2(rotation(m2.rotate()).invert([0, 0]));
    return clipExtent(x02 == null ? [[t[0] - k, t[1] - k], [t[0] + k, t[1] + k]] : project2 === mercatorRaw ? [[Math.max(t[0] - k, x02), y02], [Math.min(t[0] + k, x12), y12]] : [[x02, Math.max(t[1] - k, y02)], [x12, Math.min(t[1] + k, y12)]]);
  }
  return reclip();
}
function tany(y2) {
  return tan((halfPi$2 + y2) / 2);
}
function conicConformalRaw(y02, y12) {
  var cy0 = cos$2(y02), n = y02 === y12 ? sin$2(y02) : log$5(cy0 / cos$2(y12)) / log$5(tany(y12) / tany(y02)), f = cy0 * pow$3(tany(y02), n) / n;
  if (!n)
    return mercatorRaw;
  function project2(x2, y2) {
    if (f > 0) {
      if (y2 < -halfPi$2 + epsilon$3)
        y2 = -halfPi$2 + epsilon$3;
    } else {
      if (y2 > halfPi$2 - epsilon$3)
        y2 = halfPi$2 - epsilon$3;
    }
    var r = f / pow$3(tany(y2), n);
    return [r * sin$2(n * x2), f - r * cos$2(n * x2)];
  }
  project2.invert = function(x2, y2) {
    var fy = f - y2, r = sign$1(n) * sqrt$3(x2 * x2 + fy * fy), l = atan2$1(x2, abs$2(fy)) * sign$1(fy);
    if (fy * n < 0)
      l -= pi$2 * sign$1(x2) * sign$1(fy);
    return [l / n, 2 * atan(pow$3(f / r, 1 / n)) - halfPi$2];
  };
  return project2;
}
function geoConicConformal() {
  return conicProjection(conicConformalRaw).scale(109.5).parallels([30, 30]);
}
function equirectangularRaw(lambda, phi2) {
  return [lambda, phi2];
}
equirectangularRaw.invert = equirectangularRaw;
function geoEquirectangular() {
  return projection$1(equirectangularRaw).scale(152.63);
}
function conicEquidistantRaw(y02, y12) {
  var cy0 = cos$2(y02), n = y02 === y12 ? sin$2(y02) : (cy0 - cos$2(y12)) / (y12 - y02), g = cy0 / n + y02;
  if (abs$2(n) < epsilon$3)
    return equirectangularRaw;
  function project2(x2, y2) {
    var gy = g - y2, nx = n * x2;
    return [gy * sin$2(nx), g - gy * cos$2(nx)];
  }
  project2.invert = function(x2, y2) {
    var gy = g - y2, l = atan2$1(x2, abs$2(gy)) * sign$1(gy);
    if (gy * n < 0)
      l -= pi$2 * sign$1(x2) * sign$1(gy);
    return [l / n, g - sign$1(n) * sqrt$3(x2 * x2 + gy * gy)];
  };
  return project2;
}
function geoConicEquidistant() {
  return conicProjection(conicEquidistantRaw).scale(131.154).center([0, 13.9389]);
}
var A1 = 1.340264, A2 = -0.081106, A3 = 893e-6, A4 = 3796e-6, M = sqrt$3(3) / 2, iterations = 12;
function equalEarthRaw(lambda, phi2) {
  var l = asin$2(M * sin$2(phi2)), l2 = l * l, l6 = l2 * l2 * l2;
  return [
    lambda * cos$2(l) / (M * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2))),
    l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2))
  ];
}
equalEarthRaw.invert = function(x2, y2) {
  var l = y2, l2 = l * l, l6 = l2 * l2 * l2;
  for (var i = 0, delta, fy, fpy; i < iterations; ++i) {
    fy = l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2)) - y2;
    fpy = A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2);
    l -= delta = fy / fpy, l2 = l * l, l6 = l2 * l2 * l2;
    if (abs$2(delta) < epsilon2)
      break;
  }
  return [
    M * x2 * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2)) / cos$2(l),
    asin$2(sin$2(l) / M)
  ];
};
function geoEqualEarth() {
  return projection$1(equalEarthRaw).scale(177.158);
}
function gnomonicRaw(x2, y2) {
  var cy = cos$2(y2), k = cos$2(x2) * cy;
  return [cy * sin$2(x2) / k, sin$2(y2) / k];
}
gnomonicRaw.invert = azimuthalInvert(atan);
function geoGnomonic() {
  return projection$1(gnomonicRaw).scale(144.049).clipAngle(60);
}
function geoIdentity() {
  var k = 1, tx2 = 0, ty = 0, sx = 1, sy = 1, alpha = 0, ca, sa2, x02 = null, y02, x12, y12, kx = 1, ky = 1, transform2 = transformer$3({
    point: function(x2, y2) {
      var p = projection2([x2, y2]);
      this.stream.point(p[0], p[1]);
    }
  }), postclip = identity$4, cache2, cacheStream;
  function reset2() {
    kx = k * sx;
    ky = k * sy;
    cache2 = cacheStream = null;
    return projection2;
  }
  function projection2(p) {
    var x2 = p[0] * kx, y2 = p[1] * ky;
    if (alpha) {
      var t = y2 * ca - x2 * sa2;
      x2 = x2 * ca + y2 * sa2;
      y2 = t;
    }
    return [x2 + tx2, y2 + ty];
  }
  projection2.invert = function(p) {
    var x2 = p[0] - tx2, y2 = p[1] - ty;
    if (alpha) {
      var t = y2 * ca + x2 * sa2;
      x2 = x2 * ca - y2 * sa2;
      y2 = t;
    }
    return [x2 / kx, y2 / ky];
  };
  projection2.stream = function(stream2) {
    return cache2 && cacheStream === stream2 ? cache2 : cache2 = transform2(postclip(cacheStream = stream2));
  };
  projection2.postclip = function(_) {
    return arguments.length ? (postclip = _, x02 = y02 = x12 = y12 = null, reset2()) : postclip;
  };
  projection2.clipExtent = function(_) {
    return arguments.length ? (postclip = _ == null ? (x02 = y02 = x12 = y12 = null, identity$4) : clipRectangle(x02 = +_[0][0], y02 = +_[0][1], x12 = +_[1][0], y12 = +_[1][1]), reset2()) : x02 == null ? null : [[x02, y02], [x12, y12]];
  };
  projection2.scale = function(_) {
    return arguments.length ? (k = +_, reset2()) : k;
  };
  projection2.translate = function(_) {
    return arguments.length ? (tx2 = +_[0], ty = +_[1], reset2()) : [tx2, ty];
  };
  projection2.angle = function(_) {
    return arguments.length ? (alpha = _ % 360 * radians, sa2 = sin$2(alpha), ca = cos$2(alpha), reset2()) : alpha * degrees;
  };
  projection2.reflectX = function(_) {
    return arguments.length ? (sx = _ ? -1 : 1, reset2()) : sx < 0;
  };
  projection2.reflectY = function(_) {
    return arguments.length ? (sy = _ ? -1 : 1, reset2()) : sy < 0;
  };
  projection2.fitExtent = function(extent2, object2) {
    return fitExtent(projection2, extent2, object2);
  };
  projection2.fitSize = function(size, object2) {
    return fitSize(projection2, size, object2);
  };
  projection2.fitWidth = function(width2, object2) {
    return fitWidth(projection2, width2, object2);
  };
  projection2.fitHeight = function(height2, object2) {
    return fitHeight(projection2, height2, object2);
  };
  return projection2;
}
function naturalEarth1Raw(lambda, phi2) {
  var phi22 = phi2 * phi2, phi4 = phi22 * phi22;
  return [
    lambda * (0.8707 - 0.131979 * phi22 + phi4 * (-0.013791 + phi4 * (3971e-6 * phi22 - 1529e-6 * phi4))),
    phi2 * (1.007226 + phi22 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi22 - 5916e-6 * phi4)))
  ];
}
naturalEarth1Raw.invert = function(x2, y2) {
  var phi2 = y2, i = 25, delta;
  do {
    var phi22 = phi2 * phi2, phi4 = phi22 * phi22;
    phi2 -= delta = (phi2 * (1.007226 + phi22 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi22 - 5916e-6 * phi4))) - y2) / (1.007226 + phi22 * (0.015085 * 3 + phi4 * (-0.044475 * 7 + 0.028874 * 9 * phi22 - 5916e-6 * 11 * phi4)));
  } while (abs$2(delta) > epsilon$3 && --i > 0);
  return [
    x2 / (0.8707 + (phi22 = phi2 * phi2) * (-0.131979 + phi22 * (-0.013791 + phi22 * phi22 * phi22 * (3971e-6 - 1529e-6 * phi22)))),
    phi2
  ];
};
function geoNaturalEarth1() {
  return projection$1(naturalEarth1Raw).scale(175.295);
}
function orthographicRaw(x2, y2) {
  return [cos$2(y2) * sin$2(x2), sin$2(y2)];
}
orthographicRaw.invert = azimuthalInvert(asin$2);
function geoOrthographic() {
  return projection$1(orthographicRaw).scale(249.5).clipAngle(90 + epsilon$3);
}
function stereographicRaw(x2, y2) {
  var cy = cos$2(y2), k = 1 + cos$2(x2) * cy;
  return [cy * sin$2(x2) / k, sin$2(y2) / k];
}
stereographicRaw.invert = azimuthalInvert(function(z) {
  return 2 * atan(z);
});
function geoStereographic() {
  return projection$1(stereographicRaw).scale(250).clipAngle(142);
}
function transverseMercatorRaw(lambda, phi2) {
  return [log$5(tan((halfPi$2 + phi2) / 2)), -lambda];
}
transverseMercatorRaw.invert = function(x2, y2) {
  return [-y2, 2 * atan(exp$2(x2)) - halfPi$2];
};
function geoTransverseMercator() {
  var m2 = mercatorProjection(transverseMercatorRaw), center = m2.center, rotate2 = m2.rotate;
  m2.center = function(_) {
    return arguments.length ? center([-_[1], _[0]]) : (_ = center(), [_[1], -_[0]]);
  };
  m2.rotate = function(_) {
    return arguments.length ? rotate2([_[0], _[1], _.length > 2 ? _[2] + 90 : 90]) : (_ = rotate2(), [_[0], _[1], _[2] - 90]);
  };
  return rotate2([0, 0, 90]).scale(159.155);
}
function defaultSeparation$2(a2, b2) {
  return a2.parent === b2.parent ? 1 : 2;
}
function meanX(children2) {
  return children2.reduce(meanXReduce, 0) / children2.length;
}
function meanXReduce(x2, c2) {
  return x2 + c2.x;
}
function maxY(children2) {
  return 1 + children2.reduce(maxYReduce, 0);
}
function maxYReduce(y2, c2) {
  return Math.max(y2, c2.y);
}
function leafLeft(node) {
  var children2;
  while (children2 = node.children)
    node = children2[0];
  return node;
}
function leafRight(node) {
  var children2;
  while (children2 = node.children)
    node = children2[children2.length - 1];
  return node;
}
function cluster() {
  var separation = defaultSeparation$2, dx = 1, dy = 1, nodeSize = false;
  function cluster2(root) {
    var previousNode, x2 = 0;
    root.eachAfter(function(node) {
      var children2 = node.children;
      if (children2) {
        node.x = meanX(children2);
        node.y = maxY(children2);
      } else {
        node.x = previousNode ? x2 += separation(node, previousNode) : 0;
        node.y = 0;
        previousNode = node;
      }
    });
    var left = leafLeft(root), right = leafRight(root), x02 = left.x - separation(left, right) / 2, x12 = right.x + separation(right, left) / 2;
    return root.eachAfter(nodeSize ? function(node) {
      node.x = (node.x - root.x) * dx;
      node.y = (root.y - node.y) * dy;
    } : function(node) {
      node.x = (node.x - x02) / (x12 - x02) * dx;
      node.y = (1 - (root.y ? node.y / root.y : 1)) * dy;
    });
  }
  cluster2.separation = function(x2) {
    return arguments.length ? (separation = x2, cluster2) : separation;
  };
  cluster2.size = function(x2) {
    return arguments.length ? (nodeSize = false, dx = +x2[0], dy = +x2[1], cluster2) : nodeSize ? null : [dx, dy];
  };
  cluster2.nodeSize = function(x2) {
    return arguments.length ? (nodeSize = true, dx = +x2[0], dy = +x2[1], cluster2) : nodeSize ? [dx, dy] : null;
  };
  return cluster2;
}
function count(node) {
  var sum2 = 0, children2 = node.children, i = children2 && children2.length;
  if (!i)
    sum2 = 1;
  else
    while (--i >= 0)
      sum2 += children2[i].value;
  node.value = sum2;
}
function node_count() {
  return this.eachAfter(count);
}
function node_each(callback, that) {
  let index2 = -1;
  for (const node of this) {
    callback.call(that, node, ++index2, this);
  }
  return this;
}
function node_eachBefore(callback, that) {
  var node = this, nodes = [node], children2, i, index2 = -1;
  while (node = nodes.pop()) {
    callback.call(that, node, ++index2, this);
    if (children2 = node.children) {
      for (i = children2.length - 1; i >= 0; --i) {
        nodes.push(children2[i]);
      }
    }
  }
  return this;
}
function node_eachAfter(callback, that) {
  var node = this, nodes = [node], next = [], children2, i, n, index2 = -1;
  while (node = nodes.pop()) {
    next.push(node);
    if (children2 = node.children) {
      for (i = 0, n = children2.length; i < n; ++i) {
        nodes.push(children2[i]);
      }
    }
  }
  while (node = next.pop()) {
    callback.call(that, node, ++index2, this);
  }
  return this;
}
function node_find(callback, that) {
  let index2 = -1;
  for (const node of this) {
    if (callback.call(that, node, ++index2, this)) {
      return node;
    }
  }
}
function node_sum(value2) {
  return this.eachAfter(function(node) {
    var sum2 = +value2(node.data) || 0, children2 = node.children, i = children2 && children2.length;
    while (--i >= 0)
      sum2 += children2[i].value;
    node.value = sum2;
  });
}
function node_sort(compare2) {
  return this.eachBefore(function(node) {
    if (node.children) {
      node.children.sort(compare2);
    }
  });
}
function node_path(end) {
  var start = this, ancestor = leastCommonAncestor(start, end), nodes = [start];
  while (start !== ancestor) {
    start = start.parent;
    nodes.push(start);
  }
  var k = nodes.length;
  while (end !== ancestor) {
    nodes.splice(k, 0, end);
    end = end.parent;
  }
  return nodes;
}
function leastCommonAncestor(a2, b2) {
  if (a2 === b2)
    return a2;
  var aNodes = a2.ancestors(), bNodes = b2.ancestors(), c2 = null;
  a2 = aNodes.pop();
  b2 = bNodes.pop();
  while (a2 === b2) {
    c2 = a2;
    a2 = aNodes.pop();
    b2 = bNodes.pop();
  }
  return c2;
}
function node_ancestors() {
  var node = this, nodes = [node];
  while (node = node.parent) {
    nodes.push(node);
  }
  return nodes;
}
function node_descendants() {
  return Array.from(this);
}
function node_leaves() {
  var leaves = [];
  this.eachBefore(function(node) {
    if (!node.children) {
      leaves.push(node);
    }
  });
  return leaves;
}
function node_links() {
  var root = this, links = [];
  root.each(function(node) {
    if (node !== root) {
      links.push({ source: node.parent, target: node });
    }
  });
  return links;
}
function* node_iterator() {
  var node = this, current, next = [node], children2, i, n;
  do {
    current = next.reverse(), next = [];
    while (node = current.pop()) {
      yield node;
      if (children2 = node.children) {
        for (i = 0, n = children2.length; i < n; ++i) {
          next.push(children2[i]);
        }
      }
    }
  } while (next.length);
}
function hierarchy(data2, children2) {
  if (data2 instanceof Map) {
    data2 = [void 0, data2];
    if (children2 === void 0)
      children2 = mapChildren;
  } else if (children2 === void 0) {
    children2 = objectChildren;
  }
  var root = new Node$1(data2), node, nodes = [root], child, childs, i, n;
  while (node = nodes.pop()) {
    if ((childs = children2(node.data)) && (n = (childs = Array.from(childs)).length)) {
      node.children = childs;
      for (i = n - 1; i >= 0; --i) {
        nodes.push(child = childs[i] = new Node$1(childs[i]));
        child.parent = node;
        child.depth = node.depth + 1;
      }
    }
  }
  return root.eachBefore(computeHeight);
}
function node_copy() {
  return hierarchy(this).eachBefore(copyData);
}
function objectChildren(d) {
  return d.children;
}
function mapChildren(d) {
  return Array.isArray(d) ? d[1] : null;
}
function copyData(node) {
  if (node.data.value !== void 0)
    node.value = node.data.value;
  node.data = node.data.data;
}
function computeHeight(node) {
  var height2 = 0;
  do
    node.height = height2;
  while ((node = node.parent) && node.height < ++height2);
}
function Node$1(data2) {
  this.data = data2;
  this.depth = this.height = 0;
  this.parent = null;
}
Node$1.prototype = hierarchy.prototype = {
  constructor: Node$1,
  count: node_count,
  each: node_each,
  eachAfter: node_eachAfter,
  eachBefore: node_eachBefore,
  find: node_find,
  sum: node_sum,
  sort: node_sort,
  path: node_path,
  ancestors: node_ancestors,
  descendants: node_descendants,
  leaves: node_leaves,
  links: node_links,
  copy: node_copy,
  [Symbol.iterator]: node_iterator
};
function optional(f) {
  return f == null ? null : required(f);
}
function required(f) {
  if (typeof f !== "function")
    throw new Error();
  return f;
}
function constantZero() {
  return 0;
}
function constant$2(x2) {
  return function() {
    return x2;
  };
}
const a = 1664525;
const c = 1013904223;
const m = 4294967296;
function lcg$1() {
  let s = 1;
  return () => (s = (a * s + c) % m) / m;
}
function array$5(x2) {
  return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
}
function shuffle(array2, random2) {
  let m2 = array2.length, t, i;
  while (m2) {
    i = random2() * m2-- | 0;
    t = array2[m2];
    array2[m2] = array2[i];
    array2[i] = t;
  }
  return array2;
}
function packEncloseRandom(circles, random2) {
  var i = 0, n = (circles = shuffle(Array.from(circles), random2)).length, B2 = [], p, e;
  while (i < n) {
    p = circles[i];
    if (e && enclosesWeak(e, p))
      ++i;
    else
      e = encloseBasis(B2 = extendBasis(B2, p)), i = 0;
  }
  return e;
}
function extendBasis(B2, p) {
  var i, j;
  if (enclosesWeakAll(p, B2))
    return [p];
  for (i = 0; i < B2.length; ++i) {
    if (enclosesNot(p, B2[i]) && enclosesWeakAll(encloseBasis2(B2[i], p), B2)) {
      return [B2[i], p];
    }
  }
  for (i = 0; i < B2.length - 1; ++i) {
    for (j = i + 1; j < B2.length; ++j) {
      if (enclosesNot(encloseBasis2(B2[i], B2[j]), p) && enclosesNot(encloseBasis2(B2[i], p), B2[j]) && enclosesNot(encloseBasis2(B2[j], p), B2[i]) && enclosesWeakAll(encloseBasis3(B2[i], B2[j], p), B2)) {
        return [B2[i], B2[j], p];
      }
    }
  }
  throw new Error();
}
function enclosesNot(a2, b2) {
  var dr = a2.r - b2.r, dx = b2.x - a2.x, dy = b2.y - a2.y;
  return dr < 0 || dr * dr < dx * dx + dy * dy;
}
function enclosesWeak(a2, b2) {
  var dr = a2.r - b2.r + Math.max(a2.r, b2.r, 1) * 1e-9, dx = b2.x - a2.x, dy = b2.y - a2.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}
function enclosesWeakAll(a2, B2) {
  for (var i = 0; i < B2.length; ++i) {
    if (!enclosesWeak(a2, B2[i])) {
      return false;
    }
  }
  return true;
}
function encloseBasis(B2) {
  switch (B2.length) {
    case 1:
      return encloseBasis1(B2[0]);
    case 2:
      return encloseBasis2(B2[0], B2[1]);
    case 3:
      return encloseBasis3(B2[0], B2[1], B2[2]);
  }
}
function encloseBasis1(a2) {
  return {
    x: a2.x,
    y: a2.y,
    r: a2.r
  };
}
function encloseBasis2(a2, b2) {
  var x12 = a2.x, y12 = a2.y, r1 = a2.r, x2 = b2.x, y2 = b2.y, r2 = b2.r, x21 = x2 - x12, y21 = y2 - y12, r21 = r2 - r1, l = Math.sqrt(x21 * x21 + y21 * y21);
  return {
    x: (x12 + x2 + x21 / l * r21) / 2,
    y: (y12 + y2 + y21 / l * r21) / 2,
    r: (l + r1 + r2) / 2
  };
}
function encloseBasis3(a2, b2, c2) {
  var x12 = a2.x, y12 = a2.y, r1 = a2.r, x2 = b2.x, y2 = b2.y, r2 = b2.r, x3 = c2.x, y3 = c2.y, r3 = c2.r, a22 = x12 - x2, a3 = x12 - x3, b22 = y12 - y2, b3 = y12 - y3, c22 = r2 - r1, c3 = r3 - r1, d1 = x12 * x12 + y12 * y12 - r1 * r1, d2 = d1 - x2 * x2 - y2 * y2 + r2 * r2, d3 = d1 - x3 * x3 - y3 * y3 + r3 * r3, ab = a3 * b22 - a22 * b3, xa = (b22 * d3 - b3 * d2) / (ab * 2) - x12, xb = (b3 * c22 - b22 * c3) / ab, ya = (a3 * d2 - a22 * d3) / (ab * 2) - y12, yb = (a22 * c3 - a3 * c22) / ab, A5 = xb * xb + yb * yb - 1, B2 = 2 * (r1 + xa * xb + ya * yb), C3 = xa * xa + ya * ya - r1 * r1, r = -(Math.abs(A5) > 1e-6 ? (B2 + Math.sqrt(B2 * B2 - 4 * A5 * C3)) / (2 * A5) : C3 / B2);
  return {
    x: x12 + xa + xb * r,
    y: y12 + ya + yb * r,
    r
  };
}
function place(b2, a2, c2) {
  var dx = b2.x - a2.x, x2, a22, dy = b2.y - a2.y, y2, b22, d2 = dx * dx + dy * dy;
  if (d2) {
    a22 = a2.r + c2.r, a22 *= a22;
    b22 = b2.r + c2.r, b22 *= b22;
    if (a22 > b22) {
      x2 = (d2 + b22 - a22) / (2 * d2);
      y2 = Math.sqrt(Math.max(0, b22 / d2 - x2 * x2));
      c2.x = b2.x - x2 * dx - y2 * dy;
      c2.y = b2.y - x2 * dy + y2 * dx;
    } else {
      x2 = (d2 + a22 - b22) / (2 * d2);
      y2 = Math.sqrt(Math.max(0, a22 / d2 - x2 * x2));
      c2.x = a2.x + x2 * dx - y2 * dy;
      c2.y = a2.y + x2 * dy + y2 * dx;
    }
  } else {
    c2.x = a2.x + c2.r;
    c2.y = a2.y;
  }
}
function intersects(a2, b2) {
  var dr = a2.r + b2.r - 1e-6, dx = b2.x - a2.x, dy = b2.y - a2.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}
function score(node) {
  var a2 = node._, b2 = node.next._, ab = a2.r + b2.r, dx = (a2.x * b2.r + b2.x * a2.r) / ab, dy = (a2.y * b2.r + b2.y * a2.r) / ab;
  return dx * dx + dy * dy;
}
function Node(circle2) {
  this._ = circle2;
  this.next = null;
  this.previous = null;
}
function packSiblingsRandom(circles, random2) {
  if (!(n = (circles = array$5(circles)).length))
    return 0;
  var a2, b2, c2, n, aa, ca, i, j, k, sj, sk;
  a2 = circles[0], a2.x = 0, a2.y = 0;
  if (!(n > 1))
    return a2.r;
  b2 = circles[1], a2.x = -b2.r, b2.x = a2.r, b2.y = 0;
  if (!(n > 2))
    return a2.r + b2.r;
  place(b2, a2, c2 = circles[2]);
  a2 = new Node(a2), b2 = new Node(b2), c2 = new Node(c2);
  a2.next = c2.previous = b2;
  b2.next = a2.previous = c2;
  c2.next = b2.previous = a2;
  pack:
    for (i = 3; i < n; ++i) {
      place(a2._, b2._, c2 = circles[i]), c2 = new Node(c2);
      j = b2.next, k = a2.previous, sj = b2._.r, sk = a2._.r;
      do {
        if (sj <= sk) {
          if (intersects(j._, c2._)) {
            b2 = j, a2.next = b2, b2.previous = a2, --i;
            continue pack;
          }
          sj += j._.r, j = j.next;
        } else {
          if (intersects(k._, c2._)) {
            a2 = k, a2.next = b2, b2.previous = a2, --i;
            continue pack;
          }
          sk += k._.r, k = k.previous;
        }
      } while (j !== k.next);
      c2.previous = a2, c2.next = b2, a2.next = b2.previous = b2 = c2;
      aa = score(a2);
      while ((c2 = c2.next) !== b2) {
        if ((ca = score(c2)) < aa) {
          a2 = c2, aa = ca;
        }
      }
      b2 = a2.next;
    }
  a2 = [b2._], c2 = b2;
  while ((c2 = c2.next) !== b2)
    a2.push(c2._);
  c2 = packEncloseRandom(a2, random2);
  for (i = 0; i < n; ++i)
    a2 = circles[i], a2.x -= c2.x, a2.y -= c2.y;
  return c2.r;
}
function defaultRadius(d) {
  return Math.sqrt(d.value);
}
function pack() {
  var radius2 = null, dx = 1, dy = 1, padding2 = constantZero;
  function pack2(root) {
    const random2 = lcg$1();
    root.x = dx / 2, root.y = dy / 2;
    if (radius2) {
      root.eachBefore(radiusLeaf(radius2)).eachAfter(packChildrenRandom(padding2, 0.5, random2)).eachBefore(translateChild(1));
    } else {
      root.eachBefore(radiusLeaf(defaultRadius)).eachAfter(packChildrenRandom(constantZero, 1, random2)).eachAfter(packChildrenRandom(padding2, root.r / Math.min(dx, dy), random2)).eachBefore(translateChild(Math.min(dx, dy) / (2 * root.r)));
    }
    return root;
  }
  pack2.radius = function(x2) {
    return arguments.length ? (radius2 = optional(x2), pack2) : radius2;
  };
  pack2.size = function(x2) {
    return arguments.length ? (dx = +x2[0], dy = +x2[1], pack2) : [dx, dy];
  };
  pack2.padding = function(x2) {
    return arguments.length ? (padding2 = typeof x2 === "function" ? x2 : constant$2(+x2), pack2) : padding2;
  };
  return pack2;
}
function radiusLeaf(radius2) {
  return function(node) {
    if (!node.children) {
      node.r = Math.max(0, +radius2(node) || 0);
    }
  };
}
function packChildrenRandom(padding2, k, random2) {
  return function(node) {
    if (children2 = node.children) {
      var children2, i, n = children2.length, r = padding2(node) * k || 0, e;
      if (r)
        for (i = 0; i < n; ++i)
          children2[i].r += r;
      e = packSiblingsRandom(children2, random2);
      if (r)
        for (i = 0; i < n; ++i)
          children2[i].r -= r;
      node.r = e + r;
    }
  };
}
function translateChild(k) {
  return function(node) {
    var parent = node.parent;
    node.r *= k;
    if (parent) {
      node.x = parent.x + k * node.x;
      node.y = parent.y + k * node.y;
    }
  };
}
function roundNode(node) {
  node.x0 = Math.round(node.x0);
  node.y0 = Math.round(node.y0);
  node.x1 = Math.round(node.x1);
  node.y1 = Math.round(node.y1);
}
function treemapDice(parent, x02, y02, x12, y12) {
  var nodes = parent.children, node, i = -1, n = nodes.length, k = parent.value && (x12 - x02) / parent.value;
  while (++i < n) {
    node = nodes[i], node.y0 = y02, node.y1 = y12;
    node.x0 = x02, node.x1 = x02 += node.value * k;
  }
}
function partition$4() {
  var dx = 1, dy = 1, padding2 = 0, round = false;
  function partition2(root) {
    var n = root.height + 1;
    root.x0 = root.y0 = padding2;
    root.x1 = dx;
    root.y1 = dy / n;
    root.eachBefore(positionNode(dy, n));
    if (round)
      root.eachBefore(roundNode);
    return root;
  }
  function positionNode(dy2, n) {
    return function(node) {
      if (node.children) {
        treemapDice(node, node.x0, dy2 * (node.depth + 1) / n, node.x1, dy2 * (node.depth + 2) / n);
      }
      var x02 = node.x0, y02 = node.y0, x12 = node.x1 - padding2, y12 = node.y1 - padding2;
      if (x12 < x02)
        x02 = x12 = (x02 + x12) / 2;
      if (y12 < y02)
        y02 = y12 = (y02 + y12) / 2;
      node.x0 = x02;
      node.y0 = y02;
      node.x1 = x12;
      node.y1 = y12;
    };
  }
  partition2.round = function(x2) {
    return arguments.length ? (round = !!x2, partition2) : round;
  };
  partition2.size = function(x2) {
    return arguments.length ? (dx = +x2[0], dy = +x2[1], partition2) : [dx, dy];
  };
  partition2.padding = function(x2) {
    return arguments.length ? (padding2 = +x2, partition2) : padding2;
  };
  return partition2;
}
var preroot = { depth: -1 }, ambiguous = {}, imputed = {};
function defaultId(d) {
  return d.id;
}
function defaultParentId(d) {
  return d.parentId;
}
function stratify() {
  var id2 = defaultId, parentId = defaultParentId, path2;
  function stratify2(data2) {
    var nodes = Array.from(data2), currentId = id2, currentParentId = parentId, n, d, i, root, parent, node, nodeId, nodeKey, nodeByKey = /* @__PURE__ */ new Map();
    if (path2 != null) {
      const I = nodes.map((d2, i2) => normalize$1(path2(d2, i2, data2)));
      const P = I.map(parentof);
      const S = new Set(I).add("");
      for (const i2 of P) {
        if (!S.has(i2)) {
          S.add(i2);
          I.push(i2);
          P.push(parentof(i2));
          nodes.push(imputed);
        }
      }
      currentId = (_, i2) => I[i2];
      currentParentId = (_, i2) => P[i2];
    }
    for (i = 0, n = nodes.length; i < n; ++i) {
      d = nodes[i], node = nodes[i] = new Node$1(d);
      if ((nodeId = currentId(d, i, data2)) != null && (nodeId += "")) {
        nodeKey = node.id = nodeId;
        nodeByKey.set(nodeKey, nodeByKey.has(nodeKey) ? ambiguous : node);
      }
      if ((nodeId = currentParentId(d, i, data2)) != null && (nodeId += "")) {
        node.parent = nodeId;
      }
    }
    for (i = 0; i < n; ++i) {
      node = nodes[i];
      if (nodeId = node.parent) {
        parent = nodeByKey.get(nodeId);
        if (!parent)
          throw new Error("missing: " + nodeId);
        if (parent === ambiguous)
          throw new Error("ambiguous: " + nodeId);
        if (parent.children)
          parent.children.push(node);
        else
          parent.children = [node];
        node.parent = parent;
      } else {
        if (root)
          throw new Error("multiple roots");
        root = node;
      }
    }
    if (!root)
      throw new Error("no root");
    if (path2 != null) {
      while (root.data === imputed && root.children.length === 1) {
        root = root.children[0], --n;
      }
      for (let i2 = nodes.length - 1; i2 >= 0; --i2) {
        node = nodes[i2];
        if (node.data !== imputed)
          break;
        node.data = null;
      }
    }
    root.parent = preroot;
    root.eachBefore(function(node2) {
      node2.depth = node2.parent.depth + 1;
      --n;
    }).eachBefore(computeHeight);
    root.parent = null;
    if (n > 0)
      throw new Error("cycle");
    return root;
  }
  stratify2.id = function(x2) {
    return arguments.length ? (id2 = optional(x2), stratify2) : id2;
  };
  stratify2.parentId = function(x2) {
    return arguments.length ? (parentId = optional(x2), stratify2) : parentId;
  };
  stratify2.path = function(x2) {
    return arguments.length ? (path2 = optional(x2), stratify2) : path2;
  };
  return stratify2;
}
function normalize$1(path2) {
  path2 = `${path2}`;
  let i = path2.length;
  if (slash(path2, i - 1) && !slash(path2, i - 2))
    path2 = path2.slice(0, -1);
  return path2[0] === "/" ? path2 : `/${path2}`;
}
function parentof(path2) {
  let i = path2.length;
  if (i < 2)
    return "";
  while (--i > 1)
    if (slash(path2, i))
      break;
  return path2.slice(0, i);
}
function slash(path2, i) {
  if (path2[i] === "/") {
    let k = 0;
    while (i > 0 && path2[--i] === "\\")
      ++k;
    if ((k & 1) === 0)
      return true;
  }
  return false;
}
function defaultSeparation$1(a2, b2) {
  return a2.parent === b2.parent ? 1 : 2;
}
function nextLeft(v) {
  var children2 = v.children;
  return children2 ? children2[0] : v.t;
}
function nextRight(v) {
  var children2 = v.children;
  return children2 ? children2[children2.length - 1] : v.t;
}
function moveSubtree(wm, wp, shift) {
  var change2 = shift / (wp.i - wm.i);
  wp.c -= change2;
  wp.s += shift;
  wm.c += change2;
  wp.z += shift;
  wp.m += shift;
}
function executeShifts(v) {
  var shift = 0, change2 = 0, children2 = v.children, i = children2.length, w2;
  while (--i >= 0) {
    w2 = children2[i];
    w2.z += shift;
    w2.m += shift;
    shift += w2.s + (change2 += w2.c);
  }
}
function nextAncestor(vim, v, ancestor) {
  return vim.a.parent === v.parent ? vim.a : ancestor;
}
function TreeNode(node, i) {
  this._ = node;
  this.parent = null;
  this.children = null;
  this.A = null;
  this.a = this;
  this.z = 0;
  this.m = 0;
  this.c = 0;
  this.s = 0;
  this.t = null;
  this.i = i;
}
TreeNode.prototype = Object.create(Node$1.prototype);
function treeRoot(root) {
  var tree2 = new TreeNode(root, 0), node, nodes = [tree2], child, children2, i, n;
  while (node = nodes.pop()) {
    if (children2 = node._.children) {
      node.children = new Array(n = children2.length);
      for (i = n - 1; i >= 0; --i) {
        nodes.push(child = node.children[i] = new TreeNode(children2[i], i));
        child.parent = node;
      }
    }
  }
  (tree2.parent = new TreeNode(null, 0)).children = [tree2];
  return tree2;
}
function tree$1() {
  var separation = defaultSeparation$1, dx = 1, dy = 1, nodeSize = null;
  function tree2(root) {
    var t = treeRoot(root);
    t.eachAfter(firstWalk), t.parent.m = -t.z;
    t.eachBefore(secondWalk);
    if (nodeSize)
      root.eachBefore(sizeNode);
    else {
      var left = root, right = root, bottom = root;
      root.eachBefore(function(node) {
        if (node.x < left.x)
          left = node;
        if (node.x > right.x)
          right = node;
        if (node.depth > bottom.depth)
          bottom = node;
      });
      var s = left === right ? 1 : separation(left, right) / 2, tx2 = s - left.x, kx = dx / (right.x + s + tx2), ky = dy / (bottom.depth || 1);
      root.eachBefore(function(node) {
        node.x = (node.x + tx2) * kx;
        node.y = node.depth * ky;
      });
    }
    return root;
  }
  function firstWalk(v) {
    var children2 = v.children, siblings = v.parent.children, w2 = v.i ? siblings[v.i - 1] : null;
    if (children2) {
      executeShifts(v);
      var midpoint = (children2[0].z + children2[children2.length - 1].z) / 2;
      if (w2) {
        v.z = w2.z + separation(v._, w2._);
        v.m = v.z - midpoint;
      } else {
        v.z = midpoint;
      }
    } else if (w2) {
      v.z = w2.z + separation(v._, w2._);
    }
    v.parent.A = apportion(v, w2, v.parent.A || siblings[0]);
  }
  function secondWalk(v) {
    v._.x = v.z + v.parent.m;
    v.m += v.parent.m;
  }
  function apportion(v, w2, ancestor) {
    if (w2) {
      var vip = v, vop = v, vim = w2, vom = vip.parent.children[0], sip = vip.m, sop = vop.m, sim = vim.m, som = vom.m, shift;
      while (vim = nextRight(vim), vip = nextLeft(vip), vim && vip) {
        vom = nextLeft(vom);
        vop = nextRight(vop);
        vop.a = v;
        shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
        if (shift > 0) {
          moveSubtree(nextAncestor(vim, v, ancestor), v, shift);
          sip += shift;
          sop += shift;
        }
        sim += vim.m;
        sip += vip.m;
        som += vom.m;
        sop += vop.m;
      }
      if (vim && !nextRight(vop)) {
        vop.t = vim;
        vop.m += sim - sop;
      }
      if (vip && !nextLeft(vom)) {
        vom.t = vip;
        vom.m += sip - som;
        ancestor = v;
      }
    }
    return ancestor;
  }
  function sizeNode(node) {
    node.x *= dx;
    node.y = node.depth * dy;
  }
  tree2.separation = function(x2) {
    return arguments.length ? (separation = x2, tree2) : separation;
  };
  tree2.size = function(x2) {
    return arguments.length ? (nodeSize = false, dx = +x2[0], dy = +x2[1], tree2) : nodeSize ? null : [dx, dy];
  };
  tree2.nodeSize = function(x2) {
    return arguments.length ? (nodeSize = true, dx = +x2[0], dy = +x2[1], tree2) : nodeSize ? [dx, dy] : null;
  };
  return tree2;
}
function treemapSlice(parent, x02, y02, x12, y12) {
  var nodes = parent.children, node, i = -1, n = nodes.length, k = parent.value && (y12 - y02) / parent.value;
  while (++i < n) {
    node = nodes[i], node.x0 = x02, node.x1 = x12;
    node.y0 = y02, node.y1 = y02 += node.value * k;
  }
}
var phi = (1 + Math.sqrt(5)) / 2;
function squarifyRatio(ratio, parent, x02, y02, x12, y12) {
  var rows = [], nodes = parent.children, row, nodeValue, i0 = 0, i1 = 0, n = nodes.length, dx, dy, value2 = parent.value, sumValue, minValue, maxValue, newRatio, minRatio, alpha, beta;
  while (i0 < n) {
    dx = x12 - x02, dy = y12 - y02;
    do
      sumValue = nodes[i1++].value;
    while (!sumValue && i1 < n);
    minValue = maxValue = sumValue;
    alpha = Math.max(dy / dx, dx / dy) / (value2 * ratio);
    beta = sumValue * sumValue * alpha;
    minRatio = Math.max(maxValue / beta, beta / minValue);
    for (; i1 < n; ++i1) {
      sumValue += nodeValue = nodes[i1].value;
      if (nodeValue < minValue)
        minValue = nodeValue;
      if (nodeValue > maxValue)
        maxValue = nodeValue;
      beta = sumValue * sumValue * alpha;
      newRatio = Math.max(maxValue / beta, beta / minValue);
      if (newRatio > minRatio) {
        sumValue -= nodeValue;
        break;
      }
      minRatio = newRatio;
    }
    rows.push(row = { value: sumValue, dice: dx < dy, children: nodes.slice(i0, i1) });
    if (row.dice)
      treemapDice(row, x02, y02, x12, value2 ? y02 += dy * sumValue / value2 : y12);
    else
      treemapSlice(row, x02, y02, value2 ? x02 += dx * sumValue / value2 : x12, y12);
    value2 -= sumValue, i0 = i1;
  }
  return rows;
}
const treemapSquarify = function custom(ratio) {
  function squarify(parent, x02, y02, x12, y12) {
    squarifyRatio(ratio, parent, x02, y02, x12, y12);
  }
  squarify.ratio = function(x2) {
    return custom((x2 = +x2) > 1 ? x2 : 1);
  };
  return squarify;
}(phi);
function treemap() {
  var tile = treemapSquarify, round = false, dx = 1, dy = 1, paddingStack = [0], paddingInner = constantZero, paddingTop = constantZero, paddingRight = constantZero, paddingBottom = constantZero, paddingLeft = constantZero;
  function treemap2(root) {
    root.x0 = root.y0 = 0;
    root.x1 = dx;
    root.y1 = dy;
    root.eachBefore(positionNode);
    paddingStack = [0];
    if (round)
      root.eachBefore(roundNode);
    return root;
  }
  function positionNode(node) {
    var p = paddingStack[node.depth], x02 = node.x0 + p, y02 = node.y0 + p, x12 = node.x1 - p, y12 = node.y1 - p;
    if (x12 < x02)
      x02 = x12 = (x02 + x12) / 2;
    if (y12 < y02)
      y02 = y12 = (y02 + y12) / 2;
    node.x0 = x02;
    node.y0 = y02;
    node.x1 = x12;
    node.y1 = y12;
    if (node.children) {
      p = paddingStack[node.depth + 1] = paddingInner(node) / 2;
      x02 += paddingLeft(node) - p;
      y02 += paddingTop(node) - p;
      x12 -= paddingRight(node) - p;
      y12 -= paddingBottom(node) - p;
      if (x12 < x02)
        x02 = x12 = (x02 + x12) / 2;
      if (y12 < y02)
        y02 = y12 = (y02 + y12) / 2;
      tile(node, x02, y02, x12, y12);
    }
  }
  treemap2.round = function(x2) {
    return arguments.length ? (round = !!x2, treemap2) : round;
  };
  treemap2.size = function(x2) {
    return arguments.length ? (dx = +x2[0], dy = +x2[1], treemap2) : [dx, dy];
  };
  treemap2.tile = function(x2) {
    return arguments.length ? (tile = required(x2), treemap2) : tile;
  };
  treemap2.padding = function(x2) {
    return arguments.length ? treemap2.paddingInner(x2).paddingOuter(x2) : treemap2.paddingInner();
  };
  treemap2.paddingInner = function(x2) {
    return arguments.length ? (paddingInner = typeof x2 === "function" ? x2 : constant$2(+x2), treemap2) : paddingInner;
  };
  treemap2.paddingOuter = function(x2) {
    return arguments.length ? treemap2.paddingTop(x2).paddingRight(x2).paddingBottom(x2).paddingLeft(x2) : treemap2.paddingTop();
  };
  treemap2.paddingTop = function(x2) {
    return arguments.length ? (paddingTop = typeof x2 === "function" ? x2 : constant$2(+x2), treemap2) : paddingTop;
  };
  treemap2.paddingRight = function(x2) {
    return arguments.length ? (paddingRight = typeof x2 === "function" ? x2 : constant$2(+x2), treemap2) : paddingRight;
  };
  treemap2.paddingBottom = function(x2) {
    return arguments.length ? (paddingBottom = typeof x2 === "function" ? x2 : constant$2(+x2), treemap2) : paddingBottom;
  };
  treemap2.paddingLeft = function(x2) {
    return arguments.length ? (paddingLeft = typeof x2 === "function" ? x2 : constant$2(+x2), treemap2) : paddingLeft;
  };
  return treemap2;
}
function treemapBinary(parent, x02, y02, x12, y12) {
  var nodes = parent.children, i, n = nodes.length, sum2, sums = new Array(n + 1);
  for (sums[0] = sum2 = i = 0; i < n; ++i) {
    sums[i + 1] = sum2 += nodes[i].value;
  }
  partition2(0, n, parent.value, x02, y02, x12, y12);
  function partition2(i2, j, value2, x03, y03, x13, y13) {
    if (i2 >= j - 1) {
      var node = nodes[i2];
      node.x0 = x03, node.y0 = y03;
      node.x1 = x13, node.y1 = y13;
      return;
    }
    var valueOffset = sums[i2], valueTarget = value2 / 2 + valueOffset, k = i2 + 1, hi = j - 1;
    while (k < hi) {
      var mid = k + hi >>> 1;
      if (sums[mid] < valueTarget)
        k = mid + 1;
      else
        hi = mid;
    }
    if (valueTarget - sums[k - 1] < sums[k] - valueTarget && i2 + 1 < k)
      --k;
    var valueLeft = sums[k] - valueOffset, valueRight = value2 - valueLeft;
    if (x13 - x03 > y13 - y03) {
      var xk = value2 ? (x03 * valueRight + x13 * valueLeft) / value2 : x13;
      partition2(i2, k, valueLeft, x03, y03, xk, y13);
      partition2(k, j, valueRight, xk, y03, x13, y13);
    } else {
      var yk = value2 ? (y03 * valueRight + y13 * valueLeft) / value2 : y13;
      partition2(i2, k, valueLeft, x03, y03, x13, yk);
      partition2(k, j, valueRight, x03, yk, x13, y13);
    }
  }
}
function treemapSliceDice(parent, x02, y02, x12, y12) {
  (parent.depth & 1 ? treemapSlice : treemapDice)(parent, x02, y02, x12, y12);
}
const treemapResquarify = function custom2(ratio) {
  function resquarify(parent, x02, y02, x12, y12) {
    if ((rows = parent._squarify) && rows.ratio === ratio) {
      var rows, row, nodes, i, j = -1, n, m2 = rows.length, value2 = parent.value;
      while (++j < m2) {
        row = rows[j], nodes = row.children;
        for (i = row.value = 0, n = nodes.length; i < n; ++i)
          row.value += nodes[i].value;
        if (row.dice)
          treemapDice(row, x02, y02, x12, value2 ? y02 += (y12 - y02) * row.value / value2 : y12);
        else
          treemapSlice(row, x02, y02, value2 ? x02 += (x12 - x02) * row.value / value2 : x12, y12);
        value2 -= row.value;
      }
    } else {
      parent._squarify = rows = squarifyRatio(ratio, parent, x02, y02, x12, y12);
      rows.ratio = ratio;
    }
  }
  resquarify.ratio = function(x2) {
    return custom2((x2 = +x2) > 1 ? x2 : 1);
  };
  return resquarify;
}(phi);
function initRange(domain2, range2) {
  switch (arguments.length) {
    case 0:
      break;
    case 1:
      this.range(domain2);
      break;
    default:
      this.range(range2).domain(domain2);
      break;
  }
  return this;
}
function initInterpolator(domain2, interpolator) {
  switch (arguments.length) {
    case 0:
      break;
    case 1: {
      if (typeof domain2 === "function")
        this.interpolator(domain2);
      else
        this.range(domain2);
      break;
    }
    default: {
      this.domain(domain2);
      if (typeof interpolator === "function")
        this.interpolator(interpolator);
      else
        this.range(interpolator);
      break;
    }
  }
  return this;
}
const implicit = Symbol("implicit");
function ordinal() {
  var index2 = new InternMap(), domain2 = [], range2 = [], unknown = implicit;
  function scale2(d) {
    let i = index2.get(d);
    if (i === void 0) {
      if (unknown !== implicit)
        return unknown;
      index2.set(d, i = domain2.push(d) - 1);
    }
    return range2[i % range2.length];
  }
  scale2.domain = function(_) {
    if (!arguments.length)
      return domain2.slice();
    domain2 = [], index2 = new InternMap();
    for (const value2 of _) {
      if (index2.has(value2))
        continue;
      index2.set(value2, domain2.push(value2) - 1);
    }
    return scale2;
  };
  scale2.range = function(_) {
    return arguments.length ? (range2 = Array.from(_), scale2) : range2.slice();
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  scale2.copy = function() {
    return ordinal(domain2, range2).unknown(unknown);
  };
  initRange.apply(scale2, arguments);
  return scale2;
}
function constants(x2) {
  return function() {
    return x2;
  };
}
function number$5(x2) {
  return +x2;
}
var unit = [0, 1];
function identity$3(x2) {
  return x2;
}
function normalize(a2, b2) {
  return (b2 -= a2 = +a2) ? function(x2) {
    return (x2 - a2) / b2;
  } : constants(isNaN(b2) ? NaN : 0.5);
}
function clamper(a2, b2) {
  var t;
  if (a2 > b2)
    t = a2, a2 = b2, b2 = t;
  return function(x2) {
    return Math.max(a2, Math.min(b2, x2));
  };
}
function bimap(domain2, range2, interpolate2) {
  var d0 = domain2[0], d1 = domain2[1], r0 = range2[0], r1 = range2[1];
  if (d1 < d0)
    d0 = normalize(d1, d0), r0 = interpolate2(r1, r0);
  else
    d0 = normalize(d0, d1), r0 = interpolate2(r0, r1);
  return function(x2) {
    return r0(d0(x2));
  };
}
function polymap(domain2, range2, interpolate2) {
  var j = Math.min(domain2.length, range2.length) - 1, d = new Array(j), r = new Array(j), i = -1;
  if (domain2[j] < domain2[0]) {
    domain2 = domain2.slice().reverse();
    range2 = range2.slice().reverse();
  }
  while (++i < j) {
    d[i] = normalize(domain2[i], domain2[i + 1]);
    r[i] = interpolate2(range2[i], range2[i + 1]);
  }
  return function(x2) {
    var i2 = bisectRight$1(domain2, x2, 1, j) - 1;
    return r[i2](d[i2](x2));
  };
}
function copy$3(source2, target2) {
  return target2.domain(source2.domain()).range(source2.range()).interpolate(source2.interpolate()).clamp(source2.clamp()).unknown(source2.unknown());
}
function transformer$2() {
  var domain2 = unit, range2 = unit, interpolate2 = interpolate$1, transform2, untransform, unknown, clamp2 = identity$3, piecewise2, output2, input;
  function rescale() {
    var n = Math.min(domain2.length, range2.length);
    if (clamp2 !== identity$3)
      clamp2 = clamper(domain2[0], domain2[n - 1]);
    piecewise2 = n > 2 ? polymap : bimap;
    output2 = input = null;
    return scale2;
  }
  function scale2(x2) {
    return x2 == null || isNaN(x2 = +x2) ? unknown : (output2 || (output2 = piecewise2(domain2.map(transform2), range2, interpolate2)))(transform2(clamp2(x2)));
  }
  scale2.invert = function(y2) {
    return clamp2(untransform((input || (input = piecewise2(range2, domain2.map(transform2), interpolateNumber)))(y2)));
  };
  scale2.domain = function(_) {
    return arguments.length ? (domain2 = Array.from(_, number$5), rescale()) : domain2.slice();
  };
  scale2.range = function(_) {
    return arguments.length ? (range2 = Array.from(_), rescale()) : range2.slice();
  };
  scale2.rangeRound = function(_) {
    return range2 = Array.from(_), interpolate2 = interpolateRound, rescale();
  };
  scale2.clamp = function(_) {
    return arguments.length ? (clamp2 = _ ? true : identity$3, rescale()) : clamp2 !== identity$3;
  };
  scale2.interpolate = function(_) {
    return arguments.length ? (interpolate2 = _, rescale()) : interpolate2;
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  return function(t, u2) {
    transform2 = t, untransform = u2;
    return rescale();
  };
}
function continuous$1() {
  return transformer$2()(identity$3, identity$3);
}
function tickFormat$1(start, stop2, count2, specifier) {
  var step = tickStep(start, stop2, count2), precision;
  specifier = formatSpecifier(specifier == null ? ",f" : specifier);
  switch (specifier.type) {
    case "s": {
      var value2 = Math.max(Math.abs(start), Math.abs(stop2));
      if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value2)))
        specifier.precision = precision;
      return formatPrefix(specifier, value2);
    }
    case "":
    case "e":
    case "g":
    case "p":
    case "r": {
      if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start), Math.abs(stop2)))))
        specifier.precision = precision - (specifier.type === "e");
      break;
    }
    case "f":
    case "%": {
      if (specifier.precision == null && !isNaN(precision = precisionFixed(step)))
        specifier.precision = precision - (specifier.type === "%") * 2;
      break;
    }
  }
  return format$4(specifier);
}
function linearish(scale2) {
  var domain2 = scale2.domain;
  scale2.ticks = function(count2) {
    var d = domain2();
    return ticks(d[0], d[d.length - 1], count2 == null ? 10 : count2);
  };
  scale2.tickFormat = function(count2, specifier) {
    var d = domain2();
    return tickFormat$1(d[0], d[d.length - 1], count2 == null ? 10 : count2, specifier);
  };
  scale2.nice = function(count2) {
    if (count2 == null)
      count2 = 10;
    var d = domain2();
    var i0 = 0;
    var i1 = d.length - 1;
    var start = d[i0];
    var stop2 = d[i1];
    var prestep;
    var step;
    var maxIter = 10;
    if (stop2 < start) {
      step = start, start = stop2, stop2 = step;
      step = i0, i0 = i1, i1 = step;
    }
    while (maxIter-- > 0) {
      step = tickIncrement(start, stop2, count2);
      if (step === prestep) {
        d[i0] = start;
        d[i1] = stop2;
        return domain2(d);
      } else if (step > 0) {
        start = Math.floor(start / step) * step;
        stop2 = Math.ceil(stop2 / step) * step;
      } else if (step < 0) {
        start = Math.ceil(start * step) / step;
        stop2 = Math.floor(stop2 * step) / step;
      } else {
        break;
      }
      prestep = step;
    }
    return scale2;
  };
  return scale2;
}
function linear$1() {
  var scale2 = continuous$1();
  scale2.copy = function() {
    return copy$3(scale2, linear$1());
  };
  initRange.apply(scale2, arguments);
  return linearish(scale2);
}
function identity$2(domain2) {
  var unknown;
  function scale2(x2) {
    return x2 == null || isNaN(x2 = +x2) ? unknown : x2;
  }
  scale2.invert = scale2;
  scale2.domain = scale2.range = function(_) {
    return arguments.length ? (domain2 = Array.from(_, number$5), scale2) : domain2.slice();
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  scale2.copy = function() {
    return identity$2(domain2).unknown(unknown);
  };
  domain2 = arguments.length ? Array.from(domain2, number$5) : [0, 1];
  return linearish(scale2);
}
function nice(domain2, interval2) {
  domain2 = domain2.slice();
  var i0 = 0, i1 = domain2.length - 1, x02 = domain2[i0], x12 = domain2[i1], t;
  if (x12 < x02) {
    t = i0, i0 = i1, i1 = t;
    t = x02, x02 = x12, x12 = t;
  }
  domain2[i0] = interval2.floor(x02);
  domain2[i1] = interval2.ceil(x12);
  return domain2;
}
function transformLog(x2) {
  return Math.log(x2);
}
function transformExp(x2) {
  return Math.exp(x2);
}
function transformLogn(x2) {
  return -Math.log(-x2);
}
function transformExpn(x2) {
  return -Math.exp(-x2);
}
function pow10(x2) {
  return isFinite(x2) ? +("1e" + x2) : x2 < 0 ? 0 : x2;
}
function powp(base2) {
  return base2 === 10 ? pow10 : base2 === Math.E ? Math.exp : (x2) => Math.pow(base2, x2);
}
function logp(base2) {
  return base2 === Math.E ? Math.log : base2 === 10 && Math.log10 || base2 === 2 && Math.log2 || (base2 = Math.log(base2), (x2) => Math.log(x2) / base2);
}
function reflect(f) {
  return (x2, k) => -f(-x2, k);
}
function loggish(transform2) {
  const scale2 = transform2(transformLog, transformExp);
  const domain2 = scale2.domain;
  let base2 = 10;
  let logs;
  let pows;
  function rescale() {
    logs = logp(base2), pows = powp(base2);
    if (domain2()[0] < 0) {
      logs = reflect(logs), pows = reflect(pows);
      transform2(transformLogn, transformExpn);
    } else {
      transform2(transformLog, transformExp);
    }
    return scale2;
  }
  scale2.base = function(_) {
    return arguments.length ? (base2 = +_, rescale()) : base2;
  };
  scale2.domain = function(_) {
    return arguments.length ? (domain2(_), rescale()) : domain2();
  };
  scale2.ticks = (count2) => {
    const d = domain2();
    let u2 = d[0];
    let v = d[d.length - 1];
    const r = v < u2;
    if (r)
      [u2, v] = [v, u2];
    let i = logs(u2);
    let j = logs(v);
    let k;
    let t;
    const n = count2 == null ? 10 : +count2;
    let z = [];
    if (!(base2 % 1) && j - i < n) {
      i = Math.floor(i), j = Math.ceil(j);
      if (u2 > 0)
        for (; i <= j; ++i) {
          for (k = 1; k < base2; ++k) {
            t = i < 0 ? k / pows(-i) : k * pows(i);
            if (t < u2)
              continue;
            if (t > v)
              break;
            z.push(t);
          }
        }
      else
        for (; i <= j; ++i) {
          for (k = base2 - 1; k >= 1; --k) {
            t = i > 0 ? k / pows(-i) : k * pows(i);
            if (t < u2)
              continue;
            if (t > v)
              break;
            z.push(t);
          }
        }
      if (z.length * 2 < n)
        z = ticks(u2, v, n);
    } else {
      z = ticks(i, j, Math.min(j - i, n)).map(pows);
    }
    return r ? z.reverse() : z;
  };
  scale2.tickFormat = (count2, specifier) => {
    if (count2 == null)
      count2 = 10;
    if (specifier == null)
      specifier = base2 === 10 ? "s" : ",";
    if (typeof specifier !== "function") {
      if (!(base2 % 1) && (specifier = formatSpecifier(specifier)).precision == null)
        specifier.trim = true;
      specifier = format$4(specifier);
    }
    if (count2 === Infinity)
      return specifier;
    const k = Math.max(1, base2 * count2 / scale2.ticks().length);
    return (d) => {
      let i = d / pows(Math.round(logs(d)));
      if (i * base2 < base2 - 0.5)
        i *= base2;
      return i <= k ? specifier(d) : "";
    };
  };
  scale2.nice = () => {
    return domain2(nice(domain2(), {
      floor: (x2) => pows(Math.floor(logs(x2))),
      ceil: (x2) => pows(Math.ceil(logs(x2)))
    }));
  };
  return scale2;
}
function log$4() {
  const scale2 = loggish(transformer$2()).domain([1, 10]);
  scale2.copy = () => copy$3(scale2, log$4()).base(scale2.base());
  initRange.apply(scale2, arguments);
  return scale2;
}
function transformSymlog(c2) {
  return function(x2) {
    return Math.sign(x2) * Math.log1p(Math.abs(x2 / c2));
  };
}
function transformSymexp(c2) {
  return function(x2) {
    return Math.sign(x2) * Math.expm1(Math.abs(x2)) * c2;
  };
}
function symlogish(transform2) {
  var c2 = 1, scale2 = transform2(transformSymlog(c2), transformSymexp(c2));
  scale2.constant = function(_) {
    return arguments.length ? transform2(transformSymlog(c2 = +_), transformSymexp(c2)) : c2;
  };
  return linearish(scale2);
}
function symlog$1() {
  var scale2 = symlogish(transformer$2());
  scale2.copy = function() {
    return copy$3(scale2, symlog$1()).constant(scale2.constant());
  };
  return initRange.apply(scale2, arguments);
}
function transformPow(exponent2) {
  return function(x2) {
    return x2 < 0 ? -Math.pow(-x2, exponent2) : Math.pow(x2, exponent2);
  };
}
function transformSqrt(x2) {
  return x2 < 0 ? -Math.sqrt(-x2) : Math.sqrt(x2);
}
function transformSquare(x2) {
  return x2 < 0 ? -x2 * x2 : x2 * x2;
}
function powish(transform2) {
  var scale2 = transform2(identity$3, identity$3), exponent2 = 1;
  function rescale() {
    return exponent2 === 1 ? transform2(identity$3, identity$3) : exponent2 === 0.5 ? transform2(transformSqrt, transformSquare) : transform2(transformPow(exponent2), transformPow(1 / exponent2));
  }
  scale2.exponent = function(_) {
    return arguments.length ? (exponent2 = +_, rescale()) : exponent2;
  };
  return linearish(scale2);
}
function pow$2() {
  var scale2 = powish(transformer$2());
  scale2.copy = function() {
    return copy$3(scale2, pow$2()).exponent(scale2.exponent());
  };
  initRange.apply(scale2, arguments);
  return scale2;
}
function sqrt$2() {
  return pow$2.apply(null, arguments).exponent(0.5);
}
function quantile() {
  var domain2 = [], range2 = [], thresholds = [], unknown;
  function rescale() {
    var i = 0, n = Math.max(1, range2.length);
    thresholds = new Array(n - 1);
    while (++i < n)
      thresholds[i - 1] = quantileSorted(domain2, i / n);
    return scale2;
  }
  function scale2(x2) {
    return x2 == null || isNaN(x2 = +x2) ? unknown : range2[bisectRight$1(thresholds, x2)];
  }
  scale2.invertExtent = function(y2) {
    var i = range2.indexOf(y2);
    return i < 0 ? [NaN, NaN] : [
      i > 0 ? thresholds[i - 1] : domain2[0],
      i < thresholds.length ? thresholds[i] : domain2[domain2.length - 1]
    ];
  };
  scale2.domain = function(_) {
    if (!arguments.length)
      return domain2.slice();
    domain2 = [];
    for (let d of _)
      if (d != null && !isNaN(d = +d))
        domain2.push(d);
    domain2.sort(ascending$2);
    return rescale();
  };
  scale2.range = function(_) {
    return arguments.length ? (range2 = Array.from(_), rescale()) : range2.slice();
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  scale2.quantiles = function() {
    return thresholds.slice();
  };
  scale2.copy = function() {
    return quantile().domain(domain2).range(range2).unknown(unknown);
  };
  return initRange.apply(scale2, arguments);
}
function quantize$1() {
  var x02 = 0, x12 = 1, n = 1, domain2 = [0.5], range2 = [0, 1], unknown;
  function scale2(x2) {
    return x2 != null && x2 <= x2 ? range2[bisectRight$1(domain2, x2, 0, n)] : unknown;
  }
  function rescale() {
    var i = -1;
    domain2 = new Array(n);
    while (++i < n)
      domain2[i] = ((i + 1) * x12 - (i - n) * x02) / (n + 1);
    return scale2;
  }
  scale2.domain = function(_) {
    return arguments.length ? ([x02, x12] = _, x02 = +x02, x12 = +x12, rescale()) : [x02, x12];
  };
  scale2.range = function(_) {
    return arguments.length ? (n = (range2 = Array.from(_)).length - 1, rescale()) : range2.slice();
  };
  scale2.invertExtent = function(y2) {
    var i = range2.indexOf(y2);
    return i < 0 ? [NaN, NaN] : i < 1 ? [x02, domain2[0]] : i >= n ? [domain2[n - 1], x12] : [domain2[i - 1], domain2[i]];
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : scale2;
  };
  scale2.thresholds = function() {
    return domain2.slice();
  };
  scale2.copy = function() {
    return quantize$1().domain([x02, x12]).range(range2).unknown(unknown);
  };
  return initRange.apply(linearish(scale2), arguments);
}
function threshold() {
  var domain2 = [0.5], range2 = [0, 1], unknown, n = 1;
  function scale2(x2) {
    return x2 != null && x2 <= x2 ? range2[bisectRight$1(domain2, x2, 0, n)] : unknown;
  }
  scale2.domain = function(_) {
    return arguments.length ? (domain2 = Array.from(_), n = Math.min(domain2.length, range2.length - 1), scale2) : domain2.slice();
  };
  scale2.range = function(_) {
    return arguments.length ? (range2 = Array.from(_), n = Math.min(domain2.length, range2.length - 1), scale2) : range2.slice();
  };
  scale2.invertExtent = function(y2) {
    var i = range2.indexOf(y2);
    return [domain2[i - 1], domain2[i]];
  };
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  scale2.copy = function() {
    return threshold().domain(domain2).range(range2).unknown(unknown);
  };
  return initRange.apply(scale2, arguments);
}
const t0$1 = /* @__PURE__ */ new Date(), t1 = /* @__PURE__ */ new Date();
function timeInterval$1(floori, offseti, count2, field2) {
  function interval2(date2) {
    return floori(date2 = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date2)), date2;
  }
  interval2.floor = (date2) => {
    return floori(date2 = /* @__PURE__ */ new Date(+date2)), date2;
  };
  interval2.ceil = (date2) => {
    return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
  };
  interval2.round = (date2) => {
    const d0 = interval2(date2), d1 = interval2.ceil(date2);
    return date2 - d0 < d1 - date2 ? d0 : d1;
  };
  interval2.offset = (date2, step) => {
    return offseti(date2 = /* @__PURE__ */ new Date(+date2), step == null ? 1 : Math.floor(step)), date2;
  };
  interval2.range = (start, stop2, step) => {
    const range2 = [];
    start = interval2.ceil(start);
    step = step == null ? 1 : Math.floor(step);
    if (!(start < stop2) || !(step > 0))
      return range2;
    let previous;
    do
      range2.push(previous = /* @__PURE__ */ new Date(+start)), offseti(start, step), floori(start);
    while (previous < start && start < stop2);
    return range2;
  };
  interval2.filter = (test2) => {
    return timeInterval$1((date2) => {
      if (date2 >= date2)
        while (floori(date2), !test2(date2))
          date2.setTime(date2 - 1);
    }, (date2, step) => {
      if (date2 >= date2) {
        if (step < 0)
          while (++step <= 0) {
            while (offseti(date2, -1), !test2(date2)) {
            }
          }
        else
          while (--step >= 0) {
            while (offseti(date2, 1), !test2(date2)) {
            }
          }
      }
    });
  };
  if (count2) {
    interval2.count = (start, end) => {
      t0$1.setTime(+start), t1.setTime(+end);
      floori(t0$1), floori(t1);
      return Math.floor(count2(t0$1, t1));
    };
    interval2.every = (step) => {
      step = Math.floor(step);
      return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval2 : interval2.filter(field2 ? (d) => field2(d) % step === 0 : (d) => interval2.count(0, d) % step === 0);
    };
  }
  return interval2;
}
const millisecond = timeInterval$1(() => {
}, (date2, step) => {
  date2.setTime(+date2 + step);
}, (start, end) => {
  return end - start;
});
millisecond.every = (k) => {
  k = Math.floor(k);
  if (!isFinite(k) || !(k > 0))
    return null;
  if (!(k > 1))
    return millisecond;
  return timeInterval$1((date2) => {
    date2.setTime(Math.floor(date2 / k) * k);
  }, (date2, step) => {
    date2.setTime(+date2 + step * k);
  }, (start, end) => {
    return (end - start) / k;
  });
};
millisecond.range;
const durationSecond$1 = 1e3;
const durationMinute$1 = durationSecond$1 * 60;
const durationHour$1 = durationMinute$1 * 60;
const durationDay$1 = durationHour$1 * 24;
const durationWeek$1 = durationDay$1 * 7;
const durationMonth$1 = durationDay$1 * 30;
const durationYear$1 = durationDay$1 * 365;
const second = timeInterval$1((date2) => {
  date2.setTime(date2 - date2.getMilliseconds());
}, (date2, step) => {
  date2.setTime(+date2 + step * durationSecond$1);
}, (start, end) => {
  return (end - start) / durationSecond$1;
}, (date2) => {
  return date2.getUTCSeconds();
});
second.range;
const timeMinute = timeInterval$1((date2) => {
  date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond$1);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationMinute$1);
}, (start, end) => {
  return (end - start) / durationMinute$1;
}, (date2) => {
  return date2.getMinutes();
});
timeMinute.range;
const utcMinute = timeInterval$1((date2) => {
  date2.setUTCSeconds(0, 0);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationMinute$1);
}, (start, end) => {
  return (end - start) / durationMinute$1;
}, (date2) => {
  return date2.getUTCMinutes();
});
utcMinute.range;
const timeHour = timeInterval$1((date2) => {
  date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond$1 - date2.getMinutes() * durationMinute$1);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationHour$1);
}, (start, end) => {
  return (end - start) / durationHour$1;
}, (date2) => {
  return date2.getHours();
});
timeHour.range;
const utcHour = timeInterval$1((date2) => {
  date2.setUTCMinutes(0, 0, 0);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationHour$1);
}, (start, end) => {
  return (end - start) / durationHour$1;
}, (date2) => {
  return date2.getUTCHours();
});
utcHour.range;
const timeDay = timeInterval$1(
  (date2) => date2.setHours(0, 0, 0, 0),
  (date2, step) => date2.setDate(date2.getDate() + step),
  (start, end) => (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute$1) / durationDay$1,
  (date2) => date2.getDate() - 1
);
timeDay.range;
const utcDay = timeInterval$1((date2) => {
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCDate(date2.getUTCDate() + step);
}, (start, end) => {
  return (end - start) / durationDay$1;
}, (date2) => {
  return date2.getUTCDate() - 1;
});
utcDay.range;
const unixDay = timeInterval$1((date2) => {
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCDate(date2.getUTCDate() + step);
}, (start, end) => {
  return (end - start) / durationDay$1;
}, (date2) => {
  return Math.floor(date2 / durationDay$1);
});
unixDay.range;
function timeWeekday(i) {
  return timeInterval$1((date2) => {
    date2.setDate(date2.getDate() - (date2.getDay() + 7 - i) % 7);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setDate(date2.getDate() + step * 7);
  }, (start, end) => {
    return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute$1) / durationWeek$1;
  });
}
const timeSunday = timeWeekday(0);
const timeMonday = timeWeekday(1);
const timeTuesday = timeWeekday(2);
const timeWednesday = timeWeekday(3);
const timeThursday = timeWeekday(4);
const timeFriday = timeWeekday(5);
const timeSaturday = timeWeekday(6);
timeSunday.range;
timeMonday.range;
timeTuesday.range;
timeWednesday.range;
timeThursday.range;
timeFriday.range;
timeSaturday.range;
function utcWeekday(i) {
  return timeInterval$1((date2) => {
    date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i) % 7);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step * 7);
  }, (start, end) => {
    return (end - start) / durationWeek$1;
  });
}
const utcSunday = utcWeekday(0);
const utcMonday = utcWeekday(1);
const utcTuesday = utcWeekday(2);
const utcWednesday = utcWeekday(3);
const utcThursday = utcWeekday(4);
const utcFriday = utcWeekday(5);
const utcSaturday = utcWeekday(6);
utcSunday.range;
utcMonday.range;
utcTuesday.range;
utcWednesday.range;
utcThursday.range;
utcFriday.range;
utcSaturday.range;
const timeMonth = timeInterval$1((date2) => {
  date2.setDate(1);
  date2.setHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setMonth(date2.getMonth() + step);
}, (start, end) => {
  return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
}, (date2) => {
  return date2.getMonth();
});
timeMonth.range;
const utcMonth = timeInterval$1((date2) => {
  date2.setUTCDate(1);
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCMonth(date2.getUTCMonth() + step);
}, (start, end) => {
  return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
}, (date2) => {
  return date2.getUTCMonth();
});
utcMonth.range;
const timeYear = timeInterval$1((date2) => {
  date2.setMonth(0, 1);
  date2.setHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setFullYear(date2.getFullYear() + step);
}, (start, end) => {
  return end.getFullYear() - start.getFullYear();
}, (date2) => {
  return date2.getFullYear();
});
timeYear.every = (k) => {
  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval$1((date2) => {
    date2.setFullYear(Math.floor(date2.getFullYear() / k) * k);
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setFullYear(date2.getFullYear() + step * k);
  });
};
timeYear.range;
const utcYear = timeInterval$1((date2) => {
  date2.setUTCMonth(0, 1);
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCFullYear(date2.getUTCFullYear() + step);
}, (start, end) => {
  return end.getUTCFullYear() - start.getUTCFullYear();
}, (date2) => {
  return date2.getUTCFullYear();
});
utcYear.every = (k) => {
  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval$1((date2) => {
    date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k) * k);
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCFullYear(date2.getUTCFullYear() + step * k);
  });
};
utcYear.range;
function ticker(year, month, week2, day, hour, minute) {
  const tickIntervals = [
    [second, 1, durationSecond$1],
    [second, 5, 5 * durationSecond$1],
    [second, 15, 15 * durationSecond$1],
    [second, 30, 30 * durationSecond$1],
    [minute, 1, durationMinute$1],
    [minute, 5, 5 * durationMinute$1],
    [minute, 15, 15 * durationMinute$1],
    [minute, 30, 30 * durationMinute$1],
    [hour, 1, durationHour$1],
    [hour, 3, 3 * durationHour$1],
    [hour, 6, 6 * durationHour$1],
    [hour, 12, 12 * durationHour$1],
    [day, 1, durationDay$1],
    [day, 2, 2 * durationDay$1],
    [week2, 1, durationWeek$1],
    [month, 1, durationMonth$1],
    [month, 3, 3 * durationMonth$1],
    [year, 1, durationYear$1]
  ];
  function ticks2(start, stop2, count2) {
    const reverse2 = stop2 < start;
    if (reverse2)
      [start, stop2] = [stop2, start];
    const interval2 = count2 && typeof count2.range === "function" ? count2 : tickInterval(start, stop2, count2);
    const ticks3 = interval2 ? interval2.range(start, +stop2 + 1) : [];
    return reverse2 ? ticks3.reverse() : ticks3;
  }
  function tickInterval(start, stop2, count2) {
    const target2 = Math.abs(stop2 - start) / count2;
    const i = bisector(([, , step2]) => step2).right(tickIntervals, target2);
    if (i === tickIntervals.length)
      return year.every(tickStep(start / durationYear$1, stop2 / durationYear$1, count2));
    if (i === 0)
      return millisecond.every(Math.max(tickStep(start, stop2, count2), 1));
    const [t, step] = tickIntervals[target2 / tickIntervals[i - 1][2] < tickIntervals[i][2] / target2 ? i - 1 : i];
    return t.every(step);
  }
  return [ticks2, tickInterval];
}
const [utcTicks, utcTickInterval] = ticker(utcYear, utcMonth, utcSunday, unixDay, utcHour, utcMinute);
const [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute);
function localDate$1(d) {
  if (0 <= d.y && d.y < 100) {
    var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
    date2.setFullYear(d.y);
    return date2;
  }
  return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
}
function utcDate$1(d) {
  if (0 <= d.y && d.y < 100) {
    var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
    date2.setUTCFullYear(d.y);
    return date2;
  }
  return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
}
function newDate(y2, m2, d) {
  return { y: y2, m: m2, d, H: 0, M: 0, S: 0, L: 0 };
}
function formatLocale(locale2) {
  var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
  var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
  var formats2 = {
    "a": formatShortWeekday,
    "A": formatWeekday,
    "b": formatShortMonth,
    "B": formatMonth,
    "c": null,
    "d": formatDayOfMonth,
    "e": formatDayOfMonth,
    "f": formatMicroseconds,
    "g": formatYearISO,
    "G": formatFullYearISO,
    "H": formatHour24,
    "I": formatHour12,
    "j": formatDayOfYear,
    "L": formatMilliseconds,
    "m": formatMonthNumber,
    "M": formatMinutes,
    "p": formatPeriod,
    "q": formatQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatSeconds,
    "u": formatWeekdayNumberMonday,
    "U": formatWeekNumberSunday,
    "V": formatWeekNumberISO,
    "w": formatWeekdayNumberSunday,
    "W": formatWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatYear,
    "Y": formatFullYear,
    "Z": formatZone,
    "%": formatLiteralPercent
  };
  var utcFormats = {
    "a": formatUTCShortWeekday,
    "A": formatUTCWeekday,
    "b": formatUTCShortMonth,
    "B": formatUTCMonth,
    "c": null,
    "d": formatUTCDayOfMonth,
    "e": formatUTCDayOfMonth,
    "f": formatUTCMicroseconds,
    "g": formatUTCYearISO,
    "G": formatUTCFullYearISO,
    "H": formatUTCHour24,
    "I": formatUTCHour12,
    "j": formatUTCDayOfYear,
    "L": formatUTCMilliseconds,
    "m": formatUTCMonthNumber,
    "M": formatUTCMinutes,
    "p": formatUTCPeriod,
    "q": formatUTCQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatUTCSeconds,
    "u": formatUTCWeekdayNumberMonday,
    "U": formatUTCWeekNumberSunday,
    "V": formatUTCWeekNumberISO,
    "w": formatUTCWeekdayNumberSunday,
    "W": formatUTCWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatUTCYear,
    "Y": formatUTCFullYear,
    "Z": formatUTCZone,
    "%": formatLiteralPercent
  };
  var parses = {
    "a": parseShortWeekday,
    "A": parseWeekday,
    "b": parseShortMonth,
    "B": parseMonth,
    "c": parseLocaleDateTime,
    "d": parseDayOfMonth,
    "e": parseDayOfMonth,
    "f": parseMicroseconds,
    "g": parseYear,
    "G": parseFullYear,
    "H": parseHour24,
    "I": parseHour24,
    "j": parseDayOfYear,
    "L": parseMilliseconds,
    "m": parseMonthNumber,
    "M": parseMinutes,
    "p": parsePeriod,
    "q": parseQuarter,
    "Q": parseUnixTimestamp,
    "s": parseUnixTimestampSeconds,
    "S": parseSeconds,
    "u": parseWeekdayNumberMonday,
    "U": parseWeekNumberSunday,
    "V": parseWeekNumberISO,
    "w": parseWeekdayNumberSunday,
    "W": parseWeekNumberMonday,
    "x": parseLocaleDate,
    "X": parseLocaleTime,
    "y": parseYear,
    "Y": parseFullYear,
    "Z": parseZone,
    "%": parseLiteralPercent
  };
  formats2.x = newFormat(locale_date, formats2);
  formats2.X = newFormat(locale_time, formats2);
  formats2.c = newFormat(locale_dateTime, formats2);
  utcFormats.x = newFormat(locale_date, utcFormats);
  utcFormats.X = newFormat(locale_time, utcFormats);
  utcFormats.c = newFormat(locale_dateTime, utcFormats);
  function newFormat(specifier, formats3) {
    return function(date2) {
      var string = [], i = -1, j = 0, n = specifier.length, c2, pad2, format2;
      if (!(date2 instanceof Date))
        date2 = /* @__PURE__ */ new Date(+date2);
      while (++i < n) {
        if (specifier.charCodeAt(i) === 37) {
          string.push(specifier.slice(j, i));
          if ((pad2 = pads[c2 = specifier.charAt(++i)]) != null)
            c2 = specifier.charAt(++i);
          else
            pad2 = c2 === "e" ? " " : "0";
          if (format2 = formats3[c2])
            c2 = format2(date2, pad2);
          string.push(c2);
          j = i + 1;
        }
      }
      string.push(specifier.slice(j, i));
      return string.join("");
    };
  }
  function newParse(specifier, Z) {
    return function(string) {
      var d = newDate(1900, void 0, 1), i = parseSpecifier(d, specifier, string += "", 0), week2, day;
      if (i != string.length)
        return null;
      if ("Q" in d)
        return new Date(d.Q);
      if ("s" in d)
        return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
      if (Z && !("Z" in d))
        d.Z = 0;
      if ("p" in d)
        d.H = d.H % 12 + d.p * 12;
      if (d.m === void 0)
        d.m = "q" in d ? d.q : 0;
      if ("V" in d) {
        if (d.V < 1 || d.V > 53)
          return null;
        if (!("w" in d))
          d.w = 1;
        if ("Z" in d) {
          week2 = utcDate$1(newDate(d.y, 0, 1)), day = week2.getUTCDay();
          week2 = day > 4 || day === 0 ? utcMonday.ceil(week2) : utcMonday(week2);
          week2 = utcDay.offset(week2, (d.V - 1) * 7);
          d.y = week2.getUTCFullYear();
          d.m = week2.getUTCMonth();
          d.d = week2.getUTCDate() + (d.w + 6) % 7;
        } else {
          week2 = localDate$1(newDate(d.y, 0, 1)), day = week2.getDay();
          week2 = day > 4 || day === 0 ? timeMonday.ceil(week2) : timeMonday(week2);
          week2 = timeDay.offset(week2, (d.V - 1) * 7);
          d.y = week2.getFullYear();
          d.m = week2.getMonth();
          d.d = week2.getDate() + (d.w + 6) % 7;
        }
      } else if ("W" in d || "U" in d) {
        if (!("w" in d))
          d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
        day = "Z" in d ? utcDate$1(newDate(d.y, 0, 1)).getUTCDay() : localDate$1(newDate(d.y, 0, 1)).getDay();
        d.m = 0;
        d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
      }
      if ("Z" in d) {
        d.H += d.Z / 100 | 0;
        d.M += d.Z % 100;
        return utcDate$1(d);
      }
      return localDate$1(d);
    };
  }
  function parseSpecifier(d, specifier, string, j) {
    var i = 0, n = specifier.length, m2 = string.length, c2, parse2;
    while (i < n) {
      if (j >= m2)
        return -1;
      c2 = specifier.charCodeAt(i++);
      if (c2 === 37) {
        c2 = specifier.charAt(i++);
        parse2 = parses[c2 in pads ? specifier.charAt(i++) : c2];
        if (!parse2 || (j = parse2(d, string, j)) < 0)
          return -1;
      } else if (c2 != string.charCodeAt(j++)) {
        return -1;
      }
    }
    return j;
  }
  function parsePeriod(d, string, i) {
    var n = periodRe.exec(string.slice(i));
    return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseShortWeekday(d, string, i) {
    var n = shortWeekdayRe.exec(string.slice(i));
    return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseWeekday(d, string, i) {
    var n = weekdayRe.exec(string.slice(i));
    return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseShortMonth(d, string, i) {
    var n = shortMonthRe.exec(string.slice(i));
    return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseMonth(d, string, i) {
    var n = monthRe.exec(string.slice(i));
    return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseLocaleDateTime(d, string, i) {
    return parseSpecifier(d, locale_dateTime, string, i);
  }
  function parseLocaleDate(d, string, i) {
    return parseSpecifier(d, locale_date, string, i);
  }
  function parseLocaleTime(d, string, i) {
    return parseSpecifier(d, locale_time, string, i);
  }
  function formatShortWeekday(d) {
    return locale_shortWeekdays[d.getDay()];
  }
  function formatWeekday(d) {
    return locale_weekdays[d.getDay()];
  }
  function formatShortMonth(d) {
    return locale_shortMonths[d.getMonth()];
  }
  function formatMonth(d) {
    return locale_months[d.getMonth()];
  }
  function formatPeriod(d) {
    return locale_periods[+(d.getHours() >= 12)];
  }
  function formatQuarter(d) {
    return 1 + ~~(d.getMonth() / 3);
  }
  function formatUTCShortWeekday(d) {
    return locale_shortWeekdays[d.getUTCDay()];
  }
  function formatUTCWeekday(d) {
    return locale_weekdays[d.getUTCDay()];
  }
  function formatUTCShortMonth(d) {
    return locale_shortMonths[d.getUTCMonth()];
  }
  function formatUTCMonth(d) {
    return locale_months[d.getUTCMonth()];
  }
  function formatUTCPeriod(d) {
    return locale_periods[+(d.getUTCHours() >= 12)];
  }
  function formatUTCQuarter(d) {
    return 1 + ~~(d.getUTCMonth() / 3);
  }
  return {
    format: function(specifier) {
      var f = newFormat(specifier += "", formats2);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    parse: function(specifier) {
      var p = newParse(specifier += "", false);
      p.toString = function() {
        return specifier;
      };
      return p;
    },
    utcFormat: function(specifier) {
      var f = newFormat(specifier += "", utcFormats);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    utcParse: function(specifier) {
      var p = newParse(specifier += "", true);
      p.toString = function() {
        return specifier;
      };
      return p;
    }
  };
}
var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
function pad$1(value2, fill2, width2) {
  var sign2 = value2 < 0 ? "-" : "", string = (sign2 ? -value2 : value2) + "", length2 = string.length;
  return sign2 + (length2 < width2 ? new Array(width2 - length2 + 1).join(fill2) + string : string);
}
function requote(s) {
  return s.replace(requoteRe, "\\$&");
}
function formatRe(names) {
  return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
}
function formatLookup(names) {
  return new Map(names.map((name, i) => [name.toLowerCase(), i]));
}
function parseWeekdayNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.w = +n[0], i + n[0].length) : -1;
}
function parseWeekdayNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.u = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.U = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberISO(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.V = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.W = +n[0], i + n[0].length) : -1;
}
function parseFullYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 4));
  return n ? (d.y = +n[0], i + n[0].length) : -1;
}
function parseYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i + n[0].length) : -1;
}
function parseZone(d, string, i) {
  var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
  return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
}
function parseQuarter(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.q = n[0] * 3 - 3, i + n[0].length) : -1;
}
function parseMonthNumber(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
}
function parseDayOfMonth(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.d = +n[0], i + n[0].length) : -1;
}
function parseDayOfYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
}
function parseHour24(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.H = +n[0], i + n[0].length) : -1;
}
function parseMinutes(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.M = +n[0], i + n[0].length) : -1;
}
function parseSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.S = +n[0], i + n[0].length) : -1;
}
function parseMilliseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.L = +n[0], i + n[0].length) : -1;
}
function parseMicroseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 6));
  return n ? (d.L = Math.floor(n[0] / 1e3), i + n[0].length) : -1;
}
function parseLiteralPercent(d, string, i) {
  var n = percentRe.exec(string.slice(i, i + 1));
  return n ? i + n[0].length : -1;
}
function parseUnixTimestamp(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.Q = +n[0], i + n[0].length) : -1;
}
function parseUnixTimestampSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.s = +n[0], i + n[0].length) : -1;
}
function formatDayOfMonth(d, p) {
  return pad$1(d.getDate(), p, 2);
}
function formatHour24(d, p) {
  return pad$1(d.getHours(), p, 2);
}
function formatHour12(d, p) {
  return pad$1(d.getHours() % 12 || 12, p, 2);
}
function formatDayOfYear(d, p) {
  return pad$1(1 + timeDay.count(timeYear(d), d), p, 3);
}
function formatMilliseconds(d, p) {
  return pad$1(d.getMilliseconds(), p, 3);
}
function formatMicroseconds(d, p) {
  return formatMilliseconds(d, p) + "000";
}
function formatMonthNumber(d, p) {
  return pad$1(d.getMonth() + 1, p, 2);
}
function formatMinutes(d, p) {
  return pad$1(d.getMinutes(), p, 2);
}
function formatSeconds(d, p) {
  return pad$1(d.getSeconds(), p, 2);
}
function formatWeekdayNumberMonday(d) {
  var day = d.getDay();
  return day === 0 ? 7 : day;
}
function formatWeekNumberSunday(d, p) {
  return pad$1(timeSunday.count(timeYear(d) - 1, d), p, 2);
}
function dISO(d) {
  var day = d.getDay();
  return day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
}
function formatWeekNumberISO(d, p) {
  d = dISO(d);
  return pad$1(timeThursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p, 2);
}
function formatWeekdayNumberSunday(d) {
  return d.getDay();
}
function formatWeekNumberMonday(d, p) {
  return pad$1(timeMonday.count(timeYear(d) - 1, d), p, 2);
}
function formatYear(d, p) {
  return pad$1(d.getFullYear() % 100, p, 2);
}
function formatYearISO(d, p) {
  d = dISO(d);
  return pad$1(d.getFullYear() % 100, p, 2);
}
function formatFullYear(d, p) {
  return pad$1(d.getFullYear() % 1e4, p, 4);
}
function formatFullYearISO(d, p) {
  var day = d.getDay();
  d = day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
  return pad$1(d.getFullYear() % 1e4, p, 4);
}
function formatZone(d) {
  var z = d.getTimezoneOffset();
  return (z > 0 ? "-" : (z *= -1, "+")) + pad$1(z / 60 | 0, "0", 2) + pad$1(z % 60, "0", 2);
}
function formatUTCDayOfMonth(d, p) {
  return pad$1(d.getUTCDate(), p, 2);
}
function formatUTCHour24(d, p) {
  return pad$1(d.getUTCHours(), p, 2);
}
function formatUTCHour12(d, p) {
  return pad$1(d.getUTCHours() % 12 || 12, p, 2);
}
function formatUTCDayOfYear(d, p) {
  return pad$1(1 + utcDay.count(utcYear(d), d), p, 3);
}
function formatUTCMilliseconds(d, p) {
  return pad$1(d.getUTCMilliseconds(), p, 3);
}
function formatUTCMicroseconds(d, p) {
  return formatUTCMilliseconds(d, p) + "000";
}
function formatUTCMonthNumber(d, p) {
  return pad$1(d.getUTCMonth() + 1, p, 2);
}
function formatUTCMinutes(d, p) {
  return pad$1(d.getUTCMinutes(), p, 2);
}
function formatUTCSeconds(d, p) {
  return pad$1(d.getUTCSeconds(), p, 2);
}
function formatUTCWeekdayNumberMonday(d) {
  var dow = d.getUTCDay();
  return dow === 0 ? 7 : dow;
}
function formatUTCWeekNumberSunday(d, p) {
  return pad$1(utcSunday.count(utcYear(d) - 1, d), p, 2);
}
function UTCdISO(d) {
  var day = d.getUTCDay();
  return day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
}
function formatUTCWeekNumberISO(d, p) {
  d = UTCdISO(d);
  return pad$1(utcThursday.count(utcYear(d), d) + (utcYear(d).getUTCDay() === 4), p, 2);
}
function formatUTCWeekdayNumberSunday(d) {
  return d.getUTCDay();
}
function formatUTCWeekNumberMonday(d, p) {
  return pad$1(utcMonday.count(utcYear(d) - 1, d), p, 2);
}
function formatUTCYear(d, p) {
  return pad$1(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCYearISO(d, p) {
  d = UTCdISO(d);
  return pad$1(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCFullYear(d, p) {
  return pad$1(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCFullYearISO(d, p) {
  var day = d.getUTCDay();
  d = day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
  return pad$1(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCZone() {
  return "+0000";
}
function formatLiteralPercent() {
  return "%";
}
function formatUnixTimestamp(d) {
  return +d;
}
function formatUnixTimestampSeconds(d) {
  return Math.floor(+d / 1e3);
}
var locale$1;
var timeFormat$2;
var timeParse$2;
var utcFormat$2;
var utcParse$2;
defaultLocale$1({
  dateTime: "%x, %X",
  date: "%-m/%-d/%Y",
  time: "%-I:%M:%S %p",
  periods: ["AM", "PM"],
  days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
  shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
  shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
});
function defaultLocale$1(definition2) {
  locale$1 = formatLocale(definition2);
  timeFormat$2 = locale$1.format;
  timeParse$2 = locale$1.parse;
  utcFormat$2 = locale$1.utcFormat;
  utcParse$2 = locale$1.utcParse;
  return locale$1;
}
function date(t) {
  return new Date(t);
}
function number$4(t) {
  return t instanceof Date ? +t : +/* @__PURE__ */ new Date(+t);
}
function calendar(ticks2, tickInterval, year, month, week2, day, hour, minute, second2, format2) {
  var scale2 = continuous$1(), invert2 = scale2.invert, domain2 = scale2.domain;
  var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
  function tickFormat2(date2) {
    return (second2(date2) < date2 ? formatMillisecond : minute(date2) < date2 ? formatSecond : hour(date2) < date2 ? formatMinute : day(date2) < date2 ? formatHour : month(date2) < date2 ? week2(date2) < date2 ? formatDay : formatWeek : year(date2) < date2 ? formatMonth : formatYear2)(date2);
  }
  scale2.invert = function(y2) {
    return new Date(invert2(y2));
  };
  scale2.domain = function(_) {
    return arguments.length ? domain2(Array.from(_, number$4)) : domain2().map(date);
  };
  scale2.ticks = function(interval2) {
    var d = domain2();
    return ticks2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
  };
  scale2.tickFormat = function(count2, specifier) {
    return specifier == null ? tickFormat2 : format2(specifier);
  };
  scale2.nice = function(interval2) {
    var d = domain2();
    if (!interval2 || typeof interval2.range !== "function")
      interval2 = tickInterval(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
    return interval2 ? domain2(nice(d, interval2)) : scale2;
  };
  scale2.copy = function() {
    return copy$3(scale2, calendar(ticks2, tickInterval, year, month, week2, day, hour, minute, second2, format2));
  };
  return scale2;
}
function time$2() {
  return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute, second, timeFormat$2).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
}
function utcTime() {
  return initRange.apply(calendar(utcTicks, utcTickInterval, utcYear, utcMonth, utcSunday, utcDay, utcHour, utcMinute, second, utcFormat$2).domain([Date.UTC(2e3, 0, 1), Date.UTC(2e3, 0, 2)]), arguments);
}
function transformer$1() {
  var x02 = 0, x12 = 1, t02, t12, k10, transform2, interpolator = identity$3, clamp2 = false, unknown;
  function scale2(x2) {
    return x2 == null || isNaN(x2 = +x2) ? unknown : interpolator(k10 === 0 ? 0.5 : (x2 = (transform2(x2) - t02) * k10, clamp2 ? Math.max(0, Math.min(1, x2)) : x2));
  }
  scale2.domain = function(_) {
    return arguments.length ? ([x02, x12] = _, t02 = transform2(x02 = +x02), t12 = transform2(x12 = +x12), k10 = t02 === t12 ? 0 : 1 / (t12 - t02), scale2) : [x02, x12];
  };
  scale2.clamp = function(_) {
    return arguments.length ? (clamp2 = !!_, scale2) : clamp2;
  };
  scale2.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale2) : interpolator;
  };
  function range2(interpolate2) {
    return function(_) {
      var r0, r1;
      return arguments.length ? ([r0, r1] = _, interpolator = interpolate2(r0, r1), scale2) : [interpolator(0), interpolator(1)];
    };
  }
  scale2.range = range2(interpolate$1);
  scale2.rangeRound = range2(interpolateRound);
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  return function(t) {
    transform2 = t, t02 = t(x02), t12 = t(x12), k10 = t02 === t12 ? 0 : 1 / (t12 - t02);
    return scale2;
  };
}
function copy$2(source2, target2) {
  return target2.domain(source2.domain()).interpolator(source2.interpolator()).clamp(source2.clamp()).unknown(source2.unknown());
}
function sequential() {
  var scale2 = linearish(transformer$1()(identity$3));
  scale2.copy = function() {
    return copy$2(scale2, sequential());
  };
  return initInterpolator.apply(scale2, arguments);
}
function sequentialLog() {
  var scale2 = loggish(transformer$1()).domain([1, 10]);
  scale2.copy = function() {
    return copy$2(scale2, sequentialLog()).base(scale2.base());
  };
  return initInterpolator.apply(scale2, arguments);
}
function sequentialSymlog() {
  var scale2 = symlogish(transformer$1());
  scale2.copy = function() {
    return copy$2(scale2, sequentialSymlog()).constant(scale2.constant());
  };
  return initInterpolator.apply(scale2, arguments);
}
function sequentialPow() {
  var scale2 = powish(transformer$1());
  scale2.copy = function() {
    return copy$2(scale2, sequentialPow()).exponent(scale2.exponent());
  };
  return initInterpolator.apply(scale2, arguments);
}
function sequentialSqrt() {
  return sequentialPow.apply(null, arguments).exponent(0.5);
}
function transformer() {
  var x02 = 0, x12 = 0.5, x2 = 1, s = 1, t02, t12, t22, k10, k21, interpolator = identity$3, transform2, clamp2 = false, unknown;
  function scale2(x3) {
    return isNaN(x3 = +x3) ? unknown : (x3 = 0.5 + ((x3 = +transform2(x3)) - t12) * (s * x3 < s * t12 ? k10 : k21), interpolator(clamp2 ? Math.max(0, Math.min(1, x3)) : x3));
  }
  scale2.domain = function(_) {
    return arguments.length ? ([x02, x12, x2] = _, t02 = transform2(x02 = +x02), t12 = transform2(x12 = +x12), t22 = transform2(x2 = +x2), k10 = t02 === t12 ? 0 : 0.5 / (t12 - t02), k21 = t12 === t22 ? 0 : 0.5 / (t22 - t12), s = t12 < t02 ? -1 : 1, scale2) : [x02, x12, x2];
  };
  scale2.clamp = function(_) {
    return arguments.length ? (clamp2 = !!_, scale2) : clamp2;
  };
  scale2.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale2) : interpolator;
  };
  function range2(interpolate2) {
    return function(_) {
      var r0, r1, r2;
      return arguments.length ? ([r0, r1, r2] = _, interpolator = piecewise(interpolate2, [r0, r1, r2]), scale2) : [interpolator(0), interpolator(0.5), interpolator(1)];
    };
  }
  scale2.range = range2(interpolate$1);
  scale2.rangeRound = range2(interpolateRound);
  scale2.unknown = function(_) {
    return arguments.length ? (unknown = _, scale2) : unknown;
  };
  return function(t) {
    transform2 = t, t02 = t(x02), t12 = t(x12), t22 = t(x2), k10 = t02 === t12 ? 0 : 0.5 / (t12 - t02), k21 = t12 === t22 ? 0 : 0.5 / (t22 - t12), s = t12 < t02 ? -1 : 1;
    return scale2;
  };
}
function diverging() {
  var scale2 = linearish(transformer()(identity$3));
  scale2.copy = function() {
    return copy$2(scale2, diverging());
  };
  return initInterpolator.apply(scale2, arguments);
}
function divergingLog() {
  var scale2 = loggish(transformer()).domain([0.1, 1, 10]);
  scale2.copy = function() {
    return copy$2(scale2, divergingLog()).base(scale2.base());
  };
  return initInterpolator.apply(scale2, arguments);
}
function divergingSymlog() {
  var scale2 = symlogish(transformer());
  scale2.copy = function() {
    return copy$2(scale2, divergingSymlog()).constant(scale2.constant());
  };
  return initInterpolator.apply(scale2, arguments);
}
function divergingPow() {
  var scale2 = powish(transformer());
  scale2.copy = function() {
    return copy$2(scale2, divergingPow()).exponent(scale2.exponent());
  };
  return initInterpolator.apply(scale2, arguments);
}
function divergingSqrt() {
  return divergingPow.apply(null, arguments).exponent(0.5);
}
function constant$1(x2) {
  return function constant2() {
    return x2;
  };
}
const abs$1 = Math.abs;
const atan2 = Math.atan2;
const cos$1 = Math.cos;
const max$1 = Math.max;
const min$1 = Math.min;
const sin$1 = Math.sin;
const sqrt$1 = Math.sqrt;
const epsilon$2 = 1e-12;
const pi$1 = Math.PI;
const halfPi$1 = pi$1 / 2;
const tau = 2 * pi$1;
function acos(x2) {
  return x2 > 1 ? 0 : x2 < -1 ? pi$1 : Math.acos(x2);
}
function asin$1(x2) {
  return x2 >= 1 ? halfPi$1 : x2 <= -1 ? -halfPi$1 : Math.asin(x2);
}
function withPath(shape2) {
  let digits = 3;
  shape2.digits = function(_) {
    if (!arguments.length)
      return digits;
    if (_ == null) {
      digits = null;
    } else {
      const d = Math.floor(_);
      if (!(d >= 0))
        throw new RangeError(`invalid digits: ${_}`);
      digits = d;
    }
    return shape2;
  };
  return () => new Path$1(digits);
}
function arcInnerRadius(d) {
  return d.innerRadius;
}
function arcOuterRadius(d) {
  return d.outerRadius;
}
function arcStartAngle(d) {
  return d.startAngle;
}
function arcEndAngle(d) {
  return d.endAngle;
}
function arcPadAngle(d) {
  return d && d.padAngle;
}
function intersect$4(x02, y02, x12, y12, x2, y2, x3, y3) {
  var x10 = x12 - x02, y10 = y12 - y02, x32 = x3 - x2, y32 = y3 - y2, t = y32 * x10 - x32 * y10;
  if (t * t < epsilon$2)
    return;
  t = (x32 * (y02 - y2) - y32 * (x02 - x2)) / t;
  return [x02 + t * x10, y02 + t * y10];
}
function cornerTangents(x02, y02, x12, y12, r1, rc, cw2) {
  var x01 = x02 - x12, y01 = y02 - y12, lo = (cw2 ? rc : -rc) / sqrt$1(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x02 + ox, y11 = y02 + oy, x10 = x12 + ox, y10 = y12 + oy, x002 = (x11 + x10) / 2, y002 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D2 = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt$1(max$1(0, r * r * d2 - D2 * D2)), cx0 = (D2 * dy - dx * d) / d2, cy0 = (-D2 * dx - dy * d) / d2, cx1 = (D2 * dy + dx * d) / d2, cy1 = (-D2 * dx + dy * d) / d2, dx0 = cx0 - x002, dy0 = cy0 - y002, dx1 = cx1 - x002, dy1 = cy1 - y002;
  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1)
    cx0 = cx1, cy0 = cy1;
  return {
    cx: cx0,
    cy: cy0,
    x01: -ox,
    y01: -oy,
    x11: cx0 * (r1 / r - 1),
    y11: cy0 * (r1 / r - 1)
  };
}
function d3arc() {
  var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant$1(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context2 = null, path2 = withPath(arc2);
  function arc2() {
    var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi$1, a1 = endAngle.apply(this, arguments) - halfPi$1, da = abs$1(a1 - a0), cw2 = a1 > a0;
    if (!context2)
      context2 = buffer = path2();
    if (r1 < r0)
      r = r1, r1 = r0, r0 = r;
    if (!(r1 > epsilon$2))
      context2.moveTo(0, 0);
    else if (da > tau - epsilon$2) {
      context2.moveTo(r1 * cos$1(a0), r1 * sin$1(a0));
      context2.arc(0, 0, r1, a0, a1, !cw2);
      if (r0 > epsilon$2) {
        context2.moveTo(r0 * cos$1(a1), r0 * sin$1(a1));
        context2.arc(0, 0, r0, a1, a0, cw2);
      }
    } else {
      var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon$2 && (padRadius ? +padRadius.apply(this, arguments) : sqrt$1(r0 * r0 + r1 * r1)), rc = min$1(abs$1(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t02, t12;
      if (rp > epsilon$2) {
        var p02 = asin$1(rp / r0 * sin$1(ap)), p1 = asin$1(rp / r1 * sin$1(ap));
        if ((da0 -= p02 * 2) > epsilon$2)
          p02 *= cw2 ? 1 : -1, a00 += p02, a10 -= p02;
        else
          da0 = 0, a00 = a10 = (a0 + a1) / 2;
        if ((da1 -= p1 * 2) > epsilon$2)
          p1 *= cw2 ? 1 : -1, a01 += p1, a11 -= p1;
        else
          da1 = 0, a01 = a11 = (a0 + a1) / 2;
      }
      var x01 = r1 * cos$1(a01), y01 = r1 * sin$1(a01), x10 = r0 * cos$1(a10), y10 = r0 * sin$1(a10);
      if (rc > epsilon$2) {
        var x11 = r1 * cos$1(a11), y11 = r1 * sin$1(a11), x002 = r0 * cos$1(a00), y002 = r0 * sin$1(a00), oc;
        if (da < pi$1) {
          if (oc = intersect$4(x01, y01, x002, y002, x11, y11, x10, y10)) {
            var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin$1(acos((ax * bx + ay * by) / (sqrt$1(ax * ax + ay * ay) * sqrt$1(bx * bx + by * by))) / 2), lc = sqrt$1(oc[0] * oc[0] + oc[1] * oc[1]);
            rc0 = min$1(rc, (r0 - lc) / (kc - 1));
            rc1 = min$1(rc, (r1 - lc) / (kc + 1));
          } else {
            rc0 = rc1 = 0;
          }
        }
      }
      if (!(da1 > epsilon$2))
        context2.moveTo(x01, y01);
      else if (rc1 > epsilon$2) {
        t02 = cornerTangents(x002, y002, x01, y01, r1, rc1, cw2);
        t12 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw2);
        context2.moveTo(t02.cx + t02.x01, t02.cy + t02.y01);
        if (rc1 < rc)
          context2.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw2);
        else {
          context2.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw2);
          context2.arc(0, 0, r1, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), !cw2);
          context2.arc(t12.cx, t12.cy, rc1, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw2);
        }
      } else
        context2.moveTo(x01, y01), context2.arc(0, 0, r1, a01, a11, !cw2);
      if (!(r0 > epsilon$2) || !(da0 > epsilon$2))
        context2.lineTo(x10, y10);
      else if (rc0 > epsilon$2) {
        t02 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw2);
        t12 = cornerTangents(x01, y01, x002, y002, r0, -rc0, cw2);
        context2.lineTo(t02.cx + t02.x01, t02.cy + t02.y01);
        if (rc0 < rc)
          context2.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw2);
        else {
          context2.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw2);
          context2.arc(0, 0, r0, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), cw2);
          context2.arc(t12.cx, t12.cy, rc0, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw2);
        }
      } else
        context2.arc(0, 0, r0, a10, a00, cw2);
    }
    context2.closePath();
    if (buffer)
      return context2 = null, buffer + "" || null;
  }
  arc2.centroid = function() {
    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a2 = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi$1 / 2;
    return [cos$1(a2) * r, sin$1(a2) * r];
  };
  arc2.innerRadius = function(_) {
    return arguments.length ? (innerRadius = typeof _ === "function" ? _ : constant$1(+_), arc2) : innerRadius;
  };
  arc2.outerRadius = function(_) {
    return arguments.length ? (outerRadius = typeof _ === "function" ? _ : constant$1(+_), arc2) : outerRadius;
  };
  arc2.cornerRadius = function(_) {
    return arguments.length ? (cornerRadius = typeof _ === "function" ? _ : constant$1(+_), arc2) : cornerRadius;
  };
  arc2.padRadius = function(_) {
    return arguments.length ? (padRadius = _ == null ? null : typeof _ === "function" ? _ : constant$1(+_), arc2) : padRadius;
  };
  arc2.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : constant$1(+_), arc2) : startAngle;
  };
  arc2.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : constant$1(+_), arc2) : endAngle;
  };
  arc2.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : constant$1(+_), arc2) : padAngle;
  };
  arc2.context = function(_) {
    return arguments.length ? (context2 = _ == null ? null : _, arc2) : context2;
  };
  return arc2;
}
function array$4(x2) {
  return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
}
function Linear$1(context2) {
  this._context = context2;
}
Linear$1.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
      default:
        this._context.lineTo(x2, y2);
        break;
    }
  }
};
function curveLinear(context2) {
  return new Linear$1(context2);
}
function x$1(p) {
  return p[0];
}
function y$1(p) {
  return p[1];
}
function line$3(x2, y2) {
  var defined = constant$1(true), context2 = null, curve2 = curveLinear, output2 = null, path2 = withPath(line2);
  x2 = typeof x2 === "function" ? x2 : x2 === void 0 ? x$1 : constant$1(x2);
  y2 = typeof y2 === "function" ? y2 : y2 === void 0 ? y$1 : constant$1(y2);
  function line2(data2) {
    var i, n = (data2 = array$4(data2)).length, d, defined0 = false, buffer;
    if (context2 == null)
      output2 = curve2(buffer = path2());
    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data2[i], i, data2)) === defined0) {
        if (defined0 = !defined0)
          output2.lineStart();
        else
          output2.lineEnd();
      }
      if (defined0)
        output2.point(+x2(d, i, data2), +y2(d, i, data2));
    }
    if (buffer)
      return output2 = null, buffer + "" || null;
  }
  line2.x = function(_) {
    return arguments.length ? (x2 = typeof _ === "function" ? _ : constant$1(+_), line2) : x2;
  };
  line2.y = function(_) {
    return arguments.length ? (y2 = typeof _ === "function" ? _ : constant$1(+_), line2) : y2;
  };
  line2.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : constant$1(!!_), line2) : defined;
  };
  line2.curve = function(_) {
    return arguments.length ? (curve2 = _, context2 != null && (output2 = curve2(context2)), line2) : curve2;
  };
  line2.context = function(_) {
    return arguments.length ? (_ == null ? context2 = output2 = null : output2 = curve2(context2 = _), line2) : context2;
  };
  return line2;
}
function area$2$1(x02, y02, y12) {
  var x12 = null, defined = constant$1(true), context2 = null, curve2 = curveLinear, output2 = null, path2 = withPath(area2);
  x02 = typeof x02 === "function" ? x02 : x02 === void 0 ? x$1 : constant$1(+x02);
  y02 = typeof y02 === "function" ? y02 : y02 === void 0 ? constant$1(0) : constant$1(+y02);
  y12 = typeof y12 === "function" ? y12 : y12 === void 0 ? y$1 : constant$1(+y12);
  function area2(data2) {
    var i, j, k, n = (data2 = array$4(data2)).length, d, defined0 = false, buffer, x0z = new Array(n), y0z = new Array(n);
    if (context2 == null)
      output2 = curve2(buffer = path2());
    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data2[i], i, data2)) === defined0) {
        if (defined0 = !defined0) {
          j = i;
          output2.areaStart();
          output2.lineStart();
        } else {
          output2.lineEnd();
          output2.lineStart();
          for (k = i - 1; k >= j; --k) {
            output2.point(x0z[k], y0z[k]);
          }
          output2.lineEnd();
          output2.areaEnd();
        }
      }
      if (defined0) {
        x0z[i] = +x02(d, i, data2), y0z[i] = +y02(d, i, data2);
        output2.point(x12 ? +x12(d, i, data2) : x0z[i], y12 ? +y12(d, i, data2) : y0z[i]);
      }
    }
    if (buffer)
      return output2 = null, buffer + "" || null;
  }
  function arealine() {
    return line$3().defined(defined).curve(curve2).context(context2);
  }
  area2.x = function(_) {
    return arguments.length ? (x02 = typeof _ === "function" ? _ : constant$1(+_), x12 = null, area2) : x02;
  };
  area2.x0 = function(_) {
    return arguments.length ? (x02 = typeof _ === "function" ? _ : constant$1(+_), area2) : x02;
  };
  area2.x1 = function(_) {
    return arguments.length ? (x12 = _ == null ? null : typeof _ === "function" ? _ : constant$1(+_), area2) : x12;
  };
  area2.y = function(_) {
    return arguments.length ? (y02 = typeof _ === "function" ? _ : constant$1(+_), y12 = null, area2) : y02;
  };
  area2.y0 = function(_) {
    return arguments.length ? (y02 = typeof _ === "function" ? _ : constant$1(+_), area2) : y02;
  };
  area2.y1 = function(_) {
    return arguments.length ? (y12 = _ == null ? null : typeof _ === "function" ? _ : constant$1(+_), area2) : y12;
  };
  area2.lineX0 = area2.lineY0 = function() {
    return arealine().x(x02).y(y02);
  };
  area2.lineY1 = function() {
    return arealine().x(x02).y(y12);
  };
  area2.lineX1 = function() {
    return arealine().x(x12).y(y02);
  };
  area2.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : constant$1(!!_), area2) : defined;
  };
  area2.curve = function(_) {
    return arguments.length ? (curve2 = _, context2 != null && (output2 = curve2(context2)), area2) : curve2;
  };
  area2.context = function(_) {
    return arguments.length ? (_ == null ? context2 = output2 = null : output2 = curve2(context2 = _), area2) : context2;
  };
  return area2;
}
const circle = {
  draw(context2, size) {
    const r = sqrt$1(size / pi$1);
    context2.moveTo(r, 0);
    context2.arc(0, 0, r, 0, tau);
  }
};
function Symbol$1(type2, size) {
  let context2 = null, path2 = withPath(symbol2);
  type2 = typeof type2 === "function" ? type2 : constant$1(type2 || circle);
  size = typeof size === "function" ? size : constant$1(size === void 0 ? 64 : +size);
  function symbol2() {
    let buffer;
    if (!context2)
      context2 = buffer = path2();
    type2.apply(this, arguments).draw(context2, +size.apply(this, arguments));
    if (buffer)
      return context2 = null, buffer + "" || null;
  }
  symbol2.type = function(_) {
    return arguments.length ? (type2 = typeof _ === "function" ? _ : constant$1(_), symbol2) : type2;
  };
  symbol2.size = function(_) {
    return arguments.length ? (size = typeof _ === "function" ? _ : constant$1(+_), symbol2) : size;
  };
  symbol2.context = function(_) {
    return arguments.length ? (context2 = _ == null ? null : _, symbol2) : context2;
  };
  return symbol2;
}
function noop$2() {
}
function point$5(that, x2, y2) {
  that._context.bezierCurveTo(
    (2 * that._x0 + that._x1) / 3,
    (2 * that._y0 + that._y1) / 3,
    (that._x0 + 2 * that._x1) / 3,
    (that._y0 + 2 * that._y1) / 3,
    (that._x0 + 4 * that._x1 + x2) / 6,
    (that._y0 + 4 * that._y1 + y2) / 6
  );
}
function Basis(context2) {
  this._context = context2;
}
Basis.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 3:
        point$5(this, this._x1, this._y1);
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
      default:
        point$5(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = x2;
    this._y0 = this._y1, this._y1 = y2;
  }
};
function curveBasis(context2) {
  return new Basis(context2);
}
function BasisClosed(context2) {
  this._context = context2;
}
BasisClosed.prototype = {
  areaStart: noop$2,
  areaEnd: noop$2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x2, this._y2);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x2, this._y2);
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        break;
      }
    }
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x2 = x2, this._y2 = y2;
        break;
      case 1:
        this._point = 2;
        this._x3 = x2, this._y3 = y2;
        break;
      case 2:
        this._point = 3;
        this._x4 = x2, this._y4 = y2;
        this._context.moveTo((this._x0 + 4 * this._x1 + x2) / 6, (this._y0 + 4 * this._y1 + y2) / 6);
        break;
      default:
        point$5(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = x2;
    this._y0 = this._y1, this._y1 = y2;
  }
};
function curveBasisClosed(context2) {
  return new BasisClosed(context2);
}
function BasisOpen(context2) {
  this._context = context2;
}
BasisOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        var x02 = (this._x0 + 4 * this._x1 + x2) / 6, y02 = (this._y0 + 4 * this._y1 + y2) / 6;
        this._line ? this._context.lineTo(x02, y02) : this._context.moveTo(x02, y02);
        break;
      case 3:
        this._point = 4;
      default:
        point$5(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = x2;
    this._y0 = this._y1, this._y1 = y2;
  }
};
function curveBasisOpen(context2) {
  return new BasisOpen(context2);
}
function Bundle(context2, beta) {
  this._basis = new Basis(context2);
  this._beta = beta;
}
Bundle.prototype = {
  lineStart: function() {
    this._x = [];
    this._y = [];
    this._basis.lineStart();
  },
  lineEnd: function() {
    var x2 = this._x, y2 = this._y, j = x2.length - 1;
    if (j > 0) {
      var x02 = x2[0], y02 = y2[0], dx = x2[j] - x02, dy = y2[j] - y02, i = -1, t;
      while (++i <= j) {
        t = i / j;
        this._basis.point(
          this._beta * x2[i] + (1 - this._beta) * (x02 + t * dx),
          this._beta * y2[i] + (1 - this._beta) * (y02 + t * dy)
        );
      }
    }
    this._x = this._y = null;
    this._basis.lineEnd();
  },
  point: function(x2, y2) {
    this._x.push(+x2);
    this._y.push(+y2);
  }
};
const curveBundle = function custom3(beta) {
  function bundle2(context2) {
    return beta === 1 ? new Basis(context2) : new Bundle(context2, beta);
  }
  bundle2.beta = function(beta2) {
    return custom3(+beta2);
  };
  return bundle2;
}(0.85);
function point$4(that, x2, y2) {
  that._context.bezierCurveTo(
    that._x1 + that._k * (that._x2 - that._x0),
    that._y1 + that._k * (that._y2 - that._y0),
    that._x2 + that._k * (that._x1 - x2),
    that._y2 + that._k * (that._y1 - y2),
    that._x2,
    that._y2
  );
}
function Cardinal(context2, tension) {
  this._context = context2;
  this._k = (1 - tension) / 6;
}
Cardinal.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        point$4(this, this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
        this._x1 = x2, this._y1 = y2;
        break;
      case 2:
        this._point = 3;
      default:
        point$4(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCardinal = function custom4(tension) {
  function cardinal(context2) {
    return new Cardinal(context2, tension);
  }
  cardinal.tension = function(tension2) {
    return custom4(+tension2);
  };
  return cardinal;
}(0);
function CardinalClosed(context2, tension) {
  this._context = context2;
  this._k = (1 - tension) / 6;
}
CardinalClosed.prototype = {
  areaStart: noop$2,
  areaEnd: noop$2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x2, this._y3 = y2;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x2, this._y4 = y2);
        break;
      case 2:
        this._point = 3;
        this._x5 = x2, this._y5 = y2;
        break;
      default:
        point$4(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCardinalClosed = function custom5(tension) {
  function cardinal(context2) {
    return new CardinalClosed(context2, tension);
  }
  cardinal.tension = function(tension2) {
    return custom5(+tension2);
  };
  return cardinal;
}(0);
function CardinalOpen(context2, tension) {
  this._context = context2;
  this._k = (1 - tension) / 6;
}
CardinalOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point$4(this, x2, y2);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCardinalOpen = function custom6(tension) {
  function cardinal(context2) {
    return new CardinalOpen(context2, tension);
  }
  cardinal.tension = function(tension2) {
    return custom6(+tension2);
  };
  return cardinal;
}(0);
function point$3(that, x2, y2) {
  var x12 = that._x1, y12 = that._y1, x22 = that._x2, y22 = that._y2;
  if (that._l01_a > epsilon$2) {
    var a2 = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
    x12 = (x12 * a2 - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
    y12 = (y12 * a2 - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
  }
  if (that._l23_a > epsilon$2) {
    var b2 = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m2 = 3 * that._l23_a * (that._l23_a + that._l12_a);
    x22 = (x22 * b2 + that._x1 * that._l23_2a - x2 * that._l12_2a) / m2;
    y22 = (y22 * b2 + that._y1 * that._l23_2a - y2 * that._l12_2a) / m2;
  }
  that._context.bezierCurveTo(x12, y12, x22, y22, that._x2, that._y2);
}
function CatmullRom(context2, alpha) {
  this._context = context2;
  this._alpha = alpha;
}
CatmullRom.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        this.point(this._x2, this._y2);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    if (this._point) {
      var x23 = this._x2 - x2, y23 = this._y2 - y2;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
      default:
        point$3(this, x2, y2);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCatmullRom = function custom7(alpha) {
  function catmullRom(context2) {
    return alpha ? new CatmullRom(context2, alpha) : new Cardinal(context2, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom7(+alpha2);
  };
  return catmullRom;
}(0.5);
function CatmullRomClosed(context2, alpha) {
  this._context = context2;
  this._alpha = alpha;
}
CatmullRomClosed.prototype = {
  areaStart: noop$2,
  areaEnd: noop$2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    if (this._point) {
      var x23 = this._x2 - x2, y23 = this._y2 - y2;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x2, this._y3 = y2;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x2, this._y4 = y2);
        break;
      case 2:
        this._point = 3;
        this._x5 = x2, this._y5 = y2;
        break;
      default:
        point$3(this, x2, y2);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCatmullRomClosed = function custom8(alpha) {
  function catmullRom(context2) {
    return alpha ? new CatmullRomClosed(context2, alpha) : new CardinalClosed(context2, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom8(+alpha2);
  };
  return catmullRom;
}(0.5);
function CatmullRomOpen(context2, alpha) {
  this._context = context2;
  this._alpha = alpha;
}
CatmullRomOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    if (this._point) {
      var x23 = this._x2 - x2, y23 = this._y2 - y2;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point$3(this, x2, y2);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
  }
};
const curveCatmullRomOpen = function custom9(alpha) {
  function catmullRom(context2) {
    return alpha ? new CatmullRomOpen(context2, alpha) : new CardinalOpen(context2, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom9(+alpha2);
  };
  return catmullRom;
}(0.5);
function LinearClosed(context2) {
  this._context = context2;
}
LinearClosed.prototype = {
  areaStart: noop$2,
  areaEnd: noop$2,
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._point)
      this._context.closePath();
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    if (this._point)
      this._context.lineTo(x2, y2);
    else
      this._point = 1, this._context.moveTo(x2, y2);
  }
};
function curveLinearClosed(context2) {
  return new LinearClosed(context2);
}
function sign(x2) {
  return x2 < 0 ? -1 : 1;
}
function slope3(that, x2, y2) {
  var h0 = that._x1 - that._x0, h1 = x2 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
  return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
}
function slope2(that, t) {
  var h2 = that._x1 - that._x0;
  return h2 ? (3 * (that._y1 - that._y0) / h2 - t) / 2 : t;
}
function point$2(that, t02, t12) {
  var x02 = that._x0, y02 = that._y0, x12 = that._x1, y12 = that._y1, dx = (x12 - x02) / 3;
  that._context.bezierCurveTo(x02 + dx, y02 + dx * t02, x12 - dx, y12 - dx * t12, x12, y12);
}
function MonotoneX(context2) {
  this._context = context2;
}
MonotoneX.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
      case 3:
        point$2(this, this._t0, slope2(this, this._t0));
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    var t12 = NaN;
    x2 = +x2, y2 = +y2;
    if (x2 === this._x1 && y2 === this._y1)
      return;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        point$2(this, slope2(this, t12 = slope3(this, x2, y2)), t12);
        break;
      default:
        point$2(this, this._t0, t12 = slope3(this, x2, y2));
        break;
    }
    this._x0 = this._x1, this._x1 = x2;
    this._y0 = this._y1, this._y1 = y2;
    this._t0 = t12;
  }
};
function MonotoneY(context2) {
  this._context = new ReflectContext(context2);
}
(MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x2, y2) {
  MonotoneX.prototype.point.call(this, y2, x2);
};
function ReflectContext(context2) {
  this._context = context2;
}
ReflectContext.prototype = {
  moveTo: function(x2, y2) {
    this._context.moveTo(y2, x2);
  },
  closePath: function() {
    this._context.closePath();
  },
  lineTo: function(x2, y2) {
    this._context.lineTo(y2, x2);
  },
  bezierCurveTo: function(x12, y12, x2, y2, x3, y3) {
    this._context.bezierCurveTo(y12, x12, y2, x2, y3, x3);
  }
};
function monotoneX(context2) {
  return new MonotoneX(context2);
}
function monotoneY(context2) {
  return new MonotoneY(context2);
}
function Natural(context2) {
  this._context = context2;
}
Natural.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = [];
    this._y = [];
  },
  lineEnd: function() {
    var x2 = this._x, y2 = this._y, n = x2.length;
    if (n) {
      this._line ? this._context.lineTo(x2[0], y2[0]) : this._context.moveTo(x2[0], y2[0]);
      if (n === 2) {
        this._context.lineTo(x2[1], y2[1]);
      } else {
        var px2 = controlPoints(x2), py2 = controlPoints(y2);
        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
          this._context.bezierCurveTo(px2[0][i0], py2[0][i0], px2[1][i0], py2[1][i0], x2[i1], y2[i1]);
        }
      }
    }
    if (this._line || this._line !== 0 && n === 1)
      this._context.closePath();
    this._line = 1 - this._line;
    this._x = this._y = null;
  },
  point: function(x2, y2) {
    this._x.push(+x2);
    this._y.push(+y2);
  }
};
function controlPoints(x2) {
  var i, n = x2.length - 1, m2, a2 = new Array(n), b2 = new Array(n), r = new Array(n);
  a2[0] = 0, b2[0] = 2, r[0] = x2[0] + 2 * x2[1];
  for (i = 1; i < n - 1; ++i)
    a2[i] = 1, b2[i] = 4, r[i] = 4 * x2[i] + 2 * x2[i + 1];
  a2[n - 1] = 2, b2[n - 1] = 7, r[n - 1] = 8 * x2[n - 1] + x2[n];
  for (i = 1; i < n; ++i)
    m2 = a2[i] / b2[i - 1], b2[i] -= m2, r[i] -= m2 * r[i - 1];
  a2[n - 1] = r[n - 1] / b2[n - 1];
  for (i = n - 2; i >= 0; --i)
    a2[i] = (r[i] - a2[i + 1]) / b2[i];
  b2[n - 1] = (x2[n] + a2[n - 1]) / 2;
  for (i = 0; i < n - 1; ++i)
    b2[i] = 2 * x2[i + 1] - a2[i + 1];
  return [a2, b2];
}
function curveNatural(context2) {
  return new Natural(context2);
}
function Step(context2, t) {
  this._context = context2;
  this._t = t;
}
Step.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = this._y = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (0 < this._t && this._t < 1 && this._point === 2)
      this._context.lineTo(this._x, this._y);
    if (this._line || this._line !== 0 && this._point === 1)
      this._context.closePath();
    if (this._line >= 0)
      this._t = 1 - this._t, this._line = 1 - this._line;
  },
  point: function(x2, y2) {
    x2 = +x2, y2 = +y2;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
        break;
      case 1:
        this._point = 2;
      default: {
        if (this._t <= 0) {
          this._context.lineTo(this._x, y2);
          this._context.lineTo(x2, y2);
        } else {
          var x12 = this._x * (1 - this._t) + x2 * this._t;
          this._context.lineTo(x12, this._y);
          this._context.lineTo(x12, y2);
        }
        break;
      }
    }
    this._x = x2, this._y = y2;
  }
};
function curveStep(context2) {
  return new Step(context2, 0.5);
}
function stepBefore(context2) {
  return new Step(context2, 0);
}
function stepAfter(context2) {
  return new Step(context2, 1);
}
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2022 Joachim Wester
 * MIT licensed
 */
var __extends = /* @__PURE__ */ function() {
  var extendStatics = function(d, b2) {
    extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b3) {
      d2.__proto__ = b3;
    } || function(d2, b3) {
      for (var p in b3)
        if (b3.hasOwnProperty(p))
          d2[p] = b3[p];
    };
    return extendStatics(d, b2);
  };
  return function(d, b2) {
    extendStatics(d, b2);
    function __() {
      this.constructor = d;
    }
    d.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
  };
}();
var _hasOwnProperty = Object.prototype.hasOwnProperty;
function hasOwnProperty(obj, key2) {
  return _hasOwnProperty.call(obj, key2);
}
function _objectKeys(obj) {
  if (Array.isArray(obj)) {
    var keys_1 = new Array(obj.length);
    for (var k = 0; k < keys_1.length; k++) {
      keys_1[k] = "" + k;
    }
    return keys_1;
  }
  if (Object.keys) {
    return Object.keys(obj);
  }
  var keys2 = [];
  for (var i in obj) {
    if (hasOwnProperty(obj, i)) {
      keys2.push(i);
    }
  }
  return keys2;
}
function _deepClone(obj) {
  switch (typeof obj) {
    case "object":
      return JSON.parse(JSON.stringify(obj));
    case "undefined":
      return null;
    default:
      return obj;
  }
}
function isInteger$1(str) {
  var i = 0;
  var len = str.length;
  var charCode;
  while (i < len) {
    charCode = str.charCodeAt(i);
    if (charCode >= 48 && charCode <= 57) {
      i++;
      continue;
    }
    return false;
  }
  return true;
}
function escapePathComponent(path2) {
  if (path2.indexOf("/") === -1 && path2.indexOf("~") === -1)
    return path2;
  return path2.replace(/~/g, "~0").replace(/\//g, "~1");
}
function unescapePathComponent(path2) {
  return path2.replace(/~1/g, "/").replace(/~0/g, "~");
}
function hasUndefined(obj) {
  if (obj === void 0) {
    return true;
  }
  if (obj) {
    if (Array.isArray(obj)) {
      for (var i_1 = 0, len = obj.length; i_1 < len; i_1++) {
        if (hasUndefined(obj[i_1])) {
          return true;
        }
      }
    } else if (typeof obj === "object") {
      var objKeys = _objectKeys(obj);
      var objKeysLength = objKeys.length;
      for (var i = 0; i < objKeysLength; i++) {
        if (hasUndefined(obj[objKeys[i]])) {
          return true;
        }
      }
    }
  }
  return false;
}
function patchErrorMessageFormatter(message, args) {
  var messageParts = [message];
  for (var key2 in args) {
    var value2 = typeof args[key2] === "object" ? JSON.stringify(args[key2], null, 2) : args[key2];
    if (typeof value2 !== "undefined") {
      messageParts.push(key2 + ": " + value2);
    }
  }
  return messageParts.join("\n");
}
var PatchError = (
  /** @class */
  function(_super) {
    __extends(PatchError2, _super);
    function PatchError2(message, name, index2, operation, tree2) {
      var _newTarget = this.constructor;
      var _this = _super.call(this, patchErrorMessageFormatter(message, { name, index: index2, operation, tree: tree2 })) || this;
      _this.name = name;
      _this.index = index2;
      _this.operation = operation;
      _this.tree = tree2;
      Object.setPrototypeOf(_this, _newTarget.prototype);
      _this.message = patchErrorMessageFormatter(message, { name, index: index2, operation, tree: tree2 });
      return _this;
    }
    return PatchError2;
  }(Error)
);
var JsonPatchError = PatchError;
var deepClone = _deepClone;
var objOps = {
  add: function(obj, key2, document2) {
    obj[key2] = this.value;
    return { newDocument: document2 };
  },
  remove: function(obj, key2, document2) {
    var removed = obj[key2];
    delete obj[key2];
    return { newDocument: document2, removed };
  },
  replace: function(obj, key2, document2) {
    var removed = obj[key2];
    obj[key2] = this.value;
    return { newDocument: document2, removed };
  },
  move: function(obj, key2, document2) {
    var removed = getValueByPointer(document2, this.path);
    if (removed) {
      removed = _deepClone(removed);
    }
    var originalValue = applyOperation(document2, { op: "remove", path: this.from }).removed;
    applyOperation(document2, { op: "add", path: this.path, value: originalValue });
    return { newDocument: document2, removed };
  },
  copy: function(obj, key2, document2) {
    var valueToCopy = getValueByPointer(document2, this.from);
    applyOperation(document2, { op: "add", path: this.path, value: _deepClone(valueToCopy) });
    return { newDocument: document2 };
  },
  test: function(obj, key2, document2) {
    return { newDocument: document2, test: _areEquals(obj[key2], this.value) };
  },
  _get: function(obj, key2, document2) {
    this.value = obj[key2];
    return { newDocument: document2 };
  }
};
var arrOps = {
  add: function(arr, i, document2) {
    if (isInteger$1(i)) {
      arr.splice(i, 0, this.value);
    } else {
      arr[i] = this.value;
    }
    return { newDocument: document2, index: i };
  },
  remove: function(arr, i, document2) {
    var removedList = arr.splice(i, 1);
    return { newDocument: document2, removed: removedList[0] };
  },
  replace: function(arr, i, document2) {
    var removed = arr[i];
    arr[i] = this.value;
    return { newDocument: document2, removed };
  },
  move: objOps.move,
  copy: objOps.copy,
  test: objOps.test,
  _get: objOps._get
};
function getValueByPointer(document2, pointer) {
  if (pointer == "") {
    return document2;
  }
  var getOriginalDestination = { op: "_get", path: pointer };
  applyOperation(document2, getOriginalDestination);
  return getOriginalDestination.value;
}
function applyOperation(document2, operation, validateOperation, mutateDocument, banPrototypeModifications, index2) {
  if (validateOperation === void 0) {
    validateOperation = false;
  }
  if (mutateDocument === void 0) {
    mutateDocument = true;
  }
  if (banPrototypeModifications === void 0) {
    banPrototypeModifications = true;
  }
  if (index2 === void 0) {
    index2 = 0;
  }
  if (validateOperation) {
    if (typeof validateOperation == "function") {
      validateOperation(operation, 0, document2, operation.path);
    } else {
      validator(operation, 0);
    }
  }
  if (operation.path === "") {
    var returnValue = { newDocument: document2 };
    if (operation.op === "add") {
      returnValue.newDocument = operation.value;
      return returnValue;
    } else if (operation.op === "replace") {
      returnValue.newDocument = operation.value;
      returnValue.removed = document2;
      return returnValue;
    } else if (operation.op === "move" || operation.op === "copy") {
      returnValue.newDocument = getValueByPointer(document2, operation.from);
      if (operation.op === "move") {
        returnValue.removed = document2;
      }
      return returnValue;
    } else if (operation.op === "test") {
      returnValue.test = _areEquals(document2, operation.value);
      if (returnValue.test === false) {
        throw new JsonPatchError("Test operation failed", "TEST_OPERATION_FAILED", index2, operation, document2);
      }
      returnValue.newDocument = document2;
      return returnValue;
    } else if (operation.op === "remove") {
      returnValue.removed = document2;
      returnValue.newDocument = null;
      return returnValue;
    } else if (operation.op === "_get") {
      operation.value = document2;
      return returnValue;
    } else {
      if (validateOperation) {
        throw new JsonPatchError("Operation `op` property is not one of operations defined in RFC-6902", "OPERATION_OP_INVALID", index2, operation, document2);
      } else {
        return returnValue;
      }
    }
  } else {
    if (!mutateDocument) {
      document2 = _deepClone(document2);
    }
    var path2 = operation.path || "";
    var keys2 = path2.split("/");
    var obj = document2;
    var t = 1;
    var len = keys2.length;
    var existingPathFragment = void 0;
    var key2 = void 0;
    var validateFunction = void 0;
    if (typeof validateOperation == "function") {
      validateFunction = validateOperation;
    } else {
      validateFunction = validator;
    }
    while (true) {
      key2 = keys2[t];
      if (key2 && key2.indexOf("~") != -1) {
        key2 = unescapePathComponent(key2);
      }
      if (banPrototypeModifications && (key2 == "__proto__" || key2 == "prototype" && t > 0 && keys2[t - 1] == "constructor")) {
        throw new TypeError("JSON-Patch: modifying `__proto__` or `constructor/prototype` prop is banned for security reasons, if this was on purpose, please set `banPrototypeModifications` flag false and pass it to this function. More info in fast-json-patch README");
      }
      if (validateOperation) {
        if (existingPathFragment === void 0) {
          if (obj[key2] === void 0) {
            existingPathFragment = keys2.slice(0, t).join("/");
          } else if (t == len - 1) {
            existingPathFragment = operation.path;
          }
          if (existingPathFragment !== void 0) {
            validateFunction(operation, 0, document2, existingPathFragment);
          }
        }
      }
      t++;
      if (Array.isArray(obj)) {
        if (key2 === "-") {
          key2 = obj.length;
        } else {
          if (validateOperation && !isInteger$1(key2)) {
            throw new JsonPatchError("Expected an unsigned base-10 integer value, making the new referenced value the array element with the zero-based index", "OPERATION_PATH_ILLEGAL_ARRAY_INDEX", index2, operation, document2);
          } else if (isInteger$1(key2)) {
            key2 = ~~key2;
          }
        }
        if (t >= len) {
          if (validateOperation && operation.op === "add" && key2 > obj.length) {
            throw new JsonPatchError("The specified index MUST NOT be greater than the number of elements in the array", "OPERATION_VALUE_OUT_OF_BOUNDS", index2, operation, document2);
          }
          var returnValue = arrOps[operation.op].call(operation, obj, key2, document2);
          if (returnValue.test === false) {
            throw new JsonPatchError("Test operation failed", "TEST_OPERATION_FAILED", index2, operation, document2);
          }
          return returnValue;
        }
      } else {
        if (t >= len) {
          var returnValue = objOps[operation.op].call(operation, obj, key2, document2);
          if (returnValue.test === false) {
            throw new JsonPatchError("Test operation failed", "TEST_OPERATION_FAILED", index2, operation, document2);
          }
          return returnValue;
        }
      }
      obj = obj[key2];
      if (validateOperation && t < len && (!obj || typeof obj !== "object")) {
        throw new JsonPatchError("Cannot perform operation at the desired path", "OPERATION_PATH_UNRESOLVABLE", index2, operation, document2);
      }
    }
  }
}
function applyPatch(document2, patch2, validateOperation, mutateDocument, banPrototypeModifications) {
  if (mutateDocument === void 0) {
    mutateDocument = true;
  }
  if (banPrototypeModifications === void 0) {
    banPrototypeModifications = true;
  }
  if (validateOperation) {
    if (!Array.isArray(patch2)) {
      throw new JsonPatchError("Patch sequence must be an array", "SEQUENCE_NOT_AN_ARRAY");
    }
  }
  if (!mutateDocument) {
    document2 = _deepClone(document2);
  }
  var results = new Array(patch2.length);
  for (var i = 0, length_1 = patch2.length; i < length_1; i++) {
    results[i] = applyOperation(document2, patch2[i], validateOperation, true, banPrototypeModifications, i);
    document2 = results[i].newDocument;
  }
  results.newDocument = document2;
  return results;
}
function applyReducer(document2, operation, index2) {
  var operationResult = applyOperation(document2, operation);
  if (operationResult.test === false) {
    throw new JsonPatchError("Test operation failed", "TEST_OPERATION_FAILED", index2, operation, document2);
  }
  return operationResult.newDocument;
}
function validator(operation, index2, document2, existingPathFragment) {
  if (typeof operation !== "object" || operation === null || Array.isArray(operation)) {
    throw new JsonPatchError("Operation is not an object", "OPERATION_NOT_AN_OBJECT", index2, operation, document2);
  } else if (!objOps[operation.op]) {
    throw new JsonPatchError("Operation `op` property is not one of operations defined in RFC-6902", "OPERATION_OP_INVALID", index2, operation, document2);
  } else if (typeof operation.path !== "string") {
    throw new JsonPatchError("Operation `path` property is not a string", "OPERATION_PATH_INVALID", index2, operation, document2);
  } else if (operation.path.indexOf("/") !== 0 && operation.path.length > 0) {
    throw new JsonPatchError('Operation `path` property must start with "/"', "OPERATION_PATH_INVALID", index2, operation, document2);
  } else if ((operation.op === "move" || operation.op === "copy") && typeof operation.from !== "string") {
    throw new JsonPatchError("Operation `from` property is not present (applicable in `move` and `copy` operations)", "OPERATION_FROM_REQUIRED", index2, operation, document2);
  } else if ((operation.op === "add" || operation.op === "replace" || operation.op === "test") && operation.value === void 0) {
    throw new JsonPatchError("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)", "OPERATION_VALUE_REQUIRED", index2, operation, document2);
  } else if ((operation.op === "add" || operation.op === "replace" || operation.op === "test") && hasUndefined(operation.value)) {
    throw new JsonPatchError("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)", "OPERATION_VALUE_CANNOT_CONTAIN_UNDEFINED", index2, operation, document2);
  } else if (document2) {
    if (operation.op == "add") {
      var pathLen = operation.path.split("/").length;
      var existingPathLen = existingPathFragment.split("/").length;
      if (pathLen !== existingPathLen + 1 && pathLen !== existingPathLen) {
        throw new JsonPatchError("Cannot perform an `add` operation at the desired path", "OPERATION_PATH_CANNOT_ADD", index2, operation, document2);
      }
    } else if (operation.op === "replace" || operation.op === "remove" || operation.op === "_get") {
      if (operation.path !== existingPathFragment) {
        throw new JsonPatchError("Cannot perform the operation at a path that does not exist", "OPERATION_PATH_UNRESOLVABLE", index2, operation, document2);
      }
    } else if (operation.op === "move" || operation.op === "copy") {
      var existingValue = { op: "_get", path: operation.from, value: void 0 };
      var error2 = validate([existingValue], document2);
      if (error2 && error2.name === "OPERATION_PATH_UNRESOLVABLE") {
        throw new JsonPatchError("Cannot perform the operation from a path that does not exist", "OPERATION_FROM_UNRESOLVABLE", index2, operation, document2);
      }
    }
  }
}
function validate(sequence2, document2, externalValidator) {
  try {
    if (!Array.isArray(sequence2)) {
      throw new JsonPatchError("Patch sequence must be an array", "SEQUENCE_NOT_AN_ARRAY");
    }
    if (document2) {
      applyPatch(_deepClone(document2), _deepClone(sequence2), externalValidator || true);
    } else {
      externalValidator = externalValidator || validator;
      for (var i = 0; i < sequence2.length; i++) {
        externalValidator(sequence2[i], i, document2, void 0);
      }
    }
  } catch (e) {
    if (e instanceof JsonPatchError) {
      return e;
    } else {
      throw e;
    }
  }
}
function _areEquals(a2, b2) {
  if (a2 === b2)
    return true;
  if (a2 && b2 && typeof a2 == "object" && typeof b2 == "object") {
    var arrA = Array.isArray(a2), arrB = Array.isArray(b2), i, length2, key2;
    if (arrA && arrB) {
      length2 = a2.length;
      if (length2 != b2.length)
        return false;
      for (i = length2; i-- !== 0; )
        if (!_areEquals(a2[i], b2[i]))
          return false;
      return true;
    }
    if (arrA != arrB)
      return false;
    var keys2 = Object.keys(a2);
    length2 = keys2.length;
    if (length2 !== Object.keys(b2).length)
      return false;
    for (i = length2; i-- !== 0; )
      if (!b2.hasOwnProperty(keys2[i]))
        return false;
    for (i = length2; i-- !== 0; ) {
      key2 = keys2[i];
      if (!_areEquals(a2[key2], b2[key2]))
        return false;
    }
    return true;
  }
  return a2 !== a2 && b2 !== b2;
}
const core = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  JsonPatchError,
  _areEquals,
  applyOperation,
  applyPatch,
  applyReducer,
  deepClone,
  getValueByPointer,
  validate,
  validator
}, Symbol.toStringTag, { value: "Module" }));
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2021 Joachim Wester
 * MIT license
 */
var beforeDict = /* @__PURE__ */ new WeakMap();
var Mirror = (
  /** @class */
  /* @__PURE__ */ function() {
    function Mirror2(obj) {
      this.observers = /* @__PURE__ */ new Map();
      this.obj = obj;
    }
    return Mirror2;
  }()
);
var ObserverInfo = (
  /** @class */
  /* @__PURE__ */ function() {
    function ObserverInfo2(callback, observer) {
      this.callback = callback;
      this.observer = observer;
    }
    return ObserverInfo2;
  }()
);
function getMirror(obj) {
  return beforeDict.get(obj);
}
function getObserverFromMirror(mirror, callback) {
  return mirror.observers.get(callback);
}
function removeObserverFromMirror(mirror, observer) {
  mirror.observers.delete(observer.callback);
}
function unobserve(root, observer) {
  observer.unobserve();
}
function observe(obj, callback) {
  var patches = [];
  var observer;
  var mirror = getMirror(obj);
  if (!mirror) {
    mirror = new Mirror(obj);
    beforeDict.set(obj, mirror);
  } else {
    var observerInfo = getObserverFromMirror(mirror, callback);
    observer = observerInfo && observerInfo.observer;
  }
  if (observer) {
    return observer;
  }
  observer = {};
  mirror.value = _deepClone(obj);
  if (callback) {
    observer.callback = callback;
    observer.next = null;
    var dirtyCheck = function() {
      generate$1(observer);
    };
    var fastCheck = function() {
      clearTimeout(observer.next);
      observer.next = setTimeout(dirtyCheck);
    };
    if (typeof window !== "undefined") {
      window.addEventListener("mouseup", fastCheck);
      window.addEventListener("keyup", fastCheck);
      window.addEventListener("mousedown", fastCheck);
      window.addEventListener("keydown", fastCheck);
      window.addEventListener("change", fastCheck);
    }
  }
  observer.patches = patches;
  observer.object = obj;
  observer.unobserve = function() {
    generate$1(observer);
    clearTimeout(observer.next);
    removeObserverFromMirror(mirror, observer);
    if (typeof window !== "undefined") {
      window.removeEventListener("mouseup", fastCheck);
      window.removeEventListener("keyup", fastCheck);
      window.removeEventListener("mousedown", fastCheck);
      window.removeEventListener("keydown", fastCheck);
      window.removeEventListener("change", fastCheck);
    }
  };
  mirror.observers.set(callback, new ObserverInfo(callback, observer));
  return observer;
}
function generate$1(observer, invertible) {
  if (invertible === void 0) {
    invertible = false;
  }
  var mirror = beforeDict.get(observer.object);
  _generate(mirror.value, observer.object, observer.patches, "", invertible);
  if (observer.patches.length) {
    applyPatch(mirror.value, observer.patches);
  }
  var temp2 = observer.patches;
  if (temp2.length > 0) {
    observer.patches = [];
    if (observer.callback) {
      observer.callback(temp2);
    }
  }
  return temp2;
}
function _generate(mirror, obj, patches, path2, invertible) {
  if (obj === mirror) {
    return;
  }
  if (typeof obj.toJSON === "function") {
    obj = obj.toJSON();
  }
  var newKeys = _objectKeys(obj);
  var oldKeys = _objectKeys(mirror);
  var deleted = false;
  for (var t = oldKeys.length - 1; t >= 0; t--) {
    var key2 = oldKeys[t];
    var oldVal = mirror[key2];
    if (hasOwnProperty(obj, key2) && !(obj[key2] === void 0 && oldVal !== void 0 && Array.isArray(obj) === false)) {
      var newVal = obj[key2];
      if (typeof oldVal == "object" && oldVal != null && typeof newVal == "object" && newVal != null && Array.isArray(oldVal) === Array.isArray(newVal)) {
        _generate(oldVal, newVal, patches, path2 + "/" + escapePathComponent(key2), invertible);
      } else {
        if (oldVal !== newVal) {
          if (invertible) {
            patches.push({ op: "test", path: path2 + "/" + escapePathComponent(key2), value: _deepClone(oldVal) });
          }
          patches.push({ op: "replace", path: path2 + "/" + escapePathComponent(key2), value: _deepClone(newVal) });
        }
      }
    } else if (Array.isArray(mirror) === Array.isArray(obj)) {
      if (invertible) {
        patches.push({ op: "test", path: path2 + "/" + escapePathComponent(key2), value: _deepClone(oldVal) });
      }
      patches.push({ op: "remove", path: path2 + "/" + escapePathComponent(key2) });
      deleted = true;
    } else {
      if (invertible) {
        patches.push({ op: "test", path: path2, value: mirror });
      }
      patches.push({ op: "replace", path: path2, value: obj });
    }
  }
  if (!deleted && newKeys.length == oldKeys.length) {
    return;
  }
  for (var t = 0; t < newKeys.length; t++) {
    var key2 = newKeys[t];
    if (!hasOwnProperty(mirror, key2) && obj[key2] !== void 0) {
      patches.push({ op: "add", path: path2 + "/" + escapePathComponent(key2), value: _deepClone(obj[key2]) });
    }
  }
}
function compare$2(tree1, tree2, invertible) {
  if (invertible === void 0) {
    invertible = false;
  }
  var patches = [];
  _generate(tree1, tree2, patches, "", invertible);
  return patches;
}
const duplex = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  compare: compare$2,
  generate: generate$1,
  observe,
  unobserve
}, Symbol.toStringTag, { value: "Module" }));
Object.assign({}, core, duplex, {
  JsonPatchError: PatchError,
  deepClone: _deepClone,
  escapePathComponent,
  unescapePathComponent
});
function accessor(fn, fields, name) {
  fn.fields = fields || [];
  fn.fname = name;
  return fn;
}
function accessorName(fn) {
  return fn == null ? null : fn.fname;
}
function accessorFields(fn) {
  return fn == null ? null : fn.fields;
}
function getter$1(path2) {
  return path2.length === 1 ? get1(path2[0]) : getN(path2);
}
const get1 = (field2) => function(obj) {
  return obj[field2];
};
const getN = (path2) => {
  const len = path2.length;
  return function(obj) {
    for (let i = 0; i < len; ++i) {
      obj = obj[path2[i]];
    }
    return obj;
  };
};
function error(message) {
  throw Error(message);
}
function splitAccessPath(p) {
  const path2 = [], n = p.length;
  let q = null, b2 = 0, s = "", i, j, c2;
  p = p + "";
  function push() {
    path2.push(s + p.substring(i, j));
    s = "";
    i = j + 1;
  }
  for (i = j = 0; j < n; ++j) {
    c2 = p[j];
    if (c2 === "\\") {
      s += p.substring(i, j++);
      i = j;
    } else if (c2 === q) {
      push();
      q = null;
      b2 = -1;
    } else if (q) {
      continue;
    } else if (i === b2 && c2 === '"') {
      i = j + 1;
      q = c2;
    } else if (i === b2 && c2 === "'") {
      i = j + 1;
      q = c2;
    } else if (c2 === "." && !b2) {
      if (j > i) {
        push();
      } else {
        i = j + 1;
      }
    } else if (c2 === "[") {
      if (j > i)
        push();
      b2 = i = j + 1;
    } else if (c2 === "]") {
      if (!b2)
        error("Access path missing open bracket: " + p);
      if (b2 > 0)
        push();
      b2 = 0;
      i = j + 1;
    }
  }
  if (b2)
    error("Access path missing closing bracket: " + p);
  if (q)
    error("Access path missing closing quote: " + p);
  if (j > i) {
    j++;
    push();
  }
  return path2;
}
function field$1(field2, name, opt) {
  const path2 = splitAccessPath(field2);
  field2 = path2.length === 1 ? path2[0] : field2;
  return accessor((opt && opt.get || getter$1)(path2), [field2], name || field2);
}
const id = field$1("id");
const identity$1 = accessor((_) => _, [], "identity");
const zero$1 = accessor(() => 0, [], "zero");
const one$1 = accessor(() => 1, [], "one");
const truthy = accessor(() => true, [], "true");
const falsy = accessor(() => false, [], "false");
function log$1$1(method2, level, input) {
  const args = [level].concat([].slice.call(input));
  console[method2].apply(console, args);
}
const None$2 = 0;
const Error$1 = 1;
const Warn = 2;
const Info = 3;
const Debug = 4;
function logger(_, method2) {
  let handler = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : log$1$1;
  let level = _ || None$2;
  return {
    level(_2) {
      if (arguments.length) {
        level = +_2;
        return this;
      } else {
        return level;
      }
    },
    error() {
      if (level >= Error$1)
        handler(method2 || "error", "ERROR", arguments);
      return this;
    },
    warn() {
      if (level >= Warn)
        handler(method2 || "warn", "WARN", arguments);
      return this;
    },
    info() {
      if (level >= Info)
        handler(method2 || "log", "INFO", arguments);
      return this;
    },
    debug() {
      if (level >= Debug)
        handler(method2 || "log", "DEBUG", arguments);
      return this;
    }
  };
}
var isArray = Array.isArray;
function isObject(_) {
  return _ === Object(_);
}
const isLegalKey = (key2) => key2 !== "__proto__";
function mergeConfig() {
  for (var _len = arguments.length, configs = new Array(_len), _key = 0; _key < _len; _key++) {
    configs[_key] = arguments[_key];
  }
  return configs.reduce((out, source2) => {
    for (const key2 in source2) {
      if (key2 === "signals") {
        out.signals = mergeNamed(out.signals, source2.signals);
      } else {
        const r = key2 === "legend" ? {
          layout: 1
        } : key2 === "style" ? true : null;
        writeConfig(out, key2, source2[key2], r);
      }
    }
    return out;
  }, {});
}
function writeConfig(output2, key2, value2, recurse2) {
  if (!isLegalKey(key2))
    return;
  let k, o;
  if (isObject(value2) && !isArray(value2)) {
    o = isObject(output2[key2]) ? output2[key2] : output2[key2] = {};
    for (k in value2) {
      if (recurse2 && (recurse2 === true || recurse2[k])) {
        writeConfig(o, k, value2[k]);
      } else if (isLegalKey(k)) {
        o[k] = value2[k];
      }
    }
  } else {
    output2[key2] = value2;
  }
}
function mergeNamed(a2, b2) {
  if (a2 == null)
    return b2;
  const map2 = {}, out = [];
  function add2(_) {
    if (!map2[_.name]) {
      map2[_.name] = 1;
      out.push(_);
    }
  }
  b2.forEach(add2);
  a2.forEach(add2);
  return out;
}
function peek$2(array2) {
  return array2[array2.length - 1];
}
function toNumber(_) {
  return _ == null || _ === "" ? null : +_;
}
const exp$1 = (sign2) => (x2) => sign2 * Math.exp(x2);
const log$3 = (sign2) => (x2) => Math.log(sign2 * x2);
const symlog = (c2) => (x2) => Math.sign(x2) * Math.log1p(Math.abs(x2 / c2));
const symexp = (c2) => (x2) => Math.sign(x2) * Math.expm1(Math.abs(x2)) * c2;
const pow$1 = (exponent2) => (x2) => x2 < 0 ? -Math.pow(-x2, exponent2) : Math.pow(x2, exponent2);
function pan(domain2, delta, lift, ground) {
  const d0 = lift(domain2[0]), d1 = lift(peek$2(domain2)), dd = (d1 - d0) * delta;
  return [ground(d0 - dd), ground(d1 - dd)];
}
function panLinear(domain2, delta) {
  return pan(domain2, delta, toNumber, identity$1);
}
function panLog(domain2, delta) {
  var sign2 = Math.sign(domain2[0]);
  return pan(domain2, delta, log$3(sign2), exp$1(sign2));
}
function panPow(domain2, delta, exponent2) {
  return pan(domain2, delta, pow$1(exponent2), pow$1(1 / exponent2));
}
function panSymlog(domain2, delta, constant2) {
  return pan(domain2, delta, symlog(constant2), symexp(constant2));
}
function zoom(domain2, anchor, scale2, lift, ground) {
  const d0 = lift(domain2[0]), d1 = lift(peek$2(domain2)), da = anchor != null ? lift(anchor) : (d0 + d1) / 2;
  return [ground(da + (d0 - da) * scale2), ground(da + (d1 - da) * scale2)];
}
function zoomLinear(domain2, anchor, scale2) {
  return zoom(domain2, anchor, scale2, toNumber, identity$1);
}
function zoomLog(domain2, anchor, scale2) {
  const sign2 = Math.sign(domain2[0]);
  return zoom(domain2, anchor, scale2, log$3(sign2), exp$1(sign2));
}
function zoomPow(domain2, anchor, scale2, exponent2) {
  return zoom(domain2, anchor, scale2, pow$1(exponent2), pow$1(1 / exponent2));
}
function zoomSymlog(domain2, anchor, scale2, constant2) {
  return zoom(domain2, anchor, scale2, symlog(constant2), symexp(constant2));
}
function quarter(date2) {
  return 1 + ~~(new Date(date2).getMonth() / 3);
}
function utcquarter(date2) {
  return 1 + ~~(new Date(date2).getUTCMonth() / 3);
}
function array$3(_) {
  return _ != null ? isArray(_) ? _ : [_] : [];
}
function clampRange(range2, min2, max2) {
  let lo = range2[0], hi = range2[1], span2;
  if (hi < lo) {
    span2 = hi;
    hi = lo;
    lo = span2;
  }
  span2 = hi - lo;
  return span2 >= max2 - min2 ? [min2, max2] : [lo = Math.min(Math.max(lo, min2), max2 - span2), lo + span2];
}
function isFunction(_) {
  return typeof _ === "function";
}
const DESCENDING = "descending";
function compare$1(fields, orders, opt) {
  opt = opt || {};
  orders = array$3(orders) || [];
  const ord = [], get2 = [], fmap = {}, gen = opt.comparator || comparator;
  array$3(fields).forEach((f, i) => {
    if (f == null)
      return;
    ord.push(orders[i] === DESCENDING ? -1 : 1);
    get2.push(f = isFunction(f) ? f : field$1(f, null, opt));
    (accessorFields(f) || []).forEach((_) => fmap[_] = 1);
  });
  return get2.length === 0 ? null : accessor(gen(get2, ord), Object.keys(fmap));
}
const ascending$1 = (u2, v) => (u2 < v || u2 == null) && v != null ? -1 : (u2 > v || v == null) && u2 != null ? 1 : (v = v instanceof Date ? +v : v, u2 = u2 instanceof Date ? +u2 : u2) !== u2 && v === v ? -1 : v !== v && u2 === u2 ? 1 : 0;
const comparator = (fields, orders) => fields.length === 1 ? compare1(fields[0], orders[0]) : compareN(fields, orders, fields.length);
const compare1 = (field2, order) => function(a2, b2) {
  return ascending$1(field2(a2), field2(b2)) * order;
};
const compareN = (fields, orders, n) => {
  orders.push(0);
  return function(a2, b2) {
    let f, c2 = 0, i = -1;
    while (c2 === 0 && ++i < n) {
      f = fields[i];
      c2 = ascending$1(f(a2), f(b2));
    }
    return c2 * orders[i];
  };
};
function constant(_) {
  return isFunction(_) ? _ : () => _;
}
function debounce(delay, handler) {
  let tid;
  return (e) => {
    if (tid)
      clearTimeout(tid);
    tid = setTimeout(() => (handler(e), tid = null), delay);
  };
}
function extend(_) {
  for (let x2, k, i = 1, len = arguments.length; i < len; ++i) {
    x2 = arguments[i];
    for (k in x2) {
      _[k] = x2[k];
    }
  }
  return _;
}
function extent(array2, f) {
  let i = 0, n, v, min2, max2;
  if (array2 && (n = array2.length)) {
    if (f == null) {
      for (v = array2[i]; i < n && (v == null || v !== v); v = array2[++i])
        ;
      min2 = max2 = v;
      for (; i < n; ++i) {
        v = array2[i];
        if (v != null) {
          if (v < min2)
            min2 = v;
          if (v > max2)
            max2 = v;
        }
      }
    } else {
      for (v = f(array2[i]); i < n && (v == null || v !== v); v = f(array2[++i]))
        ;
      min2 = max2 = v;
      for (; i < n; ++i) {
        v = f(array2[i]);
        if (v != null) {
          if (v < min2)
            min2 = v;
          if (v > max2)
            max2 = v;
        }
      }
    }
  }
  return [min2, max2];
}
function extentIndex(array2, f) {
  const n = array2.length;
  let i = -1, a2, b2, c2, u2, v;
  if (f == null) {
    while (++i < n) {
      b2 = array2[i];
      if (b2 != null && b2 >= b2) {
        a2 = c2 = b2;
        break;
      }
    }
    if (i === n)
      return [-1, -1];
    u2 = v = i;
    while (++i < n) {
      b2 = array2[i];
      if (b2 != null) {
        if (a2 > b2) {
          a2 = b2;
          u2 = i;
        }
        if (c2 < b2) {
          c2 = b2;
          v = i;
        }
      }
    }
  } else {
    while (++i < n) {
      b2 = f(array2[i], i, array2);
      if (b2 != null && b2 >= b2) {
        a2 = c2 = b2;
        break;
      }
    }
    if (i === n)
      return [-1, -1];
    u2 = v = i;
    while (++i < n) {
      b2 = f(array2[i], i, array2);
      if (b2 != null) {
        if (a2 > b2) {
          a2 = b2;
          u2 = i;
        }
        if (c2 < b2) {
          c2 = b2;
          v = i;
        }
      }
    }
  }
  return [u2, v];
}
const hop = Object.prototype.hasOwnProperty;
function has$1(object2, property2) {
  return hop.call(object2, property2);
}
const NULL = {};
function fastmap(input) {
  let obj = {}, test2;
  function has$1$1(key2) {
    return has$1(obj, key2) && obj[key2] !== NULL;
  }
  const map2 = {
    size: 0,
    empty: 0,
    object: obj,
    has: has$1$1,
    get(key2) {
      return has$1$1(key2) ? obj[key2] : void 0;
    },
    set(key2, value2) {
      if (!has$1$1(key2)) {
        ++map2.size;
        if (obj[key2] === NULL)
          --map2.empty;
      }
      obj[key2] = value2;
      return this;
    },
    delete(key2) {
      if (has$1$1(key2)) {
        --map2.size;
        ++map2.empty;
        obj[key2] = NULL;
      }
      return this;
    },
    clear() {
      map2.size = map2.empty = 0;
      map2.object = obj = {};
    },
    test(_) {
      if (arguments.length) {
        test2 = _;
        return map2;
      } else {
        return test2;
      }
    },
    clean() {
      const next = {};
      let size = 0;
      for (const key2 in obj) {
        const value2 = obj[key2];
        if (value2 !== NULL && (!test2 || !test2(value2))) {
          next[key2] = value2;
          ++size;
        }
      }
      map2.size = size;
      map2.empty = 0;
      map2.object = obj = next;
    }
  };
  if (input)
    Object.keys(input).forEach((key2) => {
      map2.set(key2, input[key2]);
    });
  return map2;
}
function flush(range2, value2, threshold2, left, right, center) {
  if (!threshold2 && threshold2 !== 0)
    return center;
  const t = +threshold2;
  let a2 = range2[0], b2 = peek$2(range2), l;
  if (b2 < a2) {
    l = a2;
    a2 = b2;
    b2 = l;
  }
  l = Math.abs(value2 - a2);
  const r = Math.abs(b2 - value2);
  return l < r && l <= t ? left : r <= t ? right : center;
}
function inherits(child, parent, members) {
  const proto = child.prototype = Object.create(parent.prototype);
  Object.defineProperty(proto, "constructor", {
    value: child,
    writable: true,
    enumerable: true,
    configurable: true
  });
  return extend(proto, members);
}
function inrange(value2, range2, left, right) {
  let r0 = range2[0], r1 = range2[range2.length - 1], t;
  if (r0 > r1) {
    t = r0;
    r0 = r1;
    r1 = t;
  }
  left = left === void 0 || left;
  right = right === void 0 || right;
  return (left ? r0 <= value2 : r0 < value2) && (right ? value2 <= r1 : value2 < r1);
}
function isBoolean$1(_) {
  return typeof _ === "boolean";
}
function isDate$1(_) {
  return Object.prototype.toString.call(_) === "[object Date]";
}
function isIterable(_) {
  return _ && isFunction(_[Symbol.iterator]);
}
function isNumber$1(_) {
  return typeof _ === "number";
}
function isRegExp(_) {
  return Object.prototype.toString.call(_) === "[object RegExp]";
}
function isString(_) {
  return typeof _ === "string";
}
function key(fields, flat, opt) {
  if (fields) {
    fields = flat ? array$3(fields).map((f) => f.replace(/\\(.)/g, "$1")) : array$3(fields);
  }
  const len = fields && fields.length, gen = opt && opt.get || getter$1, map2 = (f) => gen(flat ? [f] : splitAccessPath(f));
  let fn;
  if (!len) {
    fn = function() {
      return "";
    };
  } else if (len === 1) {
    const get2 = map2(fields[0]);
    fn = function(_) {
      return "" + get2(_);
    };
  } else {
    const get2 = fields.map(map2);
    fn = function(_) {
      let s = "" + get2[0](_), i = 0;
      while (++i < len)
        s += "|" + get2[i](_);
      return s;
    };
  }
  return accessor(fn, fields, "key");
}
function lerp(array2, frac) {
  const lo = array2[0], hi = peek$2(array2), f = +frac;
  return !f ? lo : f === 1 ? hi : lo + f * (hi - lo);
}
const DEFAULT_MAX_SIZE = 1e4;
function lruCache(maxsize) {
  maxsize = +maxsize || DEFAULT_MAX_SIZE;
  let curr, prev, size;
  const clear = () => {
    curr = {};
    prev = {};
    size = 0;
  };
  const update2 = (key2, value2) => {
    if (++size > maxsize) {
      prev = curr;
      curr = {};
      size = 1;
    }
    return curr[key2] = value2;
  };
  clear();
  return {
    clear,
    has: (key2) => has$1(curr, key2) || has$1(prev, key2),
    get: (key2) => has$1(curr, key2) ? curr[key2] : has$1(prev, key2) ? update2(key2, prev[key2]) : void 0,
    set: (key2, value2) => has$1(curr, key2) ? curr[key2] = value2 : update2(key2, value2)
  };
}
function merge$3(compare2, array0, array1, output2) {
  const n0 = array0.length, n1 = array1.length;
  if (!n1)
    return array0;
  if (!n0)
    return array1;
  const merged = output2 || new array0.constructor(n0 + n1);
  let i0 = 0, i1 = 0, i = 0;
  for (; i0 < n0 && i1 < n1; ++i) {
    merged[i] = compare2(array0[i0], array1[i1]) > 0 ? array1[i1++] : array0[i0++];
  }
  for (; i0 < n0; ++i0, ++i) {
    merged[i] = array0[i0];
  }
  for (; i1 < n1; ++i1, ++i) {
    merged[i] = array1[i1];
  }
  return merged;
}
function repeat(str, reps) {
  let s = "";
  while (--reps >= 0)
    s += str;
  return s;
}
function pad(str, length2, padchar, align) {
  const c2 = padchar || " ", s = str + "", n = length2 - s.length;
  return n <= 0 ? s : align === "left" ? repeat(c2, n) + s : align === "center" ? repeat(c2, ~~(n / 2)) + s + repeat(c2, Math.ceil(n / 2)) : s + repeat(c2, n);
}
function span(array2) {
  return array2 && peek$2(array2) - array2[0] || 0;
}
function $(x2) {
  return isArray(x2) ? "[" + x2.map($) + "]" : isObject(x2) || isString(x2) ? (
    // Output valid JSON and JS source strings.
    // See http://timelessrepo.com/json-isnt-a-javascript-subset
    JSON.stringify(x2).replace("\u2028", "\\u2028").replace("\u2029", "\\u2029")
  ) : x2;
}
function toBoolean(_) {
  return _ == null || _ === "" ? null : !_ || _ === "false" || _ === "0" ? false : !!_;
}
const defaultParser = (_) => isNumber$1(_) ? _ : isDate$1(_) ? _ : Date.parse(_);
function toDate(_, parser2) {
  parser2 = parser2 || defaultParser;
  return _ == null || _ === "" ? null : parser2(_);
}
function toString(_) {
  return _ == null || _ === "" ? null : _ + "";
}
function toSet(_) {
  const s = {}, n = _.length;
  for (let i = 0; i < n; ++i)
    s[_[i]] = true;
  return s;
}
function truncate$1(str, length2, align, ellipsis) {
  const e = ellipsis != null ? ellipsis : "…", s = str + "", n = s.length, l = Math.max(0, length2 - e.length);
  return n <= length2 ? s : align === "left" ? e + s.slice(n - l) : align === "center" ? s.slice(0, Math.ceil(l / 2)) + e + s.slice(n - ~~(l / 2)) : s.slice(0, l) + e;
}
function visitArray(array2, filter2, visitor) {
  if (array2) {
    if (filter2) {
      const n = array2.length;
      for (let i = 0; i < n; ++i) {
        const t = filter2(array2[i]);
        if (t)
          visitor(t, i, array2);
      }
    } else {
      array2.forEach(visitor);
    }
  }
}
function identity(x2) {
  return x2;
}
function transform$3(transform2) {
  if (transform2 == null)
    return identity;
  var x02, y02, kx = transform2.scale[0], ky = transform2.scale[1], dx = transform2.translate[0], dy = transform2.translate[1];
  return function(input, i) {
    if (!i)
      x02 = y02 = 0;
    var j = 2, n = input.length, output2 = new Array(n);
    output2[0] = (x02 += input[0]) * kx + dx;
    output2[1] = (y02 += input[1]) * ky + dy;
    while (j < n)
      output2[j] = input[j], ++j;
    return output2;
  };
}
function reverse$2(array2, n) {
  var t, j = array2.length, i = j - n;
  while (i < --j)
    t = array2[i], array2[i++] = array2[j], array2[j] = t;
}
function feature(topology, o) {
  if (typeof o === "string")
    o = topology.objects[o];
  return o.type === "GeometryCollection" ? { type: "FeatureCollection", features: o.geometries.map(function(o2) {
    return feature$1(topology, o2);
  }) } : feature$1(topology, o);
}
function feature$1(topology, o) {
  var id2 = o.id, bbox = o.bbox, properties = o.properties == null ? {} : o.properties, geometry = object(topology, o);
  return id2 == null && bbox == null ? { type: "Feature", properties, geometry } : bbox == null ? { type: "Feature", id: id2, properties, geometry } : { type: "Feature", id: id2, bbox, properties, geometry };
}
function object(topology, o) {
  var transformPoint = transform$3(topology.transform), arcs = topology.arcs;
  function arc2(i, points2) {
    if (points2.length)
      points2.pop();
    for (var a2 = arcs[i < 0 ? ~i : i], k = 0, n = a2.length; k < n; ++k) {
      points2.push(transformPoint(a2[k], k));
    }
    if (i < 0)
      reverse$2(points2, n);
  }
  function point2(p) {
    return transformPoint(p);
  }
  function line2(arcs2) {
    var points2 = [];
    for (var i = 0, n = arcs2.length; i < n; ++i)
      arc2(arcs2[i], points2);
    if (points2.length < 2)
      points2.push(points2[0]);
    return points2;
  }
  function ring(arcs2) {
    var points2 = line2(arcs2);
    while (points2.length < 4)
      points2.push(points2[0]);
    return points2;
  }
  function polygon(arcs2) {
    return arcs2.map(ring);
  }
  function geometry(o2) {
    var type2 = o2.type, coordinates;
    switch (type2) {
      case "GeometryCollection":
        return { type: type2, geometries: o2.geometries.map(geometry) };
      case "Point":
        coordinates = point2(o2.coordinates);
        break;
      case "MultiPoint":
        coordinates = o2.coordinates.map(point2);
        break;
      case "LineString":
        coordinates = line2(o2.arcs);
        break;
      case "MultiLineString":
        coordinates = o2.arcs.map(line2);
        break;
      case "Polygon":
        coordinates = polygon(o2.arcs);
        break;
      case "MultiPolygon":
        coordinates = o2.arcs.map(polygon);
        break;
      default:
        return null;
    }
    return { type: type2, coordinates };
  }
  return geometry(o);
}
function stitch(topology, arcs) {
  var stitchedArcs = {}, fragmentByStart = {}, fragmentByEnd = {}, fragments = [], emptyIndex = -1;
  arcs.forEach(function(i, j) {
    var arc2 = topology.arcs[i < 0 ? ~i : i], t;
    if (arc2.length < 3 && !arc2[1][0] && !arc2[1][1]) {
      t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
    }
  });
  arcs.forEach(function(i) {
    var e = ends(i), start = e[0], end = e[1], f, g;
    if (f = fragmentByEnd[start]) {
      delete fragmentByEnd[f.end];
      f.push(i);
      f.end = end;
      if (g = fragmentByStart[end]) {
        delete fragmentByStart[g.start];
        var fg = g === f ? f : f.concat(g);
        fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g.end] = fg;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else if (f = fragmentByStart[end]) {
      delete fragmentByStart[f.start];
      f.unshift(i);
      f.start = start;
      if (g = fragmentByEnd[start]) {
        delete fragmentByEnd[g.end];
        var gf = g === f ? f : g.concat(f);
        fragmentByStart[gf.start = g.start] = fragmentByEnd[gf.end = f.end] = gf;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else {
      f = [i];
      fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
    }
  });
  function ends(i) {
    var arc2 = topology.arcs[i < 0 ? ~i : i], p02 = arc2[0], p1;
    if (topology.transform)
      p1 = [0, 0], arc2.forEach(function(dp) {
        p1[0] += dp[0], p1[1] += dp[1];
      });
    else
      p1 = arc2[arc2.length - 1];
    return i < 0 ? [p1, p02] : [p02, p1];
  }
  function flush2(fragmentByEnd2, fragmentByStart2) {
    for (var k in fragmentByEnd2) {
      var f = fragmentByEnd2[k];
      delete fragmentByStart2[f.start];
      delete f.start;
      delete f.end;
      f.forEach(function(i) {
        stitchedArcs[i < 0 ? ~i : i] = 1;
      });
      fragments.push(f);
    }
  }
  flush2(fragmentByEnd, fragmentByStart);
  flush2(fragmentByStart, fragmentByEnd);
  arcs.forEach(function(i) {
    if (!stitchedArcs[i < 0 ? ~i : i])
      fragments.push([i]);
  });
  return fragments;
}
function mesh(topology) {
  return object(topology, meshArcs.apply(this, arguments));
}
function meshArcs(topology, object2, filter2) {
  var arcs, i, n;
  if (arguments.length > 1)
    arcs = extractArcs(topology, object2, filter2);
  else
    for (i = 0, arcs = new Array(n = topology.arcs.length); i < n; ++i)
      arcs[i] = i;
  return { type: "MultiLineString", arcs: stitch(topology, arcs) };
}
function extractArcs(topology, object2, filter2) {
  var arcs = [], geomsByArc = [], geom;
  function extract0(i) {
    var j = i < 0 ? ~i : i;
    (geomsByArc[j] || (geomsByArc[j] = [])).push({ i, g: geom });
  }
  function extract1(arcs2) {
    arcs2.forEach(extract0);
  }
  function extract2(arcs2) {
    arcs2.forEach(extract1);
  }
  function extract3(arcs2) {
    arcs2.forEach(extract2);
  }
  function geometry(o) {
    switch (geom = o, o.type) {
      case "GeometryCollection":
        o.geometries.forEach(geometry);
        break;
      case "LineString":
        extract1(o.arcs);
        break;
      case "MultiLineString":
      case "Polygon":
        extract2(o.arcs);
        break;
      case "MultiPolygon":
        extract3(o.arcs);
        break;
    }
  }
  geometry(object2);
  geomsByArc.forEach(filter2 == null ? function(geoms) {
    arcs.push(geoms[0].i);
  } : function(geoms) {
    if (filter2(geoms[0].g, geoms[geoms.length - 1].g))
      arcs.push(geoms[0].i);
  });
  return arcs;
}
const YEAR = "year";
const QUARTER = "quarter";
const MONTH = "month";
const WEEK = "week";
const DATE = "date";
const DAY = "day";
const DAYOFYEAR = "dayofyear";
const HOURS = "hours";
const MINUTES = "minutes";
const SECONDS = "seconds";
const MILLISECONDS = "milliseconds";
const TIME_UNITS = [YEAR, QUARTER, MONTH, WEEK, DATE, DAY, DAYOFYEAR, HOURS, MINUTES, SECONDS, MILLISECONDS];
const UNITS = TIME_UNITS.reduce((o, u2, i) => (o[u2] = 1 + i, o), {});
function timeUnits(units) {
  const u2 = array$3(units).slice(), m2 = {};
  if (!u2.length)
    error("Missing time unit.");
  u2.forEach((unit2) => {
    if (has$1(UNITS, unit2)) {
      m2[unit2] = 1;
    } else {
      error(`Invalid time unit: ${unit2}.`);
    }
  });
  const numTypes = (m2[WEEK] || m2[DAY] ? 1 : 0) + (m2[QUARTER] || m2[MONTH] || m2[DATE] ? 1 : 0) + (m2[DAYOFYEAR] ? 1 : 0);
  if (numTypes > 1) {
    error(`Incompatible time units: ${units}`);
  }
  u2.sort((a2, b2) => UNITS[a2] - UNITS[b2]);
  return u2;
}
const defaultSpecifiers = {
  [YEAR]: "%Y ",
  [QUARTER]: "Q%q ",
  [MONTH]: "%b ",
  [DATE]: "%d ",
  [WEEK]: "W%U ",
  [DAY]: "%a ",
  [DAYOFYEAR]: "%j ",
  [HOURS]: "%H:00",
  [MINUTES]: "00:%M",
  [SECONDS]: ":%S",
  [MILLISECONDS]: ".%L",
  [`${YEAR}-${MONTH}`]: "%Y-%m ",
  [`${YEAR}-${MONTH}-${DATE}`]: "%Y-%m-%d ",
  [`${HOURS}-${MINUTES}`]: "%H:%M"
};
function timeUnitSpecifier(units, specifiers) {
  const s = extend({}, defaultSpecifiers, specifiers), u2 = timeUnits(units), n = u2.length;
  let fmt = "", start = 0, end, key2;
  for (start = 0; start < n; ) {
    for (end = u2.length; end > start; --end) {
      key2 = u2.slice(start, end).join("-");
      if (s[key2] != null) {
        fmt += s[key2];
        start = end;
        break;
      }
    }
  }
  return fmt.trim();
}
const t0 = /* @__PURE__ */ new Date();
function localYear(y2) {
  t0.setFullYear(y2);
  t0.setMonth(0);
  t0.setDate(1);
  t0.setHours(0, 0, 0, 0);
  return t0;
}
function dayofyear(d) {
  return localDayOfYear(new Date(d));
}
function week(d) {
  return localWeekNum(new Date(d));
}
function localDayOfYear(d) {
  return timeDay.count(localYear(d.getFullYear()) - 1, d);
}
function localWeekNum(d) {
  return timeSunday.count(localYear(d.getFullYear()) - 1, d);
}
function localFirst(y2) {
  return localYear(y2).getDay();
}
function localDate(y2, m2, d, H, M2, S, L) {
  if (0 <= y2 && y2 < 100) {
    const date2 = new Date(-1, m2, d, H, M2, S, L);
    date2.setFullYear(y2);
    return date2;
  }
  return new Date(y2, m2, d, H, M2, S, L);
}
function utcdayofyear(d) {
  return utcDayOfYear(new Date(d));
}
function utcweek(d) {
  return utcWeekNum(new Date(d));
}
function utcDayOfYear(d) {
  const y2 = Date.UTC(d.getUTCFullYear(), 0, 1);
  return utcDay.count(y2 - 1, d);
}
function utcWeekNum(d) {
  const y2 = Date.UTC(d.getUTCFullYear(), 0, 1);
  return utcSunday.count(y2 - 1, d);
}
function utcFirst(y2) {
  t0.setTime(Date.UTC(y2, 0, 1));
  return t0.getUTCDay();
}
function utcDate(y2, m2, d, H, M2, S, L) {
  if (0 <= y2 && y2 < 100) {
    const date2 = new Date(Date.UTC(-1, m2, d, H, M2, S, L));
    date2.setUTCFullYear(d.y);
    return date2;
  }
  return new Date(Date.UTC(y2, m2, d, H, M2, S, L));
}
function floor(units, step, get2, inv, newDate2) {
  const s = step || 1, b2 = peek$2(units), _ = (unit2, p, key2) => {
    key2 = key2 || unit2;
    return getUnit(get2[key2], inv[key2], unit2 === b2 && s, p);
  };
  const t = /* @__PURE__ */ new Date(), u2 = toSet(units), y2 = u2[YEAR] ? _(YEAR) : constant(2012), m2 = u2[MONTH] ? _(MONTH) : u2[QUARTER] ? _(QUARTER) : zero$1, d = u2[WEEK] && u2[DAY] ? _(DAY, 1, WEEK + DAY) : u2[WEEK] ? _(WEEK, 1) : u2[DAY] ? _(DAY, 1) : u2[DATE] ? _(DATE, 1) : u2[DAYOFYEAR] ? _(DAYOFYEAR, 1) : one$1, H = u2[HOURS] ? _(HOURS) : zero$1, M2 = u2[MINUTES] ? _(MINUTES) : zero$1, S = u2[SECONDS] ? _(SECONDS) : zero$1, L = u2[MILLISECONDS] ? _(MILLISECONDS) : zero$1;
  return function(v) {
    t.setTime(+v);
    const year = y2(t);
    return newDate2(year, m2(t), d(t, year), H(t), M2(t), S(t), L(t));
  };
}
function getUnit(f, inv, step, phase) {
  const u2 = step <= 1 ? f : phase ? (d, y2) => phase + step * Math.floor((f(d, y2) - phase) / step) : (d, y2) => step * Math.floor(f(d, y2) / step);
  return inv ? (d, y2) => inv(u2(d, y2), y2) : u2;
}
function weekday(week2, day, firstDay) {
  return day + week2 * 7 - (firstDay + 6) % 7;
}
const localGet = {
  [YEAR]: (d) => d.getFullYear(),
  [QUARTER]: (d) => Math.floor(d.getMonth() / 3),
  [MONTH]: (d) => d.getMonth(),
  [DATE]: (d) => d.getDate(),
  [HOURS]: (d) => d.getHours(),
  [MINUTES]: (d) => d.getMinutes(),
  [SECONDS]: (d) => d.getSeconds(),
  [MILLISECONDS]: (d) => d.getMilliseconds(),
  [DAYOFYEAR]: (d) => localDayOfYear(d),
  [WEEK]: (d) => localWeekNum(d),
  [WEEK + DAY]: (d, y2) => weekday(localWeekNum(d), d.getDay(), localFirst(y2)),
  [DAY]: (d, y2) => weekday(1, d.getDay(), localFirst(y2))
};
const localInv = {
  [QUARTER]: (q) => 3 * q,
  [WEEK]: (w2, y2) => weekday(w2, 0, localFirst(y2))
};
function timeFloor(units, step) {
  return floor(units, step || 1, localGet, localInv, localDate);
}
const utcGet = {
  [YEAR]: (d) => d.getUTCFullYear(),
  [QUARTER]: (d) => Math.floor(d.getUTCMonth() / 3),
  [MONTH]: (d) => d.getUTCMonth(),
  [DATE]: (d) => d.getUTCDate(),
  [HOURS]: (d) => d.getUTCHours(),
  [MINUTES]: (d) => d.getUTCMinutes(),
  [SECONDS]: (d) => d.getUTCSeconds(),
  [MILLISECONDS]: (d) => d.getUTCMilliseconds(),
  [DAYOFYEAR]: (d) => utcDayOfYear(d),
  [WEEK]: (d) => utcWeekNum(d),
  [DAY]: (d, y2) => weekday(1, d.getUTCDay(), utcFirst(y2)),
  [WEEK + DAY]: (d, y2) => weekday(utcWeekNum(d), d.getUTCDay(), utcFirst(y2))
};
const utcInv = {
  [QUARTER]: (q) => 3 * q,
  [WEEK]: (w2, y2) => weekday(w2, 0, utcFirst(y2))
};
function utcFloor(units, step) {
  return floor(units, step || 1, utcGet, utcInv, utcDate);
}
const timeIntervals = {
  [YEAR]: timeYear,
  [QUARTER]: timeMonth.every(3),
  [MONTH]: timeMonth,
  [WEEK]: timeSunday,
  [DATE]: timeDay,
  [DAY]: timeDay,
  [DAYOFYEAR]: timeDay,
  [HOURS]: timeHour,
  [MINUTES]: timeMinute,
  [SECONDS]: second,
  [MILLISECONDS]: millisecond
};
const utcIntervals = {
  [YEAR]: utcYear,
  [QUARTER]: utcMonth.every(3),
  [MONTH]: utcMonth,
  [WEEK]: utcSunday,
  [DATE]: utcDay,
  [DAY]: utcDay,
  [DAYOFYEAR]: utcDay,
  [HOURS]: utcHour,
  [MINUTES]: utcMinute,
  [SECONDS]: second,
  [MILLISECONDS]: millisecond
};
function timeInterval(unit2) {
  return timeIntervals[unit2];
}
function utcInterval(unit2) {
  return utcIntervals[unit2];
}
function offset$3(ival, date2, step) {
  return ival ? ival.offset(date2, step) : void 0;
}
function timeOffset(unit2, date2, step) {
  return offset$3(timeInterval(unit2), date2, step);
}
function utcOffset(unit2, date2, step) {
  return offset$3(utcInterval(unit2), date2, step);
}
function sequence$2(ival, start, stop2, step) {
  return ival ? ival.range(start, stop2, step) : void 0;
}
function timeSequence(unit2, start, stop2, step) {
  return sequence$2(timeInterval(unit2), start, stop2, step);
}
function utcSequence(unit2, start, stop2, step) {
  return sequence$2(utcInterval(unit2), start, stop2, step);
}
const durationSecond = 1e3, durationMinute = durationSecond * 60, durationHour = durationMinute * 60, durationDay = durationHour * 24, durationWeek = durationDay * 7, durationMonth = durationDay * 30, durationYear = durationDay * 365;
const Milli = [YEAR, MONTH, DATE, HOURS, MINUTES, SECONDS, MILLISECONDS], Seconds = Milli.slice(0, -1), Minutes = Seconds.slice(0, -1), Hours = Minutes.slice(0, -1), Day = Hours.slice(0, -1), Week = [YEAR, WEEK], Month = [YEAR, MONTH], Year = [YEAR];
const intervals = [[Seconds, 1, durationSecond], [Seconds, 5, 5 * durationSecond], [Seconds, 15, 15 * durationSecond], [Seconds, 30, 30 * durationSecond], [Minutes, 1, durationMinute], [Minutes, 5, 5 * durationMinute], [Minutes, 15, 15 * durationMinute], [Minutes, 30, 30 * durationMinute], [Hours, 1, durationHour], [Hours, 3, 3 * durationHour], [Hours, 6, 6 * durationHour], [Hours, 12, 12 * durationHour], [Day, 1, durationDay], [Week, 1, durationWeek], [Month, 1, durationMonth], [Month, 3, 3 * durationMonth], [Year, 1, durationYear]];
function bin$1(opt) {
  const ext = opt.extent, max2 = opt.maxbins || 40, target2 = Math.abs(span(ext)) / max2;
  let i = bisector((i2) => i2[2]).right(intervals, target2), units, step;
  if (i === intervals.length) {
    units = Year, step = tickStep(ext[0] / durationYear, ext[1] / durationYear, max2);
  } else if (i) {
    i = intervals[target2 / intervals[i - 1][2] < intervals[i][2] / target2 ? i - 1 : i];
    units = i[0];
    step = i[1];
  } else {
    units = Milli;
    step = Math.max(tickStep(ext[0], ext[1], max2), 1);
  }
  return {
    units,
    step
  };
}
function memoize(method2) {
  const cache2 = {};
  return (spec) => cache2[spec] || (cache2[spec] = method2(spec));
}
function trimZeroes(numberFormat, decimalChar) {
  return (x2) => {
    const str = numberFormat(x2), dec = str.indexOf(decimalChar);
    if (dec < 0)
      return str;
    let idx = rightmostDigit(str, dec);
    const end = idx < str.length ? str.slice(idx) : "";
    while (--idx > dec)
      if (str[idx] !== "0") {
        ++idx;
        break;
      }
    return str.slice(0, idx) + end;
  };
}
function rightmostDigit(str, dec) {
  let i = str.lastIndexOf("e"), c2;
  if (i > 0)
    return i;
  for (i = str.length; --i > dec; ) {
    c2 = str.charCodeAt(i);
    if (c2 >= 48 && c2 <= 57)
      return i + 1;
  }
}
function numberLocale(locale2) {
  const format2 = memoize(locale2.format), formatPrefix2 = locale2.formatPrefix;
  return {
    format: format2,
    formatPrefix: formatPrefix2,
    formatFloat(spec) {
      const s = formatSpecifier(spec || ",");
      if (s.precision == null) {
        s.precision = 12;
        switch (s.type) {
          case "%":
            s.precision -= 2;
            break;
          case "e":
            s.precision -= 1;
            break;
        }
        return trimZeroes(
          format2(s),
          // number format
          format2(".1f")(1)[1]
          // decimal point character
        );
      } else {
        return format2(s);
      }
    },
    formatSpan(start, stop2, count2, specifier) {
      specifier = formatSpecifier(specifier == null ? ",f" : specifier);
      const step = tickStep(start, stop2, count2), value2 = Math.max(Math.abs(start), Math.abs(stop2));
      let precision;
      if (specifier.precision == null) {
        switch (specifier.type) {
          case "s": {
            if (!isNaN(precision = precisionPrefix(step, value2))) {
              specifier.precision = precision;
            }
            return formatPrefix2(specifier, value2);
          }
          case "":
          case "e":
          case "g":
          case "p":
          case "r": {
            if (!isNaN(precision = precisionRound(step, value2))) {
              specifier.precision = precision - (specifier.type === "e");
            }
            break;
          }
          case "f":
          case "%": {
            if (!isNaN(precision = precisionFixed(step))) {
              specifier.precision = precision - (specifier.type === "%") * 2;
            }
            break;
          }
        }
      }
      return format2(specifier);
    }
  };
}
let defaultNumberLocale;
resetNumberFormatDefaultLocale();
function resetNumberFormatDefaultLocale() {
  return defaultNumberLocale = numberLocale({
    format: format$4,
    formatPrefix
  });
}
function numberFormatLocale(definition2) {
  return numberLocale(formatLocale$1(definition2));
}
function numberFormatDefaultLocale(definition2) {
  return arguments.length ? defaultNumberLocale = numberFormatLocale(definition2) : defaultNumberLocale;
}
function timeMultiFormat(format2, interval2, spec) {
  spec = spec || {};
  if (!isObject(spec)) {
    error(`Invalid time multi-format specifier: ${spec}`);
  }
  const second2 = interval2(SECONDS), minute = interval2(MINUTES), hour = interval2(HOURS), day = interval2(DATE), week2 = interval2(WEEK), month = interval2(MONTH), quarter2 = interval2(QUARTER), year = interval2(YEAR), L = format2(spec[MILLISECONDS] || ".%L"), S = format2(spec[SECONDS] || ":%S"), M2 = format2(spec[MINUTES] || "%I:%M"), H = format2(spec[HOURS] || "%I %p"), d = format2(spec[DATE] || spec[DAY] || "%a %d"), w2 = format2(spec[WEEK] || "%b %d"), m2 = format2(spec[MONTH] || "%B"), q = format2(spec[QUARTER] || "%B"), y2 = format2(spec[YEAR] || "%Y");
  return (date2) => (second2(date2) < date2 ? L : minute(date2) < date2 ? S : hour(date2) < date2 ? M2 : day(date2) < date2 ? H : month(date2) < date2 ? week2(date2) < date2 ? d : w2 : year(date2) < date2 ? quarter2(date2) < date2 ? m2 : q : y2)(date2);
}
function timeLocale(locale2) {
  const timeFormat2 = memoize(locale2.format), utcFormat2 = memoize(locale2.utcFormat);
  return {
    timeFormat: (spec) => isString(spec) ? timeFormat2(spec) : timeMultiFormat(timeFormat2, timeInterval, spec),
    utcFormat: (spec) => isString(spec) ? utcFormat2(spec) : timeMultiFormat(utcFormat2, utcInterval, spec),
    timeParse: memoize(locale2.parse),
    utcParse: memoize(locale2.utcParse)
  };
}
let defaultTimeLocale;
resetTimeFormatDefaultLocale();
function resetTimeFormatDefaultLocale() {
  return defaultTimeLocale = timeLocale({
    format: timeFormat$2,
    parse: timeParse$2,
    utcFormat: utcFormat$2,
    utcParse: utcParse$2
  });
}
function timeFormatLocale(definition2) {
  return timeLocale(formatLocale(definition2));
}
function timeFormatDefaultLocale(definition2) {
  return arguments.length ? defaultTimeLocale = timeFormatLocale(definition2) : defaultTimeLocale;
}
const createLocale = (number2, time2) => extend({}, number2, time2);
function locale(numberSpec, timeSpec) {
  const number2 = numberSpec ? numberFormatLocale(numberSpec) : numberFormatDefaultLocale();
  const time2 = timeSpec ? timeFormatLocale(timeSpec) : timeFormatDefaultLocale();
  return createLocale(number2, time2);
}
function defaultLocale(numberSpec, timeSpec) {
  const args = arguments.length;
  if (args && args !== 2) {
    error("defaultLocale expects either zero or two arguments.");
  }
  return args ? createLocale(numberFormatDefaultLocale(numberSpec), timeFormatDefaultLocale(timeSpec)) : createLocale(numberFormatDefaultLocale(), timeFormatDefaultLocale());
}
function resetDefaultLocale() {
  resetNumberFormatDefaultLocale();
  resetTimeFormatDefaultLocale();
  return defaultLocale();
}
const protocol_re = /^(data:|([A-Za-z]+:)?\/\/)/;
const allowed_re = /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp|file|data):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i;
const whitespace_re = /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205f\u3000]/g;
const fileProtocol = "file://";
function loaderFactory(fetch, fs) {
  return (options) => ({
    options: options || {},
    sanitize,
    load: load$1,
    fileAccess: !!fs,
    file: fileLoader(fs),
    http: httpLoader(fetch)
  });
}
async function load$1(uri, options) {
  const opt = await this.sanitize(uri, options), url = opt.href;
  return opt.localFile ? this.file(url) : this.http(url, options);
}
async function sanitize(uri, options) {
  options = extend({}, this.options, options);
  const fileAccess = this.fileAccess, result = {
    href: null
  };
  let isFile, loadFile, base2;
  const isAllowed = allowed_re.test(uri.replace(whitespace_re, ""));
  if (uri == null || typeof uri !== "string" || !isAllowed) {
    error("Sanitize failure, invalid URI: " + $(uri));
  }
  const hasProtocol = protocol_re.test(uri);
  if ((base2 = options.baseURL) && !hasProtocol) {
    if (!uri.startsWith("/") && !base2.endsWith("/")) {
      uri = "/" + uri;
    }
    uri = base2 + uri;
  }
  loadFile = (isFile = uri.startsWith(fileProtocol)) || options.mode === "file" || options.mode !== "http" && !hasProtocol && fileAccess;
  if (isFile) {
    uri = uri.slice(fileProtocol.length);
  } else if (uri.startsWith("//")) {
    if (options.defaultProtocol === "file") {
      uri = uri.slice(2);
      loadFile = true;
    } else {
      uri = (options.defaultProtocol || "http") + ":" + uri;
    }
  }
  Object.defineProperty(result, "localFile", {
    value: !!loadFile
  });
  result.href = uri;
  if (options.target) {
    result.target = options.target + "";
  }
  if (options.rel) {
    result.rel = options.rel + "";
  }
  if (options.context === "image" && options.crossOrigin) {
    result.crossOrigin = options.crossOrigin + "";
  }
  return result;
}
function fileLoader(fs) {
  return fs ? (filename) => new Promise((accept, reject) => {
    fs.readFile(filename, (error2, data2) => {
      if (error2)
        reject(error2);
      else
        accept(data2);
    });
  }) : fileReject;
}
async function fileReject() {
  error("No file system access.");
}
function httpLoader(fetch) {
  return fetch ? async function(url, options) {
    const opt = extend({}, this.options.http, options), type2 = options && options.response, response = await fetch(url, opt);
    return !response.ok ? error(response.status + "" + response.statusText) : isFunction(response[type2]) ? response[type2]() : response.text();
  } : httpReject;
}
async function httpReject() {
  error("No HTTP fetch method available.");
}
const isValid = (_) => _ != null && _ === _;
const isBoolean = (_) => _ === "true" || _ === "false" || _ === true || _ === false;
const isDate = (_) => !Number.isNaN(Date.parse(_));
const isNumber = (_) => !Number.isNaN(+_) && !(_ instanceof Date);
const isInteger = (_) => isNumber(_) && Number.isInteger(+_);
const typeParsers = {
  boolean: toBoolean,
  integer: toNumber,
  number: toNumber,
  date: toDate,
  string: toString,
  unknown: identity$1
};
const typeTests = [isBoolean, isInteger, isNumber, isDate];
const typeList = ["boolean", "integer", "number", "date"];
function inferType(values2, field2) {
  if (!values2 || !values2.length)
    return "unknown";
  const n = values2.length, m2 = typeTests.length, a2 = typeTests.map((_, i) => i + 1);
  for (let i = 0, t = 0, j, value2; i < n; ++i) {
    value2 = field2 ? values2[i][field2] : values2[i];
    for (j = 0; j < m2; ++j) {
      if (a2[j] && isValid(value2) && !typeTests[j](value2)) {
        a2[j] = 0;
        ++t;
        if (t === typeTests.length)
          return "string";
      }
    }
  }
  return typeList[a2.reduce((u2, v) => u2 === 0 ? v : u2, 0) - 1];
}
function inferTypes(data2, fields) {
  return fields.reduce((types, field2) => {
    types[field2] = inferType(data2, field2);
    return types;
  }, {});
}
function delimitedFormat(delimiter) {
  const parse2 = function(data2, format2) {
    const delim = {
      delimiter
    };
    return dsv(data2, format2 ? extend(format2, delim) : delim);
  };
  parse2.responseType = "text";
  return parse2;
}
function dsv(data2, format2) {
  if (format2.header) {
    data2 = format2.header.map($).join(format2.delimiter) + "\n" + data2;
  }
  return dsvFormat(format2.delimiter).parse(data2 + "");
}
dsv.responseType = "text";
function isBuffer(_) {
  return typeof Buffer === "function" && isFunction(Buffer.isBuffer) ? Buffer.isBuffer(_) : false;
}
function json(data2, format2) {
  const prop = format2 && format2.property ? field$1(format2.property) : identity$1;
  return isObject(data2) && !isBuffer(data2) ? parseJSON(prop(data2), format2) : prop(JSON.parse(data2));
}
json.responseType = "json";
function parseJSON(data2, format2) {
  if (!isArray(data2) && isIterable(data2)) {
    data2 = [...data2];
  }
  return format2 && format2.copy ? JSON.parse(JSON.stringify(data2)) : data2;
}
const filters = {
  interior: (a2, b2) => a2 !== b2,
  exterior: (a2, b2) => a2 === b2
};
function topojson(data2, format2) {
  let method2, object2, property2, filter2;
  data2 = json(data2, format2);
  if (format2 && format2.feature) {
    method2 = feature;
    property2 = format2.feature;
  } else if (format2 && format2.mesh) {
    method2 = mesh;
    property2 = format2.mesh;
    filter2 = filters[format2.filter];
  } else {
    error("Missing TopoJSON feature or mesh parameter.");
  }
  object2 = (object2 = data2.objects[property2]) ? method2(data2, object2, filter2) : error("Invalid TopoJSON object: " + property2);
  return object2 && object2.features || [object2];
}
topojson.responseType = "json";
const format$3 = {
  dsv,
  csv: delimitedFormat(","),
  tsv: delimitedFormat("	"),
  json,
  topojson
};
function formats$1(name, reader) {
  if (arguments.length > 1) {
    format$3[name] = reader;
    return this;
  } else {
    return has$1(format$3, name) ? format$3[name] : null;
  }
}
function responseType(type2) {
  const f = formats$1(type2);
  return f && f.responseType || "text";
}
function read(data2, schema, timeParser, utcParser) {
  schema = schema || {};
  const reader = formats$1(schema.type || "json");
  if (!reader)
    error("Unknown data format type: " + schema.type);
  data2 = reader(data2, schema);
  if (schema.parse)
    parse$6(data2, schema.parse, timeParser, utcParser);
  if (has$1(data2, "columns"))
    delete data2.columns;
  return data2;
}
function parse$6(data2, types, timeParser, utcParser) {
  if (!data2.length)
    return;
  const locale2 = timeFormatDefaultLocale();
  timeParser = timeParser || locale2.timeParse;
  utcParser = utcParser || locale2.utcParse;
  let fields = data2.columns || Object.keys(data2[0]), datum2, field2, i, j, n, m2;
  if (types === "auto")
    types = inferTypes(data2, fields);
  fields = Object.keys(types);
  const parsers = fields.map((field3) => {
    const type2 = types[field3];
    let parts, pattern;
    if (type2 && (type2.startsWith("date:") || type2.startsWith("utc:"))) {
      parts = type2.split(/:(.+)?/, 2);
      pattern = parts[1];
      if (pattern[0] === "'" && pattern[pattern.length - 1] === "'" || pattern[0] === '"' && pattern[pattern.length - 1] === '"') {
        pattern = pattern.slice(1, -1);
      }
      const parse2 = parts[0] === "utc" ? utcParser : timeParser;
      return parse2(pattern);
    }
    if (!typeParsers[type2]) {
      throw Error("Illegal format pattern: " + field3 + ":" + type2);
    }
    return typeParsers[type2];
  });
  for (i = 0, n = data2.length, m2 = fields.length; i < n; ++i) {
    datum2 = data2[i];
    for (j = 0; j < m2; ++j) {
      field2 = fields[j];
      datum2[field2] = parsers[j](datum2[field2]);
    }
  }
}
const loader = loaderFactory(require("node-fetch"), require("fs"));
function UniqueList(idFunc) {
  const $2 = idFunc || identity$1, list = [], ids = {};
  list.add = (_) => {
    const id2 = $2(_);
    if (!ids[id2]) {
      ids[id2] = 1;
      list.push(_);
    }
    return list;
  };
  list.remove = (_) => {
    const id2 = $2(_);
    if (ids[id2]) {
      ids[id2] = 0;
      const idx = list.indexOf(_);
      if (idx >= 0)
        list.splice(idx, 1);
    }
    return list;
  };
  return list;
}
async function asyncCallback(df, callback) {
  try {
    await callback(df);
  } catch (err) {
    df.error(err);
  }
}
const TUPLE_ID_KEY = Symbol("vega_id");
let TUPLE_ID = 1;
function isTuple(t) {
  return !!(t && tupleid(t));
}
function tupleid(t) {
  return t[TUPLE_ID_KEY];
}
function setid(t, id2) {
  t[TUPLE_ID_KEY] = id2;
  return t;
}
function ingest$1(datum2) {
  const t = datum2 === Object(datum2) ? datum2 : {
    data: datum2
  };
  return tupleid(t) ? t : setid(t, TUPLE_ID++);
}
function derive(t) {
  return rederive(t, ingest$1({}));
}
function rederive(t, d) {
  for (const k in t)
    d[k] = t[k];
  return d;
}
function replace$2(t, d) {
  return setid(d, tupleid(t));
}
function stableCompare(cmp, f) {
  return !cmp ? null : f ? (a2, b2) => cmp(a2, b2) || tupleid(f(a2)) - tupleid(f(b2)) : (a2, b2) => cmp(a2, b2) || tupleid(a2) - tupleid(b2);
}
function isChangeSet(v) {
  return v && v.constructor === changeset;
}
function changeset() {
  const add2 = [], rem2 = [], mod = [], remp = [], modp = [];
  let clean = null, reflow2 = false;
  return {
    constructor: changeset,
    insert(t) {
      const d = array$3(t), n = d.length;
      for (let i = 0; i < n; ++i)
        add2.push(d[i]);
      return this;
    },
    remove(t) {
      const a2 = isFunction(t) ? remp : rem2, d = array$3(t), n = d.length;
      for (let i = 0; i < n; ++i)
        a2.push(d[i]);
      return this;
    },
    modify(t, field2, value2) {
      const m2 = {
        field: field2,
        value: constant(value2)
      };
      if (isFunction(t)) {
        m2.filter = t;
        modp.push(m2);
      } else {
        m2.tuple = t;
        mod.push(m2);
      }
      return this;
    },
    encode(t, set2) {
      if (isFunction(t))
        modp.push({
          filter: t,
          field: set2
        });
      else
        mod.push({
          tuple: t,
          field: set2
        });
      return this;
    },
    clean(value2) {
      clean = value2;
      return this;
    },
    reflow() {
      reflow2 = true;
      return this;
    },
    pulse(pulse2, tuples) {
      const cur = {}, out = {};
      let i, n, m2, f, t, id2;
      for (i = 0, n = tuples.length; i < n; ++i) {
        cur[tupleid(tuples[i])] = 1;
      }
      for (i = 0, n = rem2.length; i < n; ++i) {
        t = rem2[i];
        cur[tupleid(t)] = -1;
      }
      for (i = 0, n = remp.length; i < n; ++i) {
        f = remp[i];
        tuples.forEach((t4) => {
          if (f(t4))
            cur[tupleid(t4)] = -1;
        });
      }
      for (i = 0, n = add2.length; i < n; ++i) {
        t = add2[i];
        id2 = tupleid(t);
        if (cur[id2]) {
          cur[id2] = 1;
        } else {
          pulse2.add.push(ingest$1(add2[i]));
        }
      }
      for (i = 0, n = tuples.length; i < n; ++i) {
        t = tuples[i];
        if (cur[tupleid(t)] < 0)
          pulse2.rem.push(t);
      }
      function modify2(t4, f2, v) {
        if (v) {
          t4[f2] = v(t4);
        } else {
          pulse2.encode = f2;
        }
        if (!reflow2)
          out[tupleid(t4)] = t4;
      }
      for (i = 0, n = mod.length; i < n; ++i) {
        m2 = mod[i];
        t = m2.tuple;
        f = m2.field;
        id2 = cur[tupleid(t)];
        if (id2 > 0) {
          modify2(t, f, m2.value);
          pulse2.modifies(f);
        }
      }
      for (i = 0, n = modp.length; i < n; ++i) {
        m2 = modp[i];
        f = m2.filter;
        tuples.forEach((t4) => {
          if (f(t4) && cur[tupleid(t4)] > 0) {
            modify2(t4, m2.field, m2.value);
          }
        });
        pulse2.modifies(m2.field);
      }
      if (reflow2) {
        pulse2.mod = rem2.length || remp.length ? tuples.filter((t4) => cur[tupleid(t4)] > 0) : tuples.slice();
      } else {
        for (id2 in out)
          pulse2.mod.push(out[id2]);
      }
      if (clean || clean == null && (rem2.length || remp.length)) {
        pulse2.clean(true);
      }
      return pulse2;
    }
  };
}
const CACHE = "_:mod:_";
function Parameters() {
  Object.defineProperty(this, CACHE, {
    writable: true,
    value: {}
  });
}
Parameters.prototype = {
  /**
   * Set a parameter value. If the parameter value changes, the parameter
   * will be recorded as modified.
   * @param {string} name - The parameter name.
   * @param {number} index - The index into an array-value parameter. Ignored if
   *   the argument is undefined, null or less than zero.
   * @param {*} value - The parameter value to set.
   * @param {boolean} [force=false] - If true, records the parameter as modified
   *   even if the value is unchanged.
   * @return {Parameters} - This parameter object.
   */
  set(name, index2, value2, force2) {
    const o = this, v = o[name], mod = o[CACHE];
    if (index2 != null && index2 >= 0) {
      if (v[index2] !== value2 || force2) {
        v[index2] = value2;
        mod[index2 + ":" + name] = -1;
        mod[name] = -1;
      }
    } else if (v !== value2 || force2) {
      o[name] = value2;
      mod[name] = isArray(value2) ? 1 + value2.length : -1;
    }
    return o;
  },
  /**
   * Tests if one or more parameters has been modified. If invoked with no
   * arguments, returns true if any parameter value has changed. If the first
   * argument is array, returns trues if any parameter name in the array has
   * changed. Otherwise, tests if the given name and optional array index has
   * changed.
   * @param {string} name - The parameter name to test.
   * @param {number} [index=undefined] - The parameter array index to test.
   * @return {boolean} - Returns true if a queried parameter was modified.
   */
  modified(name, index2) {
    const mod = this[CACHE];
    if (!arguments.length) {
      for (const k in mod) {
        if (mod[k])
          return true;
      }
      return false;
    } else if (isArray(name)) {
      for (let k = 0; k < name.length; ++k) {
        if (mod[name[k]])
          return true;
      }
      return false;
    }
    return index2 != null && index2 >= 0 ? index2 + 1 < mod[name] || !!mod[index2 + ":" + name] : !!mod[name];
  },
  /**
   * Clears the modification records. After calling this method,
   * all parameters are considered unmodified.
   */
  clear() {
    this[CACHE] = {};
    return this;
  }
};
let OP_ID = 0;
const PULSE = "pulse", NO_PARAMS = new Parameters();
const SKIP$1$1 = 1, MODIFIED = 2;
function Operator(init2, update2, params2, react) {
  this.id = ++OP_ID;
  this.value = init2;
  this.stamp = -1;
  this.rank = -1;
  this.qrank = -1;
  this.flags = 0;
  if (update2) {
    this._update = update2;
  }
  if (params2)
    this.parameters(params2, react);
}
function flag(bit) {
  return function(state) {
    const f = this.flags;
    if (arguments.length === 0)
      return !!(f & bit);
    this.flags = state ? f | bit : f & ~bit;
    return this;
  };
}
Operator.prototype = {
  /**
   * Returns a list of target operators dependent on this operator.
   * If this list does not exist, it is created and then returned.
   * @return {UniqueList}
   */
  targets() {
    return this._targets || (this._targets = UniqueList(id));
  },
  /**
   * Sets the value of this operator.
   * @param {*} value - the value to set.
   * @return {Number} Returns 1 if the operator value has changed
   *   according to strict equality, returns 0 otherwise.
   */
  set(value2) {
    if (this.value !== value2) {
      this.value = value2;
      return 1;
    } else {
      return 0;
    }
  },
  /**
   * Indicates that operator evaluation should be skipped on the next pulse.
   * This operator will still propagate incoming pulses, but its update function
   * will not be invoked. The skip flag is reset after every pulse, so calling
   * this method will affect processing of the next pulse only.
   */
  skip: flag(SKIP$1$1),
  /**
   * Indicates that this operator's value has been modified on its most recent
   * pulse. Normally modification is checked via strict equality; however, in
   * some cases it is more efficient to update the internal state of an object.
   * In those cases, the modified flag can be used to trigger propagation. Once
   * set, the modification flag persists across pulses until unset. The flag can
   * be used with the last timestamp to test if a modification is recent.
   */
  modified: flag(MODIFIED),
  /**
   * Sets the parameters for this operator. The parameter values are analyzed for
   * operator instances. If found, this operator will be added as a dependency
   * of the parameterizing operator. Operator values are dynamically marshalled
   * from each operator parameter prior to evaluation. If a parameter value is
   * an array, the array will also be searched for Operator instances. However,
   * the search does not recurse into sub-arrays or object properties.
   * @param {object} params - A hash of operator parameters.
   * @param {boolean} [react=true] - A flag indicating if this operator should
   *   automatically update (react) when parameter values change. In other words,
   *   this flag determines if the operator registers itself as a listener on
   *   any upstream operators included in the parameters.
   * @param {boolean} [initonly=false] - A flag indicating if this operator
   *   should calculate an update only upon its initial evaluation, then
   *   deregister dependencies and suppress all future update invocations.
   * @return {Operator[]} - An array of upstream dependencies.
   */
  parameters(params2, react, initonly) {
    react = react !== false;
    const argval = this._argval = this._argval || new Parameters(), argops = this._argops = this._argops || [], deps = [];
    let name, value2, n, i;
    const add2 = (name2, index2, value3) => {
      if (value3 instanceof Operator) {
        if (value3 !== this) {
          if (react)
            value3.targets().add(this);
          deps.push(value3);
        }
        argops.push({
          op: value3,
          name: name2,
          index: index2
        });
      } else {
        argval.set(name2, index2, value3);
      }
    };
    for (name in params2) {
      value2 = params2[name];
      if (name === PULSE) {
        array$3(value2).forEach((op) => {
          if (!(op instanceof Operator)) {
            error("Pulse parameters must be operator instances.");
          } else if (op !== this) {
            op.targets().add(this);
            deps.push(op);
          }
        });
        this.source = value2;
      } else if (isArray(value2)) {
        argval.set(name, -1, Array(n = value2.length));
        for (i = 0; i < n; ++i)
          add2(name, i, value2[i]);
      } else {
        add2(name, -1, value2);
      }
    }
    this.marshall().clear();
    if (initonly)
      argops.initonly = true;
    return deps;
  },
  /**
   * Internal method for marshalling parameter values.
   * Visits each operator dependency to pull the latest value.
   * @return {Parameters} A Parameters object to pass to the update function.
   */
  marshall(stamp) {
    const argval = this._argval || NO_PARAMS, argops = this._argops;
    let item, i, op, mod;
    if (argops) {
      const n = argops.length;
      for (i = 0; i < n; ++i) {
        item = argops[i];
        op = item.op;
        mod = op.modified() && op.stamp === stamp;
        argval.set(item.name, item.index, op.value, mod);
      }
      if (argops.initonly) {
        for (i = 0; i < n; ++i) {
          item = argops[i];
          item.op.targets().remove(this);
        }
        this._argops = null;
        this._update = null;
      }
    }
    return argval;
  },
  /**
   * Detach this operator from the dataflow.
   * Unregisters listeners on upstream dependencies.
   */
  detach() {
    const argops = this._argops;
    let i, n, item, op;
    if (argops) {
      for (i = 0, n = argops.length; i < n; ++i) {
        item = argops[i];
        op = item.op;
        if (op._targets) {
          op._targets.remove(this);
        }
      }
    }
    this.pulse = null;
    this.source = null;
  },
  /**
   * Delegate method to perform operator processing.
   * Subclasses can override this method to perform custom processing.
   * By default, it marshalls parameters and calls the update function
   * if that function is defined. If the update function does not
   * change the operator value then StopPropagation is returned.
   * If no update function is defined, this method does nothing.
   * @param {Pulse} pulse - the current dataflow pulse.
   * @return The output pulse or StopPropagation. A falsy return value
   *   (including undefined) will let the input pulse pass through.
   */
  evaluate(pulse2) {
    const update2 = this._update;
    if (update2) {
      const params2 = this.marshall(pulse2.stamp), v = update2.call(this, params2, pulse2);
      params2.clear();
      if (v !== this.value) {
        this.value = v;
      } else if (!this.modified()) {
        return pulse2.StopPropagation;
      }
    }
  },
  /**
   * Run this operator for the current pulse. If this operator has already
   * been run at (or after) the pulse timestamp, returns StopPropagation.
   * Internally, this method calls {@link evaluate} to perform processing.
   * If {@link evaluate} returns a falsy value, the input pulse is returned.
   * This method should NOT be overridden, instead overrride {@link evaluate}.
   * @param {Pulse} pulse - the current dataflow pulse.
   * @return the output pulse for this operator (or StopPropagation)
   */
  run(pulse2) {
    if (pulse2.stamp < this.stamp)
      return pulse2.StopPropagation;
    let rv;
    if (this.skip()) {
      this.skip(false);
      rv = 0;
    } else {
      rv = this.evaluate(pulse2);
    }
    return this.pulse = rv || pulse2;
  }
};
function add$2(init2, update2, params2, react) {
  let shift = 1, op;
  if (init2 instanceof Operator) {
    op = init2;
  } else if (init2 && init2.prototype instanceof Operator) {
    op = new init2();
  } else if (isFunction(init2)) {
    op = new Operator(null, init2);
  } else {
    shift = 0;
    op = new Operator(init2, update2);
  }
  this.rank(op);
  if (shift) {
    react = params2;
    params2 = update2;
  }
  if (params2)
    this.connect(op, op.parameters(params2, react));
  this.touch(op);
  return op;
}
function connect(target2, sources) {
  const targetRank = target2.rank, n = sources.length;
  for (let i = 0; i < n; ++i) {
    if (targetRank < sources[i].rank) {
      this.rerank(target2);
      return;
    }
  }
}
let STREAM_ID = 0;
function EventStream(filter2, apply2, receive) {
  this.id = ++STREAM_ID;
  this.value = null;
  if (receive)
    this.receive = receive;
  if (filter2)
    this._filter = filter2;
  if (apply2)
    this._apply = apply2;
}
function stream(filter2, apply2, receive) {
  return new EventStream(filter2, apply2, receive);
}
EventStream.prototype = {
  _filter: truthy,
  _apply: identity$1,
  targets() {
    return this._targets || (this._targets = UniqueList(id));
  },
  consume(_) {
    if (!arguments.length)
      return !!this._consume;
    this._consume = !!_;
    return this;
  },
  receive(evt) {
    if (this._filter(evt)) {
      const val = this.value = this._apply(evt), trg = this._targets, n = trg ? trg.length : 0;
      for (let i = 0; i < n; ++i)
        trg[i].receive(val);
      if (this._consume) {
        evt.preventDefault();
        evt.stopPropagation();
      }
    }
  },
  filter(filter2) {
    const s = stream(filter2);
    this.targets().add(s);
    return s;
  },
  apply(apply2) {
    const s = stream(null, apply2);
    this.targets().add(s);
    return s;
  },
  merge() {
    const s = stream();
    this.targets().add(s);
    for (let i = 0, n = arguments.length; i < n; ++i) {
      arguments[i].targets().add(s);
    }
    return s;
  },
  throttle(pause) {
    let t = -1;
    return this.filter(() => {
      const now2 = Date.now();
      if (now2 - t > pause) {
        t = now2;
        return 1;
      } else {
        return 0;
      }
    });
  },
  debounce(delay) {
    const s = stream();
    this.targets().add(stream(null, null, debounce(delay, (e) => {
      const df = e.dataflow;
      s.receive(e);
      if (df && df.run)
        df.run();
    })));
    return s;
  },
  between(a2, b2) {
    let active = false;
    a2.targets().add(stream(null, null, () => active = true));
    b2.targets().add(stream(null, null, () => active = false));
    return this.filter(() => active);
  },
  detach() {
    this._filter = truthy;
    this._targets = null;
  }
};
function events$1(source2, type2, filter2, apply2) {
  const df = this, s = stream(filter2, apply2), send = function(e) {
    e.dataflow = df;
    try {
      s.receive(e);
    } catch (error2) {
      df.error(error2);
    } finally {
      df.run();
    }
  };
  let sources;
  if (typeof source2 === "string" && typeof document !== "undefined") {
    sources = document.querySelectorAll(source2);
  } else {
    sources = array$3(source2);
  }
  const n = sources.length;
  for (let i = 0; i < n; ++i) {
    sources[i].addEventListener(type2, send);
  }
  return s;
}
function parse$5(data2, format2) {
  const locale2 = this.locale();
  return read(data2, format2, locale2.timeParse, locale2.utcParse);
}
function ingest(target2, data2, format2) {
  data2 = this.parse(data2, format2);
  return this.pulse(target2, this.changeset().insert(data2));
}
async function request(url, format2) {
  const df = this;
  let status = 0, data2;
  try {
    data2 = await df.loader().load(url, {
      context: "dataflow",
      response: responseType(format2 && format2.type)
    });
    try {
      data2 = df.parse(data2, format2);
    } catch (err) {
      status = -2;
      df.warn("Data ingestion failed", url, err);
    }
  } catch (err) {
    status = -1;
    df.warn("Loading failed", url, err);
  }
  return {
    data: data2,
    status
  };
}
async function preload(target2, url, format2) {
  const df = this, pending = df._pending || loadPending(df);
  pending.requests += 1;
  const res = await df.request(url, format2);
  df.pulse(target2, df.changeset().remove(truthy).insert(res.data || []));
  pending.done();
  return res;
}
function loadPending(df) {
  let accept;
  const pending = new Promise((a2) => accept = a2);
  pending.requests = 0;
  pending.done = () => {
    if (--pending.requests === 0) {
      df._pending = null;
      accept(df);
    }
  };
  return df._pending = pending;
}
const SKIP$2 = {
  skip: true
};
function on(source2, target2, update2, params2, options) {
  const fn = source2 instanceof Operator ? onOperator : onStream;
  fn(this, source2, target2, update2, params2, options);
  return this;
}
function onStream(df, stream2, target2, update2, params2, options) {
  const opt = extend({}, options, SKIP$2);
  let func, op;
  if (!isFunction(target2))
    target2 = constant(target2);
  if (update2 === void 0) {
    func = (e) => df.touch(target2(e));
  } else if (isFunction(update2)) {
    op = new Operator(null, update2, params2, false);
    func = (e) => {
      op.evaluate(e);
      const t = target2(e), v = op.value;
      isChangeSet(v) ? df.pulse(t, v, options) : df.update(t, v, opt);
    };
  } else {
    func = (e) => df.update(target2(e), update2, opt);
  }
  stream2.apply(func);
}
function onOperator(df, source2, target2, update2, params2, options) {
  if (update2 === void 0) {
    source2.targets().add(target2);
  } else {
    const opt = options || {}, op = new Operator(null, updater(target2, update2), params2, false);
    op.modified(opt.force);
    op.rank = source2.rank;
    source2.targets().add(op);
    if (target2) {
      op.skip(true);
      op.value = target2.value;
      op.targets().add(target2);
      df.connect(target2, [op]);
    }
  }
}
function updater(target2, update2) {
  update2 = isFunction(update2) ? update2 : constant(update2);
  return target2 ? function(_, pulse2) {
    const value2 = update2(_, pulse2);
    if (!target2.skip()) {
      target2.skip(value2 !== this.value).value = value2;
    }
    return value2;
  } : update2;
}
function rank(op) {
  op.rank = ++this._rank;
}
function rerank(op) {
  const queue = [op];
  let cur, list, i;
  while (queue.length) {
    this.rank(cur = queue.pop());
    if (list = cur._targets) {
      for (i = list.length; --i >= 0; ) {
        queue.push(cur = list[i]);
        if (cur === op)
          error("Cycle detected in dataflow graph.");
      }
    }
  }
}
const StopPropagation = {};
const ADD = 1 << 0, REM = 1 << 1, MOD$1 = 1 << 2, ADD_REM = ADD | REM, ADD_MOD = ADD | MOD$1, ALL = ADD | REM | MOD$1, REFLOW = 1 << 3, SOURCE = 1 << 4, NO_SOURCE = 1 << 5, NO_FIELDS = 1 << 6;
function Pulse(dataflow, stamp, encode2) {
  this.dataflow = dataflow;
  this.stamp = stamp == null ? -1 : stamp;
  this.add = [];
  this.rem = [];
  this.mod = [];
  this.fields = null;
  this.encode = encode2 || null;
}
function materialize(data2, filter2) {
  const out = [];
  visitArray(data2, filter2, (_) => out.push(_));
  return out;
}
function filter$2(pulse2, flags) {
  const map2 = {};
  pulse2.visit(flags, (t) => {
    map2[tupleid(t)] = 1;
  });
  return (t) => map2[tupleid(t)] ? null : t;
}
function addFilter(a2, b2) {
  return a2 ? (t, i) => a2(t, i) && b2(t, i) : b2;
}
Pulse.prototype = {
  /**
   * Sentinel value indicating pulse propagation should stop.
   */
  StopPropagation,
  /**
   * Boolean flag indicating ADD (added) tuples.
   */
  ADD,
  /**
   * Boolean flag indicating REM (removed) tuples.
   */
  REM,
  /**
   * Boolean flag indicating MOD (modified) tuples.
   */
  MOD: MOD$1,
  /**
   * Boolean flag indicating ADD (added) and REM (removed) tuples.
   */
  ADD_REM,
  /**
   * Boolean flag indicating ADD (added) and MOD (modified) tuples.
   */
  ADD_MOD,
  /**
   * Boolean flag indicating ADD, REM and MOD tuples.
   */
  ALL,
  /**
   * Boolean flag indicating all tuples in a data source
   * except for the ADD, REM and MOD tuples.
   */
  REFLOW,
  /**
   * Boolean flag indicating a 'pass-through' to a
   * backing data source, ignoring ADD, REM and MOD tuples.
   */
  SOURCE,
  /**
   * Boolean flag indicating that source data should be
   * suppressed when creating a forked pulse.
   */
  NO_SOURCE,
  /**
   * Boolean flag indicating that field modifications should be
   * suppressed when creating a forked pulse.
   */
  NO_FIELDS,
  /**
   * Creates a new pulse based on the values of this pulse.
   * The dataflow, time stamp and field modification values are copied over.
   * By default, new empty ADD, REM and MOD arrays are created.
   * @param {number} flags - Integer of boolean flags indicating which (if any)
   *   tuple arrays should be copied to the new pulse. The supported flag values
   *   are ADD, REM and MOD. Array references are copied directly: new array
   *   instances are not created.
   * @return {Pulse} - The forked pulse instance.
   * @see init
   */
  fork(flags) {
    return new Pulse(this.dataflow).init(this, flags);
  },
  /**
   * Creates a copy of this pulse with new materialized array
   * instances for the ADD, REM, MOD, and SOURCE arrays.
   * The dataflow, time stamp and field modification values are copied over.
   * @return {Pulse} - The cloned pulse instance.
   * @see init
   */
  clone() {
    const p = this.fork(ALL);
    p.add = p.add.slice();
    p.rem = p.rem.slice();
    p.mod = p.mod.slice();
    if (p.source)
      p.source = p.source.slice();
    return p.materialize(ALL | SOURCE);
  },
  /**
   * Returns a pulse that adds all tuples from a backing source. This is
   * useful for cases where operators are added to a dataflow after an
   * upstream data pipeline has already been processed, ensuring that
   * new operators can observe all tuples within a stream.
   * @return {Pulse} - A pulse instance with all source tuples included
   *   in the add array. If the current pulse already has all source
   *   tuples in its add array, it is returned directly. If the current
   *   pulse does not have a backing source, it is returned directly.
   */
  addAll() {
    let p = this;
    const reuse = !p.source || p.add === p.rem || !p.rem.length && p.source.length === p.add.length;
    if (reuse) {
      return p;
    } else {
      p = new Pulse(this.dataflow).init(this);
      p.add = p.source;
      p.rem = [];
      return p;
    }
  },
  /**
   * Initialize this pulse based on the values of another pulse. This method
   * is used internally by {@link fork} to initialize a new forked tuple.
   * The dataflow, time stamp and field modification values are copied over.
   * By default, new empty ADD, REM and MOD arrays are created.
   * @param {Pulse} src - The source pulse to copy from.
   * @param {number} flags - Integer of boolean flags indicating which (if any)
   *   tuple arrays should be copied to the new pulse. The supported flag values
   *   are ADD, REM and MOD. Array references are copied directly: new array
   *   instances are not created. By default, source data arrays are copied
   *   to the new pulse. Use the NO_SOURCE flag to enforce a null source.
   * @return {Pulse} - Returns this Pulse instance.
   */
  init(src, flags) {
    const p = this;
    p.stamp = src.stamp;
    p.encode = src.encode;
    if (src.fields && !(flags & NO_FIELDS)) {
      p.fields = src.fields;
    }
    if (flags & ADD) {
      p.addF = src.addF;
      p.add = src.add;
    } else {
      p.addF = null;
      p.add = [];
    }
    if (flags & REM) {
      p.remF = src.remF;
      p.rem = src.rem;
    } else {
      p.remF = null;
      p.rem = [];
    }
    if (flags & MOD$1) {
      p.modF = src.modF;
      p.mod = src.mod;
    } else {
      p.modF = null;
      p.mod = [];
    }
    if (flags & NO_SOURCE) {
      p.srcF = null;
      p.source = null;
    } else {
      p.srcF = src.srcF;
      p.source = src.source;
      if (src.cleans)
        p.cleans = src.cleans;
    }
    return p;
  },
  /**
   * Schedules a function to run after pulse propagation completes.
   * @param {function} func - The function to run.
   */
  runAfter(func) {
    this.dataflow.runAfter(func);
  },
  /**
   * Indicates if tuples have been added, removed or modified.
   * @param {number} [flags] - The tuple types (ADD, REM or MOD) to query.
   *   Defaults to ALL, returning true if any tuple type has changed.
   * @return {boolean} - Returns true if one or more queried tuple types have
   *   changed, false otherwise.
   */
  changed(flags) {
    const f = flags || ALL;
    return f & ADD && this.add.length || f & REM && this.rem.length || f & MOD$1 && this.mod.length;
  },
  /**
   * Forces a "reflow" of tuple values, such that all tuples in the backing
   * source are added to the MOD set, unless already present in the ADD set.
   * @param {boolean} [fork=false] - If true, returns a forked copy of this
   *   pulse, and invokes reflow on that derived pulse.
   * @return {Pulse} - The reflowed pulse instance.
   */
  reflow(fork) {
    if (fork)
      return this.fork(ALL).reflow();
    const len = this.add.length, src = this.source && this.source.length;
    if (src && src !== len) {
      this.mod = this.source;
      if (len)
        this.filter(MOD$1, filter$2(this, ADD));
    }
    return this;
  },
  /**
   * Get/set metadata to pulse requesting garbage collection
   * to reclaim currently unused resources.
   */
  clean(value2) {
    if (arguments.length) {
      this.cleans = !!value2;
      return this;
    } else {
      return this.cleans;
    }
  },
  /**
   * Marks one or more data field names as modified to assist dependency
   * tracking and incremental processing by transform operators.
   * @param {string|Array<string>} _ - The field(s) to mark as modified.
   * @return {Pulse} - This pulse instance.
   */
  modifies(_) {
    const hash = this.fields || (this.fields = {});
    if (isArray(_)) {
      _.forEach((f) => hash[f] = true);
    } else {
      hash[_] = true;
    }
    return this;
  },
  /**
   * Checks if one or more data fields have been modified during this pulse
   * propagation timestamp.
   * @param {string|Array<string>} _ - The field(s) to check for modified.
   * @param {boolean} nomod - If true, will check the modified flag even if
   *   no mod tuples exist. If false (default), mod tuples must be present.
   * @return {boolean} - Returns true if any of the provided fields has been
   *   marked as modified, false otherwise.
   */
  modified(_, nomod) {
    const fields = this.fields;
    return !((nomod || this.mod.length) && fields) ? false : !arguments.length ? !!fields : isArray(_) ? _.some((f) => fields[f]) : fields[_];
  },
  /**
   * Adds a filter function to one more tuple sets. Filters are applied to
   * backing tuple arrays, to determine the actual set of tuples considered
   * added, removed or modified. They can be used to delay materialization of
   * a tuple set in order to avoid expensive array copies. In addition, the
   * filter functions can serve as value transformers: unlike standard predicate
   * function (which return boolean values), Pulse filters should return the
   * actual tuple value to process. If a tuple set is already filtered, the
   * new filter function will be appended into a conjuntive ('and') query.
   * @param {number} flags - Flags indicating the tuple set(s) to filter.
   * @param {function(*):object} filter - Filter function that will be applied
   *   to the tuple set array, and should return a data tuple if the value
   *   should be included in the tuple set, and falsy (or null) otherwise.
   * @return {Pulse} - Returns this pulse instance.
   */
  filter(flags, filter2) {
    const p = this;
    if (flags & ADD)
      p.addF = addFilter(p.addF, filter2);
    if (flags & REM)
      p.remF = addFilter(p.remF, filter2);
    if (flags & MOD$1)
      p.modF = addFilter(p.modF, filter2);
    if (flags & SOURCE)
      p.srcF = addFilter(p.srcF, filter2);
    return p;
  },
  /**
   * Materialize one or more tuple sets in this pulse. If the tuple set(s) have
   * a registered filter function, it will be applied and the tuple set(s) will
   * be replaced with materialized tuple arrays.
   * @param {number} flags - Flags indicating the tuple set(s) to materialize.
   * @return {Pulse} - Returns this pulse instance.
   */
  materialize(flags) {
    flags = flags || ALL;
    const p = this;
    if (flags & ADD && p.addF) {
      p.add = materialize(p.add, p.addF);
      p.addF = null;
    }
    if (flags & REM && p.remF) {
      p.rem = materialize(p.rem, p.remF);
      p.remF = null;
    }
    if (flags & MOD$1 && p.modF) {
      p.mod = materialize(p.mod, p.modF);
      p.modF = null;
    }
    if (flags & SOURCE && p.srcF) {
      p.source = p.source.filter(p.srcF);
      p.srcF = null;
    }
    return p;
  },
  /**
   * Visit one or more tuple sets in this pulse.
   * @param {number} flags - Flags indicating the tuple set(s) to visit.
   *   Legal values are ADD, REM, MOD and SOURCE (if a backing data source
   *   has been set).
   * @param {function(object):*} - Visitor function invoked per-tuple.
   * @return {Pulse} - Returns this pulse instance.
   */
  visit(flags, visitor) {
    const p = this, v = visitor;
    if (flags & SOURCE) {
      visitArray(p.source, p.srcF, v);
      return p;
    }
    if (flags & ADD)
      visitArray(p.add, p.addF, v);
    if (flags & REM)
      visitArray(p.rem, p.remF, v);
    if (flags & MOD$1)
      visitArray(p.mod, p.modF, v);
    const src = p.source;
    if (flags & REFLOW && src) {
      const sum2 = p.add.length + p.mod.length;
      if (sum2 === src.length)
        ;
      else if (sum2) {
        visitArray(src, filter$2(p, ADD_MOD), v);
      } else {
        visitArray(src, p.srcF, v);
      }
    }
    return p;
  }
};
function MultiPulse(dataflow, stamp, pulses, encode2) {
  const p = this;
  let c2 = 0;
  this.dataflow = dataflow;
  this.stamp = stamp;
  this.fields = null;
  this.encode = encode2 || null;
  this.pulses = pulses;
  for (const pulse2 of pulses) {
    if (pulse2.stamp !== stamp)
      continue;
    if (pulse2.fields) {
      const hash = p.fields || (p.fields = {});
      for (const f in pulse2.fields) {
        hash[f] = 1;
      }
    }
    if (pulse2.changed(p.ADD))
      c2 |= p.ADD;
    if (pulse2.changed(p.REM))
      c2 |= p.REM;
    if (pulse2.changed(p.MOD))
      c2 |= p.MOD;
  }
  this.changes = c2;
}
inherits(MultiPulse, Pulse, {
  /**
   * Creates a new pulse based on the values of this pulse.
   * The dataflow, time stamp and field modification values are copied over.
   * @return {Pulse}
   */
  fork(flags) {
    const p = new Pulse(this.dataflow).init(this, flags & this.NO_FIELDS);
    if (flags !== void 0) {
      if (flags & p.ADD)
        this.visit(p.ADD, (t) => p.add.push(t));
      if (flags & p.REM)
        this.visit(p.REM, (t) => p.rem.push(t));
      if (flags & p.MOD)
        this.visit(p.MOD, (t) => p.mod.push(t));
    }
    return p;
  },
  changed(flags) {
    return this.changes & flags;
  },
  modified(_) {
    const p = this, fields = p.fields;
    return !(fields && p.changes & p.MOD) ? 0 : isArray(_) ? _.some((f) => fields[f]) : fields[_];
  },
  filter() {
    error("MultiPulse does not support filtering.");
  },
  materialize() {
    error("MultiPulse does not support materialization.");
  },
  visit(flags, visitor) {
    const p = this, pulses = p.pulses, n = pulses.length;
    let i = 0;
    if (flags & p.SOURCE) {
      for (; i < n; ++i) {
        pulses[i].visit(flags, visitor);
      }
    } else {
      for (; i < n; ++i) {
        if (pulses[i].stamp === p.stamp) {
          pulses[i].visit(flags, visitor);
        }
      }
    }
    return p;
  }
});
async function evaluate(encode2, prerun, postrun) {
  const df = this, async = [];
  if (df._pulse)
    return reentrant(df);
  if (df._pending)
    await df._pending;
  if (prerun)
    await asyncCallback(df, prerun);
  if (!df._touched.length) {
    df.debug("Dataflow invoked, but nothing to do.");
    return df;
  }
  const stamp = ++df._clock;
  df._pulse = new Pulse(df, stamp, encode2);
  df._touched.forEach((op2) => df._enqueue(op2, true));
  df._touched = UniqueList(id);
  let count2 = 0, op, next, error2;
  try {
    while (df._heap.size() > 0) {
      op = df._heap.pop();
      if (op.rank !== op.qrank) {
        df._enqueue(op, true);
        continue;
      }
      next = op.run(df._getPulse(op, encode2));
      if (next.then) {
        next = await next;
      } else if (next.async) {
        async.push(next.async);
        next = StopPropagation;
      }
      if (next !== StopPropagation) {
        if (op._targets)
          op._targets.forEach((op2) => df._enqueue(op2));
      }
      ++count2;
    }
  } catch (err) {
    df._heap.clear();
    error2 = err;
  }
  df._input = {};
  df._pulse = null;
  df.debug(`Pulse ${stamp}: ${count2} operators`);
  if (error2) {
    df._postrun = [];
    df.error(error2);
  }
  if (df._postrun.length) {
    const pr = df._postrun.sort((a2, b2) => b2.priority - a2.priority);
    df._postrun = [];
    for (let i = 0; i < pr.length; ++i) {
      await asyncCallback(df, pr[i].callback);
    }
  }
  if (postrun)
    await asyncCallback(df, postrun);
  if (async.length) {
    Promise.all(async).then((cb) => df.runAsync(null, () => {
      cb.forEach((f) => {
        try {
          f(df);
        } catch (err) {
          df.error(err);
        }
      });
    }));
  }
  return df;
}
async function runAsync(encode2, prerun, postrun) {
  while (this._running)
    await this._running;
  const clear = () => this._running = null;
  (this._running = this.evaluate(encode2, prerun, postrun)).then(clear, clear);
  return this._running;
}
function run(encode2, prerun, postrun) {
  return this._pulse ? reentrant(this) : (this.evaluate(encode2, prerun, postrun), this);
}
function runAfter(callback, enqueue2, priority) {
  if (this._pulse || enqueue2) {
    this._postrun.push({
      priority: priority || 0,
      callback
    });
  } else {
    try {
      callback(this);
    } catch (err) {
      this.error(err);
    }
  }
}
function reentrant(df) {
  df.error("Dataflow already running. Use runAsync() to chain invocations.");
  return df;
}
function enqueue(op, force2) {
  const q = op.stamp < this._clock;
  if (q)
    op.stamp = this._clock;
  if (q || force2) {
    op.qrank = op.rank;
    this._heap.push(op);
  }
}
function getPulse(op, encode2) {
  const s = op.source, stamp = this._clock;
  return s && isArray(s) ? new MultiPulse(this, stamp, s.map((_) => _.pulse), encode2) : this._input[op.id] || singlePulse(this._pulse, s && s.pulse);
}
function singlePulse(p, s) {
  if (s && s.stamp === p.stamp) {
    return s;
  }
  p = p.fork();
  if (s && s !== StopPropagation) {
    p.source = s.source;
  }
  return p;
}
const NO_OPT = {
  skip: false,
  force: false
};
function touch(op, options) {
  const opt = options || NO_OPT;
  if (this._pulse) {
    this._enqueue(op);
  } else {
    this._touched.add(op);
  }
  if (opt.skip)
    op.skip(true);
  return this;
}
function update$6(op, value2, options) {
  const opt = options || NO_OPT;
  if (op.set(value2) || opt.force) {
    this.touch(op, opt);
  }
  return this;
}
function pulse(op, changeset2, options) {
  this.touch(op, options || NO_OPT);
  const p = new Pulse(this, this._clock + (this._pulse ? 0 : 1)), t = op.pulse && op.pulse.source || [];
  p.target = op;
  this._input[op.id] = changeset2.pulse(p, t);
  return this;
}
function Heap(cmp) {
  let nodes = [];
  return {
    clear: () => nodes = [],
    size: () => nodes.length,
    peek: () => nodes[0],
    push: (x2) => {
      nodes.push(x2);
      return siftdown(nodes, 0, nodes.length - 1, cmp);
    },
    pop: () => {
      const last = nodes.pop();
      let item;
      if (nodes.length) {
        item = nodes[0];
        nodes[0] = last;
        siftup(nodes, 0, cmp);
      } else {
        item = last;
      }
      return item;
    }
  };
}
function siftdown(array2, start, idx, cmp) {
  let parent, pidx;
  const item = array2[idx];
  while (idx > start) {
    pidx = idx - 1 >> 1;
    parent = array2[pidx];
    if (cmp(item, parent) < 0) {
      array2[idx] = parent;
      idx = pidx;
      continue;
    }
    break;
  }
  return array2[idx] = item;
}
function siftup(array2, idx, cmp) {
  const start = idx, end = array2.length, item = array2[idx];
  let cidx = (idx << 1) + 1, ridx;
  while (cidx < end) {
    ridx = cidx + 1;
    if (ridx < end && cmp(array2[cidx], array2[ridx]) >= 0) {
      cidx = ridx;
    }
    array2[idx] = array2[cidx];
    idx = cidx;
    cidx = (idx << 1) + 1;
  }
  array2[idx] = item;
  return siftdown(array2, start, idx, cmp);
}
function Dataflow() {
  this.logger(logger());
  this.logLevel(Error$1);
  this._clock = 0;
  this._rank = 0;
  this._locale = defaultLocale();
  try {
    this._loader = loader();
  } catch (e) {
  }
  this._touched = UniqueList(id);
  this._input = {};
  this._pulse = null;
  this._heap = Heap((a2, b2) => a2.qrank - b2.qrank);
  this._postrun = [];
}
function logMethod(method2) {
  return function() {
    return this._log[method2].apply(this, arguments);
  };
}
Dataflow.prototype = {
  /**
   * The current timestamp of this dataflow. This value reflects the
   * timestamp of the previous dataflow run. The dataflow is initialized
   * with a stamp value of 0. The initial run of the dataflow will have
   * a timestap of 1, and so on. This value will match the
   * {@link Pulse.stamp} property.
   * @return {number} - The current timestamp value.
   */
  stamp() {
    return this._clock;
  },
  /**
   * Gets or sets the loader instance to use for data file loading. A
   * loader object must provide a "load" method for loading files and a
   * "sanitize" method for checking URL/filename validity. Both methods
   * should accept a URI and options hash as arguments, and return a Promise
   * that resolves to the loaded file contents (load) or a hash containing
   * sanitized URI data with the sanitized url assigned to the "href" property
   * (sanitize).
   * @param {object} _ - The loader instance to use.
   * @return {object|Dataflow} - If no arguments are provided, returns
   *   the current loader instance. Otherwise returns this Dataflow instance.
   */
  loader(_) {
    if (arguments.length) {
      this._loader = _;
      return this;
    } else {
      return this._loader;
    }
  },
  /**
   * Gets or sets the locale instance to use for formatting and parsing
   * string values. The locale object should be provided by the
   * vega-format library, and include methods such as format, timeFormat,
   * utcFormat, timeParse, and utcParse.
   * @param {object} _ - The locale instance to use.
   * @return {object|Dataflow} - If no arguments are provided, returns
   *   the current locale instance. Otherwise returns this Dataflow instance.
   */
  locale(_) {
    if (arguments.length) {
      this._locale = _;
      return this;
    } else {
      return this._locale;
    }
  },
  /**
   * Get or set the logger instance used to log messages. If no arguments are
   * provided, returns the current logger instance. Otherwise, sets the logger
   * and return this Dataflow instance. Provided loggers must support the full
   * API of logger objects generated by the vega-util logger method. Note that
   * by default the log level of the new logger will be used; use the logLevel
   * method to adjust the log level as needed.
   */
  logger(logger2) {
    if (arguments.length) {
      this._log = logger2;
      return this;
    } else {
      return this._log;
    }
  },
  /**
   * Logs an error message. By default, logged messages are written to console
   * output. The message will only be logged if the current log level is high
   * enough to permit error messages.
   */
  error: logMethod("error"),
  /**
   * Logs a warning message. By default, logged messages are written to console
   * output. The message will only be logged if the current log level is high
   * enough to permit warning messages.
   */
  warn: logMethod("warn"),
  /**
   * Logs a information message. By default, logged messages are written to
   * console output. The message will only be logged if the current log level is
   * high enough to permit information messages.
   */
  info: logMethod("info"),
  /**
   * Logs a debug message. By default, logged messages are written to console
   * output. The message will only be logged if the current log level is high
   * enough to permit debug messages.
   */
  debug: logMethod("debug"),
  /**
   * Get or set the current log level. If an argument is provided, it
   * will be used as the new log level.
   * @param {number} [level] - Should be one of None, Warn, Info
   * @return {number} - The current log level.
   */
  logLevel: logMethod("level"),
  /**
   * Empty entry threshold for garbage cleaning. Map data structures will
   * perform cleaning once the number of empty entries exceeds this value.
   */
  cleanThreshold: 1e4,
  // OPERATOR REGISTRATION
  add: add$2,
  connect,
  rank,
  rerank,
  // OPERATOR UPDATES
  pulse,
  touch,
  update: update$6,
  changeset,
  // DATA LOADING
  ingest,
  parse: parse$5,
  preload,
  request,
  // EVENT HANDLING
  events: events$1,
  on,
  // PULSE PROPAGATION
  evaluate,
  run,
  runAsync,
  runAfter,
  _enqueue: enqueue,
  _getPulse: getPulse
};
function Transform(init2, params2) {
  Operator.call(this, init2, null, params2);
}
inherits(Transform, Operator, {
  /**
   * Overrides {@link Operator.evaluate} for transform operators.
   * Internally, this method calls {@link evaluate} to perform processing.
   * If {@link evaluate} returns a falsy value, the input pulse is returned.
   * This method should NOT be overridden, instead overrride {@link evaluate}.
   * @param {Pulse} pulse - the current dataflow pulse.
   * @return the output pulse for this operator (or StopPropagation)
   */
  run(pulse2) {
    if (pulse2.stamp < this.stamp)
      return pulse2.StopPropagation;
    let rv;
    if (this.skip()) {
      this.skip(false);
    } else {
      rv = this.evaluate(pulse2);
    }
    rv = rv || pulse2;
    if (rv.then) {
      rv = rv.then((_) => this.pulse = _);
    } else if (rv !== pulse2.StopPropagation) {
      this.pulse = rv;
    }
    return rv;
  },
  /**
   * Overrides {@link Operator.evaluate} for transform operators.
   * Marshalls parameter values and then invokes {@link transform}.
   * @param {Pulse} pulse - the current dataflow pulse.
   * @return {Pulse} The output pulse (or StopPropagation). A falsy return
       value (including undefined) will let the input pulse pass through.
  */
  evaluate(pulse2) {
    const params2 = this.marshall(pulse2.stamp), out = this.transform(params2, pulse2);
    params2.clear();
    return out;
  },
  /**
   * Process incoming pulses.
   * Subclasses should override this method to implement transforms.
   * @param {Parameters} _ - The operator parameter values.
   * @param {Pulse} pulse - The current dataflow pulse.
   * @return {Pulse} The output pulse (or StopPropagation). A falsy return
   *   value (including undefined) will let the input pulse pass through.
   */
  transform() {
  }
});
const transforms = {};
function definition$1(type2) {
  const t = transform$2(type2);
  return t && t.Definition || null;
}
function transform$2(type2) {
  type2 = type2 && type2.toLowerCase();
  return has$1(transforms, type2) ? transforms[type2] : null;
}
function* numbers$1(values2, valueof) {
  if (valueof == null) {
    for (let value2 of values2) {
      if (value2 != null && value2 !== "" && (value2 = +value2) >= value2) {
        yield value2;
      }
    }
  } else {
    let index2 = -1;
    for (let value2 of values2) {
      value2 = valueof(value2, ++index2, values2);
      if (value2 != null && value2 !== "" && (value2 = +value2) >= value2) {
        yield value2;
      }
    }
  }
}
function quantiles(array2, p, f) {
  const values2 = Float64Array.from(numbers$1(array2, f));
  values2.sort(ascending$2);
  return p.map((_) => quantileSorted(values2, _));
}
function quartiles(array2, f) {
  return quantiles(array2, [0.25, 0.5, 0.75], f);
}
function estimateBandwidth(array2, f) {
  const n = array2.length, d = deviation(array2, f), q = quartiles(array2, f), h2 = (q[2] - q[0]) / 1.34, v = Math.min(d, h2) || d || Math.abs(q[0]) || 1;
  return 1.06 * v * Math.pow(n, -0.2);
}
function bin(_) {
  const maxb = _.maxbins || 20, base2 = _.base || 10, logb = Math.log(base2), div = _.divide || [5, 2];
  let min2 = _.extent[0], max2 = _.extent[1], step, level, minstep, v, i, n;
  const span2 = _.span || max2 - min2 || Math.abs(min2) || 1;
  if (_.step) {
    step = _.step;
  } else if (_.steps) {
    v = span2 / maxb;
    for (i = 0, n = _.steps.length; i < n && _.steps[i] < v; ++i)
      ;
    step = _.steps[Math.max(0, i - 1)];
  } else {
    level = Math.ceil(Math.log(maxb) / logb);
    minstep = _.minstep || 0;
    step = Math.max(minstep, Math.pow(base2, Math.round(Math.log(span2) / logb) - level));
    while (Math.ceil(span2 / step) > maxb) {
      step *= base2;
    }
    for (i = 0, n = div.length; i < n; ++i) {
      v = step / div[i];
      if (v >= minstep && span2 / v <= maxb)
        step = v;
    }
  }
  v = Math.log(step);
  const precision = v >= 0 ? 0 : ~~(-v / logb) + 1, eps = Math.pow(base2, -precision - 1);
  if (_.nice || _.nice === void 0) {
    v = Math.floor(min2 / step + eps) * step;
    min2 = min2 < v ? v - step : v;
    max2 = Math.ceil(max2 / step) * step;
  }
  return {
    start: min2,
    stop: max2 === min2 ? min2 + step : max2,
    step
  };
}
var random = Math.random;
function setRandom(r) {
  random = r;
}
function bootstrapCI(array2, samples, alpha, f) {
  if (!array2.length)
    return [void 0, void 0];
  const values2 = Float64Array.from(numbers$1(array2, f)), n = values2.length, m2 = samples;
  let a2, i, j, mu;
  for (j = 0, mu = Array(m2); j < m2; ++j) {
    for (a2 = 0, i = 0; i < n; ++i) {
      a2 += values2[~~(random() * n)];
    }
    mu[j] = a2 / n;
  }
  mu.sort(ascending$2);
  return [quantile$1(mu, alpha / 2), quantile$1(mu, 1 - alpha / 2)];
}
function dotbin(array2, step, smooth, f) {
  f = f || ((_) => _);
  const n = array2.length, v = new Float64Array(n);
  let i = 0, j = 1, a2 = f(array2[0]), b2 = a2, w2 = a2 + step, x2;
  for (; j < n; ++j) {
    x2 = f(array2[j]);
    if (x2 >= w2) {
      b2 = (a2 + b2) / 2;
      for (; i < j; ++i)
        v[i] = b2;
      w2 = x2 + step;
      a2 = x2;
    }
    b2 = x2;
  }
  b2 = (a2 + b2) / 2;
  for (; i < j; ++i)
    v[i] = b2;
  return smooth ? smoothing(v, step + step / 4) : v;
}
function smoothing(v, thresh) {
  const n = v.length;
  let a2 = 0, b2 = 1, c2, d;
  while (v[a2] === v[b2])
    ++b2;
  while (b2 < n) {
    c2 = b2 + 1;
    while (v[b2] === v[c2])
      ++c2;
    if (v[b2] - v[b2 - 1] < thresh) {
      d = b2 + (a2 + c2 - b2 - b2 >> 1);
      while (d < b2)
        v[d++] = v[b2];
      while (d > b2)
        v[d--] = v[a2];
    }
    a2 = b2;
    b2 = c2;
  }
  return v;
}
function lcg(seed) {
  return function() {
    seed = (1103515245 * seed + 12345) % 2147483647;
    return seed / 2147483647;
  };
}
function integer(min2, max2) {
  if (max2 == null) {
    max2 = min2;
    min2 = 0;
  }
  let a2, b2, d;
  const dist2 = {
    min(_) {
      if (arguments.length) {
        a2 = _ || 0;
        d = b2 - a2;
        return dist2;
      } else {
        return a2;
      }
    },
    max(_) {
      if (arguments.length) {
        b2 = _ || 0;
        d = b2 - a2;
        return dist2;
      } else {
        return b2;
      }
    },
    sample() {
      return a2 + Math.floor(d * random());
    },
    pdf(x2) {
      return x2 === Math.floor(x2) && x2 >= a2 && x2 < b2 ? 1 / d : 0;
    },
    cdf(x2) {
      const v = Math.floor(x2);
      return v < a2 ? 0 : v >= b2 ? 1 : (v - a2 + 1) / d;
    },
    icdf(p) {
      return p >= 0 && p <= 1 ? a2 - 1 + Math.floor(p * d) : NaN;
    }
  };
  return dist2.min(min2).max(max2);
}
const SQRT2PI = Math.sqrt(2 * Math.PI);
const SQRT2 = Math.SQRT2;
let nextSample = NaN;
function sampleNormal(mean2, stdev) {
  mean2 = mean2 || 0;
  stdev = stdev == null ? 1 : stdev;
  let x2 = 0, y2 = 0, rds, c2;
  if (nextSample === nextSample) {
    x2 = nextSample;
    nextSample = NaN;
  } else {
    do {
      x2 = random() * 2 - 1;
      y2 = random() * 2 - 1;
      rds = x2 * x2 + y2 * y2;
    } while (rds === 0 || rds > 1);
    c2 = Math.sqrt(-2 * Math.log(rds) / rds);
    x2 *= c2;
    nextSample = y2 * c2;
  }
  return mean2 + x2 * stdev;
}
function densityNormal(value2, mean2, stdev) {
  stdev = stdev == null ? 1 : stdev;
  const z = (value2 - (mean2 || 0)) / stdev;
  return Math.exp(-0.5 * z * z) / (stdev * SQRT2PI);
}
function cumulativeNormal(value2, mean2, stdev) {
  mean2 = mean2 || 0;
  stdev = stdev == null ? 1 : stdev;
  const z = (value2 - mean2) / stdev, Z = Math.abs(z);
  let cd;
  if (Z > 37) {
    cd = 0;
  } else {
    const exp2 = Math.exp(-Z * Z / 2);
    let sum2;
    if (Z < 7.07106781186547) {
      sum2 = 0.0352624965998911 * Z + 0.700383064443688;
      sum2 = sum2 * Z + 6.37396220353165;
      sum2 = sum2 * Z + 33.912866078383;
      sum2 = sum2 * Z + 112.079291497871;
      sum2 = sum2 * Z + 221.213596169931;
      sum2 = sum2 * Z + 220.206867912376;
      cd = exp2 * sum2;
      sum2 = 0.0883883476483184 * Z + 1.75566716318264;
      sum2 = sum2 * Z + 16.064177579207;
      sum2 = sum2 * Z + 86.7807322029461;
      sum2 = sum2 * Z + 296.564248779674;
      sum2 = sum2 * Z + 637.333633378831;
      sum2 = sum2 * Z + 793.826512519948;
      sum2 = sum2 * Z + 440.413735824752;
      cd = cd / sum2;
    } else {
      sum2 = Z + 0.65;
      sum2 = Z + 4 / sum2;
      sum2 = Z + 3 / sum2;
      sum2 = Z + 2 / sum2;
      sum2 = Z + 1 / sum2;
      cd = exp2 / sum2 / 2.506628274631;
    }
  }
  return z > 0 ? 1 - cd : cd;
}
function quantileNormal(p, mean2, stdev) {
  if (p < 0 || p > 1)
    return NaN;
  return (mean2 || 0) + (stdev == null ? 1 : stdev) * SQRT2 * erfinv(2 * p - 1);
}
function erfinv(x2) {
  let w2 = -Math.log((1 - x2) * (1 + x2)), p;
  if (w2 < 6.25) {
    w2 -= 3.125;
    p = -364441206401782e-35;
    p = -16850591381820166e-35 + p * w2;
    p = 128584807152564e-32 + p * w2;
    p = 11157877678025181e-33 + p * w2;
    p = -1333171662854621e-31 + p * w2;
    p = 20972767875968562e-33 + p * w2;
    p = 6637638134358324e-30 + p * w2;
    p = -4054566272975207e-29 + p * w2;
    p = -8151934197605472e-29 + p * w2;
    p = 26335093153082323e-28 + p * w2;
    p = -12975133253453532e-27 + p * w2;
    p = -5415412054294628e-26 + p * w2;
    p = 10512122733215323e-25 + p * w2;
    p = -4112633980346984e-24 + p * w2;
    p = -29070369957882005e-24 + p * w2;
    p = 42347877827932404e-23 + p * w2;
    p = -13654692000834679e-22 + p * w2;
    p = -13882523362786469e-21 + p * w2;
    p = 18673420803405714e-20 + p * w2;
    p = -740702534166267e-18 + p * w2;
    p = -0.006033670871430149 + p * w2;
    p = 0.24015818242558962 + p * w2;
    p = 1.6536545626831027 + p * w2;
  } else if (w2 < 16) {
    w2 = Math.sqrt(w2) - 3.25;
    p = 22137376921775787e-25;
    p = 9075656193888539e-23 + p * w2;
    p = -27517406297064545e-23 + p * w2;
    p = 18239629214389228e-24 + p * w2;
    p = 15027403968909828e-22 + p * w2;
    p = -4013867526981546e-21 + p * w2;
    p = 29234449089955446e-22 + p * w2;
    p = 12475304481671779e-21 + p * w2;
    p = -47318229009055734e-21 + p * w2;
    p = 6828485145957318e-20 + p * w2;
    p = 24031110387097894e-21 + p * w2;
    p = -3550375203628475e-19 + p * w2;
    p = 9532893797373805e-19 + p * w2;
    p = -0.0016882755560235047 + p * w2;
    p = 0.002491442096107851 + p * w2;
    p = -0.003751208507569241 + p * w2;
    p = 0.005370914553590064 + p * w2;
    p = 1.0052589676941592 + p * w2;
    p = 3.0838856104922208 + p * w2;
  } else if (Number.isFinite(w2)) {
    w2 = Math.sqrt(w2) - 5;
    p = -27109920616438573e-27;
    p = -2555641816996525e-25 + p * w2;
    p = 15076572693500548e-25 + p * w2;
    p = -3789465440126737e-24 + p * w2;
    p = 761570120807834e-23 + p * w2;
    p = -1496002662714924e-23 + p * w2;
    p = 2914795345090108e-23 + p * w2;
    p = -6771199775845234e-23 + p * w2;
    p = 22900482228026655e-23 + p * w2;
    p = -99298272942317e-20 + p * w2;
    p = 4526062597223154e-21 + p * w2;
    p = -1968177810553167e-20 + p * w2;
    p = 7599527703001776e-20 + p * w2;
    p = -21503011930044477e-20 + p * w2;
    p = -13871931833623122e-20 + p * w2;
    p = 1.0103004648645344 + p * w2;
    p = 4.849906401408584 + p * w2;
  } else {
    p = Infinity;
  }
  return p * x2;
}
function gaussian(mean2, stdev) {
  let mu, sigma;
  const dist2 = {
    mean(_) {
      if (arguments.length) {
        mu = _ || 0;
        return dist2;
      } else {
        return mu;
      }
    },
    stdev(_) {
      if (arguments.length) {
        sigma = _ == null ? 1 : _;
        return dist2;
      } else {
        return sigma;
      }
    },
    sample: () => sampleNormal(mu, sigma),
    pdf: (value2) => densityNormal(value2, mu, sigma),
    cdf: (value2) => cumulativeNormal(value2, mu, sigma),
    icdf: (p) => quantileNormal(p, mu, sigma)
  };
  return dist2.mean(mean2).stdev(stdev);
}
function kde(support, bandwidth2) {
  const kernel = gaussian();
  let n = 0;
  const dist2 = {
    data(_) {
      if (arguments.length) {
        support = _;
        n = _ ? _.length : 0;
        return dist2.bandwidth(bandwidth2);
      } else {
        return support;
      }
    },
    bandwidth(_) {
      if (!arguments.length)
        return bandwidth2;
      bandwidth2 = _;
      if (!bandwidth2 && support)
        bandwidth2 = estimateBandwidth(support);
      return dist2;
    },
    sample() {
      return support[~~(random() * n)] + bandwidth2 * kernel.sample();
    },
    pdf(x2) {
      let y2 = 0, i = 0;
      for (; i < n; ++i) {
        y2 += kernel.pdf((x2 - support[i]) / bandwidth2);
      }
      return y2 / bandwidth2 / n;
    },
    cdf(x2) {
      let y2 = 0, i = 0;
      for (; i < n; ++i) {
        y2 += kernel.cdf((x2 - support[i]) / bandwidth2);
      }
      return y2 / n;
    },
    icdf() {
      throw Error("KDE icdf not supported.");
    }
  };
  return dist2.data(support);
}
function sampleLogNormal(mean2, stdev) {
  mean2 = mean2 || 0;
  stdev = stdev == null ? 1 : stdev;
  return Math.exp(mean2 + sampleNormal() * stdev);
}
function densityLogNormal(value2, mean2, stdev) {
  if (value2 <= 0)
    return 0;
  mean2 = mean2 || 0;
  stdev = stdev == null ? 1 : stdev;
  const z = (Math.log(value2) - mean2) / stdev;
  return Math.exp(-0.5 * z * z) / (stdev * SQRT2PI * value2);
}
function cumulativeLogNormal(value2, mean2, stdev) {
  return cumulativeNormal(Math.log(value2), mean2, stdev);
}
function quantileLogNormal(p, mean2, stdev) {
  return Math.exp(quantileNormal(p, mean2, stdev));
}
function lognormal(mean2, stdev) {
  let mu, sigma;
  const dist2 = {
    mean(_) {
      if (arguments.length) {
        mu = _ || 0;
        return dist2;
      } else {
        return mu;
      }
    },
    stdev(_) {
      if (arguments.length) {
        sigma = _ == null ? 1 : _;
        return dist2;
      } else {
        return sigma;
      }
    },
    sample: () => sampleLogNormal(mu, sigma),
    pdf: (value2) => densityLogNormal(value2, mu, sigma),
    cdf: (value2) => cumulativeLogNormal(value2, mu, sigma),
    icdf: (p) => quantileLogNormal(p, mu, sigma)
  };
  return dist2.mean(mean2).stdev(stdev);
}
function mixture$1(dists, weights) {
  let m2 = 0, w2;
  function normalize2(x2) {
    const w3 = [];
    let sum2 = 0, i;
    for (i = 0; i < m2; ++i) {
      sum2 += w3[i] = x2[i] == null ? 1 : +x2[i];
    }
    for (i = 0; i < m2; ++i) {
      w3[i] /= sum2;
    }
    return w3;
  }
  const dist2 = {
    weights(_) {
      if (arguments.length) {
        w2 = normalize2(weights = _ || []);
        return dist2;
      }
      return weights;
    },
    distributions(_) {
      if (arguments.length) {
        if (_) {
          m2 = _.length;
          dists = _;
        } else {
          m2 = 0;
          dists = [];
        }
        return dist2.weights(weights);
      }
      return dists;
    },
    sample() {
      const r = random();
      let d = dists[m2 - 1], v = w2[0], i = 0;
      for (; i < m2 - 1; v += w2[++i]) {
        if (r < v) {
          d = dists[i];
          break;
        }
      }
      return d.sample();
    },
    pdf(x2) {
      let p = 0, i = 0;
      for (; i < m2; ++i) {
        p += w2[i] * dists[i].pdf(x2);
      }
      return p;
    },
    cdf(x2) {
      let p = 0, i = 0;
      for (; i < m2; ++i) {
        p += w2[i] * dists[i].cdf(x2);
      }
      return p;
    },
    icdf() {
      throw Error("Mixture icdf not supported.");
    }
  };
  return dist2.distributions(dists).weights(weights);
}
function sampleUniform(min2, max2) {
  if (max2 == null) {
    max2 = min2 == null ? 1 : min2;
    min2 = 0;
  }
  return min2 + (max2 - min2) * random();
}
function densityUniform(value2, min2, max2) {
  if (max2 == null) {
    max2 = min2 == null ? 1 : min2;
    min2 = 0;
  }
  return value2 >= min2 && value2 <= max2 ? 1 / (max2 - min2) : 0;
}
function cumulativeUniform(value2, min2, max2) {
  if (max2 == null) {
    max2 = min2 == null ? 1 : min2;
    min2 = 0;
  }
  return value2 < min2 ? 0 : value2 > max2 ? 1 : (value2 - min2) / (max2 - min2);
}
function quantileUniform(p, min2, max2) {
  if (max2 == null) {
    max2 = min2 == null ? 1 : min2;
    min2 = 0;
  }
  return p >= 0 && p <= 1 ? min2 + p * (max2 - min2) : NaN;
}
function uniform(min2, max2) {
  let a2, b2;
  const dist2 = {
    min(_) {
      if (arguments.length) {
        a2 = _ || 0;
        return dist2;
      } else {
        return a2;
      }
    },
    max(_) {
      if (arguments.length) {
        b2 = _ == null ? 1 : _;
        return dist2;
      } else {
        return b2;
      }
    },
    sample: () => sampleUniform(a2, b2),
    pdf: (value2) => densityUniform(value2, a2, b2),
    cdf: (value2) => cumulativeUniform(value2, a2, b2),
    icdf: (p) => quantileUniform(p, a2, b2)
  };
  if (max2 == null) {
    max2 = min2 == null ? 1 : min2;
    min2 = 0;
  }
  return dist2.min(min2).max(max2);
}
function ols(uX, uY, uXY, uX2) {
  const delta = uX2 - uX * uX, slope = Math.abs(delta) < 1e-24 ? 0 : (uXY - uX * uY) / delta, intercept = uY - slope * uX;
  return [intercept, slope];
}
function points(data2, x2, y2, sort2) {
  data2 = data2.filter((d2) => {
    let u2 = x2(d2), v = y2(d2);
    return u2 != null && (u2 = +u2) >= u2 && v != null && (v = +v) >= v;
  });
  if (sort2) {
    data2.sort((a2, b2) => x2(a2) - x2(b2));
  }
  const n = data2.length, X3 = new Float64Array(n), Y3 = new Float64Array(n);
  let i = 0, ux = 0, uy = 0, xv, yv, d;
  for (d of data2) {
    X3[i] = xv = +x2(d);
    Y3[i] = yv = +y2(d);
    ++i;
    ux += (xv - ux) / i;
    uy += (yv - uy) / i;
  }
  for (i = 0; i < n; ++i) {
    X3[i] -= ux;
    Y3[i] -= uy;
  }
  return [X3, Y3, ux, uy];
}
function visitPoints(data2, x2, y2, callback) {
  let i = -1, u2, v;
  for (const d of data2) {
    u2 = x2(d);
    v = y2(d);
    if (u2 != null && (u2 = +u2) >= u2 && v != null && (v = +v) >= v) {
      callback(u2, v, ++i);
    }
  }
}
function rSquared(data2, x2, y2, uY, predict) {
  let SSE = 0, SST = 0;
  visitPoints(data2, x2, y2, (dx, dy) => {
    const sse = dy - predict(dx), sst = dy - uY;
    SSE += sse * sse;
    SST += sst * sst;
  });
  return 1 - SSE / SST;
}
function linear(data2, x2, y2) {
  let X3 = 0, Y3 = 0, XY = 0, X22 = 0, n = 0;
  visitPoints(data2, x2, y2, (dx, dy) => {
    ++n;
    X3 += (dx - X3) / n;
    Y3 += (dy - Y3) / n;
    XY += (dx * dy - XY) / n;
    X22 += (dx * dx - X22) / n;
  });
  const coef = ols(X3, Y3, XY, X22), predict = (x3) => coef[0] + coef[1] * x3;
  return {
    coef,
    predict,
    rSquared: rSquared(data2, x2, y2, Y3, predict)
  };
}
function log$2(data2, x2, y2) {
  let X3 = 0, Y3 = 0, XY = 0, X22 = 0, n = 0;
  visitPoints(data2, x2, y2, (dx, dy) => {
    ++n;
    dx = Math.log(dx);
    X3 += (dx - X3) / n;
    Y3 += (dy - Y3) / n;
    XY += (dx * dy - XY) / n;
    X22 += (dx * dx - X22) / n;
  });
  const coef = ols(X3, Y3, XY, X22), predict = (x3) => coef[0] + coef[1] * Math.log(x3);
  return {
    coef,
    predict,
    rSquared: rSquared(data2, x2, y2, Y3, predict)
  };
}
function exp(data2, x2, y2) {
  const [xv, yv, ux, uy] = points(data2, x2, y2);
  let YL = 0, XY = 0, XYL = 0, X2Y = 0, n = 0, dx, ly2, xy;
  visitPoints(data2, x2, y2, (_, dy) => {
    dx = xv[n++];
    ly2 = Math.log(dy);
    xy = dx * dy;
    YL += (dy * ly2 - YL) / n;
    XY += (xy - XY) / n;
    XYL += (xy * ly2 - XYL) / n;
    X2Y += (dx * xy - X2Y) / n;
  });
  const [c0, c1] = ols(XY / uy, YL / uy, XYL / uy, X2Y / uy), predict = (x3) => Math.exp(c0 + c1 * (x3 - ux));
  return {
    coef: [Math.exp(c0 - c1 * ux), c1],
    predict,
    rSquared: rSquared(data2, x2, y2, uy, predict)
  };
}
function pow(data2, x2, y2) {
  let X3 = 0, Y3 = 0, XY = 0, X22 = 0, YS = 0, n = 0;
  visitPoints(data2, x2, y2, (dx, dy) => {
    const lx2 = Math.log(dx), ly2 = Math.log(dy);
    ++n;
    X3 += (lx2 - X3) / n;
    Y3 += (ly2 - Y3) / n;
    XY += (lx2 * ly2 - XY) / n;
    X22 += (lx2 * lx2 - X22) / n;
    YS += (dy - YS) / n;
  });
  const coef = ols(X3, Y3, XY, X22), predict = (x3) => coef[0] * Math.pow(x3, coef[1]);
  coef[0] = Math.exp(coef[0]);
  return {
    coef,
    predict,
    rSquared: rSquared(data2, x2, y2, YS, predict)
  };
}
function quad(data2, x2, y2) {
  const [xv, yv, ux, uy] = points(data2, x2, y2), n = xv.length;
  let X22 = 0, X3 = 0, X4 = 0, XY = 0, X2Y = 0, i, dx, dy, x22;
  for (i = 0; i < n; ) {
    dx = xv[i];
    dy = yv[i++];
    x22 = dx * dx;
    X22 += (x22 - X22) / i;
    X3 += (x22 * dx - X3) / i;
    X4 += (x22 * x22 - X4) / i;
    XY += (dx * dy - XY) / i;
    X2Y += (x22 * dy - X2Y) / i;
  }
  const X2X2 = X4 - X22 * X22, d = X22 * X2X2 - X3 * X3, a2 = (X2Y * X22 - XY * X3) / d, b2 = (XY * X2X2 - X2Y * X3) / d, c2 = -a2 * X22, predict = (x3) => {
    x3 = x3 - ux;
    return a2 * x3 * x3 + b2 * x3 + c2 + uy;
  };
  return {
    coef: [c2 - b2 * ux + a2 * ux * ux + uy, b2 - 2 * a2 * ux, a2],
    predict,
    rSquared: rSquared(data2, x2, y2, uy, predict)
  };
}
function poly(data2, x2, y2, order) {
  if (order === 1)
    return linear(data2, x2, y2);
  if (order === 2)
    return quad(data2, x2, y2);
  const [xv, yv, ux, uy] = points(data2, x2, y2), n = xv.length, lhs = [], rhs = [], k = order + 1;
  let i, j, l, v, c2;
  for (i = 0; i < k; ++i) {
    for (l = 0, v = 0; l < n; ++l) {
      v += Math.pow(xv[l], i) * yv[l];
    }
    lhs.push(v);
    c2 = new Float64Array(k);
    for (j = 0; j < k; ++j) {
      for (l = 0, v = 0; l < n; ++l) {
        v += Math.pow(xv[l], i + j);
      }
      c2[j] = v;
    }
    rhs.push(c2);
  }
  rhs.push(lhs);
  const coef = gaussianElimination(rhs), predict = (x3) => {
    x3 -= ux;
    let y3 = uy + coef[0] + coef[1] * x3 + coef[2] * x3 * x3;
    for (i = 3; i < k; ++i)
      y3 += coef[i] * Math.pow(x3, i);
    return y3;
  };
  return {
    coef: uncenter(k, coef, -ux, uy),
    predict,
    rSquared: rSquared(data2, x2, y2, uy, predict)
  };
}
function uncenter(k, a2, x2, y2) {
  const z = Array(k);
  let i, j, v, c2;
  for (i = 0; i < k; ++i)
    z[i] = 0;
  for (i = k - 1; i >= 0; --i) {
    v = a2[i];
    c2 = 1;
    z[i] += v;
    for (j = 1; j <= i; ++j) {
      c2 *= (i + 1 - j) / j;
      z[i - j] += v * Math.pow(x2, j) * c2;
    }
  }
  z[0] += y2;
  return z;
}
function gaussianElimination(matrix) {
  const n = matrix.length - 1, coef = [];
  let i, j, k, r, t;
  for (i = 0; i < n; ++i) {
    r = i;
    for (j = i + 1; j < n; ++j) {
      if (Math.abs(matrix[i][j]) > Math.abs(matrix[i][r])) {
        r = j;
      }
    }
    for (k = i; k < n + 1; ++k) {
      t = matrix[k][i];
      matrix[k][i] = matrix[k][r];
      matrix[k][r] = t;
    }
    for (j = i + 1; j < n; ++j) {
      for (k = n; k >= i; k--) {
        matrix[k][j] -= matrix[k][i] * matrix[i][j] / matrix[i][i];
      }
    }
  }
  for (j = n - 1; j >= 0; --j) {
    t = 0;
    for (k = j + 1; k < n; ++k) {
      t += matrix[k][j] * coef[k];
    }
    coef[j] = (matrix[n][j] - t) / matrix[j][j];
  }
  return coef;
}
const maxiters = 2, epsilon$1 = 1e-12;
function loess(data2, x2, y2, bandwidth2) {
  const [xv, yv, ux, uy] = points(data2, x2, y2, true), n = xv.length, bw = Math.max(2, ~~(bandwidth2 * n)), yhat = new Float64Array(n), residuals = new Float64Array(n), robustWeights = new Float64Array(n).fill(1);
  for (let iter = -1; ++iter <= maxiters; ) {
    const interval2 = [0, bw - 1];
    for (let i = 0; i < n; ++i) {
      const dx = xv[i], i0 = interval2[0], i1 = interval2[1], edge = dx - xv[i0] > xv[i1] - dx ? i0 : i1;
      let W = 0, X3 = 0, Y3 = 0, XY = 0, X22 = 0;
      const denom = 1 / Math.abs(xv[edge] - dx || 1);
      for (let k = i0; k <= i1; ++k) {
        const xk = xv[k], yk = yv[k], w2 = tricube(Math.abs(dx - xk) * denom) * robustWeights[k], xkw = xk * w2;
        W += w2;
        X3 += xkw;
        Y3 += yk * w2;
        XY += yk * xkw;
        X22 += xk * xkw;
      }
      const [a2, b2] = ols(X3 / W, Y3 / W, XY / W, X22 / W);
      yhat[i] = a2 + b2 * dx;
      residuals[i] = Math.abs(yv[i] - yhat[i]);
      updateInterval(xv, i + 1, interval2);
    }
    if (iter === maxiters) {
      break;
    }
    const medianResidual = median(residuals);
    if (Math.abs(medianResidual) < epsilon$1)
      break;
    for (let i = 0, arg, w2; i < n; ++i) {
      arg = residuals[i] / (6 * medianResidual);
      robustWeights[i] = arg >= 1 ? epsilon$1 : (w2 = 1 - arg * arg) * w2;
    }
  }
  return output$1(xv, yhat, ux, uy);
}
function tricube(x2) {
  return (x2 = 1 - x2 * x2 * x2) * x2 * x2;
}
function updateInterval(xv, i, interval2) {
  const val = xv[i];
  let left = interval2[0], right = interval2[1] + 1;
  if (right >= xv.length)
    return;
  while (i > left && xv[right] - val <= val - xv[left]) {
    interval2[0] = ++left;
    interval2[1] = right;
    ++right;
  }
}
function output$1(xv, yhat, ux, uy) {
  const n = xv.length, out = [];
  let i = 0, cnt = 0, prev = [], v;
  for (; i < n; ++i) {
    v = xv[i] + ux;
    if (prev[0] === v) {
      prev[1] += (yhat[i] - prev[1]) / ++cnt;
    } else {
      cnt = 0;
      prev[1] += uy;
      prev = [v, yhat[i]];
      out.push(prev);
    }
  }
  prev[1] += uy;
  return out;
}
const MIN_RADIANS = 0.5 * Math.PI / 180;
function sampleCurve(f, extent2, minSteps, maxSteps) {
  minSteps = minSteps || 25;
  maxSteps = Math.max(minSteps, maxSteps || 200);
  const point2 = (x2) => [x2, f(x2)], minX = extent2[0], maxX = extent2[1], span2 = maxX - minX, stop2 = span2 / maxSteps, prev = [point2(minX)], next = [];
  if (minSteps === maxSteps) {
    for (let i = 1; i < maxSteps; ++i) {
      prev.push(point2(minX + i / minSteps * span2));
    }
    prev.push(point2(maxX));
    return prev;
  } else {
    next.push(point2(maxX));
    for (let i = minSteps; --i > 0; ) {
      next.push(point2(minX + i / minSteps * span2));
    }
  }
  let p02 = prev[0];
  let p1 = next[next.length - 1];
  const sx = 1 / span2;
  const sy = scaleY(p02[1], next);
  while (p1) {
    const pm = point2((p02[0] + p1[0]) / 2);
    const dx = pm[0] - p02[0] >= stop2;
    if (dx && angleDelta(p02, pm, p1, sx, sy) > MIN_RADIANS) {
      next.push(pm);
    } else {
      p02 = p1;
      prev.push(p1);
      next.pop();
    }
    p1 = next[next.length - 1];
  }
  return prev;
}
function scaleY(init2, points2) {
  let ymin = init2;
  let ymax = init2;
  const n = points2.length;
  for (let i = 0; i < n; ++i) {
    const y2 = points2[i][1];
    if (y2 < ymin)
      ymin = y2;
    if (y2 > ymax)
      ymax = y2;
  }
  return 1 / (ymax - ymin);
}
function angleDelta(p, q, r, sx, sy) {
  const a0 = Math.atan2(sy * (r[1] - p[1]), sx * (r[0] - p[0])), a1 = Math.atan2(sy * (q[1] - p[1]), sx * (q[0] - p[0]));
  return Math.abs(a0 - a1);
}
function multikey(f) {
  return (x2) => {
    const n = f.length;
    let i = 1, k = String(f[0](x2));
    for (; i < n; ++i) {
      k += "|" + f[i](x2);
    }
    return k;
  };
}
function groupkey(fields) {
  return !fields || !fields.length ? function() {
    return "";
  } : fields.length === 1 ? fields[0] : multikey(fields);
}
function measureName(op, field2, as) {
  return as || op + (!field2 ? "" : "_" + field2);
}
const noop$1 = () => {
};
const base_op = {
  init: noop$1,
  add: noop$1,
  rem: noop$1,
  idx: 0
};
const AggregateOps = {
  values: {
    init: (m2) => m2.cell.store = true,
    value: (m2) => m2.cell.data.values(),
    idx: -1
  },
  count: {
    value: (m2) => m2.cell.num
  },
  __count__: {
    value: (m2) => m2.missing + m2.valid
  },
  missing: {
    value: (m2) => m2.missing
  },
  valid: {
    value: (m2) => m2.valid
  },
  sum: {
    init: (m2) => m2.sum = 0,
    value: (m2) => m2.sum,
    add: (m2, v) => m2.sum += +v,
    rem: (m2, v) => m2.sum -= v
  },
  product: {
    init: (m2) => m2.product = 1,
    value: (m2) => m2.valid ? m2.product : void 0,
    add: (m2, v) => m2.product *= v,
    rem: (m2, v) => m2.product /= v
  },
  mean: {
    init: (m2) => m2.mean = 0,
    value: (m2) => m2.valid ? m2.mean : void 0,
    add: (m2, v) => (m2.mean_d = v - m2.mean, m2.mean += m2.mean_d / m2.valid),
    rem: (m2, v) => (m2.mean_d = v - m2.mean, m2.mean -= m2.valid ? m2.mean_d / m2.valid : m2.mean)
  },
  average: {
    value: (m2) => m2.valid ? m2.mean : void 0,
    req: ["mean"],
    idx: 1
  },
  variance: {
    init: (m2) => m2.dev = 0,
    value: (m2) => m2.valid > 1 ? m2.dev / (m2.valid - 1) : void 0,
    add: (m2, v) => m2.dev += m2.mean_d * (v - m2.mean),
    rem: (m2, v) => m2.dev -= m2.mean_d * (v - m2.mean),
    req: ["mean"],
    idx: 1
  },
  variancep: {
    value: (m2) => m2.valid > 1 ? m2.dev / m2.valid : void 0,
    req: ["variance"],
    idx: 2
  },
  stdev: {
    value: (m2) => m2.valid > 1 ? Math.sqrt(m2.dev / (m2.valid - 1)) : void 0,
    req: ["variance"],
    idx: 2
  },
  stdevp: {
    value: (m2) => m2.valid > 1 ? Math.sqrt(m2.dev / m2.valid) : void 0,
    req: ["variance"],
    idx: 2
  },
  stderr: {
    value: (m2) => m2.valid > 1 ? Math.sqrt(m2.dev / (m2.valid * (m2.valid - 1))) : void 0,
    req: ["variance"],
    idx: 2
  },
  distinct: {
    value: (m2) => m2.cell.data.distinct(m2.get),
    req: ["values"],
    idx: 3
  },
  ci0: {
    value: (m2) => m2.cell.data.ci0(m2.get),
    req: ["values"],
    idx: 3
  },
  ci1: {
    value: (m2) => m2.cell.data.ci1(m2.get),
    req: ["values"],
    idx: 3
  },
  median: {
    value: (m2) => m2.cell.data.q2(m2.get),
    req: ["values"],
    idx: 3
  },
  q1: {
    value: (m2) => m2.cell.data.q1(m2.get),
    req: ["values"],
    idx: 3
  },
  q3: {
    value: (m2) => m2.cell.data.q3(m2.get),
    req: ["values"],
    idx: 3
  },
  min: {
    init: (m2) => m2.min = void 0,
    value: (m2) => m2.min = Number.isNaN(m2.min) ? m2.cell.data.min(m2.get) : m2.min,
    add: (m2, v) => {
      if (v < m2.min || m2.min === void 0)
        m2.min = v;
    },
    rem: (m2, v) => {
      if (v <= m2.min)
        m2.min = NaN;
    },
    req: ["values"],
    idx: 4
  },
  max: {
    init: (m2) => m2.max = void 0,
    value: (m2) => m2.max = Number.isNaN(m2.max) ? m2.cell.data.max(m2.get) : m2.max,
    add: (m2, v) => {
      if (v > m2.max || m2.max === void 0)
        m2.max = v;
    },
    rem: (m2, v) => {
      if (v >= m2.max)
        m2.max = NaN;
    },
    req: ["values"],
    idx: 4
  },
  argmin: {
    init: (m2) => m2.argmin = void 0,
    value: (m2) => m2.argmin || m2.cell.data.argmin(m2.get),
    add: (m2, v, t) => {
      if (v < m2.min)
        m2.argmin = t;
    },
    rem: (m2, v) => {
      if (v <= m2.min)
        m2.argmin = void 0;
    },
    req: ["min", "values"],
    idx: 3
  },
  argmax: {
    init: (m2) => m2.argmax = void 0,
    value: (m2) => m2.argmax || m2.cell.data.argmax(m2.get),
    add: (m2, v, t) => {
      if (v > m2.max)
        m2.argmax = t;
    },
    rem: (m2, v) => {
      if (v >= m2.max)
        m2.argmax = void 0;
    },
    req: ["max", "values"],
    idx: 3
  }
};
const ValidAggregateOps = Object.keys(AggregateOps).filter((d) => d !== "__count__");
function measure(key2, value2) {
  return (out) => extend({
    name: key2,
    out: out || key2
  }, base_op, value2);
}
[...ValidAggregateOps, "__count__"].forEach((key2) => {
  AggregateOps[key2] = measure(key2, AggregateOps[key2]);
});
function createMeasure(op, name) {
  return AggregateOps[op](name);
}
function compareIndex(a2, b2) {
  return a2.idx - b2.idx;
}
function resolve(agg) {
  const map2 = {};
  agg.forEach((a2) => map2[a2.name] = a2);
  const getreqs = (a2) => {
    if (!a2.req)
      return;
    a2.req.forEach((key2) => {
      if (!map2[key2])
        getreqs(map2[key2] = AggregateOps[key2]());
    });
  };
  agg.forEach(getreqs);
  return Object.values(map2).sort(compareIndex);
}
function init() {
  this.valid = 0;
  this.missing = 0;
  this._ops.forEach((op) => op.init(this));
}
function add$1(v, t) {
  if (v == null || v === "") {
    ++this.missing;
    return;
  }
  if (v !== v)
    return;
  ++this.valid;
  this._ops.forEach((op) => op.add(this, v, t));
}
function rem(v, t) {
  if (v == null || v === "") {
    --this.missing;
    return;
  }
  if (v !== v)
    return;
  --this.valid;
  this._ops.forEach((op) => op.rem(this, v, t));
}
function set$2(t) {
  this._out.forEach((op) => t[op.out] = op.value(this));
  return t;
}
function compileMeasures(agg, field2) {
  const get2 = field2 || identity$1, ops2 = resolve(agg), out = agg.slice().sort(compareIndex);
  function ctr(cell2) {
    this._ops = ops2;
    this._out = out;
    this.cell = cell2;
    this.init();
  }
  ctr.prototype.init = init;
  ctr.prototype.add = add$1;
  ctr.prototype.rem = rem;
  ctr.prototype.set = set$2;
  ctr.prototype.get = get2;
  ctr.fields = agg.map((op) => op.out);
  return ctr;
}
function TupleStore(key2) {
  this._key = key2 ? field$1(key2) : tupleid;
  this.reset();
}
const prototype$1 = TupleStore.prototype;
prototype$1.reset = function() {
  this._add = [];
  this._rem = [];
  this._ext = null;
  this._get = null;
  this._q = null;
};
prototype$1.add = function(v) {
  this._add.push(v);
};
prototype$1.rem = function(v) {
  this._rem.push(v);
};
prototype$1.values = function() {
  this._get = null;
  if (this._rem.length === 0)
    return this._add;
  const a2 = this._add, r = this._rem, k = this._key, n = a2.length, m2 = r.length, x2 = Array(n - m2), map2 = {};
  let i, j, v;
  for (i = 0; i < m2; ++i) {
    map2[k(r[i])] = 1;
  }
  for (i = 0, j = 0; i < n; ++i) {
    if (map2[k(v = a2[i])]) {
      map2[k(v)] = 0;
    } else {
      x2[j++] = v;
    }
  }
  this._rem = [];
  return this._add = x2;
};
prototype$1.distinct = function(get2) {
  const v = this.values(), map2 = {};
  let n = v.length, count2 = 0, s;
  while (--n >= 0) {
    s = get2(v[n]) + "";
    if (!has$1(map2, s)) {
      map2[s] = 1;
      ++count2;
    }
  }
  return count2;
};
prototype$1.extent = function(get2) {
  if (this._get !== get2 || !this._ext) {
    const v = this.values(), i = extentIndex(v, get2);
    this._ext = [v[i[0]], v[i[1]]];
    this._get = get2;
  }
  return this._ext;
};
prototype$1.argmin = function(get2) {
  return this.extent(get2)[0] || {};
};
prototype$1.argmax = function(get2) {
  return this.extent(get2)[1] || {};
};
prototype$1.min = function(get2) {
  const m2 = this.extent(get2)[0];
  return m2 != null ? get2(m2) : void 0;
};
prototype$1.max = function(get2) {
  const m2 = this.extent(get2)[1];
  return m2 != null ? get2(m2) : void 0;
};
prototype$1.quartile = function(get2) {
  if (this._get !== get2 || !this._q) {
    this._q = quartiles(this.values(), get2);
    this._get = get2;
  }
  return this._q;
};
prototype$1.q1 = function(get2) {
  return this.quartile(get2)[0];
};
prototype$1.q2 = function(get2) {
  return this.quartile(get2)[1];
};
prototype$1.q3 = function(get2) {
  return this.quartile(get2)[2];
};
prototype$1.ci = function(get2) {
  if (this._get !== get2 || !this._ci) {
    this._ci = bootstrapCI(this.values(), 1e3, 0.05, get2);
    this._get = get2;
  }
  return this._ci;
};
prototype$1.ci0 = function(get2) {
  return this.ci(get2)[0];
};
prototype$1.ci1 = function(get2) {
  return this.ci(get2)[1];
};
function Aggregate$1(params2) {
  Transform.call(this, null, params2);
  this._adds = [];
  this._mods = [];
  this._alen = 0;
  this._mlen = 0;
  this._drop = true;
  this._cross = false;
  this._dims = [];
  this._dnames = [];
  this._measures = [];
  this._countOnly = false;
  this._counts = null;
  this._prev = null;
  this._inputs = null;
  this._outputs = null;
}
Aggregate$1.Definition = {
  "type": "Aggregate",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "ops",
    "type": "enum",
    "array": true,
    "values": ValidAggregateOps
  }, {
    "name": "fields",
    "type": "field",
    "null": true,
    "array": true
  }, {
    "name": "as",
    "type": "string",
    "null": true,
    "array": true
  }, {
    "name": "drop",
    "type": "boolean",
    "default": true
  }, {
    "name": "cross",
    "type": "boolean",
    "default": false
  }, {
    "name": "key",
    "type": "field"
  }]
};
inherits(Aggregate$1, Transform, {
  transform(_, pulse2) {
    const aggr = this, out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), mod = _.modified();
    aggr.stamp = out.stamp;
    if (aggr.value && (mod || pulse2.modified(aggr._inputs, true))) {
      aggr._prev = aggr.value;
      aggr.value = mod ? aggr.init(_) : /* @__PURE__ */ Object.create(null);
      pulse2.visit(pulse2.SOURCE, (t) => aggr.add(t));
    } else {
      aggr.value = aggr.value || aggr.init(_);
      pulse2.visit(pulse2.REM, (t) => aggr.rem(t));
      pulse2.visit(pulse2.ADD, (t) => aggr.add(t));
    }
    out.modifies(aggr._outputs);
    aggr._drop = _.drop !== false;
    if (_.cross && aggr._dims.length > 1) {
      aggr._drop = false;
      aggr.cross();
    }
    if (pulse2.clean() && aggr._drop) {
      out.clean(true).runAfter(() => this.clean());
    }
    return aggr.changes(out);
  },
  cross() {
    const aggr = this, curr = aggr.value, dims = aggr._dnames, vals = dims.map(() => ({})), n = dims.length;
    function collect2(cells) {
      let key2, i, t, v;
      for (key2 in cells) {
        t = cells[key2].tuple;
        for (i = 0; i < n; ++i) {
          vals[i][v = t[dims[i]]] = v;
        }
      }
    }
    collect2(aggr._prev);
    collect2(curr);
    function generate2(base2, tuple, index2) {
      const name = dims[index2], v = vals[index2++];
      for (const k in v) {
        const key2 = base2 ? base2 + "|" + k : k;
        tuple[name] = v[k];
        if (index2 < n)
          generate2(key2, tuple, index2);
        else if (!curr[key2])
          aggr.cell(key2, tuple);
      }
    }
    generate2("", {}, 0);
  },
  init(_) {
    const inputs = this._inputs = [], outputs = this._outputs = [], inputMap = {};
    function inputVisit(get2) {
      const fields2 = array$3(accessorFields(get2)), n2 = fields2.length;
      let i2 = 0, f;
      for (; i2 < n2; ++i2) {
        if (!inputMap[f = fields2[i2]]) {
          inputMap[f] = 1;
          inputs.push(f);
        }
      }
    }
    this._dims = array$3(_.groupby);
    this._dnames = this._dims.map((d) => {
      const dname = accessorName(d);
      inputVisit(d);
      outputs.push(dname);
      return dname;
    });
    this.cellkey = _.key ? _.key : groupkey(this._dims);
    this._countOnly = true;
    this._counts = [];
    this._measures = [];
    const fields = _.fields || [null], ops2 = _.ops || ["count"], as = _.as || [], n = fields.length, map2 = {};
    let field2, op, m2, mname, outname, i;
    if (n !== ops2.length) {
      error("Unmatched number of fields and aggregate ops.");
    }
    for (i = 0; i < n; ++i) {
      field2 = fields[i];
      op = ops2[i];
      if (field2 == null && op !== "count") {
        error("Null aggregate field specified.");
      }
      mname = accessorName(field2);
      outname = measureName(op, mname, as[i]);
      outputs.push(outname);
      if (op === "count") {
        this._counts.push(outname);
        continue;
      }
      m2 = map2[mname];
      if (!m2) {
        inputVisit(field2);
        m2 = map2[mname] = [];
        m2.field = field2;
        this._measures.push(m2);
      }
      if (op !== "count")
        this._countOnly = false;
      m2.push(createMeasure(op, outname));
    }
    this._measures = this._measures.map((m3) => compileMeasures(m3, m3.field));
    return /* @__PURE__ */ Object.create(null);
  },
  // -- Cell Management -----
  cellkey: groupkey(),
  cell(key2, t) {
    let cell2 = this.value[key2];
    if (!cell2) {
      cell2 = this.value[key2] = this.newcell(key2, t);
      this._adds[this._alen++] = cell2;
    } else if (cell2.num === 0 && this._drop && cell2.stamp < this.stamp) {
      cell2.stamp = this.stamp;
      this._adds[this._alen++] = cell2;
    } else if (cell2.stamp < this.stamp) {
      cell2.stamp = this.stamp;
      this._mods[this._mlen++] = cell2;
    }
    return cell2;
  },
  newcell(key2, t) {
    const cell2 = {
      key: key2,
      num: 0,
      agg: null,
      tuple: this.newtuple(t, this._prev && this._prev[key2]),
      stamp: this.stamp,
      store: false
    };
    if (!this._countOnly) {
      const measures = this._measures, n = measures.length;
      cell2.agg = Array(n);
      for (let i = 0; i < n; ++i) {
        cell2.agg[i] = new measures[i](cell2);
      }
    }
    if (cell2.store) {
      cell2.data = new TupleStore();
    }
    return cell2;
  },
  newtuple(t, p) {
    const names = this._dnames, dims = this._dims, n = dims.length, x2 = {};
    for (let i = 0; i < n; ++i) {
      x2[names[i]] = dims[i](t);
    }
    return p ? replace$2(p.tuple, x2) : ingest$1(x2);
  },
  clean() {
    const cells = this.value;
    for (const key2 in cells) {
      if (cells[key2].num === 0) {
        delete cells[key2];
      }
    }
  },
  // -- Process Tuples -----
  add(t) {
    const key2 = this.cellkey(t), cell2 = this.cell(key2, t);
    cell2.num += 1;
    if (this._countOnly)
      return;
    if (cell2.store)
      cell2.data.add(t);
    const agg = cell2.agg;
    for (let i = 0, n = agg.length; i < n; ++i) {
      agg[i].add(agg[i].get(t), t);
    }
  },
  rem(t) {
    const key2 = this.cellkey(t), cell2 = this.cell(key2, t);
    cell2.num -= 1;
    if (this._countOnly)
      return;
    if (cell2.store)
      cell2.data.rem(t);
    const agg = cell2.agg;
    for (let i = 0, n = agg.length; i < n; ++i) {
      agg[i].rem(agg[i].get(t), t);
    }
  },
  celltuple(cell2) {
    const tuple = cell2.tuple, counts = this._counts;
    if (cell2.store) {
      cell2.data.values();
    }
    for (let i = 0, n = counts.length; i < n; ++i) {
      tuple[counts[i]] = cell2.num;
    }
    if (!this._countOnly) {
      const agg = cell2.agg;
      for (let i = 0, n = agg.length; i < n; ++i) {
        agg[i].set(tuple);
      }
    }
    return tuple;
  },
  changes(out) {
    const adds = this._adds, mods = this._mods, prev = this._prev, drop = this._drop, add2 = out.add, rem2 = out.rem, mod = out.mod;
    let cell2, key2, i, n;
    if (prev)
      for (key2 in prev) {
        cell2 = prev[key2];
        if (!drop || cell2.num)
          rem2.push(cell2.tuple);
      }
    for (i = 0, n = this._alen; i < n; ++i) {
      add2.push(this.celltuple(adds[i]));
      adds[i] = null;
    }
    for (i = 0, n = this._mlen; i < n; ++i) {
      cell2 = mods[i];
      (cell2.num === 0 && drop ? rem2 : mod).push(this.celltuple(cell2));
      mods[i] = null;
    }
    this._alen = this._mlen = 0;
    this._prev = null;
    return out;
  }
});
const EPSILON$1 = 1e-14;
function Bin(params2) {
  Transform.call(this, null, params2);
}
Bin.Definition = {
  "type": "Bin",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "interval",
    "type": "boolean",
    "default": true
  }, {
    "name": "anchor",
    "type": "number"
  }, {
    "name": "maxbins",
    "type": "number",
    "default": 20
  }, {
    "name": "base",
    "type": "number",
    "default": 10
  }, {
    "name": "divide",
    "type": "number",
    "array": true,
    "default": [5, 2]
  }, {
    "name": "extent",
    "type": "number",
    "array": true,
    "length": 2,
    "required": true
  }, {
    "name": "span",
    "type": "number"
  }, {
    "name": "step",
    "type": "number"
  }, {
    "name": "steps",
    "type": "number",
    "array": true
  }, {
    "name": "minstep",
    "type": "number",
    "default": 0
  }, {
    "name": "nice",
    "type": "boolean",
    "default": true
  }, {
    "name": "name",
    "type": "string"
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["bin0", "bin1"]
  }]
};
inherits(Bin, Transform, {
  transform(_, pulse2) {
    const band2 = _.interval !== false, bins = this._bins(_), start = bins.start, step = bins.step, as = _.as || ["bin0", "bin1"], b0 = as[0], b1 = as[1];
    let flag2;
    if (_.modified()) {
      pulse2 = pulse2.reflow(true);
      flag2 = pulse2.SOURCE;
    } else {
      flag2 = pulse2.modified(accessorFields(_.field)) ? pulse2.ADD_MOD : pulse2.ADD;
    }
    pulse2.visit(flag2, band2 ? (t) => {
      const v = bins(t);
      t[b0] = v;
      t[b1] = v == null ? null : start + step * (1 + (v - start) / step);
    } : (t) => t[b0] = bins(t));
    return pulse2.modifies(band2 ? as : b0);
  },
  _bins(_) {
    if (this.value && !_.modified()) {
      return this.value;
    }
    const field2 = _.field, bins = bin(_), step = bins.step;
    let start = bins.start, stop2 = start + Math.ceil((bins.stop - start) / step) * step, a2, d;
    if ((a2 = _.anchor) != null) {
      d = a2 - (start + step * Math.floor((a2 - start) / step));
      start += d;
      stop2 += d;
    }
    const f = function(t) {
      let v = toNumber(field2(t));
      return v == null ? null : v < start ? -Infinity : v > stop2 ? Infinity : (v = Math.max(start, Math.min(v, stop2 - step)), start + step * Math.floor(EPSILON$1 + (v - start) / step));
    };
    f.start = start;
    f.stop = bins.stop;
    f.step = step;
    return this.value = accessor(f, accessorFields(field2), _.name || "bin_" + accessorName(field2));
  }
});
function SortedList(idFunc, source2, input) {
  const $2 = idFunc;
  let data2 = source2 || [], add2 = input || [], rem2 = {}, cnt = 0;
  return {
    add: (t) => add2.push(t),
    remove: (t) => rem2[$2(t)] = ++cnt,
    size: () => data2.length,
    data: (compare2, resort) => {
      if (cnt) {
        data2 = data2.filter((t) => !rem2[$2(t)]);
        rem2 = {};
        cnt = 0;
      }
      if (resort && compare2) {
        data2.sort(compare2);
      }
      if (add2.length) {
        data2 = compare2 ? merge$3(compare2, data2, add2.sort(compare2)) : data2.concat(add2);
        add2 = [];
      }
      return data2;
    }
  };
}
function Collect$1(params2) {
  Transform.call(this, [], params2);
}
Collect$1.Definition = {
  "type": "Collect",
  "metadata": {
    "source": true
  },
  "params": [{
    "name": "sort",
    "type": "compare"
  }]
};
inherits(Collect$1, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.ALL), list = SortedList(tupleid, this.value, out.materialize(out.ADD).add), sort2 = _.sort, mod = pulse2.changed() || sort2 && (_.modified("sort") || pulse2.modified(sort2.fields));
    out.visit(out.REM, list.remove);
    this.modified(mod);
    this.value = out.source = list.data(stableCompare(sort2), mod);
    if (pulse2.source && pulse2.source.root) {
      this.value.root = pulse2.source.root;
    }
    return out;
  }
});
function Compare$1(params2) {
  Operator.call(this, null, update$5, params2);
}
inherits(Compare$1, Operator);
function update$5(_) {
  return this.value && !_.modified() ? this.value : compare$1(_.fields, _.orders);
}
function CountPattern(params2) {
  Transform.call(this, null, params2);
}
CountPattern.Definition = {
  "type": "CountPattern",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "case",
    "type": "enum",
    "values": ["upper", "lower", "mixed"],
    "default": "mixed"
  }, {
    "name": "pattern",
    "type": "string",
    "default": '[\\w"]+'
  }, {
    "name": "stopwords",
    "type": "string",
    "default": ""
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["text", "count"]
  }]
};
function tokenize(text2, tcase, match2) {
  switch (tcase) {
    case "upper":
      text2 = text2.toUpperCase();
      break;
    case "lower":
      text2 = text2.toLowerCase();
      break;
  }
  return text2.match(match2);
}
inherits(CountPattern, Transform, {
  transform(_, pulse2) {
    const process = (update2) => (tuple) => {
      var tokens = tokenize(get2(tuple), _.case, match2) || [], t;
      for (var i = 0, n = tokens.length; i < n; ++i) {
        if (!stop2.test(t = tokens[i]))
          update2(t);
      }
    };
    const init2 = this._parameterCheck(_, pulse2), counts = this._counts, match2 = this._match, stop2 = this._stop, get2 = _.field, as = _.as || ["text", "count"], add2 = process((t) => counts[t] = 1 + (counts[t] || 0)), rem2 = process((t) => counts[t] -= 1);
    if (init2) {
      pulse2.visit(pulse2.SOURCE, add2);
    } else {
      pulse2.visit(pulse2.ADD, add2);
      pulse2.visit(pulse2.REM, rem2);
    }
    return this._finish(pulse2, as);
  },
  _parameterCheck(_, pulse2) {
    let init2 = false;
    if (_.modified("stopwords") || !this._stop) {
      this._stop = new RegExp("^" + (_.stopwords || "") + "$", "i");
      init2 = true;
    }
    if (_.modified("pattern") || !this._match) {
      this._match = new RegExp(_.pattern || "[\\w']+", "g");
      init2 = true;
    }
    if (_.modified("field") || pulse2.modified(_.field.fields)) {
      init2 = true;
    }
    if (init2)
      this._counts = {};
    return init2;
  },
  _finish(pulse2, as) {
    const counts = this._counts, tuples = this._tuples || (this._tuples = {}), text2 = as[0], count2 = as[1], out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
    let w2, t, c2;
    for (w2 in counts) {
      t = tuples[w2];
      c2 = counts[w2] || 0;
      if (!t && c2) {
        tuples[w2] = t = ingest$1({});
        t[text2] = w2;
        t[count2] = c2;
        out.add.push(t);
      } else if (c2 === 0) {
        if (t)
          out.rem.push(t);
        counts[w2] = null;
        tuples[w2] = null;
      } else if (t[count2] !== c2) {
        t[count2] = c2;
        out.mod.push(t);
      }
    }
    return out.modifies(as);
  }
});
function Cross(params2) {
  Transform.call(this, null, params2);
}
Cross.Definition = {
  "type": "Cross",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "filter",
    "type": "expr"
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["a", "b"]
  }]
};
inherits(Cross, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE), as = _.as || ["a", "b"], a2 = as[0], b2 = as[1], reset2 = !this.value || pulse2.changed(pulse2.ADD_REM) || _.modified("as") || _.modified("filter");
    let data2 = this.value;
    if (reset2) {
      if (data2)
        out.rem = data2;
      data2 = pulse2.materialize(pulse2.SOURCE).source;
      out.add = this.value = cross(data2, a2, b2, _.filter || truthy);
    } else {
      out.mod = data2;
    }
    out.source = this.value;
    return out.modifies(as);
  }
});
function cross(input, a2, b2, filter2) {
  var data2 = [], t = {}, n = input.length, i = 0, j, left;
  for (; i < n; ++i) {
    t[a2] = left = input[i];
    for (j = 0; j < n; ++j) {
      t[b2] = input[j];
      if (filter2(t)) {
        data2.push(ingest$1(t));
        t = {};
        t[a2] = left;
      }
    }
  }
  return data2;
}
const Distributions = {
  kde,
  mixture: mixture$1,
  normal: gaussian,
  lognormal,
  uniform
};
const DISTRIBUTIONS = "distributions", FUNCTION = "function", FIELD = "field";
function parse$4(def2, data2) {
  const func = def2[FUNCTION];
  if (!has$1(Distributions, func)) {
    error("Unknown distribution function: " + func);
  }
  const d = Distributions[func]();
  for (const name in def2) {
    if (name === FIELD) {
      d.data((def2.from || data2()).map(def2[name]));
    } else if (name === DISTRIBUTIONS) {
      d[name](def2[name].map((_) => parse$4(_, data2)));
    } else if (typeof d[name] === FUNCTION) {
      d[name](def2[name]);
    }
  }
  return d;
}
function Density(params2) {
  Transform.call(this, null, params2);
}
const distributions = [{
  "key": {
    "function": "normal"
  },
  "params": [{
    "name": "mean",
    "type": "number",
    "default": 0
  }, {
    "name": "stdev",
    "type": "number",
    "default": 1
  }]
}, {
  "key": {
    "function": "lognormal"
  },
  "params": [{
    "name": "mean",
    "type": "number",
    "default": 0
  }, {
    "name": "stdev",
    "type": "number",
    "default": 1
  }]
}, {
  "key": {
    "function": "uniform"
  },
  "params": [{
    "name": "min",
    "type": "number",
    "default": 0
  }, {
    "name": "max",
    "type": "number",
    "default": 1
  }]
}, {
  "key": {
    "function": "kde"
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "from",
    "type": "data"
  }, {
    "name": "bandwidth",
    "type": "number",
    "default": 0
  }]
}];
const mixture = {
  "key": {
    "function": "mixture"
  },
  "params": [{
    "name": "distributions",
    "type": "param",
    "array": true,
    "params": distributions
  }, {
    "name": "weights",
    "type": "number",
    "array": true
  }]
};
Density.Definition = {
  "type": "Density",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "extent",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "steps",
    "type": "number"
  }, {
    "name": "minsteps",
    "type": "number",
    "default": 25
  }, {
    "name": "maxsteps",
    "type": "number",
    "default": 200
  }, {
    "name": "method",
    "type": "string",
    "default": "pdf",
    "values": ["pdf", "cdf"]
  }, {
    "name": "distribution",
    "type": "param",
    "params": distributions.concat(mixture)
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "default": ["value", "density"]
  }]
};
inherits(Density, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
    if (!this.value || pulse2.changed() || _.modified()) {
      const dist2 = parse$4(_.distribution, source$2(pulse2)), minsteps = _.steps || _.minsteps || 25, maxsteps = _.steps || _.maxsteps || 200;
      let method2 = _.method || "pdf";
      if (method2 !== "pdf" && method2 !== "cdf") {
        error("Invalid density method: " + method2);
      }
      if (!_.extent && !dist2.data) {
        error("Missing density extent parameter.");
      }
      method2 = dist2[method2];
      const as = _.as || ["value", "density"], domain2 = _.extent || extent(dist2.data()), values2 = sampleCurve(method2, domain2, minsteps, maxsteps).map((v) => {
        const tuple = {};
        tuple[as[0]] = v[0];
        tuple[as[1]] = v[1];
        return ingest$1(tuple);
      });
      if (this.value)
        out.rem = this.value;
      this.value = out.add = out.source = values2;
    }
    return out;
  }
});
function source$2(pulse2) {
  return () => pulse2.materialize(pulse2.SOURCE).source;
}
function fieldNames(fields, as) {
  if (!fields)
    return null;
  return fields.map((f, i) => as[i] || accessorName(f));
}
function partition$1$1(data2, groupby, field2) {
  const groups = [], get2 = (f) => f(t);
  let map2, i, n, t, k, g;
  if (groupby == null) {
    groups.push(data2.map(field2));
  } else {
    for (map2 = {}, i = 0, n = data2.length; i < n; ++i) {
      t = data2[i];
      k = groupby.map(get2);
      g = map2[k];
      if (!g) {
        map2[k] = g = [];
        g.dims = k;
        groups.push(g);
      }
      g.push(field2(t));
    }
  }
  return groups;
}
const Output$5 = "bin";
function DotBin(params2) {
  Transform.call(this, null, params2);
}
DotBin.Definition = {
  "type": "DotBin",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "step",
    "type": "number"
  }, {
    "name": "smooth",
    "type": "boolean",
    "default": false
  }, {
    "name": "as",
    "type": "string",
    "default": Output$5
  }]
};
const autostep = (data2, field2) => span(extent(data2, field2)) / 30;
inherits(DotBin, Transform, {
  transform(_, pulse2) {
    if (this.value && !(_.modified() || pulse2.changed())) {
      return pulse2;
    }
    const source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition$1$1(pulse2.source, _.groupby, identity$1), smooth = _.smooth || false, field2 = _.field, step = _.step || autostep(source2, field2), sort2 = stableCompare((a2, b2) => field2(a2) - field2(b2)), as = _.as || Output$5, n = groups.length;
    let min2 = Infinity, max2 = -Infinity, i = 0, j;
    for (; i < n; ++i) {
      const g = groups[i].sort(sort2);
      j = -1;
      for (const v of dotbin(g, step, smooth, field2)) {
        if (v < min2)
          min2 = v;
        if (v > max2)
          max2 = v;
        g[++j][as] = v;
      }
    }
    this.value = {
      start: min2,
      stop: max2,
      step
    };
    return pulse2.reflow(true).modifies(as);
  }
});
function Expression$1(params2) {
  Operator.call(this, null, update$4, params2);
  this.modified(true);
}
inherits(Expression$1, Operator);
function update$4(_) {
  const expr2 = _.expr;
  return this.value && !_.modified("expr") ? this.value : accessor((datum2) => expr2(datum2, _), accessorFields(expr2), accessorName(expr2));
}
function Extent(params2) {
  Transform.call(this, [void 0, void 0], params2);
}
Extent.Definition = {
  "type": "Extent",
  "metadata": {},
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }]
};
inherits(Extent, Transform, {
  transform(_, pulse2) {
    const extent2 = this.value, field2 = _.field, mod = pulse2.changed() || pulse2.modified(field2.fields) || _.modified("field");
    let min2 = extent2[0], max2 = extent2[1];
    if (mod || min2 == null) {
      min2 = Infinity;
      max2 = -Infinity;
    }
    pulse2.visit(mod ? pulse2.SOURCE : pulse2.ADD, (t) => {
      const v = toNumber(field2(t));
      if (v != null) {
        if (v < min2)
          min2 = v;
        if (v > max2)
          max2 = v;
      }
    });
    if (!Number.isFinite(min2) || !Number.isFinite(max2)) {
      let name = accessorName(field2);
      if (name)
        name = ` for field "${name}"`;
      pulse2.dataflow.warn(`Infinite extent${name}: [${min2}, ${max2}]`);
      min2 = max2 = void 0;
    }
    this.value = [min2, max2];
  }
});
function Subflow(pulse2, parent) {
  Operator.call(this, pulse2);
  this.parent = parent;
  this.count = 0;
}
inherits(Subflow, Operator, {
  /**
   * Routes pulses from this subflow to a target transform.
   * @param {Transform} target - A transform that receives the subflow of tuples.
   */
  connect(target2) {
    this.detachSubflow = target2.detachSubflow;
    this.targets().add(target2);
    return target2.source = this;
  },
  /**
   * Add an 'add' tuple to the subflow pulse.
   * @param {Tuple} t - The tuple being added.
   */
  add(t) {
    this.count += 1;
    this.value.add.push(t);
  },
  /**
   * Add a 'rem' tuple to the subflow pulse.
   * @param {Tuple} t - The tuple being removed.
   */
  rem(t) {
    this.count -= 1;
    this.value.rem.push(t);
  },
  /**
   * Add a 'mod' tuple to the subflow pulse.
   * @param {Tuple} t - The tuple being modified.
   */
  mod(t) {
    this.value.mod.push(t);
  },
  /**
   * Re-initialize this operator's pulse value.
   * @param {Pulse} pulse - The pulse to copy from.
   * @see Pulse.init
   */
  init(pulse2) {
    this.value.init(pulse2, pulse2.NO_SOURCE);
  },
  /**
   * Evaluate this operator. This method overrides the
   * default behavior to simply return the contained pulse value.
   * @return {Pulse}
   */
  evaluate() {
    return this.value;
  }
});
function Facet$1(params2) {
  Transform.call(this, {}, params2);
  this._keys = fastmap();
  const a2 = this._targets = [];
  a2.active = 0;
  a2.forEach = (f) => {
    for (let i = 0, n = a2.active; i < n; ++i) {
      f(a2[i], i, a2);
    }
  };
}
inherits(Facet$1, Transform, {
  activate(flow) {
    this._targets[this._targets.active++] = flow;
  },
  // parent argument provided by PreFacet subclass
  subflow(key2, flow, pulse2, parent) {
    const flows = this.value;
    let sf = has$1(flows, key2) && flows[key2], df, p;
    if (!sf) {
      p = parent || (p = this._group[key2]) && p.tuple;
      df = pulse2.dataflow;
      sf = new Subflow(pulse2.fork(pulse2.NO_SOURCE), this);
      df.add(sf).connect(flow(df, key2, p));
      flows[key2] = sf;
      this.activate(sf);
    } else if (sf.value.stamp < pulse2.stamp) {
      sf.init(pulse2);
      this.activate(sf);
    }
    return sf;
  },
  clean() {
    const flows = this.value;
    let detached = 0;
    for (const key2 in flows) {
      if (flows[key2].count === 0) {
        const detach = flows[key2].detachSubflow;
        if (detach)
          detach();
        delete flows[key2];
        ++detached;
      }
    }
    if (detached) {
      const active = this._targets.filter((sf) => sf && sf.count > 0);
      this.initTargets(active);
    }
  },
  initTargets(act) {
    const a2 = this._targets, n = a2.length, m2 = act ? act.length : 0;
    let i = 0;
    for (; i < m2; ++i) {
      a2[i] = act[i];
    }
    for (; i < n && a2[i] != null; ++i) {
      a2[i] = null;
    }
    a2.active = m2;
  },
  transform(_, pulse2) {
    const df = pulse2.dataflow, key2 = _.key, flow = _.subflow, cache2 = this._keys, rekey = _.modified("key"), subflow = (key3) => this.subflow(key3, flow, pulse2);
    this._group = _.group || {};
    this.initTargets();
    pulse2.visit(pulse2.REM, (t) => {
      const id2 = tupleid(t), k = cache2.get(id2);
      if (k !== void 0) {
        cache2.delete(id2);
        subflow(k).rem(t);
      }
    });
    pulse2.visit(pulse2.ADD, (t) => {
      const k = key2(t);
      cache2.set(tupleid(t), k);
      subflow(k).add(t);
    });
    if (rekey || pulse2.modified(key2.fields)) {
      pulse2.visit(pulse2.MOD, (t) => {
        const id2 = tupleid(t), k0 = cache2.get(id2), k1 = key2(t);
        if (k0 === k1) {
          subflow(k1).mod(t);
        } else {
          cache2.set(id2, k1);
          subflow(k0).rem(t);
          subflow(k1).add(t);
        }
      });
    } else if (pulse2.changed(pulse2.MOD)) {
      pulse2.visit(pulse2.MOD, (t) => {
        subflow(cache2.get(tupleid(t))).mod(t);
      });
    }
    if (rekey) {
      pulse2.visit(pulse2.REFLOW, (t) => {
        const id2 = tupleid(t), k0 = cache2.get(id2), k1 = key2(t);
        if (k0 !== k1) {
          cache2.set(id2, k1);
          subflow(k0).rem(t);
          subflow(k1).add(t);
        }
      });
    }
    if (pulse2.clean()) {
      df.runAfter(() => {
        this.clean();
        cache2.clean();
      });
    } else if (cache2.empty > df.cleanThreshold) {
      df.runAfter(cache2.clean);
    }
    return pulse2;
  }
});
function Field$1(params2) {
  Operator.call(this, null, update$3, params2);
}
inherits(Field$1, Operator);
function update$3(_) {
  return this.value && !_.modified() ? this.value : isArray(_.name) ? array$3(_.name).map((f) => field$1(f)) : field$1(_.name, _.as);
}
function Filter(params2) {
  Transform.call(this, fastmap(), params2);
}
Filter.Definition = {
  "type": "Filter",
  "metadata": {
    "changes": true
  },
  "params": [{
    "name": "expr",
    "type": "expr",
    "required": true
  }]
};
inherits(Filter, Transform, {
  transform(_, pulse2) {
    const df = pulse2.dataflow, cache2 = this.value, output2 = pulse2.fork(), add2 = output2.add, rem2 = output2.rem, mod = output2.mod, test2 = _.expr;
    let isMod = true;
    pulse2.visit(pulse2.REM, (t) => {
      const id2 = tupleid(t);
      if (!cache2.has(id2))
        rem2.push(t);
      else
        cache2.delete(id2);
    });
    pulse2.visit(pulse2.ADD, (t) => {
      if (test2(t, _))
        add2.push(t);
      else
        cache2.set(tupleid(t), 1);
    });
    function revisit(t) {
      const id2 = tupleid(t), b2 = test2(t, _), s = cache2.get(id2);
      if (b2 && s) {
        cache2.delete(id2);
        add2.push(t);
      } else if (!b2 && !s) {
        cache2.set(id2, 1);
        rem2.push(t);
      } else if (isMod && b2 && !s) {
        mod.push(t);
      }
    }
    pulse2.visit(pulse2.MOD, revisit);
    if (_.modified()) {
      isMod = false;
      pulse2.visit(pulse2.REFLOW, revisit);
    }
    if (cache2.empty > df.cleanThreshold)
      df.runAfter(cache2.clean);
    return output2;
  }
});
function Flatten(params2) {
  Transform.call(this, [], params2);
}
Flatten.Definition = {
  "type": "Flatten",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "fields",
    "type": "field",
    "array": true,
    "required": true
  }, {
    "name": "index",
    "type": "string"
  }, {
    "name": "as",
    "type": "string",
    "array": true
  }]
};
inherits(Flatten, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE), fields = _.fields, as = fieldNames(fields, _.as || []), index2 = _.index || null, m2 = as.length;
    out.rem = this.value;
    pulse2.visit(pulse2.SOURCE, (t) => {
      const arrays = fields.map((f) => f(t)), maxlen = arrays.reduce((l, a2) => Math.max(l, a2.length), 0);
      let i = 0, j, d, v;
      for (; i < maxlen; ++i) {
        d = derive(t);
        for (j = 0; j < m2; ++j) {
          d[as[j]] = (v = arrays[j][i]) == null ? null : v;
        }
        if (index2) {
          d[index2] = i;
        }
        out.add.push(d);
      }
    });
    this.value = out.source = out.add;
    if (index2)
      out.modifies(index2);
    return out.modifies(as);
  }
});
function Fold(params2) {
  Transform.call(this, [], params2);
}
Fold.Definition = {
  "type": "Fold",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "fields",
    "type": "field",
    "array": true,
    "required": true
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["key", "value"]
  }]
};
inherits(Fold, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE), fields = _.fields, fnames = fields.map(accessorName), as = _.as || ["key", "value"], k = as[0], v = as[1], n = fields.length;
    out.rem = this.value;
    pulse2.visit(pulse2.SOURCE, (t) => {
      for (let i = 0, d; i < n; ++i) {
        d = derive(t);
        d[k] = fnames[i];
        d[v] = fields[i](t);
        out.add.push(d);
      }
    });
    this.value = out.source = out.add;
    return out.modifies(as);
  }
});
function Formula(params2) {
  Transform.call(this, null, params2);
}
Formula.Definition = {
  "type": "Formula",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "expr",
    "type": "expr",
    "required": true
  }, {
    "name": "as",
    "type": "string",
    "required": true
  }, {
    "name": "initonly",
    "type": "boolean"
  }]
};
inherits(Formula, Transform, {
  transform(_, pulse2) {
    const func = _.expr, as = _.as, mod = _.modified(), flag2 = _.initonly ? pulse2.ADD : mod ? pulse2.SOURCE : pulse2.modified(func.fields) || pulse2.modified(as) ? pulse2.ADD_MOD : pulse2.ADD;
    if (mod) {
      pulse2 = pulse2.materialize().reflow(true);
    }
    if (!_.initonly) {
      pulse2.modifies(as);
    }
    return pulse2.visit(flag2, (t) => t[as] = func(t, _));
  }
});
function Generate(params2) {
  Transform.call(this, [], params2);
}
inherits(Generate, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.ALL), gen = _.generator;
    let data2 = this.value, num = _.size - data2.length, add2, rem2, t;
    if (num > 0) {
      for (add2 = []; --num >= 0; ) {
        add2.push(t = ingest$1(gen(_)));
        data2.push(t);
      }
      out.add = out.add.length ? out.materialize(out.ADD).add.concat(add2) : add2;
    } else {
      rem2 = data2.slice(0, -num);
      out.rem = out.rem.length ? out.materialize(out.REM).rem.concat(rem2) : rem2;
      data2 = data2.slice(-num);
    }
    out.source = this.value = data2;
    return out;
  }
});
const Methods$1 = {
  value: "value",
  median,
  mean,
  min: min$2,
  max: max$2
};
const Empty$1 = [];
function Impute(params2) {
  Transform.call(this, [], params2);
}
Impute.Definition = {
  "type": "Impute",
  "metadata": {
    "changes": true
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "key",
    "type": "field",
    "required": true
  }, {
    "name": "keyvals",
    "array": true
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "method",
    "type": "enum",
    "default": "value",
    "values": ["value", "mean", "median", "max", "min"]
  }, {
    "name": "value",
    "default": 0
  }]
};
function getValue(_) {
  var m2 = _.method || Methods$1.value, v;
  if (Methods$1[m2] == null) {
    error("Unrecognized imputation method: " + m2);
  } else if (m2 === Methods$1.value) {
    v = _.value !== void 0 ? _.value : 0;
    return () => v;
  } else {
    return Methods$1[m2];
  }
}
function getField$1(_) {
  const f = _.field;
  return (t) => t ? f(t) : NaN;
}
inherits(Impute, Transform, {
  transform(_, pulse2) {
    var out = pulse2.fork(pulse2.ALL), impute = getValue(_), field2 = getField$1(_), fName = accessorName(_.field), kName = accessorName(_.key), gNames = (_.groupby || []).map(accessorName), groups = partition$3(pulse2.source, _.groupby, _.key, _.keyvals), curr = [], prev = this.value, m2 = groups.domain.length, group2, value2, gVals, kVal, g, i, j, l, n, t;
    for (g = 0, l = groups.length; g < l; ++g) {
      group2 = groups[g];
      gVals = group2.values;
      value2 = NaN;
      for (j = 0; j < m2; ++j) {
        if (group2[j] != null)
          continue;
        kVal = groups.domain[j];
        t = {
          _impute: true
        };
        for (i = 0, n = gVals.length; i < n; ++i)
          t[gNames[i]] = gVals[i];
        t[kName] = kVal;
        t[fName] = Number.isNaN(value2) ? value2 = impute(group2, field2) : value2;
        curr.push(ingest$1(t));
      }
    }
    if (curr.length)
      out.add = out.materialize(out.ADD).add.concat(curr);
    if (prev.length)
      out.rem = out.materialize(out.REM).rem.concat(prev);
    this.value = curr;
    return out;
  }
});
function partition$3(data2, groupby, key2, keyvals) {
  var get2 = (f) => f(t), groups = [], domain2 = keyvals ? keyvals.slice() : [], kMap = {}, gMap = {}, gVals, gKey, group2, i, j, k, n, t;
  domain2.forEach((k2, i2) => kMap[k2] = i2 + 1);
  for (i = 0, n = data2.length; i < n; ++i) {
    t = data2[i];
    k = key2(t);
    j = kMap[k] || (kMap[k] = domain2.push(k));
    gKey = (gVals = groupby ? groupby.map(get2) : Empty$1) + "";
    if (!(group2 = gMap[gKey])) {
      group2 = gMap[gKey] = [];
      groups.push(group2);
      group2.values = gVals;
    }
    group2[j - 1] = t;
  }
  groups.domain = domain2;
  return groups;
}
function JoinAggregate(params2) {
  Aggregate$1.call(this, params2);
}
JoinAggregate.Definition = {
  "type": "JoinAggregate",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "fields",
    "type": "field",
    "null": true,
    "array": true
  }, {
    "name": "ops",
    "type": "enum",
    "array": true,
    "values": ValidAggregateOps
  }, {
    "name": "as",
    "type": "string",
    "null": true,
    "array": true
  }, {
    "name": "key",
    "type": "field"
  }]
};
inherits(JoinAggregate, Aggregate$1, {
  transform(_, pulse2) {
    const aggr = this, mod = _.modified();
    let cells;
    if (aggr.value && (mod || pulse2.modified(aggr._inputs, true))) {
      cells = aggr.value = mod ? aggr.init(_) : {};
      pulse2.visit(pulse2.SOURCE, (t) => aggr.add(t));
    } else {
      cells = aggr.value = aggr.value || this.init(_);
      pulse2.visit(pulse2.REM, (t) => aggr.rem(t));
      pulse2.visit(pulse2.ADD, (t) => aggr.add(t));
    }
    aggr.changes();
    pulse2.visit(pulse2.SOURCE, (t) => {
      extend(t, cells[aggr.cellkey(t)].tuple);
    });
    return pulse2.reflow(mod).modifies(this._outputs);
  },
  changes() {
    const adds = this._adds, mods = this._mods;
    let i, n;
    for (i = 0, n = this._alen; i < n; ++i) {
      this.celltuple(adds[i]);
      adds[i] = null;
    }
    for (i = 0, n = this._mlen; i < n; ++i) {
      this.celltuple(mods[i]);
      mods[i] = null;
    }
    this._alen = this._mlen = 0;
  }
});
function KDE(params2) {
  Transform.call(this, null, params2);
}
KDE.Definition = {
  "type": "KDE",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "cumulative",
    "type": "boolean",
    "default": false
  }, {
    "name": "counts",
    "type": "boolean",
    "default": false
  }, {
    "name": "bandwidth",
    "type": "number",
    "default": 0
  }, {
    "name": "extent",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "resolve",
    "type": "enum",
    "values": ["shared", "independent"],
    "default": "independent"
  }, {
    "name": "steps",
    "type": "number"
  }, {
    "name": "minsteps",
    "type": "number",
    "default": 25
  }, {
    "name": "maxsteps",
    "type": "number",
    "default": 200
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "default": ["value", "density"]
  }]
};
inherits(KDE, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
    if (!this.value || pulse2.changed() || _.modified()) {
      const source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition$1$1(source2, _.groupby, _.field), names = (_.groupby || []).map(accessorName), bandwidth2 = _.bandwidth, method2 = _.cumulative ? "cdf" : "pdf", as = _.as || ["value", "density"], values2 = [];
      let domain2 = _.extent, minsteps = _.steps || _.minsteps || 25, maxsteps = _.steps || _.maxsteps || 200;
      if (method2 !== "pdf" && method2 !== "cdf") {
        error("Invalid density method: " + method2);
      }
      if (_.resolve === "shared") {
        if (!domain2)
          domain2 = extent(source2, _.field);
        minsteps = maxsteps = _.steps || maxsteps;
      }
      groups.forEach((g) => {
        const density = kde(g, bandwidth2)[method2], scale2 = _.counts ? g.length : 1, local = domain2 || extent(g);
        sampleCurve(density, local, minsteps, maxsteps).forEach((v) => {
          const t = {};
          for (let i = 0; i < names.length; ++i) {
            t[names[i]] = g.dims[i];
          }
          t[as[0]] = v[0];
          t[as[1]] = v[1] * scale2;
          values2.push(ingest$1(t));
        });
      });
      if (this.value)
        out.rem = this.value;
      this.value = out.add = out.source = values2;
    }
    return out;
  }
});
function Key$1(params2) {
  Operator.call(this, null, update$2, params2);
}
inherits(Key$1, Operator);
function update$2(_) {
  return this.value && !_.modified() ? this.value : key(_.fields, _.flat);
}
function Load$1(params2) {
  Transform.call(this, [], params2);
  this._pending = null;
}
inherits(Load$1, Transform, {
  transform(_, pulse2) {
    const df = pulse2.dataflow;
    if (this._pending) {
      return output(this, pulse2, this._pending);
    }
    if (stop(_))
      return pulse2.StopPropagation;
    if (_.values) {
      return output(this, pulse2, df.parse(_.values, _.format));
    } else if (_.async) {
      const p = df.request(_.url, _.format).then((res) => {
        this._pending = array$3(res.data);
        return (df2) => df2.touch(this);
      });
      return {
        async: p
      };
    } else {
      return df.request(_.url, _.format).then((res) => output(this, pulse2, array$3(res.data)));
    }
  }
});
function stop(_) {
  return _.modified("async") && !(_.modified("values") || _.modified("url") || _.modified("format"));
}
function output(op, pulse2, data2) {
  data2.forEach(ingest$1);
  const out = pulse2.fork(pulse2.NO_FIELDS & pulse2.NO_SOURCE);
  out.rem = op.value;
  op.value = out.source = out.add = data2;
  op._pending = null;
  if (out.rem.length)
    out.clean(true);
  return out;
}
function Lookup(params2) {
  Transform.call(this, {}, params2);
}
Lookup.Definition = {
  "type": "Lookup",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "index",
    "type": "index",
    "params": [{
      "name": "from",
      "type": "data",
      "required": true
    }, {
      "name": "key",
      "type": "field",
      "required": true
    }]
  }, {
    "name": "values",
    "type": "field",
    "array": true
  }, {
    "name": "fields",
    "type": "field",
    "array": true,
    "required": true
  }, {
    "name": "as",
    "type": "string",
    "array": true
  }, {
    "name": "default",
    "default": null
  }]
};
inherits(Lookup, Transform, {
  transform(_, pulse2) {
    const keys2 = _.fields, index2 = _.index, values2 = _.values, defaultValue = _.default == null ? null : _.default, reset2 = _.modified(), n = keys2.length;
    let flag2 = reset2 ? pulse2.SOURCE : pulse2.ADD, out = pulse2, as = _.as, set2, m2, mods;
    if (values2) {
      m2 = values2.length;
      if (n > 1 && !as) {
        error('Multi-field lookup requires explicit "as" parameter.');
      }
      if (as && as.length !== n * m2) {
        error('The "as" parameter has too few output field names.');
      }
      as = as || values2.map(accessorName);
      set2 = function(t) {
        for (var i = 0, k = 0, j, v; i < n; ++i) {
          v = index2.get(keys2[i](t));
          if (v == null)
            for (j = 0; j < m2; ++j, ++k)
              t[as[k]] = defaultValue;
          else
            for (j = 0; j < m2; ++j, ++k)
              t[as[k]] = values2[j](v);
        }
      };
    } else {
      if (!as) {
        error("Missing output field names.");
      }
      set2 = function(t) {
        for (var i = 0, v; i < n; ++i) {
          v = index2.get(keys2[i](t));
          t[as[i]] = v == null ? defaultValue : v;
        }
      };
    }
    if (reset2) {
      out = pulse2.reflow(true);
    } else {
      mods = keys2.some((k) => pulse2.modified(k.fields));
      flag2 |= mods ? pulse2.MOD : 0;
    }
    pulse2.visit(flag2, set2);
    return out.modifies(as);
  }
});
function MultiExtent$1(params2) {
  Operator.call(this, null, update$1, params2);
}
inherits(MultiExtent$1, Operator);
function update$1(_) {
  if (this.value && !_.modified()) {
    return this.value;
  }
  const ext = _.extents, n = ext.length;
  let min2 = Infinity, max2 = -Infinity, i, e;
  for (i = 0; i < n; ++i) {
    e = ext[i];
    if (e[0] < min2)
      min2 = e[0];
    if (e[1] > max2)
      max2 = e[1];
  }
  return [min2, max2];
}
function MultiValues$1(params2) {
  Operator.call(this, null, update, params2);
}
inherits(MultiValues$1, Operator);
function update(_) {
  return this.value && !_.modified() ? this.value : _.values.reduce((data2, _2) => data2.concat(_2), []);
}
function Params$2(params2) {
  Transform.call(this, null, params2);
}
inherits(Params$2, Transform, {
  transform(_, pulse2) {
    this.modified(_.modified());
    this.value = _;
    return pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
  }
});
function Pivot(params2) {
  Aggregate$1.call(this, params2);
}
Pivot.Definition = {
  "type": "Pivot",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "value",
    "type": "field",
    "required": true
  }, {
    "name": "op",
    "type": "enum",
    "values": ValidAggregateOps,
    "default": "sum"
  }, {
    "name": "limit",
    "type": "number",
    "default": 0
  }, {
    "name": "key",
    "type": "field"
  }]
};
inherits(Pivot, Aggregate$1, {
  _transform: Aggregate$1.prototype.transform,
  transform(_, pulse2) {
    return this._transform(aggregateParams(_, pulse2), pulse2);
  }
});
function aggregateParams(_, pulse2) {
  const key2 = _.field, value2 = _.value, op = (_.op === "count" ? "__count__" : _.op) || "sum", fields = accessorFields(key2).concat(accessorFields(value2)), keys2 = pivotKeys(key2, _.limit || 0, pulse2);
  if (pulse2.changed())
    _.set("__pivot__", null, null, true);
  return {
    key: _.key,
    groupby: _.groupby,
    ops: keys2.map(() => op),
    fields: keys2.map((k) => get$3(k, key2, value2, fields)),
    as: keys2.map((k) => k + ""),
    modified: _.modified.bind(_)
  };
}
function get$3(k, key2, value2, fields) {
  return accessor((d) => key2(d) === k ? value2(d) : NaN, fields, k + "");
}
function pivotKeys(key2, limit, pulse2) {
  const map2 = {}, list = [];
  pulse2.visit(pulse2.SOURCE, (t) => {
    const k = key2(t);
    if (!map2[k]) {
      map2[k] = 1;
      list.push(k);
    }
  });
  list.sort(ascending$1);
  return limit ? list.slice(0, limit) : list;
}
function PreFacet$1(params2) {
  Facet$1.call(this, params2);
}
inherits(PreFacet$1, Facet$1, {
  transform(_, pulse2) {
    const flow = _.subflow, field2 = _.field, subflow = (t) => this.subflow(tupleid(t), flow, pulse2, t);
    if (_.modified("field") || field2 && pulse2.modified(accessorFields(field2))) {
      error("PreFacet does not support field modification.");
    }
    this.initTargets();
    if (field2) {
      pulse2.visit(pulse2.MOD, (t) => {
        const sf = subflow(t);
        field2(t).forEach((_2) => sf.mod(_2));
      });
      pulse2.visit(pulse2.ADD, (t) => {
        const sf = subflow(t);
        field2(t).forEach((_2) => sf.add(ingest$1(_2)));
      });
      pulse2.visit(pulse2.REM, (t) => {
        const sf = subflow(t);
        field2(t).forEach((_2) => sf.rem(_2));
      });
    } else {
      pulse2.visit(pulse2.MOD, (t) => subflow(t).mod(t));
      pulse2.visit(pulse2.ADD, (t) => subflow(t).add(t));
      pulse2.visit(pulse2.REM, (t) => subflow(t).rem(t));
    }
    if (pulse2.clean()) {
      pulse2.runAfter(() => this.clean());
    }
    return pulse2;
  }
});
function Project(params2) {
  Transform.call(this, null, params2);
}
Project.Definition = {
  "type": "Project",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "fields",
    "type": "field",
    "array": true
  }, {
    "name": "as",
    "type": "string",
    "null": true,
    "array": true
  }]
};
inherits(Project, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE), fields = _.fields, as = fieldNames(_.fields, _.as || []), derive2 = fields ? (s, t) => project(s, t, fields, as) : rederive;
    let lut;
    if (this.value) {
      lut = this.value;
    } else {
      pulse2 = pulse2.addAll();
      lut = this.value = {};
    }
    pulse2.visit(pulse2.REM, (t) => {
      const id2 = tupleid(t);
      out.rem.push(lut[id2]);
      lut[id2] = null;
    });
    pulse2.visit(pulse2.ADD, (t) => {
      const dt = derive2(t, ingest$1({}));
      lut[tupleid(t)] = dt;
      out.add.push(dt);
    });
    pulse2.visit(pulse2.MOD, (t) => {
      out.mod.push(derive2(t, lut[tupleid(t)]));
    });
    return out;
  }
});
function project(s, t, fields, as) {
  for (let i = 0, n = fields.length; i < n; ++i) {
    t[as[i]] = fields[i](s);
  }
  return t;
}
function Proxy$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Proxy$1, Transform, {
  transform(_, pulse2) {
    this.value = _.value;
    return _.modified("value") ? pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS) : pulse2.StopPropagation;
  }
});
function Quantile$1(params2) {
  Transform.call(this, null, params2);
}
Quantile$1.Definition = {
  "type": "Quantile",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "probs",
    "type": "number",
    "array": true
  }, {
    "name": "step",
    "type": "number",
    "default": 0.01
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "default": ["prob", "value"]
  }]
};
const EPSILON = 1e-14;
inherits(Quantile$1, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), as = _.as || ["prob", "value"];
    if (this.value && !_.modified() && !pulse2.changed()) {
      out.source = this.value;
      return out;
    }
    const source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition$1$1(source2, _.groupby, _.field), names = (_.groupby || []).map(accessorName), values2 = [], step = _.step || 0.01, p = _.probs || range$4(step / 2, 1 - EPSILON, step), n = p.length;
    groups.forEach((g) => {
      const q = quantiles(g, p);
      for (let i = 0; i < n; ++i) {
        const t = {};
        for (let i2 = 0; i2 < names.length; ++i2) {
          t[names[i2]] = g.dims[i2];
        }
        t[as[0]] = p[i];
        t[as[1]] = q[i];
        values2.push(ingest$1(t));
      }
    });
    if (this.value)
      out.rem = this.value;
    this.value = out.add = out.source = values2;
    return out;
  }
});
function Relay$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Relay$1, Transform, {
  transform(_, pulse2) {
    let out, lut;
    if (this.value) {
      lut = this.value;
    } else {
      out = pulse2 = pulse2.addAll();
      lut = this.value = {};
    }
    if (_.derive) {
      out = pulse2.fork(pulse2.NO_SOURCE);
      pulse2.visit(pulse2.REM, (t) => {
        const id2 = tupleid(t);
        out.rem.push(lut[id2]);
        lut[id2] = null;
      });
      pulse2.visit(pulse2.ADD, (t) => {
        const dt = derive(t);
        lut[tupleid(t)] = dt;
        out.add.push(dt);
      });
      pulse2.visit(pulse2.MOD, (t) => {
        const dt = lut[tupleid(t)];
        for (const k in t) {
          dt[k] = t[k];
          out.modifies(k);
        }
        out.mod.push(dt);
      });
    }
    return out;
  }
});
function Sample(params2) {
  Transform.call(this, [], params2);
  this.count = 0;
}
Sample.Definition = {
  "type": "Sample",
  "metadata": {},
  "params": [{
    "name": "size",
    "type": "number",
    "default": 1e3
  }]
};
inherits(Sample, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE), mod = _.modified("size"), num = _.size, map2 = this.value.reduce((m2, t) => (m2[tupleid(t)] = 1, m2), {});
    let res = this.value, cnt = this.count, cap = 0;
    function update2(t) {
      let p, idx;
      if (res.length < num) {
        res.push(t);
      } else {
        idx = ~~((cnt + 1) * random());
        if (idx < res.length && idx >= cap) {
          p = res[idx];
          if (map2[tupleid(p)])
            out.rem.push(p);
          res[idx] = t;
        }
      }
      ++cnt;
    }
    if (pulse2.rem.length) {
      pulse2.visit(pulse2.REM, (t) => {
        const id2 = tupleid(t);
        if (map2[id2]) {
          map2[id2] = -1;
          out.rem.push(t);
        }
        --cnt;
      });
      res = res.filter((t) => map2[tupleid(t)] !== -1);
    }
    if ((pulse2.rem.length || mod) && res.length < num && pulse2.source) {
      cap = cnt = res.length;
      pulse2.visit(pulse2.SOURCE, (t) => {
        if (!map2[tupleid(t)])
          update2(t);
      });
      cap = -1;
    }
    if (mod && res.length > num) {
      const n = res.length - num;
      for (let i = 0; i < n; ++i) {
        map2[tupleid(res[i])] = -1;
        out.rem.push(res[i]);
      }
      res = res.slice(n);
    }
    if (pulse2.mod.length) {
      pulse2.visit(pulse2.MOD, (t) => {
        if (map2[tupleid(t)])
          out.mod.push(t);
      });
    }
    if (pulse2.add.length) {
      pulse2.visit(pulse2.ADD, update2);
    }
    if (pulse2.add.length || cap < 0) {
      out.add = res.filter((t) => !map2[tupleid(t)]);
    }
    this.count = cnt;
    this.value = out.source = res;
    return out;
  }
});
function Sequence(params2) {
  Transform.call(this, null, params2);
}
Sequence.Definition = {
  "type": "Sequence",
  "metadata": {
    "generates": true,
    "changes": true
  },
  "params": [{
    "name": "start",
    "type": "number",
    "required": true
  }, {
    "name": "stop",
    "type": "number",
    "required": true
  }, {
    "name": "step",
    "type": "number",
    "default": 1
  }, {
    "name": "as",
    "type": "string",
    "default": "data"
  }]
};
inherits(Sequence, Transform, {
  transform(_, pulse2) {
    if (this.value && !_.modified())
      return;
    const out = pulse2.materialize().fork(pulse2.MOD), as = _.as || "data";
    out.rem = this.value ? pulse2.rem.concat(this.value) : pulse2.rem;
    this.value = range$4(_.start, _.stop, _.step || 1).map((v) => {
      const t = {};
      t[as] = v;
      return ingest$1(t);
    });
    out.add = pulse2.add.concat(this.value);
    return out;
  }
});
function Sieve$1(params2) {
  Transform.call(this, null, params2);
  this.modified(true);
}
inherits(Sieve$1, Transform, {
  transform(_, pulse2) {
    this.value = pulse2.source;
    return pulse2.changed() ? pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS) : pulse2.StopPropagation;
  }
});
function TimeUnit(params2) {
  Transform.call(this, null, params2);
}
const OUTPUT = ["unit0", "unit1"];
TimeUnit.Definition = {
  "type": "TimeUnit",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field",
    "required": true
  }, {
    "name": "interval",
    "type": "boolean",
    "default": true
  }, {
    "name": "units",
    "type": "enum",
    "values": TIME_UNITS,
    "array": true
  }, {
    "name": "step",
    "type": "number",
    "default": 1
  }, {
    "name": "maxbins",
    "type": "number",
    "default": 40
  }, {
    "name": "extent",
    "type": "date",
    "array": true
  }, {
    "name": "timezone",
    "type": "enum",
    "default": "local",
    "values": ["local", "utc"]
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": OUTPUT
  }]
};
inherits(TimeUnit, Transform, {
  transform(_, pulse2) {
    const field2 = _.field, band2 = _.interval !== false, utc = _.timezone === "utc", floor2 = this._floor(_, pulse2), offset2 = (utc ? utcInterval : timeInterval)(floor2.unit).offset, as = _.as || OUTPUT, u0 = as[0], u1 = as[1], step = floor2.step;
    let min2 = floor2.start || Infinity, max2 = floor2.stop || -Infinity, flag2 = pulse2.ADD;
    if (_.modified() || pulse2.changed(pulse2.REM) || pulse2.modified(accessorFields(field2))) {
      pulse2 = pulse2.reflow(true);
      flag2 = pulse2.SOURCE;
      min2 = Infinity;
      max2 = -Infinity;
    }
    pulse2.visit(flag2, (t) => {
      const v = field2(t);
      let a2, b2;
      if (v == null) {
        t[u0] = null;
        if (band2)
          t[u1] = null;
      } else {
        t[u0] = a2 = b2 = floor2(v);
        if (band2)
          t[u1] = b2 = offset2(a2, step);
        if (a2 < min2)
          min2 = a2;
        if (b2 > max2)
          max2 = b2;
      }
    });
    floor2.start = min2;
    floor2.stop = max2;
    return pulse2.modifies(band2 ? as : u0);
  },
  _floor(_, pulse2) {
    const utc = _.timezone === "utc";
    const {
      units,
      step
    } = _.units ? {
      units: _.units,
      step: _.step || 1
    } : bin$1({
      extent: _.extent || extent(pulse2.materialize(pulse2.SOURCE).source, _.field),
      maxbins: _.maxbins
    });
    const tunits = timeUnits(units), prev = this.value || {}, floor2 = (utc ? utcFloor : timeFloor)(tunits, step);
    floor2.unit = peek$2(tunits);
    floor2.units = tunits;
    floor2.step = step;
    floor2.start = prev.start;
    floor2.stop = prev.stop;
    return this.value = floor2;
  }
});
function TupleIndex(params2) {
  Transform.call(this, fastmap(), params2);
}
inherits(TupleIndex, Transform, {
  transform(_, pulse2) {
    const df = pulse2.dataflow, field2 = _.field, index2 = this.value, set2 = (t) => index2.set(field2(t), t);
    let mod = true;
    if (_.modified("field") || pulse2.modified(field2.fields)) {
      index2.clear();
      pulse2.visit(pulse2.SOURCE, set2);
    } else if (pulse2.changed()) {
      pulse2.visit(pulse2.REM, (t) => index2.delete(field2(t)));
      pulse2.visit(pulse2.ADD, set2);
    } else {
      mod = false;
    }
    this.modified(mod);
    if (index2.empty > df.cleanThreshold)
      df.runAfter(index2.clean);
    return pulse2.fork();
  }
});
function Values$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Values$1, Transform, {
  transform(_, pulse2) {
    const run2 = !this.value || _.modified("field") || _.modified("sort") || pulse2.changed() || _.sort && pulse2.modified(_.sort.fields);
    if (run2) {
      this.value = (_.sort ? pulse2.source.slice().sort(stableCompare(_.sort)) : pulse2.source).map(_.field);
    }
  }
});
function WindowOp(op, field2, param2, as) {
  const fn = WindowOps[op](field2, param2);
  return {
    init: fn.init || zero$1,
    update: function(w2, t) {
      t[as] = fn.next(w2);
    }
  };
}
const WindowOps = {
  row_number: function() {
    return {
      next: (w2) => w2.index + 1
    };
  },
  rank: function() {
    let rank2;
    return {
      init: () => rank2 = 1,
      next: (w2) => {
        const i = w2.index, data2 = w2.data;
        return i && w2.compare(data2[i - 1], data2[i]) ? rank2 = i + 1 : rank2;
      }
    };
  },
  dense_rank: function() {
    let drank;
    return {
      init: () => drank = 1,
      next: (w2) => {
        const i = w2.index, d = w2.data;
        return i && w2.compare(d[i - 1], d[i]) ? ++drank : drank;
      }
    };
  },
  percent_rank: function() {
    const rank2 = WindowOps.rank(), next = rank2.next;
    return {
      init: rank2.init,
      next: (w2) => (next(w2) - 1) / (w2.data.length - 1)
    };
  },
  cume_dist: function() {
    let cume;
    return {
      init: () => cume = 0,
      next: (w2) => {
        const d = w2.data, c2 = w2.compare;
        let i = w2.index;
        if (cume < i) {
          while (i + 1 < d.length && !c2(d[i], d[i + 1]))
            ++i;
          cume = i;
        }
        return (1 + cume) / d.length;
      }
    };
  },
  ntile: function(field2, num) {
    num = +num;
    if (!(num > 0))
      error("ntile num must be greater than zero.");
    const cume = WindowOps.cume_dist(), next = cume.next;
    return {
      init: cume.init,
      next: (w2) => Math.ceil(num * next(w2))
    };
  },
  lag: function(field2, offset2) {
    offset2 = +offset2 || 1;
    return {
      next: (w2) => {
        const i = w2.index - offset2;
        return i >= 0 ? field2(w2.data[i]) : null;
      }
    };
  },
  lead: function(field2, offset2) {
    offset2 = +offset2 || 1;
    return {
      next: (w2) => {
        const i = w2.index + offset2, d = w2.data;
        return i < d.length ? field2(d[i]) : null;
      }
    };
  },
  first_value: function(field2) {
    return {
      next: (w2) => field2(w2.data[w2.i0])
    };
  },
  last_value: function(field2) {
    return {
      next: (w2) => field2(w2.data[w2.i1 - 1])
    };
  },
  nth_value: function(field2, nth) {
    nth = +nth;
    if (!(nth > 0))
      error("nth_value nth must be greater than zero.");
    return {
      next: (w2) => {
        const i = w2.i0 + (nth - 1);
        return i < w2.i1 ? field2(w2.data[i]) : null;
      }
    };
  },
  prev_value: function(field2) {
    let prev;
    return {
      init: () => prev = null,
      next: (w2) => {
        const v = field2(w2.data[w2.index]);
        return v != null ? prev = v : prev;
      }
    };
  },
  next_value: function(field2) {
    let v, i;
    return {
      init: () => (v = null, i = -1),
      next: (w2) => {
        const d = w2.data;
        return w2.index <= i ? v : (i = find$1(field2, d, w2.index)) < 0 ? (i = d.length, v = null) : v = field2(d[i]);
      }
    };
  }
};
function find$1(field2, data2, index2) {
  for (let n = data2.length; index2 < n; ++index2) {
    const v = field2(data2[index2]);
    if (v != null)
      return index2;
  }
  return -1;
}
const ValidWindowOps = Object.keys(WindowOps);
function WindowState(_) {
  const ops2 = array$3(_.ops), fields = array$3(_.fields), params2 = array$3(_.params), as = array$3(_.as), outputs = this.outputs = [], windows = this.windows = [], inputs = {}, map2 = {}, counts = [], measures = [];
  let countOnly = true;
  function visitInputs(f) {
    array$3(accessorFields(f)).forEach((_2) => inputs[_2] = 1);
  }
  visitInputs(_.sort);
  ops2.forEach((op, i) => {
    const field2 = fields[i], mname = accessorName(field2), name = measureName(op, mname, as[i]);
    visitInputs(field2);
    outputs.push(name);
    if (has$1(WindowOps, op)) {
      windows.push(WindowOp(op, fields[i], params2[i], name));
    } else {
      if (field2 == null && op !== "count") {
        error("Null aggregate field specified.");
      }
      if (op === "count") {
        counts.push(name);
        return;
      }
      countOnly = false;
      let m2 = map2[mname];
      if (!m2) {
        m2 = map2[mname] = [];
        m2.field = field2;
        measures.push(m2);
      }
      m2.push(createMeasure(op, name));
    }
  });
  if (counts.length || measures.length) {
    this.cell = cell(measures, counts, countOnly);
  }
  this.inputs = Object.keys(inputs);
}
const prototype = WindowState.prototype;
prototype.init = function() {
  this.windows.forEach((_) => _.init());
  if (this.cell)
    this.cell.init();
};
prototype.update = function(w2, t) {
  const cell2 = this.cell, wind = this.windows, data2 = w2.data, m2 = wind && wind.length;
  let j;
  if (cell2) {
    for (j = w2.p0; j < w2.i0; ++j)
      cell2.rem(data2[j]);
    for (j = w2.p1; j < w2.i1; ++j)
      cell2.add(data2[j]);
    cell2.set(t);
  }
  for (j = 0; j < m2; ++j)
    wind[j].update(w2, t);
};
function cell(measures, counts, countOnly) {
  measures = measures.map((m2) => compileMeasures(m2, m2.field));
  const cell2 = {
    num: 0,
    agg: null,
    store: false,
    count: counts
  };
  if (!countOnly) {
    var n = measures.length, a2 = cell2.agg = Array(n), i = 0;
    for (; i < n; ++i)
      a2[i] = new measures[i](cell2);
  }
  if (cell2.store) {
    var store = cell2.data = new TupleStore();
  }
  cell2.add = function(t) {
    cell2.num += 1;
    if (countOnly)
      return;
    if (store)
      store.add(t);
    for (let i2 = 0; i2 < n; ++i2) {
      a2[i2].add(a2[i2].get(t), t);
    }
  };
  cell2.rem = function(t) {
    cell2.num -= 1;
    if (countOnly)
      return;
    if (store)
      store.rem(t);
    for (let i2 = 0; i2 < n; ++i2) {
      a2[i2].rem(a2[i2].get(t), t);
    }
  };
  cell2.set = function(t) {
    let i2, n2;
    if (store)
      store.values();
    for (i2 = 0, n2 = counts.length; i2 < n2; ++i2)
      t[counts[i2]] = cell2.num;
    if (!countOnly)
      for (i2 = 0, n2 = a2.length; i2 < n2; ++i2)
        a2[i2].set(t);
  };
  cell2.init = function() {
    cell2.num = 0;
    if (store)
      store.reset();
    for (let i2 = 0; i2 < n; ++i2)
      a2[i2].init();
  };
  return cell2;
}
function Window(params2) {
  Transform.call(this, {}, params2);
  this._mlen = 0;
  this._mods = [];
}
Window.Definition = {
  "type": "Window",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "sort",
    "type": "compare"
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "ops",
    "type": "enum",
    "array": true,
    "values": ValidWindowOps.concat(ValidAggregateOps)
  }, {
    "name": "params",
    "type": "number",
    "null": true,
    "array": true
  }, {
    "name": "fields",
    "type": "field",
    "null": true,
    "array": true
  }, {
    "name": "as",
    "type": "string",
    "null": true,
    "array": true
  }, {
    "name": "frame",
    "type": "number",
    "null": true,
    "array": true,
    "length": 2,
    "default": [null, 0]
  }, {
    "name": "ignorePeers",
    "type": "boolean",
    "default": false
  }]
};
inherits(Window, Transform, {
  transform(_, pulse2) {
    this.stamp = pulse2.stamp;
    const mod = _.modified(), cmp = stableCompare(_.sort), key2 = groupkey(_.groupby), group2 = (t) => this.group(key2(t));
    let state = this.state;
    if (!state || mod) {
      state = this.state = new WindowState(_);
    }
    if (mod || pulse2.modified(state.inputs)) {
      this.value = {};
      pulse2.visit(pulse2.SOURCE, (t) => group2(t).add(t));
    } else {
      pulse2.visit(pulse2.REM, (t) => group2(t).remove(t));
      pulse2.visit(pulse2.ADD, (t) => group2(t).add(t));
    }
    for (let i = 0, n = this._mlen; i < n; ++i) {
      processPartition(this._mods[i], state, cmp, _);
    }
    this._mlen = 0;
    this._mods = [];
    return pulse2.reflow(mod).modifies(state.outputs);
  },
  group(key2) {
    let group2 = this.value[key2];
    if (!group2) {
      group2 = this.value[key2] = SortedList(tupleid);
      group2.stamp = -1;
    }
    if (group2.stamp < this.stamp) {
      group2.stamp = this.stamp;
      this._mods[this._mlen++] = group2;
    }
    return group2;
  }
});
function processPartition(list, state, cmp, _) {
  const sort2 = _.sort, range2 = sort2 && !_.ignorePeers, frame2 = _.frame || [null, 0], data2 = list.data(cmp), n = data2.length, b2 = range2 ? bisector(sort2) : null, w2 = {
    i0: 0,
    i1: 0,
    p0: 0,
    p1: 0,
    index: 0,
    data: data2,
    compare: sort2 || constant(-1)
  };
  state.init();
  for (let i = 0; i < n; ++i) {
    setWindow(w2, frame2, i, n);
    if (range2)
      adjustRange(w2, b2);
    state.update(w2, data2[i]);
  }
}
function setWindow(w2, f, i, n) {
  w2.p0 = w2.i0;
  w2.p1 = w2.i1;
  w2.i0 = f[0] == null ? 0 : Math.max(0, i - Math.abs(f[0]));
  w2.i1 = f[1] == null ? n : Math.min(n, i + Math.abs(f[1]) + 1);
  w2.index = i;
}
function adjustRange(w2, bisect2) {
  const r0 = w2.i0, r1 = w2.i1 - 1, c2 = w2.compare, d = w2.data, n = d.length - 1;
  if (r0 > 0 && !c2(d[r0], d[r0 - 1]))
    w2.i0 = bisect2.left(d, d[r0]);
  if (r1 < n && !c2(d[r1], d[r1 + 1]))
    w2.i1 = bisect2.right(d, d[r1]);
}
const tx = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  aggregate: Aggregate$1,
  bin: Bin,
  collect: Collect$1,
  compare: Compare$1,
  countpattern: CountPattern,
  cross: Cross,
  density: Density,
  dotbin: DotBin,
  expression: Expression$1,
  extent: Extent,
  facet: Facet$1,
  field: Field$1,
  filter: Filter,
  flatten: Flatten,
  fold: Fold,
  formula: Formula,
  generate: Generate,
  impute: Impute,
  joinaggregate: JoinAggregate,
  kde: KDE,
  key: Key$1,
  load: Load$1,
  lookup: Lookup,
  multiextent: MultiExtent$1,
  multivalues: MultiValues$1,
  params: Params$2,
  pivot: Pivot,
  prefacet: PreFacet$1,
  project: Project,
  proxy: Proxy$1,
  quantile: Quantile$1,
  relay: Relay$1,
  sample: Sample,
  sequence: Sequence,
  sieve: Sieve$1,
  subflow: Subflow,
  timeunit: TimeUnit,
  tupleindex: TupleIndex,
  values: Values$1,
  window: Window
}, Symbol.toStringTag, { value: "Module" }));
function domCanvas(w2, h2) {
  if (typeof document !== "undefined" && document.createElement) {
    const c2 = document.createElement("canvas");
    if (c2 && c2.getContext) {
      c2.width = w2;
      c2.height = h2;
      return c2;
    }
  }
  return null;
}
const domImage = () => typeof Image !== "undefined" ? Image : null;
let NodeCanvas;
try {
  NodeCanvas = require("canvas");
  if (!(NodeCanvas && NodeCanvas.createCanvas)) {
    NodeCanvas = null;
  }
} catch (error2) {
}
function nodeCanvas(w2, h2, type2) {
  if (NodeCanvas) {
    try {
      return new NodeCanvas.Canvas(w2, h2, type2);
    } catch (e) {
    }
  }
  return null;
}
const nodeImage = () => NodeCanvas && NodeCanvas.Image || null;
function canvas(w2, h2, type2) {
  return domCanvas(w2, h2) || nodeCanvas(w2, h2, type2) || null;
}
function image$1() {
  return domImage() || nodeImage() || null;
}
function bandSpace(count2, paddingInner, paddingOuter) {
  const space = count2 - paddingInner + paddingOuter * 2;
  return count2 ? space > 0 ? space : 1 : 0;
}
const Identity = "identity";
const Linear = "linear";
const Log = "log";
const Pow = "pow";
const Sqrt = "sqrt";
const Symlog = "symlog";
const Time = "time";
const UTC = "utc";
const Sequential = "sequential";
const Diverging = "diverging";
const Quantile = "quantile";
const Quantize = "quantize";
const Threshold = "threshold";
const Ordinal = "ordinal";
const Point = "point";
const Band = "band";
const BinOrdinal = "bin-ordinal";
const Continuous = "continuous";
const Discrete$1 = "discrete";
const Discretizing = "discretizing";
const Interpolating = "interpolating";
const Temporal = "temporal";
function invertRange(scale2) {
  return function(_) {
    let lo = _[0], hi = _[1], t;
    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }
    return [scale2.invert(lo), scale2.invert(hi)];
  };
}
function invertRangeExtent(scale2) {
  return function(_) {
    const range2 = scale2.range();
    let lo = _[0], hi = _[1], min2 = -1, max2, t, i, n;
    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }
    for (i = 0, n = range2.length; i < n; ++i) {
      if (range2[i] >= lo && range2[i] <= hi) {
        if (min2 < 0)
          min2 = i;
        max2 = i;
      }
    }
    if (min2 < 0)
      return void 0;
    lo = scale2.invertExtent(range2[min2]);
    hi = scale2.invertExtent(range2[max2]);
    return [lo[0] === void 0 ? lo[1] : lo[0], hi[1] === void 0 ? hi[0] : hi[1]];
  };
}
function band() {
  const scale2 = ordinal().unknown(void 0), domain2 = scale2.domain, ordinalRange = scale2.range;
  let range$12 = [0, 1], step, bandwidth2, round = false, paddingInner = 0, paddingOuter = 0, align = 0.5;
  delete scale2.unknown;
  function rescale() {
    const n = domain2().length, reverse2 = range$12[1] < range$12[0], stop2 = range$12[1 - reverse2], space = bandSpace(n, paddingInner, paddingOuter);
    let start = range$12[reverse2 - 0];
    step = (stop2 - start) / (space || 1);
    if (round) {
      step = Math.floor(step);
    }
    start += (stop2 - start - step * (n - paddingInner)) * align;
    bandwidth2 = step * (1 - paddingInner);
    if (round) {
      start = Math.round(start);
      bandwidth2 = Math.round(bandwidth2);
    }
    const values2 = range$4(n).map((i) => start + step * i);
    return ordinalRange(reverse2 ? values2.reverse() : values2);
  }
  scale2.domain = function(_) {
    if (arguments.length) {
      domain2(_);
      return rescale();
    } else {
      return domain2();
    }
  };
  scale2.range = function(_) {
    if (arguments.length) {
      range$12 = [+_[0], +_[1]];
      return rescale();
    } else {
      return range$12.slice();
    }
  };
  scale2.rangeRound = function(_) {
    range$12 = [+_[0], +_[1]];
    round = true;
    return rescale();
  };
  scale2.bandwidth = function() {
    return bandwidth2;
  };
  scale2.step = function() {
    return step;
  };
  scale2.round = function(_) {
    if (arguments.length) {
      round = !!_;
      return rescale();
    } else {
      return round;
    }
  };
  scale2.padding = function(_) {
    if (arguments.length) {
      paddingOuter = Math.max(0, Math.min(1, _));
      paddingInner = paddingOuter;
      return rescale();
    } else {
      return paddingInner;
    }
  };
  scale2.paddingInner = function(_) {
    if (arguments.length) {
      paddingInner = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return paddingInner;
    }
  };
  scale2.paddingOuter = function(_) {
    if (arguments.length) {
      paddingOuter = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return paddingOuter;
    }
  };
  scale2.align = function(_) {
    if (arguments.length) {
      align = Math.max(0, Math.min(1, _));
      return rescale();
    } else {
      return align;
    }
  };
  scale2.invertRange = function(_) {
    if (_[0] == null || _[1] == null)
      return;
    const reverse2 = range$12[1] < range$12[0], values2 = reverse2 ? ordinalRange().reverse() : ordinalRange(), n = values2.length - 1;
    let lo = +_[0], hi = +_[1], a2, b2, t;
    if (lo !== lo || hi !== hi)
      return;
    if (hi < lo) {
      t = lo;
      lo = hi;
      hi = t;
    }
    if (hi < values2[0] || lo > range$12[1 - reverse2])
      return;
    a2 = Math.max(0, bisectRight$1(values2, lo) - 1);
    b2 = lo === hi ? a2 : bisectRight$1(values2, hi) - 1;
    if (lo - values2[a2] > bandwidth2 + 1e-10)
      ++a2;
    if (reverse2) {
      t = a2;
      a2 = n - b2;
      b2 = n - t;
    }
    return a2 > b2 ? void 0 : domain2().slice(a2, b2 + 1);
  };
  scale2.invert = function(_) {
    const value2 = scale2.invertRange([_, _]);
    return value2 ? value2[0] : value2;
  };
  scale2.copy = function() {
    return band().domain(domain2()).range(range$12).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align);
  };
  return rescale();
}
function pointish(scale2) {
  const copy2 = scale2.copy;
  scale2.padding = scale2.paddingOuter;
  delete scale2.paddingInner;
  scale2.copy = function() {
    return pointish(copy2());
  };
  return scale2;
}
function point$1() {
  return pointish(band().paddingInner(1));
}
var map = Array.prototype.map;
function numbers(_) {
  return map.call(_, toNumber);
}
const slice$3 = Array.prototype.slice;
function scaleBinOrdinal() {
  let domain2 = [], range2 = [];
  function scale2(x2) {
    return x2 == null || x2 !== x2 ? void 0 : range2[(bisectRight$1(domain2, x2) - 1) % range2.length];
  }
  scale2.domain = function(_) {
    if (arguments.length) {
      domain2 = numbers(_);
      return scale2;
    } else {
      return domain2.slice();
    }
  };
  scale2.range = function(_) {
    if (arguments.length) {
      range2 = slice$3.call(_);
      return scale2;
    } else {
      return range2.slice();
    }
  };
  scale2.tickFormat = function(count2, specifier) {
    return tickFormat$1(domain2[0], peek$2(domain2), count2 == null ? 10 : count2, specifier);
  };
  scale2.copy = function() {
    return scaleBinOrdinal().domain(scale2.domain()).range(scale2.range());
  };
  return scale2;
}
const scales = /* @__PURE__ */ new Map();
const VEGA_SCALE = Symbol("vega_scale");
function registerScale(scale2) {
  scale2[VEGA_SCALE] = true;
  return scale2;
}
function isRegisteredScale(scale2) {
  return scale2 && scale2[VEGA_SCALE] === true;
}
function create$2(type2, constructor, metadata2) {
  const ctr = function scale2() {
    const s = constructor();
    if (!s.invertRange) {
      s.invertRange = s.invert ? invertRange(s) : s.invertExtent ? invertRangeExtent(s) : void 0;
    }
    s.type = type2;
    return registerScale(s);
  };
  ctr.metadata = toSet(array$3(metadata2));
  return ctr;
}
function scale$5(type2, scale2, metadata2) {
  if (arguments.length > 1) {
    scales.set(type2, create$2(type2, scale2, metadata2));
    return this;
  } else {
    return isValidScaleType(type2) ? scales.get(type2) : void 0;
  }
}
scale$5(Identity, identity$2);
scale$5(Linear, linear$1, Continuous);
scale$5(Log, log$4, [Continuous, Log]);
scale$5(Pow, pow$2, Continuous);
scale$5(Sqrt, sqrt$2, Continuous);
scale$5(Symlog, symlog$1, Continuous);
scale$5(Time, time$2, [Continuous, Temporal]);
scale$5(UTC, utcTime, [Continuous, Temporal]);
scale$5(Sequential, sequential, [Continuous, Interpolating]);
scale$5(`${Sequential}-${Linear}`, sequential, [Continuous, Interpolating]);
scale$5(`${Sequential}-${Log}`, sequentialLog, [Continuous, Interpolating, Log]);
scale$5(`${Sequential}-${Pow}`, sequentialPow, [Continuous, Interpolating]);
scale$5(`${Sequential}-${Sqrt}`, sequentialSqrt, [Continuous, Interpolating]);
scale$5(`${Sequential}-${Symlog}`, sequentialSymlog, [Continuous, Interpolating]);
scale$5(`${Diverging}-${Linear}`, diverging, [Continuous, Interpolating]);
scale$5(`${Diverging}-${Log}`, divergingLog, [Continuous, Interpolating, Log]);
scale$5(`${Diverging}-${Pow}`, divergingPow, [Continuous, Interpolating]);
scale$5(`${Diverging}-${Sqrt}`, divergingSqrt, [Continuous, Interpolating]);
scale$5(`${Diverging}-${Symlog}`, divergingSymlog, [Continuous, Interpolating]);
scale$5(Quantile, quantile, [Discretizing, Quantile]);
scale$5(Quantize, quantize$1, Discretizing);
scale$5(Threshold, threshold, Discretizing);
scale$5(BinOrdinal, scaleBinOrdinal, [Discrete$1, Discretizing]);
scale$5(Ordinal, ordinal, Discrete$1);
scale$5(Band, band, Discrete$1);
scale$5(Point, point$1, Discrete$1);
function isValidScaleType(type2) {
  return scales.has(type2);
}
function hasType(key2, type2) {
  const s = scales.get(key2);
  return s && s.metadata[type2];
}
function isContinuous(key2) {
  return hasType(key2, Continuous);
}
function isDiscrete(key2) {
  return hasType(key2, Discrete$1);
}
function isDiscretizing(key2) {
  return hasType(key2, Discretizing);
}
function isLogarithmic(key2) {
  return hasType(key2, Log);
}
function isTemporal(key2) {
  return hasType(key2, Temporal);
}
function isInterpolating(key2) {
  return hasType(key2, Interpolating);
}
function isQuantile(key2) {
  return hasType(key2, Quantile);
}
const scaleProps = ["clamp", "base", "constant", "exponent"];
function interpolateRange(interpolator, range2) {
  const start = range2[0], span2 = peek$2(range2) - start;
  return function(i) {
    return interpolator(start + i * span2);
  };
}
function interpolateColors(colors2, type2, gamma2) {
  return piecewise(interpolate(type2 || "rgb", gamma2), colors2);
}
function quantizeInterpolator(interpolator, count2) {
  const samples = new Array(count2), n = count2 + 1;
  for (let i = 0; i < count2; )
    samples[i] = interpolator(++i / n);
  return samples;
}
function scaleFraction(scale$12, min2, max2) {
  const delta = max2 - min2;
  let i, t, s;
  if (!delta || !Number.isFinite(delta)) {
    return constant(0.5);
  } else {
    i = (t = scale$12.type).indexOf("-");
    t = i < 0 ? t : t.slice(i + 1);
    s = scale$5(t)().domain([min2, max2]).range([0, 1]);
    scaleProps.forEach((m2) => scale$12[m2] ? s[m2](scale$12[m2]()) : 0);
    return s;
  }
}
function interpolate(type2, gamma2) {
  const interp = $$1[method(type2)];
  return gamma2 != null && interp && interp.gamma ? interp.gamma(gamma2) : interp;
}
function method(type2) {
  return "interpolate" + type2.toLowerCase().split("-").map((s) => s[0].toUpperCase() + s.slice(1)).join("");
}
const continuous = {
  blues: "cfe1f2bed8eca8cee58fc1de74b2d75ba3cf4592c63181bd206fb2125ca40a4a90",
  greens: "d3eecdc0e6baabdda594d3917bc77d60ba6c46ab5e329a512089430e7735036429",
  greys: "e2e2e2d4d4d4c4c4c4b1b1b19d9d9d8888887575756262624d4d4d3535351e1e1e",
  oranges: "fdd8b3fdc998fdb87bfda55efc9244f87f2cf06b18e4580bd14904b93d029f3303",
  purples: "e2e1efd4d4e8c4c5e0b4b3d6a3a0cc928ec3827cb97566ae684ea25c3696501f8c",
  reds: "fdc9b4fcb49afc9e80fc8767fa7051f6573fec3f2fdc2a25c81b1db21218970b13",
  blueGreen: "d5efedc1e8e0a7ddd18bd2be70c6a958ba9144ad77319c5d2089460e7736036429",
  bluePurple: "ccddecbad0e4a8c2dd9ab0d4919cc98d85be8b6db28a55a6873c99822287730f71",
  greenBlue: "d3eecec5e8c3b1e1bb9bd8bb82cec269c2ca51b2cd3c9fc7288abd1675b10b60a1",
  orangeRed: "fddcaffdcf9bfdc18afdad77fb9562f67d53ee6545e24932d32d1ebf130da70403",
  purpleBlue: "dbdaebc8cee4b1c3de97b7d87bacd15b9fc93a90c01e7fb70b70ab056199045281",
  purpleBlueGreen: "dbd8eac8cee4b0c3de93b7d872acd1549fc83892bb1c88a3097f8702736b016353",
  purpleRed: "dcc9e2d3b3d7ce9eccd186c0da6bb2e14da0e23189d91e6fc61159ab07498f023a",
  redPurple: "fccfccfcbec0faa9b8f98faff571a5ec539ddb3695c41b8aa908808d0179700174",
  yellowGreen: "e4f4acd1eca0b9e2949ed68880c97c62bb6e47aa5e3297502083440e723b036034",
  yellowOrangeBrown: "feeaa1fedd84fecc63feb746fca031f68921eb7215db5e0bc54c05ab3d038f3204",
  yellowOrangeRed: "fee087fed16ffebd59fea849fd903efc7335f9522bee3423de1b20ca0b22af0225",
  blueOrange: "134b852f78b35da2cb9dcae1d2e5eff2f0ebfce0bafbbf74e8932fc5690d994a07",
  brownBlueGreen: "704108a0651ac79548e3c78af3e6c6eef1eac9e9e48ed1c74da79e187a72025147",
  purpleGreen: "5b1667834792a67fb6c9aed3e6d6e8eff0efd9efd5aedda971bb75368e490e5e29",
  purpleOrange: "4114696647968f83b7b9b4d6dadbebf3eeeafce0bafbbf74e8932fc5690d994a07",
  redBlue: "8c0d25bf363adf745ef4ae91fbdbc9f2efeed2e5ef9dcae15da2cb2f78b3134b85",
  redGrey: "8c0d25bf363adf745ef4ae91fcdccbfaf4f1e2e2e2c0c0c0969696646464343434",
  yellowGreenBlue: "eff9bddbf1b4bde5b594d5b969c5be45b4c22c9ec02182b82163aa23479c1c3185",
  redYellowBlue: "a50026d4322cf16e43fcac64fedd90faf8c1dcf1ecabd6e875abd04a74b4313695",
  redYellowGreen: "a50026d4322cf16e43fcac63fedd8df9f7aed7ee8ea4d86e64bc6122964f006837",
  pinkYellowGreen: "8e0152c0267edd72adf0b3d6faddedf5f3efe1f2cab6de8780bb474f9125276419",
  spectral: "9e0142d13c4bf0704afcac63fedd8dfbf8b0e0f3a1a9dda269bda94288b55e4fa2",
  viridis: "440154470e61481a6c482575472f7d443a834144873d4e8a39568c35608d31688e2d708e2a788e27818e23888e21918d1f988b1fa08822a8842ab07f35b77943bf7154c56866cc5d7ad1518fd744a5db36bcdf27d2e21be9e51afde725",
  magma: "0000040404130b0924150e3720114b2c11603b0f704a107957157e651a80721f817f24828c29819a2e80a8327db6377ac43c75d1426fde4968e95462f1605df76f5cfa7f5efc8f65fe9f6dfeaf78febf84fece91fddea0fcedaffcfdbf",
  inferno: "0000040403130c0826170c3b240c4f330a5f420a68500d6c5d126e6b176e781c6d86216b932667a12b62ae305cbb3755c73e4cd24644dd513ae65c30ed6925f3771af8850ffb9506fca50afcb519fac62df6d645f2e661f3f484fcffa4",
  plasma: "0d088723069033059742039d5002a25d01a66a00a87801a88405a7900da49c179ea72198b12a90ba3488c33d80cb4779d35171da5a69e16462e76e5bed7953f2834cf68f44fa9a3dfca636fdb32ffec029fcce25f9dc24f5ea27f0f921",
  cividis: "00205100235800265d002961012b65042e670831690d346b11366c16396d1c3c6e213f6e26426e2c456e31476e374a6e3c4d6e42506e47536d4c566d51586e555b6e5a5e6e5e616e62646f66676f6a6a706e6d717270717573727976737c79747f7c75827f758682768985778c8877908b78938e789691789a94789e9778a19b78a59e77a9a177aea575b2a874b6ab73bbaf71c0b26fc5b66dc9b96acebd68d3c065d8c462ddc85fe2cb5ce7cf58ebd355f0d652f3da4ff7de4cfae249fce647",
  rainbow: "6e40aa883eb1a43db3bf3cafd83fa4ee4395fe4b83ff576eff6659ff7847ff8c38f3a130e2b72fcfcc36bee044aff05b8ff4576ff65b52f6673af27828ea8d1ddfa319d0b81cbecb23abd82f96e03d82e14c6edb5a5dd0664dbf6e40aa",
  sinebow: "ff4040fc582af47218e78d0bd5a703bfbf00a7d5038de70b72f41858fc2a40ff402afc5818f4720be78d03d5a700bfbf03a7d50b8de71872f42a58fc4040ff582afc7218f48d0be7a703d5bf00bfd503a7e70b8df41872fc2a58ff4040",
  turbo: "23171b32204a3e2a71453493493eae4b49c54a53d7485ee44569ee4074f53c7ff8378af93295f72e9ff42ba9ef28b3e926bce125c5d925cdcf27d5c629dcbc2de3b232e9a738ee9d3ff39347f68950f9805afc7765fd6e70fe667cfd5e88fc5795fb51a1f84badf545b9f140c5ec3cd0e637dae034e4d931ecd12ef4c92bfac029ffb626ffad24ffa223ff9821ff8d1fff821dff771cfd6c1af76118f05616e84b14df4111d5380fcb2f0dc0260ab61f07ac1805a313029b0f00950c00910b00",
  browns: "eedbbdecca96e9b97ae4a865dc9856d18954c7784cc0673fb85536ad44339f3632",
  tealBlues: "bce4d89dd3d181c3cb65b3c245a2b9368fae347da0306a932c5985",
  teals: "bbdfdfa2d4d58ac9c975bcbb61b0af4da5a43799982b8b8c1e7f7f127273006667",
  warmGreys: "dcd4d0cec5c1c0b8b4b3aaa7a59c9998908c8b827f7e7673726866665c5a59504e",
  goldGreen: "f4d166d5ca60b6c35c98bb597cb25760a6564b9c533f8f4f33834a257740146c36",
  goldOrange: "f4d166f8be5cf8aa4cf5983bf3852aef701be2621fd65322c54923b142239e3a26",
  goldRed: "f4d166f6be59f9aa51fc964ef6834bee734ae56249db5247cf4244c43141b71d3e",
  lightGreyRed: "efe9e6e1dad7d5cbc8c8bdb9bbaea9cd967ddc7b43e15f19df4011dc000b",
  lightGreyTeal: "e4eaead6dcddc8ced2b7c2c7a6b4bc64b0bf22a6c32295c11f85be1876bc",
  lightMulti: "e0f1f2c4e9d0b0de9fd0e181f6e072f6c053f3993ef77440ef4a3c",
  lightOrange: "f2e7daf7d5baf9c499fab184fa9c73f68967ef7860e8645bde515bd43d5b",
  lightTealBlue: "e3e9e0c0dccf9aceca7abfc859afc0389fb9328dad2f7ca0276b95255988",
  darkBlue: "3232322d46681a5c930074af008cbf05a7ce25c0dd38daed50f3faffffff",
  darkGold: "3c3c3c584b37725e348c7631ae8b2bcfa424ecc31ef9de30fff184ffffff",
  darkGreen: "3a3a3a215748006f4d048942489e4276b340a6c63dd2d836ffeb2cffffaa",
  darkMulti: "3737371f5287197d8c29a86995ce3fffe800ffffff",
  darkRed: "3434347036339e3c38cc4037e75d1eec8620eeab29f0ce32ffeb2c"
};
const discrete = {
  category10: "1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf",
  category20: "1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",
  category20b: "393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6",
  category20c: "3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9",
  tableau10: "4c78a8f58518e4575672b7b254a24beeca3bb279a2ff9da69d755dbab0ac",
  tableau20: "4c78a89ecae9f58518ffbf7954a24b88d27ab79a20f2cf5b43989483bcb6e45756ff9d9879706ebab0acd67195fcbfd2b279a2d6a5c99e765fd8b5a5",
  accent: "7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666",
  dark2: "1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666",
  paired: "a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928",
  pastel1: "fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2",
  pastel2: "b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc",
  set1: "e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999",
  set2: "66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3",
  set3: "8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"
};
function colors(palette) {
  const n = palette.length / 6 | 0, c2 = new Array(n);
  for (let i = 0; i < n; ) {
    c2[i] = "#" + palette.slice(i * 6, ++i * 6);
  }
  return c2;
}
function apply$1(_, f) {
  for (const k in _)
    scheme(k, f(_[k]));
}
const schemes = {};
apply$1(discrete, colors);
apply$1(continuous, (_) => interpolateColors(colors(_)));
function scheme(name, scheme2) {
  name = name && name.toLowerCase();
  if (arguments.length > 1) {
    schemes[name] = scheme2;
    return this;
  } else {
    return schemes[name];
  }
}
const SymbolLegend = "symbol";
const DiscreteLegend = "discrete";
const GradientLegend = "gradient";
const defaultFormatter = (value2) => isArray(value2) ? value2.map((v) => String(v)) : String(value2);
const ascending = (a2, b2) => a2[1] - b2[1];
const descending = (a2, b2) => b2[1] - a2[1];
function tickCount(scale2, count2, minStep) {
  let step;
  if (isNumber$1(count2)) {
    if (scale2.bins) {
      count2 = Math.max(count2, scale2.bins.length);
    }
    if (minStep != null) {
      count2 = Math.min(count2, Math.floor(span(scale2.domain()) / minStep || 1) + 1);
    }
  }
  if (isObject(count2)) {
    step = count2.step;
    count2 = count2.interval;
  }
  if (isString(count2)) {
    count2 = scale2.type === Time ? timeInterval(count2) : scale2.type == UTC ? utcInterval(count2) : error("Only time and utc scales accept interval strings.");
    if (step)
      count2 = count2.every(step);
  }
  return count2;
}
function validTicks(scale2, ticks2, count2) {
  let range2 = scale2.range(), lo = range2[0], hi = peek$2(range2), cmp = ascending;
  if (lo > hi) {
    range2 = hi;
    hi = lo;
    lo = range2;
    cmp = descending;
  }
  lo = Math.floor(lo);
  hi = Math.ceil(hi);
  ticks2 = ticks2.map((v) => [v, scale2(v)]).filter((_) => lo <= _[1] && _[1] <= hi).sort(cmp).map((_) => _[0]);
  if (count2 > 0 && ticks2.length > 1) {
    const endpoints = [ticks2[0], peek$2(ticks2)];
    while (ticks2.length > count2 && ticks2.length >= 3) {
      ticks2 = ticks2.filter((_, i) => !(i % 2));
    }
    if (ticks2.length < 3) {
      ticks2 = endpoints;
    }
  }
  return ticks2;
}
function tickValues(scale2, count2) {
  return scale2.bins ? validTicks(scale2, scale2.bins) : scale2.ticks ? scale2.ticks(count2) : scale2.domain();
}
function tickFormat(locale2, scale2, count2, specifier, formatType, noSkip) {
  const type2 = scale2.type;
  let format2 = defaultFormatter;
  if (type2 === Time || formatType === Time) {
    format2 = locale2.timeFormat(specifier);
  } else if (type2 === UTC || formatType === UTC) {
    format2 = locale2.utcFormat(specifier);
  } else if (isLogarithmic(type2)) {
    const varfmt = locale2.formatFloat(specifier);
    if (noSkip || scale2.bins) {
      format2 = varfmt;
    } else {
      const test2 = tickLog(scale2, count2, false);
      format2 = (_) => test2(_) ? varfmt(_) : "";
    }
  } else if (scale2.tickFormat) {
    const d = scale2.domain();
    format2 = locale2.formatSpan(d[0], d[d.length - 1], count2, specifier);
  } else if (specifier) {
    format2 = locale2.format(specifier);
  }
  return format2;
}
function tickLog(scale2, count2, values2) {
  const ticks2 = tickValues(scale2, count2), base2 = scale2.base(), logb = Math.log(base2), k = Math.max(1, base2 * count2 / ticks2.length);
  const test2 = (d) => {
    let i = d / Math.pow(base2, Math.round(Math.log(d) / logb));
    if (i * base2 < base2 - 0.5)
      i *= base2;
    return i <= k;
  };
  return values2 ? ticks2.filter(test2) : test2;
}
const symbols$1 = {
  [Quantile]: "quantiles",
  [Quantize]: "thresholds",
  [Threshold]: "domain"
};
const formats = {
  [Quantile]: "quantiles",
  [Quantize]: "domain"
};
function labelValues(scale2, count2) {
  return scale2.bins ? binValues(scale2.bins) : scale2.type === Log ? tickLog(scale2, count2, true) : symbols$1[scale2.type] ? thresholdValues(scale2[symbols$1[scale2.type]]()) : tickValues(scale2, count2);
}
function thresholdFormat(locale2, scale2, specifier) {
  const _ = scale2[formats[scale2.type]](), n = _.length;
  let d = n > 1 ? _[1] - _[0] : _[0], i;
  for (i = 1; i < n; ++i) {
    d = Math.min(d, _[i] - _[i - 1]);
  }
  return locale2.formatSpan(0, d, 3 * 10, specifier);
}
function thresholdValues(thresholds) {
  const values2 = [-Infinity].concat(thresholds);
  values2.max = Infinity;
  return values2;
}
function binValues(bins) {
  const values2 = bins.slice(0, -1);
  values2.max = peek$2(bins);
  return values2;
}
const isDiscreteRange = (scale2) => symbols$1[scale2.type] || scale2.bins;
function labelFormat(locale2, scale2, count2, type2, specifier, formatType, noSkip) {
  const format2 = formats[scale2.type] && formatType !== Time && formatType !== UTC ? thresholdFormat(locale2, scale2, specifier) : tickFormat(locale2, scale2, count2, specifier, formatType, noSkip);
  return type2 === SymbolLegend && isDiscreteRange(scale2) ? formatRange(format2) : type2 === DiscreteLegend ? formatDiscrete(format2) : formatPoint(format2);
}
const formatRange = (format2) => (value2, index2, array2) => {
  const limit = get$2(array2[index2 + 1], get$2(array2.max, Infinity)), lo = formatValue$1(value2, format2), hi = formatValue$1(limit, format2);
  return lo && hi ? lo + " – " + hi : hi ? "< " + hi : "≥ " + lo;
};
const get$2 = (value2, dflt) => value2 != null ? value2 : dflt;
const formatDiscrete = (format2) => (value2, index2) => index2 ? format2(value2) : null;
const formatPoint = (format2) => (value2) => format2(value2);
const formatValue$1 = (value2, format2) => Number.isFinite(value2) ? format2(value2) : null;
function labelFraction(scale2) {
  const domain2 = scale2.domain(), count2 = domain2.length - 1;
  let lo = +domain2[0], hi = +peek$2(domain2), span2 = hi - lo;
  if (scale2.type === Threshold) {
    const adjust = count2 ? span2 / count2 : 0.1;
    lo -= adjust;
    hi += adjust;
    span2 = hi - lo;
  }
  return (value2) => (value2 - lo) / span2;
}
function format$2(locale2, scale2, specifier, formatType) {
  const type2 = formatType || scale2.type;
  if (isString(specifier) && isTemporal(type2)) {
    specifier = specifier.replace(/%a/g, "%A").replace(/%b/g, "%B");
  }
  return !specifier && type2 === Time ? locale2.timeFormat("%A, %d %B %Y, %X") : !specifier && type2 === UTC ? locale2.utcFormat("%A, %d %B %Y, %X UTC") : labelFormat(locale2, scale2, 5, null, specifier, formatType, true);
}
function domainCaption(locale2, scale2, opt) {
  opt = opt || {};
  const max2 = Math.max(3, opt.maxlen || 7), fmt = format$2(locale2, scale2, opt.format, opt.formatType);
  if (isDiscretizing(scale2.type)) {
    const v = labelValues(scale2).slice(1).map(fmt), n = v.length;
    return `${n} boundar${n === 1 ? "y" : "ies"}: ${v.join(", ")}`;
  } else if (isDiscrete(scale2.type)) {
    const d = scale2.domain(), n = d.length, v = n > max2 ? d.slice(0, max2 - 2).map(fmt).join(", ") + ", ending with " + d.slice(-1).map(fmt) : d.map(fmt).join(", ");
    return `${n} value${n === 1 ? "" : "s"}: ${v}`;
  } else {
    const d = scale2.domain();
    return `values from ${fmt(d[0])} to ${fmt(peek$2(d))}`;
  }
}
let gradient_id = 0;
function resetSVGGradientId() {
  gradient_id = 0;
}
const patternPrefix = "p_";
function isGradient(value2) {
  return value2 && value2.gradient;
}
function gradientRef(g, defs, base2) {
  const type2 = g.gradient;
  let id2 = g.id, prefix = type2 === "radial" ? patternPrefix : "";
  if (!id2) {
    id2 = g.id = "gradient_" + gradient_id++;
    if (type2 === "radial") {
      g.x1 = get$1(g.x1, 0.5);
      g.y1 = get$1(g.y1, 0.5);
      g.r1 = get$1(g.r1, 0);
      g.x2 = get$1(g.x2, 0.5);
      g.y2 = get$1(g.y2, 0.5);
      g.r2 = get$1(g.r2, 0.5);
      prefix = patternPrefix;
    } else {
      g.x1 = get$1(g.x1, 0);
      g.y1 = get$1(g.y1, 0);
      g.x2 = get$1(g.x2, 1);
      g.y2 = get$1(g.y2, 0);
    }
  }
  defs[id2] = g;
  return "url(" + (base2 || "") + "#" + prefix + id2 + ")";
}
function get$1(val, def2) {
  return val != null ? val : def2;
}
function Gradient$1(p02, p1) {
  var stops = [], gradient2;
  return gradient2 = {
    gradient: "linear",
    x1: p02 ? p02[0] : 0,
    y1: p02 ? p02[1] : 0,
    x2: p1 ? p1[0] : 1,
    y2: p1 ? p1[1] : 0,
    stops,
    stop: function(offset2, color2) {
      stops.push({
        offset: offset2,
        color: color2
      });
      return gradient2;
    }
  };
}
const lookup$4 = {
  "basis": {
    curve: curveBasis
  },
  "basis-closed": {
    curve: curveBasisClosed
  },
  "basis-open": {
    curve: curveBasisOpen
  },
  "bundle": {
    curve: curveBundle,
    tension: "beta",
    value: 0.85
  },
  "cardinal": {
    curve: curveCardinal,
    tension: "tension",
    value: 0
  },
  "cardinal-open": {
    curve: curveCardinalOpen,
    tension: "tension",
    value: 0
  },
  "cardinal-closed": {
    curve: curveCardinalClosed,
    tension: "tension",
    value: 0
  },
  "catmull-rom": {
    curve: curveCatmullRom,
    tension: "alpha",
    value: 0.5
  },
  "catmull-rom-closed": {
    curve: curveCatmullRomClosed,
    tension: "alpha",
    value: 0.5
  },
  "catmull-rom-open": {
    curve: curveCatmullRomOpen,
    tension: "alpha",
    value: 0.5
  },
  "linear": {
    curve: curveLinear
  },
  "linear-closed": {
    curve: curveLinearClosed
  },
  "monotone": {
    horizontal: monotoneY,
    vertical: monotoneX
  },
  "natural": {
    curve: curveNatural
  },
  "step": {
    curve: curveStep
  },
  "step-after": {
    curve: stepAfter
  },
  "step-before": {
    curve: stepBefore
  }
};
function curves(type2, orientation, tension) {
  var entry2 = has$1(lookup$4, type2) && lookup$4[type2], curve2 = null;
  if (entry2) {
    curve2 = entry2.curve || entry2[orientation || "vertical"];
    if (entry2.tension && tension != null) {
      curve2 = curve2[entry2.tension](tension);
    }
  }
  return curve2;
}
const paramCounts = {
  m: 2,
  l: 2,
  h: 1,
  v: 1,
  z: 0,
  c: 6,
  s: 4,
  q: 4,
  t: 2,
  a: 7
};
const commandPattern = /[mlhvzcsqta]([^mlhvzcsqta]+|$)/gi;
const numberPattern = /^[+-]?(([0-9]*\.[0-9]+)|([0-9]+\.)|([0-9]+))([eE][+-]?[0-9]+)?/;
const spacePattern = /^((\s+,?\s*)|(,\s*))/;
const flagPattern = /^[01]/;
function parse$3(path2) {
  const commands = [];
  const matches = path2.match(commandPattern) || [];
  matches.forEach((str) => {
    let cmd = str[0];
    const type2 = cmd.toLowerCase();
    const paramCount = paramCounts[type2];
    const params2 = parseParams(type2, paramCount, str.slice(1).trim());
    const count2 = params2.length;
    if (count2 < paramCount || count2 && count2 % paramCount !== 0) {
      throw Error("Invalid SVG path, incorrect parameter count");
    }
    commands.push([cmd, ...params2.slice(0, paramCount)]);
    if (count2 === paramCount) {
      return;
    }
    if (type2 === "m") {
      cmd = cmd === "M" ? "L" : "l";
    }
    for (let i = paramCount; i < count2; i += paramCount) {
      commands.push([cmd, ...params2.slice(i, i + paramCount)]);
    }
  });
  return commands;
}
function parseParams(type2, paramCount, segment) {
  const params2 = [];
  for (let index2 = 0; paramCount && index2 < segment.length; ) {
    for (let i = 0; i < paramCount; ++i) {
      const pattern = type2 === "a" && (i === 3 || i === 4) ? flagPattern : numberPattern;
      const match2 = segment.slice(index2).match(pattern);
      if (match2 === null) {
        throw Error("Invalid SVG path, incorrect parameter type");
      }
      index2 += match2[0].length;
      params2.push(+match2[0]);
      const ws = segment.slice(index2).match(spacePattern);
      if (ws !== null) {
        index2 += ws[0].length;
      }
    }
  }
  return params2;
}
const DegToRad = Math.PI / 180;
const Epsilon = 1e-14;
const HalfPi = Math.PI / 2;
const Tau = Math.PI * 2;
const HalfSqrt3 = Math.sqrt(3) / 2;
var segmentCache = {};
var bezierCache = {};
var join$2 = [].join;
function segments(x2, y2, rx, ry, large, sweep, rotateX, ox, oy) {
  const key2 = join$2.call(arguments);
  if (segmentCache[key2]) {
    return segmentCache[key2];
  }
  const th = rotateX * DegToRad;
  const sin_th = Math.sin(th);
  const cos_th = Math.cos(th);
  rx = Math.abs(rx);
  ry = Math.abs(ry);
  const px2 = cos_th * (ox - x2) * 0.5 + sin_th * (oy - y2) * 0.5;
  const py2 = cos_th * (oy - y2) * 0.5 - sin_th * (ox - x2) * 0.5;
  let pl = px2 * px2 / (rx * rx) + py2 * py2 / (ry * ry);
  if (pl > 1) {
    pl = Math.sqrt(pl);
    rx *= pl;
    ry *= pl;
  }
  const a00 = cos_th / rx;
  const a01 = sin_th / rx;
  const a10 = -sin_th / ry;
  const a11 = cos_th / ry;
  const x02 = a00 * ox + a01 * oy;
  const y02 = a10 * ox + a11 * oy;
  const x12 = a00 * x2 + a01 * y2;
  const y12 = a10 * x2 + a11 * y2;
  const d = (x12 - x02) * (x12 - x02) + (y12 - y02) * (y12 - y02);
  let sfactor_sq = 1 / d - 0.25;
  if (sfactor_sq < 0)
    sfactor_sq = 0;
  let sfactor = Math.sqrt(sfactor_sq);
  if (sweep == large)
    sfactor = -sfactor;
  const xc = 0.5 * (x02 + x12) - sfactor * (y12 - y02);
  const yc = 0.5 * (y02 + y12) + sfactor * (x12 - x02);
  const th0 = Math.atan2(y02 - yc, x02 - xc);
  const th1 = Math.atan2(y12 - yc, x12 - xc);
  let th_arc = th1 - th0;
  if (th_arc < 0 && sweep === 1) {
    th_arc += Tau;
  } else if (th_arc > 0 && sweep === 0) {
    th_arc -= Tau;
  }
  const segs = Math.ceil(Math.abs(th_arc / (HalfPi + 1e-3)));
  const result = [];
  for (let i = 0; i < segs; ++i) {
    const th2 = th0 + i * th_arc / segs;
    const th3 = th0 + (i + 1) * th_arc / segs;
    result[i] = [xc, yc, th2, th3, rx, ry, sin_th, cos_th];
  }
  return segmentCache[key2] = result;
}
function bezier(params2) {
  const key2 = join$2.call(params2);
  if (bezierCache[key2]) {
    return bezierCache[key2];
  }
  var cx = params2[0], cy = params2[1], th0 = params2[2], th1 = params2[3], rx = params2[4], ry = params2[5], sin_th = params2[6], cos_th = params2[7];
  const a00 = cos_th * rx;
  const a01 = -sin_th * ry;
  const a10 = sin_th * rx;
  const a11 = cos_th * ry;
  const cos_th0 = Math.cos(th0);
  const sin_th0 = Math.sin(th0);
  const cos_th1 = Math.cos(th1);
  const sin_th1 = Math.sin(th1);
  const th_half = 0.5 * (th1 - th0);
  const sin_th_h2 = Math.sin(th_half * 0.5);
  const t = 8 / 3 * sin_th_h2 * sin_th_h2 / Math.sin(th_half);
  const x12 = cx + cos_th0 - t * sin_th0;
  const y12 = cy + sin_th0 + t * cos_th0;
  const x3 = cx + cos_th1;
  const y3 = cy + sin_th1;
  const x2 = x3 + t * sin_th1;
  const y2 = y3 - t * cos_th1;
  return bezierCache[key2] = [a00 * x12 + a01 * y12, a10 * x12 + a11 * y12, a00 * x2 + a01 * y2, a10 * x2 + a11 * y2, a00 * x3 + a01 * y3, a10 * x3 + a11 * y3];
}
const temp = ["l", 0, 0, 0, 0, 0, 0, 0];
function scale$1$1(current, sX, sY) {
  const c2 = temp[0] = current[0];
  if (c2 === "a" || c2 === "A") {
    temp[1] = sX * current[1];
    temp[2] = sY * current[2];
    temp[3] = current[3];
    temp[4] = current[4];
    temp[5] = current[5];
    temp[6] = sX * current[6];
    temp[7] = sY * current[7];
  } else if (c2 === "h" || c2 === "H") {
    temp[1] = sX * current[1];
  } else if (c2 === "v" || c2 === "V") {
    temp[1] = sY * current[1];
  } else {
    for (var i = 1, n = current.length; i < n; ++i) {
      temp[i] = (i % 2 == 1 ? sX : sY) * current[i];
    }
  }
  return temp;
}
function pathRender(context2, path2, l, t, sX, sY) {
  var current, previous = null, x2 = 0, y2 = 0, controlX = 0, controlY = 0, tempX, tempY, tempControlX, tempControlY, anchorX = 0, anchorY = 0;
  if (l == null)
    l = 0;
  if (t == null)
    t = 0;
  if (sX == null)
    sX = 1;
  if (sY == null)
    sY = sX;
  if (context2.beginPath)
    context2.beginPath();
  for (var i = 0, len = path2.length; i < len; ++i) {
    current = path2[i];
    if (sX !== 1 || sY !== 1) {
      current = scale$1$1(current, sX, sY);
    }
    switch (current[0]) {
      case "l":
        x2 += current[1];
        y2 += current[2];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "L":
        x2 = current[1];
        y2 = current[2];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "h":
        x2 += current[1];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "H":
        x2 = current[1];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "v":
        y2 += current[1];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "V":
        y2 = current[1];
        context2.lineTo(x2 + l, y2 + t);
        break;
      case "m":
        x2 += current[1];
        y2 += current[2];
        anchorX = x2;
        anchorY = y2;
        context2.moveTo(x2 + l, y2 + t);
        break;
      case "M":
        x2 = current[1];
        y2 = current[2];
        anchorX = x2;
        anchorY = y2;
        context2.moveTo(x2 + l, y2 + t);
        break;
      case "c":
        tempX = x2 + current[5];
        tempY = y2 + current[6];
        controlX = x2 + current[3];
        controlY = y2 + current[4];
        context2.bezierCurveTo(
          x2 + current[1] + l,
          // x1
          y2 + current[2] + t,
          // y1
          controlX + l,
          // x2
          controlY + t,
          // y2
          tempX + l,
          tempY + t
        );
        x2 = tempX;
        y2 = tempY;
        break;
      case "C":
        x2 = current[5];
        y2 = current[6];
        controlX = current[3];
        controlY = current[4];
        context2.bezierCurveTo(current[1] + l, current[2] + t, controlX + l, controlY + t, x2 + l, y2 + t);
        break;
      case "s":
        tempX = x2 + current[3];
        tempY = y2 + current[4];
        controlX = 2 * x2 - controlX;
        controlY = 2 * y2 - controlY;
        context2.bezierCurveTo(controlX + l, controlY + t, x2 + current[1] + l, y2 + current[2] + t, tempX + l, tempY + t);
        controlX = x2 + current[1];
        controlY = y2 + current[2];
        x2 = tempX;
        y2 = tempY;
        break;
      case "S":
        tempX = current[3];
        tempY = current[4];
        controlX = 2 * x2 - controlX;
        controlY = 2 * y2 - controlY;
        context2.bezierCurveTo(controlX + l, controlY + t, current[1] + l, current[2] + t, tempX + l, tempY + t);
        x2 = tempX;
        y2 = tempY;
        controlX = current[1];
        controlY = current[2];
        break;
      case "q":
        tempX = x2 + current[3];
        tempY = y2 + current[4];
        controlX = x2 + current[1];
        controlY = y2 + current[2];
        context2.quadraticCurveTo(controlX + l, controlY + t, tempX + l, tempY + t);
        x2 = tempX;
        y2 = tempY;
        break;
      case "Q":
        tempX = current[3];
        tempY = current[4];
        context2.quadraticCurveTo(current[1] + l, current[2] + t, tempX + l, tempY + t);
        x2 = tempX;
        y2 = tempY;
        controlX = current[1];
        controlY = current[2];
        break;
      case "t":
        tempX = x2 + current[1];
        tempY = y2 + current[2];
        if (previous[0].match(/[QqTt]/) === null) {
          controlX = x2;
          controlY = y2;
        } else if (previous[0] === "t") {
          controlX = 2 * x2 - tempControlX;
          controlY = 2 * y2 - tempControlY;
        } else if (previous[0] === "q") {
          controlX = 2 * x2 - controlX;
          controlY = 2 * y2 - controlY;
        }
        tempControlX = controlX;
        tempControlY = controlY;
        context2.quadraticCurveTo(controlX + l, controlY + t, tempX + l, tempY + t);
        x2 = tempX;
        y2 = tempY;
        controlX = x2 + current[1];
        controlY = y2 + current[2];
        break;
      case "T":
        tempX = current[1];
        tempY = current[2];
        controlX = 2 * x2 - controlX;
        controlY = 2 * y2 - controlY;
        context2.quadraticCurveTo(controlX + l, controlY + t, tempX + l, tempY + t);
        x2 = tempX;
        y2 = tempY;
        break;
      case "a":
        drawArc(context2, x2 + l, y2 + t, [current[1], current[2], current[3], current[4], current[5], current[6] + x2 + l, current[7] + y2 + t]);
        x2 += current[6];
        y2 += current[7];
        break;
      case "A":
        drawArc(context2, x2 + l, y2 + t, [current[1], current[2], current[3], current[4], current[5], current[6] + l, current[7] + t]);
        x2 = current[6];
        y2 = current[7];
        break;
      case "z":
      case "Z":
        x2 = anchorX;
        y2 = anchorY;
        context2.closePath();
        break;
    }
    previous = current;
  }
}
function drawArc(context2, x2, y2, coords) {
  const seg = segments(
    coords[5],
    // end x
    coords[6],
    // end y
    coords[0],
    // radius x
    coords[1],
    // radius y
    coords[3],
    // large flag
    coords[4],
    // sweep flag
    coords[2],
    // rotation
    x2,
    y2
  );
  for (let i = 0; i < seg.length; ++i) {
    const bez = bezier(seg[i]);
    context2.bezierCurveTo(bez[0], bez[1], bez[2], bez[3], bez[4], bez[5]);
  }
}
const Tan30 = 0.5773502691896257;
const builtins = {
  "circle": {
    draw: function(context2, size) {
      const r = Math.sqrt(size) / 2;
      context2.moveTo(r, 0);
      context2.arc(0, 0, r, 0, Tau);
    }
  },
  "cross": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, s = r / 2.5;
      context2.moveTo(-r, -s);
      context2.lineTo(-r, s);
      context2.lineTo(-s, s);
      context2.lineTo(-s, r);
      context2.lineTo(s, r);
      context2.lineTo(s, s);
      context2.lineTo(r, s);
      context2.lineTo(r, -s);
      context2.lineTo(s, -s);
      context2.lineTo(s, -r);
      context2.lineTo(-s, -r);
      context2.lineTo(-s, -s);
      context2.closePath();
    }
  },
  "diamond": {
    draw: function(context2, size) {
      const r = Math.sqrt(size) / 2;
      context2.moveTo(-r, 0);
      context2.lineTo(0, -r);
      context2.lineTo(r, 0);
      context2.lineTo(0, r);
      context2.closePath();
    }
  },
  "square": {
    draw: function(context2, size) {
      var w2 = Math.sqrt(size), x2 = -w2 / 2;
      context2.rect(x2, x2, w2, w2);
    }
  },
  "arrow": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, s = r / 7, t = r / 2.5, v = r / 8;
      context2.moveTo(-s, r);
      context2.lineTo(s, r);
      context2.lineTo(s, -v);
      context2.lineTo(t, -v);
      context2.lineTo(0, -r);
      context2.lineTo(-t, -v);
      context2.lineTo(-s, -v);
      context2.closePath();
    }
  },
  "wedge": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r, o = h2 - r * Tan30, b2 = r / 4;
      context2.moveTo(0, -h2 - o);
      context2.lineTo(-b2, h2 - o);
      context2.lineTo(b2, h2 - o);
      context2.closePath();
    }
  },
  "triangle": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r, o = h2 - r * Tan30;
      context2.moveTo(0, -h2 - o);
      context2.lineTo(-r, h2 - o);
      context2.lineTo(r, h2 - o);
      context2.closePath();
    }
  },
  "triangle-up": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r;
      context2.moveTo(0, -h2);
      context2.lineTo(-r, h2);
      context2.lineTo(r, h2);
      context2.closePath();
    }
  },
  "triangle-down": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r;
      context2.moveTo(0, h2);
      context2.lineTo(-r, -h2);
      context2.lineTo(r, -h2);
      context2.closePath();
    }
  },
  "triangle-right": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r;
      context2.moveTo(h2, 0);
      context2.lineTo(-h2, -r);
      context2.lineTo(-h2, r);
      context2.closePath();
    }
  },
  "triangle-left": {
    draw: function(context2, size) {
      var r = Math.sqrt(size) / 2, h2 = HalfSqrt3 * r;
      context2.moveTo(-h2, 0);
      context2.lineTo(h2, -r);
      context2.lineTo(h2, r);
      context2.closePath();
    }
  },
  "stroke": {
    draw: function(context2, size) {
      const r = Math.sqrt(size) / 2;
      context2.moveTo(-r, 0);
      context2.lineTo(r, 0);
    }
  }
};
function symbols(_) {
  return has$1(builtins, _) ? builtins[_] : customSymbol(_);
}
var custom10 = {};
function customSymbol(path2) {
  if (!has$1(custom10, path2)) {
    const parsed = parse$3(path2);
    custom10[path2] = {
      draw: function(context2, size) {
        pathRender(context2, parsed, 0, 0, Math.sqrt(size) / 2);
      }
    };
  }
  return custom10[path2];
}
const C = 0.448084975506;
function rectangleX(d) {
  return d.x;
}
function rectangleY(d) {
  return d.y;
}
function rectangleWidth(d) {
  return d.width;
}
function rectangleHeight(d) {
  return d.height;
}
function number$3(_) {
  return typeof _ === "function" ? _ : () => +_;
}
function clamp(value2, min2, max2) {
  return Math.max(min2, Math.min(value2, max2));
}
function vg_rect() {
  var x2 = rectangleX, y2 = rectangleY, width2 = rectangleWidth, height2 = rectangleHeight, crTL = number$3(0), crTR = crTL, crBL = crTL, crBR = crTL, context2 = null;
  function rectangle2(_, x02, y02) {
    var buffer, x12 = x02 != null ? x02 : +x2.call(this, _), y12 = y02 != null ? y02 : +y2.call(this, _), w2 = +width2.call(this, _), h2 = +height2.call(this, _), s = Math.min(w2, h2) / 2, tl2 = clamp(+crTL.call(this, _), 0, s), tr2 = clamp(+crTR.call(this, _), 0, s), bl2 = clamp(+crBL.call(this, _), 0, s), br2 = clamp(+crBR.call(this, _), 0, s);
    if (!context2)
      context2 = buffer = path$3();
    if (tl2 <= 0 && tr2 <= 0 && bl2 <= 0 && br2 <= 0) {
      context2.rect(x12, y12, w2, h2);
    } else {
      var x22 = x12 + w2, y22 = y12 + h2;
      context2.moveTo(x12 + tl2, y12);
      context2.lineTo(x22 - tr2, y12);
      context2.bezierCurveTo(x22 - C * tr2, y12, x22, y12 + C * tr2, x22, y12 + tr2);
      context2.lineTo(x22, y22 - br2);
      context2.bezierCurveTo(x22, y22 - C * br2, x22 - C * br2, y22, x22 - br2, y22);
      context2.lineTo(x12 + bl2, y22);
      context2.bezierCurveTo(x12 + C * bl2, y22, x12, y22 - C * bl2, x12, y22 - bl2);
      context2.lineTo(x12, y12 + tl2);
      context2.bezierCurveTo(x12, y12 + C * tl2, x12 + C * tl2, y12, x12 + tl2, y12);
      context2.closePath();
    }
    if (buffer) {
      context2 = null;
      return buffer + "" || null;
    }
  }
  rectangle2.x = function(_) {
    if (arguments.length) {
      x2 = number$3(_);
      return rectangle2;
    } else {
      return x2;
    }
  };
  rectangle2.y = function(_) {
    if (arguments.length) {
      y2 = number$3(_);
      return rectangle2;
    } else {
      return y2;
    }
  };
  rectangle2.width = function(_) {
    if (arguments.length) {
      width2 = number$3(_);
      return rectangle2;
    } else {
      return width2;
    }
  };
  rectangle2.height = function(_) {
    if (arguments.length) {
      height2 = number$3(_);
      return rectangle2;
    } else {
      return height2;
    }
  };
  rectangle2.cornerRadius = function(tl2, tr2, br2, bl2) {
    if (arguments.length) {
      crTL = number$3(tl2);
      crTR = tr2 != null ? number$3(tr2) : crTL;
      crBR = br2 != null ? number$3(br2) : crTL;
      crBL = bl2 != null ? number$3(bl2) : crTR;
      return rectangle2;
    } else {
      return crTL;
    }
  };
  rectangle2.context = function(_) {
    if (arguments.length) {
      context2 = _ == null ? null : _;
      return rectangle2;
    } else {
      return context2;
    }
  };
  return rectangle2;
}
function vg_trail() {
  var x2, y2, size, defined, context2 = null, ready, x12, y12, r1;
  function point2(x22, y22, w2) {
    const r2 = w2 / 2;
    if (ready) {
      var ux = y12 - y22, uy = x22 - x12;
      if (ux || uy) {
        var ud = Math.sqrt(ux * ux + uy * uy), rx = (ux /= ud) * r1, ry = (uy /= ud) * r1, t = Math.atan2(uy, ux);
        context2.moveTo(x12 - rx, y12 - ry);
        context2.lineTo(x22 - ux * r2, y22 - uy * r2);
        context2.arc(x22, y22, r2, t - Math.PI, t);
        context2.lineTo(x12 + rx, y12 + ry);
        context2.arc(x12, y12, r1, t, t + Math.PI);
      } else {
        context2.arc(x22, y22, r2, 0, Tau);
      }
      context2.closePath();
    } else {
      ready = 1;
    }
    x12 = x22;
    y12 = y22;
    r1 = r2;
  }
  function trail2(data2) {
    var i, n = data2.length, d, defined0 = false, buffer;
    if (context2 == null)
      context2 = buffer = path$3();
    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data2[i], i, data2)) === defined0) {
        if (defined0 = !defined0)
          ready = 0;
      }
      if (defined0)
        point2(+x2(d, i, data2), +y2(d, i, data2), +size(d, i, data2));
    }
    if (buffer) {
      context2 = null;
      return buffer + "" || null;
    }
  }
  trail2.x = function(_) {
    if (arguments.length) {
      x2 = _;
      return trail2;
    } else {
      return x2;
    }
  };
  trail2.y = function(_) {
    if (arguments.length) {
      y2 = _;
      return trail2;
    } else {
      return y2;
    }
  };
  trail2.size = function(_) {
    if (arguments.length) {
      size = _;
      return trail2;
    } else {
      return size;
    }
  };
  trail2.defined = function(_) {
    if (arguments.length) {
      defined = _;
      return trail2;
    } else {
      return defined;
    }
  };
  trail2.context = function(_) {
    if (arguments.length) {
      if (_ == null) {
        context2 = null;
      } else {
        context2 = _;
      }
      return trail2;
    } else {
      return context2;
    }
  };
  return trail2;
}
function value$1(a2, b2) {
  return a2 != null ? a2 : b2;
}
const x = (item) => item.x || 0, y = (item) => item.y || 0, w = (item) => item.width || 0, h = (item) => item.height || 0, xw = (item) => (item.x || 0) + (item.width || 0), yh = (item) => (item.y || 0) + (item.height || 0), sa = (item) => item.startAngle || 0, ea = (item) => item.endAngle || 0, pa = (item) => item.padAngle || 0, ir = (item) => item.innerRadius || 0, or = (item) => item.outerRadius || 0, cr = (item) => item.cornerRadius || 0, tl = (item) => value$1(item.cornerRadiusTopLeft, item.cornerRadius) || 0, tr = (item) => value$1(item.cornerRadiusTopRight, item.cornerRadius) || 0, br = (item) => value$1(item.cornerRadiusBottomRight, item.cornerRadius) || 0, bl = (item) => value$1(item.cornerRadiusBottomLeft, item.cornerRadius) || 0, sz = (item) => value$1(item.size, 64), ts = (item) => item.size || 1, def = (item) => !(item.defined === false), type = (item) => symbols(item.shape || "circle");
const arcShape = d3arc().startAngle(sa).endAngle(ea).padAngle(pa).innerRadius(ir).outerRadius(or).cornerRadius(cr), areavShape = area$2$1().x(x).y1(y).y0(yh).defined(def), areahShape = area$2$1().y(y).x1(x).x0(xw).defined(def), lineShape = line$3().x(x).y(y).defined(def), rectShape = vg_rect().x(x).y(y).width(w).height(h).cornerRadius(tl, tr, br, bl), symbolShape = Symbol$1().type(type).size(sz), trailShape = vg_trail().x(x).y(y).defined(def).size(ts);
function hasCornerRadius(item) {
  return item.cornerRadius || item.cornerRadiusTopLeft || item.cornerRadiusTopRight || item.cornerRadiusBottomRight || item.cornerRadiusBottomLeft;
}
function arc$1(context2, item) {
  return arcShape.context(context2)(item);
}
function area$1(context2, items) {
  const item = items[0], interp = item.interpolate || "linear";
  return (item.orient === "horizontal" ? areahShape : areavShape).curve(curves(interp, item.orient, item.tension)).context(context2)(items);
}
function line$1(context2, items) {
  const item = items[0], interp = item.interpolate || "linear";
  return lineShape.curve(curves(interp, item.orient, item.tension)).context(context2)(items);
}
function rectangle(context2, item, x2, y2) {
  return rectShape.context(context2)(item, x2, y2);
}
function shape$1(context2, item) {
  return (item.mark.shape || item.shape).context(context2)(item);
}
function symbol$1(context2, item) {
  return symbolShape.context(context2)(item);
}
function trail$1(context2, items) {
  return trailShape.context(context2)(items);
}
var clip_id = 1;
function resetSVGClipId() {
  clip_id = 1;
}
function clip$1(renderer, item, size) {
  var clip2 = item.clip, defs = renderer._defs, id2 = item.clip_id || (item.clip_id = "clip" + clip_id++), c2 = defs.clipping[id2] || (defs.clipping[id2] = {
    id: id2
  });
  if (isFunction(clip2)) {
    c2.path = clip2(null);
  } else if (hasCornerRadius(size)) {
    c2.path = rectangle(null, size, 0, 0);
  } else {
    c2.width = size.width || 0;
    c2.height = size.height || 0;
  }
  return "url(#" + id2 + ")";
}
function Bounds(b2) {
  this.clear();
  if (b2)
    this.union(b2);
}
Bounds.prototype = {
  clone() {
    return new Bounds(this);
  },
  clear() {
    this.x1 = +Number.MAX_VALUE;
    this.y1 = +Number.MAX_VALUE;
    this.x2 = -Number.MAX_VALUE;
    this.y2 = -Number.MAX_VALUE;
    return this;
  },
  empty() {
    return this.x1 === +Number.MAX_VALUE && this.y1 === +Number.MAX_VALUE && this.x2 === -Number.MAX_VALUE && this.y2 === -Number.MAX_VALUE;
  },
  equals(b2) {
    return this.x1 === b2.x1 && this.y1 === b2.y1 && this.x2 === b2.x2 && this.y2 === b2.y2;
  },
  set(x12, y12, x2, y2) {
    if (x2 < x12) {
      this.x2 = x12;
      this.x1 = x2;
    } else {
      this.x1 = x12;
      this.x2 = x2;
    }
    if (y2 < y12) {
      this.y2 = y12;
      this.y1 = y2;
    } else {
      this.y1 = y12;
      this.y2 = y2;
    }
    return this;
  },
  add(x2, y2) {
    if (x2 < this.x1)
      this.x1 = x2;
    if (y2 < this.y1)
      this.y1 = y2;
    if (x2 > this.x2)
      this.x2 = x2;
    if (y2 > this.y2)
      this.y2 = y2;
    return this;
  },
  expand(d) {
    this.x1 -= d;
    this.y1 -= d;
    this.x2 += d;
    this.y2 += d;
    return this;
  },
  round() {
    this.x1 = Math.floor(this.x1);
    this.y1 = Math.floor(this.y1);
    this.x2 = Math.ceil(this.x2);
    this.y2 = Math.ceil(this.y2);
    return this;
  },
  scale(s) {
    this.x1 *= s;
    this.y1 *= s;
    this.x2 *= s;
    this.y2 *= s;
    return this;
  },
  translate(dx, dy) {
    this.x1 += dx;
    this.x2 += dx;
    this.y1 += dy;
    this.y2 += dy;
    return this;
  },
  rotate(angle2, x2, y2) {
    const p = this.rotatedPoints(angle2, x2, y2);
    return this.clear().add(p[0], p[1]).add(p[2], p[3]).add(p[4], p[5]).add(p[6], p[7]);
  },
  rotatedPoints(angle2, x2, y2) {
    var {
      x1: x12,
      y1: y12,
      x2: x22,
      y2: y22
    } = this, cos2 = Math.cos(angle2), sin2 = Math.sin(angle2), cx = x2 - x2 * cos2 + y2 * sin2, cy = y2 - x2 * sin2 - y2 * cos2;
    return [cos2 * x12 - sin2 * y12 + cx, sin2 * x12 + cos2 * y12 + cy, cos2 * x12 - sin2 * y22 + cx, sin2 * x12 + cos2 * y22 + cy, cos2 * x22 - sin2 * y12 + cx, sin2 * x22 + cos2 * y12 + cy, cos2 * x22 - sin2 * y22 + cx, sin2 * x22 + cos2 * y22 + cy];
  },
  union(b2) {
    if (b2.x1 < this.x1)
      this.x1 = b2.x1;
    if (b2.y1 < this.y1)
      this.y1 = b2.y1;
    if (b2.x2 > this.x2)
      this.x2 = b2.x2;
    if (b2.y2 > this.y2)
      this.y2 = b2.y2;
    return this;
  },
  intersect(b2) {
    if (b2.x1 > this.x1)
      this.x1 = b2.x1;
    if (b2.y1 > this.y1)
      this.y1 = b2.y1;
    if (b2.x2 < this.x2)
      this.x2 = b2.x2;
    if (b2.y2 < this.y2)
      this.y2 = b2.y2;
    return this;
  },
  encloses(b2) {
    return b2 && this.x1 <= b2.x1 && this.x2 >= b2.x2 && this.y1 <= b2.y1 && this.y2 >= b2.y2;
  },
  alignsWith(b2) {
    return b2 && (this.x1 == b2.x1 || this.x2 == b2.x2 || this.y1 == b2.y1 || this.y2 == b2.y2);
  },
  intersects(b2) {
    return b2 && !(this.x2 < b2.x1 || this.x1 > b2.x2 || this.y2 < b2.y1 || this.y1 > b2.y2);
  },
  contains(x2, y2) {
    return !(x2 < this.x1 || x2 > this.x2 || y2 < this.y1 || y2 > this.y2);
  },
  width() {
    return this.x2 - this.x1;
  },
  height() {
    return this.y2 - this.y1;
  }
};
function Item(mark) {
  this.mark = mark;
  this.bounds = this.bounds || new Bounds();
}
function GroupItem(mark) {
  Item.call(this, mark);
  this.items = this.items || [];
}
inherits(GroupItem, Item);
function ResourceLoader(customLoader) {
  this._pending = 0;
  this._loader = customLoader || loader();
}
function increment(loader2) {
  loader2._pending += 1;
}
function decrement(loader2) {
  loader2._pending -= 1;
}
ResourceLoader.prototype = {
  pending() {
    return this._pending;
  },
  sanitizeURL(uri) {
    const loader2 = this;
    increment(loader2);
    return loader2._loader.sanitize(uri, {
      context: "href"
    }).then((opt) => {
      decrement(loader2);
      return opt;
    }).catch(() => {
      decrement(loader2);
      return null;
    });
  },
  loadImage(uri) {
    const loader2 = this, Image2 = image$1();
    increment(loader2);
    return loader2._loader.sanitize(uri, {
      context: "image"
    }).then((opt) => {
      const url = opt.href;
      if (!url || !Image2)
        throw {
          url
        };
      const img = new Image2();
      const cors = has$1(opt, "crossOrigin") ? opt.crossOrigin : "anonymous";
      if (cors != null)
        img.crossOrigin = cors;
      img.onload = () => decrement(loader2);
      img.onerror = () => decrement(loader2);
      img.src = url;
      return img;
    }).catch((e) => {
      decrement(loader2);
      return {
        complete: false,
        width: 0,
        height: 0,
        src: e && e.url || ""
      };
    });
  },
  ready() {
    const loader2 = this;
    return new Promise((accept) => {
      function poll(value2) {
        if (!loader2.pending())
          accept(value2);
        else
          setTimeout(() => {
            poll(true);
          }, 10);
      }
      poll(false);
    });
  }
};
function boundStroke(bounds2, item, miter) {
  if (item.stroke && item.opacity !== 0 && item.strokeOpacity !== 0) {
    const sw = item.strokeWidth != null ? +item.strokeWidth : 1;
    bounds2.expand(sw + (miter ? miterAdjustment(item, sw) : 0));
  }
  return bounds2;
}
function miterAdjustment(item, strokeWidth) {
  return item.strokeJoin && item.strokeJoin !== "miter" ? 0 : strokeWidth;
}
const circleThreshold = Tau - 1e-8;
let bounds, lx, ly, rot, ma, mb, mc, md;
const add = (x2, y2) => bounds.add(x2, y2);
const addL = (x2, y2) => add(lx = x2, ly = y2);
const addX = (x2) => add(x2, bounds.y1);
const addY = (y2) => add(bounds.x1, y2);
const px = (x2, y2) => ma * x2 + mc * y2;
const py = (x2, y2) => mb * x2 + md * y2;
const addp = (x2, y2) => add(px(x2, y2), py(x2, y2));
const addpL = (x2, y2) => addL(px(x2, y2), py(x2, y2));
function boundContext(_, deg) {
  bounds = _;
  if (deg) {
    rot = deg * DegToRad;
    ma = md = Math.cos(rot);
    mb = Math.sin(rot);
    mc = -mb;
  } else {
    ma = md = 1;
    rot = mb = mc = 0;
  }
  return context$1;
}
const context$1 = {
  beginPath() {
  },
  closePath() {
  },
  moveTo: addpL,
  lineTo: addpL,
  rect(x2, y2, w2, h2) {
    if (rot) {
      addp(x2 + w2, y2);
      addp(x2 + w2, y2 + h2);
      addp(x2, y2 + h2);
      addpL(x2, y2);
    } else {
      add(x2 + w2, y2 + h2);
      addL(x2, y2);
    }
  },
  quadraticCurveTo(x12, y12, x2, y2) {
    const px1 = px(x12, y12), py1 = py(x12, y12), px2 = px(x2, y2), py2 = py(x2, y2);
    quadExtrema(lx, px1, px2, addX);
    quadExtrema(ly, py1, py2, addY);
    addL(px2, py2);
  },
  bezierCurveTo(x12, y12, x2, y2, x3, y3) {
    const px1 = px(x12, y12), py1 = py(x12, y12), px2 = px(x2, y2), py2 = py(x2, y2), px3 = px(x3, y3), py3 = py(x3, y3);
    cubicExtrema(lx, px1, px2, px3, addX);
    cubicExtrema(ly, py1, py2, py3, addY);
    addL(px3, py3);
  },
  arc(cx, cy, r, sa2, ea2, ccw) {
    sa2 += rot;
    ea2 += rot;
    lx = r * Math.cos(ea2) + cx;
    ly = r * Math.sin(ea2) + cy;
    if (Math.abs(ea2 - sa2) > circleThreshold) {
      add(cx - r, cy - r);
      add(cx + r, cy + r);
    } else {
      const update2 = (a2) => add(r * Math.cos(a2) + cx, r * Math.sin(a2) + cy);
      let s, i;
      update2(sa2);
      update2(ea2);
      if (ea2 !== sa2) {
        sa2 = sa2 % Tau;
        if (sa2 < 0)
          sa2 += Tau;
        ea2 = ea2 % Tau;
        if (ea2 < 0)
          ea2 += Tau;
        if (ea2 < sa2) {
          ccw = !ccw;
          s = sa2;
          sa2 = ea2;
          ea2 = s;
        }
        if (ccw) {
          ea2 -= Tau;
          s = sa2 - sa2 % HalfPi;
          for (i = 0; i < 4 && s > ea2; ++i, s -= HalfPi)
            update2(s);
        } else {
          s = sa2 - sa2 % HalfPi + HalfPi;
          for (i = 0; i < 4 && s < ea2; ++i, s = s + HalfPi)
            update2(s);
        }
      }
    }
  }
};
function quadExtrema(x02, x12, x2, cb) {
  const t = (x02 - x12) / (x02 + x2 - 2 * x12);
  if (0 < t && t < 1)
    cb(x02 + (x12 - x02) * t);
}
function cubicExtrema(x02, x12, x2, x3, cb) {
  const a2 = x3 - x02 + 3 * x12 - 3 * x2, b2 = x02 + x2 - 2 * x12, c2 = x02 - x12;
  let t02 = 0, t12 = 0, r;
  if (Math.abs(a2) > Epsilon) {
    r = b2 * b2 + c2 * a2;
    if (r >= 0) {
      r = Math.sqrt(r);
      t02 = (-b2 + r) / a2;
      t12 = (-b2 - r) / a2;
    }
  } else {
    t02 = 0.5 * c2 / b2;
  }
  if (0 < t02 && t02 < 1)
    cb(cubic(t02, x02, x12, x2, x3));
  if (0 < t12 && t12 < 1)
    cb(cubic(t12, x02, x12, x2, x3));
}
function cubic(t, x02, x12, x2, x3) {
  const s = 1 - t, s2 = s * s, t22 = t * t;
  return s2 * s * x02 + 3 * s2 * t * x12 + 3 * s * t22 * x2 + t22 * t * x3;
}
var context$2 = (context$2 = canvas(1, 1)) ? context$2.getContext("2d") : null;
const b = new Bounds();
function intersectPath(draw2) {
  return function(item, brush) {
    if (!context$2)
      return true;
    draw2(context$2, item);
    b.clear().union(item.bounds).intersect(brush).round();
    const {
      x1: x12,
      y1: y12,
      x2,
      y2
    } = b;
    for (let y3 = y12; y3 <= y2; ++y3) {
      for (let x3 = x12; x3 <= x2; ++x3) {
        if (context$2.isPointInPath(x3, y3)) {
          return true;
        }
      }
    }
    return false;
  };
}
function intersectPoint(item, box) {
  return box.contains(item.x || 0, item.y || 0);
}
function intersectRect(item, box) {
  const x2 = item.x || 0, y2 = item.y || 0, w2 = item.width || 0, h2 = item.height || 0;
  return box.intersects(b.set(x2, y2, x2 + w2, y2 + h2));
}
function intersectRule(item, box) {
  const x2 = item.x || 0, y2 = item.y || 0, x22 = item.x2 != null ? item.x2 : x2, y22 = item.y2 != null ? item.y2 : y2;
  return intersectBoxLine(box, x2, y2, x22, y22);
}
function intersectBoxLine(box, x2, y2, u2, v) {
  const {
    x1: x12,
    y1: y12,
    x2: x22,
    y2: y22
  } = box, dx = u2 - x2, dy = v - y2;
  let t02 = 0, t12 = 1, p, q, r, e;
  for (e = 0; e < 4; ++e) {
    if (e === 0) {
      p = -dx;
      q = -(x12 - x2);
    }
    if (e === 1) {
      p = dx;
      q = x22 - x2;
    }
    if (e === 2) {
      p = -dy;
      q = -(y12 - y2);
    }
    if (e === 3) {
      p = dy;
      q = y22 - y2;
    }
    if (Math.abs(p) < 1e-10 && q < 0)
      return false;
    r = q / p;
    if (p < 0) {
      if (r > t12)
        return false;
      else if (r > t02)
        t02 = r;
    } else if (p > 0) {
      if (r < t02)
        return false;
      else if (r < t12)
        t12 = r;
    }
  }
  return true;
}
function blend(context2, item) {
  context2.globalCompositeOperation = item.blend || "source-over";
}
function value$2(value2, dflt) {
  return value2 == null ? dflt : value2;
}
function addStops(gradient2, stops) {
  const n = stops.length;
  for (let i = 0; i < n; ++i) {
    gradient2.addColorStop(stops[i].offset, stops[i].color);
  }
  return gradient2;
}
function gradient$1(context2, spec, bounds2) {
  const w2 = bounds2.width(), h2 = bounds2.height();
  let gradient2;
  if (spec.gradient === "radial") {
    gradient2 = context2.createRadialGradient(bounds2.x1 + value$2(spec.x1, 0.5) * w2, bounds2.y1 + value$2(spec.y1, 0.5) * h2, Math.max(w2, h2) * value$2(spec.r1, 0), bounds2.x1 + value$2(spec.x2, 0.5) * w2, bounds2.y1 + value$2(spec.y2, 0.5) * h2, Math.max(w2, h2) * value$2(spec.r2, 0.5));
  } else {
    const x12 = value$2(spec.x1, 0), y12 = value$2(spec.y1, 0), x2 = value$2(spec.x2, 1), y2 = value$2(spec.y2, 0);
    if (x12 === x2 || y12 === y2 || w2 === h2) {
      gradient2 = context2.createLinearGradient(bounds2.x1 + x12 * w2, bounds2.y1 + y12 * h2, bounds2.x1 + x2 * w2, bounds2.y1 + y2 * h2);
    } else {
      const image2 = canvas(Math.ceil(w2), Math.ceil(h2)), ictx = image2.getContext("2d");
      ictx.scale(w2, h2);
      ictx.fillStyle = addStops(ictx.createLinearGradient(x12, y12, x2, y2), spec.stops);
      ictx.fillRect(0, 0, w2, h2);
      return context2.createPattern(image2, "no-repeat");
    }
  }
  return addStops(gradient2, spec.stops);
}
function color$1(context2, item, value2) {
  return isGradient(value2) ? gradient$1(context2, value2, item.bounds) : value2;
}
function fill(context2, item, opacity) {
  opacity *= item.fillOpacity == null ? 1 : item.fillOpacity;
  if (opacity > 0) {
    context2.globalAlpha = opacity;
    context2.fillStyle = color$1(context2, item, item.fill);
    return true;
  } else {
    return false;
  }
}
var Empty = [];
function stroke(context2, item, opacity) {
  var lw = (lw = item.strokeWidth) != null ? lw : 1;
  if (lw <= 0)
    return false;
  opacity *= item.strokeOpacity == null ? 1 : item.strokeOpacity;
  if (opacity > 0) {
    context2.globalAlpha = opacity;
    context2.strokeStyle = color$1(context2, item, item.stroke);
    context2.lineWidth = lw;
    context2.lineCap = item.strokeCap || "butt";
    context2.lineJoin = item.strokeJoin || "miter";
    context2.miterLimit = item.strokeMiterLimit || 10;
    if (context2.setLineDash) {
      context2.setLineDash(item.strokeDash || Empty);
      context2.lineDashOffset = item.strokeDashOffset || 0;
    }
    return true;
  } else {
    return false;
  }
}
function compare(a2, b2) {
  return a2.zindex - b2.zindex || a2.index - b2.index;
}
function zorder(scene) {
  if (!scene.zdirty)
    return scene.zitems;
  var items = scene.items, output2 = [], item, i, n;
  for (i = 0, n = items.length; i < n; ++i) {
    item = items[i];
    item.index = i;
    if (item.zindex)
      output2.push(item);
  }
  scene.zdirty = false;
  return scene.zitems = output2.sort(compare);
}
function visit(scene, visitor) {
  var items = scene.items, i, n;
  if (!items || !items.length)
    return;
  const zitems = zorder(scene);
  if (zitems && zitems.length) {
    for (i = 0, n = items.length; i < n; ++i) {
      if (!items[i].zindex)
        visitor(items[i]);
    }
    items = zitems;
  }
  for (i = 0, n = items.length; i < n; ++i) {
    visitor(items[i]);
  }
}
function pickVisit(scene, visitor) {
  var items = scene.items, hit2, i;
  if (!items || !items.length)
    return null;
  const zitems = zorder(scene);
  if (zitems && zitems.length)
    items = zitems;
  for (i = items.length; --i >= 0; ) {
    if (hit2 = visitor(items[i]))
      return hit2;
  }
  if (items === zitems) {
    for (items = scene.items, i = items.length; --i >= 0; ) {
      if (!items[i].zindex) {
        if (hit2 = visitor(items[i]))
          return hit2;
      }
    }
  }
  return null;
}
function drawAll(path2) {
  return function(context2, scene, bounds2) {
    visit(scene, (item) => {
      if (!bounds2 || bounds2.intersects(item.bounds)) {
        drawPath(path2, context2, item, item);
      }
    });
  };
}
function drawOne(path2) {
  return function(context2, scene, bounds2) {
    if (scene.items.length && (!bounds2 || bounds2.intersects(scene.bounds))) {
      drawPath(path2, context2, scene.items[0], scene.items);
    }
  };
}
function drawPath(path2, context2, item, items) {
  var opacity = item.opacity == null ? 1 : item.opacity;
  if (opacity === 0)
    return;
  if (path2(context2, items))
    return;
  blend(context2, item);
  if (item.fill && fill(context2, item, opacity)) {
    context2.fill();
  }
  if (item.stroke && stroke(context2, item, opacity)) {
    context2.stroke();
  }
}
function pick$1(test2) {
  test2 = test2 || truthy;
  return function(context2, scene, x2, y2, gx, gy) {
    x2 *= context2.pixelRatio;
    y2 *= context2.pixelRatio;
    return pickVisit(scene, (item) => {
      const b2 = item.bounds;
      if (b2 && !b2.contains(gx, gy) || !b2)
        return;
      if (test2(context2, item, x2, y2, gx, gy))
        return item;
    });
  };
}
function hitPath(path2, filled) {
  return function(context2, o, x2, y2) {
    var item = Array.isArray(o) ? o[0] : o, fill2 = filled == null ? item.fill : filled, stroke2 = item.stroke && context2.isPointInStroke, lw, lc;
    if (stroke2) {
      lw = item.strokeWidth;
      lc = item.strokeCap;
      context2.lineWidth = lw != null ? lw : 1;
      context2.lineCap = lc != null ? lc : "butt";
    }
    return path2(context2, o) ? false : fill2 && context2.isPointInPath(x2, y2) || stroke2 && context2.isPointInStroke(x2, y2);
  };
}
function pickPath(path2) {
  return pick$1(hitPath(path2));
}
function translate$1(x2, y2) {
  return "translate(" + x2 + "," + y2 + ")";
}
function rotate(a2) {
  return "rotate(" + a2 + ")";
}
function scale$4(scaleX, scaleY2) {
  return "scale(" + scaleX + "," + scaleY2 + ")";
}
function translateItem(item) {
  return translate$1(item.x || 0, item.y || 0);
}
function rotateItem(item) {
  return translate$1(item.x || 0, item.y || 0) + (item.angle ? " " + rotate(item.angle) : "");
}
function transformItem(item) {
  return translate$1(item.x || 0, item.y || 0) + (item.angle ? " " + rotate(item.angle) : "") + (item.scaleX || item.scaleY ? " " + scale$4(item.scaleX || 1, item.scaleY || 1) : "");
}
function markItemPath(type2, shape2, isect) {
  function attr2(emit2, item) {
    emit2("transform", rotateItem(item));
    emit2("d", shape2(null, item));
  }
  function bound2(bounds2, item) {
    shape2(boundContext(bounds2, item.angle), item);
    return boundStroke(bounds2, item).translate(item.x || 0, item.y || 0);
  }
  function draw2(context2, item) {
    var x2 = item.x || 0, y2 = item.y || 0, a2 = item.angle || 0;
    context2.translate(x2, y2);
    if (a2)
      context2.rotate(a2 *= DegToRad);
    context2.beginPath();
    shape2(context2, item);
    if (a2)
      context2.rotate(-a2);
    context2.translate(-x2, -y2);
  }
  return {
    type: type2,
    tag: "path",
    nested: false,
    attr: attr2,
    bound: bound2,
    draw: drawAll(draw2),
    pick: pickPath(draw2),
    isect: isect || intersectPath(draw2)
  };
}
var arc$2 = markItemPath("arc", arc$1);
function pickArea(a2, p) {
  var v = a2[0].orient === "horizontal" ? p[1] : p[0], z = a2[0].orient === "horizontal" ? "y" : "x", i = a2.length, min2 = Infinity, hit2, d;
  while (--i >= 0) {
    if (a2[i].defined === false)
      continue;
    d = Math.abs(a2[i][z] - v);
    if (d < min2) {
      min2 = d;
      hit2 = a2[i];
    }
  }
  return hit2;
}
function pickLine(a2, p) {
  var t = Math.pow(a2[0].strokeWidth || 1, 2), i = a2.length, dx, dy, dd;
  while (--i >= 0) {
    if (a2[i].defined === false)
      continue;
    dx = a2[i].x - p[0];
    dy = a2[i].y - p[1];
    dd = dx * dx + dy * dy;
    if (dd < t)
      return a2[i];
  }
  return null;
}
function pickTrail(a2, p) {
  var i = a2.length, dx, dy, dd;
  while (--i >= 0) {
    if (a2[i].defined === false)
      continue;
    dx = a2[i].x - p[0];
    dy = a2[i].y - p[1];
    dd = dx * dx + dy * dy;
    dx = a2[i].size || 1;
    if (dd < dx * dx)
      return a2[i];
  }
  return null;
}
function markMultiItemPath(type2, shape2, tip) {
  function attr2(emit2, item) {
    var items = item.mark.items;
    if (items.length)
      emit2("d", shape2(null, items));
  }
  function bound2(bounds2, mark) {
    var items = mark.items;
    if (items.length === 0) {
      return bounds2;
    } else {
      shape2(boundContext(bounds2), items);
      return boundStroke(bounds2, items[0]);
    }
  }
  function draw2(context2, items) {
    context2.beginPath();
    shape2(context2, items);
  }
  const hit2 = hitPath(draw2);
  function pick2(context2, scene, x2, y2, gx, gy) {
    var items = scene.items, b2 = scene.bounds;
    if (!items || !items.length || b2 && !b2.contains(gx, gy)) {
      return null;
    }
    x2 *= context2.pixelRatio;
    y2 *= context2.pixelRatio;
    return hit2(context2, items, x2, y2) ? items[0] : null;
  }
  return {
    type: type2,
    tag: "path",
    nested: true,
    attr: attr2,
    bound: bound2,
    draw: drawOne(draw2),
    pick: pick2,
    isect: intersectPoint,
    tip
  };
}
var area$2 = markMultiItemPath("area", area$1, pickArea);
function clip$2(context2, scene) {
  var clip2 = scene.clip;
  context2.save();
  if (isFunction(clip2)) {
    context2.beginPath();
    clip2(context2);
    context2.clip();
  } else {
    clipGroup(context2, scene.group);
  }
}
function clipGroup(context2, group2) {
  context2.beginPath();
  hasCornerRadius(group2) ? rectangle(context2, group2, 0, 0) : context2.rect(0, 0, group2.width || 0, group2.height || 0);
  context2.clip();
}
function offset$1(item) {
  const sw = value$2(item.strokeWidth, 1);
  return item.strokeOffset != null ? item.strokeOffset : item.stroke && sw > 0.5 && sw < 1.5 ? 0.5 - Math.abs(sw - 1) : 0;
}
function attr$5(emit2, item) {
  emit2("transform", translateItem(item));
}
function emitRectangle(emit2, item) {
  const off = offset$1(item);
  emit2("d", rectangle(null, item, off, off));
}
function background$1(emit2, item) {
  emit2("class", "background");
  emit2("aria-hidden", true);
  emitRectangle(emit2, item);
}
function foreground(emit2, item) {
  emit2("class", "foreground");
  emit2("aria-hidden", true);
  if (item.strokeForeground) {
    emitRectangle(emit2, item);
  } else {
    emit2("d", "");
  }
}
function content(emit2, item, renderer) {
  const url = item.clip ? clip$1(renderer, item, item) : null;
  emit2("clip-path", url);
}
function bound$5(bounds2, group2) {
  if (!group2.clip && group2.items) {
    const items = group2.items, m2 = items.length;
    for (let j = 0; j < m2; ++j) {
      bounds2.union(items[j].bounds);
    }
  }
  if ((group2.clip || group2.width || group2.height) && !group2.noBound) {
    bounds2.add(0, 0).add(group2.width || 0, group2.height || 0);
  }
  boundStroke(bounds2, group2);
  return bounds2.translate(group2.x || 0, group2.y || 0);
}
function rectanglePath(context2, group2, x2, y2) {
  const off = offset$1(group2);
  context2.beginPath();
  rectangle(context2, group2, (x2 || 0) + off, (y2 || 0) + off);
}
const hitBackground = hitPath(rectanglePath);
const hitForeground = hitPath(rectanglePath, false);
const hitCorner = hitPath(rectanglePath, true);
function draw$4(context2, scene, bounds2) {
  visit(scene, (group2) => {
    const gx = group2.x || 0, gy = group2.y || 0, fore = group2.strokeForeground, opacity = group2.opacity == null ? 1 : group2.opacity;
    if ((group2.stroke || group2.fill) && opacity) {
      rectanglePath(context2, group2, gx, gy);
      blend(context2, group2);
      if (group2.fill && fill(context2, group2, opacity)) {
        context2.fill();
      }
      if (group2.stroke && !fore && stroke(context2, group2, opacity)) {
        context2.stroke();
      }
    }
    context2.save();
    context2.translate(gx, gy);
    if (group2.clip)
      clipGroup(context2, group2);
    if (bounds2)
      bounds2.translate(-gx, -gy);
    visit(group2, (item) => {
      this.draw(context2, item, bounds2);
    });
    if (bounds2)
      bounds2.translate(gx, gy);
    context2.restore();
    if (fore && group2.stroke && opacity) {
      rectanglePath(context2, group2, gx, gy);
      blend(context2, group2);
      if (stroke(context2, group2, opacity)) {
        context2.stroke();
      }
    }
  });
}
function pick(context2, scene, x2, y2, gx, gy) {
  if (scene.bounds && !scene.bounds.contains(gx, gy) || !scene.items) {
    return null;
  }
  const cx = x2 * context2.pixelRatio, cy = y2 * context2.pixelRatio;
  return pickVisit(scene, (group2) => {
    let hit2, dx, dy;
    const b2 = group2.bounds;
    if (b2 && !b2.contains(gx, gy))
      return;
    dx = group2.x || 0;
    dy = group2.y || 0;
    const dw = dx + (group2.width || 0), dh = dy + (group2.height || 0), c2 = group2.clip;
    if (c2 && (gx < dx || gx > dw || gy < dy || gy > dh))
      return;
    context2.save();
    context2.translate(dx, dy);
    dx = gx - dx;
    dy = gy - dy;
    if (c2 && hasCornerRadius(group2) && !hitCorner(context2, group2, cx, cy)) {
      context2.restore();
      return null;
    }
    const fore = group2.strokeForeground, ix = scene.interactive !== false;
    if (ix && fore && group2.stroke && hitForeground(context2, group2, cx, cy)) {
      context2.restore();
      return group2;
    }
    hit2 = pickVisit(group2, (mark) => pickMark(mark, dx, dy) ? this.pick(mark, x2, y2, dx, dy) : null);
    if (!hit2 && ix && (group2.fill || !fore && group2.stroke) && hitBackground(context2, group2, cx, cy)) {
      hit2 = group2;
    }
    context2.restore();
    return hit2 || null;
  });
}
function pickMark(mark, x2, y2) {
  return (mark.interactive !== false || mark.marktype === "group") && mark.bounds && mark.bounds.contains(x2, y2);
}
var group = {
  type: "group",
  tag: "g",
  nested: false,
  attr: attr$5,
  bound: bound$5,
  draw: draw$4,
  pick,
  isect: intersectRect,
  content,
  background: background$1,
  foreground
};
var metadata = {
  "xmlns": "http://www.w3.org/2000/svg",
  "xmlns:xlink": "http://www.w3.org/1999/xlink",
  "version": "1.1"
};
function getImage(item, renderer) {
  var image2 = item.image;
  if (!image2 || item.url && item.url !== image2.url) {
    image2 = {
      complete: false,
      width: 0,
      height: 0
    };
    renderer.loadImage(item.url).then((image3) => {
      item.image = image3;
      item.image.url = item.url;
    });
  }
  return image2;
}
function imageWidth(item, image2) {
  return item.width != null ? item.width : !image2 || !image2.width ? 0 : item.aspect !== false && item.height ? item.height * image2.width / image2.height : image2.width;
}
function imageHeight(item, image2) {
  return item.height != null ? item.height : !image2 || !image2.height ? 0 : item.aspect !== false && item.width ? item.width * image2.height / image2.width : image2.height;
}
function imageXOffset(align, w2) {
  return align === "center" ? w2 / 2 : align === "right" ? w2 : 0;
}
function imageYOffset(baseline2, h2) {
  return baseline2 === "middle" ? h2 / 2 : baseline2 === "bottom" ? h2 : 0;
}
function attr$4(emit2, item, renderer) {
  const img = getImage(item, renderer), w2 = imageWidth(item, img), h2 = imageHeight(item, img), x2 = (item.x || 0) - imageXOffset(item.align, w2), y2 = (item.y || 0) - imageYOffset(item.baseline, h2), i = !img.src && img.toDataURL ? img.toDataURL() : img.src || "";
  emit2("href", i, metadata["xmlns:xlink"], "xlink:href");
  emit2("transform", translate$1(x2, y2));
  emit2("width", w2);
  emit2("height", h2);
  emit2("preserveAspectRatio", item.aspect === false ? "none" : "xMidYMid");
}
function bound$4(bounds2, item) {
  const img = item.image, w2 = imageWidth(item, img), h2 = imageHeight(item, img), x2 = (item.x || 0) - imageXOffset(item.align, w2), y2 = (item.y || 0) - imageYOffset(item.baseline, h2);
  return bounds2.set(x2, y2, x2 + w2, y2 + h2);
}
function draw$3(context2, scene, bounds2) {
  visit(scene, (item) => {
    if (bounds2 && !bounds2.intersects(item.bounds))
      return;
    const img = getImage(item, this);
    let w2 = imageWidth(item, img);
    let h2 = imageHeight(item, img);
    if (w2 === 0 || h2 === 0)
      return;
    let x2 = (item.x || 0) - imageXOffset(item.align, w2), y2 = (item.y || 0) - imageYOffset(item.baseline, h2), opacity, ar0, ar1, t;
    if (item.aspect !== false) {
      ar0 = img.width / img.height;
      ar1 = item.width / item.height;
      if (ar0 === ar0 && ar1 === ar1 && ar0 !== ar1) {
        if (ar1 < ar0) {
          t = w2 / ar0;
          y2 += (h2 - t) / 2;
          h2 = t;
        } else {
          t = h2 * ar0;
          x2 += (w2 - t) / 2;
          w2 = t;
        }
      }
    }
    if (img.complete || img.toDataURL) {
      blend(context2, item);
      context2.globalAlpha = (opacity = item.opacity) != null ? opacity : 1;
      context2.imageSmoothingEnabled = item.smooth !== false;
      context2.drawImage(img, x2, y2, w2, h2);
    }
  });
}
var image = {
  type: "image",
  tag: "image",
  nested: false,
  attr: attr$4,
  bound: bound$4,
  draw: draw$3,
  pick: pick$1(),
  isect: truthy,
  // bounds check is sufficient
  get: getImage,
  xOffset: imageXOffset,
  yOffset: imageYOffset
};
var line$2 = markMultiItemPath("line", line$1, pickLine);
function attr$3(emit2, item) {
  var sx = item.scaleX || 1, sy = item.scaleY || 1;
  if (sx !== 1 || sy !== 1) {
    emit2("vector-effect", "non-scaling-stroke");
  }
  emit2("transform", transformItem(item));
  emit2("d", item.path);
}
function path$1(context2, item) {
  var path2 = item.path;
  if (path2 == null)
    return true;
  var x2 = item.x || 0, y2 = item.y || 0, sx = item.scaleX || 1, sy = item.scaleY || 1, a2 = (item.angle || 0) * DegToRad, cache2 = item.pathCache;
  if (!cache2 || cache2.path !== path2) {
    (item.pathCache = cache2 = parse$3(path2)).path = path2;
  }
  if (a2 && context2.rotate && context2.translate) {
    context2.translate(x2, y2);
    context2.rotate(a2);
    pathRender(context2, cache2, 0, 0, sx, sy);
    context2.rotate(-a2);
    context2.translate(-x2, -y2);
  } else {
    pathRender(context2, cache2, x2, y2, sx, sy);
  }
}
function bound$3(bounds2, item) {
  return path$1(boundContext(bounds2, item.angle), item) ? bounds2.set(0, 0, 0, 0) : boundStroke(bounds2, item, true);
}
var path$2 = {
  type: "path",
  tag: "path",
  nested: false,
  attr: attr$3,
  bound: bound$3,
  draw: drawAll(path$1),
  pick: pickPath(path$1),
  isect: intersectPath(path$1)
};
function attr$2(emit2, item) {
  emit2("d", rectangle(null, item));
}
function bound$2(bounds2, item) {
  var x2, y2;
  return boundStroke(bounds2.set(x2 = item.x || 0, y2 = item.y || 0, x2 + item.width || 0, y2 + item.height || 0), item);
}
function draw$2(context2, item) {
  context2.beginPath();
  rectangle(context2, item);
}
var rect = {
  type: "rect",
  tag: "path",
  nested: false,
  attr: attr$2,
  bound: bound$2,
  draw: drawAll(draw$2),
  pick: pickPath(draw$2),
  isect: intersectRect
};
function attr$1(emit2, item) {
  emit2("transform", translateItem(item));
  emit2("x2", item.x2 != null ? item.x2 - (item.x || 0) : 0);
  emit2("y2", item.y2 != null ? item.y2 - (item.y || 0) : 0);
}
function bound$1(bounds2, item) {
  var x12, y12;
  return boundStroke(bounds2.set(x12 = item.x || 0, y12 = item.y || 0, item.x2 != null ? item.x2 : x12, item.y2 != null ? item.y2 : y12), item);
}
function path(context2, item, opacity) {
  var x12, y12, x2, y2;
  if (item.stroke && stroke(context2, item, opacity)) {
    x12 = item.x || 0;
    y12 = item.y || 0;
    x2 = item.x2 != null ? item.x2 : x12;
    y2 = item.y2 != null ? item.y2 : y12;
    context2.beginPath();
    context2.moveTo(x12, y12);
    context2.lineTo(x2, y2);
    return true;
  }
  return false;
}
function draw$1(context2, scene, bounds2) {
  visit(scene, (item) => {
    if (bounds2 && !bounds2.intersects(item.bounds))
      return;
    var opacity = item.opacity == null ? 1 : item.opacity;
    if (opacity && path(context2, item, opacity)) {
      blend(context2, item);
      context2.stroke();
    }
  });
}
function hit$1(context2, item, x2, y2) {
  if (!context2.isPointInStroke)
    return false;
  return path(context2, item, 1) && context2.isPointInStroke(x2, y2);
}
var rule$1 = {
  type: "rule",
  tag: "line",
  nested: false,
  attr: attr$1,
  bound: bound$1,
  draw: draw$1,
  pick: pick$1(hit$1),
  isect: intersectRule
};
var shape = markItemPath("shape", shape$1);
var symbol = markItemPath("symbol", symbol$1, intersectPoint);
const widthCache = lruCache();
var textMetrics = {
  height: fontSize,
  measureWidth,
  estimateWidth,
  width: estimateWidth,
  canvas: useCanvas
};
useCanvas(true);
function useCanvas(use) {
  textMetrics.width = use && context$2 ? measureWidth : estimateWidth;
}
function estimateWidth(item, text2) {
  return _estimateWidth(textValue(item, text2), fontSize(item));
}
function _estimateWidth(text2, currentFontHeight) {
  return ~~(0.8 * text2.length * currentFontHeight);
}
function measureWidth(item, text2) {
  return fontSize(item) <= 0 || !(text2 = textValue(item, text2)) ? 0 : _measureWidth(text2, font(item));
}
function _measureWidth(text2, currentFont) {
  const key2 = `(${currentFont}) ${text2}`;
  let width2 = widthCache.get(key2);
  if (width2 === void 0) {
    context$2.font = currentFont;
    width2 = context$2.measureText(text2).width;
    widthCache.set(key2, width2);
  }
  return width2;
}
function fontSize(item) {
  return item.fontSize != null ? +item.fontSize || 0 : 11;
}
function lineHeight(item) {
  return item.lineHeight != null ? item.lineHeight : fontSize(item) + 2;
}
function lineArray(_) {
  return isArray(_) ? _.length > 1 ? _ : _[0] : _;
}
function textLines(item) {
  return lineArray(item.lineBreak && item.text && !isArray(item.text) ? item.text.split(item.lineBreak) : item.text);
}
function multiLineOffset(item) {
  const tl2 = textLines(item);
  return (isArray(tl2) ? tl2.length - 1 : 0) * lineHeight(item);
}
function textValue(item, line2) {
  const text2 = line2 == null ? "" : (line2 + "").trim();
  return item.limit > 0 && text2.length ? truncate(item, text2) : text2;
}
function widthGetter(item) {
  if (textMetrics.width === measureWidth) {
    const currentFont = font(item);
    return (text2) => _measureWidth(text2, currentFont);
  } else {
    const currentFontHeight = fontSize(item);
    return (text2) => _estimateWidth(text2, currentFontHeight);
  }
}
function truncate(item, text2) {
  var limit = +item.limit, width2 = widthGetter(item);
  if (width2(text2) < limit)
    return text2;
  var ellipsis = item.ellipsis || "…", rtl = item.dir === "rtl", lo = 0, hi = text2.length, mid;
  limit -= width2(ellipsis);
  if (rtl) {
    while (lo < hi) {
      mid = lo + hi >>> 1;
      if (width2(text2.slice(mid)) > limit)
        lo = mid + 1;
      else
        hi = mid;
    }
    return ellipsis + text2.slice(lo);
  } else {
    while (lo < hi) {
      mid = 1 + (lo + hi >>> 1);
      if (width2(text2.slice(0, mid)) < limit)
        lo = mid;
      else
        hi = mid - 1;
    }
    return text2.slice(0, lo) + ellipsis;
  }
}
function fontFamily(item, quote) {
  var font2 = item.font;
  return (quote && font2 ? String(font2).replace(/"/g, "'") : font2) || "sans-serif";
}
function font(item, quote) {
  return (item.fontStyle ? item.fontStyle + " " : "") + (item.fontVariant ? item.fontVariant + " " : "") + (item.fontWeight ? item.fontWeight + " " : "") + fontSize(item) + "px " + fontFamily(item, quote);
}
function offset$2(item) {
  var baseline2 = item.baseline, h2 = fontSize(item);
  return Math.round(baseline2 === "top" ? 0.79 * h2 : baseline2 === "middle" ? 0.3 * h2 : baseline2 === "bottom" ? -0.21 * h2 : baseline2 === "line-top" ? 0.29 * h2 + 0.5 * lineHeight(item) : baseline2 === "line-bottom" ? 0.29 * h2 - 0.5 * lineHeight(item) : 0);
}
const textAlign = {
  "left": "start",
  "center": "middle",
  "right": "end"
};
const tempBounds$1 = new Bounds();
function anchorPoint(item) {
  var x2 = item.x || 0, y2 = item.y || 0, r = item.radius || 0, t;
  if (r) {
    t = (item.theta || 0) - HalfPi;
    x2 += r * Math.cos(t);
    y2 += r * Math.sin(t);
  }
  tempBounds$1.x1 = x2;
  tempBounds$1.y1 = y2;
  return tempBounds$1;
}
function attr(emit2, item) {
  var dx = item.dx || 0, dy = (item.dy || 0) + offset$2(item), p = anchorPoint(item), x2 = p.x1, y2 = p.y1, a2 = item.angle || 0, t;
  emit2("text-anchor", textAlign[item.align] || "start");
  if (a2) {
    t = translate$1(x2, y2) + " " + rotate(a2);
    if (dx || dy)
      t += " " + translate$1(dx, dy);
  } else {
    t = translate$1(x2 + dx, y2 + dy);
  }
  emit2("transform", t);
}
function bound(bounds2, item, mode) {
  var h2 = textMetrics.height(item), a2 = item.align, p = anchorPoint(item), x2 = p.x1, y2 = p.y1, dx = item.dx || 0, dy = (item.dy || 0) + offset$2(item) - Math.round(0.8 * h2), tl2 = textLines(item), w2;
  if (isArray(tl2)) {
    h2 += lineHeight(item) * (tl2.length - 1);
    w2 = tl2.reduce((w3, t) => Math.max(w3, textMetrics.width(item, t)), 0);
  } else {
    w2 = textMetrics.width(item, tl2);
  }
  if (a2 === "center") {
    dx -= w2 / 2;
  } else if (a2 === "right") {
    dx -= w2;
  } else
    ;
  bounds2.set(dx += x2, dy += y2, dx + w2, dy + h2);
  if (item.angle && !mode) {
    bounds2.rotate(item.angle * DegToRad, x2, y2);
  } else if (mode === 2) {
    return bounds2.rotatedPoints(item.angle * DegToRad, x2, y2);
  }
  return bounds2;
}
function draw$5(context2, scene, bounds2) {
  visit(scene, (item) => {
    var opacity = item.opacity == null ? 1 : item.opacity, p, x2, y2, i, lh, tl2, str;
    if (bounds2 && !bounds2.intersects(item.bounds) || // bounds check
    opacity === 0 || item.fontSize <= 0 || item.text == null || item.text.length === 0)
      return;
    context2.font = font(item);
    context2.textAlign = item.align || "left";
    p = anchorPoint(item);
    x2 = p.x1, y2 = p.y1;
    if (item.angle) {
      context2.save();
      context2.translate(x2, y2);
      context2.rotate(item.angle * DegToRad);
      x2 = y2 = 0;
    }
    x2 += item.dx || 0;
    y2 += (item.dy || 0) + offset$2(item);
    tl2 = textLines(item);
    blend(context2, item);
    if (isArray(tl2)) {
      lh = lineHeight(item);
      for (i = 0; i < tl2.length; ++i) {
        str = textValue(item, tl2[i]);
        if (item.fill && fill(context2, item, opacity)) {
          context2.fillText(str, x2, y2);
        }
        if (item.stroke && stroke(context2, item, opacity)) {
          context2.strokeText(str, x2, y2);
        }
        y2 += lh;
      }
    } else {
      str = textValue(item, tl2);
      if (item.fill && fill(context2, item, opacity)) {
        context2.fillText(str, x2, y2);
      }
      if (item.stroke && stroke(context2, item, opacity)) {
        context2.strokeText(str, x2, y2);
      }
    }
    if (item.angle)
      context2.restore();
  });
}
function hit(context2, item, x2, y2, gx, gy) {
  if (item.fontSize <= 0)
    return false;
  if (!item.angle)
    return true;
  var p = anchorPoint(item), ax = p.x1, ay = p.y1, b2 = bound(tempBounds$1, item, 1), a2 = -item.angle * DegToRad, cos2 = Math.cos(a2), sin2 = Math.sin(a2), px2 = cos2 * gx - sin2 * gy + (ax - cos2 * ax + sin2 * ay), py2 = sin2 * gx + cos2 * gy + (ay - sin2 * ax - cos2 * ay);
  return b2.contains(px2, py2);
}
function intersectText(item, box) {
  const p = bound(tempBounds$1, item, 2);
  return intersectBoxLine(box, p[0], p[1], p[2], p[3]) || intersectBoxLine(box, p[0], p[1], p[4], p[5]) || intersectBoxLine(box, p[4], p[5], p[6], p[7]) || intersectBoxLine(box, p[2], p[3], p[6], p[7]);
}
var text = {
  type: "text",
  tag: "text",
  nested: false,
  attr,
  bound,
  draw: draw$5,
  pick: pick$1(hit),
  isect: intersectText
};
var trail = markMultiItemPath("trail", trail$1, pickTrail);
var Marks = {
  arc: arc$2,
  area: area$2,
  group,
  image,
  line: line$2,
  path: path$2,
  rect,
  rule: rule$1,
  shape,
  symbol,
  text,
  trail
};
function boundItem$1(item, func, opt) {
  var type2 = Marks[item.mark.marktype], bound2 = func || type2.bound;
  if (type2.nested)
    item = item.mark;
  return bound2(item.bounds || (item.bounds = new Bounds()), item, opt);
}
var DUMMY = {
  mark: null
};
function boundMark(mark, bounds2, opt) {
  var type2 = Marks[mark.marktype], bound2 = type2.bound, items = mark.items, hasItems = items && items.length, i, n, item, b2;
  if (type2.nested) {
    if (hasItems) {
      item = items[0];
    } else {
      DUMMY.mark = mark;
      item = DUMMY;
    }
    b2 = boundItem$1(item, bound2, opt);
    bounds2 = bounds2 && bounds2.union(b2) || b2;
    return bounds2;
  }
  bounds2 = bounds2 || mark.bounds && mark.bounds.clear() || new Bounds();
  if (hasItems) {
    for (i = 0, n = items.length; i < n; ++i) {
      bounds2.union(boundItem$1(items[i], bound2, opt));
    }
  }
  return mark.bounds = bounds2;
}
const keys$1 = [
  "marktype",
  "name",
  "role",
  "interactive",
  "clip",
  "items",
  "zindex",
  "x",
  "y",
  "width",
  "height",
  "align",
  "baseline",
  // layout
  "fill",
  "fillOpacity",
  "opacity",
  "blend",
  // fill
  "stroke",
  "strokeOpacity",
  "strokeWidth",
  "strokeCap",
  // stroke
  "strokeDash",
  "strokeDashOffset",
  // stroke dash
  "strokeForeground",
  "strokeOffset",
  // group
  "startAngle",
  "endAngle",
  "innerRadius",
  "outerRadius",
  // arc
  "cornerRadius",
  "padAngle",
  // arc, rect
  "cornerRadiusTopLeft",
  "cornerRadiusTopRight",
  // rect, group
  "cornerRadiusBottomLeft",
  "cornerRadiusBottomRight",
  "interpolate",
  "tension",
  "orient",
  "defined",
  // area, line
  "url",
  "aspect",
  "smooth",
  // image
  "path",
  "scaleX",
  "scaleY",
  // path
  "x2",
  "y2",
  // rule
  "size",
  "shape",
  // symbol
  "text",
  "angle",
  "theta",
  "radius",
  "dir",
  "dx",
  "dy",
  // text
  "ellipsis",
  "limit",
  "lineBreak",
  "lineHeight",
  "font",
  "fontSize",
  "fontWeight",
  "fontStyle",
  "fontVariant",
  // font
  "description",
  "aria",
  "ariaRole",
  "ariaRoleDescription"
  // aria
];
function sceneToJSON(scene, indent) {
  return JSON.stringify(scene, keys$1, indent);
}
function sceneFromJSON(json2) {
  const scene = typeof json2 === "string" ? JSON.parse(json2) : json2;
  return initialize$1(scene);
}
function initialize$1(scene) {
  var type2 = scene.marktype, items = scene.items, parent, i, n;
  if (items) {
    for (i = 0, n = items.length; i < n; ++i) {
      parent = type2 ? "mark" : "group";
      items[i][parent] = scene;
      if (items[i].zindex)
        items[i][parent].zdirty = true;
      if ("group" === (type2 || parent))
        initialize$1(items[i]);
    }
  }
  if (type2)
    boundMark(scene);
  return scene;
}
function Scenegraph(scene) {
  if (arguments.length) {
    this.root = sceneFromJSON(scene);
  } else {
    this.root = createMark({
      marktype: "group",
      name: "root",
      role: "frame"
    });
    this.root.items = [new GroupItem(this.root)];
  }
}
Scenegraph.prototype = {
  toJSON(indent) {
    return sceneToJSON(this.root, indent || 0);
  },
  mark(markdef, group2, index2) {
    group2 = group2 || this.root.items[0];
    const mark = createMark(markdef, group2);
    group2.items[index2] = mark;
    if (mark.zindex)
      mark.group.zdirty = true;
    return mark;
  }
};
function createMark(def2, group2) {
  const mark = {
    bounds: new Bounds(),
    clip: !!def2.clip,
    group: group2,
    interactive: def2.interactive === false ? false : true,
    items: [],
    marktype: def2.marktype,
    name: def2.name || void 0,
    role: def2.role || void 0,
    zindex: def2.zindex || 0
  };
  if (def2.aria != null) {
    mark.aria = def2.aria;
  }
  if (def2.description) {
    mark.description = def2.description;
  }
  return mark;
}
function domCreate(doc, tag, ns) {
  if (!doc && typeof document !== "undefined" && document.createElement) {
    doc = document;
  }
  return doc ? ns ? doc.createElementNS(ns, tag) : doc.createElement(tag) : null;
}
function domFind(el, tag) {
  tag = tag.toLowerCase();
  var nodes = el.childNodes, i = 0, n = nodes.length;
  for (; i < n; ++i)
    if (nodes[i].tagName.toLowerCase() === tag) {
      return nodes[i];
    }
}
function domChild(el, index2, tag, ns) {
  var a2 = el.childNodes[index2], b2;
  if (!a2 || a2.tagName.toLowerCase() !== tag.toLowerCase()) {
    b2 = a2 || null;
    a2 = domCreate(el.ownerDocument, tag, ns);
    el.insertBefore(a2, b2);
  }
  return a2;
}
function domClear(el, index2) {
  var nodes = el.childNodes, curr = nodes.length;
  while (curr > index2)
    el.removeChild(nodes[--curr]);
  return el;
}
function cssClass(mark) {
  return "mark-" + mark.marktype + (mark.role ? " role-" + mark.role : "") + (mark.name ? " " + mark.name : "");
}
function point(event2, el) {
  const rect2 = el.getBoundingClientRect();
  return [event2.clientX - rect2.left - (el.clientLeft || 0), event2.clientY - rect2.top - (el.clientTop || 0)];
}
function resolveItem(item, event2, el, origin) {
  var mark = item && item.mark, mdef, p;
  if (mark && (mdef = Marks[mark.marktype]).tip) {
    p = point(event2, el);
    p[0] -= origin[0];
    p[1] -= origin[1];
    while (item = item.mark.group) {
      p[0] -= item.x || 0;
      p[1] -= item.y || 0;
    }
    item = mdef.tip(mark.items, p);
  }
  return item;
}
function Handler(customLoader, customTooltip) {
  this._active = null;
  this._handlers = {};
  this._loader = customLoader || loader();
  this._tooltip = customTooltip || defaultTooltip$1;
}
function defaultTooltip$1(handler, event2, item, value2) {
  handler.element().setAttribute("title", value2 || "");
}
Handler.prototype = {
  /**
   * Initialize a new Handler instance.
   * @param {DOMElement} el - The containing DOM element for the display.
   * @param {Array<number>} origin - The origin of the display, in pixels.
   *   The coordinate system will be translated to this point.
   * @param {object} [obj] - Optional context object that should serve as
   *   the "this" context for event callbacks.
   * @return {Handler} - This handler instance.
   */
  initialize(el, origin, obj) {
    this._el = el;
    this._obj = obj || null;
    return this.origin(origin);
  },
  /**
   * Returns the parent container element for a visualization.
   * @return {DOMElement} - The containing DOM element.
   */
  element() {
    return this._el;
  },
  /**
   * Returns the scene element (e.g., canvas or SVG) of the visualization
   * Subclasses must override if the first child is not the scene element.
   * @return {DOMElement} - The scene (e.g., canvas or SVG) element.
   */
  canvas() {
    return this._el && this._el.firstChild;
  },
  /**
   * Get / set the origin coordinates of the visualization.
   */
  origin(origin) {
    if (arguments.length) {
      this._origin = origin || [0, 0];
      return this;
    } else {
      return this._origin.slice();
    }
  },
  /**
   * Get / set the scenegraph root.
   */
  scene(scene) {
    if (!arguments.length)
      return this._scene;
    this._scene = scene;
    return this;
  },
  /**
   * Add an event handler. Subclasses should override this method.
   */
  on() {
  },
  /**
   * Remove an event handler. Subclasses should override this method.
   */
  off() {
  },
  /**
   * Utility method for finding the array index of an event handler.
   * @param {Array} h - An array of registered event handlers.
   * @param {string} type - The event type.
   * @param {function} handler - The event handler instance to find.
   * @return {number} - The handler's array index or -1 if not registered.
   */
  _handlerIndex(h2, type2, handler) {
    for (let i = h2 ? h2.length : 0; --i >= 0; ) {
      if (h2[i].type === type2 && (!handler || h2[i].handler === handler)) {
        return i;
      }
    }
    return -1;
  },
  /**
   * Returns an array with registered event handlers.
   * @param {string} [type] - The event type to query. Any annotations
   *   are ignored; for example, for the argument "click.foo", ".foo" will
   *   be ignored and the method returns all "click" handlers. If type is
   *   null or unspecified, this method returns handlers for all types.
   * @return {Array} - A new array containing all registered event handlers.
   */
  handlers(type2) {
    const h2 = this._handlers, a2 = [];
    if (type2) {
      a2.push(...h2[this.eventName(type2)]);
    } else {
      for (const k in h2) {
        a2.push(...h2[k]);
      }
    }
    return a2;
  },
  /**
   * Parses an event name string to return the specific event type.
   * For example, given "click.foo" returns "click"
   * @param {string} name - The input event type string.
   * @return {string} - A string with the event type only.
   */
  eventName(name) {
    const i = name.indexOf(".");
    return i < 0 ? name : name.slice(0, i);
  },
  /**
   * Handle hyperlink navigation in response to an item.href value.
   * @param {Event} event - The event triggering hyperlink navigation.
   * @param {Item} item - The scenegraph item.
   * @param {string} href - The URL to navigate to.
   */
  handleHref(event2, item, href2) {
    this._loader.sanitize(href2, {
      context: "href"
    }).then((opt) => {
      const e = new MouseEvent(event2.type, event2), a2 = domCreate(null, "a");
      for (const name in opt)
        a2.setAttribute(name, opt[name]);
      a2.dispatchEvent(e);
    }).catch(() => {
    });
  },
  /**
   * Handle tooltip display in response to an item.tooltip value.
   * @param {Event} event - The event triggering tooltip display.
   * @param {Item} item - The scenegraph item.
   * @param {boolean} show - A boolean flag indicating whether
   *   to show or hide a tooltip for the given item.
   */
  handleTooltip(event2, item, show) {
    if (item && item.tooltip != null) {
      item = resolveItem(item, event2, this.canvas(), this._origin);
      const value2 = show && item && item.tooltip || null;
      this._tooltip.call(this._obj, this, event2, item, value2);
    }
  },
  /**
   * Returns the size of a scenegraph item and its position relative
   * to the viewport.
   * @param {Item} item - The scenegraph item.
   * @return {object} - A bounding box object (compatible with the
   *   DOMRect type) consisting of x, y, width, heigh, top, left,
   *   right, and bottom properties.
   */
  getItemBoundingClientRect(item) {
    const el = this.canvas();
    if (!el)
      return;
    const rect2 = el.getBoundingClientRect(), origin = this._origin, bounds2 = item.bounds, width2 = bounds2.width(), height2 = bounds2.height();
    let x2 = bounds2.x1 + origin[0] + rect2.left, y2 = bounds2.y1 + origin[1] + rect2.top;
    while (item.mark && (item = item.mark.group)) {
      x2 += item.x || 0;
      y2 += item.y || 0;
    }
    return {
      x: x2,
      y: y2,
      width: width2,
      height: height2,
      left: x2,
      top: y2,
      right: x2 + width2,
      bottom: y2 + height2
    };
  }
};
function Renderer(loader2) {
  this._el = null;
  this._bgcolor = null;
  this._loader = new ResourceLoader(loader2);
}
Renderer.prototype = {
  /**
   * Initialize a new Renderer instance.
   * @param {DOMElement} el - The containing DOM element for the display.
   * @param {number} width - The coordinate width of the display, in pixels.
   * @param {number} height - The coordinate height of the display, in pixels.
   * @param {Array<number>} origin - The origin of the display, in pixels.
   *   The coordinate system will be translated to this point.
   * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
   *   the width and height to determine the final pixel size.
   * @return {Renderer} - This renderer instance.
   */
  initialize(el, width2, height2, origin, scaleFactor) {
    this._el = el;
    return this.resize(width2, height2, origin, scaleFactor);
  },
  /**
   * Returns the parent container element for a visualization.
   * @return {DOMElement} - The containing DOM element.
   */
  element() {
    return this._el;
  },
  /**
   * Returns the scene element (e.g., canvas or SVG) of the visualization
   * Subclasses must override if the first child is not the scene element.
   * @return {DOMElement} - The scene (e.g., canvas or SVG) element.
   */
  canvas() {
    return this._el && this._el.firstChild;
  },
  /**
   * Get / set the background color.
   */
  background(bgcolor) {
    if (arguments.length === 0)
      return this._bgcolor;
    this._bgcolor = bgcolor;
    return this;
  },
  /**
   * Resize the display.
   * @param {number} width - The new coordinate width of the display, in pixels.
   * @param {number} height - The new coordinate height of the display, in pixels.
   * @param {Array<number>} origin - The new origin of the display, in pixels.
   *   The coordinate system will be translated to this point.
   * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
   *   the width and height to determine the final pixel size.
   * @return {Renderer} - This renderer instance;
   */
  resize(width2, height2, origin, scaleFactor) {
    this._width = width2;
    this._height = height2;
    this._origin = origin || [0, 0];
    this._scale = scaleFactor || 1;
    return this;
  },
  /**
   * Report a dirty item whose bounds should be redrawn.
   * This base class method does nothing. Subclasses that perform
   * incremental should implement this method.
   * @param {Item} item - The dirty item whose bounds should be redrawn.
   */
  dirty() {
  },
  /**
   * Render an input scenegraph, potentially with a set of dirty items.
   * This method will perform an immediate rendering with available resources.
   * The renderer may also need to perform image loading to perform a complete
   * render. This process can lead to asynchronous re-rendering of the scene
   * after this method returns. To receive notification when rendering is
   * complete, use the renderAsync method instead.
   * @param {object} scene - The root mark of a scenegraph to render.
   * @return {Renderer} - This renderer instance.
   */
  render(scene) {
    const r = this;
    r._call = function() {
      r._render(scene);
    };
    r._call();
    r._call = null;
    return r;
  },
  /**
   * Internal rendering method. Renderer subclasses should override this
   * method to actually perform rendering.
   * @param {object} scene - The root mark of a scenegraph to render.
   */
  _render() {
  },
  /**
   * Asynchronous rendering method. Similar to render, but returns a Promise
   * that resolves when all rendering is completed. Sometimes a renderer must
   * perform image loading to get a complete rendering. The returned
   * Promise will not resolve until this process completes.
   * @param {object} scene - The root mark of a scenegraph to render.
   * @return {Promise} - A Promise that resolves when rendering is complete.
   */
  renderAsync(scene) {
    const r = this.render(scene);
    return this._ready ? this._ready.then(() => r) : Promise.resolve(r);
  },
  /**
   * Internal method for asynchronous resource loading.
   * Proxies method calls to the ImageLoader, and tracks loading
   * progress to invoke a re-render once complete.
   * @param {string} method - The method name to invoke on the ImageLoader.
   * @param {string} uri - The URI for the requested resource.
   * @return {Promise} - A Promise that resolves to the requested resource.
   */
  _load(method2, uri) {
    var r = this, p = r._loader[method2](uri);
    if (!r._ready) {
      const call = r._call;
      r._ready = r._loader.ready().then((redraw) => {
        if (redraw)
          call();
        r._ready = null;
      });
    }
    return p;
  },
  /**
   * Sanitize a URL to include as a hyperlink in the rendered scene.
   * This method proxies a call to ImageLoader.sanitizeURL, but also tracks
   * image loading progress and invokes a re-render once complete.
   * @param {string} uri - The URI string to sanitize.
   * @return {Promise} - A Promise that resolves to the sanitized URL.
   */
  sanitizeURL(uri) {
    return this._load("sanitizeURL", uri);
  },
  /**
   * Requests an image to include in the rendered scene.
   * This method proxies a call to ImageLoader.loadImage, but also tracks
   * image loading progress and invokes a re-render once complete.
   * @param {string} uri - The URI string of the image.
   * @return {Promise} - A Promise that resolves to the loaded Image.
   */
  loadImage(uri) {
    return this._load("loadImage", uri);
  }
};
const KeyDownEvent = "keydown";
const KeyPressEvent = "keypress";
const KeyUpEvent = "keyup";
const DragEnterEvent = "dragenter";
const DragLeaveEvent = "dragleave";
const DragOverEvent = "dragover";
const MouseDownEvent = "mousedown";
const MouseUpEvent = "mouseup";
const MouseMoveEvent = "mousemove";
const MouseOutEvent = "mouseout";
const MouseOverEvent = "mouseover";
const ClickEvent = "click";
const DoubleClickEvent = "dblclick";
const WheelEvent = "wheel";
const MouseWheelEvent = "mousewheel";
const TouchStartEvent = "touchstart";
const TouchMoveEvent = "touchmove";
const TouchEndEvent = "touchend";
const Events = [KeyDownEvent, KeyPressEvent, KeyUpEvent, DragEnterEvent, DragLeaveEvent, DragOverEvent, MouseDownEvent, MouseUpEvent, MouseMoveEvent, MouseOutEvent, MouseOverEvent, ClickEvent, DoubleClickEvent, WheelEvent, MouseWheelEvent, TouchStartEvent, TouchMoveEvent, TouchEndEvent];
const TooltipShowEvent = MouseMoveEvent;
const TooltipHideEvent = MouseOutEvent;
const HrefEvent = ClickEvent;
function CanvasHandler(loader2, tooltip) {
  Handler.call(this, loader2, tooltip);
  this._down = null;
  this._touch = null;
  this._first = true;
  this._events = {};
}
const eventBundle = (type2) => type2 === TouchStartEvent || type2 === TouchMoveEvent || type2 === TouchEndEvent ? [TouchStartEvent, TouchMoveEvent, TouchEndEvent] : [type2];
function eventListenerCheck(handler, type2) {
  eventBundle(type2).forEach((_) => addEventListener(handler, _));
}
function addEventListener(handler, type2) {
  const canvas2 = handler.canvas();
  if (canvas2 && !handler._events[type2]) {
    handler._events[type2] = 1;
    canvas2.addEventListener(type2, handler[type2] ? (evt) => handler[type2](evt) : (evt) => handler.fire(type2, evt));
  }
}
function move(moveEvent, overEvent, outEvent) {
  return function(evt) {
    const a2 = this._active, p = this.pickEvent(evt);
    if (p === a2) {
      this.fire(moveEvent, evt);
    } else {
      if (!a2 || !a2.exit) {
        this.fire(outEvent, evt);
      }
      this._active = p;
      this.fire(overEvent, evt);
      this.fire(moveEvent, evt);
    }
  };
}
function inactive(type2) {
  return function(evt) {
    this.fire(type2, evt);
    this._active = null;
  };
}
inherits(CanvasHandler, Handler, {
  initialize(el, origin, obj) {
    this._canvas = el && domFind(el, "canvas");
    [ClickEvent, MouseDownEvent, MouseMoveEvent, MouseOutEvent, DragLeaveEvent].forEach((type2) => eventListenerCheck(this, type2));
    return Handler.prototype.initialize.call(this, el, origin, obj);
  },
  // return the backing canvas instance
  canvas() {
    return this._canvas;
  },
  // retrieve the current canvas context
  context() {
    return this._canvas.getContext("2d");
  },
  // supported events
  events: Events,
  // to keep old versions of firefox happy
  DOMMouseScroll(evt) {
    this.fire(MouseWheelEvent, evt);
  },
  mousemove: move(MouseMoveEvent, MouseOverEvent, MouseOutEvent),
  dragover: move(DragOverEvent, DragEnterEvent, DragLeaveEvent),
  mouseout: inactive(MouseOutEvent),
  dragleave: inactive(DragLeaveEvent),
  mousedown(evt) {
    this._down = this._active;
    this.fire(MouseDownEvent, evt);
  },
  click(evt) {
    if (this._down === this._active) {
      this.fire(ClickEvent, evt);
      this._down = null;
    }
  },
  touchstart(evt) {
    this._touch = this.pickEvent(evt.changedTouches[0]);
    if (this._first) {
      this._active = this._touch;
      this._first = false;
    }
    this.fire(TouchStartEvent, evt, true);
  },
  touchmove(evt) {
    this.fire(TouchMoveEvent, evt, true);
  },
  touchend(evt) {
    this.fire(TouchEndEvent, evt, true);
    this._touch = null;
  },
  // fire an event
  fire(type2, evt, touch2) {
    const a2 = touch2 ? this._touch : this._active, h2 = this._handlers[type2];
    evt.vegaType = type2;
    if (type2 === HrefEvent && a2 && a2.href) {
      this.handleHref(evt, a2, a2.href);
    } else if (type2 === TooltipShowEvent || type2 === TooltipHideEvent) {
      this.handleTooltip(evt, a2, type2 !== TooltipHideEvent);
    }
    if (h2) {
      for (let i = 0, len = h2.length; i < len; ++i) {
        h2[i].handler.call(this._obj, evt, a2);
      }
    }
  },
  // add an event handler
  on(type2, handler) {
    const name = this.eventName(type2), h2 = this._handlers, i = this._handlerIndex(h2[name], type2, handler);
    if (i < 0) {
      eventListenerCheck(this, type2);
      (h2[name] || (h2[name] = [])).push({
        type: type2,
        handler
      });
    }
    return this;
  },
  // remove an event handler
  off(type2, handler) {
    const name = this.eventName(type2), h2 = this._handlers[name], i = this._handlerIndex(h2, type2, handler);
    if (i >= 0) {
      h2.splice(i, 1);
    }
    return this;
  },
  pickEvent(evt) {
    const p = point(evt, this._canvas), o = this._origin;
    return this.pick(this._scene, p[0], p[1], p[0] - o[0], p[1] - o[1]);
  },
  // find the scenegraph item at the current mouse position
  // x, y -- the absolute x, y mouse coordinates on the canvas element
  // gx, gy -- the relative coordinates within the current group
  pick(scene, x2, y2, gx, gy) {
    const g = this.context(), mark = Marks[scene.marktype];
    return mark.pick.call(this, g, scene, x2, y2, gx, gy);
  }
});
function devicePixelRatio() {
  return typeof window !== "undefined" ? window.devicePixelRatio || 1 : 1;
}
var pixelRatio = devicePixelRatio();
function resize(canvas2, width2, height2, origin, scaleFactor, opt) {
  const inDOM = typeof HTMLElement !== "undefined" && canvas2 instanceof HTMLElement && canvas2.parentNode != null, context2 = canvas2.getContext("2d"), ratio = inDOM ? pixelRatio : scaleFactor;
  canvas2.width = width2 * ratio;
  canvas2.height = height2 * ratio;
  for (const key2 in opt) {
    context2[key2] = opt[key2];
  }
  if (inDOM && ratio !== 1) {
    canvas2.style.width = width2 + "px";
    canvas2.style.height = height2 + "px";
  }
  context2.pixelRatio = ratio;
  context2.setTransform(ratio, 0, 0, ratio, ratio * origin[0], ratio * origin[1]);
  return canvas2;
}
function CanvasRenderer(loader2) {
  Renderer.call(this, loader2);
  this._options = {};
  this._redraw = false;
  this._dirty = new Bounds();
  this._tempb = new Bounds();
}
const base$1 = Renderer.prototype;
const viewBounds = (origin, width2, height2) => new Bounds().set(0, 0, width2, height2).translate(-origin[0], -origin[1]);
function clipToBounds(g, b2, origin) {
  b2.expand(1).round();
  if (g.pixelRatio % 1) {
    b2.scale(g.pixelRatio).round().scale(1 / g.pixelRatio);
  }
  b2.translate(-(origin[0] % 1), -(origin[1] % 1));
  g.beginPath();
  g.rect(b2.x1, b2.y1, b2.width(), b2.height());
  g.clip();
  return b2;
}
inherits(CanvasRenderer, Renderer, {
  initialize(el, width2, height2, origin, scaleFactor, options) {
    this._options = options || {};
    this._canvas = this._options.externalContext ? null : canvas(1, 1, this._options.type);
    if (el && this._canvas) {
      domClear(el, 0).appendChild(this._canvas);
      this._canvas.setAttribute("class", "marks");
    }
    return base$1.initialize.call(this, el, width2, height2, origin, scaleFactor);
  },
  resize(width2, height2, origin, scaleFactor) {
    base$1.resize.call(this, width2, height2, origin, scaleFactor);
    if (this._canvas) {
      resize(this._canvas, this._width, this._height, this._origin, this._scale, this._options.context);
    } else {
      const ctx = this._options.externalContext;
      if (!ctx)
        error("CanvasRenderer is missing a valid canvas or context");
      ctx.scale(this._scale, this._scale);
      ctx.translate(this._origin[0], this._origin[1]);
    }
    this._redraw = true;
    return this;
  },
  canvas() {
    return this._canvas;
  },
  context() {
    return this._options.externalContext || (this._canvas ? this._canvas.getContext("2d") : null);
  },
  dirty(item) {
    const b2 = this._tempb.clear().union(item.bounds);
    let g = item.mark.group;
    while (g) {
      b2.translate(g.x || 0, g.y || 0);
      g = g.mark.group;
    }
    this._dirty.union(b2);
  },
  _render(scene) {
    const g = this.context(), o = this._origin, w2 = this._width, h2 = this._height, db = this._dirty, vb = viewBounds(o, w2, h2);
    g.save();
    const b2 = this._redraw || db.empty() ? (this._redraw = false, vb.expand(1)) : clipToBounds(g, vb.intersect(db), o);
    this.clear(-o[0], -o[1], w2, h2);
    this.draw(g, scene, b2);
    g.restore();
    db.clear();
    return this;
  },
  draw(ctx, scene, bounds2) {
    const mark = Marks[scene.marktype];
    if (scene.clip)
      clip$2(ctx, scene);
    mark.draw.call(this, ctx, scene, bounds2);
    if (scene.clip)
      ctx.restore();
  },
  clear(x2, y2, w2, h2) {
    const opt = this._options, g = this.context();
    if (opt.type !== "pdf" && !opt.externalContext) {
      g.clearRect(x2, y2, w2, h2);
    }
    if (this._bgcolor != null) {
      g.fillStyle = this._bgcolor;
      g.fillRect(x2, y2, w2, h2);
    }
  }
});
function SVGHandler(loader2, tooltip) {
  Handler.call(this, loader2, tooltip);
  const h2 = this;
  h2._hrefHandler = listener(h2, (evt, item) => {
    if (item && item.href)
      h2.handleHref(evt, item, item.href);
  });
  h2._tooltipHandler = listener(h2, (evt, item) => {
    h2.handleTooltip(evt, item, evt.type !== TooltipHideEvent);
  });
}
const listener = (context2, handler) => (evt) => {
  let item = evt.target.__data__;
  item = Array.isArray(item) ? item[0] : item;
  evt.vegaType = evt.type;
  handler.call(context2._obj, evt, item);
};
inherits(SVGHandler, Handler, {
  initialize(el, origin, obj) {
    let svg = this._svg;
    if (svg) {
      svg.removeEventListener(HrefEvent, this._hrefHandler);
      svg.removeEventListener(TooltipShowEvent, this._tooltipHandler);
      svg.removeEventListener(TooltipHideEvent, this._tooltipHandler);
    }
    this._svg = svg = el && domFind(el, "svg");
    if (svg) {
      svg.addEventListener(HrefEvent, this._hrefHandler);
      svg.addEventListener(TooltipShowEvent, this._tooltipHandler);
      svg.addEventListener(TooltipHideEvent, this._tooltipHandler);
    }
    return Handler.prototype.initialize.call(this, el, origin, obj);
  },
  canvas() {
    return this._svg;
  },
  // add an event handler
  on(type2, handler) {
    const name = this.eventName(type2), h2 = this._handlers, i = this._handlerIndex(h2[name], type2, handler);
    if (i < 0) {
      const x2 = {
        type: type2,
        handler,
        listener: listener(this, handler)
      };
      (h2[name] || (h2[name] = [])).push(x2);
      if (this._svg) {
        this._svg.addEventListener(name, x2.listener);
      }
    }
    return this;
  },
  // remove an event handler
  off(type2, handler) {
    const name = this.eventName(type2), h2 = this._handlers[name], i = this._handlerIndex(h2, type2, handler);
    if (i >= 0) {
      if (this._svg) {
        this._svg.removeEventListener(name, h2[i].listener);
      }
      h2.splice(i, 1);
    }
    return this;
  }
});
const ARIA_HIDDEN = "aria-hidden";
const ARIA_LABEL = "aria-label";
const ARIA_ROLE = "role";
const ARIA_ROLEDESCRIPTION = "aria-roledescription";
const GRAPHICS_OBJECT = "graphics-object";
const GRAPHICS_SYMBOL = "graphics-symbol";
const bundle = (role, roledesc, label2) => ({
  [ARIA_ROLE]: role,
  [ARIA_ROLEDESCRIPTION]: roledesc,
  [ARIA_LABEL]: label2 || void 0
});
const AriaIgnore = toSet(["axis-domain", "axis-grid", "axis-label", "axis-tick", "axis-title", "legend-band", "legend-entry", "legend-gradient", "legend-label", "legend-title", "legend-symbol", "title"]);
const AriaGuides = {
  "axis": {
    desc: "axis",
    caption: axisCaption
  },
  "legend": {
    desc: "legend",
    caption: legendCaption
  },
  "title-text": {
    desc: "title",
    caption: (item) => `Title text '${titleCaption(item)}'`
  },
  "title-subtitle": {
    desc: "subtitle",
    caption: (item) => `Subtitle text '${titleCaption(item)}'`
  }
};
const AriaEncode = {
  ariaRole: ARIA_ROLE,
  ariaRoleDescription: ARIA_ROLEDESCRIPTION,
  description: ARIA_LABEL
};
function ariaItemAttributes(emit2, item) {
  const hide = item.aria === false;
  emit2(ARIA_HIDDEN, hide || void 0);
  if (hide || item.description == null) {
    for (const prop in AriaEncode) {
      emit2(AriaEncode[prop], void 0);
    }
  } else {
    const type2 = item.mark.marktype;
    emit2(ARIA_LABEL, item.description);
    emit2(ARIA_ROLE, item.ariaRole || (type2 === "group" ? GRAPHICS_OBJECT : GRAPHICS_SYMBOL));
    emit2(ARIA_ROLEDESCRIPTION, item.ariaRoleDescription || `${type2} mark`);
  }
}
function ariaMarkAttributes(mark) {
  return mark.aria === false ? {
    [ARIA_HIDDEN]: true
  } : AriaIgnore[mark.role] ? null : AriaGuides[mark.role] ? ariaGuide(mark, AriaGuides[mark.role]) : ariaMark(mark);
}
function ariaMark(mark) {
  const type2 = mark.marktype;
  const recurse2 = type2 === "group" || type2 === "text" || mark.items.some((_) => _.description != null && _.aria !== false);
  return bundle(recurse2 ? GRAPHICS_OBJECT : GRAPHICS_SYMBOL, `${type2} mark container`, mark.description);
}
function ariaGuide(mark, opt) {
  try {
    const item = mark.items[0], caption = opt.caption || (() => "");
    return bundle(opt.role || GRAPHICS_SYMBOL, opt.desc, item.description || caption(item));
  } catch (err) {
    return null;
  }
}
function titleCaption(item) {
  return array$3(item.text).join(" ");
}
function axisCaption(item) {
  const datum2 = item.datum, orient = item.orient, title = datum2.title ? extractTitle(item) : null, ctx = item.context, scale2 = ctx.scales[datum2.scale].value, locale2 = ctx.dataflow.locale(), type2 = scale2.type, xy = orient === "left" || orient === "right" ? "Y" : "X";
  return `${xy}-axis` + (title ? ` titled '${title}'` : "") + ` for a ${isDiscrete(type2) ? "discrete" : type2} scale with ${domainCaption(locale2, scale2, item)}`;
}
function legendCaption(item) {
  const datum2 = item.datum, title = datum2.title ? extractTitle(item) : null, type2 = `${datum2.type || ""} legend`.trim(), scales2 = datum2.scales, props = Object.keys(scales2), ctx = item.context, scale2 = ctx.scales[scales2[props[0]]].value, locale2 = ctx.dataflow.locale();
  return capitalize(type2) + (title ? ` titled '${title}'` : "") + ` for ${channelCaption(props)} with ${domainCaption(locale2, scale2, item)}`;
}
function extractTitle(item) {
  try {
    return array$3(peek$2(item.items).items[0].text).join(" ");
  } catch (err) {
    return null;
  }
}
function channelCaption(props) {
  props = props.map((p) => p + (p === "fill" || p === "stroke" ? " color" : ""));
  return props.length < 2 ? props[0] : props.slice(0, -1).join(", ") + " and " + peek$2(props);
}
function capitalize(s) {
  return s.length ? s[0].toUpperCase() + s.slice(1) : s;
}
const innerText = (val) => (val + "").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
const attrText = (val) => innerText(val).replace(/"/g, "&quot;").replace(/\t/g, "&#x9;").replace(/\n/g, "&#xA;").replace(/\r/g, "&#xD;");
function markup() {
  let buf = "", outer = "", inner = "";
  const stack = [], clear = () => outer = inner = "", push = (tag) => {
    if (outer) {
      buf += `${outer}>${inner}`;
      clear();
    }
    stack.push(tag);
  }, attr2 = (name, value2) => {
    if (value2 != null)
      outer += ` ${name}="${attrText(value2)}"`;
    return m2;
  }, m2 = {
    open(tag) {
      push(tag);
      outer = "<" + tag;
      for (var _len = arguments.length, attrs = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        attrs[_key - 1] = arguments[_key];
      }
      for (const set2 of attrs) {
        for (const key2 in set2)
          attr2(key2, set2[key2]);
      }
      return m2;
    },
    close() {
      const tag = stack.pop();
      if (outer) {
        buf += outer + (inner ? `>${inner}</${tag}>` : "/>");
      } else {
        buf += `</${tag}>`;
      }
      clear();
      return m2;
    },
    attr: attr2,
    text: (t) => (inner += innerText(t), m2),
    toString: () => buf
  };
  return m2;
}
const serializeXML = (node) => _serialize(markup(), node) + "";
function _serialize(m2, node) {
  m2.open(node.tagName);
  if (node.hasAttributes()) {
    const attrs = node.attributes, n = attrs.length;
    for (let i = 0; i < n; ++i) {
      m2.attr(attrs[i].name, attrs[i].value);
    }
  }
  if (node.hasChildNodes()) {
    const children2 = node.childNodes;
    for (const child of children2) {
      child.nodeType === 3 ? m2.text(child.nodeValue) : _serialize(m2, child);
    }
  }
  return m2.close();
}
const stylesAttr = {
  fill: "fill",
  fillOpacity: "fill-opacity",
  stroke: "stroke",
  strokeOpacity: "stroke-opacity",
  strokeWidth: "stroke-width",
  strokeCap: "stroke-linecap",
  strokeJoin: "stroke-linejoin",
  strokeDash: "stroke-dasharray",
  strokeDashOffset: "stroke-dashoffset",
  strokeMiterLimit: "stroke-miterlimit",
  opacity: "opacity"
};
const stylesCss = {
  blend: "mix-blend-mode"
};
const rootAttributes = {
  "fill": "none",
  "stroke-miterlimit": 10
};
const RootIndex = 0, xmlns = "http://www.w3.org/2000/xmlns/", svgns = metadata.xmlns;
function SVGRenderer(loader2) {
  Renderer.call(this, loader2);
  this._dirtyID = 0;
  this._dirty = [];
  this._svg = null;
  this._root = null;
  this._defs = null;
}
const base = Renderer.prototype;
inherits(SVGRenderer, Renderer, {
  /**
   * Initialize a new SVGRenderer instance.
   * @param {DOMElement} el - The containing DOM element for the display.
   * @param {number} width - The coordinate width of the display, in pixels.
   * @param {number} height - The coordinate height of the display, in pixels.
   * @param {Array<number>} origin - The origin of the display, in pixels.
   *   The coordinate system will be translated to this point.
   * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
   *   the width and height to determine the final pixel size.
   * @return {SVGRenderer} - This renderer instance.
   */
  initialize(el, width2, height2, origin, scaleFactor) {
    this._defs = {};
    this._clearDefs();
    if (el) {
      this._svg = domChild(el, 0, "svg", svgns);
      this._svg.setAttributeNS(xmlns, "xmlns", svgns);
      this._svg.setAttributeNS(xmlns, "xmlns:xlink", metadata["xmlns:xlink"]);
      this._svg.setAttribute("version", metadata["version"]);
      this._svg.setAttribute("class", "marks");
      domClear(el, 1);
      this._root = domChild(this._svg, RootIndex, "g", svgns);
      setAttributes(this._root, rootAttributes);
      domClear(this._svg, RootIndex + 1);
    }
    this.background(this._bgcolor);
    return base.initialize.call(this, el, width2, height2, origin, scaleFactor);
  },
  /**
   * Get / set the background color.
   */
  background(bgcolor) {
    if (arguments.length && this._svg) {
      this._svg.style.setProperty("background-color", bgcolor);
    }
    return base.background.apply(this, arguments);
  },
  /**
   * Resize the display.
   * @param {number} width - The new coordinate width of the display, in pixels.
   * @param {number} height - The new coordinate height of the display, in pixels.
   * @param {Array<number>} origin - The new origin of the display, in pixels.
   *   The coordinate system will be translated to this point.
   * @param {number} [scaleFactor=1] - Optional scaleFactor by which to multiply
   *   the width and height to determine the final pixel size.
   * @return {SVGRenderer} - This renderer instance;
   */
  resize(width2, height2, origin, scaleFactor) {
    base.resize.call(this, width2, height2, origin, scaleFactor);
    if (this._svg) {
      setAttributes(this._svg, {
        width: this._width * this._scale,
        height: this._height * this._scale,
        viewBox: `0 0 ${this._width} ${this._height}`
      });
      this._root.setAttribute("transform", `translate(${this._origin})`);
    }
    this._dirty = [];
    return this;
  },
  /**
   * Returns the SVG element of the visualization.
   * @return {DOMElement} - The SVG element.
   */
  canvas() {
    return this._svg;
  },
  /**
   * Returns an SVG text string for the rendered content,
   * or null if this renderer is currently headless.
   */
  svg() {
    const svg = this._svg, bg = this._bgcolor;
    if (!svg)
      return null;
    let node;
    if (bg) {
      svg.removeAttribute("style");
      node = domChild(svg, RootIndex, "rect", svgns);
      setAttributes(node, {
        width: this._width,
        height: this._height,
        fill: bg
      });
    }
    const text2 = serializeXML(svg);
    if (bg) {
      svg.removeChild(node);
      this._svg.style.setProperty("background-color", bg);
    }
    return text2;
  },
  /**
   * Internal rendering method.
   * @param {object} scene - The root mark of a scenegraph to render.
   */
  _render(scene) {
    if (this._dirtyCheck()) {
      if (this._dirtyAll)
        this._clearDefs();
      this.mark(this._root, scene);
      domClear(this._root, 1);
    }
    this.defs();
    this._dirty = [];
    ++this._dirtyID;
    return this;
  },
  // -- Manage rendering of items marked as dirty --
  /**
   * Flag a mark item as dirty.
   * @param {Item} item - The mark item.
   */
  dirty(item) {
    if (item.dirty !== this._dirtyID) {
      item.dirty = this._dirtyID;
      this._dirty.push(item);
    }
  },
  /**
   * Check if a mark item is considered dirty.
   * @param {Item} item - The mark item.
   */
  isDirty(item) {
    return this._dirtyAll || !item._svg || !item._svg.ownerSVGElement || item.dirty === this._dirtyID;
  },
  /**
   * Internal method to check dirty status and, if possible,
   * make targetted updates without a full rendering pass.
   */
  _dirtyCheck() {
    this._dirtyAll = true;
    const items = this._dirty;
    if (!items.length || !this._dirtyID)
      return true;
    const id2 = ++this._dirtyID;
    let item, mark, type2, mdef, i, n, o;
    for (i = 0, n = items.length; i < n; ++i) {
      item = items[i];
      mark = item.mark;
      if (mark.marktype !== type2) {
        type2 = mark.marktype;
        mdef = Marks[type2];
      }
      if (mark.zdirty && mark.dirty !== id2) {
        this._dirtyAll = false;
        dirtyParents(item, id2);
        mark.items.forEach((i2) => {
          i2.dirty = id2;
        });
      }
      if (mark.zdirty)
        continue;
      if (item.exit) {
        if (mdef.nested && mark.items.length) {
          o = mark.items[0];
          if (o._svg)
            this._update(mdef, o._svg, o);
        } else if (item._svg) {
          o = item._svg.parentNode;
          if (o)
            o.removeChild(item._svg);
        }
        item._svg = null;
        continue;
      }
      item = mdef.nested ? mark.items[0] : item;
      if (item._update === id2)
        continue;
      if (!item._svg || !item._svg.ownerSVGElement) {
        this._dirtyAll = false;
        dirtyParents(item, id2);
      } else {
        this._update(mdef, item._svg, item);
      }
      item._update = id2;
    }
    return !this._dirtyAll;
  },
  // -- Construct & maintain scenegraph to SVG mapping ---
  /**
   * Render a set of mark items.
   * @param {SVGElement} el - The parent element in the SVG tree.
   * @param {object} scene - The mark parent to render.
   * @param {SVGElement} prev - The previous sibling in the SVG tree.
   */
  mark(el, scene, prev) {
    if (!this.isDirty(scene)) {
      return scene._svg;
    }
    const svg = this._svg, mdef = Marks[scene.marktype], events2 = scene.interactive === false ? "none" : null, isGroup = mdef.tag === "g";
    const parent = bind$1(scene, el, prev, "g", svg);
    parent.setAttribute("class", cssClass(scene));
    const aria = ariaMarkAttributes(scene);
    for (const key2 in aria)
      setAttribute(parent, key2, aria[key2]);
    if (!isGroup) {
      setAttribute(parent, "pointer-events", events2);
    }
    setAttribute(parent, "clip-path", scene.clip ? clip$1(this, scene, scene.group) : null);
    let sibling = null, i = 0;
    const process = (item) => {
      const dirty = this.isDirty(item), node = bind$1(item, parent, sibling, mdef.tag, svg);
      if (dirty) {
        this._update(mdef, node, item);
        if (isGroup)
          recurse(this, node, item);
      }
      sibling = node;
      ++i;
    };
    if (mdef.nested) {
      if (scene.items.length)
        process(scene.items[0]);
    } else {
      visit(scene, process);
    }
    domClear(parent, i);
    return parent;
  },
  /**
   * Update the attributes of an SVG element for a mark item.
   * @param {object} mdef - The mark definition object
   * @param {SVGElement} el - The SVG element.
   * @param {Item} item - The mark item.
   */
  _update(mdef, el, item) {
    element$1 = el;
    values = el.__values__;
    ariaItemAttributes(emit, item);
    mdef.attr(emit, item, this);
    const extra = mark_extras[mdef.type];
    if (extra)
      extra.call(this, mdef, el, item);
    if (element$1)
      this.style(element$1, item);
  },
  /**
   * Update the presentation attributes of an SVG element for a mark item.
   * @param {SVGElement} el - The SVG element.
   * @param {Item} item - The mark item.
   */
  style(el, item) {
    if (item == null)
      return;
    for (const prop in stylesAttr) {
      let value2 = prop === "font" ? fontFamily(item) : item[prop];
      if (value2 === values[prop])
        continue;
      const name = stylesAttr[prop];
      if (value2 == null) {
        el.removeAttribute(name);
      } else {
        if (isGradient(value2)) {
          value2 = gradientRef(value2, this._defs.gradient, href());
        }
        el.setAttribute(name, value2 + "");
      }
      values[prop] = value2;
    }
    for (const prop in stylesCss) {
      setStyle(el, stylesCss[prop], item[prop]);
    }
  },
  /**
   * Render SVG defs, as needed.
   * Must be called *after* marks have been processed to ensure the
   * collected state is current and accurate.
   */
  defs() {
    const svg = this._svg, defs = this._defs;
    let el = defs.el, index2 = 0;
    for (const id2 in defs.gradient) {
      if (!el)
        defs.el = el = domChild(svg, RootIndex + 1, "defs", svgns);
      index2 = updateGradient(el, defs.gradient[id2], index2);
    }
    for (const id2 in defs.clipping) {
      if (!el)
        defs.el = el = domChild(svg, RootIndex + 1, "defs", svgns);
      index2 = updateClipping(el, defs.clipping[id2], index2);
    }
    if (el) {
      index2 === 0 ? (svg.removeChild(el), defs.el = null) : domClear(el, index2);
    }
  },
  /**
   * Clear defs caches.
   */
  _clearDefs() {
    const def2 = this._defs;
    def2.gradient = {};
    def2.clipping = {};
  }
});
function dirtyParents(item, id2) {
  for (; item && item.dirty !== id2; item = item.mark.group) {
    item.dirty = id2;
    if (item.mark && item.mark.dirty !== id2) {
      item.mark.dirty = id2;
    } else
      return;
  }
}
function updateGradient(el, grad, index2) {
  let i, n, stop2;
  if (grad.gradient === "radial") {
    let pt = domChild(el, index2++, "pattern", svgns);
    setAttributes(pt, {
      id: patternPrefix + grad.id,
      viewBox: "0,0,1,1",
      width: "100%",
      height: "100%",
      preserveAspectRatio: "xMidYMid slice"
    });
    pt = domChild(pt, 0, "rect", svgns);
    setAttributes(pt, {
      width: 1,
      height: 1,
      fill: `url(${href()}#${grad.id})`
    });
    el = domChild(el, index2++, "radialGradient", svgns);
    setAttributes(el, {
      id: grad.id,
      fx: grad.x1,
      fy: grad.y1,
      fr: grad.r1,
      cx: grad.x2,
      cy: grad.y2,
      r: grad.r2
    });
  } else {
    el = domChild(el, index2++, "linearGradient", svgns);
    setAttributes(el, {
      id: grad.id,
      x1: grad.x1,
      x2: grad.x2,
      y1: grad.y1,
      y2: grad.y2
    });
  }
  for (i = 0, n = grad.stops.length; i < n; ++i) {
    stop2 = domChild(el, i, "stop", svgns);
    stop2.setAttribute("offset", grad.stops[i].offset);
    stop2.setAttribute("stop-color", grad.stops[i].color);
  }
  domClear(el, i);
  return index2;
}
function updateClipping(el, clip2, index2) {
  let mask;
  el = domChild(el, index2, "clipPath", svgns);
  el.setAttribute("id", clip2.id);
  if (clip2.path) {
    mask = domChild(el, 0, "path", svgns);
    mask.setAttribute("d", clip2.path);
  } else {
    mask = domChild(el, 0, "rect", svgns);
    setAttributes(mask, {
      x: 0,
      y: 0,
      width: clip2.width,
      height: clip2.height
    });
  }
  domClear(el, 1);
  return index2 + 1;
}
function recurse(renderer, el, group2) {
  el = el.lastChild.previousSibling;
  let prev, idx = 0;
  visit(group2, (item) => {
    prev = renderer.mark(el, item, prev);
    ++idx;
  });
  domClear(el, 1 + idx);
}
function bind$1(item, el, sibling, tag, svg) {
  let node = item._svg, doc;
  if (!node) {
    doc = el.ownerDocument;
    node = domCreate(doc, tag, svgns);
    item._svg = node;
    if (item.mark) {
      node.__data__ = item;
      node.__values__ = {
        fill: "default"
      };
      if (tag === "g") {
        const bg = domCreate(doc, "path", svgns);
        node.appendChild(bg);
        bg.__data__ = item;
        const cg = domCreate(doc, "g", svgns);
        node.appendChild(cg);
        cg.__data__ = item;
        const fg = domCreate(doc, "path", svgns);
        node.appendChild(fg);
        fg.__data__ = item;
        fg.__values__ = {
          fill: "default"
        };
      }
    }
  }
  if (node.ownerSVGElement !== svg || siblingCheck(node, sibling)) {
    el.insertBefore(node, sibling ? sibling.nextSibling : el.firstChild);
  }
  return node;
}
function siblingCheck(node, sibling) {
  return node.parentNode && node.parentNode.childNodes.length > 1 && node.previousSibling != sibling;
}
let element$1 = null, values = null;
const mark_extras = {
  group(mdef, el, item) {
    const fg = element$1 = el.childNodes[2];
    values = fg.__values__;
    mdef.foreground(emit, item, this);
    values = el.__values__;
    element$1 = el.childNodes[1];
    mdef.content(emit, item, this);
    const bg = element$1 = el.childNodes[0];
    mdef.background(emit, item, this);
    const value2 = item.mark.interactive === false ? "none" : null;
    if (value2 !== values.events) {
      setAttribute(fg, "pointer-events", value2);
      setAttribute(bg, "pointer-events", value2);
      values.events = value2;
    }
    if (item.strokeForeground && item.stroke) {
      const fill2 = item.fill;
      setAttribute(fg, "display", null);
      this.style(bg, item);
      setAttribute(bg, "stroke", null);
      if (fill2)
        item.fill = null;
      values = fg.__values__;
      this.style(fg, item);
      if (fill2)
        item.fill = fill2;
      element$1 = null;
    } else {
      setAttribute(fg, "display", "none");
    }
  },
  image(mdef, el, item) {
    if (item.smooth === false) {
      setStyle(el, "image-rendering", "optimizeSpeed");
      setStyle(el, "image-rendering", "pixelated");
    } else {
      setStyle(el, "image-rendering", null);
    }
  },
  text(mdef, el, item) {
    const tl2 = textLines(item);
    let key2, value2, doc, lh;
    if (isArray(tl2)) {
      value2 = tl2.map((_) => textValue(item, _));
      key2 = value2.join("\n");
      if (key2 !== values.text) {
        domClear(el, 0);
        doc = el.ownerDocument;
        lh = lineHeight(item);
        value2.forEach((t, i) => {
          const ts2 = domCreate(doc, "tspan", svgns);
          ts2.__data__ = item;
          ts2.textContent = t;
          if (i) {
            ts2.setAttribute("x", 0);
            ts2.setAttribute("dy", lh);
          }
          el.appendChild(ts2);
        });
        values.text = key2;
      }
    } else {
      value2 = textValue(item, tl2);
      if (value2 !== values.text) {
        el.textContent = value2;
        values.text = value2;
      }
    }
    setAttribute(el, "font-family", fontFamily(item));
    setAttribute(el, "font-size", fontSize(item) + "px");
    setAttribute(el, "font-style", item.fontStyle);
    setAttribute(el, "font-variant", item.fontVariant);
    setAttribute(el, "font-weight", item.fontWeight);
  }
};
function emit(name, value2, ns) {
  if (value2 === values[name])
    return;
  if (ns) {
    setAttributeNS(element$1, name, value2, ns);
  } else {
    setAttribute(element$1, name, value2);
  }
  values[name] = value2;
}
function setStyle(el, name, value2) {
  if (value2 !== values[name]) {
    if (value2 == null) {
      el.style.removeProperty(name);
    } else {
      el.style.setProperty(name, value2 + "");
    }
    values[name] = value2;
  }
}
function setAttributes(el, attrs) {
  for (const key2 in attrs) {
    setAttribute(el, key2, attrs[key2]);
  }
}
function setAttribute(el, name, value2) {
  if (value2 != null) {
    el.setAttribute(name, value2);
  } else {
    el.removeAttribute(name);
  }
}
function setAttributeNS(el, name, value2, ns) {
  if (value2 != null) {
    el.setAttributeNS(ns, name, value2);
  } else {
    el.removeAttributeNS(ns, name);
  }
}
function href() {
  let loc;
  return typeof window === "undefined" ? "" : (loc = window.location).hash ? loc.href.slice(0, -loc.hash.length) : loc.href;
}
function SVGStringRenderer(loader2) {
  Renderer.call(this, loader2);
  this._text = null;
  this._defs = {
    gradient: {},
    clipping: {}
  };
}
inherits(SVGStringRenderer, Renderer, {
  /**
   * Returns the rendered SVG text string,
   * or null if rendering has not yet occurred.
   */
  svg() {
    return this._text;
  },
  /**
   * Internal rendering method.
   * @param {object} scene - The root mark of a scenegraph to render.
   */
  _render(scene) {
    const m2 = markup();
    m2.open("svg", extend({}, metadata, {
      class: "marks",
      width: this._width * this._scale,
      height: this._height * this._scale,
      viewBox: `0 0 ${this._width} ${this._height}`
    }));
    const bg = this._bgcolor;
    if (bg && bg !== "transparent" && bg !== "none") {
      m2.open("rect", {
        width: this._width,
        height: this._height,
        fill: bg
      }).close();
    }
    m2.open("g", rootAttributes, {
      transform: "translate(" + this._origin + ")"
    });
    this.mark(m2, scene);
    m2.close();
    this.defs(m2);
    this._text = m2.close() + "";
    return this;
  },
  /**
   * Render a set of mark items.
   * @param {object} m - The markup context.
   * @param {object} scene - The mark parent to render.
   */
  mark(m2, scene) {
    const mdef = Marks[scene.marktype], tag = mdef.tag, attrList = [ariaItemAttributes, mdef.attr];
    m2.open("g", {
      "class": cssClass(scene),
      "clip-path": scene.clip ? clip$1(this, scene, scene.group) : null
    }, ariaMarkAttributes(scene), {
      "pointer-events": tag !== "g" && scene.interactive === false ? "none" : null
    });
    const process = (item) => {
      const href2 = this.href(item);
      if (href2)
        m2.open("a", href2);
      m2.open(tag, this.attr(scene, item, attrList, tag !== "g" ? tag : null));
      if (tag === "text") {
        const tl2 = textLines(item);
        if (isArray(tl2)) {
          const attrs = {
            x: 0,
            dy: lineHeight(item)
          };
          for (let i = 0; i < tl2.length; ++i) {
            m2.open("tspan", i ? attrs : null).text(textValue(item, tl2[i])).close();
          }
        } else {
          m2.text(textValue(item, tl2));
        }
      } else if (tag === "g") {
        const fore = item.strokeForeground, fill2 = item.fill, stroke2 = item.stroke;
        if (fore && stroke2) {
          item.stroke = null;
        }
        m2.open("path", this.attr(scene, item, mdef.background, "bgrect")).close();
        m2.open("g", this.attr(scene, item, mdef.content));
        visit(item, (scene2) => this.mark(m2, scene2));
        m2.close();
        if (fore && stroke2) {
          if (fill2)
            item.fill = null;
          item.stroke = stroke2;
          m2.open("path", this.attr(scene, item, mdef.foreground, "bgrect")).close();
          if (fill2)
            item.fill = fill2;
        } else {
          m2.open("path", this.attr(scene, item, mdef.foreground, "bgfore")).close();
        }
      }
      m2.close();
      if (href2)
        m2.close();
    };
    if (mdef.nested) {
      if (scene.items && scene.items.length)
        process(scene.items[0]);
    } else {
      visit(scene, process);
    }
    return m2.close();
  },
  /**
   * Get href attributes for a hyperlinked mark item.
   * @param {Item} item - The mark item.
   */
  href(item) {
    const href2 = item.href;
    let attr2;
    if (href2) {
      if (attr2 = this._hrefs && this._hrefs[href2]) {
        return attr2;
      } else {
        this.sanitizeURL(href2).then((attr3) => {
          attr3["xlink:href"] = attr3.href;
          attr3.href = null;
          (this._hrefs || (this._hrefs = {}))[href2] = attr3;
        });
      }
    }
    return null;
  },
  /**
   * Get an object of SVG attributes for a mark item.
   * @param {object} scene - The mark parent.
   * @param {Item} item - The mark item.
   * @param {array|function} attrs - One or more attribute emitters.
   * @param {string} tag - The tag being rendered.
   */
  attr(scene, item, attrs, tag) {
    const object2 = {}, emit2 = (name, value2, ns, prefixed) => {
      object2[prefixed || name] = value2;
    };
    if (Array.isArray(attrs)) {
      attrs.forEach((fn) => fn(emit2, item, this));
    } else {
      attrs(emit2, item, this);
    }
    if (tag) {
      style(object2, item, scene, tag, this._defs);
    }
    return object2;
  },
  /**
   * Render SVG defs, as needed.
   * Must be called *after* marks have been processed to ensure the
   * collected state is current and accurate.
   * @param {object} m - The markup context.
   */
  defs(m2) {
    const gradient2 = this._defs.gradient, clipping = this._defs.clipping, count2 = Object.keys(gradient2).length + Object.keys(clipping).length;
    if (count2 === 0)
      return;
    m2.open("defs");
    for (const id2 in gradient2) {
      const def2 = gradient2[id2], stops = def2.stops;
      if (def2.gradient === "radial") {
        m2.open("pattern", {
          id: patternPrefix + id2,
          viewBox: "0,0,1,1",
          width: "100%",
          height: "100%",
          preserveAspectRatio: "xMidYMid slice"
        });
        m2.open("rect", {
          width: "1",
          height: "1",
          fill: "url(#" + id2 + ")"
        }).close();
        m2.close();
        m2.open("radialGradient", {
          id: id2,
          fx: def2.x1,
          fy: def2.y1,
          fr: def2.r1,
          cx: def2.x2,
          cy: def2.y2,
          r: def2.r2
        });
      } else {
        m2.open("linearGradient", {
          id: id2,
          x1: def2.x1,
          x2: def2.x2,
          y1: def2.y1,
          y2: def2.y2
        });
      }
      for (let i = 0; i < stops.length; ++i) {
        m2.open("stop", {
          offset: stops[i].offset,
          "stop-color": stops[i].color
        }).close();
      }
      m2.close();
    }
    for (const id2 in clipping) {
      const def2 = clipping[id2];
      m2.open("clipPath", {
        id: id2
      });
      if (def2.path) {
        m2.open("path", {
          d: def2.path
        }).close();
      } else {
        m2.open("rect", {
          x: 0,
          y: 0,
          width: def2.width,
          height: def2.height
        }).close();
      }
      m2.close();
    }
    m2.close();
  }
});
function style(s, item, scene, tag, defs) {
  let styleList;
  if (item == null)
    return s;
  if (tag === "bgrect" && scene.interactive === false) {
    s["pointer-events"] = "none";
  }
  if (tag === "bgfore") {
    if (scene.interactive === false) {
      s["pointer-events"] = "none";
    }
    s.display = "none";
    if (item.fill !== null)
      return s;
  }
  if (tag === "image" && item.smooth === false) {
    styleList = ["image-rendering: optimizeSpeed;", "image-rendering: pixelated;"];
  }
  if (tag === "text") {
    s["font-family"] = fontFamily(item);
    s["font-size"] = fontSize(item) + "px";
    s["font-style"] = item.fontStyle;
    s["font-variant"] = item.fontVariant;
    s["font-weight"] = item.fontWeight;
  }
  for (const prop in stylesAttr) {
    let value2 = item[prop];
    const name = stylesAttr[prop];
    if (value2 === "transparent" && (name === "fill" || name === "stroke"))
      ;
    else if (value2 != null) {
      if (isGradient(value2)) {
        value2 = gradientRef(value2, defs.gradient, "");
      }
      s[name] = value2;
    }
  }
  for (const prop in stylesCss) {
    const value2 = item[prop];
    if (value2 != null) {
      styleList = styleList || [];
      styleList.push(`${stylesCss[prop]}: ${value2};`);
    }
  }
  if (styleList) {
    s.style = styleList.join(" ");
  }
  return s;
}
const Canvas = "canvas";
const PNG = "png";
const SVG = "svg";
const None$1 = "none";
const RenderType = {
  Canvas,
  PNG,
  SVG,
  None: None$1
};
const modules = {};
modules[Canvas] = modules[PNG] = {
  renderer: CanvasRenderer,
  headless: CanvasRenderer,
  handler: CanvasHandler
};
modules[SVG] = {
  renderer: SVGRenderer,
  headless: SVGStringRenderer,
  handler: SVGHandler
};
modules[None$1] = {};
function renderModule(name, _) {
  name = String(name || "").toLowerCase();
  if (arguments.length > 1) {
    modules[name] = _;
    return this;
  } else {
    return modules[name];
  }
}
function intersect$3(scene, bounds2, filter2) {
  const hits = [], box = new Bounds().union(bounds2), type2 = scene.marktype;
  return type2 ? intersectMark(scene, box, filter2, hits) : type2 === "group" ? intersectGroup(scene, box, filter2, hits) : error("Intersect scene must be mark node or group item.");
}
function intersectMark(mark, box, filter2, hits) {
  if (visitMark(mark, box, filter2)) {
    const items = mark.items, type2 = mark.marktype, n = items.length;
    let i = 0;
    if (type2 === "group") {
      for (; i < n; ++i) {
        intersectGroup(items[i], box, filter2, hits);
      }
    } else {
      for (const test2 = Marks[type2].isect; i < n; ++i) {
        const item = items[i];
        if (intersectItem(item, box, test2))
          hits.push(item);
      }
    }
  }
  return hits;
}
function visitMark(mark, box, filter2) {
  return mark.bounds && box.intersects(mark.bounds) && (mark.marktype === "group" || mark.interactive !== false && (!filter2 || filter2(mark)));
}
function intersectGroup(group2, box, filter2, hits) {
  if (filter2 && filter2(group2.mark) && intersectItem(group2, box, Marks.group.isect)) {
    hits.push(group2);
  }
  const marks = group2.items, n = marks && marks.length;
  if (n) {
    const x2 = group2.x || 0, y2 = group2.y || 0;
    box.translate(-x2, -y2);
    for (let i = 0; i < n; ++i) {
      intersectMark(marks[i], box, filter2, hits);
    }
    box.translate(x2, y2);
  }
  return hits;
}
function intersectItem(item, box, test2) {
  const bounds2 = item.bounds;
  return box.encloses(bounds2) || box.intersects(bounds2) && test2(item, box);
}
const clipBounds = new Bounds();
function boundClip(mark) {
  const clip2 = mark.clip;
  if (isFunction(clip2)) {
    clip2(boundContext(clipBounds.clear()));
  } else if (clip2) {
    clipBounds.set(0, 0, mark.group.width, mark.group.height);
  } else
    return;
  mark.bounds.intersect(clipBounds);
}
const TOLERANCE = 1e-9;
function sceneEqual(a2, b2, key2) {
  return a2 === b2 ? true : key2 === "path" ? pathEqual(a2, b2) : a2 instanceof Date && b2 instanceof Date ? +a2 === +b2 : isNumber$1(a2) && isNumber$1(b2) ? Math.abs(a2 - b2) <= TOLERANCE : !a2 || !b2 || !isObject(a2) && !isObject(b2) ? a2 == b2 : objectEqual(a2, b2);
}
function pathEqual(a2, b2) {
  return sceneEqual(parse$3(a2), parse$3(b2));
}
function objectEqual(a2, b2) {
  var ka = Object.keys(a2), kb = Object.keys(b2), key2, i;
  if (ka.length !== kb.length)
    return false;
  ka.sort();
  kb.sort();
  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] != kb[i])
      return false;
  }
  for (i = ka.length - 1; i >= 0; i--) {
    key2 = ka[i];
    if (!sceneEqual(a2[key2], b2[key2], key2))
      return false;
  }
  return typeof a2 === typeof b2;
}
function resetSVGDefIds() {
  resetSVGClipId();
  resetSVGGradientId();
}
const Top$1 = "top";
const Left$1 = "left";
const Right$1 = "right";
const Bottom$1 = "bottom";
const TopLeft = "top-left";
const TopRight = "top-right";
const BottomLeft = "bottom-left";
const BottomRight = "bottom-right";
const Start$1 = "start";
const Middle$1 = "middle";
const End$1 = "end";
const X = "x";
const Y = "y";
const Group = "group";
const AxisRole$1 = "axis";
const TitleRole$1 = "title";
const FrameRole$1 = "frame";
const ScopeRole$1 = "scope";
const LegendRole$1 = "legend";
const RowHeader = "row-header";
const RowFooter = "row-footer";
const RowTitle = "row-title";
const ColHeader = "column-header";
const ColFooter = "column-footer";
const ColTitle = "column-title";
const Padding$1 = "padding";
const Symbols$1 = "symbol";
const Fit = "fit";
const FitX = "fit-x";
const FitY = "fit-y";
const Pad = "pad";
const None = "none";
const All = "all";
const Each = "each";
const Flush = "flush";
const Column = "column";
const Row = "row";
function Bound$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Bound$1, Transform, {
  transform(_, pulse2) {
    const view = pulse2.dataflow, mark = _.mark, type2 = mark.marktype, entry2 = Marks[type2], bound2 = entry2.bound;
    let markBounds = mark.bounds, rebound;
    if (entry2.nested) {
      if (mark.items.length)
        view.dirty(mark.items[0]);
      markBounds = boundItem(mark, bound2);
      mark.items.forEach((item) => {
        item.bounds.clear().union(markBounds);
      });
    } else if (type2 === Group || _.modified()) {
      pulse2.visit(pulse2.MOD, (item) => view.dirty(item));
      markBounds.clear();
      mark.items.forEach((item) => markBounds.union(boundItem(item, bound2)));
      switch (mark.role) {
        case AxisRole$1:
        case LegendRole$1:
        case TitleRole$1:
          pulse2.reflow();
      }
    } else {
      rebound = pulse2.changed(pulse2.REM);
      pulse2.visit(pulse2.ADD, (item) => {
        markBounds.union(boundItem(item, bound2));
      });
      pulse2.visit(pulse2.MOD, (item) => {
        rebound = rebound || markBounds.alignsWith(item.bounds);
        view.dirty(item);
        markBounds.union(boundItem(item, bound2));
      });
      if (rebound) {
        markBounds.clear();
        mark.items.forEach((item) => markBounds.union(item.bounds));
      }
    }
    boundClip(mark);
    return pulse2.modifies("bounds");
  }
});
function boundItem(item, bound2, opt) {
  return bound2(item.bounds.clear(), item, opt);
}
const COUNTER_NAME = ":vega_identifier:";
function Identifier$2(params2) {
  Transform.call(this, 0, params2);
}
Identifier$2.Definition = {
  "type": "Identifier",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "as",
    "type": "string",
    "required": true
  }]
};
inherits(Identifier$2, Transform, {
  transform(_, pulse2) {
    const counter = getCounter(pulse2.dataflow), as = _.as;
    let id2 = counter.value;
    pulse2.visit(pulse2.ADD, (t) => t[as] = t[as] || ++id2);
    counter.set(this.value = id2);
    return pulse2;
  }
});
function getCounter(view) {
  return view._signals[COUNTER_NAME] || (view._signals[COUNTER_NAME] = view.add(0));
}
function Mark$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Mark$1, Transform, {
  transform(_, pulse2) {
    let mark = this.value;
    if (!mark) {
      mark = pulse2.dataflow.scenegraph().mark(_.markdef, lookup$1$1(_), _.index);
      mark.group.context = _.context;
      if (!_.context.group)
        _.context.group = mark.group;
      mark.source = this.source;
      mark.clip = _.clip;
      mark.interactive = _.interactive;
      this.value = mark;
    }
    const Init = mark.marktype === Group ? GroupItem : Item;
    pulse2.visit(pulse2.ADD, (item) => Init.call(item, mark));
    if (_.modified("clip") || _.modified("interactive")) {
      mark.clip = _.clip;
      mark.interactive = !!_.interactive;
      mark.zdirty = true;
      pulse2.reflow();
    }
    mark.items = pulse2.source;
    return pulse2;
  }
});
function lookup$1$1(_) {
  const g = _.groups, p = _.parent;
  return g && g.size === 1 ? g.get(Object.keys(g.object)[0]) : g && p ? g.lookup(p) : null;
}
function Overlap$1(params2) {
  Transform.call(this, null, params2);
}
const methods = {
  parity: (items) => items.filter((item, i) => i % 2 ? item.opacity = 0 : 1),
  greedy: (items, sep) => {
    let a2;
    return items.filter((b2, i) => !i || !intersect$2(a2.bounds, b2.bounds, sep) ? (a2 = b2, 1) : b2.opacity = 0);
  }
};
const intersect$2 = (a2, b2, sep) => sep > Math.max(b2.x1 - a2.x2, a2.x1 - b2.x2, b2.y1 - a2.y2, a2.y1 - b2.y2);
const hasOverlap = (items, pad2) => {
  for (var i = 1, n = items.length, a2 = items[0].bounds, b2; i < n; a2 = b2, ++i) {
    if (intersect$2(a2, b2 = items[i].bounds, pad2))
      return true;
  }
};
const hasBounds = (item) => {
  const b2 = item.bounds;
  return b2.width() > 1 && b2.height() > 1;
};
const boundTest = (scale2, orient, tolerance) => {
  var range2 = scale2.range(), b2 = new Bounds();
  if (orient === Top$1 || orient === Bottom$1) {
    b2.set(range2[0], -Infinity, range2[1], Infinity);
  } else {
    b2.set(-Infinity, range2[0], Infinity, range2[1]);
  }
  b2.expand(tolerance || 1);
  return (item) => b2.encloses(item.bounds);
};
const reset = (source2) => {
  source2.forEach((item) => item.opacity = 1);
  return source2;
};
const reflow = (pulse2, _) => pulse2.reflow(_.modified()).modifies("opacity");
inherits(Overlap$1, Transform, {
  transform(_, pulse2) {
    const reduce = methods[_.method] || methods.parity, sep = _.separation || 0;
    let source2 = pulse2.materialize(pulse2.SOURCE).source, items, test2;
    if (!source2 || !source2.length)
      return;
    if (!_.method) {
      if (_.modified("method")) {
        reset(source2);
        pulse2 = reflow(pulse2, _);
      }
      return pulse2;
    }
    source2 = source2.filter(hasBounds);
    if (!source2.length)
      return;
    if (_.sort) {
      source2 = source2.slice().sort(_.sort);
    }
    items = reset(source2);
    pulse2 = reflow(pulse2, _);
    if (items.length >= 3 && hasOverlap(items, sep)) {
      do {
        items = reduce(items, sep);
      } while (items.length >= 3 && hasOverlap(items, sep));
      if (items.length < 3 && !peek$2(source2).opacity) {
        if (items.length > 1)
          peek$2(items).opacity = 0;
        peek$2(source2).opacity = 1;
      }
    }
    if (_.boundScale && _.boundTolerance >= 0) {
      test2 = boundTest(_.boundScale, _.boundOrient, +_.boundTolerance);
      source2.forEach((item) => {
        if (!test2(item))
          item.opacity = 0;
      });
    }
    const bounds2 = items[0].mark.bounds.clear();
    source2.forEach((item) => {
      if (item.opacity)
        bounds2.union(item.bounds);
    });
    return pulse2;
  }
});
function Render$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Render$1, Transform, {
  transform(_, pulse2) {
    const view = pulse2.dataflow;
    pulse2.visit(pulse2.ALL, (item) => view.dirty(item));
    if (pulse2.fields && pulse2.fields["zindex"]) {
      const item = pulse2.source && pulse2.source[0];
      if (item)
        item.mark.zdirty = true;
    }
  }
});
const tempBounds = new Bounds();
function set$1(item, property2, value2) {
  return item[property2] === value2 ? 0 : (item[property2] = value2, 1);
}
function isYAxis(mark) {
  var orient = mark.items[0].orient;
  return orient === Left$1 || orient === Right$1;
}
function axisIndices(datum2) {
  let index2 = +datum2.grid;
  return [
    datum2.ticks ? index2++ : -1,
    // ticks index
    datum2.labels ? index2++ : -1,
    // labels index
    index2 + +datum2.domain
    // title index
  ];
}
function axisLayout(view, axis, width2, height2) {
  var item = axis.items[0], datum2 = item.datum, delta = item.translate != null ? item.translate : 0.5, orient = item.orient, indices = axisIndices(datum2), range2 = item.range, offset2 = item.offset, position2 = item.position, minExtent = item.minExtent, maxExtent = item.maxExtent, title = datum2.title && item.items[indices[2]].items[0], titlePadding = item.titlePadding, bounds2 = item.bounds, dl = title && multiLineOffset(title), x2 = 0, y2 = 0, i, s;
  tempBounds.clear().union(bounds2);
  bounds2.clear();
  if ((i = indices[0]) > -1)
    bounds2.union(item.items[i].bounds);
  if ((i = indices[1]) > -1)
    bounds2.union(item.items[i].bounds);
  switch (orient) {
    case Top$1:
      x2 = position2 || 0;
      y2 = -offset2;
      s = Math.max(minExtent, Math.min(maxExtent, -bounds2.y1));
      bounds2.add(0, -s).add(range2, 0);
      if (title)
        axisTitleLayout(view, title, s, titlePadding, dl, 0, -1, bounds2);
      break;
    case Left$1:
      x2 = -offset2;
      y2 = position2 || 0;
      s = Math.max(minExtent, Math.min(maxExtent, -bounds2.x1));
      bounds2.add(-s, 0).add(0, range2);
      if (title)
        axisTitleLayout(view, title, s, titlePadding, dl, 1, -1, bounds2);
      break;
    case Right$1:
      x2 = width2 + offset2;
      y2 = position2 || 0;
      s = Math.max(minExtent, Math.min(maxExtent, bounds2.x2));
      bounds2.add(0, 0).add(s, range2);
      if (title)
        axisTitleLayout(view, title, s, titlePadding, dl, 1, 1, bounds2);
      break;
    case Bottom$1:
      x2 = position2 || 0;
      y2 = height2 + offset2;
      s = Math.max(minExtent, Math.min(maxExtent, bounds2.y2));
      bounds2.add(0, 0).add(range2, s);
      if (title)
        axisTitleLayout(view, title, s, titlePadding, 0, 0, 1, bounds2);
      break;
    default:
      x2 = item.x;
      y2 = item.y;
  }
  boundStroke(bounds2.translate(x2, y2), item);
  if (set$1(item, "x", x2 + delta) | set$1(item, "y", y2 + delta)) {
    item.bounds = tempBounds;
    view.dirty(item);
    item.bounds = bounds2;
    view.dirty(item);
  }
  return item.mark.bounds.clear().union(bounds2);
}
function axisTitleLayout(view, title, offset2, pad2, dl, isYAxis2, sign2, bounds2) {
  const b2 = title.bounds;
  if (title.auto) {
    const v = sign2 * (offset2 + dl + pad2);
    let dx = 0, dy = 0;
    view.dirty(title);
    isYAxis2 ? dx = (title.x || 0) - (title.x = v) : dy = (title.y || 0) - (title.y = v);
    title.mark.bounds.clear().union(b2.translate(-dx, -dy));
    view.dirty(title);
  }
  bounds2.union(b2);
}
const min = (a2, b2) => Math.floor(Math.min(a2, b2));
const max = (a2, b2) => Math.ceil(Math.max(a2, b2));
function gridLayoutGroups(group2) {
  var groups = group2.items, n = groups.length, i = 0, mark, items;
  const views = {
    marks: [],
    rowheaders: [],
    rowfooters: [],
    colheaders: [],
    colfooters: [],
    rowtitle: null,
    coltitle: null
  };
  for (; i < n; ++i) {
    mark = groups[i];
    items = mark.items;
    if (mark.marktype === Group) {
      switch (mark.role) {
        case AxisRole$1:
        case LegendRole$1:
        case TitleRole$1:
          break;
        case RowHeader:
          views.rowheaders.push(...items);
          break;
        case RowFooter:
          views.rowfooters.push(...items);
          break;
        case ColHeader:
          views.colheaders.push(...items);
          break;
        case ColFooter:
          views.colfooters.push(...items);
          break;
        case RowTitle:
          views.rowtitle = items[0];
          break;
        case ColTitle:
          views.coltitle = items[0];
          break;
        default:
          views.marks.push(...items);
      }
    }
  }
  return views;
}
function bboxFlush(item) {
  return new Bounds().set(0, 0, item.width || 0, item.height || 0);
}
function bboxFull(item) {
  const b2 = item.bounds.clone();
  return b2.empty() ? b2.set(0, 0, 0, 0) : b2.translate(-(item.x || 0), -(item.y || 0));
}
function get(opt, key2, d) {
  const v = isObject(opt) ? opt[key2] : opt;
  return v != null ? v : d !== void 0 ? d : 0;
}
function offsetValue$1(v) {
  return v < 0 ? Math.ceil(-v) : 0;
}
function gridLayout(view, groups, opt) {
  var dirty = !opt.nodirty, bbox = opt.bounds === Flush ? bboxFlush : bboxFull, bounds2 = tempBounds.set(0, 0, 0, 0), alignCol = get(opt.align, Column), alignRow = get(opt.align, Row), padCol = get(opt.padding, Column), padRow = get(opt.padding, Row), ncols = opt.columns || groups.length, nrows = ncols <= 0 ? 1 : Math.ceil(groups.length / ncols), n = groups.length, xOffset = Array(n), xExtent = Array(ncols), xMax = 0, yOffset = Array(n), yExtent = Array(nrows), yMax = 0, dx = Array(n), dy = Array(n), boxes = Array(n), m2, i, c2, r, b2, g, px2, py2, x2, y2, offset2;
  for (i = 0; i < ncols; ++i)
    xExtent[i] = 0;
  for (i = 0; i < nrows; ++i)
    yExtent[i] = 0;
  for (i = 0; i < n; ++i) {
    g = groups[i];
    b2 = boxes[i] = bbox(g);
    g.x = g.x || 0;
    dx[i] = 0;
    g.y = g.y || 0;
    dy[i] = 0;
    c2 = i % ncols;
    r = ~~(i / ncols);
    xMax = Math.max(xMax, px2 = Math.ceil(b2.x2));
    yMax = Math.max(yMax, py2 = Math.ceil(b2.y2));
    xExtent[c2] = Math.max(xExtent[c2], px2);
    yExtent[r] = Math.max(yExtent[r], py2);
    xOffset[i] = padCol + offsetValue$1(b2.x1);
    yOffset[i] = padRow + offsetValue$1(b2.y1);
    if (dirty)
      view.dirty(groups[i]);
  }
  for (i = 0; i < n; ++i) {
    if (i % ncols === 0)
      xOffset[i] = 0;
    if (i < ncols)
      yOffset[i] = 0;
  }
  if (alignCol === Each) {
    for (c2 = 1; c2 < ncols; ++c2) {
      for (offset2 = 0, i = c2; i < n; i += ncols) {
        if (offset2 < xOffset[i])
          offset2 = xOffset[i];
      }
      for (i = c2; i < n; i += ncols) {
        xOffset[i] = offset2 + xExtent[c2 - 1];
      }
    }
  } else if (alignCol === All) {
    for (offset2 = 0, i = 0; i < n; ++i) {
      if (i % ncols && offset2 < xOffset[i])
        offset2 = xOffset[i];
    }
    for (i = 0; i < n; ++i) {
      if (i % ncols)
        xOffset[i] = offset2 + xMax;
    }
  } else {
    for (alignCol = false, c2 = 1; c2 < ncols; ++c2) {
      for (i = c2; i < n; i += ncols) {
        xOffset[i] += xExtent[c2 - 1];
      }
    }
  }
  if (alignRow === Each) {
    for (r = 1; r < nrows; ++r) {
      for (offset2 = 0, i = r * ncols, m2 = i + ncols; i < m2; ++i) {
        if (offset2 < yOffset[i])
          offset2 = yOffset[i];
      }
      for (i = r * ncols; i < m2; ++i) {
        yOffset[i] = offset2 + yExtent[r - 1];
      }
    }
  } else if (alignRow === All) {
    for (offset2 = 0, i = ncols; i < n; ++i) {
      if (offset2 < yOffset[i])
        offset2 = yOffset[i];
    }
    for (i = ncols; i < n; ++i) {
      yOffset[i] = offset2 + yMax;
    }
  } else {
    for (alignRow = false, r = 1; r < nrows; ++r) {
      for (i = r * ncols, m2 = i + ncols; i < m2; ++i) {
        yOffset[i] += yExtent[r - 1];
      }
    }
  }
  for (x2 = 0, i = 0; i < n; ++i) {
    x2 = xOffset[i] + (i % ncols ? x2 : 0);
    dx[i] += x2 - groups[i].x;
  }
  for (c2 = 0; c2 < ncols; ++c2) {
    for (y2 = 0, i = c2; i < n; i += ncols) {
      y2 += yOffset[i];
      dy[i] += y2 - groups[i].y;
    }
  }
  if (alignCol && get(opt.center, Column) && nrows > 1) {
    for (i = 0; i < n; ++i) {
      b2 = alignCol === All ? xMax : xExtent[i % ncols];
      x2 = b2 - boxes[i].x2 - groups[i].x - dx[i];
      if (x2 > 0)
        dx[i] += x2 / 2;
    }
  }
  if (alignRow && get(opt.center, Row) && ncols !== 1) {
    for (i = 0; i < n; ++i) {
      b2 = alignRow === All ? yMax : yExtent[~~(i / ncols)];
      y2 = b2 - boxes[i].y2 - groups[i].y - dy[i];
      if (y2 > 0)
        dy[i] += y2 / 2;
    }
  }
  for (i = 0; i < n; ++i) {
    bounds2.union(boxes[i].translate(dx[i], dy[i]));
  }
  x2 = get(opt.anchor, X);
  y2 = get(opt.anchor, Y);
  switch (get(opt.anchor, Column)) {
    case End$1:
      x2 -= bounds2.width();
      break;
    case Middle$1:
      x2 -= bounds2.width() / 2;
  }
  switch (get(opt.anchor, Row)) {
    case End$1:
      y2 -= bounds2.height();
      break;
    case Middle$1:
      y2 -= bounds2.height() / 2;
  }
  x2 = Math.round(x2);
  y2 = Math.round(y2);
  bounds2.clear();
  for (i = 0; i < n; ++i) {
    groups[i].mark.bounds.clear();
  }
  for (i = 0; i < n; ++i) {
    g = groups[i];
    g.x += dx[i] += x2;
    g.y += dy[i] += y2;
    bounds2.union(g.mark.bounds.union(g.bounds.translate(dx[i], dy[i])));
    if (dirty)
      view.dirty(g);
  }
  return bounds2;
}
function trellisLayout(view, group2, opt) {
  var views = gridLayoutGroups(group2), groups = views.marks, bbox = opt.bounds === Flush ? boundFlush : boundFull, off = opt.offset, ncols = opt.columns || groups.length, nrows = ncols <= 0 ? 1 : Math.ceil(groups.length / ncols), cells = nrows * ncols, x2, y2, x22, y22, anchor, band2, offset2;
  const bounds2 = gridLayout(view, groups, opt);
  if (bounds2.empty())
    bounds2.set(0, 0, 0, 0);
  if (views.rowheaders) {
    band2 = get(opt.headerBand, Row, null);
    x2 = layoutHeaders(view, views.rowheaders, groups, ncols, nrows, -get(off, "rowHeader"), min, 0, bbox, "x1", 0, ncols, 1, band2);
  }
  if (views.colheaders) {
    band2 = get(opt.headerBand, Column, null);
    y2 = layoutHeaders(view, views.colheaders, groups, ncols, ncols, -get(off, "columnHeader"), min, 1, bbox, "y1", 0, 1, ncols, band2);
  }
  if (views.rowfooters) {
    band2 = get(opt.footerBand, Row, null);
    x22 = layoutHeaders(view, views.rowfooters, groups, ncols, nrows, get(off, "rowFooter"), max, 0, bbox, "x2", ncols - 1, ncols, 1, band2);
  }
  if (views.colfooters) {
    band2 = get(opt.footerBand, Column, null);
    y22 = layoutHeaders(view, views.colfooters, groups, ncols, ncols, get(off, "columnFooter"), max, 1, bbox, "y2", cells - ncols, 1, ncols, band2);
  }
  if (views.rowtitle) {
    anchor = get(opt.titleAnchor, Row);
    offset2 = get(off, "rowTitle");
    offset2 = anchor === End$1 ? x22 + offset2 : x2 - offset2;
    band2 = get(opt.titleBand, Row, 0.5);
    layoutTitle(view, views.rowtitle, offset2, 0, bounds2, band2);
  }
  if (views.coltitle) {
    anchor = get(opt.titleAnchor, Column);
    offset2 = get(off, "columnTitle");
    offset2 = anchor === End$1 ? y22 + offset2 : y2 - offset2;
    band2 = get(opt.titleBand, Column, 0.5);
    layoutTitle(view, views.coltitle, offset2, 1, bounds2, band2);
  }
}
function boundFlush(item, field2) {
  return field2 === "x1" ? item.x || 0 : field2 === "y1" ? item.y || 0 : field2 === "x2" ? (item.x || 0) + (item.width || 0) : field2 === "y2" ? (item.y || 0) + (item.height || 0) : void 0;
}
function boundFull(item, field2) {
  return item.bounds[field2];
}
function layoutHeaders(view, headers, groups, ncols, limit, offset2, agg, isX2, bound2, bf, start, stride, back, band2) {
  var n = groups.length, init2 = 0, edge = 0, i, j, k, m2, b2, h2, g, x2, y2;
  if (!n)
    return init2;
  for (i = start; i < n; i += stride) {
    if (groups[i])
      init2 = agg(init2, bound2(groups[i], bf));
  }
  if (!headers.length)
    return init2;
  if (headers.length > limit) {
    view.warn("Grid headers exceed limit: " + limit);
    headers = headers.slice(0, limit);
  }
  init2 += offset2;
  for (j = 0, m2 = headers.length; j < m2; ++j) {
    view.dirty(headers[j]);
    headers[j].mark.bounds.clear();
  }
  for (i = start, j = 0, m2 = headers.length; j < m2; ++j, i += stride) {
    h2 = headers[j];
    b2 = h2.mark.bounds;
    for (k = i; k >= 0 && (g = groups[k]) == null; k -= back)
      ;
    if (isX2) {
      x2 = band2 == null ? g.x : Math.round(g.bounds.x1 + band2 * g.bounds.width());
      y2 = init2;
    } else {
      x2 = init2;
      y2 = band2 == null ? g.y : Math.round(g.bounds.y1 + band2 * g.bounds.height());
    }
    b2.union(h2.bounds.translate(x2 - (h2.x || 0), y2 - (h2.y || 0)));
    h2.x = x2;
    h2.y = y2;
    view.dirty(h2);
    edge = agg(edge, b2[bf]);
  }
  return edge;
}
function layoutTitle(view, g, offset2, isX2, bounds2, band2) {
  if (!g)
    return;
  view.dirty(g);
  var x2 = offset2, y2 = offset2;
  isX2 ? x2 = Math.round(bounds2.x1 + band2 * bounds2.width()) : y2 = Math.round(bounds2.y1 + band2 * bounds2.height());
  g.bounds.translate(x2 - (g.x || 0), y2 - (g.y || 0));
  g.mark.bounds.clear().union(g.bounds);
  g.x = x2;
  g.y = y2;
  view.dirty(g);
}
function lookup$3(config, orient) {
  const opt = config[orient] || {};
  return (key2, d) => opt[key2] != null ? opt[key2] : config[key2] != null ? config[key2] : d;
}
function offsets(legends, value2) {
  let max2 = -Infinity;
  legends.forEach((item) => {
    if (item.offset != null)
      max2 = Math.max(max2, item.offset);
  });
  return max2 > -Infinity ? max2 : value2;
}
function legendParams(g, orient, config, xb, yb, w2, h2) {
  const _ = lookup$3(config, orient), offset2 = offsets(g, _("offset", 0)), anchor = _("anchor", Start$1), mult2 = anchor === End$1 ? 1 : anchor === Middle$1 ? 0.5 : 0;
  const p = {
    align: Each,
    bounds: _("bounds", Flush),
    columns: _("direction") === "vertical" ? 1 : g.length,
    padding: _("margin", 8),
    center: _("center"),
    nodirty: true
  };
  switch (orient) {
    case Left$1:
      p.anchor = {
        x: Math.floor(xb.x1) - offset2,
        column: End$1,
        y: mult2 * (h2 || xb.height() + 2 * xb.y1),
        row: anchor
      };
      break;
    case Right$1:
      p.anchor = {
        x: Math.ceil(xb.x2) + offset2,
        y: mult2 * (h2 || xb.height() + 2 * xb.y1),
        row: anchor
      };
      break;
    case Top$1:
      p.anchor = {
        y: Math.floor(yb.y1) - offset2,
        row: End$1,
        x: mult2 * (w2 || yb.width() + 2 * yb.x1),
        column: anchor
      };
      break;
    case Bottom$1:
      p.anchor = {
        y: Math.ceil(yb.y2) + offset2,
        x: mult2 * (w2 || yb.width() + 2 * yb.x1),
        column: anchor
      };
      break;
    case TopLeft:
      p.anchor = {
        x: offset2,
        y: offset2
      };
      break;
    case TopRight:
      p.anchor = {
        x: w2 - offset2,
        y: offset2,
        column: End$1
      };
      break;
    case BottomLeft:
      p.anchor = {
        x: offset2,
        y: h2 - offset2,
        row: End$1
      };
      break;
    case BottomRight:
      p.anchor = {
        x: w2 - offset2,
        y: h2 - offset2,
        column: End$1,
        row: End$1
      };
      break;
  }
  return p;
}
function legendLayout(view, legend) {
  var item = legend.items[0], datum2 = item.datum, orient = item.orient, bounds2 = item.bounds, x2 = item.x, y2 = item.y, w2, h2;
  item._bounds ? item._bounds.clear().union(bounds2) : item._bounds = bounds2.clone();
  bounds2.clear();
  legendGroupLayout(view, item, item.items[0].items[0]);
  bounds2 = legendBounds(item, bounds2);
  w2 = 2 * item.padding;
  h2 = 2 * item.padding;
  if (!bounds2.empty()) {
    w2 = Math.ceil(bounds2.width() + w2);
    h2 = Math.ceil(bounds2.height() + h2);
  }
  if (datum2.type === Symbols$1) {
    legendEntryLayout(item.items[0].items[0].items[0].items);
  }
  if (orient !== None) {
    item.x = x2 = 0;
    item.y = y2 = 0;
  }
  item.width = w2;
  item.height = h2;
  boundStroke(bounds2.set(x2, y2, x2 + w2, y2 + h2), item);
  item.mark.bounds.clear().union(bounds2);
  return item;
}
function legendBounds(item, b2) {
  item.items.forEach((_) => b2.union(_.bounds));
  b2.x1 = item.padding;
  b2.y1 = item.padding;
  return b2;
}
function legendGroupLayout(view, item, entry2) {
  var pad2 = item.padding, ex = pad2 - entry2.x, ey = pad2 - entry2.y;
  if (!item.datum.title) {
    if (ex || ey)
      translate(view, entry2, ex, ey);
  } else {
    var title = item.items[1].items[0], anchor = title.anchor, tpad = item.titlePadding || 0, tx2 = pad2 - title.x, ty = pad2 - title.y;
    switch (title.orient) {
      case Left$1:
        ex += Math.ceil(title.bounds.width()) + tpad;
        break;
      case Right$1:
      case Bottom$1:
        break;
      default:
        ey += title.bounds.height() + tpad;
    }
    if (ex || ey)
      translate(view, entry2, ex, ey);
    switch (title.orient) {
      case Left$1:
        ty += legendTitleOffset(item, entry2, title, anchor, 1, 1);
        break;
      case Right$1:
        tx2 += legendTitleOffset(item, entry2, title, End$1, 0, 0) + tpad;
        ty += legendTitleOffset(item, entry2, title, anchor, 1, 1);
        break;
      case Bottom$1:
        tx2 += legendTitleOffset(item, entry2, title, anchor, 0, 0);
        ty += legendTitleOffset(item, entry2, title, End$1, -1, 0, 1) + tpad;
        break;
      default:
        tx2 += legendTitleOffset(item, entry2, title, anchor, 0, 0);
    }
    if (tx2 || ty)
      translate(view, title, tx2, ty);
    if ((tx2 = Math.round(title.bounds.x1 - pad2)) < 0) {
      translate(view, entry2, -tx2, 0);
      translate(view, title, -tx2, 0);
    }
  }
}
function legendTitleOffset(item, entry2, title, anchor, y2, lr, noBar) {
  const grad = item.datum.type !== "symbol", vgrad = title.datum.vgrad, e = grad && (lr || !vgrad) && !noBar ? entry2.items[0] : entry2, s = e.bounds[y2 ? "y2" : "x2"] - item.padding, u2 = vgrad && lr ? s : 0, v = vgrad && lr ? 0 : s, o = y2 <= 0 ? 0 : multiLineOffset(title);
  return Math.round(anchor === Start$1 ? u2 : anchor === End$1 ? v - o : 0.5 * (s - o));
}
function translate(view, item, dx, dy) {
  item.x += dx;
  item.y += dy;
  item.bounds.translate(dx, dy);
  item.mark.bounds.translate(dx, dy);
  view.dirty(item);
}
function legendEntryLayout(entries) {
  const widths = entries.reduce((w2, g) => {
    w2[g.column] = Math.max(g.bounds.x2 - g.x, w2[g.column] || 0);
    return w2;
  }, {});
  entries.forEach((g) => {
    g.width = widths[g.column];
    g.height = g.bounds.y2 - g.y;
  });
}
function titleLayout(view, mark, width2, height2, viewBounds2) {
  var group2 = mark.items[0], frame2 = group2.frame, orient = group2.orient, anchor = group2.anchor, offset2 = group2.offset, padding2 = group2.padding, title = group2.items[0].items[0], subtitle = group2.items[1] && group2.items[1].items[0], end = orient === Left$1 || orient === Right$1 ? height2 : width2, start = 0, x2 = 0, y2 = 0, sx = 0, sy = 0, pos;
  if (frame2 !== Group) {
    orient === Left$1 ? (start = viewBounds2.y2, end = viewBounds2.y1) : orient === Right$1 ? (start = viewBounds2.y1, end = viewBounds2.y2) : (start = viewBounds2.x1, end = viewBounds2.x2);
  } else if (orient === Left$1) {
    start = height2, end = 0;
  }
  pos = anchor === Start$1 ? start : anchor === End$1 ? end : (start + end) / 2;
  if (subtitle && subtitle.text) {
    switch (orient) {
      case Top$1:
      case Bottom$1:
        sy = title.bounds.height() + padding2;
        break;
      case Left$1:
        sx = title.bounds.width() + padding2;
        break;
      case Right$1:
        sx = -title.bounds.width() - padding2;
        break;
    }
    tempBounds.clear().union(subtitle.bounds);
    tempBounds.translate(sx - (subtitle.x || 0), sy - (subtitle.y || 0));
    if (set$1(subtitle, "x", sx) | set$1(subtitle, "y", sy)) {
      view.dirty(subtitle);
      subtitle.bounds.clear().union(tempBounds);
      subtitle.mark.bounds.clear().union(tempBounds);
      view.dirty(subtitle);
    }
    tempBounds.clear().union(subtitle.bounds);
  } else {
    tempBounds.clear();
  }
  tempBounds.union(title.bounds);
  switch (orient) {
    case Top$1:
      x2 = pos;
      y2 = viewBounds2.y1 - tempBounds.height() - offset2;
      break;
    case Left$1:
      x2 = viewBounds2.x1 - tempBounds.width() - offset2;
      y2 = pos;
      break;
    case Right$1:
      x2 = viewBounds2.x2 + tempBounds.width() + offset2;
      y2 = pos;
      break;
    case Bottom$1:
      x2 = pos;
      y2 = viewBounds2.y2 + offset2;
      break;
    default:
      x2 = group2.x;
      y2 = group2.y;
  }
  if (set$1(group2, "x", x2) | set$1(group2, "y", y2)) {
    tempBounds.translate(x2, y2);
    view.dirty(group2);
    group2.bounds.clear().union(tempBounds);
    mark.bounds.clear().union(tempBounds);
    view.dirty(group2);
  }
  return group2.bounds;
}
function ViewLayout$1(params2) {
  Transform.call(this, null, params2);
}
inherits(ViewLayout$1, Transform, {
  transform(_, pulse2) {
    const view = pulse2.dataflow;
    _.mark.items.forEach((group2) => {
      if (_.layout)
        trellisLayout(view, group2, _.layout);
      layoutGroup(view, group2, _);
    });
    return shouldReflow(_.mark.group) ? pulse2.reflow() : pulse2;
  }
});
function shouldReflow(group2) {
  return group2 && group2.mark.role !== "legend-entry";
}
function layoutGroup(view, group2, _) {
  var items = group2.items, width2 = Math.max(0, group2.width || 0), height2 = Math.max(0, group2.height || 0), viewBounds2 = new Bounds().set(0, 0, width2, height2), xBounds = viewBounds2.clone(), yBounds = viewBounds2.clone(), legends = [], title, mark, orient, b2, i, n;
  for (i = 0, n = items.length; i < n; ++i) {
    mark = items[i];
    switch (mark.role) {
      case AxisRole$1:
        b2 = isYAxis(mark) ? xBounds : yBounds;
        b2.union(axisLayout(view, mark, width2, height2));
        break;
      case TitleRole$1:
        title = mark;
        break;
      case LegendRole$1:
        legends.push(legendLayout(view, mark));
        break;
      case FrameRole$1:
      case ScopeRole$1:
      case RowHeader:
      case RowFooter:
      case RowTitle:
      case ColHeader:
      case ColFooter:
      case ColTitle:
        xBounds.union(mark.bounds);
        yBounds.union(mark.bounds);
        break;
      default:
        viewBounds2.union(mark.bounds);
    }
  }
  if (legends.length) {
    const l = {};
    legends.forEach((item) => {
      orient = item.orient || Right$1;
      if (orient !== None)
        (l[orient] || (l[orient] = [])).push(item);
    });
    for (const orient2 in l) {
      const g = l[orient2];
      gridLayout(view, g, legendParams(g, orient2, _.legends, xBounds, yBounds, width2, height2));
    }
    legends.forEach((item) => {
      const b3 = item.bounds;
      if (!b3.equals(item._bounds)) {
        item.bounds = item._bounds;
        view.dirty(item);
        item.bounds = b3;
        view.dirty(item);
      }
      if (_.autosize && (_.autosize.type === Fit || _.autosize.type === FitX || _.autosize.type === FitY)) {
        switch (item.orient) {
          case Left$1:
          case Right$1:
            viewBounds2.add(b3.x1, 0).add(b3.x2, 0);
            break;
          case Top$1:
          case Bottom$1:
            viewBounds2.add(0, b3.y1).add(0, b3.y2);
        }
      } else {
        viewBounds2.union(b3);
      }
    });
  }
  viewBounds2.union(xBounds).union(yBounds);
  if (title) {
    viewBounds2.union(titleLayout(view, title, width2, height2, viewBounds2));
  }
  if (group2.clip) {
    viewBounds2.set(0, 0, group2.width || 0, group2.height || 0);
  }
  viewSizeLayout(view, group2, viewBounds2, _);
}
function viewSizeLayout(view, group2, viewBounds2, _) {
  const auto = _.autosize || {}, type2 = auto.type;
  if (view._autosize < 1 || !type2)
    return;
  let viewWidth2 = view._width, viewHeight2 = view._height, width2 = Math.max(0, group2.width || 0), left = Math.max(0, Math.ceil(-viewBounds2.x1)), height2 = Math.max(0, group2.height || 0), top = Math.max(0, Math.ceil(-viewBounds2.y1));
  const right = Math.max(0, Math.ceil(viewBounds2.x2 - width2)), bottom = Math.max(0, Math.ceil(viewBounds2.y2 - height2));
  if (auto.contains === Padding$1) {
    const padding2 = view.padding();
    viewWidth2 -= padding2.left + padding2.right;
    viewHeight2 -= padding2.top + padding2.bottom;
  }
  if (type2 === None) {
    left = 0;
    top = 0;
    width2 = viewWidth2;
    height2 = viewHeight2;
  } else if (type2 === Fit) {
    width2 = Math.max(0, viewWidth2 - left - right);
    height2 = Math.max(0, viewHeight2 - top - bottom);
  } else if (type2 === FitX) {
    width2 = Math.max(0, viewWidth2 - left - right);
    viewHeight2 = height2 + top + bottom;
  } else if (type2 === FitY) {
    viewWidth2 = width2 + left + right;
    height2 = Math.max(0, viewHeight2 - top - bottom);
  } else if (type2 === Pad) {
    viewWidth2 = width2 + left + right;
    viewHeight2 = height2 + top + bottom;
  }
  view._resizeView(viewWidth2, viewHeight2, width2, height2, [left, top], auto.resize);
}
const vtx = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  bound: Bound$1,
  identifier: Identifier$2,
  mark: Mark$1,
  overlap: Overlap$1,
  render: Render$1,
  viewlayout: ViewLayout$1
}, Symbol.toStringTag, { value: "Module" }));
function AxisTicks$1(params2) {
  Transform.call(this, null, params2);
}
inherits(AxisTicks$1, Transform, {
  transform(_, pulse2) {
    if (this.value && !_.modified()) {
      return pulse2.StopPropagation;
    }
    var locale2 = pulse2.dataflow.locale(), out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), ticks2 = this.value, scale2 = _.scale, tally = _.count == null ? _.values ? _.values.length : 10 : _.count, count2 = tickCount(scale2, tally, _.minstep), format2 = _.format || tickFormat(locale2, scale2, count2, _.formatSpecifier, _.formatType, !!_.values), values2 = _.values ? validTicks(scale2, _.values, count2) : tickValues(scale2, count2);
    if (ticks2)
      out.rem = ticks2;
    ticks2 = values2.map((value2, i) => ingest$1({
      index: i / (values2.length - 1 || 1),
      value: value2,
      label: format2(value2)
    }));
    if (_.extra && ticks2.length) {
      ticks2.push(ingest$1({
        index: -1,
        extra: {
          value: ticks2[0].value
        },
        label: ""
      }));
    }
    out.source = ticks2;
    out.add = ticks2;
    this.value = ticks2;
    return out;
  }
});
function DataJoin$1(params2) {
  Transform.call(this, null, params2);
}
function defaultItemCreate() {
  return ingest$1({});
}
function newMap(key2) {
  const map2 = fastmap().test((t) => t.exit);
  map2.lookup = (t) => map2.get(key2(t));
  return map2;
}
inherits(DataJoin$1, Transform, {
  transform(_, pulse2) {
    var df = pulse2.dataflow, out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), item = _.item || defaultItemCreate, key2 = _.key || tupleid, map2 = this.value;
    if (isArray(out.encode)) {
      out.encode = null;
    }
    if (map2 && (_.modified("key") || pulse2.modified(key2))) {
      error("DataJoin does not support modified key function or fields.");
    }
    if (!map2) {
      pulse2 = pulse2.addAll();
      this.value = map2 = newMap(key2);
    }
    pulse2.visit(pulse2.ADD, (t) => {
      const k = key2(t);
      let x2 = map2.get(k);
      if (x2) {
        if (x2.exit) {
          map2.empty--;
          out.add.push(x2);
        } else {
          out.mod.push(x2);
        }
      } else {
        x2 = item(t);
        map2.set(k, x2);
        out.add.push(x2);
      }
      x2.datum = t;
      x2.exit = false;
    });
    pulse2.visit(pulse2.MOD, (t) => {
      const k = key2(t), x2 = map2.get(k);
      if (x2) {
        x2.datum = t;
        out.mod.push(x2);
      }
    });
    pulse2.visit(pulse2.REM, (t) => {
      const k = key2(t), x2 = map2.get(k);
      if (t === x2.datum && !x2.exit) {
        out.rem.push(x2);
        x2.exit = true;
        ++map2.empty;
      }
    });
    if (pulse2.changed(pulse2.ADD_MOD))
      out.modifies("datum");
    if (pulse2.clean() || _.clean && map2.empty > df.cleanThreshold) {
      df.runAfter(map2.clean);
    }
    return out;
  }
});
function Encode$1(params2) {
  Transform.call(this, null, params2);
}
inherits(Encode$1, Transform, {
  transform(_, pulse2) {
    var out = pulse2.fork(pulse2.ADD_REM), fmod = _.mod || false, encoders = _.encoders, encode2 = pulse2.encode;
    if (isArray(encode2)) {
      if (out.changed() || encode2.every((e) => encoders[e])) {
        encode2 = encode2[0];
        out.encode = null;
      } else {
        return pulse2.StopPropagation;
      }
    }
    var reenter = encode2 === "enter", update2 = encoders.update || falsy, enter = encoders.enter || falsy, exit = encoders.exit || falsy, set2 = (encode2 && !reenter ? encoders[encode2] : update2) || falsy;
    if (pulse2.changed(pulse2.ADD)) {
      pulse2.visit(pulse2.ADD, (t) => {
        enter(t, _);
        update2(t, _);
      });
      out.modifies(enter.output);
      out.modifies(update2.output);
      if (set2 !== falsy && set2 !== update2) {
        pulse2.visit(pulse2.ADD, (t) => {
          set2(t, _);
        });
        out.modifies(set2.output);
      }
    }
    if (pulse2.changed(pulse2.REM) && exit !== falsy) {
      pulse2.visit(pulse2.REM, (t) => {
        exit(t, _);
      });
      out.modifies(exit.output);
    }
    if (reenter || set2 !== falsy) {
      const flag2 = pulse2.MOD | (_.modified() ? pulse2.REFLOW : 0);
      if (reenter) {
        pulse2.visit(flag2, (t) => {
          const mod = enter(t, _) || fmod;
          if (set2(t, _) || mod)
            out.mod.push(t);
        });
        if (out.mod.length)
          out.modifies(enter.output);
      } else {
        pulse2.visit(flag2, (t) => {
          if (set2(t, _) || fmod)
            out.mod.push(t);
        });
      }
      if (out.mod.length)
        out.modifies(set2.output);
    }
    return out.changed() ? out : pulse2.StopPropagation;
  }
});
function LegendEntries$1(params2) {
  Transform.call(this, [], params2);
}
inherits(LegendEntries$1, Transform, {
  transform(_, pulse2) {
    if (this.value != null && !_.modified()) {
      return pulse2.StopPropagation;
    }
    var locale2 = pulse2.dataflow.locale(), out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), items = this.value, type2 = _.type || SymbolLegend, scale2 = _.scale, limit = +_.limit, count2 = tickCount(scale2, _.count == null ? 5 : _.count, _.minstep), lskip = !!_.values || type2 === SymbolLegend, format2 = _.format || labelFormat(locale2, scale2, count2, type2, _.formatSpecifier, _.formatType, lskip), values2 = _.values || labelValues(scale2, count2), domain2, fraction, size, offset2, ellipsis;
    if (items)
      out.rem = items;
    if (type2 === SymbolLegend) {
      if (limit && values2.length > limit) {
        pulse2.dataflow.warn("Symbol legend count exceeds limit, filtering items.");
        items = values2.slice(0, limit - 1);
        ellipsis = true;
      } else {
        items = values2;
      }
      if (isFunction(size = _.size)) {
        if (!_.values && scale2(items[0]) === 0) {
          items = items.slice(1);
        }
        offset2 = items.reduce((max2, value2) => Math.max(max2, size(value2, _)), 0);
      } else {
        size = constant(offset2 = size || 8);
      }
      items = items.map((value2, index2) => ingest$1({
        index: index2,
        label: format2(value2, index2, items),
        value: value2,
        offset: offset2,
        size: size(value2, _)
      }));
      if (ellipsis) {
        ellipsis = values2[items.length];
        items.push(ingest$1({
          index: items.length,
          label: `…${values2.length - items.length} entries`,
          value: ellipsis,
          offset: offset2,
          size: size(ellipsis, _)
        }));
      }
    } else if (type2 === GradientLegend) {
      domain2 = scale2.domain(), fraction = scaleFraction(scale2, domain2[0], peek$2(domain2));
      if (values2.length < 3 && !_.values && domain2[0] !== peek$2(domain2)) {
        values2 = [domain2[0], peek$2(domain2)];
      }
      items = values2.map((value2, index2) => ingest$1({
        index: index2,
        label: format2(value2, index2, values2),
        value: value2,
        perc: fraction(value2)
      }));
    } else {
      size = values2.length - 1;
      fraction = labelFraction(scale2);
      items = values2.map((value2, index2) => ingest$1({
        index: index2,
        label: format2(value2, index2, values2),
        value: value2,
        perc: index2 ? fraction(value2) : 0,
        perc2: index2 === size ? 1 : fraction(values2[index2 + 1])
      }));
    }
    out.source = items;
    out.add = items;
    this.value = items;
    return out;
  }
});
const sourceX = (t) => t.source.x;
const sourceY = (t) => t.source.y;
const targetX = (t) => t.target.x;
const targetY = (t) => t.target.y;
function LinkPath(params2) {
  Transform.call(this, {}, params2);
}
LinkPath.Definition = {
  "type": "LinkPath",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "sourceX",
    "type": "field",
    "default": "source.x"
  }, {
    "name": "sourceY",
    "type": "field",
    "default": "source.y"
  }, {
    "name": "targetX",
    "type": "field",
    "default": "target.x"
  }, {
    "name": "targetY",
    "type": "field",
    "default": "target.y"
  }, {
    "name": "orient",
    "type": "enum",
    "default": "vertical",
    "values": ["horizontal", "vertical", "radial"]
  }, {
    "name": "shape",
    "type": "enum",
    "default": "line",
    "values": ["line", "arc", "curve", "diagonal", "orthogonal"]
  }, {
    "name": "require",
    "type": "signal"
  }, {
    "name": "as",
    "type": "string",
    "default": "path"
  }]
};
inherits(LinkPath, Transform, {
  transform(_, pulse2) {
    var sx = _.sourceX || sourceX, sy = _.sourceY || sourceY, tx2 = _.targetX || targetX, ty = _.targetY || targetY, as = _.as || "path", orient = _.orient || "vertical", shape2 = _.shape || "line", path2 = Paths.get(shape2 + "-" + orient) || Paths.get(shape2);
    if (!path2) {
      error("LinkPath unsupported type: " + _.shape + (_.orient ? "-" + _.orient : ""));
    }
    pulse2.visit(pulse2.SOURCE, (t) => {
      t[as] = path2(sx(t), sy(t), tx2(t), ty(t));
    });
    return pulse2.reflow(_.modified()).modifies(as);
  }
});
const line = (sx, sy, tx2, ty) => "M" + sx + "," + sy + "L" + tx2 + "," + ty;
const lineR = (sa2, sr, ta, tr2) => line(sr * Math.cos(sa2), sr * Math.sin(sa2), tr2 * Math.cos(ta), tr2 * Math.sin(ta));
const arc = (sx, sy, tx2, ty) => {
  var dx = tx2 - sx, dy = ty - sy, rr = Math.hypot(dx, dy) / 2, ra = 180 * Math.atan2(dy, dx) / Math.PI;
  return "M" + sx + "," + sy + "A" + rr + "," + rr + " " + ra + " 0 1 " + tx2 + "," + ty;
};
const arcR = (sa2, sr, ta, tr2) => arc(sr * Math.cos(sa2), sr * Math.sin(sa2), tr2 * Math.cos(ta), tr2 * Math.sin(ta));
const curve = (sx, sy, tx2, ty) => {
  const dx = tx2 - sx, dy = ty - sy, ix = 0.2 * (dx + dy), iy = 0.2 * (dy - dx);
  return "M" + sx + "," + sy + "C" + (sx + ix) + "," + (sy + iy) + " " + (tx2 + iy) + "," + (ty - ix) + " " + tx2 + "," + ty;
};
const curveR = (sa2, sr, ta, tr2) => curve(sr * Math.cos(sa2), sr * Math.sin(sa2), tr2 * Math.cos(ta), tr2 * Math.sin(ta));
const orthoX = (sx, sy, tx2, ty) => "M" + sx + "," + sy + "V" + ty + "H" + tx2;
const orthoY = (sx, sy, tx2, ty) => "M" + sx + "," + sy + "H" + tx2 + "V" + ty;
const orthoR = (sa2, sr, ta, tr2) => {
  const sc = Math.cos(sa2), ss = Math.sin(sa2), tc = Math.cos(ta), ts2 = Math.sin(ta), sf = Math.abs(ta - sa2) > Math.PI ? ta <= sa2 : ta > sa2;
  return "M" + sr * sc + "," + sr * ss + "A" + sr + "," + sr + " 0 0," + (sf ? 1 : 0) + " " + sr * tc + "," + sr * ts2 + "L" + tr2 * tc + "," + tr2 * ts2;
};
const diagonalX = (sx, sy, tx2, ty) => {
  const m2 = (sx + tx2) / 2;
  return "M" + sx + "," + sy + "C" + m2 + "," + sy + " " + m2 + "," + ty + " " + tx2 + "," + ty;
};
const diagonalY = (sx, sy, tx2, ty) => {
  const m2 = (sy + ty) / 2;
  return "M" + sx + "," + sy + "C" + sx + "," + m2 + " " + tx2 + "," + m2 + " " + tx2 + "," + ty;
};
const diagonalR = (sa2, sr, ta, tr2) => {
  const sc = Math.cos(sa2), ss = Math.sin(sa2), tc = Math.cos(ta), ts2 = Math.sin(ta), mr = (sr + tr2) / 2;
  return "M" + sr * sc + "," + sr * ss + "C" + mr * sc + "," + mr * ss + " " + mr * tc + "," + mr * ts2 + " " + tr2 * tc + "," + tr2 * ts2;
};
const Paths = fastmap({
  "line": line,
  "line-radial": lineR,
  "arc": arc,
  "arc-radial": arcR,
  "curve": curve,
  "curve-radial": curveR,
  "orthogonal-horizontal": orthoX,
  "orthogonal-vertical": orthoY,
  "orthogonal-radial": orthoR,
  "diagonal-horizontal": diagonalX,
  "diagonal-vertical": diagonalY,
  "diagonal-radial": diagonalR
});
function Pie(params2) {
  Transform.call(this, null, params2);
}
Pie.Definition = {
  "type": "Pie",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "startAngle",
    "type": "number",
    "default": 0
  }, {
    "name": "endAngle",
    "type": "number",
    "default": 6.283185307179586
  }, {
    "name": "sort",
    "type": "boolean",
    "default": false
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["startAngle", "endAngle"]
  }]
};
inherits(Pie, Transform, {
  transform(_, pulse2) {
    var as = _.as || ["startAngle", "endAngle"], startAngle = as[0], endAngle = as[1], field2 = _.field || one$1, start = _.startAngle || 0, stop2 = _.endAngle != null ? _.endAngle : 2 * Math.PI, data2 = pulse2.source, values2 = data2.map(field2), n = values2.length, a2 = start, k = (stop2 - start) / sum$1(values2), index2 = range$4(n), i, t, v;
    if (_.sort) {
      index2.sort((a3, b2) => values2[a3] - values2[b2]);
    }
    for (i = 0; i < n; ++i) {
      v = values2[index2[i]];
      t = data2[index2[i]];
      t[startAngle] = a2;
      t[endAngle] = a2 += v * k;
    }
    this.value = values2;
    return pulse2.reflow(_.modified()).modifies(as);
  }
});
const DEFAULT_COUNT = 5;
function includeZero(scale2) {
  const type2 = scale2.type;
  return !scale2.bins && (type2 === Linear || type2 === Pow || type2 === Sqrt);
}
function includePad(type2) {
  return isContinuous(type2) && type2 !== Sequential;
}
const SKIP$1 = toSet(["set", "modified", "clear", "type", "scheme", "schemeExtent", "schemeCount", "domain", "domainMin", "domainMid", "domainMax", "domainRaw", "domainImplicit", "nice", "zero", "bins", "range", "rangeStep", "round", "reverse", "interpolate", "interpolateGamma"]);
function Scale$1(params2) {
  Transform.call(this, null, params2);
  this.modified(true);
}
inherits(Scale$1, Transform, {
  transform(_, pulse2) {
    var df = pulse2.dataflow, scale$12 = this.value, key2 = scaleKey(_);
    if (!scale$12 || key2 !== scale$12.type) {
      this.value = scale$12 = scale$5(key2)();
    }
    for (key2 in _)
      if (!SKIP$1[key2]) {
        if (key2 === "padding" && includePad(scale$12.type))
          continue;
        isFunction(scale$12[key2]) ? scale$12[key2](_[key2]) : df.warn("Unsupported scale property: " + key2);
      }
    configureRange(scale$12, _, configureBins(scale$12, _, configureDomain(scale$12, _, df)));
    return pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
  }
});
function scaleKey(_) {
  var t = _.type, d = "", n;
  if (t === Sequential)
    return Sequential + "-" + Linear;
  if (isContinuousColor(_)) {
    n = _.rawDomain ? _.rawDomain.length : _.domain ? _.domain.length + +(_.domainMid != null) : 0;
    d = n === 2 ? Sequential + "-" : n === 3 ? Diverging + "-" : "";
  }
  return (d + t || Linear).toLowerCase();
}
function isContinuousColor(_) {
  const t = _.type;
  return isContinuous(t) && t !== Time && t !== UTC && (_.scheme || _.range && _.range.length && _.range.every(isString));
}
function configureDomain(scale2, _, df) {
  const raw = rawDomain(scale2, _.domainRaw, df);
  if (raw > -1)
    return raw;
  var domain2 = _.domain, type2 = scale2.type, zero2 = _.zero || _.zero === void 0 && includeZero(scale2), n, mid;
  if (!domain2)
    return 0;
  if (includePad(type2) && _.padding && domain2[0] !== peek$2(domain2)) {
    domain2 = padDomain(type2, domain2, _.range, _.padding, _.exponent, _.constant);
  }
  if (zero2 || _.domainMin != null || _.domainMax != null || _.domainMid != null) {
    n = (domain2 = domain2.slice()).length - 1 || 1;
    if (zero2) {
      if (domain2[0] > 0)
        domain2[0] = 0;
      if (domain2[n] < 0)
        domain2[n] = 0;
    }
    if (_.domainMin != null)
      domain2[0] = _.domainMin;
    if (_.domainMax != null)
      domain2[n] = _.domainMax;
    if (_.domainMid != null) {
      mid = _.domainMid;
      const i = mid > domain2[n] ? n + 1 : mid < domain2[0] ? 0 : n;
      if (i !== n)
        df.warn("Scale domainMid exceeds domain min or max.", mid);
      domain2.splice(i, 0, mid);
    }
  }
  scale2.domain(domainCheck(type2, domain2, df));
  if (type2 === Ordinal) {
    scale2.unknown(_.domainImplicit ? implicit : void 0);
  }
  if (_.nice && scale2.nice) {
    scale2.nice(_.nice !== true && tickCount(scale2, _.nice) || null);
  }
  return domain2.length;
}
function rawDomain(scale2, raw, df) {
  if (raw) {
    scale2.domain(domainCheck(scale2.type, raw, df));
    return raw.length;
  } else {
    return -1;
  }
}
function padDomain(type2, domain2, range2, pad2, exponent2, constant2) {
  var span2 = Math.abs(peek$2(range2) - range2[0]), frac = span2 / (span2 - 2 * pad2), d = type2 === Log ? zoomLog(domain2, null, frac) : type2 === Sqrt ? zoomPow(domain2, null, frac, 0.5) : type2 === Pow ? zoomPow(domain2, null, frac, exponent2 || 1) : type2 === Symlog ? zoomSymlog(domain2, null, frac, constant2 || 1) : zoomLinear(domain2, null, frac);
  domain2 = domain2.slice();
  domain2[0] = d[0];
  domain2[domain2.length - 1] = d[1];
  return domain2;
}
function domainCheck(type2, domain2, df) {
  if (isLogarithmic(type2)) {
    var s = Math.abs(domain2.reduce((s2, v) => s2 + (v < 0 ? -1 : v > 0 ? 1 : 0), 0));
    if (s !== domain2.length) {
      df.warn("Log scale domain includes zero: " + $(domain2));
    }
  }
  return domain2;
}
function configureBins(scale2, _, count2) {
  let bins = _.bins;
  if (bins && !isArray(bins)) {
    const domain2 = scale2.domain(), lo = domain2[0], hi = peek$2(domain2), step = bins.step;
    let start = bins.start == null ? lo : bins.start, stop2 = bins.stop == null ? hi : bins.stop;
    if (!step)
      error("Scale bins parameter missing step property.");
    if (start < lo)
      start = step * Math.ceil(lo / step);
    if (stop2 > hi)
      stop2 = step * Math.floor(hi / step);
    bins = range$4(start, stop2 + step / 2, step);
  }
  if (bins) {
    scale2.bins = bins;
  } else if (scale2.bins) {
    delete scale2.bins;
  }
  if (scale2.type === BinOrdinal) {
    if (!bins) {
      scale2.bins = scale2.domain();
    } else if (!_.domain && !_.domainRaw) {
      scale2.domain(bins);
      count2 = bins.length;
    }
  }
  return count2;
}
function configureRange(scale2, _, count2) {
  var type2 = scale2.type, round = _.round || false, range2 = _.range;
  if (_.rangeStep != null) {
    range2 = configureRangeStep(type2, _, count2);
  } else if (_.scheme) {
    range2 = configureScheme(type2, _, count2);
    if (isFunction(range2)) {
      if (scale2.interpolator) {
        return scale2.interpolator(range2);
      } else {
        error(`Scale type ${type2} does not support interpolating color schemes.`);
      }
    }
  }
  if (range2 && isInterpolating(type2)) {
    return scale2.interpolator(interpolateColors(flip(range2, _.reverse), _.interpolate, _.interpolateGamma));
  }
  if (range2 && _.interpolate && scale2.interpolate) {
    scale2.interpolate(interpolate(_.interpolate, _.interpolateGamma));
  } else if (isFunction(scale2.round)) {
    scale2.round(round);
  } else if (isFunction(scale2.rangeRound)) {
    scale2.interpolate(round ? interpolateRound : interpolate$1);
  }
  if (range2)
    scale2.range(flip(range2, _.reverse));
}
function configureRangeStep(type2, _, count2) {
  if (type2 !== Band && type2 !== Point) {
    error("Only band and point scales support rangeStep.");
  }
  var outer = (_.paddingOuter != null ? _.paddingOuter : _.padding) || 0, inner = type2 === Point ? 1 : (_.paddingInner != null ? _.paddingInner : _.padding) || 0;
  return [0, _.rangeStep * bandSpace(count2, inner, outer)];
}
function configureScheme(type2, _, count2) {
  var extent2 = _.schemeExtent, name, scheme$1;
  if (isArray(_.scheme)) {
    scheme$1 = interpolateColors(_.scheme, _.interpolate, _.interpolateGamma);
  } else {
    name = _.scheme.toLowerCase();
    scheme$1 = scheme(name);
    if (!scheme$1)
      error(`Unrecognized scheme name: ${_.scheme}`);
  }
  count2 = type2 === Threshold ? count2 + 1 : type2 === BinOrdinal ? count2 - 1 : type2 === Quantile || type2 === Quantize ? +_.schemeCount || DEFAULT_COUNT : count2;
  return isInterpolating(type2) ? adjustScheme(scheme$1, extent2, _.reverse) : isFunction(scheme$1) ? quantizeInterpolator(adjustScheme(scheme$1, extent2), count2) : type2 === Ordinal ? scheme$1 : scheme$1.slice(0, count2);
}
function adjustScheme(scheme2, extent2, reverse2) {
  return isFunction(scheme2) && (extent2 || reverse2) ? interpolateRange(scheme2, flip(extent2 || [0, 1], reverse2)) : scheme2;
}
function flip(array2, reverse2) {
  return reverse2 ? array2.slice().reverse() : array2;
}
function SortItems$1(params2) {
  Transform.call(this, null, params2);
}
inherits(SortItems$1, Transform, {
  transform(_, pulse2) {
    const mod = _.modified("sort") || pulse2.changed(pulse2.ADD) || pulse2.modified(_.sort.fields) || pulse2.modified("datum");
    if (mod)
      pulse2.source.sort(stableCompare(_.sort));
    this.modified(mod);
    return pulse2;
  }
});
const Zero = "zero", Center$1 = "center", Normalize = "normalize", DefOutput = ["y0", "y1"];
function Stack(params2) {
  Transform.call(this, null, params2);
}
Stack.Definition = {
  "type": "Stack",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "sort",
    "type": "compare"
  }, {
    "name": "offset",
    "type": "enum",
    "default": Zero,
    "values": [Zero, Center$1, Normalize]
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": DefOutput
  }]
};
inherits(Stack, Transform, {
  transform(_, pulse2) {
    var as = _.as || DefOutput, y02 = as[0], y12 = as[1], sort2 = stableCompare(_.sort), field2 = _.field || one$1, stack = _.offset === Center$1 ? stackCenter : _.offset === Normalize ? stackNormalize : stackZero, groups, i, n, max2;
    groups = partition$2(pulse2.source, _.groupby, sort2, field2);
    for (i = 0, n = groups.length, max2 = groups.max; i < n; ++i) {
      stack(groups[i], max2, field2, y02, y12);
    }
    return pulse2.reflow(_.modified()).modifies(as);
  }
});
function stackCenter(group2, max2, field2, y02, y12) {
  var last = (max2 - group2.sum) / 2, m2 = group2.length, j = 0, t;
  for (; j < m2; ++j) {
    t = group2[j];
    t[y02] = last;
    t[y12] = last += Math.abs(field2(t));
  }
}
function stackNormalize(group2, max2, field2, y02, y12) {
  var scale2 = 1 / group2.sum, last = 0, m2 = group2.length, j = 0, v = 0, t;
  for (; j < m2; ++j) {
    t = group2[j];
    t[y02] = last;
    t[y12] = last = scale2 * (v += Math.abs(field2(t)));
  }
}
function stackZero(group2, max2, field2, y02, y12) {
  var lastPos = 0, lastNeg = 0, m2 = group2.length, j = 0, v, t;
  for (; j < m2; ++j) {
    t = group2[j];
    v = +field2(t);
    if (v < 0) {
      t[y02] = lastNeg;
      t[y12] = lastNeg += v;
    } else {
      t[y02] = lastPos;
      t[y12] = lastPos += v;
    }
  }
}
function partition$2(data2, groupby, sort2, field2) {
  var groups = [], get2 = (f) => f(t), map2, i, n, m2, t, k, g, s, max2;
  if (groupby == null) {
    groups.push(data2.slice());
  } else {
    for (map2 = {}, i = 0, n = data2.length; i < n; ++i) {
      t = data2[i];
      k = groupby.map(get2);
      g = map2[k];
      if (!g) {
        map2[k] = g = [];
        groups.push(g);
      }
      g.push(t);
    }
  }
  for (k = 0, max2 = 0, m2 = groups.length; k < m2; ++k) {
    g = groups[k];
    for (i = 0, s = 0, n = g.length; i < n; ++i) {
      s += Math.abs(field2(g[i]));
    }
    g.sum = s;
    if (s > max2)
      max2 = s;
    if (sort2)
      g.sort(sort2);
  }
  groups.max = max2;
  return groups;
}
const encode$2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  axisticks: AxisTicks$1,
  datajoin: DataJoin$1,
  encode: Encode$1,
  legendentries: LegendEntries$1,
  linkpath: LinkPath,
  pie: Pie,
  scale: Scale$1,
  sortitems: SortItems$1,
  stack: Stack
}, Symbol.toStringTag, { value: "Module" }));
var abs = Math.abs;
var cos = Math.cos;
var sin = Math.sin;
var epsilon = 1e-6;
var pi = Math.PI;
var halfPi = pi / 2;
var sqrt2 = sqrt(2);
function asin(x2) {
  return x2 > 1 ? halfPi : x2 < -1 ? -halfPi : Math.asin(x2);
}
function sqrt(x2) {
  return Math.sqrt(x2) ;
}
function mollweideBromleyTheta(cp, phi2) {
  var cpsinPhi = cp * sin(phi2), i = 30, delta;
  do
    phi2 -= delta = (phi2 + sin(phi2) - cpsinPhi) / (1 + cos(phi2));
  while (abs(delta) > epsilon && --i > 0);
  return phi2 / 2;
}
function mollweideBromleyRaw(cx, cy, cp) {
  function forward(lambda, phi2) {
    return [cx * lambda * cos(phi2 = mollweideBromleyTheta(cp, phi2)), cy * sin(phi2)];
  }
  forward.invert = function(x2, y2) {
    return y2 = asin(y2 / cy), [x2 / (cx * cos(y2)), asin((2 * y2 + sin(2 * y2)) / cp)];
  };
  return forward;
}
var mollweideRaw = mollweideBromleyRaw(sqrt2 / halfPi, sqrt2, pi);
function geoMollweide() {
  return projection$1(mollweideRaw).scale(169.529);
}
const defaultPath = geoPath();
const projectionProperties = [
  // standard properties in d3-geo
  "clipAngle",
  "clipExtent",
  "scale",
  "translate",
  "center",
  "rotate",
  "parallels",
  "precision",
  "reflectX",
  "reflectY",
  // extended properties in d3-geo-projections
  "coefficient",
  "distance",
  "fraction",
  "lobes",
  "parallel",
  "radius",
  "ratio",
  "spacing",
  "tilt"
];
function create$1(type2, constructor) {
  return function projection2() {
    const p = constructor();
    p.type = type2;
    p.path = geoPath().projection(p);
    p.copy = p.copy || function() {
      const c2 = projection2();
      projectionProperties.forEach((prop) => {
        if (p[prop])
          c2[prop](p[prop]());
      });
      c2.path.pointRadius(p.path.pointRadius());
      return c2;
    };
    return registerScale(p);
  };
}
function projection(type2, proj) {
  if (!type2 || typeof type2 !== "string") {
    throw new Error("Projection type must be a name string.");
  }
  type2 = type2.toLowerCase();
  if (arguments.length > 1) {
    projections[type2] = create$1(type2, proj);
    return this;
  } else {
    return projections[type2] || null;
  }
}
function getProjectionPath(proj) {
  return proj && proj.path || defaultPath;
}
const projections = {
  // base d3-geo projection types
  albers: geoAlbers,
  albersusa: geoAlbersUsa,
  azimuthalequalarea: geoAzimuthalEqualArea,
  azimuthalequidistant: geoAzimuthalEquidistant,
  conicconformal: geoConicConformal,
  conicequalarea: geoConicEqualArea,
  conicequidistant: geoConicEquidistant,
  equalEarth: geoEqualEarth,
  equirectangular: geoEquirectangular,
  gnomonic: geoGnomonic,
  identity: geoIdentity,
  mercator: geoMercator,
  mollweide: geoMollweide,
  naturalEarth1: geoNaturalEarth1,
  orthographic: geoOrthographic,
  stereographic: geoStereographic,
  transversemercator: geoTransverseMercator
};
for (const key2 in projections) {
  projection(key2, projections[key2]);
}
function noop() {
}
const cases = [[], [[[1, 1.5], [0.5, 1]]], [[[1.5, 1], [1, 1.5]]], [[[1.5, 1], [0.5, 1]]], [[[1, 0.5], [1.5, 1]]], [[[1, 1.5], [0.5, 1]], [[1, 0.5], [1.5, 1]]], [[[1, 0.5], [1, 1.5]]], [[[1, 0.5], [0.5, 1]]], [[[0.5, 1], [1, 0.5]]], [[[1, 1.5], [1, 0.5]]], [[[0.5, 1], [1, 0.5]], [[1.5, 1], [1, 1.5]]], [[[1.5, 1], [1, 0.5]]], [[[0.5, 1], [1.5, 1]]], [[[1, 1.5], [1.5, 1]]], [[[0.5, 1], [1, 1.5]]], []];
function contours() {
  var dx = 1, dy = 1, smooth = smoothLinear;
  function contours2(values2, tz) {
    return tz.map((value2) => contour(values2, value2));
  }
  function contour(values2, value2) {
    var polygons = [], holes = [];
    isorings(values2, value2, (ring) => {
      smooth(ring, values2, value2);
      if (area(ring) > 0)
        polygons.push([ring]);
      else
        holes.push(ring);
    });
    holes.forEach((hole) => {
      for (var i = 0, n = polygons.length, polygon; i < n; ++i) {
        if (contains((polygon = polygons[i])[0], hole) !== -1) {
          polygon.push(hole);
          return;
        }
      }
    });
    return {
      type: "MultiPolygon",
      value: value2,
      coordinates: polygons
    };
  }
  function isorings(values2, value2, callback) {
    var fragmentByStart = new Array(), fragmentByEnd = new Array(), x2, y2, t02, t12, t22, t32;
    x2 = y2 = -1;
    t12 = values2[0] >= value2;
    cases[t12 << 1].forEach(stitch2);
    while (++x2 < dx - 1) {
      t02 = t12, t12 = values2[x2 + 1] >= value2;
      cases[t02 | t12 << 1].forEach(stitch2);
    }
    cases[t12 << 0].forEach(stitch2);
    while (++y2 < dy - 1) {
      x2 = -1;
      t12 = values2[y2 * dx + dx] >= value2;
      t22 = values2[y2 * dx] >= value2;
      cases[t12 << 1 | t22 << 2].forEach(stitch2);
      while (++x2 < dx - 1) {
        t02 = t12, t12 = values2[y2 * dx + dx + x2 + 1] >= value2;
        t32 = t22, t22 = values2[y2 * dx + x2 + 1] >= value2;
        cases[t02 | t12 << 1 | t22 << 2 | t32 << 3].forEach(stitch2);
      }
      cases[t12 | t22 << 3].forEach(stitch2);
    }
    x2 = -1;
    t22 = values2[y2 * dx] >= value2;
    cases[t22 << 2].forEach(stitch2);
    while (++x2 < dx - 1) {
      t32 = t22, t22 = values2[y2 * dx + x2 + 1] >= value2;
      cases[t22 << 2 | t32 << 3].forEach(stitch2);
    }
    cases[t22 << 3].forEach(stitch2);
    function stitch2(line2) {
      var start = [line2[0][0] + x2, line2[0][1] + y2], end = [line2[1][0] + x2, line2[1][1] + y2], startIndex = index2(start), endIndex = index2(end), f, g;
      if (f = fragmentByEnd[startIndex]) {
        if (g = fragmentByStart[endIndex]) {
          delete fragmentByEnd[f.end];
          delete fragmentByStart[g.start];
          if (f === g) {
            f.ring.push(end);
            callback(f.ring);
          } else {
            fragmentByStart[f.start] = fragmentByEnd[g.end] = {
              start: f.start,
              end: g.end,
              ring: f.ring.concat(g.ring)
            };
          }
        } else {
          delete fragmentByEnd[f.end];
          f.ring.push(end);
          fragmentByEnd[f.end = endIndex] = f;
        }
      } else if (f = fragmentByStart[endIndex]) {
        if (g = fragmentByEnd[startIndex]) {
          delete fragmentByStart[f.start];
          delete fragmentByEnd[g.end];
          if (f === g) {
            f.ring.push(end);
            callback(f.ring);
          } else {
            fragmentByStart[g.start] = fragmentByEnd[f.end] = {
              start: g.start,
              end: f.end,
              ring: g.ring.concat(f.ring)
            };
          }
        } else {
          delete fragmentByStart[f.start];
          f.ring.unshift(start);
          fragmentByStart[f.start = startIndex] = f;
        }
      } else {
        fragmentByStart[startIndex] = fragmentByEnd[endIndex] = {
          start: startIndex,
          end: endIndex,
          ring: [start, end]
        };
      }
    }
  }
  function index2(point2) {
    return point2[0] * 2 + point2[1] * (dx + 1) * 4;
  }
  function smoothLinear(ring, values2, value2) {
    ring.forEach((point2) => {
      var x2 = point2[0], y2 = point2[1], xt = x2 | 0, yt = y2 | 0, v0, v1 = values2[yt * dx + xt];
      if (x2 > 0 && x2 < dx && xt === x2) {
        v0 = values2[yt * dx + xt - 1];
        point2[0] = x2 + (value2 - v0) / (v1 - v0) - 0.5;
      }
      if (y2 > 0 && y2 < dy && yt === y2) {
        v0 = values2[(yt - 1) * dx + xt];
        point2[1] = y2 + (value2 - v0) / (v1 - v0) - 0.5;
      }
    });
  }
  contours2.contour = contour;
  contours2.size = function(_) {
    if (!arguments.length)
      return [dx, dy];
    var _0 = Math.floor(_[0]), _1 = Math.floor(_[1]);
    if (!(_0 >= 0 && _1 >= 0))
      error("invalid size");
    return dx = _0, dy = _1, contours2;
  };
  contours2.smooth = function(_) {
    return arguments.length ? (smooth = _ ? smoothLinear : noop, contours2) : smooth === smoothLinear;
  };
  return contours2;
}
function area(ring) {
  var i = 0, n = ring.length, area2 = ring[n - 1][1] * ring[0][0] - ring[n - 1][0] * ring[0][1];
  while (++i < n)
    area2 += ring[i - 1][1] * ring[i][0] - ring[i - 1][0] * ring[i][1];
  return area2;
}
function contains(ring, hole) {
  var i = -1, n = hole.length, c2;
  while (++i < n)
    if (c2 = ringContains(ring, hole[i]))
      return c2;
  return 0;
}
function ringContains(ring, point2) {
  var x2 = point2[0], y2 = point2[1], contains2 = -1;
  for (var i = 0, n = ring.length, j = n - 1; i < n; j = i++) {
    var pi2 = ring[i], xi = pi2[0], yi = pi2[1], pj = ring[j], xj = pj[0], yj = pj[1];
    if (segmentContains(pi2, pj, point2))
      return 0;
    if (yi > y2 !== yj > y2 && x2 < (xj - xi) * (y2 - yi) / (yj - yi) + xi)
      contains2 = -contains2;
  }
  return contains2;
}
function segmentContains(a2, b2, c2) {
  var i;
  return collinear(a2, b2, c2) && within(a2[i = +(a2[0] === b2[0])], c2[i], b2[i]);
}
function collinear(a2, b2, c2) {
  return (b2[0] - a2[0]) * (c2[1] - a2[1]) === (c2[0] - a2[0]) * (b2[1] - a2[1]);
}
function within(p, q, r) {
  return p <= q && q <= r || r <= q && q <= p;
}
function quantize(k, nice2, zero2) {
  return function(values2) {
    var ex = extent(values2), start = zero2 ? Math.min(ex[0], 0) : ex[0], stop2 = ex[1], span2 = stop2 - start, step = nice2 ? tickStep(start, stop2, k) : span2 / (k + 1);
    return range$4(start + step, stop2, step);
  };
}
function Isocontour(params2) {
  Transform.call(this, null, params2);
}
Isocontour.Definition = {
  "type": "Isocontour",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "thresholds",
    "type": "number",
    "array": true
  }, {
    "name": "levels",
    "type": "number"
  }, {
    "name": "nice",
    "type": "boolean",
    "default": false
  }, {
    "name": "resolve",
    "type": "enum",
    "values": ["shared", "independent"],
    "default": "independent"
  }, {
    "name": "zero",
    "type": "boolean",
    "default": true
  }, {
    "name": "smooth",
    "type": "boolean",
    "default": true
  }, {
    "name": "scale",
    "type": "number",
    "expr": true
  }, {
    "name": "translate",
    "type": "number",
    "array": true,
    "expr": true
  }, {
    "name": "as",
    "type": "string",
    "null": true,
    "default": "contour"
  }]
};
inherits(Isocontour, Transform, {
  transform(_, pulse2) {
    if (this.value && !pulse2.changed() && !_.modified()) {
      return pulse2.StopPropagation;
    }
    var out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), source2 = pulse2.materialize(pulse2.SOURCE).source, field2 = _.field || identity$1, contour = contours().smooth(_.smooth !== false), tz = _.thresholds || levels(source2, field2, _), as = _.as === null ? null : _.as || "contour", values2 = [];
    source2.forEach((t) => {
      const grid = field2(t);
      const paths = contour.size([grid.width, grid.height])(grid.values, isArray(tz) ? tz : tz(grid.values));
      transformPaths(paths, grid, t, _);
      paths.forEach((p) => {
        values2.push(rederive(t, ingest$1(as != null ? {
          [as]: p
        } : p)));
      });
    });
    if (this.value)
      out.rem = this.value;
    this.value = out.source = out.add = values2;
    return out;
  }
});
function levels(values2, f, _) {
  const q = quantize(_.levels || 10, _.nice, _.zero !== false);
  return _.resolve !== "shared" ? q : q(values2.map((t) => max$2(f(t).values)));
}
function transformPaths(paths, grid, datum2, _) {
  let s = _.scale || grid.scale, t = _.translate || grid.translate;
  if (isFunction(s))
    s = s(datum2, _);
  if (isFunction(t))
    t = t(datum2, _);
  if ((s === 1 || s == null) && !t)
    return;
  const sx = (isNumber$1(s) ? s : s[0]) || 1, sy = (isNumber$1(s) ? s : s[1]) || 1, tx2 = t && t[0] || 0, ty = t && t[1] || 0;
  paths.forEach(transform$1(grid, sx, sy, tx2, ty));
}
function transform$1(grid, sx, sy, tx2, ty) {
  const x12 = grid.x1 || 0, y12 = grid.y1 || 0, flip2 = sx * sy < 0;
  function transformPolygon(coordinates) {
    coordinates.forEach(transformRing);
  }
  function transformRing(coordinates) {
    if (flip2)
      coordinates.reverse();
    coordinates.forEach(transformPoint);
  }
  function transformPoint(coordinates) {
    coordinates[0] = (coordinates[0] - x12) * sx + tx2;
    coordinates[1] = (coordinates[1] - y12) * sy + ty;
  }
  return function(geometry) {
    geometry.coordinates.forEach(transformPolygon);
    return geometry;
  };
}
function radius(bw, data2, f) {
  const v = bw >= 0 ? bw : estimateBandwidth(data2, f);
  return Math.round((Math.sqrt(4 * v * v + 1) - 1) / 2);
}
function number$2(_) {
  return isFunction(_) ? _ : constant(+_);
}
function density2D() {
  var x2 = (d) => d[0], y2 = (d) => d[1], weight = one$1, bandwidth2 = [-1, -1], dx = 960, dy = 500, k = 2;
  function density(data2, counts) {
    const rx = radius(bandwidth2[0], data2, x2) >> k, ry = radius(bandwidth2[1], data2, y2) >> k, ox = rx ? rx + 2 : 0, oy = ry ? ry + 2 : 0, n = 2 * ox + (dx >> k), m2 = 2 * oy + (dy >> k), values0 = new Float32Array(n * m2), values1 = new Float32Array(n * m2);
    let values2 = values0;
    data2.forEach((d) => {
      const xi = ox + (+x2(d) >> k), yi = oy + (+y2(d) >> k);
      if (xi >= 0 && xi < n && yi >= 0 && yi < m2) {
        values0[xi + yi * n] += +weight(d);
      }
    });
    if (rx > 0 && ry > 0) {
      blurX(n, m2, values0, values1, rx);
      blurY(n, m2, values1, values0, ry);
      blurX(n, m2, values0, values1, rx);
      blurY(n, m2, values1, values0, ry);
      blurX(n, m2, values0, values1, rx);
      blurY(n, m2, values1, values0, ry);
    } else if (rx > 0) {
      blurX(n, m2, values0, values1, rx);
      blurX(n, m2, values1, values0, rx);
      blurX(n, m2, values0, values1, rx);
      values2 = values1;
    } else if (ry > 0) {
      blurY(n, m2, values0, values1, ry);
      blurY(n, m2, values1, values0, ry);
      blurY(n, m2, values0, values1, ry);
      values2 = values1;
    }
    const s = counts ? Math.pow(2, -2 * k) : 1 / sum$1(values2);
    for (let i = 0, sz2 = n * m2; i < sz2; ++i)
      values2[i] *= s;
    return {
      values: values2,
      scale: 1 << k,
      width: n,
      height: m2,
      x1: ox,
      y1: oy,
      x2: ox + (dx >> k),
      y2: oy + (dy >> k)
    };
  }
  density.x = function(_) {
    return arguments.length ? (x2 = number$2(_), density) : x2;
  };
  density.y = function(_) {
    return arguments.length ? (y2 = number$2(_), density) : y2;
  };
  density.weight = function(_) {
    return arguments.length ? (weight = number$2(_), density) : weight;
  };
  density.size = function(_) {
    if (!arguments.length)
      return [dx, dy];
    var _0 = +_[0], _1 = +_[1];
    if (!(_0 >= 0 && _1 >= 0))
      error("invalid size");
    return dx = _0, dy = _1, density;
  };
  density.cellSize = function(_) {
    if (!arguments.length)
      return 1 << k;
    if (!((_ = +_) >= 1))
      error("invalid cell size");
    k = Math.floor(Math.log(_) / Math.LN2);
    return density;
  };
  density.bandwidth = function(_) {
    if (!arguments.length)
      return bandwidth2;
    _ = array$3(_);
    if (_.length === 1)
      _ = [+_[0], +_[0]];
    if (_.length !== 2)
      error("invalid bandwidth");
    return bandwidth2 = _, density;
  };
  return density;
}
function blurX(n, m2, source2, target2, r) {
  const w2 = (r << 1) + 1;
  for (let j = 0; j < m2; ++j) {
    for (let i = 0, sr = 0; i < n + r; ++i) {
      if (i < n) {
        sr += source2[i + j * n];
      }
      if (i >= r) {
        if (i >= w2) {
          sr -= source2[i - w2 + j * n];
        }
        target2[i - r + j * n] = sr / Math.min(i + 1, n - 1 + w2 - i, w2);
      }
    }
  }
}
function blurY(n, m2, source2, target2, r) {
  const w2 = (r << 1) + 1;
  for (let i = 0; i < n; ++i) {
    for (let j = 0, sr = 0; j < m2 + r; ++j) {
      if (j < m2) {
        sr += source2[i + j * n];
      }
      if (j >= r) {
        if (j >= w2) {
          sr -= source2[i + (j - w2) * n];
        }
        target2[i + (j - r) * n] = sr / Math.min(j + 1, m2 - 1 + w2 - j, w2);
      }
    }
  }
}
function KDE2D(params2) {
  Transform.call(this, null, params2);
}
KDE2D.Definition = {
  "type": "KDE2D",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2,
    "required": true
  }, {
    "name": "x",
    "type": "field",
    "required": true
  }, {
    "name": "y",
    "type": "field",
    "required": true
  }, {
    "name": "weight",
    "type": "field"
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "cellSize",
    "type": "number"
  }, {
    "name": "bandwidth",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "counts",
    "type": "boolean",
    "default": false
  }, {
    "name": "as",
    "type": "string",
    "default": "grid"
  }]
};
const PARAMS = ["x", "y", "weight", "size", "cellSize", "bandwidth"];
function params(obj, _) {
  PARAMS.forEach((param2) => _[param2] != null ? obj[param2](_[param2]) : 0);
  return obj;
}
inherits(KDE2D, Transform, {
  transform(_, pulse2) {
    if (this.value && !pulse2.changed() && !_.modified())
      return pulse2.StopPropagation;
    var out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition$1(source2, _.groupby), names = (_.groupby || []).map(accessorName), kde2 = params(density2D(), _), as = _.as || "grid", values2 = [];
    function set2(t, vals) {
      for (let i = 0; i < names.length; ++i)
        t[names[i]] = vals[i];
      return t;
    }
    values2 = groups.map((g) => ingest$1(set2({
      [as]: kde2(g, _.counts)
    }, g.dims)));
    if (this.value)
      out.rem = this.value;
    this.value = out.source = out.add = values2;
    return out;
  }
});
function partition$1(data2, groupby) {
  var groups = [], get2 = (f) => f(t), map2, i, n, t, k, g;
  if (groupby == null) {
    groups.push(data2);
  } else {
    for (map2 = {}, i = 0, n = data2.length; i < n; ++i) {
      t = data2[i];
      k = groupby.map(get2);
      g = map2[k];
      if (!g) {
        map2[k] = g = [];
        g.dims = k;
        groups.push(g);
      }
      g.push(t);
    }
  }
  return groups;
}
function Contour(params2) {
  Transform.call(this, null, params2);
}
Contour.Definition = {
  "type": "Contour",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2,
    "required": true
  }, {
    "name": "values",
    "type": "number",
    "array": true
  }, {
    "name": "x",
    "type": "field"
  }, {
    "name": "y",
    "type": "field"
  }, {
    "name": "weight",
    "type": "field"
  }, {
    "name": "cellSize",
    "type": "number"
  }, {
    "name": "bandwidth",
    "type": "number"
  }, {
    "name": "count",
    "type": "number"
  }, {
    "name": "nice",
    "type": "boolean",
    "default": false
  }, {
    "name": "thresholds",
    "type": "number",
    "array": true
  }, {
    "name": "smooth",
    "type": "boolean",
    "default": true
  }]
};
inherits(Contour, Transform, {
  transform(_, pulse2) {
    if (this.value && !pulse2.changed() && !_.modified()) {
      return pulse2.StopPropagation;
    }
    var out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS), contour = contours().smooth(_.smooth !== false), values2 = _.values, thresh = _.thresholds || quantize(_.count || 10, _.nice, !!values2), size = _.size, grid, post;
    if (!values2) {
      values2 = pulse2.materialize(pulse2.SOURCE).source;
      grid = params(density2D(), _)(values2, true);
      post = transform$1(grid, grid.scale || 1, grid.scale || 1, 0, 0);
      size = [grid.width, grid.height];
      values2 = grid.values;
    }
    thresh = isArray(thresh) ? thresh : thresh(values2);
    values2 = contour.size(size)(values2, thresh);
    if (post)
      values2.forEach(post);
    if (this.value)
      out.rem = this.value;
    this.value = out.source = out.add = (values2 || []).map(ingest$1);
    return out;
  }
});
const Feature = "Feature";
const FeatureCollection = "FeatureCollection";
const MultiPoint = "MultiPoint";
function GeoJSON(params2) {
  Transform.call(this, null, params2);
}
GeoJSON.Definition = {
  "type": "GeoJSON",
  "metadata": {},
  "params": [{
    "name": "fields",
    "type": "field",
    "array": true,
    "length": 2
  }, {
    "name": "geojson",
    "type": "field"
  }]
};
inherits(GeoJSON, Transform, {
  transform(_, pulse2) {
    var features = this._features, points2 = this._points, fields = _.fields, lon = fields && fields[0], lat = fields && fields[1], geojson = _.geojson || !fields && identity$1, flag2 = pulse2.ADD, mod;
    mod = _.modified() || pulse2.changed(pulse2.REM) || pulse2.modified(accessorFields(geojson)) || lon && pulse2.modified(accessorFields(lon)) || lat && pulse2.modified(accessorFields(lat));
    if (!this.value || mod) {
      flag2 = pulse2.SOURCE;
      this._features = features = [];
      this._points = points2 = [];
    }
    if (geojson) {
      pulse2.visit(flag2, (t) => features.push(geojson(t)));
    }
    if (lon && lat) {
      pulse2.visit(flag2, (t) => {
        var x2 = lon(t), y2 = lat(t);
        if (x2 != null && y2 != null && (x2 = +x2) === x2 && (y2 = +y2) === y2) {
          points2.push([x2, y2]);
        }
      });
      features = features.concat({
        type: Feature,
        geometry: {
          type: MultiPoint,
          coordinates: points2
        }
      });
    }
    this.value = {
      type: FeatureCollection,
      features
    };
  }
});
function GeoPath(params2) {
  Transform.call(this, null, params2);
}
GeoPath.Definition = {
  "type": "GeoPath",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "projection",
    "type": "projection"
  }, {
    "name": "field",
    "type": "field"
  }, {
    "name": "pointRadius",
    "type": "number",
    "expr": true
  }, {
    "name": "as",
    "type": "string",
    "default": "path"
  }]
};
inherits(GeoPath, Transform, {
  transform(_, pulse2) {
    var out = pulse2.fork(pulse2.ALL), path2 = this.value, field2 = _.field || identity$1, as = _.as || "path", flag2 = out.SOURCE;
    if (!path2 || _.modified()) {
      this.value = path2 = getProjectionPath(_.projection);
      out.materialize().reflow();
    } else {
      flag2 = field2 === identity$1 || pulse2.modified(field2.fields) ? out.ADD_MOD : out.ADD;
    }
    const prev = initPath(path2, _.pointRadius);
    out.visit(flag2, (t) => t[as] = path2(field2(t)));
    path2.pointRadius(prev);
    return out.modifies(as);
  }
});
function initPath(path2, pointRadius) {
  const prev = path2.pointRadius();
  path2.context(null);
  if (pointRadius != null) {
    path2.pointRadius(pointRadius);
  }
  return prev;
}
function GeoPoint(params2) {
  Transform.call(this, null, params2);
}
GeoPoint.Definition = {
  "type": "GeoPoint",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "projection",
    "type": "projection",
    "required": true
  }, {
    "name": "fields",
    "type": "field",
    "array": true,
    "required": true,
    "length": 2
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 2,
    "default": ["x", "y"]
  }]
};
inherits(GeoPoint, Transform, {
  transform(_, pulse2) {
    var proj = _.projection, lon = _.fields[0], lat = _.fields[1], as = _.as || ["x", "y"], x2 = as[0], y2 = as[1], mod;
    function set2(t) {
      const xy = proj([lon(t), lat(t)]);
      if (xy) {
        t[x2] = xy[0];
        t[y2] = xy[1];
      } else {
        t[x2] = void 0;
        t[y2] = void 0;
      }
    }
    if (_.modified()) {
      pulse2 = pulse2.materialize().reflow(true).visit(pulse2.SOURCE, set2);
    } else {
      mod = pulse2.modified(lon.fields) || pulse2.modified(lat.fields);
      pulse2.visit(mod ? pulse2.ADD_MOD : pulse2.ADD, set2);
    }
    return pulse2.modifies(as);
  }
});
function GeoShape(params2) {
  Transform.call(this, null, params2);
}
GeoShape.Definition = {
  "type": "GeoShape",
  "metadata": {
    "modifies": true,
    "nomod": true
  },
  "params": [{
    "name": "projection",
    "type": "projection"
  }, {
    "name": "field",
    "type": "field",
    "default": "datum"
  }, {
    "name": "pointRadius",
    "type": "number",
    "expr": true
  }, {
    "name": "as",
    "type": "string",
    "default": "shape"
  }]
};
inherits(GeoShape, Transform, {
  transform(_, pulse2) {
    var out = pulse2.fork(pulse2.ALL), shape2 = this.value, as = _.as || "shape", flag2 = out.ADD;
    if (!shape2 || _.modified()) {
      this.value = shape2 = shapeGenerator(getProjectionPath(_.projection), _.field || field$1("datum"), _.pointRadius);
      out.materialize().reflow();
      flag2 = out.SOURCE;
    }
    out.visit(flag2, (t) => t[as] = shape2);
    return out.modifies(as);
  }
});
function shapeGenerator(path2, field2, pointRadius) {
  const shape2 = pointRadius == null ? (_) => path2(field2(_)) : (_) => {
    var prev = path2.pointRadius(), value2 = path2.pointRadius(pointRadius)(field2(_));
    path2.pointRadius(prev);
    return value2;
  };
  shape2.context = (_) => {
    path2.context(_);
    return shape2;
  };
  return shape2;
}
function Graticule(params2) {
  Transform.call(this, [], params2);
  this.generator = graticule();
}
Graticule.Definition = {
  "type": "Graticule",
  "metadata": {
    "changes": true,
    "generates": true
  },
  "params": [{
    "name": "extent",
    "type": "array",
    "array": true,
    "length": 2,
    "content": {
      "type": "number",
      "array": true,
      "length": 2
    }
  }, {
    "name": "extentMajor",
    "type": "array",
    "array": true,
    "length": 2,
    "content": {
      "type": "number",
      "array": true,
      "length": 2
    }
  }, {
    "name": "extentMinor",
    "type": "array",
    "array": true,
    "length": 2,
    "content": {
      "type": "number",
      "array": true,
      "length": 2
    }
  }, {
    "name": "step",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "stepMajor",
    "type": "number",
    "array": true,
    "length": 2,
    "default": [90, 360]
  }, {
    "name": "stepMinor",
    "type": "number",
    "array": true,
    "length": 2,
    "default": [10, 10]
  }, {
    "name": "precision",
    "type": "number",
    "default": 2.5
  }]
};
inherits(Graticule, Transform, {
  transform(_, pulse2) {
    var src = this.value, gen = this.generator, t;
    if (!src.length || _.modified()) {
      for (const prop in _) {
        if (isFunction(gen[prop])) {
          gen[prop](_[prop]);
        }
      }
    }
    t = gen();
    if (src.length) {
      pulse2.mod.push(replace$2(src[0], t));
    } else {
      pulse2.add.push(ingest$1(t));
    }
    src[0] = t;
    return pulse2;
  }
});
function Heatmap(params2) {
  Transform.call(this, null, params2);
}
Heatmap.Definition = {
  "type": "heatmap",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "color",
    "type": "string",
    "expr": true
  }, {
    "name": "opacity",
    "type": "number",
    "expr": true
  }, {
    "name": "resolve",
    "type": "enum",
    "values": ["shared", "independent"],
    "default": "independent"
  }, {
    "name": "as",
    "type": "string",
    "default": "image"
  }]
};
inherits(Heatmap, Transform, {
  transform(_, pulse2) {
    if (!pulse2.changed() && !_.modified()) {
      return pulse2.StopPropagation;
    }
    var source2 = pulse2.materialize(pulse2.SOURCE).source, shared = _.resolve === "shared", field2 = _.field || identity$1, opacity = opacity_(_.opacity, _), color2 = color_(_.color, _), as = _.as || "image", obj = {
      $x: 0,
      $y: 0,
      $value: 0,
      $max: shared ? max$2(source2.map((t) => max$2(field2(t).values))) : 0
    };
    source2.forEach((t) => {
      const v = field2(t);
      const o = extend({}, t, obj);
      if (!shared)
        o.$max = max$2(v.values || []);
      t[as] = toCanvas(v, o, color2.dep ? color2 : constant(color2(o)), opacity.dep ? opacity : constant(opacity(o)));
    });
    return pulse2.reflow(true).modifies(as);
  }
});
function color_(color2, _) {
  let f;
  if (isFunction(color2)) {
    f = (obj) => rgb(color2(obj, _));
    f.dep = dependency(color2);
  } else {
    f = constant(rgb(color2 || "#888"));
  }
  return f;
}
function opacity_(opacity, _) {
  let f;
  if (isFunction(opacity)) {
    f = (obj) => opacity(obj, _);
    f.dep = dependency(opacity);
  } else if (opacity) {
    f = constant(opacity);
  } else {
    f = (obj) => obj.$value / obj.$max || 0;
    f.dep = true;
  }
  return f;
}
function dependency(f) {
  if (!isFunction(f))
    return false;
  const set2 = toSet(accessorFields(f));
  return set2.$x || set2.$y || set2.$value || set2.$max;
}
function toCanvas(grid, obj, color2, opacity) {
  const n = grid.width, m2 = grid.height, x12 = grid.x1 || 0, y12 = grid.y1 || 0, x2 = grid.x2 || n, y2 = grid.y2 || m2, val = grid.values, value2 = val ? (i) => val[i] : zero$1, can = canvas(x2 - x12, y2 - y12), ctx = can.getContext("2d"), img = ctx.getImageData(0, 0, x2 - x12, y2 - y12), pix = img.data;
  for (let j = y12, k = 0; j < y2; ++j) {
    obj.$y = j - y12;
    for (let i = x12, r = j * n; i < x2; ++i, k += 4) {
      obj.$x = i - x12;
      obj.$value = value2(i + r);
      const v = color2(obj);
      pix[k + 0] = v.r;
      pix[k + 1] = v.g;
      pix[k + 2] = v.b;
      pix[k + 3] = ~~(255 * opacity(obj));
    }
  }
  ctx.putImageData(img, 0, 0);
  return can;
}
function Projection$1(params2) {
  Transform.call(this, null, params2);
  this.modified(true);
}
inherits(Projection$1, Transform, {
  transform(_, pulse2) {
    let proj = this.value;
    if (!proj || _.modified("type")) {
      this.value = proj = create(_.type);
      projectionProperties.forEach((prop) => {
        if (_[prop] != null)
          set(proj, prop, _[prop]);
      });
    } else {
      projectionProperties.forEach((prop) => {
        if (_.modified(prop))
          set(proj, prop, _[prop]);
      });
    }
    if (_.pointRadius != null)
      proj.path.pointRadius(_.pointRadius);
    if (_.fit)
      fit(proj, _);
    return pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
  }
});
function fit(proj, _) {
  const data2 = collectGeoJSON(_.fit);
  _.extent ? proj.fitExtent(_.extent, data2) : _.size ? proj.fitSize(_.size, data2) : 0;
}
function create(type2) {
  const constructor = projection((type2 || "mercator").toLowerCase());
  if (!constructor)
    error("Unrecognized projection type: " + type2);
  return constructor();
}
function set(proj, key2, value2) {
  if (isFunction(proj[key2]))
    proj[key2](value2);
}
function collectGeoJSON(data2) {
  data2 = array$3(data2);
  return data2.length === 1 ? data2[0] : {
    type: FeatureCollection,
    features: data2.reduce((a2, f) => a2.concat(featurize(f)), [])
  };
}
function featurize(f) {
  return f.type === FeatureCollection ? f.features : array$3(f).filter((d) => d != null).map((d) => d.type === Feature ? d : {
    type: Feature,
    geometry: d
  });
}
const geo = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  contour: Contour,
  geojson: GeoJSON,
  geopath: GeoPath,
  geopoint: GeoPoint,
  geoshape: GeoShape,
  graticule: Graticule,
  heatmap: Heatmap,
  isocontour: Isocontour,
  kde2d: KDE2D,
  projection: Projection$1
}, Symbol.toStringTag, { value: "Module" }));
const ForceMap = {
  center: forceCenter,
  collide: forceCollide,
  nbody: forceManyBody,
  link: forceLink,
  x: forceX,
  y: forceY
};
const Forces = "forces", ForceParams = ["alpha", "alphaMin", "alphaTarget", "velocityDecay", "forces"], ForceConfig = ["static", "iterations"], ForceOutput = ["x", "y", "vx", "vy"];
function Force(params2) {
  Transform.call(this, null, params2);
}
Force.Definition = {
  "type": "Force",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "static",
    "type": "boolean",
    "default": false
  }, {
    "name": "restart",
    "type": "boolean",
    "default": false
  }, {
    "name": "iterations",
    "type": "number",
    "default": 300
  }, {
    "name": "alpha",
    "type": "number",
    "default": 1
  }, {
    "name": "alphaMin",
    "type": "number",
    "default": 1e-3
  }, {
    "name": "alphaTarget",
    "type": "number",
    "default": 0
  }, {
    "name": "velocityDecay",
    "type": "number",
    "default": 0.4
  }, {
    "name": "forces",
    "type": "param",
    "array": true,
    "params": [{
      "key": {
        "force": "center"
      },
      "params": [{
        "name": "x",
        "type": "number",
        "default": 0
      }, {
        "name": "y",
        "type": "number",
        "default": 0
      }]
    }, {
      "key": {
        "force": "collide"
      },
      "params": [{
        "name": "radius",
        "type": "number",
        "expr": true
      }, {
        "name": "strength",
        "type": "number",
        "default": 0.7
      }, {
        "name": "iterations",
        "type": "number",
        "default": 1
      }]
    }, {
      "key": {
        "force": "nbody"
      },
      "params": [{
        "name": "strength",
        "type": "number",
        "default": -30
      }, {
        "name": "theta",
        "type": "number",
        "default": 0.9
      }, {
        "name": "distanceMin",
        "type": "number",
        "default": 1
      }, {
        "name": "distanceMax",
        "type": "number"
      }]
    }, {
      "key": {
        "force": "link"
      },
      "params": [{
        "name": "links",
        "type": "data"
      }, {
        "name": "id",
        "type": "field"
      }, {
        "name": "distance",
        "type": "number",
        "default": 30,
        "expr": true
      }, {
        "name": "strength",
        "type": "number",
        "expr": true
      }, {
        "name": "iterations",
        "type": "number",
        "default": 1
      }]
    }, {
      "key": {
        "force": "x"
      },
      "params": [{
        "name": "strength",
        "type": "number",
        "default": 0.1
      }, {
        "name": "x",
        "type": "field"
      }]
    }, {
      "key": {
        "force": "y"
      },
      "params": [{
        "name": "strength",
        "type": "number",
        "default": 0.1
      }, {
        "name": "y",
        "type": "field"
      }]
    }]
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "modify": false,
    "default": ForceOutput
  }]
};
inherits(Force, Transform, {
  transform(_, pulse2) {
    var sim = this.value, change2 = pulse2.changed(pulse2.ADD_REM), params2 = _.modified(ForceParams), iters = _.iterations || 300;
    if (!sim) {
      this.value = sim = simulation(pulse2.source, _);
      sim.on("tick", rerun(pulse2.dataflow, this));
      if (!_.static) {
        change2 = true;
        sim.tick();
      }
      pulse2.modifies("index");
    } else {
      if (change2) {
        pulse2.modifies("index");
        sim.nodes(pulse2.source);
      }
      if (params2 || pulse2.changed(pulse2.MOD)) {
        setup(sim, _, 0, pulse2);
      }
    }
    if (params2 || change2 || _.modified(ForceConfig) || pulse2.changed() && _.restart) {
      sim.alpha(Math.max(sim.alpha(), _.alpha || 1)).alphaDecay(1 - Math.pow(sim.alphaMin(), 1 / iters));
      if (_.static) {
        for (sim.stop(); --iters >= 0; )
          sim.tick();
      } else {
        if (sim.stopped())
          sim.restart();
        if (!change2)
          return pulse2.StopPropagation;
      }
    }
    return this.finish(_, pulse2);
  },
  finish(_, pulse2) {
    const dataflow = pulse2.dataflow;
    for (let args = this._argops, j = 0, m2 = args.length, arg; j < m2; ++j) {
      arg = args[j];
      if (arg.name !== Forces || arg.op._argval.force !== "link") {
        continue;
      }
      for (var ops2 = arg.op._argops, i = 0, n = ops2.length, op; i < n; ++i) {
        if (ops2[i].name === "links" && (op = ops2[i].op.source)) {
          dataflow.pulse(op, dataflow.changeset().reflow());
          break;
        }
      }
    }
    return pulse2.reflow(_.modified()).modifies(ForceOutput);
  }
});
function rerun(df, op) {
  return () => df.touch(op).run();
}
function simulation(nodes, _) {
  const sim = forceSimulation(nodes), stop2 = sim.stop, restart = sim.restart;
  let stopped = false;
  sim.stopped = () => stopped;
  sim.restart = () => (stopped = false, restart());
  sim.stop = () => (stopped = true, stop2());
  return setup(sim, _, true).on("end", () => stopped = true);
}
function setup(sim, _, init2, pulse2) {
  var f = array$3(_.forces), i, n, p, name;
  for (i = 0, n = ForceParams.length; i < n; ++i) {
    p = ForceParams[i];
    if (p !== Forces && _.modified(p))
      sim[p](_[p]);
  }
  for (i = 0, n = f.length; i < n; ++i) {
    name = Forces + i;
    p = init2 || _.modified(Forces, i) ? getForce(f[i]) : pulse2 && modified(f[i], pulse2) ? sim.force(name) : null;
    if (p)
      sim.force(name, p);
  }
  for (n = sim.numForces || 0; i < n; ++i) {
    sim.force(Forces + i, null);
  }
  sim.numForces = f.length;
  return sim;
}
function modified(f, pulse2) {
  var k, v;
  for (k in f) {
    if (isFunction(v = f[k]) && pulse2.modified(accessorFields(v)))
      return 1;
  }
  return 0;
}
function getForce(_) {
  var f, p;
  if (!has$1(ForceMap, _.force)) {
    error("Unrecognized force: " + _.force);
  }
  f = ForceMap[_.force]();
  for (p in _) {
    if (isFunction(f[p]))
      setForceParam(f[p], _[p], _);
  }
  return f;
}
function setForceParam(f, v, _) {
  f(isFunction(v) ? (d) => v(d, _) : v);
}
const force = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  force: Force
}, Symbol.toStringTag, { value: "Module" }));
function lookup$2(tree2, key2, filter2) {
  const map2 = {};
  tree2.each((node) => {
    const t = node.data;
    if (filter2(t))
      map2[key2(t)] = node;
  });
  tree2.lookup = map2;
  return tree2;
}
function Nest(params2) {
  Transform.call(this, null, params2);
}
Nest.Definition = {
  "type": "Nest",
  "metadata": {
    "treesource": true,
    "changes": true
  },
  "params": [{
    "name": "keys",
    "type": "field",
    "array": true
  }, {
    "name": "generate",
    "type": "boolean"
  }]
};
const children$2 = (n) => n.values;
inherits(Nest, Transform, {
  transform(_, pulse2) {
    if (!pulse2.source) {
      error("Nest transform requires an upstream data source.");
    }
    var gen = _.generate, mod = _.modified(), out = pulse2.clone(), tree2 = this.value;
    if (!tree2 || mod || pulse2.changed()) {
      if (tree2) {
        tree2.each((node) => {
          if (node.children && isTuple(node.data)) {
            out.rem.push(node.data);
          }
        });
      }
      this.value = tree2 = hierarchy({
        values: array$3(_.keys).reduce((n, k) => {
          n.key(k);
          return n;
        }, nest()).entries(out.source)
      }, children$2);
      if (gen) {
        tree2.each((node) => {
          if (node.children) {
            node = ingest$1(node.data);
            out.add.push(node);
            out.source.push(node);
          }
        });
      }
      lookup$2(tree2, tupleid, tupleid);
    }
    out.source.root = tree2;
    return out;
  }
});
function nest() {
  const keys2 = [], nest2 = {
    entries: (array2) => entries(apply2(array2, 0), 0),
    key: (d) => (keys2.push(d), nest2)
  };
  function apply2(array2, depth) {
    if (depth >= keys2.length) {
      return array2;
    }
    const n = array2.length, key2 = keys2[depth++], valuesByKey = {}, result = {};
    let i = -1, keyValue, value2, values2;
    while (++i < n) {
      keyValue = key2(value2 = array2[i]) + "";
      if (values2 = valuesByKey[keyValue]) {
        values2.push(value2);
      } else {
        valuesByKey[keyValue] = [value2];
      }
    }
    for (keyValue in valuesByKey) {
      result[keyValue] = apply2(valuesByKey[keyValue], depth);
    }
    return result;
  }
  function entries(map2, depth) {
    if (++depth > keys2.length)
      return map2;
    const array2 = [];
    for (const key2 in map2) {
      array2.push({
        key: key2,
        values: entries(map2[key2], depth)
      });
    }
    return array2;
  }
  return nest2;
}
function HierarchyLayout(params2) {
  Transform.call(this, null, params2);
}
const defaultSeparation = (a2, b2) => a2.parent === b2.parent ? 1 : 2;
inherits(HierarchyLayout, Transform, {
  transform(_, pulse2) {
    if (!pulse2.source || !pulse2.source.root) {
      error(this.constructor.name + " transform requires a backing tree data source.");
    }
    const layout = this.layout(_.method), fields = this.fields, root = pulse2.source.root, as = _.as || fields;
    if (_.field)
      root.sum(_.field);
    else
      root.count();
    if (_.sort)
      root.sort(stableCompare(_.sort, (d) => d.data));
    setParams(layout, this.params, _);
    if (layout.separation) {
      layout.separation(_.separation !== false ? defaultSeparation : one$1);
    }
    try {
      this.value = layout(root);
    } catch (err) {
      error(err);
    }
    root.each((node) => setFields(node, fields, as));
    return pulse2.reflow(_.modified()).modifies(as).modifies("leaf");
  }
});
function setParams(layout, params2, _) {
  for (let p, i = 0, n = params2.length; i < n; ++i) {
    p = params2[i];
    if (p in _)
      layout[p](_[p]);
  }
}
function setFields(node, fields, as) {
  const t = node.data, n = fields.length - 1;
  for (let i = 0; i < n; ++i) {
    t[as[i]] = node[fields[i]];
  }
  t[as[n]] = node.children ? node.children.length : 0;
}
const Output$3 = ["x", "y", "r", "depth", "children"];
function Pack(params2) {
  HierarchyLayout.call(this, params2);
}
Pack.Definition = {
  "type": "Pack",
  "metadata": {
    "tree": true,
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "sort",
    "type": "compare"
  }, {
    "name": "padding",
    "type": "number",
    "default": 0
  }, {
    "name": "radius",
    "type": "field",
    "default": null
  }, {
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": Output$3.length,
    "default": Output$3
  }]
};
inherits(Pack, HierarchyLayout, {
  layout: pack,
  params: ["radius", "size", "padding"],
  fields: Output$3
});
const Output$2 = ["x0", "y0", "x1", "y1", "depth", "children"];
function Partition(params2) {
  HierarchyLayout.call(this, params2);
}
Partition.Definition = {
  "type": "Partition",
  "metadata": {
    "tree": true,
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "sort",
    "type": "compare"
  }, {
    "name": "padding",
    "type": "number",
    "default": 0
  }, {
    "name": "round",
    "type": "boolean",
    "default": false
  }, {
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": Output$2.length,
    "default": Output$2
  }]
};
inherits(Partition, HierarchyLayout, {
  layout: partition$4,
  params: ["size", "round", "padding"],
  fields: Output$2
});
function Stratify(params2) {
  Transform.call(this, null, params2);
}
Stratify.Definition = {
  "type": "Stratify",
  "metadata": {
    "treesource": true
  },
  "params": [{
    "name": "key",
    "type": "field",
    "required": true
  }, {
    "name": "parentKey",
    "type": "field",
    "required": true
  }]
};
inherits(Stratify, Transform, {
  transform(_, pulse2) {
    if (!pulse2.source) {
      error("Stratify transform requires an upstream data source.");
    }
    let tree2 = this.value;
    const mod = _.modified(), out = pulse2.fork(pulse2.ALL).materialize(pulse2.SOURCE), run2 = !tree2 || mod || pulse2.changed(pulse2.ADD_REM) || pulse2.modified(_.key.fields) || pulse2.modified(_.parentKey.fields);
    out.source = out.source.slice();
    if (run2) {
      tree2 = out.source.length ? lookup$2(stratify().id(_.key).parentId(_.parentKey)(out.source), _.key, truthy) : lookup$2(stratify()([{}]), _.key, _.key);
    }
    out.source.root = this.value = tree2;
    return out;
  }
});
const Layouts = {
  tidy: tree$1,
  cluster
};
const Output$1$1 = ["x", "y", "depth", "children"];
function Tree(params2) {
  HierarchyLayout.call(this, params2);
}
Tree.Definition = {
  "type": "Tree",
  "metadata": {
    "tree": true,
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "sort",
    "type": "compare"
  }, {
    "name": "method",
    "type": "enum",
    "default": "tidy",
    "values": ["tidy", "cluster"]
  }, {
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "nodeSize",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "separation",
    "type": "boolean",
    "default": true
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": Output$1$1.length,
    "default": Output$1$1
  }]
};
inherits(Tree, HierarchyLayout, {
  /**
   * Tree layout generator. Supports both 'tidy' and 'cluster' layouts.
   */
  layout(method2) {
    const m2 = method2 || "tidy";
    if (has$1(Layouts, m2))
      return Layouts[m2]();
    else
      error("Unrecognized Tree layout method: " + m2);
  },
  params: ["size", "nodeSize"],
  fields: Output$1$1
});
function TreeLinks(params2) {
  Transform.call(this, [], params2);
}
TreeLinks.Definition = {
  "type": "TreeLinks",
  "metadata": {
    "tree": true,
    "generates": true,
    "changes": true
  },
  "params": []
};
inherits(TreeLinks, Transform, {
  transform(_, pulse2) {
    const links = this.value, tree2 = pulse2.source && pulse2.source.root, out = pulse2.fork(pulse2.NO_SOURCE), lut = {};
    if (!tree2)
      error("TreeLinks transform requires a tree data source.");
    if (pulse2.changed(pulse2.ADD_REM)) {
      out.rem = links;
      pulse2.visit(pulse2.SOURCE, (t) => lut[tupleid(t)] = 1);
      tree2.each((node) => {
        const t = node.data, p = node.parent && node.parent.data;
        if (p && lut[tupleid(t)] && lut[tupleid(p)]) {
          out.add.push(ingest$1({
            source: p,
            target: t
          }));
        }
      });
      this.value = out.add;
    } else if (pulse2.changed(pulse2.MOD)) {
      pulse2.visit(pulse2.MOD, (t) => lut[tupleid(t)] = 1);
      links.forEach((link2) => {
        if (lut[tupleid(link2.source)] || lut[tupleid(link2.target)]) {
          out.mod.push(link2);
        }
      });
    }
    return out;
  }
});
const Tiles = {
  binary: treemapBinary,
  dice: treemapDice,
  slice: treemapSlice,
  slicedice: treemapSliceDice,
  squarify: treemapSquarify,
  resquarify: treemapResquarify
};
const Output$4 = ["x0", "y0", "x1", "y1", "depth", "children"];
function Treemap(params2) {
  HierarchyLayout.call(this, params2);
}
Treemap.Definition = {
  "type": "Treemap",
  "metadata": {
    "tree": true,
    "modifies": true
  },
  "params": [{
    "name": "field",
    "type": "field"
  }, {
    "name": "sort",
    "type": "compare"
  }, {
    "name": "method",
    "type": "enum",
    "default": "squarify",
    "values": ["squarify", "resquarify", "binary", "dice", "slice", "slicedice"]
  }, {
    "name": "padding",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingInner",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingOuter",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingTop",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingRight",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingBottom",
    "type": "number",
    "default": 0
  }, {
    "name": "paddingLeft",
    "type": "number",
    "default": 0
  }, {
    "name": "ratio",
    "type": "number",
    "default": 1.618033988749895
  }, {
    "name": "round",
    "type": "boolean",
    "default": false
  }, {
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": Output$4.length,
    "default": Output$4
  }]
};
inherits(Treemap, HierarchyLayout, {
  /**
   * Treemap layout generator. Adds 'method' and 'ratio' parameters
   * to configure the underlying tile method.
   */
  layout() {
    const x2 = treemap();
    x2.ratio = (_) => {
      const t = x2.tile();
      if (t.ratio)
        x2.tile(t.ratio(_));
    };
    x2.method = (_) => {
      if (has$1(Tiles, _))
        x2.tile(Tiles[_]);
      else
        error("Unrecognized Treemap layout method: " + _);
    };
    return x2;
  },
  params: ["method", "ratio", "size", "round", "padding", "paddingInner", "paddingOuter", "paddingTop", "paddingRight", "paddingBottom", "paddingLeft"],
  fields: Output$4
});
const tree = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  nest: Nest,
  pack: Pack,
  partition: Partition,
  stratify: Stratify,
  tree: Tree,
  treelinks: TreeLinks,
  treemap: Treemap
}, Symbol.toStringTag, { value: "Module" }));
const ALPHA_MASK = 4278190080;
function baseBitmaps($2, data2) {
  const bitmap = $2.bitmap();
  (data2 || []).forEach((d) => bitmap.set($2(d.boundary[0]), $2(d.boundary[3])));
  return [bitmap, void 0];
}
function markBitmaps($2, baseMark, avoidMarks, labelInside, isGroupArea) {
  const width2 = $2.width, height2 = $2.height, border = labelInside || isGroupArea, context2 = canvas(width2, height2).getContext("2d"), baseMarkContext = canvas(width2, height2).getContext("2d"), strokeContext = border && canvas(width2, height2).getContext("2d");
  avoidMarks.forEach((items) => draw(context2, items, false));
  draw(baseMarkContext, baseMark, false);
  if (border) {
    draw(strokeContext, baseMark, true);
  }
  const buffer = getBuffer(context2, width2, height2), baseMarkBuffer = getBuffer(baseMarkContext, width2, height2), strokeBuffer = border && getBuffer(strokeContext, width2, height2), layer1 = $2.bitmap(), layer2 = border && $2.bitmap();
  let x2, y2, u2, v, index2, alpha, strokeAlpha, baseMarkAlpha;
  for (y2 = 0; y2 < height2; ++y2) {
    for (x2 = 0; x2 < width2; ++x2) {
      index2 = y2 * width2 + x2;
      alpha = buffer[index2] & ALPHA_MASK;
      baseMarkAlpha = baseMarkBuffer[index2] & ALPHA_MASK;
      strokeAlpha = border && strokeBuffer[index2] & ALPHA_MASK;
      if (alpha || strokeAlpha || baseMarkAlpha) {
        u2 = $2(x2);
        v = $2(y2);
        if (!isGroupArea && (alpha || baseMarkAlpha))
          layer1.set(u2, v);
        if (border && (alpha || strokeAlpha))
          layer2.set(u2, v);
      }
    }
  }
  return [layer1, layer2];
}
function getBuffer(context2, width2, height2) {
  return new Uint32Array(context2.getImageData(0, 0, width2, height2).data.buffer);
}
function draw(context2, items, interior) {
  if (!items.length)
    return;
  const type2 = items[0].mark.marktype;
  if (type2 === "group") {
    items.forEach((group2) => {
      group2.items.forEach((mark) => draw(context2, mark.items, interior));
    });
  } else {
    Marks[type2].draw(context2, {
      items: interior ? items.map(prepare) : items
    });
  }
}
function prepare(source2) {
  const item = rederive(source2, {});
  if (item.stroke && item.strokeOpacity !== 0 || item.fill && item.fillOpacity !== 0) {
    return {
      ...item,
      strokeOpacity: 1,
      stroke: "#000",
      fillOpacity: 0
    };
  }
  return item;
}
const DIV = 5, MOD = 31, SIZE = 32, RIGHT0 = new Uint32Array(SIZE + 1), RIGHT1 = new Uint32Array(SIZE + 1);
RIGHT1[0] = 0;
RIGHT0[0] = ~RIGHT1[0];
for (let i = 1; i <= SIZE; ++i) {
  RIGHT1[i] = RIGHT1[i - 1] << 1 | 1;
  RIGHT0[i] = ~RIGHT1[i];
}
function Bitmap(w2, h2) {
  const array2 = new Uint32Array(~~((w2 * h2 + SIZE) / SIZE));
  function _set(index2, mask) {
    array2[index2] |= mask;
  }
  function _clear(index2, mask) {
    array2[index2] &= mask;
  }
  return {
    array: array2,
    get: (x2, y2) => {
      const index2 = y2 * w2 + x2;
      return array2[index2 >>> DIV] & 1 << (index2 & MOD);
    },
    set: (x2, y2) => {
      const index2 = y2 * w2 + x2;
      _set(index2 >>> DIV, 1 << (index2 & MOD));
    },
    clear: (x2, y2) => {
      const index2 = y2 * w2 + x2;
      _clear(index2 >>> DIV, ~(1 << (index2 & MOD)));
    },
    getRange: (x2, y2, x22, y22) => {
      let r = y22, start, end, indexStart, indexEnd;
      for (; r >= y2; --r) {
        start = r * w2 + x2;
        end = r * w2 + x22;
        indexStart = start >>> DIV;
        indexEnd = end >>> DIV;
        if (indexStart === indexEnd) {
          if (array2[indexStart] & RIGHT0[start & MOD] & RIGHT1[(end & MOD) + 1]) {
            return true;
          }
        } else {
          if (array2[indexStart] & RIGHT0[start & MOD])
            return true;
          if (array2[indexEnd] & RIGHT1[(end & MOD) + 1])
            return true;
          for (let i = indexStart + 1; i < indexEnd; ++i) {
            if (array2[i])
              return true;
          }
        }
      }
      return false;
    },
    setRange: (x2, y2, x22, y22) => {
      let start, end, indexStart, indexEnd, i;
      for (; y2 <= y22; ++y2) {
        start = y2 * w2 + x2;
        end = y2 * w2 + x22;
        indexStart = start >>> DIV;
        indexEnd = end >>> DIV;
        if (indexStart === indexEnd) {
          _set(indexStart, RIGHT0[start & MOD] & RIGHT1[(end & MOD) + 1]);
        } else {
          _set(indexStart, RIGHT0[start & MOD]);
          _set(indexEnd, RIGHT1[(end & MOD) + 1]);
          for (i = indexStart + 1; i < indexEnd; ++i)
            _set(i, 4294967295);
        }
      }
    },
    clearRange: (x2, y2, x22, y22) => {
      let start, end, indexStart, indexEnd, i;
      for (; y2 <= y22; ++y2) {
        start = y2 * w2 + x2;
        end = y2 * w2 + x22;
        indexStart = start >>> DIV;
        indexEnd = end >>> DIV;
        if (indexStart === indexEnd) {
          _clear(indexStart, RIGHT1[start & MOD] | RIGHT0[(end & MOD) + 1]);
        } else {
          _clear(indexStart, RIGHT1[start & MOD]);
          _clear(indexEnd, RIGHT0[(end & MOD) + 1]);
          for (i = indexStart + 1; i < indexEnd; ++i)
            _clear(i, 0);
        }
      }
    },
    outOfBounds: (x2, y2, x22, y22) => x2 < 0 || y2 < 0 || y22 >= h2 || x22 >= w2
  };
}
function scaler(width2, height2, padding2) {
  const ratio = Math.max(1, Math.sqrt(width2 * height2 / 1e6)), w2 = ~~((width2 + 2 * padding2 + ratio) / ratio), h2 = ~~((height2 + 2 * padding2 + ratio) / ratio), scale2 = (_) => ~~((_ + padding2) / ratio);
  scale2.invert = (_) => _ * ratio - padding2;
  scale2.bitmap = () => Bitmap(w2, h2);
  scale2.ratio = ratio;
  scale2.padding = padding2;
  scale2.width = width2;
  scale2.height = height2;
  return scale2;
}
function placeAreaLabelNaive($2, bitmaps, avoidBaseMark, markIndex) {
  const width2 = $2.width, height2 = $2.height;
  return function(d) {
    const items = d.datum.datum.items[markIndex].items, n = items.length, textHeight = d.datum.fontSize, textWidth = textMetrics.width(d.datum, d.datum.text);
    let maxAreaWidth = 0, x12, x2, y12, y2, x3, y3, areaWidth;
    for (let i = 0; i < n; ++i) {
      x12 = items[i].x;
      y12 = items[i].y;
      x2 = items[i].x2 === void 0 ? x12 : items[i].x2;
      y2 = items[i].y2 === void 0 ? y12 : items[i].y2;
      x3 = (x12 + x2) / 2;
      y3 = (y12 + y2) / 2;
      areaWidth = Math.abs(x2 - x12 + y2 - y12);
      if (areaWidth >= maxAreaWidth) {
        maxAreaWidth = areaWidth;
        d.x = x3;
        d.y = y3;
      }
    }
    x3 = textWidth / 2;
    y3 = textHeight / 2;
    x12 = d.x - x3;
    x2 = d.x + x3;
    y12 = d.y - y3;
    y2 = d.y + y3;
    d.align = "center";
    if (x12 < 0 && x2 <= width2) {
      d.align = "left";
    } else if (0 <= x12 && width2 < x2) {
      d.align = "right";
    }
    d.baseline = "middle";
    if (y12 < 0 && y2 <= height2) {
      d.baseline = "top";
    } else if (0 <= y12 && height2 < y2) {
      d.baseline = "bottom";
    }
    return true;
  };
}
function outOfBounds(x2, y2, textWidth, textHeight, width2, height2) {
  let r = textWidth / 2;
  return x2 - r < 0 || x2 + r > width2 || y2 - (r = textHeight / 2) < 0 || y2 + r > height2;
}
function collision($2, x2, y2, textHeight, textWidth, h2, bm0, bm1) {
  const w2 = textWidth * h2 / (textHeight * 2), x12 = $2(x2 - w2), x22 = $2(x2 + w2), y12 = $2(y2 - (h2 = h2 / 2)), y22 = $2(y2 + h2);
  return bm0.outOfBounds(x12, y12, x22, y22) || bm0.getRange(x12, y12, x22, y22) || bm1 && bm1.getRange(x12, y12, x22, y22);
}
function placeAreaLabelReducedSearch($2, bitmaps, avoidBaseMark, markIndex) {
  const width2 = $2.width, height2 = $2.height, bm0 = bitmaps[0], bm1 = bitmaps[1];
  function tryLabel(_x, _y, maxSize, textWidth, textHeight) {
    const x2 = $2.invert(_x), y2 = $2.invert(_y);
    let lo = maxSize, hi = height2, mid;
    if (!outOfBounds(x2, y2, textWidth, textHeight, width2, height2) && !collision($2, x2, y2, textHeight, textWidth, lo, bm0, bm1) && !collision($2, x2, y2, textHeight, textWidth, textHeight, bm0, null)) {
      while (hi - lo >= 1) {
        mid = (lo + hi) / 2;
        if (collision($2, x2, y2, textHeight, textWidth, mid, bm0, bm1)) {
          hi = mid;
        } else {
          lo = mid;
        }
      }
      if (lo > maxSize) {
        return [x2, y2, lo, true];
      }
    }
  }
  return function(d) {
    const items = d.datum.datum.items[markIndex].items, n = items.length, textHeight = d.datum.fontSize, textWidth = textMetrics.width(d.datum, d.datum.text);
    let maxSize = avoidBaseMark ? textHeight : 0, labelPlaced = false, labelPlaced2 = false, maxAreaWidth = 0, x12, x2, y12, y2, x3, y3, _x, _y, _x1, _xMid, _x2, _y1, _yMid, _y2, areaWidth, result, swapTmp;
    for (let i = 0; i < n; ++i) {
      x12 = items[i].x;
      y12 = items[i].y;
      x2 = items[i].x2 === void 0 ? x12 : items[i].x2;
      y2 = items[i].y2 === void 0 ? y12 : items[i].y2;
      if (x12 > x2) {
        swapTmp = x12;
        x12 = x2;
        x2 = swapTmp;
      }
      if (y12 > y2) {
        swapTmp = y12;
        y12 = y2;
        y2 = swapTmp;
      }
      _x1 = $2(x12);
      _x2 = $2(x2);
      _xMid = ~~((_x1 + _x2) / 2);
      _y1 = $2(y12);
      _y2 = $2(y2);
      _yMid = ~~((_y1 + _y2) / 2);
      for (_x = _xMid; _x >= _x1; --_x) {
        for (_y = _yMid; _y >= _y1; --_y) {
          result = tryLabel(_x, _y, maxSize, textWidth, textHeight);
          if (result) {
            [d.x, d.y, maxSize, labelPlaced] = result;
          }
        }
      }
      for (_x = _xMid; _x <= _x2; ++_x) {
        for (_y = _yMid; _y <= _y2; ++_y) {
          result = tryLabel(_x, _y, maxSize, textWidth, textHeight);
          if (result) {
            [d.x, d.y, maxSize, labelPlaced] = result;
          }
        }
      }
      if (!labelPlaced && !avoidBaseMark) {
        areaWidth = Math.abs(x2 - x12 + y2 - y12);
        x3 = (x12 + x2) / 2;
        y3 = (y12 + y2) / 2;
        if (areaWidth >= maxAreaWidth && !outOfBounds(x3, y3, textWidth, textHeight, width2, height2) && !collision($2, x3, y3, textHeight, textWidth, textHeight, bm0, null)) {
          maxAreaWidth = areaWidth;
          d.x = x3;
          d.y = y3;
          labelPlaced2 = true;
        }
      }
    }
    if (labelPlaced || labelPlaced2) {
      x3 = textWidth / 2;
      y3 = textHeight / 2;
      bm0.setRange($2(d.x - x3), $2(d.y - y3), $2(d.x + x3), $2(d.y + y3));
      d.align = "center";
      d.baseline = "middle";
      return true;
    } else {
      return false;
    }
  };
}
const X_DIR = [-1, -1, 1, 1];
const Y_DIR = [-1, 1, -1, 1];
function placeAreaLabelFloodFill($2, bitmaps, avoidBaseMark, markIndex) {
  const width2 = $2.width, height2 = $2.height, bm0 = bitmaps[0], bm1 = bitmaps[1], bm2 = $2.bitmap();
  return function(d) {
    const items = d.datum.datum.items[markIndex].items, n = items.length, textHeight = d.datum.fontSize, textWidth = textMetrics.width(d.datum, d.datum.text), stack = [];
    let maxSize = avoidBaseMark ? textHeight : 0, labelPlaced = false, labelPlaced2 = false, maxAreaWidth = 0, x12, x2, y12, y2, x3, y3, _x, _y, lo, hi, mid, areaWidth;
    for (let i = 0; i < n; ++i) {
      x12 = items[i].x;
      y12 = items[i].y;
      x2 = items[i].x2 === void 0 ? x12 : items[i].x2;
      y2 = items[i].y2 === void 0 ? y12 : items[i].y2;
      stack.push([$2((x12 + x2) / 2), $2((y12 + y2) / 2)]);
      while (stack.length) {
        [_x, _y] = stack.pop();
        if (bm0.get(_x, _y) || bm1.get(_x, _y) || bm2.get(_x, _y))
          continue;
        bm2.set(_x, _y);
        for (let j = 0; j < 4; ++j) {
          x3 = _x + X_DIR[j];
          y3 = _y + Y_DIR[j];
          if (!bm2.outOfBounds(x3, y3, x3, y3))
            stack.push([x3, y3]);
        }
        x3 = $2.invert(_x);
        y3 = $2.invert(_y);
        lo = maxSize;
        hi = height2;
        if (!outOfBounds(x3, y3, textWidth, textHeight, width2, height2) && !collision($2, x3, y3, textHeight, textWidth, lo, bm0, bm1) && !collision($2, x3, y3, textHeight, textWidth, textHeight, bm0, null)) {
          while (hi - lo >= 1) {
            mid = (lo + hi) / 2;
            if (collision($2, x3, y3, textHeight, textWidth, mid, bm0, bm1)) {
              hi = mid;
            } else {
              lo = mid;
            }
          }
          if (lo > maxSize) {
            d.x = x3;
            d.y = y3;
            maxSize = lo;
            labelPlaced = true;
          }
        }
      }
      if (!labelPlaced && !avoidBaseMark) {
        areaWidth = Math.abs(x2 - x12 + y2 - y12);
        x3 = (x12 + x2) / 2;
        y3 = (y12 + y2) / 2;
        if (areaWidth >= maxAreaWidth && !outOfBounds(x3, y3, textWidth, textHeight, width2, height2) && !collision($2, x3, y3, textHeight, textWidth, textHeight, bm0, null)) {
          maxAreaWidth = areaWidth;
          d.x = x3;
          d.y = y3;
          labelPlaced2 = true;
        }
      }
    }
    if (labelPlaced || labelPlaced2) {
      x3 = textWidth / 2;
      y3 = textHeight / 2;
      bm0.setRange($2(d.x - x3), $2(d.y - y3), $2(d.x + x3), $2(d.y + y3));
      d.align = "center";
      d.baseline = "middle";
      return true;
    } else {
      return false;
    }
  };
}
const Aligns = ["right", "center", "left"], Baselines = ["bottom", "middle", "top"];
function placeMarkLabel($2, bitmaps, anchors, offsets2) {
  const width2 = $2.width, height2 = $2.height, bm0 = bitmaps[0], bm1 = bitmaps[1], n = offsets2.length;
  return function(d) {
    const boundary = d.boundary, textHeight = d.datum.fontSize;
    if (boundary[2] < 0 || boundary[5] < 0 || boundary[0] > width2 || boundary[3] > height2) {
      return false;
    }
    let textWidth = d.textWidth ?? 0, dx, dy, isInside, sizeFactor, insideFactor, x12, x2, y12, y2, xc, yc, _x1, _x2, _y1, _y2;
    for (let i = 0; i < n; ++i) {
      dx = (anchors[i] & 3) - 1;
      dy = (anchors[i] >>> 2 & 3) - 1;
      isInside = dx === 0 && dy === 0 || offsets2[i] < 0;
      sizeFactor = dx && dy ? Math.SQRT1_2 : 1;
      insideFactor = offsets2[i] < 0 ? -1 : 1;
      x12 = boundary[1 + dx] + offsets2[i] * dx * sizeFactor;
      yc = boundary[4 + dy] + insideFactor * textHeight * dy / 2 + offsets2[i] * dy * sizeFactor;
      y12 = yc - textHeight / 2;
      y2 = yc + textHeight / 2;
      _x1 = $2(x12);
      _y1 = $2(y12);
      _y2 = $2(y2);
      if (!textWidth) {
        if (!test(_x1, _x1, _y1, _y2, bm0, bm1, x12, x12, y12, y2, boundary, isInside)) {
          continue;
        } else {
          textWidth = textMetrics.width(d.datum, d.datum.text);
        }
      }
      xc = x12 + insideFactor * textWidth * dx / 2;
      x12 = xc - textWidth / 2;
      x2 = xc + textWidth / 2;
      _x1 = $2(x12);
      _x2 = $2(x2);
      if (test(_x1, _x2, _y1, _y2, bm0, bm1, x12, x2, y12, y2, boundary, isInside)) {
        d.x = !dx ? xc : dx * insideFactor < 0 ? x2 : x12;
        d.y = !dy ? yc : dy * insideFactor < 0 ? y2 : y12;
        d.align = Aligns[dx * insideFactor + 1];
        d.baseline = Baselines[dy * insideFactor + 1];
        bm0.setRange(_x1, _y1, _x2, _y2);
        return true;
      }
    }
    return false;
  };
}
function test(_x1, _x2, _y1, _y2, bm0, bm1, x12, x2, y12, y2, boundary, isInside) {
  return !(bm0.outOfBounds(_x1, _y1, _x2, _y2) || (isInside && bm1 || bm0).getRange(_x1, _y1, _x2, _y2));
}
const TOP = 0, MIDDLE = 4, BOTTOM = 8, LEFT = 0, CENTER = 1, RIGHT = 2;
const anchorCode = {
  "top-left": TOP + LEFT,
  "top": TOP + CENTER,
  "top-right": TOP + RIGHT,
  "left": MIDDLE + LEFT,
  "middle": MIDDLE + CENTER,
  "right": MIDDLE + RIGHT,
  "bottom-left": BOTTOM + LEFT,
  "bottom": BOTTOM + CENTER,
  "bottom-right": BOTTOM + RIGHT
};
const placeAreaLabel = {
  "naive": placeAreaLabelNaive,
  "reduced-search": placeAreaLabelReducedSearch,
  "floodfill": placeAreaLabelFloodFill
};
function labelLayout(texts, size, compare2, offset2, anchor, avoidMarks, avoidBaseMark, lineAnchor, markIndex, padding2, method2) {
  if (!texts.length)
    return texts;
  const positions = Math.max(offset2.length, anchor.length), offsets2 = getOffsets(offset2, positions), anchors = getAnchors(anchor, positions), marktype = markType(texts[0].datum), grouptype = marktype === "group" && texts[0].datum.items[markIndex].marktype, isGroupArea = grouptype === "area", boundary = markBoundary(marktype, grouptype, lineAnchor, markIndex), infPadding = padding2 === null || padding2 === Infinity, isNaiveGroupArea = isGroupArea && method2 === "naive";
  let maxTextWidth = -1, maxTextHeight = -1;
  const data2 = texts.map((d) => {
    const textWidth = infPadding ? textMetrics.width(d, d.text) : void 0;
    maxTextWidth = Math.max(maxTextWidth, textWidth);
    maxTextHeight = Math.max(maxTextHeight, d.fontSize);
    return {
      datum: d,
      opacity: 0,
      x: void 0,
      y: void 0,
      align: void 0,
      baseline: void 0,
      boundary: boundary(d),
      textWidth
    };
  });
  padding2 = padding2 === null || padding2 === Infinity ? Math.max(maxTextWidth, maxTextHeight) + Math.max(...offset2) : padding2;
  const $2 = scaler(size[0], size[1], padding2);
  let bitmaps;
  if (!isNaiveGroupArea) {
    if (compare2) {
      data2.sort((a2, b2) => compare2(a2.datum, b2.datum));
    }
    let labelInside = false;
    for (let i = 0; i < anchors.length && !labelInside; ++i) {
      labelInside = anchors[i] === 5 || offsets2[i] < 0;
    }
    const baseMark = (marktype && avoidBaseMark || isGroupArea) && texts.map((d) => d.datum);
    bitmaps = avoidMarks.length || baseMark ? markBitmaps($2, baseMark || [], avoidMarks, labelInside, isGroupArea) : baseBitmaps($2, avoidBaseMark && data2);
  }
  const place2 = isGroupArea ? placeAreaLabel[method2]($2, bitmaps, avoidBaseMark, markIndex) : placeMarkLabel($2, bitmaps, anchors, offsets2);
  data2.forEach((d) => d.opacity = +place2(d));
  return data2;
}
function getOffsets(_, count2) {
  const offsets2 = new Float64Array(count2), n = _.length;
  for (let i = 0; i < n; ++i)
    offsets2[i] = _[i] || 0;
  for (let i = n; i < count2; ++i)
    offsets2[i] = offsets2[n - 1];
  return offsets2;
}
function getAnchors(_, count2) {
  const anchors = new Int8Array(count2), n = _.length;
  for (let i = 0; i < n; ++i)
    anchors[i] |= anchorCode[_[i]];
  for (let i = n; i < count2; ++i)
    anchors[i] = anchors[n - 1];
  return anchors;
}
function markType(item) {
  return item && item.mark && item.mark.marktype;
}
function markBoundary(marktype, grouptype, lineAnchor, markIndex) {
  const xy = (d) => [d.x, d.x, d.x, d.y, d.y, d.y];
  if (!marktype) {
    return xy;
  } else if (marktype === "line" || marktype === "area") {
    return (d) => xy(d.datum);
  } else if (grouptype === "line") {
    return (d) => {
      const items = d.datum.items[markIndex].items;
      return xy(items.length ? items[lineAnchor === "start" ? 0 : items.length - 1] : {
        x: NaN,
        y: NaN
      });
    };
  } else {
    return (d) => {
      const b2 = d.datum.bounds;
      return [b2.x1, (b2.x1 + b2.x2) / 2, b2.x2, b2.y1, (b2.y1 + b2.y2) / 2, b2.y2];
    };
  }
}
const Output$1 = ["x", "y", "opacity", "align", "baseline"];
const Anchors = ["top-left", "left", "bottom-left", "top", "bottom", "top-right", "right", "bottom-right"];
function Label$1(params2) {
  Transform.call(this, null, params2);
}
Label$1.Definition = {
  type: "Label",
  metadata: {
    modifies: true
  },
  params: [{
    name: "size",
    type: "number",
    array: true,
    length: 2,
    required: true
  }, {
    name: "sort",
    type: "compare"
  }, {
    name: "anchor",
    type: "string",
    array: true,
    default: Anchors
  }, {
    name: "offset",
    type: "number",
    array: true,
    default: [1]
  }, {
    name: "padding",
    type: "number",
    default: 0,
    null: true
  }, {
    name: "lineAnchor",
    type: "string",
    values: ["start", "end"],
    default: "end"
  }, {
    name: "markIndex",
    type: "number",
    default: 0
  }, {
    name: "avoidBaseMark",
    type: "boolean",
    default: true
  }, {
    name: "avoidMarks",
    type: "data",
    array: true
  }, {
    name: "method",
    type: "string",
    default: "naive"
  }, {
    name: "as",
    type: "string",
    array: true,
    length: Output$1.length,
    default: Output$1
  }]
};
inherits(Label$1, Transform, {
  transform(_, pulse2) {
    function modp(param2) {
      const p = _[param2];
      return isFunction(p) && pulse2.modified(p.fields);
    }
    const mod = _.modified();
    if (!(mod || pulse2.changed(pulse2.ADD_REM) || modp("sort")))
      return;
    if (!_.size || _.size.length !== 2) {
      error("Size parameter should be specified as a [width, height] array.");
    }
    const as = _.as || Output$1;
    labelLayout(pulse2.materialize(pulse2.SOURCE).source || [], _.size, _.sort, array$3(_.offset == null ? 1 : _.offset), array$3(_.anchor || Anchors), _.avoidMarks || [], _.avoidBaseMark !== false, _.lineAnchor || "end", _.markIndex || 0, _.padding === void 0 ? 0 : _.padding, _.method || "naive").forEach((l) => {
      const t = l.datum;
      t[as[0]] = l.x;
      t[as[1]] = l.y;
      t[as[2]] = l.opacity;
      t[as[3]] = l.align;
      t[as[4]] = l.baseline;
    });
    return pulse2.reflow(mod).modifies(as);
  }
});
const label = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  label: Label$1
}, Symbol.toStringTag, { value: "Module" }));
function partition(data2, groupby) {
  var groups = [], get2 = function(f) {
    return f(t);
  }, map2, i, n, t, k, g;
  if (groupby == null) {
    groups.push(data2);
  } else {
    for (map2 = {}, i = 0, n = data2.length; i < n; ++i) {
      t = data2[i];
      k = groupby.map(get2);
      g = map2[k];
      if (!g) {
        map2[k] = g = [];
        g.dims = k;
        groups.push(g);
      }
      g.push(t);
    }
  }
  return groups;
}
function Loess(params2) {
  Transform.call(this, null, params2);
}
Loess.Definition = {
  "type": "Loess",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "x",
    "type": "field",
    "required": true
  }, {
    "name": "y",
    "type": "field",
    "required": true
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "bandwidth",
    "type": "number",
    "default": 0.3
  }, {
    "name": "as",
    "type": "string",
    "array": true
  }]
};
inherits(Loess, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
    if (!this.value || pulse2.changed() || _.modified()) {
      const source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition(source2, _.groupby), names = (_.groupby || []).map(accessorName), m2 = names.length, as = _.as || [accessorName(_.x), accessorName(_.y)], values2 = [];
      groups.forEach((g) => {
        loess(g, _.x, _.y, _.bandwidth || 0.3).forEach((p) => {
          const t = {};
          for (let i = 0; i < m2; ++i) {
            t[names[i]] = g.dims[i];
          }
          t[as[0]] = p[0];
          t[as[1]] = p[1];
          values2.push(ingest$1(t));
        });
      });
      if (this.value)
        out.rem = this.value;
      this.value = out.add = out.source = values2;
    }
    return out;
  }
});
const Methods = {
  linear,
  log: log$2,
  exp,
  pow,
  quad,
  poly
};
const degreesOfFreedom = (method2, order) => method2 === "poly" ? order : method2 === "quad" ? 2 : 1;
function Regression(params2) {
  Transform.call(this, null, params2);
}
Regression.Definition = {
  "type": "Regression",
  "metadata": {
    "generates": true
  },
  "params": [{
    "name": "x",
    "type": "field",
    "required": true
  }, {
    "name": "y",
    "type": "field",
    "required": true
  }, {
    "name": "groupby",
    "type": "field",
    "array": true
  }, {
    "name": "method",
    "type": "string",
    "default": "linear",
    "values": Object.keys(Methods)
  }, {
    "name": "order",
    "type": "number",
    "default": 3
  }, {
    "name": "extent",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "params",
    "type": "boolean",
    "default": false
  }, {
    "name": "as",
    "type": "string",
    "array": true
  }]
};
inherits(Regression, Transform, {
  transform(_, pulse2) {
    const out = pulse2.fork(pulse2.NO_SOURCE | pulse2.NO_FIELDS);
    if (!this.value || pulse2.changed() || _.modified()) {
      const source2 = pulse2.materialize(pulse2.SOURCE).source, groups = partition(source2, _.groupby), names = (_.groupby || []).map(accessorName), method2 = _.method || "linear", order = _.order || 3, dof = degreesOfFreedom(method2, order), as = _.as || [accessorName(_.x), accessorName(_.y)], fit2 = Methods[method2], values2 = [];
      let domain2 = _.extent;
      if (!has$1(Methods, method2)) {
        error("Invalid regression method: " + method2);
      }
      if (domain2 != null) {
        if (method2 === "log" && domain2[0] <= 0) {
          pulse2.dataflow.warn("Ignoring extent with values <= 0 for log regression.");
          domain2 = null;
        }
      }
      groups.forEach((g) => {
        const n = g.length;
        if (n <= dof) {
          pulse2.dataflow.warn("Skipping regression with more parameters than data points.");
          return;
        }
        const model = fit2(g, _.x, _.y, order);
        if (_.params) {
          values2.push(ingest$1({
            keys: g.dims,
            coef: model.coef,
            rSquared: model.rSquared
          }));
          return;
        }
        const dom = domain2 || extent(g, _.x), add2 = (p) => {
          const t = {};
          for (let i = 0; i < names.length; ++i) {
            t[names[i]] = g.dims[i];
          }
          t[as[0]] = p[0];
          t[as[1]] = p[1];
          values2.push(ingest$1(t));
        };
        if (method2 === "linear") {
          dom.forEach((x2) => add2([x2, model.predict(x2)]));
        } else {
          sampleCurve(model.predict, dom, 25, 200).forEach(add2);
        }
      });
      if (this.value)
        out.rem = this.value;
      this.value = out.add = out.source = values2;
    }
    return out;
  }
});
const reg = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loess: Loess,
  regression: Regression
}, Symbol.toStringTag, { value: "Module" }));
function Voronoi2(params2) {
  Transform.call(this, null, params2);
}
Voronoi2.Definition = {
  "type": "Voronoi",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "x",
    "type": "field",
    "required": true
  }, {
    "name": "y",
    "type": "field",
    "required": true
  }, {
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "extent",
    "type": "array",
    "array": true,
    "length": 2,
    "default": [[-1e5, -1e5], [1e5, 1e5]],
    "content": {
      "type": "number",
      "array": true,
      "length": 2
    }
  }, {
    "name": "as",
    "type": "string",
    "default": "path"
  }]
};
const defaultExtent = [-1e5, -1e5, 1e5, 1e5];
inherits(Voronoi2, Transform, {
  transform(_, pulse2) {
    const as = _.as || "path", data2 = pulse2.source;
    if (!data2 || !data2.length)
      return pulse2;
    let s = _.size;
    s = s ? [0, 0, s[0], s[1]] : (s = _.extent) ? [s[0][0], s[0][1], s[1][0], s[1][1]] : defaultExtent;
    const voronoi2 = this.value = Delaunay.from(data2, _.x, _.y).voronoi(s);
    for (let i = 0, n = data2.length; i < n; ++i) {
      const polygon = voronoi2.cellPolygon(i);
      data2[i][as] = polygon && !isPoint(polygon) ? toPathString(polygon) : null;
    }
    return pulse2.reflow(_.modified()).modifies(as);
  }
});
function toPathString(p) {
  const x2 = p[0][0], y2 = p[0][1];
  let n = p.length - 1;
  for (; p[n][0] === x2 && p[n][1] === y2; --n)
    ;
  return "M" + p.slice(0, n + 1).join("L") + "Z";
}
function isPoint(p) {
  return p.length === 2 && p[0][0] === p[1][0] && p[0][1] === p[1][1];
}
const voronoi = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  voronoi: Voronoi2
}, Symbol.toStringTag, { value: "Module" }));
var cloudRadians = Math.PI / 180, cw = 1 << 11 >> 5, ch = 1 << 11;
function cloud() {
  var size = [256, 256], text2, font2, fontSize2, fontStyle, fontWeight, rotate2, padding2, spiral = archimedeanSpiral, words = [], random2 = Math.random, cloud2 = {};
  cloud2.layout = function() {
    var contextAndRatio = getContext2(canvas()), board = zeroArray((size[0] >> 5) * size[1]), bounds2 = null, n = words.length, i = -1, tags = [], data2 = words.map((d2) => ({
      text: text2(d2),
      font: font2(d2),
      style: fontStyle(d2),
      weight: fontWeight(d2),
      rotate: rotate2(d2),
      size: ~~(fontSize2(d2) + 1e-14),
      padding: padding2(d2),
      xoff: 0,
      yoff: 0,
      x1: 0,
      y1: 0,
      x0: 0,
      y0: 0,
      hasText: false,
      sprite: null,
      datum: d2
    })).sort((a2, b2) => b2.size - a2.size);
    while (++i < n) {
      var d = data2[i];
      d.x = size[0] * (random2() + 0.5) >> 1;
      d.y = size[1] * (random2() + 0.5) >> 1;
      cloudSprite(contextAndRatio, d, data2, i);
      if (d.hasText && place2(board, d, bounds2)) {
        tags.push(d);
        if (bounds2)
          cloudBounds(bounds2, d);
        else
          bounds2 = [{
            x: d.x + d.x0,
            y: d.y + d.y0
          }, {
            x: d.x + d.x1,
            y: d.y + d.y1
          }];
        d.x -= size[0] >> 1;
        d.y -= size[1] >> 1;
      }
    }
    return tags;
  };
  function getContext2(canvas2) {
    canvas2.width = canvas2.height = 1;
    var ratio = Math.sqrt(canvas2.getContext("2d").getImageData(0, 0, 1, 1).data.length >> 2);
    canvas2.width = (cw << 5) / ratio;
    canvas2.height = ch / ratio;
    var context2 = canvas2.getContext("2d");
    context2.fillStyle = context2.strokeStyle = "red";
    context2.textAlign = "center";
    return {
      context: context2,
      ratio
    };
  }
  function place2(board, tag, bounds2) {
    var startX = tag.x, startY = tag.y, maxDelta = Math.sqrt(size[0] * size[0] + size[1] * size[1]), s = spiral(size), dt = random2() < 0.5 ? 1 : -1, t = -dt, dxdy, dx, dy;
    while (dxdy = s(t += dt)) {
      dx = ~~dxdy[0];
      dy = ~~dxdy[1];
      if (Math.min(Math.abs(dx), Math.abs(dy)) >= maxDelta)
        break;
      tag.x = startX + dx;
      tag.y = startY + dy;
      if (tag.x + tag.x0 < 0 || tag.y + tag.y0 < 0 || tag.x + tag.x1 > size[0] || tag.y + tag.y1 > size[1])
        continue;
      if (!bounds2 || !cloudCollide(tag, board, size[0])) {
        if (!bounds2 || collideRects(tag, bounds2)) {
          var sprite = tag.sprite, w2 = tag.width >> 5, sw = size[0] >> 5, lx2 = tag.x - (w2 << 4), sx = lx2 & 127, msx = 32 - sx, h2 = tag.y1 - tag.y0, x2 = (tag.y + tag.y0) * sw + (lx2 >> 5), last;
          for (var j = 0; j < h2; j++) {
            last = 0;
            for (var i = 0; i <= w2; i++) {
              board[x2 + i] |= last << msx | (i < w2 ? (last = sprite[j * w2 + i]) >>> sx : 0);
            }
            x2 += sw;
          }
          tag.sprite = null;
          return true;
        }
      }
    }
    return false;
  }
  cloud2.words = function(_) {
    if (arguments.length) {
      words = _;
      return cloud2;
    } else {
      return words;
    }
  };
  cloud2.size = function(_) {
    if (arguments.length) {
      size = [+_[0], +_[1]];
      return cloud2;
    } else {
      return size;
    }
  };
  cloud2.font = function(_) {
    if (arguments.length) {
      font2 = functor(_);
      return cloud2;
    } else {
      return font2;
    }
  };
  cloud2.fontStyle = function(_) {
    if (arguments.length) {
      fontStyle = functor(_);
      return cloud2;
    } else {
      return fontStyle;
    }
  };
  cloud2.fontWeight = function(_) {
    if (arguments.length) {
      fontWeight = functor(_);
      return cloud2;
    } else {
      return fontWeight;
    }
  };
  cloud2.rotate = function(_) {
    if (arguments.length) {
      rotate2 = functor(_);
      return cloud2;
    } else {
      return rotate2;
    }
  };
  cloud2.text = function(_) {
    if (arguments.length) {
      text2 = functor(_);
      return cloud2;
    } else {
      return text2;
    }
  };
  cloud2.spiral = function(_) {
    if (arguments.length) {
      spiral = spirals[_] || _;
      return cloud2;
    } else {
      return spiral;
    }
  };
  cloud2.fontSize = function(_) {
    if (arguments.length) {
      fontSize2 = functor(_);
      return cloud2;
    } else {
      return fontSize2;
    }
  };
  cloud2.padding = function(_) {
    if (arguments.length) {
      padding2 = functor(_);
      return cloud2;
    } else {
      return padding2;
    }
  };
  cloud2.random = function(_) {
    if (arguments.length) {
      random2 = _;
      return cloud2;
    } else {
      return random2;
    }
  };
  return cloud2;
}
function cloudSprite(contextAndRatio, d, data2, di) {
  if (d.sprite)
    return;
  var c2 = contextAndRatio.context, ratio = contextAndRatio.ratio;
  c2.clearRect(0, 0, (cw << 5) / ratio, ch / ratio);
  var x2 = 0, y2 = 0, maxh = 0, n = data2.length, w2, w32, h2, i, j;
  --di;
  while (++di < n) {
    d = data2[di];
    c2.save();
    c2.font = d.style + " " + d.weight + " " + ~~((d.size + 1) / ratio) + "px " + d.font;
    w2 = c2.measureText(d.text + "m").width * ratio;
    h2 = d.size << 1;
    if (d.rotate) {
      var sr = Math.sin(d.rotate * cloudRadians), cr2 = Math.cos(d.rotate * cloudRadians), wcr = w2 * cr2, wsr = w2 * sr, hcr = h2 * cr2, hsr = h2 * sr;
      w2 = Math.max(Math.abs(wcr + hsr), Math.abs(wcr - hsr)) + 31 >> 5 << 5;
      h2 = ~~Math.max(Math.abs(wsr + hcr), Math.abs(wsr - hcr));
    } else {
      w2 = w2 + 31 >> 5 << 5;
    }
    if (h2 > maxh)
      maxh = h2;
    if (x2 + w2 >= cw << 5) {
      x2 = 0;
      y2 += maxh;
      maxh = 0;
    }
    if (y2 + h2 >= ch)
      break;
    c2.translate((x2 + (w2 >> 1)) / ratio, (y2 + (h2 >> 1)) / ratio);
    if (d.rotate)
      c2.rotate(d.rotate * cloudRadians);
    c2.fillText(d.text, 0, 0);
    if (d.padding) {
      c2.lineWidth = 2 * d.padding;
      c2.strokeText(d.text, 0, 0);
    }
    c2.restore();
    d.width = w2;
    d.height = h2;
    d.xoff = x2;
    d.yoff = y2;
    d.x1 = w2 >> 1;
    d.y1 = h2 >> 1;
    d.x0 = -d.x1;
    d.y0 = -d.y1;
    d.hasText = true;
    x2 += w2;
  }
  var pixels = c2.getImageData(0, 0, (cw << 5) / ratio, ch / ratio).data, sprite = [];
  while (--di >= 0) {
    d = data2[di];
    if (!d.hasText)
      continue;
    w2 = d.width;
    w32 = w2 >> 5;
    h2 = d.y1 - d.y0;
    for (i = 0; i < h2 * w32; i++)
      sprite[i] = 0;
    x2 = d.xoff;
    if (x2 == null)
      return;
    y2 = d.yoff;
    var seen = 0, seenRow = -1;
    for (j = 0; j < h2; j++) {
      for (i = 0; i < w2; i++) {
        var k = w32 * j + (i >> 5), m2 = pixels[(y2 + j) * (cw << 5) + (x2 + i) << 2] ? 1 << 31 - i % 32 : 0;
        sprite[k] |= m2;
        seen |= m2;
      }
      if (seen)
        seenRow = j;
      else {
        d.y0++;
        h2--;
        j--;
        y2++;
      }
    }
    d.y1 = d.y0 + seenRow;
    d.sprite = sprite.slice(0, (d.y1 - d.y0) * w32);
  }
}
function cloudCollide(tag, board, sw) {
  sw >>= 5;
  var sprite = tag.sprite, w2 = tag.width >> 5, lx2 = tag.x - (w2 << 4), sx = lx2 & 127, msx = 32 - sx, h2 = tag.y1 - tag.y0, x2 = (tag.y + tag.y0) * sw + (lx2 >> 5), last;
  for (var j = 0; j < h2; j++) {
    last = 0;
    for (var i = 0; i <= w2; i++) {
      if ((last << msx | (i < w2 ? (last = sprite[j * w2 + i]) >>> sx : 0)) & board[x2 + i])
        return true;
    }
    x2 += sw;
  }
  return false;
}
function cloudBounds(bounds2, d) {
  var b0 = bounds2[0], b1 = bounds2[1];
  if (d.x + d.x0 < b0.x)
    b0.x = d.x + d.x0;
  if (d.y + d.y0 < b0.y)
    b0.y = d.y + d.y0;
  if (d.x + d.x1 > b1.x)
    b1.x = d.x + d.x1;
  if (d.y + d.y1 > b1.y)
    b1.y = d.y + d.y1;
}
function collideRects(a2, b2) {
  return a2.x + a2.x1 > b2[0].x && a2.x + a2.x0 < b2[1].x && a2.y + a2.y1 > b2[0].y && a2.y + a2.y0 < b2[1].y;
}
function archimedeanSpiral(size) {
  var e = size[0] / size[1];
  return function(t) {
    return [e * (t *= 0.1) * Math.cos(t), t * Math.sin(t)];
  };
}
function rectangularSpiral(size) {
  var dy = 4, dx = dy * size[0] / size[1], x2 = 0, y2 = 0;
  return function(t) {
    var sign2 = t < 0 ? -1 : 1;
    switch (Math.sqrt(1 + 4 * sign2 * t) - sign2 & 3) {
      case 0:
        x2 += dx;
        break;
      case 1:
        y2 += dy;
        break;
      case 2:
        x2 -= dx;
        break;
      default:
        y2 -= dy;
        break;
    }
    return [x2, y2];
  };
}
function zeroArray(n) {
  var a2 = [], i = -1;
  while (++i < n)
    a2[i] = 0;
  return a2;
}
function functor(d) {
  return typeof d === "function" ? d : function() {
    return d;
  };
}
var spirals = {
  archimedean: archimedeanSpiral,
  rectangular: rectangularSpiral
};
const Output = ["x", "y", "font", "fontSize", "fontStyle", "fontWeight", "angle"];
const Params$1 = ["text", "font", "rotate", "fontSize", "fontStyle", "fontWeight"];
function Wordcloud(params2) {
  Transform.call(this, cloud(), params2);
}
Wordcloud.Definition = {
  "type": "Wordcloud",
  "metadata": {
    "modifies": true
  },
  "params": [{
    "name": "size",
    "type": "number",
    "array": true,
    "length": 2
  }, {
    "name": "font",
    "type": "string",
    "expr": true,
    "default": "sans-serif"
  }, {
    "name": "fontStyle",
    "type": "string",
    "expr": true,
    "default": "normal"
  }, {
    "name": "fontWeight",
    "type": "string",
    "expr": true,
    "default": "normal"
  }, {
    "name": "fontSize",
    "type": "number",
    "expr": true,
    "default": 14
  }, {
    "name": "fontSizeRange",
    "type": "number",
    "array": "nullable",
    "default": [10, 50]
  }, {
    "name": "rotate",
    "type": "number",
    "expr": true,
    "default": 0
  }, {
    "name": "text",
    "type": "field"
  }, {
    "name": "spiral",
    "type": "string",
    "values": ["archimedean", "rectangular"]
  }, {
    "name": "padding",
    "type": "number",
    "expr": true
  }, {
    "name": "as",
    "type": "string",
    "array": true,
    "length": 7,
    "default": Output
  }]
};
inherits(Wordcloud, Transform, {
  transform(_, pulse2) {
    if (_.size && !(_.size[0] && _.size[1])) {
      error("Wordcloud size dimensions must be non-zero.");
    }
    function modp(param2) {
      const p = _[param2];
      return isFunction(p) && pulse2.modified(p.fields);
    }
    const mod = _.modified();
    if (!(mod || pulse2.changed(pulse2.ADD_REM) || Params$1.some(modp)))
      return;
    const data2 = pulse2.materialize(pulse2.SOURCE).source, layout = this.value, as = _.as || Output;
    let fontSize2 = _.fontSize || 14, range2;
    isFunction(fontSize2) ? range2 = _.fontSizeRange : fontSize2 = constant(fontSize2);
    if (range2) {
      const fsize = fontSize2, sizeScale = scale$5("sqrt")().domain(extent(data2, fsize)).range(range2);
      fontSize2 = (x2) => sizeScale(fsize(x2));
    }
    data2.forEach((t) => {
      t[as[0]] = NaN;
      t[as[1]] = NaN;
      t[as[3]] = 0;
    });
    const words = layout.words(data2).text(_.text).size(_.size || [500, 500]).padding(_.padding || 1).spiral(_.spiral || "archimedean").rotate(_.rotate || 0).font(_.font || "sans-serif").fontStyle(_.fontStyle || "normal").fontWeight(_.fontWeight || "normal").fontSize(fontSize2).random(random).layout();
    const size = layout.size(), dx = size[0] >> 1, dy = size[1] >> 1, n = words.length;
    for (let i = 0, w2, t; i < n; ++i) {
      w2 = words[i];
      t = w2.datum;
      t[as[0]] = w2.x + dx;
      t[as[1]] = w2.y + dy;
      t[as[2]] = w2.font;
      t[as[3]] = w2.size;
      t[as[4]] = w2.style;
      t[as[5]] = w2.weight;
      t[as[6]] = w2.rotate;
    }
    return pulse2.reflow(mod).modifies(as);
  }
});
const wordcloud = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  wordcloud: Wordcloud
}, Symbol.toStringTag, { value: "Module" }));
const array8 = (n) => new Uint8Array(n);
const array16 = (n) => new Uint16Array(n);
const array32 = (n) => new Uint32Array(n);
function Bitmaps() {
  let width2 = 8, data2 = [], seen = array32(0), curr = array$2(0, width2), prev = array$2(0, width2);
  return {
    data: () => data2,
    seen: () => seen = lengthen(seen, data2.length),
    add(array2) {
      for (let i = 0, j = data2.length, n = array2.length, t; i < n; ++i) {
        t = array2[i];
        t._index = j++;
        data2.push(t);
      }
    },
    remove(num, map2) {
      const n = data2.length, copy2 = Array(n - num), reindex = data2;
      let t, i, j;
      for (i = 0; !map2[i] && i < n; ++i) {
        copy2[i] = data2[i];
        reindex[i] = i;
      }
      for (j = i; i < n; ++i) {
        t = data2[i];
        if (!map2[i]) {
          reindex[i] = j;
          curr[j] = curr[i];
          prev[j] = prev[i];
          copy2[j] = t;
          t._index = j++;
        } else {
          reindex[i] = -1;
        }
        curr[i] = 0;
      }
      data2 = copy2;
      return reindex;
    },
    size: () => data2.length,
    curr: () => curr,
    prev: () => prev,
    reset: (k) => prev[k] = curr[k],
    all: () => width2 < 257 ? 255 : width2 < 65537 ? 65535 : 4294967295,
    set(k, one2) {
      curr[k] |= one2;
    },
    clear(k, one2) {
      curr[k] &= ~one2;
    },
    resize(n, m2) {
      const k = curr.length;
      if (n > k || m2 > width2) {
        width2 = Math.max(m2, width2);
        curr = array$2(n, width2, curr);
        prev = array$2(n, width2);
      }
    }
  };
}
function lengthen(array2, length2, copy2) {
  if (array2.length >= length2)
    return array2;
  copy2 = copy2 || new array2.constructor(length2);
  copy2.set(array2);
  return copy2;
}
function array$2(n, m2, array2) {
  const copy2 = (m2 < 257 ? array8 : m2 < 65537 ? array16 : array32)(n);
  if (array2)
    copy2.set(array2);
  return copy2;
}
function Dimension(index2, i, query) {
  const bit = 1 << i;
  return {
    one: bit,
    zero: ~bit,
    range: query.slice(),
    bisect: index2.bisect,
    index: index2.index,
    size: index2.size,
    onAdd(added, curr) {
      const dim = this, range2 = dim.bisect(dim.range, added.value), idx = added.index, lo = range2[0], hi = range2[1], n1 = idx.length;
      let i2;
      for (i2 = 0; i2 < lo; ++i2)
        curr[idx[i2]] |= bit;
      for (i2 = hi; i2 < n1; ++i2)
        curr[idx[i2]] |= bit;
      return dim;
    }
  };
}
function SortedIndex() {
  let index2 = array32(0), value2 = [], size = 0;
  function insert2(key2, data2, base2) {
    if (!data2.length)
      return [];
    const n0 = size, n1 = data2.length, addi = array32(n1);
    let addv = Array(n1), oldv, oldi, i;
    for (i = 0; i < n1; ++i) {
      addv[i] = key2(data2[i]);
      addi[i] = i;
    }
    addv = sort(addv, addi);
    if (n0) {
      oldv = value2;
      oldi = index2;
      value2 = Array(n0 + n1);
      index2 = array32(n0 + n1);
      merge$2(base2, oldv, oldi, n0, addv, addi, n1, value2, index2);
    } else {
      if (base2 > 0)
        for (i = 0; i < n1; ++i) {
          addi[i] += base2;
        }
      value2 = addv;
      index2 = addi;
    }
    size = n0 + n1;
    return {
      index: addi,
      value: addv
    };
  }
  function remove2(num, map2) {
    const n = size;
    let idx, i, j;
    for (i = 0; !map2[index2[i]] && i < n; ++i)
      ;
    for (j = i; i < n; ++i) {
      if (!map2[idx = index2[i]]) {
        index2[j] = idx;
        value2[j] = value2[i];
        ++j;
      }
    }
    size = n - num;
  }
  function reindex(map2) {
    for (let i = 0, n = size; i < n; ++i) {
      index2[i] = map2[index2[i]];
    }
  }
  function bisect2(range2, array2) {
    let n;
    if (array2) {
      n = array2.length;
    } else {
      array2 = value2;
      n = size;
    }
    return [bisectLeft$1(array2, range2[0], 0, n), bisectRight$1(array2, range2[1], 0, n)];
  }
  return {
    insert: insert2,
    remove: remove2,
    bisect: bisect2,
    reindex,
    index: () => index2,
    size: () => size
  };
}
function sort(values2, index2) {
  values2.sort.call(index2, (a2, b2) => {
    const x2 = values2[a2], y2 = values2[b2];
    return x2 < y2 ? -1 : x2 > y2 ? 1 : 0;
  });
  return permute(values2, index2);
}
function merge$2(base2, value0, index0, n0, value1, index1, n1, value2, index2) {
  let i0 = 0, i1 = 0, i;
  for (i = 0; i0 < n0 && i1 < n1; ++i) {
    if (value0[i0] < value1[i1]) {
      value2[i] = value0[i0];
      index2[i] = index0[i0++];
    } else {
      value2[i] = value1[i1];
      index2[i] = index1[i1++] + base2;
    }
  }
  for (; i0 < n0; ++i0, ++i) {
    value2[i] = value0[i0];
    index2[i] = index0[i0];
  }
  for (; i1 < n1; ++i1, ++i) {
    value2[i] = value1[i1];
    index2[i] = index1[i1] + base2;
  }
}
function CrossFilter(params2) {
  Transform.call(this, Bitmaps(), params2);
  this._indices = null;
  this._dims = null;
}
CrossFilter.Definition = {
  "type": "CrossFilter",
  "metadata": {},
  "params": [{
    "name": "fields",
    "type": "field",
    "array": true,
    "required": true
  }, {
    "name": "query",
    "type": "array",
    "array": true,
    "required": true,
    "content": {
      "type": "number",
      "array": true,
      "length": 2
    }
  }]
};
inherits(CrossFilter, Transform, {
  transform(_, pulse2) {
    if (!this._dims) {
      return this.init(_, pulse2);
    } else {
      var init2 = _.modified("fields") || _.fields.some((f) => pulse2.modified(f.fields));
      return init2 ? this.reinit(_, pulse2) : this.eval(_, pulse2);
    }
  },
  init(_, pulse2) {
    const fields = _.fields, query = _.query, indices = this._indices = {}, dims = this._dims = [], m2 = query.length;
    let i = 0, key2, index2;
    for (; i < m2; ++i) {
      key2 = fields[i].fname;
      index2 = indices[key2] || (indices[key2] = SortedIndex());
      dims.push(Dimension(index2, i, query[i]));
    }
    return this.eval(_, pulse2);
  },
  reinit(_, pulse2) {
    const output2 = pulse2.materialize().fork(), fields = _.fields, query = _.query, indices = this._indices, dims = this._dims, bits = this.value, curr = bits.curr(), prev = bits.prev(), all = bits.all(), out = output2.rem = output2.add, mod = output2.mod, m2 = query.length, adds = {};
    let add2, index2, key2, mods, remMap, modMap, i, n, f;
    prev.set(curr);
    if (pulse2.rem.length) {
      remMap = this.remove(_, pulse2, output2);
    }
    if (pulse2.add.length) {
      bits.add(pulse2.add);
    }
    if (pulse2.mod.length) {
      modMap = {};
      for (mods = pulse2.mod, i = 0, n = mods.length; i < n; ++i) {
        modMap[mods[i]._index] = 1;
      }
    }
    for (i = 0; i < m2; ++i) {
      f = fields[i];
      if (!dims[i] || _.modified("fields", i) || pulse2.modified(f.fields)) {
        key2 = f.fname;
        if (!(add2 = adds[key2])) {
          indices[key2] = index2 = SortedIndex();
          adds[key2] = add2 = index2.insert(f, pulse2.source, 0);
        }
        dims[i] = Dimension(index2, i, query[i]).onAdd(add2, curr);
      }
    }
    for (i = 0, n = bits.data().length; i < n; ++i) {
      if (remMap[i]) {
        continue;
      } else if (prev[i] !== curr[i]) {
        out.push(i);
      } else if (modMap[i] && curr[i] !== all) {
        mod.push(i);
      }
    }
    bits.mask = (1 << m2) - 1;
    return output2;
  },
  eval(_, pulse2) {
    const output2 = pulse2.materialize().fork(), m2 = this._dims.length;
    let mask = 0;
    if (pulse2.rem.length) {
      this.remove(_, pulse2, output2);
      mask |= (1 << m2) - 1;
    }
    if (_.modified("query") && !_.modified("fields")) {
      mask |= this.update(_, pulse2, output2);
    }
    if (pulse2.add.length) {
      this.insert(_, pulse2, output2);
      mask |= (1 << m2) - 1;
    }
    if (pulse2.mod.length) {
      this.modify(pulse2, output2);
      mask |= (1 << m2) - 1;
    }
    this.value.mask = mask;
    return output2;
  },
  insert(_, pulse2, output2) {
    const tuples = pulse2.add, bits = this.value, dims = this._dims, indices = this._indices, fields = _.fields, adds = {}, out = output2.add, n = bits.size() + tuples.length, m2 = dims.length;
    let k = bits.size(), j, key2, add2;
    bits.resize(n, m2);
    bits.add(tuples);
    const curr = bits.curr(), prev = bits.prev(), all = bits.all();
    for (j = 0; j < m2; ++j) {
      key2 = fields[j].fname;
      add2 = adds[key2] || (adds[key2] = indices[key2].insert(fields[j], tuples, k));
      dims[j].onAdd(add2, curr);
    }
    for (; k < n; ++k) {
      prev[k] = all;
      if (curr[k] !== all)
        out.push(k);
    }
  },
  modify(pulse2, output2) {
    const out = output2.mod, bits = this.value, curr = bits.curr(), all = bits.all(), tuples = pulse2.mod;
    let i, n, k;
    for (i = 0, n = tuples.length; i < n; ++i) {
      k = tuples[i]._index;
      if (curr[k] !== all)
        out.push(k);
    }
  },
  remove(_, pulse2, output2) {
    const indices = this._indices, bits = this.value, curr = bits.curr(), prev = bits.prev(), all = bits.all(), map2 = {}, out = output2.rem, tuples = pulse2.rem;
    let i, n, k, f;
    for (i = 0, n = tuples.length; i < n; ++i) {
      k = tuples[i]._index;
      map2[k] = 1;
      prev[k] = f = curr[k];
      curr[k] = all;
      if (f !== all)
        out.push(k);
    }
    for (k in indices) {
      indices[k].remove(n, map2);
    }
    this.reindex(pulse2, n, map2);
    return map2;
  },
  // reindex filters and indices after propagation completes
  reindex(pulse2, num, map2) {
    const indices = this._indices, bits = this.value;
    pulse2.runAfter(() => {
      const indexMap = bits.remove(num, map2);
      for (const key2 in indices)
        indices[key2].reindex(indexMap);
    });
  },
  update(_, pulse2, output2) {
    const dims = this._dims, query = _.query, stamp = pulse2.stamp, m2 = dims.length;
    let mask = 0, i, q;
    output2.filters = 0;
    for (q = 0; q < m2; ++q) {
      if (_.modified("query", q)) {
        i = q;
        ++mask;
      }
    }
    if (mask === 1) {
      mask = dims[i].one;
      this.incrementOne(dims[i], query[i], output2.add, output2.rem);
    } else {
      for (q = 0, mask = 0; q < m2; ++q) {
        if (!_.modified("query", q))
          continue;
        mask |= dims[q].one;
        this.incrementAll(dims[q], query[q], stamp, output2.add);
        output2.rem = output2.add;
      }
    }
    return mask;
  },
  incrementAll(dim, query, stamp, out) {
    const bits = this.value, seen = bits.seen(), curr = bits.curr(), prev = bits.prev(), index2 = dim.index(), old = dim.bisect(dim.range), range2 = dim.bisect(query), lo1 = range2[0], hi1 = range2[1], lo0 = old[0], hi0 = old[1], one2 = dim.one;
    let i, j, k;
    if (lo1 < lo0) {
      for (i = lo1, j = Math.min(lo0, hi1); i < j; ++i) {
        k = index2[i];
        if (seen[k] !== stamp) {
          prev[k] = curr[k];
          seen[k] = stamp;
          out.push(k);
        }
        curr[k] ^= one2;
      }
    } else if (lo1 > lo0) {
      for (i = lo0, j = Math.min(lo1, hi0); i < j; ++i) {
        k = index2[i];
        if (seen[k] !== stamp) {
          prev[k] = curr[k];
          seen[k] = stamp;
          out.push(k);
        }
        curr[k] ^= one2;
      }
    }
    if (hi1 > hi0) {
      for (i = Math.max(lo1, hi0), j = hi1; i < j; ++i) {
        k = index2[i];
        if (seen[k] !== stamp) {
          prev[k] = curr[k];
          seen[k] = stamp;
          out.push(k);
        }
        curr[k] ^= one2;
      }
    } else if (hi1 < hi0) {
      for (i = Math.max(lo0, hi1), j = hi0; i < j; ++i) {
        k = index2[i];
        if (seen[k] !== stamp) {
          prev[k] = curr[k];
          seen[k] = stamp;
          out.push(k);
        }
        curr[k] ^= one2;
      }
    }
    dim.range = query.slice();
  },
  incrementOne(dim, query, add2, rem2) {
    const bits = this.value, curr = bits.curr(), index2 = dim.index(), old = dim.bisect(dim.range), range2 = dim.bisect(query), lo1 = range2[0], hi1 = range2[1], lo0 = old[0], hi0 = old[1], one2 = dim.one;
    let i, j, k;
    if (lo1 < lo0) {
      for (i = lo1, j = Math.min(lo0, hi1); i < j; ++i) {
        k = index2[i];
        curr[k] ^= one2;
        add2.push(k);
      }
    } else if (lo1 > lo0) {
      for (i = lo0, j = Math.min(lo1, hi0); i < j; ++i) {
        k = index2[i];
        curr[k] ^= one2;
        rem2.push(k);
      }
    }
    if (hi1 > hi0) {
      for (i = Math.max(lo1, hi0), j = hi1; i < j; ++i) {
        k = index2[i];
        curr[k] ^= one2;
        add2.push(k);
      }
    } else if (hi1 < hi0) {
      for (i = Math.max(lo0, hi1), j = hi0; i < j; ++i) {
        k = index2[i];
        curr[k] ^= one2;
        rem2.push(k);
      }
    }
    dim.range = query.slice();
  }
});
function ResolveFilter(params2) {
  Transform.call(this, null, params2);
}
ResolveFilter.Definition = {
  "type": "ResolveFilter",
  "metadata": {},
  "params": [{
    "name": "ignore",
    "type": "number",
    "required": true,
    "description": "A bit mask indicating which filters to ignore."
  }, {
    "name": "filter",
    "type": "object",
    "required": true,
    "description": "Per-tuple filter bitmaps from a CrossFilter transform."
  }]
};
inherits(ResolveFilter, Transform, {
  transform(_, pulse2) {
    const ignore = ~(_.ignore || 0), bitmap = _.filter, mask = bitmap.mask;
    if ((mask & ignore) === 0)
      return pulse2.StopPropagation;
    const output2 = pulse2.fork(pulse2.ALL), data2 = bitmap.data(), curr = bitmap.curr(), prev = bitmap.prev(), pass = (k) => !(curr[k] & ignore) ? data2[k] : null;
    output2.filter(output2.MOD, pass);
    if (!(mask & mask - 1)) {
      output2.filter(output2.ADD, pass);
      output2.filter(output2.REM, (k) => (curr[k] & ignore) === mask ? data2[k] : null);
    } else {
      output2.filter(output2.ADD, (k) => {
        const c2 = curr[k] & ignore, f = !c2 && c2 ^ prev[k] & ignore;
        return f ? data2[k] : null;
      });
      output2.filter(output2.REM, (k) => {
        const c2 = curr[k] & ignore, f = c2 && !(c2 ^ (c2 ^ prev[k] & ignore));
        return f ? data2[k] : null;
      });
    }
    return output2.filter(output2.SOURCE, (t) => pass(t._index));
  }
});
const xf = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  crossfilter: CrossFilter,
  resolvefilter: ResolveFilter
}, Symbol.toStringTag, { value: "Module" }));
const RawCode$1 = "RawCode";
const Literal$1 = "Literal";
const Property$1 = "Property";
const Identifier$1 = "Identifier";
const ArrayExpression$1 = "ArrayExpression";
const BinaryExpression$1 = "BinaryExpression";
const CallExpression$1 = "CallExpression";
const ConditionalExpression$1 = "ConditionalExpression";
const LogicalExpression$1 = "LogicalExpression";
const MemberExpression$1 = "MemberExpression";
const ObjectExpression$1 = "ObjectExpression";
const UnaryExpression$1 = "UnaryExpression";
function ASTNode$1(type2) {
  this.type = type2;
}
ASTNode$1.prototype.visit = function(visitor) {
  let c2, i, n;
  if (visitor(this))
    return 1;
  for (c2 = children$1(this), i = 0, n = c2.length; i < n; ++i) {
    if (c2[i].visit(visitor))
      return 1;
  }
};
function children$1(node) {
  switch (node.type) {
    case ArrayExpression$1:
      return node.elements;
    case BinaryExpression$1:
    case LogicalExpression$1:
      return [node.left, node.right];
    case CallExpression$1:
      return [node.callee].concat(node.arguments);
    case ConditionalExpression$1:
      return [node.test, node.consequent, node.alternate];
    case MemberExpression$1:
      return [node.object, node.property];
    case ObjectExpression$1:
      return node.properties;
    case Property$1:
      return [node.key, node.value];
    case UnaryExpression$1:
      return [node.argument];
    case Identifier$1:
    case Literal$1:
    case RawCode$1:
    default:
      return [];
  }
}
var TokenName$1, source$1, index$1, length$1, lookahead$1;
var TokenBooleanLiteral$1 = 1, TokenEOF$1 = 2, TokenIdentifier$1 = 3, TokenKeyword$1 = 4, TokenNullLiteral$1 = 5, TokenNumericLiteral$1 = 6, TokenPunctuator$1 = 7, TokenStringLiteral$1 = 8, TokenRegularExpression$1 = 9;
TokenName$1 = {};
TokenName$1[TokenBooleanLiteral$1] = "Boolean";
TokenName$1[TokenEOF$1] = "<end>";
TokenName$1[TokenIdentifier$1] = "Identifier";
TokenName$1[TokenKeyword$1] = "Keyword";
TokenName$1[TokenNullLiteral$1] = "Null";
TokenName$1[TokenNumericLiteral$1] = "Numeric";
TokenName$1[TokenPunctuator$1] = "Punctuator";
TokenName$1[TokenStringLiteral$1] = "String";
TokenName$1[TokenRegularExpression$1] = "RegularExpression";
var SyntaxArrayExpression$1 = "ArrayExpression", SyntaxBinaryExpression$1 = "BinaryExpression", SyntaxCallExpression$1 = "CallExpression", SyntaxConditionalExpression$1 = "ConditionalExpression", SyntaxIdentifier$1 = "Identifier", SyntaxLiteral$1 = "Literal", SyntaxLogicalExpression$1 = "LogicalExpression", SyntaxMemberExpression$1 = "MemberExpression", SyntaxObjectExpression$1 = "ObjectExpression", SyntaxProperty$1 = "Property", SyntaxUnaryExpression$1 = "UnaryExpression";
var MessageUnexpectedToken$1 = "Unexpected token %0", MessageUnexpectedNumber$1 = "Unexpected number", MessageUnexpectedString$1 = "Unexpected string", MessageUnexpectedIdentifier$1 = "Unexpected identifier", MessageUnexpectedReserved$1 = "Unexpected reserved word", MessageUnexpectedEOS$1 = "Unexpected end of input", MessageInvalidRegExp$1 = "Invalid regular expression", MessageUnterminatedRegExp$1 = "Invalid regular expression: missing /", MessageStrictOctalLiteral$1 = "Octal literals are not allowed in strict mode.", MessageStrictDuplicateProperty$1 = "Duplicate data property in object literal not allowed in strict mode";
var ILLEGAL$2 = "ILLEGAL", DISABLED$1 = "Disabled.";
var RegexNonAsciiIdentifierStart$1 = new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0800-\\u0815\\u081A\\u0824\\u0828\\u0840-\\u0858\\u08A0-\\u08B2\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971-\\u0980\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0CF1\\u0CF2\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D\\u0D4E\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC-\\u0EDF\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8C\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1A20-\\u1A54\\u1AA7\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1BBA-\\u1BE5\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1CE9-\\u1CEC\\u1CEE-\\u1CF1\\u1CF5\\u1CF6\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u209C\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CEE\\u2CF2\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA66E\\uA67F-\\uA69D\\uA6A0-\\uA6EF\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA8F2-\\uA8F7\\uA8FB\\uA90A-\\uA925\\uA930-\\uA946\\uA960-\\uA97C\\uA984-\\uA9B2\\uA9CF\\uA9E0-\\uA9E4\\uA9E6-\\uA9EF\\uA9FA-\\uA9FE\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAA60-\\uAA76\\uAA7A\\uAA7E-\\uAAAF\\uAAB1\\uAAB5\\uAAB6\\uAAB9-\\uAABD\\uAAC0\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEA\\uAAF2-\\uAAF4\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABE2\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"), RegexNonAsciiIdentifierPart$1 = new RegExp("[\\xAA\\xB5\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0300-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u037F\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u0483-\\u0487\\u048A-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0610-\\u061A\\u0620-\\u0669\\u066E-\\u06D3\\u06D5-\\u06DC\\u06DF-\\u06E8\\u06EA-\\u06FC\\u06FF\\u0710-\\u074A\\u074D-\\u07B1\\u07C0-\\u07F5\\u07FA\\u0800-\\u082D\\u0840-\\u085B\\u08A0-\\u08B2\\u08E4-\\u0963\\u0966-\\u096F\\u0971-\\u0983\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7\\u09C8\\u09CB-\\u09CE\\u09D7\\u09DC\\u09DD\\u09DF-\\u09E3\\u09E6-\\u09F1\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A59-\\u0A5C\\u0A5E\\u0A66-\\u0A75\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B44\\u0B47\\u0B48\\u0B4B-\\u0B4D\\u0B56\\u0B57\\u0B5C\\u0B5D\\u0B5F-\\u0B63\\u0B66-\\u0B6F\\u0B71\\u0B82\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C00-\\u0C03\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C58\\u0C59\\u0C60-\\u0C63\\u0C66-\\u0C6F\\u0C81-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5\\u0CD6\\u0CDE\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1\\u0CF2\\u0D01-\\u0D03\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D-\\u0D44\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D57\\u0D60-\\u0D63\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D82\\u0D83\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDF\\u0DE6-\\u0DEF\\u0DF2\\u0DF3\\u0E01-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB9\\u0EBB-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDC-\\u0EDF\\u0F00\\u0F18\\u0F19\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F39\\u0F3E-\\u0F47\\u0F49-\\u0F6C\\u0F71-\\u0F84\\u0F86-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10A0-\\u10C5\\u10C7\\u10CD\\u10D0-\\u10FA\\u10FC-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u167F\\u1681-\\u169A\\u16A0-\\u16EA\\u16EE-\\u16F8\\u1700-\\u170C\\u170E-\\u1714\\u1720-\\u1734\\u1740-\\u1753\\u1760-\\u176C\\u176E-\\u1770\\u1772\\u1773\\u1780-\\u17D3\\u17D7\\u17DC\\u17DD\\u17E0-\\u17E9\\u180B-\\u180D\\u1810-\\u1819\\u1820-\\u1877\\u1880-\\u18AA\\u18B0-\\u18F5\\u1900-\\u191E\\u1920-\\u192B\\u1930-\\u193B\\u1946-\\u196D\\u1970-\\u1974\\u1980-\\u19AB\\u19B0-\\u19C9\\u19D0-\\u19D9\\u1A00-\\u1A1B\\u1A20-\\u1A5E\\u1A60-\\u1A7C\\u1A7F-\\u1A89\\u1A90-\\u1A99\\u1AA7\\u1AB0-\\u1ABD\\u1B00-\\u1B4B\\u1B50-\\u1B59\\u1B6B-\\u1B73\\u1B80-\\u1BF3\\u1C00-\\u1C37\\u1C40-\\u1C49\\u1C4D-\\u1C7D\\u1CD0-\\u1CD2\\u1CD4-\\u1CF6\\u1CF8\\u1CF9\\u1D00-\\u1DF5\\u1DFC-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u200C\\u200D\\u203F\\u2040\\u2054\\u2071\\u207F\\u2090-\\u209C\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2160-\\u2188\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2CE4\\u2CEB-\\u2CF3\\u2D00-\\u2D25\\u2D27\\u2D2D\\u2D30-\\u2D67\\u2D6F\\u2D7F-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2DE0-\\u2DFF\\u2E2F\\u3005-\\u3007\\u3021-\\u302F\\u3031-\\u3035\\u3038-\\u303C\\u3041-\\u3096\\u3099\\u309A\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31BA\\u31F0-\\u31FF\\u3400-\\u4DB5\\u4E00-\\u9FCC\\uA000-\\uA48C\\uA4D0-\\uA4FD\\uA500-\\uA60C\\uA610-\\uA62B\\uA640-\\uA66F\\uA674-\\uA67D\\uA67F-\\uA69D\\uA69F-\\uA6F1\\uA717-\\uA71F\\uA722-\\uA788\\uA78B-\\uA78E\\uA790-\\uA7AD\\uA7B0\\uA7B1\\uA7F7-\\uA827\\uA840-\\uA873\\uA880-\\uA8C4\\uA8D0-\\uA8D9\\uA8E0-\\uA8F7\\uA8FB\\uA900-\\uA92D\\uA930-\\uA953\\uA960-\\uA97C\\uA980-\\uA9C0\\uA9CF-\\uA9D9\\uA9E0-\\uA9FE\\uAA00-\\uAA36\\uAA40-\\uAA4D\\uAA50-\\uAA59\\uAA60-\\uAA76\\uAA7A-\\uAAC2\\uAADB-\\uAADD\\uAAE0-\\uAAEF\\uAAF2-\\uAAF6\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAB30-\\uAB5A\\uAB5C-\\uAB5F\\uAB64\\uAB65\\uABC0-\\uABEA\\uABEC\\uABED\\uABF0-\\uABF9\\uAC00-\\uD7A3\\uD7B0-\\uD7C6\\uD7CB-\\uD7FB\\uF900-\\uFA6D\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE00-\\uFE0F\\uFE20-\\uFE2D\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF10-\\uFF19\\uFF21-\\uFF3A\\uFF3F\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]");
function assert$1(condition, message) {
  if (!condition) {
    throw new Error("ASSERT: " + message);
  }
}
function isDecimalDigit$1(ch2) {
  return ch2 >= 48 && ch2 <= 57;
}
function isHexDigit$1(ch2) {
  return "0123456789abcdefABCDEF".indexOf(ch2) >= 0;
}
function isOctalDigit$1(ch2) {
  return "01234567".indexOf(ch2) >= 0;
}
function isWhiteSpace$1(ch2) {
  return ch2 === 32 || ch2 === 9 || ch2 === 11 || ch2 === 12 || ch2 === 160 || ch2 >= 5760 && [5760, 6158, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8239, 8287, 12288, 65279].indexOf(ch2) >= 0;
}
function isLineTerminator$1(ch2) {
  return ch2 === 10 || ch2 === 13 || ch2 === 8232 || ch2 === 8233;
}
function isIdentifierStart$1(ch2) {
  return ch2 === 36 || ch2 === 95 || // $ (dollar) and _ (underscore)
  ch2 >= 65 && ch2 <= 90 || // A..Z
  ch2 >= 97 && ch2 <= 122 || // a..z
  ch2 === 92 || // \ (backslash)
  ch2 >= 128 && RegexNonAsciiIdentifierStart$1.test(String.fromCharCode(ch2));
}
function isIdentifierPart$1(ch2) {
  return ch2 === 36 || ch2 === 95 || // $ (dollar) and _ (underscore)
  ch2 >= 65 && ch2 <= 90 || // A..Z
  ch2 >= 97 && ch2 <= 122 || // a..z
  ch2 >= 48 && ch2 <= 57 || // 0..9
  ch2 === 92 || // \ (backslash)
  ch2 >= 128 && RegexNonAsciiIdentifierPart$1.test(String.fromCharCode(ch2));
}
const keywords$1 = {
  "if": 1,
  "in": 1,
  "do": 1,
  "var": 1,
  "for": 1,
  "new": 1,
  "try": 1,
  "let": 1,
  "this": 1,
  "else": 1,
  "case": 1,
  "void": 1,
  "with": 1,
  "enum": 1,
  "while": 1,
  "break": 1,
  "catch": 1,
  "throw": 1,
  "const": 1,
  "yield": 1,
  "class": 1,
  "super": 1,
  "return": 1,
  "typeof": 1,
  "delete": 1,
  "switch": 1,
  "export": 1,
  "import": 1,
  "public": 1,
  "static": 1,
  "default": 1,
  "finally": 1,
  "extends": 1,
  "package": 1,
  "private": 1,
  "function": 1,
  "continue": 1,
  "debugger": 1,
  "interface": 1,
  "protected": 1,
  "instanceof": 1,
  "implements": 1
};
function skipComment$1() {
  while (index$1 < length$1) {
    const ch2 = source$1.charCodeAt(index$1);
    if (isWhiteSpace$1(ch2) || isLineTerminator$1(ch2)) {
      ++index$1;
    } else {
      break;
    }
  }
}
function scanHexEscape$1(prefix) {
  var i, len, ch2, code = 0;
  len = prefix === "u" ? 4 : 2;
  for (i = 0; i < len; ++i) {
    if (index$1 < length$1 && isHexDigit$1(source$1[index$1])) {
      ch2 = source$1[index$1++];
      code = code * 16 + "0123456789abcdef".indexOf(ch2.toLowerCase());
    } else {
      throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
    }
  }
  return String.fromCharCode(code);
}
function scanUnicodeCodePointEscape$1() {
  var ch2, code, cu1, cu2;
  ch2 = source$1[index$1];
  code = 0;
  if (ch2 === "}") {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  while (index$1 < length$1) {
    ch2 = source$1[index$1++];
    if (!isHexDigit$1(ch2)) {
      break;
    }
    code = code * 16 + "0123456789abcdef".indexOf(ch2.toLowerCase());
  }
  if (code > 1114111 || ch2 !== "}") {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  if (code <= 65535) {
    return String.fromCharCode(code);
  }
  cu1 = (code - 65536 >> 10) + 55296;
  cu2 = (code - 65536 & 1023) + 56320;
  return String.fromCharCode(cu1, cu2);
}
function getEscapedIdentifier$1() {
  var ch2, id2;
  ch2 = source$1.charCodeAt(index$1++);
  id2 = String.fromCharCode(ch2);
  if (ch2 === 92) {
    if (source$1.charCodeAt(index$1) !== 117) {
      throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
    }
    ++index$1;
    ch2 = scanHexEscape$1("u");
    if (!ch2 || ch2 === "\\" || !isIdentifierStart$1(ch2.charCodeAt(0))) {
      throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
    }
    id2 = ch2;
  }
  while (index$1 < length$1) {
    ch2 = source$1.charCodeAt(index$1);
    if (!isIdentifierPart$1(ch2)) {
      break;
    }
    ++index$1;
    id2 += String.fromCharCode(ch2);
    if (ch2 === 92) {
      id2 = id2.substr(0, id2.length - 1);
      if (source$1.charCodeAt(index$1) !== 117) {
        throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
      }
      ++index$1;
      ch2 = scanHexEscape$1("u");
      if (!ch2 || ch2 === "\\" || !isIdentifierPart$1(ch2.charCodeAt(0))) {
        throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
      }
      id2 += ch2;
    }
  }
  return id2;
}
function getIdentifier$1() {
  var start, ch2;
  start = index$1++;
  while (index$1 < length$1) {
    ch2 = source$1.charCodeAt(index$1);
    if (ch2 === 92) {
      index$1 = start;
      return getEscapedIdentifier$1();
    }
    if (isIdentifierPart$1(ch2)) {
      ++index$1;
    } else {
      break;
    }
  }
  return source$1.slice(start, index$1);
}
function scanIdentifier$1() {
  var start, id2, type2;
  start = index$1;
  id2 = source$1.charCodeAt(index$1) === 92 ? getEscapedIdentifier$1() : getIdentifier$1();
  if (id2.length === 1) {
    type2 = TokenIdentifier$1;
  } else if (keywords$1.hasOwnProperty(id2)) {
    type2 = TokenKeyword$1;
  } else if (id2 === "null") {
    type2 = TokenNullLiteral$1;
  } else if (id2 === "true" || id2 === "false") {
    type2 = TokenBooleanLiteral$1;
  } else {
    type2 = TokenIdentifier$1;
  }
  return {
    type: type2,
    value: id2,
    start,
    end: index$1
  };
}
function scanPunctuator$1() {
  var start = index$1, code = source$1.charCodeAt(index$1), code2, ch1 = source$1[index$1], ch2, ch3, ch4;
  switch (code) {
    case 46:
    case 40:
    case 41:
    case 59:
    case 44:
    case 123:
    case 125:
    case 91:
    case 93:
    case 58:
    case 63:
    case 126:
      ++index$1;
      return {
        type: TokenPunctuator$1,
        value: String.fromCharCode(code),
        start,
        end: index$1
      };
    default:
      code2 = source$1.charCodeAt(index$1 + 1);
      if (code2 === 61) {
        switch (code) {
          case 43:
          case 45:
          case 47:
          case 60:
          case 62:
          case 94:
          case 124:
          case 37:
          case 38:
          case 42:
            index$1 += 2;
            return {
              type: TokenPunctuator$1,
              value: String.fromCharCode(code) + String.fromCharCode(code2),
              start,
              end: index$1
            };
          case 33:
          case 61:
            index$1 += 2;
            if (source$1.charCodeAt(index$1) === 61) {
              ++index$1;
            }
            return {
              type: TokenPunctuator$1,
              value: source$1.slice(start, index$1),
              start,
              end: index$1
            };
        }
      }
  }
  ch4 = source$1.substr(index$1, 4);
  if (ch4 === ">>>=") {
    index$1 += 4;
    return {
      type: TokenPunctuator$1,
      value: ch4,
      start,
      end: index$1
    };
  }
  ch3 = ch4.substr(0, 3);
  if (ch3 === ">>>" || ch3 === "<<=" || ch3 === ">>=") {
    index$1 += 3;
    return {
      type: TokenPunctuator$1,
      value: ch3,
      start,
      end: index$1
    };
  }
  ch2 = ch3.substr(0, 2);
  if (ch1 === ch2[1] && "+-<>&|".indexOf(ch1) >= 0 || ch2 === "=>") {
    index$1 += 2;
    return {
      type: TokenPunctuator$1,
      value: ch2,
      start,
      end: index$1
    };
  }
  if (ch2 === "//") {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  if ("<>=!+-*%&|^/".indexOf(ch1) >= 0) {
    ++index$1;
    return {
      type: TokenPunctuator$1,
      value: ch1,
      start,
      end: index$1
    };
  }
  throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
}
function scanHexLiteral$1(start) {
  let number2 = "";
  while (index$1 < length$1) {
    if (!isHexDigit$1(source$1[index$1])) {
      break;
    }
    number2 += source$1[index$1++];
  }
  if (number2.length === 0) {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  if (isIdentifierStart$1(source$1.charCodeAt(index$1))) {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  return {
    type: TokenNumericLiteral$1,
    value: parseInt("0x" + number2, 16),
    start,
    end: index$1
  };
}
function scanOctalLiteral$1(start) {
  let number2 = "0" + source$1[index$1++];
  while (index$1 < length$1) {
    if (!isOctalDigit$1(source$1[index$1])) {
      break;
    }
    number2 += source$1[index$1++];
  }
  if (isIdentifierStart$1(source$1.charCodeAt(index$1)) || isDecimalDigit$1(source$1.charCodeAt(index$1))) {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  return {
    type: TokenNumericLiteral$1,
    value: parseInt(number2, 8),
    octal: true,
    start,
    end: index$1
  };
}
function scanNumericLiteral$1() {
  var number2, start, ch2;
  ch2 = source$1[index$1];
  assert$1(isDecimalDigit$1(ch2.charCodeAt(0)) || ch2 === ".", "Numeric literal must start with a decimal digit or a decimal point");
  start = index$1;
  number2 = "";
  if (ch2 !== ".") {
    number2 = source$1[index$1++];
    ch2 = source$1[index$1];
    if (number2 === "0") {
      if (ch2 === "x" || ch2 === "X") {
        ++index$1;
        return scanHexLiteral$1(start);
      }
      if (isOctalDigit$1(ch2)) {
        return scanOctalLiteral$1(start);
      }
      if (ch2 && isDecimalDigit$1(ch2.charCodeAt(0))) {
        throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
      }
    }
    while (isDecimalDigit$1(source$1.charCodeAt(index$1))) {
      number2 += source$1[index$1++];
    }
    ch2 = source$1[index$1];
  }
  if (ch2 === ".") {
    number2 += source$1[index$1++];
    while (isDecimalDigit$1(source$1.charCodeAt(index$1))) {
      number2 += source$1[index$1++];
    }
    ch2 = source$1[index$1];
  }
  if (ch2 === "e" || ch2 === "E") {
    number2 += source$1[index$1++];
    ch2 = source$1[index$1];
    if (ch2 === "+" || ch2 === "-") {
      number2 += source$1[index$1++];
    }
    if (isDecimalDigit$1(source$1.charCodeAt(index$1))) {
      while (isDecimalDigit$1(source$1.charCodeAt(index$1))) {
        number2 += source$1[index$1++];
      }
    } else {
      throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
    }
  }
  if (isIdentifierStart$1(source$1.charCodeAt(index$1))) {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  return {
    type: TokenNumericLiteral$1,
    value: parseFloat(number2),
    start,
    end: index$1
  };
}
function scanStringLiteral$1() {
  var str = "", quote, start, ch2, code, octal = false;
  quote = source$1[index$1];
  assert$1(quote === "'" || quote === '"', "String literal must starts with a quote");
  start = index$1;
  ++index$1;
  while (index$1 < length$1) {
    ch2 = source$1[index$1++];
    if (ch2 === quote) {
      quote = "";
      break;
    } else if (ch2 === "\\") {
      ch2 = source$1[index$1++];
      if (!ch2 || !isLineTerminator$1(ch2.charCodeAt(0))) {
        switch (ch2) {
          case "u":
          case "x":
            if (source$1[index$1] === "{") {
              ++index$1;
              str += scanUnicodeCodePointEscape$1();
            } else {
              str += scanHexEscape$1(ch2);
            }
            break;
          case "n":
            str += "\n";
            break;
          case "r":
            str += "\r";
            break;
          case "t":
            str += "	";
            break;
          case "b":
            str += "\b";
            break;
          case "f":
            str += "\f";
            break;
          case "v":
            str += "\v";
            break;
          default:
            if (isOctalDigit$1(ch2)) {
              code = "01234567".indexOf(ch2);
              if (code !== 0) {
                octal = true;
              }
              if (index$1 < length$1 && isOctalDigit$1(source$1[index$1])) {
                octal = true;
                code = code * 8 + "01234567".indexOf(source$1[index$1++]);
                if ("0123".indexOf(ch2) >= 0 && index$1 < length$1 && isOctalDigit$1(source$1[index$1])) {
                  code = code * 8 + "01234567".indexOf(source$1[index$1++]);
                }
              }
              str += String.fromCharCode(code);
            } else {
              str += ch2;
            }
            break;
        }
      } else {
        if (ch2 === "\r" && source$1[index$1] === "\n") {
          ++index$1;
        }
      }
    } else if (isLineTerminator$1(ch2.charCodeAt(0))) {
      break;
    } else {
      str += ch2;
    }
  }
  if (quote !== "") {
    throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
  }
  return {
    type: TokenStringLiteral$1,
    value: str,
    octal,
    start,
    end: index$1
  };
}
function testRegExp$1(pattern, flags) {
  let tmp = pattern;
  if (flags.indexOf("u") >= 0) {
    tmp = tmp.replace(/\\u\{([0-9a-fA-F]+)\}/g, ($0, $1) => {
      if (parseInt($1, 16) <= 1114111) {
        return "x";
      }
      throwError$1({}, MessageInvalidRegExp$1);
    }).replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g, "x");
  }
  try {
    new RegExp(tmp);
  } catch (e) {
    throwError$1({}, MessageInvalidRegExp$1);
  }
  try {
    return new RegExp(pattern, flags);
  } catch (exception) {
    return null;
  }
}
function scanRegExpBody$1() {
  var ch2, str, classMarker, terminated, body;
  ch2 = source$1[index$1];
  assert$1(ch2 === "/", "Regular expression literal must start with a slash");
  str = source$1[index$1++];
  classMarker = false;
  terminated = false;
  while (index$1 < length$1) {
    ch2 = source$1[index$1++];
    str += ch2;
    if (ch2 === "\\") {
      ch2 = source$1[index$1++];
      if (isLineTerminator$1(ch2.charCodeAt(0))) {
        throwError$1({}, MessageUnterminatedRegExp$1);
      }
      str += ch2;
    } else if (isLineTerminator$1(ch2.charCodeAt(0))) {
      throwError$1({}, MessageUnterminatedRegExp$1);
    } else if (classMarker) {
      if (ch2 === "]") {
        classMarker = false;
      }
    } else {
      if (ch2 === "/") {
        terminated = true;
        break;
      } else if (ch2 === "[") {
        classMarker = true;
      }
    }
  }
  if (!terminated) {
    throwError$1({}, MessageUnterminatedRegExp$1);
  }
  body = str.substr(1, str.length - 2);
  return {
    value: body,
    literal: str
  };
}
function scanRegExpFlags$1() {
  var ch2, str, flags;
  str = "";
  flags = "";
  while (index$1 < length$1) {
    ch2 = source$1[index$1];
    if (!isIdentifierPart$1(ch2.charCodeAt(0))) {
      break;
    }
    ++index$1;
    if (ch2 === "\\" && index$1 < length$1) {
      throwError$1({}, MessageUnexpectedToken$1, ILLEGAL$2);
    } else {
      flags += ch2;
      str += ch2;
    }
  }
  if (flags.search(/[^gimuy]/g) >= 0) {
    throwError$1({}, MessageInvalidRegExp$1, flags);
  }
  return {
    value: flags,
    literal: str
  };
}
function scanRegExp$1() {
  var start, body, flags, value2;
  lookahead$1 = null;
  skipComment$1();
  start = index$1;
  body = scanRegExpBody$1();
  flags = scanRegExpFlags$1();
  value2 = testRegExp$1(body.value, flags.value);
  return {
    literal: body.literal + flags.literal,
    value: value2,
    regex: {
      pattern: body.value,
      flags: flags.value
    },
    start,
    end: index$1
  };
}
function isIdentifierName$1(token) {
  return token.type === TokenIdentifier$1 || token.type === TokenKeyword$1 || token.type === TokenBooleanLiteral$1 || token.type === TokenNullLiteral$1;
}
function advance$1() {
  skipComment$1();
  if (index$1 >= length$1) {
    return {
      type: TokenEOF$1,
      start: index$1,
      end: index$1
    };
  }
  const ch2 = source$1.charCodeAt(index$1);
  if (isIdentifierStart$1(ch2)) {
    return scanIdentifier$1();
  }
  if (ch2 === 40 || ch2 === 41 || ch2 === 59) {
    return scanPunctuator$1();
  }
  if (ch2 === 39 || ch2 === 34) {
    return scanStringLiteral$1();
  }
  if (ch2 === 46) {
    if (isDecimalDigit$1(source$1.charCodeAt(index$1 + 1))) {
      return scanNumericLiteral$1();
    }
    return scanPunctuator$1();
  }
  if (isDecimalDigit$1(ch2)) {
    return scanNumericLiteral$1();
  }
  return scanPunctuator$1();
}
function lex$1() {
  const token = lookahead$1;
  index$1 = token.end;
  lookahead$1 = advance$1();
  index$1 = token.end;
  return token;
}
function peek$1() {
  const pos = index$1;
  lookahead$1 = advance$1();
  index$1 = pos;
}
function finishArrayExpression$1(elements) {
  const node = new ASTNode$1(SyntaxArrayExpression$1);
  node.elements = elements;
  return node;
}
function finishBinaryExpression$1(operator2, left, right) {
  const node = new ASTNode$1(operator2 === "||" || operator2 === "&&" ? SyntaxLogicalExpression$1 : SyntaxBinaryExpression$1);
  node.operator = operator2;
  node.left = left;
  node.right = right;
  return node;
}
function finishCallExpression$1(callee, args) {
  const node = new ASTNode$1(SyntaxCallExpression$1);
  node.callee = callee;
  node.arguments = args;
  return node;
}
function finishConditionalExpression$1(test2, consequent, alternate) {
  const node = new ASTNode$1(SyntaxConditionalExpression$1);
  node.test = test2;
  node.consequent = consequent;
  node.alternate = alternate;
  return node;
}
function finishIdentifier$1(name) {
  const node = new ASTNode$1(SyntaxIdentifier$1);
  node.name = name;
  return node;
}
function finishLiteral$1(token) {
  const node = new ASTNode$1(SyntaxLiteral$1);
  node.value = token.value;
  node.raw = source$1.slice(token.start, token.end);
  if (token.regex) {
    if (node.raw === "//") {
      node.raw = "/(?:)/";
    }
    node.regex = token.regex;
  }
  return node;
}
function finishMemberExpression$1(accessor2, object2, property2) {
  const node = new ASTNode$1(SyntaxMemberExpression$1);
  node.computed = accessor2 === "[";
  node.object = object2;
  node.property = property2;
  if (!node.computed)
    property2.member = true;
  return node;
}
function finishObjectExpression$1(properties) {
  const node = new ASTNode$1(SyntaxObjectExpression$1);
  node.properties = properties;
  return node;
}
function finishProperty$1(kind, key2, value2) {
  const node = new ASTNode$1(SyntaxProperty$1);
  node.key = key2;
  node.value = value2;
  node.kind = kind;
  return node;
}
function finishUnaryExpression$1(operator2, argument) {
  const node = new ASTNode$1(SyntaxUnaryExpression$1);
  node.operator = operator2;
  node.argument = argument;
  node.prefix = true;
  return node;
}
function throwError$1(token, messageFormat) {
  var error2, args = Array.prototype.slice.call(arguments, 2), msg = messageFormat.replace(/%(\d)/g, (whole, index2) => {
    assert$1(index2 < args.length, "Message reference must be in range");
    return args[index2];
  });
  error2 = new Error(msg);
  error2.index = index$1;
  error2.description = msg;
  throw error2;
}
function throwUnexpected$1(token) {
  if (token.type === TokenEOF$1) {
    throwError$1(token, MessageUnexpectedEOS$1);
  }
  if (token.type === TokenNumericLiteral$1) {
    throwError$1(token, MessageUnexpectedNumber$1);
  }
  if (token.type === TokenStringLiteral$1) {
    throwError$1(token, MessageUnexpectedString$1);
  }
  if (token.type === TokenIdentifier$1) {
    throwError$1(token, MessageUnexpectedIdentifier$1);
  }
  if (token.type === TokenKeyword$1) {
    throwError$1(token, MessageUnexpectedReserved$1);
  }
  throwError$1(token, MessageUnexpectedToken$1, token.value);
}
function expect$1(value2) {
  const token = lex$1();
  if (token.type !== TokenPunctuator$1 || token.value !== value2) {
    throwUnexpected$1(token);
  }
}
function match$1(value2) {
  return lookahead$1.type === TokenPunctuator$1 && lookahead$1.value === value2;
}
function matchKeyword$1(keyword) {
  return lookahead$1.type === TokenKeyword$1 && lookahead$1.value === keyword;
}
function parseArrayInitialiser$1() {
  const elements = [];
  index$1 = lookahead$1.start;
  expect$1("[");
  while (!match$1("]")) {
    if (match$1(",")) {
      lex$1();
      elements.push(null);
    } else {
      elements.push(parseConditionalExpression$1());
      if (!match$1("]")) {
        expect$1(",");
      }
    }
  }
  lex$1();
  return finishArrayExpression$1(elements);
}
function parseObjectPropertyKey$1() {
  index$1 = lookahead$1.start;
  const token = lex$1();
  if (token.type === TokenStringLiteral$1 || token.type === TokenNumericLiteral$1) {
    if (token.octal) {
      throwError$1(token, MessageStrictOctalLiteral$1);
    }
    return finishLiteral$1(token);
  }
  return finishIdentifier$1(token.value);
}
function parseObjectProperty$1() {
  var token, key2, id2, value2;
  index$1 = lookahead$1.start;
  token = lookahead$1;
  if (token.type === TokenIdentifier$1) {
    id2 = parseObjectPropertyKey$1();
    expect$1(":");
    value2 = parseConditionalExpression$1();
    return finishProperty$1("init", id2, value2);
  }
  if (token.type === TokenEOF$1 || token.type === TokenPunctuator$1) {
    throwUnexpected$1(token);
  } else {
    key2 = parseObjectPropertyKey$1();
    expect$1(":");
    value2 = parseConditionalExpression$1();
    return finishProperty$1("init", key2, value2);
  }
}
function parseObjectInitialiser$1() {
  var properties = [], property2, name, key2, map2 = {}, toString2 = String;
  index$1 = lookahead$1.start;
  expect$1("{");
  while (!match$1("}")) {
    property2 = parseObjectProperty$1();
    if (property2.key.type === SyntaxIdentifier$1) {
      name = property2.key.name;
    } else {
      name = toString2(property2.key.value);
    }
    key2 = "$" + name;
    if (Object.prototype.hasOwnProperty.call(map2, key2)) {
      throwError$1({}, MessageStrictDuplicateProperty$1);
    } else {
      map2[key2] = true;
    }
    properties.push(property2);
    if (!match$1("}")) {
      expect$1(",");
    }
  }
  expect$1("}");
  return finishObjectExpression$1(properties);
}
function parseGroupExpression$1() {
  expect$1("(");
  const expr2 = parseExpression$1();
  expect$1(")");
  return expr2;
}
const legalKeywords$1 = {
  "if": 1
};
function parsePrimaryExpression$1() {
  var type2, token, expr2;
  if (match$1("(")) {
    return parseGroupExpression$1();
  }
  if (match$1("[")) {
    return parseArrayInitialiser$1();
  }
  if (match$1("{")) {
    return parseObjectInitialiser$1();
  }
  type2 = lookahead$1.type;
  index$1 = lookahead$1.start;
  if (type2 === TokenIdentifier$1 || legalKeywords$1[lookahead$1.value]) {
    expr2 = finishIdentifier$1(lex$1().value);
  } else if (type2 === TokenStringLiteral$1 || type2 === TokenNumericLiteral$1) {
    if (lookahead$1.octal) {
      throwError$1(lookahead$1, MessageStrictOctalLiteral$1);
    }
    expr2 = finishLiteral$1(lex$1());
  } else if (type2 === TokenKeyword$1) {
    throw new Error(DISABLED$1);
  } else if (type2 === TokenBooleanLiteral$1) {
    token = lex$1();
    token.value = token.value === "true";
    expr2 = finishLiteral$1(token);
  } else if (type2 === TokenNullLiteral$1) {
    token = lex$1();
    token.value = null;
    expr2 = finishLiteral$1(token);
  } else if (match$1("/") || match$1("/=")) {
    expr2 = finishLiteral$1(scanRegExp$1());
    peek$1();
  } else {
    throwUnexpected$1(lex$1());
  }
  return expr2;
}
function parseArguments$1() {
  const args = [];
  expect$1("(");
  if (!match$1(")")) {
    while (index$1 < length$1) {
      args.push(parseConditionalExpression$1());
      if (match$1(")")) {
        break;
      }
      expect$1(",");
    }
  }
  expect$1(")");
  return args;
}
function parseNonComputedProperty$1() {
  index$1 = lookahead$1.start;
  const token = lex$1();
  if (!isIdentifierName$1(token)) {
    throwUnexpected$1(token);
  }
  return finishIdentifier$1(token.value);
}
function parseNonComputedMember$1() {
  expect$1(".");
  return parseNonComputedProperty$1();
}
function parseComputedMember$1() {
  expect$1("[");
  const expr2 = parseExpression$1();
  expect$1("]");
  return expr2;
}
function parseLeftHandSideExpressionAllowCall$1() {
  var expr2, args, property2;
  expr2 = parsePrimaryExpression$1();
  for (; ; ) {
    if (match$1(".")) {
      property2 = parseNonComputedMember$1();
      expr2 = finishMemberExpression$1(".", expr2, property2);
    } else if (match$1("(")) {
      args = parseArguments$1();
      expr2 = finishCallExpression$1(expr2, args);
    } else if (match$1("[")) {
      property2 = parseComputedMember$1();
      expr2 = finishMemberExpression$1("[", expr2, property2);
    } else {
      break;
    }
  }
  return expr2;
}
function parsePostfixExpression$1() {
  const expr2 = parseLeftHandSideExpressionAllowCall$1();
  if (lookahead$1.type === TokenPunctuator$1) {
    if (match$1("++") || match$1("--")) {
      throw new Error(DISABLED$1);
    }
  }
  return expr2;
}
function parseUnaryExpression$1() {
  var token, expr2;
  if (lookahead$1.type !== TokenPunctuator$1 && lookahead$1.type !== TokenKeyword$1) {
    expr2 = parsePostfixExpression$1();
  } else if (match$1("++") || match$1("--")) {
    throw new Error(DISABLED$1);
  } else if (match$1("+") || match$1("-") || match$1("~") || match$1("!")) {
    token = lex$1();
    expr2 = parseUnaryExpression$1();
    expr2 = finishUnaryExpression$1(token.value, expr2);
  } else if (matchKeyword$1("delete") || matchKeyword$1("void") || matchKeyword$1("typeof")) {
    throw new Error(DISABLED$1);
  } else {
    expr2 = parsePostfixExpression$1();
  }
  return expr2;
}
function binaryPrecedence$1(token) {
  let prec = 0;
  if (token.type !== TokenPunctuator$1 && token.type !== TokenKeyword$1) {
    return 0;
  }
  switch (token.value) {
    case "||":
      prec = 1;
      break;
    case "&&":
      prec = 2;
      break;
    case "|":
      prec = 3;
      break;
    case "^":
      prec = 4;
      break;
    case "&":
      prec = 5;
      break;
    case "==":
    case "!=":
    case "===":
    case "!==":
      prec = 6;
      break;
    case "<":
    case ">":
    case "<=":
    case ">=":
    case "instanceof":
    case "in":
      prec = 7;
      break;
    case "<<":
    case ">>":
    case ">>>":
      prec = 8;
      break;
    case "+":
    case "-":
      prec = 9;
      break;
    case "*":
    case "/":
    case "%":
      prec = 11;
      break;
  }
  return prec;
}
function parseBinaryExpression$1() {
  var marker, markers, expr2, token, prec, stack, right, operator2, left, i;
  marker = lookahead$1;
  left = parseUnaryExpression$1();
  token = lookahead$1;
  prec = binaryPrecedence$1(token);
  if (prec === 0) {
    return left;
  }
  token.prec = prec;
  lex$1();
  markers = [marker, lookahead$1];
  right = parseUnaryExpression$1();
  stack = [left, token, right];
  while ((prec = binaryPrecedence$1(lookahead$1)) > 0) {
    while (stack.length > 2 && prec <= stack[stack.length - 2].prec) {
      right = stack.pop();
      operator2 = stack.pop().value;
      left = stack.pop();
      markers.pop();
      expr2 = finishBinaryExpression$1(operator2, left, right);
      stack.push(expr2);
    }
    token = lex$1();
    token.prec = prec;
    stack.push(token);
    markers.push(lookahead$1);
    expr2 = parseUnaryExpression$1();
    stack.push(expr2);
  }
  i = stack.length - 1;
  expr2 = stack[i];
  markers.pop();
  while (i > 1) {
    markers.pop();
    expr2 = finishBinaryExpression$1(stack[i - 1].value, stack[i - 2], expr2);
    i -= 2;
  }
  return expr2;
}
function parseConditionalExpression$1() {
  var expr2, consequent, alternate;
  expr2 = parseBinaryExpression$1();
  if (match$1("?")) {
    lex$1();
    consequent = parseConditionalExpression$1();
    expect$1(":");
    alternate = parseConditionalExpression$1();
    expr2 = finishConditionalExpression$1(expr2, consequent, alternate);
  }
  return expr2;
}
function parseExpression$1() {
  const expr2 = parseConditionalExpression$1();
  if (match$1(",")) {
    throw new Error(DISABLED$1);
  }
  return expr2;
}
function parser$2(code) {
  source$1 = code;
  index$1 = 0;
  length$1 = source$1.length;
  lookahead$1 = null;
  peek$1();
  const expr2 = parseExpression$1();
  if (lookahead$1.type !== TokenEOF$1) {
    throw new Error("Unexpect token after expression.");
  }
  return expr2;
}
var Constants$2 = {
  NaN: "NaN",
  E: "Math.E",
  LN2: "Math.LN2",
  LN10: "Math.LN10",
  LOG2E: "Math.LOG2E",
  LOG10E: "Math.LOG10E",
  PI: "Math.PI",
  SQRT1_2: "Math.SQRT1_2",
  SQRT2: "Math.SQRT2",
  MIN_VALUE: "Number.MIN_VALUE",
  MAX_VALUE: "Number.MAX_VALUE"
};
function Functions$2(codegen2) {
  function fncall(name, args, cast, type2) {
    let obj = codegen2(args[0]);
    if (cast) {
      obj = cast + "(" + obj + ")";
      if (cast.lastIndexOf("new ", 0) === 0)
        obj = "(" + obj + ")";
    }
    return obj + "." + name + (type2 < 0 ? "" : type2 === 0 ? "()" : "(" + args.slice(1).map(codegen2).join(",") + ")");
  }
  function fn(name, cast, type2) {
    return (args) => fncall(name, args, cast, type2);
  }
  const DATE2 = "new Date", STRING = "String", REGEXP = "RegExp";
  return {
    // MATH functions
    isNaN: "Number.isNaN",
    isFinite: "Number.isFinite",
    abs: "Math.abs",
    acos: "Math.acos",
    asin: "Math.asin",
    atan: "Math.atan",
    atan2: "Math.atan2",
    ceil: "Math.ceil",
    cos: "Math.cos",
    exp: "Math.exp",
    floor: "Math.floor",
    hypot: "Math.hypot",
    log: "Math.log",
    max: "Math.max",
    min: "Math.min",
    pow: "Math.pow",
    random: "Math.random",
    round: "Math.round",
    sin: "Math.sin",
    sqrt: "Math.sqrt",
    tan: "Math.tan",
    clamp: function(args) {
      if (args.length < 3)
        error("Missing arguments to clamp function.");
      if (args.length > 3)
        error("Too many arguments to clamp function.");
      const a2 = args.map(codegen2);
      return "Math.max(" + a2[1] + ", Math.min(" + a2[2] + "," + a2[0] + "))";
    },
    // DATE functions
    now: "Date.now",
    utc: "Date.UTC",
    datetime: DATE2,
    date: fn("getDate", DATE2, 0),
    day: fn("getDay", DATE2, 0),
    year: fn("getFullYear", DATE2, 0),
    month: fn("getMonth", DATE2, 0),
    hours: fn("getHours", DATE2, 0),
    minutes: fn("getMinutes", DATE2, 0),
    seconds: fn("getSeconds", DATE2, 0),
    milliseconds: fn("getMilliseconds", DATE2, 0),
    time: fn("getTime", DATE2, 0),
    timezoneoffset: fn("getTimezoneOffset", DATE2, 0),
    utcdate: fn("getUTCDate", DATE2, 0),
    utcday: fn("getUTCDay", DATE2, 0),
    utcyear: fn("getUTCFullYear", DATE2, 0),
    utcmonth: fn("getUTCMonth", DATE2, 0),
    utchours: fn("getUTCHours", DATE2, 0),
    utcminutes: fn("getUTCMinutes", DATE2, 0),
    utcseconds: fn("getUTCSeconds", DATE2, 0),
    utcmilliseconds: fn("getUTCMilliseconds", DATE2, 0),
    // sequence functions
    length: fn("length", null, -1),
    // STRING functions
    parseFloat: "parseFloat",
    parseInt: "parseInt",
    upper: fn("toUpperCase", STRING, 0),
    lower: fn("toLowerCase", STRING, 0),
    substring: fn("substring", STRING),
    split: fn("split", STRING),
    trim: fn("trim", STRING, 0),
    // REGEXP functions
    regexp: REGEXP,
    test: fn("test", REGEXP),
    // Control Flow functions
    if: function(args) {
      if (args.length < 3)
        error("Missing arguments to if function.");
      if (args.length > 3)
        error("Too many arguments to if function.");
      const a2 = args.map(codegen2);
      return "(" + a2[0] + "?" + a2[1] + ":" + a2[2] + ")";
    }
  };
}
function stripQuotes$1(s) {
  const n = s && s.length - 1;
  return n && (s[0] === '"' && s[n] === '"' || s[0] === "'" && s[n] === "'") ? s.slice(1, -1) : s;
}
function codegen$1(opt) {
  opt = opt || {};
  const allowed = opt.allowed ? toSet(opt.allowed) : {}, forbidden = opt.forbidden ? toSet(opt.forbidden) : {}, constants2 = opt.constants || Constants$2, functions = (opt.functions || Functions$2)(visit2), globalvar = opt.globalvar, fieldvar = opt.fieldvar, outputGlobal = isFunction(globalvar) ? globalvar : (id2) => `${globalvar}["${id2}"]`;
  let globals = {}, fields = {}, memberDepth = 0;
  function visit2(ast) {
    if (isString(ast))
      return ast;
    const generator = Generators[ast.type];
    if (generator == null)
      error("Unsupported type: " + ast.type);
    return generator(ast);
  }
  const Generators = {
    Literal: (n) => n.raw,
    Identifier: (n) => {
      const id2 = n.name;
      if (memberDepth > 0) {
        return id2;
      } else if (has$1(forbidden, id2)) {
        return error("Illegal identifier: " + id2);
      } else if (has$1(constants2, id2)) {
        return constants2[id2];
      } else if (has$1(allowed, id2)) {
        return id2;
      } else {
        globals[id2] = 1;
        return outputGlobal(id2);
      }
    },
    MemberExpression: (n) => {
      const d = !n.computed, o = visit2(n.object);
      if (d)
        memberDepth += 1;
      const p = visit2(n.property);
      if (o === fieldvar) {
        fields[stripQuotes$1(p)] = 1;
      }
      if (d)
        memberDepth -= 1;
      return o + (d ? "." + p : "[" + p + "]");
    },
    CallExpression: (n) => {
      if (n.callee.type !== "Identifier") {
        error("Illegal callee type: " + n.callee.type);
      }
      const callee = n.callee.name, args = n.arguments, fn = has$1(functions, callee) && functions[callee];
      if (!fn)
        error("Unrecognized function: " + callee);
      return isFunction(fn) ? fn(args) : fn + "(" + args.map(visit2).join(",") + ")";
    },
    ArrayExpression: (n) => "[" + n.elements.map(visit2).join(",") + "]",
    BinaryExpression: (n) => "(" + visit2(n.left) + " " + n.operator + " " + visit2(n.right) + ")",
    UnaryExpression: (n) => "(" + n.operator + visit2(n.argument) + ")",
    ConditionalExpression: (n) => "(" + visit2(n.test) + "?" + visit2(n.consequent) + ":" + visit2(n.alternate) + ")",
    LogicalExpression: (n) => "(" + visit2(n.left) + n.operator + visit2(n.right) + ")",
    ObjectExpression: (n) => "{" + n.properties.map(visit2).join(",") + "}",
    Property: (n) => {
      memberDepth += 1;
      const k = visit2(n.key);
      memberDepth -= 1;
      return k + ":" + visit2(n.value);
    }
  };
  function codegen2(ast) {
    const result = {
      code: visit2(ast),
      globals: Object.keys(globals),
      fields: Object.keys(fields)
    };
    globals = {};
    fields = {};
    return result;
  }
  codegen2.functions = functions;
  codegen2.constants = constants2;
  return codegen2;
}
const SELECTION_GETTER = Symbol("vega_selection_getter");
function getter(f) {
  if (!f.getter || !f.getter[SELECTION_GETTER]) {
    f.getter = field$1(f.field);
    f.getter[SELECTION_GETTER] = true;
  }
  return f.getter;
}
const Intersect = "intersect";
const Union = "union";
const VlMulti = "vlMulti";
const VlPoint = "vlPoint";
const Or = "or";
const And = "and";
const SelectionId = "_vgsid_";
const $selectionId = field$1(SelectionId);
const TYPE_ENUM = "E", TYPE_RANGE_INC = "R", TYPE_RANGE_EXC = "R-E", TYPE_RANGE_LE = "R-LE", TYPE_RANGE_RE = "R-RE", UNIT_INDEX = "index:unit";
function testPoint(datum2, entry2) {
  var fields = entry2.fields, values2 = entry2.values, n = fields.length, i = 0, dval, f;
  for (; i < n; ++i) {
    f = fields[i];
    dval = getter(f)(datum2);
    if (isDate$1(dval))
      dval = toNumber(dval);
    if (isDate$1(values2[i]))
      values2[i] = toNumber(values2[i]);
    if (isArray(values2[i]) && isDate$1(values2[i][0]))
      values2[i] = values2[i].map(toNumber);
    if (f.type === TYPE_ENUM) {
      if (isArray(values2[i]) ? values2[i].indexOf(dval) < 0 : dval !== values2[i]) {
        return false;
      }
    } else {
      if (f.type === TYPE_RANGE_INC) {
        if (!inrange(dval, values2[i]))
          return false;
      } else if (f.type === TYPE_RANGE_RE) {
        if (!inrange(dval, values2[i], true, false))
          return false;
      } else if (f.type === TYPE_RANGE_EXC) {
        if (!inrange(dval, values2[i], false, false))
          return false;
      } else if (f.type === TYPE_RANGE_LE) {
        if (!inrange(dval, values2[i], false, true))
          return false;
      }
    }
  }
  return true;
}
function selectionTest(name, datum2, op) {
  var data2 = this.context.data[name], entries = data2 ? data2.values.value : [], unitIdx = data2 ? data2[UNIT_INDEX] && data2[UNIT_INDEX].value : void 0, intersect2 = op === Intersect, n = entries.length, i = 0, entry2, miss, count2, unit2, b2;
  for (; i < n; ++i) {
    entry2 = entries[i];
    if (unitIdx && intersect2) {
      miss = miss || {};
      count2 = miss[unit2 = entry2.unit] || 0;
      if (count2 === -1)
        continue;
      b2 = testPoint(datum2, entry2);
      miss[unit2] = b2 ? -1 : ++count2;
      if (b2 && unitIdx.size === 1)
        return true;
      if (!b2 && count2 === unitIdx.get(unit2).count)
        return false;
    } else {
      b2 = testPoint(datum2, entry2);
      if (intersect2 ^ b2)
        return b2;
    }
  }
  return n && intersect2;
}
const bisect = bisector($selectionId), bisectLeft = bisect.left, bisectRight = bisect.right;
function selectionIdTest(name, datum2, op) {
  const data2 = this.context.data[name], entries = data2 ? data2.values.value : [], unitIdx = data2 ? data2[UNIT_INDEX] && data2[UNIT_INDEX].value : void 0, intersect2 = op === Intersect, value2 = $selectionId(datum2), index2 = bisectLeft(entries, value2);
  if (index2 === entries.length)
    return false;
  if ($selectionId(entries[index2]) !== value2)
    return false;
  if (unitIdx && intersect2) {
    if (unitIdx.size === 1)
      return true;
    if (bisectRight(entries, value2) - index2 < unitIdx.size)
      return false;
  }
  return true;
}
function selectionTuples(array2, base2) {
  return array2.map((x2) => extend(base2.fields ? {
    values: base2.fields.map((f) => getter(f)(x2.datum))
  } : {
    [SelectionId]: $selectionId(x2.datum)
  }, base2));
}
function selectionResolve(name, op, isMulti, vl5) {
  var data2 = this.context.data[name], entries = data2 ? data2.values.value : [], resolved = {}, multiRes = {}, types = {}, entry2, fields, values2, unit2, field2, value2, res, resUnit, type2, union2, n = entries.length, i = 0, j, m2;
  for (; i < n; ++i) {
    entry2 = entries[i];
    unit2 = entry2.unit;
    fields = entry2.fields;
    values2 = entry2.values;
    if (fields && values2) {
      for (j = 0, m2 = fields.length; j < m2; ++j) {
        field2 = fields[j];
        res = resolved[field2.field] || (resolved[field2.field] = {});
        resUnit = res[unit2] || (res[unit2] = []);
        types[field2.field] = type2 = field2.type.charAt(0);
        union2 = ops[`${type2}_union`];
        res[unit2] = union2(resUnit, array$3(values2[j]));
      }
      if (isMulti) {
        resUnit = multiRes[unit2] || (multiRes[unit2] = []);
        resUnit.push(array$3(values2).reduce((obj, curr, j2) => (obj[fields[j2].field] = curr, obj), {}));
      }
    } else {
      field2 = SelectionId;
      value2 = $selectionId(entry2);
      res = resolved[field2] || (resolved[field2] = {});
      resUnit = res[unit2] || (res[unit2] = []);
      resUnit.push(value2);
      if (isMulti) {
        resUnit = multiRes[unit2] || (multiRes[unit2] = []);
        resUnit.push({
          [SelectionId]: value2
        });
      }
    }
  }
  op = op || Union;
  if (resolved[SelectionId]) {
    resolved[SelectionId] = ops[`${SelectionId}_${op}`](...Object.values(resolved[SelectionId]));
  } else {
    Object.keys(resolved).forEach((field3) => {
      resolved[field3] = Object.keys(resolved[field3]).map((unit3) => resolved[field3][unit3]).reduce((acc, curr) => acc === void 0 ? curr : ops[`${types[field3]}_${op}`](acc, curr));
    });
  }
  entries = Object.keys(multiRes);
  if (isMulti && entries.length) {
    const key2 = vl5 ? VlPoint : VlMulti;
    resolved[key2] = op === Union ? {
      [Or]: entries.reduce((acc, k) => (acc.push(...multiRes[k]), acc), [])
    } : {
      [And]: entries.map((k) => ({
        [Or]: multiRes[k]
      }))
    };
  }
  return resolved;
}
var ops = {
  [`${SelectionId}_union`]: union,
  [`${SelectionId}_intersect`]: intersection,
  E_union: function(base2, value2) {
    if (!base2.length)
      return value2;
    var i = 0, n = value2.length;
    for (; i < n; ++i)
      if (base2.indexOf(value2[i]) < 0)
        base2.push(value2[i]);
    return base2;
  },
  E_intersect: function(base2, value2) {
    return !base2.length ? value2 : base2.filter((v) => value2.indexOf(v) >= 0);
  },
  R_union: function(base2, value2) {
    var lo = toNumber(value2[0]), hi = toNumber(value2[1]);
    if (lo > hi) {
      lo = value2[1];
      hi = value2[0];
    }
    if (!base2.length)
      return [lo, hi];
    if (base2[0] > lo)
      base2[0] = lo;
    if (base2[1] < hi)
      base2[1] = hi;
    return base2;
  },
  R_intersect: function(base2, value2) {
    var lo = toNumber(value2[0]), hi = toNumber(value2[1]);
    if (lo > hi) {
      lo = value2[1];
      hi = value2[0];
    }
    if (!base2.length)
      return [lo, hi];
    if (hi < base2[0] || base2[1] < lo) {
      return [];
    } else {
      if (base2[0] < lo)
        base2[0] = lo;
      if (base2[1] > hi)
        base2[1] = hi;
    }
    return base2;
  }
};
const DataPrefix$2 = ":", IndexPrefix$2 = "@";
function selectionVisitor(name, args, scope, params2) {
  if (args[0].type !== Literal$1)
    error("First argument to selection functions must be a string literal.");
  const data2 = args[0].value, op = args.length >= 2 && peek$2(args).value, field2 = "unit", indexName = IndexPrefix$2 + field2, dataName = DataPrefix$2 + data2;
  if (op === Intersect && !has$1(params2, indexName)) {
    params2[indexName] = scope.getData(data2).indataRef(scope, field2);
  }
  if (!has$1(params2, dataName)) {
    params2[dataName] = scope.getData(data2).tuplesRef();
  }
}
function data$2(name) {
  const data2 = this.context.data[name];
  return data2 ? data2.values.value : [];
}
function indata$1(name, field2, value2) {
  const index2 = this.context.data[name]["index:" + field2], entry2 = index2 ? index2.value.get(value2) : void 0;
  return entry2 ? entry2.count : entry2;
}
function setdata$1(name, tuples) {
  const df = this.context.dataflow, data2 = this.context.data[name], input = data2.input;
  df.pulse(input, df.changeset().remove(truthy).insert(tuples));
  return 1;
}
function encode$1(item, name, retval) {
  if (item) {
    const df = this.context.dataflow, target2 = item.mark.source;
    df.pulse(target2, df.changeset().encode(item, name));
  }
  return retval !== void 0 ? retval : item;
}
const wrap$1 = (method2) => function(value2, spec) {
  const locale2 = this.context.dataflow.locale();
  return locale2[method2](spec)(value2);
};
const format$1 = wrap$1("format");
const timeFormat$1 = wrap$1("timeFormat");
const utcFormat$1 = wrap$1("utcFormat");
const timeParse$1 = wrap$1("timeParse");
const utcParse$1 = wrap$1("utcParse");
const dateObj$1 = new Date(2e3, 0, 1);
function time$1(month, day, specifier) {
  if (!Number.isInteger(month) || !Number.isInteger(day))
    return "";
  dateObj$1.setYear(2e3);
  dateObj$1.setMonth(month);
  dateObj$1.setDate(day);
  return timeFormat$1.call(this, dateObj$1, specifier);
}
function monthFormat$1(month) {
  return time$1.call(this, month, 1, "%B");
}
function monthAbbrevFormat$1(month) {
  return time$1.call(this, month, 1, "%b");
}
function dayFormat$1(day) {
  return time$1.call(this, 0, 2 + day, "%A");
}
function dayAbbrevFormat$1(day) {
  return time$1.call(this, 0, 2 + day, "%a");
}
const DataPrefix$1 = ":";
const IndexPrefix$1 = "@";
const ScalePrefix$1 = "%";
const SignalPrefix$1 = "$";
function dataVisitor$1(name, args, scope, params2) {
  if (args[0].type !== Literal$1) {
    error("First argument to data functions must be a string literal.");
  }
  const data2 = args[0].value, dataName = DataPrefix$1 + data2;
  if (!has$1(dataName, params2)) {
    try {
      params2[dataName] = scope.getData(data2).tuplesRef();
    } catch (err) {
    }
  }
}
function indataVisitor$1(name, args, scope, params2) {
  if (args[0].type !== Literal$1)
    error("First argument to indata must be a string literal.");
  if (args[1].type !== Literal$1)
    error("Second argument to indata must be a string literal.");
  const data2 = args[0].value, field2 = args[1].value, indexName = IndexPrefix$1 + field2;
  if (!has$1(indexName, params2)) {
    params2[indexName] = scope.getData(data2).indataRef(scope, field2);
  }
}
function scaleVisitor$1(name, args, scope, params2) {
  if (args[0].type === Literal$1) {
    addScaleDependency$1(scope, params2, args[0].value);
  } else {
    for (name in scope.scales) {
      addScaleDependency$1(scope, params2, name);
    }
  }
}
function addScaleDependency$1(scope, params2, name) {
  const scaleName = ScalePrefix$1 + name;
  if (!has$1(params2, scaleName)) {
    try {
      params2[scaleName] = scope.scaleRef(name);
    } catch (err) {
    }
  }
}
function getScale$1(nameOrFunction, ctx) {
  if (isFunction(nameOrFunction)) {
    return nameOrFunction;
  }
  if (isString(nameOrFunction)) {
    const maybeScale = ctx.scales[nameOrFunction];
    return maybeScale && isRegisteredScale(maybeScale.value) ? maybeScale.value : void 0;
  }
  return void 0;
}
function internalScaleFunctions$1(codegen2, fnctx, visitors) {
  fnctx.__bandwidth = (s) => s && s.bandwidth ? s.bandwidth() : 0;
  visitors._bandwidth = scaleVisitor$1;
  visitors._range = scaleVisitor$1;
  visitors._scale = scaleVisitor$1;
  const ref2 = (arg) => "_[" + (arg.type === Literal$1 ? $(ScalePrefix$1 + arg.value) : $(ScalePrefix$1) + "+" + codegen2(arg)) + "]";
  return {
    _bandwidth: (args) => `this.__bandwidth(${ref2(args[0])})`,
    _range: (args) => `${ref2(args[0])}.range()`,
    _scale: (args) => `${ref2(args[0])}(${codegen2(args[1])})`
  };
}
function geoMethod$1(methodName, globalMethod) {
  return function(projection2, geojson, group2) {
    if (projection2) {
      const p = getScale$1(projection2, (group2 || this).context);
      return p && p.path[methodName](geojson);
    } else {
      return globalMethod(geojson);
    }
  };
}
const geoArea$1 = geoMethod$1("area", geoArea$1$1);
const geoBounds$1 = geoMethod$1("bounds", geoBounds$1$1);
const geoCentroid$1 = geoMethod$1("centroid", geoCentroid$1$1);
function geoScale(projection2, group2) {
  const p = getScale$1(projection2, (group2 || this).context);
  return p && p.scale();
}
function inScope$1(item) {
  const group2 = this.context.group;
  let value2 = false;
  if (group2)
    while (item) {
      if (item === group2) {
        value2 = true;
        break;
      }
      item = item.mark.group;
    }
  return value2;
}
function log$1(df, method2, args) {
  try {
    df[method2].apply(df, ["EXPRESSION"].concat([].slice.call(args)));
  } catch (err) {
    df.warn(err);
  }
  return args[args.length - 1];
}
function warn$1() {
  return log$1(this.context.dataflow, "warn", arguments);
}
function info$1() {
  return log$1(this.context.dataflow, "info", arguments);
}
function debug$1() {
  return log$1(this.context.dataflow, "debug", arguments);
}
function channel_luminance_value$1(channelValue) {
  const val = channelValue / 255;
  if (val <= 0.03928) {
    return val / 12.92;
  }
  return Math.pow((val + 0.055) / 1.055, 2.4);
}
function luminance$1(color2) {
  const c2 = rgb(color2), r = channel_luminance_value$1(c2.r), g = channel_luminance_value$1(c2.g), b2 = channel_luminance_value$1(c2.b);
  return 0.2126 * r + 0.7152 * g + 0.0722 * b2;
}
function contrast$1(color1, color2) {
  const lum1 = luminance$1(color1), lum2 = luminance$1(color2), lumL = Math.max(lum1, lum2), lumD = Math.min(lum1, lum2);
  return (lumL + 0.05) / (lumD + 0.05);
}
function merge$1() {
  const args = [].slice.call(arguments);
  args.unshift({});
  return extend(...args);
}
function equal$1(a2, b2) {
  return a2 === b2 || a2 !== a2 && b2 !== b2 ? true : isArray(a2) ? isArray(b2) && a2.length === b2.length ? equalArray$1(a2, b2) : false : isObject(a2) && isObject(b2) ? equalObject$1(a2, b2) : false;
}
function equalArray$1(a2, b2) {
  for (let i = 0, n = a2.length; i < n; ++i) {
    if (!equal$1(a2[i], b2[i]))
      return false;
  }
  return true;
}
function equalObject$1(a2, b2) {
  for (const key2 in a2) {
    if (!equal$1(a2[key2], b2[key2]))
      return false;
  }
  return true;
}
function removePredicate$1(props) {
  return (_) => equalObject$1(props, _);
}
function modify$1(name, insert2, remove2, toggle, modify2, values2) {
  const df = this.context.dataflow, data2 = this.context.data[name], input = data2.input, stamp = df.stamp();
  let changes = data2.changes, predicate, key2;
  if (df._trigger === false || !(input.value.length || insert2 || toggle)) {
    return 0;
  }
  if (!changes || changes.stamp < stamp) {
    data2.changes = changes = df.changeset();
    changes.stamp = stamp;
    df.runAfter(() => {
      data2.modified = true;
      df.pulse(input, changes).run();
    }, true, 1);
  }
  if (remove2) {
    predicate = remove2 === true ? truthy : isArray(remove2) || isTuple(remove2) ? remove2 : removePredicate$1(remove2);
    changes.remove(predicate);
  }
  if (insert2) {
    changes.insert(insert2);
  }
  if (toggle) {
    predicate = removePredicate$1(toggle);
    if (input.value.some(predicate)) {
      changes.remove(predicate);
    } else {
      changes.insert(toggle);
    }
  }
  if (modify2) {
    for (key2 in values2) {
      changes.modify(modify2, key2, values2[key2]);
    }
  }
  return 1;
}
function pinchDistance$1(event2) {
  const t = event2.touches, dx = t[0].clientX - t[1].clientX, dy = t[0].clientY - t[1].clientY;
  return Math.hypot(dx, dy);
}
function pinchAngle$1(event2) {
  const t = event2.touches;
  return Math.atan2(t[0].clientY - t[1].clientY, t[0].clientX - t[1].clientX);
}
const accessors$1 = {};
function pluck$1(data2, name) {
  const accessor2 = accessors$1[name] || (accessors$1[name] = field$1(name));
  return isArray(data2) ? data2.map(accessor2) : accessor2(data2);
}
function array$1(seq) {
  return isArray(seq) || ArrayBuffer.isView(seq) ? seq : null;
}
function sequence$1(seq) {
  return array$1(seq) || (isString(seq) ? seq : null);
}
function join$1(seq) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  return array$1(seq).join(...args);
}
function indexof$1(seq) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }
  return sequence$1(seq).indexOf(...args);
}
function lastindexof$1(seq) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }
  return sequence$1(seq).lastIndexOf(...args);
}
function slice$2(seq) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }
  return sequence$1(seq).slice(...args);
}
function replace$1(str, pattern, repl) {
  if (isFunction(repl))
    error("Function argument passed to replace.");
  return String(str).replace(pattern, repl);
}
function reverse$1(seq) {
  return array$1(seq).slice().reverse();
}
function bandspace$1(count2, paddingInner, paddingOuter) {
  return bandSpace(count2 || 0, paddingInner || 0, paddingOuter || 0);
}
function bandwidth$1(name, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return s && s.bandwidth ? s.bandwidth() : 0;
}
function copy$1(name, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return s ? s.copy() : void 0;
}
function domain$1(name, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return s ? s.domain() : [];
}
function invert$1(name, range2, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return !s ? void 0 : isArray(range2) ? (s.invertRange || s.invert)(range2) : (s.invert || s.invertExtent)(range2);
}
function range$2(name, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return s && s.range ? s.range() : [];
}
function scale$3(name, value2, group2) {
  const s = getScale$1(name, (group2 || this).context);
  return s ? s(value2) : void 0;
}
function scaleGradient$1(scale2, p02, p1, count2, group2) {
  scale2 = getScale$1(scale2, (group2 || this).context);
  const gradient2 = Gradient$1(p02, p1);
  let stops = scale2.domain(), min2 = stops[0], max2 = peek$2(stops), fraction = identity$1;
  if (!(max2 - min2)) {
    scale2 = (scale2.interpolator ? scale$5("sequential")().interpolator(scale2.interpolator()) : scale$5("linear")().interpolate(scale2.interpolate()).range(scale2.range())).domain([min2 = 0, max2 = 1]);
  } else {
    fraction = scaleFraction(scale2, min2, max2);
  }
  if (scale2.ticks) {
    stops = scale2.ticks(+count2 || 15);
    if (min2 !== stops[0])
      stops.unshift(min2);
    if (max2 !== peek$2(stops))
      stops.push(max2);
  }
  stops.forEach((_) => gradient2.stop(fraction(_), scale2(_)));
  return gradient2;
}
function geoShape$1(projection2, geojson, group2) {
  const p = getScale$1(projection2, (group2 || this).context);
  return function(context2) {
    return p ? p.path.context(context2)(geojson) : "";
  };
}
function pathShape$1(path2) {
  let p = null;
  return function(context2) {
    return context2 ? pathRender(context2, p = p || parse$3(path2)) : path2;
  };
}
const datum$1 = (d) => d.data;
function treeNodes$1(name, context2) {
  const tree2 = data$2.call(context2, name);
  return tree2.root && tree2.root.lookup || {};
}
function treePath$1(name, source2, target2) {
  const nodes = treeNodes$1(name, this), s = nodes[source2], t = nodes[target2];
  return s && t ? s.path(t).map(datum$1) : void 0;
}
function treeAncestors$1(name, node) {
  const n = treeNodes$1(name, this)[node];
  return n ? n.ancestors().map(datum$1) : void 0;
}
const _window$1 = () => typeof window !== "undefined" && window || null;
function screen$1() {
  const w2 = _window$1();
  return w2 ? w2.screen : {};
}
function windowSize$1() {
  const w2 = _window$1();
  return w2 ? [w2.innerWidth, w2.innerHeight] : [void 0, void 0];
}
function containerSize$1() {
  const view = this.context.dataflow, el = view.container && view.container();
  return el ? [el.clientWidth, el.clientHeight] : [void 0, void 0];
}
function intersect$1(b2, opt, group2) {
  if (!b2)
    return [];
  const [u2, v] = b2, box = new Bounds().set(u2[0], u2[1], v[0], v[1]), scene = group2 || this.context.dataflow.scenegraph().root;
  return intersect$3(scene, box, filter$1(opt));
}
function filter$1(opt) {
  let p = null;
  if (opt) {
    const types = array$3(opt.marktype), names = array$3(opt.markname);
    p = (_) => (!types.length || types.some((t) => _.marktype === t)) && (!names.length || names.some((s) => _.name === s));
  }
  return p;
}
function lassoAppend$1(lasso, x2, y2) {
  let minDist = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 5;
  lasso = array$3(lasso);
  const last = lasso[lasso.length - 1];
  return last === void 0 || Math.hypot(last[0] - x2, last[1] - y2) > minDist ? [...lasso, [x2, y2]] : lasso;
}
function lassoPath$1(lasso) {
  return array$3(lasso).reduce((svg, _ref, i) => {
    let [x2, y2] = _ref;
    return svg += i == 0 ? `M ${x2},${y2} ` : i === lasso.length - 1 ? " Z" : `L ${x2},${y2} `;
  }, "");
}
function intersectLasso$1(markname, pixelLasso, unit2) {
  const {
    x: x2,
    y: y2,
    mark
  } = unit2;
  const bb = new Bounds().set(Number.MAX_SAFE_INTEGER, Number.MAX_SAFE_INTEGER, Number.MIN_SAFE_INTEGER, Number.MIN_SAFE_INTEGER);
  for (const [px2, py2] of pixelLasso) {
    if (px2 < bb.x1)
      bb.x1 = px2;
    if (px2 > bb.x2)
      bb.x2 = px2;
    if (py2 < bb.y1)
      bb.y1 = py2;
    if (py2 > bb.y2)
      bb.y2 = py2;
  }
  bb.translate(x2, y2);
  const intersection2 = intersect$1([[bb.x1, bb.y1], [bb.x2, bb.y2]], markname, mark);
  return intersection2.filter((tuple) => pointInPolygon$1(tuple.x, tuple.y, pixelLasso));
}
function pointInPolygon$1(testx, testy, polygon) {
  let intersections = 0;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const [prevX, prevY] = polygon[j];
    const [x2, y2] = polygon[i];
    if (y2 > testy != prevY > testy && testx < (prevX - x2) * (testy - y2) / (prevY - y2) + x2) {
      intersections++;
    }
  }
  return intersections & 1;
}
const functionContext$1 = {
  random() {
    return random();
  },
  // override default
  cumulativeNormal,
  cumulativeLogNormal,
  cumulativeUniform,
  densityNormal,
  densityLogNormal,
  densityUniform,
  quantileNormal,
  quantileLogNormal,
  quantileUniform,
  sampleNormal,
  sampleLogNormal,
  sampleUniform,
  isArray,
  isBoolean: isBoolean$1,
  isDate: isDate$1,
  isDefined(_) {
    return _ !== void 0;
  },
  isNumber: isNumber$1,
  isObject,
  isRegExp,
  isString,
  isTuple,
  isValid(_) {
    return _ != null && _ === _;
  },
  toBoolean,
  toDate(_) {
    return toDate(_);
  },
  // suppress extra arguments
  toNumber,
  toString,
  indexof: indexof$1,
  join: join$1,
  lastindexof: lastindexof$1,
  replace: replace$1,
  reverse: reverse$1,
  slice: slice$2,
  flush,
  lerp,
  merge: merge$1,
  pad,
  peek: peek$2,
  pluck: pluck$1,
  span,
  inrange,
  truncate: truncate$1,
  rgb,
  lab: lab$1,
  hcl: hcl$1,
  hsl: hsl$2,
  luminance: luminance$1,
  contrast: contrast$1,
  sequence: range$4,
  format: format$1,
  utcFormat: utcFormat$1,
  utcParse: utcParse$1,
  utcOffset,
  utcSequence,
  timeFormat: timeFormat$1,
  timeParse: timeParse$1,
  timeOffset,
  timeSequence,
  timeUnitSpecifier,
  monthFormat: monthFormat$1,
  monthAbbrevFormat: monthAbbrevFormat$1,
  dayFormat: dayFormat$1,
  dayAbbrevFormat: dayAbbrevFormat$1,
  quarter,
  utcquarter,
  week,
  utcweek,
  dayofyear,
  utcdayofyear,
  warn: warn$1,
  info: info$1,
  debug: debug$1,
  extent(_) {
    return extent(_);
  },
  // suppress extra arguments
  inScope: inScope$1,
  intersect: intersect$1,
  clampRange,
  pinchDistance: pinchDistance$1,
  pinchAngle: pinchAngle$1,
  screen: screen$1,
  containerSize: containerSize$1,
  windowSize: windowSize$1,
  bandspace: bandspace$1,
  setdata: setdata$1,
  pathShape: pathShape$1,
  panLinear,
  panLog,
  panPow,
  panSymlog,
  zoomLinear,
  zoomLog,
  zoomPow,
  zoomSymlog,
  encode: encode$1,
  modify: modify$1,
  lassoAppend: lassoAppend$1,
  lassoPath: lassoPath$1,
  intersectLasso: intersectLasso$1
};
const eventFunctions$1 = ["view", "item", "group", "xy", "x", "y"], eventPrefix$1 = "event.vega.", thisPrefix$1 = "this.", astVisitors$1 = {};
const codegenParams$1 = {
  forbidden: ["_"],
  allowed: ["datum", "event", "item"],
  fieldvar: "datum",
  globalvar: (id2) => `_[${$(SignalPrefix$1 + id2)}]`,
  functions: buildFunctions$1,
  constants: Constants$2,
  visitors: astVisitors$1
};
const codeGenerator$1 = codegen$1(codegenParams$1);
function buildFunctions$1(codegen2) {
  const fn = Functions$2(codegen2);
  eventFunctions$1.forEach((name) => fn[name] = eventPrefix$1 + name);
  for (const name in functionContext$1) {
    fn[name] = thisPrefix$1 + name;
  }
  extend(fn, internalScaleFunctions$1(codegen2, functionContext$1, astVisitors$1));
  return fn;
}
function expressionFunction$1(name, fn, visitor) {
  if (arguments.length === 1) {
    return functionContext$1[name];
  }
  functionContext$1[name] = fn;
  if (visitor)
    astVisitors$1[name] = visitor;
  if (codeGenerator$1)
    codeGenerator$1.functions[name] = thisPrefix$1 + name;
  return this;
}
expressionFunction$1("bandwidth", bandwidth$1, scaleVisitor$1);
expressionFunction$1("copy", copy$1, scaleVisitor$1);
expressionFunction$1("domain", domain$1, scaleVisitor$1);
expressionFunction$1("range", range$2, scaleVisitor$1);
expressionFunction$1("invert", invert$1, scaleVisitor$1);
expressionFunction$1("scale", scale$3, scaleVisitor$1);
expressionFunction$1("gradient", scaleGradient$1, scaleVisitor$1);
expressionFunction$1("geoArea", geoArea$1, scaleVisitor$1);
expressionFunction$1("geoBounds", geoBounds$1, scaleVisitor$1);
expressionFunction$1("geoCentroid", geoCentroid$1, scaleVisitor$1);
expressionFunction$1("geoShape", geoShape$1, scaleVisitor$1);
expressionFunction$1("geoScale", geoScale, scaleVisitor$1);
expressionFunction$1("indata", indata$1, indataVisitor$1);
expressionFunction$1("data", data$2, dataVisitor$1);
expressionFunction$1("treePath", treePath$1, dataVisitor$1);
expressionFunction$1("treeAncestors", treeAncestors$1, dataVisitor$1);
expressionFunction$1("vlSelectionTest", selectionTest, selectionVisitor);
expressionFunction$1("vlSelectionIdTest", selectionIdTest, selectionVisitor);
expressionFunction$1("vlSelectionResolve", selectionResolve, selectionVisitor);
expressionFunction$1("vlSelectionTuples", selectionTuples);
function parser$1(expr2, scope) {
  const params2 = {};
  let ast;
  try {
    expr2 = isString(expr2) ? expr2 : $(expr2) + "";
    ast = parser$2(expr2);
  } catch (err) {
    error("Expression parse error: " + expr2);
  }
  ast.visit((node) => {
    if (node.type !== CallExpression$1)
      return;
    const name = node.callee.name, visit2 = codegenParams$1.visitors[name];
    if (visit2)
      visit2(name, node.arguments, scope, params2);
  });
  const gen = codeGenerator$1(ast);
  gen.globals.forEach((name) => {
    const signalName = SignalPrefix$1 + name;
    if (!has$1(params2, signalName) && scope.getSignal(name)) {
      params2[signalName] = scope.signalRef(name);
    }
  });
  return {
    $expr: extend({
      code: gen.code
    }, scope.options.ast ? {
      ast
    } : null),
    $fields: gen.fields,
    $params: params2
  };
}
function parse$2(spec) {
  const ctx = this, operators = spec.operators || [];
  if (spec.background) {
    ctx.background = spec.background;
  }
  if (spec.eventConfig) {
    ctx.eventConfig = spec.eventConfig;
  }
  if (spec.locale) {
    ctx.locale = spec.locale;
  }
  operators.forEach((entry2) => ctx.parseOperator(entry2));
  operators.forEach((entry2) => ctx.parseOperatorParameters(entry2));
  (spec.streams || []).forEach((entry2) => ctx.parseStream(entry2));
  (spec.updates || []).forEach((entry2) => ctx.parseUpdate(entry2));
  return ctx.resolve();
}
const Skip$2 = toSet(["rule"]), Swap = toSet(["group", "image", "rect"]);
function adjustSpatial$1(encode2, marktype) {
  let code = "";
  if (Skip$2[marktype])
    return code;
  if (encode2.x2) {
    if (encode2.x) {
      if (Swap[marktype]) {
        code += "if(o.x>o.x2)$=o.x,o.x=o.x2,o.x2=$;";
      }
      code += "o.width=o.x2-o.x;";
    } else {
      code += "o.x=o.x2-(o.width||0);";
    }
  }
  if (encode2.xc) {
    code += "o.x=o.xc-(o.width||0)/2;";
  }
  if (encode2.y2) {
    if (encode2.y) {
      if (Swap[marktype]) {
        code += "if(o.y>o.y2)$=o.y,o.y=o.y2,o.y2=$;";
      }
      code += "o.height=o.y2-o.y;";
    } else {
      code += "o.y=o.y2-(o.height||0);";
    }
  }
  if (encode2.yc) {
    code += "o.y=o.yc-(o.height||0)/2;";
  }
  return code;
}
function canonicalType(type2) {
  return (type2 + "").toLowerCase();
}
function isOperator(type2) {
  return canonicalType(type2) === "operator";
}
function isCollect(type2) {
  return canonicalType(type2) === "collect";
}
function expression$1(ctx, args, code) {
  if (!code.endsWith(";")) {
    code = "return(" + code + ");";
  }
  const fn = Function(...args.concat(code));
  return ctx && ctx.functions ? fn.bind(ctx.functions) : fn;
}
function _compare(u2, v, lt, gt) {
  return `((u = ${u2}) < (v = ${v}) || u == null) && v != null ? ${lt}
  : (u > v || v == null) && u != null ? ${gt}
  : ((v = v instanceof Date ? +v : v), (u = u instanceof Date ? +u : u)) !== u && v === v ? ${lt}
  : v !== v && u === u ? ${gt} : `;
}
var expressionCodegen = {
  /**
   * Parse an expression used to update an operator value.
   */
  operator: (ctx, expr2) => expression$1(ctx, ["_"], expr2.code),
  /**
   * Parse an expression provided as an operator parameter value.
   */
  parameter: (ctx, expr2) => expression$1(ctx, ["datum", "_"], expr2.code),
  /**
   * Parse an expression applied to an event stream.
   */
  event: (ctx, expr2) => expression$1(ctx, ["event"], expr2.code),
  /**
   * Parse an expression used to handle an event-driven operator update.
   */
  handler: (ctx, expr2) => {
    const code = `var datum=event.item&&event.item.datum;return ${expr2.code};`;
    return expression$1(ctx, ["_", "event"], code);
  },
  /**
   * Parse an expression that performs visual encoding.
   */
  encode: (ctx, encode2) => {
    const {
      marktype,
      channels
    } = encode2;
    let code = "var o=item,datum=o.datum,m=0,$;";
    for (const name in channels) {
      const o = "o[" + $(name) + "]";
      code += `$=${channels[name].code};if(${o}!==$)${o}=$,m=1;`;
    }
    code += adjustSpatial$1(channels, marktype);
    code += "return m;";
    return expression$1(ctx, ["item", "_"], code);
  },
  /**
   * Optimized code generators for access and comparison.
   */
  codegen: {
    get(path2) {
      const ref2 = `[${path2.map($).join("][")}]`;
      const get2 = Function("_", `return _${ref2};`);
      get2.path = ref2;
      return get2;
    },
    comparator(fields, orders) {
      let t;
      const map2 = (f, i) => {
        const o = orders[i];
        let u2, v;
        if (f.path) {
          u2 = `a${f.path}`;
          v = `b${f.path}`;
        } else {
          (t = t || {})["f" + i] = f;
          u2 = `this.f${i}(a)`;
          v = `this.f${i}(b)`;
        }
        return _compare(u2, v, -o, o);
      };
      const fn = Function("a", "b", "var u, v; return " + fields.map(map2).join("") + "0;");
      return t ? fn.bind(t) : fn;
    }
  }
};
function parseOperator(spec) {
  const ctx = this;
  if (isOperator(spec.type) || !spec.type) {
    ctx.operator(spec, spec.update ? ctx.operatorExpression(spec.update) : null);
  } else {
    ctx.transform(spec, spec.type);
  }
}
function parseOperatorParameters(spec) {
  const ctx = this;
  if (spec.params) {
    const op = ctx.get(spec.id);
    if (!op)
      error("Invalid operator id: " + spec.id);
    ctx.dataflow.connect(op, op.parameters(ctx.parseParameters(spec.params), spec.react, spec.initonly));
  }
}
function parseParameters$1(spec, params2) {
  params2 = params2 || {};
  const ctx = this;
  for (const key2 in spec) {
    const value2 = spec[key2];
    params2[key2] = isArray(value2) ? value2.map((v) => parseParameter$2(v, ctx, params2)) : parseParameter$2(value2, ctx, params2);
  }
  return params2;
}
function parseParameter$2(spec, ctx, params2) {
  if (!spec || !isObject(spec))
    return spec;
  for (let i = 0, n = PARSERS.length, p; i < n; ++i) {
    p = PARSERS[i];
    if (has$1(spec, p.key)) {
      return p.parse(spec, ctx, params2);
    }
  }
  return spec;
}
var PARSERS = [{
  key: "$ref",
  parse: getOperator
}, {
  key: "$key",
  parse: getKey
}, {
  key: "$expr",
  parse: getExpression
}, {
  key: "$field",
  parse: getField
}, {
  key: "$encode",
  parse: getEncode
}, {
  key: "$compare",
  parse: getCompare
}, {
  key: "$context",
  parse: getContext
}, {
  key: "$subflow",
  parse: getSubflow
}, {
  key: "$tupleid",
  parse: getTupleId
}];
function getOperator(_, ctx) {
  return ctx.get(_.$ref) || error("Operator not defined: " + _.$ref);
}
function getExpression(_, ctx, params2) {
  if (_.$params) {
    ctx.parseParameters(_.$params, params2);
  }
  const k = "e:" + _.$expr.code;
  return ctx.fn[k] || (ctx.fn[k] = accessor(ctx.parameterExpression(_.$expr), _.$fields));
}
function getKey(_, ctx) {
  const k = "k:" + _.$key + "_" + !!_.$flat;
  return ctx.fn[k] || (ctx.fn[k] = key(_.$key, _.$flat, ctx.expr.codegen));
}
function getField(_, ctx) {
  if (!_.$field)
    return null;
  const k = "f:" + _.$field + "_" + _.$name;
  return ctx.fn[k] || (ctx.fn[k] = field$1(_.$field, _.$name, ctx.expr.codegen));
}
function getCompare(_, ctx) {
  const k = "c:" + _.$compare + "_" + _.$order, c2 = array$3(_.$compare).map((_2) => _2 && _2.$tupleid ? tupleid : _2);
  return ctx.fn[k] || (ctx.fn[k] = compare$1(c2, _.$order, ctx.expr.codegen));
}
function getEncode(_, ctx) {
  const spec = _.$encode, encode2 = {};
  for (const name in spec) {
    const enc = spec[name];
    encode2[name] = accessor(ctx.encodeExpression(enc.$expr), enc.$fields);
    encode2[name].output = enc.$output;
  }
  return encode2;
}
function getContext(_, ctx) {
  return ctx;
}
function getSubflow(_, ctx) {
  const spec = _.$subflow;
  return function(dataflow, key2, parent) {
    const subctx = ctx.fork().parse(spec), op = subctx.get(spec.operators[0].id), p = subctx.signals.parent;
    if (p)
      p.set(parent);
    op.detachSubflow = () => ctx.detach(subctx);
    return op;
  };
}
function getTupleId() {
  return tupleid;
}
function parseStream$2(spec) {
  var ctx = this, filter2 = spec.filter != null ? ctx.eventExpression(spec.filter) : void 0, stream2 = spec.stream != null ? ctx.get(spec.stream) : void 0, args;
  if (spec.source) {
    stream2 = ctx.events(spec.source, spec.type, filter2);
  } else if (spec.merge) {
    args = spec.merge.map((_) => ctx.get(_));
    stream2 = args[0].merge.apply(args[0], args.slice(1));
  }
  if (spec.between) {
    args = spec.between.map((_) => ctx.get(_));
    stream2 = stream2.between(args[0], args[1]);
  }
  if (spec.filter) {
    stream2 = stream2.filter(filter2);
  }
  if (spec.throttle != null) {
    stream2 = stream2.throttle(+spec.throttle);
  }
  if (spec.debounce != null) {
    stream2 = stream2.debounce(+spec.debounce);
  }
  if (stream2 == null) {
    error("Invalid stream definition: " + JSON.stringify(spec));
  }
  if (spec.consume)
    stream2.consume(true);
  ctx.stream(spec, stream2);
}
function parseUpdate$1(spec) {
  var ctx = this, srcid = isObject(srcid = spec.source) ? srcid.$ref : srcid, source2 = ctx.get(srcid), target2 = null, update2 = spec.update, params2 = void 0;
  if (!source2)
    error("Source not defined: " + spec.source);
  target2 = spec.target && spec.target.$expr ? ctx.eventExpression(spec.target.$expr) : ctx.get(spec.target);
  if (update2 && update2.$expr) {
    if (update2.$params) {
      params2 = ctx.parseParameters(update2.$params);
    }
    update2 = ctx.handlerExpression(update2.$expr);
  }
  ctx.update(spec, source2, target2, update2, params2);
}
const SKIP = {
  skip: true
};
function getState$1(options) {
  var ctx = this, state = {};
  if (options.signals) {
    var signals = state.signals = {};
    Object.keys(ctx.signals).forEach((key2) => {
      const op = ctx.signals[key2];
      if (options.signals(key2, op)) {
        signals[key2] = op.value;
      }
    });
  }
  if (options.data) {
    var data2 = state.data = {};
    Object.keys(ctx.data).forEach((key2) => {
      const dataset = ctx.data[key2];
      if (options.data(key2, dataset)) {
        data2[key2] = dataset.input.value;
      }
    });
  }
  if (ctx.subcontext && options.recurse !== false) {
    state.subcontext = ctx.subcontext.map((ctx2) => ctx2.getState(options));
  }
  return state;
}
function setState$1(state) {
  var ctx = this, df = ctx.dataflow, data2 = state.data, signals = state.signals;
  Object.keys(signals || {}).forEach((key2) => {
    df.update(ctx.signals[key2], signals[key2], SKIP);
  });
  Object.keys(data2 || {}).forEach((key2) => {
    df.pulse(ctx.data[key2].input, df.changeset().remove(truthy).insert(data2[key2]));
  });
  (state.subcontext || []).forEach((substate, i) => {
    const subctx = ctx.subcontext[i];
    if (subctx)
      subctx.setState(substate);
  });
}
function context(df, transforms2, functions, expr2) {
  return new Context(df, transforms2, functions, expr2);
}
function Context(df, transforms2, functions, expr2) {
  this.dataflow = df;
  this.transforms = transforms2;
  this.events = df.events.bind(df);
  this.expr = expr2 || expressionCodegen, this.signals = {};
  this.scales = {};
  this.nodes = {};
  this.data = {};
  this.fn = {};
  if (functions) {
    this.functions = Object.create(functions);
    this.functions.context = this;
  }
}
function Subcontext(ctx) {
  this.dataflow = ctx.dataflow;
  this.transforms = ctx.transforms;
  this.events = ctx.events;
  this.expr = ctx.expr;
  this.signals = Object.create(ctx.signals);
  this.scales = Object.create(ctx.scales);
  this.nodes = Object.create(ctx.nodes);
  this.data = Object.create(ctx.data);
  this.fn = Object.create(ctx.fn);
  if (ctx.functions) {
    this.functions = Object.create(ctx.functions);
    this.functions.context = this;
  }
}
Context.prototype = Subcontext.prototype = {
  fork() {
    const ctx = new Subcontext(this);
    (this.subcontext || (this.subcontext = [])).push(ctx);
    return ctx;
  },
  detach(ctx) {
    this.subcontext = this.subcontext.filter((c2) => c2 !== ctx);
    const keys2 = Object.keys(ctx.nodes);
    for (const key2 of keys2)
      ctx.nodes[key2]._targets = null;
    for (const key2 of keys2)
      ctx.nodes[key2].detach();
    ctx.nodes = null;
  },
  get(id2) {
    return this.nodes[id2];
  },
  set(id2, node) {
    return this.nodes[id2] = node;
  },
  add(spec, op) {
    const ctx = this, df = ctx.dataflow, data2 = spec.value;
    ctx.set(spec.id, op);
    if (isCollect(spec.type) && data2) {
      if (data2.$ingest) {
        df.ingest(op, data2.$ingest, data2.$format);
      } else if (data2.$request) {
        df.preload(op, data2.$request, data2.$format);
      } else {
        df.pulse(op, df.changeset().insert(data2));
      }
    }
    if (spec.root) {
      ctx.root = op;
    }
    if (spec.parent) {
      let p = ctx.get(spec.parent.$ref);
      if (p) {
        df.connect(p, [op]);
        op.targets().add(p);
      } else {
        (ctx.unresolved = ctx.unresolved || []).push(() => {
          p = ctx.get(spec.parent.$ref);
          df.connect(p, [op]);
          op.targets().add(p);
        });
      }
    }
    if (spec.signal) {
      ctx.signals[spec.signal] = op;
    }
    if (spec.scale) {
      ctx.scales[spec.scale] = op;
    }
    if (spec.data) {
      for (const name in spec.data) {
        const data3 = ctx.data[name] || (ctx.data[name] = {});
        spec.data[name].forEach((role) => data3[role] = op);
      }
    }
  },
  resolve() {
    (this.unresolved || []).forEach((fn) => fn());
    delete this.unresolved;
    return this;
  },
  operator(spec, update2) {
    this.add(spec, this.dataflow.add(spec.value, update2));
  },
  transform(spec, type2) {
    this.add(spec, this.dataflow.add(this.transforms[canonicalType(type2)]));
  },
  stream(spec, stream2) {
    this.set(spec.id, stream2);
  },
  update(spec, stream2, target2, update2, params2) {
    this.dataflow.on(stream2, target2, update2, params2, spec.options);
  },
  // expression parsing
  operatorExpression(expr2) {
    return this.expr.operator(this, expr2);
  },
  parameterExpression(expr2) {
    return this.expr.parameter(this, expr2);
  },
  eventExpression(expr2) {
    return this.expr.event(this, expr2);
  },
  handlerExpression(expr2) {
    return this.expr.handler(this, expr2);
  },
  encodeExpression(encode2) {
    return this.expr.encode(this, encode2);
  },
  // parse methods
  parse: parse$2,
  parseOperator,
  parseOperatorParameters,
  parseParameters: parseParameters$1,
  parseStream: parseStream$2,
  parseUpdate: parseUpdate$1,
  // state methods
  getState: getState$1,
  setState: setState$1
};
function initializeAria(view) {
  const el = view.container();
  if (el) {
    el.setAttribute("role", "graphics-document");
    el.setAttribute("aria-roleDescription", "visualization");
    ariaLabel(el, view.description());
  }
}
function ariaLabel(el, desc) {
  if (el)
    desc == null ? el.removeAttribute("aria-label") : el.setAttribute("aria-label", desc);
}
function background(view) {
  view.add(null, (_) => {
    view._background = _.bg;
    view._resize = 1;
    return _.bg;
  }, {
    bg: view._signals.background
  });
}
const Default = "default";
function cursor(view) {
  const cursor2 = view._signals.cursor || (view._signals.cursor = view.add({
    user: Default,
    item: null
  }));
  view.on(view.events("view", "mousemove"), cursor2, (_, event2) => {
    const value2 = cursor2.value, user = value2 ? isString(value2) ? value2 : value2.user : Default, item = event2.item && event2.item.cursor || null;
    return value2 && user === value2.user && item == value2.item ? value2 : {
      user,
      item
    };
  });
  view.add(null, function(_) {
    let user = _.cursor, item = this.value;
    if (!isString(user)) {
      item = user.item;
      user = user.user;
    }
    setCursor(view, user && user !== Default ? user : item || user);
    return item;
  }, {
    cursor: cursor2
  });
}
function setCursor(view, cursor2) {
  const el = view.globalCursor() ? typeof document !== "undefined" && document.body : view.container();
  if (el) {
    return cursor2 == null ? el.style.removeProperty("cursor") : el.style.cursor = cursor2;
  }
}
function dataref(view, name) {
  var data2 = view._runtime.data;
  if (!has$1(data2, name)) {
    error("Unrecognized data set: " + name);
  }
  return data2[name];
}
function data$1(name, values2) {
  return arguments.length < 2 ? dataref(this, name).values.value : change.call(this, name, changeset().remove(truthy).insert(values2));
}
function change(name, changes) {
  if (!isChangeSet(changes)) {
    error("Second argument to changes must be a changeset.");
  }
  const dataset = dataref(this, name);
  dataset.modified = true;
  return this.pulse(dataset.input, changes);
}
function insert(name, _) {
  return change.call(this, name, changeset().insert(_));
}
function remove(name, _) {
  return change.call(this, name, changeset().remove(_));
}
function width(view) {
  var padding2 = view.padding();
  return Math.max(0, view._viewWidth + padding2.left + padding2.right);
}
function height(view) {
  var padding2 = view.padding();
  return Math.max(0, view._viewHeight + padding2.top + padding2.bottom);
}
function offset(view) {
  var padding2 = view.padding(), origin = view._origin;
  return [padding2.left + origin[0], padding2.top + origin[1]];
}
function resizeRenderer(view) {
  var origin = offset(view), w2 = width(view), h2 = height(view);
  view._renderer.background(view.background());
  view._renderer.resize(w2, h2, origin);
  view._handler.origin(origin);
  view._resizeListeners.forEach((handler) => {
    try {
      handler(w2, h2);
    } catch (error2) {
      view.error(error2);
    }
  });
}
function eventExtend(view, event2, item) {
  var r = view._renderer, el = r && r.canvas(), p, e, translate2;
  if (el) {
    translate2 = offset(view);
    e = event2.changedTouches ? event2.changedTouches[0] : event2;
    p = point(e, el);
    p[0] -= translate2[0];
    p[1] -= translate2[1];
  }
  event2.dataflow = view;
  event2.item = item;
  event2.vega = extension(view, item, p);
  return event2;
}
function extension(view, item, point2) {
  const itemGroup = item ? item.mark.marktype === "group" ? item : item.mark.group : null;
  function group2(name) {
    var g = itemGroup, i;
    if (name)
      for (i = item; i; i = i.mark.group) {
        if (i.mark.name === name) {
          g = i;
          break;
        }
      }
    return g && g.mark && g.mark.interactive ? g : {};
  }
  function xy(item2) {
    if (!item2)
      return point2;
    if (isString(item2))
      item2 = group2(item2);
    const p = point2.slice();
    while (item2) {
      p[0] -= item2.x || 0;
      p[1] -= item2.y || 0;
      item2 = item2.mark && item2.mark.group;
    }
    return p;
  }
  return {
    view: constant(view),
    item: constant(item || {}),
    group: group2,
    xy,
    x: (item2) => xy(item2)[0],
    y: (item2) => xy(item2)[1]
  };
}
const VIEW$1 = "view", TIMER = "timer", WINDOW = "window", NO_TRAP = {
  trap: false
};
function initializeEventConfig(config) {
  const events2 = extend({
    defaults: {}
  }, config);
  const unpack = (obj, keys2) => {
    keys2.forEach((k) => {
      if (isArray(obj[k]))
        obj[k] = toSet(obj[k]);
    });
  };
  unpack(events2.defaults, ["prevent", "allow"]);
  unpack(events2, ["view", "window", "selector"]);
  return events2;
}
function trackEventListener(view, sources, type2, handler) {
  view._eventListeners.push({
    type: type2,
    sources: array$3(sources),
    handler
  });
}
function prevent(view, type2) {
  var def2 = view._eventConfig.defaults, prevent2 = def2.prevent, allow = def2.allow;
  return prevent2 === false || allow === true ? false : prevent2 === true || allow === false ? true : prevent2 ? prevent2[type2] : allow ? !allow[type2] : view.preventDefault();
}
function permit(view, key2, type2) {
  const rule2 = view._eventConfig && view._eventConfig[key2];
  if (rule2 === false || isObject(rule2) && !rule2[type2]) {
    view.warn(`Blocked ${key2} ${type2} event listener.`);
    return false;
  }
  return true;
}
function events(source2, type2, filter2) {
  var view = this, s = new EventStream(filter2), send = function(e, item) {
    view.runAsync(null, () => {
      if (source2 === VIEW$1 && prevent(view, type2)) {
        e.preventDefault();
      }
      s.receive(eventExtend(view, e, item));
    });
  }, sources;
  if (source2 === TIMER) {
    if (permit(view, "timer", type2)) {
      view.timer(send, type2);
    }
  } else if (source2 === VIEW$1) {
    if (permit(view, "view", type2)) {
      view.addEventListener(type2, send, NO_TRAP);
    }
  } else {
    if (source2 === WINDOW) {
      if (permit(view, "window", type2) && typeof window !== "undefined") {
        sources = [window];
      }
    } else if (typeof document !== "undefined") {
      if (permit(view, "selector", type2)) {
        sources = Array.from(document.querySelectorAll(source2));
      }
    }
    if (!sources) {
      view.warn("Can not resolve event source: " + source2);
    } else {
      for (var i = 0, n = sources.length; i < n; ++i) {
        sources[i].addEventListener(type2, send);
      }
      trackEventListener(view, sources, type2, send);
    }
  }
  return s;
}
function itemFilter(event2) {
  return event2.item;
}
function markTarget(event2) {
  return event2.item.mark.source;
}
function invoke(name) {
  return function(_, event2) {
    return event2.vega.view().changeset().encode(event2.item, name);
  };
}
function hover(hoverSet, leaveSet) {
  hoverSet = [hoverSet || "hover"];
  leaveSet = [leaveSet || "update", hoverSet[0]];
  this.on(this.events("view", "mouseover", itemFilter), markTarget, invoke(hoverSet));
  this.on(this.events("view", "mouseout", itemFilter), markTarget, invoke(leaveSet));
  return this;
}
function finalize() {
  var tooltip = this._tooltip, timers = this._timers, listeners = this._eventListeners, n, m2, e;
  n = timers.length;
  while (--n >= 0) {
    timers[n].stop();
  }
  n = listeners.length;
  while (--n >= 0) {
    e = listeners[n];
    m2 = e.sources.length;
    while (--m2 >= 0) {
      e.sources[m2].removeEventListener(e.type, e.handler);
    }
  }
  if (tooltip) {
    tooltip.call(this, this._handler, null, null, null);
  }
  return this;
}
function element(tag, attr2, text2) {
  const el = document.createElement(tag);
  for (const key2 in attr2)
    el.setAttribute(key2, attr2[key2]);
  if (text2 != null)
    el.textContent = text2;
  return el;
}
const BindClass = "vega-bind", NameClass = "vega-bind-name", RadioClass = "vega-bind-radio";
function bind(view, el, binding) {
  if (!el)
    return;
  const param2 = binding.param;
  let bind2 = binding.state;
  if (!bind2) {
    bind2 = binding.state = {
      elements: null,
      active: false,
      set: null,
      update: (value2) => {
        if (value2 != view.signal(param2.signal)) {
          view.runAsync(null, () => {
            bind2.source = true;
            view.signal(param2.signal, value2);
          });
        }
      }
    };
    if (param2.debounce) {
      bind2.update = debounce(param2.debounce, bind2.update);
    }
  }
  const create2 = param2.input == null && param2.element ? target : generate;
  create2(bind2, el, param2, view);
  if (!bind2.active) {
    view.on(view._signals[param2.signal], null, () => {
      bind2.source ? bind2.source = false : bind2.set(view.signal(param2.signal));
    });
    bind2.active = true;
  }
  return bind2;
}
function target(bind2, node, param2, view) {
  const type2 = param2.event || "input";
  const handler = () => bind2.update(node.value);
  view.signal(param2.signal, node.value);
  node.addEventListener(type2, handler);
  trackEventListener(view, node, type2, handler);
  bind2.set = (value2) => {
    node.value = value2;
    node.dispatchEvent(event(type2));
  };
}
function event(type2) {
  return typeof Event !== "undefined" ? new Event(type2) : {
    type: type2
  };
}
function generate(bind2, el, param2, view) {
  const value2 = view.signal(param2.signal);
  const div = element("div", {
    "class": BindClass
  });
  const wrapper = param2.input === "radio" ? div : div.appendChild(element("label"));
  wrapper.appendChild(element("span", {
    "class": NameClass
  }, param2.name || param2.signal));
  el.appendChild(div);
  let input = form;
  switch (param2.input) {
    case "checkbox":
      input = checkbox;
      break;
    case "select":
      input = select;
      break;
    case "radio":
      input = radio;
      break;
    case "range":
      input = range$1;
      break;
  }
  input(bind2, wrapper, param2, value2);
}
function form(bind2, el, param2, value2) {
  const node = element("input");
  for (const key2 in param2) {
    if (key2 !== "signal" && key2 !== "element") {
      node.setAttribute(key2 === "input" ? "type" : key2, param2[key2]);
    }
  }
  node.setAttribute("name", param2.signal);
  node.value = value2;
  el.appendChild(node);
  node.addEventListener("input", () => bind2.update(node.value));
  bind2.elements = [node];
  bind2.set = (value3) => node.value = value3;
}
function checkbox(bind2, el, param2, value2) {
  const attr2 = {
    type: "checkbox",
    name: param2.signal
  };
  if (value2)
    attr2.checked = true;
  const node = element("input", attr2);
  el.appendChild(node);
  node.addEventListener("change", () => bind2.update(node.checked));
  bind2.elements = [node];
  bind2.set = (value3) => node.checked = !!value3 || null;
}
function select(bind2, el, param2, value2) {
  const node = element("select", {
    name: param2.signal
  }), labels = param2.labels || [];
  param2.options.forEach((option, i) => {
    const attr2 = {
      value: option
    };
    if (valuesEqual(option, value2))
      attr2.selected = true;
    node.appendChild(element("option", attr2, (labels[i] || option) + ""));
  });
  el.appendChild(node);
  node.addEventListener("change", () => {
    bind2.update(param2.options[node.selectedIndex]);
  });
  bind2.elements = [node];
  bind2.set = (value3) => {
    for (let i = 0, n = param2.options.length; i < n; ++i) {
      if (valuesEqual(param2.options[i], value3)) {
        node.selectedIndex = i;
        return;
      }
    }
  };
}
function radio(bind2, el, param2, value2) {
  const group2 = element("span", {
    "class": RadioClass
  }), labels = param2.labels || [];
  el.appendChild(group2);
  bind2.elements = param2.options.map((option, i) => {
    const attr2 = {
      type: "radio",
      name: param2.signal,
      value: option
    };
    if (valuesEqual(option, value2))
      attr2.checked = true;
    const input = element("input", attr2);
    input.addEventListener("change", () => bind2.update(option));
    const label2 = element("label", {}, (labels[i] || option) + "");
    label2.prepend(input);
    group2.appendChild(label2);
    return input;
  });
  bind2.set = (value3) => {
    const nodes = bind2.elements, n = nodes.length;
    for (let i = 0; i < n; ++i) {
      if (valuesEqual(nodes[i].value, value3))
        nodes[i].checked = true;
    }
  };
}
function range$1(bind2, el, param2, value2) {
  value2 = value2 !== void 0 ? value2 : (+param2.max + +param2.min) / 2;
  const max2 = param2.max != null ? param2.max : Math.max(100, +value2) || 100, min2 = param2.min || Math.min(0, max2, +value2) || 0, step = param2.step || tickStep(min2, max2, 100);
  const node = element("input", {
    type: "range",
    name: param2.signal,
    min: min2,
    max: max2,
    step
  });
  node.value = value2;
  const span2 = element("span", {}, +value2);
  el.appendChild(node);
  el.appendChild(span2);
  const update2 = () => {
    span2.textContent = node.value;
    bind2.update(+node.value);
  };
  node.addEventListener("input", update2);
  node.addEventListener("change", update2);
  bind2.elements = [node];
  bind2.set = (value3) => {
    node.value = value3;
    span2.textContent = value3;
  };
}
function valuesEqual(a2, b2) {
  return a2 === b2 || a2 + "" === b2 + "";
}
function initializeRenderer(view, r, el, constructor, scaleFactor, opt) {
  r = r || new constructor(view.loader());
  return r.initialize(el, width(view), height(view), offset(view), scaleFactor, opt).background(view.background());
}
function trap(view, fn) {
  return !fn ? null : function() {
    try {
      fn.apply(this, arguments);
    } catch (error2) {
      view.error(error2);
    }
  };
}
function initializeHandler(view, prevHandler, el, constructor) {
  const handler = new constructor(view.loader(), trap(view, view.tooltip())).scene(view.scenegraph().root).initialize(el, offset(view), view);
  if (prevHandler) {
    prevHandler.handlers().forEach((h2) => {
      handler.on(h2.type, h2.handler);
    });
  }
  return handler;
}
function initialize(el, elBind) {
  const view = this, type2 = view._renderType, config = view._eventConfig.bind, module = renderModule(type2);
  el = view._el = el ? lookup$1(view, el, true) : null;
  initializeAria(view);
  if (!module)
    view.error("Unrecognized renderer type: " + type2);
  const Handler2 = module.handler || CanvasHandler, Renderer2 = el ? module.renderer : module.headless;
  view._renderer = !Renderer2 ? null : initializeRenderer(view, view._renderer, el, Renderer2);
  view._handler = initializeHandler(view, view._handler, el, Handler2);
  view._redraw = true;
  if (el && config !== "none") {
    elBind = elBind ? view._elBind = lookup$1(view, elBind, true) : el.appendChild(element("form", {
      "class": "vega-bindings"
    }));
    view._bind.forEach((_) => {
      if (_.param.element && config !== "container") {
        _.element = lookup$1(view, _.param.element, !!_.param.input);
      }
    });
    view._bind.forEach((_) => {
      bind(view, _.element || elBind, _);
    });
  }
  return view;
}
function lookup$1(view, el, clear) {
  if (typeof el === "string") {
    if (typeof document !== "undefined") {
      el = document.querySelector(el);
      if (!el) {
        view.error("Signal bind element not found: " + el);
        return null;
      }
    } else {
      view.error("DOM document instance not found.");
      return null;
    }
  }
  if (el && clear) {
    try {
      el.textContent = "";
    } catch (e) {
      el = null;
      view.error(e);
    }
  }
  return el;
}
const number$1 = (_) => +_ || 0;
const paddingObject$1 = (_) => ({
  top: _,
  bottom: _,
  left: _,
  right: _
});
function padding(_) {
  return isObject(_) ? {
    top: number$1(_.top),
    bottom: number$1(_.bottom),
    left: number$1(_.left),
    right: number$1(_.right)
  } : paddingObject$1(number$1(_));
}
async function renderHeadless(view, type2, scaleFactor, opt) {
  const module = renderModule(type2), ctr = module && module.headless;
  if (!ctr)
    error("Unrecognized renderer type: " + type2);
  await view.runAsync();
  return initializeRenderer(view, null, null, ctr, scaleFactor, opt).renderAsync(view._scenegraph.root);
}
async function renderToImageURL(type2, scaleFactor) {
  if (type2 !== RenderType.Canvas && type2 !== RenderType.SVG && type2 !== RenderType.PNG) {
    error("Unrecognized image type: " + type2);
  }
  const r = await renderHeadless(this, type2, scaleFactor);
  return type2 === RenderType.SVG ? toBlobURL(r.svg(), "image/svg+xml") : r.canvas().toDataURL("image/png");
}
function toBlobURL(data2, mime) {
  const blob = new Blob([data2], {
    type: mime
  });
  return window.URL.createObjectURL(blob);
}
async function renderToCanvas(scaleFactor, opt) {
  const r = await renderHeadless(this, RenderType.Canvas, scaleFactor, opt);
  return r.canvas();
}
async function renderToSVG(scaleFactor) {
  const r = await renderHeadless(this, RenderType.SVG, scaleFactor);
  return r.svg();
}
function runtime(view, spec, expr2) {
  return context(view, transforms, functionContext$1, expr2).parse(spec);
}
function scale$2(name) {
  var scales2 = this._runtime.scales;
  if (!has$1(scales2, name)) {
    error("Unrecognized scale or projection: " + name);
  }
  return scales2[name].value;
}
var Width = "width", Height = "height", Padding = "padding", Skip$1 = {
  skip: true
};
function viewWidth(view, width2) {
  var a2 = view.autosize(), p = view.padding();
  return width2 - (a2 && a2.contains === Padding ? p.left + p.right : 0);
}
function viewHeight(view, height2) {
  var a2 = view.autosize(), p = view.padding();
  return height2 - (a2 && a2.contains === Padding ? p.top + p.bottom : 0);
}
function initializeResize(view) {
  var s = view._signals, w2 = s[Width], h2 = s[Height], p = s[Padding];
  function resetSize() {
    view._autosize = view._resize = 1;
  }
  view._resizeWidth = view.add(null, (_) => {
    view._width = _.size;
    view._viewWidth = viewWidth(view, _.size);
    resetSize();
  }, {
    size: w2
  });
  view._resizeHeight = view.add(null, (_) => {
    view._height = _.size;
    view._viewHeight = viewHeight(view, _.size);
    resetSize();
  }, {
    size: h2
  });
  const resizePadding = view.add(null, resetSize, {
    pad: p
  });
  view._resizeWidth.rank = w2.rank + 1;
  view._resizeHeight.rank = h2.rank + 1;
  resizePadding.rank = p.rank + 1;
}
function resizeView(viewWidth2, viewHeight2, width2, height2, origin, auto) {
  this.runAfter((view) => {
    let rerun2 = 0;
    view._autosize = 0;
    if (view.width() !== width2) {
      rerun2 = 1;
      view.signal(Width, width2, Skip$1);
      view._resizeWidth.skip(true);
    }
    if (view.height() !== height2) {
      rerun2 = 1;
      view.signal(Height, height2, Skip$1);
      view._resizeHeight.skip(true);
    }
    if (view._viewWidth !== viewWidth2) {
      view._resize = 1;
      view._viewWidth = viewWidth2;
    }
    if (view._viewHeight !== viewHeight2) {
      view._resize = 1;
      view._viewHeight = viewHeight2;
    }
    if (view._origin[0] !== origin[0] || view._origin[1] !== origin[1]) {
      view._resize = 1;
      view._origin = origin;
    }
    if (rerun2)
      view.run("enter");
    if (auto)
      view.runAfter((v) => v.resize());
  }, false, 1);
}
function getState(options) {
  return this._runtime.getState(options || {
    data: dataTest,
    signals: signalTest,
    recurse: true
  });
}
function dataTest(name, data2) {
  return data2.modified && isArray(data2.input.value) && name.indexOf("_:vega:_");
}
function signalTest(name, op) {
  return !(name === "parent" || op instanceof transforms.proxy);
}
function setState(state) {
  this.runAsync(null, (v) => {
    v._trigger = false;
    v._runtime.setState(state);
  }, (v) => {
    v._trigger = true;
  });
  return this;
}
function timer(callback, delay) {
  function tick(elapsed) {
    callback({
      timestamp: Date.now(),
      elapsed
    });
  }
  this._timers.push(interval(tick, delay));
}
function defaultTooltip(handler, event2, item, value2) {
  const el = handler.element();
  if (el)
    el.setAttribute("title", formatTooltip(value2));
}
function formatTooltip(value2) {
  return value2 == null ? "" : isArray(value2) ? formatArray(value2) : isObject(value2) && !isDate$1(value2) ? formatObject(value2) : value2 + "";
}
function formatObject(obj) {
  return Object.keys(obj).map((key2) => {
    const v = obj[key2];
    return key2 + ": " + (isArray(v) ? formatArray(v) : formatValue(v));
  }).join("\n");
}
function formatArray(value2) {
  return "[" + value2.map(formatValue).join(", ") + "]";
}
function formatValue(value2) {
  return isArray(value2) ? "[…]" : isObject(value2) && !isDate$1(value2) ? "{…}" : value2;
}
function View$1(spec, options) {
  const view = this;
  options = options || {};
  Dataflow.call(view);
  if (options.loader)
    view.loader(options.loader);
  if (options.logger)
    view.logger(options.logger);
  if (options.logLevel != null)
    view.logLevel(options.logLevel);
  if (options.locale || spec.locale) {
    const loc = extend({}, spec.locale, options.locale);
    view.locale(locale(loc.number, loc.time));
  }
  view._el = null;
  view._elBind = null;
  view._renderType = options.renderer || RenderType.Canvas;
  view._scenegraph = new Scenegraph();
  const root = view._scenegraph.root;
  view._renderer = null;
  view._tooltip = options.tooltip || defaultTooltip, view._redraw = true;
  view._handler = new CanvasHandler().scene(root);
  view._globalCursor = false;
  view._preventDefault = false;
  view._timers = [];
  view._eventListeners = [];
  view._resizeListeners = [];
  view._eventConfig = initializeEventConfig(spec.eventConfig);
  view.globalCursor(view._eventConfig.globalCursor);
  const ctx = runtime(view, spec, options.expr);
  view._runtime = ctx;
  view._signals = ctx.signals;
  view._bind = (spec.bindings || []).map((_) => ({
    state: null,
    param: extend({}, _)
  }));
  if (ctx.root)
    ctx.root.set(root);
  root.source = ctx.data.root.input;
  view.pulse(ctx.data.root.input, view.changeset().insert(root.items));
  view._width = view.width();
  view._height = view.height();
  view._viewWidth = viewWidth(view, view._width);
  view._viewHeight = viewHeight(view, view._height);
  view._origin = [0, 0];
  view._resize = 0;
  view._autosize = 1;
  initializeResize(view);
  background(view);
  cursor(view);
  view.description(spec.description);
  if (options.hover)
    view.hover();
  if (options.container)
    view.initialize(options.container, options.bind);
}
function lookupSignal(view, name) {
  return has$1(view._signals, name) ? view._signals[name] : error("Unrecognized signal name: " + $(name));
}
function findOperatorHandler(op, handler) {
  const h2 = (op._targets || []).filter((op2) => op2._update && op2._update.handler === handler);
  return h2.length ? h2[0] : null;
}
function addOperatorListener(view, name, op, handler) {
  let h2 = findOperatorHandler(op, handler);
  if (!h2) {
    h2 = trap(view, () => handler(name, op.value));
    h2.handler = handler;
    view.on(op, null, h2);
  }
  return view;
}
function removeOperatorListener(view, op, handler) {
  const h2 = findOperatorHandler(op, handler);
  if (h2)
    op._targets.remove(h2);
  return view;
}
inherits(View$1, Dataflow, {
  // -- DATAFLOW / RENDERING ----
  async evaluate(encode2, prerun, postrun) {
    await Dataflow.prototype.evaluate.call(this, encode2, prerun);
    if (this._redraw || this._resize) {
      try {
        if (this._renderer) {
          if (this._resize) {
            this._resize = 0;
            resizeRenderer(this);
          }
          await this._renderer.renderAsync(this._scenegraph.root);
        }
        this._redraw = false;
      } catch (e) {
        this.error(e);
      }
    }
    if (postrun)
      asyncCallback(this, postrun);
    return this;
  },
  dirty(item) {
    this._redraw = true;
    this._renderer && this._renderer.dirty(item);
  },
  // -- GET / SET ----
  description(text2) {
    if (arguments.length) {
      const desc = text2 != null ? text2 + "" : null;
      if (desc !== this._desc)
        ariaLabel(this._el, this._desc = desc);
      return this;
    }
    return this._desc;
  },
  container() {
    return this._el;
  },
  scenegraph() {
    return this._scenegraph;
  },
  origin() {
    return this._origin.slice();
  },
  signal(name, value2, options) {
    const op = lookupSignal(this, name);
    return arguments.length === 1 ? op.value : this.update(op, value2, options);
  },
  width(_) {
    return arguments.length ? this.signal("width", _) : this.signal("width");
  },
  height(_) {
    return arguments.length ? this.signal("height", _) : this.signal("height");
  },
  padding(_) {
    return arguments.length ? this.signal("padding", padding(_)) : padding(this.signal("padding"));
  },
  autosize(_) {
    return arguments.length ? this.signal("autosize", _) : this.signal("autosize");
  },
  background(_) {
    return arguments.length ? this.signal("background", _) : this.signal("background");
  },
  renderer(type2) {
    if (!arguments.length)
      return this._renderType;
    if (!renderModule(type2))
      error("Unrecognized renderer type: " + type2);
    if (type2 !== this._renderType) {
      this._renderType = type2;
      this._resetRenderer();
    }
    return this;
  },
  tooltip(handler) {
    if (!arguments.length)
      return this._tooltip;
    if (handler !== this._tooltip) {
      this._tooltip = handler;
      this._resetRenderer();
    }
    return this;
  },
  loader(loader2) {
    if (!arguments.length)
      return this._loader;
    if (loader2 !== this._loader) {
      Dataflow.prototype.loader.call(this, loader2);
      this._resetRenderer();
    }
    return this;
  },
  resize() {
    this._autosize = 1;
    return this.touch(lookupSignal(this, "autosize"));
  },
  _resetRenderer() {
    if (this._renderer) {
      this._renderer = null;
      this.initialize(this._el, this._elBind);
    }
  },
  // -- SIZING ----
  _resizeView: resizeView,
  // -- EVENT HANDLING ----
  addEventListener(type2, handler, options) {
    let callback = handler;
    if (!(options && options.trap === false)) {
      callback = trap(this, handler);
      callback.raw = handler;
    }
    this._handler.on(type2, callback);
    return this;
  },
  removeEventListener(type2, handler) {
    var handlers = this._handler.handlers(type2), i = handlers.length, h2, t;
    while (--i >= 0) {
      t = handlers[i].type;
      h2 = handlers[i].handler;
      if (type2 === t && (handler === h2 || handler === h2.raw)) {
        this._handler.off(t, h2);
        break;
      }
    }
    return this;
  },
  addResizeListener(handler) {
    const l = this._resizeListeners;
    if (l.indexOf(handler) < 0) {
      l.push(handler);
    }
    return this;
  },
  removeResizeListener(handler) {
    var l = this._resizeListeners, i = l.indexOf(handler);
    if (i >= 0) {
      l.splice(i, 1);
    }
    return this;
  },
  addSignalListener(name, handler) {
    return addOperatorListener(this, name, lookupSignal(this, name), handler);
  },
  removeSignalListener(name, handler) {
    return removeOperatorListener(this, lookupSignal(this, name), handler);
  },
  addDataListener(name, handler) {
    return addOperatorListener(this, name, dataref(this, name).values, handler);
  },
  removeDataListener(name, handler) {
    return removeOperatorListener(this, dataref(this, name).values, handler);
  },
  globalCursor(_) {
    if (arguments.length) {
      if (this._globalCursor !== !!_) {
        const prev = setCursor(this, null);
        this._globalCursor = !!_;
        if (prev)
          setCursor(this, prev);
      }
      return this;
    } else {
      return this._globalCursor;
    }
  },
  preventDefault(_) {
    if (arguments.length) {
      this._preventDefault = _;
      return this;
    } else {
      return this._preventDefault;
    }
  },
  timer,
  events,
  finalize,
  hover,
  // -- DATA ----
  data: data$1,
  change,
  insert,
  remove,
  // -- SCALES --
  scale: scale$2,
  // -- INITIALIZATION ----
  initialize,
  // -- HEADLESS RENDERING ----
  toImageURL: renderToImageURL,
  toCanvas: renderToCanvas,
  toSVG: renderToSVG,
  // -- SAVE / RESTORE STATE ----
  getState,
  setState
});
function data(name) {
  const data2 = this.context.data[name];
  return data2 ? data2.values.value : [];
}
function indata(name, field2, value2) {
  const index2 = this.context.data[name]["index:" + field2], entry2 = index2 ? index2.value.get(value2) : void 0;
  return entry2 ? entry2.count : entry2;
}
function setdata(name, tuples) {
  const df = this.context.dataflow, data2 = this.context.data[name], input = data2.input;
  df.pulse(input, df.changeset().remove(truthy).insert(tuples));
  return 1;
}
function encode(item, name, retval) {
  if (item) {
    const df = this.context.dataflow, target2 = item.mark.source;
    df.pulse(target2, df.changeset().encode(item, name));
  }
  return retval !== void 0 ? retval : item;
}
const wrap = (method2) => function(value2, spec) {
  const locale2 = this.context.dataflow.locale();
  return locale2[method2](spec)(value2);
};
const format = wrap("format");
const timeFormat = wrap("timeFormat");
const utcFormat = wrap("utcFormat");
const timeParse = wrap("timeParse");
const utcParse = wrap("utcParse");
const dateObj = new Date(2e3, 0, 1);
function time(month, day, specifier) {
  if (!Number.isInteger(month) || !Number.isInteger(day))
    return "";
  dateObj.setYear(2e3);
  dateObj.setMonth(month);
  dateObj.setDate(day);
  return timeFormat.call(this, dateObj, specifier);
}
function monthFormat(month) {
  return time.call(this, month, 1, "%B");
}
function monthAbbrevFormat(month) {
  return time.call(this, month, 1, "%b");
}
function dayFormat(day) {
  return time.call(this, 0, 2 + day, "%A");
}
function dayAbbrevFormat(day) {
  return time.call(this, 0, 2 + day, "%a");
}
const DataPrefix = ":";
const IndexPrefix = "@";
const ScalePrefix = "%";
const SignalPrefix = "$";
function dataVisitor(name, args, scope, params2) {
  if (args[0].type !== Literal$1) {
    error("First argument to data functions must be a string literal.");
  }
  const data2 = args[0].value, dataName = DataPrefix + data2;
  if (!has$1(dataName, params2)) {
    try {
      params2[dataName] = scope.getData(data2).tuplesRef();
    } catch (err) {
    }
  }
}
function indataVisitor(name, args, scope, params2) {
  if (args[0].type !== Literal$1)
    error("First argument to indata must be a string literal.");
  if (args[1].type !== Literal$1)
    error("Second argument to indata must be a string literal.");
  const data2 = args[0].value, field2 = args[1].value, indexName = IndexPrefix + field2;
  if (!has$1(indexName, params2)) {
    params2[indexName] = scope.getData(data2).indataRef(scope, field2);
  }
}
function scaleVisitor(name, args, scope, params2) {
  if (args[0].type === Literal$1) {
    addScaleDependency(scope, params2, args[0].value);
  } else {
    for (name in scope.scales) {
      addScaleDependency(scope, params2, name);
    }
  }
}
function addScaleDependency(scope, params2, name) {
  const scaleName = ScalePrefix + name;
  if (!has$1(params2, scaleName)) {
    try {
      params2[scaleName] = scope.scaleRef(name);
    } catch (err) {
    }
  }
}
function getScale(nameOrFunction, ctx) {
  if (isFunction(nameOrFunction)) {
    return nameOrFunction;
  }
  if (isString(nameOrFunction)) {
    const maybeScale = ctx.scales[nameOrFunction];
    return maybeScale && isRegisteredScale(maybeScale.value) ? maybeScale.value : void 0;
  }
  return void 0;
}
function internalScaleFunctions(codegen2, fnctx, visitors) {
  fnctx.__bandwidth = (s) => s && s.bandwidth ? s.bandwidth() : 0;
  visitors._bandwidth = scaleVisitor;
  visitors._range = scaleVisitor;
  visitors._scale = scaleVisitor;
  const ref2 = (arg) => "_[" + (arg.type === Literal$1 ? $(ScalePrefix + arg.value) : $(ScalePrefix) + "+" + codegen2(arg)) + "]";
  return {
    _bandwidth: (args) => `this.__bandwidth(${ref2(args[0])})`,
    _range: (args) => `${ref2(args[0])}.range()`,
    _scale: (args) => `${ref2(args[0])}(${codegen2(args[1])})`
  };
}
function geoMethod(methodName, globalMethod) {
  return function(projection2, geojson, group2) {
    if (projection2) {
      const p = getScale(projection2, (group2 || this).context);
      return p && p.path[methodName](geojson);
    } else {
      return globalMethod(geojson);
    }
  };
}
const geoArea = geoMethod("area", geoArea$1$1);
const geoBounds = geoMethod("bounds", geoBounds$1$1);
const geoCentroid = geoMethod("centroid", geoCentroid$1$1);
function inScope(item) {
  const group2 = this.context.group;
  let value2 = false;
  if (group2)
    while (item) {
      if (item === group2) {
        value2 = true;
        break;
      }
      item = item.mark.group;
    }
  return value2;
}
function log(df, method2, args) {
  try {
    df[method2].apply(df, ["EXPRESSION"].concat([].slice.call(args)));
  } catch (err) {
    df.warn(err);
  }
  return args[args.length - 1];
}
function warn() {
  return log(this.context.dataflow, "warn", arguments);
}
function info() {
  return log(this.context.dataflow, "info", arguments);
}
function debug() {
  return log(this.context.dataflow, "debug", arguments);
}
function channel_luminance_value(channelValue) {
  const val = channelValue / 255;
  if (val <= 0.03928) {
    return val / 12.92;
  }
  return Math.pow((val + 0.055) / 1.055, 2.4);
}
function luminance(color2) {
  const c2 = rgb(color2), r = channel_luminance_value(c2.r), g = channel_luminance_value(c2.g), b2 = channel_luminance_value(c2.b);
  return 0.2126 * r + 0.7152 * g + 0.0722 * b2;
}
function contrast(color1, color2) {
  const lum1 = luminance(color1), lum2 = luminance(color2), lumL = Math.max(lum1, lum2), lumD = Math.min(lum1, lum2);
  return (lumL + 0.05) / (lumD + 0.05);
}
function merge() {
  const args = [].slice.call(arguments);
  args.unshift({});
  return extend(...args);
}
function equal(a2, b2) {
  return a2 === b2 || a2 !== a2 && b2 !== b2 ? true : isArray(a2) ? isArray(b2) && a2.length === b2.length ? equalArray(a2, b2) : false : isObject(a2) && isObject(b2) ? equalObject(a2, b2) : false;
}
function equalArray(a2, b2) {
  for (let i = 0, n = a2.length; i < n; ++i) {
    if (!equal(a2[i], b2[i]))
      return false;
  }
  return true;
}
function equalObject(a2, b2) {
  for (const key2 in a2) {
    if (!equal(a2[key2], b2[key2]))
      return false;
  }
  return true;
}
function removePredicate(props) {
  return (_) => equalObject(props, _);
}
function modify(name, insert2, remove2, toggle, modify2, values2) {
  const df = this.context.dataflow, data2 = this.context.data[name], input = data2.input, stamp = df.stamp();
  let changes = data2.changes, predicate, key2;
  if (df._trigger === false || !(input.value.length || insert2 || toggle)) {
    return 0;
  }
  if (!changes || changes.stamp < stamp) {
    data2.changes = changes = df.changeset();
    changes.stamp = stamp;
    df.runAfter(() => {
      data2.modified = true;
      df.pulse(input, changes).run();
    }, true, 1);
  }
  if (remove2) {
    predicate = remove2 === true ? truthy : isArray(remove2) || isTuple(remove2) ? remove2 : removePredicate(remove2);
    changes.remove(predicate);
  }
  if (insert2) {
    changes.insert(insert2);
  }
  if (toggle) {
    predicate = removePredicate(toggle);
    if (input.value.some(predicate)) {
      changes.remove(predicate);
    } else {
      changes.insert(toggle);
    }
  }
  if (modify2) {
    for (key2 in values2) {
      changes.modify(modify2, key2, values2[key2]);
    }
  }
  return 1;
}
function pinchDistance(event2) {
  const t = event2.touches, dx = t[0].clientX - t[1].clientX, dy = t[0].clientY - t[1].clientY;
  return Math.hypot(dx, dy);
}
function pinchAngle(event2) {
  const t = event2.touches;
  return Math.atan2(t[0].clientY - t[1].clientY, t[0].clientX - t[1].clientX);
}
const accessors = {};
function pluck(data2, name) {
  const accessor2 = accessors[name] || (accessors[name] = field$1(name));
  return isArray(data2) ? data2.map(accessor2) : accessor2(data2);
}
function array(seq) {
  return isArray(seq) || ArrayBuffer.isView(seq) ? seq : null;
}
function sequence(seq) {
  return array(seq) || (isString(seq) ? seq : null);
}
function join(seq) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  return array(seq).join(...args);
}
function indexof(seq) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }
  return sequence(seq).indexOf(...args);
}
function lastindexof(seq) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }
  return sequence(seq).lastIndexOf(...args);
}
function slice$1(seq) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }
  return sequence(seq).slice(...args);
}
function replace(str, pattern, repl) {
  if (isFunction(repl))
    error("Function argument passed to replace.");
  return String(str).replace(pattern, repl);
}
function reverse(seq) {
  return array(seq).slice().reverse();
}
function bandspace(count2, paddingInner, paddingOuter) {
  return bandSpace(count2 || 0, paddingInner || 0, paddingOuter || 0);
}
function bandwidth(name, group2) {
  const s = getScale(name, (group2 || this).context);
  return s && s.bandwidth ? s.bandwidth() : 0;
}
function copy(name, group2) {
  const s = getScale(name, (group2 || this).context);
  return s ? s.copy() : void 0;
}
function domain(name, group2) {
  const s = getScale(name, (group2 || this).context);
  return s ? s.domain() : [];
}
function invert(name, range2, group2) {
  const s = getScale(name, (group2 || this).context);
  return !s ? void 0 : isArray(range2) ? (s.invertRange || s.invert)(range2) : (s.invert || s.invertExtent)(range2);
}
function range(name, group2) {
  const s = getScale(name, (group2 || this).context);
  return s && s.range ? s.range() : [];
}
function scale$1(name, value2, group2) {
  const s = getScale(name, (group2 || this).context);
  return s ? s(value2) : void 0;
}
function scaleGradient(scale2, p02, p1, count2, group2) {
  scale2 = getScale(scale2, (group2 || this).context);
  const gradient2 = Gradient$1(p02, p1);
  let stops = scale2.domain(), min2 = stops[0], max2 = peek$2(stops), fraction = identity$1;
  if (!(max2 - min2)) {
    scale2 = (scale2.interpolator ? scale$5("sequential")().interpolator(scale2.interpolator()) : scale$5("linear")().interpolate(scale2.interpolate()).range(scale2.range())).domain([min2 = 0, max2 = 1]);
  } else {
    fraction = scaleFraction(scale2, min2, max2);
  }
  if (scale2.ticks) {
    stops = scale2.ticks(+count2 || 15);
    if (min2 !== stops[0])
      stops.unshift(min2);
    if (max2 !== peek$2(stops))
      stops.push(max2);
  }
  stops.forEach((_) => gradient2.stop(fraction(_), scale2(_)));
  return gradient2;
}
function geoShape(projection2, geojson, group2) {
  const p = getScale(projection2, (group2 || this).context);
  return function(context2) {
    return p ? p.path.context(context2)(geojson) : "";
  };
}
function pathShape(path2) {
  let p = null;
  return function(context2) {
    return context2 ? pathRender(context2, p = p || parse$3(path2)) : path2;
  };
}
const datum = (d) => d.data;
function treeNodes(name, context2) {
  const tree2 = data.call(context2, name);
  return tree2.root && tree2.root.lookup || {};
}
function treePath(name, source2, target2) {
  const nodes = treeNodes(name, this), s = nodes[source2], t = nodes[target2];
  return s && t ? s.path(t).map(datum) : void 0;
}
function treeAncestors(name, node) {
  const n = treeNodes(name, this)[node];
  return n ? n.ancestors().map(datum) : void 0;
}
const _window = () => typeof window !== "undefined" && window || null;
function screen() {
  const w2 = _window();
  return w2 ? w2.screen : {};
}
function windowSize() {
  const w2 = _window();
  return w2 ? [w2.innerWidth, w2.innerHeight] : [void 0, void 0];
}
function containerSize() {
  const view = this.context.dataflow, el = view.container && view.container();
  return el ? [el.clientWidth, el.clientHeight] : [void 0, void 0];
}
function intersect(b2, opt, group2) {
  if (!b2)
    return [];
  const [u2, v] = b2, box = new Bounds().set(u2[0], u2[1], v[0], v[1]), scene = group2 || this.context.dataflow.scenegraph().root;
  return intersect$3(scene, box, filter(opt));
}
function filter(opt) {
  let p = null;
  if (opt) {
    const types = array$3(opt.marktype), names = array$3(opt.markname);
    p = (_) => (!types.length || types.some((t) => _.marktype === t)) && (!names.length || names.some((s) => _.name === s));
  }
  return p;
}
function lassoAppend(lasso, x2, y2) {
  let minDist = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 5;
  lasso = array$3(lasso);
  const last = lasso[lasso.length - 1];
  return last === void 0 || Math.hypot(last[0] - x2, last[1] - y2) > minDist ? [...lasso, [x2, y2]] : lasso;
}
function lassoPath(lasso) {
  return array$3(lasso).reduce((svg, _ref, i) => {
    let [x2, y2] = _ref;
    return svg += i == 0 ? `M ${x2},${y2} ` : i === lasso.length - 1 ? " Z" : `L ${x2},${y2} `;
  }, "");
}
function intersectLasso(markname, pixelLasso, unit2) {
  const {
    x: x2,
    y: y2,
    mark
  } = unit2;
  const bb = new Bounds().set(Number.MAX_SAFE_INTEGER, Number.MAX_SAFE_INTEGER, Number.MIN_SAFE_INTEGER, Number.MIN_SAFE_INTEGER);
  for (const [px2, py2] of pixelLasso) {
    if (px2 < bb.x1)
      bb.x1 = px2;
    if (px2 > bb.x2)
      bb.x2 = px2;
    if (py2 < bb.y1)
      bb.y1 = py2;
    if (py2 > bb.y2)
      bb.y2 = py2;
  }
  bb.translate(x2, y2);
  const intersection2 = intersect([[bb.x1, bb.y1], [bb.x2, bb.y2]], markname, mark);
  return intersection2.filter((tuple) => pointInPolygon(tuple.x, tuple.y, pixelLasso));
}
function pointInPolygon(testx, testy, polygon) {
  let intersections = 0;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const [prevX, prevY] = polygon[j];
    const [x2, y2] = polygon[i];
    if (y2 > testy != prevY > testy && testx < (prevX - x2) * (testy - y2) / (prevY - y2) + x2) {
      intersections++;
    }
  }
  return intersections & 1;
}
const functionContext = {
  random() {
    return random();
  },
  // override default
  cumulativeNormal,
  cumulativeLogNormal,
  cumulativeUniform,
  densityNormal,
  densityLogNormal,
  densityUniform,
  quantileNormal,
  quantileLogNormal,
  quantileUniform,
  sampleNormal,
  sampleLogNormal,
  sampleUniform,
  isArray,
  isBoolean: isBoolean$1,
  isDate: isDate$1,
  isDefined(_) {
    return _ !== void 0;
  },
  isNumber: isNumber$1,
  isObject,
  isRegExp,
  isString,
  isTuple,
  isValid(_) {
    return _ != null && _ === _;
  },
  toBoolean,
  toDate(_) {
    return toDate(_);
  },
  // suppress extra arguments
  toNumber,
  toString,
  indexof,
  join,
  lastindexof,
  replace,
  reverse,
  slice: slice$1,
  flush,
  lerp,
  merge,
  pad,
  peek: peek$2,
  pluck,
  span,
  inrange,
  truncate: truncate$1,
  rgb,
  lab: lab$1,
  hcl: hcl$1,
  hsl: hsl$2,
  luminance,
  contrast,
  sequence: range$4,
  format,
  utcFormat,
  utcParse,
  utcOffset,
  utcSequence,
  timeFormat,
  timeParse,
  timeOffset,
  timeSequence,
  timeUnitSpecifier,
  monthFormat,
  monthAbbrevFormat,
  dayFormat,
  dayAbbrevFormat,
  quarter,
  utcquarter,
  week,
  utcweek,
  dayofyear,
  utcdayofyear,
  warn,
  info,
  debug,
  extent(_) {
    return extent(_);
  },
  // suppress extra arguments
  inScope,
  intersect,
  clampRange,
  pinchDistance,
  pinchAngle,
  screen,
  containerSize,
  windowSize,
  bandspace,
  setdata,
  pathShape,
  panLinear,
  panLog,
  panPow,
  panSymlog,
  zoomLinear,
  zoomLog,
  zoomPow,
  zoomSymlog,
  encode,
  modify,
  lassoAppend,
  lassoPath,
  intersectLasso
};
const eventFunctions = ["view", "item", "group", "xy", "x", "y"], eventPrefix = "event.vega.", thisPrefix = "this.", astVisitors = {};
const codegenParams = {
  forbidden: ["_"],
  allowed: ["datum", "event", "item"],
  fieldvar: "datum",
  globalvar: (id2) => `_[${$(SignalPrefix + id2)}]`,
  functions: buildFunctions,
  constants: Constants$2,
  visitors: astVisitors
};
const codeGenerator = codegen$1(codegenParams);
function buildFunctions(codegen2) {
  const fn = Functions$2(codegen2);
  eventFunctions.forEach((name) => fn[name] = eventPrefix + name);
  for (const name in functionContext) {
    fn[name] = thisPrefix + name;
  }
  extend(fn, internalScaleFunctions(codegen2, functionContext, astVisitors));
  return fn;
}
function expressionFunction(name, fn, visitor) {
  if (arguments.length === 1) {
    return functionContext[name];
  }
  functionContext[name] = fn;
  if (visitor)
    astVisitors[name] = visitor;
  if (codeGenerator)
    codeGenerator.functions[name] = thisPrefix + name;
  return this;
}
expressionFunction("bandwidth", bandwidth, scaleVisitor);
expressionFunction("copy", copy, scaleVisitor);
expressionFunction("domain", domain, scaleVisitor);
expressionFunction("range", range, scaleVisitor);
expressionFunction("invert", invert, scaleVisitor);
expressionFunction("scale", scale$1, scaleVisitor);
expressionFunction("gradient", scaleGradient, scaleVisitor);
expressionFunction("geoArea", geoArea, scaleVisitor);
expressionFunction("geoBounds", geoBounds, scaleVisitor);
expressionFunction("geoCentroid", geoCentroid, scaleVisitor);
expressionFunction("geoShape", geoShape, scaleVisitor);
expressionFunction("indata", indata, indataVisitor);
expressionFunction("data", data, dataVisitor);
expressionFunction("treePath", treePath, dataVisitor);
expressionFunction("treeAncestors", treeAncestors, dataVisitor);
expressionFunction("vlSelectionTest", selectionTest, selectionVisitor);
expressionFunction("vlSelectionIdTest", selectionIdTest, selectionVisitor);
expressionFunction("vlSelectionResolve", selectionResolve, selectionVisitor);
expressionFunction("vlSelectionTuples", selectionTuples);
const VIEW = "view", LBRACK = "[", RBRACK = "]", LBRACE = "{", RBRACE = "}", COLON = ":", COMMA = ",", NAME = "@", GT = ">", ILLEGAL$1 = /[[\]{}]/, DEFAULT_MARKS = {
  "*": 1,
  arc: 1,
  area: 1,
  group: 1,
  image: 1,
  line: 1,
  path: 1,
  rect: 1,
  rule: 1,
  shape: 1,
  symbol: 1,
  text: 1,
  trail: 1
};
let DEFAULT_SOURCE, MARKS;
function eventSelector(selector, source2, marks) {
  DEFAULT_SOURCE = source2 || VIEW;
  MARKS = marks || DEFAULT_MARKS;
  return parseMerge(selector.trim()).map(parseSelector);
}
function isMarkType(type2) {
  return MARKS[type2];
}
function find(s, i, endChar, pushChar, popChar) {
  const n = s.length;
  let count2 = 0, c2;
  for (; i < n; ++i) {
    c2 = s[i];
    if (!count2 && c2 === endChar)
      return i;
    else if (popChar && popChar.indexOf(c2) >= 0)
      --count2;
    else if (pushChar && pushChar.indexOf(c2) >= 0)
      ++count2;
  }
  return i;
}
function parseMerge(s) {
  const output2 = [], n = s.length;
  let start = 0, i = 0;
  while (i < n) {
    i = find(s, i, COMMA, LBRACK + LBRACE, RBRACK + RBRACE);
    output2.push(s.substring(start, i).trim());
    start = ++i;
  }
  if (output2.length === 0) {
    throw "Empty event selector: " + s;
  }
  return output2;
}
function parseSelector(s) {
  return s[0] === "[" ? parseBetween(s) : parseStream$1(s);
}
function parseBetween(s) {
  const n = s.length;
  let i = 1, b2;
  i = find(s, i, RBRACK, LBRACK, RBRACK);
  if (i === n) {
    throw "Empty between selector: " + s;
  }
  b2 = parseMerge(s.substring(1, i));
  if (b2.length !== 2) {
    throw "Between selector must have two elements: " + s;
  }
  s = s.slice(i + 1).trim();
  if (s[0] !== GT) {
    throw "Expected '>' after between selector: " + s;
  }
  b2 = b2.map(parseSelector);
  const stream2 = parseSelector(s.slice(1).trim());
  if (stream2.between) {
    return {
      between: b2,
      stream: stream2
    };
  } else {
    stream2.between = b2;
  }
  return stream2;
}
function parseStream$1(s) {
  const stream2 = {
    source: DEFAULT_SOURCE
  }, source2 = [];
  let throttle = [0, 0], markname = 0, start = 0, n = s.length, i = 0, j, filter2;
  if (s[n - 1] === RBRACE) {
    i = s.lastIndexOf(LBRACE);
    if (i >= 0) {
      try {
        throttle = parseThrottle(s.substring(i + 1, n - 1));
      } catch (e) {
        throw "Invalid throttle specification: " + s;
      }
      s = s.slice(0, i).trim();
      n = s.length;
    } else
      throw "Unmatched right brace: " + s;
    i = 0;
  }
  if (!n)
    throw s;
  if (s[0] === NAME)
    markname = ++i;
  j = find(s, i, COLON);
  if (j < n) {
    source2.push(s.substring(start, j).trim());
    start = i = ++j;
  }
  i = find(s, i, LBRACK);
  if (i === n) {
    source2.push(s.substring(start, n).trim());
  } else {
    source2.push(s.substring(start, i).trim());
    filter2 = [];
    start = ++i;
    if (start === n)
      throw "Unmatched left bracket: " + s;
  }
  while (i < n) {
    i = find(s, i, RBRACK);
    if (i === n)
      throw "Unmatched left bracket: " + s;
    filter2.push(s.substring(start, i).trim());
    if (i < n - 1 && s[++i] !== LBRACK)
      throw "Expected left bracket: " + s;
    start = ++i;
  }
  if (!(n = source2.length) || ILLEGAL$1.test(source2[n - 1])) {
    throw "Invalid event selector: " + s;
  }
  if (n > 1) {
    stream2.type = source2[1];
    if (markname) {
      stream2.markname = source2[0].slice(1);
    } else if (isMarkType(source2[0])) {
      stream2.marktype = source2[0];
    } else {
      stream2.source = source2[0];
    }
  } else {
    stream2.type = source2[0];
  }
  if (stream2.type.slice(-1) === "!") {
    stream2.consume = true;
    stream2.type = stream2.type.slice(0, -1);
  }
  if (filter2 != null)
    stream2.filter = filter2;
  if (throttle[0])
    stream2.throttle = throttle[0];
  if (throttle[1])
    stream2.debounce = throttle[1];
  return stream2;
}
function parseThrottle(s) {
  const a2 = s.split(COMMA);
  if (!s.length || a2.length > 2)
    throw s;
  return a2.map((_) => {
    const x2 = +_;
    if (x2 !== x2)
      throw s;
    return x2;
  });
}
function parseAutosize(spec) {
  return isObject(spec) ? spec : {
    type: spec || "pad"
  };
}
const number = (_) => +_ || 0;
const paddingObject = (_) => ({
  top: _,
  bottom: _,
  left: _,
  right: _
});
function parsePadding(spec) {
  return !isObject(spec) ? paddingObject(number(spec)) : spec.signal ? spec : {
    top: number(spec.top),
    bottom: number(spec.bottom),
    left: number(spec.left),
    right: number(spec.right)
  };
}
const encoder = (_) => isObject(_) && !isArray(_) ? extend({}, _) : {
  value: _
};
function addEncode(object2, name, value2, set2) {
  if (value2 != null) {
    const isEncoder = isObject(value2) && !isArray(value2) || isArray(value2) && value2.length && isObject(value2[0]);
    if (isEncoder) {
      object2.update[name] = value2;
    } else {
      object2[set2 || "enter"][name] = {
        value: value2
      };
    }
    return 1;
  } else {
    return 0;
  }
}
function addEncoders(object2, enter, update2) {
  for (const name in enter) {
    addEncode(object2, name, enter[name]);
  }
  for (const name in update2) {
    addEncode(object2, name, update2[name], "update");
  }
}
function extendEncode(encode2, extra, skip) {
  for (const name in extra) {
    if (skip && has$1(skip, name))
      continue;
    encode2[name] = extend(encode2[name] || {}, extra[name]);
  }
  return encode2;
}
function has(key2, encode2) {
  return encode2 && (encode2.enter && encode2.enter[key2] || encode2.update && encode2.update[key2]);
}
const MarkRole = "mark";
const FrameRole = "frame";
const ScopeRole = "scope";
const AxisRole = "axis";
const AxisDomainRole = "axis-domain";
const AxisGridRole = "axis-grid";
const AxisLabelRole = "axis-label";
const AxisTickRole = "axis-tick";
const AxisTitleRole = "axis-title";
const LegendRole = "legend";
const LegendBandRole = "legend-band";
const LegendEntryRole = "legend-entry";
const LegendGradientRole = "legend-gradient";
const LegendLabelRole = "legend-label";
const LegendSymbolRole = "legend-symbol";
const LegendTitleRole = "legend-title";
const TitleRole = "title";
const TitleTextRole = "title-text";
const TitleSubtitleRole = "title-subtitle";
function applyDefaults(encode2, type2, role, style2, config) {
  const defaults2 = {}, enter = {};
  let update2, key2, skip, props;
  key2 = "lineBreak";
  if (type2 === "text" && config[key2] != null && !has(key2, encode2)) {
    applyDefault(defaults2, key2, config[key2]);
  }
  if (role == "legend" || String(role).startsWith("axis")) {
    role = null;
  }
  props = role === FrameRole ? config.group : role === MarkRole ? extend({}, config.mark, config[type2]) : null;
  for (key2 in props) {
    skip = has(key2, encode2) || (key2 === "fill" || key2 === "stroke") && (has("fill", encode2) || has("stroke", encode2));
    if (!skip)
      applyDefault(defaults2, key2, props[key2]);
  }
  array$3(style2).forEach((name) => {
    const props2 = config.style && config.style[name];
    for (const key3 in props2) {
      if (!has(key3, encode2)) {
        applyDefault(defaults2, key3, props2[key3]);
      }
    }
  });
  encode2 = extend({}, encode2);
  for (key2 in defaults2) {
    props = defaults2[key2];
    if (props.signal) {
      (update2 = update2 || {})[key2] = props;
    } else {
      enter[key2] = props;
    }
  }
  encode2.enter = extend(enter, encode2.enter);
  if (update2)
    encode2.update = extend(update2, encode2.update);
  return encode2;
}
function applyDefault(defaults2, key2, value2) {
  defaults2[key2] = value2 && value2.signal ? {
    signal: value2.signal
  } : {
    value: value2
  };
}
const scaleRef = (scale2) => isString(scale2) ? $(scale2) : scale2.signal ? `(${scale2.signal})` : field(scale2);
function entry$1(enc) {
  if (enc.gradient != null) {
    return gradient(enc);
  }
  let value2 = enc.signal ? `(${enc.signal})` : enc.color ? color(enc.color) : enc.field != null ? field(enc.field) : enc.value !== void 0 ? $(enc.value) : void 0;
  if (enc.scale != null) {
    value2 = scale(enc, value2);
  }
  if (value2 === void 0) {
    value2 = null;
  }
  if (enc.exponent != null) {
    value2 = `pow(${value2},${property(enc.exponent)})`;
  }
  if (enc.mult != null) {
    value2 += `*${property(enc.mult)}`;
  }
  if (enc.offset != null) {
    value2 += `+${property(enc.offset)}`;
  }
  if (enc.round) {
    value2 = `round(${value2})`;
  }
  return value2;
}
const _color = (type2, x2, y2, z) => `(${type2}(${[x2, y2, z].map(entry$1).join(",")})+'')`;
function color(enc) {
  return enc.c ? _color("hcl", enc.h, enc.c, enc.l) : enc.h || enc.s ? _color("hsl", enc.h, enc.s, enc.l) : enc.l || enc.a ? _color("lab", enc.l, enc.a, enc.b) : enc.r || enc.g || enc.b ? _color("rgb", enc.r, enc.g, enc.b) : null;
}
function gradient(enc) {
  const args = [enc.start, enc.stop, enc.count].map((_) => _ == null ? null : $(_));
  while (args.length && peek$2(args) == null)
    args.pop();
  args.unshift(scaleRef(enc.gradient));
  return `gradient(${args.join(",")})`;
}
function property(property2) {
  return isObject(property2) ? "(" + entry$1(property2) + ")" : property2;
}
function field(ref2) {
  return resolveField(isObject(ref2) ? ref2 : {
    datum: ref2
  });
}
function resolveField(ref2) {
  let object2, level, field2;
  if (ref2.signal) {
    object2 = "datum";
    field2 = ref2.signal;
  } else if (ref2.group || ref2.parent) {
    level = Math.max(1, ref2.level || 1);
    object2 = "item";
    while (level-- > 0) {
      object2 += ".mark.group";
    }
    if (ref2.parent) {
      field2 = ref2.parent;
      object2 += ".datum";
    } else {
      field2 = ref2.group;
    }
  } else if (ref2.datum) {
    object2 = "datum";
    field2 = ref2.datum;
  } else {
    error("Invalid field reference: " + $(ref2));
  }
  if (!ref2.signal) {
    field2 = isString(field2) ? splitAccessPath(field2).map($).join("][") : resolveField(field2);
  }
  return object2 + "[" + field2 + "]";
}
function scale(enc, value2) {
  const scale2 = scaleRef(enc.scale);
  if (enc.range != null) {
    value2 = `lerp(_range(${scale2}), ${+enc.range})`;
  } else {
    if (value2 !== void 0)
      value2 = `_scale(${scale2}, ${value2})`;
    if (enc.band) {
      value2 = (value2 ? value2 + "+" : "") + `_bandwidth(${scale2})` + (+enc.band === 1 ? "" : "*" + property(enc.band));
      if (enc.extra) {
        value2 = `(datum.extra ? _scale(${scale2}, datum.extra.value) : ${value2})`;
      }
    }
    if (value2 == null)
      value2 = "0";
  }
  return value2;
}
function rule(enc) {
  let code = "";
  enc.forEach((rule2) => {
    const value2 = entry$1(rule2);
    code += rule2.test ? `(${rule2.test})?${value2}:` : value2;
  });
  if (peek$2(code) === ":") {
    code += "null";
  }
  return code;
}
function parseEncode(encode2, type2, role, style2, scope, params2) {
  const enc = {};
  params2 = params2 || {};
  params2.encoders = {
    $encode: enc
  };
  encode2 = applyDefaults(encode2, type2, role, style2, scope.config);
  for (const key2 in encode2) {
    enc[key2] = parseBlock(encode2[key2], type2, params2, scope);
  }
  return params2;
}
function parseBlock(block, marktype, params2, scope) {
  const channels = {}, fields = {};
  for (const name in block) {
    if (block[name] != null) {
      channels[name] = parse$1(expr(block[name]), scope, params2, fields);
    }
  }
  return {
    $expr: {
      marktype,
      channels
    },
    $fields: Object.keys(fields),
    $output: Object.keys(block)
  };
}
function expr(enc) {
  return isArray(enc) ? rule(enc) : entry$1(enc);
}
function parse$1(code, scope, params2, fields) {
  const expr2 = parser$1(code, scope);
  expr2.$fields.forEach((name) => fields[name] = 1);
  extend(params2, expr2.$params);
  return expr2.$expr;
}
const OUTER = "outer", OUTER_INVALID = ["value", "update", "init", "react", "bind"];
function outerError(prefix, name) {
  error(prefix + ' for "outer" push: ' + $(name));
}
function parseSignal(signal, scope) {
  const name = signal.name;
  if (signal.push === OUTER) {
    if (!scope.signals[name])
      outerError("No prior signal definition", name);
    OUTER_INVALID.forEach((prop) => {
      if (signal[prop] !== void 0)
        outerError("Invalid property ", prop);
    });
  } else {
    const op = scope.addSignal(name, signal.value);
    if (signal.react === false)
      op.react = false;
    if (signal.bind)
      scope.addBinding(name, signal.bind);
  }
}
function Entry(type2, value2, params2, parent) {
  this.id = -1;
  this.type = type2;
  this.value = value2;
  this.params = params2;
  if (parent)
    this.parent = p