import fs from 'fs';

const getFileUpdatedDate = (path) => {
  const stats = fs.statSync(path);
  return stats.mtime;
};

const verDate = new Date(getFileUpdatedDate('./src/js/settingsManager/version.js'));

let mon;
switch (verDate.getMonth()) {
  case 0:
    mon = 'January';
    break;
  case 1:
    mon = 'February';
    break;
  case 2:
    mon = 'March';
    break;
  case 3:
    mon = 'April';
    break;
  case 4:
    mon = 'May';
    break;
  case 5:
    mon = 'June';
    break;
  case 6:
    mon = 'July';
    break;
  case 7:
    mon = 'August';
    break;
  case 8:
    mon = 'September';
    break;
  case 9:
    mon = 'October';
    break;
  case 10:
    mon = 'November';
    break;
  case 11:
    mon = 'December';
    break;
}
const day = verDate.getDate();
const year = verDate.getFullYear();
const dateStr = `${mon} ${day}, ${year}`;
// console.log(dateStr);

const content = `// THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.\nexport const VERSION_DATE = '${dateStr}';`;

fs.writeFile('./src/js/settingsManager/versionDate.js', content, (err) => {
  if (err) {
    console.error(err);
    return;
  }
  //file written successfully
});
