/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller;

import com.lilithsthrone.controller.MainController;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInformationEventListener;
import com.lilithsthrone.controller.eventListeners.tooltips.TooltipInventoryEventListener;
import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.DebugDialogue;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.AbstractSetBonus;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.outfit.AbstractOutfit;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import java.util.Iterator;
import org.w3c.dom.events.EventTarget;

public class DebugController {
    public static void initSpawnItemListeners() {
        Object id;
        for (AbstractClothingType clothingType : ClothingType.getAllClothing()) {
            id = clothingType.getId() + "_SPAWN";
            if (MainController.document.getElementById((String)id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addClothing(Main.game.getItemGen().generateClothing(clothingType, true));
                MainController.updateUIRightPanel();
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setGenericClothing(clothingType, clothingType.getColourReplacement(0).getFirstOfDefaultColours()));
        }
        for (AbstractWeaponType weaponType : WeaponType.getAllWeapons()) {
            id = weaponType.getId() + "_SPAWN";
            if (MainController.document.getElementById((String)id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addWeapon(Main.game.getItemGen().generateWeapon(weaponType));
                MainController.updateUIRightPanel();
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setGenericWeapon(weaponType, weaponType.getAvailableDamageTypes().get(0)));
        }
        for (AbstractItemType itemType : ItemType.getAllItems()) {
            id = itemType.getId() + "_SPAWN";
            if (MainController.document.getElementById((String)id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addItem(Main.game.getItemGen().generateItem(itemType));
                MainController.updateUIRightPanel();
            }, false);
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setGenericItem(itemType));
        }
        for (AbstractTattooType tattooType : TattooType.getAllTattooTypes()) {
            id = tattooType.getId() + "_SPAWN";
            if (MainController.document.getElementById((String)id) == null) continue;
            MainController.addTooltipListeners((String)id, new TooltipInventoryEventListener().setGenericTattoo(tattooType));
        }
        for (Iterator<AbstractCoreType> iterator : InventorySlot.values()) {
            id = String.valueOf(iterator) + "_SPAWN_SELECT";
            if (MainController.document.getElementById((String)id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.itemTag = null;
                DebugDialogue.activeSlot = slot;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        id = "ITEM_SPAWN_SELECT";
        if (MainController.document.getElementById((String)id) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.activeSlot = null;
                DebugDialogue.itemTag = null;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "BOOK_SPAWN_SELECT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.activeSlot = null;
                DebugDialogue.itemTag = ItemTag.BOOK;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "ESSENCE_SPAWN_SELECT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.activeSlot = null;
                DebugDialogue.itemTag = ItemTag.ESSENCE;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "SPELL_SPAWN_SELECT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.activeSlot = null;
                DebugDialogue.itemTag = ItemTag.SPELL_BOOK;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
        if (MainController.document.getElementById((String)(id = "HIDDEN_SPAWN_SELECT")) != null) {
            ((EventTarget)((Object)MainController.document.getElementById((String)id))).addEventListener("click", e -> {
                DebugDialogue.activeSlot = null;
                DebugDialogue.itemTag = ItemTag.CHEAT_ITEM;
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
    }

    public static void initSpawnSetListeners() {
        for (AbstractSetBonus sb : SetBonus.allSetBonuses) {
            String id = "SET_BONUS_" + SetBonus.getIdFromSetBonus(sb);
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                if (WeaponType.getAllWeaponsInSet(sb) != null) {
                    for (AbstractWeaponType wt : WeaponType.getAllWeaponsInSet(sb)) {
                        Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addWeapon(Main.game.getItemGen().generateWeapon(wt));
                    }
                }
                if (ClothingType.getAllClothingInSet(sb) != null) {
                    for (AbstractClothingType ct : ClothingType.getAllClothingInSet(sb)) {
                        Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getInventory().addClothing(Main.game.getItemGen().generateClothing(ct, false));
                    }
                }
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
        }
    }

    public static void initApplyOutfitListeners() {
        for (AbstractOutfit ot : OutfitType.getAllOutfits()) {
            String id = "OUTFIT_" + OutfitType.getIdFromOutfitType(ot);
            if (MainController.document.getElementById(id) == null) continue;
            ((EventTarget)((Object)MainController.document.getElementById(id))).addEventListener("click", e -> {
                DebugDialogue.applyOutfitToDoll(ot);
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }, false);
            MainController.addEventListener(MainController.document, id, "mousemove", MainController.moveTooltipListener, false);
            MainController.addEventListener(MainController.document, id, "mouseleave", MainController.hideTooltipListener, false);
            TooltipInformationEventListener el = new TooltipInformationEventListener().setInformation("\u5e94\u7528\u5957\u88c5", "\u70b9\u51fb\u5c06\u8be5\u5957\u88c5\u5e94\u7528\u5728\u6362\u88c5\u73a9\u5076\u4e0a\u3002\u56e0\u6b64\u8be5\u5957\u88c5\u7684\u5973\u6027\u5316\u7a0b\u5ea6\u3001\u5957\u88c5\u7c7b\u578b\u548c\u6761\u4ef6\u63cf\u8ff0\u90fd\u4f1a\u88ab\u65e0\u89c6\u3002\u73a9\u5076\u7684\u817f\u90e8\u914d\u7f6e\u4f1a\u6309\u9700\u6539\u53d8\u3002\u591a\u6b21\u70b9\u51fb\u53ef\u4ee5\u770b\u5230\u591a\u79cd\u53d8\u4f53\u3002");
            MainController.addEventListener(MainController.document, id, "mouseenter", el, false);
        }
    }
}

