/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller.eventListeners;

import com.lilithsthrone.controller.TooltipUpdateThread;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.RenderingEngine;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class InventorySelectedItemEventListener
implements EventListener {
    private AbstractItem item;
    private AbstractClothing clothing;
    private AbstractClothing clothingEquipped;
    private AbstractWeapon weapon;
    private AbstractWeapon weaponEquipped;
    private InventorySlot weaponSlot;
    private GameCharacter owner;
    private int buyBackIndex;

    @Override
    public void handleEvent(Event event) {
        if (!(Main.game.getCurrentDialogueNode() != EnchantmentDialogue.ENCHANTMENT_MENU && (Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.INVENTORY || Main.game.isInSex() && !Main.game.getCurrentDialogueNode().isInventoryDisabled() || Main.game.isInCombat() || this.clothingEquipped == null && this.weaponEquipped == null))) {
            return;
        }
        TooltipUpdateThread.cancelThreads = true;
        if (this.item != null) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() != DialogueNodeType.INVENTORY) {
                Main.mainController.openInventory();
            }
            if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade)) {
                switch (InventoryDialogue.getNPCInventoryInteraction()) {
                    case COMBAT: {
                        break;
                    }
                    case FULL_MANAGEMENT: {
                        break;
                    }
                    case SEX: {
                        break;
                    }
                    case TRADING: {
                        break;
                    }
                }
            } else {
                InventoryDialogue.setOwner(this.owner);
                InventoryDialogue.setItem(this.item);
                InventoryDialogue.setBuyBackIndex(this.buyBackIndex);
                Main.game.setResponseTab(1);
                RenderingEngine.setPage(this.owner, this.item);
                Main.game.setContent(new Response("", "", InventoryDialogue.ITEM_INVENTORY));
            }
        } else if (this.clothing != null) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() != DialogueNodeType.INVENTORY) {
                Main.mainController.openInventory();
            }
            InventoryDialogue.setOwner(this.owner);
            InventoryDialogue.setClothing(this.clothing);
            InventoryDialogue.setBuyBackIndex(this.buyBackIndex);
            Main.game.setResponseTab(1);
            RenderingEngine.setPage(this.owner, this.clothing);
            Main.game.setContent(new Response("", "", InventoryDialogue.CLOTHING_INVENTORY));
        } else if (this.weapon != null) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() != DialogueNodeType.INVENTORY) {
                Main.mainController.openInventory();
            }
            InventoryDialogue.setOwner(this.owner);
            InventoryDialogue.setWeapon(this.weaponSlot, this.weapon);
            InventoryDialogue.setBuyBackIndex(this.buyBackIndex);
            Main.game.setResponseTab(1);
            RenderingEngine.setPage(this.owner, this.weapon);
            Main.game.setContent(new Response("", "", InventoryDialogue.WEAPON_INVENTORY));
        } else if (this.clothingEquipped != null) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() != DialogueNodeType.INVENTORY) {
                Main.mainController.openInventory();
            }
            InventoryDialogue.setOwner(this.owner);
            InventoryDialogue.setClothing(this.clothingEquipped);
            InventoryDialogue.setBuyBackIndex(this.buyBackIndex);
            Main.game.setResponseTab(1);
            Main.game.setContent(new Response("", "", InventoryDialogue.CLOTHING_EQUIPPED));
        } else if (this.weaponEquipped != null) {
            if (Main.game.getCurrentDialogueNode().getDialogueNodeType() != DialogueNodeType.INVENTORY) {
                Main.mainController.openInventory();
            }
            InventoryDialogue.setOwner(this.owner);
            InventoryDialogue.setWeapon(this.weaponSlot, this.weaponEquipped);
            InventoryDialogue.setBuyBackIndex(this.buyBackIndex);
            Main.game.setResponseTab(1);
            Main.game.setContent(new Response("", "", InventoryDialogue.WEAPON_EQUIPPED));
        }
        Main.mainController.getTooltip().hide();
    }

    public InventorySelectedItemEventListener setItemInventory(AbstractItem item, GameCharacter owner) {
        return this.setItemInventory(item, owner, 0);
    }

    public InventorySelectedItemEventListener setItemInventory(AbstractItem item, GameCharacter owner, int buyBackIndex) {
        this.resetVariables();
        this.item = item;
        this.buyBackIndex = buyBackIndex;
        this.setOwner(owner);
        return this;
    }

    public InventorySelectedItemEventListener setClothingInventory(AbstractClothing clothing, GameCharacter owner) {
        return this.setClothingInventory(clothing, owner, 0);
    }

    public InventorySelectedItemEventListener setClothingInventory(AbstractClothing clothing, GameCharacter owner, int buyBackIndex) {
        this.resetVariables();
        this.clothing = clothing;
        this.buyBackIndex = buyBackIndex;
        this.setOwner(owner);
        return this;
    }

    public InventorySelectedItemEventListener setWeaponInventory(AbstractWeapon weapon, GameCharacter owner) {
        return this.setWeaponInventory(weapon, owner, 0);
    }

    public InventorySelectedItemEventListener setWeaponInventory(AbstractWeapon weapon, GameCharacter owner, int buyBackIndex) {
        this.resetVariables();
        this.weapon = weapon;
        this.buyBackIndex = buyBackIndex;
        this.setOwner(owner);
        return this;
    }

    public InventorySelectedItemEventListener setWeaponEquipped(GameCharacter owner, InventorySlot invSlot) {
        this.resetVariables();
        this.setOwner(owner);
        this.weaponSlot = invSlot;
        if (owner != null) {
            if (invSlot == InventorySlot.WEAPON_MAIN_1) {
                this.weaponEquipped = owner.getMainWeapon(0);
            } else if (invSlot == InventorySlot.WEAPON_MAIN_2) {
                this.weaponEquipped = owner.getMainWeapon(1);
            } else if (invSlot == InventorySlot.WEAPON_MAIN_3) {
                this.weaponEquipped = owner.getMainWeapon(2);
            } else if (invSlot == InventorySlot.WEAPON_OFFHAND_1) {
                this.weaponEquipped = owner.getOffhandWeapon(0);
            } else if (invSlot == InventorySlot.WEAPON_OFFHAND_2) {
                this.weaponEquipped = owner.getOffhandWeapon(1);
            } else if (invSlot == InventorySlot.WEAPON_OFFHAND_3) {
                this.weaponEquipped = owner.getOffhandWeapon(2);
            }
        } else {
            this.weaponEquipped = null;
        }
        return this;
    }

    public InventorySelectedItemEventListener setClothingEquipped(GameCharacter owner, InventorySlot invSlot) {
        this.resetVariables();
        this.setOwner(owner);
        this.clothingEquipped = owner != null ? owner.getClothingInSlot(invSlot) : null;
        return this;
    }

    private void setOwner(GameCharacter owner) {
        this.owner = owner;
    }

    private void resetVariables() {
        this.item = null;
        this.clothing = null;
        this.clothingEquipped = null;
        this.weapon = null;
        this.weaponEquipped = null;
        this.weaponSlot = null;
        this.owner = null;
        this.buyBackIndex = 0;
    }
}

