/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller.eventListeners.tooltips;

import com.lilithsthrone.controller.TooltipUpdateThread;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.ArousalLevel;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.attributes.IntelligenceLevel;
import com.lilithsthrone.game.character.attributes.LustLevel;
import com.lilithsthrone.game.character.attributes.PhysiqueLevel;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.types.AntennaType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.VaginaType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.BodyShape;
import com.lilithsthrone.game.character.body.valueEnums.BreastShape;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.fetishes.FetishLevel;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.combat.AoEData;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellUpgrade;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.Library;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.LoadedEnchantment;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobFlag;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.CachedImage;
import com.lilithsthrone.rendering.ImageCache;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class TooltipInformationEventListener
implements EventListener {
    private String title;
    private String description;
    private boolean extraAttributes = false;
    private boolean weather = false;
    private boolean protection = false;
    private boolean copyInformation = false;
    private boolean availableForSelection = false;
    private GameCharacter owner;
    private AbstractStatusEffect statusEffect;
    private AbstractPerk perk;
    private AbstractPerk levelUpPerk;
    private int perkRow;
    private AbstractFetish fetish;
    private boolean fetishWithCostInformation;
    private boolean fetishExperience = false;
    private FetishDesire desire;
    private Spell spell;
    private SpellUpgrade spellUpgrade;
    private AbstractAttribute attribute;
    private InventorySlot concealedSlot;
    private LoadedEnchantment loadedEnchantment;
    private AbstractCombatMove move;
    private Cell cell;
    private GameCharacter moneyTransferTarget;
    private int moneyTransferPercentage;
    private SlaveJob slaveJob;
    private Body loadedBody;
    private static boolean attributeTableLeft = true;
    private static StringBuilder tooltipSB = new StringBuilder();
    private int descriptionHeightOverride;
    private static final int LINE_HEIGHT = 16;
    private static final int TOOLTIP_WIDTH = 480;

    @Override
    public void handleEvent(Event event) {
        Main.mainController.setTooltipSize(360, 180);
        Main.mainController.setTooltipContent("");
        if (this.statusEffect != null) {
            int specialYIncrease = 0;
            int yIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(this.statusEffect.getName(this.owner)) + "</h5></div>");
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.statusEffect.getSVGString(this.owner) + "</div></div>");
            tooltipSB.append(this.statusEffect.getDescription(this.owner));
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            StringBuilder effectsSB = new StringBuilder();
            boolean effectsFound = false;
            if (this.statusEffect != StatusEffect.SUBSPECIES_BONUS || Main.getProperties().isAdvancedRaceKnowledgeDiscovered(this.owner.getTrueSubspecies()) && !this.owner.isRaceConcealed() || this.owner.isPlayer()) {
                if (!this.statusEffect.getModifiersAsStringList(this.owner).isEmpty()) {
                    for (String s : this.statusEffect.getModifiersAsStringList(this.owner)) {
                        effectsSB.append((effectsFound ? "<br/>" : "") + UtilText.parse(this.owner, s, new ParserTag[0]));
                        effectsFound = true;
                        ++yIncrease;
                    }
                }
            } else {
                effectsSB.append("<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>");
                if (this.owner.isRaceConcealed()) {
                    effectsSB.append(UtilText.parse(this.owner, "\u4f60\u4e0d\u77e5\u9053[npc.namePos]\u7684\u79cd\u65cf\uff0c\u6240\u4ee5\u4e5f\u4e0d\u77e5\u9053[npc.her]\u7684\u4f18\u52bf\u548c\u5f31\u70b9\u2026\u2026", new ParserTag[0]));
                } else {
                    effectsSB.append(UtilText.parse(this.owner, "\u4f60\u5bf9" + this.owner.getSubspecies().getNamePlural(null) + "\u4e86\u89e3\u4e0d\u8db3\uff0c\u65e0\u6cd5\u77e5\u6653[npc.namePos]\u7684\u4f18\u52bf\u548c\u5f31\u70b9\u2026\u2026", new ParserTag[0]));
                }
                effectsSB.append("</span>");
                ++yIncrease;
                ++yIncrease;
                effectsFound = true;
            }
            for (AbstractCombatMove cm : this.statusEffect.getCombatMoves()) {
                effectsSB.append((effectsFound ? "<br/>" : "") + "[style.boldExcellent(\u6388\u4e88)][style.boldCombat(\u52a8\u4f5c)]\uff1a" + Util.capitaliseSentence(cm.getName(0, this.owner)));
                effectsFound = true;
                ++yIncrease;
            }
            for (Spell spell : this.statusEffect.getSpells()) {
                effectsSB.append((effectsFound ? "<br/>" : "") + "[style.boldExcellent(\u6388\u4e88)][style.boldSpell(\u6cd5\u672f)]<b>\uff1a</b><b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(spell.getName()) + "</b>");
                effectsFound = true;
                ++yIncrease;
            }
            if (effectsSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(effectsSB.toString());
                tooltipSB.append("</div>");
            }
            StringBuilder extraDescriptionsSB = new StringBuilder();
            List<Util.Value<Integer, String>> extraDescriptions = this.statusEffect.getAdditionalDescriptions(this.owner);
            if (extraDescriptions != null && !extraDescriptions.isEmpty()) {
                int i = 0;
                for (Util.Value<Integer, String> desc : extraDescriptions) {
                    extraDescriptionsSB.append((i == 0 ? "" : "<br/>") + desc.getValue());
                    yIncrease += desc.getKey().intValue();
                    ++i;
                }
            }
            if (extraDescriptionsSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(extraDescriptionsSB.toString());
                tooltipSB.append("</div>");
            }
            if (this.owner.hasStatusEffect(this.statusEffect)) {
                StringBuilder timerSB = new StringBuilder();
                if (this.owner.getStatusEffectDuration(this.statusEffect) != -1 || this.statusEffect.isCombatEffect()) {
                    if (this.statusEffect.isCombatEffect()) {
                        timerSB.append("\u5269\u4f59\u56de\u5408\uff1a");
                        int turnsRemaining = this.owner.getStatusEffectDuration(this.statusEffect);
                        Colour turnCountColour = turnsRemaining < 0 ? PresetColour.GENERIC_EXCELLENT : (turnsRemaining > 10 ? PresetColour.STATUS_EFFECT_TIME_OVERFLOW : (turnsRemaining > 5 ? PresetColour.STATUS_EFFECT_TIME_HIGH : (turnsRemaining >= 2 ? PresetColour.STATUS_EFFECT_TIME_MEDIUM : PresetColour.STATUS_EFFECT_TIME_LOW)));
                        timerSB.append("<b style='color:" + turnCountColour.toWebHexString() + ";'>");
                        if (this.owner.getStatusEffectDuration(this.statusEffect) != -1) {
                            timerSB.append(this.owner.getStatusEffectDuration(this.statusEffect));
                        } else {
                            timerSB.append(UtilText.getBasicInfinitySymbol());
                        }
                        timerSB.append("</b>");
                        ++yIncrease;
                    } else {
                        int timerHeight = (int)((float)this.owner.getStatusEffectDuration(this.statusEffect) / 21600.0f * 100.0f);
                        Colour timerColour = PresetColour.STATUS_EFFECT_TIME_HIGH;
                        if (timerHeight > 100) {
                            timerHeight = 100;
                            timerColour = PresetColour.STATUS_EFFECT_TIME_OVERFLOW;
                        } else if (timerHeight < 15) {
                            timerColour = PresetColour.STATUS_EFFECT_TIME_LOW;
                        } else if (timerHeight < 50) {
                            timerColour = PresetColour.STATUS_EFFECT_TIME_MEDIUM;
                        }
                        int minutes = Math.max(1, this.owner.getStatusEffectDuration(this.statusEffect) / 60);
                        int hours = minutes / 60;
                        int days = hours / 24;
                        timerSB.append("\u5269\u4f59\u65f6\u95f4\uff1a<b style='color:" + timerColour.toWebHexString() + ";'>" + (days > 0 ? days + " \u5929" + (String)(hours % 24 > 0 ? " " + hours % 24 + " \u65f6" + (String)(minutes % 60 > 0 ? " " + minutes % 60 + " \u5206" : "") : (minutes % 60 > 0 ? " " + minutes % 60 + " \u5206" : "")) : (hours > 0 ? " " + hours + " \u65f6" + (String)(minutes % 60 > 0 ? " " + minutes % 60 + " \u5206" : "") : minutes + "\u5206")));
                        ++yIncrease;
                    }
                }
                if (timerSB.length() > 0) {
                    specialYIncrease += 16;
                    tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                    tooltipSB.append(timerSB.toString());
                    tooltipSB.append("</div>");
                }
            }
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 208 + specialYIncrease + yIncrease * 18);
        } else if (this.perk != null || this.levelUpPerk != null) {
            int yIncrease = 0;
            int specialYIncrease = 0;
            AbstractPerk activePerk = this.perk != null ? this.perk : this.levelUpPerk;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(activePerk.getName(this.owner)) + "</h5></div>");
            tooltipSB.append("<div class='container-full-width titular'>");
            if (activePerk.isEquippableTrait()) {
                if (activePerk.getPerkCategory() == PerkCategory.JOB) {
                    Occupation associatedOccupation = this.owner.getHistory();
                    for (Occupation occ : Occupation.getAvailableHistories(Main.game.getPlayer())) {
                        if (occ.getAssociatedPerk() != activePerk) continue;
                        associatedOccupation = occ;
                        break;
                    }
                    tooltipSB.append("<span style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>'" + Util.capitaliseSentence(associatedOccupation.getName(this.owner)) + "' \u804c\u4e1a\u7279\u6027</span>");
                } else if (activePerk.isHiddenPerk()) {
                    tooltipSB.append("<span style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>\u72ec\u7279\u7279\u6027</span>");
                } else {
                    tooltipSB.append("<span style='color:" + PresetColour.TRAIT.toWebHexString() + ";'>\u7279\u6027</span>");
                }
            } else if (activePerk.isHiddenPerk()) {
                tooltipSB.append("<span style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>\u72ec\u7279\u5929\u8d4b</span>");
            } else {
                tooltipSB.append("<span style='color:" + PresetColour.PERK.toWebHexString() + ";'>\u5929\u8d4b</span>");
            }
            tooltipSB.append("</div>");
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + activePerk.getSVGString(this.owner) + "</div></div>");
            tooltipSB.append(UtilText.parse(this.owner, activePerk.getDescription(this.owner), new ParserTag[0]));
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            StringBuilder attributesSB = new StringBuilder();
            List<String> extraDescriptions = activePerk.getModifiersAsStringList(this.owner);
            if (extraDescriptions != null && !extraDescriptions.isEmpty()) {
                int i = 0;
                for (String s : extraDescriptions) {
                    attributesSB.append((i != 0 ? "<br/>" : "") + s);
                    ++i;
                    ++yIncrease;
                }
            }
            if (attributesSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(attributesSB.toString());
                tooltipSB.append("</div>");
            }
            if (this.levelUpPerk != null && this.availableForSelection) {
                specialYIncrease += 16;
                ++yIncrease;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal; font-style:italic;'>");
                if (this.levelUpPerk.isEquippableTrait()) {
                    if (this.levelUpPerk.getPerkCategory() == PerkCategory.JOB) {
                        tooltipSB.append("<span style='color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'>\u65e0\u6cd5\u79fb\u9664\u804c\u4e1a\u7279\u6027\u3002</span>");
                    } else if (!this.owner.hasPerkInTree(this.perkRow, this.levelUpPerk)) {
                        if (!PerkManager.MANAGER.isPerkAvailable(this.owner, this.perkRow, this.levelUpPerk)) {
                            tooltipSB.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u9700\u8981\u4e00\u4e2a\u76f8\u8fde\u7684\u5929\u8d4b\u6216\u7279\u6027\u624d\u80fd\u8d2d\u4e70\u3002</span>");
                        } else {
                            tooltipSB.append("<span style='color:" + PresetColour.GENERIC_MINOR_GOOD.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u8d2d\u4e70\u7279\u6027\u3002</span>");
                        }
                    } else if (this.owner.getTraits().contains(this.levelUpPerk)) {
                        tooltipSB.append("<span style='color:" + PresetColour.GENERIC_MINOR_BAD.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u5378\u4e0b\u7279\u6027\u3002</span>");
                    } else if (this.owner.getTraits().size() == 6) {
                        tooltipSB.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5df2\u8fbe\u5230\u6fc0\u6d3b\u7279\u6027\u7684\u4e0a\u9650\u3002</span>");
                    } else {
                        tooltipSB.append("<span style='color:" + PresetColour.TRAIT.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u88c5\u5907\u7279\u6027\u3002</span>");
                    }
                } else if (!this.owner.hasPerkInTree(this.perkRow, this.levelUpPerk) && !this.levelUpPerk.isHiddenPerk()) {
                    if (!PerkManager.MANAGER.isPerkAvailable(this.owner, this.perkRow, this.levelUpPerk)) {
                        tooltipSB.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u9700\u8981\u4e00\u4e2a\u76f8\u8fde\u7684\u5929\u8d4b\u6216\u7279\u6027\u624d\u80fd\u8d2d\u4e70\u3002</span>");
                    } else {
                        tooltipSB.append("<span style='color:" + PresetColour.GENERIC_MINOR_GOOD.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u8d2d\u4e70\u5929\u8d4b\u3002</span>");
                    }
                } else {
                    tooltipSB.append("<span style='color:" + PresetColour.PERK.toWebHexString() + ";'>" + UtilText.parse(this.owner, "[npc.Name]\u5df2\u62e5\u6709\u8fd9\u9879\u5929\u8d4b\uff01", new ParserTag[0]) + "</span>");
                }
                tooltipSB.append("</div>");
            }
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 242 + specialYIncrease + yIncrease * 18);
        } else if (this.move != null) {
            int specialYIncrease = 0;
            int yIncrease = 0;
            List<String> critReqs = this.move.getCritRequirements(this.owner, null, null, null);
            int currentCooldown = this.owner.getMoveCooldown(this.move.getIdentifier());
            boolean coreMove = this.owner.getEquippedMoves().contains(this.move);
            int combatTurn = Main.game.isInCombat() ? Main.combat.getTurn() : 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(this.move.getName(0, this.owner)) + "</h5></div>");
            tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 0 8px; width:calc(50% - 10px);'>" + (coreMove ? "[style.colourMinorGood(\u6838\u5fc3)]" : "[style.colourMinorBad(\u975e\u6838\u5fc3)]") + "</div>");
            tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 0 2px; width:calc(50% - 10px); color:" + this.move.getColourByDamageType(0, this.owner).toWebHexString() + ";'>" + this.move.getType().getName() + "</div>");
            if (currentCooldown > 0) {
                specialYIncrease += 64;
                tooltipSB.append("<div class='subTitle'>[style.colourTerrible(\u51b7\u5374\u4e2d)]\uff1a" + currentCooldown + "\u56de\u5408</div>");
            }
            Util.Value<Boolean, String> availableValue = this.owner.isMoveAvailable(this.move.getIdentifier());
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.move.getSVGString() + "</div></div>");
            tooltipSB.append("<span style='color:" + (availableValue.getKey() != false ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_MINOR_BAD).toWebHexString() + ";'>" + availableValue.getValue() + "</span> " + this.move.getDescription(!Main.game.isInCombat() ? 0 : this.owner.getSelectedMoves().size(), this.owner));
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            if (this.move.getBaseDamage(this.owner) > 0 || !this.move.getAoeDamage().isEmpty()) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                if (this.move.getBaseDamage(this.owner) > 0) {
                    ++yIncrease;
                    tooltipSB.append("Base " + this.move.getBaseDamage(this.owner) + " " + Util.capitaliseSentence(this.move.getDamageType(combatTurn, this.owner).getMultiplierAttribute().getColouredName("span")));
                }
                if (!this.move.getAoeDamage().isEmpty()) {
                    for (AoEData aoe : this.move.getAoeDamage()) {
                        ++yIncrease;
                        int aoeChance = aoe.getChance();
                        tooltipSB.append("<br/>");
                        tooltipSB.append("[style.colourAqua(\u8303\u56f4\u4f24\u5bb3)] (<span style='color:" + (aoeChance <= 25 ? PresetColour.GENERIC_BAD : (aoeChance <= 50 ? PresetColour.GENERIC_MINOR_BAD : (aoeChance <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + aoeChance + "%</span>): " + aoe.getDamage(this.owner) + Util.capitaliseSentence(this.move.getDamageType(combatTurn, this.owner).getMultiplierAttribute().getColouredName("span")));
                    }
                }
                tooltipSB.append("</div>");
            }
            int apCost = this.move.getAPcost(this.owner);
            int cooldown = this.move.getCooldown(this.owner);
            StringBuilder effectsSB = new StringBuilder();
            if (!coreMove) {
                ++yIncrease;
                effectsSB.append("[style.italicsMinorBad(\u975e\u6838\u5fc3\u62db\u5f0f\u7684\u884c\u52a8\u70b9\u6d88\u8017\u4e0e\u51b7\u5374\u65f6\u95f4+1)]<br/>");
            }
            effectsSB.append("\u884c\u52a8\u70b9\u6d88\u8017\uff1a<span style='color:" + PresetColour.ACTION_POINT_COLOURS[apCost].toWebHexString() + ";'>" + String.valueOf(coreMove ? Integer.valueOf(apCost) : apCost - 1 + "[style.colourBad(+1)]") + "</span>");
            effectsSB.append("<br/>\u51b7\u5374\uff1a<span style='color:" + (cooldown - (coreMove ? 0 : 1) <= 0 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_MINOR_BAD).toWebHexString() + ";'>" + String.valueOf(coreMove ? Integer.valueOf(cooldown) : cooldown - 1 + "[style.colourBad(+1)]") + "</span>\u56de\u5408");
            if (this.move.getStatusEffects(this.owner, this.owner, false) != null) {
                for (Map.Entry<AbstractStatusEffect, Integer> entry : this.move.getStatusEffects(this.owner, this.owner, false).entrySet()) {
                    effectsSB.append("<br/>");
                    effectsSB.append("\u6548\u679c\uff1a<span style='color:" + entry.getKey().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(entry.getKey().getName(null)) + "</span>" + String.valueOf(entry.getValue()) + "\u56de\u5408");
                    ++yIncrease;
                }
            }
            if (effectsSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(effectsSB.toString());
                tooltipSB.append("</div>");
            }
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append("<span style='color:" + PresetColour.CRIT.toWebHexString() + ";'>\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\u5c06\u66b4\u51fb\uff1a</span>");
            for (String s : critReqs) {
                ++yIncrease;
                tooltipSB.append("<br/>" + s);
            }
            tooltipSB.append("</div>");
            if (!Main.game.isInCombat()) {
                specialYIncrease += 16;
                ++yIncrease;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal; font-style:italic;'>");
                if (this.owner.getEquippedMoves().contains(this.move)) {
                    tooltipSB.append("<span style='color:" + PresetColour.GENERIC_MINOR_BAD.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u5378\u4e0b\u6280\u80fd\u3002</div>");
                } else if (this.owner.getEquippedMoves().size() >= 8) {
                    tooltipSB.append("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5df2\u9009\u62e9\u6700\u5927\u6570\u91cf\u6838\u5fc3\u6280\u80fd\u3002</div>");
                } else {
                    tooltipSB.append("<span style='color:" + PresetColour.TRAIT.toWebHexString() + ";'>\u70b9\u51fb\u4ee5\u88c5\u5907\u6280\u80fd\u3002</div>");
                }
                tooltipSB.append("</div>");
            }
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 276 + specialYIncrease + yIncrease * 18);
        } else if (this.desire != null) {
            int yIncrease = 0;
            int specialYIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center' style='color:" + this.desire.getColour().toWebHexString() + ";'><h5>" + Util.capitaliseSentence(this.desire.getName()) + "</h5></div>");
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.desire.getSVGImage() + "</div></div>");
            tooltipSB.append(this.fetish.getFetishDesireDescription(this.owner, this.desire));
            if (this.owner.hasFetish(this.fetish) && this.desire != FetishDesire.FOUR_LOVE) {
                tooltipSB.append("<br/><i>\u4f60\u7684\u6e34\u671b\u503c[style.boldBad(\u88ab\u9501\u5b9a)]\u4e3a<b style='color:" + FetishDesire.FOUR_LOVE.getColour().toWebHexString() + ";'>" + FetishDesire.FOUR_LOVE.getName() + "</b>\uff0c\u7531\u4e8e\u62e5\u6709\u76f8\u5173\u7684\u6027\u7656(" + this.fetish.getName(this.owner) + ")\u3002</i>");
            }
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            StringBuilder attributesSB = new StringBuilder();
            List<String> extraDescriptions = this.desire.getModifiersAsStringList();
            if (extraDescriptions != null && !extraDescriptions.isEmpty()) {
                int i = 0;
                for (String s : extraDescriptions) {
                    attributesSB.append((i != 0 ? "<br/>" : "") + s);
                    ++i;
                    ++yIncrease;
                }
            }
            if (attributesSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(attributesSB.toString());
                tooltipSB.append("</div>");
            }
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal; font-style:italic;'>");
            if (this.owner.hasFetish(this.fetish) && this.desire != FetishDesire.FOUR_LOVE || this.owner.getBaseFetishDesire(this.fetish) == this.desire) {
                tooltipSB.append("\u6d88\u8017\uff1a[style.colourDisabled(\u4e0d\u9002\u7528)]");
            } else {
                tooltipSB.append("\u6d88\u8017\uff1a" + (FetishDesire.getCostToChange() == 0 ? "\u514d\u8d39" : UtilText.formatAsEssences(FetishDesire.getCostToChange(), "span", false)));
            }
            tooltipSB.append("</div>");
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 242 + specialYIncrease + yIncrease * 18);
        } else if (this.fetish != null) {
            if (this.fetishExperience) {
                Main.mainController.setTooltipSize(420, 156);
                tooltipSB.setLength(0);
                tooltipSB.append("<div class='title'>" + Util.capitaliseSentence(this.fetish.getName(this.owner)) + "\u6027\u7656</div>");
                FetishLevel level = FetishLevel.getFetishLevelFromValue(this.owner.getFetishExperience(this.fetish));
                tooltipSB.append("<div class='subTitle'>\u7b49\u7ea7 " + level.getNumeral() + ": <span style='color:" + level.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(level.getName()) + "</span><span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>|</span> " + this.owner.getFetishExperience(this.fetish) + " / " + level.getMaximumExperience() + " \u7ecf\u9a8c</div>");
                tooltipSB.append("<div class='description' style='height:53px'>\u4f60\u5728\u6027\u884c\u4e3a\u4e2d\u91c7\u53d6\u4e86\u76f8\u5173\u52a8\u4f5c\uff0c\u83b7\u5f97\u4e86\u6027\u7656\u7ecf\u9a8c\u3002\u66f4\u591a\u6027\u7656\u6280\u80fd\u4f1a\u968f\u5347\u7ea7\u89e3\u9501(\u6700\u9ad8\u7b49\u7ea7\u4e3a5)\u3002</div>");
                Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            } else {
                int yIncrease = 0;
                int specialYIncrease = 0;
                boolean fetishHasUnlockRequirements = !this.fetish.getFetishesForAutomaticUnlock().isEmpty() || !this.owner.hasFetish(this.fetish) && !this.fetish.getPerkRequirements(this.owner).isEmpty();
                tooltipSB.setLength(0);
                tooltipSB.append("<body>");
                tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(this.fetish.getName(this.owner)) + "</h5></div>");
                FetishLevel level = FetishLevel.getFetishLevelFromValue(this.owner.getFetishExperience(this.fetish));
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append("\u7b49\u7ea7" + level.getNumeral() + "\uff1a<span style='color:" + level.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(level.getName()) + "</span><span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>|</span> " + this.owner.getFetishExperience(this.fetish) + " / " + level.getMaximumExperience() + " \u7ecf\u9a8c");
                String appliedFetishLevelDescription = this.fetish.getAppliedFetishLevelEffectDescription(this.owner);
                tooltipSB.append("<br/>[style.colourFetish(\u7b49\u7ea7\u6548\u679c\uff1a)] ");
                if (appliedFetishLevelDescription != null && !appliedFetishLevelDescription.isEmpty()) {
                    tooltipSB.append("<i>" + appliedFetishLevelDescription + "</i>");
                } else {
                    tooltipSB.append("[style.colourDisabled(\u65e0\u2026\u2026)]");
                }
                tooltipSB.append("</div>");
                if (fetishHasUnlockRequirements) {
                    specialYIncrease += 16;
                    tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                    tooltipSB.append("<b>\u8981\u6c42</b>");
                    ++yIncrease;
                    for (AbstractFetish f : this.fetish.getFetishesForAutomaticUnlock()) {
                        if (this.owner.hasFetish(f)) {
                            tooltipSB.append("<br/>[style.italicsGood(" + Util.capitaliseSentence(f.getName(this.owner)) + ")]");
                        } else {
                            tooltipSB.append("<br/>[style.italicsBad(" + Util.capitaliseSentence(f.getName(this.owner)) + ")]");
                        }
                        ++yIncrease;
                    }
                    if (!this.owner.hasFetish(this.fetish)) {
                        for (String s : this.fetish.getPerkRequirements(this.owner)) {
                            tooltipSB.append("<br/>" + s);
                            ++yIncrease;
                        }
                    }
                    tooltipSB.append("</div>");
                }
                tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
                tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
                tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.fetish.getSVGString(this.owner) + "</div></div>");
                tooltipSB.append(this.fetish.getDescription(this.owner));
                tooltipSB.append("</div>");
                tooltipSB.append("</div>");
                StringBuilder attributesSB = new StringBuilder();
                List<String> extraDescriptions = this.fetish.getModifiersAsStringList(this.owner);
                if (extraDescriptions != null && !extraDescriptions.isEmpty()) {
                    int i = 0;
                    for (String s : extraDescriptions) {
                        attributesSB.append((i != 0 ? "<br/>" : "") + s);
                        ++i;
                        ++yIncrease;
                    }
                }
                if (attributesSB.length() > 0) {
                    specialYIncrease += 16;
                    tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                    tooltipSB.append(attributesSB.toString());
                    tooltipSB.append("</div>");
                }
                if (!fetishHasUnlockRequirements && this.fetishWithCostInformation) {
                    specialYIncrease += 16;
                    tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal; font-style:italic;'>");
                    if (this.owner.hasBaseFetish(this.fetish)) {
                        tooltipSB.append("\u6d88\u8017\uff1a[style.colourDisabled(\u4e0d\u9002\u7528 - \u5df2\u62e5\u6709)]");
                    } else {
                        tooltipSB.append("\u6d88\u8017\uff1a" + UtilText.formatAsEssences(this.fetish.getCost(), "span", false));
                    }
                    ++yIncrease;
                    tooltipSB.append("</div>");
                }
                tooltipSB.append("</body>");
                Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
                Main.mainController.setTooltipSize(480, 260 + specialYIncrease + yIncrease * 18);
            }
        } else if (this.spell != null) {
            int yIncrease = 0;
            int specialYIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(this.spell.getName()) + "</h5></div>");
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.spell.getSVGString() + "</div></div>");
            tooltipSB.append(this.spell.isForbiddenSpell() && !this.owner.hasSpell(this.spell) ? "[style.italicsArcane(\u8fd9\u662f\u88ab\u7981\u6b62\u7684\u6cd5\u672f\uff0c\u53ea\u80fd\u901a\u8fc7\u7279\u522b\u4efb\u52a1\u53d1\u73b0\uff01)]<br/>" : "");
            tooltipSB.append(this.spell.getDescription(this.owner));
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append("[style.colourExcellent(\u66b4\u51fb\u8981\u6c42)]\uff1a");
            for (String s : this.spell.getCritRequirements(this.owner, null, null, null)) {
                ++yIncrease;
                tooltipSB.append("<br/>" + s);
            }
            tooltipSB.append("</div>");
            StringBuilder attributesSB = new StringBuilder();
            if (this.spell.getDamage(Main.game.getPlayer()) > 0) {
                attributesSB.append((attributesSB.length() == 0 ? "" : "<br/>") + "\u57fa\u7840" + this.spell.getDamage(this.owner) + "<span style='color:" + this.spell.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.spell.getDamageType().getName()) + "\u4f24\u5bb3</span><br/>" + Attack.getMinimumSpellDamage(this.owner, null, this.spell.getDamageType(), this.spell.getDamage(this.owner), this.spell.getDamageVariance()) + "-" + Attack.getMaximumSpellDamage(this.owner, null, this.spell.getDamageType(), this.spell.getDamage(this.owner), this.spell.getDamageVariance()) + "<span style='color:" + this.spell.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.spell.getDamageType().getName()) + "\u4f24\u5bb3</span>");
                ++yIncrease;
                ++yIncrease;
            }
            for (int i = 0; i < this.spell.getModifiersAsStringList().size(); ++i) {
                attributesSB.append((attributesSB.length() == 0 ? "" : "<br/>") + this.spell.getModifiersAsStringList().get(i));
                ++yIncrease;
            }
            if (attributesSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(attributesSB.toString());
                tooltipSB.append("</div>");
            }
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append("<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u6d88\u8017</b><b>" + this.spell.getModifiedCost(this.owner) + "</b><b style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>\u7075\u6c14</b>");
            tooltipSB.append("</div>");
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 278 + specialYIncrease + yIncrease * 18);
        } else if (this.spellUpgrade != null) {
            int yIncrease = 0;
            int specialYIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<body>");
            tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(this.spellUpgrade.getName()) + "</h5></div>");
            tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
            tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
            tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + this.spellUpgrade.getSVGString() + "</div></div>");
            tooltipSB.append(this.spellUpgrade.getDescription());
            tooltipSB.append("</div>");
            tooltipSB.append("</div>");
            StringBuilder attributesSB = new StringBuilder();
            String unavailableReason = this.spellUpgrade.getUnavailableReason(this.owner);
            if (unavailableReason != null && !unavailableReason.isEmpty()) {
                attributesSB.append(unavailableReason);
                ++yIncrease;
            }
            for (int i = 0; i < this.spellUpgrade.getModifiersAsStringList().size(); ++i) {
                attributesSB.append((attributesSB.length() == 0 ? "" : "<br/>") + this.spellUpgrade.getModifiersAsStringList().get(i));
                ++yIncrease;
            }
            if (attributesSB.length() > 0) {
                specialYIncrease += 16;
                tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
                tooltipSB.append(attributesSB.toString());
                tooltipSB.append("</div>");
            }
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            if (this.owner.hasSpellUpgrade(this.spellUpgrade)) {
                tooltipSB.append("[style.boldExcellent(\u5df2\u62e5\u6709)](\u5360\u7528<b style='color:" + this.spellUpgrade.getSpellSchool().getColour().toWebHexString() + ";'>" + this.spellUpgrade.getPointCost() + "</b>\u70b9\u6570)");
            } else if (this.owner.getSpellUpgradePoints(this.spellUpgrade.getSpellSchool()) >= this.spellUpgrade.getPointCost()) {
                tooltipSB.append("\u5360\u7528<b style='color:" + this.spellUpgrade.getSpellSchool().getColour().toWebHexString() + ";'>" + this.spellUpgrade.getPointCost() + "</b>\u70b9\u6570 - [style.colourGood(\u53ef\u627f\u62c5\uff01)]");
            } else {
                tooltipSB.append("\u5360\u7528<b style='color:" + this.spellUpgrade.getSpellSchool().getColour().toWebHexString() + ";'>" + this.spellUpgrade.getPointCost() + "</b>\u70b9\u6570 - [style.colourBad(\u4e0d\u53ef\u627f\u62c5\uff01)]");
            }
            tooltipSB.append("</div>");
            tooltipSB.append("</body>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            Main.mainController.setTooltipSize(480, 242 + specialYIncrease + yIncrease * 18);
        } else if (this.attribute != null) {
            if (this.attribute == Attribute.MAJOR_PHYSIQUE || this.attribute == Attribute.MAJOR_ARCANE || this.attribute == Attribute.MAJOR_CORRUPTION || this.attribute == Attribute.AROUSAL || this.attribute == Attribute.LUST) {
                AbstractStatusEffect currentAttributeStatusEffect = null;
                int minimumLevelValue = 0;
                int maximumLevelValue = 0;
                if (this.attribute == Attribute.MAJOR_PHYSIQUE) {
                    currentAttributeStatusEffect = PhysiqueLevel.getPhysiqueLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_PHYSIQUE)).getRelatedStatusEffect();
                    minimumLevelValue = PhysiqueLevel.getPhysiqueLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_PHYSIQUE)).getMinimumValue();
                    maximumLevelValue = PhysiqueLevel.getPhysiqueLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_PHYSIQUE)).getMaximumValue();
                } else if (this.attribute == Attribute.MAJOR_ARCANE) {
                    currentAttributeStatusEffect = IntelligenceLevel.getIntelligenceLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_ARCANE)).getRelatedStatusEffect();
                    minimumLevelValue = IntelligenceLevel.getIntelligenceLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_ARCANE)).getMinimumValue();
                    maximumLevelValue = IntelligenceLevel.getIntelligenceLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_ARCANE)).getMaximumValue();
                } else if (this.attribute == Attribute.MAJOR_CORRUPTION) {
                    currentAttributeStatusEffect = CorruptionLevel.getCorruptionLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_CORRUPTION)).getRelatedStatusEffect();
                    minimumLevelValue = CorruptionLevel.getCorruptionLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_CORRUPTION)).getMinimumValue();
                    maximumLevelValue = CorruptionLevel.getCorruptionLevelFromValue(this.owner.getAttributeValue(Attribute.MAJOR_CORRUPTION)).getMaximumValue();
                } else if (this.attribute == Attribute.AROUSAL) {
                    currentAttributeStatusEffect = ArousalLevel.getArousalLevelFromValue(this.owner.getAttributeValue(Attribute.AROUSAL)).getRelatedStatusEffect();
                    minimumLevelValue = ArousalLevel.getArousalLevelFromValue(this.owner.getAttributeValue(Attribute.AROUSAL)).getMinimumValue();
                    maximumLevelValue = ArousalLevel.getArousalLevelFromValue(this.owner.getAttributeValue(Attribute.AROUSAL)).getMaximumValue();
                } else if (this.attribute == Attribute.LUST) {
                    currentAttributeStatusEffect = LustLevel.getLustLevelFromValue(this.owner.getAttributeValue(Attribute.LUST)).getRelatedStatusEffect();
                    minimumLevelValue = LustLevel.getLustLevelFromValue(this.owner.getAttributeValue(Attribute.LUST)).getMinimumValue();
                    maximumLevelValue = LustLevel.getLustLevelFromValue(this.owner.getAttributeValue(Attribute.LUST)).getMaximumValue();
                }
                int yIncrease = (currentAttributeStatusEffect.getModifiersAsStringList(this.owner).size() > 4 ? currentAttributeStatusEffect.getModifiersAsStringList(this.owner).size() - 4 : 0) + (this.owner.hasStatusEffect(currentAttributeStatusEffect) ? (this.owner.getStatusEffectDuration(currentAttributeStatusEffect) == -1 ? 0 : 2) : 0);
                Main.mainController.setTooltipSize(360, 460 + yIncrease * 16);
                tooltipSB.setLength(0);
                tooltipSB.append("<div class='title' style='color:" + this.attribute.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.attribute.getName()) + "</div><div class='subTitle-third'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u6838\u5fc3</b><br/>" + (String)(this.owner.getBaseAttributeValue(this.attribute) > 0.0f ? "<span style='color: " + PresetColour.GENERIC_EXCELLENT.getShades()[1] + ";'>" : "<span>") + Units.number(this.owner.getBaseAttributeValue(this.attribute), 1, 1) + "</span></div><div class='subTitle-third'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u52a0\u6210</b><br/>" + (this.owner.getBonusAttributeValue(this.attribute) > 0.0f ? "<span style='color: " + PresetColour.GENERIC_GOOD.getShades()[1] + ";'>" : (this.owner.getBonusAttributeValue(this.attribute) == 0.0f ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>" : "<span style='color: " + PresetColour.GENERIC_BAD.getShades()[1] + ";'>")) + Units.number(this.owner.getBonusAttributeValue(this.attribute), 1, 1) + "</span></div><div class='subTitle-third'><b style='color:" + this.attribute.getColour().toWebHexString() + ";'>\u603b\u548c</b><br/>" + Units.number(this.owner.getAttributeValue(this.attribute), 1, 1) + "</span></div>");
                tooltipSB.append("<div class='description-half'>" + this.attribute.getDescription(this.owner) + "</div>");
                tooltipSB.append("<div class='title'><span style='color:" + currentAttributeStatusEffect.getColour().toWebHexString() + ";'>" + currentAttributeStatusEffect.getName(this.owner) + "</span> (" + minimumLevelValue + "-" + maximumLevelValue + ")</div>");
                tooltipSB.append("<div class='subTitle-picture'>");
                if (!currentAttributeStatusEffect.getModifiersAsStringList(this.owner).isEmpty()) {
                    int i = 0;
                    for (String s : currentAttributeStatusEffect.getModifiersAsStringList(this.owner)) {
                        if (i != 0) {
                            tooltipSB.append("<br/>");
                        }
                        tooltipSB.append(s);
                        ++i;
                    }
                } else {
                    tooltipSB.append("<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u7279\u6548</span>");
                }
                tooltipSB.append("</div>");
                tooltipSB.append("<div class='picture'>" + currentAttributeStatusEffect.getSVGString(this.owner) + "</div>");
                tooltipSB.append("<div class='description'>" + currentAttributeStatusEffect.getDescription(this.owner) + "</div>");
                Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            } else if (this.attribute == Attribute.EXPERIENCE) {
                if (this.owner.isRaceConcealed()) {
                    tooltipSB.setLength(0);
                    tooltipSB.append("<div class='title' style='color:" + PresetColour.RACE_UNKNOWN.toWebHexString() + ";'>");
                    tooltipSB.append("\u672a\u77e5\u79cd\u65cf\uff01");
                    tooltipSB.append("</div>");
                    int knownAreas = 0;
                    if (Main.game.getPlayer().isKnowsCharacterArea(CoverableArea.ANUS, this.owner)) {
                        ++knownAreas;
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u809b\u95e8", this.owner.getAssRace(), this.owner.getAssType().getAnusType().getBodyCoveringType(this.owner), this.owner.isAnusFeral()));
                    }
                    if (Main.game.getPlayer().isKnowsCharacterArea(CoverableArea.BREASTS, this.owner)) {
                        ++knownAreas;
                        if (this.owner.isFeral() && !this.owner.getFeralAttributes().isBreastsPresent()) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934(\u80f8\u90e8)", "\u65e0"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e73\u5934", this.owner.getBreastRace(), this.owner.getBreastType().getNippleType().getBodyCoveringType(this.owner), this.owner.isNippleFeral(), Util.capitaliseSentence(Util.intToString(this.owner.getBreastRows() * 2)) + "\u4e2a" + (String)(this.owner.getBreastRawSizeValue() > 0 ? this.owner.getBreastSize().getCupSizeName() + "\u7f69\u676f\u4e73\u623f" : (this.owner.isFeminine() ? "\u5e73\u80f8" : "\u5e73\u677f\u80f8\u90e8"))));
                        }
                    }
                    if (this.owner.hasBreastsCrotch() && Main.game.getPlayer().isKnowsCharacterArea(CoverableArea.BREASTS_CROTCH, this.owner)) {
                        ++knownAreas;
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e73\u5934", this.owner.getBreastCrotchRace(), this.owner.getNippleCrotchCovering(), this.owner.isNippleCrotchFeral(), Util.capitaliseSentence(Util.intToString(Math.max(1, this.owner.getBreastCrotchRows() * 2))) + "\u4e2a" + (String)(this.owner.getBreastRawSizeValue() > 0 ? this.owner.getBreastCrotchSize().getCupSizeName() + "\u7f69\u676f" : "\u5e73\u5766 ") + (this.owner.getBreastCrotchShape() == BreastShape.UDDERS ? (this.owner.getBreastCrotchRows() == 0 ? "\u8179\u4e73" : "\u8179\u4e73") : "\u80ef\u4e73")));
                    }
                    if (Main.game.getPlayer().isKnowsCharacterArea(CoverableArea.PENIS, this.owner)) {
                        ++knownAreas;
                        if (this.owner.hasPenisIgnoreDildo()) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9634\u830e", this.owner.getPenisRace(), this.owner.getPenisCovering(), this.owner.isPenisFeral(), "[unit.sizeShort(" + this.owner.getPenisRawSizeValue() + ")]"));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u830e", "\u65e0"));
                        }
                    }
                    if (Main.game.getPlayer().isKnowsCharacterArea(CoverableArea.VAGINA, this.owner)) {
                        ++knownAreas;
                        if (this.owner.getVaginaType() != VaginaType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9634\u9053", this.owner.getVaginaRace(), this.owner.getVaginaCovering(), this.owner.isVaginaFeral(), this.owner.isClitorisPseudoPenis() ? "[unit.sizeShort(" + this.owner.getVaginaRawClitorisSizeValue() + ")]\u9634\u8482" : null));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u9053", "\u65e0"));
                        }
                    }
                    Main.mainController.setTooltipSize(420, 64 + knownAreas * 28);
                } else {
                    boolean displayImage;
                    CachedImage image = null;
                    boolean bl = displayImage = Main.getProperties().hasValue(PropertyValue.thumbnail) && Main.getProperties().hasValue(PropertyValue.artwork) && (!this.owner.isElemental() || ((Elemental)this.owner).isActive());
                    if (displayImage) {
                        if (this.owner.hasArtwork()) {
                            image = ImageCache.INSTANCE.requestImage(this.owner.getCurrentArtwork().getCurrentImage());
                        }
                        displayImage = image != null;
                    }
                    boolean crotchBreasts = this.owner.hasBreastsCrotch() && (this.owner.isBreastsCrotchVisibleThroughClothing() || this.owner.isAreaKnownByCharacter(CoverableArea.NIPPLES_CROTCH, Main.game.getPlayer()));
                    boolean spinneret = this.owner.hasSpinneret();
                    boolean elemental = this.owner.isElemental() && !((Elemental)this.owner).getSummoner().isElementalActive();
                    int crotchBreastAddition = crotchBreasts ? 24 : 0;
                    int spinneretAddition = spinneret ? 24 : 0;
                    int[] dimensions = new int[]{419, elemental ? 108 + (((Elemental)this.owner).getSummoner().isPlayer() ? 28 : 0) : 522 + crotchBreastAddition + spinneretAddition};
                    int imagePadding = 0;
                    int imageWidth = 0;
                    if (displayImage) {
                        int[] scaledSize = image.getAdjustedSize(380, 445);
                        imageWidth = scaledSize[0];
                        dimensions[0] = dimensions[0] + scaledSize[0];
                        imagePadding = Math.max(0, 455 - scaledSize[1]);
                    }
                    Main.mainController.setTooltipSize(dimensions[0], dimensions[1]);
                    tooltipSB.setLength(0);
                    BodyShape bodyShape = this.owner.getBodyShape();
                    boolean feral = this.owner.isFeral();
                    tooltipSB.append("<div class='title'>" + (String)(this.owner.getRaceStage().getName() != "" ? "<b style='color:" + this.owner.getRaceStage().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.owner.getRaceStage().getName()) + "</b>" : "") + "<b style='color:" + this.owner.getSubspecies().getColour(this.owner).toWebHexString() + ";'>" + (this.owner.isFeminine() ? Util.capitaliseSentence((this.owner.isPrependWingedToRaceName() ? "\u6709\u7ffc" : "") + this.owner.getSubspecies().getSingularFemaleName(this.owner.getBody())) : Util.capitaliseSentence((this.owner.isPrependWingedToRaceName() ? "\u6709\u7ffc" : "") + this.owner.getSubspecies().getSingularMaleName(this.owner.getBody()))) + "</b>" + (String)(elemental ? "" : "<div class='subTitle' style='font-weight:normal; margin:0; padding:0; background:#00000000; width:100%;'><span style='color:" + this.owner.getFemininity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.owner.getFemininity().getName(false)) + "</span> | <span style='color:" + bodyShape.toWebHexStringColour() + ";'>" + Util.capitaliseSentence(bodyShape.getName(false)) + "\u7684\u8eab\u4f53</span> | " + (feral && !this.owner.getFeralAttributes().isSizeHeight() ? "[unit.sizeShort(" + this.owner.getHeightValue() + ")]\u957f" : "[unit.sizeShort(" + this.owner.getHeightValue() + ")]\u9ad8</div>")) + "</div>");
                    if (displayImage) {
                        tooltipSB.append("<div style='width: 410px; float: left'>");
                    }
                    if (!elemental) {
                        if (this.owner.getCovering(this.owner.getFaceCovering()).getPattern() == CoveringPattern.FRECKLED_FACE) {
                            Covering c = this.owner.getCovering(this.owner.getFaceCovering());
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9762\u90e8", this.owner.getFaceRace(), new Covering(this.owner.getFaceCovering(), CoveringPattern.FRECKLED, c.getModifier(), c.getPrimaryColour(), c.isPrimaryGlowing(), c.getSecondaryColour(), c.isSecondaryGlowing()), this.owner.isFaceFeral(), null));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9762\u90e8", this.owner.getFaceRace(), this.owner.getFaceCovering(), this.owner.isFaceFeral()));
                        }
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u8eaf\u5e72", this.owner.getSkinRace(), this.owner.getTorsoCovering(), this.owner.isTorsoFeral()));
                        if (this.owner.isFeral() && !this.owner.getFeralAttributes().isArmsOrWingsPresent() && this.owner.getLegConfiguration() != LegConfiguration.AVIAN) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u624b\u81c2", "\u65e0"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getArmRows() * 2)) + "\u53ea\u624b\u81c2", this.owner.getArmRace(), this.owner.getArmCovering(), this.owner.isArmFeral()));
                        }
                        switch (this.owner.getLegConfiguration()) {
                            case ARACHNID: {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getLegCount())) + "\u6761\u6b65\u8db3", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                break;
                            }
                            case BIPEDAL: 
                            case QUADRUPEDAL: 
                            case WINGED_BIPED: {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getLegCount())) + "\u6761" + this.owner.getFootStructure().getName() + "\u817f", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                break;
                            }
                            case CEPHALOPOD: {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getLegCount())) + "\u53ea\u8155\u8db3", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                break;
                            }
                            case TAIL: {
                                if (this.owner.hasStatusEffect(StatusEffect.AQUATIC_NEGATIVE)) {
                                    tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getLegCount())) + "\u6761" + this.owner.getFootStructure().getName() + "\u817f", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                    break;
                                }
                                tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9c7c\u5c3e", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                break;
                            }
                            case TAIL_LONG: {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, "\u86c7\u5c3e(\u957f\u5ea6\uff1a" + Units.size(this.owner.getLegTailLength(false)) + ")", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                                break;
                            }
                            case AVIAN: {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getLegCount())) + "\u6761\u9e1f\u817f", this.owner.getLegRace(), this.owner.getLegCovering(), this.owner.isLegFeral()));
                            }
                        }
                        if (this.owner.getHairRawLengthValue() == 0) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u6bdb\u53d1", this.owner.isFaceBaldnessNatural() ? "\u65e0" : "\u79c3\u9876"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, this.owner.getHairStyle().getName(this.owner) + Util.capitaliseSentence(this.owner.getHairLength().getDescriptor()) + this.owner.getHairName(), this.owner.getHairRace(), this.owner.getHairCovering(), this.owner.isHairFeral()));
                        }
                        if (!this.owner.isPlayer() && !this.owner.isAreaKnownByCharacter(CoverableArea.EYES, Main.game.getPlayer())) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u773c\u90e8", "\u672a\u77e5\uff01"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getEyePairs() * 2)) + "\u53ea\u773c\u775b", this.owner.getEyeRace(), this.owner.getEyeCovering(), this.owner.isEyeFeral()));
                        }
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u8033\u6735", this.owner.getEarRace(), this.owner.getEarCovering(), this.owner.isEarFeral()));
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u820c\u5934", this.owner.getTongueRace(), this.owner.getTongueCovering(), this.owner.isTongueFeral()));
                        if (this.owner.getHornType() != HornType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getTotalHorns())) + "\u6839" + (this.owner.getTotalHorns() == 1 ? this.owner.getHornNameSingular() : this.owner.getHornName()), this.owner.getHornRace(), this.owner.getHornCovering(), this.owner.isHornFeral()));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u89d2", "\u65e0"));
                        }
                        if (this.owner.getAntennaType() != AntennaType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getAntennaRows() * this.owner.getAntennaePerRow())) + "\u6839\u89e6\u987b", this.owner.getAntennaRace(), this.owner.getAntennaCovering(), this.owner.isAntennaFeral()));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u89e6\u987b", "\u65e0"));
                        }
                        if (this.owner.getWingType() != WingType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(this.owner.getWingSize().getName()) + "\u7684\u7fc5\u8180", this.owner.getWingRace(), this.owner.getWingCovering(), this.owner.isWingFeral()));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u7fc5\u8180", "\u65e0"));
                        }
                        if (this.owner.getTailType() != TailType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, Util.capitaliseSentence(Util.intToString(this.owner.getTailCount())) + "\u6761" + this.owner.getTailGirthDescriptor() + "\u7684\u5c3e\u5df4", this.owner.getTailRace(), this.owner.getTailCovering(), this.owner.isTailFeral()));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u5c3e\u5df4", "\u65e0"));
                        }
                        if (!this.owner.isPlayer() && !this.owner.isAreaKnownByCharacter(CoverableArea.VAGINA, Main.game.getPlayer())) {
                            if (this.owner.getVaginaType() == VaginaType.NONE && Main.game.getPlayer().hasTrait(Perk.OBSERVANT, true)) {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u9053", "\u65e0"));
                            } else {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u9053", "\u672a\u77e5\uff01"));
                            }
                        } else if (this.owner.getVaginaType() != VaginaType.NONE) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9634\u9053", this.owner.getVaginaRace(), this.owner.getVaginaCovering(), this.owner.isVaginaFeral(), this.owner.isClitorisPseudoPenis() ? "[unit.sizeShort(" + this.owner.getVaginaRawClitorisSizeValue() + ")]\u9634\u8482" : null));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u9053", "\u65e0"));
                        }
                        if (!this.owner.isPlayer() && !this.owner.isAreaKnownByCharacter(CoverableArea.PENIS, Main.game.getPlayer())) {
                            if (!this.owner.hasPenis() && Main.game.getPlayer().hasTrait(Perk.OBSERVANT, true)) {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u830e", "\u65e0"));
                            } else {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u830e", "\u672a\u77e5\uff01"));
                            }
                        } else if (this.owner.hasPenisIgnoreDildo()) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9634\u830e", this.owner.getPenisRace(), this.owner.getPenisCovering(), this.owner.isPenisFeral(), "[unit.sizeShort(" + this.owner.getPenisRawSizeValue() + ")]\u957f\uff0c[unit.sizeShort(" + this.owner.getPenisDiameter() + ")]\u76f4\u5f84"));
                        } else if (this.owner.hasPenis()) {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u9634\u830e", this.owner.getPenisRace(), this.owner.getPenisCovering(), this.owner.isPenisFeral(), "[unit.sizeShort(" + this.owner.getPenisRawSizeValue() + ")]\u957f\uff0c[unit.sizeShort(" + this.owner.getPenisDiameter() + ")]\u76f4\u5f84"));
                        } else {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u830e", "\u65e0"));
                        }
                        if (!this.owner.isPlayer() && !this.owner.isAreaKnownByCharacter(CoverableArea.ANUS, Main.game.getPlayer())) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u809b\u95e8", "\u672a\u77e5\uff01"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u809b\u95e8", this.owner.getAssRace(), this.owner.getAssType().getAnusType().getBodyCoveringType(this.owner), this.owner.isAnusFeral()));
                        }
                        if (!this.owner.isPlayer() && !this.owner.isAreaKnownByCharacter(CoverableArea.NIPPLES, Main.game.getPlayer())) {
                            if (this.owner.isFeral() && !this.owner.getFeralAttributes().isBreastsPresent()) {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934(\u80f8\u90e8)", "\u65e0"));
                            } else {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934", "\u672a\u77e5\uff01", Util.capitaliseSentence(Util.intToString(this.owner.getBreastRows() * 2)) + "\u4e2a" + (String)(this.owner.getBreastRawSizeValue() > 0 ? this.owner.getBreastSize().getCupSizeName() + "\u7f69\u676f\u4e73\u623f" : (this.owner.isFeminine() ? "\u5e73\u80f8" : "\u5e73\u677f\u80f8\u90e8"))));
                            }
                        } else if (this.owner.isFeral() && !this.owner.getFeralAttributes().isBreastsPresent()) {
                            tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934(\u80f8\u90e8)", "\u65e0"));
                        } else {
                            tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e73\u5934", this.owner.getBreastRace(), this.owner.getBreastType().getNippleType().getBodyCoveringType(this.owner), this.owner.isNippleFeral(), Util.capitaliseSentence(Util.intToString(this.owner.getBreastRows() * 2)) + "\u4e2a" + (String)(this.owner.getBreastRawSizeValue() > 0 ? this.owner.getBreastSize().getCupSizeName() + "\u7f69\u676f\u4e73\u623f" : (this.owner.isFeminine() ? "\u5e73\u80f8" : "\u5e73\u677f\u80f8\u90e8"))));
                        }
                        if (spinneret) {
                            if (this.owner.hasTailSpinneret()) {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e1d\u56ca", this.owner.getTailRace(), this.owner.getSpinneretCovering(), this.owner.isTailFeral(), ""));
                            } else {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e1d\u56ca", this.owner.getLegRace(), this.owner.getSpinneretCovering(), this.owner.isLegFeral(), ""));
                            }
                        }
                        if (crotchBreasts) {
                            if (!this.owner.isAreaKnownByCharacter(CoverableArea.NIPPLES_CROTCH, Main.game.getPlayer())) {
                                tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934", "\u672a\u77e5\uff01", Util.capitaliseSentence(Util.intToString(Math.max(1, this.owner.getBreastCrotchRows() * 2))) + "\u4e2a" + (String)(this.owner.getBreastCrotchRawSizeValue() > 0 ? this.owner.getBreastCrotchSize().getCupSizeName() + "\u7f69\u676f" : "\u5e73\u5766") + (this.owner.getBreastCrotchShape() == BreastShape.UDDERS ? (this.owner.getBreastCrotchRows() == 0 ? "\u8179\u4e73" : "\u8179\u4e73") : "\u80ef\u4e73")));
                            } else {
                                tooltipSB.append(this.getBodyPartDiv(this.owner, "\u4e73\u5934", this.owner.getBreastCrotchRace(), this.owner.getNippleCrotchCovering(), this.owner.isNippleCrotchFeral(), Util.capitaliseSentence(Util.intToString(Math.max(1, this.owner.getBreastCrotchRows() * 2))) + "\u4e2a" + (String)(this.owner.getBreastCrotchRawSizeValue() > 0 ? this.owner.getBreastCrotchSize().getCupSizeName() + "\u7f69\u676f" : "\u5e73\u5766") + (this.owner.getBreastCrotchShape() == BreastShape.UDDERS ? (this.owner.getBreastCrotchRows() == 0 ? "\u8179\u4e73" : "\u8179\u4e73") : "\u80ef\u4e73")));
                            }
                        }
                    } else {
                        tooltipSB.append(this.getBodyPartDiv(this.owner, "\u88ab\u52a8\u5f62\u5f0f", this.owner.getSkinRace(), this.owner.getTorsoCovering(), this.owner.isTorsoFeral()));
                        if (((Elemental)this.owner).getSummoner().isPlayer()) {
                            tooltipSB.append("<div class='subTitle' style='font-weight:normal; margin-top:2px; white-space:nowrap;'>");
                            if (!Main.game.isInNeutralDialogue()) {
                                tooltipSB.append("[style.italicsBad(\u5728\u8fd9\u4e2a\u573a\u666f\u4f60\u4e0d\u80fd\u548c\u4f60\u7684\u5143\u7d20\u8bf4\u8bdd\uff01)]");
                            } else {
                                tooltipSB.append("[style.italicsMinorGood(\u70b9\u51fb\u5f00\u59cb\u4e0e\u4f60\u7684\u5143\u7d20\u4ea4\u8c08\uff01)]");
                            }
                            tooltipSB.append("</div>");
                        }
                    }
                    if (displayImage) {
                        boolean revealed = this.owner.isImageRevealed();
                        tooltipSB.append("</div><div style='float: left;'><img id='CHARACTER_IMAGE' style='" + (revealed ? "" : "-webkit-filter: brightness(0%);") + " width: auto; height: auto; max-width: 380; max-height: 445; padding-top: " + imagePadding + "px;' src='" + image.getThumbnailString() + "'/>" + (String)(revealed ? "" : "<p style='position:absolute; top:33%; right:0; width:" + imageWidth + "; font-weight:bold; text-align:center; color:" + PresetColour.BASE_GREY.toWebHexString() + ";'>\u901a\u8fc7\u6027\u7231\u89e3\u9501\uff01</p>") + "</div>");
                    }
                }
                Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
            } else {
                Main.mainController.setTooltipSize(360, 234);
                Main.mainController.setTooltipContent(UtilText.parse("<div class='title' style='color:" + this.attribute.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.attribute.getName()) + "</div><div class='subTitle-third'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u6838\u5fc3</b><br/>" + (String)(this.owner.getBaseAttributeValue(this.attribute) > 0.0f ? "<span style='color: " + PresetColour.GENERIC_EXCELLENT.getShades()[1] + ";'>" : "<span>") + Units.number(this.owner.getBaseAttributeValue(this.attribute), 1, 1) + "</span></div><div class='subTitle-third'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u52a0\u6210</b><br/>" + (this.owner.getBonusAttributeValue(this.attribute) > 0.0f ? "<span style='color: " + PresetColour.GENERIC_GOOD.getShades()[1] + ";'>" : (this.owner.getBonusAttributeValue(this.attribute) == 0.0f ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>" : "<span style='color: " + PresetColour.GENERIC_BAD.getShades()[1] + ";'>")) + Units.number(this.owner.getBonusAttributeValue(this.attribute), 1, 1) + "</span></div><div class='subTitle-third'><b style='color:" + this.attribute.getColour().toWebHexString() + ";'>\u603b\u548c</b><br/>" + Units.number(this.owner.getAttributeValue(this.attribute), 1, 1) + "</span></div><div class='description'>" + this.attribute.getDescription(this.owner) + "</div>", new ParserTag[0]));
            }
        } else if (this.extraAttributes) {
            boolean elemental = this.owner.isElemental() && ((Elemental)this.owner).getSummoner().isPlayer();
            Main.mainController.setTooltipSize(400, 528 + (Main.game.isEnchantmentCapacityEnabled() ? 46 : 32) + (elemental ? 28 : 0));
            int enchantmentPointsUsed = this.owner.getEnchantmentPointsUsedTotal();
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='subTitle'><span style='color:" + Femininity.valueOf(this.owner.getFemininityValue()).getColour().toWebHexString() + "; font-size:110%;'>" + (this.owner.getName(true).length() == 0 ? "[npc.Race]" : (this.owner.isPlayer() || this.owner.isPlayerKnowsName() ? "[npc.NameFull]" : "[npc.Name]")) + "</span><br/>\u7b49\u7ea7 " + this.owner.getLevel() + (String)(this.owner.getLevel() != this.owner.getTrueLevel() ? "[style.colourDisabled((" + this.owner.getTrueLevel() + "))]" : "") + "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>| " + (String)(this.owner.isElemental() ? "\u5143\u7d20\u5171\u4eab\u5176\u53ec\u5524\u8005\u7684\u7b49\u7ea7</span>" : "</span>" + this.owner.getExperience() + " / " + 10 * this.owner.getLevel() + "\u7ecf\u9a8c") + "</div>");
            tooltipSB.append((String)(Main.game.isEnchantmentCapacityEnabled() ? "<div class='subTitle-half' style='padding:2px; margin:2px 1% 2px 2%; width:47%;'>[style.colourEnchantment(" + Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ")]<br/>" + ((float)enchantmentPointsUsed > this.owner.getAttributeValue(Attribute.ENCHANTMENT_LIMIT) ? "[style.colourBad(" : ((float)enchantmentPointsUsed == this.owner.getAttributeValue(Attribute.ENCHANTMENT_LIMIT) ? "[style.colourGood(" : "[style.colourMinorGood(")) + enchantmentPointsUsed + ")]/" + Math.round(this.owner.getAttributeValue(Attribute.ENCHANTMENT_LIMIT)) + "</div><div class='subTitle-half' style='padding:2px; margin:2px 2% 2px 1%; width:47%;'>" : "<div class='subTitle' style='margin:2px 1%; width:98%'>") + "[style.colourArcane(\u7cbe\u534e)]" + (Main.game.isEnchantmentCapacityEnabled() ? "<br/>" : ": ") + this.owner.getEssenceCount() + "</div>");
            attributeTableLeft = true;
            tooltipSB.append(this.getAttributeDiv(this.owner, Attribute.HEALTH_MAXIMUM) + this.getAttributeDiv(this.owner, Attribute.MANA_MAXIMUM) + this.getAttributeDiv(this.owner, Attribute.MAJOR_PHYSIQUE) + this.getAttributeDiv(this.owner, Attribute.MAJOR_ARCANE) + this.getAttributeDiv(this.owner, Attribute.MAJOR_CORRUPTION) + this.getAttributeDiv(this.owner, Attribute.CRITICAL_DAMAGE) + this.getAttributeDiv(this.owner, Attribute.SPELL_COST_MODIFIER) + this.getAttributeDiv(this.owner, Attribute.DAMAGE_SPELLS) + this.getAttributeDiv(this.owner, Attribute.DAMAGE_UNARMED) + this.getAttributeDiv(this.owner, Attribute.DAMAGE_MELEE_WEAPON) + this.getAttributeDiv(this.owner, Attribute.DAMAGE_RANGED_WEAPON) + this.getAttributeDiv(this.owner, Attribute.ENERGY_SHIELDING) + "<div class='subTitle-third combatValue' style='padding:2px; margin:2px 0 2px 2%; width:31.5%;'>\u7c7b\u578b</div><div class='subTitle-third combatValue' style='padding:2px; margin:2px 0.75%; width:31.5%;'>\u4f24\u5bb3</div><div class='subTitle-third combatValue' style='padding:2px; margin:2px 2% 2px 0; width:31.5%;'>\u62a4\u76fe</div>" + this.getAttributeTableRowDiv(this.owner, "\u7269\u7406", Attribute.DAMAGE_PHYSICAL, Attribute.RESISTANCE_PHYSICAL) + this.getAttributeTableRowDiv(this.owner, "\u706b\u7130", Attribute.DAMAGE_FIRE, Attribute.RESISTANCE_FIRE) + this.getAttributeTableRowDiv(this.owner, "\u5bd2\u51b7", Attribute.DAMAGE_ICE, Attribute.RESISTANCE_ICE) + this.getAttributeTableRowDiv(this.owner, "\u6bd2\u7d20", Attribute.DAMAGE_POISON, Attribute.RESISTANCE_POISON) + this.getAttributeTableRowDiv(this.owner, "\u9b45\u60d1", Attribute.DAMAGE_LUST, Attribute.RESISTANCE_LUST) + this.getAttributeDiv(this.owner, Attribute.FERTILITY) + this.getAttributeDiv(this.owner, Attribute.VIRILITY));
            if (elemental) {
                tooltipSB.append("<div class='subTitle' style='font-weight:normal; margin-top:2px; white-space:nowrap;'>");
                if (!Main.game.isInNeutralDialogue()) {
                    tooltipSB.append("[style.italicsBad(\u5728\u8fd9\u4e2a\u573a\u666f\u4f60\u4e0d\u80fd\u548c\u4f60\u7684\u5143\u7d20\u8bf4\u8bdd\uff01)]");
                } else {
                    tooltipSB.append("[style.italicsMinorGood(\u70b9\u51fb\u5f00\u59cb\u4e0e\u4f60\u7684\u5143\u7d20\u4ea4\u8c08\uff01)]");
                }
                tooltipSB.append("</div>");
            }
            Main.mainController.setTooltipContent(UtilText.parse(this.owner, tooltipSB.toString(), new ParserTag[0]));
        } else if (this.weather) {
            Main.mainController.setTooltipSize(360, 100);
            tooltipSB.setLength(0);
            int minutes = Math.max(1, Main.game.getWeatherTimeRemainingInSeconds() / 60);
            int hours = minutes / 60;
            tooltipSB.append("<div class='title'><b style='color:" + Main.game.getCurrentWeather().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(Main.game.getCurrentWeather().getName()) + "</b></div><div class='title'><b>" + (String)(hours > 0 ? hours + "\u65f6" : "") + (String)(minutes % 60 > 0 ? minutes + " \u5206" : "") + "\u7684\u5269\u4f59\u65f6\u95f4</b></div>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.protection) {
            Main.mainController.setTooltipSize(360, 100);
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='title'>\u4fdd\u62a4</div><div class='subTitle'>" + (this.owner.isWearingCondom() ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u7a7f\u7740\u907f\u5b55\u5957</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u65e0\u5957</span>") + "</div>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.copyInformation) {
            Main.mainController.setTooltipSize(360, 170);
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='subTitle'>\u573a\u666f\u590d\u5236</div><div class='description'>\u5355\u51fb\u4ee5\u5c06\u5f53\u524d\u663e\u793a\u7684\u5bf9\u8bdd\u590d\u5236\u5230\u526a\u8d34\u677f<br/><br/>\u8fd9\u4e00\u5e55\u7684\u4f5c\u8005\u662f<b style='color:" + PresetColour.ANDROGYNOUS.toWebHexString() + ";'>" + Main.game.getCurrentDialogueNode().getAuthor() + "</b></div>");
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.concealedSlot != null) {
            Map<InventorySlot, List<AbstractClothing>> concealedSlots = RenderingEngine.getCharacterToRender().getInventorySlotsConcealed(Main.game.getPlayer());
            List<AbstractClothing> clothingVisible = concealedSlots.get((Object)this.concealedSlot).stream().filter(clothing -> !concealedSlots.containsKey((Object)clothing.getSlotEquippedTo())).collect(Collectors.toList());
            Main.mainController.setTooltipSize(360, 175);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title'>" + Util.capitaliseSentence(this.concealedSlot.getName()) + " - [style.boldBad(\u5df2\u9690\u853d\uff01)]</div><div class='description'>" + UtilText.parse(RenderingEngine.getCharacterToRender(), (String)(concealedSlots.get((Object)this.concealedSlot).isEmpty() ? "[npc.namePos]\u7531\u4e8e\u4f4d\u7f6e\u770b\u4e0d\u89c1\u8be5\u680f\u4f4d\uff01" : (clothingVisible.isEmpty() ? "[npc.namePos]\u7684\u8863\u7269\u906e\u6321\u4e86\u8fd9\u4e2a\u680f\u4f4d\uff0c\u4f60\u73b0\u5728\u770b\u4e0d\u89c1\u5b83\uff01" : "\u7531\u4e8e\u88ab[npc.namePos]\u7684<b>" + Util.clothesToStringList(clothingVisible, false) + "</b>\u6240\u906e\u6321\uff0c\u8be5\u680f\u4f4d\u73b0\u5df2\u9690\u85cf\u3002")), new ParserTag[0]) + "</div>", new ParserTag[0]));
        } else if (this.slaveJob != null) {
            int yIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='title'>" + Util.capitaliseSentence(this.slaveJob.getName(this.owner)) + "</div>");
            tooltipSB.append("<div class='description' style='min-height:28px; height:28px; text-align:center;'>[style.boldStamina(\u6bcf\u5c0f\u65f6\u6d88\u8017\u8010\u529b\uff1a)]" + (this.slaveJob.getHourlyStaminaDrain(this.owner) > 0.0f ? "[style.boldBad(" : " [style.boldGood(") + this.slaveJob.getHourlyStaminaDrain(this.owner) + ")]</div>");
            tooltipSB.append("<div class='description' style='min-height:64px; height:64px;'>");
            tooltipSB.append(this.slaveJob.getDescription());
            if (this.slaveJob == SlaveJob.IDLE) {
                tooltipSB.append("<br/>");
                tooltipSB.append("\u7a7a\u95f2\u65f6\u95f4\u7761\u89c9\u7684\u5974\u96b6\u5c06\u62e5\u6709[style.colourSleep(zzZ)]\u6807\u8bb0\u3002");
            }
            tooltipSB.append("</div>");
            for (SlaveJobFlag flag : this.slaveJob.getFlags()) {
                tooltipSB.append("<div class='description' style='min-height:48px; height:48px;'><b style='color:" + flag.getColour().toWebHexString() + ";'>" + flag.getName() + ":</b>" + flag.getDescription() + "</div>");
                ++yIncrease;
            }
            Main.mainController.setTooltipSize(360, 172 + yIncrease * 56);
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.loadedEnchantment != null) {
            int yIncrease = 0;
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='title'>" + Util.capitaliseSentence(this.loadedEnchantment.getName()) + "</div>");
            if (this.loadedEnchantment.isSuitableItemAvailable()) {
                tooltipSB.append("<div class='subTitle' style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u7269\u54c1\u680f\u4e2d\u5408\u9002\u7684\u7269\u54c1</div>");
            } else {
                tooltipSB.append("<div class='subTitle' style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u7269\u54c1\u680f\u4e2d\u6ca1\u6709\u5408\u9002\u7684\u7269\u54c1</div>");
            }
            tooltipSB.append("<div class='subTitle-picture'>");
            int i = 0;
            for (ItemEffect ie : this.loadedEnchantment.getEffects()) {
                for (String s : ie.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                    tooltipSB.append((i != 0 ? "<br/>" : "") + s);
                    ++yIncrease;
                    if (UtilText.parse(s, new ParserTag[0]).replaceAll("<.*?>", "").length() <= 32) continue;
                    ++yIncrease;
                }
                ++i;
            }
            yIncrease = yIncrease >= 5 ? (yIncrease -= 5) : 0;
            tooltipSB.append("</div>");
            tooltipSB.append("<div class='picture'>" + this.loadedEnchantment.getSVGString() + "</div>");
            Main.mainController.setTooltipSize(360, 208 + (yIncrease > 0 ? 4 : 0) + yIncrease * 16);
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.cell != null) {
            HashSet<NPC> charactersPresent = new HashSet<NPC>(Main.game.getCharactersPresent(this.cell));
            if (!this.cell.equals(Main.game.getWorlds().get(WorldType.DOMINION).getCell(0, 0))) {
                charactersPresent.addAll(Main.game.getCharactersTreatingCellAsHome(this.cell));
            }
            boolean libraryMap = Main.game.getCurrentDialogueNode() == Library.DOMINION_MAP;
            boolean teleport = !libraryMap && Main.game.getPlayer().hasSpell(Spell.TELEPORT);
            int yIncrease = 0;
            StringBuilder charactersPresentDescription = new StringBuilder();
            StringBuilder teleportingDescription = new StringBuilder();
            if (!libraryMap) {
                if (!charactersPresent.isEmpty()) {
                    for (NPC character : charactersPresent) {
                        ++yIncrease;
                        charactersPresentDescription.append((String)(Main.game.getCharactersPresent(this.cell).contains(character) ? character.getName() : "[style.colourDisabled(" + character.getName() + ")]") + ": " + (character.isRaceConcealed() ? "[style.colourDisabled(\u672a\u77e5\u79cd\u65cf\uff01)]" : UtilText.parse((GameCharacter)character, "[npc.FullRace(true)]", new ParserTag[0])) + "<br/>");
                    }
                }
                if (teleport) {
                    if (this.cell.getType().getTeleportPermissions().isIncoming() && this.cell.getPlace().getPlaceType().getTeleportPermissions().isIncoming()) {
                        teleportingDescription.append("[style.colourGood(\u53ef\u4ee5)][style.colourArcane(\u4f20\u9001)]\u8fdb\u8be5\u5730\u5757\uff01");
                    } else {
                        teleportingDescription.append("[style.colourBad(\u65e0\u6cd5)][style.colourArcane(\u4f20\u9001)]\u8fdb\u8be5\u5730\u5757\uff01");
                    }
                    if (this.cell.getType().getTeleportPermissions().isOutgoing() && this.cell.getPlace().getPlaceType().getTeleportPermissions().isOutgoing()) {
                        teleportingDescription.append("<br/>[style.colourGood(\u53ef\u4ee5)][style.colourArcane(\u4f20\u9001)]\u51fa\u8be5\u5730\u5757\uff01");
                    } else {
                        teleportingDescription.append("<br/>[style.colourBad(\u65e0\u6cd5)][style.colourArcane(\u4f20\u9001)]\u51fa\u8be5\u5730\u5757\uff01");
                    }
                }
            }
            Main.mainController.setTooltipSize(360, 175 + (yIncrease > 0 ? 32 : 0) + (teleport ? 56 : 0) + yIncrease * 16);
            String tooltipDesc = this.cell.getPlace().getPlaceType().getTooltipDescription();
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title'>" + Util.capitaliseSentence(this.cell.getPlaceName()) + "</div><div class='description'>" + (String)(tooltipDesc == null || tooltipDesc.isEmpty() ? "" : tooltipDesc + "<br/>") + (this.cell.getPlace().getPlaceType().isDangerous() ? "\u8fd9\u662f[style.italicsBad(\u5371\u9669)]\u533a\u57df\uff01" : "\u8fd9\u662f[style.italicsGood(\u5b89\u5168)]\u533a\u57df") + "</div>" + (String)(yIncrease > 0 ? "<div class='description' style='height:" + (24 + yIncrease * 16) + "px;'>" + charactersPresentDescription.toString() + "</div>" : "") + (String)(teleport ? "<div class='description' style='height:48px; text-align:center;'>" + teleportingDescription.toString() + "</div>" : ""), new ParserTag[0]));
        } else if (this.moneyTransferPercentage > 0) {
            String percentageTransfer;
            if (InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.FULL_MANAGEMENT && this.owner != null ? this.owner.getMoney() > 0L : Main.game.getPlayerCell().getInventory().getMoney() > 0L) {
                Main.mainController.setTooltipSize(360, 112);
            } else {
                Main.mainController.setTooltipSize(360, 96);
            }
            tooltipSB.setLength(0);
            if (this.moneyTransferPercentage == 1) {
                tooltipSB.append("<div class='title'>[style.colourMinorGood(\u8f6c\u79fb\u5c11\u91cf\u706b\u5e01)]</div>");
                percentageTransfer = "[style.colourMinorGood(" + this.moneyTransferPercentage + "%)]";
            } else if (this.moneyTransferPercentage == 10) {
                tooltipSB.append("<div class='title'>[style.colourGood(\u8f6c\u79fb\u706b\u5e01)]</div>");
                percentageTransfer = "[style.colourGood(" + this.moneyTransferPercentage + "%)]";
            } else {
                tooltipSB.append("<div class='title'>[style.colourExcellent(\u8f6c\u79fb\u5168\u90e8\u706b\u5e01)]</div>");
                percentageTransfer = "[style.colourExcellent(" + this.moneyTransferPercentage + "%)]";
            }
            if (InventoryDialogue.getNPCInventoryInteraction() != InventoryInteraction.FULL_MANAGEMENT) {
                tooltipSB.append("<div class='subtitle'>[style.italicsBad(\u6b64\u5904\u65e0\u6cd5\u8fdb\u884c\u706b\u5e01\u8f6c\u79fb\uff01)]</div>");
            } else if (this.owner == null) {
                long transferAmount = (long)Math.max(1.0f, (float)Main.game.getPlayerCell().getInventory().getMoney() * ((float)this.moneyTransferPercentage / 100.0f));
                tooltipSB.append("<div class='subtitle'>" + (String)(Main.game.getPlayerCell().getInventory().getMoney() == 0L ? "[style.italicsBad(\u8fd9\u4e2a\u533a\u57df\u6ca1\u6709\u706b\u5e01\u2026\u2026)]" : UtilText.parse(this.moneyTransferTarget, "\u6361\u8d77" + percentageTransfer + "\u8be5\u533a\u57df\u7684\u706b\u5e01\uff1a<br/> ", new ParserTag[0]) + UtilText.formatAsMoney(transferAmount, "i")) + "</div>");
            } else if (this.owner.isPlayer()) {
                long transferAmount = (long)Math.max(1.0f, (float)this.owner.getMoney() * ((float)this.moneyTransferPercentage / 100.0f));
                tooltipSB.append("<div class='subtitle'>" + (String)(this.owner.getMoney() == 0L ? "[style.italicsBad(\u4f60\u6ca1\u6709\u706b\u5e01\uff0c\u6240\u4ee5\u65e0\u6cd5\u8f6c\u79fb\u2026\u2026)]" : (String)(this.moneyTransferTarget == null ? (Main.game.getPlayerCell().getPlace().isItemsDisappear() ? "[style.colourBad(\u653e\u5f03)]" + percentageTransfer + "\u4f60\u5728\u8be5\u533a\u57df\u7684\u706b\u5e01\uff1a<br/> " : "[style.colourGood(\u5b89\u5168\u5b58\u50a8)] " + percentageTransfer + "\u4f60\u5728\u8be5\u533a\u57df\u7684\u706b\u5e01\uff1a<br/> ") : UtilText.parse(this.moneyTransferTarget, "\u628a\u4f60\u7684\u706b\u5e01\u8f6c\u79fb\u7ed9" + percentageTransfer + "[npc.name]:<br/> ", new ParserTag[0])) + UtilText.formatAsMoney(transferAmount, "i")) + "</div>");
            } else {
                long transferAmount = (long)Math.max(1.0f, (float)this.owner.getMoney() * ((float)this.moneyTransferPercentage / 100.0f));
                tooltipSB.append("<div class='subtitle'>" + UtilText.parse(this.owner, (String)(this.owner.getMoney() == 0L ? "[style.italicsBad([npc.Name]\u6ca1\u6709\u706b\u5e01\u2026\u2026)]" : "\u62ff\u8d70" + percentageTransfer + "[npc.namePos]\u7684\u706b\u5e01\uff1a<br/> " + UtilText.formatAsMoney(transferAmount, "i")), new ParserTag[0]) + "</div>");
            }
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.loadedBody != null) {
            boolean feral = this.loadedBody.isFeral();
            boolean crotchBreasts = this.loadedBody.hasBreastsCrotch();
            boolean spinneret = this.loadedBody.hasSpinneret();
            int crotchBreastAddition = crotchBreasts ? 24 : 0;
            int spinneretAddition = spinneret ? 24 : 0;
            int[] dimensions = new int[]{419, 522 + crotchBreastAddition + spinneretAddition};
            Main.mainController.setTooltipSize(dimensions[0], dimensions[1]);
            BodyShape bodyShape = this.loadedBody.getBodyShape();
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='title' style='color:" + this.loadedBody.getRace().getColour().toWebHexString() + ";'>" + (String)(this.loadedBody.getRaceStage().getName() != "" ? "<b style='color:" + this.loadedBody.getRaceStage().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.loadedBody.getRaceStage().getName()) + "</b>" : "") + "<b style='color:" + this.loadedBody.getSubspecies().getColour(null).toWebHexString() + ";'>" + (this.loadedBody.isFeminine() ? this.loadedBody.getSubspecies().getSingularFemaleName(this.loadedBody) : this.loadedBody.getSubspecies().getSingularMaleName(this.loadedBody)) + "</b><div class='subTitle' style='font-weight:normal; margin:0; padding:0; background:#00000000; width:100%;'><span style='color:" + Femininity.valueOf(this.loadedBody.getFemininity()).getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(Femininity.valueOf(this.loadedBody.getFemininity()).getName(false)) + "</span> | <span style='color:" + bodyShape.toWebHexStringColour() + ";'>" + Util.capitaliseSentence(bodyShape.getName(false)) + "\u7684\u8eab\u4f53</span> | " + (feral && !this.loadedBody.getSubspecies().getFeralAttributes(this.loadedBody).isSizeHeight() ? "[unit.sizeShort(" + this.loadedBody.getHeightValue() + ")]\u957f" : "[unit.sizeShort(" + this.loadedBody.getHeightValue() + ")]\u9ad8") + "</div></div>");
            AbstractBodyCoveringType covType = this.loadedBody.getFace().getBodyCoveringType(this.loadedBody);
            if (this.loadedBody.getCovering(covType, true).getPattern() == CoveringPattern.FRECKLED_FACE) {
                Covering c = this.loadedBody.getCovering(covType, true);
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9762\u90e8", this.loadedBody.getFace(), null, new Covering(covType, CoveringPattern.FRECKLED, c.getModifier(), c.getPrimaryColour(), c.isPrimaryGlowing(), c.getSecondaryColour(), c.isSecondaryGlowing())));
            } else {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9762\u90e8", this.loadedBody.getFace()));
            }
            tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u8eaf\u5e72", this.loadedBody.getTorso()));
            if (feral && !this.loadedBody.getSubspecies().getFeralAttributes(this.loadedBody).isArmsOrWingsPresent() && this.loadedBody.getLegConfiguration() != LegConfiguration.AVIAN) {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u624b\u81c2", "\u65e0"));
            } else {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getArm().getArmRows() * 2)) + "\u6761\u624b\u81c2", this.loadedBody.getArm()));
            }
            switch (this.loadedBody.getLegConfiguration()) {
                case ARACHNID: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getLeg().getLegConfiguration().getNumberOfLegs())) + "\u6761\u6b65\u8db3", this.loadedBody.getLeg()));
                    break;
                }
                case BIPEDAL: 
                case QUADRUPEDAL: 
                case WINGED_BIPED: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getLeg().getLegConfiguration().getNumberOfLegs())) + "\u6761" + this.loadedBody.getLeg().getFootStructure().getName() + "\u817f", this.loadedBody.getLeg()));
                    break;
                }
                case CEPHALOPOD: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getLeg().getLegConfiguration().getNumberOfLegs())) + "\u6761\u8155\u8db3", this.loadedBody.getLeg()));
                    break;
                }
                case TAIL: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9c7c\u5c3e", this.loadedBody.getLeg()));
                    break;
                }
                case TAIL_LONG: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u86c7\u5c3e(\u957f\u5ea6\uff1a" + Units.size(this.loadedBody.getLeg().getLength(this.loadedBody)) + ")", this.loadedBody.getLeg()));
                    break;
                }
                case AVIAN: {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getLeg().getLegConfiguration().getNumberOfLegs())) + "\u6761\u9e1f\u817f", this.loadedBody.getLeg()));
                }
            }
            if (this.loadedBody.getHair().getRawLengthValue() == 0 && this.loadedBody.getFace().isBaldnessNatural()) {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u6bdb\u53d1", "\u65e0"));
            } else {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(this.loadedBody.getHair().getStyle().getName(this.loadedBody) + this.loadedBody.getHair().getLength().getDescriptor()) + this.loadedBody.getHair().getName(this.owner), this.loadedBody.getHair()));
            }
            tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getEye().getEyePairs() * 2)) + "\u53ea\u773c\u775b", this.loadedBody.getEye()));
            tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u8033\u6735", this.loadedBody.getEar()));
            tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u820c\u5934", this.loadedBody.getFace().getTongue()));
            if (this.loadedBody.getHornType() != HornType.NONE) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getHorn().getTotalHorns())) + "\u6839" + this.loadedBody.getHorn().getName(this.owner), this.loadedBody.getHorn()));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u89d2", "\u65e0"));
            }
            if (this.loadedBody.getAntenna().getType() != AntennaType.NONE) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getAntenna().getTotalAntennae())) + "\u6839\u89e6\u987b", this.loadedBody.getAntenna()));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u89e6\u987b", "\u65e0"));
            }
            if (this.loadedBody.getWingType() != WingType.NONE) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(this.loadedBody.getWing().getSize().getName()) + "\u7684\u7fc5\u8180", this.loadedBody.getWing()));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u7fc5\u8180", "\u65e0"));
            }
            if (this.loadedBody.getTailType() != TailType.NONE) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, Util.capitaliseSentence(Util.intToString(this.loadedBody.getTail().getTailCount())) + "\u6761" + this.loadedBody.getTail().getType().getGirthDescriptor(this.loadedBody) + "\u7684\u5c3e\u5df4", this.loadedBody.getTail()));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u5c3e\u5df4", "\u65e0"));
            }
            if (this.loadedBody.getVaginaType() != VaginaType.NONE) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9634\u9053", this.loadedBody.getVagina(), this.loadedBody.getVagina().getClitoris().getClitorisSize().isPseudoPenisSize() ? "[unit.sizeShort(" + this.loadedBody.getVagina().getClitoris().getRawClitorisSizeValue() + ")]\u7684\u9634\u8482" : null));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u9053", "\u65e0"));
            }
            if (this.loadedBody.hasPenisIgnoreDildo()) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9634\u830e", this.loadedBody.getPenis(), "[unit.sizeShort(" + this.loadedBody.getPenis().getRawLengthValue() + ")]\u957f\uff0c[unit.sizeShort(" + this.loadedBody.getPenis().getDiameter() + ")]\u76f4\u5f84"));
            } else if (this.loadedBody.hasPenis()) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u9634\u830e", this.loadedBody.getPenis(), "[unit.sizeShort(" + this.loadedBody.getPenis().getRawLengthValue() + ")]\u957f\uff0c[unit.sizeShort(" + this.loadedBody.getPenis().getDiameter() + ")]\u76f4\u5f84"));
            } else {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u9634\u830e", "\u65e0"));
            }
            tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u809b\u95e8", this.loadedBody.getAss().getAnus()));
            if (feral && !this.loadedBody.getSubspecies().getFeralAttributes(this.loadedBody).isBreastsPresent()) {
                tooltipSB.append(this.getEmptyBodyPartDiv("\u4e73\u5934(\u80f8\u90e8)", "\u65e0"));
            } else {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u4e73\u5934", this.loadedBody.getBreast().getNipples(), Util.capitaliseSentence(Util.intToString(this.loadedBody.getBreast().getRows() * 2)) + "\u9897" + (String)(this.loadedBody.getBreast().getRawSizeValue() > 0 ? this.loadedBody.getBreast().getSize().getCupSizeName() + "\u7f69\u676f\u4e73\u623f" : (this.loadedBody.isFeminine() ? "\u5e73\u5766\u7684\u80f8\u90e8" : "\u5e73\u677f\u80f8\u90e8"))));
            }
            if (spinneret) {
                if (this.loadedBody.hasTailSpinneret()) {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u4e1d\u56ca", this.loadedBody.getTail(), "", this.loadedBody.getCovering(BodyCoveringType.SPINNERET, true)));
                } else {
                    tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u4e1d\u56ca", this.loadedBody.getLeg(), "", this.loadedBody.getCovering(BodyCoveringType.SPINNERET, true)));
                }
            }
            if (crotchBreasts) {
                tooltipSB.append(this.getBodyPartDiv(this.loadedBody, "\u4e73\u5934", this.loadedBody.getBreastCrotch().getNipples(), Util.capitaliseSentence(Util.intToString(Math.max(1, this.loadedBody.getBreastCrotch().getRows() * 2))) + "\u9897" + (String)(this.loadedBody.getBreastCrotch().getRawSizeValue() > 0 ? this.loadedBody.getBreastCrotch().getSize().getCupSizeName() + "\u7f69\u676f" : "\u5e73\u5766") + (this.loadedBody.getBreastCrotch().getShape() == BreastShape.UDDERS ? (this.loadedBody.getBreastCrotch().getRows() == 0 ? "\u8179\u4e73" : "\u8179\u4e73") : "\u80ef\u4e73")));
            }
            Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
        } else if (this.description == null || this.description.isEmpty()) {
            Main.mainController.setTooltipSize(360, 64);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title'>" + this.title + "</div>", new ParserTag[0]));
        } else if (this.title == null || this.title.isEmpty()) {
            Main.mainController.setTooltipSize(360, this.descriptionHeightOverride > 0 ? this.descriptionHeightOverride + 64 + 32 : 200);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='description' style='height:" + String.valueOf(this.descriptionHeightOverride > 0 ? Integer.valueOf(this.descriptionHeightOverride + 26) : "176") + "px;'>" + this.description + "</div>", new ParserTag[0]));
        } else {
            Main.mainController.setTooltipSize(360, this.descriptionHeightOverride > 0 ? this.descriptionHeightOverride + 64 + 20 : 175);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title'>" + this.title + "</div><div class='description' " + (String)(this.descriptionHeightOverride > 0 ? "style='min-height:0; height:" + (this.descriptionHeightOverride + 16) + "px;'" : "") + ">" + this.description + "</div>", new ParserTag[0]));
        }
        TooltipUpdateThread.updateToolTip(-1.0, -1.0);
    }

    private String getBodyPartDiv(GameCharacter character, String name, AbstractRace race, AbstractBodyCoveringType covering, boolean feral) {
        return this.getBodyPartDiv(character, name, race, covering, feral, null);
    }

    private String getBodyPartDiv(GameCharacter character, String name, AbstractRace race, AbstractBodyCoveringType covering, boolean feral, String size) {
        return this.getBodyPartDiv(character, name, race, this.owner.getCovering(covering), feral, size);
    }

    private String getBodyPartDiv(GameCharacter character, String name, AbstractRace race, Covering covering, boolean feral, String size) {
        Object raceName = race.getName(character.getBody(), feral);
        Colour primaryColour = covering.getPrimaryColour();
        Colour secondaryColour = covering.getSecondaryColour();
        boolean displaySecondary = covering.getPattern().isNaturalSecondColour(character);
        String coveringName = covering.getName(character);
        boolean elementalFeral = false;
        boolean passiveElemental = false;
        if (character.isElemental()) {
            boolean bl = elementalFeral = !((Elemental)character).getSummoner().isElementalActive();
            if (elementalFeral) {
                passiveElemental = true;
                if (((Elemental)character).getPassiveForm() == null) {
                    coveringName = "\u5965\u672f\u80fd\u91cf";
                    raceName = ((Elemental)character).getCurrentSchool().getName() + "\u7cbe\u7075";
                    elementalFeral = false;
                } else {
                    raceName = ((Elemental)character).getPassiveForm().getFeralName(character.getBody());
                }
            }
        }
        return "<div class='subTitle' style='font-weight:normal; text-align:" + (passiveElemental ? "center" : "left") + "; margin-top:2px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;'><div style='width:10px; height:16px; padding:0; margin:0;'><div class='colour-box' style='width:8px; height:" + (displaySecondary ? "8px; margin:0;" : "8px; margin:4px 0 0 0;") + " border-radius:2px; padding:0;" + (primaryColour.isMetallic() ? "background: repeating-linear-gradient(135deg, " + primaryColour.toWebHexString() + ", " + primaryColour.getShades()[4] + " 1px);" : (primaryColour.getRainbowColours() != null ? "background: " + primaryColour.getRainbowDiv(1) + ";" : "background:" + primaryColour.getCoveringIconColour() + ";")) + "'></div>" + (String)(displaySecondary ? "<div class='colour-box' style='width:8px; height:8px; margin:0; padding:0; border-radius:2px;" + (secondaryColour.isMetallic() ? "background: repeating-linear-gradient(135deg, " + secondaryColour.toWebHexString() + ", " + secondaryColour.getShades()[4] + " 1px);" : (secondaryColour.getRainbowColours() != null ? "background: " + secondaryColour.getRainbowDiv(1) + ";" : "background:" + secondaryColour.getCoveringIconColour() + ";")) + "'></div>" : "") + "</div>" + name + (String)(size != null && !size.isEmpty() ? " (" + size + "): " : ": ") + (elementalFeral || feral && race != Race.NONE ? "[style.colourFeral(\u517d\u6001)]" : "") + (covering.getType() != BodyCoveringType.DILDO ? "<span style='color:" + race.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence((String)raceName) : "<span style='color:" + PresetColour.BASE_PINK_DEEP.toWebHexString() + ";'>\u5047\u9633\u5177") + "</span>" + (passiveElemental ? "<br/>" : " - ") + covering.getColourDescriptor(character, true, true) + coveringName + "</div>";
    }

    private String getBodyPartDiv(Body body, String name, BodyPartInterface bodyPart) {
        return this.getBodyPartDiv(body, name, bodyPart, null, null);
    }

    private String getBodyPartDiv(Body body, String name, BodyPartInterface bodyPart, String size) {
        return this.getBodyPartDiv(body, name, bodyPart, size, null);
    }

    private String getBodyPartDiv(Body body, String name, BodyPartInterface bodyPart, String size, Covering coveringOverride) {
        boolean feral = bodyPart.isFeral(this.owner);
        AbstractRace race = bodyPart.getType().getRace();
        String raceName = race.getName(body, feral);
        Covering covering = coveringOverride != null ? coveringOverride : body.getCovering(bodyPart.getBodyCoveringType(body), true);
        Colour primaryColour = covering.getPrimaryColour();
        Colour secondaryColour = covering.getSecondaryColour();
        boolean displaySecondary = covering.getPattern().isNaturalSecondColour(this.owner);
        String coveringName = covering.getName(this.owner);
        return "<div class='subTitle' style='font-weight:normal; text-align:left; margin-top:2px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;'><div style='width:10px; height:16px; padding:0; margin:0;'><div class='colour-box' style='width:8px; height:" + (displaySecondary ? "8px; margin:0;" : "8px; margin:4px 0 0 0;") + " border-radius:2px; padding:0;" + (primaryColour.isMetallic() ? "background: repeating-linear-gradient(135deg, " + primaryColour.toWebHexString() + ", " + primaryColour.getShades()[4] + " 1px);" : (primaryColour.getRainbowColours() != null ? "background: " + primaryColour.getRainbowDiv(1) + ";" : "background:" + primaryColour.getCoveringIconColour() + ";")) + "'></div>" + (String)(displaySecondary ? "<div class='colour-box' style='width:8px; height:8px; margin:0; padding:0; border-radius:2px;" + (secondaryColour.isMetallic() ? "background: repeating-linear-gradient(135deg, " + secondaryColour.toWebHexString() + ", " + secondaryColour.getShades()[4] + " 1px);" : (secondaryColour.getRainbowColours() != null ? "background: " + secondaryColour.getRainbowDiv(1) + ";" : "background:" + secondaryColour.getCoveringIconColour() + ";")) + "'></div>" : "") + "</div>" + name + (String)(size != null && !size.isEmpty() ? " (" + size + "): " : ": ") + (feral && race != Race.NONE ? "[style.colourFeral(\u517d\u6001)]" : "") + (covering.getType() != BodyCoveringType.DILDO ? "<span style='color:" + race.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(raceName) : "<span style='color:" + PresetColour.BASE_PINK_DEEP.toWebHexString() + ";'>\u5047\u9633\u5177") + "</span> - " + covering.getColourDescriptor(this.owner, true, true) + coveringName + "</div>";
    }

    private String getEmptyBodyPartDiv(String name, String description) {
        return this.getEmptyBodyPartDiv(name, description, null);
    }

    private String getEmptyBodyPartDiv(String name, String description, String size) {
        return "<div class='subTitle' style='font-weight:normal; text-align:left; margin-top:2px; white-space: nowrap;'>[style.colourDisabled(" + name + (String)(size != null ? " (" + size + ")" : "") + ": " + description + ")]</div>";
    }

    private String getAttributeDiv(GameCharacter owner, AbstractAttribute attribute) {
        float value = owner.getAttributeValue(attribute);
        Object valueForDisplay = (float)((int)value) == value ? String.valueOf((int)value) : String.valueOf(value);
        if (attribute.isInfiniteAtUpperLimit() && value >= (float)attribute.getUpperLimit()) {
            valueForDisplay = UtilText.getInfinitySymbol(true);
        }
        if (attribute.isPercentage()) {
            valueForDisplay = (value >= 0.0f ? "+" : "") + (String)valueForDisplay + "%";
        }
        attributeTableLeft = !attributeTableLeft;
        return "<div class='subTitle-half' style='padding:2px; margin:2px " + (!attributeTableLeft ? "1" : "2") + "% 2px " + (!attributeTableLeft ? "2" : "1") + "%; width:47%;'><span style='color:" + attribute.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(attribute.getName()) + "</span><br/>" + (value > (float)attribute.getBaseValue() ? "<span style='color:" + (value == (float)attribute.getUpperLimit() ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_MINOR_GOOD).toWebHexString() + ";'>" : (value < (float)attribute.getBaseValue() ? "<span style='color:" + (value == (float)attribute.getLowerLimit() ? PresetColour.GENERIC_BAD : PresetColour.GENERIC_MINOR_BAD).toWebHexString() + ";'>" : "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>")) + (String)valueForDisplay + "</span></div>";
    }

    private String getAttributeTableRowDiv(GameCharacter owner, String type, AbstractAttribute damage, AbstractAttribute resist) {
        float damageValue = owner.getAttributeValue(damage);
        float resistValue = owner.getAttributeValue(resist);
        Object damageValueForDisplay = (float)((int)damageValue) == damageValue ? String.valueOf((int)damageValue) : String.valueOf(damageValue);
        if (damage.isInfiniteAtUpperLimit() && damageValue >= (float)damage.getUpperLimit()) {
            damageValueForDisplay = UtilText.getInfinitySymbol(true);
        }
        if (damage.isPercentage()) {
            damageValueForDisplay = (damageValue >= 0.0f ? "+" : "") + (String)damageValueForDisplay + "%";
        }
        Object resistValueForDisplay = (float)((int)resistValue) == resistValue ? String.valueOf((int)resistValue) : String.valueOf(resistValue);
        if (resist.isInfiniteAtUpperLimit() && resistValue >= (float)resist.getUpperLimit()) {
            resistValueForDisplay = UtilText.getInfinitySymbol(true);
        }
        if (resist.isPercentage()) {
            resistValueForDisplay = (resistValue >= 0.0f ? "+" : "") + (String)resistValueForDisplay + "%";
        }
        return "<div class='subTitle-third combatValue' style='padding:2px; margin:2px 0 2px 2%; width:31.5%;'><span style='color:" + damage.getColour().toWebHexString() + ";'>" + type + "</span></div><div class='subTitle-third combatValue' style='padding:2px; margin:2px 0.75%; width:31.5%;'>" + (damageValue > (float)damage.getBaseValue() ? "<span style='color:" + (damageValue == (float)damage.getUpperLimit() ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_MINOR_GOOD).toWebHexString() + ";'>" : (damageValue < (float)damage.getBaseValue() ? "<span style='color:" + (damageValue == (float)damage.getLowerLimit() ? PresetColour.GENERIC_BAD : PresetColour.GENERIC_MINOR_BAD).toWebHexString() + ";'>" : "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>")) + (String)damageValueForDisplay + "</span></div><div class='subTitle-third combatValue' style='padding:2px; margin:2px 2% 2px 0; width:31.5%;'>" + (String)(resist == null ? "0.0" : (resistValue > 0.0f ? "<span style='color:" + (resistValue == (float)resist.getUpperLimit() ? PresetColour.GENERIC_GOOD : PresetColour.GENERIC_MINOR_GOOD).toWebHexString() + ";'>" : (resistValue < 0.0f ? "<span style='color:" + (resistValue == (float)resist.getLowerLimit() ? PresetColour.GENERIC_BAD : PresetColour.GENERIC_MINOR_BAD).toWebHexString() + ";'>" : "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>")) + (String)resistValueForDisplay + "</span>") + "</div>";
    }

    public TooltipInformationEventListener setInformation(String title, String description) {
        this.resetFields();
        this.title = title;
        this.description = description;
        return this;
    }

    public TooltipInformationEventListener setInformation(String title, String description, int descriptionHeightOverride) {
        this.setInformation(title, description);
        this.descriptionHeightOverride = descriptionHeightOverride;
        return this;
    }

    public TooltipInformationEventListener setWeather() {
        this.resetFields();
        this.weather = true;
        return this;
    }

    public TooltipInformationEventListener setExtraAttributes(GameCharacter owner) {
        this.resetFields();
        this.extraAttributes = true;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setStatusEffect(AbstractStatusEffect statusEffect, GameCharacter owner) {
        this.resetFields();
        this.statusEffect = statusEffect;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setPerk(AbstractPerk perk, GameCharacter owner) {
        this.resetFields();
        this.perk = perk;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setFetish(AbstractFetish fetish, GameCharacter owner, boolean withCostInformation) {
        this.resetFields();
        this.fetish = fetish;
        this.fetishWithCostInformation = withCostInformation;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setFetishExperience(AbstractFetish fetish, GameCharacter owner) {
        this.resetFields();
        this.fetishExperience = true;
        this.fetish = fetish;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setFetishDesire(AbstractFetish fetish, FetishDesire desire, GameCharacter owner) {
        this.resetFields();
        this.desire = desire;
        this.fetish = fetish;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setLevelUpPerk(int perkRow, AbstractPerk levelUpPerk, GameCharacter owner, boolean availableForSelection) {
        this.resetFields();
        this.levelUpPerk = levelUpPerk;
        this.perkRow = perkRow;
        this.owner = owner;
        this.availableForSelection = availableForSelection;
        return this;
    }

    public TooltipInformationEventListener setSpell(Spell spell, GameCharacter owner) {
        this.resetFields();
        this.spell = spell;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setSpellUpgrade(SpellUpgrade spellUpgrade, GameCharacter owner) {
        this.resetFields();
        this.spellUpgrade = spellUpgrade;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setAttribute(AbstractAttribute attribute, GameCharacter owner) {
        this.resetFields();
        this.attribute = attribute;
        this.owner = owner;
        return this;
    }

    public TooltipInformationEventListener setProtection(GameCharacter owner) {
        this.resetFields();
        this.owner = owner;
        this.protection = true;
        return this;
    }

    public TooltipInformationEventListener setCopyInformation() {
        this.resetFields();
        this.copyInformation = true;
        return this;
    }

    public TooltipInformationEventListener setConcealedSlot(InventorySlot concealedSlot) {
        this.resetFields();
        this.concealedSlot = concealedSlot;
        return this;
    }

    public TooltipInformationEventListener setLoadedEnchantment(LoadedEnchantment loadedEnchantment) {
        this.resetFields();
        this.loadedEnchantment = loadedEnchantment;
        return this;
    }

    public TooltipInformationEventListener setCombatMove(AbstractCombatMove move, GameCharacter owner) {
        this.resetFields();
        this.owner = owner;
        this.move = move;
        return this;
    }

    public TooltipInformationEventListener setCell(Cell cell) {
        this.resetFields();
        this.cell = cell;
        return this;
    }

    public TooltipInformationEventListener setMoneyTransferTarget(GameCharacter from, GameCharacter to, int moneyTransferPercentage) {
        this.resetFields();
        this.owner = from;
        this.moneyTransferTarget = to;
        this.moneyTransferPercentage = moneyTransferPercentage;
        return this;
    }

    public TooltipInformationEventListener setSlaveJob(SlaveJob slaveJob, GameCharacter owner) {
        this.resetFields();
        this.owner = owner;
        this.slaveJob = slaveJob;
        return this;
    }

    public TooltipInformationEventListener setLoadedBody(Body loadedBody, GameCharacter owner) {
        this.resetFields();
        this.owner = owner;
        this.loadedBody = loadedBody;
        return this;
    }

    private void resetFields() {
        this.extraAttributes = false;
        this.weather = false;
        this.owner = null;
        this.statusEffect = null;
        this.perk = null;
        this.fetish = null;
        this.fetishWithCostInformation = false;
        this.fetishExperience = false;
        this.desire = null;
        this.levelUpPerk = null;
        this.availableForSelection = false;
        this.perkRow = 0;
        this.spell = null;
        this.spellUpgrade = null;
        this.attribute = null;
        this.protection = false;
        this.copyInformation = false;
        this.concealedSlot = null;
        this.loadedEnchantment = null;
        this.move = null;
        this.descriptionHeightOverride = 0;
        this.cell = null;
        this.moneyTransferTarget = null;
        this.moneyTransferPercentage = 0;
        this.slaveJob = null;
        this.loadedBody = null;
    }
}

