/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller.eventListeners.tooltips;

import com.lilithsthrone.controller.TooltipUpdateThread;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.PenisType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.VaginaType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.game.character.markings.Scar;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.character.markings.TattooCountType;
import com.lilithsthrone.game.character.markings.TattooCounter;
import com.lilithsthrone.game.character.markings.TattooCounterType;
import com.lilithsthrone.game.character.markings.TattooWriting;
import com.lilithsthrone.game.character.markings.TattooWritingStyle;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDressingRoomDialogue;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ShopTransaction;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.BodyPartClothingBlock;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.utils.SizedStack;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class TooltipInventoryEventListener
implements EventListener {
    private GameCharacter owner;
    private GameCharacter equippedToCharacter;
    private AbstractCoreItem coreItem;
    private InventorySlot invSlot;
    private AbstractItem item;
    private AbstractItemType genericItem;
    private AbstractWeapon weapon;
    private AbstractWeaponType genericWeapon;
    private DamageType dt;
    private AbstractWeapon dyeWeapon;
    private DamageType damageType;
    private AbstractClothing clothing;
    private AbstractClothingType genericClothing;
    private AbstractClothing dyeClothing;
    private Tattoo tattoo;
    private AbstractTattooType genericTattoo;
    private int colourIndex;
    private Colour patternColour;
    private Colour colour;
    private TFModifier enchantmentModifier;
    private TFPotency potency;
    private static StringBuilder tooltipSB = new StringBuilder();
    private static final int LINE_HEIGHT = 17;
    private static final int TOOLTIP_WIDTH = 400;

    @Override
    public void handleEvent(Event event) {
        if (this.item != null || this.coreItem instanceof AbstractItem) {
            if (this.coreItem != null) {
                this.item = (AbstractItem)this.coreItem;
            }
            this.itemTooltip(this.item);
        } else if (this.weapon != null || this.coreItem instanceof AbstractWeapon) {
            if (this.coreItem != null) {
                this.weapon = (AbstractWeapon)this.coreItem;
            }
            this.weaponTooltip(this.weapon);
        } else if (this.clothing != null || this.coreItem instanceof AbstractClothing) {
            if (this.coreItem != null) {
                this.clothing = (AbstractClothing)this.coreItem;
            }
            this.clothingTooltip(this.clothing);
        } else if (this.tattoo != null) {
            this.tattooTooltip(this.tattoo);
        } else if (this.dyeClothing != null) {
            Main.mainController.setTooltipSize(400, 480);
            Colour subtitleColour = this.dyeClothing.isEnchantmentKnown() ? this.dyeClothing.getRarity().getColour() : PresetColour.RARITY_UNKNOWN;
            InventorySlot slotEquippedTo = this.dyeClothing.getSlotEquippedTo();
            if (slotEquippedTo == null) {
                slotEquippedTo = this.dyeClothing.getClothingType().getEquipSlots().get(0);
            }
            boolean isInventoryDialogue = Main.game.getCurrentDialogueNode() != LilayaDressingRoomDialogue.OUTFIT_EDITOR_ITEM_DYE;
            tooltipSB.setLength(0);
            if (this.colour != null) {
                ArrayList<Colour> dyeColours = new ArrayList<Colour>(isInventoryDialogue ? InventoryDialogue.dyePreviews : LilayaDressingRoomDialogue.getClothingSelected().getColours());
                dyeColours.remove(this.colourIndex);
                dyeColours.add(this.colourIndex, this.colour);
                tooltipSB.append("<div class='title' style='color:" + subtitleColour.toWebHexString() + ";'>" + Util.capitaliseSentence(this.dyeClothing.getName()) + "</div><div class='subTitle'>" + Util.capitaliseSentence(this.colour.getName()) + " (" + (this.dyeClothing.getClothingType().getColourReplacement(this.colourIndex).getDefaultColours().contains(this.colour) ? "\u6807\u51c6\u989c\u8272" : "\u975e\u6807\u51c6\u989c\u8272") + ")</div><div class='picture full' style='position:relative; margin:8px; padding:0; width:calc(400px - 24px); height:calc(400px - 24px);'>" + this.dyeClothing.getClothingType().getSVGImage(slotEquippedTo, dyeColours, isInventoryDialogue ? InventoryDialogue.dyePreviewPattern : LilayaDressingRoomDialogue.getClothingSelected().getPattern(), isInventoryDialogue ? InventoryDialogue.dyePreviewPatternColours : LilayaDressingRoomDialogue.getClothingSelected().getPatternColours(), isInventoryDialogue ? InventoryDialogue.getDyePreviewStickersAsStrings() : LilayaDressingRoomDialogue.getClothingSelected().getStickers()) + "</div>");
            } else if (this.patternColour != null) {
                ArrayList<Colour> dyeColours = new ArrayList<Colour>(isInventoryDialogue ? InventoryDialogue.dyePreviewPatternColours : LilayaDressingRoomDialogue.getClothingSelected().getPatternColours());
                dyeColours.remove(this.colourIndex);
                dyeColours.add(this.colourIndex, this.patternColour);
                tooltipSB.append("<div class='title' style='color:" + subtitleColour.toWebHexString() + ";'>" + Util.capitaliseSentence(this.dyeClothing.getName()) + "</div><div class='subTitle'>" + Util.capitaliseSentence(Pattern.getPattern(isInventoryDialogue ? InventoryDialogue.dyePreviewPattern : LilayaDressingRoomDialogue.getClothingSelected().getPattern()).getNiceName()) + "</div><div class='picture full' style='position:relative; margin:8px; padding:0; width:calc(400px - 24px); height:calc(400px - 24px);'>" + this.dyeClothing.getClothingType().getSVGImage(slotEquippedTo, isInventoryDialogue ? InventoryDialogue.dyePreviews : LilayaDressingRoomDialogue.getClothingSelected().getColours(), isInventoryDialogue ? InventoryDialogue.dyePreviewPattern : LilayaDressingRoomDialogue.getClothingSelected().getPattern(), dyeColours, isInventoryDialogue ? InventoryDialogue.getDyePreviewStickersAsStrings() : LilayaDressingRoomDialogue.getClothingSelected().getStickers()) + "</div>");
            }
            Main.mainController.setTooltipContent(UtilText.parse((AbstractCoreItem)this.dyeClothing, tooltipSB.toString(), new ParserTag[0]));
        } else if (this.dyeWeapon != null) {
            boolean isInventoryDialogue;
            Main.mainController.setTooltipSize(400, 480);
            tooltipSB.setLength(0);
            tooltipSB.append("<div class='title' style='color:" + this.dyeWeapon.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.dyeWeapon.getName()) + "</div>");
            boolean bl = isInventoryDialogue = Main.game.getCurrentDialogueNode() != LilayaDressingRoomDialogue.OUTFIT_EDITOR_ITEM_DYE;
            if (this.colour != null) {
                ArrayList<Colour> dyeColours = new ArrayList<Colour>(isInventoryDialogue ? InventoryDialogue.dyePreviews : LilayaDressingRoomDialogue.getWeaponSelected().getColours());
                dyeColours.remove(this.colourIndex);
                dyeColours.add(this.colourIndex, this.colour);
                tooltipSB.append("<div class='subTitle'>" + Util.capitaliseSentence(this.colour.getName()) + " (" + (this.dyeWeapon.getWeaponType().getColourReplacement(true, this.colourIndex).getDefaultColours().contains(this.colour) ? "\u6807\u51c6\u989c\u8272" : "\u975e\u6807\u51c6\u989c\u8272") + ")</div><div class='picture full' style='position:relative; margin:8px; padding:0; width:calc(400px - 24px); height:calc(400px - 24px);'>" + this.dyeWeapon.getWeaponType().getSVGImage(this.dyeWeapon.getDamageType(), dyeColours) + "</div>");
            } else if (this.damageType != null) {
                tooltipSB.append("<div class='subTitle'>" + Util.capitaliseSentence(this.damageType.getName()) + "</div><div class='picture full' style='position:relative; margin:8px; padding:0; width:calc(400px - 24px); height:calc(400px - 24px);'>" + this.dyeWeapon.getWeaponType().getSVGImage(this.damageType, isInventoryDialogue ? InventoryDialogue.dyePreviews : LilayaDressingRoomDialogue.getWeaponSelected().getColours()) + "</div>");
            }
            Main.mainController.setTooltipContent(UtilText.parse((AbstractCoreItem)this.dyeWeapon, tooltipSB.toString(), new ParserTag[0]));
        } else if (this.genericItem != null) {
            this.itemTooltip(Main.game.getItemGen().generateItem(this.genericItem));
        } else if (this.genericClothing != null) {
            if (this.colour != null) {
                this.clothingTooltip(Main.game.getItemGen().generateClothing(this.genericClothing, this.colour, false));
            } else {
                this.clothingTooltip(Main.game.getItemGen().generateClothing(this.genericClothing, false));
            }
        } else if (this.genericTattoo != null) {
            this.tattooTooltip(new Tattoo(this.genericTattoo, false, new TattooWriting("The quick brown fox jumps over the lazy dog.", this.genericTattoo.getAvailablePrimaryColours().get(0), false, new TattooWritingStyle[0]), new TattooCounter(TattooCounterType.UNIQUE_SEX_PARTNERS, TattooCountType.NUMBERS, this.genericTattoo.getAvailablePrimaryColours().get(0), false, 0)));
        } else if (this.genericWeapon != null) {
            this.weaponTooltip(Main.game.getItemGen().generateWeapon(this.genericWeapon, this.dt));
        } else if (this.invSlot != null) {
            if (this.invSlot == InventorySlot.WEAPON_MAIN_1) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getMainWeapon(0) == null) {
                        this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_MAIN_1, "Primary Weapon");
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getMainWeapon(0));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u4e3b\u624b\u6b66\u5668</div>");
                }
            } else if (this.invSlot == InventorySlot.WEAPON_MAIN_2) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getMainWeapon(1) == null) {
                        if (this.equippedToCharacter.getArmRows() < 2) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u7b2c\u4e8c\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u4e3b\u624b\u6b66\u5668\u4e86\uff01", "[npc.Name]\u6ca1\u6709\u7b2c\u4e8c\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u4e3b\u624b\u6b66\u5668\u4e86\uff01"));
                        } else {
                            this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_MAIN_2, "Primary Weapon (2nd)");
                        }
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getMainWeapon(1));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u4e3b\u624b\u6b66\u5668(\u4e8c)</div>");
                }
            } else if (this.invSlot == InventorySlot.WEAPON_MAIN_3) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getMainWeapon(2) == null) {
                        if (this.equippedToCharacter.getArmRows() < 3) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u7b2c\u4e09\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u4e3b\u624b\u6b66\u5668\u4e86\uff01", "[npc.Name]\u6ca1\u6709\u7b2c\u4e09\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u4e3b\u624b\u6b66\u5668\u4e86\uff01"));
                        } else {
                            this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_MAIN_3, "Primary Weapon (3rd)");
                        }
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getMainWeapon(2));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u4e3b\u624b\u6b66\u5668(\u4e09)</div>");
                }
            } else if (this.invSlot == InventorySlot.WEAPON_OFFHAND_1) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getOffhandWeapon(0) == null) {
                        AbstractWeapon primary = this.equippedToCharacter.getMainWeapon(0);
                        if (primary != null && primary.getWeaponType().isTwoHanded()) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, primary.getWeaponType().isPlural() ? "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002", primary.getWeaponType().isPlural() ? "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002"));
                        } else {
                            this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_OFFHAND_1, "Secondary Weapon");
                        }
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getOffhandWeapon(0));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u526f\u624b\u6b66\u5668</div>");
                }
            } else if (this.invSlot == InventorySlot.WEAPON_OFFHAND_2) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getOffhandWeapon(1) == null) {
                        AbstractWeapon primary = this.equippedToCharacter.getMainWeapon(1);
                        if (primary != null && primary.getWeaponType().isTwoHanded()) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, primary.getWeaponType().isPlural() ? "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002", primary.getWeaponType().isPlural() ? "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002"));
                        } else if (this.equippedToCharacter.getArmRows() < 2) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u7b2c\u4e8c\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u526f\u624b\u6b66\u5668\u4e86\uff01", "[npc.Name]\u6ca1\u6709\u7b2c\u4e8c\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u526f\u624b\u6b66\u5668\u4e86\uff01"));
                        } else {
                            this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_OFFHAND_2, "Secondary Weapon (2nd)");
                        }
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getOffhandWeapon(1));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u526f\u624b\u6b66\u5668(\u4e8c)</div>");
                }
            } else if (this.invSlot == InventorySlot.WEAPON_OFFHAND_3) {
                if (this.equippedToCharacter != null) {
                    if (this.equippedToCharacter.getOffhandWeapon(2) == null) {
                        AbstractWeapon primary = this.equippedToCharacter.getMainWeapon(2);
                        if (primary != null && primary.getWeaponType().isTwoHanded()) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, primary.getWeaponType().isPlural() ? "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e\u4f60\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u4f60\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002", primary.getWeaponType().isPlural() ? "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002" : "\u7531\u4e8e[npc.namePos]\u7684" + primary.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c[npc.sheIsFull]\u65e0\u6cd5\u518d\u5728\u526f\u624b\u88c5\u5907\u4e00\u4ef6\u6b66\u5668\u3002"));
                        } else if (this.equippedToCharacter.getArmRows() < 3) {
                            this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u7b2c\u4e09\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u526f\u624b\u6b66\u5668\u4e86\uff01", "[npc.Name]\u6ca1\u6709\u7b2c\u4e09\u5bf9\u624b\u81c2\u6765\u63e1\u6301\u53e6\u4e00\u4ef6\u526f\u624b\u6b66\u5668\u4e86\uff01"));
                        } else {
                            this.setUnarmedWeaponSlotTooltip(InventorySlot.WEAPON_OFFHAND_3, "Secondary Weapon (3rd)");
                        }
                    } else {
                        this.weaponTooltip(this.equippedToCharacter.getOffhandWeapon(2));
                    }
                } else {
                    Main.mainController.setTooltipSize(400, 60);
                    Main.mainController.setTooltipContent("<div class='title'>\u526f\u624b\u6b66\u5668(\u4e09)</div>");
                }
            } else if (this.equippedToCharacter != null) {
                boolean renderingTattoos = false;
                if (this.equippedToCharacter.isPlayer() && RenderingEngine.ENGINE.isRenderingTattoosLeft() || !this.equippedToCharacter.isPlayer() && RenderingEngine.ENGINE.isRenderingTattoosRight() && !this.invSlot.isJewellery()) {
                    renderingTattoos = true;
                }
                if (!renderingTattoos && this.equippedToCharacter.getClothingInSlot(this.invSlot) == null || renderingTattoos && this.equippedToCharacter.getTattooInSlot(this.invSlot) == null) {
                    ArrayList<String> clothingBlockingThisSlot = new ArrayList<String>();
                    for (AbstractClothing c : this.equippedToCharacter.getClothingCurrentlyEquipped()) {
                        if (!c.getIncompatibleSlots(this.equippedToCharacter, c.getSlotEquippedTo()).contains((Object)this.invSlot)) continue;
                        clothingBlockingThisSlot.add(c.getName());
                    }
                    BodyPartClothingBlock block = this.invSlot.getBodyPartClothingBlock(this.equippedToCharacter);
                    if (!renderingTattoos && !clothingBlockingThisSlot.isEmpty()) {
                        this.setBlockedTooltipContent(UtilText.parse(this.equippedToCharacter, "\u8be5\u680f\u4f4d\u88ab[npc.namePos]<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u9501\u4f4f\u4e86</b>", new ParserTag[0]) + Util.stringsToStringList(clothingBlockingThisSlot, false) + "\u3002");
                    } else if (!renderingTattoos && block != null) {
                        this.setBlockedTooltipContent("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u88ab\u963b\u6321\uff01</span>", UtilText.parse(this.equippedToCharacter, block.getDescription(), new ParserTag[0]));
                    } else {
                        boolean piercingBlocked = false;
                        boolean bypassesPiercing = !this.equippedToCharacter.getBody().getBodyMaterial().isRequiresPiercing();
                        switch (this.invSlot) {
                            case PIERCING_VAGINA: {
                                if (this.equippedToCharacter.getVaginaType() == VaginaType.NONE) {
                                    this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u9634\u9053\u3002", this.equippedToCharacter.isAreaKnownByCharacter(CoverableArea.VAGINA, Main.game.getPlayer()) ? "[npc.Name]\u6ca1\u6709\u9634\u9053\u3002" : "\u4f60\u4e0d\u6e05\u695a[npc.name]\u6709\u6ca1\u6709\u9634\u9053\u3002"));
                                    piercingBlocked = true;
                                    break;
                                }
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedVagina()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u9634\u6237\u5c1a\u672a\u7a7f\u5b54\u3002", this.equippedToCharacter.isAreaKnownByCharacter(CoverableArea.VAGINA, Main.game.getPlayer()) ? "[npc.NamePos]\u7684\u9634\u6237\u5c1a\u672a\u7a7f\u5b54\u3002" : "\u4f60\u4e0d\u6e05\u695a[npc.name]\u6709\u6ca1\u6709\u9634\u9053\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_EAR: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedEar()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u8033\u6735\u5c1a\u672a\u7a7f\u5b54\u3002", "[npc.NamePos]\u7684\u8033\u6735\u5c1a\u672a\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_LIP: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedLip()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u5634\u5507\u5c1a\u672a\u7a7f\u5b54\u3002", "[npc.NamePos]\u7684\u5634\u5507\u5c1a\u672a\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_NIPPLE: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedNipple()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u4e73\u5934\u5c1a\u672a\u7a7f\u5b54\u3002", this.equippedToCharacter.isAreaKnownByCharacter(CoverableArea.NIPPLES, Main.game.getPlayer()) ? "[npc.NamePos]\u7684\u4e73\u5934\u5c1a\u672a\u7a7f\u5b54\u3002" : "\u4f60\u4e0d\u6e05\u695a[npc.namePos]\u7684\u4e73\u5934\u662f\u5426\u5df2\u7ecf\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_NOSE: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedNose()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u9f3b\u5b50\u5c1a\u672a\u7a7f\u5b54\u3002", "[npc.NamePos]\u7684\u9f3b\u5b50\u5c1a\u672a\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_PENIS: {
                                if (this.equippedToCharacter.getPenisType() == PenisType.NONE) {
                                    this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u9634\u830e\u3002", this.equippedToCharacter.isAreaKnownByCharacter(CoverableArea.PENIS, Main.game.getPlayer()) ? "[npc.Name]\u6ca1\u6709\u9634\u830e\u3002" : "\u4f60\u4e0d\u6e05\u695a[npc.name]\u6709\u6ca1\u6709\u9634\u830e\u3002"));
                                    piercingBlocked = true;
                                    break;
                                }
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedPenis()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u9634\u830e\u5c1a\u672a\u7a7f\u5b54\u3002", this.equippedToCharacter.isAreaKnownByCharacter(CoverableArea.PENIS, Main.game.getPlayer()) ? "[npc.NamePos]\u7684\u9634\u830e\u5c1a\u672a\u7a7f\u5b54\u3002" : "\u4f60\u4e0d\u6e05\u695a[npc.name]\u6709\u6ca1\u6709\u9634\u830e\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_STOMACH: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedNavel()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u809a\u8110\u5c1a\u672a\u7a7f\u5b54\u3002", "[npc.NamePos]\u7684\u809a\u8110\u5c1a\u672a\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PIERCING_TONGUE: {
                                if (bypassesPiercing || this.equippedToCharacter.isPiercedTongue()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u7684\u820c\u5934\u5c1a\u672a\u7a7f\u5b54\u3002", "[npc.NamePos]\u7684\u820c\u5934\u5c1a\u672a\u7a7f\u5b54\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case HORNS: {
                                if (!this.equippedToCharacter.getHornType().equals(HornType.NONE)) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u89d2\u3002", "[npc.Name]\u6ca1\u6709\u89d2\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case PENIS: {
                                if (this.equippedToCharacter.hasPenisIgnoreDildo()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u9634\u830e\u3002", "[npc.Name]\u6ca1\u6709\u9634\u830e\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case TAIL: {
                                if (this.equippedToCharacter.getTailType() != TailType.NONE) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u5c3e\u5df4\u3002", "[npc.Name]\u6ca1\u6709\u5c3e\u5df4\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case VAGINA: {
                                if (this.equippedToCharacter.hasVagina()) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u9634\u9053\u3002", "[npc.Name]\u6ca1\u6709\u9634\u9053\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                            case WINGS: {
                                if (this.equippedToCharacter.getWingType() != WingType.NONE) break;
                                this.setBlockedTooltipContent(this.getTooltipText(this.equippedToCharacter, "\u4f60\u6ca1\u6709\u7fc5\u8180\u3002", "[npc.Name]\u6ca1\u6709\u7fc5\u8180\u3002"));
                                piercingBlocked = true;
                                break;
                            }
                        }
                        if (!piercingBlocked) {
                            if (renderingTattoos) {
                                this.scarTooltip(this.equippedToCharacter.getScarInSlot(this.invSlot));
                            } else {
                                this.setEmptyInventorySlotTooltipContent();
                            }
                        }
                    }
                } else if (renderingTattoos && !this.invSlot.isJewellery()) {
                    this.tattooTooltip(this.equippedToCharacter.getTattooInSlot(this.invSlot));
                } else {
                    this.clothingTooltip(this.equippedToCharacter.getClothingInSlot(this.invSlot));
                }
            } else {
                this.setEmptyInventorySlotTooltipContent();
            }
        } else if (this.enchantmentModifier != null) {
            Main.mainController.setTooltipSize(400, 152);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title' style='color:" + this.enchantmentModifier.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.enchantmentModifier.getName()) + "</div><div class='description' style='min-height:48px; max-height:48px;'>" + UtilText.parse(this.enchantmentModifier.getDescription(), new ParserTag[0]) + "</div><div class='subTitle'>" + (EnchantmentDialogue.getIngredient() instanceof Tattoo ? UtilText.formatAsMoney(this.enchantmentModifier.getValue() * 500, "b") + "\u5360\u7528" : UtilText.formatAsEssences(this.enchantmentModifier.getValue(), "b", false) + "\u7cbe\u534e\u6d88\u8017") + "</div>", new ParserTag[0]));
        } else if (this.potency != null) {
            Main.mainController.setTooltipSize(400, 60);
            Main.mainController.setTooltipContent(UtilText.parse("<div class='title'>\u5c06\u6548\u80fd\u8bbe\u7f6e\u4e3a<b style='color:" + this.potency.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.potency.getName()) + "</b></div>", new ParserTag[0]));
        } else {
            return;
        }
        TooltipUpdateThread.updateToolTip(-1.0, -1.0);
    }

    private void setBlockedTooltipContent(String description) {
        this.setBlockedTooltipContent("<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>Blocked!</span>", description);
    }

    private void setBlockedTooltipContent(String title, String description) {
        this.setEmptyInventorySlotTooltipContent(title, description);
    }

    private void setEmptyInventorySlotTooltipContent() {
        this.setEmptyInventorySlotTooltipContent("", "");
    }

    private void setEmptyInventorySlotTooltipContent(String title, String description) {
        int cummedMapSize;
        if (this.equippedToCharacter == null) {
            Main.mainController.setTooltipSize(400, 60);
            Main.mainController.setTooltipContent("<div class='title'>" + Util.capitaliseSentence(this.invSlot.getName()) + (String)(title != null && !title.isEmpty() ? ": " + title : "") + "</div>");
            return;
        }
        boolean dirty = this.equippedToCharacter.isDirtySlot(this.invSlot);
        boolean hasDescription = description != null && !description.isEmpty();
        HashMap<GameCharacter, Integer> cummedOnInfo = new HashMap<GameCharacter, Integer>();
        if (Main.game.isInSex()) {
            for (Map.Entry<GameCharacter, Map<InventorySlot, Integer>> entry : Main.sex.getAmountCummedOnByPartners(this.equippedToCharacter).entrySet()) {
                for (Map.Entry<InventorySlot, Integer> areas : entry.getValue().entrySet()) {
                    if (areas.getKey() != this.invSlot) continue;
                    cummedOnInfo.put(entry.getKey(), areas.getValue());
                }
            }
        }
        int descHeight = 17 * (cummedMapSize + ((cummedMapSize = cummedOnInfo.size()) > 0 ? 1 : 0) + (dirty ? (Main.game.isInSex() && cummedMapSize == 0 ? 2 : 1) : 0) + (hasDescription ? 2 : 0));
        if (descHeight > 0) {
            descHeight += 16;
        }
        Main.mainController.setTooltipSize(400, 60 + (dirty || !cummedOnInfo.isEmpty() || hasDescription ? 8 : 0) + descHeight);
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='title'>" + Util.capitaliseSentence(this.invSlot.getName()) + (String)(title != null && !title.isEmpty() ? ": " + title : "") + "</div>");
        if (dirty || !cummedOnInfo.isEmpty() || hasDescription) {
            sb.append("<div class='description' style='min-height:0; height:" + descHeight + "px; text-align:center;'>");
            if (hasDescription) {
                sb.append(description);
                if (dirty) {
                    sb.append("<br/>");
                }
            }
            if (dirty) {
                sb.append("[npc.NamePos]\u7684" + this.invSlot.getName() + "\u88ab[style.colourDirty(\u5f04\u810f\u4e86)]\uff01");
                if (Main.game.isInSex()) {
                    sb.append("<br/>");
                }
                if (!cummedOnInfo.isEmpty()) {
                    sb.append("[style.boldDirty(\u73b0\u5b58\u6027\u6db2\u4f53\uff1a)]");
                    for (Map.Entry entry : cummedOnInfo.entrySet()) {
                        sb.append("<br/>");
                        sb.append(UtilText.parse((GameCharacter)entry.getKey(), "[style.fluid(" + String.valueOf(entry.getValue()) + ")]<span style='color:" + ((GameCharacter)entry.getKey()).getFemininity().getColour().toWebHexString() + ";'>[npc.namePos]</span>[npc.cum+]\uff01", new ParserTag[0]));
                    }
                } else if (Main.game.isInSex()) {
                    sb.append("[style.italicsDisabled(\u65e0\u6db2\u4f53\u53ef\u7528\u2026\u2026)]");
                }
            }
            sb.append("</div>");
        }
        Main.mainController.setTooltipContent(UtilText.parse(this.equippedToCharacter, sb.toString(), new ParserTag[0]));
    }

    public TooltipInventoryEventListener setCoreItem(AbstractCoreItem coreItem, GameCharacter owner, GameCharacter equippedToCharacter) {
        this.resetVariables();
        this.coreItem = coreItem;
        this.equippedToCharacter = equippedToCharacter;
        this.owner = owner;
        return this;
    }

    public TooltipInventoryEventListener setItem(AbstractItem item, GameCharacter owner, GameCharacter equippedToCharacter) {
        this.resetVariables();
        this.item = item;
        this.equippedToCharacter = equippedToCharacter;
        this.owner = owner;
        return this;
    }

    public TooltipInventoryEventListener setTattoo(InventorySlot invSlot, Tattoo tattoo, GameCharacter owner, GameCharacter equippedToCharacter) {
        this.resetVariables();
        this.invSlot = invSlot;
        this.tattoo = tattoo;
        this.equippedToCharacter = equippedToCharacter;
        this.owner = owner;
        return this;
    }

    public TooltipInventoryEventListener setGenericItem(AbstractItemType genericItem) {
        this.resetVariables();
        this.genericItem = genericItem;
        return this;
    }

    public TooltipInventoryEventListener setClothing(AbstractClothing clothing, GameCharacter owner, GameCharacter equippedToCharacter) {
        this.resetVariables();
        this.clothing = clothing;
        this.equippedToCharacter = equippedToCharacter;
        this.owner = owner;
        return this;
    }

    public TooltipInventoryEventListener setDyeClothing(AbstractClothing dyeClothing, int colourIndex, Colour colour) {
        this.resetVariables();
        this.dyeClothing = dyeClothing;
        this.colourIndex = colourIndex;
        this.colour = colour;
        return this;
    }

    public TooltipInventoryEventListener setDyeClothingPattern(AbstractClothing dyeClothing, int colourIndex, Colour patternColour) {
        this.resetVariables();
        this.dyeClothing = dyeClothing;
        this.colourIndex = colourIndex;
        this.patternColour = patternColour;
        return this;
    }

    public TooltipInventoryEventListener setDyeWeapon(AbstractWeapon dyeWeapon, int colourIndex, Colour colour) {
        this.resetVariables();
        this.dyeWeapon = dyeWeapon;
        this.colourIndex = colourIndex;
        this.colour = colour;
        return this;
    }

    public TooltipInventoryEventListener setDamageTypeWeapon(AbstractWeapon dyeWeapon, DamageType damageType) {
        this.resetVariables();
        this.dyeWeapon = dyeWeapon;
        this.damageType = damageType;
        return this;
    }

    public TooltipInventoryEventListener setGenericClothing(AbstractClothingType genericClothing) {
        this.resetVariables();
        this.genericClothing = genericClothing;
        return this;
    }

    public TooltipInventoryEventListener setGenericClothing(AbstractClothingType genericClothing, Colour colour) {
        this.resetVariables();
        this.genericClothing = genericClothing;
        this.colour = colour;
        return this;
    }

    public TooltipInventoryEventListener setGenericTattoo(AbstractTattooType genericTattoo) {
        this.resetVariables();
        this.genericTattoo = genericTattoo;
        this.invSlot = genericTattoo.getSlotAvailability().contains((Object)InventorySlot.TORSO_UNDER) ? InventorySlot.TORSO_UNDER : genericTattoo.getSlotAvailability().get(0);
        return this;
    }

    public TooltipInventoryEventListener setGenericWeapon(AbstractWeaponType genericWeapon, DamageType dt) {
        this.resetVariables();
        this.genericWeapon = genericWeapon;
        this.dt = dt;
        return this;
    }

    public TooltipInventoryEventListener setWeapon(AbstractWeapon weapon, GameCharacter owner, boolean isEquipped) {
        this.resetVariables();
        this.weapon = weapon;
        if (isEquipped) {
            this.equippedToCharacter = owner;
        }
        this.owner = owner;
        return this;
    }

    public TooltipInventoryEventListener setInventorySlot(InventorySlot invSlot, GameCharacter equippedToCharacter) {
        this.resetVariables();
        this.invSlot = invSlot;
        this.equippedToCharacter = equippedToCharacter;
        this.owner = equippedToCharacter;
        return this;
    }

    public TooltipInventoryEventListener setTFModifier(TFModifier enchantmentModifier) {
        this.resetVariables();
        this.enchantmentModifier = enchantmentModifier;
        return this;
    }

    public TooltipInventoryEventListener setTFPotency(TFPotency potency) {
        this.resetVariables();
        this.potency = potency;
        return this;
    }

    private void resetVariables() {
        this.owner = null;
        this.equippedToCharacter = null;
        this.coreItem = null;
        this.item = null;
        this.tattoo = null;
        this.genericItem = null;
        this.weapon = null;
        this.genericWeapon = null;
        this.dt = null;
        this.clothing = null;
        this.patternColour = null;
        this.colour = null;
        this.colourIndex = 0;
        this.dyeClothing = null;
        this.dyeWeapon = null;
        this.damageType = null;
        this.genericClothing = null;
        this.genericTattoo = null;
        this.invSlot = null;
        this.enchantmentModifier = null;
        this.potency = null;
    }

    private void itemTooltip(AbstractItem absItem) {
        String author;
        List<String> extraDescriptions;
        int specialYIncrease = 0;
        int yIncrease = 0;
        tooltipSB.setLength(0);
        tooltipSB.append("<body>");
        tooltipSB.append("<div class='container-full-width center'><h5>" + Util.capitaliseSentence(absItem.getDisplayName(true)) + "</h5></div>");
        tooltipSB.append("<div class='container-full-width titular' style='margin-bottom:2px;'>" + (absItem.isConsumedOnUse() ? "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u4f7f\u7528\u540e\u6d88\u8017</span>" : "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u53ef\u65e0\u9650\u4f7f\u7528</span>") + "</div>");
        String valueDivClass = Main.game.isEnchantmentCapacityEnabled() ? "container-half-width titular" : "container-full-width titular";
        String valueStyle = "style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'";
        if (InventoryDialogue.getInventoryNPC() != null && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.TRADING) {
            if (this.owner.isPlayer()) {
                if (InventoryDialogue.getInventoryNPC().willBuy(absItem)) {
                    int buyModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getBuyModifier() * 100.0f);
                    Colour buyColour = buyModifierPercentage <= 50 ? PresetColour.GENERIC_BAD : (buyModifierPercentage < 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u552e\u4ef7\uff1a" + UtilText.formatAsMoney(absItem.getPrice(InventoryDialogue.getInventoryNPC().getBuyModifier())) + " (<span style='color:" + buyColour.toWebHexString() + ";'>" + buyModifierPercentage + "%</span>)</div>");
                } else {
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + UtilText.formatAsMoney(absItem.getValue()) + "</div>");
                }
            } else if (InventoryDialogue.isBuyback()) {
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u56de\u8d2d\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(this.getBuybackPriceFor(absItem)) + "</div>");
            } else {
                int sellModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getSellModifier(absItem) * 100.0f);
                Colour sellColour = sellModifierPercentage >= 200 ? PresetColour.GENERIC_BAD : (sellModifierPercentage > 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u4e70\u4ef7\uff1a" + UtilText.formatAsMoney(absItem.getPrice(InventoryDialogue.getInventoryNPC().getSellModifier(absItem))) + " (<span style='color:" + sellColour.toWebHexString() + ";'>" + sellModifierPercentage + "%</span>)</div>");
            }
        } else {
            tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + UtilText.formatAsMoney(absItem.getValue()) + "</div>");
        }
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'><span style='color:" + absItem.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(absItem.getRarity().getName()) + "</span></div>");
        tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
        tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
        tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + absItem.getSVGString() + "</div></div>");
        tooltipSB.append(absItem.getTypeDescription(this.owner));
        tooltipSB.append("</div>");
        tooltipSB.append("</div>");
        StringBuilder effectsSB = new StringBuilder();
        if (absItem.isAppendItemEffectLinesToTooltip()) {
            Object effectEntry = "";
            int effectMulti = 0;
            for (int it = 0; it < absItem.getEffects().size(); ++it) {
                ItemEffect ie = absItem.getEffects().get(it);
                StringBuilder effectSB = new StringBuilder();
                for (int i = 0; i < ie.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer()).size(); ++i) {
                    ++yIncrease;
                    if (effectSB.length() > 0) {
                        effectSB.append("<br/>");
                    }
                    effectSB.append(ie.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer()).get(i));
                }
                effectEntry = effectSB.toString();
                if (it == absItem.getEffects().size() - 1 || !absItem.getEffects().get(it + 1).equals(ie)) {
                    if (effectsSB.length() > 0) {
                        effectsSB.append("<br/>");
                    }
                    if (effectMulti > 0) {
                        effectsSB.append("[style.colourArcane(x" + (effectMulti + 1) + ")] ");
                        yIncrease -= effectMulti;
                    }
                    effectsSB.append((String)effectEntry);
                    effectMulti = 0;
                    continue;
                }
                ++effectMulti;
            }
        }
        for (String s : absItem.getEffectTooltipLines()) {
            ++yIncrease;
            if (effectsSB.length() > 0) {
                effectsSB.append("<br/>");
            }
            effectsSB.append(s);
        }
        if (effectsSB.length() > 0) {
            specialYIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append(effectsSB.toString());
            tooltipSB.append("</div>");
        }
        if (!(extraDescriptions = absItem.getExtraDescriptions(this.equippedToCharacter)).isEmpty()) {
            specialYIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight: normal;'>");
            for (int i = 0; i < extraDescriptions.size(); ++i) {
                ++yIncrease;
                if (i > 0) {
                    tooltipSB.append("<br/>");
                }
                tooltipSB.append(extraDescriptions.get(i));
                ++i;
            }
            tooltipSB.append("</div>");
        }
        if (!(author = absItem.getItemType().getAuthorDescription()).isEmpty()) {
            int authorDivHeight = 48;
            specialYIncrease += 56;
            tooltipSB.append("<div class='description' style='margin:4px 8px; min-height:" + authorDivHeight + "px; max-height:" + authorDivHeight + "px;'>" + author + "</div>");
        }
        tooltipSB.append("</body>");
        String fullNameWithHtmlTags = absItem.getDisplayName(true);
        if (fullNameWithHtmlTags.replaceAll("<[^>]*>", "").length() > 45) {
            specialYIncrease += 26;
        }
        Main.mainController.setTooltipSize(480, 272 + yIncrease * 18 + specialYIncrease);
        Main.mainController.setTooltipContent(UtilText.parse(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter, (AbstractCoreItem)absItem, tooltipSB.toString(), new ParserTag[0]));
    }

    private void weaponTooltip(AbstractWeapon absWeapon) {
        String author;
        int cost;
        String valueStyle;
        int specialYIncrease = 0;
        int yIncrease = 0;
        tooltipSB.setLength(0);
        tooltipSB.append("<body><div class='container-full-width center'><h5>" + Util.capitaliseSentence(absWeapon.getDisplayName(true)) + "</h5></div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'>" + (absWeapon.getWeaponType().isTwoHanded() ? "\u53cc\u624b" : "\u5355\u624b") + (absWeapon.getWeaponType().isOneShot() ? " [style.colourYellow(\u5355\u53d1)]" : "") + "</div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'><span style='color:" + absWeapon.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(absWeapon.getRarity().getName()) + "</span></div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 2px 8px; width:calc(50% - 10px); color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>" + (absWeapon.getWeaponType().isUsingUnarmedCalculation() ? "[style.colourUnarmed(\u5f92\u624b)]" : (absWeapon.getWeaponType().isMelee() ? "[style.colourMelee(\u8fd1\u6218)]" : "[style.colourRanged(\u8fdc\u7a0b)]")) + " " + Util.capitaliseSentence(absWeapon.getDamageType().getName()) + "\u4f24\u5bb3</div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'>" + (absWeapon.getWeaponType().getClothingSet() == null ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u975e\u914d\u5957\u6b66\u5668</span>" : "<span style='color:" + PresetColour.RARITY_EPIC.toWebHexString() + ";'>" + absWeapon.getWeaponType().getClothingSet().getName() + "\u5957\u88c5</span>") + "</div>");
        String valueDivClass = Main.game.isEnchantmentCapacityEnabled() ? "container-half-width titular" : "container-full-width titular";
        String string = valueStyle = Main.game.isEnchantmentCapacityEnabled() ? "style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'" : "";
        if (InventoryDialogue.getInventoryNPC() != null && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.TRADING) {
            if (this.owner.isPlayer()) {
                if (InventoryDialogue.getInventoryNPC().willBuy(absWeapon)) {
                    int buyModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getBuyModifier() * 100.0f);
                    Colour buyColour = buyModifierPercentage <= 50 ? PresetColour.GENERIC_BAD : (buyModifierPercentage < 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u552e\u4ef7\uff1a" + UtilText.formatAsMoney(absWeapon.getPrice(InventoryDialogue.getInventoryNPC().getBuyModifier())) + " (<span style='color:" + buyColour.toWebHexString() + ";'>" + buyModifierPercentage + "%</span>)</div>");
                } else {
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + UtilText.formatAsMoney(absWeapon.getValue()) + "</div>");
                }
            } else if (InventoryDialogue.isBuyback() && !this.owner.hasWeaponEquipped(absWeapon)) {
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u56de\u8d2d\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(this.getBuybackPriceFor(absWeapon)) + "</div>");
            } else {
                int sellModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getSellModifier(absWeapon) * 100.0f);
                Colour sellColour = sellModifierPercentage >= 200 ? PresetColour.GENERIC_BAD : (sellModifierPercentage > 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u4e70\u4ef7\uff1a" + UtilText.formatAsMoney(absWeapon.getPrice(InventoryDialogue.getInventoryNPC().getSellModifier(absWeapon))) + " (<span style='color:" + sellColour.toWebHexString() + ";'>" + sellModifierPercentage + "%</span>)</div>");
            }
        } else {
            tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + UtilText.formatAsMoney(absWeapon.getValue()) + "</div>");
        }
        if (Main.game.isEnchantmentCapacityEnabled()) {
            int enchCapacityCost = absWeapon.getEnchantmentCapacityCost();
            tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'>" + (String)(enchCapacityCost == 0 ? "[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(enchCapacityCost, "b") + ")]" : UtilText.formatAsEnchantmentCapacity(enchCapacityCost, "b")) + "</div>");
        }
        tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
        tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
        tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + (this.owner != null && this.owner.hasWeaponEquipped(absWeapon) ? absWeapon.getSVGEquippedString(this.owner) : absWeapon.getSVGString()) + "</div></div>");
        tooltipSB.append(absWeapon.getTypeDescription(this.owner));
        tooltipSB.append("</div>");
        tooltipSB.append("</div>");
        if (this.owner != null && this.owner.getEssenceCount() < absWeapon.getWeaponType().getArcaneCost()) {
            yIncrease += 2;
            tooltipSB.append("<div class='container-full-width titular'>[style.colourBad(\u53d1\u5c04\u6240\u9700\u7684\u7cbe\u534e\u4e0d\u8db3\uff01)]</div>");
        }
        StringBuilder effectsSB = new StringBuilder();
        float res = absWeapon.getWeaponType().getPhysicalResistance();
        if (res > 0.0f) {
            ++yIncrease;
            effectsSB.append("[style.colourGood(+" + res + ")]\u81ea\u7136[style.colourResPhysical(" + Util.capitaliseSentence(Attribute.RESISTANCE_PHYSICAL.getName()) + ")]<br/>");
        }
        if ((cost = absWeapon.getWeaponType().getArcaneCost()) > 0) {
            ++yIncrease;
            effectsSB.append((absWeapon.getWeaponType().isMelee() ? "\u6bcf\u6b21\u653b\u51fb" : "\u5c04\u51fb") + "\u6d88\u8017[style.boldArcane(" + cost + "\u5965\u672f\u7cbe\u534e)]<br/>");
        }
        if (this.equippedToCharacter != null) {
            if (absWeapon.getWeaponType().isUsingUnarmedCalculation()) {
                ++yIncrease;
                effectsSB.append("\u5305\u62ec[style.colourUnarmed(" + this.equippedToCharacter.getUnarmedDamage() + "\u5f92\u624b\u4f24\u5bb3)]<br/>");
            }
            ++yIncrease;
            effectsSB.append("<span>" + Attack.getMinimumDamage(this.equippedToCharacter, null, Attack.MAIN, absWeapon) + " - " + Attack.getMaximumDamage(this.equippedToCharacter, null, Attack.MAIN, absWeapon) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
            for (Util.Value<Integer, Integer> value : absWeapon.getWeaponType().getAoeDamage()) {
                ++yIncrease;
                aoeChance = value.getKey();
                effectsSB.append("<br/>[style.colourAqua(\u8303\u56f4\u4f24\u5bb3)]: (<span style='color:" + (aoeChance <= 25 ? PresetColour.GENERIC_BAD : (aoeChance <= 50 ? PresetColour.GENERIC_MINOR_BAD : (aoeChance <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + aoeChance + "%</span>): <span>" + Attack.getMinimumDamage(this.equippedToCharacter, null, Attack.MAIN, absWeapon, value.getValue().intValue()) + " - " + Attack.getMaximumDamage(this.equippedToCharacter, null, Attack.MAIN, absWeapon, value.getValue().intValue()) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
            }
        } else {
            if (this.owner != null && !this.owner.isPlayer()) {
                ++yIncrease;
                effectsSB.append(UtilText.parse(this.owner, "[npc.Name]\uff1a", new ParserTag[0]) + "<span>" + Attack.getMinimumDamage(this.owner, null, Attack.MAIN, absWeapon) + " - " + Attack.getMaximumDamage(this.owner, null, Attack.MAIN, absWeapon) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
                for (Util.Value<Integer, Integer> value : absWeapon.getWeaponType().getAoeDamage()) {
                    ++yIncrease;
                    aoeChance = value.getKey();
                    effectsSB.append("<br/>[style.colourAqua(\u8303\u56f4\u4f24\u5bb3)]: (<span style='color:" + (aoeChance <= 25 ? PresetColour.GENERIC_BAD : (aoeChance <= 50 ? PresetColour.GENERIC_MINOR_BAD : (aoeChance <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + aoeChance + "%</span>): <span>" + Attack.getMinimumDamage(this.owner, null, Attack.MAIN, absWeapon, value.getValue().intValue()) + " - " + Attack.getMaximumDamage(this.owner, null, Attack.MAIN, absWeapon, value.getValue().intValue()) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
                }
                effectsSB.append("<br/>\u4f60\uff1a");
            }
            ++yIncrease;
            effectsSB.append("<span>" + Attack.getMinimumDamage(Main.game.getPlayer(), null, Attack.MAIN, absWeapon) + " - " + Attack.getMaximumDamage(Main.game.getPlayer(), null, Attack.MAIN, absWeapon) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
            for (Util.Value<Integer, Integer> value : absWeapon.getWeaponType().getAoeDamage()) {
                ++yIncrease;
                aoeChance = value.getKey();
                effectsSB.append("<br/>[style.colourAqua(\u8303\u56f4\u4f24\u5bb3)] (<span style='color:" + (aoeChance <= 25 ? PresetColour.GENERIC_BAD : (aoeChance <= 50 ? PresetColour.GENERIC_MINOR_BAD : (aoeChance <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + aoeChance + "%</span>): <span>" + Attack.getMinimumDamage(Main.game.getPlayer(), null, Attack.MAIN, absWeapon, value.getValue().intValue()) + " - " + Attack.getMaximumDamage(Main.game.getPlayer(), null, Attack.MAIN, absWeapon, value.getValue().intValue()) + "</span> <span style='color:" + absWeapon.getDamageType().getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>");
            }
        }
        if (absWeapon.getWeaponType().isOneShot()) {
            ++yIncrease;
            ++yIncrease;
            int chanceToRecoverTurn = (int)absWeapon.getWeaponType().getOneShotChanceToRecoverAfterTurn();
            int n = (int)absWeapon.getWeaponType().getOneShotChanceToRecoverAfterCombat();
            effectsSB.append("<br/><span style='color:" + (chanceToRecoverTurn <= 25 ? PresetColour.GENERIC_BAD : (chanceToRecoverTurn <= 50 ? PresetColour.GENERIC_MINOR_BAD : (chanceToRecoverTurn <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + "'>[style.colourBlueLight(\u4f7f\u7528\u540e)]\u6062\u590d" + chanceToRecoverTurn + "%</span><br/>");
            effectsSB.append("<span style='color:" + (n <= 25 ? PresetColour.GENERIC_BAD : (n <= 50 ? PresetColour.GENERIC_MINOR_BAD : (n <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>[style.colourCombat(\u6218\u6597\u540e)]\u6062\u590d" + n + "%</span>");
        }
        for (String string2 : absWeapon.getWeaponType().getExtraEffects()) {
            ++yIncrease;
            effectsSB.append("<br/><span>" + string2 + "</span>");
        }
        for (Map.Entry entry : absWeapon.getAttributeModifiers().entrySet()) {
            ++yIncrease;
            effectsSB.append("<br/><span>" + ((AbstractAttribute)entry.getKey()).getFormattedValue(((Integer)entry.getValue()).intValue()) + "</span>");
        }
        for (Spell spell : absWeapon.getSpells()) {
            ++yIncrease;
            effectsSB.append("<br/>[style.colourSpell(\u6cd5\u672f)]: <span style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(spell.getName()) + "</span>");
        }
        for (AbstractCombatMove abstractCombatMove : absWeapon.getCombatMoves()) {
            ++yIncrease;
            effectsSB.append("<br/>[style.colourCombat(\u52a8\u4f5c)]: " + Util.capitaliseSentence(abstractCombatMove.getName(0, Main.game.getPlayer())));
        }
        if (effectsSB.length() > 0) {
            specialYIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append(effectsSB.toString());
            tooltipSB.append("</div>");
        }
        StringBuilder extraDescriptionsSB = new StringBuilder();
        List<String> list = absWeapon.getExtraDescriptions(this.equippedToCharacter);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ++yIncrease;
                if (i > 0) {
                    extraDescriptionsSB.append("<br/>");
                }
                extraDescriptionsSB.append(list.get(i));
            }
        }
        if (extraDescriptionsSB.length() > 0) {
            specialYIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append(extraDescriptionsSB.toString());
            tooltipSB.append("</div>");
        }
        if (!(author = absWeapon.getWeaponType().getAuthorDescription()).isEmpty()) {
            int authorDivHeight = 48;
            specialYIncrease += 56;
            tooltipSB.append("<div class='description' style='margin:4px 8px; min-height:" + authorDivHeight + "px; max-height:" + authorDivHeight + "px;'>" + author + "</div>");
        }
        tooltipSB.append("</body>");
        String fullNameWithHtmlTags = absWeapon.getDisplayName(false);
        if (fullNameWithHtmlTags.replaceAll("<[^>]*>", "").length() > 45) {
            specialYIncrease += 26;
        }
        Main.mainController.setTooltipSize(480, 300 + yIncrease * 18 + specialYIncrease);
        Main.mainController.setTooltipContent(UtilText.parse(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter, (AbstractCoreItem)absWeapon, tooltipSB.toString(), new ParserTag[0]));
    }

    private void clothingTooltip(AbstractClothing absClothing) {
        String author;
        String valueStyle;
        float resistance;
        InventorySlot slotEquippedTo = absClothing.getSlotEquippedTo();
        int specialYIncrease = 0;
        int yIncrease = 0;
        if (absClothing.isEnchantmentKnown()) {
            yIncrease += absClothing.getAttributeModifiers().size();
        }
        if ((resistance = absClothing.getClothingType().getPhysicalResistance()) > 0.0f) {
            ++yIncrease;
        }
        if (absClothing.isEnchantmentKnown()) {
            for (ItemEffect ie : absClothing.getEffects()) {
                if (ie.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || ie.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE) continue;
                yIncrease += ie.getEffectsDescription(this.owner, this.equippedToCharacter).size();
            }
        } else {
            ++yIncrease;
        }
        tooltipSB.setLength(0);
        tooltipSB.append("<body>");
        tooltipSB.append("<div class='container-full-width center'>");
        tooltipSB.append("<h5>" + Util.capitaliseSentence(absClothing.getDisplayName(true)) + "</h5>");
        tooltipSB.append("</div>");
        Femininity femininityRestriction = absClothing.getClothingType().getFemininityRestriction();
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'>" + (femininityRestriction == null || femininityRestriction == Femininity.ANDROGYNOUS ? "[style.colourAndrogynous(\u7537\u5973\u901a\u7528)]" : (femininityRestriction.isFeminine() ? "[style.colourFeminine(\u5973\u6027\u5316)]" : "[style.colourMasculine(\u7537\u6027\u5316)]")) + "</div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'><span style='color:" + (absClothing.isEnchantmentKnown() ? absClothing.getRarity().getColour() : PresetColour.TEXT_GREY).toWebHexString() + ";'>" + Util.capitaliseSentence(absClothing.isEnchantmentKnown() ? absClothing.getRarity().getName() : "\u672a\u77e5") + "</span></div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'>");
        boolean nonPiercingSlots = absClothing.getClothingType().getEquipSlots().stream().anyMatch(is -> !is.isJewellery());
        ArrayList<InventorySlot> possibleSlots = new ArrayList<InventorySlot>(absClothing.getClothingType().getEquipSlots());
        if (nonPiercingSlots) {
            possibleSlots.sort((is1, is2) -> slotEquippedTo == is1 ? 1 : (slotEquippedTo == is2 ? -1 : 0));
        }
        for (int i = 0; i < possibleSlots.size(); ++i) {
            boolean equipped;
            InventorySlot slot = (InventorySlot)((Object)possibleSlots.get(i));
            boolean bl = equipped = slotEquippedTo == slot;
            if (nonPiercingSlots) {
                tooltipSB.append((String)(equipped || slotEquippedTo == null ? Util.capitaliseSentence(slot.getName()) : "[style.colourDisabled(" + Util.capitaliseSentence(slot.getName()) + ")]") + (i == possibleSlots.size() - 1 ? "" : (slotEquippedTo != null ? "[style.colourDisabled(/)]" : "/")));
                continue;
            }
            String slotName = slot.getName().replace("\u7a7f\u5b54", "");
            tooltipSB.append((String)(equipped || slotEquippedTo == null ? Util.capitaliseSentence(slotName) : "[style.colourDisabled(" + Util.capitaliseSentence(slotName) + ")]") + (i == possibleSlots.size() - 1 ? "" : (slotEquippedTo != null ? "[style.colourDisabled(/)]" : "/")));
            if (i != possibleSlots.size() - 1) continue;
            tooltipSB.append("\u7a7f\u5b54");
        }
        tooltipSB.append("</div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'>" + (absClothing.getClothingType().getClothingSet() == null ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u975e\u914d\u5957\u670d\u88c5</span>" : "<span style='color:" + PresetColour.RARITY_EPIC.toWebHexString() + ";'>" + absClothing.getClothingType().getClothingSet().getName() + "\u5957\u88c5</span>") + "</div>");
        String valueDivClass = Main.game.isEnchantmentCapacityEnabled() ? "container-half-width titular" : "container-full-width titular";
        String string = valueStyle = Main.game.isEnchantmentCapacityEnabled() ? "style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'" : "";
        if (InventoryDialogue.getInventoryNPC() != null && InventoryDialogue.getNPCInventoryInteraction() == InventoryInteraction.TRADING) {
            if (this.owner.isPlayer()) {
                if (InventoryDialogue.getInventoryNPC().willBuy(absClothing)) {
                    int buyModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getBuyModifier() * 100.0f);
                    Colour buyColour = buyModifierPercentage <= 50 ? PresetColour.GENERIC_BAD : (buyModifierPercentage < 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u552e\u4ef7\uff1a" + UtilText.formatAsMoney(absClothing.getPrice(InventoryDialogue.getInventoryNPC().getBuyModifier())) + " (<span style='color:" + buyColour.toWebHexString() + ";'>" + buyModifierPercentage + "%</span>)</div>");
                } else {
                    tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + (absClothing.isEnchantmentKnown() ? UtilText.formatAsMoney(absClothing.getValue()) : UtilText.formatAsMoney("?", "b")) + "</div>");
                }
            } else if (InventoryDialogue.isBuyback() && !this.owner.getClothingCurrentlyEquipped().contains(absClothing)) {
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u56de\u8d2d\u4ef7\u683c\uff1a" + (absClothing.isEnchantmentKnown() ? UtilText.formatAsMoney(this.getBuybackPriceFor(absClothing)) : UtilText.formatAsMoney("?", "b")) + "</div>");
            } else {
                int sellModifierPercentage = (int)(InventoryDialogue.getInventoryNPC().getSellModifier(absClothing) * 100.0f);
                Colour sellColour = sellModifierPercentage >= 200 ? PresetColour.GENERIC_BAD : (sellModifierPercentage > 100 ? PresetColour.GENERIC_MINOR_BAD : PresetColour.GENERIC_MINOR_GOOD);
                tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">\u4e70\u4ef7\uff1a" + UtilText.formatAsMoney(absClothing.getPrice(InventoryDialogue.getInventoryNPC().getSellModifier(absClothing))) + " (<span style='color:" + sellColour.toWebHexString() + ";'>" + sellModifierPercentage + "%</span>)</div>");
            }
        } else {
            tooltipSB.append("<div class='" + valueDivClass + "' " + valueStyle + ">" + (absClothing.isEnchantmentKnown() ? UtilText.formatAsMoney(absClothing.getValue()) : UtilText.formatAsMoney("?", "b")) + "</div>");
        }
        if (Main.game.isEnchantmentCapacityEnabled()) {
            int enchCapacityCost = absClothing.getEnchantmentCapacityCost();
            tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'>" + (String)(absClothing.isEnchantmentKnown() ? (enchCapacityCost == 0 ? "[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(enchCapacityCost, "b") + ")]" : UtilText.formatAsEnchantmentCapacity(enchCapacityCost, "b")) : "[style.boldDisabled(" + UtilText.getEnchantmentCapacitySymbolUncoloured() + "?)]") + "</div>");
        }
        tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
        tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
        tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + (this.owner != null && this.owner.getClothingCurrentlyEquipped().contains(absClothing) ? absClothing.getSVGEquippedString(this.owner) : absClothing.getSVGString()) + "</div></div>");
        tooltipSB.append(absClothing.getTypeDescription(this.owner));
        tooltipSB.append("</div>");
        tooltipSB.append("</div>");
        StringBuilder effectsSB = new StringBuilder();
        boolean brNeeded = false;
        if (resistance > 0.0f) {
            effectsSB.append("[style.colourGood(+" + resistance + ")]\u81ea\u7136[style.colourResPhysical(" + Util.capitaliseSentence(Attribute.RESISTANCE_PHYSICAL.getName()) + ")]");
            brNeeded = true;
        }
        if (!absClothing.getEffects().isEmpty()) {
            if (!absClothing.isEnchantmentKnown()) {
                effectsSB.append((brNeeded ? "<br/>" : "") + "[style.colourDisabled(\u672a\u8bc6\u522b\u6548\u679c\uff01)]");
                brNeeded = true;
            } else {
                for (Map.Entry<AbstractAttribute, Integer> entry : absClothing.getAttributeModifiers().entrySet()) {
                    effectsSB.append((brNeeded ? "<br/>" : "") + entry.getKey().getFormattedValue(entry.getValue().intValue()));
                    brNeeded = true;
                }
                for (ItemEffect e : absClothing.getEffects()) {
                    if (e.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || e.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE) continue;
                    for (String s : e.getEffectsDescription(this.owner, this.owner)) {
                        effectsSB.append((brNeeded ? "<br/>" : "") + s);
                        brNeeded = true;
                    }
                }
            }
        }
        StringBuilder extraDescriptionsSB = new StringBuilder();
        ArrayList<Object> extraDescriptions = new ArrayList<Object>();
        if (slotEquippedTo == null && absClothing.getClothingType().getEquipSlots().size() > 1) {
            if (!absClothing.getExtraDescriptions(this.equippedToCharacter, null, false).isEmpty()) {
                for (String s : absClothing.getExtraDescriptions(this.equippedToCharacter, null, false)) {
                    extraDescriptions.add(s);
                    ++yIncrease;
                }
            }
            for (int i = 0; i < absClothing.getClothingType().getEquipSlots().size(); ++i) {
                InventorySlot slot = absClothing.getClothingType().getEquipSlots().get(i);
                if (absClothing.getExtraDescriptions(this.equippedToCharacter, slot, false).isEmpty()) continue;
                extraDescriptions.add("<i>\u5f53\u88c5\u5907\u5230\u201c" + slot.getName() + "\u201d\u680f\u4f4d\u65f6\uff1a</i>");
                ++yIncrease;
                for (String s : absClothing.getExtraDescriptions(this.equippedToCharacter, slot, false)) {
                    extraDescriptions.add(s);
                    ++yIncrease;
                }
            }
        } else {
            if (slotEquippedTo != null && !absClothing.getExtraDescriptions(this.equippedToCharacter, null, false).isEmpty()) {
                for (String s : absClothing.getExtraDescriptions(this.equippedToCharacter, null, false)) {
                    extraDescriptions.add(s);
                    ++yIncrease;
                }
            }
            if (!absClothing.getExtraDescriptions(this.equippedToCharacter, slotEquippedTo, false).isEmpty()) {
                for (String s : absClothing.getExtraDescriptions(this.equippedToCharacter, slotEquippedTo, false)) {
                    extraDescriptions.add(s);
                    ++yIncrease;
                }
            }
        }
        if (!extraDescriptions.isEmpty()) {
            for (int i = 0; i < extraDescriptions.size(); ++i) {
                if (i > 0) {
                    extraDescriptionsSB.append("<br/>");
                }
                extraDescriptionsSB.append((String)extraDescriptions.get(i));
            }
        }
        if (effectsSB.length() > 0) {
            specialYIncrease += 16;
            String background = "";
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;" + background + "'>");
            tooltipSB.append(effectsSB.toString());
            tooltipSB.append("</div>");
        }
        if (extraDescriptionsSB.length() > 0) {
            specialYIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append(extraDescriptionsSB.toString());
            tooltipSB.append("</div>");
        }
        if (!(author = absClothing.getClothingType().getAuthorDescription()).isEmpty()) {
            int authorDivHeight = 48;
            specialYIncrease += 56;
            tooltipSB.append("<div class='description' style='margin:4px 8px; min-height:" + authorDivHeight + "px; max-height:" + authorDivHeight + "px;'>" + author + "</div>");
        }
        tooltipSB.append("</body>");
        String fullNameWithHtmlTags = absClothing.getDisplayName(false);
        if (fullNameWithHtmlTags.replaceAll("<[^>]*>", "").length() > 45) {
            specialYIncrease += 26;
        }
        Main.mainController.setTooltipSize(480, 300 + yIncrease * 18 + specialYIncrease);
        Main.mainController.setTooltipContent(UtilText.parse(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter, (AbstractCoreItem)absClothing, tooltipSB.toString(), new ParserTag[0]));
    }

    private void scarTooltip(Scar scar) {
        int yIncrease = 0;
        tooltipSB.setLength(0);
        tooltipSB.append("<body><div class='container-full-width center'><h5>\u65e0\u7eb9\u8eab</h5></div>");
        tooltipSB.append("<div class='container-half-width titular'>" + Util.capitaliseSentence(this.invSlot.getTattooSlotName()) + "</div>");
        tooltipSB.append("<div class='container-half-width titular'>" + (scar == null ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u75a4\u75d5</span>" : "<span style='color:" + PresetColour.SCAR.toWebHexString() + ";'>" + Util.capitaliseSentence(this.owner.getScarInSlot(this.invSlot).getName()) + "</span>") + "</div>");
        SizedStack<Covering> lipsticks = this.owner.getLipstickMarkingsInSlot(this.invSlot);
        if (lipsticks != null) {
            yIncrease = 24 + (1 + lipsticks.size()) * 17;
            tooltipSB.append("<div class='container-full-width' style='text-align:center; padding:8px; height:" + (16 + (1 + lipsticks.size()) * 17) + "px;'>");
            tooltipSB.append(UtilText.parse(this.owner, "[npc.NamePos]", new ParserTag[0]) + this.invSlot.getNameOfAssociatedPart(this.owner) + (this.invSlot.isPlural(this.owner) ? "" : "") + "\u5df2\u88ab\u6807\u8bb0\uff1a");
            for (int i = lipsticks.size() - 1; i >= 0; --i) {
                tooltipSB.append("<br/>" + Util.capitaliseSentence(((Covering)lipsticks.get(i)).getFullDescription(this.owner, true)));
            }
            tooltipSB.append("</div>");
        }
        Main.mainController.setTooltipSize(400, yIncrease + 88);
        Main.mainController.setTooltipContent(UtilText.parse(tooltipSB.toString(), new ParserTag[0]));
    }

    /*
     * WARNING - void declaration
     */
    private void tattooTooltip(Tattoo tattoo) {
        SizedStack<Covering> sizedStack;
        int yIncrease = 0;
        int specialIncrease = 0;
        tooltipSB.setLength(0);
        tooltipSB.append("<body><div class='container-full-width center'><h5>" + Util.capitaliseSentence(tattoo.getDisplayName(true)) + "</h5></div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'>" + (this.owner == null || this.owner.getScarInSlot(this.invSlot) == null ? "<span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u75a4\u75d5</span>" : "<span style='color:" + PresetColour.SCAR.toWebHexString() + ";'>" + Util.capitaliseSentence(this.owner.getScarInSlot(this.invSlot).getName()) + "</span>") + "</div>");
        tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'><span style='color:" + tattoo.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(tattoo.getRarity().getName()) + "</span></div>");
        String slotStyle = Main.game.isEnchantmentCapacityEnabled() ? "style='margin:2px 2px 2px 8px; width:calc(50% - 10px);'" : "";
        tooltipSB.append("<div class='" + (Main.game.isEnchantmentCapacityEnabled() ? "container-half-width titular" : "container-full-width titular") + "' " + slotStyle + ">" + (this.invSlot.getTattooSlotName() == null ? "[style.colourDisabled(\u65e0\u6cd5\u7eb9\u8eab)]" : Util.capitaliseSentence(this.invSlot.getTattooSlotName())) + "</div>");
        if (Main.game.isEnchantmentCapacityEnabled()) {
            int enchCapacityCost = tattoo.getEnchantmentCapacityCost();
            tooltipSB.append("<div class='container-half-width titular' style='margin:2px 8px 2px 2px; width:calc(50% - 10px);'>" + (String)(enchCapacityCost == 0 ? "[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(enchCapacityCost, "b") + ")]" : UtilText.formatAsEnchantmentCapacity(enchCapacityCost, "b")) + "</div>");
        }
        tooltipSB.append("<div class='container-full-width' style='padding:0; min-height:106px;'>");
        tooltipSB.append("<div class='container-half-width' style='width:calc(100% - 16px); font-weight:normal; text-align:left; max-height:140px;'>");
        tooltipSB.append("<div class='item-image' style='float:right;'><div class='item-image-content'>" + tattoo.getSVGImage(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter) + "</div></div>");
        tooltipSB.append(tattoo.getType().getDescription());
        StringBuilder writingSB = new StringBuilder();
        if (tattoo.getWriting() != null && !tattoo.getWriting().getText().isEmpty()) {
            if (tattoo.getWriting().getStyles().isEmpty()) {
                writingSB.append("\u666e\u901a\uff0c");
            } else {
                int i = 0;
                for (TattooWritingStyle tattooWritingStyle : tattoo.getWriting().getStyles()) {
                    writingSB.append((String)(i == 0 ? Util.capitaliseSentence(tattooWritingStyle.getName()) : ", " + tattooWritingStyle.getName()));
                    ++i;
                }
            }
            writingSB.append(tattoo.getWriting().getColour().getName() + "\u7684\u6587\u5b57");
        }
        StringBuilder counterSB = new StringBuilder();
        if (tattoo.getCounter() != null && tattoo.getCounter().getType() != TattooCounterType.NONE) {
            counterSB.append("\u5df2\u9644\u9b54\u7684\uff0c\u201c'" + tattoo.getCounter().getColour().getName() + " " + tattoo.getCounter().getType().getName() + "\u201d\u8ba1\u6570\u6307\u793a");
        }
        if (writingSB.length() > 0) {
            tooltipSB.append("<i>");
            tooltipSB.append(writingSB.toString());
            if (counterSB.length() > 0) {
                tooltipSB.append("\u548c");
                tooltipSB.append(counterSB.toString());
                tooltipSB.append("\u5df2\u88ab\u5e94\u7528\u5230\u7eb9\u8eab\u4e0a\u3002");
            } else {
                tooltipSB.append("\u5df2\u88ab\u5e94\u7528\u5230\u7eb9\u8eab\u4e0a\u3002");
            }
            tooltipSB.append("</i>");
        } else if (counterSB.length() > 0) {
            tooltipSB.append("<i>");
            tooltipSB.append(Util.capitaliseSentence(writingSB.toString()));
            tooltipSB.append("\u5df2\u88ab\u5e94\u7528\u5230\u7eb9\u8eab\u4e0a\u3002");
            tooltipSB.append("</i>");
        }
        tooltipSB.append("</div>");
        tooltipSB.append("</div>");
        StringBuilder effectsSB = new StringBuilder();
        if (!tattoo.getEffects().isEmpty()) {
            for (ItemEffect itemEffect : tattoo.getEffects()) {
                if (itemEffect.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || itemEffect.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE) continue;
                for (String s : itemEffect.getEffectsDescription(this.owner, this.owner)) {
                    ++yIncrease;
                    if (effectsSB.length() > 0) {
                        effectsSB.append("<br/>");
                    }
                    effectsSB.append(s);
                }
            }
            for (Map.Entry<AbstractAttribute, Integer> entry : tattoo.getAttributeModifiers().entrySet()) {
                ++yIncrease;
                if (effectsSB.length() > 0) {
                    effectsSB.append("<br/>");
                }
                effectsSB.append(entry.getKey().getFormattedValue(entry.getValue().intValue()));
            }
        }
        if (effectsSB.length() > 0) {
            specialIncrease += 16;
            tooltipSB.append("<div class='container-full-width titular' style='font-weight:normal;'>");
            tooltipSB.append(effectsSB.toString());
            tooltipSB.append("</div>");
        }
        if (tattoo.getWriting() != null && !tattoo.getWriting().getText().isEmpty()) {
            specialIncrease += 16;
            ++yIncrease;
            ++yIncrease;
            int n = tattoo.getWriting().getText().split("<br/>").length;
            tooltipSB.append("<div class='container-full-width' style='padding:4px; height:" + (28 + n * 17) + "px; text-align:center;'>");
            tooltipSB.append("\u5199\u7740\uff1a<br/>");
            tooltipSB.append(tattoo.getFormattedWritingOutput());
            tooltipSB.append("</div>");
        }
        if (tattoo.getCounter() != null && tattoo.getCounter().getType() != TattooCounterType.NONE) {
            specialIncrease += 16;
            ++yIncrease;
            ++yIncrease;
            tooltipSB.append("<div class='container-full-width' style='padding:4px; height:42px; text-align:center;'>\u201c" + tattoo.getCounter().getType().getName() + "\u201d\u8ba1\u6570\u6307\u793a\u5f53\u524d\u4e3a\uff1a<br/><span style='color:" + tattoo.getCounter().getColour().toWebHexString() + ";'>" + tattoo.getFormattedCounterOutput(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter) + "</span></div>");
        }
        tooltipSB.append("</div>");
        if (this.owner != null && (sizedStack = this.owner.getLipstickMarkingsInSlot(this.invSlot)) != null) {
            void var9_21;
            specialIncrease += 16;
            ++yIncrease;
            tooltipSB.append("<div class='container-full-width' style='text-align:center; padding:8px; height:" + (16 + (1 + sizedStack.size()) * 17) + "px;'>");
            tooltipSB.append(UtilText.parse(this.owner, "[npc.NamePos]", new ParserTag[0]) + this.invSlot.getTattooSlotName() + (this.invSlot.isPlural(this.owner) ? "" : "") + "\u5df2\u88ab\u6807\u8bb0\uff1a");
            int n = sizedStack.size() - 1;
            while (var9_21 >= 0) {
                ++yIncrease;
                tooltipSB.append("<br/>" + Util.capitaliseSentence(((Covering)sizedStack.get((int)var9_21)).getFullDescription(this.owner, true)));
                --var9_21;
            }
            tooltipSB.append("</div>");
        }
        tooltipSB.append("</body>");
        String string = tattoo.getDisplayName(true);
        if (string.replaceAll("<[^>]*>", "").length() > 45) {
            specialIncrease += 26;
        }
        Main.mainController.setTooltipSize(480, 272 + yIncrease * 18 + specialIncrease);
        Main.mainController.setTooltipContent(UtilText.parse(this.equippedToCharacter == null ? Main.game.getPlayer() : this.equippedToCharacter, tooltipSB.toString(), new ParserTag[0]));
    }

    private int getBuybackPriceFor(AbstractCoreItem item) {
        for (ShopTransaction s : Main.game.getPlayer().getBuybackStack()) {
            if (s.getAbstractItemSold() != item) continue;
            return s.getPrice();
        }
        throw new IllegalArgumentException("That's not a buyback item");
    }

    private String getTooltipText(GameCharacter character, String playerText, String NPCText) {
        if (character.isPlayer()) {
            return playerText;
        }
        return UtilText.parse(character, NPCText, new ParserTag[0]);
    }

    private void setUnarmedWeaponSlotTooltip(InventorySlot slot, String title) {
        BodyPartClothingBlock block = slot.getBodyPartClothingBlock(this.equippedToCharacter);
        Main.mainController.setTooltipSize(400, 132 + (block != null ? 128 : 0));
        int baseDamage = this.equippedToCharacter.getBaseUnarmedDamage();
        int modifiedDamage = this.equippedToCharacter.getUnarmedDamage();
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='title'>" + title + "(\u5f92\u624b)</div><div class='description' style='height:64px; text-align:center;'>" + UtilText.parse(this.equippedToCharacter, "[npc.Name]\u80fd\u591f\u9020\u6210" + baseDamage + "\u70b9\u57fa\u7840\u5f92\u624b\u4f24\u5bb3\uff0c\u8be5\u503c\u4f1a\u6839\u636e\u5c5e\u6027\u53d8\u5316\uff0c\u6700\u7ec8\u4e3a\uff1a<br/>[style.boldUnarmed(" + modifiedDamage + "\u5f92\u624b\u4f24\u5bb3)]", new ParserTag[0]) + "</div>");
        if (block != null) {
            sb.append(UtilText.parse(this.equippedToCharacter, "<div class='title'><span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u88ab\u963b\u6321\uff01</span></div><div class='description' style='height:72px; text-align:center;'>" + UtilText.parse(this.equippedToCharacter, block.getDescription(), new ParserTag[0]) + "</div>", new ParserTag[0]));
        }
        Main.mainController.setTooltipContent(sb.toString());
    }
}

