/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.controller.xmlParsing;

import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.main.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Element {
    private final org.w3c.dom.Element innerElement;
    private final String fileDirectory;
    private final Document document;

    private Element(org.w3c.dom.Element w3cElement, String fileDirectory, Document document) {
        this.innerElement = w3cElement;
        this.fileDirectory = fileDirectory;
        this.document = document;
    }

    public static Element getDocumentRootElement(File xmlFile) throws XMLLoadException {
        try {
            String fileDirectory = xmlFile.getAbsolutePath();
            Document parsedDocument = Main.getDocBuilder().parse(xmlFile);
            parsedDocument.getDocumentElement().normalize();
            return new Element(parsedDocument.getDocumentElement(), fileDirectory, parsedDocument);
        }
        catch (Exception e) {
            throw new XMLLoadException(e);
        }
    }

    public static Element getElement(org.w3c.dom.Element w3cElement, String fileDirectory, Document document) throws XMLLoadException {
        try {
            return new Element(w3cElement, "", document);
        }
        catch (Exception e) {
            throw new XMLLoadException(e);
        }
    }

    public String getTagName() {
        return this.innerElement.getTagName();
    }

    public String getAttribute(String name) {
        return this.innerElement.getAttribute(name);
    }

    public String getTextContent() {
        try {
            return this.innerElement.getTextContent();
        }
        catch (DOMException ex) {
            System.err.println(String.format("DOM exception: text content in element \"%s\" probably exceeds max allowed.XML parsing will try to continue with empty text content", this.getTagName()));
            return "";
        }
    }

    @Deprecated
    public org.w3c.dom.Element getInnerElement() {
        return this.innerElement;
    }

    @Deprecated
    public Document getDocument() {
        return this.document;
    }

    public Element getMandatoryFirstOf(String tag) throws XMLMissingTagException {
        org.w3c.dom.Element firstElement = (org.w3c.dom.Element)this.innerElement.getElementsByTagName(tag).item(0);
        if (firstElement == null) {
            throw new XMLMissingTagException(tag, this.fileDirectory);
        }
        return new Element(firstElement, this.fileDirectory, this.document);
    }

    public Optional<Element> getOptionalFirstOf(String tag) {
        org.w3c.dom.Element foundElement = (org.w3c.dom.Element)this.innerElement.getElementsByTagName(tag).item(0);
        if (foundElement == null) {
            return Optional.empty();
        }
        return Optional.of(new Element(foundElement, this.fileDirectory, this.document));
    }

    public List<Element> getAllOf(String tag) {
        NodeList nl = this.innerElement.getElementsByTagName(tag);
        ArrayList<Element> returnList = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            returnList.add(new Element((org.w3c.dom.Element)nl.item(i), this.fileDirectory, this.document));
        }
        return returnList;
    }

    public List<Element> getAll() {
        NodeList nl = this.innerElement.getChildNodes();
        ArrayList<Element> returnList = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof org.w3c.dom.Element)) continue;
            returnList.add(new Element((org.w3c.dom.Element)nl.item(i), this.fileDirectory, this.document));
        }
        return returnList;
    }
}

