/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.FluidCum;
import com.lilithsthrone.game.character.body.FluidGirlCum;
import com.lilithsthrone.game.character.body.FluidInterface;
import com.lilithsthrone.game.character.body.FluidMilk;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.XMLSaving;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FluidStored
implements XMLSaving {
    private String charactersFluidID;
    private Body body;
    private boolean cumVirile;
    private float virility;
    private boolean feral;
    private FluidCum cum;
    private FluidMilk milk;
    private FluidGirlCum girlCum;
    private float millilitres;

    public FluidStored(GameCharacter character, FluidCum cum, float millilitres) {
        if (character != null) {
            this.charactersFluidID = character.getId();
            this.body = new Body(character.getBody());
            this.cumVirile = character.isVirile(Attribute.VIRILITY);
            this.virility = character.getAttributeValue(Attribute.VIRILITY);
            this.feral = cum.isFeral(character);
        } else {
            this.charactersFluidID = "";
            this.body = null;
            this.cumVirile = true;
            this.virility = 25.0f;
            this.feral = false;
        }
        this.cum = new FluidCum(cum.getType());
        this.cum.clearFluidModifiers();
        this.cum.setFlavour(null, cum.getFlavour());
        for (FluidModifier fm : cum.getFluidModifiers()) {
            this.cum.addFluidModifier(null, fm);
        }
        for (ItemEffect ie : cum.getTransformativeEffects()) {
            this.cum.addTransformativeEffect(ie);
        }
        this.millilitres = millilitres;
    }

    public FluidStored(String charactersFluidID, Body body, FluidCum cum, float millilitres) {
        this.charactersFluidID = charactersFluidID;
        this.body = body;
        try {
            GameCharacter owner = charactersFluidID == null || charactersFluidID.isEmpty() ? null : Main.game.getNPCById(charactersFluidID);
            this.feral = cum.isFeral(owner);
            this.cumVirile = owner == null ? true : owner.isVirile(Attribute.VIRILITY);
            this.virility = owner == null ? 25.0f : owner.getAttributeValue(Attribute.VIRILITY);
        }
        catch (Exception e) {
            this.feral = false;
        }
        this.cum = new FluidCum(cum.getType());
        this.cum.clearFluidModifiers();
        this.cum.setFlavour(null, cum.getFlavour());
        for (FluidModifier fm : cum.getFluidModifiers()) {
            this.cum.addFluidModifier(null, fm);
        }
        for (ItemEffect ie : cum.getTransformativeEffects()) {
            this.cum.addTransformativeEffect(ie);
        }
        this.millilitres = millilitres;
    }

    public FluidStored(String charactersFluidID, FluidMilk milk, float millilitres) {
        this.charactersFluidID = charactersFluidID;
        this.body = null;
        this.cumVirile = false;
        this.virility = 0.0f;
        try {
            GameCharacter owner = charactersFluidID == null || charactersFluidID.isEmpty() ? null : Main.game.getNPCById(charactersFluidID);
            this.feral = milk.isFeral(owner);
        }
        catch (Exception e) {
            this.feral = false;
        }
        this.milk = new FluidMilk(milk.getType(), milk.isCrotchMilk());
        this.milk.clearFluidModifiers();
        this.milk.setFlavour(null, milk.getFlavour());
        for (FluidModifier fm : milk.getFluidModifiers()) {
            this.milk.addFluidModifier(null, fm);
        }
        for (ItemEffect ie : milk.getTransformativeEffects()) {
            this.milk.addTransformativeEffect(ie);
        }
        this.millilitres = millilitres;
    }

    public FluidStored(String charactersFluidID, FluidGirlCum girlCum, float millilitres) {
        this.charactersFluidID = charactersFluidID;
        this.body = null;
        this.cumVirile = false;
        this.virility = 0.0f;
        try {
            GameCharacter owner = charactersFluidID == null || charactersFluidID.isEmpty() ? null : Main.game.getNPCById(charactersFluidID);
            this.feral = girlCum.isFeral(owner);
        }
        catch (Exception e) {
            this.feral = false;
        }
        this.girlCum = new FluidGirlCum(girlCum.getType());
        this.girlCum.clearFluidModifiers();
        this.girlCum.setFlavour(null, girlCum.getFlavour());
        for (FluidModifier fm : girlCum.getFluidModifiers()) {
            this.girlCum.addFluidModifier(null, fm);
        }
        for (ItemEffect ie : girlCum.getTransformativeEffects()) {
            this.girlCum.addTransformativeEffect(ie);
        }
        this.millilitres = millilitres;
    }

    public boolean equals(Object o) {
        return o instanceof FluidStored && ((FluidStored)o).getFluid().equals(this.getFluid()) && ((FluidStored)o).getCharactersFluidID().equals(this.getCharactersFluidID()) && ((FluidStored)o).isFeral() == this.isFeral() && (this.getBody() != null && this.body != null ? Objects.equals(((FluidStored)o).getBody().getSubspecies(), this.body.getSubspecies()) && Objects.equals((Object)((FluidStored)o).getBody().getGender(), (Object)this.body.getGender()) : this.getBody() == null && this.body == null) && ((FluidStored)o).isCumVirile() == this.isCumVirile() && ((FluidStored)o).getVirility() == this.getVirility();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getFluid().hashCode();
        result = 31 * result + this.getCharactersFluidID().hashCode();
        result = 31 * result + (this.isFeral() ? 1 : 0);
        if (this.getBody() != null) {
            result = 31 * result + this.getBody().getSubspecies().hashCode();
            result = 31 * result + this.getBody().getGender().hashCode();
        }
        result = 31 * result + (this.isCumVirile() ? 1 : 0);
        result = 31 * result + Float.floatToIntBits(this.getVirility());
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element fluidStoredElement = doc.createElement("fluidStored");
        parentElement.appendChild(fluidStoredElement);
        XMLUtil.addAttribute(doc, fluidStoredElement, "charactersFluidID", this.charactersFluidID);
        XMLUtil.addAttribute(doc, fluidStoredElement, "bestial", String.valueOf(this.feral));
        XMLUtil.addAttribute(doc, fluidStoredElement, "cumVirile", String.valueOf(this.cumVirile));
        XMLUtil.addAttribute(doc, fluidStoredElement, "virility", String.valueOf(this.virility));
        XMLUtil.addAttribute(doc, fluidStoredElement, "millilitres", String.valueOf(this.millilitres));
        if (this.isCum()) {
            Element bodyElement = doc.createElement("body");
            fluidStoredElement.appendChild(bodyElement);
            this.body.saveAsXML(bodyElement, doc);
            this.cum.saveAsXML("fluidCum", fluidStoredElement, doc);
        }
        if (this.isMilk()) {
            this.milk.saveAsXML("fluidMilk", fluidStoredElement, doc);
        }
        if (this.isGirlCum()) {
            this.girlCum.saveAsXML("fluidGirlCum", fluidStoredElement, doc);
        }
        return fluidStoredElement;
    }

    public static FluidStored loadFromXML(StringBuilder log, Element parentElement, Document doc) {
        String ID = parentElement.getAttribute("charactersFluidID");
        float millimetres = Float.parseFloat(parentElement.getAttribute("millilitres"));
        boolean feral = false;
        boolean cumVirile = true;
        float virility = 25.0f;
        try {
            feral = Boolean.parseBoolean(parentElement.getAttribute("bestial"));
            virility = Float.parseFloat(parentElement.getAttribute("virility"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!parentElement.getAttribute("cumVirile").isEmpty()) {
            cumVirile = Boolean.parseBoolean(parentElement.getAttribute("cumVirile"));
        }
        if (parentElement.getElementsByTagName("body").item(0) != null) {
            if (parentElement.getElementsByTagName("fluidCum").item(0) != null) {
                FluidStored fluid = new FluidStored(ID, Body.loadFromXML(log, (Element)parentElement.getElementsByTagName("body").item(0), doc), FluidCum.loadFromXML("fluidCum", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = cumVirile;
                fluid.virility = virility;
                return fluid;
            }
        } else {
            if (parentElement.getElementsByTagName("milk").item(0) != null) {
                FluidStored fluid = new FluidStored(ID, FluidMilk.loadFromXML("milk", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = false;
                fluid.virility = 0.0f;
                return fluid;
            }
            if (parentElement.getElementsByTagName("fluidMilk").item(0) != null) {
                FluidStored fluid = new FluidStored(ID, FluidMilk.loadFromXML("fluidMilk", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = false;
                fluid.virility = 0.0f;
                return fluid;
            }
            if (parentElement.getElementsByTagName("girlcum").item(0) != null) {
                FluidStored fluid = new FluidStored(ID, FluidGirlCum.loadFromXML("girlcum", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = false;
                fluid.virility = 0.0f;
                return fluid;
            }
            if (parentElement.getElementsByTagName("fluidGirlCum").item(0) != null) {
                FluidStored fluid = new FluidStored(ID, FluidGirlCum.loadFromXML("fluidGirlCum", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = false;
                fluid.virility = 0.0f;
                return fluid;
            }
            if (parentElement.getElementsByTagName("cum").item(0) != null) {
                AbstractSubspecies subspecies = Subspecies.HUMAN;
                AbstractSubspecies halfDemonSubspecies = Subspecies.HUMAN;
                try {
                    subspecies = Subspecies.getSubspeciesFromId(parentElement.getAttribute("cumSubspecies"));
                    halfDemonSubspecies = Subspecies.getSubspeciesFromId(parentElement.getAttribute("cumHalfDemonSubspecies"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FluidStored fluid = new FluidStored(ID, subspecies == Subspecies.HALF_DEMON ? Main.game.getCharacterUtils().generateHalfDemonBody(null, Gender.M_P_MALE, halfDemonSubspecies, false) : Main.game.getCharacterUtils().generateBody(null, Gender.M_P_MALE, subspecies, RaceStage.GREATER), FluidCum.loadFromXML("cum", parentElement, doc), millimetres);
                fluid.feral = feral;
                fluid.cumVirile = cumVirile;
                fluid.virility = virility;
                return fluid;
            }
        }
        System.err.println("WARNING: FluidStored failed to load!");
        new Exception().printStackTrace();
        return null;
    }

    public String getCharactersFluidID() {
        return this.charactersFluidID;
    }

    public GameCharacter getFluidCharacter() throws Exception {
        if (this.charactersFluidID.equals(Main.game.getPlayer().getId())) {
            return Main.game.getPlayer();
        }
        return Main.game.getNPCById(this.charactersFluidID);
    }

    public boolean isCum() {
        return this.cum != null;
    }

    public boolean isMilk() {
        return this.milk != null;
    }

    public boolean isGirlCum() {
        return this.girlCum != null;
    }

    public FluidInterface getFluid() {
        if (this.isCum()) {
            return this.cum;
        }
        if (this.isMilk()) {
            return this.milk;
        }
        return this.girlCum;
    }

    public Body getBody() {
        return this.body;
    }

    public boolean isFeral() {
        return this.feral;
    }

    public boolean isCumVirile() {
        return this.cumVirile;
    }

    public float getVirility() {
        return this.virility;
    }

    public float getMillilitres() {
        return this.millilitres;
    }

    public void setMillilitres(float millilitres) {
        this.millilitres = Math.max(0.0f, millilitres);
    }

    public void incrementMillilitres(float increment) {
        this.setMillilitres(this.millilitres + increment);
    }
}

