/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum AffectionLevel {
    NEGATIVE_FIVE_LOATHE("\u618e\u6076", "\u618e\u6076", -100, -90, PresetColour.AFFECTION_NEGATIVE_FIVE, true),
    NEGATIVE_FOUR_HATE("\u538c\u6076", "\u538c\u6076", -90, -70, PresetColour.AFFECTION_NEGATIVE_FOUR, true),
    NEGATIVE_THREE_STRONG_DISLIKE("\u6781\u5176\u8ba8\u538c", "\u6781\u5176\u8ba8\u538c", -70, -50, PresetColour.AFFECTION_NEGATIVE_THREE, true),
    NEGATIVE_TWO_DISLIKE("\u8ba8\u538c", "\u8ba8\u538c", -50, -30, PresetColour.AFFECTION_NEGATIVE_TWO, true),
    NEGATIVE_ONE_ANNOYED("\u70e6\u607c", "\u6709\u70b9\u70e6", -30, -10, PresetColour.AFFECTION_NEGATIVE_ONE, true),
    ZERO_NEUTRAL("\u4e2d\u7acb", "\u4e0d\u559c\u6b22\u4e5f\u4e0d\u8ba8\u538c", -10, 10, PresetColour.AFFECTION_NEUTRAL, true),
    POSITIVE_ONE_FRIENDLY("\u53cb\u5584", "\u53cb\u5584\u5bf9\u5f85", 10, 30, PresetColour.AFFECTION_POSITIVE_ONE, false),
    POSITIVE_TWO_LIKE("\u559c\u6b22", "\u559c\u6b22", 30, 50, PresetColour.AFFECTION_POSITIVE_TWO, false),
    POSITIVE_THREE_CARING("\u5173\u5fc3", "\u5173\u5fc3", 50, 70, PresetColour.AFFECTION_POSITIVE_THREE, false),
    POSITIVE_FOUR_LOVE("\u559c\u7231", "\u559c\u7231", 70, 90, PresetColour.AFFECTION_POSITIVE_FOUR, false),
    POSITIVE_FIVE_WORSHIP("\u7231\u6155", "\u7231\u6155", 90, 100, PresetColour.AFFECTION_POSITIVE_FIVE, false);

    private String name;
    private String descriptor;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;
    private boolean willFightPlayer;

    private AffectionLevel(String name, String descriptor, int minimumValue, int maximumValue, Colour colour, boolean willFightPlayer) {
        this.name = name;
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
        this.willFightPlayer = willFightPlayer;
    }

    public static String getDescription(GameCharacter character, GameCharacter target, boolean withColour) {
        StringBuilder sb = new StringBuilder();
        AffectionLevel affectionLevel = character.getAffectionLevel(target);
        switch (affectionLevel) {
            case NEGATIVE_FIVE_LOATHE: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u618e\u6076", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case NEGATIVE_FOUR_HATE: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u538c\u6076", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case NEGATIVE_THREE_STRONG_DISLIKE: {
                sb.append(UtilText.parse(character, target, "[npc.Name] " + AffectionLevel.applyColourWrapper("\u975e\u5e38\u8ba8\u538c", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case NEGATIVE_TWO_DISLIKE: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u8ba8\u538c", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case NEGATIVE_ONE_ANNOYED: {
                sb.append(UtilText.parse(character, target, "[npc.Name]\u5bf9[npc2.name]\u611f\u5230" + AffectionLevel.applyColourWrapper("\u607c\u706b", affectionLevel, withColour) + "\u3002", new ParserTag[0]));
                break;
            }
            case ZERO_NEUTRAL: {
                sb.append(UtilText.parse(character, target, "[npc.Name]\u5bf9[npc2.name]" + AffectionLevel.applyColourWrapper("\u6ee1\u4e0d\u5728\u4e4e", affectionLevel, withColour) + "\u3002", new ParserTag[0]));
                break;
            }
            case POSITIVE_ONE_FRIENDLY: {
                sb.append(UtilText.parse(character, target, "[npc.Name]\u5bf9[npc2.name]" + AffectionLevel.applyColourWrapper("\u53cb\u5584", affectionLevel, withColour) + "\u3002", new ParserTag[0]));
                break;
            }
            case POSITIVE_TWO_LIKE: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u559c\u6b22", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case POSITIVE_THREE_CARING: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u5173\u5fc3", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case POSITIVE_FOUR_LOVE: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u559c\u7231", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
                break;
            }
            case POSITIVE_FIVE_WORSHIP: {
                sb.append(UtilText.parse(character, target, "[npc.Name]" + AffectionLevel.applyColourWrapper("\u7231\u6155", affectionLevel, withColour) + "[npc2.name]\u3002", new ParserTag[0]));
            }
        }
        return sb.toString();
    }

    public static String getAttitudeDescription(GameCharacter character, GameCharacter target, boolean withColour) {
        StringBuilder sb = new StringBuilder();
        AffectionLevel affectionLevel = character.getAffectionLevel(target);
        sb.append("<p style='text-align:center;'><i>");
        switch (affectionLevel) {
            case NEGATIVE_FIVE_LOATHE: {
                sb.append("\u4ece\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.Name]\u5f88\u660e\u663e\u5341\u5206" + AffectionLevel.applyColourWrapper("\u618e\u6076[npc2.name]", affectionLevel, withColour) + "\u3002");
                break;
            }
            case NEGATIVE_FOUR_HATE: {
                sb.append("\u4ece\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.Name]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u538c\u6076[npc2.name]", affectionLevel, withColour) + "\u3002");
                break;
            }
            case NEGATIVE_THREE_STRONG_DISLIKE: {
                sb.append("\u770b[npc.Name]\u7684\u6001\u5ea6\uff0c\u5979\u660e\u663e" + AffectionLevel.applyColourWrapper("\u6781\u5176\u8ba8\u538c[npc2.name]", affectionLevel, withColour) + "\u3002");
                break;
            }
            case NEGATIVE_TWO_DISLIKE: {
                sb.append("[npc.NameIsFull]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u8ba8\u538c[npc2.name]", affectionLevel, withColour) + "\u3002");
                break;
            }
            case NEGATIVE_ONE_ANNOYED: {
                sb.append("[npc.NameIsFull]\u660e\u663e\u5bf9[npc2.name]\u611f\u5230" + AffectionLevel.applyColourWrapper("\u607c\u706b", affectionLevel, withColour) + "\u3002");
                break;
            }
            case ZERO_NEUTRAL: {
                sb.append("\u5bf9\u4e8e[npc2.name]\uff0c[npc.NameIsFull]\u6446\u51fa\u4e00\u526f" + AffectionLevel.applyColourWrapper("\u6ee1\u4e0d\u5728\u4e4e", affectionLevel, withColour) + "\u7684\u59ff\u6001\u3002");
                break;
            }
            case POSITIVE_ONE_FRIENDLY: {
                if (character.isAttractedTo(target)) {
                    sb.append("\u5bf9\u4e8e[npc2.name]\uff0c[npc.NameIsFull]\u6446\u51fa\u4e00\u526f" + AffectionLevel.applyColourWrapper("\u53cb\u5584\u3001\u6311\u9017", affectionLevel, withColour) + "\u7684\u59ff\u6001\u3002");
                    break;
                }
                sb.append("\u5bf9\u4e8e[npc2.name]\uff0c[npc.NameIsFull]\u6446\u51fa\u4e00\u526f" + AffectionLevel.applyColourWrapper("\u53cb\u5584", affectionLevel, withColour) + "\u7684\u59ff\u6001\u3002");
                break;
            }
            case POSITIVE_TWO_LIKE: {
                if (character.isAttractedTo(target)) {
                    sb.append("[npc.Name]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u559c\u6b22[npc2.name]", affectionLevel, withColour) + "\uff0c\u800c\u4e14\u8ba4\u4e3a[npc2.herHim]\u4e0d\u53ea\u662f\u670b\u53cb\u3002");
                    break;
                }
                sb.append("[npc.Name]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u559c\u6b22[npc2.name]", affectionLevel, withColour) + "\uff0c\u5e76\u4e14\u8ba4\u4e3a[npc2.herHim]\u662f\u4f4d\u597d\u670b\u53cb\u3002");
                break;
            }
            case POSITIVE_THREE_CARING: {
                if (character.isAttractedTo(target)) {
                    sb.append("[npc.Name]\u660e\u663e" + AffectionLevel.applyColourWrapper("\u5f88\u5728\u4e4e[npc2.name]", affectionLevel, withColour) + "\uff0c\u5e76\u4e14\u88ab[npc2.herHim]\u6df1\u6df1\u5730\u5438\u5f15\u4e86\u3002");
                    break;
                }
                sb.append("[npc.Name]\u660e\u663e" + AffectionLevel.applyColourWrapper("\u5f88\u5728\u4e4e[npc2.name]", affectionLevel, withColour) + "\uff0c\u5e76\u4e14\u8ba4\u4e3a[npc2.herHim]\u662f[npc.her]\u6700\u597d\u7684\u670b\u53cb\u3002");
                break;
            }
            case POSITIVE_FOUR_LOVE: {
                if (character.isAttractedTo(target)) {
                    sb.append("\u4ece[npc.Name]\u770b\u5411[npc2.name]\u7684\u773c\u795e\u5c31\u80fd\u5f97\u77e5\uff0c[npc.she]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u7231\u4e0a\u4e86[npc2.herHim]", affectionLevel, withColour) + "\u3002");
                    break;
                }
                sb.append("\u4ece[npc.Name]\u7684\u884c\u4e3a\u4e0a\u6765\u770b\uff0c[npc.she]\u5f88\u660e\u663e" + AffectionLevel.applyColourWrapper("\u559c\u7231\u7740[npc2.name]", affectionLevel, withColour) + "\uff0c\u4e00\u79cd\u67cf\u62c9\u56fe\u5f0f\u7684\u53cb\u8c0a\u3002");
                break;
            }
            case POSITIVE_FIVE_WORSHIP: {
                if (character.isAttractedTo(target)) {
                    sb.append("[npc.Name]\u5341\u5206" + AffectionLevel.applyColourWrapper("\u7231\u6155[npc2.name]", affectionLevel, withColour) + "\uff0c\u5df2\u7ecf\u6b7b\u5fc3\u584c\u5730\u5730\u7231\u4e0a\u4e86[npc2.herHim]\u3002");
                    break;
                }
                sb.append("[npc.Name]\u5341\u5206" + AffectionLevel.applyColourWrapper("\u4ef0\u6155[npc2.name]", affectionLevel, withColour) + "\uff0c\u65e0\u8bba[npc2.she]\u8ba9\u81ea\u5df1\u505a\u4ec0\u4e48\u90fd\u613f\u610f\u3002");
            }
        }
        sb.append("</i></p>");
        return UtilText.parse(character, target, sb.toString(), new ParserTag[0]);
    }

    private static String applyColourWrapper(String input, AffectionLevel affection, boolean withColour) {
        if (!withColour) {
            return input;
        }
        return "<span style='color:" + affection.getColour().toWebHexString() + ";'>" + input + "</span>";
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isWillFightPlayer() {
        return this.willFightPlayer;
    }

    public static AffectionLevel getAffectionLevelFromValue(float value) {
        for (AffectionLevel al : AffectionLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return POSITIVE_FIVE_WORSHIP;
    }

    public boolean isLessThan(AffectionLevel levelToCompare) {
        return this.getMedianValue() < levelToCompare.getMedianValue();
    }

    public boolean isGreaterThan(AffectionLevel levelToCompare) {
        return this.getMedianValue() > levelToCompare.getMedianValue();
    }
}

