/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum AlcoholLevel {
    ZERO_SOBER("\u6e05\u9192", 0, 0.0f, 0.01f, PresetColour.ALCOHOL_LEVEL_ZERO),
    ONE_TIPSY("\u5fae\u91ba", 0, 0.01f, 0.2f, PresetColour.ALCOHOL_LEVEL_ONE),
    TWO_MERRY("\u6d45\u9189", 0, 0.2f, 0.4f, PresetColour.ALCOHOL_LEVEL_TWO),
    THREE_DRUNK("\u9189\u9152", 30, 0.4f, 0.6f, PresetColour.ALCOHOL_LEVEL_THREE),
    FOUR_HAMMERED("\u6c89\u9189", 20, 0.6f, 0.8f, PresetColour.ALCOHOL_LEVEL_FOUR),
    FIVE_WASTED("\u70c2\u9189", 10, 0.8f, 1.0f, PresetColour.ALCOHOL_LEVEL_FIVE);

    private String name;
    private float minimumValue;
    private float maximumValue;
    private Colour colour;
    private int slurredSpeechFrequency;

    private AlcoholLevel(String name, int slurredSpeechFrequency, float minimumValue, float maximumValue, Colour colour) {
        this.name = name;
        this.slurredSpeechFrequency = slurredSpeechFrequency;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public int getSlurredSpeechFrequency() {
        return this.slurredSpeechFrequency;
    }

    public float getMinimumValue() {
        return this.minimumValue;
    }

    public float getMaximumValue() {
        return this.maximumValue;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static AlcoholLevel getAlcoholLevelFromValue(float value) {
        for (AlcoholLevel al : AlcoholLevel.values()) {
            if (!(value >= al.getMinimumValue()) || !(value < al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_WASTED;
    }

    public boolean isLessThan(AlcoholLevel level) {
        return this.getMinimumValue() < level.getMinimumValue();
    }

    public boolean isGreaterThan(AlcoholLevel level) {
        return this.getMinimumValue() > level.getMinimumValue();
    }
}

