/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ArousalLevel {
    ZERO_NONE("\u65e0", 0, 10, PresetColour.AROUSAL_STAGE_ZERO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_0;
        }
    }
    ,
    ONE_TURNED_ON("\u6027\u6b32\u6fc0\u8d77", 10, 25, PresetColour.AROUSAL_STAGE_ONE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_1;
        }
    }
    ,
    TWO_EXCITED("\u975e\u5e38\u6027\u594b", 25, 50, PresetColour.AROUSAL_STAGE_TWO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_2;
        }
    }
    ,
    THREE_HEATED("\u6b32\u706b\u711a\u8eab", 50, 80, PresetColour.AROUSAL_STAGE_THREE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_3;
        }
    }
    ,
    FOUR_PASSIONATE("\u6fc0\u60c5\u6f8e\u62dc", 80, 95, PresetColour.AROUSAL_STAGE_FOUR){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_4;
        }

        @Override
        public boolean isMutualOrgasm() {
            return true;
        }
    }
    ,
    FIVE_ORGASM_IMMINENT("\u4e34\u8fd1\u9ad8\u6f6e", 95, 100, PresetColour.AROUSAL_STAGE_FIVE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.AROUSAL_PERK_5;
        }

        @Override
        public boolean isMutualOrgasm() {
            return true;
        }
    };

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;

    private ArousalLevel(String name, int minimumValue, int maximumValue, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public abstract AbstractStatusEffect getRelatedStatusEffect();

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static ArousalLevel getArousalLevelFromValue(float value) {
        for (ArousalLevel al : ArousalLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_ORGASM_IMMINENT;
    }

    public boolean isMutualOrgasm() {
        return false;
    }
}

