/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Attribute {
    public static AbstractAttribute MAJOR_PHYSIQUE;
    public static AbstractAttribute MAJOR_ARCANE;
    public static AbstractAttribute MAJOR_CORRUPTION;
    public static AbstractAttribute HEALTH_MAXIMUM;
    public static AbstractAttribute MANA_MAXIMUM;
    public static AbstractAttribute EXPERIENCE;
    public static AbstractAttribute ACTION_POINTS;
    public static AbstractAttribute ENCHANTMENT_LIMIT;
    public static AbstractAttribute LUST;
    public static AbstractAttribute RESTING_LUST;
    public static AbstractAttribute AROUSAL;
    public static AbstractAttribute VIRILITY;
    public static AbstractAttribute FERTILITY;
    public static AbstractAttribute SPELL_COST_MODIFIER;
    public static AbstractAttribute CRITICAL_DAMAGE;
    public static AbstractAttribute DAMAGE_UNARMED;
    public static AbstractAttribute DAMAGE_MELEE_WEAPON;
    public static AbstractAttribute DAMAGE_RANGED_WEAPON;
    public static AbstractAttribute DAMAGE_SPELLS;
    public static AbstractAttribute DAMAGE_PHYSICAL;
    public static AbstractAttribute DAMAGE_LUST;
    public static AbstractAttribute DAMAGE_FIRE;
    public static AbstractAttribute DAMAGE_ICE;
    public static AbstractAttribute DAMAGE_POISON;
    public static AbstractAttribute ENERGY_SHIELDING;
    public static AbstractAttribute RESISTANCE_PHYSICAL;
    public static AbstractAttribute RESISTANCE_LUST;
    public static AbstractAttribute RESISTANCE_FIRE;
    public static AbstractAttribute RESISTANCE_ICE;
    public static AbstractAttribute RESISTANCE_POISON;
    public static AbstractAttribute DAMAGE_ELDER_LILIN;
    public static AbstractAttribute DAMAGE_LILIN;
    public static AbstractAttribute DAMAGE_IMP;
    public static Map<AbstractAttribute, String> attributeToIdMap;
    public static Map<String, AbstractAttribute> idToAttributeMap;
    public static List<AbstractAttribute> allAttributes;
    public static Map<AbstractRace, AbstractAttribute> racialAttributes;
    private static Map<String, AbstractAttribute> oldConversionMapping;

    public static AbstractAttribute getAttributeFromId(String attributeId) {
        if (attributeId.startsWith("RESISTANCE_ELEMENTAL")) {
            attributeId = "RESISTANCE_ELEMENTAL";
        } else if (attributeId.startsWith("DAMAGE_ELEMENTAL")) {
            attributeId = "DAMAGE_ELEMENTAL";
        } else if (attributeId.startsWith("CRITICAL_CHANCE")) {
            attributeId = "CRITICAL_DAMAGE";
        }
        if (oldConversionMapping.containsKey(attributeId)) {
            return oldConversionMapping.get(attributeId);
        }
        attributeId = Util.getClosestStringMatch(attributeId, idToAttributeMap.keySet(), 3);
        return idToAttributeMap.get(attributeId);
    }

    public static String getIdFromAttribute(AbstractAttribute attribute) {
        return attributeToIdMap.get(attribute);
    }

    public static List<AbstractAttribute> getAllAttributes() {
        return allAttributes;
    }

    public static AbstractAttribute getRacialDamageAttribute(AbstractRace race) {
        return racialAttributes.get(race);
    }

    static {
        Field[] fields;
        MAJOR_PHYSIQUE = new AbstractAttribute(false, 0, 0, 100, "physique", "\u4f53\u683c", "strengthIcon", PresetColour.ATTRIBUTE_PHYSIQUE, "\u5f3a\u58ee", "\u865a\u5f31", Util.newArrayListOfValues("\u6bcf1\u70b9\u4f53\u683c<b>+2</b><b style='color: " + PresetColour.ATTRIBUTE_HEALTH.toWebHexString() + "'>\u751f\u547d</b>")){

            @Override
            public boolean hasStatusEffect() {
                return true;
            }

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u8861\u91cf[npc.name]\u8eab\u4f53\u5065\u5eb7\u7684\u6807\u51c6\uff0c\u4f53\u683c\u4f1a<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u88ab\u52a8\u63d0\u5347</b>[npc.her]\u7684<b style='color:" + PresetColour.ATTRIBUTE_HEALTH.toWebHexString() + ";'>\u6700\u5927\u751f\u547d\u503c</b>\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 10;
            }
        };
        MAJOR_ARCANE = new AbstractAttribute(false, 0, 0, 100, "arcane", "\u5965\u672f", "intelligenceIcon", PresetColour.ATTRIBUTE_ARCANE, "\u5965\u672f\u589e\u5e45", "\u5965\u672f\u6d41\u5931", Util.newArrayListOfValues("\u6bcf1\u70b9\u5965\u672f<b>+2</b><b style='color: " + PresetColour.ATTRIBUTE_MANA.toWebHexString() + "'>\u7075\u6c14</b>")){

            @Override
            public boolean hasStatusEffect() {
                return true;
            }

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u8861\u91cf[npc.namePos]\u5965\u672f\u4eb2\u548c\u529b\u7684\u6807\u51c6\u3002\u5965\u672f\u4f1a<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u88ab\u52a8\u63d0\u5347</b>[npc.her]\u7684<b style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>\u6700\u5927\u7075\u6c14</b>\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 20;
            }
        };
        MAJOR_CORRUPTION = new AbstractAttribute(false, 0, 0, 100, "corruption", "\u5815\u843d", "corruptionIcon", PresetColour.ATTRIBUTE_CORRUPTION, "\u5815\u843d", "\u7eaf\u6d01", Util.newArrayListOfValues("\u6bcf1\u70b9\u5815\u843d<b>-0.5</b><b style='color: " + PresetColour.ATTRIBUTE_MANA.toWebHexString() + "'>\u5feb\u611f\u62b5\u6297</b>", "\u6bcf1\u70b9\u5815\u843d<b>+0.5</b><b style='color: " + PresetColour.DAMAGE_TYPE_MANA.toWebHexString() + "'>\u5feb\u611f\u4f24\u5bb3</b>")){

            @Override
            public boolean hasStatusEffect() {
                return true;
            }

            @Override
            public String getDescription(GameCharacter owner) {
                if (owner.isPlayer()) {
                    return "\u5815\u843d\u662f\u8861\u91cf\u4f60\u6709\u591a\u53d8\u6001\u7684\u6570\u503c\uff0c\u4f1a\u5f71\u54cd<b style='color:" + PresetColour.ATTRIBUTE_CORRUPTION.toWebHexString() + ";'>\u54ea\u4e9b\u6027\u52a8\u4f5c\u80fd\u968f\u5fc3\u6240\u6b32\u5730\u4f7f\u7528</b>\u3002";
                }
                return UtilText.parse(owner, "\u5815\u843d\u662f\u8861\u91cf[npc.namePos]\u6709\u591a\u53d8\u6001\u7684\u6570\u503c\uff0c\u5e76<i>\u4e0d\u80fd</i>\u53cd\u6620[npc.she]\u662f\u5584\u826f\u8fd8\u662f\u90aa\u6076\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 30;
            }
        };
        HEALTH_MAXIMUM = new AbstractAttribute(false, 1, 1, 999, "\u5065\u5eb7", "\u751f\u547d", "healthIcon", PresetColour.ATTRIBUTE_HEALTH, "\u5065\u5eb7", "\u60a3\u75c5", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "[npc.Name]\u6240\u62e5\u6709\u7684\u4f53\u80fd\u4e0e\u51b3\u5fc3\u3002\u5728\u6218\u6597\u4e2d\u964d\u4e3a0\u540e\u4fbf\u4f1a\u88ab\u51fb\u8d25\u3002<br/>\u80fd\u591f\u989d\u5916\u589e\u52a0\u81f3\u201c\u52a0\u6210\u201d\u6570\u503c\u7684\u751f\u547d\u6765\u6e90:<br/><b>10 + (5*\u7b49\u7ea7) + (2*\u4f53\u683c) + \u80fd\u91cf\u52a0\u6210</b>", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 40;
            }
        };
        MANA_MAXIMUM = new AbstractAttribute(false, 1, 1, 999, "aura", "\u7075\u6c14", "manaIcon", PresetColour.ATTRIBUTE_MANA, "\u7075\u6c14\u589e\u5f3a", "\u7075\u6c14\u6d41\u5931", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u8861\u91cf[npc.name]\u7075\u6c14\u4e2d\u5965\u672f\u80fd\u91cf\u591a\u5c11\u7684\u6807\u51c6\u3002<br/>\u80fd\u591f\u989d\u5916\u589e\u52a0\u81f3\u201c\u52a0\u6210\u201d\u6570\u503c\u7684\u7075\u6c14\u6765\u6e90:<br/><b>5 + (2*\u7b49\u7ea7) + (5*\u5965\u672f) + \u7075\u6c14\u52a0\u6210</b>", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 50;
            }
        };
        EXPERIENCE = new AbstractAttribute(false, 0, 0, 1000000, "experience", "\u7ecf\u9a8c", "experienceIcon", PresetColour.GENERIC_EXPERIENCE, "\u597d\u5b66", "\u5065\u5fd8", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "[npc.Name]\u63d0\u5347\u81f3\u4e0b\u4e00\u7ea7\u8fc7\u7a0b\u4e2d\u79ef\u7d2f\u7684\u8fdb\u5ea6\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 60;
            }
        };
        ACTION_POINTS = new AbstractAttribute(false, 0, 0, 10, "action points", "\u884c\u52a8\u70b9\u6570", "action_points", PresetColour.GENERIC_ACTION_POINTS, "\u638c\u63e1\u5148\u673a", "\u65e0\u7cbe\u6253\u91c7", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "[npc.nameHasFull]\u5728\u6218\u6597\u4e2d\u80fd\u591f\u7528\u4e8e\u52a8\u4f5c\u7684\u884c\u52a8\u70b9\u6570\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 70;
            }
        };
        ENCHANTMENT_LIMIT = new AbstractAttribute(false, 0, 0, 1000, "enchantment instability", "\u9644\u9b54\u4e0d\u7a33\u5b9a", "enchantmentLimitIcon", PresetColour.GENERIC_ENCHANTMENT, "\u638c\u63a7\u4e00\u5207", "\u7b28\u624b\u7b28\u811a", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "\u5728\u4e0d\u9020\u6210\u4e25\u91cd\u60e9\u7f5a\u7684\u524d\u63d0\u4e0b\uff0c[npc.nameIsFull]\u80fd\u591f\u9a7e\u9a6d\u7684\u8863\u7269\u3001\u6b66\u5668\u3001\u7eb9\u8eab\u9644\u9b54\u7684\u603b\u91cf\u3002", new ParserTag[0]);
            }

            @Override
            public boolean isAffectedByEnchantmentCost() {
                return false;
            }

            @Override
            public int getOrderPriority() {
                return 80;
            }
        };
        LUST = new AbstractAttribute(false, 0, 0, 100, "lust", "\u6027\u6b32", "arousalIcon", PresetColour.ATTRIBUTE_LUST, "\u8089\u6b32", "\u51b7\u6de1", null){

            @Override
            public boolean hasStatusEffect() {
                return true;
            }

            @Override
            public String getDescription(GameCharacter owner) {
                if (owner.isPlayer()) {
                    return "\u8861\u91cf\u4f60\u6709\u591a\u6025\u5207\u5730\u60f3\u8fdb\u884c\u6027\u63a5\u89e6\u7684\u6807\u51c6\u3002\u4f60\u7684\u6027\u6b32\u503c\u4f1a\u968f\u65f6\u95f4\u9010\u6e10\u5411\u65e5\u5e38\u6027\u6b32\u503c\u6062\u590d\u3002<br/><b>\u65e5\u5e38\u6027\u6b32 = (\u5815\u843d/2) + \u52a0\u6210</b>";
                }
                return UtilText.parse(owner, "[npc.Name]\u6709\u591a\u6025\u5207\u5730\u60f3\u8fdb\u884c\u6027\u63a5\u89e6\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 100;
            }
        };
        RESTING_LUST = new AbstractAttribute(false, 0, -100, 80, "resting lust", "\u65e5\u5e38\u6027\u6b32", "arousalIcon", PresetColour.ATTRIBUTE_LUST, "\u8089\u6b32", "\u51b7\u6de1", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return UtilText.parse(owner, "[npc.Name]\u7684\u6027\u6b32\u4f1a\u968f\u65f6\u95f4\u6062\u590d\u81f3\u8be5\u6570\u503c\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 110;
            }
        };
        AROUSAL = new AbstractAttribute(false, 0, 0, 100, "arousal", "\u5feb\u611f", "arousalIcon", PresetColour.ATTRIBUTE_AROUSAL, "\u6301\u4e45", "\u65e9\u6cc4", null){

            @Override
            public boolean hasStatusEffect() {
                return true;
            }

            @Override
            public String getDescription(GameCharacter owner) {
                if (owner.isPlayer()) {
                    return "\u4f60\u73b0\u5728\u79ef\u7d2f\u4e86\u591a\u5c11\u5feb\u611f\uff0c\u5145\u6ee1\u65f6\u5219\u4f1a\u9ad8\u6f6e\u3002";
                }
                return UtilText.parse(owner, "[npc.name]\u79ef\u7d2f\u4e86\u591a\u5c11\u5feb\u611f\u3002\u5145\u6ee1\u65f6[npc.She]\u5219\u4f1a\u9ad8\u6f6e\u3002", new ParserTag[0]);
            }

            @Override
            public int getOrderPriority() {
                return 120;
            }
        };
        VIRILITY = new AbstractAttribute(true, 10, -100, 100, "virility", "\u751f\u6b96\u529b", "shieldIcon", PresetColour.GENERIC_SEX, "\u591a\u80b2", "\u4e0d\u80b2", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u4f7f\u4eba\u53d7\u5b55\u7684\u6982\u7387\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 130;
            }
        };
        FERTILITY = new AbstractAttribute(true, 10, -100, 100, "fertility", "\u751f\u80b2\u529b", "shieldIcon", PresetColour.GENERIC_SEX, "\u591a\u80b2", "\u4e0d\u80b2", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u6000\u5b55\u7684\u6982\u7387\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 140;
            }
        };
        SPELL_COST_MODIFIER = new AbstractAttribute(true, 0, 0, 80, "spell efficiency", "\u6cd5\u672f\u6548\u7387", "shieldIcon", PresetColour.ATTRIBUTE_MANA, "\u7cbe\u901a", "\u65e0\u80fd", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u91ca\u653e\u6cd5\u672f\u7684\u6d88\u8017\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 200;
            }
        };
        CRITICAL_DAMAGE = new AbstractAttribute(true, 150, 100, 500, "critical power", "\u66b4\u51fb\u4f24\u5bb3", "shieldIcon", PresetColour.ATTRIBUTE_HEALTH, "\u5f3a\u5927", "\u65e0\u529b", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u6bcf\u4e00\u70b9\u7ed9\u4e8e1%\u989d\u5916\u7684\u66b4\u51fb\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 210;
            }
        };
        DAMAGE_UNARMED = new AbstractAttribute(true, 0, -80, 100, "unarmed damage", "\u5f92\u624b\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_UNARMED, "\u7cbe\u901a\u6b66\u672f", "\u6b66\u672f\u4e0d\u7cbe", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u5f92\u624b\u653b\u51fb\u9020\u6210\u7684\u4f24\u5bb3\uff0c\u5305\u62ec\u53c8\u975e\u4eba\u7c7b\u8eab\u4f53\u90e8\u4ef6\u53d1\u51fa\u7684\u7279\u6b8a\u653b\u51fb\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 220;
            }
        };
        DAMAGE_MELEE_WEAPON = new AbstractAttribute(true, 0, -80, 100, "melee weapon damage", "\u8fd1\u6218\u6b66\u5668\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_MELEE, "\u8fd1\u6218\u5927\u5e08", "\u4e0d\u5584\u8fd1\u6218", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u8fd1\u6218\u6b66\u5668\u653b\u51fb\u9020\u6210\u7684\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 230;
            }
        };
        DAMAGE_RANGED_WEAPON = new AbstractAttribute(true, 0, -80, 100, "ranged weapon damage", "\u8fdc\u7a0b\u6b66\u5668\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_RANGED, "\u8fdc\u7a0b\u5927\u5e08", "\u4e0d\u5584\u8fdc\u7a0b", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u8fdc\u7a0b\u6b66\u5668\u653b\u51fb\u9020\u6210\u7684\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 240;
            }
        };
        DAMAGE_SPELLS = new AbstractAttribute(true, 0, -80, 100, "spell damage", "\u6cd5\u672f\u4f24\u5bb3", "swordIcon", PresetColour.ATTRIBUTE_MANA, "\u5965\u672f\u5a01\u80fd", "\u5965\u672f\u5f31\u80fd", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u6cd5\u672f\u4f24\u5bb3";
            }

            @Override
            public int getOrderPriority() {
                return 250;
            }
        };
        DAMAGE_PHYSICAL = new AbstractAttribute(true, 0, -80, 100, "physical damage", "\u7269\u7406\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_PHYSICAL, "\u5f3a\u51fb", "\u8f7b\u51fb", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u7269\u7406\u4f24\u5bb3";
            }

            @Override
            public int getOrderPriority() {
                return 260;
            }
        };
        DAMAGE_LUST = new AbstractAttribute(true, 0, -80, 100, "lust damage", "\u6027\u6b32\u4f24\u5bb3", "swordIcon", PresetColour.GENERIC_SEX, "\u52fe\u5f15", "\u6392\u65a5", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u6027\u6b32\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 270;
            }
        };
        DAMAGE_FIRE = new AbstractAttribute(true, 0, -80, 100, "fire damage", "\u706b\u7130\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_FIRE, "\u70bc\u72f1", "\u4f59\u70ec", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u706b\u7130\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 280;
            }
        };
        DAMAGE_ICE = new AbstractAttribute(true, 0, -80, 100, "cold damage", "\u5bd2\u51b7\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_COLD, "\u66b4\u98ce\u96ea", "\u878d\u96ea", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u5bd2\u51b7\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 290;
            }
        };
        DAMAGE_POISON = new AbstractAttribute(true, 0, -80, 100, "poison damage", "\u6bd2\u7d20\u4f24\u5bb3", "swordIcon", PresetColour.DAMAGE_TYPE_POISON, "\u5267\u6bd2", "\u7a00\u91ca", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u6bd2\u7d20\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 300;
            }
        };
        ENERGY_SHIELDING = new AbstractAttribute(false, 0, -100, 500, "health shielding", "\u751f\u547d\u62a4\u76fe", "shieldIcon", PresetColour.ATTRIBUTE_HEALTH, "\u575a\u97e7", "\u8106\u5f31", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u6bcf\u6218\u6597\u56de\u5408\u5f00\u59cb\u65f6\uff0c\u8be5\u6570\u503c\u4f1a\u88ab\u65bd\u52a0\u5230\u751f\u547d\u62a4\u76fe\u4e0a\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourHealth(\u6240\u6709\u7c7b\u578b\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 400;
            }
        };
        RESISTANCE_PHYSICAL = new AbstractAttribute(false, 0, -100, 500, "physical shielding", "\u7269\u7406\u62a4\u76fe", "shieldIcon", PresetColour.DAMAGE_TYPE_PHYSICAL, "\u5f3a\u97e7", "\u67d4\u5f31", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u53d7\u5230\u7684\u7269\u7406\u4f24\u5bb3\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourPhysical(\u7269\u7406\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 410;
            }
        };
        RESISTANCE_LUST = new AbstractAttribute(false, 0, -100, 500, "lust shielding", "\u6027\u6b32\u62a4\u76fe", "shieldIcon", PresetColour.GENERIC_SEX, "\u8d1e\u64cd", "\u8bf1\u60d1", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u53d7\u5230\u7684\u6027\u6b32\u4f24\u5bb3\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourLust(\u6027\u6b32\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 420;
            }
        };
        RESISTANCE_FIRE = new AbstractAttribute(false, 0, -100, 500, "fire shielding", "\u706b\u7130\u62a4\u76fe", "shieldIcon", PresetColour.DAMAGE_TYPE_FIRE, "\u963b\u71c3", "\u6613\u71c3", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u53d7\u5230\u7684\u706b\u7130\u4f24\u5bb3\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourFire(\u706b\u7130\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 430;
            }
        };
        RESISTANCE_ICE = new AbstractAttribute(false, 0, -100, 500, "cold shielding", "\u5bd2\u51b7\u62a4\u76fe", "shieldIcon", PresetColour.DAMAGE_TYPE_COLD, "\u6e29\u6696", "\u51bb\u4f24", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u53d7\u5230\u7684\u5bd2\u51b7\u4f24\u5bb3\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourIce(\u5bd2\u51b7\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 440;
            }
        };
        RESISTANCE_POISON = new AbstractAttribute(false, 0, -100, 500, "poison shielding", "\u6bd2\u7d20\u62a4\u76fe", "shieldIcon", PresetColour.DAMAGE_TYPE_POISON, "\u6297\u6bd2", "\u6613\u611f", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u964d\u4f4e\u53d7\u5230\u7684\u6bd2\u7d20\u4f24\u5bb3\u3002";
            }

            @Override
            public boolean isInfiniteAtUpperLimit() {
                return true;
            }

            @Override
            public String getInfiniteDescription() {
                return "[style.colourExcellent(\u514d\u75ab)][style.colourPoison(\u6bd2\u7d20\u4f24\u5bb3)]";
            }

            @Override
            public int getOrderPriority() {
                return 450;
            }
        };
        DAMAGE_ELDER_LILIN = new AbstractAttribute(true, 0, -100, 100, "elder lilin damage", "\u8389\u7433\u957f\u8001\u4f24\u5bb3", "swordIcon", PresetColour.RACE_LILIN, "\u8083\u6e05\u8389\u7433\u957f\u8001", "\u601c\u60af\u8389\u7433\u957f\u8001", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u5bf9\u6297\u8389\u7433\u957f\u8001\u7684\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 1000;
            }
        };
        DAMAGE_LILIN = new AbstractAttribute(true, 0, -100, 100, "lilin damage", "\u8389\u7433\u4f24\u5bb3", "swordIcon", PresetColour.RACE_LILIN, "\u8083\u6e05\u8389\u7433", "\u601c\u60af\u8389\u7433", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u5bf9\u6297\u8389\u7433\u7684\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 1100;
            }
        };
        DAMAGE_IMP = new AbstractAttribute(true, 0, -100, 100, "imp damage", "\u5c0f\u6076\u9b54\u4f24\u5bb3", "swordIcon", PresetColour.RACE_IMP, "\u8083\u6e05\u5c0f\u6076\u9b54", "\u601c\u60af\u5c0f\u6076\u9b54", null){

            @Override
            public String getDescription(GameCharacter owner) {
                return "\u63d0\u5347\u5bf9\u6297\u5c0f\u6076\u9b54\u7684\u4f24\u5bb3\u3002";
            }

            @Override
            public int getOrderPriority() {
                return 1200;
            }
        };
        attributeToIdMap = new HashMap<AbstractAttribute, String>();
        idToAttributeMap = new HashMap<String, AbstractAttribute>();
        racialAttributes = new HashMap<AbstractRace, AbstractAttribute>();
        oldConversionMapping = new HashMap<String, AbstractAttribute>();
        oldConversionMapping.put("CORRUPTION", MAJOR_CORRUPTION);
        oldConversionMapping.put("STRENGTH", MAJOR_PHYSIQUE);
        oldConversionMapping.put("MAJOR_STRENGTH", MAJOR_PHYSIQUE);
        oldConversionMapping.put("INTELLIGENCE", MAJOR_ARCANE);
        oldConversionMapping.put("RESISTANCE_ATTACK", RESISTANCE_PHYSICAL);
        oldConversionMapping.put("RESISTANCE_MANA", RESISTANCE_LUST);
        oldConversionMapping.put("RESISTANCE_PURE", ENERGY_SHIELDING);
        allAttributes = new ArrayList<AbstractAttribute>();
        for (Field f : fields = Attribute.class.getFields()) {
            if (!AbstractAttribute.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractAttribute attribute = (AbstractAttribute)f.get(null);
                attributeToIdMap.put(attribute, f.getName());
                idToAttributeMap.put(f.getName(), attribute);
                allAttributes.add(attribute);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

