/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CorruptionLevel {
    ZERO_PURE("\u7eaf\u6d01", 0, 10, PresetColour.CORRUPTION_STAGE_ZERO, 0.0f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_0;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            switch (action) {
                case ZERO_PURE: 
                case ONE_VANILLA: {
                    return true;
                }
                case TWO_HORNY: 
                case THREE_DIRTY: 
                case FOUR_LUSTFUL: 
                case FIVE_CORRUPT: {
                    return false;
                }
            }
            return false;
        }
    }
    ,
    ONE_VANILLA("\u5bfb\u5e38", 10, 30, PresetColour.CORRUPTION_STAGE_ONE, 0.1f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_1;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            switch (action) {
                case ZERO_PURE: 
                case ONE_VANILLA: 
                case TWO_HORNY: {
                    return true;
                }
                case THREE_DIRTY: 
                case FOUR_LUSTFUL: 
                case FIVE_CORRUPT: {
                    return false;
                }
            }
            return false;
        }
    }
    ,
    TWO_HORNY("\u5996\u5a9a", 30, 50, PresetColour.CORRUPTION_STAGE_TWO, 0.25f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_2;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            switch (action) {
                case ZERO_PURE: 
                case ONE_VANILLA: 
                case TWO_HORNY: 
                case THREE_DIRTY: {
                    return true;
                }
                case FOUR_LUSTFUL: 
                case FIVE_CORRUPT: {
                    return false;
                }
            }
            return false;
        }
    }
    ,
    THREE_DIRTY("\u80ae\u810f", 50, 70, PresetColour.CORRUPTION_STAGE_THREE, 0.5f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_3;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            switch (action) {
                case ZERO_PURE: 
                case ONE_VANILLA: 
                case TWO_HORNY: 
                case THREE_DIRTY: 
                case FOUR_LUSTFUL: {
                    return true;
                }
                case FIVE_CORRUPT: {
                    return false;
                }
            }
            return false;
        }
    }
    ,
    FOUR_LUSTFUL("\u6deb\u8361", 70, 90, PresetColour.CORRUPTION_STAGE_FOUR, 1.0f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_4;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            return true;
        }
    }
    ,
    FIVE_CORRUPT("\u5815\u843d", 90, 100, PresetColour.CORRUPTION_STAGE_FIVE, 2.0f){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.CORRUPTION_PERK_5;
        }

        @Override
        public boolean isAbleToPerformCorruptiveAction(CorruptionLevel action) {
            return true;
        }
    };

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;
    private float corruptionBypass;

    private CorruptionLevel(String name, int minimumValue, int maximumValue, Colour colour, float corruptionBypass) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
        this.corruptionBypass = corruptionBypass;
    }

    public abstract AbstractStatusEffect getRelatedStatusEffect();

    public abstract boolean isAbleToPerformCorruptiveAction(CorruptionLevel var1);

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public Colour getColour() {
        return this.colour;
    }

    public float getCorruptionBypass() {
        return this.corruptionBypass;
    }

    public static CorruptionLevel getCorruptionLevelFromValue(float value) {
        for (CorruptionLevel al : CorruptionLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_CORRUPT;
    }
}

