/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.attributes;

import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IntelligenceLevel {
    ZERO_AIRHEAD("\u5965\u672f\u624d\u758f", 0, 10, PresetColour.INTELLIGENCE_STAGE_ZERO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            if (Main.game.isInNewWorld()) {
                return StatusEffect.INTELLIGENCE_PERK_0;
            }
            return StatusEffect.INTELLIGENCE_PERK_0_OLD_WORLD;
        }
    }
    ,
    ONE_AVERAGE("\u5965\u672f\u6f5c\u80fd", 10, 30, PresetColour.INTELLIGENCE_STAGE_ONE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.INTELLIGENCE_PERK_1;
        }
    }
    ,
    TWO_SMART("\u5965\u672f\u7cbe\u901a", 30, 50, PresetColour.INTELLIGENCE_STAGE_TWO){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.INTELLIGENCE_PERK_2;
        }
    }
    ,
    THREE_BRAINY("\u8d85\u51e1\u5965\u672f", 50, 70, PresetColour.INTELLIGENCE_STAGE_THREE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.INTELLIGENCE_PERK_3;
        }
    }
    ,
    FOUR_GENIUS("\u5965\u672f\u5927\u5e08", 70, 90, PresetColour.INTELLIGENCE_STAGE_FOUR){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.INTELLIGENCE_PERK_4;
        }
    }
    ,
    FIVE_POLYMATH("\u5965\u672f\u4e4b\u5149", 90, 100, PresetColour.INTELLIGENCE_STAGE_FIVE){

        @Override
        public AbstractStatusEffect getRelatedStatusEffect() {
            return StatusEffect.INTELLIGENCE_PERK_5;
        }
    };

    private String name;
    private int minimumValue;
    private int maximumValue;
    private Colour colour;

    private IntelligenceLevel(String name, int minimumValue, int maximumValue, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public abstract AbstractStatusEffect getRelatedStatusEffect();

    public String getName() {
        return this.name;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static IntelligenceLevel getIntelligenceLevelFromValue(float value) {
        for (IntelligenceLevel al : IntelligenceLevel.values()) {
            if (!(value >= (float)al.getMinimumValue()) || !(value < (float)al.getMaximumValue())) continue;
            return al;
        }
        return FIVE_POLYMATH;
    }
}

