/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractArmType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.valueEnums.BodyHair;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class Arm
implements BodyPartInterface {
    public static final int MAXIMUM_ROWS = 3;
    protected AbstractArmType type;
    protected int armRows;
    protected BodyHair underarmHair;

    public Arm(AbstractArmType type, int armRows) {
        this.type = type;
        this.armRows = armRows;
        this.underarmHair = BodyHair.ZERO_NONE;
    }

    public Arm(Arm armToCopy) {
        this.type = armToCopy.type;
        this.armRows = armToCopy.armRows;
        this.underarmHair = armToCopy.underarmHair;
    }

    @Override
    public AbstractArmType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        ArrayList<String> descriptorList = new ArrayList<String>();
        descriptorList.add(this.type.getDescriptor(gc));
        descriptorList.add(this.type.getDescriptor(gc));
        descriptorList.add(Util.randomItemFrom(gc.getBodyShape().getLimbDescriptors()));
        return (String)Util.randomItemFrom(descriptorList);
    }

    public String setType(GameCharacter owner, AbstractArmType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u62e5\u6709\u4e86[npc.a_armRace]\u7684[npc.arms]\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (owner.isPlayer()) {
            sb.append("<p>\u4f60\u5ffd\u7136\u89c9\u5f97[pc.arms+]\u53c8\u70ed\u53c8\u75d2\uff0c\u4f60\u610f\u8bc6\u5230\u8f6c\u53d8\u5f00\u59cb\u4e86\uff0c\u4e8e\u662f\u4e0d\u7981\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002\u4f60\u7684\u5927\u81c2\u5f00\u59cb\u626d\u66f2\u53d8\u5f62\uff0c\u4f60\u53d1\u51fa\u4e00\u58f0\u75db\u53eb\uff0c\u5374\u65e0\u80fd\u4e3a\u529b\uff0c\u53ea\u5f97\u773c\u7741\u7741\u5730\u770b\u7740\u624b\u81c2\u8f6c\u5316\u6210\u4e86\u65b0\u7684\u5f62\u6001\u3002");
        } else {
            sb.append("<p>[npc.Name]\u611f\u5230[npc.she][npc.arms+]\u53d8\u5f97\u53c8\u70ed\u53c8\u75d2\uff0c\u987f\u65f6\u624b\u8db3\u65e0\u63aa\uff0c[npc.she]\u610f\u8bc6\u5230\u8f6c\u53d8\u5f00\u59cb\u4e86\uff0c\u4e8e\u662f\u4e0d\u7981\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002[npc.her]\u7684\u5927\u81c2\u5f00\u59cb\u626d\u66f2\u53d8\u5f62\uff0c[npc.she]\u53d1\u51fa\u4e00\u58f0\u75db\u53eb\uff0c\u5374\u65e0\u80fd\u4e3a\u529b\uff0c\u53ea\u5f97\u773c\u7741\u7741\u5730\u770b\u7740\u624b\u81c2\u8f6c\u5316\u6210\u4e86\u65b0\u7684\u5f62\u6001\u3002");
        }
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        sb.append(type.getTransformationDescription(owner) + "</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getArmRows() {
        return this.armRows;
    }

    public String setArmRows(GameCharacter owner, int armRows) {
        if (!Main.game.isStarted() || owner == null) {
            this.armRows = armRows = Math.max(1, Math.min(armRows, 3));
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        int currentArmRows = this.getArmRows();
        if ((armRows = Math.max(1, Math.min(armRows, 3))) == currentArmRows) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        StringBuilder sb = new StringBuilder();
        if (armRows < currentArmRows) {
            boolean losesTwoPairs;
            boolean bl = losesTwoPairs = armRows + 2 == currentArmRows;
            if (owner.isPlayer()) {
                sb.append("<p>\u4f60\u611f\u89c9\u5230\u4e00\u9635\u5947\u5999\u7684\u538b\u529b\uff0c\u51fa\u73b0\u5728" + (losesTwoPairs ? "\u4f60\u989d\u5916\u7684\u4e24\u5bf9" : (armRows == 2 ? "\u6700\u4e0b\u65b9\u7684\u4e00\u5bf9" : "\u4f60\u989d\u5916\u7684\u90a3\u5bf9")) + "[pc.arms]\u7684\u57fa\u90e8\uff0c\u8fd8\u6ca1\u7b49\u4f60\u53cd\u5e94\u8fc7\u6765\uff0c\u8fd9\u4e9b\u624b\u81c2\u4fbf\u5feb\u901f\u6f5c\u5165\u4e86\u4f60\u8eaf\u5e72\u7684[pc.skin]\u4e4b\u4e0b\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709[style.boldTfLesser(" + Util.intToString(armRows) + "\u5bf9[pc.arms])]\uff0c[pc.materialDescriptor][pc.armFullDescriptionColour]\u3002</p>");
            } else {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u62c5\u5fc3\u5730\u4f4e\u5934\u7784\u5411" + (losesTwoPairs ? "[npc.her]\u989d\u5916\u7684\u4e24\u5bf9" : (armRows == 2 ? "[npc.her]\u6700\u4e0b\u65b9\u7684\u4e00\u5bf9" : "[npc.her]\u989d\u5916\u7684\u90a3\u5bf9")) + "[npc.arms]\uff0c\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c\u8fd9\u4e9b\u624b\u81c2\u4fbf\u5feb\u901f\u6f5c\u5165\u4e86\u8eaf\u5e72\u7684[npc.skin]\u4e4b\u4e0b\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfLesser(" + Util.intToString(armRows) + "\u5bf9[npc.arms])]\uff0c[npc.materialDescriptor][npc.armFullDescriptionColour]\u3002</p>", new ParserTag[0]));
            }
        } else {
            boolean gainsTwoPairs;
            boolean bl = gainsTwoPairs = armRows - 2 == currentArmRows;
            if (owner.isPlayer()) {
                sb.append("<p>\u4f60\u611f\u89c9\u5230\u4e00\u9635\u5947\u5999\u7684\u538b\u529b\uff0c\u51fa\u73b0\u5728\u4f60\u7684\u8eaf\u5e72\u4e24\u4fa7\uff0c\u8fd8\u6ca1\u7b49\u4f60\u53cd\u5e94\u8fc7\u6765\uff0c" + (gainsTwoPairs ? "\u989d\u5916\u7684\u4e24\u5bf9" : "\u989d\u5916\u7684\u4e00\u5bf9") + "[pc.arms]\u4fbf\u8fc5\u901f\u4ece\u8eaf\u5e72\u504f\u4e0b\u90e8\u5206\u7684[pc.skin]\u4e2d\u751f\u957f\u4e86\u51fa\u6765\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709[style.boldTfLesser(" + Util.intToString(armRows) + "\u5bf9[pc.arms])]\uff0c[pc.materialDescriptor][pc.armFullDescriptionColour]\u3002</p>");
            } else {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u62c5\u5fc3\u5730\u63d0\u90fd\u7784\u5411[npc.her]\u7684\u8eaf\u5e72\uff0c\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c" + (gainsTwoPairs ? "\u989d\u5916\u7684\u4e24\u5bf9" : "\u989d\u5916\u7684\u4e00\u5bf9") + "[npc.arms]\u4fbf\u8fc5\u901f\u4ece\u8eaf\u5e72\u504f\u4e0b\u90e8\u5206\u7684[npc.skin]\u4e2d\u751f\u957f\u4e86\u51fa\u6765\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldTfLesser(" + Util.intToString(armRows) + "\u5bf9[npc.arms])]\uff0c[npc.materialDescriptor][npc.armFullDescriptionColour]\u3002</p>", new ParserTag[0]));
            }
        }
        this.armRows = armRows;
        sb.append(UtilText.parse(owner, "<p>" + owner.postTransformationCalculation() + "</p>", new ParserTag[0]));
        return sb.toString();
    }

    public BodyHair getUnderarmHair() {
        return this.underarmHair;
    }

    public Covering getUnderarmHairType(GameCharacter owner) {
        return owner.getCovering(owner.getBodyHairCoveringType(owner.getArmType().getRace()));
    }

    public String setUnderarmHair(GameCharacter owner, BodyHair underarmHair) {
        if (owner == null) {
            this.underarmHair = underarmHair;
            return "";
        }
        if (!this.getType().isUnderarmHairAllowed()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.namePos]\u7684\u624b\u81c2\u7c7b\u578b\u4e0d\u5141\u8bb8[npc.herHim]\u751f\u957f\u4efb\u4f55\u814b\u4e0b\u6bdb\u53d1\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (this.getUnderarmHair() == underarmHair) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        StringBuilder sb = new StringBuilder();
        switch (underarmHair) {
            case ZERO_NONE: {
                sb.append(UtilText.parse(owner, "<p>[npc.her]\u7684\u814b\u4e0b\u5df2\u7ecf\u6ca1\u6709\u4e86" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u7684\u8e2a\u8ff9\u3002</p>", new ParserTag[0]));
                break;
            }
            case ONE_STUBBLE: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u5c0f\u7247\u77ed\u832c\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case TWO_MANICURED: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u5c0f\u7247\u9f50\u6574\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case THREE_TRIMMED: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u5c0f\u7247\u4fee\u526a\u8fc7\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case FOUR_NATURAL: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u81ea\u7136\u751f\u957f\u7740\u4e00\u7247" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case FIVE_UNKEMPT: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u7247\u51cc\u4e71\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case SIX_BUSHY: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u7247\u539a\u5b9e\u6d53\u5bc6\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case SEVEN_WILD: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u814b\u4e0b\u73b0\u5728\u6709\u4e00\u5927\u7247\u91ce\u86ee\u751f\u957f\u7684" + this.getUnderarmHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
            }
        }
        this.underarmHair = underarmHair;
        return sb.toString();
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Arm.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

