/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractEyeType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.EyeShape;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;

public class Eye
implements BodyPartInterface {
    public static final int MAXIMUM_PAIRS = 4;
    protected AbstractEyeType type;
    protected int eyePairs;
    protected EyeShape irisShape;
    protected EyeShape pupilShape;

    public Eye(AbstractEyeType type) {
        this.type = type;
        this.eyePairs = type.getDefaultPairCount();
        this.irisShape = type.getDefaultIrisShape();
        this.pupilShape = type.getDefaultPupilShape();
    }

    public Eye(Eye eyeToCopy) {
        this.type = eyeToCopy.type;
        this.eyePairs = eyeToCopy.eyePairs;
        this.irisShape = eyeToCopy.irisShape;
        this.pupilShape = eyeToCopy.pupilShape;
    }

    @Override
    public AbstractEyeType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public String setType(GameCharacter owner, AbstractEyeType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            this.irisShape = type.getDefaultIrisShape();
            this.pupilShape = type.getDefaultPupilShape();
            if (owner != null) {
                owner.resetAreaKnownByCharacters(CoverableArea.EYES);
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_eyeRace]\u7684[npc.eyes]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        if (owner.isArmMovementHindered()) {
            sb.append("[npc.NamePos]\u7684[npc.eyes]\u7a81\u7136\u53d8\u5f97\u53c8\u70ed\u53c8\u75d2\uff0c\u4f7f[npc.herHim]\u672c\u80fd\u5730\u95ed\u7d27\u53cc\u773c\u3002");
        } else {
            sb.append("[npc.NamePos]\u7684[npc.eyes]\u7a81\u7136\u53d8\u5f97\u53c8\u70ed\u53c8\u75d2\uff0c\u4f7f[npc.she]\u672c\u80fd\u5730\u95ed\u7d27\u53cc\u773c\uff0c\u4f38\u624b\u53bb\u63c9\u3002");
        }
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        this.irisShape = type.getDefaultIrisShape();
        this.pupilShape = type.getDefaultPupilShape();
        owner.resetAreaKnownByCharacters(CoverableArea.EYES);
        sb.append(type.getTransformationDescription(owner));
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getEyePairs() {
        return this.eyePairs;
    }

    public String setEyePairs(GameCharacter owner, int eyePairs) {
        eyePairs = Math.max(1, Math.min(eyePairs, 4));
        if (owner.getEyePairs() == eyePairs) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        boolean removingExtraEyes = owner.getEyePairs() > eyePairs;
        this.eyePairs = eyePairs;
        if (removingExtraEyes) {
            return UtilText.parse(owner, "<p>\u523a\u75db\u611f\u904d\u5e03[npc.namePos]\u7684[npc.face]\uff0c\u968f\u540e\u8f6c\u79fb\u96c6\u4e2d\u5728[npc.her]\u7684[npc.eyes]\u4e0a\u3002[npc.She]\u731b\u5730\u5408\u773c\uff0c\u4e0b\u610f\u8bc6\u558a\u53eb\u51fa\u58f0\uff0c\u540c\u65f6\u611f\u89c9\u5230\u6709\u4e9b[style.boldShrink(\u6d88\u5931)]\u8fdb\u4e86[npc.her]\u4e3b\u773c\u4e0b\u7684[npc.faceSkin]\u76ae\u80a4\u91cc\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u7684\u8138\u4e0a\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_eyes])]\u3002</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u523a\u75db\u611f\u904d\u5e03[npc.namePos]\u7684[npc.face]\uff0c\u968f\u540e\u8f6c\u79fb\u96c6\u4e2d\u5728[npc.her]\u7684[npc.eyes]\u4e0a\u3002[npc.She]\u731b\u5730\u5408\u773c\uff0c\u4e0b\u610f\u8bc6\u558a\u53eb\u51fa\u58f0\uff0c\u4e00\u80a1\u4ee4\u4eba\u4e0d\u5b89\u7684\u611f\u89c9\u8513\u5ef6\u5728[npc.her]\u4e3b\u773c\u4e0b\u7684[npc.faceSkin]\u5904\uff0c\u4e5f\u5c31\u662f\u65b0[npc.eyes][style.boldGrow(\u957f\u51fa)]\u7684\u5730\u65b9\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u7684\u8138\u4e0a\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_eyes])]\u3002</p>", new ParserTag[0]);
    }

    public EyeShape getIrisShape() {
        return this.irisShape;
    }

    public String setIrisShape(GameCharacter owner, EyeShape irisShape) {
        if (owner == null) {
            this.irisShape = irisShape;
            return "";
        }
        if (owner.getIrisShape() == irisShape) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.irisShape = irisShape;
        return UtilText.parse(owner, "<p>[npc.namePos]\u7684[npc.eyes]\u5468\u56f4\u7a81\u7136\u7619\u75d2\u96be\u8010\uff0c\u4f46\u611f\u89c9\u5f88\u5feb\u5c31\u8fc7\u53bb\u4e86\uff0c[npc.she]\u751a\u81f3\u6765\u4e0d\u53ca\u4f38\u624b\u63c9\u63c9\u3002<br/>[npc.Name]\u73b0\u5728\u5df2\u6709[style.boldTfGeneric([npc.irisShape]\u7684\u77b3\u5b54)]\uff01</p>", new ParserTag[0]);
    }

    public EyeShape getPupilShape() {
        return this.pupilShape;
    }

    public String setPupilShape(GameCharacter owner, EyeShape pupilShape) {
        if (owner == null) {
            this.pupilShape = pupilShape;
            return "";
        }
        if (owner.getPupilShape() == pupilShape) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.pupilShape = pupilShape;
        return UtilText.parse(owner, "<p>[npc.namePos]\u7684[npc.eyes]\u5468\u56f4\u7a81\u7136\u7619\u75d2\u96be\u8010\uff0c\u4f46\u611f\u89c9\u5f88\u5feb\u5c31\u8fc7\u53bb\u4e86\uff0c[npc.she]\u751a\u81f3\u6765\u4e0d\u53ca\u4f38\u624b\u63c9\u63c9\u3002<br/>[npc.Name]\u73b0\u5728\u5df2\u6709[style.boldTfGeneric([npc.pupilShape]\u7684\u77b3\u5b54)]\uff01</p>", new ParserTag[0]);
    }

    public String setEyeCovering(GameCharacter owner, Covering covering) {
        if (owner.getCovering(owner.getEyeCovering()).equals(covering) || owner.getCovering(BodyCoveringType.EYE_PUPILS).equals(covering) || owner.getCovering(BodyCoveringType.EYE_SCLERA).equals(covering)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        StringBuilder sb = new StringBuilder();
        owner.getBody().getCoverings().put(covering.getType(), covering);
        sb.append("<p>[npc.NamePos]\u7684\u89c6\u7ebf\u77ac\u95f4\u6a21\u7cca\uff0c\u7728\u4e86\u597d\u51e0\u4e0b\u773c\u540e\uff0c[npc.her]\u7684[npc.eyes]\u7a81\u7136\u53d1\u73b0\u8f6c\u53d8\uff0c\u8fde\u989c\u8272\u90fd\u6539\u53d8\u4e86\u3002<br/>[npc.She]\u73b0\u5df2\u62e5\u6709");
        if (covering.getPattern() == CoveringPattern.EYE_IRISES_HETEROCHROMATIC) {
            sb.append("\u5f02\u8272\u7684[npc.irisPrimaryColour(true)]\u548c[npc.irisSecondaryColour(true)][npc.irisShape]\u7684\u8679\u819c\uff0c");
        } else {
            sb.append("[npc.irisPrimaryColour(true)][npc.irisShape]\u7684\u8679\u819c");
        }
        if (covering.getPattern() == CoveringPattern.EYE_PUPILS_HETEROCHROMATIC) {
            sb.append("\u6709\u7740[npc.pupilPrimaryColour(true)]\u548c[npc.pupilSecondaryColour(true)][npc.pupilShape]\u5f02\u8272\u77b3\u5b54");
        } else {
            sb.append("\u6709\u7740[npc.pupilPrimaryColour(true)][npc.pupilShape]\u7684\u77b3\u5b54");
        }
        if (covering.getPattern() == CoveringPattern.EYE_SCLERA_HETEROCHROMATIC) {
            sb.append("\u548c\u5f02\u8272[npc.scleraPrimaryColour(true)]\u548c[npc.scleraSecondaryColour(true)]\u5de9\u819c\u3002</p>");
        } else {
            sb.append("\u4ee5\u53ca[npc.scleraPrimaryColour(true)]\u5de9\u819c\u3002</p>");
        }
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Eye.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

