/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.Mouth;
import com.lilithsthrone.game.character.body.Tongue;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFaceType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.valueEnums.BodyHair;
import com.lilithsthrone.game.character.body.valueEnums.Capacity;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.OrificeDepth;
import com.lilithsthrone.game.character.body.valueEnums.OrificeElasticity;
import com.lilithsthrone.game.character.body.valueEnums.OrificePlasticity;
import com.lilithsthrone.game.character.body.valueEnums.Wetness;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.main.Main;
import java.util.List;

public class Face
implements BodyPartInterface {
    protected AbstractFaceType type;
    protected boolean piercedNose;
    protected BodyHair facialHair;
    protected Mouth mouth;
    protected Tongue tongue;

    public Face(AbstractFaceType type, int lipSize) {
        this.type = type;
        this.piercedNose = false;
        this.facialHair = BodyHair.ZERO_NONE;
        this.mouth = new Mouth(type.getMouthType(), lipSize, Wetness.THREE_WET.getValue(), Capacity.THREE_SLIGHTLY_LOOSE.getMedianValue(), OrificeDepth.TWO_AVERAGE.getValue(), OrificeElasticity.FOUR_LIMBER.getValue(), OrificePlasticity.THREE_RESILIENT.getValue(), true);
        this.tongue = new Tongue(type.getMouthType().getTongueType());
    }

    public Face(Face faceToCopy) {
        this.type = faceToCopy.type;
        this.piercedNose = faceToCopy.piercedNose;
        this.facialHair = faceToCopy.facialHair;
        this.mouth = new Mouth(faceToCopy.mouth);
        this.tongue = new Tongue(faceToCopy.tongue);
    }

    public Mouth getMouth() {
        return this.mouth;
    }

    public Tongue getTongue() {
        return this.tongue;
    }

    @Override
    public AbstractFaceType getType() {
        return this.type;
    }

    public List<BodyPartTag> getTypeTags() {
        return this.type.getTags();
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter owner) {
        return this.type.getDescriptor(owner);
    }

    public String getNoseNameSingular(GameCharacter gc) {
        return this.type.getNoseNameSingular(gc);
    }

    public String getNoseNamePlural(GameCharacter gc) {
        return this.type.getNoseNamePlural(gc);
    }

    public String getNoseDescriptor(GameCharacter gc) {
        return this.type.getNoseDescriptor(gc);
    }

    public String setType(GameCharacter owner, AbstractFaceType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            this.mouth.setType(type.getMouthType());
            this.tongue.setType(type.getMouthType().getTongueType());
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_faceRace]\u7684[npc.face]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("\u4e00\u79cd\u5f3a\u70c8\u7684\u523a\u75db\u611f\u7a81\u7136\u63a0\u8fc7[npc.namePos]\u7684[npc.face]\uff0c\u5728\u610f\u8bc6\u5230\u8f6c\u5316\u7684\u53d1\u751f\u65f6\uff0c[npc.she]\u77aa\u5927\u4e86\u53cc\u773c\u3002\u968f\u7740\u4e00\u58f0\u6e05\u8106\u7684\u54cd\u58f0\uff0c[npc.her]\u7684\u9762\u90e8\u9aa8\u9abc\u5f00\u59cb\u91cd\u7ec4\uff0c\u867d\u7136\u8fd9\u79cd\u611f\u89c9\u5e76\u4e0d\u75db\u82e6\uff0c\u4f46\u8db3\u4ee5\u8ba9[npc.herHim]\u4e0d\u7531\u81ea\u4e3b\u5730\u60ca\u53eb\u4e86\u4e00\u58f0");
        String s = UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        sb.setLength(0);
        sb.append(s);
        this.type = type;
        this.mouth.setType(type.getMouthType());
        this.tongue.setType(type.getMouthType().getTongueType());
        sb.append(type.getTransformationDescription(owner));
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<br/><br/>" + owner.postTransformationCalculation() + "</p>";
    }

    public boolean isPiercedNose() {
        return this.piercedNose;
    }

    public String setPiercedNose(GameCharacter owner, boolean piercedNose) {
        if (owner.isPiercedNose() == piercedNose) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.piercedNose = piercedNose;
        if (piercedNose) {
            return UtilText.parse(owner, "<p>[npc.NamePos]\u7684[npc.nose]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>", new ParserTag[0]);
        }
        AbstractClothing c = owner.getClothingInSlot(InventorySlot.PIERCING_NOSE);
        String piercingUnequip = "";
        if (c != null) {
            owner.forceUnequipClothingIntoVoid(owner, c);
            piercingUnequip = owner.addClothing(c, false);
        }
        return UtilText.parse(owner, "<p>[npc.NamePos]\u7684[npc.nose][style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip, new ParserTag[0]);
    }

    public BodyHair getFacialHair() {
        return this.facialHair;
    }

    public Covering getFacialHairType(GameCharacter owner) {
        return owner.getCovering(owner.getBodyHairCoveringType(owner.getFaceType().getRace()));
    }

    public String setFacialHair(GameCharacter owner, BodyHair facialHair) {
        if (owner == null) {
            this.facialHair = facialHair;
            return "";
        }
        if (!this.getType().isFacialHairAllowed()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos]\u7684\u8138\u578b\u4f7f[npc.herHim]\u65e0\u6cd5\u957f\u51fa\u80e1\u987b\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (owner.getFemininityValue() >= Femininity.ANDROGYNOUS.getMinimumFemininity() && facialHair != BodyHair.ZERO_NONE && !Main.getProperties().hasValue(PropertyValue.feminineBeardsContent)) {
            if (owner.isPlayer()) {
                return "<p style='text-align:center;'>[style.colourDisabled(\u4f60\u592a\u8fc7\u5973\u6027\u5316\uff0c\u65e0\u6cd5\u957f\u51fa\u80e1\u5b50\u2026\u2026)]</p>";
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.sheIs]\u592a\u8fc7\u5973\u6027\u5316\uff0c\u65e0\u6cd5\u957f\u51fa\u80e1\u5b50\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (this.getFacialHair() == facialHair) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        StringBuilder sb = new StringBuilder();
        switch (facialHair) {
            case ZERO_NONE: {
                sb.append(UtilText.parse(owner, "<p>[npc.her]\u7684\u9762\u90e8\u4e0a\u4e0d\u518d\u6709" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u7684\u75d5\u8ff9\u3002</p>", new ParserTag[0]));
                break;
            }
            case ONE_STUBBLE: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u4e86\u77ed\u800c\u7c97\u7684" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case TWO_MANICURED: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u4e86\u5c11\u91cf\u7684" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case THREE_TRIMMED: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u4e86\u4fee\u526a\u6574\u9f50\u7684" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case FOUR_NATURAL: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u7740\u80e1\u987b\uff0c\u5916\u89c2\u4f3c" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case FIVE_UNKEMPT: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u7740\u84ec\u4e71\u6d53\u5bc6\u7684\u80e1\u987b\uff0c\u5916\u89c2\u4f3c" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case SIX_BUSHY: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u7740\u5927\u800c\u6d53\u5bc6\u7684\u80e1\u987b\uff0c\u5916\u89c2\u4f3c" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
                break;
            }
            case SEVEN_WILD: {
                sb.append(UtilText.parse(owner, "<p>[npc.Name]\u7684\u8138\u4e0a\u73b0\u5728\u6709\u7740\u6d53\u5bc6\u4e14\u6beb\u65e0\u4fee\u9970\u7684\u5927\u80e1\u5b50\uff0c\u5916\u89c2\u4f3c" + this.getFacialHairType(owner).getFullDescription(owner, true) + "\u3002</p>", new ParserTag[0]));
            }
        }
        this.facialHair = facialHair;
        return sb.toString();
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Face.class) && this.getType().getRace().isFeralPartsAvailable();
    }

    public boolean isBaldnessNatural() {
        return this.getTypeTags().contains((Object)BodyPartTag.FACE_NATURAL_BALDNESS_AVIAN) || this.getTypeTags().contains((Object)BodyPartTag.FACE_NATURAL_BALDNESS_FURRY) || this.getTypeTags().contains((Object)BodyPartTag.FACE_NATURAL_BALDNESS_SCALY) || this.getTypeTags().contains((Object)BodyPartTag.FACE_NATURAL_BALDNESS_SKIN);
    }

    public boolean isMuzzle() {
        return this.getTypeTags().contains((Object)BodyPartTag.FACE_MUZZLE);
    }

    public boolean isHasFangs() {
        return this.getTypeTags().contains((Object)BodyPartTag.FACE_FANGS);
    }

    public boolean isBeak() {
        return this.getTypeTags().contains((Object)BodyPartTag.FACE_BEAK);
    }

    public boolean isSharkTeeth() {
        return this.getTypeTags().contains((Object)BodyPartTag.FACE_SHARK_TEETH);
    }
}

