/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.FluidInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.valueEnums.FluidFlavour;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FluidMilk
implements FluidInterface {
    protected AbstractFluidType type;
    protected FluidFlavour flavour;
    protected Set<FluidModifier> fluidModifiers;
    protected List<ItemEffect> transformativeEffects;
    protected boolean crotchMilk;

    public FluidMilk(AbstractFluidType type, boolean crotchMilk) {
        this.type = type;
        this.flavour = type.getFlavour();
        this.transformativeEffects = new ArrayList<ItemEffect>();
        this.fluidModifiers = new HashSet<FluidModifier>();
        this.fluidModifiers.addAll(type.getDefaultFluidModifiers());
        this.crotchMilk = crotchMilk;
    }

    public FluidMilk(FluidMilk milkToCopy) {
        this.type = milkToCopy.type;
        this.flavour = milkToCopy.flavour;
        this.fluidModifiers = new HashSet<FluidModifier>(milkToCopy.fluidModifiers);
        this.transformativeEffects = new ArrayList<ItemEffect>(milkToCopy.transformativeEffects);
        this.crotchMilk = milkToCopy.crotchMilk;
    }

    public Element saveAsXML(String rootElementName, Element parentElement, Document doc) {
        Element element = doc.createElement(rootElementName);
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "type", FluidType.getIdFromFluidType(this.type));
        XMLUtil.addAttribute(doc, element, "flavour", this.flavour.toString());
        for (FluidModifier fm : this.getFluidModifiers()) {
            Element mod = doc.createElement("mod");
            mod.setTextContent(fm.toString());
            element.appendChild(mod);
        }
        return element;
    }

    public static FluidMilk loadFromXML(String rootElementName, Element parentElement, Document doc) {
        return FluidMilk.loadFromXML(rootElementName, parentElement, doc, null, false);
    }

    public static FluidMilk loadFromXML(String rootElementName, Element parentElement, Document doc, AbstractFluidType baseType, boolean crotchMilk) {
        Element milk = (Element)parentElement.getElementsByTagName(rootElementName).item(0);
        AbstractFluidType fluidType = FluidType.MILK_HUMAN;
        if (baseType != null) {
            fluidType = baseType;
        } else {
            try {
                fluidType = FluidType.getFluidTypeFromId(milk.getAttribute("type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FluidMilk fluidMilk = new FluidMilk(fluidType, crotchMilk);
        String flavourId = milk.getAttribute("flavour");
        fluidMilk.flavour = flavourId.equalsIgnoreCase("SLIME") ? FluidFlavour.BUBBLEGUM : FluidFlavour.valueOf(flavourId);
        Element milkModifiersElement = (Element)milk.getElementsByTagName("milkModifiers").item(0);
        fluidMilk.fluidModifiers.clear();
        if (milkModifiersElement != null) {
            if (milkModifiersElement != null) {
                Set<FluidModifier> milkFluidModifiers = fluidMilk.fluidModifiers;
                Body.handleLoadingOfModifiers((Enum[])FluidModifier.values(), null, (Element)milkModifiersElement, milkFluidModifiers);
            }
        } else {
            NodeList mods = milk.getElementsByTagName("mod");
            for (int i = 0; i < mods.getLength(); ++i) {
                Element e = (Element)mods.item(i);
                fluidMilk.fluidModifiers.add(FluidModifier.valueOf(e.getTextContent()));
            }
        }
        return fluidMilk;
    }

    public boolean equals(Object o) {
        return o instanceof FluidMilk && ((FluidMilk)o).getType().equals(this.getType()) && ((FluidMilk)o).getFlavour() == this.getFlavour() && ((FluidMilk)o).getFluidModifiers().equals(this.getFluidModifiers()) && ((FluidMilk)o).getTransformativeEffects().equals(this.getTransformativeEffects());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.getFlavour().hashCode();
        result = 31 * result + this.getFluidModifiers().hashCode();
        result = 31 * result + this.getTransformativeEffects().hashCode();
        return result;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        String modifierDescriptor = "";
        if (!this.fluidModifiers.isEmpty()) {
            modifierDescriptor = new ArrayList<FluidModifier>(this.fluidModifiers).get(Util.random.nextInt(this.fluidModifiers.size())).getName();
        }
        return UtilText.returnStringAtRandom(modifierDescriptor, this.flavour.getRandomFlavourDescriptor(), this.type.getDescriptor(gc));
    }

    @Override
    public AbstractFluidType getType() {
        return this.type;
    }

    public void setType(AbstractFluidType type) {
        this.type = type;
    }

    @Override
    public FluidFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public String setFlavour(GameCharacter owner, FluidFlavour flavour) {
        if (owner == null) {
            this.flavour = flavour;
            return "";
        }
        if (this.flavour == flavour) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.flavour = flavour;
        if (this.isCrotchMilk()) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u5411\u4e0b\u8513\u5ef6\u5230[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\uff0c\u4ee4[npc.herHim]\u4e0d\u7531\u81ea\u4e3b\u5730\u53d1\u51fa[npc.moan]\u58f0\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]" + (flavour == FluidFlavour.FLAVOURLESS ? "\u73b0\u5728\u662f<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>" : "\u73b0\u5728\u5c1d\u8d77\u6765\u50cf<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>\u3002") + "</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u8513\u5ef6\u5230[npc.namePos]\u7684[npc.breasts]\u4e2d\uff0c\u4ee4[npc.herHim]\u4e0d\u7531\u81ea\u4e3b\u5730\u53d1\u51fa[npc.moan]\u58f0\u3002<br/>[npc.NamePos]\u7684[npc.milk]" + (flavour == FluidFlavour.FLAVOURLESS ? "\u73b0\u5728\u662f<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>" : "\u73b0\u5728\u5c1d\u8d77\u6765\u50cf<b style='color:" + flavour.getColour().toWebHexString() + ";'>" + flavour.getName() + "</b>\u3002") + "</p>", new ParserTag[0]);
    }

    @Override
    public boolean hasFluidModifier(FluidModifier fluidModifier) {
        return this.fluidModifiers.contains((Object)fluidModifier);
    }

    @Override
    public String addFluidModifier(GameCharacter owner, FluidModifier fluidModifier) {
        if (this.fluidModifiers.contains((Object)fluidModifier)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.fluidModifiers.add(fluidModifier);
        if (owner == null) {
            return "";
        }
        switch (fluidModifier) {
            case ADDICTIVE: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8e81\u52a8\u7684\u70ed\u6d41\u6df1\u5165\u4e86[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0b\u610f\u8bc6\u5730\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u6210\u763e\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8e81\u52a8\u7684\u70ed\u6d41\u6df1\u5165\u4e86[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0b\u610f\u8bc6\u5730\u53d1\u51fa\u4e00\u58f0[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u6210\u763e\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC: {
                this.fluidModifiers.remove((Object)FluidModifier.ALCOHOLIC_WEAK);
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9ad8\u5ea6\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9ad8\u5ea6\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC_WEAK: {
                this.fluidModifiers.remove((Object)FluidModifier.ALCOHOLIC);
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u542b\u9152\u7cbe\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case BUBBLING: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u8f7b\u5fae\u7684\u6c14\u6ce1\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u8d77\u6ce1\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8f7b\u5fae\u7684\u6c14\u6ce1\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u8d77\u6ce1\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case HALLUCINOGENIC: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u5947\u5999\u7684\u640f\u52a8\u611f\u76f4\u51b2[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u81f4\u5e7b\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u5947\u5999\u7684\u640f\u52a8\u611f\u76f4\u51b2[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u81f4\u5e7b\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case MINERAL_OIL: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u5145\u6ee1\u4e86[style.boldGrow(\u77ff\u7269\u6cb9)]\uff0c\u53ef\u4ee5\u878d\u5316\u907f\u5b55\u5957\u4e86\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u5145\u6ee1\u4e86[style.boldGrow(\u77ff\u7269\u6cb9)]\uff0c\u53ef\u4ee5\u878d\u5316\u907f\u5b55\u5957\u4e86\uff01</p>", new ParserTag[0]);
            }
            case MUSKY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u7f13\u6162\u8815\u52a8\u7684\u6696\u610f\u4ece[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u9e9d\u9999\u5473\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u7f13\u6162\u8815\u52a8\u7684\u6696\u610f\u4ece[npc.namePos]\u7684[npc.breasts]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u9e9d\u9999\u5473\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case SLIMY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u6ed1\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u5999\u800c\u8212\u7f13\u7684\u6696\u6d41\u6c81\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u6ed1\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case STICKY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u539a\u91cd\u7684\u6696\u6d41\u6d41\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u9ecf\u7cca\u7cca\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u539a\u91cd\u7684\u6696\u6d41\u6d41\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u9ecf\u7cca\u7cca\u7684)]\uff01</p>", new ParserTag[0]);
            }
            case VISCOUS: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5f3a\u70c8\u7684\u70ed\u6d41\u7f13\u7f13\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u7a20\u7684)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5f3a\u70c8\u7684\u70ed\u6d41\u7f13\u7f13\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa[npc.a_moan+]\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728\u662f[style.boldGrow(\u7c98\u7a20\u7684)]\uff01</p>", new ParserTag[0]);
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    @Override
    public String removeFluidModifier(GameCharacter owner, FluidModifier fluidModifier) {
        if (!this.fluidModifiers.contains((Object)fluidModifier)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.fluidModifiers.remove((Object)fluidModifier);
        if (owner == null) {
            return "";
        }
        switch (fluidModifier) {
            case ADDICTIVE: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u6210\u763e\u6027)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u6210\u763e\u6027)]\uff01</p>", new ParserTag[0]);
            }
            case ALCOHOLIC: 
            case ALCOHOLIC_WEAK: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u542b\u9152\u7cbe)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u8513\u5ef6\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u542b\u9152\u7cbe)]\uff01</p>", new ParserTag[0]);
            }
            case BUBBLING: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5e73\u9759\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u8d77\u6ce1)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5e73\u9759\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u51fa\u73b0\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u8d77\u6ce1)]\uff01</p>", new ParserTag[0]);
            }
            case HALLUCINOGENIC: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u8212\u7f13\u7684\u6d6a\u6f6e\u6d8c\u5411[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u81f4\u5e7b\u6027)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u8fde\u4e32\u8212\u7f13\u7684\u6d6a\u6f6e\u6d8c\u4e0a[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u6709\u81f4\u5e7b\u6027)]\uff01</p>", new ParserTag[0]);
            }
            case MUSKY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u5145\u6ee1\u6deb\u5473)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u5145\u6ee1\u6deb\u5473)]\uff01</p>", new ParserTag[0]);
            }
            case SLIMY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u6d41\u5165[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u9ecf\u6ed1)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u723d\u611f\u6d41\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u7c98\u6ed1)]\uff01</p>", new ParserTag[0]);
            }
            case STICKY: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u6696\u6c81\u5165\u4e86[npc.namePos]\u7684[npc.crotchBoobs]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u9ecf\u7cca\u7cca)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u6696\u6c81\u5165\u4e86[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u9ecf\u7cca\u7cca)]\uff01</p>", new ParserTag[0]);
            }
            case VISCOUS: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.crotchBoobs]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u7c98\u7a20)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u5fae\u51c9\u611f\u5728[npc.namePos]\u7684[npc.breasts]\u4e2d\u5347\u817e\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u7c98\u7a20)]\uff01</p>", new ParserTag[0]);
            }
            case MINERAL_OIL: {
                if (this.isCrotchMilk()) {
                    return UtilText.parse(owner, "<p>\u4e00\u80a1\u77ed\u6682\u7684\u91ca\u653e\u611f\u6d41\u5165[npc.namePos]\u7684[npc.crotchBoobs],\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.crotchMilk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u542b\u77ff\u7269\u6cb9)]\uff01</p>", new ParserTag[0]);
                }
                return UtilText.parse(owner, "<p>\u4e00\u80a1\u77ed\u6682\u7684\u91ca\u653e\u611f\u6d41\u5165[npc.namePos]\u7684[npc.breasts]\uff0c\u8ba9[npc.herHim]\u4e0d\u7981\u53d1\u51fa\u4e00\u58f0\u8f7b\u53f9\u3002<br/>[npc.NamePos]\u7684[npc.milk]\u73b0\u5728[style.boldShrink(\u4e0d\u518d\u542b\u77ff\u7269\u6cb9)]\uff01</p>", new ParserTag[0]);
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    @Override
    public List<ItemEffect> getTransformativeEffects() {
        return this.transformativeEffects;
    }

    @Override
    public void addTransformativeEffect(ItemEffect ie) {
        this.transformativeEffects.add(ie);
    }

    @Override
    public Set<FluidModifier> getFluidModifiers() {
        return this.fluidModifiers;
    }

    public void clearFluidModifiers() {
        this.fluidModifiers.clear();
    }

    @Override
    public float getValuePerMl() {
        return 0.01f * this.type.getValueModifier();
    }

    public boolean isCrotchMilk() {
        return this.crotchMilk;
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(FluidMilk.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

