/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractHornType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.valueEnums.HornLength;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;

public class Horn
implements BodyPartInterface {
    public static final int MAXIMUM_ROWS = 3;
    public static final int MAXIMUM_HORNS_PER_ROW = 4;
    protected AbstractHornType type;
    protected int rows;
    protected int hornsPerRow;
    protected int length;

    public Horn(AbstractHornType type, int length) {
        if (length <= 0) {
            this.length = 0;
            this.type = HornType.NONE;
        } else {
            this.type = type;
            this.length = length;
        }
        this.rows = 1;
        this.hornsPerRow = type.getDefaultHornsPerRow();
    }

    public Horn(Horn hornToCopy) {
        this.type = hornToCopy.type;
        this.length = hornToCopy.length;
        this.rows = hornToCopy.rows;
        this.hornsPerRow = hornToCopy.hornsPerRow;
    }

    @Override
    public AbstractHornType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public void setType(AbstractHornType type) {
        this.type = type;
    }

    public String setType(GameCharacter owner, AbstractHornType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            if (type.equals(HornType.NONE)) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709horns\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_hornRace]\u7684[npc.horns]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (type == HornType.HORSE_STRAIGHT) {
            this.setHornsPerRow(owner, 1);
            this.setHornRows(owner, 1);
        }
        if (this.type.equals(HornType.NONE)) {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u5012\u5438\u4e00\u53e3\u51c9\u6c14\uff0c\u611f\u5230\u524d\u989d\u53d8\u5f97\u6eda\u70eb\u53c8\u654f\u611f\uff0c\u8fde\u5fd9\u6478\u4e86\u6478\u3002\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.her]\u9707\u60ca\u5730\u7741\u5927\u4e86[npc.eyes]\uff0c\u6709\u4ec0\u4e48\u4e1c\u897f\u4ece[npc.her]\u524d\u989d\u7684[npc.faceSkin]\u4e4b\u4e0b\u51b2\u4e86\u51fa\u6765\u3002", new ParserTag[0]));
        } else {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u5012\u5438\u4e00\u53e3\u51c9\u6c14\uff0c\u611f\u5230[npc.horn]\u7684\u6839\u90e8\u6709\u4e00\u79cd\u5947\u602a\u7684\u523a\u75db\u611f\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c[npc.horn]\u4fbf\u5206\u5d29\u79bb\u6790\uff0c\u8f6c\u77ac\u6d88\u5931\u4e86\u3002", new ParserTag[0]));
        }
        if (type != HornType.NONE) {
            sb.append(UtilText.parse(owner, owner.getTotalHorns() == 1 ? "[npc.she]\u60ca\u5598\u51fa\u58f0\uff0c\u4e00\u5904\u575a\u786c\u7684\u5c0f\u51f8\u8d77\u4ece[npc.her]\u524d\u989d\u4e0a\u5ffd\u7136\u5192\u51fa\uff0c\u5e76\u4e14\u8fc5\u901f\u6210\u957f\u4e3a\u4e86" : "[npc.she]\u60ca\u5598\u51fa\u58f0\uff0c\u4e00\u5904\u575a\u786c\u7684\u5c0f\u51f8\u8d77\u4ece[npc.her]\u5934\u90e8\u5ffd\u7136\u5192\u51fa\uff0c\u5e76\u4e14\u8fc5\u901f\u6210\u957f\u4e3a\u4e86", new ParserTag[0]));
        }
        this.type = type;
        sb.append(type.getTransformationDescription(owner));
        if (this.length == 0) {
            this.length = HornLength.ONE_SMALL.getMinimumValue();
        }
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getHornRows() {
        return this.rows;
    }

    public String setHornRows(GameCharacter owner, int rows) {
        rows = Math.max(1, Math.min(rows, 3));
        if (owner == null) {
            this.rows = rows;
            return "";
        }
        if (owner.getHornRows() == rows) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        boolean removingHorns = owner.getHornRows() > rows;
        this.rows = rows;
        owner.postTransformationCalculation();
        if (owner.getHornType().equals(HornType.NONE)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingHorns) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.horns]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0b\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u524d\u989d\u4e0a\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u611f\u5230\u6709\u4e9b[npc.horns]\u987f\u65f6\u5206\u5d29\u79bb\u6790\uff0c\u6d88\u5931\u5728[npc.her]\u7684[npc.faceSkin]\u4e4b\u4e0b\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u4fbf\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_horns])]\u3002</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.horns]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0b\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u524d\u989d\u4e0a\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u611f\u5230\u5168\u65b0\u7684[npc.horns][style.boldGrow(\u5411\u4e0a\u63a8\u6324)]\u7740\uff0c\u4ece[npc.her]\u7684[npc.faceSkin]\u4e0a\u957f\u4e86\u51fa\u6765\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u4fbf\u5f97\u5230\u4e86[style.boldTfGeneric([npc.a_horns])]\u3002</p>", new ParserTag[0]);
    }

    public int getHornsPerRow() {
        return this.hornsPerRow;
    }

    public String setHornsPerRow(GameCharacter owner, int hornsPerRow) {
        hornsPerRow = Math.max(1, Math.min(hornsPerRow, 4));
        if (owner == null) {
            this.hornsPerRow = hornsPerRow;
            return "";
        }
        if (owner.getHornsPerRow() == hornsPerRow) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        boolean removingHorns = owner.getHornsPerRow() > hornsPerRow;
        this.hornsPerRow = hornsPerRow;
        owner.postTransformationCalculation();
        if (owner.getHornType().equals(HornType.NONE)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingHorns) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u602a\u7684\u8e81\u52a8\u611f\u5728[npc.namePos]\u7684[npc.horns]\u57fa\u90e8\u6108\u53d1\u5f3a\u70c8\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c[npc.horns]\u4fbf\u5f00\u59cb[style.boldShrink(\u89e3\u79bb\u91cd\u7ec4)]\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u5c31\u53d8\u6210\u4e86" + (this.rows == 1 ? "" : "\u6bcf\u4e00\u7ec4") + "[style.boldTfGeneric(" + Util.intToString(hornsPerRow) + "\u6839" + (hornsPerRow == 1 ? "[npc.horn]" : "[npc.horns]") + ")]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u5947\u602a\u7684\u8e81\u52a8\u611f\u5728[npc.namePos]\u7684\u524d\u989d\u6108\u53d1\u5f3a\u70c8\u3002\u8fd8\u6ca1\u7b49[npc.she]\u53cd\u5e94\u8fc7\u6765\uff0c\u5168\u65b0\u7684[npc.horns]\u4fbf\u7a81\u7136\u51b2\u51fa\uff0c\u4ece[npc.her]\u7684[npc.faceSkin]\u4e0a\u957f\u4e86\u51fa\u6765\u3002<br/>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c[npc.sheIs]\u5c31\u53d8\u6210\u4e86" + (this.rows == 1 ? "" : "\u6bcf\u4e00\u7ec4") + "[style.boldTfGeneric(" + Util.intToString(hornsPerRow) + "\u6839" + (hornsPerRow == 1 ? "[npc.horn]" : "[npc.horns]") + ")]\uff01</p>", new ParserTag[0]);
    }

    public int getTotalHorns() {
        return this.getHornRows() * this.getHornsPerRow();
    }

    public HornLength getHornLength() {
        return HornLength.getLengthFromInt(this.length);
    }

    public int getHornLengthValue() {
        return this.length;
    }

    public void setHornLength(int length) {
        this.length = Math.max(0, Math.min(length, HornLength.FOUR_MASSIVE.getMaximumValue()));
    }

    public void setTypeAndLength(AbstractHornType type, int length) {
        this.setType(type);
        this.setHornLength(length);
    }

    public String setHornLength(GameCharacter owner, int length) {
        int oldLength = this.length;
        this.length = Math.max(0, Math.min(length, HornLength.FOUR_MASSIVE.getMaximumValue()));
        int sizeChange = this.length - oldLength;
        if (owner == null) {
            return "";
        }
        if (owner.getHornType().equals(HornType.NONE)) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u6ca1\u6709\u89d2\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.horns]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange < 0) {
            return UtilText.parse(owner, "<p>[npc.Name]\u60ca\u53eb\u4e86\u4e00\u58f0\uff0c[npc.she]\u611f\u5230\u4e00\u80a1\u5947\u602a\u7684\u523a\u75db\u611f\u4f20\u904d[npc.face]\uff0c\u5f88\u5feb\u4fbf\u4f20\u5230\u4e86[npc.horns]\u4e0a\uff0c\u7136\u540e\u7a81\u7f29\u4e86\u4e0b\u53bb\uff0c[style.boldShrink(\u663e\u7136\u66f4\u77ed\u4e86)]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + (this.getTotalHorns() == 1 ? "[npc.a_hornSize]" : "[npc.hornSize]") + "\u7684[npc.horns])]\uff01</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u60ca\u5598\u4e86\u4e00\u58f0\uff0c\u611f\u5230\u4e00\u80a1\u6e29\u70ed\u7684\u8109\u52a8\u611f\u4ece[npc.face]\u4f20\u9012\u5230\u4e86[npc.horns]\u4e0a\uff0c\u7136\u540e\u7a81\u957f\u4e86\u4e00\u622a\uff0c[style.boldShrink(\u663e\u7136\u66f4\u957f\u4e86)]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldTfGeneric(" + (this.getTotalHorns() == 1 ? "[npc.a_hornSize]" : "[npc.hornSize]") + "\u7684[npc.horns])]\uff01</p>", new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Horn.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

