/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.OrificeMouth;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractMouthType;
import com.lilithsthrone.game.character.body.valueEnums.LipSize;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class Mouth
implements BodyPartInterface {
    protected AbstractMouthType type;
    protected OrificeMouth orificeMouth;
    protected int lipSize;
    protected boolean piercedLip;

    public Mouth(AbstractMouthType type, int lipSize, int wetness, float capacity, int depth, int elasticity, int plasticity, boolean virgin) {
        this.type = type;
        this.lipSize = lipSize;
        this.orificeMouth = new OrificeMouth(wetness, capacity, depth, elasticity, plasticity, virgin, type.getDefaultRacialOrificeModifiers());
    }

    public Mouth(Mouth mouthToCopy) {
        this.type = mouthToCopy.type;
        this.lipSize = mouthToCopy.lipSize;
        this.orificeMouth = new OrificeMouth(mouthToCopy.orificeMouth);
        this.piercedLip = mouthToCopy.piercedLip;
    }

    @Override
    public AbstractMouthType getType() {
        return this.type;
    }

    public OrificeMouth getOrificeMouth() {
        return this.orificeMouth;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter owner) {
        return this.getNameSingular(owner);
    }

    @Override
    public String getName(GameCharacter gc, boolean withDescriptor) {
        String name = this.getName(gc);
        return name;
    }

    @Override
    public String getNameSingular(GameCharacter owner) {
        return this.type.getNameSingular(owner);
    }

    @Override
    public String getNamePlural(GameCharacter owner) {
        return this.type.getNamePlural(owner);
    }

    @Override
    public String getDescriptor(GameCharacter owner) {
        ArrayList<String> descriptorList = new ArrayList<String>();
        for (OrificeModifier om : this.orificeMouth.getOrificeModifiers()) {
            descriptorList.add(om.getName());
        }
        descriptorList.add(owner.getCovering(owner.getMouthCovering()).getPrimaryColour().getName());
        descriptorList.add(this.type.getDescriptor(owner));
        return (String)Util.randomItemFrom(descriptorList);
    }

    public String getLipsNameSingular(GameCharacter gc) {
        return this.type.getLipsNameSingular(gc);
    }

    public String getLipsNamePlural(GameCharacter gc) {
        return this.type.getLipsNamePlural(gc);
    }

    public String getLipsDescriptor(GameCharacter gc) {
        ArrayList<String> descriptorList = new ArrayList<String>();
        if (this.type.isLipsDescriptorSizeAllowed(gc) && (!Main.game.isInSex() || this.getLipSize() != LipSize.ONE_AVERAGE)) {
            descriptorList.add(this.getLipSize().getName());
        }
        descriptorList.addAll(this.type.getLipsDescriptors(gc));
        return (String)Util.randomItemFrom(descriptorList);
    }

    public void setType(AbstractMouthType type) {
        this.type = type;
    }

    public LipSize getLipSize() {
        return LipSize.getLipSizeFromInt(this.lipSize);
    }

    public int getLipSizeValue() {
        return this.lipSize;
    }

    public String setLipSize(GameCharacter owner, int lipSize) {
        int effectiveLipSize = Math.max(0, Math.min(lipSize, LipSize.getLargest()));
        if (owner == null) {
            this.lipSize = effectiveLipSize;
            return "";
        }
        if (owner.getLipSizeValue() == effectiveLipSize) {
            if (owner.isPlayer()) {
                return "<p style='text-align:center;'>[style.colourDisabled(\u4f60[pc.lips]\u7684\u5927\u5c0f\u5e76\u6ca1\u6709\u6539\u53d8\u2026\u2026)]</p>";
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.lips]\u5927\u5c0f\u5e76\u65e0\u6539\u53d8\u2026\u2026)]</p>", new ParserTag[0]);
        }
        String transformation = "";
        transformation = this.lipSize > effectiveLipSize ? (owner.isPlayer() ? "<p>A soothing coolness rises up into your [pc.lips], causing you to let out a surprised gasp as you feel them [style.boldShrink(shrinking)].<br/>" : UtilText.parse(owner, "<p>\u5f53[npc.Name]\u611f\u89c9\u5230\u5507\u4e0a\u5347\u8d77\u4e00\u80a1\u8212\u7f13\u7684\u51c9\u610f\u65f6\uff0c[npc.she]\u5fcd\u4e0d\u4f4f\u8f7b\u547c\u4e00\u58f0\uff0c\u5634\u5507\u7d27\u63a5\u7740\u7a81\u7136[style.boldShrink(\u7f29\u5c0f)]\u3002<br/>", new ParserTag[0])) : (owner.isPlayer() ? "<p>A pulsating warmth rises up into your [pc.lips], causing you to let out a surprised gasp as you feel them [style.boldGrow(growing larger)].<br/>" : UtilText.parse(owner, "<p>\u5f53[npc.Name]\u611f\u89c9\u5230\u5507\u4e0a\u5347\u8d77\u4e00\u80a1\u8109\u52a8\u4f3c\u7684\u6696\u610f\u65f6\uff0c[npc.she]\u5fcd\u4e0d\u4f4f\u8f7b\u547c\u4e00\u58f0\uff0c\u5634\u5507\u7d27\u63a5\u7740\u7a81\u7136[style.boldGrow(\u53d8\u5927)]\u3002<br/>", new ParserTag[0]));
        this.lipSize = effectiveLipSize;
        if (owner.isPlayer()) {
            return transformation + "\u4f60\u73b0\u5728\u6709\u4e86[style.boldSex([pc.lipSize][pc.lips])]\uff01</p>";
        }
        return transformation + UtilText.parse(owner, "[npc.Name]\u73b0\u5728\u6709\u4e86[style.boldSex([npc.lipSize][npc.lips])]\uff01</p>", new ParserTag[0]);
    }

    public boolean isPiercedLip() {
        return this.piercedLip;
    }

    public String setPiercedLip(GameCharacter owner, boolean piercedLip) {
        if (owner.isPiercedLip() == piercedLip) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.piercedLip = piercedLip;
        if (piercedLip) {
            if (owner.isPlayer()) {
                return "<p>\u4f60[pc.lips]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>";
            }
            return UtilText.parse(owner, "<p>[npc.NamePos][npc.lips]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>", new ParserTag[0]);
        }
        AbstractClothing c = owner.getClothingInSlot(InventorySlot.PIERCING_LIP);
        String piercingUnequip = "";
        if (c != null) {
            owner.forceUnequipClothingIntoVoid(owner, c);
            piercingUnequip = owner.addClothing(c, false);
        }
        if (owner.isPlayer()) {
            return "<p>\u4f60[pc.lips]\u5df2[style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip;
        }
        return UtilText.parse(owner, "<p>[npc.NamePos][npc.lips]\u5df2[style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip, new ParserTag[0]);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Mouth.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

