/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTailType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class Tail
implements BodyPartInterface {
    public static final int MAXIMUM_COUNT = 9;
    public static final float LENGTH_PERCENTAGE_MIN = 0.05f;
    public static final float LENGTH_PERCENTAGE_MAX = 2.5f;
    protected AbstractTailType type;
    protected int tailCount;
    protected int girth;
    protected float lengthAsPercentageOfHeight;

    public Tail(AbstractTailType type) {
        this.type = type;
        this.tailCount = 1;
        this.girth = type.getDefaultGirth();
        this.lengthAsPercentageOfHeight = type.getDefaultLengthAsPercentageOfHeight();
    }

    public Tail(Tail tailToCopy) {
        this.type = tailToCopy.type;
        this.tailCount = tailToCopy.tailCount;
        this.girth = tailToCopy.girth;
        this.lengthAsPercentageOfHeight = tailToCopy.lengthAsPercentageOfHeight;
    }

    @Override
    public AbstractTailType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        ArrayList<String> descriptors = new ArrayList<String>();
        descriptors.add(this.type.getDescriptor(gc));
        if (gc.getTailGirth() != PenetrationGirth.THREE_AVERAGE) {
            descriptors.add(gc.getTailGirth().getName());
        }
        return (String)Util.randomItemFrom(descriptors);
    }

    public String setType(GameCharacter owner, AbstractTailType type) {
        if (!Main.game.isStarted() || owner == null) {
            if (owner != null && !owner.getLegConfiguration().isAbleToGrowTail()) {
                type = TailType.NONE;
            }
            if (this.getLengthAsPercentageOfHeight() == this.getType().getDefaultLengthAsPercentageOfHeight()) {
                this.setLengthAsPercentageOfHeight(owner, type.getDefaultLengthAsPercentageOfHeight());
            }
            this.type = type;
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!owner.getLegConfiguration().isAbleToGrowTail() && type != TailType.NONE) {
            type = TailType.NONE;
            sb.append(UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u62e5\u6709\u201c" + owner.getLegConfiguration().getName() + "\u201d\u817f\u90e8\u914d\u7f6e\uff0c\u6240\u4ee5\u65e0\u6cd5\u957f\u5c3e\u5df4\uff01)]</p>", new ParserTag[0]));
        }
        if (type == this.getType()) {
            if (type == TailType.NONE) {
                sb.append(UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709\u5c3e\u5df4\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]));
            } else {
                sb.append(UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_tailRace]\u7684[npc.tail]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]));
            }
            return UtilText.parse(owner, sb.toString(), new ParserTag[0]);
        }
        if (this.type == TailType.NONE) {
            sb.append("<p>[npc.Name]\u611f\u5230\u8170\u80cc\u95f4\u53d8\u5f97\u6eda\u70eb\u53c8\u654f\u611f\uff0c\u8fde\u5fd9\u6478\u4e86\u6478\uff0c\u8fd9\u624d\u53d1\u73b0\u6709\u4ec0\u4e48\u4e1c\u897f\u6b63\u4ece[npc.skin]\u4e4b\u4e0b\u751f\u957f\u51fa\u6765\u3002");
        } else {
            sb.append("<p>" + (owner.getTailCount() == 1 ? "[npc.Name]\u611f\u89c9[npc.tail]\u6e10\u6e10\u71e5\u70ed\u53d1\u75d2\u8d77\u6765\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u5c31\u5f00\u59cb\u4e86\u8f6c\u5316\u3002" : "[npc.Name]\u611f\u89c9[npc.tails]\u6e10\u6e10\u71e5\u70ed\u53d1\u75d2\u8d77\u6765\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u5c31\u5f00\u59cb\u4e86\u8f6c\u5316\u3002"));
        }
        if (this.getLengthAsPercentageOfHeight() == this.getType().getDefaultLengthAsPercentageOfHeight()) {
            this.setLengthAsPercentageOfHeight(owner, type.getDefaultLengthAsPercentageOfHeight());
        }
        if (this.getRawGirthValue() == this.getType().getDefaultGirth()) {
            this.setTailGirth(owner, type.getDefaultGirth());
        }
        if (type == TailType.NONE) {
            sb.append(type.getTransformationDescription(owner));
            this.type = type;
        } else {
            this.type = type;
            sb.append(type.getTransformationDescription(owner));
        }
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public int getTailCount() {
        return this.tailCount;
    }

    public int getMaxTailCount(GameCharacter owner) {
        if (owner.hasPerkAnywhereInTree(Perk.SINGLE_TAILED_YOUKO)) {
            return 1;
        }
        if (owner.hasPerkAnywhereInTree(Perk.TWO_TAILED_YOUKO)) {
            return 2;
        }
        if (owner.hasPerkAnywhereInTree(Perk.THREE_TAILED_YOUKO)) {
            return 3;
        }
        if (owner.hasPerkAnywhereInTree(Perk.FOUR_TAILED_YOUKO)) {
            return 4;
        }
        if (owner.hasPerkAnywhereInTree(Perk.FIVE_TAILED_YOUKO)) {
            return 5;
        }
        if (owner.hasPerkAnywhereInTree(Perk.SIX_TAILED_YOUKO)) {
            return 6;
        }
        if (owner.hasPerkAnywhereInTree(Perk.SEVEN_TAILED_YOUKO)) {
            return 7;
        }
        if (owner.hasPerkAnywhereInTree(Perk.EIGHT_TAILED_YOUKO)) {
            return 8;
        }
        if (owner.hasPerkAnywhereInTree(Perk.NINE_TAILED_YOUKO)) {
            return 9;
        }
        return this.tailCount;
    }

    public String setTailCount(GameCharacter owner, int tailCount, boolean overrideYoukoLimitations) {
        tailCount = Math.max(1, Math.min(tailCount, 9));
        if (!Main.game.isStarted() || owner == null) {
            this.tailCount = tailCount;
            return "";
        }
        if (owner.getTailCount() == tailCount && !overrideYoukoLimitations) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (owner.getTailType().equals(TailType.FOX_MORPH_MAGIC) && tailCount > this.getMaxTailCount(owner) && !overrideYoukoLimitations) {
            return "<p style='text-align:center;'>[style.colourMinorBad([npc.NamePos]\u6ce8\u5165\u5965\u672f\u7684" + (this.tailCount == 1 ? "\u5c3e\u5df4\u5438\u6536\u5e76\u4e14\u65e0\u6548\u5316\u4e86" : "\u5c3e\u5df4\u5438\u6536\u5e76\u4e14\u65e0\u6548\u5316\u4e86") + "\u8f6c\u5316\u6548\u679c\uff0c\u5c3e\u5df4\u6570\u91cf\u6ca1\u80fd\u53d1\u751f\u53d8\u5316\uff01)]</p>";
        }
        owner.removeStatusEffect(StatusEffect.SUBSPECIES_BONUS);
        boolean removingTails = owner.getTailCount() > tailCount;
        this.tailCount = tailCount;
        owner.addStatusEffect(StatusEffect.SUBSPECIES_BONUS, -1);
        if (overrideYoukoLimitations) {
            if (owner.hasPerkAnywhereInTree(Perk.SINGLE_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.SINGLE_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.TWO_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.TWO_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.THREE_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.THREE_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.FOUR_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.FOUR_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.FIVE_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.FIVE_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.SIX_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.SIX_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.SEVEN_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.SEVEN_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.EIGHT_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.EIGHT_TAILED_YOUKO);
            }
            if (owner.hasPerkAnywhereInTree(Perk.NINE_TAILED_YOUKO)) {
                owner.removeSpecialPerk(Perk.NINE_TAILED_YOUKO);
            }
            if (owner.getTailType().equals(TailType.FOX_MORPH_MAGIC)) {
                switch (owner.getTailCount()) {
                    case 1: {
                        owner.addSpecialPerk(Perk.SINGLE_TAILED_YOUKO);
                        break;
                    }
                    case 2: {
                        owner.addSpecialPerk(Perk.TWO_TAILED_YOUKO);
                        break;
                    }
                    case 3: {
                        owner.addSpecialPerk(Perk.THREE_TAILED_YOUKO);
                        break;
                    }
                    case 4: {
                        owner.addSpecialPerk(Perk.FOUR_TAILED_YOUKO);
                        break;
                    }
                    case 5: {
                        owner.addSpecialPerk(Perk.FIVE_TAILED_YOUKO);
                        break;
                    }
                    case 6: {
                        owner.addSpecialPerk(Perk.SIX_TAILED_YOUKO);
                        break;
                    }
                    case 7: {
                        owner.addSpecialPerk(Perk.SEVEN_TAILED_YOUKO);
                        break;
                    }
                    case 8: {
                        owner.addSpecialPerk(Perk.EIGHT_TAILED_YOUKO);
                        break;
                    }
                    case 9: {
                        owner.addSpecialPerk(Perk.NINE_TAILED_YOUKO);
                    }
                }
            }
        }
        if (owner.getTailType() == TailType.NONE) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        if (removingTails) {
            return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.tails]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0a\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u8170\u80cc\u95f4\u3002[npc.She]\u4e0d\u7981\u5927\u53eb\u4e00\u58f0\uff0c\u53ea\u89c9\u5f97\u597d\u50cf\u6709\u4e00\u6761[style.boldShrink(\u7f29\u4e86\u4e0b\u53bb)]\uff0c\u6d88\u5931\u5728[npc.her]\u7684[npc.skin]\u4e4b\u4e0b\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u4fbf\u6709\u4e86[style.boldTfGeneric(" + (String)(tailCount == 1 ? "\u4e00\u6761[npc.tail]" : Util.intToString(tailCount) + "\u6761[npc.tails]") + ")]\u3002</p>", new ParserTag[0]);
        }
        return UtilText.parse(owner, "<p>\u4e00\u80a1\u523a\u75db\u611f\u4f20\u904d\u4e86[npc.namePos]\u7684[npc.tails]\uff0c\u63a5\u7740\u8fd9\u79cd\u611f\u89c9\u7ee7\u7eed\u5411\u4e0a\uff0c\u96c6\u4e2d\u5728\u4e86[npc.her]\u7684\u8170\u80cc\u95f4\u3002[npc.She]\u4e0d\u7981\u8f7b\u547c\u4e00\u58f0\uff0c\u53ea\u89c9\u5f97\u597d\u50cf\u6709\u65b0\u7684[npc.tails][style.boldShrink(\u6b63\u5728\u751f\u957f)]\uff0c\u7a81\u7834[npc.skin]\u800c\u51fa\u3002<br/>\u7247\u523b\u8fc7\u540e\uff0c[npc.sheIs]\u4fbf\u6709\u4e86[style.boldTfGeneric(" + (String)(tailCount == 1 ? "\u4e00\u6761[npc.tail]" : Util.intToString(tailCount) + "\u6761[npc.tails]") + ")]\u3002</p>", new ParserTag[0]);
    }

    public PenetrationGirth getGirth() {
        return PenetrationGirth.getGirthFromInt(this.girth);
    }

    public int getRawGirthValue() {
        return this.girth;
    }

    public String setTailGirth(GameCharacter owner, int girth) {
        if (owner == null) {
            this.girth = Math.max(0, Math.min(girth, PenetrationGirth.getMaximum()));
            return "";
        }
        int girthChange = 0;
        if (girth <= 0) {
            if (this.girth != 0) {
                girthChange = 0 - this.girth;
                this.girth = 0;
            }
        } else if (girth >= PenetrationGirth.getMaximum()) {
            if (this.girth != PenetrationGirth.getMaximum()) {
                girthChange = PenetrationGirth.getMaximum() - this.girth;
                this.girth = PenetrationGirth.getMaximum();
            }
        } else if (this.girth != girth) {
            girthChange = girth - this.girth;
            this.girth = girth;
        }
        if (!owner.hasTail()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u6ca1\u6709\u5c3e\u5df4\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (girthChange == 0) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tail]\u7684\u5468\u957f\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        return owner.getTailType().getGirthTransformationDescription(owner, girthChange > 0);
    }

    public float getLengthAsPercentageOfHeight() {
        return this.lengthAsPercentageOfHeight;
    }

    public String setLengthAsPercentageOfHeight(GameCharacter owner, float lengthAsPercentageOfHeight) {
        if (owner == null) {
            this.lengthAsPercentageOfHeight = Math.max(0.05f, Math.min(lengthAsPercentageOfHeight, 2.5f));
            return "";
        }
        float lengthChange = 0.0f;
        if (lengthAsPercentageOfHeight <= 0.05f) {
            if (this.lengthAsPercentageOfHeight != 0.05f) {
                lengthChange = 0.05f - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = 0.05f;
            }
        } else if (lengthAsPercentageOfHeight >= 2.5f) {
            if (this.lengthAsPercentageOfHeight != 2.5f) {
                lengthChange = 2.5f - this.lengthAsPercentageOfHeight;
                this.lengthAsPercentageOfHeight = 2.5f;
            }
        } else if (this.lengthAsPercentageOfHeight != lengthAsPercentageOfHeight) {
            lengthChange = lengthAsPercentageOfHeight - this.lengthAsPercentageOfHeight;
            this.lengthAsPercentageOfHeight = lengthAsPercentageOfHeight;
        }
        if (!owner.hasTail()) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u6ca1\u6709\u5c3e\u5df4\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (lengthChange == 0.0f) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tail]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        return owner.getTailType().getLengthTransformationDescription(owner, lengthChange > 0.0f);
    }

    public int getLength(GameCharacter owner) {
        return (int)((float)owner.getHeightValue() * this.getLengthAsPercentageOfHeight());
    }

    public boolean isSuitableForPenetration() {
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_NEVER_SUITABLE_FOR_PENETRATION)) {
            return false;
        }
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION) || Main.game.isFurryTailPenetrationContentEnabled()) {
            return this.getType().isPrehensile() || this.getLengthAsPercentageOfHeight() >= 0.5f;
        }
        return false;
    }

    public static float getGenericDiameter(int height, PenetrationGirth girth) {
        return Units.round((float)height * 0.08f * (1.0f + girth.getDiameterPercentageModifier()), 2);
    }

    public float getBaseDiameter(GameCharacter owner) {
        return this.getDiameter(owner, 0.0f);
    }

    public float getDiameter(GameCharacter owner, float atLength) {
        float baseDiameter = (float)owner.getHeightValue() * 0.08f * (1.0f + this.getGirth().getDiameterPercentageModifier());
        float lengthPercentage = Math.min(1.0f, atLength / (float)this.getLength(owner));
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_TAPERING_EXPONENTIAL)) {
            return 1.0f / (4.0f * lengthPercentage + 1.0f) * baseDiameter;
        }
        if (this.getType().getTags().contains((Object)BodyPartTag.TAIL_TAPERING_LINEAR)) {
            return (1.0f - 0.8f * lengthPercentage) * baseDiameter;
        }
        return Units.round(baseDiameter, 2);
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Tail.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

