/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTongueType;
import com.lilithsthrone.game.character.body.valueEnums.TongueLength;
import com.lilithsthrone.game.character.body.valueEnums.TongueModifier;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Tongue
implements BodyPartInterface {
    protected AbstractTongueType type;
    protected Set<TongueModifier> tongueModifiers;
    protected int tongueLength;
    protected boolean pierced;

    public Tongue(AbstractTongueType type) {
        this.type = type;
        this.pierced = false;
        this.tongueLength = type.getDefaultLength();
        this.tongueModifiers = new HashSet<TongueModifier>(type.getDefaultRacialTongueModifiers());
    }

    public Tongue(Tongue tongueToCopy) {
        this.type = tongueToCopy.type;
        this.pierced = tongueToCopy.pierced;
        this.tongueLength = tongueToCopy.tongueLength;
        this.tongueModifiers = new HashSet<TongueModifier>(tongueToCopy.tongueModifiers);
    }

    @Override
    public AbstractTongueType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter owner) {
        ArrayList<String> list = new ArrayList<String>();
        for (TongueModifier tm : this.tongueModifiers) {
            list.add(tm.getName());
        }
        list.add(this.type.getDescriptor(owner));
        return (String)Util.randomItemFrom(list);
    }

    public void setType(AbstractTongueType type) {
        this.type = type;
        this.resetTongueModifiers();
    }

    public boolean isPierced() {
        return this.pierced;
    }

    public String setPierced(GameCharacter owner, boolean pierced) {
        if (this.pierced == pierced) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.pierced = pierced;
        if (pierced) {
            if (owner.isPlayer()) {
                return "<p>\u4f60\u7684[pc.tongue]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>";
            }
            return UtilText.parse(owner, "<p>[npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u5df2[style.boldGrow(\u7a7f\u5b54)]\uff01</p>", new ParserTag[0]);
        }
        AbstractClothing c = owner.getClothingInSlot(InventorySlot.PIERCING_TONGUE);
        String piercingUnequip = "";
        if (c != null) {
            owner.forceUnequipClothingIntoVoid(owner, c);
            piercingUnequip = owner.addClothing(c, false);
        }
        if (owner.isPlayer()) {
            return "<p>\u4f60\u7684[pc.tongue][style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip;
        }
        return UtilText.parse(owner, "<p>[npc.NamePos]\u7684[npc.tongue][style.boldShrink(\u4e0d\u518d\u6709\u7a7f\u5b54\u4e86)]\uff01</p>" + piercingUnequip, new ParserTag[0]);
    }

    public TongueLength getTongueLength() {
        return TongueLength.getTongueLengthFromInt(this.tongueLength);
    }

    public int getTongueLengthValue() {
        return this.tongueLength;
    }

    public String setTongueLength(GameCharacter owner, int tongueLength) {
        int oldTongueLength = this.tongueLength;
        this.tongueLength = Math.max(0, Math.min(tongueLength, TongueLength.FOUR_ABSURDLY_LONG.getMaximumValue()));
        int sizeChange = this.tongueLength - oldTongueLength;
        if (sizeChange == 0) {
            if (owner.isPlayer()) {
                return "<p style='text-align:center;'>[style.colourDisabled(\u4f60[pc.tongue]\u7684\u7a0b\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>";
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.tongue]\u7684\u957f\u5ea6\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        if (sizeChange < 0) {
            if (owner.isPlayer()) {
                return "<p>\u4e00\u80a1\u8212\u7f13\u7684\u5fae\u51c9\u611f\u4ece[pc.tongue]\u4e0a\u5347\u8d77\uff0c\u4f60\u60ca\u547c\u4e00\u58f0\uff0c\u611f\u89c9\u5230[pc.tongue][style.boldShrink(\u53d8\u77ed\u4e86)]\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709" + UtilText.generateSingularDeterminer(Util.intToString(this.tongueLength)) + "[style.boldTfGeneric(" + Units.size(this.tongueLength, Units.UnitType.LONG_SINGULAR) + "\u7684[pc.tongue])]\uff01</p>";
            }
            return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.tongue]\u4e0a\u5347\u8d77\u4e00\u4e1d\u8212\u7f13\u7684\u51c9\u610f\uff0c\u5fcd\u4e0d\u4f4f\u8f7b\u547c\u4e00\u58f0\uff0c\u968f\u540e[npc.tongue]\u4fbf\u7a81\u7136[style.boldShrink(\u53d8\u77ed\u4e86)]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + UtilText.generateSingularDeterminer(Util.intToString(this.tongueLength)) + "[style.boldTfGeneric(" + Units.size(this.tongueLength, Units.UnitType.LONG_SINGULAR) + "\u7684[npc.tongue])]\uff01</p>", new ParserTag[0]);
        }
        if (owner.isPlayer()) {
            return "<p>\u4e00\u80a1\u8109\u52a8\u7684\u6696\u610f\u4ece[pc.tongue]\u4e0a\u5347\u8d77\uff0c\u4f60\u60ca\u547c\u4e00\u58f0\uff0c\u611f\u89c9\u5230[pc.tongue][style.boldGrow(\u53d8\u957f\u4e86)]\u3002<br/>\u4f60\u73b0\u5728\u62e5\u6709" + UtilText.generateSingularDeterminer(Util.intToString(this.tongueLength)) + "[style.boldTfGeneric(" + Units.size(this.tongueLength, Units.UnitType.LONG_SINGULAR) + "\u7684[pc.tongue])]\uff01</p>";
        }
        return UtilText.parse(owner, "<p>[npc.Name]\u611f\u89c9\u5230[npc.tongue]\u4e0a\u5347\u8d77\u4e00\u4e1d\u8109\u52a8\u7684\u6696\u610f\uff0c\u5fcd\u4e0d\u4f4f\u8f7b\u547c\u4e00\u58f0\uff0c\u968f\u540e[npc.tongue]\u4fbf\u7a81\u7136[style.boldGrow(\u53d8\u957f\u4e86)]\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709" + UtilText.generateSingularDeterminer(Util.intToString(this.tongueLength)) + "[style.boldTfGeneric(" + Units.size(this.tongueLength, Units.UnitType.LONG_SINGULAR) + "\u7684[npc.tongue])]\uff01</p>", new ParserTag[0]);
    }

    public boolean hasTongueModifier(TongueModifier modifier) {
        return this.tongueModifiers.contains((Object)modifier);
    }

    public String addTongueModifier(GameCharacter owner, TongueModifier modifier) {
        if (this.hasTongueModifier(modifier)) {
            return owner == null ? "" : "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.tongueModifiers.add(modifier);
        if (owner == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        switch (modifier) {
            case RIBBED: {
                sb.append("[npc.Name]\u611f\u5230\u4e00\u9635\u5f3a\u70c8\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c[npc.she]\u8fd8\u6ca1\u6765\u5f97\u53ca\u614c\u5f20\uff0c\u8fd9\u79cd\u611f\u89c9\u4fbf\u6d88\u5931\u4e86\uff0c[npc.tongue]\u4e0a\u73b0\u5728\u886c\u7740[style.boldGrow(\u7a0d\u786c\u7684\u8089\u8d28\u87ba\u7eb9)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u957f\u6709\u87ba\u7eb9\uff01)]");
                break;
            }
            case TENTACLED: {
                sb.append("[npc.Name]\u611f\u5230\u5f3a\u70c8\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c\u4e8e\u662f\u4e0d\u7531\u81ea\u4e3b\u5730\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[style.boldGrow(\u4e00\u8fde\u4e32\u626d\u52a8\u7684\u7ec6\u5c0f\u89e6\u624b)]\u5e03\u6ee1\u4e86[npc.tongue]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u8986\u76d6\u7740\u7ec6\u5c0f\u7684\u89e6\u624b\uff0c\u81ea\u884c\u873f\u8712\u626d\u52a8\u7740\uff01)]");
                break;
            }
            case BIFURCATED: {
                sb.append("[npc.Name]\u611f\u5230\u5f3a\u70c8\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c\u4e8e\u662f\u4e0d\u7531\u81ea\u4e3b\u5730\u53eb\u4e86\u51fa\u6765\uff0c[style.boldGrow([npc.her][npc.tongue]\u7684\u9876\u7aef\u4e00\u5206\u4e3a\u4e8c)]\u4e86\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u50cf\u86c7\u4e00\u6837\u5206\u53c9\u4e86\uff01)]");
                break;
            }
            case STRONG: {
                sb.append("[npc.Name]\u611f\u5230\u4e00\u80a1\u5e73\u7a33\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c\u4f46\u8fd8\u6ca1\u7b49\u53cd\u5e94\uff0c\u8fd9\u611f\u89c9\u4fbf\u51b2\u5411\u4e86[npc.tongue]\uff0c\u5c06\u5176\u8f6c\u5316[style.boldGrow(\u5f97\u683c\u5916\u6709\u529b)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u975e\u5e38\u5f3a\u58ee\uff01)]");
                break;
            }
            case FLAT: {
                sb.append("[npc.Name]\u611f\u5230\u4e00\u80a1\u5e73\u7a33\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c\u4f46\u8fd8\u6ca1\u7b49\u53cd\u5e94\uff0c\u8fd9\u611f\u89c9\u4fbf\u51b2\u5411\u4e86[npc.tongue]\uff0c\u5c06\u5176\u8f6c\u5316[style.boldGrow(\u5f97\u683c\u5916\u5e73\u76f4)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u53c8\u5e73\u53c8\u76f4\uff01)]");
                break;
            }
            case WIDE: {
                sb.append("[npc.Name]\u611f\u5230\u4e00\u80a1\u5e73\u7a33\u7684\u538b\u529b\u4e0d\u65ad\u4ece\u5589\u5934\u5904\u4ea7\u751f\uff0c\u4f46\u8fd8\u6ca1\u7b49\u53cd\u5e94\uff0c\u8fd9\u611f\u89c9\u4fbf\u51b2\u5411\u4e86[npc.tongue]\uff0c\u5c06\u5176\u8f6c\u5316[style.boldGrow(\u5f97\u683c\u5916\u5bbd\u5927)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u683c\u5916\u5bbd\u5927\uff01)]");
                break;
            }
            case TAPERED: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u9635\u4ece[npc.tongue]\u56db\u9762\u516b\u65b9\u88ad\u6765\u7684\u6536\u7f29\u611f\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[npc.tongue][style.boldGrow(\u53d8\u4e3a\u9525\u5f62\uff0c\u8d8a\u9760\u8fd1\u9876\u7aef\u53d8\u5f97\u8d8a\u7ec6)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u73b0\u5728\u662f\u9525\u5f62\u7684\uff01)]</p>";
            }
        }
        sb.append("</p>");
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]);
    }

    public String removeTongueModifier(GameCharacter owner, TongueModifier modifier) {
        if (!this.hasTongueModifier(modifier)) {
            return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
        }
        this.tongueModifiers.remove((Object)modifier);
        switch (modifier) {
            case RIBBED: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8f7b\u5fae\u7684\u51c9\u610f\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4f46\u8fd9\u611f\u89c9\u8f6c\u77ac\u5373\u901d\uff0c\u8fd8\u6ca1\u7b49[npc.she]\u505a\u51fa\u4efb\u4f55\u53cd\u5e94\uff0c\u90a3\u7a0d\u786c\u7684\u8089\u8d28\u87ba\u7eb9\u4fbf[style.boldShrink(\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u6709\u87ba\u7eb9\u4e86\uff01)]</p>";
            }
            case TENTACLED: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8f7b\u5fae\u7684\u51c9\u610f\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[style.boldShrink(\u90a3\u626d\u52a8\u7684\u7ec6\u5c0f\u89e6\u624b\u4fbf\u6d88\u5931\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u8986\u76d6\u7ec6\u5c0f\u7684\u89e6\u624b\u4e86\uff01)]</p>";
            }
            case BIFURCATED: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8f7b\u5fae\u7684\u51c9\u610f\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[style.boldShrink(\u5c16\u7aef\u4fbf\u878d\u5408\u5728\u4e86\u4e00\u8d77)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u5206\u53c9\u4e86\uff01)]</p>";
            }
            case FLAT: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8109\u52a8\u7684\u538b\u529b\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[npc.tongue][style.boldShrink(\u66f4\u539a\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u90a3\u4e48\u5e73\u76f4\u4e86\uff01)]</p>";
            }
            case STRONG: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8109\u52a8\u7684\u538b\u529b\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[npc.tongue][style.boldShrink(\u8f6f\u4e86\u4e0b\u6765\uff0c\u5931\u53bb\u4e86\u529b\u91cf)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u683c\u5916\u6709\u529b\u4e86\uff01)]</p>";
            }
            case WIDE: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8109\u52a8\u7684\u538b\u529b\u4ece[npc.tongue]\u4e0a\u5347\u8d77\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[npc.tongue][style.boldShrink(\u7f29\u7a84\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u90a3\u4e48\u5bbd\u5927\u4e86\uff01)]</p>";
            }
            case TAPERED: {
                return "<p>[npc.Name]\u611f\u5230\u4e00\u80a1\u8109\u52a8\u7684\u538b\u529b\u4e0d\u65ad\u4ece[npc.tongue]\u4e0a\u4ea7\u751f\uff0c\u4e8e\u662f\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\uff0c[npc.tongue][style.boldShrink(\u5c55\u4e86\u5f00\u6765\uff0c\u4e0d\u518d\u662f\u5c16\u5934\u7684\u4e86)]\u3002<br/>[style.boldSex([npc.NamePos]\u7684[npc.tongue]\u4e0d\u518d\u662f\u9525\u5f62\u7684\u4e86\uff01)]</p>";
            }
        }
        return "<p style='text-align:center;'>[style.colourDisabled(\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>";
    }

    public void resetTongueModifiers() {
        this.tongueModifiers = new HashSet<TongueModifier>(this.type.getDefaultRacialTongueModifiers());
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Tongue.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

