/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.BodyPartInterface;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractWingType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.WingSize;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;

public class Wing
implements BodyPartInterface {
    protected AbstractWingType type;
    protected int size;

    public Wing(AbstractWingType type, int size) {
        this.type = type;
        this.size = size;
    }

    public Wing(Wing wingToCopy) {
        this.type = wingToCopy.type;
        this.size = wingToCopy.size;
    }

    @Override
    public AbstractWingType getType() {
        return this.type;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return this.type.getDeterminer(gc);
    }

    @Override
    public String getName(GameCharacter gc) {
        return this.type.getName(gc);
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.type.getNameSingular(gc);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.type.getNamePlural(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        return this.type.getDescriptor(gc);
    }

    public void setType(AbstractWingType type) {
        this.type = type;
    }

    public String setType(GameCharacter owner, AbstractWingType type) {
        if (!Main.game.isStarted() || owner == null) {
            this.type = type;
            this.setSize(owner, this.getSizeValue());
            if (owner != null) {
                owner.postTransformationCalculation();
            }
            return "";
        }
        if (type == this.getType()) {
            if (type == WingType.NONE) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6ca1\u6709\u7fc5\u8180\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
            }
            if (type.getRace() != Race.NONE) {
                return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709[npc.a_wingRace]\u7684[npc.wings]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
            }
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.Name]\u5df2\u7ecf\u6709" + type.getTransformName() + "[npc.wings]\u4e86\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (type != WingType.NONE) {
            sb.append("<p>[npc.Name]\u611f\u5230\u80cc\u90e8\u5ffd\u7136\u4e00\u9635\u8e81\u52a8\u611f\uff0c\u6b63\u51c6\u5907\u56de\u5934\u770b\uff0c\u5c31\u6709\u4ec0\u4e48\u4e1c\u897f\u4ece[npc.skin]\u4e0b\u7834\u4f53\u800c\u51fa\u3002");
        } else {
            sb.append("<p>[npc.NamePos]\u7684[npc.wings]\u7a81\u7136\u5f00\u59cb\u4e0d\u53d7\u63a7\u5236\u5730\u98a4\u6296\u6247\u52a8\u8d77\u6765\uff0c[npc.she]\u611f\u5230\u8f6c\u5316\u5df2\u7ecf\u5f00\u59cb\u4e86\uff0c\u7981\u4e0d\u4f4f\u5012\u5438\u4e00\u53e3\u51c9\u6c14\u3002");
        }
        sb.append(type.getTransformationDescription(owner));
        if (type != WingType.NONE) {
            if (this.getSize().getValue() >= owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getValue()) {
                sb.append("</br>[npc.sheIs]\u5c1d\u8bd5\u7740\u6247\u52a8\u4e86\u4e00\u4e0b\uff0c\u60ca\u559c\u5730\u53d1\u73b0\u7adf\u7136[style.colourGood(\u8db3\u591f\u6709\u529b\u4ee5\u652f\u6301[npc.herHim]\u98de\u7fd4)]\u4e86\uff01<br/>[style.italics(" + Util.capitaliseSentence(owner.getLegConfiguration().getName()) + "\u7684\u8eab\u8eaf\u9700\u8981\u7fc5\u8180\u81f3\u5c11\u8fbe\u5230\u201c" + owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getName() + "\u201d\u5c3a\u5bf8\u624d\u80fd\u591f\u98de\u7fd4\u3002)]");
            } else {
                sb.append("</br>[npc.sheIs]\u5c1d\u8bd5\u7740\u6247\u52a8\u4e86\u4e00\u4e0b\uff0c\u5931\u671b\u5730\u53d1\u73b0\u8fd8\u662f[style.colourBad(\u5e76\u4e0d\u8db3\u4ee5\u652f\u6301[npc.herHim]\u98de\u7fd4)]\u2026\u2026<br/>[style.italics(" + Util.capitaliseSentence(owner.getLegConfiguration().getName()) + "\u7684\u8eab\u8eaf\u9700\u8981\u7fc5\u8180\u81f3\u5c11\u8fbe\u5230\u201c" + owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getName() + "\u201d\u5c3a\u5bf8\u624d\u80fd\u591f\u98de\u7fd4\u3002)]");
            }
        }
        sb.append("</p>");
        this.type = type;
        this.setSize(owner, this.getSizeValue());
        return UtilText.parse(owner, sb.toString(), new ParserTag[0]) + "<p>" + owner.postTransformationCalculation() + "</p>";
    }

    public WingSize getSize() {
        return WingSize.getWingSizeFromInt(this.size);
    }

    public int getSizeValue() {
        return this.size;
    }

    public void setSize(int wingSize) {
        this.size = Math.max(0, Math.min(wingSize, WingSize.getLargest()));
    }

    public void setTypeAndSize(AbstractWingType type, int wingSize) {
        this.setType(type);
        this.setSize(wingSize);
    }

    public String setSize(GameCharacter owner, int wingSize) {
        if (owner == null) {
            int effectiveSize;
            this.size = effectiveSize = Math.max(this.getType().getMinimumSize().getValue(), Math.min(wingSize, this.getType().getMaximumSize().getValue()));
            return "";
        }
        if (this.getType() == WingType.NONE) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.NamePos]\u6ca1\u6709\u7fc5\u8180\uff0c\u6240\u4ee5\u65e0\u4e8b\u53d1\u751f\u2026\u2026)]</p>", new ParserTag[0]);
        }
        int effectiveSize = Math.max(this.getType().getMinimumSize().getValue(), Math.min(wingSize, this.getType().getMaximumSize().getValue()));
        if (owner.getWingSizeValue() == effectiveSize) {
            return UtilText.parse(owner, "<p style='text-align:center;'>[style.colourDisabled([npc.namePos][npc.wings]\u7684\u5c3a\u5bf8\u6ca1\u6709\u53d8\u5316\u2026\u2026)]</p>", new ParserTag[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (this.size > effectiveSize) {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u611f\u53d7\u5230\u4e00\u80a1\u8212\u7f13\u7684\u6e05\u51c9\u611f\u4ece[npc.her][npc.wings+]\u4e2d\u5347\u817e\u800c\u8d77\uff0c\u5fcd\u4e0d\u4f4f\u60ca\u547c\u4e00\u58f0\uff0c[npc.wings]\u7d27\u63a5\u7740[style.boldShrink(\u7f29\u5c0f)]\u4e86\u3002<br/>", new ParserTag[0]));
        } else {
            sb.append(UtilText.parse(owner, "<p>[npc.Name]\u611f\u53d7\u5230\u4e00\u80a1\u640f\u52a8\u7684\u6e29\u6696\u611f\u4ece[npc.her][npc.wings+]\u4e2d\u5347\u817e\u800c\u8d77\uff0c\u5fcd\u4e0d\u4f4f\u60ca\u547c\u4e00\u58f0\uff0c[npc.wings]\u7d27\u63a5\u7740[style.boldGrow(\u53d8\u5927)]\u4e86\u3002<br/>", new ParserTag[0]));
        }
        this.size = effectiveSize;
        sb.append(UtilText.parse(owner, "[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldSex([npc.wingSize]\u7684[npc.wings])]\uff01", new ParserTag[0]));
        if (this.type != WingType.NONE) {
            if (this.getSize().getValue() >= owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getValue()) {
                sb.append("</br>[npc.sheIs]\u5c1d\u8bd5\u7740\u6247\u52a8\u4e86\u4e00\u4e0b\uff0c\u60ca\u559c\u5730\u53d1\u73b0\u7adf\u7136[style.colourGood(\u8db3\u591f\u6709\u529b\u4ee5\u652f\u6301[npc.herHim]\u98de\u7fd4)]\u4e86\uff01<br/>[style.italics(" + Util.capitaliseSentence(owner.getLegConfiguration().getName()) + "\u7684\u8eab\u8eaf\u9700\u8981\u7fc5\u8180\u81f3\u5c11\u8fbe\u5230\u201c" + owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getName() + "\u201d\u5c3a\u5bf8\u624d\u80fd\u591f\u98de\u7fd4\u3002)]");
            } else {
                sb.append("</br>[npc.sheIs]\u5c1d\u8bd5\u7740\u6247\u52a8\u4e86\u4e00\u4e0b\uff0c\u5931\u671b\u5730\u53d1\u73b0\u8fd8\u662f[style.colourBad(\u5e76\u4e0d\u8db3\u4ee5\u652f\u6301[npc.herHim]\u98de\u7fd4)]\u2026\u2026<br/>[style.italics(" + Util.capitaliseSentence(owner.getLegConfiguration().getName()) + "\u7684\u8eab\u8eaf\u9700\u8981\u7fc5\u8180\u81f3\u5c11\u8fbe\u5230\u201c" + owner.getLegConfiguration().getMinimumWingSizeForFlight(owner.getBody()).getName() + "\u201d\u5c3a\u5bf8\u624d\u80fd\u591f\u98de\u7fd4\u3002)]");
            }
        }
        sb.append("</p>");
        return sb.toString();
    }

    @Override
    public boolean isFeral(GameCharacter owner) {
        if (owner == null) {
            return false;
        }
        return owner.isFeral() || owner.getLegConfiguration().getFeralParts().contains(Wing.class) && this.getType().getRace().isFeralPartsAvailable();
    }
}

