/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.EyeShape;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractEyeType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private int defaultPairCount;
    private EyeShape defaultIrisShape;
    private EyeShape defaultPupilShape;
    private String name;
    private String namePlural;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    private String eyeTransformationDescription;
    private String eyeBodyDescription;
    private List<BodyPartTag> tags;

    public AbstractEyeType(AbstractBodyCoveringType coveringType, AbstractRace race, int defaultPairCount, EyeShape defaultIrisShape, EyeShape defaultPupilShape, String transformationName, String name, String namePlural, List<String> descriptorsMasculine, List<String> descriptorsFeminine, String eyeTransformationDescription, String eyeBodyDescription) {
        this.coveringType = coveringType;
        this.race = race;
        this.defaultPairCount = defaultPairCount;
        this.defaultIrisShape = defaultIrisShape;
        this.defaultPupilShape = defaultPupilShape;
        this.transformationName = transformationName;
        this.name = name;
        this.namePlural = namePlural;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.eyeTransformationDescription = eyeTransformationDescription;
        this.eyeBodyDescription = eyeBodyDescription;
        this.tags = new ArrayList<BodyPartTag>();
    }

    public AbstractEyeType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.tags = new ArrayList<BodyPartTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(BodyPartTag.getBodyPartTagFromId(e.getTextContent()));
                    }
                }
                this.defaultPairCount = Integer.valueOf(coreElement.getMandatoryFirstOf("defaultPairCount").getTextContent());
                this.defaultIrisShape = EyeShape.valueOf(coreElement.getMandatoryFirstOf("defaultIrisShape").getTextContent());
                this.defaultPupilShape = EyeShape.valueOf(coreElement.getMandatoryFirstOf("defaultPupilShape").getTextContent());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.eyeTransformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.eyeBodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractEyeType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public int getDefaultPairCount() {
        return this.defaultPairCount;
    }

    public EyeShape getDefaultIrisShape() {
        return this.defaultIrisShape;
    }

    public EyeShape getDefaultPupilShape() {
        return this.defaultPupilShape;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getEyePairs() == 1) {
            return "\u4e00\u53cc";
        }
        return Util.intToString(gc.getEyePairs()) + "\u53cc";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        return this.name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.namePlural;
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.eyeBodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.eyeTransformationDescription, new ParserTag[0]);
    }

    @Override
    public List<BodyPartTag> getTags() {
        return this.tags;
    }
}

