/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.valueEnums.FluidFlavour;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.character.body.valueEnums.FluidTypeBase;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractFluidType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private String transformationName;
    private FluidTypeBase baseFluidType;
    private FluidFlavour flavour;
    private AbstractRace race;
    private List<String> namesMasculine;
    private List<String> namesFeminine;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    List<FluidModifier> defaultFluidModifiers;

    public AbstractFluidType(FluidTypeBase baseFluidType, FluidFlavour flavour, AbstractRace race, List<String> namesMasculine, List<String> namesFeminine, List<String> descriptorsMasculine, List<String> descriptorsFeminine, List<FluidModifier> defaultFluidModifiers) {
        this.baseFluidType = baseFluidType;
        this.flavour = flavour;
        this.race = race;
        this.transformationName = null;
        this.namesMasculine = namesMasculine;
        this.namesFeminine = namesFeminine;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.defaultFluidModifiers = defaultFluidModifiers;
    }

    public AbstractFluidType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.baseFluidType = FluidTypeBase.valueOf(coreElement.getMandatoryFirstOf("baseFluidType").getTextContent());
                this.flavour = FluidFlavour.valueOf(coreElement.getMandatoryFirstOf("flavour").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.namesMasculine = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesMasculine").getAllOf("name")) {
                    this.namesMasculine.add(e.getTextContent());
                }
                this.namesFeminine = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesFeminine").getAllOf("name")) {
                    this.namesFeminine.add(e.getTextContent());
                }
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.defaultFluidModifiers = new ArrayList<FluidModifier>();
                if (coreElement.getOptionalFirstOf("defaultFluidModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultFluidModifiers").getAllOf("modifier")) {
                        this.defaultFluidModifiers.add(FluidModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractFluidType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    public String toString() {
        System.err.println("Warning! AbstractFluidType is calling toString()");
        return super.toString();
    }

    public String getId() {
        return FluidType.getIdFromFluidType(this);
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "\u4e00\u4e9b";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        String name;
        if (gc == null || gc.isFeminine()) {
            if (this.namesFeminine == null || this.namesFeminine.isEmpty()) {
                return Util.randomItemFrom(this.baseFluidType.getNames());
            }
            name = Util.randomItemFrom(this.namesFeminine);
        } else {
            if (this.namesMasculine == null || this.namesMasculine.isEmpty()) {
                return Util.randomItemFrom(this.baseFluidType.getNames());
            }
            name = Util.randomItemFrom(this.namesMasculine);
        }
        if (name == null || name.isEmpty()) {
            return Util.randomItemFrom(this.baseFluidType.getNames());
        }
        if (!this.baseFluidType.getNames().contains(name)) {
            if (Math.random() < 0.25) {
                return name + Util.randomItemFrom(this.baseFluidType.getNames());
            }
            return Util.randomItemFrom(this.baseFluidType.getNames());
        }
        return name;
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        return this.getNameSingular(gc);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc == null || gc.isFeminine()) {
            if (this.descriptorsFeminine == null || this.descriptorsFeminine.isEmpty()) {
                return "";
            }
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        if (this.descriptorsMasculine == null || this.descriptorsMasculine.isEmpty()) {
            return "";
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.baseFluidType.getCoveringType();
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public FluidTypeBase getBaseType() {
        return this.baseFluidType;
    }

    public FluidFlavour getFlavour() {
        return this.flavour;
    }

    public List<FluidModifier> getDefaultFluidModifiers() {
        return this.defaultFluidModifiers;
    }

    public float getValueModifier() {
        return 1.0f;
    }
}

