/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractNippleType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private List<String> descriptorsMasculine;
    private List<String> descriptorsFeminine;
    List<OrificeModifier> defaultRacialOrificeModifiers;

    public AbstractNippleType(AbstractBodyCoveringType coveringType, AbstractRace race, List<String> descriptorsMasculine, List<String> descriptorsFeminine, List<OrificeModifier> defaultRacialOrificeModifiers) {
        this.coveringType = coveringType;
        this.race = race;
        this.descriptorsMasculine = descriptorsMasculine;
        this.descriptorsFeminine = descriptorsFeminine;
        this.defaultRacialOrificeModifiers = defaultRacialOrificeModifiers == null ? new ArrayList<OrificeModifier>() : defaultRacialOrificeModifiers;
    }

    public AbstractNippleType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.descriptorsMasculine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsMasculine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsMasculine").getAllOf("descriptor")) {
                        this.descriptorsMasculine.add(e.getTextContent());
                    }
                }
                this.descriptorsFeminine = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptorsFeminine").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptorsFeminine").getAllOf("descriptor")) {
                        this.descriptorsFeminine.add(e.getTextContent());
                    }
                }
                this.defaultRacialOrificeModifiers = new ArrayList<OrificeModifier>();
                if (coreElement.getOptionalFirstOf("defaultOrificeModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultOrificeModifiers").getAllOf("modifier")) {
                        this.defaultRacialOrificeModifiers.add(OrificeModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractNippleType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getBreastRows() == 1) {
            return "\u4e00\u5bf9";
        }
        if (gc.getBreastRows() == 2) {
            return "\u4e24\u5bf9";
        }
        return "\u4e09\u5bf9";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        switch (gc.getNippleShape()) {
            case LIPS: {
                return UtilText.returnStringAtRandom("\u5507\u5316\u4e73\u5934", "\u4e73\u5507");
            }
            case INVERTED: 
            case NORMAL: {
                if (gc.hasBreasts()) {
                    return UtilText.returnStringAtRandom("\u4e73\u5934", "\u5976\u5934");
                }
                return "\u4e73\u5934";
            }
            case VAGINA: {
                return UtilText.returnStringAtRandom("\u4e73\u5934\u7a74", "\u4e73\u7a74");
            }
        }
        return "";
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        switch (gc.getNippleShape()) {
            case LIPS: {
                return UtilText.returnStringAtRandom("\u5507\u5316\u4e73\u5934", "\u4e73\u5507");
            }
            case INVERTED: 
            case NORMAL: {
                if (gc.hasBreasts()) {
                    return UtilText.returnStringAtRandom("\u4e73\u5934", "\u5976\u5934");
                }
                return "\u4e73\u5934";
            }
            case VAGINA: {
                return UtilText.returnStringAtRandom("\u4e73\u5934\u7a74", "\u4e73\u7a74");
            }
        }
        return "";
    }

    public String getNameCrotchSingular(GameCharacter gc) {
        switch (gc.getNippleCrotchShape()) {
            case LIPS: {
                return UtilText.returnStringAtRandom("\u5507\u5316\u4e73\u5934", "\u4e73\u5507");
            }
            case INVERTED: 
            case NORMAL: {
                if (gc.hasBreasts()) {
                    return UtilText.returnStringAtRandom("\u4e73\u5934", "\u5976\u5934");
                }
                return "\u4e73\u5934";
            }
            case VAGINA: {
                return UtilText.returnStringAtRandom("\u4e73\u5934\u7a74", "\u4e73\u7a74");
            }
        }
        return "";
    }

    public String getNameCrotchPlural(GameCharacter gc) {
        switch (gc.getNippleCrotchShape()) {
            case LIPS: {
                return UtilText.returnStringAtRandom("\u5507\u5316\u4e73\u5934", "\u4e73\u5507");
            }
            case INVERTED: 
            case NORMAL: {
                if (gc.hasBreasts()) {
                    return UtilText.returnStringAtRandom("\u4e73\u5934", "\u5976\u5934");
                }
                return "\u4e73\u5934";
            }
            case VAGINA: {
                return UtilText.returnStringAtRandom("\u4e73\u5934\u7a74", "\u4e73\u7a74");
            }
        }
        return "";
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (gc.isFeminine()) {
            return Util.randomItemFrom(this.descriptorsFeminine);
        }
        return Util.randomItemFrom(this.descriptorsMasculine);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public List<OrificeModifier> getDefaultRacialOrificeModifiers() {
        return this.defaultRacialOrificeModifiers;
    }
}

