/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractTesticleType
implements BodyPartTypeInterface {
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractRace race;
    private AbstractFluidType fluidType;
    private boolean internal;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptors;

    public AbstractTesticleType(AbstractBodyCoveringType coveringType, AbstractRace race, AbstractFluidType fluidType, boolean internal, List<String> names, List<String> namesPlural, List<String> descriptors) {
        this.coveringType = coveringType;
        this.race = race;
        this.fluidType = fluidType;
        this.internal = internal;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptors = descriptors;
    }

    public AbstractTesticleType(AbstractBodyCoveringType skinType, AbstractRace race, AbstractFluidType fluidType, boolean internal) {
        this(skinType, race, fluidType, internal, null, null, null);
    }

    public AbstractTesticleType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.fluidType = FluidType.getFluidTypeFromId(coreElement.getMandatoryFirstOf("fluidType").getTextContent());
                this.internal = Boolean.valueOf(coreElement.getMandatoryFirstOf("internal").getTextContent());
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptors = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptors").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptors").getAllOf("descriptor")) {
                        this.descriptors.add(e.getTextContent());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractTesticleType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public AbstractFluidType getFluidType() {
        return this.fluidType;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        if (gc.getTesticleCount() == 2) {
            return "\u4e00\u5bf9";
        }
        if (gc.getTesticleCount() == 3) {
            return "\u4e09\u4e2a";
        }
        return Util.intToString(gc.getTesticleCount());
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return true;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        if (this.names == null || this.names.isEmpty()) {
            return UtilText.returnStringAtRandom("\u86cb\u86cb", "\u9634\u56ca");
        }
        return Util.randomItemFrom(this.names);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        if (this.namesPlural == null || this.namesPlural.isEmpty()) {
            return UtilText.returnStringAtRandom("\u86cb\u86cb", "\u9634\u56ca");
        }
        return Util.randomItemFrom(this.namesPlural);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (this.descriptors == null || this.descriptors.isEmpty()) {
            return "";
        }
        return Util.randomItemFrom(this.descriptors);
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }
}

