/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.abstractTypes;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.BodyPartTypeInterface;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AbstractVaginaType
implements BodyPartTypeInterface {
    protected static final Map<String, Integer> BASE_NAMES_SINGULAR = Util.newHashMapOfValues(new Util.Value<String, Integer>("\u5904\u5973\u7a74", 2), new Util.Value<String, Integer>("\u871c\u7a74", 1), new Util.Value<String, Integer>("\u5c0f\u7a74", 4), new Util.Value<String, Integer>("\u9634\u9053", 1), new Util.Value<String, Integer>("\u79d8\u7f1d", 2));
    protected static final Map<String, Integer> BASE_NAMES_PLURAL = Util.newHashMapOfValues(new Util.Value<String, Integer>("\u5904\u5973\u7a74", 2), new Util.Value<String, Integer>("\u871c\u7a74", 1), new Util.Value<String, Integer>("\u5c0f\u7a74", 4), new Util.Value<String, Integer>("\u9634\u9053", 1), new Util.Value<String, Integer>("\u79d8\u7f1d", 2));
    private boolean mod;
    private boolean fromExternalFile;
    private AbstractBodyCoveringType coveringType;
    private AbstractFluidType fluidType;
    private AbstractRace race;
    private String transformationName;
    private boolean pubicHairAllowed;
    private boolean eggLayer;
    private List<String> names;
    private List<String> namesPlural;
    private List<String> descriptors;
    private String transformationDescription;
    private String bodyDescription;
    private List<OrificeModifier> defaultRacialOrificeModifiers;

    public AbstractVaginaType(AbstractBodyCoveringType coveringType, AbstractFluidType fluidType, AbstractRace race, boolean eggLayer, List<String> names, List<String> namesPlural, List<String> descriptors, String transformationDescription, String bodyDescription, List<OrificeModifier> defaultRacialOrificeModifiers) {
        this.pubicHairAllowed = race.getRacialClass().isAnthroHair();
        this.coveringType = coveringType;
        this.fluidType = fluidType;
        this.race = race;
        this.eggLayer = eggLayer;
        this.transformationName = null;
        this.names = names;
        this.namesPlural = namesPlural;
        this.descriptors = descriptors;
        this.transformationDescription = transformationDescription;
        this.bodyDescription = bodyDescription;
        this.defaultRacialOrificeModifiers = defaultRacialOrificeModifiers == null ? new ArrayList<OrificeModifier>() : defaultRacialOrificeModifiers;
    }

    public AbstractVaginaType(AbstractBodyCoveringType skinType, AbstractFluidType fluidType, AbstractRace race, boolean eggLayer, String transformationDescription, String bodyDescription, List<OrificeModifier> defaultRacialOrificeModifiers) {
        this(skinType, fluidType, race, eggLayer, null, null, null, transformationDescription, bodyDescription, defaultRacialOrificeModifiers);
    }

    public AbstractVaginaType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.coveringType = BodyCoveringType.getBodyCoveringTypeFromId(coreElement.getMandatoryFirstOf("coveringType").getTextContent());
                this.transformationName = coreElement.getMandatoryFirstOf("transformationName").getTextContent();
                this.pubicHairAllowed = this.race.getRacialClass().isAnthroHair();
                if (coreElement.getOptionalFirstOf("pubicHairAllowed").isPresent()) {
                    this.pubicHairAllowed = Boolean.valueOf(coreElement.getMandatoryFirstOf("pubicHairAllowed").getTextContent());
                }
                this.fluidType = FluidType.getFluidTypeFromId(coreElement.getMandatoryFirstOf("fluidType").getTextContent());
                this.eggLayer = Boolean.valueOf(coreElement.getMandatoryFirstOf("eggLayer").getTextContent());
                this.names = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("names").getAllOf("name")) {
                    this.names.add(e.getTextContent());
                }
                this.namesPlural = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("namesPlural").getAllOf("name")) {
                    this.namesPlural.add(e.getTextContent());
                }
                this.descriptors = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("descriptors").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("descriptors").getAllOf("descriptor")) {
                        this.descriptors.add(e.getTextContent());
                    }
                }
                this.transformationDescription = coreElement.getMandatoryFirstOf("transformationDescription").getTextContent();
                this.bodyDescription = coreElement.getMandatoryFirstOf("bodyDescription").getTextContent();
                this.defaultRacialOrificeModifiers = new ArrayList<OrificeModifier>();
                if (coreElement.getOptionalFirstOf("defaultOrificeModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("defaultOrificeModifiers").getAllOf("modifier")) {
                        this.defaultRacialOrificeModifiers.add(OrificeModifier.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractAnusType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isPubicHairAllowed() {
        return this.pubicHairAllowed;
    }

    @Override
    public String getTransformationNameOverride() {
        return this.transformationName;
    }

    public AbstractFluidType getFluidType() {
        return this.fluidType;
    }

    public boolean isEggLayer() {
        return this.eggLayer;
    }

    public List<OrificeModifier> getDefaultRacialOrificeModifiers() {
        return this.defaultRacialOrificeModifiers;
    }

    @Override
    public String getDeterminer(GameCharacter gc) {
        return "";
    }

    @Override
    public boolean isDefaultPlural(GameCharacter gc) {
        return false;
    }

    @Override
    public String getNameSingular(GameCharacter gc) {
        HashMap<String, Integer> returnNames = new HashMap<String, Integer>(BASE_NAMES_SINGULAR);
        if (!gc.isVaginaVirgin()) {
            returnNames.remove("\u5904\u5973\u7a74");
        }
        String name = this.names == null || this.names.isEmpty() ? Util.getRandomObjectFromWeightedMap(returnNames) : Util.randomItemFrom(this.names);
        if (!Main.game.isStarted()) {
            return name;
        }
        if (!Main.game.isStarted()) {
            return name;
        }
        if (!returnNames.containsKey(name)) {
            if (Math.random() < 0.25) {
                return UtilText.parse(gc, name + Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
            }
            return UtilText.parse(gc, Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
        }
        if (name.isEmpty()) {
            return UtilText.parse(gc, Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
        }
        return UtilText.parse(gc, name, new ParserTag[0]);
    }

    @Override
    public String getNamePlural(GameCharacter gc) {
        String name;
        HashMap<String, Integer> returnNames = new HashMap<String, Integer>(BASE_NAMES_PLURAL);
        if (!gc.isVaginaVirgin()) {
            returnNames.remove("\u5904\u5973\u7a74");
        }
        if (!returnNames.containsKey(name = this.namesPlural == null || this.namesPlural.isEmpty() ? Util.getRandomObjectFromWeightedMap(returnNames) : Util.randomItemFrom(this.namesPlural))) {
            if (Math.random() < 0.25 && (!Main.game.isInSex() || Main.sex.getAllParticipants().size() <= 2)) {
                return UtilText.parse(gc, name + Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
            }
            return UtilText.parse(gc, Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
        }
        if (name.isEmpty()) {
            return UtilText.parse(gc, Util.getRandomObjectFromWeightedMap(returnNames), new ParserTag[0]);
        }
        return UtilText.parse(gc, name, new ParserTag[0]);
    }

    @Override
    public String getDescriptor(GameCharacter gc) {
        if (this.descriptors != null) {
            return Util.randomItemFrom(this.descriptors);
        }
        return "";
    }

    @Override
    public AbstractBodyCoveringType getBodyCoveringType(Body body) {
        return this.coveringType;
    }

    @Override
    public AbstractRace getRace() {
        return this.race;
    }

    public String getBodyDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.bodyDescription, new ParserTag[0]);
    }

    public String getTransformationDescription(GameCharacter owner) {
        return UtilText.parse(owner, this.transformationDescription, new ParserTag[0]);
    }

    public String applyAdditionalTransformationEffects(GameCharacter owner, boolean applicationAfterChangeApplied) {
        return "";
    }
}

