/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.coverings;

import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.StartingSkinTone;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BodyCoveringSkinToneColorHelper {
    private static final List<AbstractBodyCoveringType> NOT_FOR_THESE_BCTS = Util.newArrayListOfValues(BodyCoveringType.MAKEUP_BLUSHER, BodyCoveringType.MAKEUP_EYE_LINER, BodyCoveringType.MAKEUP_EYE_SHADOW, BodyCoveringType.MAKEUP_LIPSTICK, BodyCoveringType.MAKEUP_NAIL_POLISH_FEET, BodyCoveringType.MAKEUP_NAIL_POLISH_HANDS);
    private static Map<StartingSkinTone, Map<AbstractBodyCoveringType, FilteredColours>> filteredColours = new EnumMap<StartingSkinTone, Map<AbstractBodyCoveringType, FilteredColours>>(StartingSkinTone.class);

    private BodyCoveringSkinToneColorHelper() {
    }

    public static List<Colour> getAcceptableColoursForPrimary(StartingSkinTone tone, AbstractBodyCoveringType bct) {
        return BodyCoveringSkinToneColorHelper.getOrCreateFilteredColoursForCombination(tone, bct).getPrimary();
    }

    public static List<Colour> getAcceptableColoursForSecondary(StartingSkinTone tone, AbstractBodyCoveringType bct) {
        return BodyCoveringSkinToneColorHelper.getOrCreateFilteredColoursForCombination(tone, bct).getSecondary();
    }

    private static FilteredColours getOrCreateFilteredColoursForCombination(StartingSkinTone tone, AbstractBodyCoveringType bct) {
        if (NOT_FOR_THESE_BCTS.contains(bct)) {
            return new FilteredColours(new ArrayList<Colour>(), new ArrayList<Colour>());
        }
        return filteredColours.computeIfAbsent(tone, ignored -> new ConcurrentHashMap()).computeIfAbsent(bct, ignored -> {
            HashSet<Colour> colourApplicationListPrimary = new HashSet<Colour>();
            colourApplicationListPrimary.addAll(bct.getNaturalColoursPrimary());
            colourApplicationListPrimary.retainAll(tone.getAssociatedColours());
            if (colourApplicationListPrimary.isEmpty()) {
                colourApplicationListPrimary.addAll(bct.getNaturalColoursPrimary());
            }
            HashSet<Colour> colourApplicationListSecondary = new HashSet<Colour>();
            colourApplicationListSecondary.addAll(bct.getNaturalColoursSecondary());
            colourApplicationListSecondary.retainAll(tone.getAssociatedColours());
            if (colourApplicationListSecondary.isEmpty()) {
                colourApplicationListSecondary.addAll(bct.getNaturalColoursSecondary());
            }
            return new FilteredColours(new ArrayList<Colour>(colourApplicationListPrimary), new ArrayList<Colour>(colourApplicationListSecondary));
        });
    }

    private static class FilteredColours {
        private List<Colour> primary;
        private List<Colour> secondary;

        public FilteredColours(List<Colour> primary, List<Colour> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public List<Colour> getPrimary() {
            return this.primary;
        }

        public List<Colour> getSecondary() {
            return this.secondary;
        }
    }
}

