/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.coverings;

import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BodyCoveringTemplate {
    public final String determiner;
    public final String namePlural;
    public final String nameSingular;
    public final List<CoveringModifier> naturalModifiers;
    public final List<CoveringModifier> extraModifiers;
    public final List<Colour> naturalColoursPrimary;
    public final List<Colour> dyeColoursPrimary;
    public final List<Colour> naturalColoursSecondary;
    public final List<Colour> dyeColoursSecondary;
    public final Map<CoveringPattern, Integer> naturalPatterns;
    public final Map<CoveringPattern, Integer> dyePatterns;
    public final boolean isDefaultPlural;

    public BodyCoveringTemplate(String determiner, boolean isDefaultPlural, String namePlural, String nameSingular, List<CoveringModifier> naturalModifiers, List<CoveringModifier> extraModifiers, Map<CoveringPattern, Integer> naturalPatterns, Map<CoveringPattern, Integer> dyePatterns, List<Colour> naturalColoursPrimary, List<Colour> dyeColoursPrimary, List<Colour> naturalColoursSecondary, List<Colour> dyeColoursSecondary) {
        this.determiner = determiner;
        this.namePlural = namePlural;
        this.nameSingular = nameSingular;
        this.isDefaultPlural = isDefaultPlural;
        this.naturalModifiers = this.getImmutableListFromNullableList(naturalModifiers);
        this.extraModifiers = this.getImmutableListFromNullableList(extraModifiers);
        this.naturalPatterns = naturalPatterns == null ? Util.newHashMapOfValues(new Util.Value<CoveringPattern, Integer>(CoveringPattern.NONE, 1)) : Collections.unmodifiableMap(naturalPatterns);
        this.dyePatterns = new HashMap<CoveringPattern, Integer>();
        if (dyePatterns != null) {
            for (Map.Entry<CoveringPattern, Integer> entry : dyePatterns.entrySet()) {
                if (this.naturalPatterns.containsKey((Object)entry.getKey())) continue;
                this.dyePatterns.put(entry.getKey(), entry.getValue());
            }
        }
        this.naturalColoursPrimary = this.getImmutableListFromNullableList(naturalColoursPrimary);
        this.dyeColoursPrimary = this.getImmutableListFromNullableList(dyeColoursPrimary);
        this.naturalColoursSecondary = this.getImmutableListFromNullableList(naturalColoursSecondary);
        this.dyeColoursSecondary = this.getImmutableListFromNullableList(dyeColoursSecondary);
    }

    private <T> List<T> getImmutableListFromNullableList(List<T> nullableList) {
        return Collections.unmodifiableList(this.getListFromNullableList(nullableList));
    }

    private <T> List<T> getListFromNullableList(List<T> nullableList) {
        return new ArrayList(Optional.ofNullable(nullableList).orElse(new ArrayList()));
    }
}

