/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.tags;

import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum BodyPartTag {
    NIGHT_VISION,
    ECHO_LOCATION,
    THERMAL_VISION,
    ALLOWS_FLIGHT,
    TORSO_DORSAL_FIN,
    ARM_STANDARD,
    ARM_WINGS,
    ARM_WINGS_FEATHERED,
    ARM_WINGS_LEATHERY,
    FACE_STANDARD,
    FACE_MUZZLE,
    FACE_FANGS,
    FACE_BEAK,
    FACE_SHARK_TEETH,
    FACE_VENOMOUS_TEETH,
    FACE_VENOMOUS_TEETH_LUST,
    FACE_NATURAL_BALDNESS_FURRY,
    FACE_NATURAL_BALDNESS_AVIAN,
    FACE_NATURAL_BALDNESS_SCALY,
    FACE_NATURAL_BALDNESS_SKIN,
    EYE_PERFECT_VISION,
    EAR_HANDLES_IN_SEX,
    HAIR_HANDLES_IN_SEX,
    HAIR_NATURAL_MANE,
    HAIR_IGNORE_PLAYER_SETTINGS,
    TAIL_PREHENSILE,
    TAIL_NEVER_SUITABLE_FOR_PENETRATION,
    TAIL_SUITABLE_FOR_PENETRATION,
    TAIL_SLEEP_HUGGING,
    TAIL_ATTACK,
    TAIL_VENOMOUS_STING,
    TAIL_VENOMOUS_STING_LUST,
    TAIL_OVIPOSITOR,
    TAIL_TYPE_SKIN,
    TAIL_TYPE_SCALES,
    TAIL_TYPE_FUR,
    TAIL_TYPE_TUFT,
    TAIL_TYPE_HAIR,
    TAIL_TYPE_FEATHER,
    TAIL_TYPE_GENERIC,
    TAIL_TAPERING_EXPONENTIAL,
    TAIL_TAPERING_LINEAR,
    TAIL_TAPERING_BULBOUS,
    TAIL_TAPERING_NONE;

    public static List<BodyPartTag> allBodyPartTags;
    public static Map<BodyPartTag, String> bodypartTagToIdMap;
    public static Map<String, BodyPartTag> idToBodypartTagMap;

    public static List<BodyPartTag> getAllBodyPartTags() {
        return allBodyPartTags;
    }

    public static BodyPartTag getBodyPartTagFromId(String id) {
        id = Util.getClosestStringMatch(id, idToBodypartTagMap.keySet());
        return idToBodypartTagMap.get(id);
    }

    public static String getIdFromBodyPartTag(BodyPartTag bpt) {
        return bodypartTagToIdMap.get((Object)bpt);
    }

    static {
        allBodyPartTags = new ArrayList<BodyPartTag>();
        bodypartTagToIdMap = new HashMap<BodyPartTag, String>();
        idToBodypartTagMap = new HashMap<String, BodyPartTag>();
        for (BodyPartTag tag : BodyPartTag.values()) {
            allBodyPartTags.add(tag);
            bodypartTagToIdMap.put(tag, tag.toString());
            idToBodypartTagMap.put(tag.toString(), tag);
        }
    }
}

