/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractAntennaType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AntennaType {
    public static final AbstractAntennaType NONE;
    private static List<AbstractAntennaType> allAntennaTypes;
    private static Map<AbstractAntennaType, String> antennaToIdMap;
    private static Map<String, AbstractAntennaType> idToAntennaMap;
    private static Map<AbstractRace, List<AbstractAntennaType>> typesMap;

    public static AbstractAntennaType getAntennaTypeFromId(String id) {
        id = Util.getClosestStringMatch(id, idToAntennaMap.keySet());
        return idToAntennaMap.get(id);
    }

    public static String getIdFromAntennaType(AbstractAntennaType antennaType) {
        return antennaToIdMap.get(antennaType);
    }

    public static List<AbstractAntennaType> getAllAntennaTypes() {
        return allAntennaTypes;
    }

    public static List<AbstractAntennaType> getAntennaTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractAntennaType> types = new ArrayList<AbstractAntennaType>();
        for (AbstractAntennaType type : AntennaType.getAllAntennaTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        if (types.isEmpty()) {
            types.add(NONE);
        }
        return types;
    }

    static {
        Field[] fieldArray;
        NONE = new AbstractAntennaType(BodyCoveringType.ANTENNA, Race.NONE, "\u65e0", "\u89e6\u987b", "\u89e6\u987b", (List)new ArrayList(), (List)new ArrayList(), "<br/>[npc.Name]\u73b0\u5728[style.boldTfGeneric(\u6ca1\u6709\u89e6\u987b)]\u3002", ""){};
        antennaToIdMap = new HashMap<AbstractAntennaType, String>();
        idToAntennaMap = new HashMap<String, AbstractAntennaType>();
        allAntennaTypes = new ArrayList<AbstractAntennaType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("antenna")) continue;
                try {
                    AbstractAntennaType type = new AbstractAntennaType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allAntennaTypes.add(type);
                    antennaToIdMap.put(type, id);
                    idToAntennaMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("antenna")) continue;
                try {
                    AbstractAntennaType type = new AbstractAntennaType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allAntennaTypes.add(type);
                    antennaToIdMap.put(type, id);
                    idToAntennaMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = AntennaType.class.getFields()) {
            if (!AbstractAntennaType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractAntennaType ct = (AbstractAntennaType)f.get(null);
                antennaToIdMap.put(ct, f.getName());
                idToAntennaMap.put(f.getName(), ct);
                allAntennaTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allAntennaTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractAntennaType>>();
    }
}

