/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractEyeType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.valueEnums.EyeShape;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EyeType {
    public static AbstractEyeType HUMAN;
    public static AbstractEyeType ANGEL;
    public static AbstractEyeType DEMON_COMMON;
    public static AbstractEyeType DEMON_OWL;
    public static AbstractEyeType CAT_MORPH;
    public static AbstractEyeType COW_MORPH;
    public static AbstractEyeType DOG_MORPH;
    public static AbstractEyeType FOX_MORPH;
    public static AbstractEyeType WOLF_MORPH;
    public static AbstractEyeType SQUIRREL_MORPH;
    public static AbstractEyeType RAT_MORPH;
    public static AbstractEyeType RABBIT_MORPH;
    public static AbstractEyeType BAT_MORPH;
    public static AbstractEyeType ALLIGATOR_MORPH;
    public static AbstractEyeType HORSE_MORPH;
    public static AbstractEyeType REINDEER_MORPH;
    public static AbstractEyeType HARPY;
    private static List<AbstractEyeType> allEyeTypes;
    private static Map<AbstractEyeType, String> eyeToIdMap;
    private static Map<String, AbstractEyeType> idToEyeMap;
    private static Map<AbstractRace, List<AbstractEyeType>> typesMap;

    public static AbstractEyeType getEyeTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToEyeMap.keySet());
        return idToEyeMap.get(id);
    }

    public static String getIdFromEyeType(AbstractEyeType eyeType) {
        return eyeToIdMap.get(eyeType);
    }

    public static List<AbstractEyeType> getAllEyeTypes() {
        return allEyeTypes;
    }

    public static List<AbstractEyeType> getEyeTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractEyeType> types = new ArrayList<AbstractEyeType>();
        for (AbstractEyeType type : EyeType.getAllEyeTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractEyeType(BodyCoveringType.EYE_HUMAN, Race.HUMAN, 1, EyeShape.ROUND, EyeShape.ROUND, "\u4eba\u7c7b", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u4eba\u7c7b\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u7684\u6bd4\u4f8b\u9002\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHuman(\u4eba\u7c7b\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u666e\u901a\u7684\u4eba\u7c7b\u773c\u775b\uff0c[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){};
        ANGEL = new AbstractEyeType(BodyCoveringType.EYE_ANGEL, Race.ANGEL, 1, EyeShape.ROUND, EyeShape.ROUND, "\u5929\u4f7f", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u5929\u4f7f\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u7684\u6bd4\u4f8b\u9002\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5929\u4f7f\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u5929\u4f7f\u7684\u773c\u775b\uff0c[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.EYE_PERFECT_VISION);
            }
        };
        DEMON_COMMON = new AbstractEyeType(BodyCoveringType.EYE_DEMON_COMMON, Race.DEMON, 1, EyeShape.ROUND, EyeShape.VERTICAL, "\u6076\u9b54", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "#IF(npc.isShortStature())[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u5c0f\u6076\u9b54\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u7eb5\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldImp(\u5c0f\u6076\u9b54\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002#ELSE[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u6076\u9b54\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u7eb5\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDemon(\u6076\u9b54\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002#ENDIF", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u7684\u773c\u775b\uff0c[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION, BodyPartTag.EYE_PERFECT_VISION);
            }
        };
        DEMON_OWL = new AbstractEyeType(BodyCoveringType.EYE_DEMON_COMMON, Race.DEMON, 1, EyeShape.ROUND, EyeShape.ROUND, "\u6076\u9b54\u9e2e", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u72b9\u8c6b\u7740\u518d\u5ea6\u7741\u5f00\u773c\u775b\uff0c\u90a3\u53cc\u773c\u5df2\u7ecf\u5316\u4f5c\u4e86\u6076\u9b54\u4f3c\u7684\u9e2e\u773c\u775b\uff0c\u4e3a[npc.herHim]\u63d0\u4f9b\u4e86\u51fa\u8272\u7684\u591c\u89c6\u80fd\u529b\u3002<br/>[npc.Name]\u62e5\u6709\u4e86[style.boldDemon(\u6076\u9b54\u4f3c\u7684\u9e2e\u773c\u775b)]\uff0c\u8fd8\u5e26\u6709[style.boldGenericTF([npc.irisShape])]\uff0c[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\uff0c[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u6076\u9b54\u4f3c\u7684\u9e2e\u773c\u775b\uff0c[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION, BodyPartTag.EYE_PERFECT_VISION);
            }
        };
        CAT_MORPH = new AbstractEyeType(BodyCoveringType.EYE_FELINE, Race.CAT_MORPH, 1, EyeShape.ROUND, EyeShape.VERTICAL, "\u732b", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u732b\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u7eb5\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u732b\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        COW_MORPH = new AbstractEyeType(BodyCoveringType.EYE_COW_MORPH, Race.COW_MORPH, 1, EyeShape.ROUND, EyeShape.HORIZONTAL, "\u725b", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u725b\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u6a2a\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u725b\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        DOG_MORPH = new AbstractEyeType(BodyCoveringType.EYE_DOG_MORPH, Race.DOG_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u72ac", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u72ac\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u72ac\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        FOX_MORPH = new AbstractEyeType(BodyCoveringType.EYE_FOX_MORPH, Race.FOX_MORPH, 1, EyeShape.ROUND, EyeShape.VERTICAL, "\u72d0\u72f8", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u72d0\u72f8\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u7eb5\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u72d0\u72f8\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        WOLF_MORPH = new AbstractEyeType(BodyCoveringType.EYE_LYCAN, Race.WOLF_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u72fc", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u72fc\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u72fc\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        SQUIRREL_MORPH = new AbstractEyeType(BodyCoveringType.EYE_SQUIRREL, Race.SQUIRREL_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u677e\u9f20", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u677e\u9f20\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u677e\u9f20\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){};
        RAT_MORPH = new AbstractEyeType(BodyCoveringType.EYE_RAT, Race.RAT_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u8001\u9f20", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u8001\u9f20\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u8001\u9f20\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){};
        RABBIT_MORPH = new AbstractEyeType(BodyCoveringType.EYE_RABBIT, Race.RABBIT_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u5154\u5b50", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u5154\u5b50\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRabbitMorph(\u5154\u5b50\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u5154\u5b50\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){};
        BAT_MORPH = new AbstractEyeType(BodyCoveringType.EYE_BAT, Race.BAT_MORPH, 1, EyeShape.ROUND, EyeShape.ROUND, "\u8759\u8760", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u90a3\u53cc\u773c\u5df2\u7ecf\u53d8\u6210\u4e86\u8759\u8760\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldBatMorph(\u8759\u8760\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u8759\u8760\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        ALLIGATOR_MORPH = new AbstractEyeType(BodyCoveringType.EYE_ALLIGATOR_MORPH, Race.ALLIGATOR_MORPH, 1, EyeShape.ROUND, EyeShape.VERTICAL, "\u9cc4\u9c7c", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u9cc4\u9c7c\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u7eb5\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAlligatorMorph(\u9cc4\u9c7c\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u9cc4\u9c7c\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        HORSE_MORPH = new AbstractEyeType(BodyCoveringType.EYE_HORSE_MORPH, Race.HORSE_MORPH, 1, EyeShape.ROUND, EyeShape.HORIZONTAL, "\u9a6c", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u9a6c\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u6a2a\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u9a6c\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        REINDEER_MORPH = new AbstractEyeType(BodyCoveringType.EYE_REINDEER_MORPH, Race.REINDEER_MORPH, 1, EyeShape.ROUND, EyeShape.HORIZONTAL, "\u9a6f\u9e7f", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u9a6f\u9e7f\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u504f\u5927\uff0c\u6a2a\u5411\u7684\u77b3\u5b54\u5c45\u4e8e\u5176\u4e2d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u9a6f\u9e7f\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){

            @Override
            public List<BodyPartTag> getTags() {
                return Util.newArrayListOfValues(BodyPartTag.NIGHT_VISION);
            }
        };
        HARPY = new AbstractEyeType(BodyCoveringType.EYE_HARPY, Race.HARPY, 1, EyeShape.ROUND, EyeShape.ROUND, "\u54c8\u6bd4", "\u773c\u775b", "\u773c\u775b", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.she]\u6218\u6218\u5162\u5162\u5730\u7741\u5f00\u773c\u65f6\uff0c\u53d1\u73b0\u5df2\u7ecf\u53d8\u6210\u4e86\u9e1f\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u90fd\u663e\u5f97\u7a0d\u5927\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHarpy(\u9e1f\u4e00\u822c\u7684\u773c\u775b)]\uff0c\u6709\u7740[style.boldGenericTF([npc.irisShape])]\u7684[npc.irisFullDescription(true)]\u548c[style.boldGenericTF([npc.pupilShape])]\u7684[npc.pupilFullDescription(true)]\u3002", "[npc.SheHasFull]\u62e5\u6709[npc.eyePairs]\u9e1f\u4e00\u822c\u7684\u773c\u775b\uff0c\u8679\u819c\u548c\u77b3\u5b54\u76f8\u6bd4\u4e00\u822c\u4eba\u7c7b\u7684\u90fd\u8981\u5927\u4e00\u4e9b\u3002[npc.irisColour(true)]\u8679\u819c\u5448[npc.irisShape]\uff0c[npc.pupilColour(true)]\u77b3\u5b54\u5448[npc.pupilShape]\uff0c\u8fd8\u6709\u7740[npc.scleraColour(true)]\u7684\u5de9\u819c\u3002"){};
        eyeToIdMap = new HashMap<AbstractEyeType, String>();
        idToEyeMap = new HashMap<String, AbstractEyeType>();
        allEyeTypes = new ArrayList<AbstractEyeType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("eye")) continue;
                try {
                    AbstractEyeType type = new AbstractEyeType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allEyeTypes.add(type);
                    eyeToIdMap.put(type, id);
                    idToEyeMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("eye")) continue;
                try {
                    AbstractEyeType type = new AbstractEyeType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allEyeTypes.add(type);
                    eyeToIdMap.put(type, id);
                    idToEyeMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = EyeType.class.getFields()) {
            if (!AbstractEyeType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractEyeType ct = (AbstractEyeType)f.get(null);
                eyeToIdMap.put(ct, f.getName());
                idToEyeMap.put(f.getName(), ct);
                allEyeTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allEyeTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractEyeType>>();
    }
}

