/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFootType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.FootStructure;
import com.lilithsthrone.utils.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FootType {
    public static AbstractFootType NONE;
    public static AbstractFootType HUMANOID;
    public static AbstractFootType PAWS;
    public static AbstractFootType HOOFS;
    public static AbstractFootType REPTILIAN;
    public static AbstractFootType AMPHIBIAN;
    public static AbstractFootType TALONS;
    public static AbstractFootType ARACHNID;
    public static AbstractFootType TENTACLE;
    private static List<AbstractFootType> allFootTypes;
    private static Map<AbstractFootType, String> footToIdMap;
    private static Map<String, AbstractFootType> idToFootMap;

    public static AbstractFootType getFootTypeFromId(String id) {
        id = Util.getClosestStringMatch(id, idToFootMap.keySet());
        return idToFootMap.get(id);
    }

    public static String getIdFromFootType(AbstractFootType footType) {
        return footToIdMap.get(footType);
    }

    public static List<AbstractFootType> getAllFootTypes() {
        return allFootTypes;
    }

    static {
        Field[] fields;
        NONE = new AbstractFootType("\u65e0", "\u65e0", "\u65e0", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u65e0", "\u65e0", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u8db3\u4ea4", "[npc.SheHasFull]\u6ca1\u6709\u811a\u3002", Util.newArrayListOfValues(FootStructure.NONE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "";
            }
        };
        HUMANOID = new AbstractFootType("\u4eba\u7c7b", "\u811a", "\u811a", Util.newArrayListOfValues("\u9633\u521a"), Util.newArrayListOfValues("\u9634\u67d4", "\u67d4\u8f6f", "\u7cbe\u81f4", "\u4fee\u957f"), "\u811a\u8dbe", "\u811a\u8dbe", Util.newArrayListOfValues("\u9633\u521a"), Util.newArrayListOfValues("\u9634\u67d4", "\u67d4\u8f6f", "\u7cbe\u81f4", "\u4fee\u957f"), "\u8db3\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u50cf\u4eba\u4e00\u6837\u7684\u811a\u3002", Util.newArrayListOfValues(FootStructure.PLANTIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.Her]\u7684\u811a\u8dbe\u7532\u4e0a\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        PAWS = new AbstractFootType("\u722a\u4e00\u822c", "\u811a\u722a", "\u811a\u722a", Util.newArrayListOfValues("\u7537\u6027\u5316", "\u5e26\u8089\u57ab"), Util.newArrayListOfValues("\u9634\u67d4", "\u67d4\u8f6f", "\u5e26\u8089\u57ab", "\u7cbe\u81f4", "\u7ea4\u7ec6"), "\u811a\u8dbe", "\u811a\u8dbe", Util.newArrayListOfValues("\u9633\u521a", "\u8089\u57ab"), Util.newArrayListOfValues("\u9634\u67d4", "\u67d4\u8f6f", "\u5e26\u8089\u57ab", "\u7cbe\u81f4", "\u7ea4\u7ec6"), "\u8db3\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u722a\u4e00\u822c\u7684\u811a\u3002", Util.newArrayListOfValues(FootStructure.PLANTIGRADE, FootStructure.DIGITIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.Her]\u7684\u811a\u8dbe\u7532\u4e0a\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        HOOFS = new AbstractFootType("\u8e44\u5b50\u822c", "\u8e44\u5b50", "\u8e44\u5b50", Util.newArrayListOfValues("\u9633\u521a", "\u575a\u786c"), Util.newArrayListOfValues("\u9634\u67d4", "\u7cbe\u81f4", "\u575a\u786c"), "\u8e44", "\u8e44\u5b50", Util.newArrayListOfValues("\u9633\u521a", "\u575a\u786c"), Util.newArrayListOfValues("\u9634\u67d4", "\u575a\u786c", "\u7cbe\u81f4"), "\u8e44\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u8e44\u5b50\u800c\u975e\u811a\u3002", Util.newArrayListOfValues(FootStructure.UNGULIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.Her]\u7684\u8e44\u5b50\u6d82\u4e0a\u4e86" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        REPTILIAN = new AbstractFootType("\u722c\u884c\u7c7b", "\u811a", "\u811a", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u722a"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u722a", "\u4fee\u957f"), "\u811a\u8dbe", "\u811a\u8dbe", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u722a"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u722a", "\u4fee\u957f"), "\u8db3\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u722c\u884c\u7c7b\u7684\u811a\u3002", Util.newArrayListOfValues(FootStructure.PLANTIGRADE, FootStructure.DIGITIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "\u5728[npc.her]\u7c97\u77ed\u811a\u8dbe\u9876\u7aef\u7684\u722a\u5b50\u4e0a\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        AMPHIBIAN = new AbstractFootType("\u4e24\u6816\u7c7b", "\u811a", "\u811a", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u8e7c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u8e7c", "\u4fee\u957f"), "\u811a\u8dbe", "\u811a\u8dbe", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u8e7c"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u8e7c", "\u4fee\u957f"), "\u8db3\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u4e24\u6816\u7c7b\u7684\u811a\u3002", Util.newArrayListOfValues(FootStructure.PLANTIGRADE, FootStructure.DIGITIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.her]\u811a\u8dbe\u7684\u9876\u7aef\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        TALONS = new AbstractFootType("\u9e1f\u4e00\u822c", "\u5229\u722a", "\u5229\u722a", Util.newArrayListOfValues("\u9633\u521a", "\u5e26\u722a"), Util.newArrayListOfValues("\u9634\u67d4", "\u5e26\u722a", "\u4fee\u957f"), "\u722a\u5b50", "\u722a\u5b50", Util.newArrayListOfValues("\u9633\u521a", "\u5c16\u9510"), Util.newArrayListOfValues("\u9634\u67d4", "\u5c16\u9510", "\u4fee\u957f"), "\u722a\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u9e1f\u4e00\u6837\u7684\u5229\u722a\u800c\u975e\u811a\u3002", Util.newArrayListOfValues(FootStructure.DIGITIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.her]\u9e1f\u722a\u7684\u722a\u5b50\u4e0a\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        ARACHNID = new AbstractFootType("\u86db\u5f62", "\u811a", "\u811a", Util.newArrayListOfValues("\u9633\u521a", "\u8282\u8282\u5206\u660e"), Util.newArrayListOfValues("\u9634\u67d4", "\u8282\u8282\u5206\u660e", "\u7ea4\u7ec6"), "\u722a\u5b50", "\u722a\u5b50", Util.newArrayListOfValues("\u9633\u521a", "\u5c16\u9510"), Util.newArrayListOfValues("\u9634\u67d4", "\u5c16\u9510", "\u4fee\u957f"), "\u722a\u4ea4", "[npc.SheHasFull]\u62e5\u6709\u86db\u5f62\u722a\u800c\u975e\u811a\u3002", Util.newArrayListOfValues(FootStructure.PLANTIGRADE, FootStructure.DIGITIGRADE)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.her]\u86db\u5f62\u7684\u722a\u4e0a\u6d82\u4e86" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        TENTACLE = new AbstractFootType("\u89e6\u624b", "\u89e6\u624b", "\u89e6\u624b", Util.newArrayListOfValues("\u9633\u521a", "\u6709\u529b"), Util.newArrayListOfValues("\u9634\u67d4", "\u6709\u529b", "\u4fee\u957f"), "\u5438\u76d8", "\u5438\u76d8", Util.newArrayListOfValues("\u6709\u529b"), Util.newArrayListOfValues("\u6709\u529b"), "\u89e6\u624b\u6deb", "[npc.her]\u7684\u89e6\u624b\u9876\u7aef\u53ef\u4ee5\u5f53\u505a\u811a\u6765\u7528\u3002", Util.newArrayListOfValues(FootStructure.TENTACLED)){

            @Override
            public String getFootNailPolishDescription(GameCharacter owner) {
                return "[npc.her]\u89e6\u624b\u7684\u9876\u7aef\u6d82\u7740" + owner.getCovering(BodyCoveringType.MAKEUP_NAIL_POLISH_FEET).getFullDescription(owner, true) + "\u3002";
            }
        };
        footToIdMap = new HashMap<AbstractFootType, String>();
        idToFootMap = new HashMap<String, AbstractFootType>();
        allFootTypes = new ArrayList<AbstractFootType>();
        for (Field f : fields = FootType.class.getFields()) {
            if (!AbstractFootType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractFootType ct = (AbstractFootType)f.get(null);
                footToIdMap.put(ct, f.getName());
                idToFootMap.put(f.getName(), ct);
                allFootTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

