/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractMouthType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.types.TongueType;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MouthType {
    public static AbstractMouthType HUMAN;
    public static AbstractMouthType ANGEL;
    public static AbstractMouthType DEMON_COMMON;
    public static AbstractMouthType DOG_MORPH;
    public static AbstractMouthType WOLF_MORPH;
    public static AbstractMouthType FOX_MORPH;
    public static AbstractMouthType CAT_MORPH;
    public static AbstractMouthType COW_MORPH;
    public static AbstractMouthType SQUIRREL_MORPH;
    public static AbstractMouthType RAT_MORPH;
    public static AbstractMouthType RABBIT_MORPH;
    public static AbstractMouthType BAT_MORPH;
    public static AbstractMouthType ALLIGATOR_MORPH;
    public static AbstractMouthType HORSE_MORPH;
    public static AbstractMouthType REINDEER_MORPH;
    public static AbstractMouthType HARPY;
    private static List<AbstractMouthType> allMouthTypes;
    private static Map<AbstractMouthType, String> mouthToIdMap;
    private static Map<String, AbstractMouthType> idToMouthMap;
    private static Map<AbstractRace, List<AbstractMouthType>> typesMap;

    public static AbstractMouthType getMouthTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        id = Util.getClosestStringMatch(id, idToMouthMap.keySet());
        return idToMouthMap.get(id);
    }

    public static String getIdFromMouthType(AbstractMouthType mouthType) {
        return mouthToIdMap.get(mouthType);
    }

    public static List<AbstractMouthType> getAllMouthTypes() {
        return allMouthTypes;
    }

    public static List<AbstractMouthType> getMouthTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractMouthType> types = new ArrayList<AbstractMouthType>();
        for (AbstractMouthType type : MouthType.getAllMouthTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractMouthType(Race.HUMAN, TongueType.HUMAN){};
        ANGEL = new AbstractMouthType(Race.ANGEL, TongueType.ANGEL){};
        DEMON_COMMON = new AbstractMouthType(Race.DEMON, TongueType.DEMON_COMMON){};
        DOG_MORPH = new AbstractMouthType(Race.DOG_MORPH, TongueType.DOG_MORPH){};
        WOLF_MORPH = new AbstractMouthType(Race.WOLF_MORPH, TongueType.WOLF_MORPH){};
        FOX_MORPH = new AbstractMouthType(Race.FOX_MORPH, TongueType.FOX_MORPH){};
        CAT_MORPH = new AbstractMouthType(Race.CAT_MORPH, TongueType.CAT_MORPH){};
        COW_MORPH = new AbstractMouthType(Race.COW_MORPH, TongueType.COW_MORPH){};
        SQUIRREL_MORPH = new AbstractMouthType(Race.SQUIRREL_MORPH, TongueType.SQUIRREL_MORPH){};
        RAT_MORPH = new AbstractMouthType(Race.RAT_MORPH, TongueType.RAT_MORPH){};
        RABBIT_MORPH = new AbstractMouthType(Race.RABBIT_MORPH, TongueType.RABBIT_MORPH){};
        BAT_MORPH = new AbstractMouthType(Race.BAT_MORPH, TongueType.BAT_MORPH){};
        ALLIGATOR_MORPH = new AbstractMouthType(Race.ALLIGATOR_MORPH, TongueType.ALLIGATOR_MORPH){};
        HORSE_MORPH = new AbstractMouthType(Race.HORSE_MORPH, TongueType.HORSE_MORPH){};
        REINDEER_MORPH = new AbstractMouthType(Race.REINDEER_MORPH, TongueType.REINDEER_MORPH){};
        HARPY = new AbstractMouthType(BodyCoveringType.MOUTH, Race.HARPY, TongueType.HARPY, Util.newArrayListOfValues("\u5599"), Util.newArrayListOfValues("\u5599"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), Util.newArrayListOfValues("\u5599\u5507"), Util.newArrayListOfValues("\u5599\u5507"), Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), null, Util.newArrayListOfValues(new OrificeModifier[0])){

            @Override
            public boolean isLipsDescriptorSizeAllowed(GameCharacter gc) {
                return false;
            }
        };
        mouthToIdMap = new HashMap<AbstractMouthType, String>();
        idToMouthMap = new HashMap<String, AbstractMouthType>();
        allMouthTypes = new ArrayList<AbstractMouthType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("mouth")) continue;
                try {
                    AbstractMouthType type = new AbstractMouthType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allMouthTypes.add(type);
                    mouthToIdMap.put(type, id);
                    idToMouthMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("mouth")) continue;
                try {
                    AbstractMouthType type = new AbstractMouthType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allMouthTypes.add(type);
                    mouthToIdMap.put(type, id);
                    idToMouthMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = MouthType.class.getFields()) {
            if (!AbstractMouthType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractMouthType ct = (AbstractMouthType)f.get(null);
                mouthToIdMap.put(ct, f.getName());
                idToMouthMap.put(f.getName(), ct);
                allMouthTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allMouthTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractMouthType>>();
    }
}

